-- --------------------------------------------------------
-- Host:                         54.151.227.26
-- Server version:               8.0.23 - MySQL Community Server - GPL
-- Server OS:                    Linux
-- HeidiSQL Version:             11.2.0.6213
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Dumping structure for table phillip.branch
CREATE TABLE IF NOT EXISTS `branch` (
  `id` int NOT NULL AUTO_INCREMENT,
  `branch_code` varchar(40) NOT NULL,
  `branch_name` varchar(255) NOT NULL,
  `address` text,
  `city` varchar(255) DEFAULT NULL,
  `province` varchar(255) DEFAULT NULL,
  `postal_code` int DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `is_active` tinyint DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(90) DEFAULT NULL,
  `web_address` varchar(255) DEFAULT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.branch: ~6 rows (approximately)
/*!40000 ALTER TABLE `branch` DISABLE KEYS */;
INSERT INTO `branch` (`id`, `branch_code`, `branch_name`, `address`, `city`, `province`, `postal_code`, `country`, `is_active`, `phone`, `email`, `web_address`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(1, 'PW-01', 'Main Office', 'Jalan Bahureksa no 1', 'Bandung', 'Jawa Barat', 13450, NULL, 1, '02254168097', 'phillip@gmail.com', 'phillipworks.com', '2021-04-07 17:27:41.366157', '2021-04-07 17:27:41.366157', NULL),
	(2, 'PW-02', 'Karang Sari', 'Jl.Karangsari No.3', 'Bandung', 'Jawa Barat', NULL, 'Indonesia', 1, NULL, NULL, NULL, '2021-04-12 14:05:57.000000', '2021-04-12 14:05:57.000000', NULL),
	(3, 'PW-03', 'Maulana Yusuf', 'Jl.Maulana Yusuf No.2', 'Bandung', 'Jawa Barat', NULL, 'Indonesia', 1, NULL, NULL, NULL, '2021-04-12 14:05:57.000000', '2021-04-12 14:05:57.000000', NULL),
	(4, 'PW-04', 'Bahureksa', 'Jl.Bahureksa No.1', 'Bandung', 'Jawa Barat', NULL, 'Indonesia', 1, NULL, NULL, NULL, '2021-04-12 14:05:57.000000', '2021-04-12 14:05:57.000000', NULL),
	(5, 'PW-05', 'Gudang Selatan', 'Jl.Gudang Selatan no.22 Blok A', 'Bandung', 'Jawa Barat', NULL, 'Indonesia', 1, NULL, NULL, NULL, '2021-04-12 14:05:57.000000', '2021-04-12 14:05:57.000000', NULL),
	(6, 'PW-06', 'Yogyakarta', 'Jl.Cendrawasih', 'Yogyakarta', 'Jawa Tengah', NULL, 'Indonesia', 1, NULL, NULL, NULL, '2021-05-25 06:07:08.000000', '2021-04-12 14:05:57.000000', NULL);
/*!40000 ALTER TABLE `branch` ENABLE KEYS */;

-- Dumping structure for table phillip.brand
CREATE TABLE IF NOT EXISTS `brand` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `status` tinyint NOT NULL,
  `comission` float DEFAULT NULL,
  `contact_id` int DEFAULT NULL,
  `category` enum('internal','external') NOT NULL DEFAULT 'internal',
  `has_comission_by_category` tinyint NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_3af821041b79d248cc6abe73562` (`contact_id`),
  CONSTRAINT `FK_3af821041b79d248cc6abe73562` FOREIGN KEY (`contact_id`) REFERENCES `contact` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.brand: ~9 rows (approximately)
/*!40000 ALTER TABLE `brand` DISABLE KEYS */;
INSERT INTO `brand` (`id`, `code`, `name`, `status`, `comission`, `contact_id`, `category`, `has_comission_by_category`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(1, 'NONE', 'None', 1, NULL, NULL, 'internal', 0, '2021-04-07 17:27:43.954683', '2021-04-07 17:27:43.954683', NULL),
	(2, 'PW', 'Phillipworks', 1, NULL, NULL, 'internal', 0, '2021-04-07 17:27:43.958329', '2021-04-07 17:27:43.958329', NULL),
	(3, 'SX', 'Sixpax', 1, NULL, NULL, 'external', 0, '2021-04-07 17:27:43.958329', '2021-04-07 17:27:43.958329', NULL),
	(4, 'NY', 'Northy', 1, NULL, NULL, 'external', 0, '2021-04-07 17:27:43.958329', '2021-04-07 17:27:43.958329', NULL),
	(5, 'EN', 'Enfini8', 1, NULL, NULL, 'external', 0, '2021-04-07 17:27:43.958329', '2021-04-07 17:27:43.958329', NULL),
	(6, 'FS', 'Fourspeed', 1, NULL, NULL, 'external', 0, '2021-04-07 17:27:43.958329', '2021-04-07 17:27:43.958329', NULL),
	(7, 'GG', 'GGoodstuff', 1, NULL, NULL, 'external', 0, '2021-04-07 17:27:43.958329', '2021-04-07 17:27:43.958329', NULL),
	(8, 'NK', 'Noski', 1, NULL, NULL, 'external', 0, '2021-04-07 17:27:43.958329', '2021-04-07 17:27:43.958329', NULL),
	(9, 'RF', 'Richfield', 1, NULL, NULL, 'external', 0, '2021-04-07 17:27:43.958329', '2021-04-07 17:27:43.958329', NULL);
/*!40000 ALTER TABLE `brand` ENABLE KEYS */;

-- Dumping structure for table phillip.brand_category_item
CREATE TABLE IF NOT EXISTS `brand_category_item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `brand_id` int DEFAULT NULL,
  `category_id` int NOT NULL,
  `status` tinyint DEFAULT NULL,
  `comission` float NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_1732470a1f3028f0b1a5a1313b9` (`brand_id`),
  KEY `FK_dfab6de3e1b458c4d6b37435fba` (`category_id`),
  CONSTRAINT `FK_1732470a1f3028f0b1a5a1313b9` FOREIGN KEY (`brand_id`) REFERENCES `brand` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_dfab6de3e1b458c4d6b37435fba` FOREIGN KEY (`category_id`) REFERENCES `category` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.brand_category_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `brand_category_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `brand_category_item` ENABLE KEYS */;

-- Dumping structure for table phillip.category
CREATE TABLE IF NOT EXISTS `category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `parent_id` int DEFAULT NULL,
  `status` tinyint NOT NULL,
  `variant_id` int DEFAULT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.category: ~14 rows (approximately)
/*!40000 ALTER TABLE `category` DISABLE KEYS */;
INSERT INTO `category` (`id`, `code`, `name`, `parent_id`, `status`, `variant_id`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(1, 'NONE', 'None', NULL, 1, NULL, '2021-04-07 17:27:44.084087', '2021-04-07 17:27:44.084087', NULL),
	(2, 'TS', 'T-Shirt', NULL, 1, NULL, '2021-04-07 17:27:44.087535', '2021-04-07 17:27:44.087535', NULL),
	(3, 'AC', 'Accesories', NULL, 1, NULL, '2021-04-07 17:27:44.091159', '2021-04-07 17:27:44.091159', NULL),
	(4, 'BG', 'Bag', NULL, 1, NULL, '2021-04-07 17:27:44.100234', '2021-04-07 17:27:44.100234', NULL),
	(5, 'GL', 'Gloves', NULL, 1, NULL, '2021-04-07 17:27:44.102618', '2021-04-07 17:27:44.102618', NULL),
	(6, 'HT', 'Hat', NULL, 1, NULL, '2021-04-07 17:27:44.104910', '2021-04-07 17:27:44.104910', NULL),
	(7, 'JK', 'Jacket', NULL, 1, NULL, '2021-04-07 17:27:44.108312', '2021-04-07 17:27:44.108312', NULL),
	(8, 'JKD', 'Jacket Kids', NULL, 1, NULL, '2021-04-07 17:27:44.116745', '2021-04-07 17:27:44.116745', NULL),
	(9, 'HM', 'Helmet', NULL, 1, NULL, '2021-04-07 17:27:44.118864', '2021-04-07 17:27:44.118864', NULL),
	(10, 'SH', 'Shirt', NULL, 1, NULL, '2021-04-07 17:27:44.122176', '2021-04-07 17:27:44.122176', NULL),
	(11, 'TSK', 'T-Shirt Kids', NULL, 1, NULL, '2021-04-07 17:27:44.139103', '2021-04-07 17:27:44.139103', NULL),
	(12, 'SW', 'Sweater', NULL, 1, NULL, '2021-04-07 17:27:44.141747', '2021-04-07 17:27:44.141747', NULL),
	(13, 'PN', 'Pants', NULL, 1, NULL, '2021-05-24 12:51:31.000000', '2021-04-07 17:27:44.152012', NULL),
	(14, 'WL', 'Wallet', NULL, 1, NULL, '2021-04-07 17:27:44.156573', '2021-04-07 17:27:44.156573', NULL);
/*!40000 ALTER TABLE `category` ENABLE KEYS */;

-- Dumping structure for table phillip.category_variant
CREATE TABLE IF NOT EXISTS `category_variant` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_id` int NOT NULL,
  `variant_type_id` int NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.category_variant: ~0 rows (approximately)
/*!40000 ALTER TABLE `category_variant` DISABLE KEYS */;
/*!40000 ALTER TABLE `category_variant` ENABLE KEYS */;

-- Dumping structure for table phillip.city
CREATE TABLE IF NOT EXISTS `city` (
  `id` int NOT NULL AUTO_INCREMENT,
  `provinsi_id` int NOT NULL,
  `kabupaten_kota` varchar(100) NOT NULL,
  `ibukota` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=501 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.city: ~500 rows (approximately)
/*!40000 ALTER TABLE `city` DISABLE KEYS */;
INSERT INTO `city` (`id`, `provinsi_id`, `kabupaten_kota`, `ibukota`) VALUES
	(1, 1, 'Kabupaten Aceh Barat', 'Meulaboh'),
	(2, 1, 'Kabupaten Aceh Barat Daya', 'Blangpidie'),
	(3, 1, 'Kabupaten Aceh Besar', 'Jantho'),
	(4, 1, 'Kabupaten Aceh Jaya', 'Calang'),
	(5, 1, 'Kabupaten Aceh Selatan', 'Tapak Tuan'),
	(6, 1, 'Kabupaten Aceh Singkil', 'Singkil'),
	(7, 1, 'Kabupaten Aceh Tamiang', 'Karang Baru'),
	(8, 1, 'Kabupaten Aceh Tengah', 'Takengon'),
	(9, 1, 'Kabupaten Aceh Tenggara', 'Kutacane'),
	(10, 1, 'Kabupaten Aceh Timur', 'Langsa'),
	(11, 1, 'Kabupaten Aceh Utara', 'Lhoksukon'),
	(12, 1, 'Kabupaten Bener Meriah', 'Simpang Tiga Redelong'),
	(13, 1, 'Kabupaten Bireuen', 'Bireuen'),
	(14, 1, 'Kabupaten Gayo Lues', 'Blangkejeren'),
	(15, 1, 'Kabupaten Nagan Raya', 'Suka Makmue'),
	(16, 1, 'Kabupaten Pidie', 'Sigli'),
	(17, 1, 'Kabupaten Pidie Jaya', 'Meureundu'),
	(18, 1, 'Kabupaten Simeulue', 'Sinabang'),
	(19, 1, 'Kota Banda Aceh', 'Banda Aceh'),
	(20, 1, 'Kota Langsa', 'Langsa'),
	(21, 1, 'Kota Lhokseumawe', 'Lhokseumawe'),
	(22, 1, 'Kota Sabang', 'Sabang'),
	(23, 1, 'Kota Subulussalam', 'Subulussalam'),
	(24, 2, 'Kabupaten Asahan', 'Kisaran'),
	(25, 2, 'Kabupaten Batu Bara', 'Lima Puluh'),
	(26, 2, 'Kabupaten Dairi', 'Sidikalang'),
	(27, 2, 'Kabupaten Deli Serdang', 'Lubuk Pakam'),
	(28, 2, 'Kabupaten Humbang Hasundutan', 'Dolok Sanggul'),
	(29, 2, 'Kabupaten Karo', 'Kabanjahe'),
	(30, 2, 'Kabupaten Labuhanbatu', 'Rantau Prapat'),
	(31, 2, 'Kabupaten Labuhanbatu Selatan', 'Kota Pinang'),
	(32, 2, 'Kabupaten Labuhanbatu Utara', 'Aek Kanopan'),
	(33, 2, 'Kabupaten Langkat', 'Stabat'),
	(34, 2, 'Kabupaten Mandailing Natal', 'Panyabungan'),
	(35, 2, 'Kabupaten Nias', 'Gunungsitoli'),
	(36, 2, 'Kabupaten Nias Barat', 'Lahomi'),
	(37, 2, 'Kabupaten Nias Selatan', 'Teluk Dalam'),
	(38, 2, 'Kabupaten Nias Utara', 'Lotu'),
	(39, 2, 'Kabupaten Padang Lawas', 'Sibuhuan'),
	(40, 2, 'Kabupaten Padang Lawas Utara', 'Gunung Tua'),
	(41, 2, 'Kabupaten Pakpak Bharat', 'Salak'),
	(42, 2, 'Kabupaten Samosir', 'Pangururan'),
	(43, 2, 'Kabupaten Serdang Bedagai', 'Sei Rampah'),
	(44, 2, 'Kabupaten Simalungun', 'Pematang Siantar'),
	(45, 2, 'Kabupaten Tapanuli Selatan', 'Padang Sidempuan'),
	(46, 2, 'Kabupaten Tapanuli Tengah', 'Sibolga'),
	(47, 2, 'Kabupaten Tapanuli Utara', 'Tarutung'),
	(48, 2, 'Kabupaten Toba Samosir', 'Balige'),
	(49, 2, 'Kota Binjai', 'Binjai'),
	(50, 2, 'Kota Gunungsitoli', 'Gunungsitoli'),
	(51, 2, 'Kota Medan', 'Medan'),
	(52, 2, 'Kota Padang Sidempuan', 'Padang Sidempuan'),
	(53, 2, 'Kota Pematangsiantar', 'Pematangsiantar'),
	(54, 2, 'Kota Sibolga', 'Sibolga'),
	(55, 2, 'Kota Tanjung Balai', 'Tanjung Balai'),
	(56, 2, 'Kota Tebing Tinggi', 'Tebing Tinggi'),
	(57, 3, 'Kabupaten Agam', 'Lubuk Basung'),
	(58, 3, 'Kabupaten Dharmasraya', 'Pulau Punjung'),
	(59, 3, 'Kabupaten Kepulauan Mentawai', 'Tuapejat'),
	(60, 3, 'Kabupaten Lima Puluh Kota', 'Sarilamak'),
	(61, 3, 'Kabupaten Padang Pariaman', 'Nagari Parit Malintang'),
	(62, 3, 'Kabupaten Pasaman', 'Lubuk Sikaping'),
	(63, 3, 'Kabupaten Pasaman Barat', 'Simpang Empat'),
	(64, 3, 'Kabupaten Pesisir Selatan', 'Painan'),
	(65, 3, 'Kabupaten Sijunjung (Sawah Lunto Sijunjung)', 'Muaro Sijunjung'),
	(66, 3, 'Kabupaten Solok', 'Arosuka'),
	(67, 3, 'Kabupaten Solok Selatan', 'Padang Aro'),
	(68, 3, 'Kabupaten Tanah Datar', 'Batusangkar'),
	(69, 3, 'Kota Bukittinggi', 'Bukittinggi'),
	(70, 3, 'Kota Padang', 'Padang'),
	(71, 3, 'Kota Padang Panjang', 'Padang Panjang'),
	(72, 3, 'Kota Pariaman', 'Pariaman'),
	(73, 3, 'Kota Payakumbuh', 'Payakumbuh'),
	(74, 3, 'Kota Sawahlunto', 'Sawahlunto'),
	(75, 3, 'Kota Solok', 'Solok'),
	(76, 4, 'Kabupaten Bengkalis', 'Bengkalis'),
	(77, 4, 'Kabupaten Indragiri Hilir', 'Tembilahan'),
	(78, 4, 'Kabupaten Indragiri Hulu', 'Rengat'),
	(79, 4, 'Kabupaten Kampar', 'Bangkinang'),
	(80, 4, 'Kabupaten Kepulauan Meranti', 'Tebing Tinggi'),
	(81, 4, 'Kabupaten Kuantan Singingi', 'Teluk Kuantan'),
	(82, 4, 'Kabupaten Pelalawan', 'Pangkalan Kerinci'),
	(83, 4, 'Kabupaten Rokan Hilir', 'Ujung Tanjung'),
	(84, 4, 'Kabupaten Rokan Hulu', 'Pasir Pengarairan'),
	(85, 4, 'Kabupaten Siak', 'Siak Sriindrapura'),
	(86, 4, 'Kota Dumai', 'Dumai'),
	(87, 4, 'Kota Pekanbaru', 'Pekanbaru'),
	(88, 5, 'Kabupaten Batanghari', 'Muara Bulian'),
	(89, 5, 'Kabupaten Bungo', 'Muara Bungo'),
	(90, 5, 'Kabupaten Kerinci', 'Sungai Penuh'),
	(91, 5, 'Kabupaten Merangin', 'Bangko'),
	(92, 5, 'Kabupaten Muaro Jambi', 'Sengeti'),
	(93, 5, 'Kabupaten Sarolangun', 'Sarolangun'),
	(94, 5, 'Kabupaten Tanjung Jabung Barat', 'Kuala Tungkal'),
	(95, 5, 'Kabupaten Tanjung Jabung Timur', 'Muara Sabak'),
	(96, 5, 'Kabupaten Tebo', 'Muara Tebo'),
	(97, 5, 'Kota Jambi', 'Jambi'),
	(98, 5, 'Kota Sungai Penuh', 'Sungai Penuh'),
	(99, 6, 'Kabupaten Banyuasin', 'Pangkalan Balai'),
	(100, 6, 'Kabupaten Empat Lawang', 'Tebing Tinggi'),
	(101, 6, 'Kabupaten Lahat', 'Lahat'),
	(102, 6, 'Kabupaten Muara Enim', 'Muara Enim'),
	(103, 6, 'Kabupaten Musi Banyuasin', 'Sekayu'),
	(104, 6, 'Kabupaten Musi Rawas', 'Muarabeliti'),
	(105, 6, 'Kabupaten Musi Rawas Utara', 'Rupit'),
	(106, 6, 'Kabupaten Ogan Ilir', 'Indralaya'),
	(107, 6, 'Kabupaten Ogan Komering Ilir', 'Kayu Agung'),
	(108, 6, 'Kabupaten Ogan Komering Ulu', 'Baturaja'),
	(109, 6, 'Kabupaten Ogan Komering Ulu Selatan (Oku Selatan)', 'Muaradua'),
	(110, 6, 'Kabupaten Ogan Komering Ulu Timur (Oku Timur)', 'Martapura'),
	(111, 6, 'Kabupaten Penukal Abab Lematang Ilir', 'Talang Ubi'),
	(112, 6, 'Kota Lubuk Linggau', 'Lubuk Linggau'),
	(113, 6, 'Kota Pagar Alam', 'Pagar Alam'),
	(114, 6, 'Kota Palembang', 'Pelembang'),
	(115, 6, 'Kota Prabumulih', 'Prabumulih'),
	(116, 7, 'Kabupaten Bengkulu Selatan', 'Manna'),
	(117, 7, 'Kabupaten Bengkulu Tengah', 'Karang Tinggi'),
	(118, 7, 'Kabupaten Bengkulu Utara', 'Arga Makmur'),
	(119, 7, 'Kabupaten Kaur', 'Bintuhan'),
	(120, 7, 'Kabupaten Kepahiang', 'Kepahiang'),
	(121, 7, 'Kabupaten Lebong', 'Tubei'),
	(122, 7, 'Kabupaten Muko Muko', 'Mukomuko'),
	(123, 7, 'Kabupaten Rejang Lebong', 'Curup'),
	(124, 7, 'Kabupaten Seluma', 'Tais'),
	(125, 7, 'Kota Bengkulu', 'Bengkulu'),
	(126, 8, 'Kabupaten Lampung Barat', 'Liwa'),
	(127, 8, 'Kabupaten Lampung Selatan', 'Kalianda'),
	(128, 8, 'Kabupaten Lampung Tengah', 'Gunung Sugih'),
	(129, 8, 'Kabupaten Lampung Timur', 'Sukadana'),
	(130, 8, 'Kabupaten Lampung Utara', 'Kotabumi'),
	(131, 8, 'Kabupaten Mesuji', 'Mesuji'),
	(132, 8, 'Kabupaten Pesawaran', 'Gedong Tataan'),
	(133, 8, 'Kabupaten Pesisir Barat', 'Krui'),
	(134, 8, 'Kabupaten Pringsewu', 'Pringsewu'),
	(135, 8, 'Kabupaten Tanggamus', 'Kota Agung'),
	(136, 8, 'Kabupaten Tulang Bawang', 'Menggala'),
	(137, 8, 'Kabupaten Tulang Bawang Barat', 'Tulang Bawang Tengah'),
	(138, 8, 'Kabupaten Way Kanan', 'Blambangan Umpu'),
	(139, 8, 'Kota Bandar Lampung', 'Bandar Lampung'),
	(140, 8, 'Kota Metro', 'Metro'),
	(141, 9, 'Kabupaten Bangka', 'Sungai Liat'),
	(142, 9, 'Kabupaten Bangka Barat', 'Mentok'),
	(143, 9, 'Kabupaten Bangka Selatan', 'Toboali'),
	(144, 9, 'Kabupaten Bangka Tengah', 'Koba'),
	(145, 9, 'Kabupaten Belitung', 'Tanjung Pandan'),
	(146, 9, 'Kabupaten Belitung Timur', 'Manggar'),
	(147, 9, 'Kota Pangkal Pinang', 'Pangkal Pinang'),
	(148, 10, 'Kabupaten Bintan', 'Bandar Seri Bentan'),
	(149, 10, 'Kabupaten Karimun', 'Tanjung Balai Karimun'),
	(150, 10, 'Kabupaten Kepulauan Anambas', 'Tarempa'),
	(151, 10, 'Kabupaten Lingga', 'Daik Lingga'),
	(152, 10, 'Kabupaten Natuna', 'Ranai'),
	(153, 10, 'Kota Batam', 'Batam'),
	(154, 10, 'Kota Tanjung Pinang', 'Tanjung Pinang'),
	(155, 11, 'Kabupaten Adm. Kepulauan Seribu', 'Kepulauan Seribu Utara'),
	(156, 11, 'Kota Adm. Jakarta Barat', 'Grogol Petamburan'),
	(157, 11, 'Kota Adm. Jakarta Pusat', 'Tanah Abang'),
	(158, 11, 'Kota Adm. Jakarta Selatan', 'Kebayoran Baru'),
	(159, 11, 'Kota Adm. Jakarta Timur', 'Cakung'),
	(160, 11, 'Kota Adm. Jakarta Utara', 'Tanjung Priok'),
	(161, 12, 'Kabupaten Bandung', 'Soreang'),
	(162, 12, 'Kabupaten Bandung Barat', 'Ngamprah'),
	(163, 12, 'Kabupaten Bekasi', 'Cikarang'),
	(164, 12, 'Kabupaten Bogor', 'Cibinong'),
	(165, 12, 'Kabupaten Ciamis', 'Ciamis'),
	(166, 12, 'Kabupaten Cianjur', 'Cianjur'),
	(167, 12, 'Kabupaten Cirebon', 'Sumber'),
	(168, 12, 'Kabupaten Garut', 'Garut'),
	(169, 12, 'Kabupaten Indramayu', 'Indramayu'),
	(170, 12, 'Kabupaten Karawang', 'Karawang'),
	(171, 12, 'Kabupaten Kuningan', 'Kuningan'),
	(172, 12, 'Kabupaten Majalengka', 'Majalengka'),
	(173, 12, 'Kabupaten Pangandaran', 'Parigi'),
	(174, 12, 'Kabupaten Purwakarta', 'Purwakarta'),
	(175, 12, 'Kabupaten Subang', 'Subang'),
	(176, 12, 'Kabupaten Sukabumi', 'Sukabumi'),
	(177, 12, 'Kabupaten Sumedang', 'Sumedang'),
	(178, 12, 'Kabupaten Tasikmalaya', 'Singaparna'),
	(179, 12, 'Kota Bandung', 'Bandung'),
	(180, 12, 'Kota Banjar', 'Banjar'),
	(181, 12, 'Kota Bekasi', 'Bekasi'),
	(182, 12, 'Kota Bogor', 'Bogor'),
	(183, 12, 'Kota Cimahi', 'Cimahi'),
	(184, 12, 'Kota Cirebon', 'Cirebon'),
	(185, 12, 'Kota Depok', 'Depok'),
	(186, 12, 'Kota Sukabumi', 'Sukabumi'),
	(187, 12, 'Kota Tasikmalaya', 'Tasikmalaya'),
	(188, 13, 'Kabupaten Banjarnegara', 'Banjarnegara'),
	(189, 13, 'Kabupaten Banyumas', 'Purwokerto'),
	(190, 13, 'Kabupaten Batang', 'Batang'),
	(191, 13, 'Kabupaten Blora', 'Blora'),
	(192, 13, 'Kabupaten Boyolali', 'Boyolali'),
	(193, 13, 'Kabupaten Brebes', 'Brebes'),
	(194, 13, 'Kabupaten Cilacap', 'Cilacap'),
	(195, 13, 'Kabupaten Demak', 'Demak'),
	(196, 13, 'Kabupaten Grobogan', 'Purwodadi'),
	(197, 13, 'Kabupaten Jepara', 'Jepara'),
	(198, 13, 'Kabupaten Karanganyar', 'Karanganyar'),
	(199, 13, 'Kabupaten Kebumen', 'Kebumen'),
	(200, 13, 'Kabupaten Kendal', 'Kendal'),
	(201, 13, 'Kabupaten Klaten', 'Klaten'),
	(202, 13, 'Kabupaten Kudus', 'Kudus'),
	(203, 13, 'Kabupaten Magelang', 'Mungkid'),
	(204, 13, 'Kabupaten Pati', 'Pati'),
	(205, 13, 'Kabupaten Pekalongan', 'Kajen'),
	(206, 13, 'Kabupaten Pemalang', 'Pemalang'),
	(207, 13, 'Kabupaten Purbalingga', 'Purbalingga'),
	(208, 13, 'Kabupaten Purworejo', 'Purworejo'),
	(209, 13, 'Kabupaten Rembang', 'Rembang'),
	(210, 13, 'Kabupaten Semarang', 'Ungaran'),
	(211, 13, 'Kabupaten Sragen', 'Sragen'),
	(212, 13, 'Kabupaten Sukoharjo', 'Sukoharjo'),
	(213, 13, 'Kabupaten Tegal', 'Slawi'),
	(214, 13, 'Kabupaten Temanggung', 'Temanggung'),
	(215, 13, 'Kabupaten Wonogiri', 'Wonogiri'),
	(216, 13, 'Kabupaten Wonosobo', 'Wonosobo'),
	(217, 13, 'Kota Magelang', 'Magelang'),
	(218, 13, 'Kota Pekalongan', 'Pekalongan'),
	(219, 13, 'Kota Salatiga', 'Salatiga'),
	(220, 13, 'Kota Semarang', 'Semarang'),
	(221, 13, 'Kota Surakarta (Solo)', 'Surakarta'),
	(222, 13, 'Kota Tegal', 'Tegal'),
	(223, 14, 'Kabupaten Bantul', 'Bantul'),
	(224, 14, 'Kabupaten Gunung Kidul', 'Wonosari'),
	(225, 14, 'Kabupaten Kulon Progo', 'Wates'),
	(226, 14, 'Kabupaten Sleman', 'Sleman'),
	(227, 14, 'Kota Yogyakarta', 'Yogyakarta'),
	(228, 15, 'Kabupaten Bangkalan', 'Bangkalan'),
	(229, 15, 'Kabupaten Banyuwangi', 'Banyuwangi'),
	(230, 15, 'Kabupaten Blitar', 'Kanigoro'),
	(231, 15, 'Kabupaten Bojonegoro', 'Bojonegoro'),
	(232, 15, 'Kabupaten Bondowoso', 'Bondowoso'),
	(233, 15, 'Kabupaten Gresik', 'Gresik'),
	(234, 15, 'Kabupaten Jember', 'Jember'),
	(235, 15, 'Kabupaten Jombang', 'Jombang'),
	(236, 15, 'Kabupaten Kediri', 'Kediri'),
	(237, 15, 'Kabupaten Lamongan', 'Lamongan'),
	(238, 15, 'Kabupaten Lumajang', 'Lumajang'),
	(239, 15, 'Kabupaten Madiun', 'Mejayan'),
	(240, 15, 'Kabupaten Magetan', 'Magetan'),
	(241, 15, 'Kabupaten Malang', 'Kepanjen'),
	(242, 15, 'Kabupaten Mojokerto', 'Mojokerto'),
	(243, 15, 'Kabupaten Nganjuk', 'Nganjuk'),
	(244, 15, 'Kabupaten Ngawi', 'Ngawi'),
	(245, 15, 'Kabupaten Pacitan', 'Pacitan'),
	(246, 15, 'Kabupaten Pamekasan', 'Pamekasan'),
	(247, 15, 'Kabupaten Pasuruan', 'Pasuruan'),
	(248, 15, 'Kabupaten Ponorogo', 'Ponorogo'),
	(249, 15, 'Kabupaten Probolinggo', 'Kraksaan'),
	(250, 15, 'Kabupaten Sampang', 'Sampang'),
	(251, 15, 'Kabupaten Sidoarjo', 'Sidoarjo'),
	(252, 15, 'Kabupaten Situbondo', 'Situbondo'),
	(253, 15, 'Kabupaten Sumenep', 'Sumenep'),
	(254, 15, 'Kabupaten Trenggalek', 'Trenggalek'),
	(255, 15, 'Kabupaten Tuban', 'Tuban'),
	(256, 15, 'Kabupaten Tulungagung', 'Tulungagung'),
	(257, 15, 'Kota Batu', 'Batu'),
	(258, 15, 'Kota Blitar', 'Blitar'),
	(259, 15, 'Kota Kediri', 'Kediri'),
	(260, 15, 'Kota Madiun', 'Madiun'),
	(261, 15, 'Kota Malang', 'Malang'),
	(262, 15, 'Kota Mojokerto', 'Mojokerto'),
	(263, 15, 'Kota Pasuruan', 'Pasuruan'),
	(264, 15, 'Kota Probolinggo', 'Probolinggo'),
	(265, 15, 'Kota Surabaya', 'Surabaya'),
	(266, 16, 'Kabupaten Lebak', 'Rangkas Bitung'),
	(267, 16, 'Kabupaten Pandeglang', 'Pandeglang'),
	(268, 16, 'Kabupaten Serang', 'Serang'),
	(269, 16, 'Kabupaten Tangerang', 'Tigaraksa'),
	(270, 16, 'Kota Cilegon', 'Cilegon'),
	(271, 16, 'Kota Serang', 'Serang'),
	(272, 16, 'Kota Tangerang', 'Tangerang'),
	(273, 16, 'Kota Tangerang Selatan', 'Ciputat'),
	(274, 17, 'Kabupaten Badung', 'Mengwi'),
	(275, 17, 'Kabupaten Bangli', 'Bangli'),
	(276, 17, 'Kabupaten Buleleng', 'Singaraja'),
	(277, 17, 'Kabupaten Gianyar', 'Gianyar'),
	(278, 17, 'Kabupaten Jembrana', 'Negara'),
	(279, 17, 'Kabupaten Karangasem', 'Karangasem'),
	(280, 17, 'Kabupaten Klungkung', 'Semarapura'),
	(281, 17, 'Kabupaten Tabanan', 'Tabanan'),
	(282, 17, 'Kota Denpasar', 'Denpasar'),
	(283, 18, 'Kabupaten Bima', 'Woha'),
	(284, 18, 'Kabupaten Dompu', 'Dompu'),
	(285, 18, 'Kabupaten Lombok Barat', 'Gerung'),
	(286, 18, 'Kabupaten Lombok Tengah', 'Praya'),
	(287, 18, 'Kabupaten Lombok Timur', 'Selong'),
	(288, 18, 'Kabupaten Lombok Utara', 'Tanjung'),
	(289, 18, 'Kabupaten Sumbawa', 'Sumbawa Besar'),
	(290, 18, 'Kabupaten Sumbawa Barat', 'Taliwang'),
	(291, 18, 'Kota Bima', 'Bima'),
	(292, 18, 'Kota Mataram', 'Mataram'),
	(293, 19, 'Kabupaten Alor', 'Kalabahi'),
	(294, 19, 'Kabupaten Belu', 'Atambua'),
	(295, 19, 'Kabupaten Ende', 'Ende'),
	(296, 19, 'Kabupaten Flores Timur', 'Larantuka'),
	(297, 19, 'Kabupaten Kupang', 'Kupang'),
	(298, 19, 'Kabupaten Lembata', 'Lewoleba'),
	(299, 19, 'Kabupaten Malaka', 'Betun'),
	(300, 19, 'Kabupaten Manggarai', 'Ruteng'),
	(301, 19, 'Kabupaten Manggarai Barat', 'Labuan Bajo'),
	(302, 19, 'Kabupaten Manggarai Timur', 'Borong'),
	(303, 19, 'Kabupaten Nagekeo', 'Mbay'),
	(304, 19, 'Kabupaten Ngada', 'Bajawa'),
	(305, 19, 'Kabupaten Rote Ndao', 'Baa'),
	(306, 19, 'Kabupaten Sabu Raijua', 'Sabu Barat'),
	(307, 19, 'Kabupaten Sikka', 'Maumere'),
	(308, 19, 'Kabupaten Sumba Barat', 'Waikabubak'),
	(309, 19, 'Kabupaten Sumba Barat Daya', 'Tambolaka'),
	(310, 19, 'Kabupaten Sumba Tengah', 'Waibakul'),
	(311, 19, 'Kabupaten Sumba Timur', 'Waingapu'),
	(312, 19, 'Kabupaten Timor Tengah Selatan', 'Soe'),
	(313, 19, 'Kabupaten Timor Tengah Utara', 'Kefamenanu'),
	(314, 19, 'Kota Kupang', 'Kupang'),
	(315, 20, 'Kabupaten Bengkayang', 'Bengkayang'),
	(316, 20, 'Kabupaten Kapuas Hulu', 'Putussibau'),
	(317, 20, 'Kabupaten Kayong Utara', 'Sukadane'),
	(318, 20, 'Kabupaten Ketapang', 'Ketapang'),
	(319, 20, 'Kabupaten Kubu Raya', 'Sungai Raya'),
	(320, 20, 'Kabupaten Landak', 'Ngabang'),
	(321, 20, 'Kabupaten Melawi', 'Nanga Pinoh'),
	(322, 20, 'Kabupaten Mempawah', 'Mempawah'),
	(323, 20, 'Kabupaten Sambas', 'Sambas'),
	(324, 20, 'Kabupaten Sanggau', 'Sanggau'),
	(325, 20, 'Kabupaten Sekadau', 'Sekadau'),
	(326, 20, 'Kabupaten Sintang', 'Sintang'),
	(327, 20, 'Kota Pontianak', 'Pontianak'),
	(328, 20, 'Kota Singkawang', 'Singkawang'),
	(329, 21, 'Kabupaten Barito Selatan', 'Buntok'),
	(330, 21, 'Kabupaten Barito Timur', 'Tamiang Layang'),
	(331, 21, 'Kabupaten Barito Utara', 'Muara Teweh'),
	(332, 21, 'Kabupaten Gunung Mas', 'Kuala Kurun'),
	(333, 21, 'Kabupaten Kapuas', 'Kuala Kapuas'),
	(334, 21, 'Kabupaten Katingan', 'Kasongan'),
	(335, 21, 'Kabupaten Kotawaringin Barat', 'Pangkalan Bun'),
	(336, 21, 'Kabupaten Kotawaringin Timur', 'Sampit'),
	(337, 21, 'Kabupaten Lamandau', 'Nanga Bulik'),
	(338, 21, 'Kabupaten Murung Raya', 'Puruk Cahu'),
	(339, 21, 'Kabupaten Pulang Pisau', 'Pulang Pisau'),
	(340, 21, 'Kabupaten Seruyan', 'Kuala Pembuang'),
	(341, 21, 'Kabupaten Sukamara', 'Sukamara'),
	(342, 21, 'Kota Palangka Raya', 'Palangkaraya'),
	(343, 22, 'Kabupaten Balangan', 'Paringin'),
	(344, 22, 'Kabupaten Banjar', 'Martapura'),
	(345, 22, 'Kabupaten Barito Kuala', 'Marabahan'),
	(346, 22, 'Kabupaten Hulu Sungai Selatan', 'Kandangan'),
	(347, 22, 'Kabupaten Hulu Sungai Tengah', 'Barabai'),
	(348, 22, 'Kabupaten Hulu Sungai Utara', 'Amuntai'),
	(349, 22, 'Kabupaten Kotabaru', 'Kotabaru'),
	(350, 22, 'Kabupaten Tabalong', 'Tanjung'),
	(351, 22, 'Kabupaten Tanah Bumbu', 'Batulicin'),
	(352, 22, 'Kabupaten Tanah Laut', 'Pelaihari'),
	(353, 22, 'Kabupaten Tapin', 'Rantau'),
	(354, 22, 'Kota Banjarbaru', 'Banjarbaru'),
	(355, 22, 'Kota Banjarmasin', 'Banjarmasin'),
	(356, 23, 'Kabupaten Berau', 'Tanjung Redeb'),
	(357, 23, 'Kabupaten Kutai Barat', 'Sendawar'),
	(358, 23, 'Kabupaten Kutai Kartanegara', 'Tenggarong'),
	(359, 23, 'Kabupaten Kutai Timur', 'Sanggatta'),
	(360, 23, 'Kabupaten Mahakam Ulu', 'Ujoh Bilang'),
	(361, 23, 'Kabupaten Paser', 'Tanah Grogot'),
	(362, 23, 'Kabupaten Penajam Paser Utara', 'Penajam'),
	(363, 23, 'Kota Balikpapan', 'Balikpapan'),
	(364, 23, 'Kota Bontang', 'Bontang'),
	(365, 23, 'Kota Samarinda', 'Samarinda'),
	(366, 24, 'Kabupaten Bulungan (Bulongan)', 'Tanjung Selor'),
	(367, 24, 'Kabupaten Malinau', 'Malinau'),
	(368, 24, 'Kabupaten Nunukan', 'Nunukan'),
	(369, 24, 'Kabupaten Tana Tidung', 'Tideng Pale'),
	(370, 24, 'Kota Tarakan', 'Tarakan'),
	(371, 25, 'Kabupaten Bolaang Mongondow', 'Lolak'),
	(372, 25, 'Kabupaten Bolaang Mongondow Selatan', 'Bolaang Uki'),
	(373, 25, 'Kabupaten Bolaang Mongondow Timur', 'Tutuyan'),
	(374, 25, 'Kabupaten Bolaang Mongondow Utara', 'Boroko'),
	(375, 25, 'Kabupaten Kepulauan Sangihe', 'Tahuna'),
	(376, 25, 'Kabupaten Kepulauan Siau Tagulandang Biaro (Sitaro)', 'Ondong Siau'),
	(377, 25, 'Kabupaten Kepulauan Talaud', 'Melongguane'),
	(378, 25, 'Kabupaten Minahasa', 'Tondano'),
	(379, 25, 'Kabupaten Minahasa Selatan', 'Amurang'),
	(380, 25, 'Kabupaten Minahasa Tenggara', 'Ratahan'),
	(381, 25, 'Kabupaten Minahasa Utara', 'Air Madidi'),
	(382, 25, 'Kota Bitung', 'Bitung'),
	(383, 25, 'Kota Kotamobagu', 'Kotamobagu'),
	(384, 25, 'Kota Manado', 'Manado'),
	(385, 25, 'Kota Tomohon', 'Tomohon'),
	(386, 26, 'Kabupaten Banggai', 'Luwuk'),
	(387, 26, 'Kabupaten Banggai Kepulauan', 'Salakan'),
	(388, 26, 'Kabupaten Banggai Laut', 'Banggai'),
	(389, 26, 'Kabupaten Buol', 'Buol'),
	(390, 26, 'Kabupaten Donggala', 'Donggala'),
	(391, 26, 'Kabupaten Morowali', 'Bungku'),
	(392, 26, 'Kabupaten Morowali Utara', 'Kolonodale'),
	(393, 26, 'Kabupaten Parigi Moutong', 'Parigi'),
	(394, 26, 'Kabupaten Poso', 'Poso'),
	(395, 26, 'Kabupaten Sigi', 'Sigi Biromaru'),
	(396, 26, 'Kabupaten Tojo Una-Una', 'Ampana'),
	(397, 26, 'Kabupaten Toli-Toli', 'Toli Toli'),
	(398, 26, 'Kota Palu', 'Palu'),
	(399, 27, 'Kabupaten Bantaeng', 'Bantaeng'),
	(400, 27, 'Kabupaten Barru', 'Barru'),
	(401, 27, 'Kabupaten Bone', 'Watampone'),
	(402, 27, 'Kabupaten Bulukumba', 'Bulukumba'),
	(403, 27, 'Kabupaten Enrekang', 'Enrekang'),
	(404, 27, 'Kabupaten Gowa', 'Sungguminasa'),
	(405, 27, 'Kabupaten Jeneponto', 'Jeneponto'),
	(406, 27, 'Kabupaten Selayar (Kepulauan Selayar)', 'Benteng'),
	(407, 27, 'Kabupaten Luwu', 'Palopo'),
	(408, 27, 'Kabupaten Luwu Timur', 'Malili'),
	(409, 27, 'Kabupaten Luwu Utara', 'Masamba'),
	(410, 27, 'Kabupaten Maros', 'Maros'),
	(411, 27, 'Kabupaten Pangkajene Kepulauan', 'Pangkajene'),
	(412, 27, 'Kabupaten Pinrang', 'Pinrang'),
	(413, 27, 'Kabupaten Sidenreng Rappang (Sidrap)', 'Sidenreng'),
	(414, 27, 'Kabupaten Sinjai', 'Sinjai'),
	(415, 27, 'Kabupaten Soppeng', 'Watan Soppeng'),
	(416, 27, 'Kabupaten Takalar', 'Takalar'),
	(417, 27, 'Kabupaten Tana Toraja', 'Makale'),
	(418, 27, 'Kabupaten Toraja Utara', 'Rantepao'),
	(419, 27, 'Kabupaten Wajo', 'Sengkang'),
	(420, 27, 'Kota Makassar', 'Makassar'),
	(421, 27, 'Kota Palopo', 'Palopo'),
	(422, 27, 'Kota Parepare', 'Pare Pare'),
	(423, 28, 'Kabupaten Bombana', 'Rumbia'),
	(424, 28, 'Kabupaten Buton', 'Pasar Wajo'),
	(425, 28, 'Kabupaten Buton Selatan', 'Batauga'),
	(426, 28, 'Kabupaten Buton Tengah', 'Labungkari'),
	(427, 28, 'Kabupaten Buton Utara', 'Buranga'),
	(428, 28, 'Kabupaten Kolaka', 'Kolaka'),
	(429, 28, 'Kabupaten Kolaka Timur', 'Tirawuta'),
	(430, 28, 'Kabupaten Kolaka Utara', 'Lasusua'),
	(431, 28, 'Kabupaten Konawe', 'Unaaha'),
	(432, 28, 'Kabupaten Konawe Kepulauan', 'Langara'),
	(433, 28, 'Kabupaten Konawe Selatan', 'Andoolo'),
	(434, 28, 'Kabupaten Konawe Utara', 'Wanggudu'),
	(435, 28, 'Kabupaten Muna', 'Raha'),
	(436, 28, 'Kabupaten Muna Barat', 'Sawerigadi'),
	(437, 28, 'Kabupaten Wakatobi', 'Wangi Wangi'),
	(438, 28, 'Kota Baubau', 'Bau-Bau'),
	(439, 28, 'Kota Kendari', 'Kendari'),
	(440, 29, 'Kabupaten Boalemo', 'Tilamuta'),
	(441, 29, 'Kabupaten Bone Bolango', 'Suwawa'),
	(442, 29, 'Kabupaten Gorontalo', 'Limboto'),
	(443, 29, 'Kabupaten Gorontalo Utara', 'Kwandang'),
	(444, 29, 'Kabupaten Pohuwato', 'Marisa'),
	(445, 29, 'Kota Gorontalo', 'Gorontalo'),
	(446, 30, 'Kabupaten Majene', 'Majene'),
	(447, 30, 'Kabupaten Mamasa', 'Mamasa'),
	(448, 30, 'Kabupaten Mamuju', 'Mamuju'),
	(449, 30, 'Kabupaten Mamuju Tengah', 'Tobadak'),
	(450, 30, 'Kabupaten Mamuju Utara', 'Pasangkayu'),
	(451, 30, 'Kabupaten Polewali Mandar', 'Polewali'),
	(452, 31, 'Kabupaten Buru', 'Namlea'),
	(453, 31, 'Kabupaten Buru Selatan', 'Namrole'),
	(454, 31, 'Kabupaten Kepulauan Aru', 'Dobo'),
	(455, 31, 'Kabupaten Maluku Barat Daya', 'Tiakur'),
	(456, 31, 'Kabupaten Maluku Tengah', 'Masohi'),
	(457, 31, 'Kabupaten Maluku Tenggara', 'Tual'),
	(458, 31, 'Kabupaten Maluku Tenggara Barat', 'Saumlaki'),
	(459, 31, 'Kabupaten Seram Bagian Barat', 'Dataran Hunipopu'),
	(460, 31, 'Kabupaten Seram Bagian Timur', 'Dataran Hunimoa'),
	(461, 31, 'Kota Ambon', 'Ambon'),
	(462, 31, 'Kota Tual', 'Tual'),
	(463, 32, 'Kabupaten Halmahera Barat', 'Jailolo'),
	(464, 32, 'Kabupaten Halmahera Selatan', 'Labuha'),
	(465, 32, 'Kabupaten Halmahera Tengah', 'Weda'),
	(466, 32, 'Kabupaten Halmahera Timur', 'Maba'),
	(467, 32, 'Kabupaten Halmahera Utara', 'Tobelo'),
	(468, 32, 'Kabupaten Kepulauan Sula', 'Sanana'),
	(469, 32, 'Kabupaten Pulau Morotai', 'Daruba'),
	(470, 32, 'Kabupaten Pulau Taliabu', 'Bobong'),
	(471, 32, 'Kota Ternate', 'Ternate'),
	(472, 32, 'Kota Tidore Kepulauan', 'Tidore'),
	(473, 33, 'Kabupaten Asmat', 'Agats'),
	(474, 33, 'Kabupaten Biak Numfor', 'Biak'),
	(475, 33, 'Kabupaten Boven Digoel', 'Tanah Merah'),
	(476, 33, 'Kabupaten Deiyai (Deliyai)', 'Tigi'),
	(477, 33, 'Kabupaten Dogiyai', 'Kigamani'),
	(478, 33, 'Kabupaten Intan Jaya', 'Sugapa'),
	(479, 33, 'Kabupaten Jayapura', 'Jayapura'),
	(480, 33, 'Kabupaten Jayawijaya', 'Wamena'),
	(481, 33, 'Kabupaten Keerom', 'Waris'),
	(482, 33, 'Kabupaten Kepulauan Yapen (Yapen Waropen)', 'Serui'),
	(483, 33, 'Kabupaten Lanny Jaya', 'Tiom'),
	(484, 33, 'Kabupaten Mamberamo Raya', 'Burmeso'),
	(485, 33, 'Kabupaten Mamberamo Tengah', 'Kobakma'),
	(486, 33, 'Kabupaten Mappi', 'Kepi'),
	(487, 33, 'Kabupaten Merauke', 'Merauke'),
	(488, 33, 'Kabupaten Mimika', 'Timika'),
	(489, 33, 'Kabupaten Nabire', 'Nabire'),
	(490, 33, 'Kabupaten Nduga', 'Kenyam'),
	(491, 33, 'Kabupaten Paniai', 'Enarotali'),
	(492, 33, 'Kabupaten Pegunungan Bintang', 'Oksibil'),
	(493, 33, 'Kabupaten Puncak', 'Ilaga'),
	(494, 33, 'Kabupaten Puncak Jaya', 'Mulia'),
	(495, 33, 'Kabupaten Sarmi', 'Sarmi'),
	(496, 33, 'Kabupaten Supiori', 'Sorendiweri'),
	(497, 33, 'Kabupaten Tolikara', 'Karubaga'),
	(498, 33, 'Kabupaten Waropen', 'Botawa'),
	(499, 33, 'Kabupaten Yahukimo', 'Sumohai'),
	(500, 33, 'Kabupaten Yalimo', 'Elelim');
/*!40000 ALTER TABLE `city` ENABLE KEYS */;

-- Dumping structure for table phillip.color
CREATE TABLE IF NOT EXISTS `color` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(70) NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.color: ~32 rows (approximately)
/*!40000 ALTER TABLE `color` DISABLE KEYS */;
INSERT INTO `color` (`id`, `code`, `name`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(1, 'None', 'NONE', '2021-04-07 17:27:44.395338', '2021-04-07 17:27:44.395338', NULL),
	(2, 'BL', 'Black', '2021-04-07 17:27:44.400564', '2021-04-07 17:27:44.400564', NULL),
	(3, 'YW', 'Yellow', '2021-04-07 17:27:44.420604', '2021-04-07 17:27:44.420604', NULL),
	(4, 'WT', 'White', '2021-04-07 17:27:44.423246', '2021-04-07 17:27:44.423246', NULL),
	(5, 'BE', 'Blue', '2021-04-07 17:27:44.425423', '2021-04-07 17:27:44.425423', NULL),
	(6, 'GY', 'Grey', '2021-04-07 17:27:44.427887', '2021-04-07 17:27:44.427887', NULL),
	(7, 'RD', 'Red', '2021-04-07 17:27:44.430253', '2021-04-07 17:27:44.430253', NULL),
	(8, 'BW', 'Brown', '2021-04-07 17:27:44.432452', '2021-04-07 17:27:44.432452', NULL),
	(9, 'MC', 'Mocca', '2021-04-07 17:27:44.434682', '2021-04-07 17:27:44.434682', NULL),
	(10, 'OG', 'Orange', '2021-04-07 17:27:44.437150', '2021-04-07 17:27:44.437150', NULL),
	(11, 'OL', 'Olive', '2021-04-07 17:27:44.439601', '2021-04-07 17:27:44.439601', NULL),
	(12, 'GN', 'Green', '2021-04-07 17:27:44.441981', '2021-04-07 17:27:44.441981', NULL),
	(13, 'MR', 'Maroon', '2021-04-07 17:27:44.444684', '2021-04-07 17:27:44.444684', NULL),
	(14, 'CM', 'Camo', '2021-04-07 17:27:44.446919', '2021-04-07 17:27:44.446919', NULL),
	(15, 'AR', 'Army', '2021-04-07 17:27:44.448930', '2021-04-07 17:27:44.448930', NULL),
	(16, 'DS', 'Desert', '2021-04-07 17:27:44.451128', '2021-04-07 17:27:44.451128', NULL),
	(17, 'NV', 'Navy', '2021-04-07 17:27:44.453700', '2021-04-07 17:27:44.453700', NULL),
	(18, 'TC', 'Tosca', '2021-04-07 17:27:44.455907', '2021-04-07 17:27:44.455907', NULL),
	(19, 'DM', 'Denim', '2021-04-07 17:27:44.458150', '2021-04-07 17:27:44.458150', NULL),
	(20, 'WH', 'Wash', '2021-04-07 17:27:44.460566', '2021-04-07 17:27:44.460566', NULL),
	(21, 'DK', 'Dark', '2021-04-07 17:27:44.462770', '2021-04-07 17:27:44.462770', NULL),
	(22, 'BD', 'Black Doff', '2021-04-07 17:27:44.462770', '2021-04-07 17:27:44.462770', NULL),
	(23, 'CH', 'Chocolatte', '2021-04-07 17:27:44.462770', '2021-04-07 17:27:44.462770', NULL),
	(24, 'TN', 'Tan', '2021-04-07 17:27:44.462770', '2021-04-07 17:27:44.462770', NULL),
	(25, 'DB', 'Dark Blue', '2021-04-07 17:27:44.462770', '2021-04-07 17:27:44.462770', NULL),
	(26, 'DG', 'Dark Grey', '2021-04-07 17:27:44.462770', '2021-04-07 17:27:44.462770', NULL),
	(27, 'CR', 'Cream', '2021-04-07 17:27:44.462770', '2021-04-07 17:27:44.462770', NULL),
	(28, 'SV', 'Silver', '2021-04-07 17:27:44.462770', '2021-04-07 17:27:44.462770', NULL),
	(29, 'AP', 'Alpaca', '2021-04-07 17:27:44.462770', '2021-04-07 17:27:44.462770', NULL),
	(30, 'BR', 'Brass', '2021-04-07 17:27:44.462770', '2021-04-07 17:27:44.462770', NULL),
	(31, 'MX', 'Mixed', '2021-04-07 17:27:44.462770', '2021-04-07 17:27:44.462770', NULL),
	(32, 'KH', 'Khaky', '2021-04-07 17:27:44.462770', '2021-04-07 17:27:44.462770', NULL);
/*!40000 ALTER TABLE `color` ENABLE KEYS */;

-- Dumping structure for table phillip.company
CREATE TABLE IF NOT EXISTS `company` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_name` varchar(100) NOT NULL,
  `province` varchar(50) DEFAULT NULL,
  `postal_code` int DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `country` varchar(20) DEFAULT NULL,
  `logo_url` varchar(255) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `site_address` varchar(50) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.company: ~0 rows (approximately)
/*!40000 ALTER TABLE `company` DISABLE KEYS */;
INSERT INTO `company` (`id`, `company_name`, `province`, `postal_code`, `city`, `country`, `logo_url`, `phone`, `email`, `site_address`, `address`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(1, 'Phillip Works', NULL, NULL, NULL, 'Indonesia', 'company/images.png', NULL, NULL, 'https://phillipworks.com/', NULL, '2021-04-07 17:27:43.156000', '2021-04-07 17:27:43.156000', NULL);
/*!40000 ALTER TABLE `company` ENABLE KEYS */;

-- Dumping structure for table phillip.contact
CREATE TABLE IF NOT EXISTS `contact` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` enum('user','supplier','brand','consignment') NOT NULL,
  `is_active` tinyint DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `code` varchar(20) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address` text,
  `country` varchar(50) DEFAULT NULL,
  `province` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `postal_code` int DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `is_brand` tinyint DEFAULT NULL,
  `brand_comission_type` enum('all_product','by_category') DEFAULT NULL,
  `brand_comission` double DEFAULT NULL,
  `is_consignment` tinyint DEFAULT NULL,
  `consignment_comission_type` enum('all_product','by_category') DEFAULT NULL,
  `consignment_comission` double DEFAULT NULL,
  `is_supplier` tinyint DEFAULT NULL,
  `is_user` tinyint DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10000006 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.contact: ~5 rows (approximately)
/*!40000 ALTER TABLE `contact` DISABLE KEYS */;
INSERT INTO `contact` (`id`, `type`, `is_active`, `name`, `code`, `phone`, `address`, `country`, `province`, `city`, `email`, `postal_code`, `note`, `is_brand`, `brand_comission_type`, `brand_comission`, `is_consignment`, `consignment_comission_type`, `consignment_comission`, `is_supplier`, `is_user`, `user_id`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(1, 'user', 1, 'Admin', 'CODE', NULL, NULL, NULL, 'Jawa Barat', 'Kota Bandung', NULL, 0, NULL, 0, NULL, NULL, 0, NULL, NULL, NULL, 1, 1, '1800-01-01 09:19:53', '1800-01-01 09:19:53', NULL),
	(2, 'user', 1, 'Admin 2', 'CODE2', NULL, NULL, NULL, 'Jawa Barat', 'Kota Bandung', NULL, 0, NULL, 0, NULL, NULL, 0, NULL, NULL, NULL, 1, 2, '1800-01-01 09:19:53', '1800-01-01 09:19:53', NULL),
	(10000003, 'user', 1, 'Jubey', 'CTC-2405-10000003', NULL, 'Jl.Bahureksa No.1', 'Indonesia', 'Jawa Barat', NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, NULL, 0, 1, 10000003, '2021-05-24 13:10:36', '2021-05-24 13:10:36', NULL),
	(10000004, 'user', 1, 'galih kristian', 'CTC-2505-10000004', '089528192552', 'Banturejo RT/RW 07/14, Sukoharjo, Ngaglik, Sleman', 'Indonesia', 'Daerah Istimewa Yogyakarta', 'Sleman', 'galihkristian123@gmail.com', 55581, NULL, 0, NULL, NULL, 0, NULL, NULL, 0, 1, 10000004, '2021-05-25 18:06:34', '2021-05-25 18:06:34', NULL),
	(10000005, 'user', 1, 'Royhan Rivaldi HD', 'CTC-2505-10000005', '081573563052', 'kampung cipatat rt 02 rw 10 desa lagadar kecamatan marga asih, Kab. Bandung', 'Indonesia', 'Jawa Barat', 'Soreang', 'royhan.mary@gmail.com', NULL, NULL, 0, NULL, NULL, 0, NULL, NULL, 0, 1, 10000005, '2021-05-25 19:15:56', '2021-05-25 19:15:56', NULL);
/*!40000 ALTER TABLE `contact` ENABLE KEYS */;

-- Dumping structure for table phillip.member
CREATE TABLE IF NOT EXISTS `member` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `member_code` varchar(255) NOT NULL,
  `address` text,
  `country` varchar(255) DEFAULT NULL,
  `province` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `email` varchar(90) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `postal_code` int DEFAULT NULL,
  `note` text,
  `member_social` varchar(255) DEFAULT NULL,
  `member_card_status` enum('SUDAH_DIBERIKAN','BELUM_DIBERIKAN') DEFAULT 'BELUM_DIBERIKAN',
  `member_card_received_date` date DEFAULT NULL,
  `member_card_expired_date` date DEFAULT NULL,
  `is_active` tinyint DEFAULT NULL,
  `total_transaction` int DEFAULT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.member: ~2 rows (approximately)
/*!40000 ALTER TABLE `member` DISABLE KEYS */;
INSERT INTO `member` (`id`, `name`, `member_code`, `address`, `country`, `province`, `city`, `email`, `phone`, `postal_code`, `note`, `member_social`, `member_card_status`, `member_card_received_date`, `member_card_expired_date`, `is_active`, `total_transaction`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(1, 'VIP', '-', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'SUDAH_DIBERIKAN', '2020-01-01', '4000-01-01', 1, NULL, '2021-04-07 17:27:44.394050', '2021-04-07 17:27:44.394050', NULL),
	(2, 'GENERAL', '-', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'SUDAH_DIBERIKAN', '2020-01-01', '4000-01-01', 1, NULL, '2021-04-07 17:27:44.398925', '2021-04-07 17:27:44.398925', NULL);
/*!40000 ALTER TABLE `member` ENABLE KEYS */;

-- Dumping structure for table phillip.product
CREATE TABLE IF NOT EXISTS `product` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `product_type` enum('product_sales','product_general','consignment') NOT NULL,
  `name` varchar(255) NOT NULL,
  `category_id` int DEFAULT NULL,
  `unit_of_measurement_id` int DEFAULT NULL,
  `color_id` int DEFAULT NULL,
  `hpp` int NOT NULL,
  `material_price` int NOT NULL,
  `sales_price` int DEFAULT NULL,
  `comission` int DEFAULT NULL,
  `brand_id` int DEFAULT NULL,
  `status` tinyint NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_0dce9bc93c2d2c399982d04bef1` (`category_id`),
  KEY `FK_a732ea630f0dbb9f4b26ffff1e5` (`unit_of_measurement_id`),
  KEY `FK_e586d22a197c9b985af3ac82ce3` (`color_id`),
  KEY `FK_2eb5ce4324613b4b457c364f4a2` (`brand_id`),
  FULLTEXT KEY `IDX_99c39b067cfa73c783f0fc49a6` (`code`),
  FULLTEXT KEY `IDX_22cc43e9a74d7498546e9a63e7` (`name`),
  CONSTRAINT `FK_0dce9bc93c2d2c399982d04bef1` FOREIGN KEY (`category_id`) REFERENCES `category` (`id`),
  CONSTRAINT `FK_2eb5ce4324613b4b457c364f4a2` FOREIGN KEY (`brand_id`) REFERENCES `brand` (`id`),
  CONSTRAINT `FK_a732ea630f0dbb9f4b26ffff1e5` FOREIGN KEY (`unit_of_measurement_id`) REFERENCES `unit` (`id`),
  CONSTRAINT `FK_e586d22a197c9b985af3ac82ce3` FOREIGN KEY (`color_id`) REFERENCES `color` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100679 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.product: ~678 rows (approximately)
/*!40000 ALTER TABLE `product` DISABLE KEYS */;
INSERT INTO `product` (`id`, `code`, `product_type`, `name`, `category_id`, `unit_of_measurement_id`, `color_id`, `hpp`, `material_price`, `sales_price`, `comission`, `brand_id`, `status`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(100001, 'PW21A-AC100001BL', 'product_sales', 'PHILLIP LOGO ENAMEL', 3, 1, 2, 0, 0, 89000, 0, 2, 1, '2021-04-15 11:52:51.000000', '2021-04-15 11:52:51.000000', NULL),
	(100002, 'PW21A-AC100002YW ', 'product_sales', 'PHILLIP PLATE ENAMEL', 3, 1, 3, 0, 0, 89000, 0, 2, 1, '2021-04-15 11:52:51.000001', '2021-04-15 11:52:51.000001', NULL),
	(100003, 'PW21A-AC100003BL', 'product_sales', 'PHILLIP PATCH ENAMEL', 3, 1, 2, 0, 0, 89000, 0, 2, 1, '2021-04-15 11:52:51.000002', '2021-04-15 11:52:51.000002', NULL),
	(100004, 'PW21A-AC100004BL', 'product_sales', 'PHILLIP UMBRELLA', 3, 1, 2, 0, 0, 199000, 0, 2, 1, '2021-04-15 11:52:51.000003', '2021-04-15 11:52:51.000003', NULL),
	(100005, 'PW21A-AC100005BL', 'product_sales', 'PHILLIP ASHTRAY', 3, 1, 2, 0, 0, 65000, 0, 2, 1, '2021-04-15 11:52:51.000004', '2021-04-15 11:52:51.000004', NULL),
	(100006, 'PW21A-AC100006BL', 'product_sales', 'PHILLIP BOTTLE SPORT', 3, 1, 2, 0, 0, 135000, 0, 2, 1, '2021-04-15 11:52:51.000005', '2021-04-15 11:52:51.000005', NULL),
	(100007, 'PW21A-AC100007BL', 'product_sales', 'PHILLIP BOTTLE SPORT 2.0', 3, 1, 2, 0, 0, 135000, 0, 2, 1, '2021-04-15 11:52:51.000006', '2021-04-15 11:52:51.000006', NULL),
	(100008, 'PW21A-AC100008BL', 'product_sales', 'PHILLIP KEYCHAIN BLACK', 3, 1, 2, 0, 0, 99000, 0, 2, 1, '2021-04-15 11:52:51.000007', '2021-04-15 11:52:51.000007', NULL),
	(100009, 'PW21A-AC100009BW', 'product_sales', 'PHILLIP KEYCHAIN BROWN', 3, 1, 8, 0, 0, 99000, 0, 2, 1, '2021-04-15 11:52:51.000008', '2021-04-15 11:52:51.000008', NULL),
	(100010, 'PW21A-AC100010MC', 'product_sales', 'PHILLIP KEYCHAIN MOCCA', 3, 1, 9, 0, 0, 99000, 0, 2, 1, '2021-04-15 11:52:51.000009', '2021-04-15 11:52:51.000009', NULL),
	(100011, 'PW21A-AC100011OG', 'product_sales', 'PHILLIP KEYCHAIN ORANGE', 3, 1, 10, 0, 0, 99000, 0, 2, 1, '2021-04-15 11:52:51.000010', '2021-04-15 11:52:51.000010', NULL),
	(100012, 'PW21A-AC100012BL', 'product_sales', 'PW MOTO KEYCHAIN BLACK', 3, 1, 2, 0, 0, 99000, 0, 2, 1, '2021-04-15 11:52:51.000011', '2021-04-15 11:52:51.000011', NULL),
	(100013, 'PW21A-AC100013OG', 'product_sales', 'PW MOTO KEYCHAIN ORANGE', 3, 1, 10, 0, 0, 99000, 0, 2, 1, '2021-04-15 11:52:51.000012', '2021-04-15 11:52:51.000012', NULL),
	(100014, 'PW21A-AC100014OL', 'product_sales', 'PW MOTO KEYCHAIN OLIVE', 3, 1, 11, 0, 0, 99000, 0, 2, 1, '2021-04-15 11:52:51.000013', '2021-04-15 11:52:51.000013', NULL),
	(100015, 'PW21A-AC100015MR', 'product_sales', 'PW MOTO KEYCHAIN MAROON', 3, 1, 13, 0, 0, 99000, 0, 2, 1, '2021-04-15 11:52:51.000014', '2021-04-15 11:52:51.000014', NULL),
	(100016, 'PW21A-AC100016BL', 'product_sales', 'PHILLIP COIN CASE', 3, 1, 2, 0, 0, 99000, 0, 2, 1, '2021-04-15 11:52:51.000015', '2021-04-15 11:52:51.000015', NULL),
	(100017, 'PW21A-AC100017BL', 'product_sales', 'DEMAND FREEDOM COIN CASE', 3, 1, 2, 0, 0, 99000, 0, 2, 1, '2021-04-15 11:52:51.000016', '2021-04-15 11:52:51.000016', NULL),
	(100018, 'PW21A-BG100018WT', 'product_sales', 'SPENCER WAISTBAG', 4, 1, 4, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000017', '2021-04-15 11:52:51.000017', NULL),
	(100019, 'PW21A-BG100019BL', 'product_sales', 'OLIVER WAISTBAG', 4, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000018', '2021-04-15 11:52:51.000018', NULL),
	(100020, 'PW21A-BG100020BL', 'product_sales', 'JOHNSON WAISTBAG', 4, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000019', '2021-04-15 11:52:51.000019', NULL),
	(100021, 'PW21A-BG100021BL', 'product_sales', 'URBAN BACKPACK', 4, 1, 2, 0, 0, 425000, 0, 2, 1, '2021-04-15 11:52:51.000020', '2021-04-15 11:52:51.000020', NULL),
	(100022, 'PW21A-BG100022BL', 'product_sales', 'XJ-030 WAISTBAG', 4, 1, 2, 0, 0, 299000, 0, 2, 1, '2021-04-15 11:52:51.000021', '2021-04-15 11:52:51.000021', NULL),
	(100023, 'PW21A-BG100023BL', 'product_sales', 'XJ-077 SLINGBAG', 4, 1, 2, 0, 0, 249000, 0, 2, 1, '2021-04-15 11:52:51.000022', '2021-04-15 11:52:51.000022', NULL),
	(100024, 'PW21A-BG100024BL', 'product_sales', 'XJ-012 HOLSTER', 4, 1, 2, 0, 0, 369000, 0, 2, 1, '2021-04-15 11:52:51.000023', '2021-04-15 11:52:51.000023', NULL),
	(100025, 'PW21A-BG100025BL', 'product_sales', 'XJ-069 MESSENGER', 4, 1, 2, 0, 0, 439000, 0, 2, 1, '2021-04-15 11:52:51.000024', '2021-04-15 11:52:51.000024', NULL),
	(100026, 'PW21A-BG100026CM', 'product_sales', 'XJ-012 HOLSTER GREY', 4, 1, 14, 0, 0, 369000, 0, 2, 1, '2021-04-15 11:52:51.000025', '2021-04-15 11:52:51.000025', NULL),
	(100027, 'PW21A-BG100027CM', 'product_sales', 'XJ-012 HOLSTER ARMY', 4, 1, 14, 0, 0, 369000, 0, 2, 1, '2021-04-15 11:52:51.000026', '2021-04-15 11:52:51.000026', NULL),
	(100028, 'PW21A-BG100028CM', 'product_sales', '2 IN 1 BACKPACK GREY', 4, 1, 14, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000027', '2021-04-15 11:52:51.000027', NULL),
	(100029, 'PW21A-BG100029CM', 'product_sales', '2 IN 1 BACKPACK GREEN', 4, 1, 14, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000028', '2021-04-15 11:52:51.000028', NULL),
	(100030, 'PW21A-BG100030BL', 'product_sales', 'XJ-099 3 LAYER SLINGBAG', 4, 1, 2, 0, 0, 249000, 0, 2, 1, '2021-04-15 11:52:51.000029', '2021-04-15 11:52:51.000029', NULL),
	(100031, 'PW21A-BG100031BL', 'product_sales', 'URBAN TRAVEL BAG', 4, 1, 2, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000030', '2021-04-15 11:52:51.000030', NULL),
	(100032, 'PW21A-BG100032BL', 'product_sales', 'LOGO TOTE BAG YELLOW', 4, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000031', '2021-04-15 11:52:51.000031', NULL),
	(100033, 'PW21A-BG100033BL', 'product_sales', 'LOGO TOTE BAG WHITE', 4, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000032', '2021-04-15 11:52:51.000032', NULL),
	(100034, 'PW21A-BG100034BL', 'product_sales', 'CLASSIC LOGO TOTE BAG', 4, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000033', '2021-04-15 11:52:51.000033', NULL),
	(100035, 'PW21A-BG100035BL', 'product_sales', 'RIVERA BACKPACK', 4, 1, 2, 0, 0, 499000, 0, 2, 1, '2021-04-15 11:52:51.000034', '2021-04-15 11:52:51.000034', NULL),
	(100036, 'PW21A-BG100036BL', 'product_sales', 'PATHFINDER BACKPACK', 4, 1, 2, 0, 0, 469000, 0, 2, 1, '2021-04-15 11:52:51.000035', '2021-04-15 11:52:51.000035', NULL),
	(100037, 'PW21A-BG100037OG', 'product_sales', 'STING RAY', 4, 1, 10, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000036', '2021-04-15 11:52:51.000036', NULL),
	(100038, 'PW21A-BG100038BL', 'product_sales', 'SHELBY', 4, 1, 2, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000037', '2021-04-15 11:52:51.000037', NULL),
	(100039, 'PW21A-BG100039GN', 'product_sales', 'CABRIO', 4, 1, 12, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000038', '2021-04-15 11:52:51.000038', NULL),
	(100040, 'PW21A-BG100040WT', 'product_sales', 'ELEANOR', 4, 1, 4, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000039', '2021-04-15 11:52:51.000039', NULL),
	(100041, 'PW21A-BG100041BL', 'product_sales', 'BIKE POUCH', 4, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000040', '2021-04-15 11:52:51.000040', NULL),
	(100042, 'PW21A-BG100042BL', 'product_sales', 'MARINO BAG', 4, 1, 2, 0, 0, 159000, 0, 2, 1, '2021-04-15 11:52:51.000041', '2021-04-15 11:52:51.000041', NULL),
	(100043, 'PW21A-BG100043BL', 'product_sales', 'FLOYD WAISTBAG', 4, 1, 2, 0, 0, 299000, 0, 2, 1, '2021-04-15 11:52:51.000042', '2021-04-15 11:52:51.000042', NULL),
	(100044, 'PW21A-BG100044BL', 'product_sales', 'HAMILTON POUCH', 4, 1, 2, 0, 0, 139000, 0, 2, 1, '2021-04-15 11:52:51.000043', '2021-04-15 11:52:51.000043', NULL),
	(100045, 'PW21A-BG100045BL', 'product_sales', 'JAVAS SLINGBAG', 4, 1, 2, 0, 0, 349000, 0, 2, 1, '2021-04-15 11:52:51.000044', '2021-04-15 11:52:51.000044', NULL),
	(100046, 'PW21A-BG100046BL', 'product_sales', 'SPECTER TOTEBAG', 4, 1, 2, 0, 0, 459000, 0, 2, 1, '2021-04-15 11:52:51.000045', '2021-04-15 11:52:51.000045', NULL),
	(100047, 'PW21A-BG100047BL', 'product_sales', 'STRATO BACKPACK', 4, 1, 2, 0, 0, 259000, 0, 2, 1, '2021-04-15 11:52:51.000046', '2021-04-15 11:52:51.000046', NULL),
	(100048, 'PW21A-BG100048BL', 'product_sales', 'JAMES SLINGBAG', 4, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000047', '2021-04-15 11:52:51.000047', NULL),
	(100049, 'PW21A-BG100049BL', 'product_sales', 'SMALL LAPTOP CASE', 4, 1, 2, 0, 0, 229000, 0, 2, 1, '2021-04-15 11:52:51.000048', '2021-04-15 11:52:51.000048', NULL),
	(100050, 'PW21A-BG100050BL', 'product_sales', 'LARGE LAPTOP CASE', 4, 1, 2, 0, 0, 249000, 0, 2, 1, '2021-04-15 11:52:51.000049', '2021-04-15 11:52:51.000049', NULL),
	(100051, 'PW21A-BG100051BL', 'product_sales', 'SMITH', 4, 1, 2, 0, 0, 199000, 0, 2, 1, '2021-04-15 11:52:51.000050', '2021-04-15 11:52:51.000050', NULL),
	(100052, 'PW21A-BG100052BL', 'product_sales', 'HYBRID WP', 4, 1, 2, 0, 0, 319000, 0, 2, 1, '2021-04-15 11:52:51.000051', '2021-04-15 11:52:51.000051', NULL),
	(100053, 'PW21A-BG100053BL', 'product_sales', 'RUNNING PACK', 4, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000052', '2021-04-15 11:52:51.000052', NULL),
	(100054, 'PW21A-BG100054BL', 'product_sales', 'PATHFINDER BACKPACK 2.0', 4, 1, 2, 0, 0, 469000, 0, 2, 1, '2021-04-15 11:52:51.000053', '2021-04-15 11:52:51.000053', NULL),
	(100055, 'PW21A-GL100055YW ', 'product_sales', 'YELLOW BANDIT', 5, 1, 3, 0, 0, 489000, 0, 2, 1, '2021-04-15 11:52:51.000054', '2021-04-15 11:52:51.000054', NULL),
	(100056, 'PW21A-GL100056BW', 'product_sales', 'ROAD RUNNER', 5, 1, 8, 0, 0, 399000, 0, 2, 1, '2021-04-15 11:52:51.000055', '2021-04-15 11:52:51.000055', NULL),
	(100057, 'PW21A-GL100057CM', 'product_sales', 'BOLD HUNTER', 5, 1, 14, 0, 0, 499000, 0, 2, 1, '2021-04-15 11:52:51.000056', '2021-04-15 11:52:51.000056', NULL),
	(100058, 'PW21A-GL100058BW', 'product_sales', 'MAD GREASER', 5, 1, 8, 0, 0, 499000, 0, 2, 1, '2021-04-15 11:52:51.000057', '2021-04-15 11:52:51.000057', NULL),
	(100059, 'PW21A-GL100059BL', 'product_sales', 'HITMAN', 5, 1, 2, 0, 0, 499000, 0, 2, 1, '2021-04-15 11:52:51.000058', '2021-04-15 11:52:51.000058', NULL),
	(100060, 'PW21A-GL100060BL', 'product_sales', 'DARE DEVIL', 5, 1, 2, 0, 0, 399000, 0, 2, 1, '2021-04-15 11:52:51.000059', '2021-04-15 11:52:51.000059', NULL),
	(100061, 'PW21A-GL100061RD', 'product_sales', 'DARK INFERNO', 5, 1, 7, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000060', '2021-04-15 11:52:51.000060', NULL),
	(100062, 'PW21A-GL100062WT', 'product_sales', 'HURRICANE', 5, 1, 4, 0, 0, 575000, 0, 2, 1, '2021-04-15 11:52:51.000061', '2021-04-15 11:52:51.000061', NULL),
	(100063, 'PW21A-GL100063BW', 'product_sales', 'CRUSADER', 5, 1, 8, 0, 0, 499000, 0, 2, 1, '2021-04-15 11:52:51.000062', '2021-04-15 11:52:51.000062', NULL),
	(100064, 'PW21A-GL100064WT', 'product_sales', 'MARK I', 5, 1, 4, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000063', '2021-04-15 11:52:51.000063', NULL),
	(100065, 'PW21A-GL100065BL', 'product_sales', 'MARK II', 5, 1, 2, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000064', '2021-04-15 11:52:51.000064', NULL),
	(100066, 'PW21A-GL100066YW ', 'product_sales', 'DAYTONA', 5, 1, 3, 0, 0, 499000, 0, 2, 1, '2021-04-15 11:52:51.000065', '2021-04-15 11:52:51.000065', NULL),
	(100067, 'PW21A-GL100067BW', 'product_sales', 'DOMINATOR', 5, 1, 8, 0, 0, 499000, 0, 2, 1, '2021-04-15 11:52:51.000066', '2021-04-15 11:52:51.000066', NULL),
	(100068, 'PW21A-HT100068BL', 'product_sales', 'BLACK COBRA TRUCKER', 6, 1, 2, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000067', '2021-04-15 11:52:51.000067', NULL),
	(100069, 'PW21A-HT100069BL', 'product_sales', 'SIGNATURE TRUCKER', 6, 1, 2, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000068', '2021-04-15 11:52:51.000068', NULL),
	(100070, 'PW21A-HT100070BL', 'product_sales', 'EAGLE SNAKE TRUCKER', 6, 1, 2, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000069', '2021-04-15 11:52:51.000069', NULL),
	(100071, 'PW21A-HT100071BL', 'product_sales', 'IRON BEAST', 6, 1, 2, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000070', '2021-04-15 11:52:51.000070', NULL),
	(100072, 'PW21A-HT100072BL', 'product_sales', 'PARTS AND BUILD 2.0', 6, 1, 2, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000071', '2021-04-15 11:52:51.000071', NULL),
	(100073, 'PW21A-HT100073BL', 'product_sales', 'GARAGE TRUCKER', 6, 1, 5, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000072', '2021-04-15 11:52:51.000072', NULL),
	(100074, 'PW21A-HT100074BL', 'product_sales', 'PIRATE TRUCKER', 6, 1, 2, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000073', '2021-04-15 11:52:51.000073', NULL),
	(100075, 'PW21A-HT100075BL', 'product_sales', 'TROOPER TRUCKER', 6, 1, 2, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000074', '2021-04-15 11:52:51.000074', NULL),
	(100076, 'PW21A-HT100076BL', 'product_sales', 'WING TRUCKER 2.0', 6, 1, 2, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000075', '2021-04-15 11:52:51.000075', NULL),
	(100077, 'PW21A-HT100077BL', 'product_sales', 'EQUADOR', 6, 1, 2, 0, 0, 199000, 0, 2, 1, '2021-04-15 11:52:51.000076', '2021-04-15 11:52:51.000076', NULL),
	(100078, 'PW21A-HT100078BL', 'product_sales', 'SHALLOW CAP', 6, 1, 2, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000077', '2021-04-15 11:52:51.000077', NULL),
	(100079, 'PW21A-HT100079AR', 'product_sales', 'DELTA CAP ARMY', 6, 1, 15, 0, 0, 199000, 0, 2, 1, '2021-04-15 11:52:51.000078', '2021-04-15 11:52:51.000078', NULL),
	(100080, 'PW21A-HT100080BL', 'product_sales', 'DELTA CAP BLACK', 6, 1, 2, 0, 0, 199000, 0, 2, 1, '2021-04-15 11:52:51.000079', '2021-04-15 11:52:51.000079', NULL),
	(100081, 'PW21A-HT100081CM', 'product_sales', 'DELTA CAP ARMY CAMO', 6, 1, 14, 0, 0, 199000, 0, 2, 1, '2021-04-15 11:52:51.000080', '2021-04-15 11:52:51.000080', NULL),
	(100082, 'PW21A-HT100082DS', 'product_sales', 'DELTA CAP ARMY DESERT', 6, 1, 16, 0, 0, 199000, 0, 2, 1, '2021-04-15 11:52:51.000081', '2021-04-15 11:52:51.000081', NULL),
	(100083, 'PW21A-HT100083CM', 'product_sales', 'EQUADOR CAMO', 6, 1, 14, 0, 0, 199000, 0, 2, 1, '2021-04-15 11:52:51.000082', '2021-04-15 11:52:51.000082', NULL),
	(100084, 'PW21A-HT100084DS', 'product_sales', 'EQUADOR DESERT', 6, 1, 16, 0, 0, 199000, 0, 2, 1, '2021-04-15 11:52:51.000083', '2021-04-15 11:52:51.000083', NULL),
	(100085, 'PW21A-HT100085MR', 'product_sales', 'SHALLOW MAROON', 6, 1, 13, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000084', '2021-04-15 11:52:51.000084', NULL),
	(100086, 'PW21A-HT100086NV', 'product_sales', 'SHALLOW NAVY', 6, 1, 17, 0, 0, 149000, 0, 2, 1, '2021-04-15 11:52:51.000085', '2021-04-15 11:52:51.000085', NULL),
	(100087, 'PW21A-HT100087BL', 'product_sales', 'SIGNATURE TRUCKER 2.0', 6, 1, 2, 0, 0, 159000, 0, 2, 1, '2021-04-15 11:52:51.000086', '2021-04-15 11:52:51.000086', NULL),
	(100088, 'PW21A-HT100088NV', 'product_sales', 'HIGHWAY CAP NAVY', 6, 1, 17, 0, 0, 189000, 0, 2, 1, '2021-04-15 11:52:51.000087', '2021-04-15 11:52:51.000087', NULL),
	(100089, 'PW21A-HT100089RD', 'product_sales', 'HIGHWAY CAP RED', 6, 1, 7, 0, 0, 189000, 0, 2, 1, '2021-04-15 11:52:51.000088', '2021-04-15 11:52:51.000088', NULL),
	(100090, 'PW21A-HT100090BL', 'product_sales', 'PETROL TRUCKER BLACK', 6, 1, 2, 0, 0, 159000, 0, 2, 1, '2021-04-15 11:52:51.000089', '2021-04-15 11:52:51.000089', NULL),
	(100091, 'PW21A-HT100091RD', 'product_sales', 'PETROL TRUCKER RED', 6, 1, 7, 0, 0, 159000, 0, 2, 1, '2021-04-15 11:52:51.000090', '2021-04-15 11:52:51.000090', NULL),
	(100092, 'PW21A-JK100092BL', 'product_sales', 'BLACK VIPER', 7, 1, 2, 0, 0, 519000, 0, 2, 1, '2021-04-15 11:52:51.000091', '2021-04-15 11:52:51.000091', NULL),
	(100093, 'PW21A-JK100093BL', 'product_sales', 'BLACK FALCON', 7, 1, 2, 0, 0, 499000, 0, 2, 1, '2021-04-15 11:52:51.000092', '2021-04-15 11:52:51.000092', NULL),
	(100094, 'PW21A-JK100094GY', 'product_sales', 'THE BRAVE', 7, 1, 6, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000093', '2021-04-15 11:52:51.000093', NULL),
	(100095, 'PW21A-JK100095AR', 'product_sales', 'NEVER LOST', 7, 1, 15, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000094', '2021-04-15 11:52:51.000094', NULL),
	(100096, 'PW21A-JK100096BL', 'product_sales', 'UNRIVALED', 7, 1, 2, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000095', '2021-04-15 11:52:51.000095', NULL),
	(100097, 'PW21A-JK100097WT', 'product_sales', 'PRIDE OF INDONESIA', 7, 1, 4, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000096', '2021-04-15 11:52:51.000096', NULL),
	(100098, 'PW21A-JK100098BL', 'product_sales', 'CHRYSANT DEMON WINDBREAKER', 7, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000097', '2021-04-15 11:52:51.000097', NULL),
	(100099, 'PW21A-JK100099BL', 'product_sales', 'BLACK EAGLE 2.0', 7, 1, 2, 0, 0, 359000, 0, 2, 1, '2021-04-15 11:52:51.000098', '2021-04-15 11:52:51.000098', NULL),
	(100100, 'PW21A-JK100100DM', 'product_sales', 'LIBERATOR DENIM', 7, 1, 19, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000099', '2021-04-15 11:52:51.000099', NULL),
	(100101, 'PW21A-JK100101NV', 'product_sales', 'INTERCEPTOR RIDER', 7, 1, 17, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000100', '2021-04-15 11:52:51.000100', NULL),
	(100102, 'PW21A-JK100102BW', 'product_sales', 'BRADFORD JACKET', 7, 1, 8, 0, 0, 459000, 0, 2, 1, '2021-04-15 11:52:51.000101', '2021-04-15 11:52:51.000101', NULL),
	(100103, 'PW21A-JK100103BL', 'product_sales', 'RIDE OR DIE 2.0', 7, 1, 2, 0, 0, 545000, 0, 2, 1, '2021-04-15 11:52:51.000102', '2021-04-15 11:52:51.000102', NULL),
	(100104, 'PW21A-JK100104BL', 'product_sales', 'MC CARTHY PARKA 2.0', 7, 1, 2, 0, 0, 469000, 0, 2, 1, '2021-04-15 11:52:51.000103', '2021-04-15 11:52:51.000103', NULL),
	(100105, 'PW21A-JK100105TC', 'product_sales', 'NIPPON 3.0', 7, 1, 18, 0, 0, 479000, 0, 2, 1, '2021-04-15 11:52:51.000104', '2021-04-15 11:52:51.000104', NULL),
	(100106, 'PW21A-JK100106BL', 'product_sales', 'ROAD HUNTER WINDBREAKER 3.0', 7, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000105', '2021-04-15 11:52:51.000105', NULL),
	(100107, 'PW21A-JK100107BL', 'product_sales', 'PW MC WINDBEAKER', 7, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000106', '2021-04-15 11:52:51.000106', NULL),
	(100108, 'PW21A-JK100108BL', 'product_sales', 'BORN TO RIDE 3.0', 7, 1, 2, 0, 0, 479000, 0, 2, 1, '2021-04-15 11:52:51.000107', '2021-04-15 11:52:51.000107', NULL),
	(100109, 'PW21A-JK100109BL', 'product_sales', 'HERITAGE WINDBREAKER 3.0', 7, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000108', '2021-04-15 11:52:51.000108', NULL),
	(100110, 'PW21A-JK100110BL', 'product_sales', 'VARSITY HIGH SCHOOL', 7, 1, 2, 0, 0, 545000, 0, 2, 1, '2021-04-15 11:52:51.000109', '2021-04-15 11:52:51.000109', NULL),
	(100111, 'PW21A-JK100111BL', 'product_sales', 'VARSITY COLLEGE', 7, 1, 2, 0, 0, 545000, 0, 2, 1, '2021-04-15 11:52:51.000110', '2021-04-15 11:52:51.000110', NULL),
	(100112, 'PW21A-JK100112CM', 'product_sales', 'JUNGLE AERO', 7, 1, 14, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000111', '2021-04-15 11:52:51.000111', NULL),
	(100113, 'PW21A-JK100113CM', 'product_sales', 'JUNGLE SPEED', 7, 1, 14, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000112', '2021-04-15 11:52:51.000112', NULL),
	(100114, 'PW21A-JK100114CM', 'product_sales', 'BLACK FALCON 2.0', 7, 1, 14, 0, 0, 519000, 0, 2, 1, '2021-04-15 11:52:51.000113', '2021-04-15 11:52:51.000113', NULL),
	(100115, 'PW21A-JK100115DM', 'product_sales', 'BELFAST 2.0', 7, 1, 19, 0, 0, 489000, 0, 2, 1, '2021-04-15 11:52:51.000114', '2021-04-15 11:52:51.000114', NULL),
	(100116, 'PW21A-JK100116RD', 'product_sales', 'MOTEGI', 7, 1, 7, 0, 0, 489000, 0, 2, 1, '2021-04-15 11:52:51.000115', '2021-04-15 11:52:51.000115', NULL),
	(100117, 'PW21A-JK100117BL', 'product_sales', 'MAVERICK BOMBER', 7, 1, 2, 0, 0, 499000, 0, 2, 1, '2021-04-15 11:52:51.000116', '2021-04-15 11:52:51.000116', NULL),
	(100118, 'PW21A-JK100118AR', 'product_sales', 'SHERMAN BOMBER', 7, 1, 15, 0, 0, 585000, 0, 2, 1, '2021-04-15 11:52:51.000117', '2021-04-15 11:52:51.000117', NULL),
	(100119, 'PW21A-JK100119BL', 'product_sales', 'CONTINENTAL WINDBREAKER', 7, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000118', '2021-04-15 11:52:51.000118', NULL),
	(100120, 'PW21A-JK100120BL', 'product_sales', 'VELOCITY', 7, 1, 2, 0, 0, 545000, 0, 2, 1, '2021-04-15 11:52:51.000119', '2021-04-15 11:52:51.000119', NULL),
	(100121, 'PW21A-JK100121MR', 'product_sales', 'GO RIDE WINDBREAKER', 7, 1, 13, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000120', '2021-04-15 11:52:51.000120', NULL),
	(100122, 'PW21A-JK100122RD', 'product_sales', 'CONCORDE RIDER', 7, 1, 7, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000121', '2021-04-15 11:52:51.000121', NULL),
	(100123, 'PW21A-JK100123BL', 'product_sales', 'PHILLIP SPORTY JACKET', 7, 1, 2, 0, 0, 439000, 0, 2, 1, '2021-04-15 11:52:51.000122', '2021-04-15 11:52:51.000122', NULL),
	(100124, 'PW21A-JK100124BL', 'product_sales', 'WARRIOR PARKA', 7, 1, 2, 0, 0, 789000, 0, 2, 1, '2021-04-15 11:52:51.000123', '2021-04-15 11:52:51.000123', NULL),
	(100125, 'PW21A-JK100125AR', 'product_sales', 'WILD AND FREE PARKA', 7, 1, 15, 0, 0, 789000, 0, 2, 1, '2021-04-15 11:52:51.000124', '2021-04-15 11:52:51.000124', NULL),
	(100126, 'PW21A-JK100126BL', 'product_sales', 'RAVEN', 7, 1, 2, 0, 0, 3550000, 0, 2, 1, '2021-04-15 11:52:51.000125', '2021-04-15 11:52:51.000125', NULL),
	(100127, 'PW21A-JK100127BL', 'product_sales', 'YEAGER', 7, 1, 2, 0, 0, 3850000, 0, 2, 1, '2021-04-15 11:52:51.000126', '2021-04-15 11:52:51.000126', NULL),
	(100128, 'PW21A-JK100128BL', 'product_sales', 'MAGNUS', 7, 1, 2, 0, 0, 3850000, 0, 2, 1, '2021-04-15 11:52:51.000127', '2021-04-15 11:52:51.000127', NULL),
	(100129, 'PW21A-JK100129YW ', 'product_sales', 'FORTIUS WINDBREAKER', 7, 1, 3, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000128', '2021-04-15 11:52:51.000128', NULL),
	(100130, 'PW21A-JK100130YW ', 'product_sales', 'SHIBUYA JACKET', 7, 1, 3, 0, 0, 479000, 0, 2, 1, '2021-04-15 11:52:51.000129', '2021-04-15 11:52:51.000129', NULL),
	(100131, 'PW21A-JK100131YW ', 'product_sales', 'SPEEDSTER RIDER', 7, 1, 3, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000130', '2021-04-15 11:52:51.000130', NULL),
	(100132, 'PW21A-JK100132BL', 'product_sales', 'BARETTA VEST BLACK', 7, 1, 2, 0, 0, 489000, 0, 2, 1, '2021-04-15 11:52:51.000131', '2021-04-15 11:52:51.000131', NULL),
	(100133, 'PW21A-JK100133BL', 'product_sales', 'MISANO RIDER', 7, 1, 5, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000132', '2021-04-15 11:52:51.000132', NULL),
	(100134, 'PW21A-JK100134OL', 'product_sales', 'BARETTA VEST OLIVE', 7, 1, 11, 0, 0, 489000, 0, 2, 1, '2021-04-15 11:52:51.000133', '2021-04-15 11:52:51.000133', NULL),
	(100135, 'PW21A-JK100135BL', 'product_sales', 'KAMIKAZE RIDER', 7, 1, 2, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000134', '2021-04-15 11:52:51.000134', NULL),
	(100136, 'PW21A-JK100136OL', 'product_sales', 'JUNGLE SNAKE', 7, 1, 11, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000135', '2021-04-15 11:52:51.000135', NULL),
	(100137, 'PW21A-JK100137BL', 'product_sales', 'PRIDE OF INDONESIA BLACK', 7, 1, 2, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000136', '2021-04-15 11:52:51.000136', NULL),
	(100138, 'PW21A-JK100138OL', 'product_sales', 'JUNGLE PANTHER', 7, 1, 11, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000137', '2021-04-15 11:52:51.000137', NULL),
	(100139, 'PW21A-JK100139BL', 'product_sales', 'VENOM WINDBREAKER', 7, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000138', '2021-04-15 11:52:51.000138', NULL),
	(100140, 'PW21A-JK100140OL', 'product_sales', 'SPEED BOMBER', 7, 1, 11, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000139', '2021-04-15 11:52:51.000139', NULL),
	(100141, 'PW21A-JK100141BL', 'product_sales', 'DOMINATION SUKAJAN', 7, 1, 2, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000140', '2021-04-15 11:52:51.000140', NULL),
	(100142, 'PW21A-JK100142OL', 'product_sales', 'AERO BOMBER', 7, 1, 11, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000141', '2021-04-15 11:52:51.000141', NULL),
	(100143, 'PW21A-JK100143BL', 'product_sales', 'BLACK SQUADRON', 7, 1, 2, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000142', '2021-04-15 11:52:51.000142', NULL),
	(100144, 'PW21A-JK100144AR', 'product_sales', 'SKULL BARR', 7, 1, 15, 0, 0, 469000, 0, 2, 1, '2021-04-15 11:52:51.000143', '2021-04-15 11:52:51.000143', NULL),
	(100145, 'PW21A-JK100145RD', 'product_sales', 'KONOTORI SUKAJAN', 7, 1, 7, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000144', '2021-04-15 11:52:51.000144', NULL),
	(100146, 'PW21A-JK100146BL', 'product_sales', 'FREEDOM FIGHTER SUKAJAN', 7, 1, 2, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000145', '2021-04-15 11:52:51.000145', NULL),
	(100147, 'PW21A-JK100147BL', 'product_sales', 'SUPERIOR WINDBREAKER', 7, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000146', '2021-04-15 11:52:51.000146', NULL),
	(100148, 'PW21A-JK100148BL', 'product_sales', 'UNFORGIVEN WINDBREAKER', 7, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000147', '2021-04-15 11:52:51.000147', NULL),
	(100149, 'PW21A-JK100149BL', 'product_sales', 'FREAKLESS WINDBREAKER', 7, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000148', '2021-04-15 11:52:51.000148', NULL),
	(100150, 'PW21A-JK100150BL', 'product_sales', 'BURNING SKULL WINDBREAKER', 7, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000149', '2021-04-15 11:52:51.000149', NULL),
	(100151, 'PW21A-JK100151BL', 'product_sales', 'PISTON HEAD WINDBREAKER', 7, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000150', '2021-04-15 11:52:51.000150', NULL),
	(100152, 'PW21A-JK100152BL', 'product_sales', 'JAPAN KOI SUKAJAN', 7, 1, 5, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000151', '2021-04-15 11:52:51.000151', NULL),
	(100153, 'PW21A-JK100153GN', 'product_sales', 'TENGUHEBI SUKAJAN', 7, 1, 12, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000152', '2021-04-15 11:52:51.000152', NULL),
	(100154, 'PW21A-JD100154BL', 'product_sales', 'HERITAGE WB KIDS', 8, 1, 2, 0, 0, 259000, 0, 2, 1, '2021-04-15 11:52:51.000153', '2021-04-15 11:52:51.000153', NULL),
	(100155, 'PW21A-JK100155OL', 'product_sales', 'IGNORANT JUNGLE', 7, 1, 11, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000154', '2021-04-15 11:52:51.000154', NULL),
	(100156, 'PW21A-JK100156YW ', 'product_sales', 'ROAD KILLER WINDBREAKER', 7, 1, 3, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000155', '2021-04-15 11:52:51.000155', NULL),
	(100157, 'PW21A-JK100157BL', 'product_sales', 'ONIMUSHA SUKAJAN', 7, 1, 2, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000156', '2021-04-15 11:52:51.000156', NULL),
	(100158, 'PW21A-JK100158AR', 'product_sales', 'KNOCK OUT PARKA', 7, 1, 15, 0, 0, 525000, 0, 2, 1, '2021-04-15 11:52:51.000157', '2021-04-15 11:52:51.000157', NULL),
	(100159, 'PW21A-JD100159MR', 'product_sales', 'GO RIDE WB KIDS', 8, 1, 13, 0, 0, 259000, 0, 2, 1, '2021-04-15 11:52:51.000158', '2021-04-15 11:52:51.000158', NULL),
	(100160, 'PW21A-JK100160TC', 'product_sales', 'NIPPON 4.0', 7, 1, 18, 0, 0, 499000, 0, 2, 1, '2021-04-15 11:52:51.000159', '2021-04-15 11:52:51.000159', NULL),
	(100161, 'PW21A-JK100161BL', 'product_sales', 'DIRTY DEES WINDBREAKER', 7, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000160', '2021-04-15 11:52:51.000160', NULL),
	(100162, 'PW21A-JD100162BL', 'product_sales', 'PW MC WB KIDS', 8, 1, 2, 0, 0, 259000, 0, 2, 1, '2021-04-15 11:52:51.000161', '2021-04-15 11:52:51.000161', NULL),
	(100163, 'PW21A-JK100163RD', 'product_sales', 'MOTEGI 2.0', 7, 1, 7, 0, 0, 499000, 0, 2, 1, '2021-04-15 11:52:51.000162', '2021-04-15 11:52:51.000162', NULL),
	(100164, 'PW21A-JD100164BL', 'product_sales', 'BLACK EAGLE WB KIDS', 8, 1, 2, 0, 0, 259000, 0, 2, 1, '2021-04-15 11:52:51.000163', '2021-04-15 11:52:51.000163', NULL),
	(100165, 'PW21A-JK100165NV', 'product_sales', 'UNIT ZERO BOMBER', 7, 1, 17, 0, 0, 549000, 0, 2, 1, '2021-04-15 11:52:51.000164', '2021-04-15 11:52:51.000164', NULL),
	(100166, 'PW21A-JK100166MR', 'product_sales', 'BIRD BOMBER', 7, 1, 13, 0, 0, 549000, 0, 2, 1, '2021-04-15 11:52:51.000165', '2021-04-15 11:52:51.000165', NULL),
	(100167, 'PW21A-JK100167WT', 'product_sales', 'OKAMI WINDBREAKER', 7, 1, 4, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000166', '2021-04-15 11:52:51.000166', NULL),
	(100168, 'PW21A-JK100168BL', 'product_sales', 'JAVA ANORAK JACKET', 7, 1, 2, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000167', '2021-04-15 11:52:51.000167', NULL),
	(100169, 'PW21A-JK100169BL', 'product_sales', 'RACING DIVISION BLACK', 7, 1, 2, 0, 0, 549000, 0, 2, 1, '2021-04-15 11:52:51.000168', '2021-04-15 11:52:51.000168', NULL),
	(100170, 'PW21A-JK100170RD', 'product_sales', 'RACING DIVISION RED', 7, 1, 7, 0, 0, 549000, 0, 2, 1, '2021-04-15 11:52:51.000169', '2021-04-15 11:52:51.000169', NULL),
	(100171, 'PW21A-JK100171WT', 'product_sales', 'RACING DIVISION WHITE', 7, 1, 4, 0, 0, 549000, 0, 2, 1, '2021-04-15 11:52:51.000170', '2021-04-15 11:52:51.000170', NULL),
	(100172, 'PW21A-JK100172BL', 'product_sales', 'ECHOPLEX WINDBREAKER', 7, 1, 2, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000171', '2021-04-15 11:52:51.000171', NULL),
	(100173, 'PW21A-TS100173BL', 'product_sales', 'CB 1972', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000172', '2021-04-15 11:52:51.000172', NULL),
	(100174, 'PW21A-TS100174NV', 'product_sales', 'DUST AND WHEELS', 2, 1, 17, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000173', '2021-04-15 11:52:51.000173', NULL),
	(100175, 'PW21A-TS100175BL', 'product_sales', 'NO FEAR', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000174', '2021-04-15 11:52:51.000174', NULL),
	(100176, 'PW21A-TS100176BL', 'product_sales', 'NEVER TRUST', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000175', '2021-04-15 11:52:51.000175', NULL),
	(100177, 'PW21A-TS100177BL', 'product_sales', 'JAPAN CULTURE', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000176', '2021-04-15 11:52:51.000176', NULL),
	(100178, 'PW21A-TS100178BL', 'product_sales', 'THE ROOT', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000177', '2021-04-15 11:52:51.000177', NULL),
	(100179, 'PW21A-TS100179BL', 'product_sales', 'HERITAGE TEE REBORN', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000178', '2021-04-15 11:52:51.000178', NULL),
	(100180, 'PW21A-TS100180BL', 'product_sales', 'DETROIT CITY', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000179', '2021-04-15 11:52:51.000179', NULL),
	(100181, 'PW21A-TS100181BL', 'product_sales', 'WILD ENGINE', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000180', '2021-04-15 11:52:51.000180', NULL),
	(100182, 'PW21A-TS100182BL', 'product_sales', 'RECKLESS TEE', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000181', '2021-04-15 11:52:51.000181', NULL),
	(100183, 'PW21A-TS100183BL', 'product_sales', 'STREET TRACKER 2.0', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000182', '2021-04-15 11:52:51.000182', NULL),
	(100184, 'PW21A-TS100184BL', 'product_sales', 'NO REGRET', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000183', '2021-04-15 11:52:51.000183', NULL),
	(100185, 'PW21A-TS100185BL', 'product_sales', 'SHUTEN DOJI', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000184', '2021-04-15 11:52:51.000184', NULL),
	(100186, 'PW21A-TS100186BL', 'product_sales', 'CHRYSANT DEMON', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000185', '2021-04-15 11:52:51.000185', NULL),
	(100187, 'PW21A-TS100187BL', 'product_sales', 'INVOLVED 2.0', 2, 1, 2, 0, 0, 189000, 0, 2, 1, '2021-04-15 11:52:51.000186', '2021-04-15 11:52:51.000186', NULL),
	(100188, 'PW21A-TS100188BL', 'product_sales', 'OSAKA TIGER', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000187', '2021-04-15 11:52:51.000187', NULL),
	(100189, 'PW21A-TS100189BL', 'product_sales', 'KARASU TENGU', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000188', '2021-04-15 11:52:51.000188', NULL),
	(100190, 'PW21A-TS100190WT', 'product_sales', 'NO FEAR WHITE', 2, 1, 4, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000189', '2021-04-15 11:52:51.000189', NULL),
	(100191, 'PW21A-TS100191YW ', 'product_sales', 'BRAVERY', 2, 1, 3, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000190', '2021-04-15 11:52:51.000190', NULL),
	(100192, 'PW21A-TS100192GN', 'product_sales', 'PW MC TEES', 2, 1, 12, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000191', '2021-04-15 11:52:51.000191', NULL),
	(100193, 'PW21A-TS100193BL', 'product_sales', 'EL FUERTE', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000192', '2021-04-15 11:52:51.000192', NULL),
	(100194, 'PW21A-TS100194RD', 'product_sales', 'GO RIDE', 2, 1, 7, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000193', '2021-04-15 11:52:51.000193', NULL),
	(100195, 'PW21A-TS100195BL', 'product_sales', 'THE WILD', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000194', '2021-04-15 11:52:51.000194', NULL),
	(100196, 'PW21A-TS100196BL', 'product_sales', 'SNAKE DAGGER', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000195', '2021-04-15 11:52:51.000195', NULL),
	(100197, 'PW21A-TS100197BL', 'product_sales', 'END OF WAR', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000196', '2021-04-15 11:52:51.000196', NULL),
	(100198, 'PW21A-TS100198BL', 'product_sales', 'LIBERATOR TEES', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000197', '2021-04-15 11:52:51.000197', NULL),
	(100199, 'PW21A-TS100199BL', 'product_sales', 'KIRIN 2.0', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000198', '2021-04-15 11:52:51.000198', NULL),
	(100200, 'PW21A-TS100200BL', 'product_sales', 'POSER', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000199', '2021-04-15 11:52:51.000199', NULL),
	(100201, 'PW21A-TS100201BL', 'product_sales', 'SERPENT ROSE', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000200', '2021-04-15 11:52:51.000200', NULL),
	(100202, 'PW21A-TS100202BL', 'product_sales', 'RISING DRAGON', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000201', '2021-04-15 11:52:51.000201', NULL),
	(100203, 'PW21A-TS100203BL', 'product_sales', 'GREEDY SOUL', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000202', '2021-04-15 11:52:51.000202', NULL),
	(100204, 'PW21A-TS100204BL', 'product_sales', 'KILLER CROC', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000203', '2021-04-15 11:52:51.000203', NULL),
	(100205, 'PW21A-TS100205WT', 'product_sales', 'NEKO SHENSI 2.0', 2, 1, 4, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000204', '2021-04-15 11:52:51.000204', NULL),
	(100206, 'PW21A-TS100206WT', 'product_sales', 'ONI MASK WHITE 2.0', 2, 1, 4, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000205', '2021-04-15 11:52:51.000205', NULL),
	(100207, 'PW21A-TS100207BL', 'product_sales', 'SAMURAI SPIRIT', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000206', '2021-04-15 11:52:51.000206', NULL),
	(100208, 'PW21A-TS100208BL', 'product_sales', 'ETERNITY FLAMES 2.0', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000207', '2021-04-15 11:52:51.000207', NULL),
	(100209, 'PW21A-TS100209BL', 'product_sales', 'LOCAL FIGHTER', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000208', '2021-04-15 11:52:51.000208', NULL),
	(100210, 'PW21A-TS100210BL', 'product_sales', 'WRATH DRAGON 2.0', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000209', '2021-04-15 11:52:51.000209', NULL),
	(100211, 'PW21A-TS100211BL', 'product_sales', 'SUMO SHENSO 2.0', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000210', '2021-04-15 11:52:51.000210', NULL),
	(100212, 'PW21A-TS100212GN', 'product_sales', 'SPEED JUNKIES', 2, 1, 12, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000211', '2021-04-15 11:52:51.000211', NULL),
	(100213, 'PW21A-TS100213BL', 'product_sales', 'RECKLESS LEAP', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000212', '2021-04-15 11:52:51.000212', NULL),
	(100214, 'PW21A-TS100214BL', 'product_sales', 'ONI MASK BLACK 2.0', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000213', '2021-04-15 11:52:51.000213', NULL),
	(100215, 'PW21A-TS100215BL', 'product_sales', 'FLAMES CHOPPER 2.0', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000214', '2021-04-15 11:52:51.000214', NULL),
	(100216, 'PW21A-TS100216NV', 'product_sales', 'TIGER FLAMES', 2, 1, 17, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000215', '2021-04-15 11:52:51.000215', NULL),
	(100217, 'PW21A-TS100217BL', 'product_sales', 'INDIAN OWL', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000216', '2021-04-15 11:52:51.000216', NULL),
	(100218, 'PW21A-TS100218BL', 'product_sales', 'NORTON MANX 2.0', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000217', '2021-04-15 11:52:51.000217', NULL),
	(100219, 'PW21A-TS100219BL', 'product_sales', 'KONOTORI TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000218', '2021-04-15 11:52:51.000218', NULL),
	(100220, 'PW21A-TS100220BL', 'product_sales', 'DEMAND FREEDOM TEE', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000219', '2021-04-15 11:52:51.000219', NULL),
	(100221, 'PW21A-TK100221BL', 'product_sales', 'RECKLESS LEAP KIDS', 11, 1, 2, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000220', '2021-04-15 11:52:51.000220', NULL),
	(100222, 'PW21A-TS100222BL', 'product_sales', 'FREEDOM FIGHTER TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000221', '2021-04-15 11:52:51.000221', NULL),
	(100223, 'PW21A-TS100223BL', 'product_sales', 'FREAKLESS TEE', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000222', '2021-04-15 11:52:51.000222', NULL),
	(100224, 'PW21A-TK100224BL', 'product_sales', 'VINTAGE CAT KIDS', 11, 1, 2, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000223', '2021-04-15 11:52:51.000223', NULL),
	(100225, 'PW21A-TK100225BL', 'product_sales', 'NORTON MANX KIDS', 11, 1, 2, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000224', '2021-04-15 11:52:51.000224', NULL),
	(100226, 'PW21A-TS100226BL', 'product_sales', 'WOLF SPIRIT TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000225', '2021-04-15 11:52:51.000225', NULL),
	(100227, 'PW21A-TK100227BL', 'product_sales', 'GREEDY SOUL KIDS', 11, 1, 2, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000226', '2021-04-15 11:52:51.000226', NULL),
	(100228, 'PW21A-TS100228BL', 'product_sales', 'REVENGER TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000227', '2021-04-15 11:52:51.000227', NULL),
	(100229, 'PW21A-TK100229BL', 'product_sales', 'EL FUERTE KIDS', 11, 1, 2, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000228', '2021-04-15 11:52:51.000228', NULL),
	(100230, 'PW21A-TK100230BL', 'product_sales', 'FREEDOM DIVISION KIDS', 11, 1, 2, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000229', '2021-04-15 11:52:51.000229', NULL),
	(100231, 'PW21A-TS100231BL', 'product_sales', 'AKUMA TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000230', '2021-04-15 11:52:51.000230', NULL),
	(100232, 'PW21A-TK100232GN', 'product_sales', 'SPEED JUNKIES KIDS', 11, 1, 12, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000231', '2021-04-15 11:52:51.000231', NULL),
	(100233, 'PW21A-TS100233BL', 'product_sales', 'SENSHI TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000232', '2021-04-15 11:52:51.000232', NULL),
	(100234, 'PW21A-TK100234BL', 'product_sales', 'HERITAGE TEE KIDS', 11, 1, 2, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000233', '2021-04-15 11:52:51.000233', NULL),
	(100235, 'PW21A-TS100235BL', 'product_sales', 'UMA SENSHI', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000234', '2021-04-15 11:52:51.000234', NULL),
	(100236, 'PW21A-TK100236WT', 'product_sales', 'BIG BAD WOLF KIDS', 11, 1, 4, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000235', '2021-04-15 11:52:51.000235', NULL),
	(100237, 'PW21A-TS100237BL', 'product_sales', 'SAKURAGI TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000236', '2021-04-15 11:52:51.000236', NULL),
	(100238, 'PW21A-TS100238BL', 'product_sales', 'KEMONO TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000237', '2021-04-15 11:52:51.000237', NULL),
	(100239, 'PW21A-TK100239OG', 'product_sales', 'EASY WAY KIDS', 11, 1, 10, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000238', '2021-04-15 11:52:51.000238', NULL),
	(100240, 'PW21A-TK100240OG', 'product_sales', 'THE BRAVE KIDS', 11, 1, 10, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000239', '2021-04-15 11:52:51.000239', NULL),
	(100241, 'PW21A-TS100241YW ', 'product_sales', 'FORTIUS TEE', 2, 1, 3, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000240', '2021-04-15 11:52:51.000240', NULL),
	(100242, 'PW21A-TS100242BL', 'product_sales', 'MOTOR CULTURE', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000241', '2021-04-15 11:52:51.000241', NULL),
	(100243, 'PW21A-TK100243BL', 'product_sales', 'NO FEAR KIDS', 11, 1, 2, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000242', '2021-04-15 11:52:51.000242', NULL),
	(100244, 'PW21A-TS100244BL', 'product_sales', 'THE STRONGEST 2.0', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000243', '2021-04-15 11:52:51.000243', NULL),
	(100245, 'PW21A-TS100245RD', 'product_sales', 'RIDE AND FREE', 2, 1, 7, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000244', '2021-04-15 11:52:51.000244', NULL),
	(100246, 'PW21A-TK100246BL', 'product_sales', 'LOCAL FIGHTER KIDS', 11, 1, 2, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000245', '2021-04-15 11:52:51.000245', NULL),
	(100247, 'PW21A-TS100247NV', 'product_sales', 'GRAND PRIX TEE', 2, 1, 17, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000246', '2021-04-15 11:52:51.000246', NULL),
	(100248, 'PW21A-TS100248BL', 'product_sales', 'NEVER QUIT TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000247', '2021-04-15 11:52:51.000247', NULL),
	(100249, 'PW21A-TK100249WT', 'product_sales', 'SEISHIN KIDS', 11, 1, 4, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000248', '2021-04-15 11:52:51.000248', NULL),
	(100250, 'PW21A-TS100250WT', 'product_sales', 'SEISHIN TEE', 2, 1, 4, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000249', '2021-04-15 11:52:51.000249', NULL),
	(100251, 'PW21A-TS100251BL', 'product_sales', 'DEATH GLORY', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000250', '2021-04-15 11:52:51.000250', NULL),
	(100252, 'PW21A-TS100252WT', 'product_sales', 'DARUMA TEE', 2, 1, 4, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000251', '2021-04-15 11:52:51.000251', NULL),
	(100253, 'PW21A-TS100253BL', 'product_sales', 'DIGGER FREAK', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000252', '2021-04-15 11:52:51.000252', NULL),
	(100254, 'PW21A-TK100254BL', 'product_sales', 'UMA SENSHI KIDS', 11, 1, 2, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000253', '2021-04-15 11:52:51.000253', NULL),
	(100255, 'PW21A-TS100255BL', 'product_sales', 'VENOM TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000254', '2021-04-15 11:52:51.000254', NULL),
	(100256, 'PW21A-TK100256BL', 'product_sales', 'LIBERATOR TEE KIDS', 11, 1, 2, 0, 0, 119000, 0, 2, 1, '2021-04-15 11:52:51.000255', '2021-04-15 11:52:51.000255', NULL),
	(100257, 'PW21A-TS100257WT', 'product_sales', 'SASORI TEE 2.0', 2, 1, 4, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000256', '2021-04-15 11:52:51.000256', NULL),
	(100258, 'PW21A-TS100258WT', 'product_sales', 'COBALT TEE', 2, 1, 4, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000257', '2021-04-15 11:52:51.000257', NULL),
	(100259, 'PW21A-TS100259BL', 'product_sales', 'DEADSOUL', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000258', '2021-04-15 11:52:51.000258', NULL),
	(100260, 'PW21A-TS100260BL', 'product_sales', 'OKAMI DEMON', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000259', '2021-04-15 11:52:51.000259', NULL),
	(100261, 'PW21A-TS100261BL', 'product_sales', 'FLYING SKULL', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000260', '2021-04-15 11:52:51.000260', NULL),
	(100262, 'PW21A-TS100262BL', 'product_sales', 'RAIJIN TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000261', '2021-04-15 11:52:51.000261', NULL),
	(100263, 'PW21A-TS100263BL', 'product_sales', 'KIRIN GIVEAWAY', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000262', '2021-04-15 11:52:51.000262', NULL),
	(100264, 'PW21A-TS100264WH', 'product_sales', 'TWIN HORSE', 2, 1, 20, 0, 0, 189000, 0, 2, 1, '2021-04-15 11:52:51.000263', '2021-04-15 11:52:51.000263', NULL),
	(100265, 'PW21A-TS100265RD', 'product_sales', 'ENDLESS TEE', 2, 1, 7, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000264', '2021-04-15 11:52:51.000264', NULL),
	(100266, 'PW21A-TS100266BL', 'product_sales', 'SUPERIOR TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000265', '2021-04-15 11:52:51.000265', NULL),
	(100267, 'PW21A-TS100267BL', 'product_sales', 'DOMINATION TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000266', '2021-04-15 11:52:51.000266', NULL),
	(100268, 'PW21A-TS100268BL', 'product_sales', 'KAERU SENSHI', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000267', '2021-04-15 11:52:51.000267', NULL),
	(100269, 'PW21A-TS100269BL', 'product_sales', 'UNFORGIVEN TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000268', '2021-04-15 11:52:51.000268', NULL),
	(100270, 'PW21A-TS100270BL', 'product_sales', 'ETNIC BEAR', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000269', '2021-04-15 11:52:51.000269', NULL),
	(100271, 'PW21A-TS100271BL', 'product_sales', 'BATOSAI TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000270', '2021-04-15 11:52:51.000270', NULL),
	(100272, 'PW21A-TS100272BL', 'product_sales', 'DIRTY DEEDS', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000271', '2021-04-15 11:52:51.000271', NULL),
	(100273, 'PW21A-TS100273WT', 'product_sales', 'BARONG TEE', 2, 1, 4, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000272', '2021-04-15 11:52:51.000272', NULL),
	(100274, 'PW21A-TS100274BL', 'product_sales', 'BURNING FEAR', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000273', '2021-04-15 11:52:51.000273', NULL),
	(100275, 'PW21A-TS100275BL', 'product_sales', 'TENGU HEBI', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000274', '2021-04-15 11:52:51.000274', NULL),
	(100276, 'PW21A-TS100276WT', 'product_sales', 'KYOGEN MASK', 2, 1, 4, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000275', '2021-04-15 11:52:51.000275', NULL),
	(100277, 'PW21A-TS100277BL', 'product_sales', 'HELL DRIVER', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000276', '2021-04-15 11:52:51.000276', NULL),
	(100278, 'PW21A-TS100278BL', 'product_sales', 'GEISHA BLACK', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000277', '2021-04-15 11:52:51.000277', NULL),
	(100279, 'PW21A-TS100279WT', 'product_sales', 'GEISHA WHITE', 2, 1, 4, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000278', '2021-04-15 11:52:51.000278', NULL),
	(100280, 'PW21A-TS100280BL', 'product_sales', 'FUTAGO ONI', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000279', '2021-04-15 11:52:51.000279', NULL),
	(100281, 'PW21A-TS100281BL', 'product_sales', 'TORA TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000280', '2021-04-15 11:52:51.000280', NULL),
	(100282, 'PW21A-TS100282BL', 'product_sales', 'SKULL JUNKIES', 2, 1, 2, 0, 0, 169000, 0, 2, 1, '2021-04-15 11:52:51.000281', '2021-04-15 11:52:51.000281', NULL),
	(100283, 'PW21A-TS100283BL', 'product_sales', 'ROAD KILLER', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000282', '2021-04-15 11:52:51.000282', NULL),
	(100284, 'PW21A-TS100284BL', 'product_sales', 'ONIMUSHA TEE', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000283', '2021-04-15 11:52:51.000283', NULL),
	(100285, 'PW21A-TS100285BL', 'product_sales', 'GYPSY SOUL', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000284', '2021-04-15 11:52:51.000284', NULL),
	(100286, 'PW21A-TS100286BL', 'product_sales', 'FUJIN ', 2, 1, 2, 0, 0, 219000, 0, 2, 1, '2021-04-15 11:52:51.000285', '2021-04-15 11:52:51.000285', NULL),
	(100287, 'PW21A-TS100287BL', 'product_sales', 'SHORT BLUE PW', 10, 1, 5, 0, 0, 215000, 0, 2, 1, '2021-04-15 11:52:51.000286', '2021-04-15 11:52:51.000286', NULL),
	(100288, 'PW21A-TS100288BL', 'product_sales', 'MIDNIGHT RIDER', 10, 1, 2, 0, 0, 285000, 0, 2, 1, '2021-04-15 11:52:51.000287', '2021-04-15 11:52:51.000287', NULL),
	(100289, 'PW21A-TS100289BL', 'product_sales', 'RIDE AND CONQUER', 10, 1, 2, 0, 0, 365000, 0, 2, 1, '2021-04-15 11:52:51.000288', '2021-04-15 11:52:51.000288', NULL),
	(100290, 'PW21A-TS100290OL', 'product_sales', 'FEARLESS 3.0', 10, 1, 11, 0, 0, 375000, 0, 2, 1, '2021-04-15 11:52:51.000289', '2021-04-15 11:52:51.000289', NULL),
	(100291, 'PW21A-TS100291BL', 'product_sales', 'CHRYSANT DEMON OVERSHIRT', 10, 1, 2, 0, 0, 365000, 0, 2, 1, '2021-04-15 11:52:51.000290', '2021-04-15 11:52:51.000290', NULL),
	(100292, 'PW21A-TS100292NV', 'product_sales', 'PHILLIP WORKSHIRT', 10, 1, 17, 0, 0, 339000, 0, 2, 1, '2021-04-15 11:52:51.000291', '2021-04-15 11:52:51.000291', NULL),
	(100293, 'PW21A-TS100293OL', 'product_sales', 'THE LIBERATOR', 10, 1, 11, 0, 0, 365000, 0, 2, 1, '2021-04-15 11:52:51.000292', '2021-04-15 11:52:51.000292', NULL),
	(100294, 'PW21A-TS100294OL', 'product_sales', 'THE LIBERATOR 2.0', 10, 1, 11, 0, 0, 375000, 0, 2, 1, '2021-04-15 11:52:51.000293', '2021-04-15 11:52:51.000293', NULL),
	(100295, 'PW21A-TS100295NV', 'product_sales', 'MEMENTO MORI 2.0', 10, 1, 17, 0, 0, 375000, 0, 2, 1, '2021-04-15 11:52:51.000294', '2021-04-15 11:52:51.000294', NULL),
	(100296, 'PW21A-TS100296BL', 'product_sales', 'CHRYSANT DEMON OVERSHIRT 2.0', 10, 1, 2, 0, 0, 375000, 0, 2, 1, '2021-04-15 11:52:51.000295', '2021-04-15 11:52:51.000295', NULL),
	(100297, 'PW21A-TS100297OL', 'product_sales', 'STRONGER THAN DEATH 2.0', 10, 1, 11, 0, 0, 375000, 0, 2, 1, '2021-04-15 11:52:51.000296', '2021-04-15 11:52:51.000296', NULL),
	(100298, 'PW21A-TS100298OL', 'product_sales', 'EL LUCHADOR 4.0', 10, 1, 11, 0, 0, 385000, 0, 2, 1, '2021-04-15 11:52:51.000297', '2021-04-15 11:52:51.000297', NULL),
	(100299, 'PW21A-TS100299BL', 'product_sales', 'LE MANS WORKSHIRT', 10, 1, 2, 0, 0, 365000, 0, 2, 1, '2021-04-15 11:52:51.000298', '2021-04-15 11:52:51.000298', NULL),
	(100300, 'PW21A-TS100300MR', 'product_sales', 'MONZA WORKSHIRT', 10, 1, 13, 0, 0, 365000, 0, 2, 1, '2021-04-15 11:52:51.000299', '2021-04-15 11:52:51.000299', NULL),
	(100301, 'PW21A-TS100301BL', 'product_sales', 'FREEDOM FIGHTER OVERSHIRT', 10, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000300', '2021-04-15 11:52:51.000300', NULL),
	(100302, 'PW21A-TS100302BL', 'product_sales', 'WOLF SPIRIT OVERSHIRT', 10, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000301', '2021-04-15 11:52:51.000301', NULL),
	(100303, 'PW21A-TS100303BL', 'product_sales', 'DEVIL MASK OVERSHIRT', 10, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000302', '2021-04-15 11:52:51.000302', NULL),
	(100304, 'PW21A-TS100304OL', 'product_sales', 'THE LIBERATOR 3.0', 10, 1, 11, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000303', '2021-04-15 11:52:51.000303', NULL),
	(100305, 'PW21A-TS100305AR', 'product_sales', 'UNDEFEATED 2.0', 10, 1, 15, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000304', '2021-04-15 11:52:51.000304', NULL),
	(100306, 'PW21A-TS100306GN', 'product_sales', 'AERO OVERSHIRT', 10, 1, 12, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000305', '2021-04-15 11:52:51.000305', NULL),
	(100307, 'PW21A-TS100307GN', 'product_sales', 'SPEED OVERSHIRT', 10, 1, 12, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000306', '2021-04-15 11:52:51.000306', NULL),
	(100308, 'PW21A-TS100308GN', 'product_sales', 'GRYPHON OVERSHIRT', 10, 1, 12, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000307', '2021-04-15 11:52:51.000307', NULL),
	(100309, 'PW21A-TS100309GN', 'product_sales', 'THE DESTROYER OVERSHIRT', 10, 1, 12, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000308', '2021-04-15 11:52:51.000308', NULL),
	(100310, 'PW21A-SW100310BL', 'product_sales', 'RECKLESS HOODIE', 12, 1, 2, 0, 0, 385000, 0, 2, 1, '2021-04-15 11:52:51.000309', '2021-04-15 11:52:51.000309', NULL),
	(100311, 'PW21A-SW100311BL', 'product_sales', 'HERITAGE HOODIE 2.0', 12, 1, 2, 0, 0, 399000, 0, 2, 1, '2021-04-15 11:52:51.000310', '2021-04-15 11:52:51.000310', NULL),
	(100312, 'PW21A-SW100312BL', 'product_sales', 'SERPENT ROSE HOODIE', 12, 1, 2, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000311', '2021-04-15 11:52:51.000311', NULL),
	(100313, 'PW21A-SW100313BL', 'product_sales', 'POSER HOODIE', 12, 1, 2, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000312', '2021-04-15 11:52:51.000312', NULL),
	(100314, 'PW21A-SW100314DK', 'product_sales', 'STORM ACTIVE', 12, 1, 21, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000313', '2021-04-15 11:52:51.000313', NULL),
	(100315, 'PW21A-SW100315BL', 'product_sales', 'OSAKA TIGER HOODIE', 12, 1, 2, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000314', '2021-04-15 11:52:51.000314', NULL),
	(100316, 'PW21A-SW100316BL', 'product_sales', 'KARASU TENGU HOODIE', 12, 1, 2, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000315', '2021-04-15 11:52:51.000315', NULL),
	(100317, 'PW21A-SW100317BL', 'product_sales', 'INTERSTELLAR BLACK', 12, 1, 2, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000316', '2021-04-15 11:52:51.000316', NULL),
	(100318, 'PW21A-SW100318OL', 'product_sales', 'INTERSTELLAR OLIVE', 12, 1, 11, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000317', '2021-04-15 11:52:51.000317', NULL),
	(100319, 'PW21A-SW100319WT', 'product_sales', 'INTERSTELLAR WHITE', 12, 1, 4, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000318', '2021-04-15 11:52:51.000318', NULL),
	(100320, 'PW21A-SW100320BL', 'product_sales', 'KARASU TENGU HOODIE 2.0', 12, 1, 2, 0, 0, 399000, 0, 2, 1, '2021-04-15 11:52:51.000319', '2021-04-15 11:52:51.000319', NULL),
	(100321, 'PW21A-SW100321BL', 'product_sales', 'OSAKA TIGER HOODIE 2.0', 12, 1, 2, 0, 0, 399000, 0, 2, 1, '2021-04-15 11:52:51.000320', '2021-04-15 11:52:51.000320', NULL),
	(100322, 'PW21A-SW100322BL', 'product_sales', 'CHRYSANT DEMON HOODIE 2.0', 12, 1, 2, 0, 0, 399000, 0, 2, 1, '2021-04-15 11:52:51.000321', '2021-04-15 11:52:51.000321', NULL),
	(100323, 'PW21A-SW100323BL', 'product_sales', 'DEMAND FREEDOM HOODIE', 12, 1, 2, 0, 0, 399000, 0, 2, 1, '2021-04-15 11:52:51.000322', '2021-04-15 11:52:51.000322', NULL),
	(100324, 'PW21A-SW100324BL', 'product_sales', 'RECKLESS HOODIE ZIP', 12, 1, 2, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000323', '2021-04-15 11:52:51.000323', NULL),
	(100325, 'PW21A-SW100325BL', 'product_sales', 'STRATO HOODIE', 12, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000324', '2021-04-15 11:52:51.000324', NULL),
	(100326, 'PW21A-SW100326BL', 'product_sales', 'BURNING SKULL HOODIE', 12, 1, 2, 0, 0, 369000, 0, 2, 1, '2021-04-15 11:52:51.000325', '2021-04-15 11:52:51.000325', NULL),
	(100327, 'PW21A-SW100327BL', 'product_sales', 'DEATH GLORY HOODIE', 12, 1, 2, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000326', '2021-04-15 11:52:51.000326', NULL),
	(100328, 'PW21A-SW100328BL', 'product_sales', 'RIDE AND FREE HOODIE', 12, 1, 2, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000327', '2021-04-15 11:52:51.000327', NULL),
	(100329, 'PW21A-SW100329BL', 'product_sales', 'PISTON HEAD HOODIE', 12, 1, 2, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000328', '2021-04-15 11:52:51.000328', NULL),
	(100330, 'PW21A-SW100330BL', 'product_sales', 'MOTOR CO HOODIE', 12, 1, 2, 0, 0, 369000, 0, 2, 1, '2021-04-15 11:52:51.000329', '2021-04-15 11:52:51.000329', NULL),
	(100331, 'PW21A-PN100331BL', 'product_sales', 'NIGHT RIDER', 13, 1, 2, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000330', '2021-04-15 11:52:51.000330', NULL),
	(100332, 'PW21A-PN100332BL', 'product_sales', 'BLACK HAWK', 13, 1, 2, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000331', '2021-04-15 11:52:51.000331', NULL),
	(100333, 'PW21A-PN100333BL', 'product_sales', 'BLUE WELDER', 13, 1, 5, 0, 0, 469000, 0, 2, 1, '2021-04-15 11:52:51.000332', '2021-04-15 11:52:51.000332', NULL),
	(100334, 'PW21A-PN100334BL', 'product_sales', 'NIGHT RIDER 2.0', 13, 1, 2, 0, 0, 459000, 0, 2, 1, '2021-04-15 11:52:51.000333', '2021-04-15 11:52:51.000333', NULL),
	(100335, 'PW21A-PN100335BL', 'product_sales', 'REMINGTON PANTS BLACK', 13, 1, 2, 0, 0, 339000, 0, 2, 1, '2021-04-15 11:52:51.000334', '2021-04-15 11:52:51.000334', NULL),
	(100336, 'PW21A-PN100336GN', 'product_sales', 'REMINGTON PANTS GREEN', 13, 1, 12, 0, 0, 339000, 0, 2, 1, '2021-04-15 11:52:51.000335', '2021-04-15 11:52:51.000335', NULL),
	(100337, 'PW21A-PN100337CM', 'product_sales', 'REMINGTON PANTS CAMO', 13, 1, 14, 0, 0, 339000, 0, 2, 1, '2021-04-15 11:52:51.000336', '2021-04-15 11:52:51.000336', NULL),
	(100338, 'PW21A-PN100338BL', 'product_sales', 'TEMPERDOWN BLACK', 13, 1, 2, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000337', '2021-04-15 11:52:51.000337', NULL),
	(100339, 'PW21A-PN100339CM', 'product_sales', 'TEMPERDOWN CAMO', 13, 1, 14, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000338', '2021-04-15 11:52:51.000338', NULL),
	(100340, 'PW21A-PN100340OL', 'product_sales', 'TEMPERDOWN OLIVE', 13, 1, 11, 0, 0, 389000, 0, 2, 1, '2021-04-15 11:52:51.000339', '2021-04-15 11:52:51.000339', NULL),
	(100341, 'PW21A-PN100341DM', 'product_sales', 'BLUE STONE', 13, 1, 19, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000340', '2021-04-15 11:52:51.000340', NULL),
	(100342, 'PW21A-PN100342DM', 'product_sales', 'STARLEY', 13, 1, 19, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000341', '2021-04-15 11:52:51.000341', NULL),
	(100343, 'PW21A-PN100343DM', 'product_sales', 'WILD ONE', 13, 1, 19, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000342', '2021-04-15 11:52:51.000342', NULL),
	(100344, 'PW21A-WL100344BW', 'product_sales', 'VAQUERO', 14, 1, 8, 0, 0, 449000, 0, 2, 1, '2021-04-15 11:52:51.000343', '2021-04-15 11:52:51.000343', NULL),
	(100345, 'PW21A-WL100345BW', 'product_sales', 'RODEO', 14, 1, 8, 0, 0, 459000, 0, 2, 1, '2021-04-15 11:52:51.000344', '2021-04-15 11:52:51.000344', NULL),
	(100346, 'PW21A-WL100346BW', 'product_sales', 'TEXAS', 14, 1, 8, 0, 0, 259000, 0, 2, 1, '2021-04-15 11:52:51.000345', '2021-04-15 11:52:51.000345', NULL),
	(100347, 'PW21A-HM100347BL', 'product_sales', 'BLACK ROVER DOFF', 9, 1, 2, 0, 0, 2100000, 0, 2, 1, '2021-04-15 11:52:51.000346', '2021-04-15 11:52:51.000346', NULL),
	(100348, 'PW21A-HM100348WT', 'product_sales', 'WHITE ROVER', 9, 1, 4, 0, 0, 2100000, 0, 2, 1, '2021-04-15 11:52:51.000347', '2021-04-15 11:52:51.000347', NULL),
	(100349, 'PW21A-HM100349BL', 'product_sales', 'RAMBLER BLACK DOFF', 9, 1, 2, 0, 0, 1900000, 0, 2, 1, '2021-04-15 11:52:51.000348', '2021-04-15 11:52:51.000348', NULL),
	(100350, 'PW21A-HM100350BL', 'product_sales', 'RAMBLER BLACK GLOSSY', 9, 1, 2, 0, 0, 1900000, 0, 2, 1, '2021-04-15 11:52:51.000349', '2021-04-15 11:52:51.000349', NULL),
	(100351, 'PW21A-HM100351BL', 'product_sales', 'BLACK ROVER GLOSSY', 9, 1, 2, 0, 0, 2100000, 0, 2, 1, '2021-04-15 11:52:51.000350', '2021-04-15 11:52:51.000350', NULL),
	(100352, 'PW21A-HM100352BL', 'product_sales', 'ROVER BLACK DOFF', 9, 1, 2, 0, 0, 2100000, 0, 2, 1, '2021-04-15 11:52:51.000351', '2021-04-15 11:52:51.000351', NULL),
	(100353, 'PW21A-HM100353WT', 'product_sales', 'ROVER WHITE GLOSSY', 9, 1, 4, 0, 0, 2100000, 0, 2, 1, '2021-04-15 11:52:51.000352', '2021-04-15 11:52:51.000352', NULL),
	(100354, 'PW21A-HM100354WT', 'product_sales', 'RAMBLER WHITE GLOSSY', 9, 1, 4, 0, 0, 1900000, 0, 2, 1, '2021-04-15 11:52:51.000353', '2021-04-15 11:52:51.000353', NULL),
	(100355, 'PW21A-HM100355RD', 'product_sales', 'ROVER RED GLOSSY', 9, 1, 7, 0, 0, 2100000, 0, 2, 1, '2021-04-15 11:52:51.000354', '2021-04-15 11:52:51.000354', NULL),
	(100356, 'PW21A-HM100356YW ', 'product_sales', 'RAMBLER YELLOW GLOSSY', 9, 1, 3, 0, 0, 1900000, 0, 2, 1, '2021-04-15 11:52:51.000355', '2021-04-15 11:52:51.000355', NULL),
	(100357, 'PW21A-HM100357YW ', 'product_sales', 'ROVER YELLOW GLOSSY', 9, 1, 3, 0, 0, 2100000, 0, 2, 1, '2021-04-15 11:52:51.000356', '2021-04-15 11:52:51.000356', NULL),
	(100358, 'PW21A-HM100358WT', 'product_sales', 'ROVER X LOKALHERO', 9, 1, 4, 0, 0, 4000000, 0, 2, 1, '2021-04-15 11:52:51.000357', '2021-04-15 11:52:51.000357', NULL),
	(100359, 'PW21A-JK100359NV', 'product_sales', 'RIDE TO GLORY PARKA', 7, 1, 17, 0, 0, 749000, 0, 2, 1, '2021-04-15 11:52:51.000358', '2021-04-15 11:52:51.000358', NULL),
	(100360, 'PW21A-SH100360DM', 'product_sales', 'DENIM BLUE PW', 10, 1, 19, 0, 0, 249000, 0, 2, 1, '2021-04-15 11:52:51.000359', '2021-04-15 11:52:51.000359', NULL),
	(100361, 'PW21A-SH100361BL', 'product_sales', 'CLOUD', 10, 1, 5, 0, 0, 285000, 0, 2, 1, '2021-04-15 11:52:51.000360', '2021-04-15 11:52:51.000360', NULL),
	(100362, 'PW21A-SH100362BL', 'product_sales', 'STEVIE', 10, 1, 5, 0, 0, 285000, 0, 2, 1, '2021-04-15 11:52:51.000361', '2021-04-15 11:52:51.000361', NULL),
	(100363, 'PW21A-JK100363BL', 'product_sales', 'CRUISER GORETEX', 7, 1, 2, 0, 0, 649000, 0, 2, 1, '2021-04-15 11:52:51.000362', '2021-04-15 11:52:51.000362', NULL),
	(100364, 'PW21A-SH100364BL', 'product_sales', 'DEVON', 10, 1, 2, 0, 0, 385000, 0, 2, 1, '2021-04-15 11:52:51.000363', '2021-04-15 11:52:51.000363', NULL),
	(100365, 'PW21A-SW100365GY', 'product_sales', 'SACRAMENTO HOODIE', 12, 1, 6, 0, 0, 399000, 0, 2, 1, '2021-04-15 11:52:51.000364', '2021-04-15 11:52:51.000364', NULL),
	(100366, 'PW21A-SW100366GY', 'product_sales', 'MC CARTHY HOODIE', 12, 1, 6, 0, 0, 399000, 0, 2, 1, '2021-04-15 11:52:51.000365', '2021-04-15 11:52:51.000365', NULL),
	(100367, 'PW21A-SW100367BL', 'product_sales', 'BLACK TERRA', 12, 1, 2, 0, 0, 399000, 0, 2, 1, '2021-04-15 11:52:51.000366', '2021-04-15 11:52:51.000366', NULL),
	(100368, 'PW21A-SW100368NV', 'product_sales', 'STRONGER THAN FEAR', 12, 1, 17, 0, 0, 399000, 0, 2, 1, '2021-04-15 11:52:51.000367', '2021-04-15 11:52:51.000367', NULL),
	(100369, 'PW21A-JK100369BL', 'product_sales', 'INDIAN GORETEX', 7, 1, 2, 0, 0, 589000, 0, 2, 1, '2021-04-15 11:52:51.000368', '2021-04-15 11:52:51.000368', NULL),
	(100370, 'PW21A-SH100370NV', 'product_sales', 'BROOKLYN', 10, 1, 17, 0, 0, 289000, 0, 2, 1, '2021-04-15 11:52:51.000369', '2021-04-15 11:52:51.000369', NULL),
	(100371, 'PW21A-SH100371BL', 'product_sales', 'OKLAHOMA', 10, 1, 2, 0, 0, 289000, 0, 2, 1, '2021-04-15 11:52:51.000370', '2021-04-15 11:52:51.000370', NULL),
	(100372, 'PW21A-SH100372DK', 'product_sales', 'PHANTOM', 10, 1, 21, 0, 0, 269000, 0, 2, 1, '2021-04-15 11:52:51.000371', '2021-04-15 11:52:51.000371', NULL),
	(100373, 'PW21A-SH100373GY', 'product_sales', 'MAJESTY', 10, 1, 6, 0, 0, 269000, 0, 2, 1, '2021-04-15 11:52:51.000372', '2021-04-15 11:52:51.000372', NULL),
	(100374, 'PW21A-SH100374GY', 'product_sales', 'LONDON PRINTED SHIRT', 10, 1, 6, 0, 0, 269000, 0, 2, 1, '2021-04-15 11:52:51.000373', '2021-04-15 11:52:51.000373', NULL),
	(100375, 'PW21A-SH100375BL', 'product_sales', 'NORDIC URBAN', 10, 1, 5, 0, 0, 269000, 0, 2, 1, '2021-04-15 11:52:51.000374', '2021-04-15 11:52:51.000374', NULL),
	(100376, 'PW21A-SH100376CM', 'product_sales', 'ROOKIE CAMO SHIRT', 10, 1, 14, 0, 0, 284000, 0, 2, 1, '2021-04-15 11:52:51.000375', '2021-04-15 11:52:51.000375', NULL),
	(100377, 'PW21A-SW100377BL', 'product_sales', 'RECKLESS HOODIE 2.0', 12, 1, 2, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000376', '2021-04-15 11:52:51.000376', NULL),
	(100378, 'PW21A-SW100378DK', 'product_sales', 'STORM ACTIVE', 12, 1, 21, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000377', '2021-04-15 11:52:51.000377', NULL),
	(100379, 'PW21A-SW100379GY', 'product_sales', 'BLIZZARD ACTIVE', 12, 1, 6, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000378', '2021-04-15 11:52:51.000378', NULL),
	(100380, 'PW21A-SW100380NV', 'product_sales', 'LIGHTNING ACTIVE', 12, 1, 17, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000379', '2021-04-15 11:52:51.000379', NULL),
	(100381, 'PW21A-SW100381BL', 'product_sales', 'CHRYSANT DEMON HOODIE', 12, 1, 2, 0, 0, 419000, 0, 2, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100382, 'SX21A-AC100382BW', 'consignment', 'LEATHER KEYRING BROWN', 3, 1, 8, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100383, 'SX21A-AC100383DK', 'consignment', 'BOWLER LEATHER WALLET', 3, 1, 21, 0, 0, 249900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100384, 'SX21A-AC100384BL', 'consignment', 'FOLDING KEYCHAIN 1 BLACK', 3, 1, 2, 0, 0, 99900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100385, 'SX21A-AC100385BW', 'consignment', 'FOLDING KEYCHAIN 1 BROWN', 3, 1, 8, 0, 0, 99900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100386, 'SX21A-AC100386BL', 'consignment', 'FOLDING KEYCHAIN 2 BLACK ', 3, 1, 2, 0, 0, 99900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100387, 'SX21A-AC100387BD', 'consignment', 'FOLDING KEYCHAIN 2 BLACK DOFF', 3, 1, 22, 0, 0, 99900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100388, 'SX21A-AC100388BW', 'consignment', 'FOLDING KEYCHAIN 2 BROWN', 3, 1, 8, 0, 0, 99900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100389, 'SX21A-AC100389DK', 'consignment', 'FOLDING KEYCHAIN 2 DARK', 3, 1, 21, 0, 0, 99900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100390, 'SX21A-AC100390BW', 'consignment', 'GIANT LEATHER WALLET ', 3, 1, 8, 0, 0, 249900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100391, 'SX21A-AC100391AR', 'consignment', 'GLADING BELT ARMYGREEN', 3, 1, 15, 0, 0, 109900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100392, 'SX21A-AC100392BL', 'consignment', 'GLADING BELT BLACK', 3, 1, 2, 0, 0, 109900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100393, 'SX21A-AC100393NV', 'consignment', 'GLADING BELT NAVY', 3, 1, 17, 0, 0, 109900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100394, 'SX21A-AC100394BL', 'consignment', 'KENZO WALLET', 3, 1, 2, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100395, 'SX21A-AC100395BL', 'consignment', 'LEATHER KEYRING BLACK', 3, 1, 2, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100396, 'SX21A-AC100396BL', 'consignment', 'LEATHER KEYRING BLUE ', 3, 1, 5, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100397, 'SX21A-AC100397BW', 'consignment', 'LEATHER KEYRING BROWN', 3, 1, 8, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100398, 'SX21A-AC100398GN', 'consignment', 'LEATHER KEYRING GREEN', 3, 1, 12, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100399, 'SX21A-AC100399GY', 'consignment', 'LEATHER KEYRING GREY', 3, 1, 6, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100400, 'SX21A-AC100400RD', 'consignment', 'LEATHER KEYRING RED', 3, 1, 7, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100401, 'SX21A-AC100401YW ', 'consignment', 'LEATHER KEYRING YELLOW', 3, 1, 3, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100402, 'SX21A-AC100402NV', 'consignment', 'PEDY BELT NAVY', 3, 1, 17, 0, 0, 109900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100403, 'SX21A-AC100403BL', 'consignment', 'PEDY BELT BLACK', 3, 1, 2, 0, 0, 109900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100404, 'SX21A-AC100404BL', 'consignment', 'TANGIER KEYRING BLACK', 3, 1, 2, 0, 0, 59900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100405, 'SX21A-AC100405GN', 'consignment', 'TANGIER KEYRING GREEN', 3, 1, 12, 0, 0, 59900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100406, 'SX21A-AC100406NV', 'consignment', 'TANGIER KEYRING NAVY', 3, 1, 17, 0, 0, 59900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100407, 'SX21A-AC100407CH', 'consignment', 'TANGIER KEYRING CHOCO', 3, 1, 23, 0, 0, 59900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100408, 'SX21A-AC100408GY', 'consignment', 'TANGIER KEYRING GREY', 3, 1, 6, 0, 0, 59900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100409, 'SX21A-AC100409RD', 'consignment', 'TANGIER KEYRING RED', 3, 1, 7, 0, 0, 59900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100410, 'SX21A-AC100410AR', 'consignment', 'WEBING BELT ARMY', 3, 1, 15, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100411, 'SX21A-AC100411BL', 'consignment', 'WEBING BELT BLACK', 3, 1, 2, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100412, 'SX21A-AC100412GY', 'consignment', 'WEBING BELT GREY', 3, 1, 6, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100413, 'SX21A-AC100413NV', 'consignment', 'WEBING BELT NAVY', 3, 1, 17, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100414, 'SX21A-BG100414AR', 'consignment', 'AVIREX SLINGBAG', 4, 1, 15, 0, 0, 229900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100415, 'SX21A-BG100415BL', 'consignment', 'BIG FLOWER WAISTBAG', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100416, 'SX21A-BG100416BL', 'consignment', 'BIG JANEMBA WAISTBAG', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100417, 'SX21A-BG100417BL', 'consignment', 'BIG SLUG WAISTBAG', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100418, 'SX21A-BG100418BL', 'consignment', 'BIG TURLES WAISTBAG', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100419, 'SX21A-BG100419BW', 'consignment', 'BUGGY TRAVELKIT', 4, 1, 8, 0, 0, 149900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100420, 'SX21A-BG100420BL', 'consignment', 'BUZZ TRAVELKIT', 4, 1, 2, 0, 0, 149900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100421, 'SX21A-BG100421BL', 'consignment', 'CARD STORAGE BLACK', 4, 1, 2, 0, 0, 79900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100422, 'SX21A-BG100422BW', 'consignment', 'CARD STORAGE BROWN', 4, 1, 8, 0, 0, 79900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100423, 'SX21A-BG100423NV', 'consignment', 'CARD STORAGE NAVY', 4, 1, 17, 0, 0, 79900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100424, 'SX21A-BG100424BL', 'consignment', 'CHIBA WAISTBAG BLACK', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100425, 'SX21A-BG100425DK', 'consignment', 'CHIBA WAISTBAG DARK', 4, 1, 21, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100426, 'SX21A-BG100426NV', 'consignment', 'CHIBA WAISTBAG NAVY', 4, 1, 17, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100427, 'SX21A-BG100427WT', 'consignment', 'CHIBA WAISTBAG WHITE', 4, 1, 4, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100428, 'SX21A-BG100428BL', 'consignment', 'DAILY SLINGBAG', 4, 1, 2, 0, 0, 149900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100429, 'SX21A-BG100429BL', 'consignment', 'DIMSY GYMBAG', 4, 1, 2, 0, 0, 249900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100430, 'SX21A-BG100430BL', 'consignment', 'DOTTA SLINGBAG', 4, 1, 2, 0, 0, 149900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100431, 'SX21A-BG100431BL', 'consignment', 'DRAGON SLINGBAG BLACK', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100432, 'SX21A-BG100432BL', 'consignment', 'DRAGON SLINGBAG BLUE', 4, 1, 5, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100433, 'SX21A-BG100433GN', 'consignment', 'DRAGON SLINGBAG GREEN', 4, 1, 12, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100434, 'SX21A-BG100434NV', 'consignment', 'DRAGON SLINGBAG NAVY', 4, 1, 17, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100435, 'SX21A-BG100435BL', 'consignment', 'DRY BAG 15,5L', 4, 1, 2, 0, 0, 209900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100436, 'SX21A-BG100436BL', 'consignment', 'DRY BAG 25,5L', 4, 1, 2, 0, 0, 99900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100437, 'SX21A-BG100437BL', 'consignment', 'DRY BAG 20.2L', 4, 1, 2, 0, 0, 259900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100438, 'SX21A-BG100438BL', 'consignment', 'DRY BAG 3,5L', 4, 1, 2, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100439, 'SX21A-BG100439BL', 'consignment', 'DRY BAG 30L', 4, 1, 2, 0, 0, 299900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100440, 'SX21A-BG100440BL', 'consignment', 'DRY BAG 5,1L', 4, 1, 2, 0, 0, 159900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100441, 'SX21A-BG100441BL', 'consignment', 'DUSCO WAISTBAG BLACK', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100442, 'SX21A-BG100442GY', 'consignment', 'FUKUOKA TOTE BAG', 4, 1, 6, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100443, 'SX21A-BG100443GN', 'consignment', 'GOLDIE WAISTBAG GREEN', 4, 1, 12, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100444, 'SX21A-BG100444BL', 'consignment', 'GOTEN WAISTBAG BLACK', 4, 1, 2, 0, 0, 209900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100445, 'SX21A-BG100445BW', 'consignment', 'GOTEN WAISTBAG BROWN', 4, 1, 8, 0, 0, 209900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100446, 'SX21A-BG100446DK', 'consignment', 'GOTEN WAISTBAG DARK', 4, 1, 21, 0, 0, 209900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100447, 'SX21A-BG100447BW', 'consignment', 'GYMBAG', 4, 1, 8, 0, 0, 279900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100448, 'SX21A-BG100448BL', 'consignment', 'HANZO GYMBAG', 4, 1, 2, 0, 0, 249900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100449, 'SX21A-BG100449BL', 'consignment', 'KANAZAWA TOTE BAG', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100450, 'SX21A-BG100450BL', 'consignment', 'KINTON WAISTBAG', 4, 1, 5, 0, 0, 169900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100451, 'SX21A-BG100451BL', 'consignment', 'MATASUYAMA TOTEBAG', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100452, 'SX21A-BG100452BL', 'consignment', 'NAGONO WAISTBAG BLACK', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100453, 'SX21A-BG100453NV', 'consignment', 'NAGONO WAISTBAG NAVY', 4, 1, 17, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100454, 'SX21A-BG100454AR', 'consignment', 'NAGONO WAISTBAG ARMY', 4, 1, 15, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100455, 'SX21A-BG100455BL', 'consignment', 'NAZGUL WAISTBAG', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100456, 'SX21A-BG100456BL', 'consignment', 'OCTURNAL SLINGBAG', 4, 1, 2, 0, 0, 149900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100457, 'SX21A-BG100457BL', 'consignment', 'OKAYAMA WAISTBAG BLACK', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100458, 'SX21A-BG100458GN', 'consignment', 'OKAYAMA WAISTBAG GREEN', 4, 1, 12, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100459, 'SX21A-BG100459NV', 'consignment', 'OKAYAMA WAISTBAG NAVY', 4, 1, 17, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100460, 'SX21A-BG100460TN', 'consignment', 'OKAYAMA WAISTBAG TAN', 4, 1, 24, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100461, 'SX21A-BG100461WT', 'consignment', 'OKAYAMA WAISTBAG WHITE', 4, 1, 4, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100462, 'SX21A-BG100462BW', 'consignment', 'PORTER WAISTBAG BROWN', 4, 1, 8, 0, 0, 209900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100463, 'SX21A-BG100463CM', 'consignment', 'PORTER WAISTBAG CAMO', 4, 1, 14, 0, 0, 209900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100464, 'SX21A-BG100464DB', 'consignment', 'PORTER WAISTBAG DARK BLUE', 4, 1, 25, 0, 0, 209900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100465, 'SX21A-BG100465DG', 'consignment', 'PORTER WAISTBAG DARK GREY', 4, 1, 26, 0, 0, 209900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100466, 'SX21A-BG100466BL', 'consignment', 'SAKURA WAISTBAG BLACK', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100467, 'SX21A-BG100467BL', 'consignment', 'SAKURA WAISTBAG BLUE', 4, 1, 5, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100468, 'SX21A-BG100468BL', 'consignment', 'SAMIE WAISTBAG BLACK', 4, 1, 2, 0, 0, 209900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100469, 'SX21A-BG100469BL', 'consignment', 'TAGOMA WAISTBAG BLACK', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100470, 'SX21A-BG100470GY', 'consignment', 'TAGOMA WAISTBAG GREY', 4, 1, 6, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100471, 'SX21A-BG100471BL', 'consignment', 'TANZIA WAISTBAG BLACK', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100472, 'SX21A-BG100472AR', 'consignment', 'TANZIA WAISTBAG ARMY', 4, 1, 15, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100473, 'SX21A-BG100473GN', 'consignment', 'TANZIA WAISTBAG GREEN', 4, 1, 12, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100474, 'SX21A-BG100474GY', 'consignment', 'TANZIA WAISTBAG GREY', 4, 1, 6, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100475, 'SX21A-BG100475NV', 'consignment', 'TANZIA WAISTBAG NAVY', 4, 1, 17, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100476, 'SX21A-BG100476BL', 'consignment', 'YOKOHAMA TOTE BAG', 4, 1, 2, 0, 0, 199900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100477, 'SX21A-HT100477BL', 'consignment', 'CONQUER TRUCKER', 6, 1, 2, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100478, 'SX21A-HT100478BL', 'consignment', 'CUSTOM TRUCKER', 6, 1, 2, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100479, 'SX21A-HT100479BL', 'consignment', 'FLYING SPEED TRUCKER', 6, 1, 2, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100480, 'SX21A-HT100480BL', 'consignment', 'GARAGE TRUCKER SX', 6, 1, 2, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100481, 'SX21A-HT100481BL', 'consignment', 'MACHINE TRUCKER', 6, 1, 2, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100482, 'SX21A-HT100482BL', 'consignment', 'MOTORCYCLE TRUCKER DARK', 6, 1, 2, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100483, 'SX21A-HT100483NV', 'consignment', 'MOTORCYCLE TRUCKER NAVY', 6, 1, 17, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100484, 'SX21A-HT100484AR', 'consignment', 'MOTOWORK TRUCKER ARMY', 6, 1, 15, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100485, 'SX21A-HT100485CH', 'consignment', 'MOTOWORK TRUCKER CHOCO', 6, 1, 23, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100486, 'SX21A-HT100486NV', 'consignment', 'MOTOWORK TRUCKER NAVY', 6, 1, 17, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100487, 'SX21A-HT100487AR', 'consignment', 'NORRIS CAP ARMY', 6, 1, 15, 0, 0, 139900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100488, 'SX21A-HT100488CR', 'consignment', 'NORRIS CAP CREAM', 6, 1, 27, 0, 0, 139900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100489, 'SX21A-HT100489MR', 'consignment', 'NORRIS CAP MAROON', 6, 1, 13, 0, 0, 139900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100490, 'SX21A-HT100490BL', 'consignment', 'SUPERB CUB TRUCKER', 6, 1, 2, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100491, 'SX21A-HT100491BL', 'consignment', 'UNION CAPS BLACK', 6, 1, 2, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100492, 'SX21A-HT100492GN', 'consignment', 'UNION CAPS GREEN', 6, 1, 12, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100493, 'SX21A-HT100493GY', 'consignment', 'UNION CAPS GREY', 6, 1, 6, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100494, 'SX21A-HT100494MR', 'consignment', 'UNION CAPS MAROON', 6, 1, 13, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100495, 'SX21A-HT100495NV', 'consignment', 'UNION CAPS NAVY', 6, 1, 17, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100496, 'SX21A-HT100496BW', 'consignment', 'UNITED ARMY', 6, 1, 8, 0, 0, 99900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100497, 'SX21A-HT100497BL', 'consignment', 'WEMBLEY TRUCKER BLACK', 6, 1, 2, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100498, 'SX21A-HT100498GN', 'consignment', 'WEMBLEY TRUCKER GREEN', 6, 1, 12, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100499, 'SX21A-HT100499NV', 'consignment', 'WEMBLEY TRUCKER NAVY', 6, 1, 17, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100500, 'SX21A-HT100500MR', 'consignment', 'WEMBLEY TRUCKER MAROON', 6, 1, 13, 0, 0, 129900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100501, 'SX21A-HT100501BL', 'consignment', 'WHEEL TRUCKER', 6, 1, 2, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100502, 'SX21A-HT100502BL', 'consignment', 'WORK TO WIN TRUCKER', 6, 1, 2, 0, 0, 119900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100503, 'SX21A-WL100503CH', 'consignment', 'CARD STORAGE CHOCOLATE', 14, 1, 23, 0, 0, 79900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100504, 'SX21A-SW100504BL', 'consignment', 'GRANADA HOODIE BLACK', 12, 1, 2, 0, 0, 449900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100505, 'SX21A-JK100505BL', 'consignment', 'GARAGE BOMBER', 7, 1, 2, 0, 0, 439900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100506, 'SX21A-JK100506BL', 'consignment', 'IRON BOMBER', 7, 1, 2, 0, 0, 429900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100507, 'SX21A-JK100507BL', 'consignment', 'HIGHT DENIM JACKET', 7, 1, 2, 0, 0, 429900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100508, 'SX21A-JK100508BL', 'consignment', 'WB FLYING MACHINES', 7, 1, 2, 0, 0, 339900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100509, 'SX21A-JK100509DK', 'consignment', 'WB IRON HAND DARK', 7, 1, 21, 0, 0, 339900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100510, 'SX21A-JK100510GY', 'consignment', 'JACK HAMMER ZIP', 7, 1, 6, 0, 0, 299900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100511, 'SX21A-JK100511GY', 'consignment', 'WB SUPER CUB', 7, 1, 6, 0, 0, 339900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100512, 'SX21A-JK100512GY', 'consignment', 'WB COURT', 7, 1, 6, 0, 0, 339900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100513, 'SX21A-JK100513CM', 'consignment', 'WB ALL MAKER', 7, 1, 14, 0, 0, 339900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100514, 'SX21A-JK100514DK', 'consignment', 'WB READY TO GO', 7, 1, 21, 0, 0, 339900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100515, 'SX21A-JK100515DK', 'consignment', 'DRAKEN BOMBER', 7, 1, 21, 0, 0, 399900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100516, 'SX21A-JK100516NV', 'consignment', 'WB GARAGE NAVY', 7, 1, 17, 0, 0, 339900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100517, 'SX21A-JK100517DK', 'consignment', 'RUNNING BAT', 7, 1, 21, 0, 0, 299900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100518, 'SX21A-JK100518BL', 'consignment', 'WB RACER', 7, 1, 2, 0, 0, 359900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100519, 'SX21A-JK100519DK', 'consignment', 'RECIFE BOMBER DARK', 7, 1, 21, 0, 0, 399900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100520, 'SX21A-JK100520BL', 'consignment', 'WB WORK TO WIN B3', 7, 1, 2, 0, 0, 349900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100521, 'SX21A-JK100521BL', 'consignment', 'WB LOCAL MOTO', 7, 1, 2, 0, 0, 339900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100522, 'SX21A-JK100522BL', 'consignment', 'RECIFE BOMBER BLACK', 7, 1, 2, 0, 0, 399900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100523, 'SX21A-JK100523BL', 'consignment', 'ZEPPLIN BOMBER ', 7, 1, 2, 0, 0, 449900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100524, 'SX21A-JK100524BL', 'consignment', 'WB VISION', 7, 1, 2, 0, 0, 339900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100525, 'SX21A-JK100525BL', 'consignment', 'WB GARAGE BLACK', 7, 1, 2, 0, 0, 339900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100526, 'SX21A-JK100526BL', 'consignment', 'ORLANDO PARKA', 7, 1, 2, 0, 0, 669900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100527, 'SX21A-JK100527GY', 'consignment', 'SANDOR CAGOULE #2', 7, 1, 6, 0, 0, 399900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100528, 'SX21A-JK100528BL', 'consignment', 'RACER BOMBER B1', 7, 1, 2, 0, 0, 399900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100529, 'SX21A-JK100529AR', 'consignment', 'WB IRONHEAD B3', 7, 1, 15, 0, 0, 349900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100530, 'SX21A-JK100530BL', 'consignment', 'WB LABOR MACHINES', 7, 1, 2, 0, 0, 349900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100531, 'SX21A-JK100531BL', 'consignment', 'ENERGIZER BOMBER', 7, 1, 2, 0, 0, 399900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100532, 'SX21A-JK100532BL', 'consignment', 'HERINGTON SUEDE #4', 7, 1, 2, 0, 0, 399900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100533, 'SX21A-JK100533DK', 'consignment', 'WB FLYING MACHINES DARK #1', 7, 1, 21, 0, 0, 399900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100534, 'SX21A-JK100534RD', 'consignment', 'WB CUSTOM MACHINES C1', 7, 1, 7, 0, 0, 399900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100535, 'SX21A-JK100535BL', 'consignment', 'OSMOND BOMBER', 7, 1, 2, 0, 0, 599900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100536, 'SX21A-JK100536CH', 'consignment', 'HERINGTON MONGREL', 7, 1, 23, 0, 0, 399900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100537, 'SX21A-JK100537GY', 'consignment', 'HERINGTON BRIDSON', 7, 1, 6, 0, 0, 399900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100538, 'SX21A-JK100538NV', 'consignment', 'HERINGTON ORDANT', 7, 1, 17, 0, 0, 399900, 0, 3, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100539, 'EN21A-AC100539SV', 'consignment', 'BRACELET SKULL SILVER', 3, 1, 28, 0, 0, 250000, 0, 5, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100540, 'EN21A-AC100540SV', 'consignment', 'KINGDOM RING', 3, 1, 28, 0, 0, 200000, 0, 5, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100541, 'FS21A-AC100541AP', 'consignment', 'DEATH MONGER RING ALP', 3, 1, 29, 0, 0, 1400000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100542, 'FS21A-AC100542BR', 'consignment', 'DEATHWINGS RING', 3, 1, 30, 0, 0, 1200000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100543, 'FS21A-AC100543AP', 'consignment', 'DEATHWINGS RING ALP', 3, 1, 29, 0, 0, 1400000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100544, 'FS21A-AC100544BR', 'consignment', 'PTOLEMIC RING', 3, 1, 30, 0, 0, 1150000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100545, 'FS21A-AC100545AP', 'consignment', 'PTOLEMIC RING ALP', 3, 1, 29, 0, 0, 1350000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100546, 'FS21A-AC100546BR', 'consignment', 'HELL CLOWN', 3, 1, 30, 0, 0, 1150000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100547, 'FS21A-AC100547AP', 'consignment', 'HELL CLOWN ALP', 3, 1, 29, 0, 0, 1350000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100548, 'FS21A-AC100548AP', 'consignment', 'MECHANIX PENDANT', 3, 1, 29, 0, 0, 1350000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100549, 'FS21A-AC100549AP', 'consignment', 'BANDITOS PENDANT', 3, 1, 29, 0, 0, 1300000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100550, 'FS21A-AC100550AP', 'consignment', 'DIABOLIC PENDANT', 3, 1, 29, 0, 0, 1250000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100551, 'FS21A-AC100551BR', 'consignment', 'BETTA RING', 3, 1, 30, 0, 0, 1050000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100552, 'FS21A-AC100552AP', 'consignment', 'BETTA RING ALP', 3, 1, 29, 0, 0, 1200000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100553, 'FS21A-AC100553BR', 'consignment', 'GORGA RING', 3, 1, 30, 0, 0, 1050000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100554, 'FS21A-AC100554AP', 'consignment', 'GORGA RING ALP', 3, 1, 29, 0, 0, 1200000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100555, 'FS21A-AC100555AP', 'consignment', 'SAHASIKA RING ALP', 3, 1, 29, 0, 0, 1200000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100556, 'FS21A-AC100556AP', 'consignment', 'KAMANDAKA PENDANT ALP', 3, 1, 29, 0, 0, 1200000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100557, 'FS21A-AC100557AP', 'consignment', 'MECHANIC PENDANT ALP', 3, 1, 29, 0, 0, 1200000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100558, 'FS21A-AC100558AP', 'consignment', 'BANDITOS PENDANT ALP', 3, 1, 29, 0, 0, 1200000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100559, 'FS21A-AC100559AP', 'consignment', 'DIABOLIC PENDANT ALP', 3, 1, 29, 0, 0, 1200000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100560, 'FS21A-AC100560BR', 'consignment', 'DIABOLIC PENDANT BRASS', 3, 1, 30, 0, 0, 1200000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100561, 'FS21A-AC100561BR', 'consignment', 'PRIDE RING BRASS', 3, 1, 30, 0, 0, 1400000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100562, 'FS21A-AC100562AP', 'consignment', 'GORGA RING ALP', 3, 1, 29, 0, 0, 1100000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100563, 'FS21A-AC100563BR', 'consignment', 'ASTAKA BRASS', 3, 1, 30, 0, 0, 900000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100564, 'FS21A-AC100564AP', 'consignment', 'D MONGER ALPACA', 3, 1, 29, 0, 0, 1400000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100565, 'FS21A-AC100565AP', 'consignment', 'BETTA  ALPACA', 3, 1, 29, 0, 0, 1100000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100566, 'FS21A-AC100566BR', 'consignment', 'PTOLEMIC BRASS', 3, 1, 30, 0, 0, 1400000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100567, 'FS21A-AC100567BR', 'consignment', 'HELLCLOWN BRASS', 3, 1, 30, 0, 0, 1400000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100568, 'FS21A-AC100568BR', 'consignment', 'D MONGER BRASS', 3, 1, 30, 0, 0, 1400000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100569, 'FS21A-AC100569BR', 'consignment', 'LONGINUS BRASS', 3, 1, 30, 0, 0, 1200000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100570, 'FS21A-AC100570BR', 'consignment', 'D RIDER BRASS', 3, 1, 30, 0, 0, 1400000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100571, 'FS21A-AC100571BR', 'consignment', 'DEAD WINGS BRASS', 3, 1, 30, 0, 0, 1400000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100572, 'FS21A-AC100572BR', 'consignment', 'AERONAUT BRASS', 3, 1, 30, 0, 0, 1400000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100573, 'FS21A-AC100573MX', 'consignment', 'EAGLE PIN', 3, 1, 31, 0, 0, 93000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100574, 'FS21A-AC100574MX', 'consignment', 'PINAPPLE PIN', 3, 1, 31, 0, 0, 93000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100575, 'FS21A-AC100575MX', 'consignment', 'ICE CREAM PIN', 3, 1, 31, 0, 0, 93000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100576, 'FS21A-AC100576MX', 'consignment', 'CACTUS PIN', 3, 1, 31, 0, 0, 93000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100577, 'FS21A-AC100577MX', 'consignment', 'HEART PENDANT', 3, 1, 31, 0, 0, 187000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100578, 'FS21A-AC100578MX', 'consignment', 'KEY PENDANT', 3, 1, 31, 0, 0, 187000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100579, 'FS21A-AC100579MX', 'consignment', 'ACE PENDANT', 3, 1, 31, 0, 0, 187000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100580, 'FS21A-AC100580MX', 'consignment', 'SKULL DAGGER PENDANT', 3, 1, 31, 0, 0, 187000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100581, 'FS21A-AC100581MX', 'consignment', 'PISTON PENDANT', 3, 1, 31, 0, 0, 187000, 0, 6, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100582, 'GG21A-BG100582BL', 'consignment', 'JALI BLACK', 4, 1, 2, 0, 0, 250000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100583, 'GG21A-BG100583BL', 'consignment', 'JALI SOLID BLACK', 4, 1, 2, 0, 0, 220000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100584, 'GG21A-BG100584BL', 'consignment', 'BOKS MINI BLACK', 4, 1, 2, 0, 0, 120000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100585, 'GG21A-BG100585BL', 'consignment', 'GVSTI BLACK', 4, 1, 2, 0, 0, 270000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100586, 'GG21A-BG100586BL', 'consignment', 'RUMERE BLACK', 4, 1, 2, 0, 0, 320000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100587, 'GG21A-BG100587BL', 'consignment', 'PYJO BLACK 2.0', 4, 1, 2, 0, 0, 480000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100588, 'GG21A-BG100588BL', 'consignment', 'RADEN', 4, 1, 2, 0, 0, 380000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100589, 'GG21A-BG100589BL', 'consignment', 'TEKU', 4, 1, 2, 0, 0, 250000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100590, 'GG21A-BG100590BL', 'consignment', 'LANANG', 4, 1, 2, 0, 0, 290000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100591, 'GG21A-BG100591BL', 'consignment', 'BELL', 4, 1, 2, 0, 0, 200000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100592, 'GG21A-BG100592OG', 'consignment', 'UNI ORANGE', 4, 1, 10, 0, 0, 75000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100593, 'GG21A-BG100593RD', 'consignment', 'UNI RED', 4, 1, 7, 0, 0, 75000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100594, 'GG21A-BG100594BL', 'consignment', 'CES BLACK', 4, 1, 2, 0, 0, 250000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100595, 'GG21A-BG100595BL', 'consignment', 'GATTA BLUE', 4, 1, 5, 0, 0, 250000, 0, 7, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100596, 'NY21A-GL100596RD', 'consignment', 'NOBLEMAN RED', 5, 1, 7, 0, 0, 270000, 0, 4, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100597, 'NY21A-GL100597RD', 'consignment', 'SABR RED', 5, 1, 7, 0, 0, 270000, 0, 4, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100598, 'NY21A-GL100598RD', 'consignment', 'OSBORN RED', 5, 1, 7, 0, 0, 270000, 0, 4, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100599, 'NY21A-GL100599YW ', 'consignment', 'OSBORN YELLOW', 5, 1, 3, 0, 0, 270000, 0, 4, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100600, 'NY21A-GL100600RD', 'consignment', 'LEON RED', 5, 1, 7, 0, 0, 270000, 0, 4, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100601, 'NY21A-GL100601MR', 'consignment', 'LEON MAROON', 5, 1, 13, 0, 0, 270000, 0, 4, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100602, 'NY21A-GL100602RD', 'consignment', 'SABR RUSTIC RED', 5, 1, 7, 0, 0, 270000, 0, 4, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100603, 'NY21A-GL100603YW ', 'consignment', 'SABR RUSTIC YELLOW', 5, 1, 3, 0, 0, 270000, 0, 4, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100604, 'NY21A-GL100604YW ', 'consignment', 'OSBORN RUSTIC YELLOW', 5, 1, 3, 0, 0, 270000, 0, 4, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100605, 'NY21A-GL100605RD', 'consignment', 'NOBLEMAN RUSTIC RED', 5, 1, 7, 0, 0, 270000, 0, 4, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100606, 'NK21A-AC100606MX', 'consignment', 'NAPOLI', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100607, 'NK21A-AC100607MX', 'consignment', 'NORDIC', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100608, 'NK21A-AC100608MX', 'consignment', 'LAVA', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100609, 'NK21A-AC100609MX', 'consignment', 'SKY', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100610, 'NK21A-AC100610MX', 'consignment', 'COLOGNE CHRISTMAS', 3, 1, 31, 0, 0, 198000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100611, 'NK21A-AC100611MX', 'consignment', 'AMITY GREEN', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100612, 'NK21A-AC100612MX', 'consignment', 'SEVILLE', 3, 1, 31, 0, 0, 198000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100613, 'NK21A-AC100613MX', 'consignment', 'BROOKLYN STRIPE', 3, 1, 31, 0, 0, 198000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100614, 'NK21A-AC100614MX', 'consignment', 'HAMAR', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100615, 'NK21A-AC100615MX', 'consignment', 'LARVIK', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100616, 'NK21A-AC100616MX', 'consignment', 'MOLDE', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100617, 'NK21A-AC100617MX', 'consignment', 'BRYNE', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100618, 'NK21A-AC100618MX', 'consignment', 'GREEN FOREST', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100619, 'NK21A-AC100619MX', 'consignment', 'EXARCHISE STRIPE', 3, 1, 31, 0, 0, 89000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100620, 'NK21A-AC100620MX', 'consignment', 'SAMARA (NS 48)', 3, 1, 31, 0, 0, 89000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100621, 'NK21A-AC100621MX', 'consignment', 'LATVIA (NS 50)', 3, 1, 31, 0, 0, 89000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100622, 'NK21A-AC100622MX', 'consignment', 'OEKABITI (NS 054)', 3, 1, 31, 0, 0, 89000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100623, 'NK21A-AC100623MX', 'consignment', 'BLUE LAGOON', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100624, 'NK21A-AC100624MX', 'consignment', 'ROMANS', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100625, 'NK21A-AC100625MX', 'consignment', 'BOHEMIAN HALDEN', 3, 1, 31, 0, 0, 198000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100626, 'NK21A-AC100626MX', 'consignment', 'BOYD', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100627, 'NK21A-AC100627MX', 'consignment', 'BRISTOL', 3, 1, 31, 0, 0, 198000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100628, 'NK21A-AC100628MX', 'consignment', 'DERRICK', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100629, 'NK21A-AC100629MX', 'consignment', 'BLACK PANTHER', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100630, 'NK21A-AC100630MX', 'consignment', 'BOHEMIAN OSLO', 3, 1, 31, 0, 0, 198000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100631, 'NK21A-AC100631MX', 'consignment', 'MOSKOW', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100632, 'NK21A-AC100632MX', 'consignment', 'KAZAN', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100633, 'NK21A-AC100633MX', 'consignment', 'SOCHI', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100634, 'NK21A-AC100634MX', 'consignment', 'VOLGA', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100635, 'NK21A-AC100635MX', 'consignment', 'BACK TO BASIC', 3, 1, 31, 0, 0, 159000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100636, 'NK21A-AC100636MX', 'consignment', 'KANSAS STRIPE', 3, 1, 31, 0, 0, 159000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100637, 'NK21A-AC100637MX', 'consignment', 'VLADIMIR', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100638, 'NK21A-AC100638MX', 'consignment', 'BLACK CAMO', 3, 1, 31, 0, 0, 89000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100639, 'NK21A-AC100639MX', 'consignment', 'PERM', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100640, 'NK21A-AC100640MX', 'consignment', 'CHITA', 3, 1, 31, 0, 0, 59000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100641, 'NK21A-AC100641MX', 'consignment', 'TURIN CREW BASIC', 3, 1, 31, 0, 0, 89000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100642, 'NK21A-AC100642MX', 'consignment', 'LATIVA CREW BASIC', 3, 1, 31, 0, 0, 89000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100643, 'NK21A-AC100643MX', 'consignment', 'KAZAN CREW BASIC', 3, 1, 31, 0, 0, 89000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100644, 'NK21A-AC100644MX', 'consignment', 'COLORADO STRIPE', 3, 1, 31, 0, 0, 89000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100645, 'NK21A-AC100645MX', 'consignment', 'IROQUOIS', 3, 1, 31, 0, 0, 89000, 0, 8, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100646, 'RF21A-BG100646GY', 'consignment', 'NVBAG 17 006', 4, 1, 6, 0, 0, 568000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100647, 'RF21A-BG100647BW', 'consignment', 'NVBAG 18 014', 4, 1, 8, 0, 0, 1168000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100648, 'RF21A-JK100648NV', 'consignment', 'NVJ 17 D 068', 7, 1, 17, 0, 0, 1668000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100649, 'RF21A-PN100649OL', 'consignment', 'M5SC 17 G 002', 13, 1, 11, 0, 0, 798000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100650, 'RF21A-PN100650OL', 'consignment', 'M5SC 17 G 003', 13, 1, 11, 0, 0, 798000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100651, 'RF21A-PN100651OL', 'consignment', 'M5SC 17 G 004', 13, 1, 11, 0, 0, 798000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100652, 'RF21A-PN100652OL', 'consignment', 'M5SC 17 G 005', 13, 1, 11, 0, 0, 798000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100653, 'RF21A-PN100653OL', 'consignment', 'M5SC 17 G 006', 13, 1, 11, 0, 0, 798000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100654, 'RF21A-BG100654GY', 'consignment', 'NVBAGT 18 001', 4, 1, 6, 0, 0, 698000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100655, 'RF21A-JK100655BL', 'consignment', 'NVJ 16 D 040', 7, 1, 2, 0, 0, 1288000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100656, 'RF21A-BG100656GN', 'consignment', 'NVBAGR 042', 4, 1, 12, 0, 0, 1668000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100657, 'RF21A-BG100657NV', 'consignment', 'NVBAG 18 034', 4, 1, 17, 0, 0, 825000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100658, 'RF21A-BG100658BL', 'consignment', 'NVBAG 18 033', 4, 1, 2, 0, 0, 1088000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100659, 'RF21A-BG100659BL', 'consignment', 'M5BAG 009', 4, 1, 2, 0, 0, 1268000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100660, 'RF21A-BG100660AR', 'consignment', 'M5BAG 010', 4, 1, 15, 0, 0, 925000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100661, 'RF21A-HT100661NV', 'consignment', 'NVHAT 17 017', 6, 1, 17, 0, 0, 348000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100662, 'RF21A-HT100662BL', 'consignment', 'NVHAT 17 014', 6, 1, 2, 0, 0, 225000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100663, 'RF21A-HT100663OL', 'consignment', 'NVHAT 17 013', 6, 1, 11, 0, 0, 428000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100664, 'RF21A-JK100664KH', 'consignment', 'M5LS 002 KHAKY', 7, 1, 32, 0, 0, 768000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100665, 'RF21A-JK100665OL', 'consignment', 'NV BJ 018 OLIVE', 7, 1, 11, 0, 0, 1768000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100666, 'RF21A-JK100666GN', 'consignment', 'NV BJ 001 GREEN', 7, 1, 12, 0, 0, 1268000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100667, 'RF21A-SH100667RD', 'consignment', 'NVLS 16 D 006', 10, 1, 7, 0, 0, 468000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100668, 'RF21A-BG100668GN', 'consignment', 'NVBAGS 001', 4, 1, 12, 0, 0, 298000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100669, 'RF21A-SH100669GN', 'consignment', 'NVAR LS 001', 10, 1, 12, 0, 0, 868000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100670, 'RF21A-SH100670GN', 'consignment', 'NVAR LS 002', 10, 1, 12, 0, 0, 868000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100671, 'RF21A-PN100671BL', 'consignment', 'M5LP 002', 13, 1, 2, 0, 0, 768000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100672, 'RF21A-PN100672AR', 'consignment', 'M5LP 003', 13, 1, 15, 0, 0, 826000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100673, 'RF21A-PN100673BL', 'consignment', 'B17SP 001', 13, 1, 2, 0, 0, 568000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100674, 'RF21A-PN100674BL', 'consignment', 'B17SP 002', 13, 1, 2, 0, 0, 568000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100675, 'RF21A-JK100675BL', 'consignment', 'NVJ 17D 069', 7, 1, 2, 0, 0, 2688000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100676, 'RF21A-JK100676GN', 'consignment', 'NVJ 075', 7, 1, 12, 0, 0, 2188000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100677, 'RF21A-JK100677GN', 'consignment', 'NVAR LS 005', 7, 1, 12, 0, 0, 768000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(100678, 'RF21A-JK100678GY', 'consignment', 'HOODIE M5H 001', 7, 1, 6, 0, 0, 678000, 0, 9, 1, '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL);
/*!40000 ALTER TABLE `product` ENABLE KEYS */;

-- Dumping structure for table phillip.product_receivement
CREATE TABLE IF NOT EXISTS `product_receivement` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` enum('general','consignment','internal_transfer','return','return_consigment') NOT NULL,
  `branch_id` int NOT NULL,
  `contact_id` int NOT NULL,
  `code` varchar(255) DEFAULT NULL,
  `date` date NOT NULL,
  `reference` varchar(50) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `status` enum('draft','open','waiting','done','cancelled') NOT NULL,
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_0b7c9f73c68f73999dea0e2bb54` (`branch_id`),
  CONSTRAINT `FK_0b7c9f73c68f73999dea0e2bb54` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.product_receivement: ~0 rows (approximately)
/*!40000 ALTER TABLE `product_receivement` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_receivement` ENABLE KEYS */;

-- Dumping structure for table phillip.product_receivement_item
CREATE TABLE IF NOT EXISTS `product_receivement_item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `product_receivement_id` int NOT NULL,
  `product_id` int NOT NULL,
  `variant_type_id` int DEFAULT NULL,
  `price` int NOT NULL,
  `qty` int NOT NULL,
  `qty_received` int DEFAULT NULL,
  `unit_of_measurement_id` int NOT NULL,
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_89689b29494126af253bebef0d7` (`product_receivement_id`),
  KEY `FK_94e91f93959f671f58c51d870b8` (`product_id`),
  KEY `FK_0e3c22cf08dfe126bbc2c09f96f` (`variant_type_id`),
  CONSTRAINT `FK_89689b29494126af253bebef0d7` FOREIGN KEY (`product_receivement_id`) REFERENCES `product_receivement` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_94e91f93959f671f58c51d870b8` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.product_receivement_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `product_receivement_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_receivement_item` ENABLE KEYS */;

-- Dumping structure for table phillip.product_shipment
CREATE TABLE IF NOT EXISTS `product_shipment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) DEFAULT NULL,
  `type` enum('general','return_consigment','internal_transfer','consigment') NOT NULL,
  `date` date NOT NULL,
  `contact_id` int NOT NULL,
  `branch_id` int NOT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `status` enum('draft','open','cancelled','waiting','done','confirmed') NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_d9fb75ee6eacf244c37031251e8` (`branch_id`),
  CONSTRAINT `FK_d9fb75ee6eacf244c37031251e8` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.product_shipment: ~0 rows (approximately)
/*!40000 ALTER TABLE `product_shipment` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_shipment` ENABLE KEYS */;

-- Dumping structure for table phillip.product_shipment_item
CREATE TABLE IF NOT EXISTS `product_shipment_item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `product_shipment_id` int DEFAULT NULL,
  `product_id` int NOT NULL,
  `type` enum('stock','reject') NOT NULL,
  `variant_id` int DEFAULT NULL,
  `qty` int NOT NULL,
  `qty_shipment` int DEFAULT NULL,
  `qty_additional_sent` int DEFAULT NULL,
  `qty_partial` int DEFAULT NULL,
  `qty_additional_received` int DEFAULT NULL,
  `uom_id` int NOT NULL,
  `price` int NOT NULL,
  `product_location` enum('stock','reject') NOT NULL,
  `variant_type_id` int DEFAULT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_9f73b8d44abb0223d3593a2f6e0` (`product_id`),
  KEY `FK_df16c2053c1e1c0ceaf84471cf6` (`product_shipment_id`),
  KEY `FK_a0b43b9ba05750c053fde959518` (`variant_type_id`),
  CONSTRAINT `FK_9f73b8d44abb0223d3593a2f6e0` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  CONSTRAINT `FK_a0b43b9ba05750c053fde959518` FOREIGN KEY (`variant_type_id`) REFERENCES `variant_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.product_shipment_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `product_shipment_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_shipment_item` ENABLE KEYS */;

-- Dumping structure for table phillip.product_variant_item
CREATE TABLE IF NOT EXISTS `product_variant_item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` int DEFAULT NULL,
  `variant_type_id` int NOT NULL,
  `barcode` varchar(255) NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_cb9f60fedce85794cc718170689` (`variant_type_id`),
  KEY `FK_5d8e620175d0972c6ebfb4e2e29` (`product_id`),
  FULLTEXT KEY `IDX_6f81c6ec80fc677f3410c8b7b0` (`barcode`),
  CONSTRAINT `FK_cb9f60fedce85794cc718170689` FOREIGN KEY (`variant_type_id`) REFERENCES `variant_type` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10002440 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.product_variant_item: ~2.439 rows (approximately)
/*!40000 ALTER TABLE `product_variant_item` DISABLE KEYS */;
INSERT INTO `product_variant_item` (`id`, `product_id`, `variant_type_id`, `barcode`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(10000001, 100001, 10000012, 'PW21A-AC100001BL-All', '2021-04-15 11:52:51.000000', '2021-04-15 11:52:51.000000', NULL),
	(10000002, 100002, 10000012, 'PW21A-AC100002YW -All', '2021-04-15 11:52:51.000001', '2021-04-15 11:52:51.000001', NULL),
	(10000003, 100003, 10000012, 'PW21A-AC100003BL-All', '2021-04-15 11:52:51.000002', '2021-04-15 11:52:51.000002', NULL),
	(10000004, 100004, 10000012, 'PW21A-AC100004BL-All', '2021-04-15 11:52:51.000003', '2021-04-15 11:52:51.000003', NULL),
	(10000005, 100005, 10000012, 'PW21A-AC100005BL-All', '2021-04-15 11:52:51.000004', '2021-04-15 11:52:51.000004', NULL),
	(10000006, 100006, 10000012, 'PW21A-AC100006BL-All', '2021-04-15 11:52:51.000005', '2021-04-15 11:52:51.000005', NULL),
	(10000007, 100007, 10000012, 'PW21A-AC100007BL-All', '2021-04-15 11:52:51.000006', '2021-04-15 11:52:51.000006', NULL),
	(10000008, 100008, 10000012, 'PW21A-AC100008BL-All', '2021-04-15 11:52:51.000007', '2021-04-15 11:52:51.000007', NULL),
	(10000009, 100009, 10000012, 'PW21A-AC100009BW-All', '2021-04-15 11:52:51.000008', '2021-04-15 11:52:51.000008', NULL),
	(10000010, 100010, 10000012, 'PW21A-AC100010MC-All', '2021-04-15 11:52:51.000009', '2021-04-15 11:52:51.000009', NULL),
	(10000011, 100011, 10000012, 'PW21A-AC100011OG-All', '2021-04-15 11:52:51.000010', '2021-04-15 11:52:51.000010', NULL),
	(10000012, 100012, 10000012, 'PW21A-AC100012BL-All', '2021-04-15 11:52:51.000011', '2021-04-15 11:52:51.000011', NULL),
	(10000013, 100013, 10000012, 'PW21A-AC100013OG-All', '2021-04-15 11:52:51.000012', '2021-04-15 11:52:51.000012', NULL),
	(10000014, 100014, 10000012, 'PW21A-AC100014OL-All', '2021-04-15 11:52:51.000013', '2021-04-15 11:52:51.000013', NULL),
	(10000015, 100015, 10000012, 'PW21A-AC100015MR-All', '2021-04-15 11:52:51.000014', '2021-04-15 11:52:51.000014', NULL),
	(10000016, 100016, 10000012, 'PW21A-AC100016BL-All', '2021-04-15 11:52:51.000015', '2021-04-15 11:52:51.000015', NULL),
	(10000017, 100017, 10000012, 'PW21A-AC100017BL-All', '2021-04-15 11:52:51.000016', '2021-04-15 11:52:51.000016', NULL),
	(10000018, 100018, 10000012, 'PW21A-BG100018WT-All', '2021-04-15 11:52:51.000017', '2021-04-15 11:52:51.000017', NULL),
	(10000019, 100019, 10000012, 'PW21A-BG100019BL-All', '2021-04-15 11:52:51.000018', '2021-04-15 11:52:51.000018', NULL),
	(10000020, 100020, 10000012, 'PW21A-BG100020BL-All', '2021-04-15 11:52:51.000019', '2021-04-15 11:52:51.000019', NULL),
	(10000021, 100021, 10000012, 'PW21A-BG100021BL-All', '2021-04-15 11:52:51.000020', '2021-04-15 11:52:51.000020', NULL),
	(10000022, 100022, 10000012, 'PW21A-BG100022BL-All', '2021-04-15 11:52:51.000021', '2021-04-15 11:52:51.000021', NULL),
	(10000023, 100023, 10000012, 'PW21A-BG100023BL-All', '2021-04-15 11:52:51.000022', '2021-04-15 11:52:51.000022', NULL),
	(10000024, 100024, 10000012, 'PW21A-BG100024BL-All', '2021-04-15 11:52:51.000023', '2021-04-15 11:52:51.000023', NULL),
	(10000025, 100025, 10000012, 'PW21A-BG100025BL-All', '2021-04-15 11:52:51.000024', '2021-04-15 11:52:51.000024', NULL),
	(10000026, 100026, 10000012, 'PW21A-BG100026CM-All', '2021-04-15 11:52:51.000025', '2021-04-15 11:52:51.000025', NULL),
	(10000027, 100027, 10000012, 'PW21A-BG100027CM-All', '2021-04-15 11:52:51.000026', '2021-04-15 11:52:51.000026', NULL),
	(10000028, 100028, 10000012, 'PW21A-BG100028CM-All', '2021-04-15 11:52:51.000027', '2021-04-15 11:52:51.000027', NULL),
	(10000029, 100029, 10000012, 'PW21A-BG100029CM-All', '2021-04-15 11:52:51.000028', '2021-04-15 11:52:51.000028', NULL),
	(10000030, 100030, 10000012, 'PW21A-BG100030BL-All', '2021-04-15 11:52:51.000029', '2021-04-15 11:52:51.000029', NULL),
	(10000031, 100031, 10000012, 'PW21A-BG100031BL-All', '2021-04-15 11:52:51.000030', '2021-04-15 11:52:51.000030', NULL),
	(10000032, 100032, 10000012, 'PW21A-BG100032BL-All', '2021-04-15 11:52:51.000031', '2021-04-15 11:52:51.000031', NULL),
	(10000033, 100033, 10000012, 'PW21A-BG100033BL-All', '2021-04-15 11:52:51.000032', '2021-04-15 11:52:51.000032', NULL),
	(10000034, 100034, 10000012, 'PW21A-BG100034BL-All', '2021-04-15 11:52:51.000033', '2021-04-15 11:52:51.000033', NULL),
	(10000035, 100035, 10000012, 'PW21A-BG100035BL-All', '2021-04-15 11:52:51.000034', '2021-04-15 11:52:51.000034', NULL),
	(10000036, 100036, 10000012, 'PW21A-BG100036BL-All', '2021-04-15 11:52:51.000035', '2021-04-15 11:52:51.000035', NULL),
	(10000037, 100037, 10000012, 'PW21A-BG100037OG-All', '2021-04-15 11:52:51.000036', '2021-04-15 11:52:51.000036', NULL),
	(10000038, 100038, 10000012, 'PW21A-BG100038BL-All', '2021-04-15 11:52:51.000037', '2021-04-15 11:52:51.000037', NULL),
	(10000039, 100039, 10000012, 'PW21A-BG100039GN-All', '2021-04-15 11:52:51.000038', '2021-04-15 11:52:51.000038', NULL),
	(10000040, 100040, 10000012, 'PW21A-BG100040WT-All', '2021-04-15 11:52:51.000039', '2021-04-15 11:52:51.000039', NULL),
	(10000041, 100041, 10000012, 'PW21A-BG100041BL-All', '2021-04-15 11:52:51.000040', '2021-04-15 11:52:51.000040', NULL),
	(10000042, 100042, 10000012, 'PW21A-BG100042BL-All', '2021-04-15 11:52:51.000041', '2021-04-15 11:52:51.000041', NULL),
	(10000043, 100043, 10000012, 'PW21A-BG100043BL-All', '2021-04-15 11:52:51.000042', '2021-04-15 11:52:51.000042', NULL),
	(10000044, 100044, 10000012, 'PW21A-BG100044BL-All', '2021-04-15 11:52:51.000043', '2021-04-15 11:52:51.000043', NULL),
	(10000045, 100045, 10000012, 'PW21A-BG100045BL-All', '2021-04-15 11:52:51.000044', '2021-04-15 11:52:51.000044', NULL),
	(10000046, 100046, 10000012, 'PW21A-BG100046BL-All', '2021-04-15 11:52:51.000045', '2021-04-15 11:52:51.000045', NULL),
	(10000047, 100047, 10000012, 'PW21A-BG100047BL-All', '2021-04-15 11:52:51.000046', '2021-04-15 11:52:51.000046', NULL),
	(10000048, 100048, 10000012, 'PW21A-BG100048BL-All', '2021-04-15 11:52:51.000047', '2021-04-15 11:52:51.000047', NULL),
	(10000049, 100049, 10000012, 'PW21A-BG100049BL-All', '2021-04-15 11:52:51.000048', '2021-04-15 11:52:51.000048', NULL),
	(10000050, 100050, 10000012, 'PW21A-BG100050BL-All', '2021-04-15 11:52:51.000049', '2021-04-15 11:52:51.000049', NULL),
	(10000051, 100051, 10000012, 'PW21A-BG100051BL-All', '2021-04-15 11:52:51.000050', '2021-04-15 11:52:51.000050', NULL),
	(10000052, 100052, 10000012, 'PW21A-BG100052BL-All', '2021-04-15 11:52:51.000051', '2021-04-15 11:52:51.000051', NULL),
	(10000053, 100053, 10000012, 'PW21A-BG100053BL-All', '2021-04-15 11:52:51.000052', '2021-04-15 11:52:51.000052', NULL),
	(10000054, 100054, 10000012, 'PW21A-BG100054BL-All', '2021-04-15 11:52:51.000053', '2021-04-15 11:52:51.000053', NULL),
	(10000055, 100055, 10000002, 'PW21A-GL100055YW -S', '2021-04-15 11:52:51.000054', '2021-04-15 11:52:51.000054', NULL),
	(10000056, 100055, 10000003, 'PW21A-GL100055YW -M', '2021-04-15 11:52:51.000055', '2021-04-15 11:52:51.000055', NULL),
	(10000057, 100055, 10000004, 'PW21A-GL100055YW -L', '2021-04-15 11:52:51.000056', '2021-04-15 11:52:51.000056', NULL),
	(10000058, 100055, 10000005, 'PW21A-GL100055YW -XL', '2021-04-15 11:52:51.000057', '2021-04-15 11:52:51.000057', NULL),
	(10000059, 100056, 10000002, 'PW21A-GL100056BW-S', '2021-04-15 11:52:51.000058', '2021-04-15 11:52:51.000058', NULL),
	(10000060, 100056, 10000003, 'PW21A-GL100056BW-M', '2021-04-15 11:52:51.000059', '2021-04-15 11:52:51.000059', NULL),
	(10000061, 100056, 10000004, 'PW21A-GL100056BW-L', '2021-04-15 11:52:51.000060', '2021-04-15 11:52:51.000060', NULL),
	(10000062, 100056, 10000005, 'PW21A-GL100056BW-XL', '2021-04-15 11:52:51.000061', '2021-04-15 11:52:51.000061', NULL),
	(10000063, 100057, 10000002, 'PW21A-GL100057CM-S', '2021-04-15 11:52:51.000062', '2021-04-15 11:52:51.000062', NULL),
	(10000064, 100057, 10000003, 'PW21A-GL100057CM-M', '2021-04-15 11:52:51.000063', '2021-04-15 11:52:51.000063', NULL),
	(10000065, 100057, 10000004, 'PW21A-GL100057CM-L', '2021-04-15 11:52:51.000064', '2021-04-15 11:52:51.000064', NULL),
	(10000066, 100057, 10000005, 'PW21A-GL100057CM-XL', '2021-04-15 11:52:51.000065', '2021-04-15 11:52:51.000065', NULL),
	(10000067, 100058, 10000002, 'PW21A-GL100058BW-S', '2021-04-15 11:52:51.000066', '2021-04-15 11:52:51.000066', NULL),
	(10000068, 100058, 10000003, 'PW21A-GL100058BW-M', '2021-04-15 11:52:51.000067', '2021-04-15 11:52:51.000067', NULL),
	(10000069, 100058, 10000004, 'PW21A-GL100058BW-L', '2021-04-15 11:52:51.000068', '2021-04-15 11:52:51.000068', NULL),
	(10000070, 100058, 10000005, 'PW21A-GL100058BW-XL', '2021-04-15 11:52:51.000069', '2021-04-15 11:52:51.000069', NULL),
	(10000071, 100059, 10000002, 'PW21A-GL100059BL-S', '2021-04-15 11:52:51.000070', '2021-04-15 11:52:51.000070', NULL),
	(10000072, 100059, 10000003, 'PW21A-GL100059BL-M', '2021-04-15 11:52:51.000071', '2021-04-15 11:52:51.000071', NULL),
	(10000073, 100059, 10000004, 'PW21A-GL100059BL-L', '2021-04-15 11:52:51.000072', '2021-04-15 11:52:51.000072', NULL),
	(10000074, 100059, 10000005, 'PW21A-GL100059BL-XL', '2021-04-15 11:52:51.000073', '2021-04-15 11:52:51.000073', NULL),
	(10000075, 100060, 10000002, 'PW21A-GL100060BL-S', '2021-04-15 11:52:51.000074', '2021-04-15 11:52:51.000074', NULL),
	(10000076, 100060, 10000003, 'PW21A-GL100060BL-M', '2021-04-15 11:52:51.000075', '2021-04-15 11:52:51.000075', NULL),
	(10000077, 100060, 10000004, 'PW21A-GL100060BL-L', '2021-04-15 11:52:51.000076', '2021-04-15 11:52:51.000076', NULL),
	(10000078, 100060, 10000005, 'PW21A-GL100060BL-XL', '2021-04-15 11:52:51.000077', '2021-04-15 11:52:51.000077', NULL),
	(10000079, 100061, 10000002, 'PW21A-GL100061RD-S', '2021-04-15 11:52:51.000078', '2021-04-15 11:52:51.000078', NULL),
	(10000080, 100061, 10000003, 'PW21A-GL100061RD-M', '2021-04-15 11:52:51.000079', '2021-04-15 11:52:51.000079', NULL),
	(10000081, 100061, 10000004, 'PW21A-GL100061RD-L', '2021-04-15 11:52:51.000080', '2021-04-15 11:52:51.000080', NULL),
	(10000082, 100061, 10000005, 'PW21A-GL100061RD-XL', '2021-04-15 11:52:51.000081', '2021-04-15 11:52:51.000081', NULL),
	(10000083, 100062, 10000002, 'PW21A-GL100062WT-S', '2021-04-15 11:52:51.000082', '2021-04-15 11:52:51.000082', NULL),
	(10000084, 100062, 10000003, 'PW21A-GL100062WT-M', '2021-04-15 11:52:51.000083', '2021-04-15 11:52:51.000083', NULL),
	(10000085, 100062, 10000004, 'PW21A-GL100062WT-L', '2021-04-15 11:52:51.000084', '2021-04-15 11:52:51.000084', NULL),
	(10000086, 100062, 10000005, 'PW21A-GL100062WT-XL', '2021-04-15 11:52:51.000085', '2021-04-15 11:52:51.000085', NULL),
	(10000087, 100063, 10000002, 'PW21A-GL100063BW-S', '2021-04-15 11:52:51.000086', '2021-04-15 11:52:51.000086', NULL),
	(10000088, 100063, 10000003, 'PW21A-GL100063BW-M', '2021-04-15 11:52:51.000087', '2021-04-15 11:52:51.000087', NULL),
	(10000089, 100063, 10000004, 'PW21A-GL100063BW-L', '2021-04-15 11:52:51.000088', '2021-04-15 11:52:51.000088', NULL),
	(10000090, 100063, 10000005, 'PW21A-GL100063BW-XL', '2021-04-15 11:52:51.000089', '2021-04-15 11:52:51.000089', NULL),
	(10000091, 100064, 10000002, 'PW21A-GL100064WT-S', '2021-04-15 11:52:51.000090', '2021-04-15 11:52:51.000090', NULL),
	(10000092, 100064, 10000003, 'PW21A-GL100064WT-M', '2021-04-15 11:52:51.000091', '2021-04-15 11:52:51.000091', NULL),
	(10000093, 100064, 10000004, 'PW21A-GL100064WT-L', '2021-04-15 11:52:51.000092', '2021-04-15 11:52:51.000092', NULL),
	(10000094, 100064, 10000005, 'PW21A-GL100064WT-XL', '2021-04-15 11:52:51.000093', '2021-04-15 11:52:51.000093', NULL),
	(10000095, 100065, 10000002, 'PW21A-GL100065BL-S', '2021-04-15 11:52:51.000094', '2021-04-15 11:52:51.000094', NULL),
	(10000096, 100065, 10000003, 'PW21A-GL100065BL-M', '2021-04-15 11:52:51.000095', '2021-04-15 11:52:51.000095', NULL),
	(10000097, 100065, 10000004, 'PW21A-GL100065BL-L', '2021-04-15 11:52:51.000096', '2021-04-15 11:52:51.000096', NULL),
	(10000098, 100065, 10000005, 'PW21A-GL100065BL-XL', '2021-04-15 11:52:51.000097', '2021-04-15 11:52:51.000097', NULL),
	(10000099, 100066, 10000002, 'PW21A-GL100066YW -S', '2021-04-15 11:52:51.000098', '2021-04-15 11:52:51.000098', NULL),
	(10000100, 100066, 10000003, 'PW21A-GL100066YW -M', '2021-04-15 11:52:51.000099', '2021-04-15 11:52:51.000099', NULL),
	(10000101, 100066, 10000004, 'PW21A-GL100066YW -L', '2021-04-15 11:52:51.000100', '2021-04-15 11:52:51.000100', NULL),
	(10000102, 100066, 10000005, 'PW21A-GL100066YW -XL', '2021-04-15 11:52:51.000101', '2021-04-15 11:52:51.000101', NULL),
	(10000103, 100067, 10000002, 'PW21A-GL100067BW-S', '2021-04-15 11:52:51.000102', '2021-04-15 11:52:51.000102', NULL),
	(10000104, 100067, 10000003, 'PW21A-GL100067BW-M', '2021-04-15 11:52:51.000103', '2021-04-15 11:52:51.000103', NULL),
	(10000105, 100067, 10000004, 'PW21A-GL100067BW-L', '2021-04-15 11:52:51.000104', '2021-04-15 11:52:51.000104', NULL),
	(10000106, 100067, 10000005, 'PW21A-GL100067BW-XL', '2021-04-15 11:52:51.000105', '2021-04-15 11:52:51.000105', NULL),
	(10000107, 100068, 10000012, 'PW21A-HT100068BL-All', '2021-04-15 11:52:51.000106', '2021-04-15 11:52:51.000106', NULL),
	(10000108, 100069, 10000012, 'PW21A-HT100069BL-All', '2021-04-15 11:52:51.000107', '2021-04-15 11:52:51.000107', NULL),
	(10000109, 100070, 10000012, 'PW21A-HT100070BL-All', '2021-04-15 11:52:51.000108', '2021-04-15 11:52:51.000108', NULL),
	(10000110, 100071, 10000012, 'PW21A-HT100071BL-All', '2021-04-15 11:52:51.000109', '2021-04-15 11:52:51.000109', NULL),
	(10000111, 100072, 10000012, 'PW21A-HT100072BL-All', '2021-04-15 11:52:51.000110', '2021-04-15 11:52:51.000110', NULL),
	(10000112, 100073, 10000012, 'PW21A-HT100073BL-All', '2021-04-15 11:52:51.000111', '2021-04-15 11:52:51.000111', NULL),
	(10000113, 100074, 10000012, 'PW21A-HT100074BL-All', '2021-04-15 11:52:51.000112', '2021-04-15 11:52:51.000112', NULL),
	(10000114, 100075, 10000012, 'PW21A-HT100075BL-All', '2021-04-15 11:52:51.000113', '2021-04-15 11:52:51.000113', NULL),
	(10000115, 100076, 10000012, 'PW21A-HT100076BL-All', '2021-04-15 11:52:51.000114', '2021-04-15 11:52:51.000114', NULL),
	(10000116, 100077, 10000012, 'PW21A-HT100077BL-All', '2021-04-15 11:52:51.000115', '2021-04-15 11:52:51.000115', NULL),
	(10000117, 100078, 10000012, 'PW21A-HT100078BL-All', '2021-04-15 11:52:51.000116', '2021-04-15 11:52:51.000116', NULL),
	(10000118, 100079, 10000012, 'PW21A-HT100079AR-All', '2021-04-15 11:52:51.000117', '2021-04-15 11:52:51.000117', NULL),
	(10000119, 100080, 10000012, 'PW21A-HT100080BL-All', '2021-04-15 11:52:51.000118', '2021-04-15 11:52:51.000118', NULL),
	(10000120, 100081, 10000012, 'PW21A-HT100081CM-All', '2021-04-15 11:52:51.000119', '2021-04-15 11:52:51.000119', NULL),
	(10000121, 100082, 10000012, 'PW21A-HT100082DS-All', '2021-04-15 11:52:51.000120', '2021-04-15 11:52:51.000120', NULL),
	(10000122, 100083, 10000012, 'PW21A-HT100083CM-All', '2021-04-15 11:52:51.000121', '2021-04-15 11:52:51.000121', NULL),
	(10000123, 100084, 10000012, 'PW21A-HT100084DS-All', '2021-04-15 11:52:51.000122', '2021-04-15 11:52:51.000122', NULL),
	(10000124, 100085, 10000012, 'PW21A-HT100085MR-All', '2021-04-15 11:52:51.000123', '2021-04-15 11:52:51.000123', NULL),
	(10000125, 100086, 10000012, 'PW21A-HT100086NV-All', '2021-04-15 11:52:51.000124', '2021-04-15 11:52:51.000124', NULL),
	(10000126, 100087, 10000012, 'PW21A-HT100087BL-All', '2021-04-15 11:52:51.000125', '2021-04-15 11:52:51.000125', NULL),
	(10000127, 100088, 10000012, 'PW21A-HT100088NV-All', '2021-04-15 11:52:51.000126', '2021-04-15 11:52:51.000126', NULL),
	(10000128, 100089, 10000012, 'PW21A-HT100089RD-All', '2021-04-15 11:52:51.000127', '2021-04-15 11:52:51.000127', NULL),
	(10000129, 100090, 10000012, 'PW21A-HT100090BL-All', '2021-04-15 11:52:51.000128', '2021-04-15 11:52:51.000128', NULL),
	(10000130, 100091, 10000012, 'PW21A-HT100091RD-All', '2021-04-15 11:52:51.000129', '2021-04-15 11:52:51.000129', NULL),
	(10000131, 100092, 10000001, 'PW21A-JK100092BL-XS', '2021-04-15 11:52:51.000130', '2021-04-15 11:52:51.000130', NULL),
	(10000132, 100092, 10000002, 'PW21A-JK100092BL-S', '2021-04-15 11:52:51.000131', '2021-04-15 11:52:51.000131', NULL),
	(10000133, 100092, 10000003, 'PW21A-JK100092BL-M', '2021-04-15 11:52:51.000132', '2021-04-15 11:52:51.000132', NULL),
	(10000134, 100092, 10000004, 'PW21A-JK100092BL-L', '2021-04-15 11:52:51.000133', '2021-04-15 11:52:51.000133', NULL),
	(10000135, 100092, 10000005, 'PW21A-JK100092BL-XL', '2021-04-15 11:52:51.000134', '2021-04-15 11:52:51.000134', NULL),
	(10000136, 100092, 10000006, 'PW21A-JK100092BL-XXL', '2021-04-15 11:52:51.000135', '2021-04-15 11:52:51.000135', NULL),
	(10000137, 100093, 10000001, 'PW21A-JK100093BL-XS', '2021-04-15 11:52:51.000136', '2021-04-15 11:52:51.000136', NULL),
	(10000138, 100093, 10000002, 'PW21A-JK100093BL-S', '2021-04-15 11:52:51.000137', '2021-04-15 11:52:51.000137', NULL),
	(10000139, 100093, 10000003, 'PW21A-JK100093BL-M', '2021-04-15 11:52:51.000138', '2021-04-15 11:52:51.000138', NULL),
	(10000140, 100093, 10000004, 'PW21A-JK100093BL-L', '2021-04-15 11:52:51.000139', '2021-04-15 11:52:51.000139', NULL),
	(10000141, 100093, 10000005, 'PW21A-JK100093BL-XL', '2021-04-15 11:52:51.000140', '2021-04-15 11:52:51.000140', NULL),
	(10000142, 100093, 10000006, 'PW21A-JK100093BL-XXL', '2021-04-15 11:52:51.000141', '2021-04-15 11:52:51.000141', NULL),
	(10000143, 100094, 10000001, 'PW21A-JK100094GY-XS', '2021-04-15 11:52:51.000142', '2021-04-15 11:52:51.000142', NULL),
	(10000144, 100094, 10000002, 'PW21A-JK100094GY-S', '2021-04-15 11:52:51.000143', '2021-04-15 11:52:51.000143', NULL),
	(10000145, 100094, 10000003, 'PW21A-JK100094GY-M', '2021-04-15 11:52:51.000144', '2021-04-15 11:52:51.000144', NULL),
	(10000146, 100094, 10000004, 'PW21A-JK100094GY-L', '2021-04-15 11:52:51.000145', '2021-04-15 11:52:51.000145', NULL),
	(10000147, 100094, 10000005, 'PW21A-JK100094GY-XL', '2021-04-15 11:52:51.000146', '2021-04-15 11:52:51.000146', NULL),
	(10000148, 100094, 10000006, 'PW21A-JK100094GY-XXL', '2021-04-15 11:52:51.000147', '2021-04-15 11:52:51.000147', NULL),
	(10000149, 100095, 10000001, 'PW21A-JK100095AR-XS', '2021-04-15 11:52:51.000148', '2021-04-15 11:52:51.000148', NULL),
	(10000150, 100095, 10000002, 'PW21A-JK100095AR-S', '2021-04-15 11:52:51.000149', '2021-04-15 11:52:51.000149', NULL),
	(10000151, 100095, 10000003, 'PW21A-JK100095AR-M', '2021-04-15 11:52:51.000150', '2021-04-15 11:52:51.000150', NULL),
	(10000152, 100095, 10000004, 'PW21A-JK100095AR-L', '2021-04-15 11:52:51.000151', '2021-04-15 11:52:51.000151', NULL),
	(10000153, 100095, 10000005, 'PW21A-JK100095AR-XL', '2021-04-15 11:52:51.000152', '2021-04-15 11:52:51.000152', NULL),
	(10000154, 100095, 10000006, 'PW21A-JK100095AR-XXL', '2021-04-15 11:52:51.000153', '2021-04-15 11:52:51.000153', NULL),
	(10000155, 100096, 10000001, 'PW21A-JK100096BL-XS', '2021-04-15 11:52:51.000154', '2021-04-15 11:52:51.000154', NULL),
	(10000156, 100096, 10000002, 'PW21A-JK100096BL-S', '2021-04-15 11:52:51.000155', '2021-04-15 11:52:51.000155', NULL),
	(10000157, 100096, 10000003, 'PW21A-JK100096BL-M', '2021-04-15 11:52:51.000156', '2021-04-15 11:52:51.000156', NULL),
	(10000158, 100096, 10000004, 'PW21A-JK100096BL-L', '2021-04-15 11:52:51.000157', '2021-04-15 11:52:51.000157', NULL),
	(10000159, 100096, 10000005, 'PW21A-JK100096BL-XL', '2021-04-15 11:52:51.000158', '2021-04-15 11:52:51.000158', NULL),
	(10000160, 100096, 10000006, 'PW21A-JK100096BL-XXL', '2021-04-15 11:52:51.000159', '2021-04-15 11:52:51.000159', NULL),
	(10000161, 100097, 10000001, 'PW21A-JK100097WT-XS', '2021-04-15 11:52:51.000160', '2021-04-15 11:52:51.000160', NULL),
	(10000162, 100097, 10000002, 'PW21A-JK100097WT-S', '2021-04-15 11:52:51.000161', '2021-04-15 11:52:51.000161', NULL),
	(10000163, 100097, 10000003, 'PW21A-JK100097WT-M', '2021-04-15 11:52:51.000162', '2021-04-15 11:52:51.000162', NULL),
	(10000164, 100097, 10000004, 'PW21A-JK100097WT-L', '2021-04-15 11:52:51.000163', '2021-04-15 11:52:51.000163', NULL),
	(10000165, 100097, 10000005, 'PW21A-JK100097WT-XL', '2021-04-15 11:52:51.000164', '2021-04-15 11:52:51.000164', NULL),
	(10000166, 100097, 10000006, 'PW21A-JK100097WT-XXL', '2021-04-15 11:52:51.000165', '2021-04-15 11:52:51.000165', NULL),
	(10000167, 100098, 10000001, 'PW21A-JK100098BL-XS', '2021-04-15 11:52:51.000166', '2021-04-15 11:52:51.000166', NULL),
	(10000168, 100098, 10000002, 'PW21A-JK100098BL-S', '2021-04-15 11:52:51.000167', '2021-04-15 11:52:51.000167', NULL),
	(10000169, 100098, 10000003, 'PW21A-JK100098BL-M', '2021-04-15 11:52:51.000168', '2021-04-15 11:52:51.000168', NULL),
	(10000170, 100098, 10000004, 'PW21A-JK100098BL-L', '2021-04-15 11:52:51.000169', '2021-04-15 11:52:51.000169', NULL),
	(10000171, 100098, 10000005, 'PW21A-JK100098BL-XL', '2021-04-15 11:52:51.000170', '2021-04-15 11:52:51.000170', NULL),
	(10000172, 100098, 10000006, 'PW21A-JK100098BL-XXL', '2021-04-15 11:52:51.000171', '2021-04-15 11:52:51.000171', NULL),
	(10000173, 100099, 10000001, 'PW21A-JK100099BL-XS', '2021-04-15 11:52:51.000172', '2021-04-15 11:52:51.000172', NULL),
	(10000174, 100099, 10000002, 'PW21A-JK100099BL-S', '2021-04-15 11:52:51.000173', '2021-04-15 11:52:51.000173', NULL),
	(10000175, 100099, 10000003, 'PW21A-JK100099BL-M', '2021-04-15 11:52:51.000174', '2021-04-15 11:52:51.000174', NULL),
	(10000176, 100099, 10000004, 'PW21A-JK100099BL-L', '2021-04-15 11:52:51.000175', '2021-04-15 11:52:51.000175', NULL),
	(10000177, 100099, 10000005, 'PW21A-JK100099BL-XL', '2021-04-15 11:52:51.000176', '2021-04-15 11:52:51.000176', NULL),
	(10000178, 100099, 10000006, 'PW21A-JK100099BL-XXL', '2021-04-15 11:52:51.000177', '2021-04-15 11:52:51.000177', NULL),
	(10000179, 100100, 10000001, 'PW21A-JK100100DM-XS', '2021-04-15 11:52:51.000178', '2021-04-15 11:52:51.000178', NULL),
	(10000180, 100100, 10000002, 'PW21A-JK100100DM-S', '2021-04-15 11:52:51.000179', '2021-04-15 11:52:51.000179', NULL),
	(10000181, 100100, 10000003, 'PW21A-JK100100DM-M', '2021-04-15 11:52:51.000180', '2021-04-15 11:52:51.000180', NULL),
	(10000182, 100100, 10000004, 'PW21A-JK100100DM-L', '2021-04-15 11:52:51.000181', '2021-04-15 11:52:51.000181', NULL),
	(10000183, 100100, 10000005, 'PW21A-JK100100DM-XL', '2021-04-15 11:52:51.000182', '2021-04-15 11:52:51.000182', NULL),
	(10000184, 100100, 10000006, 'PW21A-JK100100DM-XXL', '2021-04-15 11:52:51.000183', '2021-04-15 11:52:51.000183', NULL),
	(10000185, 100101, 10000001, 'PW21A-JK100101NV-XS', '2021-04-15 11:52:51.000184', '2021-04-15 11:52:51.000184', NULL),
	(10000186, 100101, 10000002, 'PW21A-JK100101NV-S', '2021-04-15 11:52:51.000185', '2021-04-15 11:52:51.000185', NULL),
	(10000187, 100101, 10000003, 'PW21A-JK100101NV-M', '2021-04-15 11:52:51.000186', '2021-04-15 11:52:51.000186', NULL),
	(10000188, 100101, 10000004, 'PW21A-JK100101NV-L', '2021-04-15 11:52:51.000187', '2021-04-15 11:52:51.000187', NULL),
	(10000189, 100101, 10000005, 'PW21A-JK100101NV-XL', '2021-04-15 11:52:51.000188', '2021-04-15 11:52:51.000188', NULL),
	(10000190, 100101, 10000006, 'PW21A-JK100101NV-XXL', '2021-04-15 11:52:51.000189', '2021-04-15 11:52:51.000189', NULL),
	(10000191, 100102, 10000001, 'PW21A-JK100102BW-XS', '2021-04-15 11:52:51.000190', '2021-04-15 11:52:51.000190', NULL),
	(10000192, 100102, 10000002, 'PW21A-JK100102BW-S', '2021-04-15 11:52:51.000191', '2021-04-15 11:52:51.000191', NULL),
	(10000193, 100102, 10000003, 'PW21A-JK100102BW-M', '2021-04-15 11:52:51.000192', '2021-04-15 11:52:51.000192', NULL),
	(10000194, 100102, 10000004, 'PW21A-JK100102BW-L', '2021-04-15 11:52:51.000193', '2021-04-15 11:52:51.000193', NULL),
	(10000195, 100102, 10000005, 'PW21A-JK100102BW-XL', '2021-04-15 11:52:51.000194', '2021-04-15 11:52:51.000194', NULL),
	(10000196, 100102, 10000006, 'PW21A-JK100102BW-XXL', '2021-04-15 11:52:51.000195', '2021-04-15 11:52:51.000195', NULL),
	(10000197, 100103, 10000001, 'PW21A-JK100103BL-XS', '2021-04-15 11:52:51.000196', '2021-04-15 11:52:51.000196', NULL),
	(10000198, 100103, 10000002, 'PW21A-JK100103BL-S', '2021-04-15 11:52:51.000197', '2021-04-15 11:52:51.000197', NULL),
	(10000199, 100103, 10000003, 'PW21A-JK100103BL-M', '2021-04-15 11:52:51.000198', '2021-04-15 11:52:51.000198', NULL),
	(10000200, 100103, 10000004, 'PW21A-JK100103BL-L', '2021-04-15 11:52:51.000199', '2021-04-15 11:52:51.000199', NULL),
	(10000201, 100103, 10000005, 'PW21A-JK100103BL-XL', '2021-04-15 11:52:51.000200', '2021-04-15 11:52:51.000200', NULL),
	(10000202, 100103, 10000006, 'PW21A-JK100103BL-XXL', '2021-04-15 11:52:51.000201', '2021-04-15 11:52:51.000201', NULL),
	(10000203, 100104, 10000001, 'PW21A-JK100104BL-XS', '2021-04-15 11:52:51.000202', '2021-04-15 11:52:51.000202', NULL),
	(10000204, 100104, 10000002, 'PW21A-JK100104BL-S', '2021-04-15 11:52:51.000203', '2021-04-15 11:52:51.000203', NULL),
	(10000205, 100104, 10000003, 'PW21A-JK100104BL-M', '2021-04-15 11:52:51.000204', '2021-04-15 11:52:51.000204', NULL),
	(10000206, 100104, 10000004, 'PW21A-JK100104BL-L', '2021-04-15 11:52:51.000205', '2021-04-15 11:52:51.000205', NULL),
	(10000207, 100104, 10000005, 'PW21A-JK100104BL-XL', '2021-04-15 11:52:51.000206', '2021-04-15 11:52:51.000206', NULL),
	(10000208, 100104, 10000006, 'PW21A-JK100104BL-XXL', '2021-04-15 11:52:51.000207', '2021-04-15 11:52:51.000207', NULL),
	(10000209, 100105, 10000001, 'PW21A-JK100105TC-XS', '2021-04-15 11:52:51.000208', '2021-04-15 11:52:51.000208', NULL),
	(10000210, 100105, 10000002, 'PW21A-JK100105TC-S', '2021-04-15 11:52:51.000209', '2021-04-15 11:52:51.000209', NULL),
	(10000211, 100105, 10000003, 'PW21A-JK100105TC-M', '2021-04-15 11:52:51.000210', '2021-04-15 11:52:51.000210', NULL),
	(10000212, 100105, 10000004, 'PW21A-JK100105TC-L', '2021-04-15 11:52:51.000211', '2021-04-15 11:52:51.000211', NULL),
	(10000213, 100105, 10000005, 'PW21A-JK100105TC-XL', '2021-04-15 11:52:51.000212', '2021-04-15 11:52:51.000212', NULL),
	(10000214, 100105, 10000006, 'PW21A-JK100105TC-XXL', '2021-04-15 11:52:51.000213', '2021-04-15 11:52:51.000213', NULL),
	(10000215, 100106, 10000001, 'PW21A-JK100106BL-XS', '2021-04-15 11:52:51.000214', '2021-04-15 11:52:51.000214', NULL),
	(10000216, 100106, 10000002, 'PW21A-JK100106BL-S', '2021-04-15 11:52:51.000215', '2021-04-15 11:52:51.000215', NULL),
	(10000217, 100106, 10000003, 'PW21A-JK100106BL-M', '2021-04-15 11:52:51.000216', '2021-04-15 11:52:51.000216', NULL),
	(10000218, 100106, 10000004, 'PW21A-JK100106BL-L', '2021-04-15 11:52:51.000217', '2021-04-15 11:52:51.000217', NULL),
	(10000219, 100106, 10000005, 'PW21A-JK100106BL-XL', '2021-04-15 11:52:51.000218', '2021-04-15 11:52:51.000218', NULL),
	(10000220, 100106, 10000006, 'PW21A-JK100106BL-XXL', '2021-04-15 11:52:51.000219', '2021-04-15 11:52:51.000219', NULL),
	(10000221, 100107, 10000001, 'PW21A-JK100107BL-XS', '2021-04-15 11:52:51.000220', '2021-04-15 11:52:51.000220', NULL),
	(10000222, 100107, 10000002, 'PW21A-JK100107BL-S', '2021-04-15 11:52:51.000221', '2021-04-15 11:52:51.000221', NULL),
	(10000223, 100107, 10000003, 'PW21A-JK100107BL-M', '2021-04-15 11:52:51.000222', '2021-04-15 11:52:51.000222', NULL),
	(10000224, 100107, 10000004, 'PW21A-JK100107BL-L', '2021-04-15 11:52:51.000223', '2021-04-15 11:52:51.000223', NULL),
	(10000225, 100107, 10000005, 'PW21A-JK100107BL-XL', '2021-04-15 11:52:51.000224', '2021-04-15 11:52:51.000224', NULL),
	(10000226, 100107, 10000006, 'PW21A-JK100107BL-XXL', '2021-04-15 11:52:51.000225', '2021-04-15 11:52:51.000225', NULL),
	(10000227, 100108, 10000001, 'PW21A-JK100108BL-XS', '2021-04-15 11:52:51.000226', '2021-04-15 11:52:51.000226', NULL),
	(10000228, 100108, 10000002, 'PW21A-JK100108BL-S', '2021-04-15 11:52:51.000227', '2021-04-15 11:52:51.000227', NULL),
	(10000229, 100108, 10000003, 'PW21A-JK100108BL-M', '2021-04-15 11:52:51.000228', '2021-04-15 11:52:51.000228', NULL),
	(10000230, 100108, 10000004, 'PW21A-JK100108BL-L', '2021-04-15 11:52:51.000229', '2021-04-15 11:52:51.000229', NULL),
	(10000231, 100108, 10000005, 'PW21A-JK100108BL-XL', '2021-04-15 11:52:51.000230', '2021-04-15 11:52:51.000230', NULL),
	(10000232, 100108, 10000006, 'PW21A-JK100108BL-XXL', '2021-04-15 11:52:51.000231', '2021-04-15 11:52:51.000231', NULL),
	(10000233, 100109, 10000001, 'PW21A-JK100109BL-XS', '2021-04-15 11:52:51.000232', '2021-04-15 11:52:51.000232', NULL),
	(10000234, 100109, 10000002, 'PW21A-JK100109BL-S', '2021-04-15 11:52:51.000233', '2021-04-15 11:52:51.000233', NULL),
	(10000235, 100109, 10000003, 'PW21A-JK100109BL-M', '2021-04-15 11:52:51.000234', '2021-04-15 11:52:51.000234', NULL),
	(10000236, 100109, 10000004, 'PW21A-JK100109BL-L', '2021-04-15 11:52:51.000235', '2021-04-15 11:52:51.000235', NULL),
	(10000237, 100109, 10000005, 'PW21A-JK100109BL-XL', '2021-04-15 11:52:51.000236', '2021-04-15 11:52:51.000236', NULL),
	(10000238, 100109, 10000006, 'PW21A-JK100109BL-XXL', '2021-04-15 11:52:51.000237', '2021-04-15 11:52:51.000237', NULL),
	(10000239, 100110, 10000001, 'PW21A-JK100110BL-XS', '2021-04-15 11:52:51.000238', '2021-04-15 11:52:51.000238', NULL),
	(10000240, 100110, 10000002, 'PW21A-JK100110BL-S', '2021-04-15 11:52:51.000239', '2021-04-15 11:52:51.000239', NULL),
	(10000241, 100110, 10000003, 'PW21A-JK100110BL-M', '2021-04-15 11:52:51.000240', '2021-04-15 11:52:51.000240', NULL),
	(10000242, 100110, 10000004, 'PW21A-JK100110BL-L', '2021-04-15 11:52:51.000241', '2021-04-15 11:52:51.000241', NULL),
	(10000243, 100110, 10000005, 'PW21A-JK100110BL-XL', '2021-04-15 11:52:51.000242', '2021-04-15 11:52:51.000242', NULL),
	(10000244, 100110, 10000006, 'PW21A-JK100110BL-XXL', '2021-04-15 11:52:51.000243', '2021-04-15 11:52:51.000243', NULL),
	(10000245, 100111, 10000001, 'PW21A-JK100111BL-XS', '2021-04-15 11:52:51.000244', '2021-04-15 11:52:51.000244', NULL),
	(10000246, 100111, 10000002, 'PW21A-JK100111BL-S', '2021-04-15 11:52:51.000245', '2021-04-15 11:52:51.000245', NULL),
	(10000247, 100111, 10000003, 'PW21A-JK100111BL-M', '2021-04-15 11:52:51.000246', '2021-04-15 11:52:51.000246', NULL),
	(10000248, 100111, 10000004, 'PW21A-JK100111BL-L', '2021-04-15 11:52:51.000247', '2021-04-15 11:52:51.000247', NULL),
	(10000249, 100111, 10000005, 'PW21A-JK100111BL-XL', '2021-04-15 11:52:51.000248', '2021-04-15 11:52:51.000248', NULL),
	(10000250, 100111, 10000006, 'PW21A-JK100111BL-XXL', '2021-04-15 11:52:51.000249', '2021-04-15 11:52:51.000249', NULL),
	(10000251, 100112, 10000001, 'PW21A-JK100112CM-XS', '2021-04-15 11:52:51.000250', '2021-04-15 11:52:51.000250', NULL),
	(10000252, 100112, 10000002, 'PW21A-JK100112CM-S', '2021-04-15 11:52:51.000251', '2021-04-15 11:52:51.000251', NULL),
	(10000253, 100112, 10000003, 'PW21A-JK100112CM-M', '2021-04-15 11:52:51.000252', '2021-04-15 11:52:51.000252', NULL),
	(10000254, 100112, 10000004, 'PW21A-JK100112CM-L', '2021-04-15 11:52:51.000253', '2021-04-15 11:52:51.000253', NULL),
	(10000255, 100112, 10000005, 'PW21A-JK100112CM-XL', '2021-04-15 11:52:51.000254', '2021-04-15 11:52:51.000254', NULL),
	(10000256, 100112, 10000006, 'PW21A-JK100112CM-XXL', '2021-04-15 11:52:51.000255', '2021-04-15 11:52:51.000255', NULL),
	(10000257, 100113, 10000001, 'PW21A-JK100113CM-XS', '2021-04-15 11:52:51.000256', '2021-04-15 11:52:51.000256', NULL),
	(10000258, 100113, 10000002, 'PW21A-JK100113CM-S', '2021-04-15 11:52:51.000257', '2021-04-15 11:52:51.000257', NULL),
	(10000259, 100113, 10000003, 'PW21A-JK100113CM-M', '2021-04-15 11:52:51.000258', '2021-04-15 11:52:51.000258', NULL),
	(10000260, 100113, 10000004, 'PW21A-JK100113CM-L', '2021-04-15 11:52:51.000259', '2021-04-15 11:52:51.000259', NULL),
	(10000261, 100113, 10000005, 'PW21A-JK100113CM-XL', '2021-04-15 11:52:51.000260', '2021-04-15 11:52:51.000260', NULL),
	(10000262, 100113, 10000006, 'PW21A-JK100113CM-XXL', '2021-04-15 11:52:51.000261', '2021-04-15 11:52:51.000261', NULL),
	(10000263, 100114, 10000001, 'PW21A-JK100114CM-XS', '2021-04-15 11:52:51.000262', '2021-04-15 11:52:51.000262', NULL),
	(10000264, 100114, 10000002, 'PW21A-JK100114CM-S', '2021-04-15 11:52:51.000263', '2021-04-15 11:52:51.000263', NULL),
	(10000265, 100114, 10000003, 'PW21A-JK100114CM-M', '2021-04-15 11:52:51.000264', '2021-04-15 11:52:51.000264', NULL),
	(10000266, 100114, 10000004, 'PW21A-JK100114CM-L', '2021-04-15 11:52:51.000265', '2021-04-15 11:52:51.000265', NULL),
	(10000267, 100114, 10000005, 'PW21A-JK100114CM-XL', '2021-04-15 11:52:51.000266', '2021-04-15 11:52:51.000266', NULL),
	(10000268, 100114, 10000006, 'PW21A-JK100114CM-XXL', '2021-04-15 11:52:51.000267', '2021-04-15 11:52:51.000267', NULL),
	(10000269, 100115, 10000001, 'PW21A-JK100115DM-XS', '2021-04-15 11:52:51.000268', '2021-04-15 11:52:51.000268', NULL),
	(10000270, 100115, 10000002, 'PW21A-JK100115DM-S', '2021-04-15 11:52:51.000269', '2021-04-15 11:52:51.000269', NULL),
	(10000271, 100115, 10000003, 'PW21A-JK100115DM-M', '2021-04-15 11:52:51.000270', '2021-04-15 11:52:51.000270', NULL),
	(10000272, 100115, 10000004, 'PW21A-JK100115DM-L', '2021-04-15 11:52:51.000271', '2021-04-15 11:52:51.000271', NULL),
	(10000273, 100115, 10000005, 'PW21A-JK100115DM-XL', '2021-04-15 11:52:51.000272', '2021-04-15 11:52:51.000272', NULL),
	(10000274, 100115, 10000006, 'PW21A-JK100115DM-XXL', '2021-04-15 11:52:51.000273', '2021-04-15 11:52:51.000273', NULL),
	(10000275, 100116, 10000001, 'PW21A-JK100116RD-XS', '2021-04-15 11:52:51.000274', '2021-04-15 11:52:51.000274', NULL),
	(10000276, 100116, 10000002, 'PW21A-JK100116RD-S', '2021-04-15 11:52:51.000275', '2021-04-15 11:52:51.000275', NULL),
	(10000277, 100116, 10000003, 'PW21A-JK100116RD-M', '2021-04-15 11:52:51.000276', '2021-04-15 11:52:51.000276', NULL),
	(10000278, 100116, 10000004, 'PW21A-JK100116RD-L', '2021-04-15 11:52:51.000277', '2021-04-15 11:52:51.000277', NULL),
	(10000279, 100116, 10000005, 'PW21A-JK100116RD-XL', '2021-04-15 11:52:51.000278', '2021-04-15 11:52:51.000278', NULL),
	(10000280, 100116, 10000006, 'PW21A-JK100116RD-XXL', '2021-04-15 11:52:51.000279', '2021-04-15 11:52:51.000279', NULL),
	(10000281, 100117, 10000001, 'PW21A-JK100117BL-XS', '2021-04-15 11:52:51.000280', '2021-04-15 11:52:51.000280', NULL),
	(10000282, 100117, 10000002, 'PW21A-JK100117BL-S', '2021-04-15 11:52:51.000281', '2021-04-15 11:52:51.000281', NULL),
	(10000283, 100117, 10000003, 'PW21A-JK100117BL-M', '2021-04-15 11:52:51.000282', '2021-04-15 11:52:51.000282', NULL),
	(10000284, 100117, 10000004, 'PW21A-JK100117BL-L', '2021-04-15 11:52:51.000283', '2021-04-15 11:52:51.000283', NULL),
	(10000285, 100117, 10000005, 'PW21A-JK100117BL-XL', '2021-04-15 11:52:51.000284', '2021-04-15 11:52:51.000284', NULL),
	(10000286, 100117, 10000006, 'PW21A-JK100117BL-XXL', '2021-04-15 11:52:51.000285', '2021-04-15 11:52:51.000285', NULL),
	(10000287, 100118, 10000001, 'PW21A-JK100118AR-XS', '2021-04-15 11:52:51.000286', '2021-04-15 11:52:51.000286', NULL),
	(10000288, 100118, 10000002, 'PW21A-JK100118AR-S', '2021-04-15 11:52:51.000287', '2021-04-15 11:52:51.000287', NULL),
	(10000289, 100118, 10000003, 'PW21A-JK100118AR-M', '2021-04-15 11:52:51.000288', '2021-04-15 11:52:51.000288', NULL),
	(10000290, 100118, 10000004, 'PW21A-JK100118AR-L', '2021-04-15 11:52:51.000289', '2021-04-15 11:52:51.000289', NULL),
	(10000291, 100118, 10000005, 'PW21A-JK100118AR-XL', '2021-04-15 11:52:51.000290', '2021-04-15 11:52:51.000290', NULL),
	(10000292, 100118, 10000006, 'PW21A-JK100118AR-XXL', '2021-04-15 11:52:51.000291', '2021-04-15 11:52:51.000291', NULL),
	(10000293, 100119, 10000001, 'PW21A-JK100119BL-XS', '2021-04-15 11:52:51.000292', '2021-04-15 11:52:51.000292', NULL),
	(10000294, 100119, 10000002, 'PW21A-JK100119BL-S', '2021-04-15 11:52:51.000293', '2021-04-15 11:52:51.000293', NULL),
	(10000295, 100119, 10000003, 'PW21A-JK100119BL-M', '2021-04-15 11:52:51.000294', '2021-04-15 11:52:51.000294', NULL),
	(10000296, 100119, 10000004, 'PW21A-JK100119BL-L', '2021-04-15 11:52:51.000295', '2021-04-15 11:52:51.000295', NULL),
	(10000297, 100119, 10000005, 'PW21A-JK100119BL-XL', '2021-04-15 11:52:51.000296', '2021-04-15 11:52:51.000296', NULL),
	(10000298, 100119, 10000006, 'PW21A-JK100119BL-XXL', '2021-04-15 11:52:51.000297', '2021-04-15 11:52:51.000297', NULL),
	(10000299, 100120, 10000001, 'PW21A-JK100120BL-XS', '2021-04-15 11:52:51.000298', '2021-04-15 11:52:51.000298', NULL),
	(10000300, 100120, 10000002, 'PW21A-JK100120BL-S', '2021-04-15 11:52:51.000299', '2021-04-15 11:52:51.000299', NULL),
	(10000301, 100120, 10000003, 'PW21A-JK100120BL-M', '2021-04-15 11:52:51.000300', '2021-04-15 11:52:51.000300', NULL),
	(10000302, 100120, 10000004, 'PW21A-JK100120BL-L', '2021-04-15 11:52:51.000301', '2021-04-15 11:52:51.000301', NULL),
	(10000303, 100120, 10000005, 'PW21A-JK100120BL-XL', '2021-04-15 11:52:51.000302', '2021-04-15 11:52:51.000302', NULL),
	(10000304, 100120, 10000006, 'PW21A-JK100120BL-XXL', '2021-04-15 11:52:51.000303', '2021-04-15 11:52:51.000303', NULL),
	(10000305, 100121, 10000001, 'PW21A-JK100121MR-XS', '2021-04-15 11:52:51.000304', '2021-04-15 11:52:51.000304', NULL),
	(10000306, 100121, 10000002, 'PW21A-JK100121MR-S', '2021-04-15 11:52:51.000305', '2021-04-15 11:52:51.000305', NULL),
	(10000307, 100121, 10000003, 'PW21A-JK100121MR-M', '2021-04-15 11:52:51.000306', '2021-04-15 11:52:51.000306', NULL),
	(10000308, 100121, 10000004, 'PW21A-JK100121MR-L', '2021-04-15 11:52:51.000307', '2021-04-15 11:52:51.000307', NULL),
	(10000309, 100121, 10000005, 'PW21A-JK100121MR-XL', '2021-04-15 11:52:51.000308', '2021-04-15 11:52:51.000308', NULL),
	(10000310, 100121, 10000006, 'PW21A-JK100121MR-XXL', '2021-04-15 11:52:51.000309', '2021-04-15 11:52:51.000309', NULL),
	(10000311, 100122, 10000001, 'PW21A-JK100122RD-XS', '2021-04-15 11:52:51.000310', '2021-04-15 11:52:51.000310', NULL),
	(10000312, 100122, 10000002, 'PW21A-JK100122RD-S', '2021-04-15 11:52:51.000311', '2021-04-15 11:52:51.000311', NULL),
	(10000313, 100122, 10000003, 'PW21A-JK100122RD-M', '2021-04-15 11:52:51.000312', '2021-04-15 11:52:51.000312', NULL),
	(10000314, 100122, 10000004, 'PW21A-JK100122RD-L', '2021-04-15 11:52:51.000313', '2021-04-15 11:52:51.000313', NULL),
	(10000315, 100122, 10000005, 'PW21A-JK100122RD-XL', '2021-04-15 11:52:51.000314', '2021-04-15 11:52:51.000314', NULL),
	(10000316, 100122, 10000006, 'PW21A-JK100122RD-XXL', '2021-04-15 11:52:51.000315', '2021-04-15 11:52:51.000315', NULL),
	(10000317, 100123, 10000001, 'PW21A-JK100123BL-XS', '2021-04-15 11:52:51.000316', '2021-04-15 11:52:51.000316', NULL),
	(10000318, 100123, 10000002, 'PW21A-JK100123BL-S', '2021-04-15 11:52:51.000317', '2021-04-15 11:52:51.000317', NULL),
	(10000319, 100123, 10000003, 'PW21A-JK100123BL-M', '2021-04-15 11:52:51.000318', '2021-04-15 11:52:51.000318', NULL),
	(10000320, 100123, 10000004, 'PW21A-JK100123BL-L', '2021-04-15 11:52:51.000319', '2021-04-15 11:52:51.000319', NULL),
	(10000321, 100123, 10000005, 'PW21A-JK100123BL-XL', '2021-04-15 11:52:51.000320', '2021-04-15 11:52:51.000320', NULL),
	(10000322, 100123, 10000006, 'PW21A-JK100123BL-XXL', '2021-04-15 11:52:51.000321', '2021-04-15 11:52:51.000321', NULL),
	(10000323, 100124, 10000001, 'PW21A-JK100124BL-XS', '2021-04-15 11:52:51.000322', '2021-04-15 11:52:51.000322', NULL),
	(10000324, 100124, 10000002, 'PW21A-JK100124BL-S', '2021-04-15 11:52:51.000323', '2021-04-15 11:52:51.000323', NULL),
	(10000325, 100124, 10000003, 'PW21A-JK100124BL-M', '2021-04-15 11:52:51.000324', '2021-04-15 11:52:51.000324', NULL),
	(10000326, 100124, 10000004, 'PW21A-JK100124BL-L', '2021-04-15 11:52:51.000325', '2021-04-15 11:52:51.000325', NULL),
	(10000327, 100124, 10000005, 'PW21A-JK100124BL-XL', '2021-04-15 11:52:51.000326', '2021-04-15 11:52:51.000326', NULL),
	(10000328, 100124, 10000006, 'PW21A-JK100124BL-XXL', '2021-04-15 11:52:51.000327', '2021-04-15 11:52:51.000327', NULL),
	(10000329, 100125, 10000001, 'PW21A-JK100125AR-XS', '2021-04-15 11:52:51.000328', '2021-04-15 11:52:51.000328', NULL),
	(10000330, 100125, 10000002, 'PW21A-JK100125AR-S', '2021-04-15 11:52:51.000329', '2021-04-15 11:52:51.000329', NULL),
	(10000331, 100125, 10000003, 'PW21A-JK100125AR-M', '2021-04-15 11:52:51.000330', '2021-04-15 11:52:51.000330', NULL),
	(10000332, 100125, 10000004, 'PW21A-JK100125AR-L', '2021-04-15 11:52:51.000331', '2021-04-15 11:52:51.000331', NULL),
	(10000333, 100125, 10000005, 'PW21A-JK100125AR-XL', '2021-04-15 11:52:51.000332', '2021-04-15 11:52:51.000332', NULL),
	(10000334, 100125, 10000006, 'PW21A-JK100125AR-XXL', '2021-04-15 11:52:51.000333', '2021-04-15 11:52:51.000333', NULL),
	(10000335, 100126, 10000001, 'PW21A-JK100126BL-XS', '2021-04-15 11:52:51.000334', '2021-04-15 11:52:51.000334', NULL),
	(10000336, 100126, 10000002, 'PW21A-JK100126BL-S', '2021-04-15 11:52:51.000335', '2021-04-15 11:52:51.000335', NULL),
	(10000337, 100126, 10000003, 'PW21A-JK100126BL-M', '2021-04-15 11:52:51.000336', '2021-04-15 11:52:51.000336', NULL),
	(10000338, 100126, 10000004, 'PW21A-JK100126BL-L', '2021-04-15 11:52:51.000337', '2021-04-15 11:52:51.000337', NULL),
	(10000339, 100126, 10000005, 'PW21A-JK100126BL-XL', '2021-04-15 11:52:51.000338', '2021-04-15 11:52:51.000338', NULL),
	(10000340, 100126, 10000006, 'PW21A-JK100126BL-XXL', '2021-04-15 11:52:51.000339', '2021-04-15 11:52:51.000339', NULL),
	(10000341, 100127, 10000001, 'PW21A-JK100127BL-XS', '2021-04-15 11:52:51.000340', '2021-04-15 11:52:51.000340', NULL),
	(10000342, 100127, 10000002, 'PW21A-JK100127BL-S', '2021-04-15 11:52:51.000341', '2021-04-15 11:52:51.000341', NULL),
	(10000343, 100127, 10000003, 'PW21A-JK100127BL-M', '2021-04-15 11:52:51.000342', '2021-04-15 11:52:51.000342', NULL),
	(10000344, 100127, 10000004, 'PW21A-JK100127BL-L', '2021-04-15 11:52:51.000343', '2021-04-15 11:52:51.000343', NULL),
	(10000345, 100127, 10000005, 'PW21A-JK100127BL-XL', '2021-04-15 11:52:51.000344', '2021-04-15 11:52:51.000344', NULL),
	(10000346, 100127, 10000006, 'PW21A-JK100127BL-XXL', '2021-04-15 11:52:51.000345', '2021-04-15 11:52:51.000345', NULL),
	(10000347, 100128, 10000001, 'PW21A-JK100128BL-XS', '2021-04-15 11:52:51.000346', '2021-04-15 11:52:51.000346', NULL),
	(10000348, 100128, 10000002, 'PW21A-JK100128BL-S', '2021-04-15 11:52:51.000347', '2021-04-15 11:52:51.000347', NULL),
	(10000349, 100128, 10000003, 'PW21A-JK100128BL-M', '2021-04-15 11:52:51.000348', '2021-04-15 11:52:51.000348', NULL),
	(10000350, 100128, 10000004, 'PW21A-JK100128BL-L', '2021-04-15 11:52:51.000349', '2021-04-15 11:52:51.000349', NULL),
	(10000351, 100128, 10000005, 'PW21A-JK100128BL-XL', '2021-04-15 11:52:51.000350', '2021-04-15 11:52:51.000350', NULL),
	(10000352, 100128, 10000006, 'PW21A-JK100128BL-XXL', '2021-04-15 11:52:51.000351', '2021-04-15 11:52:51.000351', NULL),
	(10000353, 100129, 10000001, 'PW21A-JK100129YW -XS', '2021-04-15 11:52:51.000352', '2021-04-15 11:52:51.000352', NULL),
	(10000354, 100129, 10000002, 'PW21A-JK100129YW -S', '2021-04-15 11:52:51.000353', '2021-04-15 11:52:51.000353', NULL),
	(10000355, 100129, 10000003, 'PW21A-JK100129YW -M', '2021-04-15 11:52:51.000354', '2021-04-15 11:52:51.000354', NULL),
	(10000356, 100129, 10000004, 'PW21A-JK100129YW -L', '2021-04-15 11:52:51.000355', '2021-04-15 11:52:51.000355', NULL),
	(10000357, 100129, 10000005, 'PW21A-JK100129YW -XL', '2021-04-15 11:52:51.000356', '2021-04-15 11:52:51.000356', NULL),
	(10000358, 100129, 10000006, 'PW21A-JK100129YW -XXL', '2021-04-15 11:52:51.000357', '2021-04-15 11:52:51.000357', NULL),
	(10000359, 100130, 10000001, 'PW21A-JK100130YW -XS', '2021-04-15 11:52:51.000358', '2021-04-15 11:52:51.000358', NULL),
	(10000360, 100130, 10000002, 'PW21A-JK100130YW -S', '2021-04-15 11:52:51.000359', '2021-04-15 11:52:51.000359', NULL),
	(10000361, 100130, 10000003, 'PW21A-JK100130YW -M', '2021-04-15 11:52:51.000360', '2021-04-15 11:52:51.000360', NULL),
	(10000362, 100130, 10000004, 'PW21A-JK100130YW -L', '2021-04-15 11:52:51.000361', '2021-04-15 11:52:51.000361', NULL),
	(10000363, 100130, 10000005, 'PW21A-JK100130YW -XL', '2021-04-15 11:52:51.000362', '2021-04-15 11:52:51.000362', NULL),
	(10000364, 100130, 10000006, 'PW21A-JK100130YW -XXL', '2021-04-15 11:52:51.000363', '2021-04-15 11:52:51.000363', NULL),
	(10000365, 100131, 10000001, 'PW21A-JK100131YW -XS', '2021-04-15 11:52:51.000364', '2021-04-15 11:52:51.000364', NULL),
	(10000366, 100131, 10000002, 'PW21A-JK100131YW -S', '2021-04-15 11:52:51.000365', '2021-04-15 11:52:51.000365', NULL),
	(10000367, 100131, 10000003, 'PW21A-JK100131YW -M', '2021-04-15 11:52:51.000366', '2021-04-15 11:52:51.000366', NULL),
	(10000368, 100131, 10000004, 'PW21A-JK100131YW -L', '2021-04-15 11:52:51.000367', '2021-04-15 11:52:51.000367', NULL),
	(10000369, 100131, 10000005, 'PW21A-JK100131YW -XL', '2021-04-15 11:52:51.000368', '2021-04-15 11:52:51.000368', NULL),
	(10000370, 100131, 10000006, 'PW21A-JK100131YW -XXL', '2021-04-15 11:52:51.000369', '2021-04-15 11:52:51.000369', NULL),
	(10000371, 100132, 10000001, 'PW21A-JK100132BL-XS', '2021-04-15 11:52:51.000370', '2021-04-15 11:52:51.000370', NULL),
	(10000372, 100132, 10000002, 'PW21A-JK100132BL-S', '2021-04-15 11:52:51.000371', '2021-04-15 11:52:51.000371', NULL),
	(10000373, 100132, 10000003, 'PW21A-JK100132BL-M', '2021-04-15 11:52:51.000372', '2021-04-15 11:52:51.000372', NULL),
	(10000374, 100132, 10000004, 'PW21A-JK100132BL-L', '2021-04-15 11:52:51.000373', '2021-04-15 11:52:51.000373', NULL),
	(10000375, 100132, 10000005, 'PW21A-JK100132BL-XL', '2021-04-15 11:52:51.000374', '2021-04-15 11:52:51.000374', NULL),
	(10000376, 100132, 10000006, 'PW21A-JK100132BL-XXL', '2021-04-15 11:52:51.000375', '2021-04-15 11:52:51.000375', NULL),
	(10000377, 100133, 10000001, 'PW21A-JK100133BL-XS', '2021-04-15 11:52:51.000376', '2021-04-15 11:52:51.000376', NULL),
	(10000378, 100133, 10000002, 'PW21A-JK100133BL-S', '2021-04-15 11:52:51.000377', '2021-04-15 11:52:51.000377', NULL),
	(10000379, 100133, 10000003, 'PW21A-JK100133BL-M', '2021-04-15 11:52:51.000378', '2021-04-15 11:52:51.000378', NULL),
	(10000380, 100133, 10000004, 'PW21A-JK100133BL-L', '2021-04-15 11:52:51.000379', '2021-04-15 11:52:51.000379', NULL),
	(10000381, 100133, 10000005, 'PW21A-JK100133BL-XL', '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(10000382, 100133, 10000006, 'PW21A-JK100133BL-XXL', '2021-04-15 11:52:51.000381', '2021-04-15 11:52:51.000381', NULL),
	(10000383, 100134, 10000001, 'PW21A-JK100134OL-XS', '2021-04-15 11:52:51.000382', '2021-04-15 11:52:51.000382', NULL),
	(10000384, 100134, 10000002, 'PW21A-JK100134OL-S', '2021-04-15 11:52:51.000383', '2021-04-15 11:52:51.000383', NULL),
	(10000385, 100134, 10000003, 'PW21A-JK100134OL-M', '2021-04-15 11:52:51.000384', '2021-04-15 11:52:51.000384', NULL),
	(10000386, 100134, 10000004, 'PW21A-JK100134OL-L', '2021-04-15 11:52:51.000385', '2021-04-15 11:52:51.000385', NULL),
	(10000387, 100134, 10000005, 'PW21A-JK100134OL-XL', '2021-04-15 11:52:51.000386', '2021-04-15 11:52:51.000386', NULL),
	(10000388, 100134, 10000006, 'PW21A-JK100134OL-XXL', '2021-04-15 11:52:51.000387', '2021-04-15 11:52:51.000387', NULL),
	(10000389, 100135, 10000001, 'PW21A-JK100135BL-XS', '2021-04-15 11:52:51.000388', '2021-04-15 11:52:51.000388', NULL),
	(10000390, 100135, 10000002, 'PW21A-JK100135BL-S', '2021-04-15 11:52:51.000389', '2021-04-15 11:52:51.000389', NULL),
	(10000391, 100135, 10000003, 'PW21A-JK100135BL-M', '2021-04-15 11:52:51.000390', '2021-04-15 11:52:51.000390', NULL),
	(10000392, 100135, 10000004, 'PW21A-JK100135BL-L', '2021-04-15 11:52:51.000391', '2021-04-15 11:52:51.000391', NULL),
	(10000393, 100135, 10000005, 'PW21A-JK100135BL-XL', '2021-04-15 11:52:51.000392', '2021-04-15 11:52:51.000392', NULL),
	(10000394, 100135, 10000006, 'PW21A-JK100135BL-XXL', '2021-04-15 11:52:51.000393', '2021-04-15 11:52:51.000393', NULL),
	(10000395, 100136, 10000001, 'PW21A-JK100136OL-XS', '2021-04-15 11:52:51.000394', '2021-04-15 11:52:51.000394', NULL),
	(10000396, 100136, 10000002, 'PW21A-JK100136OL-S', '2021-04-15 11:52:51.000395', '2021-04-15 11:52:51.000395', NULL),
	(10000397, 100136, 10000003, 'PW21A-JK100136OL-M', '2021-04-15 11:52:51.000396', '2021-04-15 11:52:51.000396', NULL),
	(10000398, 100136, 10000004, 'PW21A-JK100136OL-L', '2021-04-15 11:52:51.000397', '2021-04-15 11:52:51.000397', NULL),
	(10000399, 100136, 10000005, 'PW21A-JK100136OL-XL', '2021-04-15 11:52:51.000398', '2021-04-15 11:52:51.000398', NULL),
	(10000400, 100136, 10000006, 'PW21A-JK100136OL-XXL', '2021-04-15 11:52:51.000399', '2021-04-15 11:52:51.000399', NULL),
	(10000401, 100137, 10000001, 'PW21A-JK100137BL-XS', '2021-04-15 11:52:51.000400', '2021-04-15 11:52:51.000400', NULL),
	(10000402, 100137, 10000002, 'PW21A-JK100137BL-S', '2021-04-15 11:52:51.000401', '2021-04-15 11:52:51.000401', NULL),
	(10000403, 100137, 10000003, 'PW21A-JK100137BL-M', '2021-04-15 11:52:51.000402', '2021-04-15 11:52:51.000402', NULL),
	(10000404, 100137, 10000004, 'PW21A-JK100137BL-L', '2021-04-15 11:52:51.000403', '2021-04-15 11:52:51.000403', NULL),
	(10000405, 100137, 10000005, 'PW21A-JK100137BL-XL', '2021-04-15 11:52:51.000404', '2021-04-15 11:52:51.000404', NULL),
	(10000406, 100137, 10000006, 'PW21A-JK100137BL-XXL', '2021-04-15 11:52:51.000405', '2021-04-15 11:52:51.000405', NULL),
	(10000407, 100138, 10000001, 'PW21A-JK100138OL-XS', '2021-04-15 11:52:51.000406', '2021-04-15 11:52:51.000406', NULL),
	(10000408, 100138, 10000002, 'PW21A-JK100138OL-S', '2021-04-15 11:52:51.000407', '2021-04-15 11:52:51.000407', NULL),
	(10000409, 100138, 10000003, 'PW21A-JK100138OL-M', '2021-04-15 11:52:51.000408', '2021-04-15 11:52:51.000408', NULL),
	(10000410, 100138, 10000004, 'PW21A-JK100138OL-L', '2021-04-15 11:52:51.000409', '2021-04-15 11:52:51.000409', NULL),
	(10000411, 100138, 10000005, 'PW21A-JK100138OL-XL', '2021-04-15 11:52:51.000410', '2021-04-15 11:52:51.000410', NULL),
	(10000412, 100138, 10000006, 'PW21A-JK100138OL-XXL', '2021-04-15 11:52:51.000411', '2021-04-15 11:52:51.000411', NULL),
	(10000413, 100139, 10000001, 'PW21A-JK100139BL-XS', '2021-04-15 11:52:51.000412', '2021-04-15 11:52:51.000412', NULL),
	(10000414, 100139, 10000002, 'PW21A-JK100139BL-S', '2021-04-15 11:52:51.000413', '2021-04-15 11:52:51.000413', NULL),
	(10000415, 100139, 10000003, 'PW21A-JK100139BL-M', '2021-04-15 11:52:51.000414', '2021-04-15 11:52:51.000414', NULL),
	(10000416, 100139, 10000004, 'PW21A-JK100139BL-L', '2021-04-15 11:52:51.000415', '2021-04-15 11:52:51.000415', NULL),
	(10000417, 100139, 10000005, 'PW21A-JK100139BL-XL', '2021-04-15 11:52:51.000416', '2021-04-15 11:52:51.000416', NULL),
	(10000418, 100139, 10000006, 'PW21A-JK100139BL-XXL', '2021-04-15 11:52:51.000417', '2021-04-15 11:52:51.000417', NULL),
	(10000419, 100140, 10000001, 'PW21A-JK100140OL-XS', '2021-04-15 11:52:51.000418', '2021-04-15 11:52:51.000418', NULL),
	(10000420, 100140, 10000002, 'PW21A-JK100140OL-S', '2021-04-15 11:52:51.000419', '2021-04-15 11:52:51.000419', NULL),
	(10000421, 100140, 10000003, 'PW21A-JK100140OL-M', '2021-04-15 11:52:51.000420', '2021-04-15 11:52:51.000420', NULL),
	(10000422, 100140, 10000004, 'PW21A-JK100140OL-L', '2021-04-15 11:52:51.000421', '2021-04-15 11:52:51.000421', NULL),
	(10000423, 100140, 10000005, 'PW21A-JK100140OL-XL', '2021-04-15 11:52:51.000422', '2021-04-15 11:52:51.000422', NULL),
	(10000424, 100140, 10000006, 'PW21A-JK100140OL-XXL', '2021-04-15 11:52:51.000423', '2021-04-15 11:52:51.000423', NULL),
	(10000425, 100141, 10000001, 'PW21A-JK100141BL-XS', '2021-04-15 11:52:51.000424', '2021-04-15 11:52:51.000424', NULL),
	(10000426, 100141, 10000002, 'PW21A-JK100141BL-S', '2021-04-15 11:52:51.000425', '2021-04-15 11:52:51.000425', NULL),
	(10000427, 100141, 10000003, 'PW21A-JK100141BL-M', '2021-04-15 11:52:51.000426', '2021-04-15 11:52:51.000426', NULL),
	(10000428, 100141, 10000004, 'PW21A-JK100141BL-L', '2021-04-15 11:52:51.000427', '2021-04-15 11:52:51.000427', NULL),
	(10000429, 100141, 10000005, 'PW21A-JK100141BL-XL', '2021-04-15 11:52:51.000428', '2021-04-15 11:52:51.000428', NULL),
	(10000430, 100141, 10000006, 'PW21A-JK100141BL-XXL', '2021-04-15 11:52:51.000429', '2021-04-15 11:52:51.000429', NULL),
	(10000431, 100142, 10000001, 'PW21A-JK100142OL-XS', '2021-04-15 11:52:51.000430', '2021-04-15 11:52:51.000430', NULL),
	(10000432, 100142, 10000002, 'PW21A-JK100142OL-S', '2021-04-15 11:52:51.000431', '2021-04-15 11:52:51.000431', NULL),
	(10000433, 100142, 10000003, 'PW21A-JK100142OL-M', '2021-04-15 11:52:51.000432', '2021-04-15 11:52:51.000432', NULL),
	(10000434, 100142, 10000004, 'PW21A-JK100142OL-L', '2021-04-15 11:52:51.000433', '2021-04-15 11:52:51.000433', NULL),
	(10000435, 100142, 10000005, 'PW21A-JK100142OL-XL', '2021-04-15 11:52:51.000434', '2021-04-15 11:52:51.000434', NULL),
	(10000436, 100142, 10000006, 'PW21A-JK100142OL-XXL', '2021-04-15 11:52:51.000435', '2021-04-15 11:52:51.000435', NULL),
	(10000437, 100143, 10000001, 'PW21A-JK100143BL-XS', '2021-04-15 11:52:51.000436', '2021-04-15 11:52:51.000436', NULL),
	(10000438, 100143, 10000002, 'PW21A-JK100143BL-S', '2021-04-15 11:52:51.000437', '2021-04-15 11:52:51.000437', NULL),
	(10000439, 100143, 10000003, 'PW21A-JK100143BL-M', '2021-04-15 11:52:51.000438', '2021-04-15 11:52:51.000438', NULL),
	(10000440, 100143, 10000004, 'PW21A-JK100143BL-L', '2021-04-15 11:52:51.000439', '2021-04-15 11:52:51.000439', NULL),
	(10000441, 100143, 10000005, 'PW21A-JK100143BL-XL', '2021-04-15 11:52:51.000440', '2021-04-15 11:52:51.000440', NULL),
	(10000442, 100143, 10000006, 'PW21A-JK100143BL-XXL', '2021-04-15 11:52:51.000441', '2021-04-15 11:52:51.000441', NULL),
	(10000443, 100144, 10000001, 'PW21A-JK100144AR-XS', '2021-04-15 11:52:51.000442', '2021-04-15 11:52:51.000442', NULL),
	(10000444, 100144, 10000002, 'PW21A-JK100144AR-S', '2021-04-15 11:52:51.000443', '2021-04-15 11:52:51.000443', NULL),
	(10000445, 100144, 10000003, 'PW21A-JK100144AR-M', '2021-04-15 11:52:51.000444', '2021-04-15 11:52:51.000444', NULL),
	(10000446, 100144, 10000004, 'PW21A-JK100144AR-L', '2021-04-15 11:52:51.000445', '2021-04-15 11:52:51.000445', NULL),
	(10000447, 100144, 10000005, 'PW21A-JK100144AR-XL', '2021-04-15 11:52:51.000446', '2021-04-15 11:52:51.000446', NULL),
	(10000448, 100144, 10000006, 'PW21A-JK100144AR-XXL', '2021-04-15 11:52:51.000447', '2021-04-15 11:52:51.000447', NULL),
	(10000449, 100145, 10000001, 'PW21A-JK100145RD-XS', '2021-04-15 11:52:51.000448', '2021-04-15 11:52:51.000448', NULL),
	(10000450, 100145, 10000002, 'PW21A-JK100145RD-S', '2021-04-15 11:52:51.000449', '2021-04-15 11:52:51.000449', NULL),
	(10000451, 100145, 10000003, 'PW21A-JK100145RD-M', '2021-04-15 11:52:51.000450', '2021-04-15 11:52:51.000450', NULL),
	(10000452, 100145, 10000004, 'PW21A-JK100145RD-L', '2021-04-15 11:52:51.000451', '2021-04-15 11:52:51.000451', NULL),
	(10000453, 100145, 10000005, 'PW21A-JK100145RD-XL', '2021-04-15 11:52:51.000452', '2021-04-15 11:52:51.000452', NULL),
	(10000454, 100145, 10000006, 'PW21A-JK100145RD-XXL', '2021-04-15 11:52:51.000453', '2021-04-15 11:52:51.000453', NULL),
	(10000455, 100146, 10000001, 'PW21A-JK100146BL-XS', '2021-04-15 11:52:51.000454', '2021-04-15 11:52:51.000454', NULL),
	(10000456, 100146, 10000002, 'PW21A-JK100146BL-S', '2021-04-15 11:52:51.000455', '2021-04-15 11:52:51.000455', NULL),
	(10000457, 100146, 10000003, 'PW21A-JK100146BL-M', '2021-04-15 11:52:51.000456', '2021-04-15 11:52:51.000456', NULL),
	(10000458, 100146, 10000004, 'PW21A-JK100146BL-L', '2021-04-15 11:52:51.000457', '2021-04-15 11:52:51.000457', NULL),
	(10000459, 100146, 10000005, 'PW21A-JK100146BL-XL', '2021-04-15 11:52:51.000458', '2021-04-15 11:52:51.000458', NULL),
	(10000460, 100146, 10000006, 'PW21A-JK100146BL-XXL', '2021-04-15 11:52:51.000459', '2021-04-15 11:52:51.000459', NULL),
	(10000461, 100147, 10000001, 'PW21A-JK100147BL-XS', '2021-04-15 11:52:51.000460', '2021-04-15 11:52:51.000460', NULL),
	(10000462, 100147, 10000002, 'PW21A-JK100147BL-S', '2021-04-15 11:52:51.000461', '2021-04-15 11:52:51.000461', NULL),
	(10000463, 100147, 10000003, 'PW21A-JK100147BL-M', '2021-04-15 11:52:51.000462', '2021-04-15 11:52:51.000462', NULL),
	(10000464, 100147, 10000004, 'PW21A-JK100147BL-L', '2021-04-15 11:52:51.000463', '2021-04-15 11:52:51.000463', NULL),
	(10000465, 100147, 10000005, 'PW21A-JK100147BL-XL', '2021-04-15 11:52:51.000464', '2021-04-15 11:52:51.000464', NULL),
	(10000466, 100147, 10000006, 'PW21A-JK100147BL-XXL', '2021-04-15 11:52:51.000465', '2021-04-15 11:52:51.000465', NULL),
	(10000467, 100148, 10000001, 'PW21A-JK100148BL-XS', '2021-04-15 11:52:51.000466', '2021-04-15 11:52:51.000466', NULL),
	(10000468, 100148, 10000002, 'PW21A-JK100148BL-S', '2021-04-15 11:52:51.000467', '2021-04-15 11:52:51.000467', NULL),
	(10000469, 100148, 10000003, 'PW21A-JK100148BL-M', '2021-04-15 11:52:51.000468', '2021-04-15 11:52:51.000468', NULL),
	(10000470, 100148, 10000004, 'PW21A-JK100148BL-L', '2021-04-15 11:52:51.000469', '2021-04-15 11:52:51.000469', NULL),
	(10000471, 100148, 10000005, 'PW21A-JK100148BL-XL', '2021-04-15 11:52:51.000470', '2021-04-15 11:52:51.000470', NULL),
	(10000472, 100148, 10000006, 'PW21A-JK100148BL-XXL', '2021-04-15 11:52:51.000471', '2021-04-15 11:52:51.000471', NULL),
	(10000473, 100149, 10000001, 'PW21A-JK100149BL-XS', '2021-04-15 11:52:51.000472', '2021-04-15 11:52:51.000472', NULL),
	(10000474, 100149, 10000002, 'PW21A-JK100149BL-S', '2021-04-15 11:52:51.000473', '2021-04-15 11:52:51.000473', NULL),
	(10000475, 100149, 10000003, 'PW21A-JK100149BL-M', '2021-04-15 11:52:51.000474', '2021-04-15 11:52:51.000474', NULL),
	(10000476, 100149, 10000004, 'PW21A-JK100149BL-L', '2021-04-15 11:52:51.000475', '2021-04-15 11:52:51.000475', NULL),
	(10000477, 100149, 10000005, 'PW21A-JK100149BL-XL', '2021-04-15 11:52:51.000476', '2021-04-15 11:52:51.000476', NULL),
	(10000478, 100149, 10000006, 'PW21A-JK100149BL-XXL', '2021-04-15 11:52:51.000477', '2021-04-15 11:52:51.000477', NULL),
	(10000479, 100150, 10000001, 'PW21A-JK100150BL-XS', '2021-04-15 11:52:51.000478', '2021-04-15 11:52:51.000478', NULL),
	(10000480, 100150, 10000002, 'PW21A-JK100150BL-S', '2021-04-15 11:52:51.000479', '2021-04-15 11:52:51.000479', NULL),
	(10000481, 100150, 10000003, 'PW21A-JK100150BL-M', '2021-04-15 11:52:51.000480', '2021-04-15 11:52:51.000480', NULL),
	(10000482, 100150, 10000004, 'PW21A-JK100150BL-L', '2021-04-15 11:52:51.000481', '2021-04-15 11:52:51.000481', NULL),
	(10000483, 100150, 10000005, 'PW21A-JK100150BL-XL', '2021-04-15 11:52:51.000482', '2021-04-15 11:52:51.000482', NULL),
	(10000484, 100150, 10000006, 'PW21A-JK100150BL-XXL', '2021-04-15 11:52:51.000483', '2021-04-15 11:52:51.000483', NULL),
	(10000485, 100151, 10000001, 'PW21A-JK100151BL-XS', '2021-04-15 11:52:51.000484', '2021-04-15 11:52:51.000484', NULL),
	(10000486, 100151, 10000002, 'PW21A-JK100151BL-S', '2021-04-15 11:52:51.000485', '2021-04-15 11:52:51.000485', NULL),
	(10000487, 100151, 10000003, 'PW21A-JK100151BL-M', '2021-04-15 11:52:51.000486', '2021-04-15 11:52:51.000486', NULL),
	(10000488, 100151, 10000004, 'PW21A-JK100151BL-L', '2021-04-15 11:52:51.000487', '2021-04-15 11:52:51.000487', NULL),
	(10000489, 100151, 10000005, 'PW21A-JK100151BL-XL', '2021-04-15 11:52:51.000488', '2021-04-15 11:52:51.000488', NULL),
	(10000490, 100151, 10000006, 'PW21A-JK100151BL-XXL', '2021-04-15 11:52:51.000489', '2021-04-15 11:52:51.000489', NULL),
	(10000491, 100152, 10000001, 'PW21A-JK100152BL-XS', '2021-04-15 11:52:51.000490', '2021-04-15 11:52:51.000490', NULL),
	(10000492, 100152, 10000002, 'PW21A-JK100152BL-S', '2021-04-15 11:52:51.000491', '2021-04-15 11:52:51.000491', NULL),
	(10000493, 100152, 10000003, 'PW21A-JK100152BL-M', '2021-04-15 11:52:51.000492', '2021-04-15 11:52:51.000492', NULL),
	(10000494, 100152, 10000004, 'PW21A-JK100152BL-L', '2021-04-15 11:52:51.000493', '2021-04-15 11:52:51.000493', NULL),
	(10000495, 100152, 10000005, 'PW21A-JK100152BL-XL', '2021-04-15 11:52:51.000494', '2021-04-15 11:52:51.000494', NULL),
	(10000496, 100152, 10000006, 'PW21A-JK100152BL-XXL', '2021-04-15 11:52:51.000495', '2021-04-15 11:52:51.000495', NULL),
	(10000497, 100153, 10000001, 'PW21A-JK100153GN-XS', '2021-04-15 11:52:51.000496', '2021-04-15 11:52:51.000496', NULL),
	(10000498, 100153, 10000002, 'PW21A-JK100153GN-S', '2021-04-15 11:52:51.000497', '2021-04-15 11:52:51.000497', NULL),
	(10000499, 100153, 10000003, 'PW21A-JK100153GN-M', '2021-04-15 11:52:51.000498', '2021-04-15 11:52:51.000498', NULL),
	(10000500, 100153, 10000004, 'PW21A-JK100153GN-L', '2021-04-15 11:52:51.000499', '2021-04-15 11:52:51.000499', NULL),
	(10000501, 100153, 10000005, 'PW21A-JK100153GN-XL', '2021-04-15 11:52:51.000500', '2021-04-15 11:52:51.000500', NULL),
	(10000502, 100153, 10000006, 'PW21A-JK100153GN-XXL', '2021-04-15 11:52:51.000501', '2021-04-15 11:52:51.000501', NULL),
	(10000503, 100154, 10000001, 'PW21A-JD100154BL-XS', '2021-04-15 11:52:51.000502', '2021-04-15 11:52:51.000502', NULL),
	(10000504, 100154, 10000002, 'PW21A-JD100154BL-S', '2021-04-15 11:52:51.000503', '2021-04-15 11:52:51.000503', NULL),
	(10000505, 100154, 10000003, 'PW21A-JD100154BL-M', '2021-04-15 11:52:51.000504', '2021-04-15 11:52:51.000504', NULL),
	(10000506, 100154, 10000004, 'PW21A-JD100154BL-L', '2021-04-15 11:52:51.000505', '2021-04-15 11:52:51.000505', NULL),
	(10000507, 100154, 10000005, 'PW21A-JD100154BL-XL', '2021-04-15 11:52:51.000506', '2021-04-15 11:52:51.000506', NULL),
	(10000508, 100154, 10000006, 'PW21A-JD100154BL-XXL', '2021-04-15 11:52:51.000507', '2021-04-15 11:52:51.000507', NULL),
	(10000509, 100155, 10000001, 'PW21A-JK100155OL-XS', '2021-04-15 11:52:51.000508', '2021-04-15 11:52:51.000508', NULL),
	(10000510, 100155, 10000002, 'PW21A-JK100155OL-S', '2021-04-15 11:52:51.000509', '2021-04-15 11:52:51.000509', NULL),
	(10000511, 100155, 10000003, 'PW21A-JK100155OL-M', '2021-04-15 11:52:51.000510', '2021-04-15 11:52:51.000510', NULL),
	(10000512, 100155, 10000004, 'PW21A-JK100155OL-L', '2021-04-15 11:52:51.000511', '2021-04-15 11:52:51.000511', NULL),
	(10000513, 100155, 10000005, 'PW21A-JK100155OL-XL', '2021-04-15 11:52:51.000512', '2021-04-15 11:52:51.000512', NULL),
	(10000514, 100155, 10000006, 'PW21A-JK100155OL-XXL', '2021-04-15 11:52:51.000513', '2021-04-15 11:52:51.000513', NULL),
	(10000515, 100156, 10000001, 'PW21A-JK100156YW -XS', '2021-04-15 11:52:51.000514', '2021-04-15 11:52:51.000514', NULL),
	(10000516, 100156, 10000002, 'PW21A-JK100156YW -S', '2021-04-15 11:52:51.000515', '2021-04-15 11:52:51.000515', NULL),
	(10000517, 100156, 10000003, 'PW21A-JK100156YW -M', '2021-04-15 11:52:51.000516', '2021-04-15 11:52:51.000516', NULL),
	(10000518, 100156, 10000004, 'PW21A-JK100156YW -L', '2021-04-15 11:52:51.000517', '2021-04-15 11:52:51.000517', NULL),
	(10000519, 100156, 10000005, 'PW21A-JK100156YW -XL', '2021-04-15 11:52:51.000518', '2021-04-15 11:52:51.000518', NULL),
	(10000520, 100156, 10000006, 'PW21A-JK100156YW -XXL', '2021-04-15 11:52:51.000519', '2021-04-15 11:52:51.000519', NULL),
	(10000521, 100157, 10000001, 'PW21A-JK100157BL-XS', '2021-04-15 11:52:51.000520', '2021-04-15 11:52:51.000520', NULL),
	(10000522, 100157, 10000002, 'PW21A-JK100157BL-S', '2021-04-15 11:52:51.000521', '2021-04-15 11:52:51.000521', NULL),
	(10000523, 100157, 10000003, 'PW21A-JK100157BL-M', '2021-04-15 11:52:51.000522', '2021-04-15 11:52:51.000522', NULL),
	(10000524, 100157, 10000004, 'PW21A-JK100157BL-L', '2021-04-15 11:52:51.000523', '2021-04-15 11:52:51.000523', NULL),
	(10000525, 100157, 10000005, 'PW21A-JK100157BL-XL', '2021-04-15 11:52:51.000524', '2021-04-15 11:52:51.000524', NULL),
	(10000526, 100157, 10000006, 'PW21A-JK100157BL-XXL', '2021-04-15 11:52:51.000525', '2021-04-15 11:52:51.000525', NULL),
	(10000527, 100158, 10000001, 'PW21A-JK100158AR-XS', '2021-04-15 11:52:51.000526', '2021-04-15 11:52:51.000526', NULL),
	(10000528, 100158, 10000002, 'PW21A-JK100158AR-S', '2021-04-15 11:52:51.000527', '2021-04-15 11:52:51.000527', NULL),
	(10000529, 100158, 10000003, 'PW21A-JK100158AR-M', '2021-04-15 11:52:51.000528', '2021-04-15 11:52:51.000528', NULL),
	(10000530, 100158, 10000004, 'PW21A-JK100158AR-L', '2021-04-15 11:52:51.000529', '2021-04-15 11:52:51.000529', NULL),
	(10000531, 100158, 10000005, 'PW21A-JK100158AR-XL', '2021-04-15 11:52:51.000530', '2021-04-15 11:52:51.000530', NULL),
	(10000532, 100158, 10000006, 'PW21A-JK100158AR-XXL', '2021-04-15 11:52:51.000531', '2021-04-15 11:52:51.000531', NULL),
	(10000533, 100159, 10000001, 'PW21A-JD100159MR-XS', '2021-04-15 11:52:51.000532', '2021-04-15 11:52:51.000532', NULL),
	(10000534, 100159, 10000002, 'PW21A-JD100159MR-S', '2021-04-15 11:52:51.000533', '2021-04-15 11:52:51.000533', NULL),
	(10000535, 100159, 10000003, 'PW21A-JD100159MR-M', '2021-04-15 11:52:51.000534', '2021-04-15 11:52:51.000534', NULL),
	(10000536, 100159, 10000004, 'PW21A-JD100159MR-L', '2021-04-15 11:52:51.000535', '2021-04-15 11:52:51.000535', NULL),
	(10000537, 100159, 10000005, 'PW21A-JD100159MR-XL', '2021-04-15 11:52:51.000536', '2021-04-15 11:52:51.000536', NULL),
	(10000538, 100159, 10000006, 'PW21A-JD100159MR-XXL', '2021-04-15 11:52:51.000537', '2021-04-15 11:52:51.000537', NULL),
	(10000539, 100160, 10000001, 'PW21A-JK100160TC-XS', '2021-04-15 11:52:51.000538', '2021-04-15 11:52:51.000538', NULL),
	(10000540, 100160, 10000002, 'PW21A-JK100160TC-S', '2021-04-15 11:52:51.000539', '2021-04-15 11:52:51.000539', NULL),
	(10000541, 100160, 10000003, 'PW21A-JK100160TC-M', '2021-04-15 11:52:51.000540', '2021-04-15 11:52:51.000540', NULL),
	(10000542, 100160, 10000004, 'PW21A-JK100160TC-L', '2021-04-15 11:52:51.000541', '2021-04-15 11:52:51.000541', NULL),
	(10000543, 100160, 10000005, 'PW21A-JK100160TC-XL', '2021-04-15 11:52:51.000542', '2021-04-15 11:52:51.000542', NULL),
	(10000544, 100160, 10000006, 'PW21A-JK100160TC-XXL', '2021-04-15 11:52:51.000543', '2021-04-15 11:52:51.000543', NULL),
	(10000545, 100161, 10000001, 'PW21A-JK100161BL-XS', '2021-04-15 11:52:51.000544', '2021-04-15 11:52:51.000544', NULL),
	(10000546, 100161, 10000002, 'PW21A-JK100161BL-S', '2021-04-15 11:52:51.000545', '2021-04-15 11:52:51.000545', NULL),
	(10000547, 100161, 10000003, 'PW21A-JK100161BL-M', '2021-04-15 11:52:51.000546', '2021-04-15 11:52:51.000546', NULL),
	(10000548, 100161, 10000004, 'PW21A-JK100161BL-L', '2021-04-15 11:52:51.000547', '2021-04-15 11:52:51.000547', NULL),
	(10000549, 100161, 10000005, 'PW21A-JK100161BL-XL', '2021-04-15 11:52:51.000548', '2021-04-15 11:52:51.000548', NULL),
	(10000550, 100161, 10000006, 'PW21A-JK100161BL-XXL', '2021-04-15 11:52:51.000549', '2021-04-15 11:52:51.000549', NULL),
	(10000551, 100162, 10000001, 'PW21A-JD100162BL-XS', '2021-04-15 11:52:51.000550', '2021-04-15 11:52:51.000550', NULL),
	(10000552, 100162, 10000002, 'PW21A-JD100162BL-S', '2021-04-15 11:52:51.000551', '2021-04-15 11:52:51.000551', NULL),
	(10000553, 100162, 10000003, 'PW21A-JD100162BL-M', '2021-04-15 11:52:51.000552', '2021-04-15 11:52:51.000552', NULL),
	(10000554, 100162, 10000004, 'PW21A-JD100162BL-L', '2021-04-15 11:52:51.000553', '2021-04-15 11:52:51.000553', NULL),
	(10000555, 100162, 10000005, 'PW21A-JD100162BL-XL', '2021-04-15 11:52:51.000554', '2021-04-15 11:52:51.000554', NULL),
	(10000556, 100162, 10000006, 'PW21A-JD100162BL-XXL', '2021-04-15 11:52:51.000555', '2021-04-15 11:52:51.000555', NULL),
	(10000557, 100163, 10000001, 'PW21A-JK100163RD-XS', '2021-04-15 11:52:51.000556', '2021-04-15 11:52:51.000556', NULL),
	(10000558, 100163, 10000002, 'PW21A-JK100163RD-S', '2021-04-15 11:52:51.000557', '2021-04-15 11:52:51.000557', NULL),
	(10000559, 100163, 10000003, 'PW21A-JK100163RD-M', '2021-04-15 11:52:51.000558', '2021-04-15 11:52:51.000558', NULL),
	(10000560, 100163, 10000004, 'PW21A-JK100163RD-L', '2021-04-15 11:52:51.000559', '2021-04-15 11:52:51.000559', NULL),
	(10000561, 100163, 10000005, 'PW21A-JK100163RD-XL', '2021-04-15 11:52:51.000560', '2021-04-15 11:52:51.000560', NULL),
	(10000562, 100163, 10000006, 'PW21A-JK100163RD-XXL', '2021-04-15 11:52:51.000561', '2021-04-15 11:52:51.000561', NULL),
	(10000563, 100164, 10000001, 'PW21A-JD100164BL-XS', '2021-04-15 11:52:51.000562', '2021-04-15 11:52:51.000562', NULL),
	(10000564, 100164, 10000002, 'PW21A-JD100164BL-S', '2021-04-15 11:52:51.000563', '2021-04-15 11:52:51.000563', NULL),
	(10000565, 100164, 10000003, 'PW21A-JD100164BL-M', '2021-04-15 11:52:51.000564', '2021-04-15 11:52:51.000564', NULL),
	(10000566, 100164, 10000004, 'PW21A-JD100164BL-L', '2021-04-15 11:52:51.000565', '2021-04-15 11:52:51.000565', NULL),
	(10000567, 100164, 10000005, 'PW21A-JD100164BL-XL', '2021-04-15 11:52:51.000566', '2021-04-15 11:52:51.000566', NULL),
	(10000568, 100164, 10000006, 'PW21A-JD100164BL-XXL', '2021-04-15 11:52:51.000567', '2021-04-15 11:52:51.000567', NULL),
	(10000569, 100165, 10000001, 'PW21A-JK100165NV-XS', '2021-04-15 11:52:51.000568', '2021-04-15 11:52:51.000568', NULL),
	(10000570, 100165, 10000002, 'PW21A-JK100165NV-S', '2021-04-15 11:52:51.000569', '2021-04-15 11:52:51.000569', NULL),
	(10000571, 100165, 10000003, 'PW21A-JK100165NV-M', '2021-04-15 11:52:51.000570', '2021-04-15 11:52:51.000570', NULL),
	(10000572, 100165, 10000004, 'PW21A-JK100165NV-L', '2021-04-15 11:52:51.000571', '2021-04-15 11:52:51.000571', NULL),
	(10000573, 100165, 10000005, 'PW21A-JK100165NV-XL', '2021-04-15 11:52:51.000572', '2021-04-15 11:52:51.000572', NULL),
	(10000574, 100165, 10000006, 'PW21A-JK100165NV-XXL', '2021-04-15 11:52:51.000573', '2021-04-15 11:52:51.000573', NULL),
	(10000575, 100166, 10000001, 'PW21A-JK100166MR-XS', '2021-04-15 11:52:51.000574', '2021-04-15 11:52:51.000574', NULL),
	(10000576, 100166, 10000002, 'PW21A-JK100166MR-S', '2021-04-15 11:52:51.000575', '2021-04-15 11:52:51.000575', NULL),
	(10000577, 100166, 10000003, 'PW21A-JK100166MR-M', '2021-04-15 11:52:51.000576', '2021-04-15 11:52:51.000576', NULL),
	(10000578, 100166, 10000004, 'PW21A-JK100166MR-L', '2021-04-15 11:52:51.000577', '2021-04-15 11:52:51.000577', NULL),
	(10000579, 100166, 10000005, 'PW21A-JK100166MR-XL', '2021-04-15 11:52:51.000578', '2021-04-15 11:52:51.000578', NULL),
	(10000580, 100166, 10000006, 'PW21A-JK100166MR-XXL', '2021-04-15 11:52:51.000579', '2021-04-15 11:52:51.000579', NULL),
	(10000581, 100167, 10000001, 'PW21A-JK100167WT-XS', '2021-04-15 11:52:51.000580', '2021-04-15 11:52:51.000580', NULL),
	(10000582, 100167, 10000002, 'PW21A-JK100167WT-S', '2021-04-15 11:52:51.000581', '2021-04-15 11:52:51.000581', NULL),
	(10000583, 100167, 10000003, 'PW21A-JK100167WT-M', '2021-04-15 11:52:51.000582', '2021-04-15 11:52:51.000582', NULL),
	(10000584, 100167, 10000004, 'PW21A-JK100167WT-L', '2021-04-15 11:52:51.000583', '2021-04-15 11:52:51.000583', NULL),
	(10000585, 100167, 10000005, 'PW21A-JK100167WT-XL', '2021-04-15 11:52:51.000584', '2021-04-15 11:52:51.000584', NULL),
	(10000586, 100167, 10000006, 'PW21A-JK100167WT-XXL', '2021-04-15 11:52:51.000585', '2021-04-15 11:52:51.000585', NULL),
	(10000587, 100168, 10000001, 'PW21A-JK100168BL-XS', '2021-04-15 11:52:51.000586', '2021-04-15 11:52:51.000586', NULL),
	(10000588, 100168, 10000002, 'PW21A-JK100168BL-S', '2021-04-15 11:52:51.000587', '2021-04-15 11:52:51.000587', NULL),
	(10000589, 100168, 10000003, 'PW21A-JK100168BL-M', '2021-04-15 11:52:51.000588', '2021-04-15 11:52:51.000588', NULL),
	(10000590, 100168, 10000004, 'PW21A-JK100168BL-L', '2021-04-15 11:52:51.000589', '2021-04-15 11:52:51.000589', NULL),
	(10000591, 100168, 10000005, 'PW21A-JK100168BL-XL', '2021-04-15 11:52:51.000590', '2021-04-15 11:52:51.000590', NULL),
	(10000592, 100168, 10000006, 'PW21A-JK100168BL-XXL', '2021-04-15 11:52:51.000591', '2021-04-15 11:52:51.000591', NULL),
	(10000593, 100169, 10000001, 'PW21A-JK100169BL-XS', '2021-04-15 11:52:51.000592', '2021-04-15 11:52:51.000592', NULL),
	(10000594, 100169, 10000002, 'PW21A-JK100169BL-S', '2021-04-15 11:52:51.000593', '2021-04-15 11:52:51.000593', NULL),
	(10000595, 100169, 10000003, 'PW21A-JK100169BL-M', '2021-04-15 11:52:51.000594', '2021-04-15 11:52:51.000594', NULL),
	(10000596, 100169, 10000004, 'PW21A-JK100169BL-L', '2021-04-15 11:52:51.000595', '2021-04-15 11:52:51.000595', NULL),
	(10000597, 100169, 10000005, 'PW21A-JK100169BL-XL', '2021-04-15 11:52:51.000596', '2021-04-15 11:52:51.000596', NULL),
	(10000598, 100169, 10000006, 'PW21A-JK100169BL-XXL', '2021-04-15 11:52:51.000597', '2021-04-15 11:52:51.000597', NULL),
	(10000599, 100170, 10000001, 'PW21A-JK100170RD-XS', '2021-04-15 11:52:51.000598', '2021-04-15 11:52:51.000598', NULL),
	(10000600, 100170, 10000002, 'PW21A-JK100170RD-S', '2021-04-15 11:52:51.000599', '2021-04-15 11:52:51.000599', NULL),
	(10000601, 100170, 10000003, 'PW21A-JK100170RD-M', '2021-04-15 11:52:51.000600', '2021-04-15 11:52:51.000600', NULL),
	(10000602, 100170, 10000004, 'PW21A-JK100170RD-L', '2021-04-15 11:52:51.000601', '2021-04-15 11:52:51.000601', NULL),
	(10000603, 100170, 10000005, 'PW21A-JK100170RD-XL', '2021-04-15 11:52:51.000602', '2021-04-15 11:52:51.000602', NULL),
	(10000604, 100170, 10000006, 'PW21A-JK100170RD-XXL', '2021-04-15 11:52:51.000603', '2021-04-15 11:52:51.000603', NULL),
	(10000605, 100171, 10000001, 'PW21A-JK100171WT-XS', '2021-04-15 11:52:51.000604', '2021-04-15 11:52:51.000604', NULL),
	(10000606, 100171, 10000002, 'PW21A-JK100171WT-S', '2021-04-15 11:52:51.000605', '2021-04-15 11:52:51.000605', NULL),
	(10000607, 100171, 10000003, 'PW21A-JK100171WT-M', '2021-04-15 11:52:51.000606', '2021-04-15 11:52:51.000606', NULL),
	(10000608, 100171, 10000004, 'PW21A-JK100171WT-L', '2021-04-15 11:52:51.000607', '2021-04-15 11:52:51.000607', NULL),
	(10000609, 100171, 10000005, 'PW21A-JK100171WT-XL', '2021-04-15 11:52:51.000608', '2021-04-15 11:52:51.000608', NULL),
	(10000610, 100171, 10000006, 'PW21A-JK100171WT-XXL', '2021-04-15 11:52:51.000609', '2021-04-15 11:52:51.000609', NULL),
	(10000611, 100172, 10000001, 'PW21A-JK100172BL-XS', '2021-04-15 11:52:51.000610', '2021-04-15 11:52:51.000610', NULL),
	(10000612, 100172, 10000002, 'PW21A-JK100172BL-S', '2021-04-15 11:52:51.000611', '2021-04-15 11:52:51.000611', NULL),
	(10000613, 100172, 10000003, 'PW21A-JK100172BL-M', '2021-04-15 11:52:51.000612', '2021-04-15 11:52:51.000612', NULL),
	(10000614, 100172, 10000004, 'PW21A-JK100172BL-L', '2021-04-15 11:52:51.000613', '2021-04-15 11:52:51.000613', NULL),
	(10000615, 100172, 10000005, 'PW21A-JK100172BL-XL', '2021-04-15 11:52:51.000614', '2021-04-15 11:52:51.000614', NULL),
	(10000616, 100172, 10000006, 'PW21A-JK100172BL-XXL', '2021-04-15 11:52:51.000615', '2021-04-15 11:52:51.000615', NULL),
	(10000617, 100173, 10000001, 'PW21A-TS100173BL-XS', '2021-04-15 11:52:51.000616', '2021-04-15 11:52:51.000616', NULL),
	(10000618, 100173, 10000003, 'PW21A-TS100173BL-M', '2021-04-15 11:52:51.000617', '2021-04-15 11:52:51.000617', NULL),
	(10000619, 100173, 10000004, 'PW21A-TS100173BL-L', '2021-04-15 11:52:51.000618', '2021-04-15 11:52:51.000618', NULL),
	(10000620, 100173, 10000005, 'PW21A-TS100173BL-XL', '2021-04-15 11:52:51.000619', '2021-04-15 11:52:51.000619', NULL),
	(10000621, 100173, 10000006, 'PW21A-TS100173BL-XXL', '2021-04-15 11:52:51.000620', '2021-04-15 11:52:51.000620', NULL),
	(10000622, 100174, 10000001, 'PW21A-TS100174NV-XS', '2021-04-15 11:52:51.000621', '2021-04-15 11:52:51.000621', NULL),
	(10000623, 100174, 10000002, 'PW21A-TS100174NV-S', '2021-04-15 11:52:51.000622', '2021-04-15 11:52:51.000622', NULL),
	(10000624, 100174, 10000003, 'PW21A-TS100174NV-M', '2021-04-15 11:52:51.000623', '2021-04-15 11:52:51.000623', NULL),
	(10000625, 100174, 10000004, 'PW21A-TS100174NV-L', '2021-04-15 11:52:51.000624', '2021-04-15 11:52:51.000624', NULL),
	(10000626, 100174, 10000005, 'PW21A-TS100174NV-XL', '2021-04-15 11:52:51.000625', '2021-04-15 11:52:51.000625', NULL),
	(10000627, 100174, 10000006, 'PW21A-TS100174NV-XXL', '2021-04-15 11:52:51.000626', '2021-04-15 11:52:51.000626', NULL),
	(10000628, 100175, 10000001, 'PW21A-TS100175BL-XS', '2021-04-15 11:52:51.000627', '2021-04-15 11:52:51.000627', NULL),
	(10000629, 100175, 10000002, 'PW21A-TS100175BL-S', '2021-04-15 11:52:51.000628', '2021-04-15 11:52:51.000628', NULL),
	(10000630, 100175, 10000003, 'PW21A-TS100175BL-M', '2021-04-15 11:52:51.000629', '2021-04-15 11:52:51.000629', NULL),
	(10000631, 100175, 10000004, 'PW21A-TS100175BL-L', '2021-04-15 11:52:51.000630', '2021-04-15 11:52:51.000630', NULL),
	(10000632, 100175, 10000005, 'PW21A-TS100175BL-XL', '2021-04-15 11:52:51.000631', '2021-04-15 11:52:51.000631', NULL),
	(10000633, 100175, 10000006, 'PW21A-TS100175BL-XXL', '2021-04-15 11:52:51.000632', '2021-04-15 11:52:51.000632', NULL),
	(10000634, 100176, 10000001, 'PW21A-TS100176BL-XS', '2021-04-15 11:52:51.000633', '2021-04-15 11:52:51.000633', NULL),
	(10000635, 100176, 10000002, 'PW21A-TS100176BL-S', '2021-04-15 11:52:51.000634', '2021-04-15 11:52:51.000634', NULL),
	(10000636, 100176, 10000003, 'PW21A-TS100176BL-M', '2021-04-15 11:52:51.000635', '2021-04-15 11:52:51.000635', NULL),
	(10000637, 100176, 10000004, 'PW21A-TS100176BL-L', '2021-04-15 11:52:51.000636', '2021-04-15 11:52:51.000636', NULL),
	(10000638, 100176, 10000005, 'PW21A-TS100176BL-XL', '2021-04-15 11:52:51.000637', '2021-04-15 11:52:51.000637', NULL),
	(10000639, 100176, 10000006, 'PW21A-TS100176BL-XXL', '2021-04-15 11:52:51.000638', '2021-04-15 11:52:51.000638', NULL),
	(10000640, 100177, 10000001, 'PW21A-TS100177BL-XS', '2021-04-15 11:52:51.000639', '2021-04-15 11:52:51.000639', NULL),
	(10000641, 100177, 10000002, 'PW21A-TS100177BL-S', '2021-04-15 11:52:51.000640', '2021-04-15 11:52:51.000640', NULL),
	(10000642, 100177, 10000003, 'PW21A-TS100177BL-M', '2021-04-15 11:52:51.000641', '2021-04-15 11:52:51.000641', NULL),
	(10000643, 100177, 10000004, 'PW21A-TS100177BL-L', '2021-04-15 11:52:51.000642', '2021-04-15 11:52:51.000642', NULL),
	(10000644, 100177, 10000005, 'PW21A-TS100177BL-XL', '2021-04-15 11:52:51.000643', '2021-04-15 11:52:51.000643', NULL),
	(10000645, 100177, 10000006, 'PW21A-TS100177BL-XXL', '2021-04-15 11:52:51.000644', '2021-04-15 11:52:51.000644', NULL),
	(10000646, 100178, 10000001, 'PW21A-TS100178BL-XS', '2021-04-15 11:52:51.000645', '2021-04-15 11:52:51.000645', NULL),
	(10000647, 100178, 10000002, 'PW21A-TS100178BL-S', '2021-04-15 11:52:51.000646', '2021-04-15 11:52:51.000646', NULL),
	(10000648, 100178, 10000003, 'PW21A-TS100178BL-M', '2021-04-15 11:52:51.000647', '2021-04-15 11:52:51.000647', NULL),
	(10000649, 100178, 10000004, 'PW21A-TS100178BL-L', '2021-04-15 11:52:51.000648', '2021-04-15 11:52:51.000648', NULL),
	(10000650, 100178, 10000005, 'PW21A-TS100178BL-XL', '2021-04-15 11:52:51.000649', '2021-04-15 11:52:51.000649', NULL),
	(10000651, 100178, 10000006, 'PW21A-TS100178BL-XXL', '2021-04-15 11:52:51.000650', '2021-04-15 11:52:51.000650', NULL),
	(10000652, 100179, 10000001, 'PW21A-TS100179BL-XS', '2021-04-15 11:52:51.000651', '2021-04-15 11:52:51.000651', NULL),
	(10000653, 100179, 10000002, 'PW21A-TS100179BL-S', '2021-04-15 11:52:51.000652', '2021-04-15 11:52:51.000652', NULL),
	(10000654, 100179, 10000003, 'PW21A-TS100179BL-M', '2021-04-15 11:52:51.000653', '2021-04-15 11:52:51.000653', NULL),
	(10000655, 100179, 10000004, 'PW21A-TS100179BL-L', '2021-04-15 11:52:51.000654', '2021-04-15 11:52:51.000654', NULL),
	(10000656, 100179, 10000005, 'PW21A-TS100179BL-XL', '2021-04-15 11:52:51.000655', '2021-04-15 11:52:51.000655', NULL),
	(10000657, 100179, 10000006, 'PW21A-TS100179BL-XXL', '2021-04-15 11:52:51.000656', '2021-04-15 11:52:51.000656', NULL),
	(10000658, 100180, 10000001, 'PW21A-TS100180BL-XS', '2021-04-15 11:52:51.000657', '2021-04-15 11:52:51.000657', NULL),
	(10000659, 100180, 10000002, 'PW21A-TS100180BL-S', '2021-04-15 11:52:51.000658', '2021-04-15 11:52:51.000658', NULL),
	(10000660, 100180, 10000003, 'PW21A-TS100180BL-M', '2021-04-15 11:52:51.000659', '2021-04-15 11:52:51.000659', NULL),
	(10000661, 100180, 10000004, 'PW21A-TS100180BL-L', '2021-04-15 11:52:51.000660', '2021-04-15 11:52:51.000660', NULL),
	(10000662, 100180, 10000005, 'PW21A-TS100180BL-XL', '2021-04-15 11:52:51.000661', '2021-04-15 11:52:51.000661', NULL),
	(10000663, 100180, 10000006, 'PW21A-TS100180BL-XXL', '2021-04-15 11:52:51.000662', '2021-04-15 11:52:51.000662', NULL),
	(10000664, 100181, 10000001, 'PW21A-TS100181BL-XS', '2021-04-15 11:52:51.000663', '2021-04-15 11:52:51.000663', NULL),
	(10000665, 100181, 10000002, 'PW21A-TS100181BL-S', '2021-04-15 11:52:51.000664', '2021-04-15 11:52:51.000664', NULL),
	(10000666, 100181, 10000003, 'PW21A-TS100181BL-M', '2021-04-15 11:52:51.000665', '2021-04-15 11:52:51.000665', NULL),
	(10000667, 100181, 10000004, 'PW21A-TS100181BL-L', '2021-04-15 11:52:51.000666', '2021-04-15 11:52:51.000666', NULL),
	(10000668, 100181, 10000005, 'PW21A-TS100181BL-XL', '2021-04-15 11:52:51.000667', '2021-04-15 11:52:51.000667', NULL),
	(10000669, 100181, 10000006, 'PW21A-TS100181BL-XXL', '2021-04-15 11:52:51.000668', '2021-04-15 11:52:51.000668', NULL),
	(10000670, 100182, 10000001, 'PW21A-TS100182BL-XS', '2021-04-15 11:52:51.000669', '2021-04-15 11:52:51.000669', NULL),
	(10000671, 100182, 10000002, 'PW21A-TS100182BL-S', '2021-04-15 11:52:51.000670', '2021-04-15 11:52:51.000670', NULL),
	(10000672, 100182, 10000003, 'PW21A-TS100182BL-M', '2021-04-15 11:52:51.000671', '2021-04-15 11:52:51.000671', NULL),
	(10000673, 100182, 10000004, 'PW21A-TS100182BL-L', '2021-04-15 11:52:51.000672', '2021-04-15 11:52:51.000672', NULL),
	(10000674, 100182, 10000005, 'PW21A-TS100182BL-XL', '2021-04-15 11:52:51.000673', '2021-04-15 11:52:51.000673', NULL),
	(10000675, 100182, 10000006, 'PW21A-TS100182BL-XXL', '2021-04-15 11:52:51.000674', '2021-04-15 11:52:51.000674', NULL),
	(10000676, 100183, 10000001, 'PW21A-TS100183BL-XS', '2021-04-15 11:52:51.000675', '2021-04-15 11:52:51.000675', NULL),
	(10000677, 100183, 10000002, 'PW21A-TS100183BL-S', '2021-04-15 11:52:51.000676', '2021-04-15 11:52:51.000676', NULL),
	(10000678, 100183, 10000003, 'PW21A-TS100183BL-M', '2021-04-15 11:52:51.000677', '2021-04-15 11:52:51.000677', NULL),
	(10000679, 100183, 10000004, 'PW21A-TS100183BL-L', '2021-04-15 11:52:51.000678', '2021-04-15 11:52:51.000678', NULL),
	(10000680, 100183, 10000005, 'PW21A-TS100183BL-XL', '2021-04-15 11:52:51.000679', '2021-04-15 11:52:51.000679', NULL),
	(10000681, 100183, 10000006, 'PW21A-TS100183BL-XXL', '2021-04-15 11:52:51.000680', '2021-04-15 11:52:51.000680', NULL),
	(10000682, 100184, 10000001, 'PW21A-TS100184BL-XS', '2021-04-15 11:52:51.000681', '2021-04-15 11:52:51.000681', NULL),
	(10000683, 100184, 10000002, 'PW21A-TS100184BL-S', '2021-04-15 11:52:51.000682', '2021-04-15 11:52:51.000682', NULL),
	(10000684, 100184, 10000003, 'PW21A-TS100184BL-M', '2021-04-15 11:52:51.000683', '2021-04-15 11:52:51.000683', NULL),
	(10000685, 100184, 10000004, 'PW21A-TS100184BL-L', '2021-04-15 11:52:51.000684', '2021-04-15 11:52:51.000684', NULL),
	(10000686, 100184, 10000005, 'PW21A-TS100184BL-XL', '2021-04-15 11:52:51.000685', '2021-04-15 11:52:51.000685', NULL),
	(10000687, 100184, 10000006, 'PW21A-TS100184BL-XXL', '2021-04-15 11:52:51.000686', '2021-04-15 11:52:51.000686', NULL),
	(10000688, 100185, 10000001, 'PW21A-TS100185BL-XS', '2021-04-15 11:52:51.000687', '2021-04-15 11:52:51.000687', NULL),
	(10000689, 100185, 10000002, 'PW21A-TS100185BL-S', '2021-04-15 11:52:51.000688', '2021-04-15 11:52:51.000688', NULL),
	(10000690, 100185, 10000003, 'PW21A-TS100185BL-M', '2021-04-15 11:52:51.000689', '2021-04-15 11:52:51.000689', NULL),
	(10000691, 100185, 10000004, 'PW21A-TS100185BL-L', '2021-04-15 11:52:51.000690', '2021-04-15 11:52:51.000690', NULL),
	(10000692, 100185, 10000005, 'PW21A-TS100185BL-XL', '2021-04-15 11:52:51.000691', '2021-04-15 11:52:51.000691', NULL),
	(10000693, 100185, 10000006, 'PW21A-TS100185BL-XXL', '2021-04-15 11:52:51.000692', '2021-04-15 11:52:51.000692', NULL),
	(10000694, 100186, 10000001, 'PW21A-TS100186BL-XS', '2021-04-15 11:52:51.000693', '2021-04-15 11:52:51.000693', NULL),
	(10000695, 100186, 10000002, 'PW21A-TS100186BL-S', '2021-04-15 11:52:51.000694', '2021-04-15 11:52:51.000694', NULL),
	(10000696, 100186, 10000003, 'PW21A-TS100186BL-M', '2021-04-15 11:52:51.000695', '2021-04-15 11:52:51.000695', NULL),
	(10000697, 100186, 10000004, 'PW21A-TS100186BL-L', '2021-04-15 11:52:51.000696', '2021-04-15 11:52:51.000696', NULL),
	(10000698, 100186, 10000005, 'PW21A-TS100186BL-XL', '2021-04-15 11:52:51.000697', '2021-04-15 11:52:51.000697', NULL),
	(10000699, 100186, 10000006, 'PW21A-TS100186BL-XXL', '2021-04-15 11:52:51.000698', '2021-04-15 11:52:51.000698', NULL),
	(10000700, 100187, 10000001, 'PW21A-TS100187BL-XS', '2021-04-15 11:52:51.000699', '2021-04-15 11:52:51.000699', NULL),
	(10000701, 100187, 10000002, 'PW21A-TS100187BL-S', '2021-04-15 11:52:51.000700', '2021-04-15 11:52:51.000700', NULL),
	(10000702, 100187, 10000003, 'PW21A-TS100187BL-M', '2021-04-15 11:52:51.000701', '2021-04-15 11:52:51.000701', NULL),
	(10000703, 100187, 10000004, 'PW21A-TS100187BL-L', '2021-04-15 11:52:51.000702', '2021-04-15 11:52:51.000702', NULL),
	(10000704, 100187, 10000005, 'PW21A-TS100187BL-XL', '2021-04-15 11:52:51.000703', '2021-04-15 11:52:51.000703', NULL),
	(10000705, 100187, 10000006, 'PW21A-TS100187BL-XXL', '2021-04-15 11:52:51.000704', '2021-04-15 11:52:51.000704', NULL),
	(10000706, 100188, 10000001, 'PW21A-TS100188BL-XS', '2021-04-15 11:52:51.000705', '2021-04-15 11:52:51.000705', NULL),
	(10000707, 100188, 10000002, 'PW21A-TS100188BL-S', '2021-04-15 11:52:51.000706', '2021-04-15 11:52:51.000706', NULL),
	(10000708, 100188, 10000003, 'PW21A-TS100188BL-M', '2021-04-15 11:52:51.000707', '2021-04-15 11:52:51.000707', NULL),
	(10000709, 100188, 10000004, 'PW21A-TS100188BL-L', '2021-04-15 11:52:51.000708', '2021-04-15 11:52:51.000708', NULL),
	(10000710, 100188, 10000005, 'PW21A-TS100188BL-XL', '2021-04-15 11:52:51.000709', '2021-04-15 11:52:51.000709', NULL),
	(10000711, 100188, 10000006, 'PW21A-TS100188BL-XXL', '2021-04-15 11:52:51.000710', '2021-04-15 11:52:51.000710', NULL),
	(10000712, 100189, 10000001, 'PW21A-TS100189BL-XS', '2021-04-15 11:52:51.000711', '2021-04-15 11:52:51.000711', NULL),
	(10000713, 100189, 10000002, 'PW21A-TS100189BL-S', '2021-04-15 11:52:51.000712', '2021-04-15 11:52:51.000712', NULL),
	(10000714, 100189, 10000003, 'PW21A-TS100189BL-M', '2021-04-15 11:52:51.000713', '2021-04-15 11:52:51.000713', NULL),
	(10000715, 100189, 10000004, 'PW21A-TS100189BL-L', '2021-04-15 11:52:51.000714', '2021-04-15 11:52:51.000714', NULL),
	(10000716, 100189, 10000005, 'PW21A-TS100189BL-XL', '2021-04-15 11:52:51.000715', '2021-04-15 11:52:51.000715', NULL),
	(10000717, 100189, 10000006, 'PW21A-TS100189BL-XXL', '2021-04-15 11:52:51.000716', '2021-04-15 11:52:51.000716', NULL),
	(10000718, 100190, 10000001, 'PW21A-TS100190WT-XS', '2021-04-15 11:52:51.000717', '2021-04-15 11:52:51.000717', NULL),
	(10000719, 100190, 10000002, 'PW21A-TS100190WT-S', '2021-04-15 11:52:51.000718', '2021-04-15 11:52:51.000718', NULL),
	(10000720, 100190, 10000003, 'PW21A-TS100190WT-M', '2021-04-15 11:52:51.000719', '2021-04-15 11:52:51.000719', NULL),
	(10000721, 100190, 10000004, 'PW21A-TS100190WT-L', '2021-04-15 11:52:51.000720', '2021-04-15 11:52:51.000720', NULL),
	(10000722, 100190, 10000005, 'PW21A-TS100190WT-XL', '2021-04-15 11:52:51.000721', '2021-04-15 11:52:51.000721', NULL),
	(10000723, 100190, 10000006, 'PW21A-TS100190WT-XXL', '2021-04-15 11:52:51.000722', '2021-04-15 11:52:51.000722', NULL),
	(10000724, 100191, 10000001, 'PW21A-TS100191YW -XS', '2021-04-15 11:52:51.000723', '2021-04-15 11:52:51.000723', NULL),
	(10000725, 100191, 10000002, 'PW21A-TS100191YW -S', '2021-04-15 11:52:51.000724', '2021-04-15 11:52:51.000724', NULL),
	(10000726, 100191, 10000003, 'PW21A-TS100191YW -M', '2021-04-15 11:52:51.000725', '2021-04-15 11:52:51.000725', NULL),
	(10000727, 100191, 10000004, 'PW21A-TS100191YW -L', '2021-04-15 11:52:51.000726', '2021-04-15 11:52:51.000726', NULL),
	(10000728, 100191, 10000005, 'PW21A-TS100191YW -XL', '2021-04-15 11:52:51.000727', '2021-04-15 11:52:51.000727', NULL),
	(10000729, 100191, 10000006, 'PW21A-TS100191YW -XXL', '2021-04-15 11:52:51.000728', '2021-04-15 11:52:51.000728', NULL),
	(10000730, 100192, 10000001, 'PW21A-TS100192GN-XS', '2021-04-15 11:52:51.000729', '2021-04-15 11:52:51.000729', NULL),
	(10000731, 100192, 10000002, 'PW21A-TS100192GN-S', '2021-04-15 11:52:51.000730', '2021-04-15 11:52:51.000730', NULL),
	(10000732, 100192, 10000003, 'PW21A-TS100192GN-M', '2021-04-15 11:52:51.000731', '2021-04-15 11:52:51.000731', NULL),
	(10000733, 100192, 10000004, 'PW21A-TS100192GN-L', '2021-04-15 11:52:51.000732', '2021-04-15 11:52:51.000732', NULL),
	(10000734, 100192, 10000005, 'PW21A-TS100192GN-XL', '2021-04-15 11:52:51.000733', '2021-04-15 11:52:51.000733', NULL),
	(10000735, 100192, 10000006, 'PW21A-TS100192GN-XXL', '2021-04-15 11:52:51.000734', '2021-04-15 11:52:51.000734', NULL),
	(10000736, 100193, 10000001, 'PW21A-TS100193BL-XS', '2021-04-15 11:52:51.000735', '2021-04-15 11:52:51.000735', NULL),
	(10000737, 100193, 10000002, 'PW21A-TS100193BL-S', '2021-04-15 11:52:51.000736', '2021-04-15 11:52:51.000736', NULL),
	(10000738, 100193, 10000003, 'PW21A-TS100193BL-M', '2021-04-15 11:52:51.000737', '2021-04-15 11:52:51.000737', NULL),
	(10000739, 100193, 10000004, 'PW21A-TS100193BL-L', '2021-04-15 11:52:51.000738', '2021-04-15 11:52:51.000738', NULL),
	(10000740, 100193, 10000005, 'PW21A-TS100193BL-XL', '2021-04-15 11:52:51.000739', '2021-04-15 11:52:51.000739', NULL),
	(10000741, 100193, 10000006, 'PW21A-TS100193BL-XXL', '2021-04-15 11:52:51.000740', '2021-04-15 11:52:51.000740', NULL),
	(10000742, 100194, 10000001, 'PW21A-TS100194RD-XS', '2021-04-15 11:52:51.000741', '2021-04-15 11:52:51.000741', NULL),
	(10000743, 100194, 10000002, 'PW21A-TS100194RD-S', '2021-04-15 11:52:51.000742', '2021-04-15 11:52:51.000742', NULL),
	(10000744, 100194, 10000003, 'PW21A-TS100194RD-M', '2021-04-15 11:52:51.000743', '2021-04-15 11:52:51.000743', NULL),
	(10000745, 100194, 10000004, 'PW21A-TS100194RD-L', '2021-04-15 11:52:51.000744', '2021-04-15 11:52:51.000744', NULL),
	(10000746, 100194, 10000005, 'PW21A-TS100194RD-XL', '2021-04-15 11:52:51.000745', '2021-04-15 11:52:51.000745', NULL),
	(10000747, 100194, 10000006, 'PW21A-TS100194RD-XXL', '2021-04-15 11:52:51.000746', '2021-04-15 11:52:51.000746', NULL),
	(10000748, 100195, 10000001, 'PW21A-TS100195BL-XS', '2021-04-15 11:52:51.000747', '2021-04-15 11:52:51.000747', NULL),
	(10000749, 100195, 10000002, 'PW21A-TS100195BL-S', '2021-04-15 11:52:51.000748', '2021-04-15 11:52:51.000748', NULL),
	(10000750, 100195, 10000003, 'PW21A-TS100195BL-M', '2021-04-15 11:52:51.000749', '2021-04-15 11:52:51.000749', NULL),
	(10000751, 100195, 10000004, 'PW21A-TS100195BL-L', '2021-04-15 11:52:51.000750', '2021-04-15 11:52:51.000750', NULL),
	(10000752, 100195, 10000005, 'PW21A-TS100195BL-XL', '2021-04-15 11:52:51.000751', '2021-04-15 11:52:51.000751', NULL),
	(10000753, 100195, 10000006, 'PW21A-TS100195BL-XXL', '2021-04-15 11:52:51.000752', '2021-04-15 11:52:51.000752', NULL),
	(10000754, 100196, 10000001, 'PW21A-TS100196BL-XS', '2021-04-15 11:52:51.000753', '2021-04-15 11:52:51.000753', NULL),
	(10000755, 100196, 10000002, 'PW21A-TS100196BL-S', '2021-04-15 11:52:51.000754', '2021-04-15 11:52:51.000754', NULL),
	(10000756, 100196, 10000003, 'PW21A-TS100196BL-M', '2021-04-15 11:52:51.000755', '2021-04-15 11:52:51.000755', NULL),
	(10000757, 100196, 10000004, 'PW21A-TS100196BL-L', '2021-04-15 11:52:51.000756', '2021-04-15 11:52:51.000756', NULL),
	(10000758, 100196, 10000005, 'PW21A-TS100196BL-XL', '2021-04-15 11:52:51.000757', '2021-04-15 11:52:51.000757', NULL),
	(10000759, 100196, 10000006, 'PW21A-TS100196BL-XXL', '2021-04-15 11:52:51.000758', '2021-04-15 11:52:51.000758', NULL),
	(10000760, 100197, 10000001, 'PW21A-TS100197BL-XS', '2021-04-15 11:52:51.000759', '2021-04-15 11:52:51.000759', NULL),
	(10000761, 100197, 10000002, 'PW21A-TS100197BL-S', '2021-04-15 11:52:51.000760', '2021-04-15 11:52:51.000760', NULL),
	(10000762, 100197, 10000003, 'PW21A-TS100197BL-M', '2021-04-15 11:52:51.000761', '2021-04-15 11:52:51.000761', NULL),
	(10000763, 100197, 10000004, 'PW21A-TS100197BL-L', '2021-04-15 11:52:51.000762', '2021-04-15 11:52:51.000762', NULL),
	(10000764, 100197, 10000005, 'PW21A-TS100197BL-XL', '2021-04-15 11:52:51.000763', '2021-04-15 11:52:51.000763', NULL),
	(10000765, 100197, 10000006, 'PW21A-TS100197BL-XXL', '2021-04-15 11:52:51.000764', '2021-04-15 11:52:51.000764', NULL),
	(10000766, 100198, 10000001, 'PW21A-TS100198BL-XS', '2021-04-15 11:52:51.000765', '2021-04-15 11:52:51.000765', NULL),
	(10000767, 100198, 10000002, 'PW21A-TS100198BL-S', '2021-04-15 11:52:51.000766', '2021-04-15 11:52:51.000766', NULL),
	(10000768, 100198, 10000003, 'PW21A-TS100198BL-M', '2021-04-15 11:52:51.000767', '2021-04-15 11:52:51.000767', NULL),
	(10000769, 100198, 10000004, 'PW21A-TS100198BL-L', '2021-04-15 11:52:51.000768', '2021-04-15 11:52:51.000768', NULL),
	(10000770, 100198, 10000005, 'PW21A-TS100198BL-XL', '2021-04-15 11:52:51.000769', '2021-04-15 11:52:51.000769', NULL),
	(10000771, 100198, 10000006, 'PW21A-TS100198BL-XXL', '2021-04-15 11:52:51.000770', '2021-04-15 11:52:51.000770', NULL),
	(10000772, 100199, 10000001, 'PW21A-TS100199BL-XS', '2021-04-15 11:52:51.000771', '2021-04-15 11:52:51.000771', NULL),
	(10000773, 100199, 10000002, 'PW21A-TS100199BL-S', '2021-04-15 11:52:51.000772', '2021-04-15 11:52:51.000772', NULL),
	(10000774, 100199, 10000003, 'PW21A-TS100199BL-M', '2021-04-15 11:52:51.000773', '2021-04-15 11:52:51.000773', NULL),
	(10000775, 100199, 10000004, 'PW21A-TS100199BL-L', '2021-04-15 11:52:51.000774', '2021-04-15 11:52:51.000774', NULL),
	(10000776, 100199, 10000005, 'PW21A-TS100199BL-XL', '2021-04-15 11:52:51.000775', '2021-04-15 11:52:51.000775', NULL),
	(10000777, 100199, 10000006, 'PW21A-TS100199BL-XXL', '2021-04-15 11:52:51.000776', '2021-04-15 11:52:51.000776', NULL),
	(10000778, 100200, 10000001, 'PW21A-TS100200BL-XS', '2021-04-15 11:52:51.000777', '2021-04-15 11:52:51.000777', NULL),
	(10000779, 100200, 10000002, 'PW21A-TS100200BL-S', '2021-04-15 11:52:51.000778', '2021-04-15 11:52:51.000778', NULL),
	(10000780, 100200, 10000003, 'PW21A-TS100200BL-M', '2021-04-15 11:52:51.000779', '2021-04-15 11:52:51.000779', NULL),
	(10000781, 100200, 10000004, 'PW21A-TS100200BL-L', '2021-04-15 11:52:51.000780', '2021-04-15 11:52:51.000780', NULL),
	(10000782, 100200, 10000005, 'PW21A-TS100200BL-XL', '2021-04-15 11:52:51.000781', '2021-04-15 11:52:51.000781', NULL),
	(10000783, 100200, 10000006, 'PW21A-TS100200BL-XXL', '2021-04-15 11:52:51.000782', '2021-04-15 11:52:51.000782', NULL),
	(10000784, 100201, 10000001, 'PW21A-TS100201BL-XS', '2021-04-15 11:52:51.000783', '2021-04-15 11:52:51.000783', NULL),
	(10000785, 100201, 10000002, 'PW21A-TS100201BL-S', '2021-04-15 11:52:51.000784', '2021-04-15 11:52:51.000784', NULL),
	(10000786, 100201, 10000003, 'PW21A-TS100201BL-M', '2021-04-15 11:52:51.000785', '2021-04-15 11:52:51.000785', NULL),
	(10000787, 100201, 10000004, 'PW21A-TS100201BL-L', '2021-04-15 11:52:51.000786', '2021-04-15 11:52:51.000786', NULL),
	(10000788, 100201, 10000005, 'PW21A-TS100201BL-XL', '2021-04-15 11:52:51.000787', '2021-04-15 11:52:51.000787', NULL),
	(10000789, 100201, 10000006, 'PW21A-TS100201BL-XXL', '2021-04-15 11:52:51.000788', '2021-04-15 11:52:51.000788', NULL),
	(10000790, 100202, 10000001, 'PW21A-TS100202BL-XS', '2021-04-15 11:52:51.000789', '2021-04-15 11:52:51.000789', NULL),
	(10000791, 100202, 10000002, 'PW21A-TS100202BL-S', '2021-04-15 11:52:51.000790', '2021-04-15 11:52:51.000790', NULL),
	(10000792, 100202, 10000003, 'PW21A-TS100202BL-M', '2021-04-15 11:52:51.000791', '2021-04-15 11:52:51.000791', NULL),
	(10000793, 100202, 10000004, 'PW21A-TS100202BL-L', '2021-04-15 11:52:51.000792', '2021-04-15 11:52:51.000792', NULL),
	(10000794, 100202, 10000005, 'PW21A-TS100202BL-XL', '2021-04-15 11:52:51.000793', '2021-04-15 11:52:51.000793', NULL),
	(10000795, 100202, 10000006, 'PW21A-TS100202BL-XXL', '2021-04-15 11:52:51.000794', '2021-04-15 11:52:51.000794', NULL),
	(10000796, 100203, 10000001, 'PW21A-TS100203BL-XS', '2021-04-15 11:52:51.000795', '2021-04-15 11:52:51.000795', NULL),
	(10000797, 100203, 10000002, 'PW21A-TS100203BL-S', '2021-04-15 11:52:51.000796', '2021-04-15 11:52:51.000796', NULL),
	(10000798, 100203, 10000003, 'PW21A-TS100203BL-M', '2021-04-15 11:52:51.000797', '2021-04-15 11:52:51.000797', NULL),
	(10000799, 100203, 10000004, 'PW21A-TS100203BL-L', '2021-04-15 11:52:51.000798', '2021-04-15 11:52:51.000798', NULL),
	(10000800, 100203, 10000005, 'PW21A-TS100203BL-XL', '2021-04-15 11:52:51.000799', '2021-04-15 11:52:51.000799', NULL),
	(10000801, 100203, 10000006, 'PW21A-TS100203BL-XXL', '2021-04-15 11:52:51.000800', '2021-04-15 11:52:51.000800', NULL),
	(10000802, 100204, 10000001, 'PW21A-TS100204BL-XS', '2021-04-15 11:52:51.000801', '2021-04-15 11:52:51.000801', NULL),
	(10000803, 100204, 10000002, 'PW21A-TS100204BL-S', '2021-04-15 11:52:51.000802', '2021-04-15 11:52:51.000802', NULL),
	(10000804, 100204, 10000003, 'PW21A-TS100204BL-M', '2021-04-15 11:52:51.000803', '2021-04-15 11:52:51.000803', NULL),
	(10000805, 100204, 10000004, 'PW21A-TS100204BL-L', '2021-04-15 11:52:51.000804', '2021-04-15 11:52:51.000804', NULL),
	(10000806, 100204, 10000005, 'PW21A-TS100204BL-XL', '2021-04-15 11:52:51.000805', '2021-04-15 11:52:51.000805', NULL),
	(10000807, 100204, 10000006, 'PW21A-TS100204BL-XXL', '2021-04-15 11:52:51.000806', '2021-04-15 11:52:51.000806', NULL),
	(10000808, 100205, 10000001, 'PW21A-TS100205WT-XS', '2021-04-15 11:52:51.000807', '2021-04-15 11:52:51.000807', NULL),
	(10000809, 100205, 10000002, 'PW21A-TS100205WT-S', '2021-04-15 11:52:51.000808', '2021-04-15 11:52:51.000808', NULL),
	(10000810, 100205, 10000003, 'PW21A-TS100205WT-M', '2021-04-15 11:52:51.000809', '2021-04-15 11:52:51.000809', NULL),
	(10000811, 100205, 10000004, 'PW21A-TS100205WT-L', '2021-04-15 11:52:51.000810', '2021-04-15 11:52:51.000810', NULL),
	(10000812, 100205, 10000005, 'PW21A-TS100205WT-XL', '2021-04-15 11:52:51.000811', '2021-04-15 11:52:51.000811', NULL),
	(10000813, 100205, 10000006, 'PW21A-TS100205WT-XXL', '2021-04-15 11:52:51.000812', '2021-04-15 11:52:51.000812', NULL),
	(10000814, 100206, 10000001, 'PW21A-TS100206WT-XS', '2021-04-15 11:52:51.000813', '2021-04-15 11:52:51.000813', NULL),
	(10000815, 100206, 10000002, 'PW21A-TS100206WT-S', '2021-04-15 11:52:51.000814', '2021-04-15 11:52:51.000814', NULL),
	(10000816, 100206, 10000003, 'PW21A-TS100206WT-M', '2021-04-15 11:52:51.000815', '2021-04-15 11:52:51.000815', NULL),
	(10000817, 100206, 10000004, 'PW21A-TS100206WT-L', '2021-04-15 11:52:51.000816', '2021-04-15 11:52:51.000816', NULL),
	(10000818, 100206, 10000005, 'PW21A-TS100206WT-XL', '2021-04-15 11:52:51.000817', '2021-04-15 11:52:51.000817', NULL),
	(10000819, 100206, 10000006, 'PW21A-TS100206WT-XXL', '2021-04-15 11:52:51.000818', '2021-04-15 11:52:51.000818', NULL),
	(10000820, 100207, 10000001, 'PW21A-TS100207BL-XS', '2021-04-15 11:52:51.000819', '2021-04-15 11:52:51.000819', NULL),
	(10000821, 100207, 10000002, 'PW21A-TS100207BL-S', '2021-04-15 11:52:51.000820', '2021-04-15 11:52:51.000820', NULL),
	(10000822, 100207, 10000003, 'PW21A-TS100207BL-M', '2021-04-15 11:52:51.000821', '2021-04-15 11:52:51.000821', NULL),
	(10000823, 100207, 10000004, 'PW21A-TS100207BL-L', '2021-04-15 11:52:51.000822', '2021-04-15 11:52:51.000822', NULL),
	(10000824, 100207, 10000005, 'PW21A-TS100207BL-XL', '2021-04-15 11:52:51.000823', '2021-04-15 11:52:51.000823', NULL),
	(10000825, 100207, 10000006, 'PW21A-TS100207BL-XXL', '2021-04-15 11:52:51.000824', '2021-04-15 11:52:51.000824', NULL),
	(10000826, 100208, 10000001, 'PW21A-TS100208BL-XS', '2021-04-15 11:52:51.000825', '2021-04-15 11:52:51.000825', NULL),
	(10000827, 100208, 10000002, 'PW21A-TS100208BL-S', '2021-04-15 11:52:51.000826', '2021-04-15 11:52:51.000826', NULL),
	(10000828, 100208, 10000003, 'PW21A-TS100208BL-M', '2021-04-15 11:52:51.000827', '2021-04-15 11:52:51.000827', NULL),
	(10000829, 100208, 10000004, 'PW21A-TS100208BL-L', '2021-04-15 11:52:51.000828', '2021-04-15 11:52:51.000828', NULL),
	(10000830, 100208, 10000005, 'PW21A-TS100208BL-XL', '2021-04-15 11:52:51.000829', '2021-04-15 11:52:51.000829', NULL),
	(10000831, 100208, 10000006, 'PW21A-TS100208BL-XXL', '2021-04-15 11:52:51.000830', '2021-04-15 11:52:51.000830', NULL),
	(10000832, 100209, 10000001, 'PW21A-TS100209BL-XS', '2021-04-15 11:52:51.000831', '2021-04-15 11:52:51.000831', NULL),
	(10000833, 100209, 10000002, 'PW21A-TS100209BL-S', '2021-04-15 11:52:51.000832', '2021-04-15 11:52:51.000832', NULL),
	(10000834, 100209, 10000003, 'PW21A-TS100209BL-M', '2021-04-15 11:52:51.000833', '2021-04-15 11:52:51.000833', NULL),
	(10000835, 100209, 10000004, 'PW21A-TS100209BL-L', '2021-04-15 11:52:51.000834', '2021-04-15 11:52:51.000834', NULL),
	(10000836, 100209, 10000005, 'PW21A-TS100209BL-XL', '2021-04-15 11:52:51.000835', '2021-04-15 11:52:51.000835', NULL),
	(10000837, 100209, 10000006, 'PW21A-TS100209BL-XXL', '2021-04-15 11:52:51.000836', '2021-04-15 11:52:51.000836', NULL),
	(10000838, 100210, 10000001, 'PW21A-TS100210BL-XS', '2021-04-15 11:52:51.000837', '2021-04-15 11:52:51.000837', NULL),
	(10000839, 100210, 10000002, 'PW21A-TS100210BL-S', '2021-04-15 11:52:51.000838', '2021-04-15 11:52:51.000838', NULL),
	(10000840, 100210, 10000003, 'PW21A-TS100210BL-M', '2021-04-15 11:52:51.000839', '2021-04-15 11:52:51.000839', NULL),
	(10000841, 100210, 10000004, 'PW21A-TS100210BL-L', '2021-04-15 11:52:51.000840', '2021-04-15 11:52:51.000840', NULL),
	(10000842, 100210, 10000005, 'PW21A-TS100210BL-XL', '2021-04-15 11:52:51.000841', '2021-04-15 11:52:51.000841', NULL),
	(10000843, 100210, 10000006, 'PW21A-TS100210BL-XXL', '2021-04-15 11:52:51.000842', '2021-04-15 11:52:51.000842', NULL),
	(10000844, 100211, 10000001, 'PW21A-TS100211BL-XS', '2021-04-15 11:52:51.000843', '2021-04-15 11:52:51.000843', NULL),
	(10000845, 100211, 10000002, 'PW21A-TS100211BL-S', '2021-04-15 11:52:51.000844', '2021-04-15 11:52:51.000844', NULL),
	(10000846, 100211, 10000003, 'PW21A-TS100211BL-M', '2021-04-15 11:52:51.000845', '2021-04-15 11:52:51.000845', NULL),
	(10000847, 100211, 10000004, 'PW21A-TS100211BL-L', '2021-04-15 11:52:51.000846', '2021-04-15 11:52:51.000846', NULL),
	(10000848, 100211, 10000005, 'PW21A-TS100211BL-XL', '2021-04-15 11:52:51.000847', '2021-04-15 11:52:51.000847', NULL),
	(10000849, 100211, 10000006, 'PW21A-TS100211BL-XXL', '2021-04-15 11:52:51.000848', '2021-04-15 11:52:51.000848', NULL),
	(10000850, 100212, 10000001, 'PW21A-TS100212GN-XS', '2021-04-15 11:52:51.000849', '2021-04-15 11:52:51.000849', NULL),
	(10000851, 100212, 10000002, 'PW21A-TS100212GN-S', '2021-04-15 11:52:51.000850', '2021-04-15 11:52:51.000850', NULL),
	(10000852, 100212, 10000003, 'PW21A-TS100212GN-M', '2021-04-15 11:52:51.000851', '2021-04-15 11:52:51.000851', NULL),
	(10000853, 100212, 10000004, 'PW21A-TS100212GN-L', '2021-04-15 11:52:51.000852', '2021-04-15 11:52:51.000852', NULL),
	(10000854, 100212, 10000005, 'PW21A-TS100212GN-XL', '2021-04-15 11:52:51.000853', '2021-04-15 11:52:51.000853', NULL),
	(10000855, 100212, 10000006, 'PW21A-TS100212GN-XXL', '2021-04-15 11:52:51.000854', '2021-04-15 11:52:51.000854', NULL),
	(10000856, 100213, 10000001, 'PW21A-TS100213BL-XS', '2021-04-15 11:52:51.000855', '2021-04-15 11:52:51.000855', NULL),
	(10000857, 100213, 10000002, 'PW21A-TS100213BL-S', '2021-04-15 11:52:51.000856', '2021-04-15 11:52:51.000856', NULL),
	(10000858, 100213, 10000003, 'PW21A-TS100213BL-M', '2021-04-15 11:52:51.000857', '2021-04-15 11:52:51.000857', NULL),
	(10000859, 100213, 10000004, 'PW21A-TS100213BL-L', '2021-04-15 11:52:51.000858', '2021-04-15 11:52:51.000858', NULL),
	(10000860, 100213, 10000005, 'PW21A-TS100213BL-XL', '2021-04-15 11:52:51.000859', '2021-04-15 11:52:51.000859', NULL),
	(10000861, 100213, 10000006, 'PW21A-TS100213BL-XXL', '2021-04-15 11:52:51.000860', '2021-04-15 11:52:51.000860', NULL),
	(10000862, 100214, 10000001, 'PW21A-TS100214BL-XS', '2021-04-15 11:52:51.000861', '2021-04-15 11:52:51.000861', NULL),
	(10000863, 100214, 10000002, 'PW21A-TS100214BL-S', '2021-04-15 11:52:51.000862', '2021-04-15 11:52:51.000862', NULL),
	(10000864, 100214, 10000003, 'PW21A-TS100214BL-M', '2021-04-15 11:52:51.000863', '2021-04-15 11:52:51.000863', NULL),
	(10000865, 100214, 10000004, 'PW21A-TS100214BL-L', '2021-04-15 11:52:51.000864', '2021-04-15 11:52:51.000864', NULL),
	(10000866, 100214, 10000005, 'PW21A-TS100214BL-XL', '2021-04-15 11:52:51.000865', '2021-04-15 11:52:51.000865', NULL),
	(10000867, 100214, 10000006, 'PW21A-TS100214BL-XXL', '2021-04-15 11:52:51.000866', '2021-04-15 11:52:51.000866', NULL),
	(10000868, 100215, 10000001, 'PW21A-TS100215BL-XS', '2021-04-15 11:52:51.000867', '2021-04-15 11:52:51.000867', NULL),
	(10000869, 100215, 10000002, 'PW21A-TS100215BL-S', '2021-04-15 11:52:51.000868', '2021-04-15 11:52:51.000868', NULL),
	(10000870, 100215, 10000003, 'PW21A-TS100215BL-M', '2021-04-15 11:52:51.000869', '2021-04-15 11:52:51.000869', NULL),
	(10000871, 100215, 10000004, 'PW21A-TS100215BL-L', '2021-04-15 11:52:51.000870', '2021-04-15 11:52:51.000870', NULL),
	(10000872, 100215, 10000005, 'PW21A-TS100215BL-XL', '2021-04-15 11:52:51.000871', '2021-04-15 11:52:51.000871', NULL),
	(10000873, 100215, 10000006, 'PW21A-TS100215BL-XXL', '2021-04-15 11:52:51.000872', '2021-04-15 11:52:51.000872', NULL),
	(10000874, 100216, 10000001, 'PW21A-TS100216NV-XS', '2021-04-15 11:52:51.000873', '2021-04-15 11:52:51.000873', NULL),
	(10000875, 100216, 10000002, 'PW21A-TS100216NV-S', '2021-04-15 11:52:51.000874', '2021-04-15 11:52:51.000874', NULL),
	(10000876, 100216, 10000003, 'PW21A-TS100216NV-M', '2021-04-15 11:52:51.000875', '2021-04-15 11:52:51.000875', NULL),
	(10000877, 100216, 10000004, 'PW21A-TS100216NV-L', '2021-04-15 11:52:51.000876', '2021-04-15 11:52:51.000876', NULL),
	(10000878, 100216, 10000005, 'PW21A-TS100216NV-XL', '2021-04-15 11:52:51.000877', '2021-04-15 11:52:51.000877', NULL),
	(10000879, 100216, 10000006, 'PW21A-TS100216NV-XXL', '2021-04-15 11:52:51.000878', '2021-04-15 11:52:51.000878', NULL),
	(10000880, 100217, 10000001, 'PW21A-TS100217BL-XS', '2021-04-15 11:52:51.000879', '2021-04-15 11:52:51.000879', NULL),
	(10000881, 100217, 10000002, 'PW21A-TS100217BL-S', '2021-04-15 11:52:51.000880', '2021-04-15 11:52:51.000880', NULL),
	(10000882, 100217, 10000003, 'PW21A-TS100217BL-M', '2021-04-15 11:52:51.000881', '2021-04-15 11:52:51.000881', NULL),
	(10000883, 100217, 10000004, 'PW21A-TS100217BL-L', '2021-04-15 11:52:51.000882', '2021-04-15 11:52:51.000882', NULL),
	(10000884, 100217, 10000005, 'PW21A-TS100217BL-XL', '2021-04-15 11:52:51.000883', '2021-04-15 11:52:51.000883', NULL),
	(10000885, 100217, 10000006, 'PW21A-TS100217BL-XXL', '2021-04-15 11:52:51.000884', '2021-04-15 11:52:51.000884', NULL),
	(10000886, 100218, 10000001, 'PW21A-TS100218BL-XS', '2021-04-15 11:52:51.000885', '2021-04-15 11:52:51.000885', NULL),
	(10000887, 100218, 10000002, 'PW21A-TS100218BL-S', '2021-04-15 11:52:51.000886', '2021-04-15 11:52:51.000886', NULL),
	(10000888, 100218, 10000003, 'PW21A-TS100218BL-M', '2021-04-15 11:52:51.000887', '2021-04-15 11:52:51.000887', NULL),
	(10000889, 100218, 10000004, 'PW21A-TS100218BL-L', '2021-04-15 11:52:51.000888', '2021-04-15 11:52:51.000888', NULL),
	(10000890, 100218, 10000005, 'PW21A-TS100218BL-XL', '2021-04-15 11:52:51.000889', '2021-04-15 11:52:51.000889', NULL),
	(10000891, 100218, 10000006, 'PW21A-TS100218BL-XXL', '2021-04-15 11:52:51.000890', '2021-04-15 11:52:51.000890', NULL),
	(10000892, 100219, 10000001, 'PW21A-TS100219BL-XS', '2021-04-15 11:52:51.000891', '2021-04-15 11:52:51.000891', NULL),
	(10000893, 100219, 10000002, 'PW21A-TS100219BL-S', '2021-04-15 11:52:51.000892', '2021-04-15 11:52:51.000892', NULL),
	(10000894, 100219, 10000003, 'PW21A-TS100219BL-M', '2021-04-15 11:52:51.000893', '2021-04-15 11:52:51.000893', NULL),
	(10000895, 100219, 10000004, 'PW21A-TS100219BL-L', '2021-04-15 11:52:51.000894', '2021-04-15 11:52:51.000894', NULL),
	(10000896, 100219, 10000005, 'PW21A-TS100219BL-XL', '2021-04-15 11:52:51.000895', '2021-04-15 11:52:51.000895', NULL),
	(10000897, 100219, 10000006, 'PW21A-TS100219BL-XXL', '2021-04-15 11:52:51.000896', '2021-04-15 11:52:51.000896', NULL),
	(10000898, 100220, 10000001, 'PW21A-TS100220BL-XS', '2021-04-15 11:52:51.000897', '2021-04-15 11:52:51.000897', NULL),
	(10000899, 100220, 10000002, 'PW21A-TS100220BL-S', '2021-04-15 11:52:51.000898', '2021-04-15 11:52:51.000898', NULL),
	(10000900, 100220, 10000003, 'PW21A-TS100220BL-M', '2021-04-15 11:52:51.000899', '2021-04-15 11:52:51.000899', NULL),
	(10000901, 100220, 10000004, 'PW21A-TS100220BL-L', '2021-04-15 11:52:51.000900', '2021-04-15 11:52:51.000900', NULL),
	(10000902, 100220, 10000005, 'PW21A-TS100220BL-XL', '2021-04-15 11:52:51.000901', '2021-04-15 11:52:51.000901', NULL),
	(10000903, 100220, 10000006, 'PW21A-TS100220BL-XXL', '2021-04-15 11:52:51.000902', '2021-04-15 11:52:51.000902', NULL),
	(10000904, 100221, 10000001, 'PW21A-TK100221BL-XS', '2021-04-15 11:52:51.000903', '2021-04-15 11:52:51.000903', NULL),
	(10000905, 100221, 10000002, 'PW21A-TK100221BL-S', '2021-04-15 11:52:51.000904', '2021-04-15 11:52:51.000904', NULL),
	(10000906, 100221, 10000003, 'PW21A-TK100221BL-M', '2021-04-15 11:52:51.000905', '2021-04-15 11:52:51.000905', NULL),
	(10000907, 100221, 10000004, 'PW21A-TK100221BL-L', '2021-04-15 11:52:51.000906', '2021-04-15 11:52:51.000906', NULL),
	(10000908, 100221, 10000005, 'PW21A-TK100221BL-XL', '2021-04-15 11:52:51.000907', '2021-04-15 11:52:51.000907', NULL),
	(10000909, 100221, 10000006, 'PW21A-TK100221BL-XXL', '2021-04-15 11:52:51.000908', '2021-04-15 11:52:51.000908', NULL),
	(10000910, 100222, 10000001, 'PW21A-TS100222BL-XS', '2021-04-15 11:52:51.000909', '2021-04-15 11:52:51.000909', NULL),
	(10000911, 100222, 10000002, 'PW21A-TS100222BL-S', '2021-04-15 11:52:51.000910', '2021-04-15 11:52:51.000910', NULL),
	(10000912, 100222, 10000003, 'PW21A-TS100222BL-M', '2021-04-15 11:52:51.000911', '2021-04-15 11:52:51.000911', NULL),
	(10000913, 100222, 10000004, 'PW21A-TS100222BL-L', '2021-04-15 11:52:51.000912', '2021-04-15 11:52:51.000912', NULL),
	(10000914, 100222, 10000005, 'PW21A-TS100222BL-XL', '2021-04-15 11:52:51.000913', '2021-04-15 11:52:51.000913', NULL),
	(10000915, 100222, 10000006, 'PW21A-TS100222BL-XXL', '2021-04-15 11:52:51.000914', '2021-04-15 11:52:51.000914', NULL),
	(10000916, 100223, 10000001, 'PW21A-TS100223BL-XS', '2021-04-15 11:52:51.000915', '2021-04-15 11:52:51.000915', NULL),
	(10000917, 100223, 10000002, 'PW21A-TS100223BL-S', '2021-04-15 11:52:51.000916', '2021-04-15 11:52:51.000916', NULL),
	(10000918, 100223, 10000003, 'PW21A-TS100223BL-M', '2021-04-15 11:52:51.000917', '2021-04-15 11:52:51.000917', NULL),
	(10000919, 100223, 10000004, 'PW21A-TS100223BL-L', '2021-04-15 11:52:51.000918', '2021-04-15 11:52:51.000918', NULL),
	(10000920, 100223, 10000005, 'PW21A-TS100223BL-XL', '2021-04-15 11:52:51.000919', '2021-04-15 11:52:51.000919', NULL),
	(10000921, 100223, 10000006, 'PW21A-TS100223BL-XXL', '2021-04-15 11:52:51.000920', '2021-04-15 11:52:51.000920', NULL),
	(10000922, 100224, 10000001, 'PW21A-TK100224BL-XS', '2021-04-15 11:52:51.000921', '2021-04-15 11:52:51.000921', NULL),
	(10000923, 100224, 10000002, 'PW21A-TK100224BL-S', '2021-04-15 11:52:51.000922', '2021-04-15 11:52:51.000922', NULL),
	(10000924, 100224, 10000003, 'PW21A-TK100224BL-M', '2021-04-15 11:52:51.000923', '2021-04-15 11:52:51.000923', NULL),
	(10000925, 100224, 10000004, 'PW21A-TK100224BL-L', '2021-04-15 11:52:51.000924', '2021-04-15 11:52:51.000924', NULL),
	(10000926, 100224, 10000005, 'PW21A-TK100224BL-XL', '2021-04-15 11:52:51.000925', '2021-04-15 11:52:51.000925', NULL),
	(10000927, 100224, 10000006, 'PW21A-TK100224BL-XXL', '2021-04-15 11:52:51.000926', '2021-04-15 11:52:51.000926', NULL),
	(10000928, 100225, 10000001, 'PW21A-TK100225BL-XS', '2021-04-15 11:52:51.000927', '2021-04-15 11:52:51.000927', NULL),
	(10000929, 100225, 10000002, 'PW21A-TK100225BL-S', '2021-04-15 11:52:51.000928', '2021-04-15 11:52:51.000928', NULL),
	(10000930, 100225, 10000003, 'PW21A-TK100225BL-M', '2021-04-15 11:52:51.000929', '2021-04-15 11:52:51.000929', NULL),
	(10000931, 100225, 10000004, 'PW21A-TK100225BL-L', '2021-04-15 11:52:51.000930', '2021-04-15 11:52:51.000930', NULL),
	(10000932, 100225, 10000005, 'PW21A-TK100225BL-XL', '2021-04-15 11:52:51.000931', '2021-04-15 11:52:51.000931', NULL),
	(10000933, 100225, 10000006, 'PW21A-TK100225BL-XXL', '2021-04-15 11:52:51.000932', '2021-04-15 11:52:51.000932', NULL),
	(10000934, 100226, 10000001, 'PW21A-TS100226BL-XS', '2021-04-15 11:52:51.000933', '2021-04-15 11:52:51.000933', NULL),
	(10000935, 100226, 10000002, 'PW21A-TS100226BL-S', '2021-04-15 11:52:51.000934', '2021-04-15 11:52:51.000934', NULL),
	(10000936, 100226, 10000003, 'PW21A-TS100226BL-M', '2021-04-15 11:52:51.000935', '2021-04-15 11:52:51.000935', NULL),
	(10000937, 100226, 10000004, 'PW21A-TS100226BL-L', '2021-04-15 11:52:51.000936', '2021-04-15 11:52:51.000936', NULL),
	(10000938, 100226, 10000005, 'PW21A-TS100226BL-XL', '2021-04-15 11:52:51.000937', '2021-04-15 11:52:51.000937', NULL),
	(10000939, 100226, 10000006, 'PW21A-TS100226BL-XXL', '2021-04-15 11:52:51.000938', '2021-04-15 11:52:51.000938', NULL),
	(10000940, 100227, 10000001, 'PW21A-TK100227BL-XS', '2021-04-15 11:52:51.000939', '2021-04-15 11:52:51.000939', NULL),
	(10000941, 100227, 10000002, 'PW21A-TK100227BL-S', '2021-04-15 11:52:51.000940', '2021-04-15 11:52:51.000940', NULL),
	(10000942, 100227, 10000003, 'PW21A-TK100227BL-M', '2021-04-15 11:52:51.000941', '2021-04-15 11:52:51.000941', NULL),
	(10000943, 100227, 10000004, 'PW21A-TK100227BL-L', '2021-04-15 11:52:51.000942', '2021-04-15 11:52:51.000942', NULL),
	(10000944, 100227, 10000005, 'PW21A-TK100227BL-XL', '2021-04-15 11:52:51.000943', '2021-04-15 11:52:51.000943', NULL),
	(10000945, 100227, 10000006, 'PW21A-TK100227BL-XXL', '2021-04-15 11:52:51.000944', '2021-04-15 11:52:51.000944', NULL),
	(10000946, 100228, 10000001, 'PW21A-TS100228BL-XS', '2021-04-15 11:52:51.000945', '2021-04-15 11:52:51.000945', NULL),
	(10000947, 100228, 10000002, 'PW21A-TS100228BL-S', '2021-04-15 11:52:51.000946', '2021-04-15 11:52:51.000946', NULL),
	(10000948, 100228, 10000003, 'PW21A-TS100228BL-M', '2021-04-15 11:52:51.000947', '2021-04-15 11:52:51.000947', NULL),
	(10000949, 100228, 10000004, 'PW21A-TS100228BL-L', '2021-04-15 11:52:51.000948', '2021-04-15 11:52:51.000948', NULL),
	(10000950, 100228, 10000005, 'PW21A-TS100228BL-XL', '2021-04-15 11:52:51.000949', '2021-04-15 11:52:51.000949', NULL),
	(10000951, 100228, 10000006, 'PW21A-TS100228BL-XXL', '2021-04-15 11:52:51.000950', '2021-04-15 11:52:51.000950', NULL),
	(10000952, 100229, 10000001, 'PW21A-TK100229BL-XS', '2021-04-15 11:52:51.000951', '2021-04-15 11:52:51.000951', NULL),
	(10000953, 100229, 10000002, 'PW21A-TK100229BL-S', '2021-04-15 11:52:51.000952', '2021-04-15 11:52:51.000952', NULL),
	(10000954, 100229, 10000003, 'PW21A-TK100229BL-M', '2021-04-15 11:52:51.000953', '2021-04-15 11:52:51.000953', NULL),
	(10000955, 100229, 10000004, 'PW21A-TK100229BL-L', '2021-04-15 11:52:51.000954', '2021-04-15 11:52:51.000954', NULL),
	(10000956, 100229, 10000005, 'PW21A-TK100229BL-XL', '2021-04-15 11:52:51.000955', '2021-04-15 11:52:51.000955', NULL),
	(10000957, 100229, 10000006, 'PW21A-TK100229BL-XXL', '2021-04-15 11:52:51.000956', '2021-04-15 11:52:51.000956', NULL),
	(10000958, 100230, 10000001, 'PW21A-TK100230BL-XS', '2021-04-15 11:52:51.000957', '2021-04-15 11:52:51.000957', NULL),
	(10000959, 100230, 10000002, 'PW21A-TK100230BL-S', '2021-04-15 11:52:51.000958', '2021-04-15 11:52:51.000958', NULL),
	(10000960, 100230, 10000003, 'PW21A-TK100230BL-M', '2021-04-15 11:52:51.000959', '2021-04-15 11:52:51.000959', NULL),
	(10000961, 100230, 10000004, 'PW21A-TK100230BL-L', '2021-04-15 11:52:51.000960', '2021-04-15 11:52:51.000960', NULL),
	(10000962, 100230, 10000005, 'PW21A-TK100230BL-XL', '2021-04-15 11:52:51.000961', '2021-04-15 11:52:51.000961', NULL),
	(10000963, 100230, 10000006, 'PW21A-TK100230BL-XXL', '2021-04-15 11:52:51.000962', '2021-04-15 11:52:51.000962', NULL),
	(10000964, 100231, 10000001, 'PW21A-TS100231BL-XS', '2021-04-15 11:52:51.000963', '2021-04-15 11:52:51.000963', NULL),
	(10000965, 100231, 10000002, 'PW21A-TS100231BL-S', '2021-04-15 11:52:51.000964', '2021-04-15 11:52:51.000964', NULL),
	(10000966, 100231, 10000003, 'PW21A-TS100231BL-M', '2021-04-15 11:52:51.000965', '2021-04-15 11:52:51.000965', NULL),
	(10000967, 100231, 10000004, 'PW21A-TS100231BL-L', '2021-04-15 11:52:51.000966', '2021-04-15 11:52:51.000966', NULL),
	(10000968, 100231, 10000005, 'PW21A-TS100231BL-XL', '2021-04-15 11:52:51.000967', '2021-04-15 11:52:51.000967', NULL),
	(10000969, 100231, 10000006, 'PW21A-TS100231BL-XXL', '2021-04-15 11:52:51.000968', '2021-04-15 11:52:51.000968', NULL),
	(10000970, 100232, 10000001, 'PW21A-TK100232GN-XS', '2021-04-15 11:52:51.000969', '2021-04-15 11:52:51.000969', NULL),
	(10000971, 100232, 10000002, 'PW21A-TK100232GN-S', '2021-04-15 11:52:51.000970', '2021-04-15 11:52:51.000970', NULL),
	(10000972, 100232, 10000003, 'PW21A-TK100232GN-M', '2021-04-15 11:52:51.000971', '2021-04-15 11:52:51.000971', NULL),
	(10000973, 100232, 10000004, 'PW21A-TK100232GN-L', '2021-04-15 11:52:51.000972', '2021-04-15 11:52:51.000972', NULL),
	(10000974, 100232, 10000005, 'PW21A-TK100232GN-XL', '2021-04-15 11:52:51.000973', '2021-04-15 11:52:51.000973', NULL),
	(10000975, 100232, 10000006, 'PW21A-TK100232GN-XXL', '2021-04-15 11:52:51.000974', '2021-04-15 11:52:51.000974', NULL),
	(10000976, 100233, 10000001, 'PW21A-TS100233BL-XS', '2021-04-15 11:52:51.000975', '2021-04-15 11:52:51.000975', NULL),
	(10000977, 100233, 10000002, 'PW21A-TS100233BL-S', '2021-04-15 11:52:51.000976', '2021-04-15 11:52:51.000976', NULL),
	(10000978, 100233, 10000003, 'PW21A-TS100233BL-M', '2021-04-15 11:52:51.000977', '2021-04-15 11:52:51.000977', NULL),
	(10000979, 100233, 10000004, 'PW21A-TS100233BL-L', '2021-04-15 11:52:51.000978', '2021-04-15 11:52:51.000978', NULL),
	(10000980, 100233, 10000005, 'PW21A-TS100233BL-XL', '2021-04-15 11:52:51.000979', '2021-04-15 11:52:51.000979', NULL),
	(10000981, 100233, 10000006, 'PW21A-TS100233BL-XXL', '2021-04-15 11:52:51.000980', '2021-04-15 11:52:51.000980', NULL),
	(10000982, 100234, 10000001, 'PW21A-TK100234BL-XS', '2021-04-15 11:52:51.000981', '2021-04-15 11:52:51.000981', NULL),
	(10000983, 100234, 10000002, 'PW21A-TK100234BL-S', '2021-04-15 11:52:51.000982', '2021-04-15 11:52:51.000982', NULL),
	(10000984, 100234, 10000003, 'PW21A-TK100234BL-M', '2021-04-15 11:52:51.000983', '2021-04-15 11:52:51.000983', NULL),
	(10000985, 100234, 10000004, 'PW21A-TK100234BL-L', '2021-04-15 11:52:51.000984', '2021-04-15 11:52:51.000984', NULL),
	(10000986, 100234, 10000005, 'PW21A-TK100234BL-XL', '2021-04-15 11:52:51.000985', '2021-04-15 11:52:51.000985', NULL),
	(10000987, 100234, 10000006, 'PW21A-TK100234BL-XXL', '2021-04-15 11:52:51.000986', '2021-04-15 11:52:51.000986', NULL),
	(10000988, 100235, 10000001, 'PW21A-TS100235BL-XS', '2021-04-15 11:52:51.000987', '2021-04-15 11:52:51.000987', NULL),
	(10000989, 100235, 10000002, 'PW21A-TS100235BL-S', '2021-04-15 11:52:51.000988', '2021-04-15 11:52:51.000988', NULL),
	(10000990, 100235, 10000003, 'PW21A-TS100235BL-M', '2021-04-15 11:52:51.000989', '2021-04-15 11:52:51.000989', NULL),
	(10000991, 100235, 10000004, 'PW21A-TS100235BL-L', '2021-04-15 11:52:51.000990', '2021-04-15 11:52:51.000990', NULL),
	(10000992, 100235, 10000005, 'PW21A-TS100235BL-XL', '2021-04-15 11:52:51.000991', '2021-04-15 11:52:51.000991', NULL),
	(10000993, 100235, 10000006, 'PW21A-TS100235BL-XXL', '2021-04-15 11:52:51.000992', '2021-04-15 11:52:51.000992', NULL),
	(10000994, 100236, 10000001, 'PW21A-TK100236WT-XS', '2021-04-15 11:52:51.000993', '2021-04-15 11:52:51.000993', NULL),
	(10000995, 100236, 10000002, 'PW21A-TK100236WT-S', '2021-04-15 11:52:51.000994', '2021-04-15 11:52:51.000994', NULL),
	(10000996, 100236, 10000003, 'PW21A-TK100236WT-M', '2021-04-15 11:52:51.000995', '2021-04-15 11:52:51.000995', NULL),
	(10000997, 100236, 10000004, 'PW21A-TK100236WT-L', '2021-04-15 11:52:51.000996', '2021-04-15 11:52:51.000996', NULL),
	(10000998, 100236, 10000005, 'PW21A-TK100236WT-XL', '2021-04-15 11:52:51.000997', '2021-04-15 11:52:51.000997', NULL),
	(10000999, 100236, 10000006, 'PW21A-TK100236WT-XXL', '2021-04-15 11:52:51.000998', '2021-04-15 11:52:51.000998', NULL),
	(10001000, 100237, 10000001, 'PW21A-TS100237BL-XS', '2021-04-15 11:52:51.000999', '2021-04-15 11:52:51.000999', NULL),
	(10001001, 100237, 10000002, 'PW21A-TS100237BL-S', '2021-04-15 11:52:51.001000', '2021-04-15 11:52:51.001000', NULL),
	(10001002, 100237, 10000003, 'PW21A-TS100237BL-M', '2021-04-15 11:52:51.001001', '2021-04-15 11:52:51.001001', NULL),
	(10001003, 100237, 10000004, 'PW21A-TS100237BL-L', '2021-04-15 11:52:51.001002', '2021-04-15 11:52:51.001002', NULL),
	(10001004, 100237, 10000005, 'PW21A-TS100237BL-XL', '2021-04-15 11:52:51.001003', '2021-04-15 11:52:51.001003', NULL),
	(10001005, 100237, 10000006, 'PW21A-TS100237BL-XXL', '2021-04-15 11:52:51.001004', '2021-04-15 11:52:51.001004', NULL),
	(10001006, 100238, 10000001, 'PW21A-TS100238BL-XS', '2021-04-15 11:52:51.001005', '2021-04-15 11:52:51.001005', NULL),
	(10001007, 100238, 10000002, 'PW21A-TS100238BL-S', '2021-04-15 11:52:51.001006', '2021-04-15 11:52:51.001006', NULL),
	(10001008, 100238, 10000003, 'PW21A-TS100238BL-M', '2021-04-15 11:52:51.001007', '2021-04-15 11:52:51.001007', NULL),
	(10001009, 100238, 10000004, 'PW21A-TS100238BL-L', '2021-04-15 11:52:51.001008', '2021-04-15 11:52:51.001008', NULL),
	(10001010, 100238, 10000005, 'PW21A-TS100238BL-XL', '2021-04-15 11:52:51.001009', '2021-04-15 11:52:51.001009', NULL),
	(10001011, 100238, 10000006, 'PW21A-TS100238BL-XXL', '2021-04-15 11:52:51.001010', '2021-04-15 11:52:51.001010', NULL),
	(10001012, 100239, 10000001, 'PW21A-TK100239OG-XS', '2021-04-15 11:52:51.001011', '2021-04-15 11:52:51.001011', NULL),
	(10001013, 100239, 10000002, 'PW21A-TK100239OG-S', '2021-04-15 11:52:51.001012', '2021-04-15 11:52:51.001012', NULL),
	(10001014, 100239, 10000003, 'PW21A-TK100239OG-M', '2021-04-15 11:52:51.001013', '2021-04-15 11:52:51.001013', NULL),
	(10001015, 100239, 10000004, 'PW21A-TK100239OG-L', '2021-04-15 11:52:51.001014', '2021-04-15 11:52:51.001014', NULL),
	(10001016, 100239, 10000005, 'PW21A-TK100239OG-XL', '2021-04-15 11:52:51.001015', '2021-04-15 11:52:51.001015', NULL),
	(10001017, 100239, 10000006, 'PW21A-TK100239OG-XXL', '2021-04-15 11:52:51.001016', '2021-04-15 11:52:51.001016', NULL),
	(10001018, 100240, 10000001, 'PW21A-TK100240OG-XS', '2021-04-15 11:52:51.001017', '2021-04-15 11:52:51.001017', NULL),
	(10001019, 100240, 10000002, 'PW21A-TK100240OG-S', '2021-04-15 11:52:51.001018', '2021-04-15 11:52:51.001018', NULL),
	(10001020, 100240, 10000003, 'PW21A-TK100240OG-M', '2021-04-15 11:52:51.001019', '2021-04-15 11:52:51.001019', NULL),
	(10001021, 100240, 10000004, 'PW21A-TK100240OG-L', '2021-04-15 11:52:51.001020', '2021-04-15 11:52:51.001020', NULL),
	(10001022, 100240, 10000005, 'PW21A-TK100240OG-XL', '2021-04-15 11:52:51.001021', '2021-04-15 11:52:51.001021', NULL),
	(10001023, 100240, 10000006, 'PW21A-TK100240OG-XXL', '2021-04-15 11:52:51.001022', '2021-04-15 11:52:51.001022', NULL),
	(10001024, 100241, 10000001, 'PW21A-TS100241YW -XS', '2021-04-15 11:52:51.001023', '2021-04-15 11:52:51.001023', NULL),
	(10001025, 100241, 10000002, 'PW21A-TS100241YW -S', '2021-04-15 11:52:51.001024', '2021-04-15 11:52:51.001024', NULL),
	(10001026, 100241, 10000003, 'PW21A-TS100241YW -M', '2021-04-15 11:52:51.001025', '2021-04-15 11:52:51.001025', NULL),
	(10001027, 100241, 10000004, 'PW21A-TS100241YW -L', '2021-04-15 11:52:51.001026', '2021-04-15 11:52:51.001026', NULL),
	(10001028, 100241, 10000005, 'PW21A-TS100241YW -XL', '2021-04-15 11:52:51.001027', '2021-04-15 11:52:51.001027', NULL),
	(10001029, 100241, 10000006, 'PW21A-TS100241YW -XXL', '2021-04-15 11:52:51.001028', '2021-04-15 11:52:51.001028', NULL),
	(10001030, 100242, 10000001, 'PW21A-TS100242BL-XS', '2021-04-15 11:52:51.001029', '2021-04-15 11:52:51.001029', NULL),
	(10001031, 100242, 10000002, 'PW21A-TS100242BL-S', '2021-04-15 11:52:51.001030', '2021-04-15 11:52:51.001030', NULL),
	(10001032, 100242, 10000003, 'PW21A-TS100242BL-M', '2021-04-15 11:52:51.001031', '2021-04-15 11:52:51.001031', NULL),
	(10001033, 100242, 10000004, 'PW21A-TS100242BL-L', '2021-04-15 11:52:51.001032', '2021-04-15 11:52:51.001032', NULL),
	(10001034, 100242, 10000005, 'PW21A-TS100242BL-XL', '2021-04-15 11:52:51.001033', '2021-04-15 11:52:51.001033', NULL),
	(10001035, 100242, 10000006, 'PW21A-TS100242BL-XXL', '2021-04-15 11:52:51.001034', '2021-04-15 11:52:51.001034', NULL),
	(10001036, 100243, 10000001, 'PW21A-TK100243BL-XS', '2021-04-15 11:52:51.001035', '2021-04-15 11:52:51.001035', NULL),
	(10001037, 100243, 10000002, 'PW21A-TK100243BL-S', '2021-04-15 11:52:51.001036', '2021-04-15 11:52:51.001036', NULL),
	(10001038, 100243, 10000003, 'PW21A-TK100243BL-M', '2021-04-15 11:52:51.001037', '2021-04-15 11:52:51.001037', NULL),
	(10001039, 100243, 10000004, 'PW21A-TK100243BL-L', '2021-04-15 11:52:51.001038', '2021-04-15 11:52:51.001038', NULL),
	(10001040, 100243, 10000005, 'PW21A-TK100243BL-XL', '2021-04-15 11:52:51.001039', '2021-04-15 11:52:51.001039', NULL),
	(10001041, 100243, 10000006, 'PW21A-TK100243BL-XXL', '2021-04-15 11:52:51.001040', '2021-04-15 11:52:51.001040', NULL),
	(10001042, 100244, 10000001, 'PW21A-TS100244BL-XS', '2021-04-15 11:52:51.001041', '2021-04-15 11:52:51.001041', NULL),
	(10001043, 100244, 10000002, 'PW21A-TS100244BL-S', '2021-04-15 11:52:51.001042', '2021-04-15 11:52:51.001042', NULL),
	(10001044, 100244, 10000003, 'PW21A-TS100244BL-M', '2021-04-15 11:52:51.001043', '2021-04-15 11:52:51.001043', NULL),
	(10001045, 100244, 10000004, 'PW21A-TS100244BL-L', '2021-04-15 11:52:51.001044', '2021-04-15 11:52:51.001044', NULL),
	(10001046, 100244, 10000005, 'PW21A-TS100244BL-XL', '2021-04-15 11:52:51.001045', '2021-04-15 11:52:51.001045', NULL),
	(10001047, 100244, 10000006, 'PW21A-TS100244BL-XXL', '2021-04-15 11:52:51.001046', '2021-04-15 11:52:51.001046', NULL),
	(10001048, 100245, 10000001, 'PW21A-TS100245RD-XS', '2021-04-15 11:52:51.001047', '2021-04-15 11:52:51.001047', NULL),
	(10001049, 100245, 10000002, 'PW21A-TS100245RD-S', '2021-04-15 11:52:51.001048', '2021-04-15 11:52:51.001048', NULL),
	(10001050, 100245, 10000003, 'PW21A-TS100245RD-M', '2021-04-15 11:52:51.001049', '2021-04-15 11:52:51.001049', NULL),
	(10001051, 100245, 10000004, 'PW21A-TS100245RD-L', '2021-04-15 11:52:51.001050', '2021-04-15 11:52:51.001050', NULL),
	(10001052, 100245, 10000005, 'PW21A-TS100245RD-XL', '2021-04-15 11:52:51.001051', '2021-04-15 11:52:51.001051', NULL),
	(10001053, 100245, 10000006, 'PW21A-TS100245RD-XXL', '2021-04-15 11:52:51.001052', '2021-04-15 11:52:51.001052', NULL),
	(10001054, 100246, 10000001, 'PW21A-TK100246BL-XS', '2021-04-15 11:52:51.001053', '2021-04-15 11:52:51.001053', NULL),
	(10001055, 100246, 10000002, 'PW21A-TK100246BL-S', '2021-04-15 11:52:51.001054', '2021-04-15 11:52:51.001054', NULL),
	(10001056, 100246, 10000003, 'PW21A-TK100246BL-M', '2021-04-15 11:52:51.001055', '2021-04-15 11:52:51.001055', NULL),
	(10001057, 100246, 10000004, 'PW21A-TK100246BL-L', '2021-04-15 11:52:51.001056', '2021-04-15 11:52:51.001056', NULL),
	(10001058, 100246, 10000005, 'PW21A-TK100246BL-XL', '2021-04-15 11:52:51.001057', '2021-04-15 11:52:51.001057', NULL),
	(10001059, 100246, 10000006, 'PW21A-TK100246BL-XXL', '2021-04-15 11:52:51.001058', '2021-04-15 11:52:51.001058', NULL),
	(10001060, 100247, 10000001, 'PW21A-TS100247NV-XS', '2021-04-15 11:52:51.001059', '2021-04-15 11:52:51.001059', NULL),
	(10001061, 100247, 10000002, 'PW21A-TS100247NV-S', '2021-04-15 11:52:51.001060', '2021-04-15 11:52:51.001060', NULL),
	(10001062, 100247, 10000003, 'PW21A-TS100247NV-M', '2021-04-15 11:52:51.001061', '2021-04-15 11:52:51.001061', NULL),
	(10001063, 100247, 10000004, 'PW21A-TS100247NV-L', '2021-04-15 11:52:51.001062', '2021-04-15 11:52:51.001062', NULL),
	(10001064, 100247, 10000005, 'PW21A-TS100247NV-XL', '2021-04-15 11:52:51.001063', '2021-04-15 11:52:51.001063', NULL),
	(10001065, 100247, 10000006, 'PW21A-TS100247NV-XXL', '2021-04-15 11:52:51.001064', '2021-04-15 11:52:51.001064', NULL),
	(10001066, 100248, 10000001, 'PW21A-TS100248BL-XS', '2021-04-15 11:52:51.001065', '2021-04-15 11:52:51.001065', NULL),
	(10001067, 100248, 10000002, 'PW21A-TS100248BL-S', '2021-04-15 11:52:51.001066', '2021-04-15 11:52:51.001066', NULL),
	(10001068, 100248, 10000003, 'PW21A-TS100248BL-M', '2021-04-15 11:52:51.001067', '2021-04-15 11:52:51.001067', NULL),
	(10001069, 100248, 10000004, 'PW21A-TS100248BL-L', '2021-04-15 11:52:51.001068', '2021-04-15 11:52:51.001068', NULL),
	(10001070, 100248, 10000005, 'PW21A-TS100248BL-XL', '2021-04-15 11:52:51.001069', '2021-04-15 11:52:51.001069', NULL),
	(10001071, 100248, 10000006, 'PW21A-TS100248BL-XXL', '2021-04-15 11:52:51.001070', '2021-04-15 11:52:51.001070', NULL),
	(10001072, 100249, 10000001, 'PW21A-TK100249WT-XS', '2021-04-15 11:52:51.001071', '2021-04-15 11:52:51.001071', NULL),
	(10001073, 100249, 10000002, 'PW21A-TK100249WT-S', '2021-04-15 11:52:51.001072', '2021-04-15 11:52:51.001072', NULL),
	(10001074, 100249, 10000003, 'PW21A-TK100249WT-M', '2021-04-15 11:52:51.001073', '2021-04-15 11:52:51.001073', NULL),
	(10001075, 100249, 10000004, 'PW21A-TK100249WT-L', '2021-04-15 11:52:51.001074', '2021-04-15 11:52:51.001074', NULL),
	(10001076, 100249, 10000005, 'PW21A-TK100249WT-XL', '2021-04-15 11:52:51.001075', '2021-04-15 11:52:51.001075', NULL),
	(10001077, 100249, 10000006, 'PW21A-TK100249WT-XXL', '2021-04-15 11:52:51.001076', '2021-04-15 11:52:51.001076', NULL),
	(10001078, 100250, 10000001, 'PW21A-TS100250WT-XS', '2021-04-15 11:52:51.001077', '2021-04-15 11:52:51.001077', NULL),
	(10001079, 100250, 10000002, 'PW21A-TS100250WT-S', '2021-04-15 11:52:51.001078', '2021-04-15 11:52:51.001078', NULL),
	(10001080, 100250, 10000003, 'PW21A-TS100250WT-M', '2021-04-15 11:52:51.001079', '2021-04-15 11:52:51.001079', NULL),
	(10001081, 100250, 10000004, 'PW21A-TS100250WT-L', '2021-04-15 11:52:51.001080', '2021-04-15 11:52:51.001080', NULL),
	(10001082, 100250, 10000005, 'PW21A-TS100250WT-XL', '2021-04-15 11:52:51.001081', '2021-04-15 11:52:51.001081', NULL),
	(10001083, 100250, 10000006, 'PW21A-TS100250WT-XXL', '2021-04-15 11:52:51.001082', '2021-04-15 11:52:51.001082', NULL),
	(10001084, 100251, 10000001, 'PW21A-TS100251BL-XS', '2021-04-15 11:52:51.001083', '2021-04-15 11:52:51.001083', NULL),
	(10001085, 100251, 10000002, 'PW21A-TS100251BL-S', '2021-04-15 11:52:51.001084', '2021-04-15 11:52:51.001084', NULL),
	(10001086, 100251, 10000003, 'PW21A-TS100251BL-M', '2021-04-15 11:52:51.001085', '2021-04-15 11:52:51.001085', NULL),
	(10001087, 100251, 10000004, 'PW21A-TS100251BL-L', '2021-04-15 11:52:51.001086', '2021-04-15 11:52:51.001086', NULL),
	(10001088, 100251, 10000005, 'PW21A-TS100251BL-XL', '2021-04-15 11:52:51.001087', '2021-04-15 11:52:51.001087', NULL),
	(10001089, 100251, 10000006, 'PW21A-TS100251BL-XXL', '2021-04-15 11:52:51.001088', '2021-04-15 11:52:51.001088', NULL),
	(10001090, 100252, 10000001, 'PW21A-TS100252WT-XS', '2021-04-15 11:52:51.001089', '2021-04-15 11:52:51.001089', NULL),
	(10001091, 100252, 10000002, 'PW21A-TS100252WT-S', '2021-04-15 11:52:51.001090', '2021-04-15 11:52:51.001090', NULL),
	(10001092, 100252, 10000003, 'PW21A-TS100252WT-M', '2021-04-15 11:52:51.001091', '2021-04-15 11:52:51.001091', NULL),
	(10001093, 100252, 10000004, 'PW21A-TS100252WT-L', '2021-04-15 11:52:51.001092', '2021-04-15 11:52:51.001092', NULL),
	(10001094, 100252, 10000005, 'PW21A-TS100252WT-XL', '2021-04-15 11:52:51.001093', '2021-04-15 11:52:51.001093', NULL),
	(10001095, 100252, 10000006, 'PW21A-TS100252WT-XXL', '2021-04-15 11:52:51.001094', '2021-04-15 11:52:51.001094', NULL),
	(10001096, 100253, 10000001, 'PW21A-TS100253BL-XS', '2021-04-15 11:52:51.001095', '2021-04-15 11:52:51.001095', NULL),
	(10001097, 100253, 10000002, 'PW21A-TS100253BL-S', '2021-04-15 11:52:51.001096', '2021-04-15 11:52:51.001096', NULL),
	(10001098, 100253, 10000003, 'PW21A-TS100253BL-M', '2021-04-15 11:52:51.001097', '2021-04-15 11:52:51.001097', NULL),
	(10001099, 100253, 10000004, 'PW21A-TS100253BL-L', '2021-04-15 11:52:51.001098', '2021-04-15 11:52:51.001098', NULL),
	(10001100, 100253, 10000005, 'PW21A-TS100253BL-XL', '2021-04-15 11:52:51.001099', '2021-04-15 11:52:51.001099', NULL),
	(10001101, 100253, 10000006, 'PW21A-TS100253BL-XXL', '2021-04-15 11:52:51.001100', '2021-04-15 11:52:51.001100', NULL),
	(10001102, 100254, 10000001, 'PW21A-TK100254BL-XS', '2021-04-15 11:52:51.001101', '2021-04-15 11:52:51.001101', NULL),
	(10001103, 100254, 10000002, 'PW21A-TK100254BL-S', '2021-04-15 11:52:51.001102', '2021-04-15 11:52:51.001102', NULL),
	(10001104, 100254, 10000003, 'PW21A-TK100254BL-M', '2021-04-15 11:52:51.001103', '2021-04-15 11:52:51.001103', NULL),
	(10001105, 100254, 10000004, 'PW21A-TK100254BL-L', '2021-04-15 11:52:51.001104', '2021-04-15 11:52:51.001104', NULL),
	(10001106, 100254, 10000005, 'PW21A-TK100254BL-XL', '2021-04-15 11:52:51.001105', '2021-04-15 11:52:51.001105', NULL),
	(10001107, 100254, 10000006, 'PW21A-TK100254BL-XXL', '2021-04-15 11:52:51.001106', '2021-04-15 11:52:51.001106', NULL),
	(10001108, 100255, 10000001, 'PW21A-TS100255BL-XS', '2021-04-15 11:52:51.001107', '2021-04-15 11:52:51.001107', NULL),
	(10001109, 100255, 10000002, 'PW21A-TS100255BL-S', '2021-04-15 11:52:51.001108', '2021-04-15 11:52:51.001108', NULL),
	(10001110, 100255, 10000003, 'PW21A-TS100255BL-M', '2021-04-15 11:52:51.001109', '2021-04-15 11:52:51.001109', NULL),
	(10001111, 100255, 10000004, 'PW21A-TS100255BL-L', '2021-04-15 11:52:51.001110', '2021-04-15 11:52:51.001110', NULL),
	(10001112, 100255, 10000005, 'PW21A-TS100255BL-XL', '2021-04-15 11:52:51.001111', '2021-04-15 11:52:51.001111', NULL),
	(10001113, 100255, 10000006, 'PW21A-TS100255BL-XXL', '2021-04-15 11:52:51.001112', '2021-04-15 11:52:51.001112', NULL),
	(10001114, 100256, 10000001, 'PW21A-TK100256BL-XS', '2021-04-15 11:52:51.001113', '2021-04-15 11:52:51.001113', NULL),
	(10001115, 100256, 10000002, 'PW21A-TK100256BL-S', '2021-04-15 11:52:51.001114', '2021-04-15 11:52:51.001114', NULL),
	(10001116, 100256, 10000003, 'PW21A-TK100256BL-M', '2021-04-15 11:52:51.001115', '2021-04-15 11:52:51.001115', NULL),
	(10001117, 100256, 10000004, 'PW21A-TK100256BL-L', '2021-04-15 11:52:51.001116', '2021-04-15 11:52:51.001116', NULL),
	(10001118, 100256, 10000005, 'PW21A-TK100256BL-XL', '2021-04-15 11:52:51.001117', '2021-04-15 11:52:51.001117', NULL),
	(10001119, 100256, 10000006, 'PW21A-TK100256BL-XXL', '2021-04-15 11:52:51.001118', '2021-04-15 11:52:51.001118', NULL),
	(10001120, 100257, 10000001, 'PW21A-TS100257WT-XS', '2021-04-15 11:52:51.001119', '2021-04-15 11:52:51.001119', NULL),
	(10001121, 100257, 10000002, 'PW21A-TS100257WT-S', '2021-04-15 11:52:51.001120', '2021-04-15 11:52:51.001120', NULL),
	(10001122, 100257, 10000003, 'PW21A-TS100257WT-M', '2021-04-15 11:52:51.001121', '2021-04-15 11:52:51.001121', NULL),
	(10001123, 100257, 10000004, 'PW21A-TS100257WT-L', '2021-04-15 11:52:51.001122', '2021-04-15 11:52:51.001122', NULL),
	(10001124, 100257, 10000005, 'PW21A-TS100257WT-XL', '2021-04-15 11:52:51.001123', '2021-04-15 11:52:51.001123', NULL),
	(10001125, 100257, 10000006, 'PW21A-TS100257WT-XXL', '2021-04-15 11:52:51.001124', '2021-04-15 11:52:51.001124', NULL),
	(10001126, 100258, 10000001, 'PW21A-TS100258WT-XS', '2021-04-15 11:52:51.001125', '2021-04-15 11:52:51.001125', NULL),
	(10001127, 100258, 10000002, 'PW21A-TS100258WT-S', '2021-04-15 11:52:51.001126', '2021-04-15 11:52:51.001126', NULL),
	(10001128, 100258, 10000003, 'PW21A-TS100258WT-M', '2021-04-15 11:52:51.001127', '2021-04-15 11:52:51.001127', NULL),
	(10001129, 100258, 10000004, 'PW21A-TS100258WT-L', '2021-04-15 11:52:51.001128', '2021-04-15 11:52:51.001128', NULL),
	(10001130, 100258, 10000005, 'PW21A-TS100258WT-XL', '2021-04-15 11:52:51.001129', '2021-04-15 11:52:51.001129', NULL),
	(10001131, 100258, 10000006, 'PW21A-TS100258WT-XXL', '2021-04-15 11:52:51.001130', '2021-04-15 11:52:51.001130', NULL),
	(10001132, 100259, 10000001, 'PW21A-TS100259BL-XS', '2021-04-15 11:52:51.001131', '2021-04-15 11:52:51.001131', NULL),
	(10001133, 100259, 10000002, 'PW21A-TS100259BL-S', '2021-04-15 11:52:51.001132', '2021-04-15 11:52:51.001132', NULL),
	(10001134, 100259, 10000003, 'PW21A-TS100259BL-M', '2021-04-15 11:52:51.001133', '2021-04-15 11:52:51.001133', NULL),
	(10001135, 100259, 10000004, 'PW21A-TS100259BL-L', '2021-04-15 11:52:51.001134', '2021-04-15 11:52:51.001134', NULL),
	(10001136, 100259, 10000005, 'PW21A-TS100259BL-XL', '2021-04-15 11:52:51.001135', '2021-04-15 11:52:51.001135', NULL),
	(10001137, 100259, 10000006, 'PW21A-TS100259BL-XXL', '2021-04-15 11:52:51.001136', '2021-04-15 11:52:51.001136', NULL),
	(10001138, 100260, 10000001, 'PW21A-TS100260BL-XS', '2021-04-15 11:52:51.001137', '2021-04-15 11:52:51.001137', NULL),
	(10001139, 100260, 10000002, 'PW21A-TS100260BL-S', '2021-04-15 11:52:51.001138', '2021-04-15 11:52:51.001138', NULL),
	(10001140, 100260, 10000003, 'PW21A-TS100260BL-M', '2021-04-15 11:52:51.001139', '2021-04-15 11:52:51.001139', NULL),
	(10001141, 100260, 10000004, 'PW21A-TS100260BL-L', '2021-04-15 11:52:51.001140', '2021-04-15 11:52:51.001140', NULL),
	(10001142, 100260, 10000005, 'PW21A-TS100260BL-XL', '2021-04-15 11:52:51.001141', '2021-04-15 11:52:51.001141', NULL),
	(10001143, 100260, 10000006, 'PW21A-TS100260BL-XXL', '2021-04-15 11:52:51.001142', '2021-04-15 11:52:51.001142', NULL),
	(10001144, 100261, 10000001, 'PW21A-TS100261BL-XS', '2021-04-15 11:52:51.001143', '2021-04-15 11:52:51.001143', NULL),
	(10001145, 100261, 10000002, 'PW21A-TS100261BL-S', '2021-04-15 11:52:51.001144', '2021-04-15 11:52:51.001144', NULL),
	(10001146, 100261, 10000003, 'PW21A-TS100261BL-M', '2021-04-15 11:52:51.001145', '2021-04-15 11:52:51.001145', NULL),
	(10001147, 100261, 10000004, 'PW21A-TS100261BL-L', '2021-04-15 11:52:51.001146', '2021-04-15 11:52:51.001146', NULL),
	(10001148, 100261, 10000005, 'PW21A-TS100261BL-XL', '2021-04-15 11:52:51.001147', '2021-04-15 11:52:51.001147', NULL),
	(10001149, 100261, 10000006, 'PW21A-TS100261BL-XXL', '2021-04-15 11:52:51.001148', '2021-04-15 11:52:51.001148', NULL),
	(10001150, 100262, 10000001, 'PW21A-TS100262BL-XS', '2021-04-15 11:52:51.001149', '2021-04-15 11:52:51.001149', NULL),
	(10001151, 100262, 10000002, 'PW21A-TS100262BL-S', '2021-04-15 11:52:51.001150', '2021-04-15 11:52:51.001150', NULL),
	(10001152, 100262, 10000003, 'PW21A-TS100262BL-M', '2021-04-15 11:52:51.001151', '2021-04-15 11:52:51.001151', NULL),
	(10001153, 100262, 10000004, 'PW21A-TS100262BL-L', '2021-04-15 11:52:51.001152', '2021-04-15 11:52:51.001152', NULL),
	(10001154, 100262, 10000005, 'PW21A-TS100262BL-XL', '2021-04-15 11:52:51.001153', '2021-04-15 11:52:51.001153', NULL),
	(10001155, 100262, 10000006, 'PW21A-TS100262BL-XXL', '2021-04-15 11:52:51.001154', '2021-04-15 11:52:51.001154', NULL),
	(10001156, 100263, 10000001, 'PW21A-TS100263BL-XS', '2021-04-15 11:52:51.001155', '2021-04-15 11:52:51.001155', NULL),
	(10001157, 100263, 10000002, 'PW21A-TS100263BL-S', '2021-04-15 11:52:51.001156', '2021-04-15 11:52:51.001156', NULL),
	(10001158, 100263, 10000003, 'PW21A-TS100263BL-M', '2021-04-15 11:52:51.001157', '2021-04-15 11:52:51.001157', NULL),
	(10001159, 100263, 10000004, 'PW21A-TS100263BL-L', '2021-04-15 11:52:51.001158', '2021-04-15 11:52:51.001158', NULL),
	(10001160, 100263, 10000005, 'PW21A-TS100263BL-XL', '2021-04-15 11:52:51.001159', '2021-04-15 11:52:51.001159', NULL),
	(10001161, 100263, 10000006, 'PW21A-TS100263BL-XXL', '2021-04-15 11:52:51.001160', '2021-04-15 11:52:51.001160', NULL),
	(10001162, 100264, 10000001, 'PW21A-TS100264WH-XS', '2021-04-15 11:52:51.001161', '2021-04-15 11:52:51.001161', NULL),
	(10001163, 100264, 10000002, 'PW21A-TS100264WH-S', '2021-04-15 11:52:51.001162', '2021-04-15 11:52:51.001162', NULL),
	(10001164, 100264, 10000003, 'PW21A-TS100264WH-M', '2021-04-15 11:52:51.001163', '2021-04-15 11:52:51.001163', NULL),
	(10001165, 100264, 10000004, 'PW21A-TS100264WH-L', '2021-04-15 11:52:51.001164', '2021-04-15 11:52:51.001164', NULL),
	(10001166, 100264, 10000005, 'PW21A-TS100264WH-XL', '2021-04-15 11:52:51.001165', '2021-04-15 11:52:51.001165', NULL),
	(10001167, 100264, 10000006, 'PW21A-TS100264WH-XXL', '2021-04-15 11:52:51.001166', '2021-04-15 11:52:51.001166', NULL),
	(10001168, 100265, 10000001, 'PW21A-TS100265RD-XS', '2021-04-15 11:52:51.001167', '2021-04-15 11:52:51.001167', NULL),
	(10001169, 100265, 10000002, 'PW21A-TS100265RD-S', '2021-04-15 11:52:51.001168', '2021-04-15 11:52:51.001168', NULL),
	(10001170, 100265, 10000003, 'PW21A-TS100265RD-M', '2021-04-15 11:52:51.001169', '2021-04-15 11:52:51.001169', NULL),
	(10001171, 100265, 10000004, 'PW21A-TS100265RD-L', '2021-04-15 11:52:51.001170', '2021-04-15 11:52:51.001170', NULL),
	(10001172, 100265, 10000005, 'PW21A-TS100265RD-XL', '2021-04-15 11:52:51.001171', '2021-04-15 11:52:51.001171', NULL),
	(10001173, 100265, 10000006, 'PW21A-TS100265RD-XXL', '2021-04-15 11:52:51.001172', '2021-04-15 11:52:51.001172', NULL),
	(10001174, 100266, 10000001, 'PW21A-TS100266BL-XS', '2021-04-15 11:52:51.001173', '2021-04-15 11:52:51.001173', NULL),
	(10001175, 100266, 10000002, 'PW21A-TS100266BL-S', '2021-04-15 11:52:51.001174', '2021-04-15 11:52:51.001174', NULL),
	(10001176, 100266, 10000003, 'PW21A-TS100266BL-M', '2021-04-15 11:52:51.001175', '2021-04-15 11:52:51.001175', NULL),
	(10001177, 100266, 10000004, 'PW21A-TS100266BL-L', '2021-04-15 11:52:51.001176', '2021-04-15 11:52:51.001176', NULL),
	(10001178, 100266, 10000005, 'PW21A-TS100266BL-XL', '2021-04-15 11:52:51.001177', '2021-04-15 11:52:51.001177', NULL),
	(10001179, 100266, 10000006, 'PW21A-TS100266BL-XXL', '2021-04-15 11:52:51.001178', '2021-04-15 11:52:51.001178', NULL),
	(10001180, 100267, 10000001, 'PW21A-TS100267BL-XS', '2021-04-15 11:52:51.001179', '2021-04-15 11:52:51.001179', NULL),
	(10001181, 100267, 10000002, 'PW21A-TS100267BL-S', '2021-04-15 11:52:51.001180', '2021-04-15 11:52:51.001180', NULL),
	(10001182, 100267, 10000003, 'PW21A-TS100267BL-M', '2021-04-15 11:52:51.001181', '2021-04-15 11:52:51.001181', NULL),
	(10001183, 100267, 10000004, 'PW21A-TS100267BL-L', '2021-04-15 11:52:51.001182', '2021-04-15 11:52:51.001182', NULL),
	(10001184, 100267, 10000005, 'PW21A-TS100267BL-XL', '2021-04-15 11:52:51.001183', '2021-04-15 11:52:51.001183', NULL),
	(10001185, 100267, 10000006, 'PW21A-TS100267BL-XXL', '2021-04-15 11:52:51.001184', '2021-04-15 11:52:51.001184', NULL),
	(10001186, 100268, 10000001, 'PW21A-TS100268BL-XS', '2021-04-15 11:52:51.001185', '2021-04-15 11:52:51.001185', NULL),
	(10001187, 100268, 10000002, 'PW21A-TS100268BL-S', '2021-04-15 11:52:51.001186', '2021-04-15 11:52:51.001186', NULL),
	(10001188, 100268, 10000003, 'PW21A-TS100268BL-M', '2021-04-15 11:52:51.001187', '2021-04-15 11:52:51.001187', NULL),
	(10001189, 100268, 10000004, 'PW21A-TS100268BL-L', '2021-04-15 11:52:51.001188', '2021-04-15 11:52:51.001188', NULL),
	(10001190, 100268, 10000005, 'PW21A-TS100268BL-XL', '2021-04-15 11:52:51.001189', '2021-04-15 11:52:51.001189', NULL),
	(10001191, 100268, 10000006, 'PW21A-TS100268BL-XXL', '2021-04-15 11:52:51.001190', '2021-04-15 11:52:51.001190', NULL),
	(10001192, 100269, 10000001, 'PW21A-TS100269BL-XS', '2021-04-15 11:52:51.001191', '2021-04-15 11:52:51.001191', NULL),
	(10001193, 100269, 10000002, 'PW21A-TS100269BL-S', '2021-04-15 11:52:51.001192', '2021-04-15 11:52:51.001192', NULL),
	(10001194, 100269, 10000003, 'PW21A-TS100269BL-M', '2021-04-15 11:52:51.001193', '2021-04-15 11:52:51.001193', NULL),
	(10001195, 100269, 10000004, 'PW21A-TS100269BL-L', '2021-04-15 11:52:51.001194', '2021-04-15 11:52:51.001194', NULL),
	(10001196, 100269, 10000005, 'PW21A-TS100269BL-XL', '2021-04-15 11:52:51.001195', '2021-04-15 11:52:51.001195', NULL),
	(10001197, 100269, 10000006, 'PW21A-TS100269BL-XXL', '2021-04-15 11:52:51.001196', '2021-04-15 11:52:51.001196', NULL),
	(10001198, 100270, 10000001, 'PW21A-TS100270BL-XS', '2021-04-15 11:52:51.001197', '2021-04-15 11:52:51.001197', NULL),
	(10001199, 100270, 10000002, 'PW21A-TS100270BL-S', '2021-04-15 11:52:51.001198', '2021-04-15 11:52:51.001198', NULL),
	(10001200, 100270, 10000003, 'PW21A-TS100270BL-M', '2021-04-15 11:52:51.001199', '2021-04-15 11:52:51.001199', NULL),
	(10001201, 100270, 10000004, 'PW21A-TS100270BL-L', '2021-04-15 11:52:51.001200', '2021-04-15 11:52:51.001200', NULL),
	(10001202, 100270, 10000005, 'PW21A-TS100270BL-XL', '2021-04-15 11:52:51.001201', '2021-04-15 11:52:51.001201', NULL),
	(10001203, 100270, 10000006, 'PW21A-TS100270BL-XXL', '2021-04-15 11:52:51.001202', '2021-04-15 11:52:51.001202', NULL),
	(10001204, 100271, 10000001, 'PW21A-TS100271BL-XS', '2021-04-15 11:52:51.001203', '2021-04-15 11:52:51.001203', NULL),
	(10001205, 100271, 10000002, 'PW21A-TS100271BL-S', '2021-04-15 11:52:51.001204', '2021-04-15 11:52:51.001204', NULL),
	(10001206, 100271, 10000003, 'PW21A-TS100271BL-M', '2021-04-15 11:52:51.001205', '2021-04-15 11:52:51.001205', NULL),
	(10001207, 100271, 10000004, 'PW21A-TS100271BL-L', '2021-04-15 11:52:51.001206', '2021-04-15 11:52:51.001206', NULL),
	(10001208, 100271, 10000005, 'PW21A-TS100271BL-XL', '2021-04-15 11:52:51.001207', '2021-04-15 11:52:51.001207', NULL),
	(10001209, 100271, 10000006, 'PW21A-TS100271BL-XXL', '2021-04-15 11:52:51.001208', '2021-04-15 11:52:51.001208', NULL),
	(10001210, 100272, 10000001, 'PW21A-TS100272BL-XS', '2021-04-15 11:52:51.001209', '2021-04-15 11:52:51.001209', NULL),
	(10001211, 100272, 10000002, 'PW21A-TS100272BL-S', '2021-04-15 11:52:51.001210', '2021-04-15 11:52:51.001210', NULL),
	(10001212, 100272, 10000003, 'PW21A-TS100272BL-M', '2021-04-15 11:52:51.001211', '2021-04-15 11:52:51.001211', NULL),
	(10001213, 100272, 10000004, 'PW21A-TS100272BL-L', '2021-04-15 11:52:51.001212', '2021-04-15 11:52:51.001212', NULL),
	(10001214, 100272, 10000005, 'PW21A-TS100272BL-XL', '2021-04-15 11:52:51.001213', '2021-04-15 11:52:51.001213', NULL),
	(10001215, 100272, 10000006, 'PW21A-TS100272BL-XXL', '2021-04-15 11:52:51.001214', '2021-04-15 11:52:51.001214', NULL),
	(10001216, 100273, 10000001, 'PW21A-TS100273WT-XS', '2021-04-15 11:52:51.001215', '2021-04-15 11:52:51.001215', NULL),
	(10001217, 100273, 10000002, 'PW21A-TS100273WT-S', '2021-04-15 11:52:51.001216', '2021-04-15 11:52:51.001216', NULL),
	(10001218, 100273, 10000003, 'PW21A-TS100273WT-M', '2021-04-15 11:52:51.001217', '2021-04-15 11:52:51.001217', NULL),
	(10001219, 100273, 10000004, 'PW21A-TS100273WT-L', '2021-04-15 11:52:51.001218', '2021-04-15 11:52:51.001218', NULL),
	(10001220, 100273, 10000005, 'PW21A-TS100273WT-XL', '2021-04-15 11:52:51.001219', '2021-04-15 11:52:51.001219', NULL),
	(10001221, 100273, 10000006, 'PW21A-TS100273WT-XXL', '2021-04-15 11:52:51.001220', '2021-04-15 11:52:51.001220', NULL),
	(10001222, 100274, 10000001, 'PW21A-TS100274BL-XS', '2021-04-15 11:52:51.001221', '2021-04-15 11:52:51.001221', NULL),
	(10001223, 100274, 10000002, 'PW21A-TS100274BL-S', '2021-04-15 11:52:51.001222', '2021-04-15 11:52:51.001222', NULL),
	(10001224, 100274, 10000003, 'PW21A-TS100274BL-M', '2021-04-15 11:52:51.001223', '2021-04-15 11:52:51.001223', NULL),
	(10001225, 100274, 10000004, 'PW21A-TS100274BL-L', '2021-04-15 11:52:51.001224', '2021-04-15 11:52:51.001224', NULL),
	(10001226, 100274, 10000005, 'PW21A-TS100274BL-XL', '2021-04-15 11:52:51.001225', '2021-04-15 11:52:51.001225', NULL),
	(10001227, 100274, 10000006, 'PW21A-TS100274BL-XXL', '2021-04-15 11:52:51.001226', '2021-04-15 11:52:51.001226', NULL),
	(10001228, 100275, 10000001, 'PW21A-TS100275BL-XS', '2021-04-15 11:52:51.001227', '2021-04-15 11:52:51.001227', NULL),
	(10001229, 100275, 10000002, 'PW21A-TS100275BL-S', '2021-04-15 11:52:51.001228', '2021-04-15 11:52:51.001228', NULL),
	(10001230, 100275, 10000003, 'PW21A-TS100275BL-M', '2021-04-15 11:52:51.001229', '2021-04-15 11:52:51.001229', NULL),
	(10001231, 100275, 10000004, 'PW21A-TS100275BL-L', '2021-04-15 11:52:51.001230', '2021-04-15 11:52:51.001230', NULL),
	(10001232, 100275, 10000005, 'PW21A-TS100275BL-XL', '2021-04-15 11:52:51.001231', '2021-04-15 11:52:51.001231', NULL),
	(10001233, 100275, 10000006, 'PW21A-TS100275BL-XXL', '2021-04-15 11:52:51.001232', '2021-04-15 11:52:51.001232', NULL),
	(10001234, 100276, 10000001, 'PW21A-TS100276WT-XS', '2021-04-15 11:52:51.001233', '2021-04-15 11:52:51.001233', NULL),
	(10001235, 100276, 10000002, 'PW21A-TS100276WT-S', '2021-04-15 11:52:51.001234', '2021-04-15 11:52:51.001234', NULL),
	(10001236, 100276, 10000003, 'PW21A-TS100276WT-M', '2021-04-15 11:52:51.001235', '2021-04-15 11:52:51.001235', NULL),
	(10001237, 100276, 10000004, 'PW21A-TS100276WT-L', '2021-04-15 11:52:51.001236', '2021-04-15 11:52:51.001236', NULL),
	(10001238, 100276, 10000005, 'PW21A-TS100276WT-XL', '2021-04-15 11:52:51.001237', '2021-04-15 11:52:51.001237', NULL),
	(10001239, 100276, 10000006, 'PW21A-TS100276WT-XXL', '2021-04-15 11:52:51.001238', '2021-04-15 11:52:51.001238', NULL),
	(10001240, 100277, 10000001, 'PW21A-TS100277BL-XS', '2021-04-15 11:52:51.001239', '2021-04-15 11:52:51.001239', NULL),
	(10001241, 100277, 10000002, 'PW21A-TS100277BL-S', '2021-04-15 11:52:51.001240', '2021-04-15 11:52:51.001240', NULL),
	(10001242, 100277, 10000003, 'PW21A-TS100277BL-M', '2021-04-15 11:52:51.001241', '2021-04-15 11:52:51.001241', NULL),
	(10001243, 100277, 10000004, 'PW21A-TS100277BL-L', '2021-04-15 11:52:51.001242', '2021-04-15 11:52:51.001242', NULL),
	(10001244, 100277, 10000005, 'PW21A-TS100277BL-XL', '2021-04-15 11:52:51.001243', '2021-04-15 11:52:51.001243', NULL),
	(10001245, 100277, 10000006, 'PW21A-TS100277BL-XXL', '2021-04-15 11:52:51.001244', '2021-04-15 11:52:51.001244', NULL),
	(10001246, 100278, 10000001, 'PW21A-TS100278BL-XS', '2021-04-15 11:52:51.001245', '2021-04-15 11:52:51.001245', NULL),
	(10001247, 100278, 10000002, 'PW21A-TS100278BL-S', '2021-04-15 11:52:51.001246', '2021-04-15 11:52:51.001246', NULL),
	(10001248, 100278, 10000003, 'PW21A-TS100278BL-M', '2021-04-15 11:52:51.001247', '2021-04-15 11:52:51.001247', NULL),
	(10001249, 100278, 10000004, 'PW21A-TS100278BL-L', '2021-04-15 11:52:51.001248', '2021-04-15 11:52:51.001248', NULL),
	(10001250, 100278, 10000005, 'PW21A-TS100278BL-XL', '2021-04-15 11:52:51.001249', '2021-04-15 11:52:51.001249', NULL),
	(10001251, 100278, 10000006, 'PW21A-TS100278BL-XXL', '2021-04-15 11:52:51.001250', '2021-04-15 11:52:51.001250', NULL),
	(10001252, 100279, 10000001, 'PW21A-TS100279WT-XS', '2021-04-15 11:52:51.001251', '2021-04-15 11:52:51.001251', NULL),
	(10001253, 100279, 10000002, 'PW21A-TS100279WT-S', '2021-04-15 11:52:51.001252', '2021-04-15 11:52:51.001252', NULL),
	(10001254, 100279, 10000003, 'PW21A-TS100279WT-M', '2021-04-15 11:52:51.001253', '2021-04-15 11:52:51.001253', NULL),
	(10001255, 100279, 10000004, 'PW21A-TS100279WT-L', '2021-04-15 11:52:51.001254', '2021-04-15 11:52:51.001254', NULL),
	(10001256, 100279, 10000005, 'PW21A-TS100279WT-XL', '2021-04-15 11:52:51.001255', '2021-04-15 11:52:51.001255', NULL),
	(10001257, 100279, 10000006, 'PW21A-TS100279WT-XXL', '2021-04-15 11:52:51.001256', '2021-04-15 11:52:51.001256', NULL),
	(10001258, 100280, 10000001, 'PW21A-TS100280BL-XS', '2021-04-15 11:52:51.001257', '2021-04-15 11:52:51.001257', NULL),
	(10001259, 100280, 10000002, 'PW21A-TS100280BL-S', '2021-04-15 11:52:51.001258', '2021-04-15 11:52:51.001258', NULL),
	(10001260, 100280, 10000003, 'PW21A-TS100280BL-M', '2021-04-15 11:52:51.001259', '2021-04-15 11:52:51.001259', NULL),
	(10001261, 100280, 10000004, 'PW21A-TS100280BL-L', '2021-04-15 11:52:51.001260', '2021-04-15 11:52:51.001260', NULL),
	(10001262, 100280, 10000005, 'PW21A-TS100280BL-XL', '2021-04-15 11:52:51.001261', '2021-04-15 11:52:51.001261', NULL),
	(10001263, 100280, 10000006, 'PW21A-TS100280BL-XXL', '2021-04-15 11:52:51.001262', '2021-04-15 11:52:51.001262', NULL),
	(10001264, 100281, 10000001, 'PW21A-TS100281BL-XS', '2021-04-15 11:52:51.001263', '2021-04-15 11:52:51.001263', NULL),
	(10001265, 100281, 10000002, 'PW21A-TS100281BL-S', '2021-04-15 11:52:51.001264', '2021-04-15 11:52:51.001264', NULL),
	(10001266, 100281, 10000003, 'PW21A-TS100281BL-M', '2021-04-15 11:52:51.001265', '2021-04-15 11:52:51.001265', NULL),
	(10001267, 100281, 10000004, 'PW21A-TS100281BL-L', '2021-04-15 11:52:51.001266', '2021-04-15 11:52:51.001266', NULL),
	(10001268, 100281, 10000005, 'PW21A-TS100281BL-XL', '2021-04-15 11:52:51.001267', '2021-04-15 11:52:51.001267', NULL),
	(10001269, 100281, 10000006, 'PW21A-TS100281BL-XXL', '2021-04-15 11:52:51.001268', '2021-04-15 11:52:51.001268', NULL),
	(10001270, 100282, 10000001, 'PW21A-TS100282BL-XS', '2021-04-15 11:52:51.001269', '2021-04-15 11:52:51.001269', NULL),
	(10001271, 100282, 10000002, 'PW21A-TS100282BL-S', '2021-04-15 11:52:51.001270', '2021-04-15 11:52:51.001270', NULL),
	(10001272, 100282, 10000003, 'PW21A-TS100282BL-M', '2021-04-15 11:52:51.001271', '2021-04-15 11:52:51.001271', NULL),
	(10001273, 100282, 10000004, 'PW21A-TS100282BL-L', '2021-04-15 11:52:51.001272', '2021-04-15 11:52:51.001272', NULL),
	(10001274, 100282, 10000005, 'PW21A-TS100282BL-XL', '2021-04-15 11:52:51.001273', '2021-04-15 11:52:51.001273', NULL),
	(10001275, 100282, 10000006, 'PW21A-TS100282BL-XXL', '2021-04-15 11:52:51.001274', '2021-04-15 11:52:51.001274', NULL),
	(10001276, 100283, 10000001, 'PW21A-TS100283BL-XS', '2021-04-15 11:52:51.001275', '2021-04-15 11:52:51.001275', NULL),
	(10001277, 100283, 10000002, 'PW21A-TS100283BL-S', '2021-04-15 11:52:51.001276', '2021-04-15 11:52:51.001276', NULL),
	(10001278, 100283, 10000003, 'PW21A-TS100283BL-M', '2021-04-15 11:52:51.001277', '2021-04-15 11:52:51.001277', NULL),
	(10001279, 100283, 10000004, 'PW21A-TS100283BL-L', '2021-04-15 11:52:51.001278', '2021-04-15 11:52:51.001278', NULL),
	(10001280, 100283, 10000005, 'PW21A-TS100283BL-XL', '2021-04-15 11:52:51.001279', '2021-04-15 11:52:51.001279', NULL),
	(10001281, 100283, 10000006, 'PW21A-TS100283BL-XXL', '2021-04-15 11:52:51.001280', '2021-04-15 11:52:51.001280', NULL),
	(10001282, 100284, 10000001, 'PW21A-TS100284BL-XS', '2021-04-15 11:52:51.001281', '2021-04-15 11:52:51.001281', NULL),
	(10001283, 100284, 10000002, 'PW21A-TS100284BL-S', '2021-04-15 11:52:51.001282', '2021-04-15 11:52:51.001282', NULL),
	(10001284, 100284, 10000003, 'PW21A-TS100284BL-M', '2021-04-15 11:52:51.001283', '2021-04-15 11:52:51.001283', NULL),
	(10001285, 100284, 10000004, 'PW21A-TS100284BL-L', '2021-04-15 11:52:51.001284', '2021-04-15 11:52:51.001284', NULL),
	(10001286, 100284, 10000005, 'PW21A-TS100284BL-XL', '2021-04-15 11:52:51.001285', '2021-04-15 11:52:51.001285', NULL),
	(10001287, 100284, 10000006, 'PW21A-TS100284BL-XXL', '2021-04-15 11:52:51.001286', '2021-04-15 11:52:51.001286', NULL),
	(10001288, 100285, 10000001, 'PW21A-TS100285BL-XS', '2021-04-15 11:52:51.001287', '2021-04-15 11:52:51.001287', NULL),
	(10001289, 100285, 10000002, 'PW21A-TS100285BL-S', '2021-04-15 11:52:51.001288', '2021-04-15 11:52:51.001288', NULL),
	(10001290, 100285, 10000003, 'PW21A-TS100285BL-M', '2021-04-15 11:52:51.001289', '2021-04-15 11:52:51.001289', NULL),
	(10001291, 100285, 10000004, 'PW21A-TS100285BL-L', '2021-04-15 11:52:51.001290', '2021-04-15 11:52:51.001290', NULL),
	(10001292, 100285, 10000005, 'PW21A-TS100285BL-XL', '2021-04-15 11:52:51.001291', '2021-04-15 11:52:51.001291', NULL),
	(10001293, 100285, 10000006, 'PW21A-TS100285BL-XXL', '2021-04-15 11:52:51.001292', '2021-04-15 11:52:51.001292', NULL),
	(10001294, 100286, 10000001, 'PW21A-TS100286BL-XS', '2021-04-15 11:52:51.001293', '2021-04-15 11:52:51.001293', NULL),
	(10001295, 100286, 10000002, 'PW21A-TS100286BL-S', '2021-04-15 11:52:51.001294', '2021-04-15 11:52:51.001294', NULL),
	(10001296, 100286, 10000003, 'PW21A-TS100286BL-M', '2021-04-15 11:52:51.001295', '2021-04-15 11:52:51.001295', NULL),
	(10001297, 100286, 10000004, 'PW21A-TS100286BL-L', '2021-04-15 11:52:51.001296', '2021-04-15 11:52:51.001296', NULL),
	(10001298, 100286, 10000005, 'PW21A-TS100286BL-XL', '2021-04-15 11:52:51.001297', '2021-04-15 11:52:51.001297', NULL),
	(10001299, 100286, 10000006, 'PW21A-TS100286BL-XXL', '2021-04-15 11:52:51.001298', '2021-04-15 11:52:51.001298', NULL),
	(10001300, 100287, 10000001, 'PW21A-TS100287BL-XS', '2021-04-15 11:52:51.001299', '2021-04-15 11:52:51.001299', NULL),
	(10001301, 100287, 10000002, 'PW21A-TS100287BL-S', '2021-04-15 11:52:51.001300', '2021-04-15 11:52:51.001300', NULL),
	(10001302, 100287, 10000003, 'PW21A-TS100287BL-M', '2021-04-15 11:52:51.001301', '2021-04-15 11:52:51.001301', NULL),
	(10001303, 100287, 10000004, 'PW21A-TS100287BL-L', '2021-04-15 11:52:51.001302', '2021-04-15 11:52:51.001302', NULL),
	(10001304, 100287, 10000005, 'PW21A-TS100287BL-XL', '2021-04-15 11:52:51.001303', '2021-04-15 11:52:51.001303', NULL),
	(10001305, 100287, 10000006, 'PW21A-TS100287BL-XXL', '2021-04-15 11:52:51.001304', '2021-04-15 11:52:51.001304', NULL),
	(10001306, 100288, 10000001, 'PW21A-TS100288BL-XS', '2021-04-15 11:52:51.001305', '2021-04-15 11:52:51.001305', NULL),
	(10001307, 100288, 10000002, 'PW21A-TS100288BL-S', '2021-04-15 11:52:51.001306', '2021-04-15 11:52:51.001306', NULL),
	(10001308, 100288, 10000003, 'PW21A-TS100288BL-M', '2021-04-15 11:52:51.001307', '2021-04-15 11:52:51.001307', NULL),
	(10001309, 100288, 10000004, 'PW21A-TS100288BL-L', '2021-04-15 11:52:51.001308', '2021-04-15 11:52:51.001308', NULL),
	(10001310, 100288, 10000005, 'PW21A-TS100288BL-XL', '2021-04-15 11:52:51.001309', '2021-04-15 11:52:51.001309', NULL),
	(10001311, 100288, 10000006, 'PW21A-TS100288BL-XXL', '2021-04-15 11:52:51.001310', '2021-04-15 11:52:51.001310', NULL),
	(10001312, 100289, 10000001, 'PW21A-TS100289BL-XS', '2021-04-15 11:52:51.001311', '2021-04-15 11:52:51.001311', NULL),
	(10001313, 100289, 10000002, 'PW21A-TS100289BL-S', '2021-04-15 11:52:51.001312', '2021-04-15 11:52:51.001312', NULL),
	(10001314, 100289, 10000003, 'PW21A-TS100289BL-M', '2021-04-15 11:52:51.001313', '2021-04-15 11:52:51.001313', NULL),
	(10001315, 100289, 10000004, 'PW21A-TS100289BL-L', '2021-04-15 11:52:51.001314', '2021-04-15 11:52:51.001314', NULL),
	(10001316, 100289, 10000005, 'PW21A-TS100289BL-XL', '2021-04-15 11:52:51.001315', '2021-04-15 11:52:51.001315', NULL),
	(10001317, 100289, 10000006, 'PW21A-TS100289BL-XXL', '2021-04-15 11:52:51.001316', '2021-04-15 11:52:51.001316', NULL),
	(10001318, 100290, 10000001, 'PW21A-TS100290OL-XS', '2021-04-15 11:52:51.001317', '2021-04-15 11:52:51.001317', NULL),
	(10001319, 100290, 10000002, 'PW21A-TS100290OL-S', '2021-04-15 11:52:51.001318', '2021-04-15 11:52:51.001318', NULL),
	(10001320, 100290, 10000003, 'PW21A-TS100290OL-M', '2021-04-15 11:52:51.001319', '2021-04-15 11:52:51.001319', NULL),
	(10001321, 100290, 10000004, 'PW21A-TS100290OL-L', '2021-04-15 11:52:51.001320', '2021-04-15 11:52:51.001320', NULL),
	(10001322, 100290, 10000005, 'PW21A-TS100290OL-XL', '2021-04-15 11:52:51.001321', '2021-04-15 11:52:51.001321', NULL),
	(10001323, 100290, 10000006, 'PW21A-TS100290OL-XXL', '2021-04-15 11:52:51.001322', '2021-04-15 11:52:51.001322', NULL),
	(10001324, 100291, 10000001, 'PW21A-TS100291BL-XS', '2021-04-15 11:52:51.001323', '2021-04-15 11:52:51.001323', NULL),
	(10001325, 100291, 10000002, 'PW21A-TS100291BL-S', '2021-04-15 11:52:51.001324', '2021-04-15 11:52:51.001324', NULL),
	(10001326, 100291, 10000003, 'PW21A-TS100291BL-M', '2021-04-15 11:52:51.001325', '2021-04-15 11:52:51.001325', NULL),
	(10001327, 100291, 10000004, 'PW21A-TS100291BL-L', '2021-04-15 11:52:51.001326', '2021-04-15 11:52:51.001326', NULL),
	(10001328, 100291, 10000005, 'PW21A-TS100291BL-XL', '2021-04-15 11:52:51.001327', '2021-04-15 11:52:51.001327', NULL),
	(10001329, 100291, 10000006, 'PW21A-TS100291BL-XXL', '2021-04-15 11:52:51.001328', '2021-04-15 11:52:51.001328', NULL),
	(10001330, 100292, 10000001, 'PW21A-TS100292NV-XS', '2021-04-15 11:52:51.001329', '2021-04-15 11:52:51.001329', NULL),
	(10001331, 100292, 10000002, 'PW21A-TS100292NV-S', '2021-04-15 11:52:51.001330', '2021-04-15 11:52:51.001330', NULL),
	(10001332, 100292, 10000003, 'PW21A-TS100292NV-M', '2021-04-15 11:52:51.001331', '2021-04-15 11:52:51.001331', NULL),
	(10001333, 100292, 10000004, 'PW21A-TS100292NV-L', '2021-04-15 11:52:51.001332', '2021-04-15 11:52:51.001332', NULL),
	(10001334, 100292, 10000005, 'PW21A-TS100292NV-XL', '2021-04-15 11:52:51.001333', '2021-04-15 11:52:51.001333', NULL),
	(10001335, 100292, 10000006, 'PW21A-TS100292NV-XXL', '2021-04-15 11:52:51.001334', '2021-04-15 11:52:51.001334', NULL),
	(10001336, 100293, 10000001, 'PW21A-TS100293OL-XS', '2021-04-15 11:52:51.001335', '2021-04-15 11:52:51.001335', NULL),
	(10001337, 100293, 10000002, 'PW21A-TS100293OL-S', '2021-04-15 11:52:51.001336', '2021-04-15 11:52:51.001336', NULL),
	(10001338, 100293, 10000003, 'PW21A-TS100293OL-M', '2021-04-15 11:52:51.001337', '2021-04-15 11:52:51.001337', NULL),
	(10001339, 100293, 10000004, 'PW21A-TS100293OL-L', '2021-04-15 11:52:51.001338', '2021-04-15 11:52:51.001338', NULL),
	(10001340, 100293, 10000005, 'PW21A-TS100293OL-XL', '2021-04-15 11:52:51.001339', '2021-04-15 11:52:51.001339', NULL),
	(10001341, 100293, 10000006, 'PW21A-TS100293OL-XXL', '2021-04-15 11:52:51.001340', '2021-04-15 11:52:51.001340', NULL),
	(10001342, 100294, 10000001, 'PW21A-TS100294OL-XS', '2021-04-15 11:52:51.001341', '2021-04-15 11:52:51.001341', NULL),
	(10001343, 100294, 10000002, 'PW21A-TS100294OL-S', '2021-04-15 11:52:51.001342', '2021-04-15 11:52:51.001342', NULL),
	(10001344, 100294, 10000003, 'PW21A-TS100294OL-M', '2021-04-15 11:52:51.001343', '2021-04-15 11:52:51.001343', NULL),
	(10001345, 100294, 10000004, 'PW21A-TS100294OL-L', '2021-04-15 11:52:51.001344', '2021-04-15 11:52:51.001344', NULL),
	(10001346, 100294, 10000005, 'PW21A-TS100294OL-XL', '2021-04-15 11:52:51.001345', '2021-04-15 11:52:51.001345', NULL),
	(10001347, 100294, 10000006, 'PW21A-TS100294OL-XXL', '2021-04-15 11:52:51.001346', '2021-04-15 11:52:51.001346', NULL),
	(10001348, 100295, 10000001, 'PW21A-TS100295NV-XS', '2021-04-15 11:52:51.001347', '2021-04-15 11:52:51.001347', NULL),
	(10001349, 100295, 10000002, 'PW21A-TS100295NV-S', '2021-04-15 11:52:51.001348', '2021-04-15 11:52:51.001348', NULL),
	(10001350, 100295, 10000003, 'PW21A-TS100295NV-M', '2021-04-15 11:52:51.001349', '2021-04-15 11:52:51.001349', NULL),
	(10001351, 100295, 10000004, 'PW21A-TS100295NV-L', '2021-04-15 11:52:51.001350', '2021-04-15 11:52:51.001350', NULL),
	(10001352, 100295, 10000005, 'PW21A-TS100295NV-XL', '2021-04-15 11:52:51.001351', '2021-04-15 11:52:51.001351', NULL),
	(10001353, 100295, 10000006, 'PW21A-TS100295NV-XXL', '2021-04-15 11:52:51.001352', '2021-04-15 11:52:51.001352', NULL),
	(10001354, 100296, 10000001, 'PW21A-TS100296BL-XS', '2021-04-15 11:52:51.001353', '2021-04-15 11:52:51.001353', NULL),
	(10001355, 100296, 10000002, 'PW21A-TS100296BL-S', '2021-04-15 11:52:51.001354', '2021-04-15 11:52:51.001354', NULL),
	(10001356, 100296, 10000003, 'PW21A-TS100296BL-M', '2021-04-15 11:52:51.001355', '2021-04-15 11:52:51.001355', NULL),
	(10001357, 100296, 10000004, 'PW21A-TS100296BL-L', '2021-04-15 11:52:51.001356', '2021-04-15 11:52:51.001356', NULL),
	(10001358, 100296, 10000005, 'PW21A-TS100296BL-XL', '2021-04-15 11:52:51.001357', '2021-04-15 11:52:51.001357', NULL),
	(10001359, 100296, 10000006, 'PW21A-TS100296BL-XXL', '2021-04-15 11:52:51.001358', '2021-04-15 11:52:51.001358', NULL),
	(10001360, 100297, 10000001, 'PW21A-TS100297OL-XS', '2021-04-15 11:52:51.001359', '2021-04-15 11:52:51.001359', NULL),
	(10001361, 100297, 10000002, 'PW21A-TS100297OL-S', '2021-04-15 11:52:51.001360', '2021-04-15 11:52:51.001360', NULL),
	(10001362, 100297, 10000003, 'PW21A-TS100297OL-M', '2021-04-15 11:52:51.001361', '2021-04-15 11:52:51.001361', NULL),
	(10001363, 100297, 10000004, 'PW21A-TS100297OL-L', '2021-04-15 11:52:51.001362', '2021-04-15 11:52:51.001362', NULL),
	(10001364, 100297, 10000005, 'PW21A-TS100297OL-XL', '2021-04-15 11:52:51.001363', '2021-04-15 11:52:51.001363', NULL),
	(10001365, 100297, 10000006, 'PW21A-TS100297OL-XXL', '2021-04-15 11:52:51.001364', '2021-04-15 11:52:51.001364', NULL),
	(10001366, 100298, 10000001, 'PW21A-TS100298OL-XS', '2021-04-15 11:52:51.001365', '2021-04-15 11:52:51.001365', NULL),
	(10001367, 100298, 10000002, 'PW21A-TS100298OL-S', '2021-04-15 11:52:51.001366', '2021-04-15 11:52:51.001366', NULL),
	(10001368, 100298, 10000003, 'PW21A-TS100298OL-M', '2021-04-15 11:52:51.001367', '2021-04-15 11:52:51.001367', NULL),
	(10001369, 100298, 10000004, 'PW21A-TS100298OL-L', '2021-04-15 11:52:51.001368', '2021-04-15 11:52:51.001368', NULL),
	(10001370, 100298, 10000005, 'PW21A-TS100298OL-XL', '2021-04-15 11:52:51.001369', '2021-04-15 11:52:51.001369', NULL),
	(10001371, 100298, 10000006, 'PW21A-TS100298OL-XXL', '2021-04-15 11:52:51.001370', '2021-04-15 11:52:51.001370', NULL),
	(10001372, 100299, 10000001, 'PW21A-TS100299BL-XS', '2021-04-15 11:52:51.001371', '2021-04-15 11:52:51.001371', NULL),
	(10001373, 100299, 10000002, 'PW21A-TS100299BL-S', '2021-04-15 11:52:51.001372', '2021-04-15 11:52:51.001372', NULL),
	(10001374, 100299, 10000003, 'PW21A-TS100299BL-M', '2021-04-15 11:52:51.001373', '2021-04-15 11:52:51.001373', NULL),
	(10001375, 100299, 10000004, 'PW21A-TS100299BL-L', '2021-04-15 11:52:51.001374', '2021-04-15 11:52:51.001374', NULL),
	(10001376, 100299, 10000005, 'PW21A-TS100299BL-XL', '2021-04-15 11:52:51.001375', '2021-04-15 11:52:51.001375', NULL),
	(10001377, 100299, 10000006, 'PW21A-TS100299BL-XXL', '2021-04-15 11:52:51.001376', '2021-04-15 11:52:51.001376', NULL),
	(10001378, 100300, 10000001, 'PW21A-TS100300MR-XS', '2021-04-15 11:52:51.001377', '2021-04-15 11:52:51.001377', NULL),
	(10001379, 100300, 10000002, 'PW21A-TS100300MR-S', '2021-04-15 11:52:51.001378', '2021-04-15 11:52:51.001378', NULL),
	(10001380, 100300, 10000003, 'PW21A-TS100300MR-M', '2021-04-15 11:52:51.001379', '2021-04-15 11:52:51.001379', NULL),
	(10001381, 100300, 10000004, 'PW21A-TS100300MR-L', '2021-04-15 11:52:51.001380', '2021-04-15 11:52:51.001380', NULL),
	(10001382, 100300, 10000005, 'PW21A-TS100300MR-XL', '2021-04-15 11:52:51.001381', '2021-04-15 11:52:51.001381', NULL),
	(10001383, 100300, 10000006, 'PW21A-TS100300MR-XXL', '2021-04-15 11:52:51.001382', '2021-04-15 11:52:51.001382', NULL),
	(10001384, 100301, 10000001, 'PW21A-TS100301BL-XS', '2021-04-15 11:52:51.001383', '2021-04-15 11:52:51.001383', NULL),
	(10001385, 100301, 10000002, 'PW21A-TS100301BL-S', '2021-04-15 11:52:51.001384', '2021-04-15 11:52:51.001384', NULL),
	(10001386, 100301, 10000003, 'PW21A-TS100301BL-M', '2021-04-15 11:52:51.001385', '2021-04-15 11:52:51.001385', NULL),
	(10001387, 100301, 10000004, 'PW21A-TS100301BL-L', '2021-04-15 11:52:51.001386', '2021-04-15 11:52:51.001386', NULL),
	(10001388, 100301, 10000005, 'PW21A-TS100301BL-XL', '2021-04-15 11:52:51.001387', '2021-04-15 11:52:51.001387', NULL),
	(10001389, 100301, 10000006, 'PW21A-TS100301BL-XXL', '2021-04-15 11:52:51.001388', '2021-04-15 11:52:51.001388', NULL),
	(10001390, 100302, 10000001, 'PW21A-TS100302BL-XS', '2021-04-15 11:52:51.001389', '2021-04-15 11:52:51.001389', NULL),
	(10001391, 100302, 10000002, 'PW21A-TS100302BL-S', '2021-04-15 11:52:51.001390', '2021-04-15 11:52:51.001390', NULL),
	(10001392, 100302, 10000003, 'PW21A-TS100302BL-M', '2021-04-15 11:52:51.001391', '2021-04-15 11:52:51.001391', NULL),
	(10001393, 100302, 10000004, 'PW21A-TS100302BL-L', '2021-04-15 11:52:51.001392', '2021-04-15 11:52:51.001392', NULL),
	(10001394, 100302, 10000005, 'PW21A-TS100302BL-XL', '2021-04-15 11:52:51.001393', '2021-04-15 11:52:51.001393', NULL),
	(10001395, 100302, 10000006, 'PW21A-TS100302BL-XXL', '2021-04-15 11:52:51.001394', '2021-04-15 11:52:51.001394', NULL),
	(10001396, 100303, 10000001, 'PW21A-TS100303BL-XS', '2021-04-15 11:52:51.001395', '2021-04-15 11:52:51.001395', NULL),
	(10001397, 100303, 10000002, 'PW21A-TS100303BL-S', '2021-04-15 11:52:51.001396', '2021-04-15 11:52:51.001396', NULL),
	(10001398, 100303, 10000003, 'PW21A-TS100303BL-M', '2021-04-15 11:52:51.001397', '2021-04-15 11:52:51.001397', NULL),
	(10001399, 100303, 10000004, 'PW21A-TS100303BL-L', '2021-04-15 11:52:51.001398', '2021-04-15 11:52:51.001398', NULL),
	(10001400, 100303, 10000005, 'PW21A-TS100303BL-XL', '2021-04-15 11:52:51.001399', '2021-04-15 11:52:51.001399', NULL),
	(10001401, 100303, 10000006, 'PW21A-TS100303BL-XXL', '2021-04-15 11:52:51.001400', '2021-04-15 11:52:51.001400', NULL),
	(10001402, 100304, 10000001, 'PW21A-TS100304OL-XS', '2021-04-15 11:52:51.001401', '2021-04-15 11:52:51.001401', NULL),
	(10001403, 100304, 10000002, 'PW21A-TS100304OL-S', '2021-04-15 11:52:51.001402', '2021-04-15 11:52:51.001402', NULL),
	(10001404, 100304, 10000003, 'PW21A-TS100304OL-M', '2021-04-15 11:52:51.001403', '2021-04-15 11:52:51.001403', NULL),
	(10001405, 100304, 10000004, 'PW21A-TS100304OL-L', '2021-04-15 11:52:51.001404', '2021-04-15 11:52:51.001404', NULL),
	(10001406, 100304, 10000005, 'PW21A-TS100304OL-XL', '2021-04-15 11:52:51.001405', '2021-04-15 11:52:51.001405', NULL),
	(10001407, 100304, 10000006, 'PW21A-TS100304OL-XXL', '2021-04-15 11:52:51.001406', '2021-04-15 11:52:51.001406', NULL),
	(10001408, 100305, 10000001, 'PW21A-TS100305AR-XS', '2021-04-15 11:52:51.001407', '2021-04-15 11:52:51.001407', NULL),
	(10001409, 100305, 10000002, 'PW21A-TS100305AR-S', '2021-04-15 11:52:51.001408', '2021-04-15 11:52:51.001408', NULL),
	(10001410, 100305, 10000003, 'PW21A-TS100305AR-M', '2021-04-15 11:52:51.001409', '2021-04-15 11:52:51.001409', NULL),
	(10001411, 100305, 10000004, 'PW21A-TS100305AR-L', '2021-04-15 11:52:51.001410', '2021-04-15 11:52:51.001410', NULL),
	(10001412, 100305, 10000005, 'PW21A-TS100305AR-XL', '2021-04-15 11:52:51.001411', '2021-04-15 11:52:51.001411', NULL),
	(10001413, 100305, 10000006, 'PW21A-TS100305AR-XXL', '2021-04-15 11:52:51.001412', '2021-04-15 11:52:51.001412', NULL),
	(10001414, 100306, 10000001, 'PW21A-TS100306GN-XS', '2021-04-15 11:52:51.001413', '2021-04-15 11:52:51.001413', NULL),
	(10001415, 100306, 10000002, 'PW21A-TS100306GN-S', '2021-04-15 11:52:51.001414', '2021-04-15 11:52:51.001414', NULL),
	(10001416, 100306, 10000003, 'PW21A-TS100306GN-M', '2021-04-15 11:52:51.001415', '2021-04-15 11:52:51.001415', NULL),
	(10001417, 100306, 10000004, 'PW21A-TS100306GN-L', '2021-04-15 11:52:51.001416', '2021-04-15 11:52:51.001416', NULL),
	(10001418, 100306, 10000005, 'PW21A-TS100306GN-XL', '2021-04-15 11:52:51.001417', '2021-04-15 11:52:51.001417', NULL),
	(10001419, 100306, 10000006, 'PW21A-TS100306GN-XXL', '2021-04-15 11:52:51.001418', '2021-04-15 11:52:51.001418', NULL),
	(10001420, 100307, 10000001, 'PW21A-TS100307GN-XS', '2021-04-15 11:52:51.001419', '2021-04-15 11:52:51.001419', NULL),
	(10001421, 100307, 10000002, 'PW21A-TS100307GN-S', '2021-04-15 11:52:51.001420', '2021-04-15 11:52:51.001420', NULL),
	(10001422, 100307, 10000003, 'PW21A-TS100307GN-M', '2021-04-15 11:52:51.001421', '2021-04-15 11:52:51.001421', NULL),
	(10001423, 100307, 10000004, 'PW21A-TS100307GN-L', '2021-04-15 11:52:51.001422', '2021-04-15 11:52:51.001422', NULL),
	(10001424, 100307, 10000005, 'PW21A-TS100307GN-XL', '2021-04-15 11:52:51.001423', '2021-04-15 11:52:51.001423', NULL),
	(10001425, 100307, 10000006, 'PW21A-TS100307GN-XXL', '2021-04-15 11:52:51.001424', '2021-04-15 11:52:51.001424', NULL),
	(10001426, 100308, 10000001, 'PW21A-TS100308GN-XS', '2021-04-15 11:52:51.001425', '2021-04-15 11:52:51.001425', NULL),
	(10001427, 100308, 10000002, 'PW21A-TS100308GN-S', '2021-04-15 11:52:51.001426', '2021-04-15 11:52:51.001426', NULL),
	(10001428, 100308, 10000003, 'PW21A-TS100308GN-M', '2021-04-15 11:52:51.001427', '2021-04-15 11:52:51.001427', NULL),
	(10001429, 100308, 10000004, 'PW21A-TS100308GN-L', '2021-04-15 11:52:51.001428', '2021-04-15 11:52:51.001428', NULL),
	(10001430, 100308, 10000005, 'PW21A-TS100308GN-XL', '2021-04-15 11:52:51.001429', '2021-04-15 11:52:51.001429', NULL),
	(10001431, 100308, 10000006, 'PW21A-TS100308GN-XXL', '2021-04-15 11:52:51.001430', '2021-04-15 11:52:51.001430', NULL),
	(10001432, 100309, 10000001, 'PW21A-TS100309GN-XS', '2021-04-15 11:52:51.001431', '2021-04-15 11:52:51.001431', NULL),
	(10001433, 100309, 10000002, 'PW21A-TS100309GN-S', '2021-04-15 11:52:51.001432', '2021-04-15 11:52:51.001432', NULL),
	(10001434, 100309, 10000003, 'PW21A-TS100309GN-M', '2021-04-15 11:52:51.001433', '2021-04-15 11:52:51.001433', NULL),
	(10001435, 100309, 10000004, 'PW21A-TS100309GN-L', '2021-04-15 11:52:51.001434', '2021-04-15 11:52:51.001434', NULL),
	(10001436, 100309, 10000005, 'PW21A-TS100309GN-XL', '2021-04-15 11:52:51.001435', '2021-04-15 11:52:51.001435', NULL),
	(10001437, 100309, 10000006, 'PW21A-TS100309GN-XXL', '2021-04-15 11:52:51.001436', '2021-04-15 11:52:51.001436', NULL),
	(10001438, 100310, 10000001, 'PW21A-SW100310BL-XS', '2021-04-15 11:52:51.001437', '2021-04-15 11:52:51.001437', NULL),
	(10001439, 100310, 10000002, 'PW21A-SW100310BL-S', '2021-04-15 11:52:51.001438', '2021-04-15 11:52:51.001438', NULL),
	(10001440, 100310, 10000003, 'PW21A-SW100310BL-M', '2021-04-15 11:52:51.001439', '2021-04-15 11:52:51.001439', NULL),
	(10001441, 100310, 10000004, 'PW21A-SW100310BL-L', '2021-04-15 11:52:51.001440', '2021-04-15 11:52:51.001440', NULL),
	(10001442, 100310, 10000005, 'PW21A-SW100310BL-XL', '2021-04-15 11:52:51.001441', '2021-04-15 11:52:51.001441', NULL),
	(10001443, 100310, 10000006, 'PW21A-SW100310BL-XXL', '2021-04-15 11:52:51.001442', '2021-04-15 11:52:51.001442', NULL),
	(10001444, 100311, 10000001, 'PW21A-SW100311BL-XS', '2021-04-15 11:52:51.001443', '2021-04-15 11:52:51.001443', NULL),
	(10001445, 100311, 10000002, 'PW21A-SW100311BL-S', '2021-04-15 11:52:51.001444', '2021-04-15 11:52:51.001444', NULL),
	(10001446, 100311, 10000003, 'PW21A-SW100311BL-M', '2021-04-15 11:52:51.001445', '2021-04-15 11:52:51.001445', NULL),
	(10001447, 100311, 10000004, 'PW21A-SW100311BL-L', '2021-04-15 11:52:51.001446', '2021-04-15 11:52:51.001446', NULL),
	(10001448, 100311, 10000005, 'PW21A-SW100311BL-XL', '2021-04-15 11:52:51.001447', '2021-04-15 11:52:51.001447', NULL),
	(10001449, 100311, 10000006, 'PW21A-SW100311BL-XXL', '2021-04-15 11:52:51.001448', '2021-04-15 11:52:51.001448', NULL),
	(10001450, 100312, 10000001, 'PW21A-SW100312BL-XS', '2021-04-15 11:52:51.001449', '2021-04-15 11:52:51.001449', NULL),
	(10001451, 100312, 10000002, 'PW21A-SW100312BL-S', '2021-04-15 11:52:51.001450', '2021-04-15 11:52:51.001450', NULL),
	(10001452, 100312, 10000003, 'PW21A-SW100312BL-M', '2021-04-15 11:52:51.001451', '2021-04-15 11:52:51.001451', NULL),
	(10001453, 100312, 10000004, 'PW21A-SW100312BL-L', '2021-04-15 11:52:51.001452', '2021-04-15 11:52:51.001452', NULL),
	(10001454, 100312, 10000005, 'PW21A-SW100312BL-XL', '2021-04-15 11:52:51.001453', '2021-04-15 11:52:51.001453', NULL),
	(10001455, 100312, 10000006, 'PW21A-SW100312BL-XXL', '2021-04-15 11:52:51.001454', '2021-04-15 11:52:51.001454', NULL),
	(10001456, 100313, 10000001, 'PW21A-SW100313BL-XS', '2021-04-15 11:52:51.001455', '2021-04-15 11:52:51.001455', NULL),
	(10001457, 100313, 10000002, 'PW21A-SW100313BL-S', '2021-04-15 11:52:51.001456', '2021-04-15 11:52:51.001456', NULL),
	(10001458, 100313, 10000003, 'PW21A-SW100313BL-M', '2021-04-15 11:52:51.001457', '2021-04-15 11:52:51.001457', NULL),
	(10001459, 100313, 10000004, 'PW21A-SW100313BL-L', '2021-04-15 11:52:51.001458', '2021-04-15 11:52:51.001458', NULL),
	(10001460, 100313, 10000005, 'PW21A-SW100313BL-XL', '2021-04-15 11:52:51.001459', '2021-04-15 11:52:51.001459', NULL),
	(10001461, 100313, 10000006, 'PW21A-SW100313BL-XXL', '2021-04-15 11:52:51.001460', '2021-04-15 11:52:51.001460', NULL),
	(10001462, 100314, 10000001, 'PW21A-SW100314DK-XS', '2021-04-15 11:52:51.001461', '2021-04-15 11:52:51.001461', NULL),
	(10001463, 100314, 10000002, 'PW21A-SW100314DK-S', '2021-04-15 11:52:51.001462', '2021-04-15 11:52:51.001462', NULL),
	(10001464, 100314, 10000003, 'PW21A-SW100314DK-M', '2021-04-15 11:52:51.001463', '2021-04-15 11:52:51.001463', NULL),
	(10001465, 100314, 10000004, 'PW21A-SW100314DK-L', '2021-04-15 11:52:51.001464', '2021-04-15 11:52:51.001464', NULL),
	(10001466, 100314, 10000005, 'PW21A-SW100314DK-XL', '2021-04-15 11:52:51.001465', '2021-04-15 11:52:51.001465', NULL),
	(10001467, 100314, 10000006, 'PW21A-SW100314DK-XXL', '2021-04-15 11:52:51.001466', '2021-04-15 11:52:51.001466', NULL),
	(10001468, 100315, 10000001, 'PW21A-SW100315BL-XS', '2021-04-15 11:52:51.001467', '2021-04-15 11:52:51.001467', NULL),
	(10001469, 100315, 10000002, 'PW21A-SW100315BL-S', '2021-04-15 11:52:51.001468', '2021-04-15 11:52:51.001468', NULL),
	(10001470, 100315, 10000003, 'PW21A-SW100315BL-M', '2021-04-15 11:52:51.001469', '2021-04-15 11:52:51.001469', NULL),
	(10001471, 100315, 10000004, 'PW21A-SW100315BL-L', '2021-04-15 11:52:51.001470', '2021-04-15 11:52:51.001470', NULL),
	(10001472, 100315, 10000005, 'PW21A-SW100315BL-XL', '2021-04-15 11:52:51.001471', '2021-04-15 11:52:51.001471', NULL),
	(10001473, 100315, 10000006, 'PW21A-SW100315BL-XXL', '2021-04-15 11:52:51.001472', '2021-04-15 11:52:51.001472', NULL),
	(10001474, 100316, 10000001, 'PW21A-SW100316BL-XS', '2021-04-15 11:52:51.001473', '2021-04-15 11:52:51.001473', NULL),
	(10001475, 100316, 10000002, 'PW21A-SW100316BL-S', '2021-04-15 11:52:51.001474', '2021-04-15 11:52:51.001474', NULL),
	(10001476, 100316, 10000003, 'PW21A-SW100316BL-M', '2021-04-15 11:52:51.001475', '2021-04-15 11:52:51.001475', NULL),
	(10001477, 100316, 10000004, 'PW21A-SW100316BL-L', '2021-04-15 11:52:51.001476', '2021-04-15 11:52:51.001476', NULL),
	(10001478, 100316, 10000005, 'PW21A-SW100316BL-XL', '2021-04-15 11:52:51.001477', '2021-04-15 11:52:51.001477', NULL),
	(10001479, 100316, 10000006, 'PW21A-SW100316BL-XXL', '2021-04-15 11:52:51.001478', '2021-04-15 11:52:51.001478', NULL),
	(10001480, 100317, 10000001, 'PW21A-SW100317BL-XS', '2021-04-15 11:52:51.001479', '2021-04-15 11:52:51.001479', NULL),
	(10001481, 100317, 10000002, 'PW21A-SW100317BL-S', '2021-04-15 11:52:51.001480', '2021-04-15 11:52:51.001480', NULL),
	(10001482, 100317, 10000003, 'PW21A-SW100317BL-M', '2021-04-15 11:52:51.001481', '2021-04-15 11:52:51.001481', NULL),
	(10001483, 100317, 10000004, 'PW21A-SW100317BL-L', '2021-04-15 11:52:51.001482', '2021-04-15 11:52:51.001482', NULL),
	(10001484, 100317, 10000005, 'PW21A-SW100317BL-XL', '2021-04-15 11:52:51.001483', '2021-04-15 11:52:51.001483', NULL),
	(10001485, 100317, 10000006, 'PW21A-SW100317BL-XXL', '2021-04-15 11:52:51.001484', '2021-04-15 11:52:51.001484', NULL),
	(10001486, 100318, 10000001, 'PW21A-SW100318OL-XS', '2021-04-15 11:52:51.001485', '2021-04-15 11:52:51.001485', NULL),
	(10001487, 100318, 10000002, 'PW21A-SW100318OL-S', '2021-04-15 11:52:51.001486', '2021-04-15 11:52:51.001486', NULL),
	(10001488, 100318, 10000003, 'PW21A-SW100318OL-M', '2021-04-15 11:52:51.001487', '2021-04-15 11:52:51.001487', NULL),
	(10001489, 100318, 10000004, 'PW21A-SW100318OL-L', '2021-04-15 11:52:51.001488', '2021-04-15 11:52:51.001488', NULL),
	(10001490, 100318, 10000005, 'PW21A-SW100318OL-XL', '2021-04-15 11:52:51.001489', '2021-04-15 11:52:51.001489', NULL),
	(10001491, 100318, 10000006, 'PW21A-SW100318OL-XXL', '2021-04-15 11:52:51.001490', '2021-04-15 11:52:51.001490', NULL),
	(10001492, 100319, 10000001, 'PW21A-SW100319WT-XS', '2021-04-15 11:52:51.001491', '2021-04-15 11:52:51.001491', NULL),
	(10001493, 100319, 10000002, 'PW21A-SW100319WT-S', '2021-04-15 11:52:51.001492', '2021-04-15 11:52:51.001492', NULL),
	(10001494, 100319, 10000003, 'PW21A-SW100319WT-M', '2021-04-15 11:52:51.001493', '2021-04-15 11:52:51.001493', NULL),
	(10001495, 100319, 10000004, 'PW21A-SW100319WT-L', '2021-04-15 11:52:51.001494', '2021-04-15 11:52:51.001494', NULL),
	(10001496, 100319, 10000005, 'PW21A-SW100319WT-XL', '2021-04-15 11:52:51.001495', '2021-04-15 11:52:51.001495', NULL),
	(10001497, 100319, 10000006, 'PW21A-SW100319WT-XXL', '2021-04-15 11:52:51.001496', '2021-04-15 11:52:51.001496', NULL),
	(10001498, 100320, 10000001, 'PW21A-SW100320BL-XS', '2021-04-15 11:52:51.001497', '2021-04-15 11:52:51.001497', NULL),
	(10001499, 100320, 10000002, 'PW21A-SW100320BL-S', '2021-04-15 11:52:51.001498', '2021-04-15 11:52:51.001498', NULL),
	(10001500, 100320, 10000003, 'PW21A-SW100320BL-M', '2021-04-15 11:52:51.001499', '2021-04-15 11:52:51.001499', NULL),
	(10001501, 100320, 10000004, 'PW21A-SW100320BL-L', '2021-04-15 11:52:51.001500', '2021-04-15 11:52:51.001500', NULL),
	(10001502, 100320, 10000005, 'PW21A-SW100320BL-XL', '2021-04-15 11:52:51.001501', '2021-04-15 11:52:51.001501', NULL),
	(10001503, 100320, 10000006, 'PW21A-SW100320BL-XXL', '2021-04-15 11:52:51.001502', '2021-04-15 11:52:51.001502', NULL),
	(10001504, 100321, 10000001, 'PW21A-SW100321BL-XS', '2021-04-15 11:52:51.001503', '2021-04-15 11:52:51.001503', NULL),
	(10001505, 100321, 10000002, 'PW21A-SW100321BL-S', '2021-04-15 11:52:51.001504', '2021-04-15 11:52:51.001504', NULL),
	(10001506, 100321, 10000003, 'PW21A-SW100321BL-M', '2021-04-15 11:52:51.001505', '2021-04-15 11:52:51.001505', NULL),
	(10001507, 100321, 10000004, 'PW21A-SW100321BL-L', '2021-04-15 11:52:51.001506', '2021-04-15 11:52:51.001506', NULL),
	(10001508, 100321, 10000005, 'PW21A-SW100321BL-XL', '2021-04-15 11:52:51.001507', '2021-04-15 11:52:51.001507', NULL),
	(10001509, 100321, 10000006, 'PW21A-SW100321BL-XXL', '2021-04-15 11:52:51.001508', '2021-04-15 11:52:51.001508', NULL),
	(10001510, 100322, 10000001, 'PW21A-SW100322BL-XS', '2021-04-15 11:52:51.001509', '2021-04-15 11:52:51.001509', NULL),
	(10001511, 100322, 10000002, 'PW21A-SW100322BL-S', '2021-04-15 11:52:51.001510', '2021-04-15 11:52:51.001510', NULL),
	(10001512, 100322, 10000003, 'PW21A-SW100322BL-M', '2021-04-15 11:52:51.001511', '2021-04-15 11:52:51.001511', NULL),
	(10001513, 100322, 10000004, 'PW21A-SW100322BL-L', '2021-04-15 11:52:51.001512', '2021-04-15 11:52:51.001512', NULL),
	(10001514, 100322, 10000005, 'PW21A-SW100322BL-XL', '2021-04-15 11:52:51.001513', '2021-04-15 11:52:51.001513', NULL),
	(10001515, 100322, 10000006, 'PW21A-SW100322BL-XXL', '2021-04-15 11:52:51.001514', '2021-04-15 11:52:51.001514', NULL),
	(10001516, 100323, 10000001, 'PW21A-SW100323BL-XS', '2021-04-15 11:52:51.001515', '2021-04-15 11:52:51.001515', NULL),
	(10001517, 100323, 10000002, 'PW21A-SW100323BL-S', '2021-04-15 11:52:51.001516', '2021-04-15 11:52:51.001516', NULL),
	(10001518, 100323, 10000003, 'PW21A-SW100323BL-M', '2021-04-15 11:52:51.001517', '2021-04-15 11:52:51.001517', NULL),
	(10001519, 100323, 10000004, 'PW21A-SW100323BL-L', '2021-04-15 11:52:51.001518', '2021-04-15 11:52:51.001518', NULL),
	(10001520, 100323, 10000005, 'PW21A-SW100323BL-XL', '2021-04-15 11:52:51.001519', '2021-04-15 11:52:51.001519', NULL),
	(10001521, 100323, 10000006, 'PW21A-SW100323BL-XXL', '2021-04-15 11:52:51.001520', '2021-04-15 11:52:51.001520', NULL),
	(10001522, 100324, 10000001, 'PW21A-SW100324BL-XS', '2021-04-15 11:52:51.001521', '2021-04-15 11:52:51.001521', NULL),
	(10001523, 100324, 10000002, 'PW21A-SW100324BL-S', '2021-04-15 11:52:51.001522', '2021-04-15 11:52:51.001522', NULL),
	(10001524, 100324, 10000003, 'PW21A-SW100324BL-M', '2021-04-15 11:52:51.001523', '2021-04-15 11:52:51.001523', NULL),
	(10001525, 100324, 10000004, 'PW21A-SW100324BL-L', '2021-04-15 11:52:51.001524', '2021-04-15 11:52:51.001524', NULL),
	(10001526, 100324, 10000005, 'PW21A-SW100324BL-XL', '2021-04-15 11:52:51.001525', '2021-04-15 11:52:51.001525', NULL),
	(10001527, 100324, 10000006, 'PW21A-SW100324BL-XXL', '2021-04-15 11:52:51.001526', '2021-04-15 11:52:51.001526', NULL),
	(10001528, 100325, 10000001, 'PW21A-SW100325BL-XS', '2021-04-15 11:52:51.001527', '2021-04-15 11:52:51.001527', NULL),
	(10001529, 100325, 10000002, 'PW21A-SW100325BL-S', '2021-04-15 11:52:51.001528', '2021-04-15 11:52:51.001528', NULL),
	(10001530, 100325, 10000003, 'PW21A-SW100325BL-M', '2021-04-15 11:52:51.001529', '2021-04-15 11:52:51.001529', NULL),
	(10001531, 100325, 10000004, 'PW21A-SW100325BL-L', '2021-04-15 11:52:51.001530', '2021-04-15 11:52:51.001530', NULL),
	(10001532, 100325, 10000005, 'PW21A-SW100325BL-XL', '2021-04-15 11:52:51.001531', '2021-04-15 11:52:51.001531', NULL),
	(10001533, 100325, 10000006, 'PW21A-SW100325BL-XXL', '2021-04-15 11:52:51.001532', '2021-04-15 11:52:51.001532', NULL),
	(10001534, 100326, 10000001, 'PW21A-SW100326BL-XS', '2021-04-15 11:52:51.001533', '2021-04-15 11:52:51.001533', NULL),
	(10001535, 100326, 10000002, 'PW21A-SW100326BL-S', '2021-04-15 11:52:51.001534', '2021-04-15 11:52:51.001534', NULL),
	(10001536, 100326, 10000003, 'PW21A-SW100326BL-M', '2021-04-15 11:52:51.001535', '2021-04-15 11:52:51.001535', NULL),
	(10001537, 100326, 10000004, 'PW21A-SW100326BL-L', '2021-04-15 11:52:51.001536', '2021-04-15 11:52:51.001536', NULL),
	(10001538, 100326, 10000005, 'PW21A-SW100326BL-XL', '2021-04-15 11:52:51.001537', '2021-04-15 11:52:51.001537', NULL),
	(10001539, 100326, 10000006, 'PW21A-SW100326BL-XXL', '2021-04-15 11:52:51.001538', '2021-04-15 11:52:51.001538', NULL),
	(10001540, 100327, 10000001, 'PW21A-SW100327BL-XS', '2021-04-15 11:52:51.001539', '2021-04-15 11:52:51.001539', NULL),
	(10001541, 100327, 10000002, 'PW21A-SW100327BL-S', '2021-04-15 11:52:51.001540', '2021-04-15 11:52:51.001540', NULL),
	(10001542, 100327, 10000003, 'PW21A-SW100327BL-M', '2021-04-15 11:52:51.001541', '2021-04-15 11:52:51.001541', NULL),
	(10001543, 100327, 10000004, 'PW21A-SW100327BL-L', '2021-04-15 11:52:51.001542', '2021-04-15 11:52:51.001542', NULL),
	(10001544, 100327, 10000005, 'PW21A-SW100327BL-XL', '2021-04-15 11:52:51.001543', '2021-04-15 11:52:51.001543', NULL),
	(10001545, 100327, 10000006, 'PW21A-SW100327BL-XXL', '2021-04-15 11:52:51.001544', '2021-04-15 11:52:51.001544', NULL),
	(10001546, 100328, 10000001, 'PW21A-SW100328BL-XS', '2021-04-15 11:52:51.001545', '2021-04-15 11:52:51.001545', NULL),
	(10001547, 100328, 10000002, 'PW21A-SW100328BL-S', '2021-04-15 11:52:51.001546', '2021-04-15 11:52:51.001546', NULL),
	(10001548, 100328, 10000003, 'PW21A-SW100328BL-M', '2021-04-15 11:52:51.001547', '2021-04-15 11:52:51.001547', NULL),
	(10001549, 100328, 10000004, 'PW21A-SW100328BL-L', '2021-04-15 11:52:51.001548', '2021-04-15 11:52:51.001548', NULL),
	(10001550, 100328, 10000005, 'PW21A-SW100328BL-XL', '2021-04-15 11:52:51.001549', '2021-04-15 11:52:51.001549', NULL),
	(10001551, 100328, 10000006, 'PW21A-SW100328BL-XXL', '2021-04-15 11:52:51.001550', '2021-04-15 11:52:51.001550', NULL),
	(10001552, 100329, 10000001, 'PW21A-SW100329BL-XS', '2021-04-15 11:52:51.001551', '2021-04-15 11:52:51.001551', NULL),
	(10001553, 100329, 10000002, 'PW21A-SW100329BL-S', '2021-04-15 11:52:51.001552', '2021-04-15 11:52:51.001552', NULL),
	(10001554, 100329, 10000003, 'PW21A-SW100329BL-M', '2021-04-15 11:52:51.001553', '2021-04-15 11:52:51.001553', NULL),
	(10001555, 100329, 10000004, 'PW21A-SW100329BL-L', '2021-04-15 11:52:51.001554', '2021-04-15 11:52:51.001554', NULL),
	(10001556, 100329, 10000005, 'PW21A-SW100329BL-XL', '2021-04-15 11:52:51.001555', '2021-04-15 11:52:51.001555', NULL),
	(10001557, 100329, 10000006, 'PW21A-SW100329BL-XXL', '2021-04-15 11:52:51.001556', '2021-04-15 11:52:51.001556', NULL),
	(10001558, 100330, 10000001, 'PW21A-SW100330BL-XS', '2021-04-15 11:52:51.001557', '2021-04-15 11:52:51.001557', NULL),
	(10001559, 100330, 10000002, 'PW21A-SW100330BL-S', '2021-04-15 11:52:51.001558', '2021-04-15 11:52:51.001558', NULL),
	(10001560, 100330, 10000003, 'PW21A-SW100330BL-M', '2021-04-15 11:52:51.001559', '2021-04-15 11:52:51.001559', NULL),
	(10001561, 100330, 10000004, 'PW21A-SW100330BL-L', '2021-04-15 11:52:51.001560', '2021-04-15 11:52:51.001560', NULL),
	(10001562, 100330, 10000005, 'PW21A-SW100330BL-XL', '2021-04-15 11:52:51.001561', '2021-04-15 11:52:51.001561', NULL),
	(10001563, 100330, 10000006, 'PW21A-SW100330BL-XXL', '2021-04-15 11:52:51.001562', '2021-04-15 11:52:51.001562', NULL),
	(10001564, 100331, 10000007, 'PW21A-PN100331BL-28', '2021-04-15 11:52:51.001563', '2021-04-15 11:52:51.001563', NULL),
	(10001565, 100331, 10000008, 'PW21A-PN100331BL-30', '2021-04-15 11:52:51.001564', '2021-04-15 11:52:51.001564', NULL),
	(10001566, 100331, 10000009, 'PW21A-PN100331BL-32', '2021-04-15 11:52:51.001565', '2021-04-15 11:52:51.001565', NULL),
	(10001567, 100331, 10000010, 'PW21A-PN100331BL-34', '2021-04-15 11:52:51.001566', '2021-04-15 11:52:51.001566', NULL),
	(10001568, 100331, 10000011, 'PW21A-PN100331BL-36', '2021-04-15 11:52:51.001567', '2021-04-15 11:52:51.001567', NULL),
	(10001569, 100332, 10000007, 'PW21A-PN100332BL-28', '2021-04-15 11:52:51.001568', '2021-04-15 11:52:51.001568', NULL),
	(10001570, 100332, 10000008, 'PW21A-PN100332BL-30', '2021-04-15 11:52:51.001569', '2021-04-15 11:52:51.001569', NULL),
	(10001571, 100332, 10000009, 'PW21A-PN100332BL-32', '2021-04-15 11:52:51.001570', '2021-04-15 11:52:51.001570', NULL),
	(10001572, 100332, 10000010, 'PW21A-PN100332BL-34', '2021-04-15 11:52:51.001571', '2021-04-15 11:52:51.001571', NULL),
	(10001573, 100332, 10000011, 'PW21A-PN100332BL-36', '2021-04-15 11:52:51.001572', '2021-04-15 11:52:51.001572', NULL),
	(10001574, 100333, 10000007, 'PW21A-PN100333BL-28', '2021-04-15 11:52:51.001573', '2021-04-15 11:52:51.001573', NULL),
	(10001575, 100333, 10000008, 'PW21A-PN100333BL-30', '2021-04-15 11:52:51.001574', '2021-04-15 11:52:51.001574', NULL),
	(10001576, 100333, 10000009, 'PW21A-PN100333BL-32', '2021-04-15 11:52:51.001575', '2021-04-15 11:52:51.001575', NULL),
	(10001577, 100333, 10000010, 'PW21A-PN100333BL-34', '2021-04-15 11:52:51.001576', '2021-04-15 11:52:51.001576', NULL),
	(10001578, 100333, 10000011, 'PW21A-PN100333BL-36', '2021-04-15 11:52:51.001577', '2021-04-15 11:52:51.001577', NULL),
	(10001579, 100334, 10000007, 'PW21A-PN100334BL-28', '2021-04-15 11:52:51.001578', '2021-04-15 11:52:51.001578', NULL),
	(10001580, 100334, 10000008, 'PW21A-PN100334BL-30', '2021-04-15 11:52:51.001579', '2021-04-15 11:52:51.001579', NULL),
	(10001581, 100334, 10000009, 'PW21A-PN100334BL-32', '2021-04-15 11:52:51.001580', '2021-04-15 11:52:51.001580', NULL),
	(10001582, 100334, 10000010, 'PW21A-PN100334BL-34', '2021-04-15 11:52:51.001581', '2021-04-15 11:52:51.001581', NULL),
	(10001583, 100334, 10000011, 'PW21A-PN100334BL-36', '2021-04-15 11:52:51.001582', '2021-04-15 11:52:51.001582', NULL),
	(10001584, 100335, 10000007, 'PW21A-PN100335BL-28', '2021-04-15 11:52:51.001583', '2021-04-15 11:52:51.001583', NULL),
	(10001585, 100335, 10000008, 'PW21A-PN100335BL-30', '2021-04-15 11:52:51.001584', '2021-04-15 11:52:51.001584', NULL),
	(10001586, 100335, 10000009, 'PW21A-PN100335BL-32', '2021-04-15 11:52:51.001585', '2021-04-15 11:52:51.001585', NULL),
	(10001587, 100335, 10000010, 'PW21A-PN100335BL-34', '2021-04-15 11:52:51.001586', '2021-04-15 11:52:51.001586', NULL),
	(10001588, 100335, 10000011, 'PW21A-PN100335BL-36', '2021-04-15 11:52:51.001587', '2021-04-15 11:52:51.001587', NULL),
	(10001589, 100336, 10000007, 'PW21A-PN100336GN-28', '2021-04-15 11:52:51.001588', '2021-04-15 11:52:51.001588', NULL),
	(10001590, 100336, 10000008, 'PW21A-PN100336GN-30', '2021-04-15 11:52:51.001589', '2021-04-15 11:52:51.001589', NULL),
	(10001591, 100336, 10000009, 'PW21A-PN100336GN-32', '2021-04-15 11:52:51.001590', '2021-04-15 11:52:51.001590', NULL),
	(10001592, 100336, 10000010, 'PW21A-PN100336GN-34', '2021-04-15 11:52:51.001591', '2021-04-15 11:52:51.001591', NULL),
	(10001593, 100336, 10000011, 'PW21A-PN100336GN-36', '2021-04-15 11:52:51.001592', '2021-04-15 11:52:51.001592', NULL),
	(10001594, 100337, 10000007, 'PW21A-PN100337CM-28', '2021-04-15 11:52:51.001593', '2021-04-15 11:52:51.001593', NULL),
	(10001595, 100337, 10000008, 'PW21A-PN100337CM-30', '2021-04-15 11:52:51.001594', '2021-04-15 11:52:51.001594', NULL),
	(10001596, 100337, 10000009, 'PW21A-PN100337CM-32', '2021-04-15 11:52:51.001595', '2021-04-15 11:52:51.001595', NULL),
	(10001597, 100337, 10000010, 'PW21A-PN100337CM-34', '2021-04-15 11:52:51.001596', '2021-04-15 11:52:51.001596', NULL),
	(10001598, 100337, 10000011, 'PW21A-PN100337CM-36', '2021-04-15 11:52:51.001597', '2021-04-15 11:52:51.001597', NULL),
	(10001599, 100338, 10000007, 'PW21A-PN100338BL-28', '2021-04-15 11:52:51.001598', '2021-04-15 11:52:51.001598', NULL),
	(10001600, 100338, 10000008, 'PW21A-PN100338BL-30', '2021-04-15 11:52:51.001599', '2021-04-15 11:52:51.001599', NULL),
	(10001601, 100338, 10000009, 'PW21A-PN100338BL-32', '2021-04-15 11:52:51.001600', '2021-04-15 11:52:51.001600', NULL),
	(10001602, 100338, 10000010, 'PW21A-PN100338BL-34', '2021-04-15 11:52:51.001601', '2021-04-15 11:52:51.001601', NULL),
	(10001603, 100338, 10000011, 'PW21A-PN100338BL-36', '2021-04-15 11:52:51.001602', '2021-04-15 11:52:51.001602', NULL),
	(10001604, 100339, 10000007, 'PW21A-PN100339CM-28', '2021-04-15 11:52:51.001603', '2021-04-15 11:52:51.001603', NULL),
	(10001605, 100339, 10000008, 'PW21A-PN100339CM-30', '2021-04-15 11:52:51.001604', '2021-04-15 11:52:51.001604', NULL),
	(10001606, 100339, 10000009, 'PW21A-PN100339CM-32', '2021-04-15 11:52:51.001605', '2021-04-15 11:52:51.001605', NULL),
	(10001607, 100339, 10000010, 'PW21A-PN100339CM-34', '2021-04-15 11:52:51.001606', '2021-04-15 11:52:51.001606', NULL),
	(10001608, 100339, 10000011, 'PW21A-PN100339CM-36', '2021-04-15 11:52:51.001607', '2021-04-15 11:52:51.001607', NULL),
	(10001609, 100340, 10000007, 'PW21A-PN100340OL-28', '2021-04-15 11:52:51.001608', '2021-04-15 11:52:51.001608', NULL),
	(10001610, 100340, 10000008, 'PW21A-PN100340OL-30', '2021-04-15 11:52:51.001609', '2021-04-15 11:52:51.001609', NULL),
	(10001611, 100340, 10000009, 'PW21A-PN100340OL-32', '2021-04-15 11:52:51.001610', '2021-04-15 11:52:51.001610', NULL),
	(10001612, 100340, 10000010, 'PW21A-PN100340OL-34', '2021-04-15 11:52:51.001611', '2021-04-15 11:52:51.001611', NULL),
	(10001613, 100340, 10000011, 'PW21A-PN100340OL-36', '2021-04-15 11:52:51.001612', '2021-04-15 11:52:51.001612', NULL),
	(10001614, 100341, 10000007, 'PW21A-PN100341DM-28', '2021-04-15 11:52:51.001613', '2021-04-15 11:52:51.001613', NULL),
	(10001615, 100341, 10000008, 'PW21A-PN100341DM-30', '2021-04-15 11:52:51.001614', '2021-04-15 11:52:51.001614', NULL),
	(10001616, 100341, 10000009, 'PW21A-PN100341DM-32', '2021-04-15 11:52:51.001615', '2021-04-15 11:52:51.001615', NULL),
	(10001617, 100341, 10000010, 'PW21A-PN100341DM-34', '2021-04-15 11:52:51.001616', '2021-04-15 11:52:51.001616', NULL),
	(10001618, 100341, 10000011, 'PW21A-PN100341DM-36', '2021-04-15 11:52:51.001617', '2021-04-15 11:52:51.001617', NULL),
	(10001619, 100342, 10000007, 'PW21A-PN100342DM-28', '2021-04-15 11:52:51.001618', '2021-04-15 11:52:51.001618', NULL),
	(10001620, 100342, 10000008, 'PW21A-PN100342DM-30', '2021-04-15 11:52:51.001619', '2021-04-15 11:52:51.001619', NULL),
	(10001621, 100342, 10000009, 'PW21A-PN100342DM-32', '2021-04-15 11:52:51.001620', '2021-04-15 11:52:51.001620', NULL),
	(10001622, 100342, 10000010, 'PW21A-PN100342DM-34', '2021-04-15 11:52:51.001621', '2021-04-15 11:52:51.001621', NULL),
	(10001623, 100342, 10000011, 'PW21A-PN100342DM-36', '2021-04-15 11:52:51.001622', '2021-04-15 11:52:51.001622', NULL),
	(10001624, 100343, 10000007, 'PW21A-PN100343DM-28', '2021-04-15 11:52:51.001623', '2021-04-15 11:52:51.001623', NULL),
	(10001625, 100343, 10000008, 'PW21A-PN100343DM-30', '2021-04-15 11:52:51.001624', '2021-04-15 11:52:51.001624', NULL),
	(10001626, 100343, 10000009, 'PW21A-PN100343DM-32', '2021-04-15 11:52:51.001625', '2021-04-15 11:52:51.001625', NULL),
	(10001627, 100343, 10000010, 'PW21A-PN100343DM-34', '2021-04-15 11:52:51.001626', '2021-04-15 11:52:51.001626', NULL),
	(10001628, 100343, 10000011, 'PW21A-PN100343DM-36', '2021-04-15 11:52:51.001627', '2021-04-15 11:52:51.001627', NULL),
	(10001629, 100344, 10000012, 'PW21A-WL100344BW-All', '2021-04-15 11:52:51.001628', '2021-04-15 11:52:51.001628', NULL),
	(10001630, 100345, 10000012, 'PW21A-WL100345BW-All', '2021-04-15 11:52:51.001629', '2021-04-15 11:52:51.001629', NULL),
	(10001631, 100346, 10000012, 'PW21A-WL100346BW-All', '2021-04-15 11:52:51.001630', '2021-04-15 11:52:51.001630', NULL),
	(10001632, 100347, 10000001, 'PW21A-HM100347BL-XS', '2021-04-15 11:52:51.001631', '2021-04-15 11:52:51.001631', NULL),
	(10001633, 100347, 10000002, 'PW21A-HM100347BL-S', '2021-04-15 11:52:51.001632', '2021-04-15 11:52:51.001632', NULL),
	(10001634, 100347, 10000003, 'PW21A-HM100347BL-M', '2021-04-15 11:52:51.001633', '2021-04-15 11:52:51.001633', NULL),
	(10001635, 100347, 10000004, 'PW21A-HM100347BL-L', '2021-04-15 11:52:51.001634', '2021-04-15 11:52:51.001634', NULL),
	(10001636, 100347, 10000005, 'PW21A-HM100347BL-XL', '2021-04-15 11:52:51.001635', '2021-04-15 11:52:51.001635', NULL),
	(10001637, 100347, 10000006, 'PW21A-HM100347BL-XXL', '2021-04-15 11:52:51.001636', '2021-04-15 11:52:51.001636', NULL),
	(10001638, 100348, 10000001, 'PW21A-HM100348WT-XS', '2021-04-15 11:52:51.001637', '2021-04-15 11:52:51.001637', NULL),
	(10001639, 100348, 10000002, 'PW21A-HM100348WT-S', '2021-04-15 11:52:51.001638', '2021-04-15 11:52:51.001638', NULL),
	(10001640, 100348, 10000003, 'PW21A-HM100348WT-M', '2021-04-15 11:52:51.001639', '2021-04-15 11:52:51.001639', NULL),
	(10001641, 100348, 10000004, 'PW21A-HM100348WT-L', '2021-04-15 11:52:51.001640', '2021-04-15 11:52:51.001640', NULL),
	(10001642, 100348, 10000005, 'PW21A-HM100348WT-XL', '2021-04-15 11:52:51.001641', '2021-04-15 11:52:51.001641', NULL),
	(10001643, 100348, 10000006, 'PW21A-HM100348WT-XXL', '2021-04-15 11:52:51.001642', '2021-04-15 11:52:51.001642', NULL),
	(10001644, 100349, 10000001, 'PW21A-HM100349BL-XS', '2021-04-15 11:52:51.001643', '2021-04-15 11:52:51.001643', NULL),
	(10001645, 100349, 10000002, 'PW21A-HM100349BL-S', '2021-04-15 11:52:51.001644', '2021-04-15 11:52:51.001644', NULL),
	(10001646, 100349, 10000003, 'PW21A-HM100349BL-M', '2021-04-15 11:52:51.001645', '2021-04-15 11:52:51.001645', NULL),
	(10001647, 100349, 10000004, 'PW21A-HM100349BL-L', '2021-04-15 11:52:51.001646', '2021-04-15 11:52:51.001646', NULL),
	(10001648, 100349, 10000005, 'PW21A-HM100349BL-XL', '2021-04-15 11:52:51.001647', '2021-04-15 11:52:51.001647', NULL),
	(10001649, 100349, 10000006, 'PW21A-HM100349BL-XXL', '2021-04-15 11:52:51.001648', '2021-04-15 11:52:51.001648', NULL),
	(10001650, 100350, 10000001, 'PW21A-HM100350BL-XS', '2021-04-15 11:52:51.001649', '2021-04-15 11:52:51.001649', NULL),
	(10001651, 100350, 10000002, 'PW21A-HM100350BL-S', '2021-04-15 11:52:51.001650', '2021-04-15 11:52:51.001650', NULL),
	(10001652, 100350, 10000003, 'PW21A-HM100350BL-M', '2021-04-15 11:52:51.001651', '2021-04-15 11:52:51.001651', NULL),
	(10001653, 100350, 10000004, 'PW21A-HM100350BL-L', '2021-04-15 11:52:51.001652', '2021-04-15 11:52:51.001652', NULL),
	(10001654, 100350, 10000005, 'PW21A-HM100350BL-XL', '2021-04-15 11:52:51.001653', '2021-04-15 11:52:51.001653', NULL),
	(10001655, 100350, 10000006, 'PW21A-HM100350BL-XXL', '2021-04-15 11:52:51.001654', '2021-04-15 11:52:51.001654', NULL),
	(10001656, 100351, 10000001, 'PW21A-HM100351BL-XS', '2021-04-15 11:52:51.001655', '2021-04-15 11:52:51.001655', NULL),
	(10001657, 100351, 10000002, 'PW21A-HM100351BL-S', '2021-04-15 11:52:51.001656', '2021-04-15 11:52:51.001656', NULL),
	(10001658, 100351, 10000003, 'PW21A-HM100351BL-M', '2021-04-15 11:52:51.001657', '2021-04-15 11:52:51.001657', NULL),
	(10001659, 100351, 10000004, 'PW21A-HM100351BL-L', '2021-04-15 11:52:51.001658', '2021-04-15 11:52:51.001658', NULL),
	(10001660, 100351, 10000005, 'PW21A-HM100351BL-XL', '2021-04-15 11:52:51.001659', '2021-04-15 11:52:51.001659', NULL),
	(10001661, 100351, 10000006, 'PW21A-HM100351BL-XXL', '2021-04-15 11:52:51.001660', '2021-04-15 11:52:51.001660', NULL),
	(10001662, 100352, 10000001, 'PW21A-HM100352BL-XS', '2021-04-15 11:52:51.001661', '2021-04-15 11:52:51.001661', NULL),
	(10001663, 100352, 10000002, 'PW21A-HM100352BL-S', '2021-04-15 11:52:51.001662', '2021-04-15 11:52:51.001662', NULL),
	(10001664, 100352, 10000003, 'PW21A-HM100352BL-M', '2021-04-15 11:52:51.001663', '2021-04-15 11:52:51.001663', NULL),
	(10001665, 100352, 10000004, 'PW21A-HM100352BL-L', '2021-04-15 11:52:51.001664', '2021-04-15 11:52:51.001664', NULL),
	(10001666, 100352, 10000005, 'PW21A-HM100352BL-XL', '2021-04-15 11:52:51.001665', '2021-04-15 11:52:51.001665', NULL),
	(10001667, 100352, 10000006, 'PW21A-HM100352BL-XXL', '2021-04-15 11:52:51.001666', '2021-04-15 11:52:51.001666', NULL),
	(10001668, 100353, 10000001, 'PW21A-HM100353WT-XS', '2021-04-15 11:52:51.001667', '2021-04-15 11:52:51.001667', NULL),
	(10001669, 100353, 10000002, 'PW21A-HM100353WT-S', '2021-04-15 11:52:51.001668', '2021-04-15 11:52:51.001668', NULL),
	(10001670, 100353, 10000003, 'PW21A-HM100353WT-M', '2021-04-15 11:52:51.001669', '2021-04-15 11:52:51.001669', NULL),
	(10001671, 100353, 10000004, 'PW21A-HM100353WT-L', '2021-04-15 11:52:51.001670', '2021-04-15 11:52:51.001670', NULL),
	(10001672, 100353, 10000005, 'PW21A-HM100353WT-XL', '2021-04-15 11:52:51.001671', '2021-04-15 11:52:51.001671', NULL),
	(10001673, 100353, 10000006, 'PW21A-HM100353WT-XXL', '2021-04-15 11:52:51.001672', '2021-04-15 11:52:51.001672', NULL),
	(10001674, 100354, 10000001, 'PW21A-HM100354WT-XS', '2021-04-15 11:52:51.001673', '2021-04-15 11:52:51.001673', NULL),
	(10001675, 100354, 10000002, 'PW21A-HM100354WT-S', '2021-04-15 11:52:51.001674', '2021-04-15 11:52:51.001674', NULL),
	(10001676, 100354, 10000003, 'PW21A-HM100354WT-M', '2021-04-15 11:52:51.001675', '2021-04-15 11:52:51.001675', NULL),
	(10001677, 100354, 10000004, 'PW21A-HM100354WT-L', '2021-04-15 11:52:51.001676', '2021-04-15 11:52:51.001676', NULL),
	(10001678, 100354, 10000005, 'PW21A-HM100354WT-XL', '2021-04-15 11:52:51.001677', '2021-04-15 11:52:51.001677', NULL),
	(10001679, 100354, 10000006, 'PW21A-HM100354WT-XXL', '2021-04-15 11:52:51.001678', '2021-04-15 11:52:51.001678', NULL),
	(10001680, 100355, 10000001, 'PW21A-HM100355RD-XS', '2021-04-15 11:52:51.001679', '2021-04-15 11:52:51.001679', NULL),
	(10001681, 100355, 10000002, 'PW21A-HM100355RD-S', '2021-04-15 11:52:51.001680', '2021-04-15 11:52:51.001680', NULL),
	(10001682, 100355, 10000003, 'PW21A-HM100355RD-M', '2021-04-15 11:52:51.001681', '2021-04-15 11:52:51.001681', NULL),
	(10001683, 100355, 10000004, 'PW21A-HM100355RD-L', '2021-04-15 11:52:51.001682', '2021-04-15 11:52:51.001682', NULL),
	(10001684, 100355, 10000005, 'PW21A-HM100355RD-XL', '2021-04-15 11:52:51.001683', '2021-04-15 11:52:51.001683', NULL),
	(10001685, 100355, 10000006, 'PW21A-HM100355RD-XXL', '2021-04-15 11:52:51.001684', '2021-04-15 11:52:51.001684', NULL),
	(10001686, 100356, 10000001, 'PW21A-HM100356YW -XS', '2021-04-15 11:52:51.001685', '2021-04-15 11:52:51.001685', NULL),
	(10001687, 100356, 10000002, 'PW21A-HM100356YW -S', '2021-04-15 11:52:51.001686', '2021-04-15 11:52:51.001686', NULL),
	(10001688, 100356, 10000003, 'PW21A-HM100356YW -M', '2021-04-15 11:52:51.001687', '2021-04-15 11:52:51.001687', NULL),
	(10001689, 100356, 10000004, 'PW21A-HM100356YW -L', '2021-04-15 11:52:51.001688', '2021-04-15 11:52:51.001688', NULL),
	(10001690, 100356, 10000005, 'PW21A-HM100356YW -XL', '2021-04-15 11:52:51.001689', '2021-04-15 11:52:51.001689', NULL),
	(10001691, 100356, 10000006, 'PW21A-HM100356YW -XXL', '2021-04-15 11:52:51.001690', '2021-04-15 11:52:51.001690', NULL),
	(10001692, 100357, 10000001, 'PW21A-HM100357YW -XS', '2021-04-15 11:52:51.001691', '2021-04-15 11:52:51.001691', NULL),
	(10001693, 100357, 10000002, 'PW21A-HM100357YW -S', '2021-04-15 11:52:51.001692', '2021-04-15 11:52:51.001692', NULL),
	(10001694, 100357, 10000003, 'PW21A-HM100357YW -M', '2021-04-15 11:52:51.001693', '2021-04-15 11:52:51.001693', NULL),
	(10001695, 100357, 10000004, 'PW21A-HM100357YW -L', '2021-04-15 11:52:51.001694', '2021-04-15 11:52:51.001694', NULL),
	(10001696, 100357, 10000005, 'PW21A-HM100357YW -XL', '2021-04-15 11:52:51.001695', '2021-04-15 11:52:51.001695', NULL),
	(10001697, 100357, 10000006, 'PW21A-HM100357YW -XXL', '2021-04-15 11:52:51.001696', '2021-04-15 11:52:51.001696', NULL),
	(10001698, 100358, 10000001, 'PW21A-HM100358WT-XS', '2021-04-15 11:52:51.001697', '2021-04-15 11:52:51.001697', NULL),
	(10001699, 100358, 10000002, 'PW21A-HM100358WT-S', '2021-04-15 11:52:51.001698', '2021-04-15 11:52:51.001698', NULL),
	(10001700, 100358, 10000003, 'PW21A-HM100358WT-M', '2021-04-15 11:52:51.001699', '2021-04-15 11:52:51.001699', NULL),
	(10001701, 100358, 10000004, 'PW21A-HM100358WT-L', '2021-04-15 11:52:51.001700', '2021-04-15 11:52:51.001700', NULL),
	(10001702, 100358, 10000005, 'PW21A-HM100358WT-XL', '2021-04-15 11:52:51.001701', '2021-04-15 11:52:51.001701', NULL),
	(10001703, 100358, 10000006, 'PW21A-HM100358WT-XXL', '2021-04-15 11:52:51.001702', '2021-04-15 11:52:51.001702', NULL),
	(10001704, 100359, 10000001, 'PW21A-JK100359NV-XS', '2021-04-15 11:52:51.001703', '2021-04-15 11:52:51.001703', NULL),
	(10001705, 100359, 10000002, 'PW21A-JK100359NV-S', '2021-04-15 11:52:51.001704', '2021-04-15 11:52:51.001704', NULL),
	(10001706, 100359, 10000003, 'PW21A-JK100359NV-M', '2021-04-15 11:52:51.001705', '2021-04-15 11:52:51.001705', NULL),
	(10001707, 100359, 10000004, 'PW21A-JK100359NV-L', '2021-04-15 11:52:51.001706', '2021-04-15 11:52:51.001706', NULL),
	(10001708, 100359, 10000005, 'PW21A-JK100359NV-XL', '2021-04-15 11:52:51.001707', '2021-04-15 11:52:51.001707', NULL),
	(10001709, 100359, 10000006, 'PW21A-JK100359NV-XXL', '2021-04-15 11:52:51.001708', '2021-04-15 11:52:51.001708', NULL),
	(10001710, 100360, 10000001, 'PW21A-SH100360DM-XS', '2021-04-15 11:52:51.001709', '2021-04-15 11:52:51.001709', NULL),
	(10001711, 100360, 10000002, 'PW21A-SH100360DM-S', '2021-04-15 11:52:51.001710', '2021-04-15 11:52:51.001710', NULL),
	(10001712, 100360, 10000003, 'PW21A-SH100360DM-M', '2021-04-15 11:52:51.001711', '2021-04-15 11:52:51.001711', NULL),
	(10001713, 100360, 10000004, 'PW21A-SH100360DM-L', '2021-04-15 11:52:51.001712', '2021-04-15 11:52:51.001712', NULL),
	(10001714, 100360, 10000005, 'PW21A-SH100360DM-XL', '2021-04-15 11:52:51.001713', '2021-04-15 11:52:51.001713', NULL),
	(10001715, 100360, 10000006, 'PW21A-SH100360DM-XXL', '2021-04-15 11:52:51.001714', '2021-04-15 11:52:51.001714', NULL),
	(10001716, 100361, 10000001, 'PW21A-SH100361BL-XS', '2021-04-15 11:52:51.001715', '2021-04-15 11:52:51.001715', NULL),
	(10001717, 100361, 10000002, 'PW21A-SH100361BL-S', '2021-04-15 11:52:51.001716', '2021-04-15 11:52:51.001716', NULL),
	(10001718, 100361, 10000003, 'PW21A-SH100361BL-M', '2021-04-15 11:52:51.001717', '2021-04-15 11:52:51.001717', NULL),
	(10001719, 100361, 10000004, 'PW21A-SH100361BL-L', '2021-04-15 11:52:51.001718', '2021-04-15 11:52:51.001718', NULL),
	(10001720, 100361, 10000005, 'PW21A-SH100361BL-XL', '2021-04-15 11:52:51.001719', '2021-04-15 11:52:51.001719', NULL),
	(10001721, 100361, 10000006, 'PW21A-SH100361BL-XXL', '2021-04-15 11:52:51.001720', '2021-04-15 11:52:51.001720', NULL),
	(10001722, 100362, 10000001, 'PW21A-SH100362BL-XS', '2021-04-15 11:52:51.001721', '2021-04-15 11:52:51.001721', NULL),
	(10001723, 100362, 10000002, 'PW21A-SH100362BL-S', '2021-04-15 11:52:51.001722', '2021-04-15 11:52:51.001722', NULL),
	(10001724, 100362, 10000003, 'PW21A-SH100362BL-M', '2021-04-15 11:52:51.001723', '2021-04-15 11:52:51.001723', NULL),
	(10001725, 100362, 10000004, 'PW21A-SH100362BL-L', '2021-04-15 11:52:51.001724', '2021-04-15 11:52:51.001724', NULL),
	(10001726, 100362, 10000005, 'PW21A-SH100362BL-XL', '2021-04-15 11:52:51.001725', '2021-04-15 11:52:51.001725', NULL),
	(10001727, 100362, 10000006, 'PW21A-SH100362BL-XXL', '2021-04-15 11:52:51.001726', '2021-04-15 11:52:51.001726', NULL),
	(10001728, 100363, 10000001, 'PW21A-JK100363BL-XS', '2021-04-15 11:52:51.001727', '2021-04-15 11:52:51.001727', NULL),
	(10001729, 100363, 10000002, 'PW21A-JK100363BL-S', '2021-04-15 11:52:51.001728', '2021-04-15 11:52:51.001728', NULL),
	(10001730, 100363, 10000003, 'PW21A-JK100363BL-M', '2021-04-15 11:52:51.001729', '2021-04-15 11:52:51.001729', NULL),
	(10001731, 100363, 10000004, 'PW21A-JK100363BL-L', '2021-04-15 11:52:51.001730', '2021-04-15 11:52:51.001730', NULL),
	(10001732, 100363, 10000005, 'PW21A-JK100363BL-XL', '2021-04-15 11:52:51.001731', '2021-04-15 11:52:51.001731', NULL),
	(10001733, 100363, 10000006, 'PW21A-JK100363BL-XXL', '2021-04-15 11:52:51.001732', '2021-04-15 11:52:51.001732', NULL),
	(10001734, 100364, 10000001, 'PW21A-SH100364BL-XS', '2021-04-15 11:52:51.001733', '2021-04-15 11:52:51.001733', NULL),
	(10001735, 100364, 10000002, 'PW21A-SH100364BL-S', '2021-04-15 11:52:51.001734', '2021-04-15 11:52:51.001734', NULL),
	(10001736, 100364, 10000003, 'PW21A-SH100364BL-M', '2021-04-15 11:52:51.001735', '2021-04-15 11:52:51.001735', NULL),
	(10001737, 100364, 10000004, 'PW21A-SH100364BL-L', '2021-04-15 11:52:51.001736', '2021-04-15 11:52:51.001736', NULL),
	(10001738, 100364, 10000005, 'PW21A-SH100364BL-XL', '2021-04-15 11:52:51.001737', '2021-04-15 11:52:51.001737', NULL),
	(10001739, 100364, 10000006, 'PW21A-SH100364BL-XXL', '2021-04-15 11:52:51.001738', '2021-04-15 11:52:51.001738', NULL),
	(10001740, 100365, 10000001, 'PW21A-SW100365GY-XS', '2021-04-15 11:52:51.001739', '2021-04-15 11:52:51.001739', NULL),
	(10001741, 100365, 10000002, 'PW21A-SW100365GY-S', '2021-04-15 11:52:51.001740', '2021-04-15 11:52:51.001740', NULL),
	(10001742, 100365, 10000003, 'PW21A-SW100365GY-M', '2021-04-15 11:52:51.001741', '2021-04-15 11:52:51.001741', NULL),
	(10001743, 100365, 10000004, 'PW21A-SW100365GY-L', '2021-04-15 11:52:51.001742', '2021-04-15 11:52:51.001742', NULL),
	(10001744, 100365, 10000005, 'PW21A-SW100365GY-XL', '2021-04-15 11:52:51.001743', '2021-04-15 11:52:51.001743', NULL),
	(10001745, 100365, 10000006, 'PW21A-SW100365GY-XXL', '2021-04-15 11:52:51.001744', '2021-04-15 11:52:51.001744', NULL),
	(10001746, 100366, 10000001, 'PW21A-SW100366GY-XS', '2021-04-15 11:52:51.001745', '2021-04-15 11:52:51.001745', NULL),
	(10001747, 100366, 10000002, 'PW21A-SW100366GY-S', '2021-04-15 11:52:51.001746', '2021-04-15 11:52:51.001746', NULL),
	(10001748, 100366, 10000003, 'PW21A-SW100366GY-M', '2021-04-15 11:52:51.001747', '2021-04-15 11:52:51.001747', NULL),
	(10001749, 100366, 10000004, 'PW21A-SW100366GY-L', '2021-04-15 11:52:51.001748', '2021-04-15 11:52:51.001748', NULL),
	(10001750, 100366, 10000005, 'PW21A-SW100366GY-XL', '2021-04-15 11:52:51.001749', '2021-04-15 11:52:51.001749', NULL),
	(10001751, 100366, 10000006, 'PW21A-SW100366GY-XXL', '2021-04-15 11:52:51.001750', '2021-04-15 11:52:51.001750', NULL),
	(10001752, 100367, 10000001, 'PW21A-SW100367BL-XS', '2021-04-15 11:52:51.001751', '2021-04-15 11:52:51.001751', NULL),
	(10001753, 100367, 10000002, 'PW21A-SW100367BL-S', '2021-04-15 11:52:51.001752', '2021-04-15 11:52:51.001752', NULL),
	(10001754, 100367, 10000003, 'PW21A-SW100367BL-M', '2021-04-15 11:52:51.001753', '2021-04-15 11:52:51.001753', NULL),
	(10001755, 100367, 10000004, 'PW21A-SW100367BL-L', '2021-04-15 11:52:51.001754', '2021-04-15 11:52:51.001754', NULL),
	(10001756, 100367, 10000005, 'PW21A-SW100367BL-XL', '2021-04-15 11:52:51.001755', '2021-04-15 11:52:51.001755', NULL),
	(10001757, 100367, 10000006, 'PW21A-SW100367BL-XXL', '2021-04-15 11:52:51.001756', '2021-04-15 11:52:51.001756', NULL),
	(10001758, 100368, 10000001, 'PW21A-SW100368NV-XS', '2021-04-15 11:52:51.001757', '2021-04-15 11:52:51.001757', NULL),
	(10001759, 100368, 10000002, 'PW21A-SW100368NV-S', '2021-04-15 11:52:51.001758', '2021-04-15 11:52:51.001758', NULL),
	(10001760, 100368, 10000003, 'PW21A-SW100368NV-M', '2021-04-15 11:52:51.001759', '2021-04-15 11:52:51.001759', NULL),
	(10001761, 100368, 10000004, 'PW21A-SW100368NV-L', '2021-04-15 11:52:51.001760', '2021-04-15 11:52:51.001760', NULL),
	(10001762, 100368, 10000005, 'PW21A-SW100368NV-XL', '2021-04-15 11:52:51.001761', '2021-04-15 11:52:51.001761', NULL),
	(10001763, 100368, 10000006, 'PW21A-SW100368NV-XXL', '2021-04-15 11:52:51.001762', '2021-04-15 11:52:51.001762', NULL),
	(10001764, 100369, 10000001, 'PW21A-JK100369BL-XS', '2021-04-15 11:52:51.001763', '2021-04-15 11:52:51.001763', NULL),
	(10001765, 100369, 10000002, 'PW21A-JK100369BL-S', '2021-04-15 11:52:51.001764', '2021-04-15 11:52:51.001764', NULL),
	(10001766, 100369, 10000003, 'PW21A-JK100369BL-M', '2021-04-15 11:52:51.001765', '2021-04-15 11:52:51.001765', NULL),
	(10001767, 100369, 10000004, 'PW21A-JK100369BL-L', '2021-04-15 11:52:51.001766', '2021-04-15 11:52:51.001766', NULL),
	(10001768, 100369, 10000005, 'PW21A-JK100369BL-XL', '2021-04-15 11:52:51.001767', '2021-04-15 11:52:51.001767', NULL),
	(10001769, 100369, 10000006, 'PW21A-JK100369BL-XXL', '2021-04-15 11:52:51.001768', '2021-04-15 11:52:51.001768', NULL),
	(10001770, 100370, 10000001, 'PW21A-SH100370NV-XS', '2021-04-15 11:52:51.001769', '2021-04-15 11:52:51.001769', NULL),
	(10001771, 100370, 10000002, 'PW21A-SH100370NV-S', '2021-04-15 11:52:51.001770', '2021-04-15 11:52:51.001770', NULL),
	(10001772, 100370, 10000003, 'PW21A-SH100370NV-M', '2021-04-15 11:52:51.001771', '2021-04-15 11:52:51.001771', NULL),
	(10001773, 100370, 10000004, 'PW21A-SH100370NV-L', '2021-04-15 11:52:51.001772', '2021-04-15 11:52:51.001772', NULL),
	(10001774, 100370, 10000005, 'PW21A-SH100370NV-XL', '2021-04-15 11:52:51.001773', '2021-04-15 11:52:51.001773', NULL),
	(10001775, 100370, 10000006, 'PW21A-SH100370NV-XXL', '2021-04-15 11:52:51.001774', '2021-04-15 11:52:51.001774', NULL),
	(10001776, 100371, 10000001, 'PW21A-SH100371BL-XS', '2021-04-15 11:52:51.001775', '2021-04-15 11:52:51.001775', NULL),
	(10001777, 100371, 10000002, 'PW21A-SH100371BL-S', '2021-04-15 11:52:51.001776', '2021-04-15 11:52:51.001776', NULL),
	(10001778, 100371, 10000003, 'PW21A-SH100371BL-M', '2021-04-15 11:52:51.001777', '2021-04-15 11:52:51.001777', NULL),
	(10001779, 100371, 10000004, 'PW21A-SH100371BL-L', '2021-04-15 11:52:51.001778', '2021-04-15 11:52:51.001778', NULL),
	(10001780, 100371, 10000005, 'PW21A-SH100371BL-XL', '2021-04-15 11:52:51.001779', '2021-04-15 11:52:51.001779', NULL),
	(10001781, 100371, 10000006, 'PW21A-SH100371BL-XXL', '2021-04-15 11:52:51.001780', '2021-04-15 11:52:51.001780', NULL),
	(10001782, 100372, 10000001, 'PW21A-SH100372DK-XS', '2021-04-15 11:52:51.001781', '2021-04-15 11:52:51.001781', NULL),
	(10001783, 100372, 10000002, 'PW21A-SH100372DK-S', '2021-04-15 11:52:51.001782', '2021-04-15 11:52:51.001782', NULL),
	(10001784, 100372, 10000003, 'PW21A-SH100372DK-M', '2021-04-15 11:52:51.001783', '2021-04-15 11:52:51.001783', NULL),
	(10001785, 100372, 10000004, 'PW21A-SH100372DK-L', '2021-04-15 11:52:51.001784', '2021-04-15 11:52:51.001784', NULL),
	(10001786, 100372, 10000005, 'PW21A-SH100372DK-XL', '2021-04-15 11:52:51.001785', '2021-04-15 11:52:51.001785', NULL),
	(10001787, 100372, 10000006, 'PW21A-SH100372DK-XXL', '2021-04-15 11:52:51.001786', '2021-04-15 11:52:51.001786', NULL),
	(10001788, 100373, 10000001, 'PW21A-SH100373GY-XS', '2021-04-15 11:52:51.001787', '2021-04-15 11:52:51.001787', NULL),
	(10001789, 100373, 10000002, 'PW21A-SH100373GY-S', '2021-04-15 11:52:51.001788', '2021-04-15 11:52:51.001788', NULL),
	(10001790, 100373, 10000003, 'PW21A-SH100373GY-M', '2021-04-15 11:52:51.001789', '2021-04-15 11:52:51.001789', NULL),
	(10001791, 100373, 10000004, 'PW21A-SH100373GY-L', '2021-04-15 11:52:51.001790', '2021-04-15 11:52:51.001790', NULL),
	(10001792, 100373, 10000005, 'PW21A-SH100373GY-XL', '2021-04-15 11:52:51.001791', '2021-04-15 11:52:51.001791', NULL),
	(10001793, 100373, 10000006, 'PW21A-SH100373GY-XXL', '2021-04-15 11:52:51.001792', '2021-04-15 11:52:51.001792', NULL),
	(10001794, 100374, 10000001, 'PW21A-SH100374GY-XS', '2021-04-15 11:52:51.001793', '2021-04-15 11:52:51.001793', NULL),
	(10001795, 100374, 10000002, 'PW21A-SH100374GY-S', '2021-04-15 11:52:51.001794', '2021-04-15 11:52:51.001794', NULL),
	(10001796, 100374, 10000003, 'PW21A-SH100374GY-M', '2021-04-15 11:52:51.001795', '2021-04-15 11:52:51.001795', NULL),
	(10001797, 100374, 10000004, 'PW21A-SH100374GY-L', '2021-04-15 11:52:51.001796', '2021-04-15 11:52:51.001796', NULL),
	(10001798, 100374, 10000005, 'PW21A-SH100374GY-XL', '2021-04-15 11:52:51.001797', '2021-04-15 11:52:51.001797', NULL),
	(10001799, 100374, 10000006, 'PW21A-SH100374GY-XXL', '2021-04-15 11:52:51.001798', '2021-04-15 11:52:51.001798', NULL),
	(10001800, 100375, 10000001, 'PW21A-SH100375BL-XS', '2021-04-15 11:52:51.001799', '2021-04-15 11:52:51.001799', NULL),
	(10001801, 100375, 10000002, 'PW21A-SH100375BL-S', '2021-04-15 11:52:51.001800', '2021-04-15 11:52:51.001800', NULL),
	(10001802, 100375, 10000003, 'PW21A-SH100375BL-M', '2021-04-15 11:52:51.001801', '2021-04-15 11:52:51.001801', NULL),
	(10001803, 100375, 10000004, 'PW21A-SH100375BL-L', '2021-04-15 11:52:51.001802', '2021-04-15 11:52:51.001802', NULL),
	(10001804, 100375, 10000005, 'PW21A-SH100375BL-XL', '2021-04-15 11:52:51.001803', '2021-04-15 11:52:51.001803', NULL),
	(10001805, 100375, 10000006, 'PW21A-SH100375BL-XXL', '2021-04-15 11:52:51.001804', '2021-04-15 11:52:51.001804', NULL),
	(10001806, 100376, 10000001, 'PW21A-SH100376CM-XS', '2021-04-15 11:52:51.001805', '2021-04-15 11:52:51.001805', NULL),
	(10001807, 100376, 10000002, 'PW21A-SH100376CM-S', '2021-04-15 11:52:51.001806', '2021-04-15 11:52:51.001806', NULL),
	(10001808, 100376, 10000003, 'PW21A-SH100376CM-M', '2021-04-15 11:52:51.001807', '2021-04-15 11:52:51.001807', NULL),
	(10001809, 100376, 10000004, 'PW21A-SH100376CM-L', '2021-04-15 11:52:51.001808', '2021-04-15 11:52:51.001808', NULL),
	(10001810, 100376, 10000005, 'PW21A-SH100376CM-XL', '2021-04-15 11:52:51.001809', '2021-04-15 11:52:51.001809', NULL),
	(10001811, 100376, 10000006, 'PW21A-SH100376CM-XXL', '2021-04-15 11:52:51.001810', '2021-04-15 11:52:51.001810', NULL),
	(10001812, 100377, 10000001, 'PW21A-SW100377BL-XS', '2021-04-15 11:52:51.001811', '2021-04-15 11:52:51.001811', NULL),
	(10001813, 100377, 10000002, 'PW21A-SW100377BL-S', '2021-04-15 11:52:51.001812', '2021-04-15 11:52:51.001812', NULL),
	(10001814, 100377, 10000003, 'PW21A-SW100377BL-M', '2021-04-15 11:52:51.001813', '2021-04-15 11:52:51.001813', NULL),
	(10001815, 100377, 10000004, 'PW21A-SW100377BL-L', '2021-04-15 11:52:51.001814', '2021-04-15 11:52:51.001814', NULL),
	(10001816, 100377, 10000005, 'PW21A-SW100377BL-XL', '2021-04-15 11:52:51.001815', '2021-04-15 11:52:51.001815', NULL),
	(10001817, 100377, 10000006, 'PW21A-SW100377BL-XXL', '2021-04-15 11:52:51.001816', '2021-04-15 11:52:51.001816', NULL),
	(10001818, 100314, 10000001, 'PW21A-SW100314DK-XS', '2021-04-15 11:52:51.001817', '2021-04-15 11:52:51.001817', NULL),
	(10001819, 100314, 10000002, 'PW21A-SW100314DK-S', '2021-04-15 11:52:51.001818', '2021-04-15 11:52:51.001818', NULL),
	(10001820, 100314, 10000003, 'PW21A-SW100314DK-M', '2021-04-15 11:52:51.001819', '2021-04-15 11:52:51.001819', NULL),
	(10001821, 100314, 10000004, 'PW21A-SW100314DK-L', '2021-04-15 11:52:51.001820', '2021-04-15 11:52:51.001820', NULL),
	(10001822, 100314, 10000005, 'PW21A-SW100314DK-XL', '2021-04-15 11:52:51.001821', '2021-04-15 11:52:51.001821', NULL),
	(10001823, 100314, 10000006, 'PW21A-SW100314DK-XXL', '2021-04-15 11:52:51.001822', '2021-04-15 11:52:51.001822', NULL),
	(10001824, 100379, 10000001, 'PW21A-SW100379GY-XS', '2021-04-15 11:52:51.001823', '2021-04-15 11:52:51.001823', NULL),
	(10001825, 100379, 10000002, 'PW21A-SW100379GY-S', '2021-04-15 11:52:51.001824', '2021-04-15 11:52:51.001824', NULL),
	(10001826, 100379, 10000003, 'PW21A-SW100379GY-M', '2021-04-15 11:52:51.001825', '2021-04-15 11:52:51.001825', NULL),
	(10001827, 100379, 10000004, 'PW21A-SW100379GY-L', '2021-04-15 11:52:51.001826', '2021-04-15 11:52:51.001826', NULL),
	(10001828, 100379, 10000005, 'PW21A-SW100379GY-XL', '2021-04-15 11:52:51.001827', '2021-04-15 11:52:51.001827', NULL),
	(10001829, 100379, 10000006, 'PW21A-SW100379GY-XXL', '2021-04-15 11:52:51.001828', '2021-04-15 11:52:51.001828', NULL),
	(10001830, 100380, 10000001, 'PW21A-SW100380NV-XS', '2021-04-15 11:52:51.001829', '2021-04-15 11:52:51.001829', NULL),
	(10001831, 100380, 10000002, 'PW21A-SW100380NV-S', '2021-04-15 11:52:51.001830', '2021-04-15 11:52:51.001830', NULL),
	(10001832, 100380, 10000003, 'PW21A-SW100380NV-M', '2021-04-15 11:52:51.001831', '2021-04-15 11:52:51.001831', NULL),
	(10001833, 100380, 10000004, 'PW21A-SW100380NV-L', '2021-04-15 11:52:51.001832', '2021-04-15 11:52:51.001832', NULL),
	(10001834, 100380, 10000005, 'PW21A-SW100380NV-XL', '2021-04-15 11:52:51.001833', '2021-04-15 11:52:51.001833', NULL),
	(10001835, 100380, 10000006, 'PW21A-SW100380NV-XXL', '2021-04-15 11:52:51.001834', '2021-04-15 11:52:51.001834', NULL),
	(10001836, 100381, 10000001, 'PW21A-SW100381BL-XS', '2021-04-15 11:52:51.001835', '2021-04-15 11:52:51.001835', NULL),
	(10001837, 100381, 10000002, 'PW21A-SW100381BL-S', '2021-04-15 11:52:51.001836', '2021-04-15 11:52:51.001836', NULL),
	(10001838, 100381, 10000003, 'PW21A-SW100381BL-M', '2021-04-15 11:52:51.001837', '2021-04-15 11:52:51.001837', NULL),
	(10001839, 100381, 10000004, 'PW21A-SW100381BL-L', '2021-04-15 11:52:51.001838', '2021-04-15 11:52:51.001838', NULL),
	(10001840, 100381, 10000005, 'PW21A-SW100381BL-XL', '2021-04-15 11:52:51.001839', '2021-04-15 11:52:51.001839', NULL),
	(10001841, 100381, 10000006, 'PW21A-SW100381BL-XXL', '2021-04-15 11:52:51.001840', '2021-04-15 11:52:51.001840', NULL),
	(10001842, 100382, 10000012, 'SX21A-AC100382BW-All', '2021-04-15 11:52:51.001840', '2021-04-15 11:52:51.001840', NULL),
	(10001843, 100383, 10000012, 'SX21A-AC100383DK-All', '2021-04-15 11:52:51.001841', '2021-04-15 11:52:51.001841', NULL),
	(10001844, 100384, 10000012, 'SX21A-AC100384BL-All', '2021-04-15 11:52:51.001842', '2021-04-15 11:52:51.001842', NULL),
	(10001845, 100385, 10000012, 'SX21A-AC100385BW-All', '2021-04-15 11:52:51.001843', '2021-04-15 11:52:51.001843', NULL),
	(10001846, 100386, 10000012, 'SX21A-AC100386BL-All', '2021-04-15 11:52:51.001844', '2021-04-15 11:52:51.001844', NULL),
	(10001847, 100386, 10000012, 'SX21A-AC100386BL-All', '2021-04-15 11:52:51.001845', '2021-04-15 11:52:51.001845', NULL),
	(10001848, 100388, 10000012, 'SX21A-AC100388BW-All', '2021-04-15 11:52:51.001846', '2021-04-15 11:52:51.001846', NULL),
	(10001849, 100389, 10000012, 'SX21A-AC100389DK-All', '2021-04-15 11:52:51.001847', '2021-04-15 11:52:51.001847', NULL),
	(10001850, 100390, 10000012, 'SX21A-AC100390BW-All', '2021-04-15 11:52:51.001848', '2021-04-15 11:52:51.001848', NULL),
	(10001851, 100391, 10000012, 'SX21A-AC100391AR-All', '2021-04-15 11:52:51.001849', '2021-04-15 11:52:51.001849', NULL),
	(10001852, 100392, 10000012, 'SX21A-AC100392BL-All', '2021-04-15 11:52:51.001850', '2021-04-15 11:52:51.001850', NULL),
	(10001853, 100393, 10000012, 'SX21A-AC100393NV-All', '2021-04-15 11:52:51.001851', '2021-04-15 11:52:51.001851', NULL),
	(10001854, 100394, 10000012, 'SX21A-AC100394BL-All', '2021-04-15 11:52:51.001852', '2021-04-15 11:52:51.001852', NULL),
	(10001855, 100395, 10000012, 'SX21A-AC100395BL-All', '2021-04-15 11:52:51.001853', '2021-04-15 11:52:51.001853', NULL),
	(10001856, 100396, 10000012, 'SX21A-AC100396BL-All', '2021-04-15 11:52:51.001854', '2021-04-15 11:52:51.001854', NULL),
	(10001857, 100382, 10000012, 'SX21A-AC100382BW-All', '2021-04-15 11:52:51.001855', '2021-04-15 11:52:51.001855', NULL),
	(10001858, 100398, 10000012, 'SX21A-AC100398GN-All', '2021-04-15 11:52:51.001856', '2021-04-15 11:52:51.001856', NULL),
	(10001859, 100399, 10000012, 'SX21A-AC100399GY-All', '2021-04-15 11:52:51.001857', '2021-04-15 11:52:51.001857', NULL),
	(10001860, 100400, 10000012, 'SX21A-AC100400RD-All', '2021-04-15 11:52:51.001858', '2021-04-15 11:52:51.001858', NULL),
	(10001861, 100401, 10000012, 'SX21A-AC100401YW -All', '2021-04-15 11:52:51.001859', '2021-04-15 11:52:51.001859', NULL),
	(10001862, 100402, 10000012, 'SX21A-AC100402NV-All', '2021-04-15 11:52:51.001860', '2021-04-15 11:52:51.001860', NULL),
	(10001863, 100403, 10000012, 'SX21A-AC100403BL-All', '2021-04-15 11:52:51.001861', '2021-04-15 11:52:51.001861', NULL),
	(10001864, 100404, 10000012, 'SX21A-AC100404BL-All', '2021-04-15 11:52:51.001862', '2021-04-15 11:52:51.001862', NULL),
	(10001865, 100405, 10000012, 'SX21A-AC100405GN-All', '2021-04-15 11:52:51.001863', '2021-04-15 11:52:51.001863', NULL),
	(10001866, 100406, 10000012, 'SX21A-AC100406NV-All', '2021-04-15 11:52:51.001864', '2021-04-15 11:52:51.001864', NULL),
	(10001867, 100407, 10000012, 'SX21A-AC100407CH-All', '2021-04-15 11:52:51.001865', '2021-04-15 11:52:51.001865', NULL),
	(10001868, 100408, 10000012, 'SX21A-AC100408GY-All', '2021-04-15 11:52:51.001866', '2021-04-15 11:52:51.001866', NULL),
	(10001869, 100409, 10000012, 'SX21A-AC100409RD-All', '2021-04-15 11:52:51.001867', '2021-04-15 11:52:51.001867', NULL),
	(10001870, 100410, 10000012, 'SX21A-AC100410AR-All', '2021-04-15 11:52:51.001868', '2021-04-15 11:52:51.001868', NULL),
	(10001871, 100411, 10000012, 'SX21A-AC100411BL-All', '2021-04-15 11:52:51.001869', '2021-04-15 11:52:51.001869', NULL),
	(10001872, 100412, 10000012, 'SX21A-AC100412GY-All', '2021-04-15 11:52:51.001870', '2021-04-15 11:52:51.001870', NULL),
	(10001873, 100413, 10000012, 'SX21A-AC100413NV-All', '2021-04-15 11:52:51.001871', '2021-04-15 11:52:51.001871', NULL),
	(10001874, 100414, 10000012, 'SX21A-BG100414AR-All', '2021-04-15 11:52:51.001872', '2021-04-15 11:52:51.001872', NULL),
	(10001875, 100415, 10000012, 'SX21A-BG100415BL-All', '2021-04-15 11:52:51.001873', '2021-04-15 11:52:51.001873', NULL),
	(10001876, 100416, 10000012, 'SX21A-BG100416BL-All', '2021-04-15 11:52:51.001874', '2021-04-15 11:52:51.001874', NULL),
	(10001877, 100417, 10000012, 'SX21A-BG100417BL-All', '2021-04-15 11:52:51.001875', '2021-04-15 11:52:51.001875', NULL),
	(10001878, 100418, 10000012, 'SX21A-BG100418BL-All', '2021-04-15 11:52:51.001876', '2021-04-15 11:52:51.001876', NULL),
	(10001879, 100419, 10000012, 'SX21A-BG100419BW-All', '2021-04-15 11:52:51.001877', '2021-04-15 11:52:51.001877', NULL),
	(10001880, 100420, 10000012, 'SX21A-BG100420BL-All', '2021-04-15 11:52:51.001878', '2021-04-15 11:52:51.001878', NULL),
	(10001881, 100421, 10000012, 'SX21A-BG100421BL-All', '2021-04-15 11:52:51.001879', '2021-04-15 11:52:51.001879', NULL),
	(10001882, 100422, 10000012, 'SX21A-BG100422BW-All', '2021-04-15 11:52:51.001880', '2021-04-15 11:52:51.001880', NULL),
	(10001883, 100423, 10000012, 'SX21A-BG100423NV-All', '2021-04-15 11:52:51.001881', '2021-04-15 11:52:51.001881', NULL),
	(10001884, 100424, 10000012, 'SX21A-BG100424BL-All', '2021-04-15 11:52:51.001882', '2021-04-15 11:52:51.001882', NULL),
	(10001885, 100425, 10000012, 'SX21A-BG100425DK-All', '2021-04-15 11:52:51.001883', '2021-04-15 11:52:51.001883', NULL),
	(10001886, 100426, 10000012, 'SX21A-BG100426NV-All', '2021-04-15 11:52:51.001884', '2021-04-15 11:52:51.001884', NULL),
	(10001887, 100427, 10000012, 'SX21A-BG100427WT-All', '2021-04-15 11:52:51.001885', '2021-04-15 11:52:51.001885', NULL),
	(10001888, 100428, 10000012, 'SX21A-BG100428BL-All', '2021-04-15 11:52:51.001886', '2021-04-15 11:52:51.001886', NULL),
	(10001889, 100429, 10000012, 'SX21A-BG100429BL-All', '2021-04-15 11:52:51.001887', '2021-04-15 11:52:51.001887', NULL),
	(10001890, 100430, 10000012, 'SX21A-BG100430BL-All', '2021-04-15 11:52:51.001888', '2021-04-15 11:52:51.001888', NULL),
	(10001891, 100431, 10000012, 'SX21A-BG100431BL-All', '2021-04-15 11:52:51.001889', '2021-04-15 11:52:51.001889', NULL),
	(10001892, 100432, 10000012, 'SX21A-BG100432BL-All', '2021-04-15 11:52:51.001890', '2021-04-15 11:52:51.001890', NULL),
	(10001893, 100433, 10000012, 'SX21A-BG100433GN-All', '2021-04-15 11:52:51.001891', '2021-04-15 11:52:51.001891', NULL),
	(10001894, 100434, 10000012, 'SX21A-BG100434NV-All', '2021-04-15 11:52:51.001892', '2021-04-15 11:52:51.001892', NULL),
	(10001895, 100435, 10000012, 'SX21A-BG100435BL-All', '2021-04-15 11:52:51.001893', '2021-04-15 11:52:51.001893', NULL),
	(10001896, 100436, 10000012, 'SX21A-BG100436BL-All', '2021-04-15 11:52:51.001894', '2021-04-15 11:52:51.001894', NULL),
	(10001897, 100437, 10000012, 'SX21A-BG100437BL-All', '2021-04-15 11:52:51.001895', '2021-04-15 11:52:51.001895', NULL),
	(10001898, 100438, 10000012, 'SX21A-BG100438BL-All', '2021-04-15 11:52:51.001896', '2021-04-15 11:52:51.001896', NULL),
	(10001899, 100439, 10000012, 'SX21A-BG100439BL-All', '2021-04-15 11:52:51.001897', '2021-04-15 11:52:51.001897', NULL),
	(10001900, 100440, 10000012, 'SX21A-BG100440BL-All', '2021-04-15 11:52:51.001898', '2021-04-15 11:52:51.001898', NULL),
	(10001901, 100441, 10000012, 'SX21A-BG100441BL-All', '2021-04-15 11:52:51.001899', '2021-04-15 11:52:51.001899', NULL),
	(10001902, 100442, 10000012, 'SX21A-BG100442GY-All', '2021-04-15 11:52:51.001900', '2021-04-15 11:52:51.001900', NULL),
	(10001903, 100443, 10000012, 'SX21A-BG100443GN-All', '2021-04-15 11:52:51.001901', '2021-04-15 11:52:51.001901', NULL),
	(10001904, 100444, 10000012, 'SX21A-BG100444BL-All', '2021-04-15 11:52:51.001902', '2021-04-15 11:52:51.001902', NULL),
	(10001905, 100445, 10000012, 'SX21A-BG100445BW-All', '2021-04-15 11:52:51.001903', '2021-04-15 11:52:51.001903', NULL),
	(10001906, 100446, 10000012, 'SX21A-BG100446DK-All', '2021-04-15 11:52:51.001904', '2021-04-15 11:52:51.001904', NULL),
	(10001907, 100447, 10000012, 'SX21A-BG100447BW-All', '2021-04-15 11:52:51.001905', '2021-04-15 11:52:51.001905', NULL),
	(10001908, 100448, 10000012, 'SX21A-BG100448BL-All', '2021-04-15 11:52:51.001906', '2021-04-15 11:52:51.001906', NULL),
	(10001909, 100449, 10000012, 'SX21A-BG100449BL-All', '2021-04-15 11:52:51.001907', '2021-04-15 11:52:51.001907', NULL),
	(10001910, 100450, 10000012, 'SX21A-BG100450BL-All', '2021-04-15 11:52:51.001908', '2021-04-15 11:52:51.001908', NULL),
	(10001911, 100451, 10000012, 'SX21A-BG100451BL-All', '2021-04-15 11:52:51.001909', '2021-04-15 11:52:51.001909', NULL),
	(10001912, 100452, 10000012, 'SX21A-BG100452BL-All', '2021-04-15 11:52:51.001910', '2021-04-15 11:52:51.001910', NULL),
	(10001913, 100453, 10000012, 'SX21A-BG100453NV-All', '2021-04-15 11:52:51.001911', '2021-04-15 11:52:51.001911', NULL),
	(10001914, 100454, 10000012, 'SX21A-BG100454AR-All', '2021-04-15 11:52:51.001912', '2021-04-15 11:52:51.001912', NULL),
	(10001915, 100455, 10000012, 'SX21A-BG100455BL-All', '2021-04-15 11:52:51.001913', '2021-04-15 11:52:51.001913', NULL),
	(10001916, 100456, 10000012, 'SX21A-BG100456BL-All', '2021-04-15 11:52:51.001914', '2021-04-15 11:52:51.001914', NULL),
	(10001917, 100457, 10000012, 'SX21A-BG100457BL-All', '2021-04-15 11:52:51.001915', '2021-04-15 11:52:51.001915', NULL),
	(10001918, 100458, 10000012, 'SX21A-BG100458GN-All', '2021-04-15 11:52:51.001916', '2021-04-15 11:52:51.001916', NULL),
	(10001919, 100459, 10000012, 'SX21A-BG100459NV-All', '2021-04-15 11:52:51.001917', '2021-04-15 11:52:51.001917', NULL),
	(10001920, 100460, 10000012, 'SX21A-BG100460TN-All', '2021-04-15 11:52:51.001918', '2021-04-15 11:52:51.001918', NULL),
	(10001921, 100461, 10000012, 'SX21A-BG100461WT-All', '2021-04-15 11:52:51.001919', '2021-04-15 11:52:51.001919', NULL),
	(10001922, 100462, 10000012, 'SX21A-BG100462BW-All', '2021-04-15 11:52:51.001920', '2021-04-15 11:52:51.001920', NULL),
	(10001923, 100463, 10000012, 'SX21A-BG100463CM-All', '2021-04-15 11:52:51.001921', '2021-04-15 11:52:51.001921', NULL),
	(10001924, 100464, 10000012, 'SX21A-BG100464DB-All', '2021-04-15 11:52:51.001922', '2021-04-15 11:52:51.001922', NULL),
	(10001925, 100465, 10000012, 'SX21A-BG100465DG-All', '2021-04-15 11:52:51.001923', '2021-04-15 11:52:51.001923', NULL),
	(10001926, 100466, 10000012, 'SX21A-BG100466BL-All', '2021-04-15 11:52:51.001924', '2021-04-15 11:52:51.001924', NULL),
	(10001927, 100467, 10000012, 'SX21A-BG100467BL-All', '2021-04-15 11:52:51.001925', '2021-04-15 11:52:51.001925', NULL),
	(10001928, 100468, 10000012, 'SX21A-BG100468BL-All', '2021-04-15 11:52:51.001926', '2021-04-15 11:52:51.001926', NULL),
	(10001929, 100469, 10000012, 'SX21A-BG100469BL-All', '2021-04-15 11:52:51.001927', '2021-04-15 11:52:51.001927', NULL),
	(10001930, 100470, 10000012, 'SX21A-BG100470GY-All', '2021-04-15 11:52:51.001928', '2021-04-15 11:52:51.001928', NULL),
	(10001931, 100471, 10000012, 'SX21A-BG100471BL-All', '2021-04-15 11:52:51.001929', '2021-04-15 11:52:51.001929', NULL),
	(10001932, 100472, 10000012, 'SX21A-BG100472AR-All', '2021-04-15 11:52:51.001930', '2021-04-15 11:52:51.001930', NULL),
	(10001933, 100473, 10000012, 'SX21A-BG100473GN-All', '2021-04-15 11:52:51.001931', '2021-04-15 11:52:51.001931', NULL),
	(10001934, 100474, 10000012, 'SX21A-BG100474GY-All', '2021-04-15 11:52:51.001932', '2021-04-15 11:52:51.001932', NULL),
	(10001935, 100475, 10000012, 'SX21A-BG100475NV-All', '2021-04-15 11:52:51.001933', '2021-04-15 11:52:51.001933', NULL),
	(10001936, 100476, 10000012, 'SX21A-BG100476BL-All', '2021-04-15 11:52:51.001934', '2021-04-15 11:52:51.001934', NULL),
	(10001937, 100477, 10000012, 'SX21A-HT100477BL-All', '2021-04-15 11:52:51.001935', '2021-04-15 11:52:51.001935', NULL),
	(10001938, 100478, 10000012, 'SX21A-HT100478BL-All', '2021-04-15 11:52:51.001936', '2021-04-15 11:52:51.001936', NULL),
	(10001939, 100479, 10000012, 'SX21A-HT100479BL-All', '2021-04-15 11:52:51.001937', '2021-04-15 11:52:51.001937', NULL),
	(10001940, 100480, 10000012, 'SX21A-HT100480BL-All', '2021-04-15 11:52:51.001938', '2021-04-15 11:52:51.001938', NULL),
	(10001941, 100481, 10000012, 'SX21A-HT100481BL-All', '2021-04-15 11:52:51.001939', '2021-04-15 11:52:51.001939', NULL),
	(10001942, 100482, 10000012, 'SX21A-HT100482BL-All', '2021-04-15 11:52:51.001940', '2021-04-15 11:52:51.001940', NULL),
	(10001943, 100483, 10000012, 'SX21A-HT100483NV-All', '2021-04-15 11:52:51.001941', '2021-04-15 11:52:51.001941', NULL),
	(10001944, 100484, 10000012, 'SX21A-HT100484AR-All', '2021-04-15 11:52:51.001942', '2021-04-15 11:52:51.001942', NULL),
	(10001945, 100485, 10000012, 'SX21A-HT100485CH-All', '2021-04-15 11:52:51.001943', '2021-04-15 11:52:51.001943', NULL),
	(10001946, 100486, 10000012, 'SX21A-HT100486NV-All', '2021-04-15 11:52:51.001944', '2021-04-15 11:52:51.001944', NULL),
	(10001947, 100487, 10000012, 'SX21A-HT100487AR-All', '2021-04-15 11:52:51.001945', '2021-04-15 11:52:51.001945', NULL),
	(10001948, 100488, 10000012, 'SX21A-HT100488CR-All', '2021-04-15 11:52:51.001946', '2021-04-15 11:52:51.001946', NULL),
	(10001949, 100489, 10000012, 'SX21A-HT100489MR-All', '2021-04-15 11:52:51.001947', '2021-04-15 11:52:51.001947', NULL),
	(10001950, 100490, 10000012, 'SX21A-HT100490BL-All', '2021-04-15 11:52:51.001948', '2021-04-15 11:52:51.001948', NULL),
	(10001951, 100491, 10000012, 'SX21A-HT100491BL-All', '2021-04-15 11:52:51.001949', '2021-04-15 11:52:51.001949', NULL),
	(10001952, 100492, 10000012, 'SX21A-HT100492GN-All', '2021-04-15 11:52:51.001950', '2021-04-15 11:52:51.001950', NULL),
	(10001953, 100493, 10000012, 'SX21A-HT100493GY-All', '2021-04-15 11:52:51.001951', '2021-04-15 11:52:51.001951', NULL),
	(10001954, 100494, 10000012, 'SX21A-HT100494MR-All', '2021-04-15 11:52:51.001952', '2021-04-15 11:52:51.001952', NULL),
	(10001955, 100495, 10000012, 'SX21A-HT100495NV-All', '2021-04-15 11:52:51.001953', '2021-04-15 11:52:51.001953', NULL),
	(10001956, 100496, 10000012, 'SX21A-HT100496BW-All', '2021-04-15 11:52:51.001954', '2021-04-15 11:52:51.001954', NULL),
	(10001957, 100497, 10000012, 'SX21A-HT100497BL-All', '2021-04-15 11:52:51.001955', '2021-04-15 11:52:51.001955', NULL),
	(10001958, 100498, 10000012, 'SX21A-HT100498GN-All', '2021-04-15 11:52:51.001956', '2021-04-15 11:52:51.001956', NULL),
	(10001959, 100499, 10000012, 'SX21A-HT100499NV-All', '2021-04-15 11:52:51.001957', '2021-04-15 11:52:51.001957', NULL),
	(10001960, 100500, 10000012, 'SX21A-HT100500MR-All', '2021-04-15 11:52:51.001958', '2021-04-15 11:52:51.001958', NULL),
	(10001961, 100501, 10000012, 'SX21A-HT100501BL-All', '2021-04-15 11:52:51.001959', '2021-04-15 11:52:51.001959', NULL),
	(10001962, 100502, 10000012, 'SX21A-HT100502BL-All', '2021-04-15 11:52:51.001960', '2021-04-15 11:52:51.001960', NULL),
	(10001963, 100503, 10000012, 'SX21A-WL100503CH-All', '2021-04-15 11:52:51.001961', '2021-04-15 11:52:51.001961', NULL),
	(10001964, 100504, 10000001, 'SX21A-SW100504BL-XS', '2021-04-15 11:52:51.001962', '2021-04-15 11:52:51.001962', NULL),
	(10001965, 100504, 10000002, 'SX21A-SW100504BL-S', '2021-04-15 11:52:51.001963', '2021-04-15 11:52:51.001963', NULL),
	(10001966, 100504, 10000003, 'SX21A-SW100504BL-M', '2021-04-15 11:52:51.001964', '2021-04-15 11:52:51.001964', NULL),
	(10001967, 100504, 10000004, 'SX21A-SW100504BL-L', '2021-04-15 11:52:51.001965', '2021-04-15 11:52:51.001965', NULL),
	(10001968, 100504, 10000005, 'SX21A-SW100504BL-XL', '2021-04-15 11:52:51.001966', '2021-04-15 11:52:51.001966', NULL),
	(10001969, 100504, 10000006, 'SX21A-SW100504BL-XXL', '2021-04-15 11:52:51.001967', '2021-04-15 11:52:51.001967', NULL),
	(10001970, 100505, 10000001, 'SX21A-JK100505BL-XS', '2021-04-15 11:52:51.001968', '2021-04-15 11:52:51.001968', NULL),
	(10001971, 100505, 10000002, 'SX21A-JK100505BL-S', '2021-04-15 11:52:51.001969', '2021-04-15 11:52:51.001969', NULL),
	(10001972, 100505, 10000003, 'SX21A-JK100505BL-M', '2021-04-15 11:52:51.001970', '2021-04-15 11:52:51.001970', NULL),
	(10001973, 100505, 10000004, 'SX21A-JK100505BL-L', '2021-04-15 11:52:51.001971', '2021-04-15 11:52:51.001971', NULL),
	(10001974, 100505, 10000005, 'SX21A-JK100505BL-XL', '2021-04-15 11:52:51.001972', '2021-04-15 11:52:51.001972', NULL),
	(10001975, 100505, 10000006, 'SX21A-JK100505BL-XXL', '2021-04-15 11:52:51.001973', '2021-04-15 11:52:51.001973', NULL),
	(10001976, 100506, 10000001, 'SX21A-JK100506BL-XS', '2021-04-15 11:52:51.001974', '2021-04-15 11:52:51.001974', NULL),
	(10001977, 100506, 10000002, 'SX21A-JK100506BL-S', '2021-04-15 11:52:51.001975', '2021-04-15 11:52:51.001975', NULL),
	(10001978, 100506, 10000003, 'SX21A-JK100506BL-M', '2021-04-15 11:52:51.001976', '2021-04-15 11:52:51.001976', NULL),
	(10001979, 100506, 10000004, 'SX21A-JK100506BL-L', '2021-04-15 11:52:51.001977', '2021-04-15 11:52:51.001977', NULL),
	(10001980, 100506, 10000005, 'SX21A-JK100506BL-XL', '2021-04-15 11:52:51.001978', '2021-04-15 11:52:51.001978', NULL),
	(10001981, 100506, 10000006, 'SX21A-JK100506BL-XXL', '2021-04-15 11:52:51.001979', '2021-04-15 11:52:51.001979', NULL),
	(10001982, 100507, 10000001, 'SX21A-JK100507BL-XS', '2021-04-15 11:52:51.001980', '2021-04-15 11:52:51.001980', NULL),
	(10001983, 100507, 10000002, 'SX21A-JK100507BL-S', '2021-04-15 11:52:51.001981', '2021-04-15 11:52:51.001981', NULL),
	(10001984, 100507, 10000003, 'SX21A-JK100507BL-M', '2021-04-15 11:52:51.001982', '2021-04-15 11:52:51.001982', NULL),
	(10001985, 100507, 10000004, 'SX21A-JK100507BL-L', '2021-04-15 11:52:51.001983', '2021-04-15 11:52:51.001983', NULL),
	(10001986, 100507, 10000005, 'SX21A-JK100507BL-XL', '2021-04-15 11:52:51.001984', '2021-04-15 11:52:51.001984', NULL),
	(10001987, 100507, 10000006, 'SX21A-JK100507BL-XXL', '2021-04-15 11:52:51.001985', '2021-04-15 11:52:51.001985', NULL),
	(10001988, 100508, 10000001, 'SX21A-JK100508BL-XS', '2021-04-15 11:52:51.001986', '2021-04-15 11:52:51.001986', NULL),
	(10001989, 100508, 10000002, 'SX21A-JK100508BL-S', '2021-04-15 11:52:51.001987', '2021-04-15 11:52:51.001987', NULL),
	(10001990, 100508, 10000003, 'SX21A-JK100508BL-M', '2021-04-15 11:52:51.001988', '2021-04-15 11:52:51.001988', NULL),
	(10001991, 100508, 10000004, 'SX21A-JK100508BL-L', '2021-04-15 11:52:51.001989', '2021-04-15 11:52:51.001989', NULL),
	(10001992, 100508, 10000005, 'SX21A-JK100508BL-XL', '2021-04-15 11:52:51.001990', '2021-04-15 11:52:51.001990', NULL),
	(10001993, 100508, 10000006, 'SX21A-JK100508BL-XXL', '2021-04-15 11:52:51.001991', '2021-04-15 11:52:51.001991', NULL),
	(10001994, 100509, 10000001, 'SX21A-JK100509DK-XS', '2021-04-15 11:52:51.001992', '2021-04-15 11:52:51.001992', NULL),
	(10001995, 100509, 10000002, 'SX21A-JK100509DK-S', '2021-04-15 11:52:51.001993', '2021-04-15 11:52:51.001993', NULL),
	(10001996, 100509, 10000003, 'SX21A-JK100509DK-M', '2021-04-15 11:52:51.001994', '2021-04-15 11:52:51.001994', NULL),
	(10001997, 100509, 10000004, 'SX21A-JK100509DK-L', '2021-04-15 11:52:51.001995', '2021-04-15 11:52:51.001995', NULL),
	(10001998, 100509, 10000005, 'SX21A-JK100509DK-XL', '2021-04-15 11:52:51.001996', '2021-04-15 11:52:51.001996', NULL),
	(10001999, 100509, 10000006, 'SX21A-JK100509DK-XXL', '2021-04-15 11:52:51.001997', '2021-04-15 11:52:51.001997', NULL),
	(10002000, 100510, 10000001, 'SX21A-JK100510GY-XS', '2021-04-15 11:52:51.001998', '2021-04-15 11:52:51.001998', NULL),
	(10002001, 100510, 10000002, 'SX21A-JK100510GY-S', '2021-04-15 11:52:51.001999', '2021-04-15 11:52:51.001999', NULL),
	(10002002, 100510, 10000003, 'SX21A-JK100510GY-M', '2021-04-15 11:52:51.002000', '2021-04-15 11:52:51.002000', NULL),
	(10002003, 100510, 10000004, 'SX21A-JK100510GY-L', '2021-04-15 11:52:51.002001', '2021-04-15 11:52:51.002001', NULL),
	(10002004, 100510, 10000005, 'SX21A-JK100510GY-XL', '2021-04-15 11:52:51.002002', '2021-04-15 11:52:51.002002', NULL),
	(10002005, 100510, 10000006, 'SX21A-JK100510GY-XXL', '2021-04-15 11:52:51.002003', '2021-04-15 11:52:51.002003', NULL),
	(10002006, 100511, 10000001, 'SX21A-JK100511GY-XS', '2021-04-15 11:52:51.002004', '2021-04-15 11:52:51.002004', NULL),
	(10002007, 100511, 10000002, 'SX21A-JK100511GY-S', '2021-04-15 11:52:51.002005', '2021-04-15 11:52:51.002005', NULL),
	(10002008, 100511, 10000003, 'SX21A-JK100511GY-M', '2021-04-15 11:52:51.002006', '2021-04-15 11:52:51.002006', NULL),
	(10002009, 100511, 10000004, 'SX21A-JK100511GY-L', '2021-04-15 11:52:51.002007', '2021-04-15 11:52:51.002007', NULL),
	(10002010, 100511, 10000005, 'SX21A-JK100511GY-XL', '2021-04-15 11:52:51.002008', '2021-04-15 11:52:51.002008', NULL),
	(10002011, 100511, 10000006, 'SX21A-JK100511GY-XXL', '2021-04-15 11:52:51.002009', '2021-04-15 11:52:51.002009', NULL),
	(10002012, 100512, 10000001, 'SX21A-JK100512GY-XS', '2021-04-15 11:52:51.002010', '2021-04-15 11:52:51.002010', NULL),
	(10002013, 100512, 10000002, 'SX21A-JK100512GY-S', '2021-04-15 11:52:51.002011', '2021-04-15 11:52:51.002011', NULL),
	(10002014, 100512, 10000003, 'SX21A-JK100512GY-M', '2021-04-15 11:52:51.002012', '2021-04-15 11:52:51.002012', NULL),
	(10002015, 100512, 10000004, 'SX21A-JK100512GY-L', '2021-04-15 11:52:51.002013', '2021-04-15 11:52:51.002013', NULL),
	(10002016, 100512, 10000005, 'SX21A-JK100512GY-XL', '2021-04-15 11:52:51.002014', '2021-04-15 11:52:51.002014', NULL),
	(10002017, 100512, 10000006, 'SX21A-JK100512GY-XXL', '2021-04-15 11:52:51.002015', '2021-04-15 11:52:51.002015', NULL),
	(10002018, 100513, 10000001, 'SX21A-JK100513CM-XS', '2021-04-15 11:52:51.002016', '2021-04-15 11:52:51.002016', NULL),
	(10002019, 100513, 10000002, 'SX21A-JK100513CM-S', '2021-04-15 11:52:51.002017', '2021-04-15 11:52:51.002017', NULL),
	(10002020, 100513, 10000003, 'SX21A-JK100513CM-M', '2021-04-15 11:52:51.002018', '2021-04-15 11:52:51.002018', NULL),
	(10002021, 100513, 10000004, 'SX21A-JK100513CM-L', '2021-04-15 11:52:51.002019', '2021-04-15 11:52:51.002019', NULL),
	(10002022, 100513, 10000005, 'SX21A-JK100513CM-XL', '2021-04-15 11:52:51.002020', '2021-04-15 11:52:51.002020', NULL),
	(10002023, 100513, 10000006, 'SX21A-JK100513CM-XXL', '2021-04-15 11:52:51.002021', '2021-04-15 11:52:51.002021', NULL),
	(10002024, 100514, 10000001, 'SX21A-JK100514DK-XS', '2021-04-15 11:52:51.002022', '2021-04-15 11:52:51.002022', NULL),
	(10002025, 100514, 10000002, 'SX21A-JK100514DK-S', '2021-04-15 11:52:51.002023', '2021-04-15 11:52:51.002023', NULL),
	(10002026, 100514, 10000003, 'SX21A-JK100514DK-M', '2021-04-15 11:52:51.002024', '2021-04-15 11:52:51.002024', NULL),
	(10002027, 100514, 10000004, 'SX21A-JK100514DK-L', '2021-04-15 11:52:51.002025', '2021-04-15 11:52:51.002025', NULL),
	(10002028, 100514, 10000005, 'SX21A-JK100514DK-XL', '2021-04-15 11:52:51.002026', '2021-04-15 11:52:51.002026', NULL),
	(10002029, 100514, 10000006, 'SX21A-JK100514DK-XXL', '2021-04-15 11:52:51.002027', '2021-04-15 11:52:51.002027', NULL),
	(10002030, 100515, 10000001, 'SX21A-JK100515DK-XS', '2021-04-15 11:52:51.002028', '2021-04-15 11:52:51.002028', NULL),
	(10002031, 100515, 10000002, 'SX21A-JK100515DK-S', '2021-04-15 11:52:51.002029', '2021-04-15 11:52:51.002029', NULL),
	(10002032, 100515, 10000003, 'SX21A-JK100515DK-M', '2021-04-15 11:52:51.002030', '2021-04-15 11:52:51.002030', NULL),
	(10002033, 100515, 10000004, 'SX21A-JK100515DK-L', '2021-04-15 11:52:51.002031', '2021-04-15 11:52:51.002031', NULL),
	(10002034, 100515, 10000005, 'SX21A-JK100515DK-XL', '2021-04-15 11:52:51.002032', '2021-04-15 11:52:51.002032', NULL),
	(10002035, 100515, 10000006, 'SX21A-JK100515DK-XXL', '2021-04-15 11:52:51.002033', '2021-04-15 11:52:51.002033', NULL),
	(10002036, 100516, 10000001, 'SX21A-JK100516NV-XS', '2021-04-15 11:52:51.002034', '2021-04-15 11:52:51.002034', NULL),
	(10002037, 100516, 10000002, 'SX21A-JK100516NV-S', '2021-04-15 11:52:51.002035', '2021-04-15 11:52:51.002035', NULL),
	(10002038, 100516, 10000003, 'SX21A-JK100516NV-M', '2021-04-15 11:52:51.002036', '2021-04-15 11:52:51.002036', NULL),
	(10002039, 100516, 10000004, 'SX21A-JK100516NV-L', '2021-04-15 11:52:51.002037', '2021-04-15 11:52:51.002037', NULL),
	(10002040, 100516, 10000005, 'SX21A-JK100516NV-XL', '2021-04-15 11:52:51.002038', '2021-04-15 11:52:51.002038', NULL),
	(10002041, 100516, 10000006, 'SX21A-JK100516NV-XXL', '2021-04-15 11:52:51.002039', '2021-04-15 11:52:51.002039', NULL),
	(10002042, 100517, 10000001, 'SX21A-JK100517DK-XS', '2021-04-15 11:52:51.002040', '2021-04-15 11:52:51.002040', NULL),
	(10002043, 100517, 10000002, 'SX21A-JK100517DK-S', '2021-04-15 11:52:51.002041', '2021-04-15 11:52:51.002041', NULL),
	(10002044, 100517, 10000003, 'SX21A-JK100517DK-M', '2021-04-15 11:52:51.002042', '2021-04-15 11:52:51.002042', NULL),
	(10002045, 100517, 10000004, 'SX21A-JK100517DK-L', '2021-04-15 11:52:51.002043', '2021-04-15 11:52:51.002043', NULL),
	(10002046, 100517, 10000005, 'SX21A-JK100517DK-XL', '2021-04-15 11:52:51.002044', '2021-04-15 11:52:51.002044', NULL),
	(10002047, 100517, 10000006, 'SX21A-JK100517DK-XXL', '2021-04-15 11:52:51.002045', '2021-04-15 11:52:51.002045', NULL),
	(10002048, 100518, 10000001, 'SX21A-JK100518BL-XS', '2021-04-15 11:52:51.002046', '2021-04-15 11:52:51.002046', NULL),
	(10002049, 100518, 10000002, 'SX21A-JK100518BL-S', '2021-04-15 11:52:51.002047', '2021-04-15 11:52:51.002047', NULL),
	(10002050, 100518, 10000003, 'SX21A-JK100518BL-M', '2021-04-15 11:52:51.002048', '2021-04-15 11:52:51.002048', NULL),
	(10002051, 100518, 10000004, 'SX21A-JK100518BL-L', '2021-04-15 11:52:51.002049', '2021-04-15 11:52:51.002049', NULL),
	(10002052, 100518, 10000005, 'SX21A-JK100518BL-XL', '2021-04-15 11:52:51.002050', '2021-04-15 11:52:51.002050', NULL),
	(10002053, 100518, 10000006, 'SX21A-JK100518BL-XXL', '2021-04-15 11:52:51.002051', '2021-04-15 11:52:51.002051', NULL),
	(10002054, 100519, 10000001, 'SX21A-JK100519DK-XS', '2021-04-15 11:52:51.002052', '2021-04-15 11:52:51.002052', NULL),
	(10002055, 100519, 10000002, 'SX21A-JK100519DK-S', '2021-04-15 11:52:51.002053', '2021-04-15 11:52:51.002053', NULL),
	(10002056, 100519, 10000003, 'SX21A-JK100519DK-M', '2021-04-15 11:52:51.002054', '2021-04-15 11:52:51.002054', NULL),
	(10002057, 100519, 10000004, 'SX21A-JK100519DK-L', '2021-04-15 11:52:51.002055', '2021-04-15 11:52:51.002055', NULL),
	(10002058, 100519, 10000005, 'SX21A-JK100519DK-XL', '2021-04-15 11:52:51.002056', '2021-04-15 11:52:51.002056', NULL),
	(10002059, 100519, 10000006, 'SX21A-JK100519DK-XXL', '2021-04-15 11:52:51.002057', '2021-04-15 11:52:51.002057', NULL),
	(10002060, 100520, 10000001, 'SX21A-JK100520BL-XS', '2021-04-15 11:52:51.002058', '2021-04-15 11:52:51.002058', NULL),
	(10002061, 100520, 10000002, 'SX21A-JK100520BL-S', '2021-04-15 11:52:51.002059', '2021-04-15 11:52:51.002059', NULL),
	(10002062, 100520, 10000003, 'SX21A-JK100520BL-M', '2021-04-15 11:52:51.002060', '2021-04-15 11:52:51.002060', NULL),
	(10002063, 100520, 10000004, 'SX21A-JK100520BL-L', '2021-04-15 11:52:51.002061', '2021-04-15 11:52:51.002061', NULL),
	(10002064, 100520, 10000005, 'SX21A-JK100520BL-XL', '2021-04-15 11:52:51.002062', '2021-04-15 11:52:51.002062', NULL),
	(10002065, 100520, 10000006, 'SX21A-JK100520BL-XXL', '2021-04-15 11:52:51.002063', '2021-04-15 11:52:51.002063', NULL),
	(10002066, 100521, 10000001, 'SX21A-JK100521BL-XS', '2021-04-15 11:52:51.002064', '2021-04-15 11:52:51.002064', NULL),
	(10002067, 100521, 10000002, 'SX21A-JK100521BL-S', '2021-04-15 11:52:51.002065', '2021-04-15 11:52:51.002065', NULL),
	(10002068, 100521, 10000003, 'SX21A-JK100521BL-M', '2021-04-15 11:52:51.002066', '2021-04-15 11:52:51.002066', NULL),
	(10002069, 100521, 10000004, 'SX21A-JK100521BL-L', '2021-04-15 11:52:51.002067', '2021-04-15 11:52:51.002067', NULL),
	(10002070, 100521, 10000005, 'SX21A-JK100521BL-XL', '2021-04-15 11:52:51.002068', '2021-04-15 11:52:51.002068', NULL),
	(10002071, 100521, 10000006, 'SX21A-JK100521BL-XXL', '2021-04-15 11:52:51.002069', '2021-04-15 11:52:51.002069', NULL),
	(10002072, 100522, 10000001, 'SX21A-JK100522BL-XS', '2021-04-15 11:52:51.002070', '2021-04-15 11:52:51.002070', NULL),
	(10002073, 100522, 10000002, 'SX21A-JK100522BL-S', '2021-04-15 11:52:51.002071', '2021-04-15 11:52:51.002071', NULL),
	(10002074, 100522, 10000003, 'SX21A-JK100522BL-M', '2021-04-15 11:52:51.002072', '2021-04-15 11:52:51.002072', NULL),
	(10002075, 100522, 10000004, 'SX21A-JK100522BL-L', '2021-04-15 11:52:51.002073', '2021-04-15 11:52:51.002073', NULL),
	(10002076, 100522, 10000005, 'SX21A-JK100522BL-XL', '2021-04-15 11:52:51.002074', '2021-04-15 11:52:51.002074', NULL),
	(10002077, 100522, 10000006, 'SX21A-JK100522BL-XXL', '2021-04-15 11:52:51.002075', '2021-04-15 11:52:51.002075', NULL),
	(10002078, 100523, 10000001, 'SX21A-JK100523BL-XS', '2021-04-15 11:52:51.002076', '2021-04-15 11:52:51.002076', NULL),
	(10002079, 100523, 10000002, 'SX21A-JK100523BL-S', '2021-04-15 11:52:51.002077', '2021-04-15 11:52:51.002077', NULL),
	(10002080, 100523, 10000003, 'SX21A-JK100523BL-M', '2021-04-15 11:52:51.002078', '2021-04-15 11:52:51.002078', NULL),
	(10002081, 100523, 10000004, 'SX21A-JK100523BL-L', '2021-04-15 11:52:51.002079', '2021-04-15 11:52:51.002079', NULL),
	(10002082, 100523, 10000005, 'SX21A-JK100523BL-XL', '2021-04-15 11:52:51.002080', '2021-04-15 11:52:51.002080', NULL),
	(10002083, 100523, 10000006, 'SX21A-JK100523BL-XXL', '2021-04-15 11:52:51.002081', '2021-04-15 11:52:51.002081', NULL),
	(10002084, 100524, 10000001, 'SX21A-JK100524BL-XS', '2021-04-15 11:52:51.002082', '2021-04-15 11:52:51.002082', NULL),
	(10002085, 100524, 10000002, 'SX21A-JK100524BL-S', '2021-04-15 11:52:51.002083', '2021-04-15 11:52:51.002083', NULL),
	(10002086, 100524, 10000003, 'SX21A-JK100524BL-M', '2021-04-15 11:52:51.002084', '2021-04-15 11:52:51.002084', NULL),
	(10002087, 100524, 10000004, 'SX21A-JK100524BL-L', '2021-04-15 11:52:51.002085', '2021-04-15 11:52:51.002085', NULL),
	(10002088, 100524, 10000005, 'SX21A-JK100524BL-XL', '2021-04-15 11:52:51.002086', '2021-04-15 11:52:51.002086', NULL),
	(10002089, 100524, 10000006, 'SX21A-JK100524BL-XXL', '2021-04-15 11:52:51.002087', '2021-04-15 11:52:51.002087', NULL),
	(10002090, 100525, 10000001, 'SX21A-JK100525BL-XS', '2021-04-15 11:52:51.002088', '2021-04-15 11:52:51.002088', NULL),
	(10002091, 100525, 10000002, 'SX21A-JK100525BL-S', '2021-04-15 11:52:51.002089', '2021-04-15 11:52:51.002089', NULL),
	(10002092, 100525, 10000003, 'SX21A-JK100525BL-M', '2021-04-15 11:52:51.002090', '2021-04-15 11:52:51.002090', NULL),
	(10002093, 100525, 10000004, 'SX21A-JK100525BL-L', '2021-04-15 11:52:51.002091', '2021-04-15 11:52:51.002091', NULL),
	(10002094, 100525, 10000005, 'SX21A-JK100525BL-XL', '2021-04-15 11:52:51.002092', '2021-04-15 11:52:51.002092', NULL),
	(10002095, 100525, 10000006, 'SX21A-JK100525BL-XXL', '2021-04-15 11:52:51.002093', '2021-04-15 11:52:51.002093', NULL),
	(10002096, 100526, 10000001, 'SX21A-JK100526BL-XS', '2021-04-15 11:52:51.002094', '2021-04-15 11:52:51.002094', NULL),
	(10002097, 100526, 10000002, 'SX21A-JK100526BL-S', '2021-04-15 11:52:51.002095', '2021-04-15 11:52:51.002095', NULL),
	(10002098, 100526, 10000003, 'SX21A-JK100526BL-M', '2021-04-15 11:52:51.002096', '2021-04-15 11:52:51.002096', NULL),
	(10002099, 100526, 10000004, 'SX21A-JK100526BL-L', '2021-04-15 11:52:51.002097', '2021-04-15 11:52:51.002097', NULL),
	(10002100, 100526, 10000005, 'SX21A-JK100526BL-XL', '2021-04-15 11:52:51.002098', '2021-04-15 11:52:51.002098', NULL),
	(10002101, 100526, 10000006, 'SX21A-JK100526BL-XXL', '2021-04-15 11:52:51.002099', '2021-04-15 11:52:51.002099', NULL),
	(10002102, 100527, 10000001, 'SX21A-JK100527GY-XS', '2021-04-15 11:52:51.002100', '2021-04-15 11:52:51.002100', NULL),
	(10002103, 100527, 10000002, 'SX21A-JK100527GY-S', '2021-04-15 11:52:51.002101', '2021-04-15 11:52:51.002101', NULL),
	(10002104, 100527, 10000003, 'SX21A-JK100527GY-M', '2021-04-15 11:52:51.002102', '2021-04-15 11:52:51.002102', NULL),
	(10002105, 100527, 10000004, 'SX21A-JK100527GY-L', '2021-04-15 11:52:51.002103', '2021-04-15 11:52:51.002103', NULL),
	(10002106, 100527, 10000005, 'SX21A-JK100527GY-XL', '2021-04-15 11:52:51.002104', '2021-04-15 11:52:51.002104', NULL),
	(10002107, 100527, 10000006, 'SX21A-JK100527GY-XXL', '2021-04-15 11:52:51.002105', '2021-04-15 11:52:51.002105', NULL),
	(10002108, 100528, 10000001, 'SX21A-JK100528BL-XS', '2021-04-15 11:52:51.002106', '2021-04-15 11:52:51.002106', NULL),
	(10002109, 100528, 10000002, 'SX21A-JK100528BL-S', '2021-04-15 11:52:51.002107', '2021-04-15 11:52:51.002107', NULL),
	(10002110, 100528, 10000003, 'SX21A-JK100528BL-M', '2021-04-15 11:52:51.002108', '2021-04-15 11:52:51.002108', NULL),
	(10002111, 100528, 10000004, 'SX21A-JK100528BL-L', '2021-04-15 11:52:51.002109', '2021-04-15 11:52:51.002109', NULL),
	(10002112, 100528, 10000005, 'SX21A-JK100528BL-XL', '2021-04-15 11:52:51.002110', '2021-04-15 11:52:51.002110', NULL),
	(10002113, 100528, 10000006, 'SX21A-JK100528BL-XXL', '2021-04-15 11:52:51.002111', '2021-04-15 11:52:51.002111', NULL),
	(10002114, 100529, 10000001, 'SX21A-JK100529AR-XS', '2021-04-15 11:52:51.002112', '2021-04-15 11:52:51.002112', NULL),
	(10002115, 100529, 10000002, 'SX21A-JK100529AR-S', '2021-04-15 11:52:51.002113', '2021-04-15 11:52:51.002113', NULL),
	(10002116, 100529, 10000003, 'SX21A-JK100529AR-M', '2021-04-15 11:52:51.002114', '2021-04-15 11:52:51.002114', NULL),
	(10002117, 100529, 10000004, 'SX21A-JK100529AR-L', '2021-04-15 11:52:51.002115', '2021-04-15 11:52:51.002115', NULL),
	(10002118, 100529, 10000005, 'SX21A-JK100529AR-XL', '2021-04-15 11:52:51.002116', '2021-04-15 11:52:51.002116', NULL),
	(10002119, 100529, 10000006, 'SX21A-JK100529AR-XXL', '2021-04-15 11:52:51.002117', '2021-04-15 11:52:51.002117', NULL),
	(10002120, 100530, 10000001, 'SX21A-JK100530BL-XS', '2021-04-15 11:52:51.002118', '2021-04-15 11:52:51.002118', NULL),
	(10002121, 100530, 10000002, 'SX21A-JK100530BL-S', '2021-04-15 11:52:51.002119', '2021-04-15 11:52:51.002119', NULL),
	(10002122, 100530, 10000003, 'SX21A-JK100530BL-M', '2021-04-15 11:52:51.002120', '2021-04-15 11:52:51.002120', NULL),
	(10002123, 100530, 10000004, 'SX21A-JK100530BL-L', '2021-04-15 11:52:51.002121', '2021-04-15 11:52:51.002121', NULL),
	(10002124, 100530, 10000005, 'SX21A-JK100530BL-XL', '2021-04-15 11:52:51.002122', '2021-04-15 11:52:51.002122', NULL),
	(10002125, 100530, 10000006, 'SX21A-JK100530BL-XXL', '2021-04-15 11:52:51.002123', '2021-04-15 11:52:51.002123', NULL),
	(10002126, 100531, 10000001, 'SX21A-JK100531BL-XS', '2021-04-15 11:52:51.002124', '2021-04-15 11:52:51.002124', NULL),
	(10002127, 100531, 10000002, 'SX21A-JK100531BL-S', '2021-04-15 11:52:51.002125', '2021-04-15 11:52:51.002125', NULL),
	(10002128, 100531, 10000003, 'SX21A-JK100531BL-M', '2021-04-15 11:52:51.002126', '2021-04-15 11:52:51.002126', NULL),
	(10002129, 100531, 10000004, 'SX21A-JK100531BL-L', '2021-04-15 11:52:51.002127', '2021-04-15 11:52:51.002127', NULL),
	(10002130, 100531, 10000005, 'SX21A-JK100531BL-XL', '2021-04-15 11:52:51.002128', '2021-04-15 11:52:51.002128', NULL),
	(10002131, 100531, 10000006, 'SX21A-JK100531BL-XXL', '2021-04-15 11:52:51.002129', '2021-04-15 11:52:51.002129', NULL),
	(10002132, 100532, 10000001, 'SX21A-JK100532BL-XS', '2021-04-15 11:52:51.002130', '2021-04-15 11:52:51.002130', NULL),
	(10002133, 100532, 10000002, 'SX21A-JK100532BL-S', '2021-04-15 11:52:51.002131', '2021-04-15 11:52:51.002131', NULL),
	(10002134, 100532, 10000003, 'SX21A-JK100532BL-M', '2021-04-15 11:52:51.002132', '2021-04-15 11:52:51.002132', NULL),
	(10002135, 100532, 10000004, 'SX21A-JK100532BL-L', '2021-04-15 11:52:51.002133', '2021-04-15 11:52:51.002133', NULL),
	(10002136, 100532, 10000005, 'SX21A-JK100532BL-XL', '2021-04-15 11:52:51.002134', '2021-04-15 11:52:51.002134', NULL),
	(10002137, 100532, 10000006, 'SX21A-JK100532BL-XXL', '2021-04-15 11:52:51.002135', '2021-04-15 11:52:51.002135', NULL),
	(10002138, 100533, 10000001, 'SX21A-JK100533DK-XS', '2021-04-15 11:52:51.002136', '2021-04-15 11:52:51.002136', NULL),
	(10002139, 100533, 10000002, 'SX21A-JK100533DK-S', '2021-04-15 11:52:51.002137', '2021-04-15 11:52:51.002137', NULL),
	(10002140, 100533, 10000003, 'SX21A-JK100533DK-M', '2021-04-15 11:52:51.002138', '2021-04-15 11:52:51.002138', NULL),
	(10002141, 100533, 10000004, 'SX21A-JK100533DK-L', '2021-04-15 11:52:51.002139', '2021-04-15 11:52:51.002139', NULL),
	(10002142, 100533, 10000005, 'SX21A-JK100533DK-XL', '2021-04-15 11:52:51.002140', '2021-04-15 11:52:51.002140', NULL),
	(10002143, 100533, 10000006, 'SX21A-JK100533DK-XXL', '2021-04-15 11:52:51.002141', '2021-04-15 11:52:51.002141', NULL),
	(10002144, 100534, 10000001, 'SX21A-JK100534RD-XS', '2021-04-15 11:52:51.002142', '2021-04-15 11:52:51.002142', NULL),
	(10002145, 100534, 10000002, 'SX21A-JK100534RD-S', '2021-04-15 11:52:51.002143', '2021-04-15 11:52:51.002143', NULL),
	(10002146, 100534, 10000003, 'SX21A-JK100534RD-M', '2021-04-15 11:52:51.002144', '2021-04-15 11:52:51.002144', NULL),
	(10002147, 100534, 10000004, 'SX21A-JK100534RD-L', '2021-04-15 11:52:51.002145', '2021-04-15 11:52:51.002145', NULL),
	(10002148, 100534, 10000005, 'SX21A-JK100534RD-XL', '2021-04-15 11:52:51.002146', '2021-04-15 11:52:51.002146', NULL),
	(10002149, 100534, 10000006, 'SX21A-JK100534RD-XXL', '2021-04-15 11:52:51.002147', '2021-04-15 11:52:51.002147', NULL),
	(10002150, 100535, 10000001, 'SX21A-JK100535BL-XS', '2021-04-15 11:52:51.002148', '2021-04-15 11:52:51.002148', NULL),
	(10002151, 100535, 10000002, 'SX21A-JK100535BL-S', '2021-04-15 11:52:51.002149', '2021-04-15 11:52:51.002149', NULL),
	(10002152, 100535, 10000003, 'SX21A-JK100535BL-M', '2021-04-15 11:52:51.002150', '2021-04-15 11:52:51.002150', NULL),
	(10002153, 100535, 10000004, 'SX21A-JK100535BL-L', '2021-04-15 11:52:51.002151', '2021-04-15 11:52:51.002151', NULL),
	(10002154, 100535, 10000005, 'SX21A-JK100535BL-XL', '2021-04-15 11:52:51.002152', '2021-04-15 11:52:51.002152', NULL),
	(10002155, 100535, 10000006, 'SX21A-JK100535BL-XXL', '2021-04-15 11:52:51.002153', '2021-04-15 11:52:51.002153', NULL),
	(10002156, 100536, 10000001, 'SX21A-JK100536CH-XS', '2021-04-15 11:52:51.002154', '2021-04-15 11:52:51.002154', NULL),
	(10002157, 100536, 10000002, 'SX21A-JK100536CH-S', '2021-04-15 11:52:51.002155', '2021-04-15 11:52:51.002155', NULL),
	(10002158, 100536, 10000003, 'SX21A-JK100536CH-M', '2021-04-15 11:52:51.002156', '2021-04-15 11:52:51.002156', NULL),
	(10002159, 100536, 10000004, 'SX21A-JK100536CH-L', '2021-04-15 11:52:51.002157', '2021-04-15 11:52:51.002157', NULL),
	(10002160, 100536, 10000005, 'SX21A-JK100536CH-XL', '2021-04-15 11:52:51.002158', '2021-04-15 11:52:51.002158', NULL),
	(10002161, 100536, 10000006, 'SX21A-JK100536CH-XXL', '2021-04-15 11:52:51.002159', '2021-04-15 11:52:51.002159', NULL),
	(10002162, 100537, 10000001, 'SX21A-JK100537GY-XS', '2021-04-15 11:52:51.002160', '2021-04-15 11:52:51.002160', NULL),
	(10002163, 100537, 10000002, 'SX21A-JK100537GY-S', '2021-04-15 11:52:51.002161', '2021-04-15 11:52:51.002161', NULL),
	(10002164, 100537, 10000003, 'SX21A-JK100537GY-M', '2021-04-15 11:52:51.002162', '2021-04-15 11:52:51.002162', NULL),
	(10002165, 100537, 10000004, 'SX21A-JK100537GY-L', '2021-04-15 11:52:51.002163', '2021-04-15 11:52:51.002163', NULL),
	(10002166, 100537, 10000005, 'SX21A-JK100537GY-XL', '2021-04-15 11:52:51.002164', '2021-04-15 11:52:51.002164', NULL),
	(10002167, 100537, 10000006, 'SX21A-JK100537GY-XXL', '2021-04-15 11:52:51.002165', '2021-04-15 11:52:51.002165', NULL),
	(10002168, 100538, 10000001, 'SX21A-JK100538NV-XS', '2021-04-15 11:52:51.002166', '2021-04-15 11:52:51.002166', NULL),
	(10002169, 100538, 10000002, 'SX21A-JK100538NV-S', '2021-04-15 11:52:51.002167', '2021-04-15 11:52:51.002167', NULL),
	(10002170, 100538, 10000003, 'SX21A-JK100538NV-M', '2021-04-15 11:52:51.002168', '2021-04-15 11:52:51.002168', NULL),
	(10002171, 100538, 10000004, 'SX21A-JK100538NV-L', '2021-04-15 11:52:51.002169', '2021-04-15 11:52:51.002169', NULL),
	(10002172, 100538, 10000005, 'SX21A-JK100538NV-XL', '2021-04-15 11:52:51.002170', '2021-04-15 11:52:51.002170', NULL),
	(10002173, 100538, 10000006, 'SX21A-JK100538NV-XXL', '2021-04-15 11:52:51.002171', '2021-04-15 11:52:51.002171', NULL),
	(10002174, 100539, 10000012, 'EN21A-AC100539SV-All', '2021-04-15 11:52:51.002172', '2021-04-15 11:52:51.002172', NULL),
	(10002175, 100540, 10000012, 'EN21A-AC100540SV-All', '2021-04-15 11:52:51.002173', '2021-04-15 11:52:51.002173', NULL),
	(10002176, 100541, 10000012, 'FS21A-AC100541AP-All', '2021-04-15 11:52:51.002174', '2021-04-15 11:52:51.002174', NULL),
	(10002177, 100542, 10000012, 'FS21A-AC100542BR-All', '2021-04-15 11:52:51.002175', '2021-04-15 11:52:51.002175', NULL),
	(10002178, 100543, 10000012, 'FS21A-AC100543AP-All', '2021-04-15 11:52:51.002176', '2021-04-15 11:52:51.002176', NULL),
	(10002179, 100544, 10000012, 'FS21A-AC100544BR-All', '2021-04-15 11:52:51.002177', '2021-04-15 11:52:51.002177', NULL),
	(10002180, 100545, 10000012, 'FS21A-AC100545AP-All', '2021-04-15 11:52:51.002178', '2021-04-15 11:52:51.002178', NULL),
	(10002181, 100546, 10000012, 'FS21A-AC100546BR-All', '2021-04-15 11:52:51.002179', '2021-04-15 11:52:51.002179', NULL),
	(10002182, 100547, 10000012, 'FS21A-AC100547AP-All', '2021-04-15 11:52:51.002180', '2021-04-15 11:52:51.002180', NULL),
	(10002183, 100548, 10000012, 'FS21A-AC100548AP-All', '2021-04-15 11:52:51.002181', '2021-04-15 11:52:51.002181', NULL),
	(10002184, 100549, 10000012, 'FS21A-AC100549AP-All', '2021-04-15 11:52:51.002182', '2021-04-15 11:52:51.002182', NULL),
	(10002185, 100550, 10000012, 'FS21A-AC100550AP-All', '2021-04-15 11:52:51.002183', '2021-04-15 11:52:51.002183', NULL),
	(10002186, 100551, 10000012, 'FS21A-AC100551BR-All', '2021-04-15 11:52:51.002184', '2021-04-15 11:52:51.002184', NULL),
	(10002187, 100552, 10000012, 'FS21A-AC100552AP-All', '2021-04-15 11:52:51.002185', '2021-04-15 11:52:51.002185', NULL),
	(10002188, 100553, 10000012, 'FS21A-AC100553BR-All', '2021-04-15 11:52:51.002186', '2021-04-15 11:52:51.002186', NULL),
	(10002189, 100554, 10000012, 'FS21A-AC100554AP-All', '2021-04-15 11:52:51.002187', '2021-04-15 11:52:51.002187', NULL),
	(10002190, 100555, 10000012, 'FS21A-AC100555AP-All', '2021-04-15 11:52:51.002188', '2021-04-15 11:52:51.002188', NULL),
	(10002191, 100556, 10000012, 'FS21A-AC100556AP-All', '2021-04-15 11:52:51.002189', '2021-04-15 11:52:51.002189', NULL),
	(10002192, 100557, 10000012, 'FS21A-AC100557AP-All', '2021-04-15 11:52:51.002190', '2021-04-15 11:52:51.002190', NULL),
	(10002193, 100558, 10000012, 'FS21A-AC100558AP-All', '2021-04-15 11:52:51.002191', '2021-04-15 11:52:51.002191', NULL),
	(10002194, 100559, 10000012, 'FS21A-AC100559AP-All', '2021-04-15 11:52:51.002192', '2021-04-15 11:52:51.002192', NULL),
	(10002195, 100560, 10000012, 'FS21A-AC100560BR-All', '2021-04-15 11:52:51.002193', '2021-04-15 11:52:51.002193', NULL),
	(10002196, 100561, 10000012, 'FS21A-AC100561BR-All', '2021-04-15 11:52:51.002194', '2021-04-15 11:52:51.002194', NULL),
	(10002197, 100554, 10000012, 'FS21A-AC100554AP-All', '2021-04-15 11:52:51.002195', '2021-04-15 11:52:51.002195', NULL),
	(10002198, 100563, 10000012, 'FS21A-AC100563BR-All', '2021-04-15 11:52:51.002196', '2021-04-15 11:52:51.002196', NULL),
	(10002199, 100564, 10000012, 'FS21A-AC100564AP-All', '2021-04-15 11:52:51.002197', '2021-04-15 11:52:51.002197', NULL),
	(10002200, 100565, 10000012, 'FS21A-AC100565AP-All', '2021-04-15 11:52:51.002198', '2021-04-15 11:52:51.002198', NULL),
	(10002201, 100566, 10000012, 'FS21A-AC100566BR-All', '2021-04-15 11:52:51.002199', '2021-04-15 11:52:51.002199', NULL),
	(10002202, 100567, 10000012, 'FS21A-AC100567BR-All', '2021-04-15 11:52:51.002200', '2021-04-15 11:52:51.002200', NULL),
	(10002203, 100568, 10000012, 'FS21A-AC100568BR-All', '2021-04-15 11:52:51.002201', '2021-04-15 11:52:51.002201', NULL),
	(10002204, 100569, 10000012, 'FS21A-AC100569BR-All', '2021-04-15 11:52:51.002202', '2021-04-15 11:52:51.002202', NULL),
	(10002205, 100570, 10000012, 'FS21A-AC100570BR-All', '2021-04-15 11:52:51.002203', '2021-04-15 11:52:51.002203', NULL),
	(10002206, 100571, 10000012, 'FS21A-AC100571BR-All', '2021-04-15 11:52:51.002204', '2021-04-15 11:52:51.002204', NULL),
	(10002207, 100572, 10000012, 'FS21A-AC100572BR-All', '2021-04-15 11:52:51.002205', '2021-04-15 11:52:51.002205', NULL),
	(10002208, 100573, 10000012, 'FS21A-AC100573MX-All', '2021-04-15 11:52:51.002206', '2021-04-15 11:52:51.002206', NULL),
	(10002209, 100574, 10000012, 'FS21A-AC100574MX-All', '2021-04-15 11:52:51.002207', '2021-04-15 11:52:51.002207', NULL),
	(10002210, 100575, 10000012, 'FS21A-AC100575MX-All', '2021-04-15 11:52:51.002208', '2021-04-15 11:52:51.002208', NULL),
	(10002211, 100576, 10000012, 'FS21A-AC100576MX-All', '2021-04-15 11:52:51.002209', '2021-04-15 11:52:51.002209', NULL),
	(10002212, 100577, 10000012, 'FS21A-AC100577MX-All', '2021-04-15 11:52:51.002210', '2021-04-15 11:52:51.002210', NULL),
	(10002213, 100578, 10000012, 'FS21A-AC100578MX-All', '2021-04-15 11:52:51.002211', '2021-04-15 11:52:51.002211', NULL),
	(10002214, 100579, 10000012, 'FS21A-AC100579MX-All', '2021-04-15 11:52:51.002212', '2021-04-15 11:52:51.002212', NULL),
	(10002215, 100580, 10000012, 'FS21A-AC100580MX-All', '2021-04-15 11:52:51.002213', '2021-04-15 11:52:51.002213', NULL),
	(10002216, 100581, 10000012, 'FS21A-AC100581MX-All', '2021-04-15 11:52:51.002214', '2021-04-15 11:52:51.002214', NULL),
	(10002217, 100582, 10000012, 'GG21A-BG100582BL-All', '2021-04-15 11:52:51.002215', '2021-04-15 11:52:51.002215', NULL),
	(10002218, 100583, 10000012, 'GG21A-BG100583BL-All', '2021-04-15 11:52:51.002216', '2021-04-15 11:52:51.002216', NULL),
	(10002219, 100584, 10000012, 'GG21A-BG100584BL-All', '2021-04-15 11:52:51.002217', '2021-04-15 11:52:51.002217', NULL),
	(10002220, 100585, 10000012, 'GG21A-BG100585BL-All', '2021-04-15 11:52:51.002218', '2021-04-15 11:52:51.002218', NULL),
	(10002221, 100586, 10000012, 'GG21A-BG100586BL-All', '2021-04-15 11:52:51.002219', '2021-04-15 11:52:51.002219', NULL),
	(10002222, 100587, 10000012, 'GG21A-BG100587BL-All', '2021-04-15 11:52:51.002220', '2021-04-15 11:52:51.002220', NULL),
	(10002223, 100588, 10000012, 'GG21A-BG100588BL-All', '2021-04-15 11:52:51.002221', '2021-04-15 11:52:51.002221', NULL),
	(10002224, 100589, 10000012, 'GG21A-BG100589BL-All', '2021-04-15 11:52:51.002222', '2021-04-15 11:52:51.002222', NULL),
	(10002225, 100590, 10000012, 'GG21A-BG100590BL-All', '2021-04-15 11:52:51.002223', '2021-04-15 11:52:51.002223', NULL),
	(10002226, 100591, 10000012, 'GG21A-BG100591BL-All', '2021-04-15 11:52:51.002224', '2021-04-15 11:52:51.002224', NULL),
	(10002227, 100592, 10000012, 'GG21A-BG100592OG-All', '2021-04-15 11:52:51.002225', '2021-04-15 11:52:51.002225', NULL),
	(10002228, 100593, 10000012, 'GG21A-BG100593RD-All', '2021-04-15 11:52:51.002226', '2021-04-15 11:52:51.002226', NULL),
	(10002229, 100594, 10000012, 'GG21A-BG100594BL-All', '2021-04-15 11:52:51.002227', '2021-04-15 11:52:51.002227', NULL),
	(10002230, 100595, 10000012, 'GG21A-BG100595BL-All', '2021-04-15 11:52:51.002228', '2021-04-15 11:52:51.002228', NULL),
	(10002231, 100596, 10000001, 'NY21A-GL100596RD-XS', '2021-04-15 11:52:51.002229', '2021-04-15 11:52:51.002229', NULL),
	(10002232, 100596, 10000002, 'NY21A-GL100596RD-S', '2021-04-15 11:52:51.002230', '2021-04-15 11:52:51.002230', NULL),
	(10002233, 100596, 10000003, 'NY21A-GL100596RD-M', '2021-04-15 11:52:51.002231', '2021-04-15 11:52:51.002231', NULL),
	(10002234, 100596, 10000004, 'NY21A-GL100596RD-L', '2021-04-15 11:52:51.002232', '2021-04-15 11:52:51.002232', NULL),
	(10002235, 100596, 10000005, 'NY21A-GL100596RD-XL', '2021-04-15 11:52:51.002233', '2021-04-15 11:52:51.002233', NULL),
	(10002236, 100596, 10000006, 'NY21A-GL100596RD-XXL', '2021-04-15 11:52:51.002234', '2021-04-15 11:52:51.002234', NULL),
	(10002237, 100597, 10000001, 'NY21A-GL100597RD-XS', '2021-04-15 11:52:51.002235', '2021-04-15 11:52:51.002235', NULL),
	(10002238, 100597, 10000002, 'NY21A-GL100597RD-S', '2021-04-15 11:52:51.002236', '2021-04-15 11:52:51.002236', NULL),
	(10002239, 100597, 10000003, 'NY21A-GL100597RD-M', '2021-04-15 11:52:51.002237', '2021-04-15 11:52:51.002237', NULL),
	(10002240, 100597, 10000004, 'NY21A-GL100597RD-L', '2021-04-15 11:52:51.002238', '2021-04-15 11:52:51.002238', NULL),
	(10002241, 100597, 10000005, 'NY21A-GL100597RD-XL', '2021-04-15 11:52:51.002239', '2021-04-15 11:52:51.002239', NULL),
	(10002242, 100597, 10000006, 'NY21A-GL100597RD-XXL', '2021-04-15 11:52:51.002240', '2021-04-15 11:52:51.002240', NULL),
	(10002243, 100598, 10000001, 'NY21A-GL100598RD-XS', '2021-04-15 11:52:51.002241', '2021-04-15 11:52:51.002241', NULL),
	(10002244, 100598, 10000002, 'NY21A-GL100598RD-S', '2021-04-15 11:52:51.002242', '2021-04-15 11:52:51.002242', NULL),
	(10002245, 100598, 10000003, 'NY21A-GL100598RD-M', '2021-04-15 11:52:51.002243', '2021-04-15 11:52:51.002243', NULL),
	(10002246, 100598, 10000004, 'NY21A-GL100598RD-L', '2021-04-15 11:52:51.002244', '2021-04-15 11:52:51.002244', NULL),
	(10002247, 100598, 10000005, 'NY21A-GL100598RD-XL', '2021-04-15 11:52:51.002245', '2021-04-15 11:52:51.002245', NULL),
	(10002248, 100598, 10000006, 'NY21A-GL100598RD-XXL', '2021-04-15 11:52:51.002246', '2021-04-15 11:52:51.002246', NULL),
	(10002249, 100599, 10000001, 'NY21A-GL100599YW -XS', '2021-04-15 11:52:51.002247', '2021-04-15 11:52:51.002247', NULL),
	(10002250, 100599, 10000002, 'NY21A-GL100599YW -S', '2021-04-15 11:52:51.002248', '2021-04-15 11:52:51.002248', NULL),
	(10002251, 100599, 10000003, 'NY21A-GL100599YW -M', '2021-04-15 11:52:51.002249', '2021-04-15 11:52:51.002249', NULL),
	(10002252, 100599, 10000004, 'NY21A-GL100599YW -L', '2021-04-15 11:52:51.002250', '2021-04-15 11:52:51.002250', NULL),
	(10002253, 100599, 10000005, 'NY21A-GL100599YW -XL', '2021-04-15 11:52:51.002251', '2021-04-15 11:52:51.002251', NULL),
	(10002254, 100599, 10000006, 'NY21A-GL100599YW -XXL', '2021-04-15 11:52:51.002252', '2021-04-15 11:52:51.002252', NULL),
	(10002255, 100600, 10000001, 'NY21A-GL100600RD-XS', '2021-04-15 11:52:51.002253', '2021-04-15 11:52:51.002253', NULL),
	(10002256, 100600, 10000002, 'NY21A-GL100600RD-S', '2021-04-15 11:52:51.002254', '2021-04-15 11:52:51.002254', NULL),
	(10002257, 100600, 10000003, 'NY21A-GL100600RD-M', '2021-04-15 11:52:51.002255', '2021-04-15 11:52:51.002255', NULL),
	(10002258, 100600, 10000004, 'NY21A-GL100600RD-L', '2021-04-15 11:52:51.002256', '2021-04-15 11:52:51.002256', NULL),
	(10002259, 100600, 10000005, 'NY21A-GL100600RD-XL', '2021-04-15 11:52:51.002257', '2021-04-15 11:52:51.002257', NULL),
	(10002260, 100600, 10000006, 'NY21A-GL100600RD-XXL', '2021-04-15 11:52:51.002258', '2021-04-15 11:52:51.002258', NULL),
	(10002261, 100601, 10000001, 'NY21A-GL100601MR-XS', '2021-04-15 11:52:51.002259', '2021-04-15 11:52:51.002259', NULL),
	(10002262, 100601, 10000002, 'NY21A-GL100601MR-S', '2021-04-15 11:52:51.002260', '2021-04-15 11:52:51.002260', NULL),
	(10002263, 100601, 10000003, 'NY21A-GL100601MR-M', '2021-04-15 11:52:51.002261', '2021-04-15 11:52:51.002261', NULL),
	(10002264, 100601, 10000004, 'NY21A-GL100601MR-L', '2021-04-15 11:52:51.002262', '2021-04-15 11:52:51.002262', NULL),
	(10002265, 100601, 10000005, 'NY21A-GL100601MR-XL', '2021-04-15 11:52:51.002263', '2021-04-15 11:52:51.002263', NULL),
	(10002266, 100601, 10000006, 'NY21A-GL100601MR-XXL', '2021-04-15 11:52:51.002264', '2021-04-15 11:52:51.002264', NULL),
	(10002267, 100602, 10000001, 'NY21A-GL100602RD-XS', '2021-04-15 11:52:51.002265', '2021-04-15 11:52:51.002265', NULL),
	(10002268, 100602, 10000002, 'NY21A-GL100602RD-S', '2021-04-15 11:52:51.002266', '2021-04-15 11:52:51.002266', NULL),
	(10002269, 100602, 10000003, 'NY21A-GL100602RD-M', '2021-04-15 11:52:51.002267', '2021-04-15 11:52:51.002267', NULL),
	(10002270, 100602, 10000004, 'NY21A-GL100602RD-L', '2021-04-15 11:52:51.002268', '2021-04-15 11:52:51.002268', NULL),
	(10002271, 100602, 10000005, 'NY21A-GL100602RD-XL', '2021-04-15 11:52:51.002269', '2021-04-15 11:52:51.002269', NULL),
	(10002272, 100602, 10000006, 'NY21A-GL100602RD-XXL', '2021-04-15 11:52:51.002270', '2021-04-15 11:52:51.002270', NULL),
	(10002273, 100603, 10000001, 'NY21A-GL100603YW -XS', '2021-04-15 11:52:51.002271', '2021-04-15 11:52:51.002271', NULL),
	(10002274, 100603, 10000002, 'NY21A-GL100603YW -S', '2021-04-15 11:52:51.002272', '2021-04-15 11:52:51.002272', NULL),
	(10002275, 100603, 10000003, 'NY21A-GL100603YW -M', '2021-04-15 11:52:51.002273', '2021-04-15 11:52:51.002273', NULL),
	(10002276, 100603, 10000004, 'NY21A-GL100603YW -L', '2021-04-15 11:52:51.002274', '2021-04-15 11:52:51.002274', NULL),
	(10002277, 100603, 10000005, 'NY21A-GL100603YW -XL', '2021-04-15 11:52:51.002275', '2021-04-15 11:52:51.002275', NULL),
	(10002278, 100603, 10000006, 'NY21A-GL100603YW -XXL', '2021-04-15 11:52:51.002276', '2021-04-15 11:52:51.002276', NULL),
	(10002279, 100604, 10000001, 'NY21A-GL100604YW -XS', '2021-04-15 11:52:51.002277', '2021-04-15 11:52:51.002277', NULL),
	(10002280, 100604, 10000002, 'NY21A-GL100604YW -S', '2021-04-15 11:52:51.002278', '2021-04-15 11:52:51.002278', NULL),
	(10002281, 100604, 10000003, 'NY21A-GL100604YW -M', '2021-04-15 11:52:51.002279', '2021-04-15 11:52:51.002279', NULL),
	(10002282, 100604, 10000004, 'NY21A-GL100604YW -L', '2021-04-15 11:52:51.002280', '2021-04-15 11:52:51.002280', NULL),
	(10002283, 100604, 10000005, 'NY21A-GL100604YW -XL', '2021-04-15 11:52:51.002281', '2021-04-15 11:52:51.002281', NULL),
	(10002284, 100604, 10000006, 'NY21A-GL100604YW -XXL', '2021-04-15 11:52:51.002282', '2021-04-15 11:52:51.002282', NULL),
	(10002285, 100605, 10000001, 'NY21A-GL100605RD-XS', '2021-04-15 11:52:51.002283', '2021-04-15 11:52:51.002283', NULL),
	(10002286, 100605, 10000002, 'NY21A-GL100605RD-S', '2021-04-15 11:52:51.002284', '2021-04-15 11:52:51.002284', NULL),
	(10002287, 100605, 10000003, 'NY21A-GL100605RD-M', '2021-04-15 11:52:51.002285', '2021-04-15 11:52:51.002285', NULL),
	(10002288, 100605, 10000004, 'NY21A-GL100605RD-L', '2021-04-15 11:52:51.002286', '2021-04-15 11:52:51.002286', NULL),
	(10002289, 100605, 10000005, 'NY21A-GL100605RD-XL', '2021-04-15 11:52:51.002287', '2021-04-15 11:52:51.002287', NULL),
	(10002290, 100605, 10000006, 'NY21A-GL100605RD-XXL', '2021-04-15 11:52:51.002288', '2021-04-15 11:52:51.002288', NULL),
	(10002291, 100606, 10000012, 'NK21A-AC100606MX-All', '2021-04-15 11:52:51.002289', '2021-04-15 11:52:51.002289', NULL),
	(10002292, 100607, 10000012, 'NK21A-AC100607MX-All', '2021-04-15 11:52:51.002290', '2021-04-15 11:52:51.002290', NULL),
	(10002293, 100608, 10000012, 'NK21A-AC100608MX-All', '2021-04-15 11:52:51.002291', '2021-04-15 11:52:51.002291', NULL),
	(10002294, 100609, 10000012, 'NK21A-AC100609MX-All', '2021-04-15 11:52:51.002292', '2021-04-15 11:52:51.002292', NULL),
	(10002295, 100610, 10000012, 'NK21A-AC100610MX-All', '2021-04-15 11:52:51.002293', '2021-04-15 11:52:51.002293', NULL),
	(10002296, 100611, 10000012, 'NK21A-AC100611MX-All', '2021-04-15 11:52:51.002294', '2021-04-15 11:52:51.002294', NULL),
	(10002297, 100612, 10000012, 'NK21A-AC100612MX-All', '2021-04-15 11:52:51.002295', '2021-04-15 11:52:51.002295', NULL),
	(10002298, 100613, 10000012, 'NK21A-AC100613MX-All', '2021-04-15 11:52:51.002296', '2021-04-15 11:52:51.002296', NULL),
	(10002299, 100614, 10000012, 'NK21A-AC100614MX-All', '2021-04-15 11:52:51.002297', '2021-04-15 11:52:51.002297', NULL),
	(10002300, 100615, 10000012, 'NK21A-AC100615MX-All', '2021-04-15 11:52:51.002298', '2021-04-15 11:52:51.002298', NULL),
	(10002301, 100616, 10000012, 'NK21A-AC100616MX-All', '2021-04-15 11:52:51.002299', '2021-04-15 11:52:51.002299', NULL),
	(10002302, 100617, 10000012, 'NK21A-AC100617MX-All', '2021-04-15 11:52:51.002300', '2021-04-15 11:52:51.002300', NULL),
	(10002303, 100618, 10000012, 'NK21A-AC100618MX-All', '2021-04-15 11:52:51.002301', '2021-04-15 11:52:51.002301', NULL),
	(10002304, 100619, 10000012, 'NK21A-AC100619MX-All', '2021-04-15 11:52:51.002302', '2021-04-15 11:52:51.002302', NULL),
	(10002305, 100620, 10000012, 'NK21A-AC100620MX-All', '2021-04-15 11:52:51.002303', '2021-04-15 11:52:51.002303', NULL),
	(10002306, 100621, 10000012, 'NK21A-AC100621MX-All', '2021-04-15 11:52:51.002304', '2021-04-15 11:52:51.002304', NULL),
	(10002307, 100622, 10000012, 'NK21A-AC100622MX-All', '2021-04-15 11:52:51.002305', '2021-04-15 11:52:51.002305', NULL),
	(10002308, 100623, 10000012, 'NK21A-AC100623MX-All', '2021-04-15 11:52:51.002306', '2021-04-15 11:52:51.002306', NULL),
	(10002309, 100624, 10000012, 'NK21A-AC100624MX-All', '2021-04-15 11:52:51.002307', '2021-04-15 11:52:51.002307', NULL),
	(10002310, 100625, 10000012, 'NK21A-AC100625MX-All', '2021-04-15 11:52:51.002308', '2021-04-15 11:52:51.002308', NULL),
	(10002311, 100626, 10000012, 'NK21A-AC100626MX-All', '2021-04-15 11:52:51.002309', '2021-04-15 11:52:51.002309', NULL),
	(10002312, 100627, 10000012, 'NK21A-AC100627MX-All', '2021-04-15 11:52:51.002310', '2021-04-15 11:52:51.002310', NULL),
	(10002313, 100628, 10000012, 'NK21A-AC100628MX-All', '2021-04-15 11:52:51.002311', '2021-04-15 11:52:51.002311', NULL),
	(10002314, 100629, 10000012, 'NK21A-AC100629MX-All', '2021-04-15 11:52:51.002312', '2021-04-15 11:52:51.002312', NULL),
	(10002315, 100630, 10000012, 'NK21A-AC100630MX-All', '2021-04-15 11:52:51.002313', '2021-04-15 11:52:51.002313', NULL),
	(10002316, 100631, 10000012, 'NK21A-AC100631MX-All', '2021-04-15 11:52:51.002314', '2021-04-15 11:52:51.002314', NULL),
	(10002317, 100632, 10000012, 'NK21A-AC100632MX-All', '2021-04-15 11:52:51.002315', '2021-04-15 11:52:51.002315', NULL),
	(10002318, 100633, 10000012, 'NK21A-AC100633MX-All', '2021-04-15 11:52:51.002316', '2021-04-15 11:52:51.002316', NULL),
	(10002319, 100634, 10000012, 'NK21A-AC100634MX-All', '2021-04-15 11:52:51.002317', '2021-04-15 11:52:51.002317', NULL),
	(10002320, 100635, 10000012, 'NK21A-AC100635MX-All', '2021-04-15 11:52:51.002318', '2021-04-15 11:52:51.002318', NULL),
	(10002321, 100636, 10000012, 'NK21A-AC100636MX-All', '2021-04-15 11:52:51.002319', '2021-04-15 11:52:51.002319', NULL),
	(10002322, 100637, 10000012, 'NK21A-AC100637MX-All', '2021-04-15 11:52:51.002320', '2021-04-15 11:52:51.002320', NULL),
	(10002323, 100638, 10000012, 'NK21A-AC100638MX-All', '2021-04-15 11:52:51.002321', '2021-04-15 11:52:51.002321', NULL),
	(10002324, 100639, 10000012, 'NK21A-AC100639MX-All', '2021-04-15 11:52:51.002322', '2021-04-15 11:52:51.002322', NULL),
	(10002325, 100640, 10000012, 'NK21A-AC100640MX-All', '2021-04-15 11:52:51.002323', '2021-04-15 11:52:51.002323', NULL),
	(10002326, 100641, 10000012, 'NK21A-AC100641MX-All', '2021-04-15 11:52:51.002324', '2021-04-15 11:52:51.002324', NULL),
	(10002327, 100642, 10000012, 'NK21A-AC100642MX-All', '2021-04-15 11:52:51.002325', '2021-04-15 11:52:51.002325', NULL),
	(10002328, 100643, 10000012, 'NK21A-AC100643MX-All', '2021-04-15 11:52:51.002326', '2021-04-15 11:52:51.002326', NULL),
	(10002329, 100644, 10000012, 'NK21A-AC100644MX-All', '2021-04-15 11:52:51.002327', '2021-04-15 11:52:51.002327', NULL),
	(10002330, 100645, 10000012, 'NK21A-AC100645MX-All', '2021-04-15 11:52:51.002328', '2021-04-15 11:52:51.002328', NULL),
	(10002331, 100646, 10000012, 'RF21A-BG100646GY-All', '2021-04-15 11:52:51.002329', '2021-04-15 11:52:51.002329', NULL),
	(10002332, 100647, 10000012, 'RF21A-BG100647BW-All', '2021-04-15 11:52:51.002330', '2021-04-15 11:52:51.002330', NULL),
	(10002333, 100648, 10000001, 'RF21A-JK100648NV-XS', '2021-04-15 11:52:51.002331', '2021-04-15 11:52:51.002331', NULL),
	(10002334, 100648, 10000002, 'RF21A-JK100648NV-S', '2021-04-15 11:52:51.002332', '2021-04-15 11:52:51.002332', NULL),
	(10002335, 100648, 10000003, 'RF21A-JK100648NV-M', '2021-04-15 11:52:51.002333', '2021-04-15 11:52:51.002333', NULL),
	(10002336, 100648, 10000004, 'RF21A-JK100648NV-L', '2021-04-15 11:52:51.002334', '2021-04-15 11:52:51.002334', NULL),
	(10002337, 100648, 10000005, 'RF21A-JK100648NV-XL', '2021-04-15 11:52:51.002335', '2021-04-15 11:52:51.002335', NULL),
	(10002338, 100648, 10000006, 'RF21A-JK100648NV-XXL', '2021-04-15 11:52:51.002336', '2021-04-15 11:52:51.002336', NULL),
	(10002339, 100649, 10000007, 'RF21A-PN100649OL-28', '2021-04-15 11:52:51.002337', '2021-04-15 11:52:51.002337', NULL),
	(10002340, 100650, 10000008, 'RF21A-PN100650OL-30', '2021-04-15 11:52:51.002338', '2021-04-15 11:52:51.002338', NULL),
	(10002341, 100651, 10000009, 'RF21A-PN100651OL-32', '2021-04-15 11:52:51.002339', '2021-04-15 11:52:51.002339', NULL),
	(10002342, 100652, 10000010, 'RF21A-PN100652OL-34', '2021-04-15 11:52:51.002340', '2021-04-15 11:52:51.002340', NULL),
	(10002343, 100653, 10000011, 'RF21A-PN100653OL-36', '2021-04-15 11:52:51.002341', '2021-04-15 11:52:51.002341', NULL),
	(10002344, 100654, 10000012, 'RF21A-BG100654GY-All', '2021-04-15 11:52:51.002342', '2021-04-15 11:52:51.002342', NULL),
	(10002345, 100655, 10000001, 'RF21A-JK100655BL-XS', '2021-04-15 11:52:51.002343', '2021-04-15 11:52:51.002343', NULL),
	(10002346, 100655, 10000002, 'RF21A-JK100655BL-S', '2021-04-15 11:52:51.002344', '2021-04-15 11:52:51.002344', NULL),
	(10002347, 100655, 10000003, 'RF21A-JK100655BL-M', '2021-04-15 11:52:51.002345', '2021-04-15 11:52:51.002345', NULL),
	(10002348, 100655, 10000004, 'RF21A-JK100655BL-L', '2021-04-15 11:52:51.002346', '2021-04-15 11:52:51.002346', NULL),
	(10002349, 100655, 10000005, 'RF21A-JK100655BL-XL', '2021-04-15 11:52:51.002347', '2021-04-15 11:52:51.002347', NULL),
	(10002350, 100655, 10000006, 'RF21A-JK100655BL-XXL', '2021-04-15 11:52:51.002348', '2021-04-15 11:52:51.002348', NULL),
	(10002351, 100656, 10000012, 'RF21A-BG100656GN-All', '2021-04-15 11:52:51.002349', '2021-04-15 11:52:51.002349', NULL),
	(10002352, 100657, 10000012, 'RF21A-BG100657NV-All', '2021-04-15 11:52:51.002350', '2021-04-15 11:52:51.002350', NULL),
	(10002353, 100658, 10000012, 'RF21A-BG100658BL-All', '2021-04-15 11:52:51.002351', '2021-04-15 11:52:51.002351', NULL),
	(10002354, 100659, 10000012, 'RF21A-BG100659BL-All', '2021-04-15 11:52:51.002352', '2021-04-15 11:52:51.002352', NULL),
	(10002355, 100660, 10000012, 'RF21A-BG100660AR-All', '2021-04-15 11:52:51.002353', '2021-04-15 11:52:51.002353', NULL),
	(10002356, 100661, 10000012, 'RF21A-HT100661NV-All', '2021-04-15 11:52:51.002354', '2021-04-15 11:52:51.002354', NULL),
	(10002357, 100662, 10000012, 'RF21A-HT100662BL-All', '2021-04-15 11:52:51.002355', '2021-04-15 11:52:51.002355', NULL),
	(10002358, 100663, 10000012, 'RF21A-HT100663OL-All', '2021-04-15 11:52:51.002356', '2021-04-15 11:52:51.002356', NULL),
	(10002359, 100664, 10000001, 'RF21A-JK100664KH-XS', '2021-04-15 11:52:51.002357', '2021-04-15 11:52:51.002357', NULL),
	(10002360, 100664, 10000002, 'RF21A-JK100664KH-S', '2021-04-15 11:52:51.002358', '2021-04-15 11:52:51.002358', NULL),
	(10002361, 100664, 10000003, 'RF21A-JK100664KH-M', '2021-04-15 11:52:51.002359', '2021-04-15 11:52:51.002359', NULL),
	(10002362, 100664, 10000004, 'RF21A-JK100664KH-L', '2021-04-15 11:52:51.002360', '2021-04-15 11:52:51.002360', NULL),
	(10002363, 100664, 10000005, 'RF21A-JK100664KH-XL', '2021-04-15 11:52:51.002361', '2021-04-15 11:52:51.002361', NULL),
	(10002364, 100664, 10000006, 'RF21A-JK100664KH-XXL', '2021-04-15 11:52:51.002362', '2021-04-15 11:52:51.002362', NULL),
	(10002365, 100665, 10000001, 'RF21A-JK100665OL-XS', '2021-04-15 11:52:51.002363', '2021-04-15 11:52:51.002363', NULL),
	(10002366, 100665, 10000002, 'RF21A-JK100665OL-S', '2021-04-15 11:52:51.002364', '2021-04-15 11:52:51.002364', NULL),
	(10002367, 100665, 10000003, 'RF21A-JK100665OL-M', '2021-04-15 11:52:51.002365', '2021-04-15 11:52:51.002365', NULL),
	(10002368, 100665, 10000004, 'RF21A-JK100665OL-L', '2021-04-15 11:52:51.002366', '2021-04-15 11:52:51.002366', NULL),
	(10002369, 100665, 10000005, 'RF21A-JK100665OL-XL', '2021-04-15 11:52:51.002367', '2021-04-15 11:52:51.002367', NULL),
	(10002370, 100665, 10000005, 'RF21A-JK100665OL-XL', '2021-04-15 11:52:51.002368', '2021-04-15 11:52:51.002368', NULL),
	(10002371, 100666, 10000001, 'RF21A-JK100666GN-XS', '2021-04-15 11:52:51.002369', '2021-04-15 11:52:51.002369', NULL),
	(10002372, 100666, 10000002, 'RF21A-JK100666GN-S', '2021-04-15 11:52:51.002370', '2021-04-15 11:52:51.002370', NULL),
	(10002373, 100666, 10000003, 'RF21A-JK100666GN-M', '2021-04-15 11:52:51.002371', '2021-04-15 11:52:51.002371', NULL),
	(10002374, 100666, 10000004, 'RF21A-JK100666GN-L', '2021-04-15 11:52:51.002372', '2021-04-15 11:52:51.002372', NULL),
	(10002375, 100666, 10000005, 'RF21A-JK100666GN-XL', '2021-04-15 11:52:51.002373', '2021-04-15 11:52:51.002373', NULL),
	(10002376, 100666, 10000006, 'RF21A-JK100666GN-XXL', '2021-04-15 11:52:51.002374', '2021-04-15 11:52:51.002374', NULL),
	(10002377, 100667, 10000001, 'RF21A-SH100667RD-XS', '2021-04-15 11:52:51.002375', '2021-04-15 11:52:51.002375', NULL),
	(10002378, 100667, 10000002, 'RF21A-SH100667RD-S', '2021-04-15 11:52:51.002376', '2021-04-15 11:52:51.002376', NULL),
	(10002379, 100667, 10000003, 'RF21A-SH100667RD-M', '2021-04-15 11:52:51.002377', '2021-04-15 11:52:51.002377', NULL),
	(10002380, 100667, 10000004, 'RF21A-SH100667RD-L', '2021-04-15 11:52:51.002378', '2021-04-15 11:52:51.002378', NULL),
	(10002381, 100667, 10000005, 'RF21A-SH100667RD-XL', '2021-04-15 11:52:51.002379', '2021-04-15 11:52:51.002379', NULL),
	(10002382, 100667, 10000006, 'RF21A-SH100667RD-XXL', '2021-04-15 11:52:51.002380', '2021-04-15 11:52:51.002380', NULL),
	(10002383, 100668, 10000012, 'RF21A-BG100668GN-All', '2021-04-15 11:52:51.002381', '2021-04-15 11:52:51.002381', NULL),
	(10002384, 100669, 10000001, 'RF21A-SH100669GN-XS', '2021-04-15 11:52:51.002382', '2021-04-15 11:52:51.002382', NULL),
	(10002385, 100669, 10000002, 'RF21A-SH100669GN-S', '2021-04-15 11:52:51.002383', '2021-04-15 11:52:51.002383', NULL),
	(10002386, 100669, 10000003, 'RF21A-SH100669GN-M', '2021-04-15 11:52:51.002384', '2021-04-15 11:52:51.002384', NULL),
	(10002387, 100669, 10000004, 'RF21A-SH100669GN-L', '2021-04-15 11:52:51.002385', '2021-04-15 11:52:51.002385', NULL),
	(10002388, 100669, 10000005, 'RF21A-SH100669GN-XL', '2021-04-15 11:52:51.002386', '2021-04-15 11:52:51.002386', NULL),
	(10002389, 100669, 10000006, 'RF21A-SH100669GN-XXL', '2021-04-15 11:52:51.002387', '2021-04-15 11:52:51.002387', NULL),
	(10002390, 100670, 10000001, 'RF21A-SH100670GN-XS', '2021-04-15 11:52:51.002388', '2021-04-15 11:52:51.002388', NULL),
	(10002391, 100670, 10000002, 'RF21A-SH100670GN-S', '2021-04-15 11:52:51.002389', '2021-04-15 11:52:51.002389', NULL),
	(10002392, 100670, 10000003, 'RF21A-SH100670GN-M', '2021-04-15 11:52:51.002390', '2021-04-15 11:52:51.002390', NULL),
	(10002393, 100670, 10000004, 'RF21A-SH100670GN-L', '2021-04-15 11:52:51.002391', '2021-04-15 11:52:51.002391', NULL),
	(10002394, 100670, 10000005, 'RF21A-SH100670GN-XL', '2021-04-15 11:52:51.002392', '2021-04-15 11:52:51.002392', NULL),
	(10002395, 100670, 10000006, 'RF21A-SH100670GN-XXL', '2021-04-15 11:52:51.002393', '2021-04-15 11:52:51.002393', NULL),
	(10002396, 100671, 10000007, 'RF21A-PN100671BL-28', '2021-04-15 11:52:51.002394', '2021-04-15 11:52:51.002394', NULL),
	(10002397, 100671, 10000008, 'RF21A-PN100671BL-30', '2021-04-15 11:52:51.002395', '2021-04-15 11:52:51.002395', NULL),
	(10002398, 100671, 10000009, 'RF21A-PN100671BL-32', '2021-04-15 11:52:51.002396', '2021-04-15 11:52:51.002396', NULL),
	(10002399, 100671, 10000010, 'RF21A-PN100671BL-34', '2021-04-15 11:52:51.002397', '2021-04-15 11:52:51.002397', NULL),
	(10002400, 100671, 10000011, 'RF21A-PN100671BL-36', '2021-04-15 11:52:51.002398', '2021-04-15 11:52:51.002398', NULL),
	(10002401, 100672, 10000007, 'RF21A-PN100672AR-28', '2021-04-15 11:52:51.002399', '2021-04-15 11:52:51.002399', NULL),
	(10002402, 100672, 10000008, 'RF21A-PN100672AR-30', '2021-04-15 11:52:51.002400', '2021-04-15 11:52:51.002400', NULL),
	(10002403, 100672, 10000009, 'RF21A-PN100672AR-32', '2021-04-15 11:52:51.002401', '2021-04-15 11:52:51.002401', NULL),
	(10002404, 100672, 10000010, 'RF21A-PN100672AR-34', '2021-04-15 11:52:51.002402', '2021-04-15 11:52:51.002402', NULL),
	(10002405, 100672, 10000011, 'RF21A-PN100672AR-36', '2021-04-15 11:52:51.002403', '2021-04-15 11:52:51.002403', NULL),
	(10002406, 100673, 10000007, 'RF21A-PN100673BL-28', '2021-04-15 11:52:51.002404', '2021-04-15 11:52:51.002404', NULL),
	(10002407, 100673, 10000008, 'RF21A-PN100673BL-30', '2021-04-15 11:52:51.002405', '2021-04-15 11:52:51.002405', NULL),
	(10002408, 100673, 10000009, 'RF21A-PN100673BL-32', '2021-04-15 11:52:51.002406', '2021-04-15 11:52:51.002406', NULL),
	(10002409, 100673, 10000010, 'RF21A-PN100673BL-34', '2021-04-15 11:52:51.002407', '2021-04-15 11:52:51.002407', NULL),
	(10002410, 100673, 10000011, 'RF21A-PN100673BL-36', '2021-04-15 11:52:51.002408', '2021-04-15 11:52:51.002408', NULL),
	(10002411, 100674, 10000007, 'RF21A-PN100674BL-28', '2021-04-15 11:52:51.002409', '2021-04-15 11:52:51.002409', NULL),
	(10002412, 100674, 10000008, 'RF21A-PN100674BL-30', '2021-04-15 11:52:51.002410', '2021-04-15 11:52:51.002410', NULL),
	(10002413, 100674, 10000009, 'RF21A-PN100674BL-32', '2021-04-15 11:52:51.002411', '2021-04-15 11:52:51.002411', NULL),
	(10002414, 100674, 10000010, 'RF21A-PN100674BL-34', '2021-04-15 11:52:51.002412', '2021-04-15 11:52:51.002412', NULL),
	(10002415, 100674, 10000011, 'RF21A-PN100674BL-36', '2021-04-15 11:52:51.002413', '2021-04-15 11:52:51.002413', NULL),
	(10002416, 100675, 10000001, 'RF21A-JK100675BL-XS', '2021-04-15 11:52:51.002414', '2021-04-15 11:52:51.002414', NULL),
	(10002417, 100675, 10000002, 'RF21A-JK100675BL-S', '2021-04-15 11:52:51.002415', '2021-04-15 11:52:51.002415', NULL),
	(10002418, 100675, 10000003, 'RF21A-JK100675BL-M', '2021-04-15 11:52:51.002416', '2021-04-15 11:52:51.002416', NULL),
	(10002419, 100675, 10000004, 'RF21A-JK100675BL-L', '2021-04-15 11:52:51.002417', '2021-04-15 11:52:51.002417', NULL),
	(10002420, 100675, 10000005, 'RF21A-JK100675BL-XL', '2021-04-15 11:52:51.002418', '2021-04-15 11:52:51.002418', NULL),
	(10002421, 100675, 10000006, 'RF21A-JK100675BL-XXL', '2021-04-15 11:52:51.002419', '2021-04-15 11:52:51.002419', NULL),
	(10002422, 100676, 10000001, 'RF21A-JK100676GN-XS', '2021-04-15 11:52:51.002420', '2021-04-15 11:52:51.002420', NULL),
	(10002423, 100676, 10000002, 'RF21A-JK100676GN-S', '2021-04-15 11:52:51.002421', '2021-04-15 11:52:51.002421', NULL),
	(10002424, 100676, 10000003, 'RF21A-JK100676GN-M', '2021-04-15 11:52:51.002422', '2021-04-15 11:52:51.002422', NULL),
	(10002425, 100676, 10000004, 'RF21A-JK100676GN-L', '2021-04-15 11:52:51.002423', '2021-04-15 11:52:51.002423', NULL),
	(10002426, 100676, 10000005, 'RF21A-JK100676GN-XL', '2021-04-15 11:52:51.002424', '2021-04-15 11:52:51.002424', NULL),
	(10002427, 100676, 10000006, 'RF21A-JK100676GN-XXL', '2021-04-15 11:52:51.002425', '2021-04-15 11:52:51.002425', NULL),
	(10002428, 100677, 10000001, 'RF21A-JK100677GN-XS', '2021-04-15 11:52:51.002426', '2021-04-15 11:52:51.002426', NULL),
	(10002429, 100677, 10000002, 'RF21A-JK100677GN-S', '2021-04-15 11:52:51.002427', '2021-04-15 11:52:51.002427', NULL),
	(10002430, 100677, 10000003, 'RF21A-JK100677GN-M', '2021-04-15 11:52:51.002428', '2021-04-15 11:52:51.002428', NULL),
	(10002431, 100677, 10000004, 'RF21A-JK100677GN-L', '2021-04-15 11:52:51.002429', '2021-04-15 11:52:51.002429', NULL),
	(10002432, 100677, 10000005, 'RF21A-JK100677GN-XL', '2021-04-15 11:52:51.002430', '2021-04-15 11:52:51.002430', NULL),
	(10002433, 100677, 10000006, 'RF21A-JK100677GN-XXL', '2021-04-15 11:52:51.002431', '2021-04-15 11:52:51.002431', NULL),
	(10002434, 100678, 10000001, 'RF21A-JK100678GY-XS', '2021-04-15 11:52:51.002432', '2021-04-15 11:52:51.002432', NULL),
	(10002435, 100678, 10000002, 'RF21A-JK100678GY-S', '2021-04-15 11:52:51.002433', '2021-04-15 11:52:51.002433', NULL),
	(10002436, 100678, 10000003, 'RF21A-JK100678GY-M', '2021-04-15 11:52:51.002434', '2021-04-15 11:52:51.002434', NULL),
	(10002437, 100678, 10000004, 'RF21A-JK100678GY-L', '2021-04-15 11:52:51.002435', '2021-04-15 11:52:51.002435', NULL),
	(10002438, 100678, 10000005, 'RF21A-JK100678GY-XL', '2021-04-15 11:52:51.002436', '2021-04-15 11:52:51.002436', NULL),
	(10002439, 100678, 10000006, 'RF21A-JK100678GY-XXL', '2021-04-15 11:52:51.002437', '2021-04-15 11:52:51.002437', NULL);
/*!40000 ALTER TABLE `product_variant_item` ENABLE KEYS */;

-- Dumping structure for table phillip.province
CREATE TABLE IF NOT EXISTS `province` (
  `id` int NOT NULL AUTO_INCREMENT,
  `provinsi` varchar(100) NOT NULL,
  `ibukota` varchar(100) NOT NULL,
  `p_bsni` char(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.province: ~34 rows (approximately)
/*!40000 ALTER TABLE `province` DISABLE KEYS */;
INSERT INTO `province` (`id`, `provinsi`, `ibukota`, `p_bsni`) VALUES
	(1, 'Aceh', 'Banda Aceh', 'ID-AC'),
	(2, 'Sumatra Utara', 'Medan', 'ID-SU'),
	(3, 'Sumatra Barat', 'Padang', 'ID-SB'),
	(4, 'Riau', 'Pekanbaru', 'ID-RI'),
	(5, 'Jambi', 'Jambi', 'ID-JA'),
	(6, 'Sumatra Selatan', 'Palembang', 'ID-SS'),
	(7, 'Bengkulu', 'Bengkulu', 'ID-BE'),
	(8, 'Lampung', 'Bandar Lampung', 'ID-LA'),
	(9, 'Kepulauan Bangka Belitung', 'Pangkalpinang', 'ID-BB'),
	(10, 'Kepulauan Riau', 'Tanjungpinang', 'ID-KR'),
	(11, 'Daerah Khusus Ibukota Jakarta', 'Jakarta', 'ID-JB'),
	(12, 'Jawa Barat', 'Bandung', 'ID-JB'),
	(13, 'Jawa Tengah', 'Semarang', 'ID-JT'),
	(14, 'Daerah Istimewa Yogyakarta', 'Yogyakarta', 'ID-YO'),
	(15, 'Jawa Timur', 'Surabaya', 'ID-JI'),
	(16, 'Banten', 'Serang', 'ID-BT'),
	(17, 'Bali', 'Denpasar', 'ID-BA'),
	(18, 'Nusa Tenggara Barat', 'Mataram', 'ID-NB'),
	(19, 'Nusa Tenggara Timur', 'Kupang', 'ID-NT'),
	(20, 'Kalimantan Barat', 'Pontianak', 'ID-KB'),
	(21, 'Kalimantan Tengah', 'Palangka Raya', 'ID-KT'),
	(22, 'Kalimantan Selatan', 'Banjarmasin', 'ID-KS'),
	(23, 'Kalimantan Timur', 'Samarinda', 'ID-KI'),
	(24, 'Kalimantan Utara', 'Tanjung Selor', 'ID-KU'),
	(25, 'Sulawesi Utara', 'Manado', 'ID-SA'),
	(26, 'Sulawesi Tengah', 'Palu', 'ID-ST'),
	(27, 'Sulawesi Selatan', 'Makassar', 'ID-SN'),
	(28, 'Sulawesi Tenggara', 'Kendari', 'ID-SG'),
	(29, 'Gorontalo', 'Gorontalo', 'ID-GO'),
	(30, 'Sulawesi Barat', 'Mamuju', 'ID-SR'),
	(31, 'Maluku', 'Ambon', 'ID-MA'),
	(32, 'Maluku Utara', 'Sofifi', 'ID-MU'),
	(33, 'Papua', 'Jayapura', 'ID-PA'),
	(34, 'Papua Barat', 'Manokwari', 'ID-PB');
/*!40000 ALTER TABLE `province` ENABLE KEYS */;

-- Dumping structure for table phillip.reject
CREATE TABLE IF NOT EXISTS `reject` (
  `id` int NOT NULL AUTO_INCREMENT,
  `branch_id` int NOT NULL,
  `code` varchar(255) DEFAULT NULL,
  `date` date NOT NULL,
  `reference` varchar(50) DEFAULT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `status` enum('draft','checked','confirmed') NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_6aeb0f434790725eb73e556e42f` (`branch_id`),
  CONSTRAINT `FK_6aeb0f434790725eb73e556e42f` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.reject: ~0 rows (approximately)
/*!40000 ALTER TABLE `reject` DISABLE KEYS */;
/*!40000 ALTER TABLE `reject` ENABLE KEYS */;

-- Dumping structure for table phillip.reject_item
CREATE TABLE IF NOT EXISTS `reject_item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `reject_id` int DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `variant_type_id` int DEFAULT NULL,
  `unit_of_measuremnt_id` int NOT NULL,
  `price` int NOT NULL,
  `qty` int NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_952f8b63e744ca13da8dc148e50` (`product_id`),
  KEY `FK_f1c4f94bcff5bd301322543293d` (`reject_id`),
  KEY `FK_e610cc39508484a3fc295365d24` (`variant_type_id`),
  CONSTRAINT `FK_952f8b63e744ca13da8dc148e50` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  CONSTRAINT `FK_e610cc39508484a3fc295365d24` FOREIGN KEY (`variant_type_id`) REFERENCES `variant_type` (`id`),
  CONSTRAINT `FK_f1c4f94bcff5bd301322543293d` FOREIGN KEY (`reject_id`) REFERENCES `reject` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.reject_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `reject_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `reject_item` ENABLE KEYS */;

-- Dumping structure for table phillip.sales_order
CREATE TABLE IF NOT EXISTS `sales_order` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `contact_id` int NOT NULL,
  `branch_id` int DEFAULT NULL,
  `status` enum('draft','confirmed','waiting','delivered','invoiced','done') NOT NULL,
  `shipment_date` date NOT NULL,
  `date` date NOT NULL,
  `note` text,
  `created_by_contact_id` int DEFAULT NULL,
  `updated_by_contact_id` int DEFAULT NULL,
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_906ee2298cb22a4e98a49c921b0` (`created_by_contact_id`),
  KEY `FK_2d67c2427231432403a575c2384` (`updated_by_contact_id`),
  KEY `FK_9d1126c797fd31c8094cda5611e` (`contact_id`),
  KEY `FK_32b11add572ea125cc047045102` (`branch_id`),
  CONSTRAINT `FK_2d67c2427231432403a575c2384` FOREIGN KEY (`updated_by_contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_32b11add572ea125cc047045102` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`),
  CONSTRAINT `FK_906ee2298cb22a4e98a49c921b0` FOREIGN KEY (`created_by_contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_9d1126c797fd31c8094cda5611e` FOREIGN KEY (`contact_id`) REFERENCES `contact` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.sales_order: ~0 rows (approximately)
/*!40000 ALTER TABLE `sales_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_order` ENABLE KEYS */;

-- Dumping structure for table phillip.sales_order_product
CREATE TABLE IF NOT EXISTS `sales_order_product` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sales_order_id` int DEFAULT NULL,
  `uom_id` int NOT NULL,
  `product_id` int DEFAULT NULL,
  `variant_type_id` int DEFAULT NULL,
  `quantity` int NOT NULL,
  `price` int NOT NULL,
  `discount` int NOT NULL DEFAULT '0',
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_b7205fd803e3c39ed303fdc5a6a` (`uom_id`),
  KEY `FK_9684f9e2db0f05b6c854ae9c302` (`product_id`),
  KEY `FK_a8923197ccce4e1ec2821be697a` (`variant_type_id`),
  KEY `FK_3989f07d94b6fb5b86696fddc1e` (`sales_order_id`),
  CONSTRAINT `FK_3989f07d94b6fb5b86696fddc1e` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_order` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9684f9e2db0f05b6c854ae9c302` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  CONSTRAINT `FK_a8923197ccce4e1ec2821be697a` FOREIGN KEY (`variant_type_id`) REFERENCES `variant_type` (`id`),
  CONSTRAINT `FK_b7205fd803e3c39ed303fdc5a6a` FOREIGN KEY (`uom_id`) REFERENCES `unit` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.sales_order_product: ~0 rows (approximately)
/*!40000 ALTER TABLE `sales_order_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_order_product` ENABLE KEYS */;

-- Dumping structure for table phillip.sales_order_shipment
CREATE TABLE IF NOT EXISTS `sales_order_shipment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shipment_id` int DEFAULT NULL,
  `sales_order_id` int DEFAULT NULL,
  `product_id` int NOT NULL,
  `variant_type_id` int DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `rest_of_quantity` int DEFAULT NULL,
  `status` enum('draft','open','confirmed','waiting','delivered','invoiced','done') NOT NULL,
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_959c0b8e6e615b7ce6a84b190cd` (`shipment_id`),
  KEY `FK_dfeb0a60966ae11c40bdab9742e` (`sales_order_id`),
  CONSTRAINT `FK_959c0b8e6e615b7ce6a84b190cd` FOREIGN KEY (`shipment_id`) REFERENCES `product_shipment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_dfeb0a60966ae11c40bdab9742e` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_order` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.sales_order_shipment: ~0 rows (approximately)
/*!40000 ALTER TABLE `sales_order_shipment` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_order_shipment` ENABLE KEYS */;

-- Dumping structure for table phillip.sales_return
CREATE TABLE IF NOT EXISTS `sales_return` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `contact_id` int NOT NULL,
  `branch_id` int DEFAULT NULL,
  `status` enum('draft','confirmed','waiting','delivered','received','invoiced','done') NOT NULL,
  `date` date NOT NULL,
  `reference` text,
  `note` text,
  `created_by_contact_id` int DEFAULT NULL,
  `updated_by_contact_id` int DEFAULT NULL,
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_adf72a3e407f7fb145d0f201570` (`created_by_contact_id`),
  KEY `FK_9b53718216ed4f37fd47a155f8f` (`updated_by_contact_id`),
  KEY `FK_7d692a5a00af5bde98954cc131d` (`contact_id`),
  KEY `FK_9669adc6431982949c64e6d576f` (`branch_id`),
  CONSTRAINT `FK_7d692a5a00af5bde98954cc131d` FOREIGN KEY (`contact_id`) REFERENCES `contact` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.sales_return: ~0 rows (approximately)
/*!40000 ALTER TABLE `sales_return` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_return` ENABLE KEYS */;

-- Dumping structure for table phillip.sales_return_product
CREATE TABLE IF NOT EXISTS `sales_return_product` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sales_return_id` int DEFAULT NULL,
  `uom_id` int NOT NULL,
  `product_id` int DEFAULT NULL,
  `variant_type_id` int DEFAULT NULL,
  `quantity` int NOT NULL,
  `price` int NOT NULL,
  `discount` int NOT NULL DEFAULT '0',
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_5f816114c8153ee1837ae3c3b5d` (`uom_id`),
  KEY `FK_b1f47dbc50bd9ffcecc62308011` (`product_id`),
  KEY `FK_714bf5e12e079fd9ae128299d42` (`variant_type_id`),
  KEY `FK_e48bb89a7e3d164baf994d626ef` (`sales_return_id`),
  CONSTRAINT `FK_5f816114c8153ee1837ae3c3b5d` FOREIGN KEY (`uom_id`) REFERENCES `unit` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.sales_return_product: ~0 rows (approximately)
/*!40000 ALTER TABLE `sales_return_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_return_product` ENABLE KEYS */;

-- Dumping structure for table phillip.sales_return_shipment
CREATE TABLE IF NOT EXISTS `sales_return_shipment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shipment_id` int DEFAULT NULL,
  `sales_return_id` int DEFAULT NULL,
  `product_id` int NOT NULL,
  `variant_type_id` int DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `rest_of_quantity` int DEFAULT NULL,
  `status` enum('draft','open','confirmed','waiting','received','invoiced','done') NOT NULL,
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_3a01100d748297626ebcae85073` (`shipment_id`),
  KEY `FK_3df231c3cf7a2b179239b8aba80` (`sales_return_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.sales_return_shipment: ~0 rows (approximately)
/*!40000 ALTER TABLE `sales_return_shipment` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_return_shipment` ENABLE KEYS */;

-- Dumping structure for table phillip.stock_opname
CREATE TABLE IF NOT EXISTS `stock_opname` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `branch_id` int NOT NULL,
  `date` date NOT NULL,
  `reference` varchar(255) NOT NULL,
  `note` varchar(255) DEFAULT NULL,
  `based_on` enum('all_product','product','category') NOT NULL DEFAULT 'all_product',
  `location` enum('all_location','reject','stock') NOT NULL DEFAULT 'all_location',
  `warehouse_id` int NOT NULL,
  `result` enum('match','selisih') NOT NULL,
  `status` enum('draft','open','checked') NOT NULL DEFAULT 'draft',
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_45a4c929dd8d2221e433c5a46d8` (`branch_id`),
  CONSTRAINT `FK_45a4c929dd8d2221e433c5a46d8` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10000007 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.stock_opname: ~6 rows (approximately)
/*!40000 ALTER TABLE `stock_opname` DISABLE KEYS */;
INSERT INTO `stock_opname` (`id`, `code`, `branch_id`, `date`, `reference`, `note`, `based_on`, `location`, `warehouse_id`, `result`, `status`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(10000001, 'SOP-1', 1, '2021-04-15', '', NULL, 'all_product', 'all_location', 1, 'selisih', 'checked', '2021-04-15 12:51:18.000000', '2021-04-15 11:52:51.000000', NULL),
	(10000002, 'SOP-2', 2, '2021-04-15', '', NULL, 'all_product', 'all_location', 2, 'selisih', 'checked', '2021-04-15 12:58:18.000000', '2021-04-15 11:52:51.000001', NULL),
	(10000003, 'SOP-3', 3, '2021-04-15', '', NULL, 'all_product', 'all_location', 3, 'selisih', 'checked', '2021-04-15 13:01:02.000000', '2021-04-15 11:52:51.000002', NULL),
	(10000004, 'SOP-4', 4, '2021-04-15', '', NULL, 'all_product', 'all_location', 4, 'selisih', 'checked', '2021-04-15 13:03:20.000000', '2021-04-15 11:52:51.000003', NULL),
	(10000005, 'SOP-5', 5, '2021-04-15', '', NULL, 'all_product', 'all_location', 5, 'selisih', 'checked', '2021-04-15 13:06:33.000000', '2021-04-15 11:52:51.000004', NULL),
	(10000006, 'SOP-6', 6, '2021-04-15', '', NULL, 'all_product', 'all_location', 6, 'selisih', 'open', '2021-04-15 11:52:51.000005', '2021-04-15 11:52:51.000005', '2021-04-15 13:09:13.000000');
/*!40000 ALTER TABLE `stock_opname` ENABLE KEYS */;

-- Dumping structure for table phillip.stock_opname_category
CREATE TABLE IF NOT EXISTS `stock_opname_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `stock_opname_id` int NOT NULL,
  `category_id` int NOT NULL,
  `category_name` varchar(255) NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_78d36fbc447b5cb1e3352b4d5a0` (`stock_opname_id`),
  CONSTRAINT `FK_78d36fbc447b5cb1e3352b4d5a0` FOREIGN KEY (`stock_opname_id`) REFERENCES `stock_opname` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.stock_opname_category: ~0 rows (approximately)
/*!40000 ALTER TABLE `stock_opname_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_opname_category` ENABLE KEYS */;

-- Dumping structure for table phillip.stock_opname_item
CREATE TABLE IF NOT EXISTS `stock_opname_item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `stock_opname_id` int DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `product_id` int DEFAULT NULL,
  `product_name` varchar(255) NOT NULL,
  `category_id` int NOT NULL,
  `category_name` varchar(255) NOT NULL,
  `brand_id` int NOT NULL,
  `brand_name` varchar(255) NOT NULL,
  `variant_type_id` int DEFAULT NULL,
  `variant_type_value` varchar(255) DEFAULT NULL,
  `qty_reject` int DEFAULT NULL,
  `qty_stock` int DEFAULT NULL,
  `qty_reject_physic` int DEFAULT NULL,
  `qty_stock_physic` int DEFAULT NULL,
  `uom_id` int NOT NULL,
  `uom_name` varchar(255) NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_d879f967224c1e56ae8ca48e1af` (`stock_opname_id`),
  KEY `FK_d53b25bd2dc65cd41a603ef2016` (`product_id`),
  KEY `FK_01ada77b01a6580a8516c5bab57` (`variant_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10009206 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.stock_opname_item: ~9.063 rows (approximately)
/*!40000 ALTER TABLE `stock_opname_item` DISABLE KEYS */;
INSERT INTO `stock_opname_item` (`id`, `stock_opname_id`, `code`, `product_id`, `product_name`, `category_id`, `category_name`, `brand_id`, `brand_name`, `variant_type_id`, `variant_type_value`, `qty_reject`, `qty_stock`, `qty_reject_physic`, `qty_stock_physic`, `uom_id`, `uom_name`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(10000001, 10000001, 'PW21A-AC100001BL-All', 100001, 'PHILLIP LOGO ENAMEL', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.000000', '2021-04-15 11:52:51.000000', NULL),
	(10000002, 10000001, 'PW21A-AC100002YW -All', 100002, 'PHILLIP PLATE ENAMEL', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 30, 1, 'Piece', '2021-04-15 11:52:51.000001', '2021-04-15 11:52:51.000001', NULL),
	(10000003, 10000001, 'PW21A-AC100003BL-All', 100003, 'PHILLIP PATCH ENAMEL', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 28, 1, 'Piece', '2021-04-15 11:52:51.000002', '2021-04-15 11:52:51.000002', NULL),
	(10000004, 10000001, 'PW21A-AC100004BL-All', 100004, 'PHILLIP UMBRELLA', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000003', '2021-04-15 11:52:51.000003', NULL),
	(10000005, 10000001, 'PW21A-AC100005BL-All', 100005, 'PHILLIP ASHTRAY', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.000004', '2021-04-15 11:52:51.000004', NULL),
	(10000006, 10000001, 'PW21A-AC100006BL-All', 100006, 'PHILLIP BOTTLE SPORT', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.000005', '2021-04-15 11:52:51.000005', NULL),
	(10000007, 10000001, 'PW21A-AC100007BL-All', 100007, 'PHILLIP BOTTLE SPORT 2.0', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000006', '2021-04-15 11:52:51.000006', NULL),
	(10000008, 10000001, 'PW21A-AC100008BL-All', 100008, 'PHILLIP KEYCHAIN BLACK', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000007', '2021-04-15 11:52:51.000007', NULL),
	(10000009, 10000001, 'PW21A-AC100009BW-All', 100009, 'PHILLIP KEYCHAIN BROWN', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 87, 1, 'Piece', '2021-04-15 11:52:51.000008', '2021-04-15 11:52:51.000008', NULL),
	(10000010, 10000001, 'PW21A-AC100010MC-All', 100010, 'PHILLIP KEYCHAIN MOCCA', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 30, 1, 'Piece', '2021-04-15 11:52:51.000009', '2021-04-15 11:52:51.000009', NULL),
	(10000011, 10000001, 'PW21A-AC100011OG-All', 100011, 'PHILLIP KEYCHAIN ORANGE', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 34, 1, 'Piece', '2021-04-15 11:52:51.000010', '2021-04-15 11:52:51.000010', NULL),
	(10000012, 10000001, 'PW21A-AC100012BL-All', 100012, 'PW MOTO KEYCHAIN BLACK', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 54, 1, 'Piece', '2021-04-15 11:52:51.000011', '2021-04-15 11:52:51.000011', NULL),
	(10000013, 10000001, 'PW21A-AC100013OG-All', 100013, 'PW MOTO KEYCHAIN ORANGE', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 58, 1, 'Piece', '2021-04-15 11:52:51.000012', '2021-04-15 11:52:51.000012', NULL),
	(10000014, 10000001, 'PW21A-AC100014OL-All', 100014, 'PW MOTO KEYCHAIN OLIVE', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 89, 1, 'Piece', '2021-04-15 11:52:51.000013', '2021-04-15 11:52:51.000013', NULL),
	(10000015, 10000001, 'PW21A-AC100015MR-All', 100015, 'PW MOTO KEYCHAIN MAROON', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 79, 1, 'Piece', '2021-04-15 11:52:51.000014', '2021-04-15 11:52:51.000014', NULL),
	(10000016, 10000001, 'PW21A-AC100016BL-All', 100016, 'PHILLIP COIN CASE', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 42, 1, 'Piece', '2021-04-15 11:52:51.000015', '2021-04-15 11:52:51.000015', NULL),
	(10000017, 10000001, 'PW21A-AC100017BL-All', 100017, 'DEMAND FREEDOM COIN CASE', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 40, 1, 'Piece', '2021-04-15 11:52:51.000016', '2021-04-15 11:52:51.000016', NULL),
	(10000018, 10000001, 'PW21A-BG100018WT-All', 100018, 'SPENCER WAISTBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 30, 1, 'Piece', '2021-04-15 11:52:51.000017', '2021-04-15 11:52:51.000017', NULL),
	(10000019, 10000001, 'PW21A-BG100019BL-All', 100019, 'OLIVER WAISTBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 63, 1, 'Piece', '2021-04-15 11:52:51.000018', '2021-04-15 11:52:51.000018', NULL),
	(10000020, 10000001, 'PW21A-BG100020BL-All', 100020, 'JOHNSON WAISTBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 66, 1, 'Piece', '2021-04-15 11:52:51.000019', '2021-04-15 11:52:51.000019', NULL),
	(10000021, 10000001, 'PW21A-BG100021BL-All', 100021, 'URBAN BACKPACK', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000020', '2021-04-15 11:52:51.000020', NULL),
	(10000022, 10000001, 'PW21A-BG100022BL-All', 100022, 'XJ-030 WAISTBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000021', '2021-04-15 11:52:51.000021', NULL),
	(10000023, 10000001, 'PW21A-BG100023BL-All', 100023, 'XJ-077 SLINGBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.000022', '2021-04-15 11:52:51.000022', NULL),
	(10000024, 10000001, 'PW21A-BG100024BL-All', 100024, 'XJ-012 HOLSTER', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 38, 1, 'Piece', '2021-04-15 11:52:51.000023', '2021-04-15 11:52:51.000023', NULL),
	(10000025, 10000001, 'PW21A-BG100025BL-All', 100025, 'XJ-069 MESSENGER', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 47, 1, 'Piece', '2021-04-15 11:52:51.000024', '2021-04-15 11:52:51.000024', NULL),
	(10000026, 10000001, 'PW21A-BG100026CM-All', 100026, 'XJ-012 HOLSTER GREY', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 28, 1, 'Piece', '2021-04-15 11:52:51.000025', '2021-04-15 11:52:51.000025', NULL),
	(10000027, 10000001, 'PW21A-BG100027CM-All', 100027, 'XJ-012 HOLSTER ARMY', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 33, 1, 'Piece', '2021-04-15 11:52:51.000026', '2021-04-15 11:52:51.000026', NULL),
	(10000028, 10000001, 'PW21A-BG100028CM-All', 100028, '2 IN 1 BACKPACK GREY', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.000027', '2021-04-15 11:52:51.000027', NULL),
	(10000029, 10000001, 'PW21A-BG100029CM-All', 100029, '2 IN 1 BACKPACK GREEN', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.000028', '2021-04-15 11:52:51.000028', NULL),
	(10000030, 10000001, 'PW21A-BG100030BL-All', 100030, 'XJ-099 3 LAYER SLINGBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.000029', '2021-04-15 11:52:51.000029', NULL),
	(10000031, 10000001, 'PW21A-BG100031BL-All', 100031, 'URBAN TRAVEL BAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000030', '2021-04-15 11:52:51.000030', NULL),
	(10000032, 10000001, 'PW21A-BG100032BL-All', 100032, 'LOGO TOTE BAG YELLOW', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000031', '2021-04-15 11:52:51.000031', NULL),
	(10000033, 10000001, 'PW21A-BG100033BL-All', 100033, 'LOGO TOTE BAG WHITE', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000032', '2021-04-15 11:52:51.000032', NULL),
	(10000034, 10000001, 'PW21A-BG100034BL-All', 100034, 'CLASSIC LOGO TOTE BAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000033', '2021-04-15 11:52:51.000033', NULL),
	(10000035, 10000001, 'PW21A-BG100035BL-All', 100035, 'RIVERA BACKPACK', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 40, 1, 'Piece', '2021-04-15 11:52:51.000034', '2021-04-15 11:52:51.000034', NULL),
	(10000036, 10000001, 'PW21A-BG100036BL-All', 100036, 'PATHFINDER BACKPACK', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000035', '2021-04-15 11:52:51.000035', NULL),
	(10000037, 10000001, 'PW21A-BG100037OG-All', 100037, 'STING RAY', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 52, 1, 'Piece', '2021-04-15 11:52:51.000036', '2021-04-15 11:52:51.000036', NULL),
	(10000038, 10000001, 'PW21A-BG100038BL-All', 100038, 'SHELBY', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 184, 1, 'Piece', '2021-04-15 11:52:51.000037', '2021-04-15 11:52:51.000037', NULL),
	(10000039, 10000001, 'PW21A-BG100039GN-All', 100039, 'CABRIO', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 42, 1, 'Piece', '2021-04-15 11:52:51.000038', '2021-04-15 11:52:51.000038', NULL),
	(10000040, 10000001, 'PW21A-BG100040WT-All', 100040, 'ELEANOR', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 56, 1, 'Piece', '2021-04-15 11:52:51.000039', '2021-04-15 11:52:51.000039', NULL),
	(10000041, 10000001, 'PW21A-BG100041BL-All', 100041, 'BIKE POUCH', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 33, 1, 'Piece', '2021-04-15 11:52:51.000040', '2021-04-15 11:52:51.000040', NULL),
	(10000042, 10000001, 'PW21A-BG100042BL-All', 100042, 'MARINO BAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 33, 1, 'Piece', '2021-04-15 11:52:51.000041', '2021-04-15 11:52:51.000041', NULL),
	(10000043, 10000001, 'PW21A-BG100043BL-All', 100043, 'FLOYD WAISTBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 58, 1, 'Piece', '2021-04-15 11:52:51.000042', '2021-04-15 11:52:51.000042', NULL),
	(10000044, 10000001, 'PW21A-BG100044BL-All', 100044, 'HAMILTON POUCH', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 256, 1, 'Piece', '2021-04-15 11:52:51.000043', '2021-04-15 11:52:51.000043', NULL),
	(10000045, 10000001, 'PW21A-BG100045BL-All', 100045, 'JAVAS SLINGBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 43, 1, 'Piece', '2021-04-15 11:52:51.000044', '2021-04-15 11:52:51.000044', NULL),
	(10000046, 10000001, 'PW21A-BG100046BL-All', 100046, 'SPECTER TOTEBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 49, 1, 'Piece', '2021-04-15 11:52:51.000045', '2021-04-15 11:52:51.000045', NULL),
	(10000047, 10000001, 'PW21A-BG100047BL-All', 100047, 'STRATO BACKPACK', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 53, 1, 'Piece', '2021-04-15 11:52:51.000046', '2021-04-15 11:52:51.000046', NULL),
	(10000048, 10000001, 'PW21A-BG100048BL-All', 100048, 'JAMES SLINGBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 82, 1, 'Piece', '2021-04-15 11:52:51.000047', '2021-04-15 11:52:51.000047', NULL),
	(10000049, 10000001, 'PW21A-BG100049BL-All', 100049, 'SMALL LAPTOP CASE', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 32, 1, 'Piece', '2021-04-15 11:52:51.000048', '2021-04-15 11:52:51.000048', NULL),
	(10000050, 10000001, 'PW21A-BG100050BL-All', 100050, 'LARGE LAPTOP CASE', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 40, 1, 'Piece', '2021-04-15 11:52:51.000049', '2021-04-15 11:52:51.000049', NULL),
	(10000051, 10000001, 'PW21A-BG100051BL-All', 100051, 'SMITH', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 42, 1, 'Piece', '2021-04-15 11:52:51.000050', '2021-04-15 11:52:51.000050', NULL),
	(10000052, 10000001, 'PW21A-BG100052BL-All', 100052, 'HYBRID WP', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 39, 1, 'Piece', '2021-04-15 11:52:51.000051', '2021-04-15 11:52:51.000051', NULL),
	(10000053, 10000001, 'PW21A-BG100053BL-All', 100053, 'RUNNING PACK', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 47, 1, 'Piece', '2021-04-15 11:52:51.000052', '2021-04-15 11:52:51.000052', NULL),
	(10000054, 10000001, 'PW21A-BG100054BL-All', 100054, 'PATHFINDER BACKPACK 2.0', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000053', '2021-04-15 11:52:51.000053', NULL),
	(10000055, 10000001, 'PW21A-GL100055YW -S', 100055, 'YELLOW BANDIT', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000054', '2021-04-15 11:52:51.000054', NULL),
	(10000056, 10000001, 'PW21A-GL100055YW -M', 100055, 'YELLOW BANDIT', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000055', '2021-04-15 11:52:51.000055', NULL),
	(10000057, 10000001, 'PW21A-GL100055YW -L', 100055, 'YELLOW BANDIT', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000056', '2021-04-15 11:52:51.000056', NULL),
	(10000058, 10000001, 'PW21A-GL100055YW -XL', 100055, 'YELLOW BANDIT', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000057', '2021-04-15 11:52:51.000057', NULL),
	(10000059, 10000001, 'PW21A-GL100056BW-S', 100056, 'ROAD RUNNER', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000058', '2021-04-15 11:52:51.000058', NULL),
	(10000060, 10000001, 'PW21A-GL100056BW-M', 100056, 'ROAD RUNNER', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000059', '2021-04-15 11:52:51.000059', NULL),
	(10000061, 10000001, 'PW21A-GL100056BW-L', 100056, 'ROAD RUNNER', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000060', '2021-04-15 11:52:51.000060', NULL),
	(10000062, 10000001, 'PW21A-GL100056BW-XL', 100056, 'ROAD RUNNER', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000061', '2021-04-15 11:52:51.000061', NULL),
	(10000063, 10000001, 'PW21A-GL100057CM-S', 100057, 'BOLD HUNTER', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000062', '2021-04-15 11:52:51.000062', NULL),
	(10000064, 10000001, 'PW21A-GL100057CM-M', 100057, 'BOLD HUNTER', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000063', '2021-04-15 11:52:51.000063', NULL),
	(10000065, 10000001, 'PW21A-GL100057CM-L', 100057, 'BOLD HUNTER', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000064', '2021-04-15 11:52:51.000064', NULL),
	(10000066, 10000001, 'PW21A-GL100057CM-XL', 100057, 'BOLD HUNTER', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000065', '2021-04-15 11:52:51.000065', NULL),
	(10000067, 10000001, 'PW21A-GL100058BW-S', 100058, 'MAD GREASER', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000066', '2021-04-15 11:52:51.000066', NULL),
	(10000068, 10000001, 'PW21A-GL100058BW-M', 100058, 'MAD GREASER', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000067', '2021-04-15 11:52:51.000067', NULL),
	(10000069, 10000001, 'PW21A-GL100058BW-L', 100058, 'MAD GREASER', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000068', '2021-04-15 11:52:51.000068', NULL),
	(10000070, 10000001, 'PW21A-GL100058BW-XL', 100058, 'MAD GREASER', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000069', '2021-04-15 11:52:51.000069', NULL),
	(10000071, 10000001, 'PW21A-GL100059BL-S', 100059, 'HITMAN', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000070', '2021-04-15 11:52:51.000070', NULL),
	(10000072, 10000001, 'PW21A-GL100059BL-M', 100059, 'HITMAN', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000071', '2021-04-15 11:52:51.000071', NULL),
	(10000073, 10000001, 'PW21A-GL100059BL-L', 100059, 'HITMAN', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000072', '2021-04-15 11:52:51.000072', NULL),
	(10000074, 10000001, 'PW21A-GL100059BL-XL', 100059, 'HITMAN', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000073', '2021-04-15 11:52:51.000073', NULL),
	(10000075, 10000001, 'PW21A-GL100060BL-S', 100060, 'DARE DEVIL', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000074', '2021-04-15 11:52:51.000074', NULL),
	(10000076, 10000001, 'PW21A-GL100060BL-M', 100060, 'DARE DEVIL', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000075', '2021-04-15 11:52:51.000075', NULL),
	(10000077, 10000001, 'PW21A-GL100060BL-L', 100060, 'DARE DEVIL', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000076', '2021-04-15 11:52:51.000076', NULL),
	(10000078, 10000001, 'PW21A-GL100060BL-XL', 100060, 'DARE DEVIL', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000077', '2021-04-15 11:52:51.000077', NULL),
	(10000079, 10000001, 'PW21A-GL100061RD-S', 100061, 'DARK INFERNO', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000078', '2021-04-15 11:52:51.000078', NULL),
	(10000080, 10000001, 'PW21A-GL100061RD-M', 100061, 'DARK INFERNO', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000079', '2021-04-15 11:52:51.000079', NULL),
	(10000081, 10000001, 'PW21A-GL100061RD-L', 100061, 'DARK INFERNO', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000080', '2021-04-15 11:52:51.000080', NULL),
	(10000082, 10000001, 'PW21A-GL100061RD-XL', 100061, 'DARK INFERNO', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000081', '2021-04-15 11:52:51.000081', NULL),
	(10000083, 10000001, 'PW21A-GL100062WT-S', 100062, 'HURRICANE', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000082', '2021-04-15 11:52:51.000082', NULL),
	(10000084, 10000001, 'PW21A-GL100062WT-M', 100062, 'HURRICANE', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000083', '2021-04-15 11:52:51.000083', NULL),
	(10000085, 10000001, 'PW21A-GL100062WT-L', 100062, 'HURRICANE', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.000084', '2021-04-15 11:52:51.000084', NULL),
	(10000086, 10000001, 'PW21A-GL100062WT-XL', 100062, 'HURRICANE', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000085', '2021-04-15 11:52:51.000085', NULL),
	(10000087, 10000001, 'PW21A-GL100063BW-S', 100063, 'CRUSADER', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000086', '2021-04-15 11:52:51.000086', NULL),
	(10000088, 10000001, 'PW21A-GL100063BW-M', 100063, 'CRUSADER', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000087', '2021-04-15 11:52:51.000087', NULL),
	(10000089, 10000001, 'PW21A-GL100063BW-L', 100063, 'CRUSADER', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000088', '2021-04-15 11:52:51.000088', NULL),
	(10000090, 10000001, 'PW21A-GL100063BW-XL', 100063, 'CRUSADER', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000089', '2021-04-15 11:52:51.000089', NULL),
	(10000091, 10000001, 'PW21A-GL100064WT-S', 100064, 'MARK I', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000090', '2021-04-15 11:52:51.000090', NULL),
	(10000092, 10000001, 'PW21A-GL100064WT-M', 100064, 'MARK I', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000091', '2021-04-15 11:52:51.000091', NULL),
	(10000093, 10000001, 'PW21A-GL100064WT-L', 100064, 'MARK I', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000092', '2021-04-15 11:52:51.000092', NULL),
	(10000094, 10000001, 'PW21A-GL100064WT-XL', 100064, 'MARK I', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000093', '2021-04-15 11:52:51.000093', NULL),
	(10000095, 10000001, 'PW21A-GL100065BL-S', 100065, 'MARK II', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000094', '2021-04-15 11:52:51.000094', NULL),
	(10000096, 10000001, 'PW21A-GL100065BL-M', 100065, 'MARK II', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000095', '2021-04-15 11:52:51.000095', NULL),
	(10000097, 10000001, 'PW21A-GL100065BL-L', 100065, 'MARK II', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000096', '2021-04-15 11:52:51.000096', NULL),
	(10000098, 10000001, 'PW21A-GL100065BL-XL', 100065, 'MARK II', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000097', '2021-04-15 11:52:51.000097', NULL),
	(10000099, 10000001, 'PW21A-GL100066YW -S', 100066, 'DAYTONA', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000098', '2021-04-15 11:52:51.000098', NULL),
	(10000100, 10000001, 'PW21A-GL100066YW -M', 100066, 'DAYTONA', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000099', '2021-04-15 11:52:51.000099', NULL),
	(10000101, 10000001, 'PW21A-GL100066YW -L', 100066, 'DAYTONA', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000100', '2021-04-15 11:52:51.000100', NULL),
	(10000102, 10000001, 'PW21A-GL100066YW -XL', 100066, 'DAYTONA', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000101', '2021-04-15 11:52:51.000101', NULL),
	(10000103, 10000001, 'PW21A-GL100067BW-S', 100067, 'DOMINATOR', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000102', '2021-04-15 11:52:51.000102', NULL),
	(10000104, 10000001, 'PW21A-GL100067BW-M', 100067, 'DOMINATOR', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000103', '2021-04-15 11:52:51.000103', NULL),
	(10000105, 10000001, 'PW21A-GL100067BW-L', 100067, 'DOMINATOR', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000104', '2021-04-15 11:52:51.000104', NULL),
	(10000106, 10000001, 'PW21A-GL100067BW-XL', 100067, 'DOMINATOR', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000105', '2021-04-15 11:52:51.000105', NULL),
	(10000107, 10000001, 'PW21A-HT100068BL-All', 100068, 'BLACK COBRA TRUCKER', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 33, 1, 'Piece', '2021-04-15 11:52:51.000106', '2021-04-15 11:52:51.000106', NULL),
	(10000108, 10000001, 'PW21A-HT100069BL-All', 100069, 'SIGNATURE TRUCKER', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000107', '2021-04-15 11:52:51.000107', NULL),
	(10000109, 10000001, 'PW21A-HT100070BL-All', 100070, 'EAGLE SNAKE TRUCKER', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000108', '2021-04-15 11:52:51.000108', NULL),
	(10000110, 10000001, 'PW21A-HT100071BL-All', 100071, 'IRON BEAST', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000109', '2021-04-15 11:52:51.000109', NULL),
	(10000111, 10000001, 'PW21A-HT100072BL-All', 100072, 'PARTS AND BUILD 2.0', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000110', '2021-04-15 11:52:51.000110', NULL),
	(10000112, 10000001, 'PW21A-HT100073BL-All', 100073, 'GARAGE TRUCKER', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000111', '2021-04-15 11:52:51.000111', NULL),
	(10000113, 10000001, 'PW21A-HT100074BL-All', 100074, 'PIRATE TRUCKER', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000112', '2021-04-15 11:52:51.000112', NULL),
	(10000114, 10000001, 'PW21A-HT100075BL-All', 100075, 'TROOPER TRUCKER', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000113', '2021-04-15 11:52:51.000113', NULL),
	(10000115, 10000001, 'PW21A-HT100076BL-All', 100076, 'WING TRUCKER 2.0', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000114', '2021-04-15 11:52:51.000114', NULL),
	(10000116, 10000001, 'PW21A-HT100077BL-All', 100077, 'EQUADOR', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.000115', '2021-04-15 11:52:51.000115', NULL),
	(10000117, 10000001, 'PW21A-HT100078BL-All', 100078, 'SHALLOW CAP', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 28, 1, 'Piece', '2021-04-15 11:52:51.000116', '2021-04-15 11:52:51.000116', NULL),
	(10000118, 10000001, 'PW21A-HT100079AR-All', 100079, 'DELTA CAP ARMY', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 40, 1, 'Piece', '2021-04-15 11:52:51.000117', '2021-04-15 11:52:51.000117', NULL),
	(10000119, 10000001, 'PW21A-HT100080BL-All', 100080, 'DELTA CAP BLACK', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 41, 1, 'Piece', '2021-04-15 11:52:51.000118', '2021-04-15 11:52:51.000118', NULL),
	(10000120, 10000001, 'PW21A-HT100081CM-All', 100081, 'DELTA CAP ARMY CAMO', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 41, 1, 'Piece', '2021-04-15 11:52:51.000119', '2021-04-15 11:52:51.000119', NULL),
	(10000121, 10000001, 'PW21A-HT100082DS-All', 100082, 'DELTA CAP ARMY DESERT', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 49, 1, 'Piece', '2021-04-15 11:52:51.000120', '2021-04-15 11:52:51.000120', NULL),
	(10000122, 10000001, 'PW21A-HT100083CM-All', 100083, 'EQUADOR CAMO', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 43, 1, 'Piece', '2021-04-15 11:52:51.000121', '2021-04-15 11:52:51.000121', NULL),
	(10000123, 10000001, 'PW21A-HT100084DS-All', 100084, 'EQUADOR DESERT', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 47, 1, 'Piece', '2021-04-15 11:52:51.000122', '2021-04-15 11:52:51.000122', NULL),
	(10000124, 10000001, 'PW21A-HT100085MR-All', 100085, 'SHALLOW MAROON', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 51, 1, 'Piece', '2021-04-15 11:52:51.000123', '2021-04-15 11:52:51.000123', NULL),
	(10000125, 10000001, 'PW21A-HT100086NV-All', 100086, 'SHALLOW NAVY', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 45, 1, 'Piece', '2021-04-15 11:52:51.000124', '2021-04-15 11:52:51.000124', NULL),
	(10000126, 10000001, 'PW21A-HT100087BL-All', 100087, 'SIGNATURE TRUCKER 2.0', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 98, 1, 'Piece', '2021-04-15 11:52:51.000125', '2021-04-15 11:52:51.000125', NULL),
	(10000127, 10000001, 'PW21A-HT100088NV-All', 100088, 'HIGHWAY CAP NAVY', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000126', '2021-04-15 11:52:51.000126', NULL),
	(10000128, 10000001, 'PW21A-HT100089RD-All', 100089, 'HIGHWAY CAP RED', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000127', '2021-04-15 11:52:51.000127', NULL),
	(10000129, 10000001, 'PW21A-HT100090BL-All', 100090, 'PETROL TRUCKER BLACK', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000128', '2021-04-15 11:52:51.000128', NULL),
	(10000130, 10000001, 'PW21A-HT100091RD-All', 100091, 'PETROL TRUCKER RED', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000129', '2021-04-15 11:52:51.000129', NULL),
	(10000131, 10000001, 'PW21A-JK100092BL-XS', 100092, 'BLACK VIPER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000130', '2021-04-15 11:52:51.000130', NULL),
	(10000132, 10000001, 'PW21A-JK100092BL-S', 100092, 'BLACK VIPER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000131', '2021-04-15 11:52:51.000131', NULL),
	(10000133, 10000001, 'PW21A-JK100092BL-M', 100092, 'BLACK VIPER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000132', '2021-04-15 11:52:51.000132', NULL),
	(10000134, 10000001, 'PW21A-JK100092BL-L', 100092, 'BLACK VIPER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000133', '2021-04-15 11:52:51.000133', NULL),
	(10000135, 10000001, 'PW21A-JK100092BL-XL', 100092, 'BLACK VIPER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000134', '2021-04-15 11:52:51.000134', NULL),
	(10000136, 10000001, 'PW21A-JK100092BL-XXL', 100092, 'BLACK VIPER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000135', '2021-04-15 11:52:51.000135', NULL),
	(10000137, 10000001, 'PW21A-JK100093BL-XS', 100093, 'BLACK FALCON', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000136', '2021-04-15 11:52:51.000136', NULL),
	(10000138, 10000001, 'PW21A-JK100093BL-S', 100093, 'BLACK FALCON', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000137', '2021-04-15 11:52:51.000137', NULL),
	(10000139, 10000001, 'PW21A-JK100093BL-M', 100093, 'BLACK FALCON', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000138', '2021-04-15 11:52:51.000138', NULL),
	(10000140, 10000001, 'PW21A-JK100093BL-L', 100093, 'BLACK FALCON', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000139', '2021-04-15 11:52:51.000139', NULL),
	(10000141, 10000001, 'PW21A-JK100093BL-XL', 100093, 'BLACK FALCON', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000140', '2021-04-15 11:52:51.000140', NULL),
	(10000142, 10000001, 'PW21A-JK100093BL-XXL', 100093, 'BLACK FALCON', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000141', '2021-04-15 11:52:51.000141', NULL),
	(10000143, 10000001, 'PW21A-JK100094GY-XS', 100094, 'THE BRAVE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000142', '2021-04-15 11:52:51.000142', NULL),
	(10000144, 10000001, 'PW21A-JK100094GY-S', 100094, 'THE BRAVE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.000143', '2021-04-15 11:52:51.000143', NULL),
	(10000145, 10000001, 'PW21A-JK100094GY-M', 100094, 'THE BRAVE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000144', '2021-04-15 11:52:51.000144', NULL),
	(10000146, 10000001, 'PW21A-JK100094GY-L', 100094, 'THE BRAVE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.000145', '2021-04-15 11:52:51.000145', NULL),
	(10000147, 10000001, 'PW21A-JK100094GY-XL', 100094, 'THE BRAVE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000146', '2021-04-15 11:52:51.000146', NULL),
	(10000148, 10000001, 'PW21A-JK100094GY-XXL', 100094, 'THE BRAVE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000147', '2021-04-15 11:52:51.000147', NULL),
	(10000149, 10000001, 'PW21A-JK100095AR-XS', 100095, 'NEVER LOST', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000148', '2021-04-15 11:52:51.000148', NULL),
	(10000150, 10000001, 'PW21A-JK100095AR-S', 100095, 'NEVER LOST', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000149', '2021-04-15 11:52:51.000149', NULL),
	(10000151, 10000001, 'PW21A-JK100095AR-M', 100095, 'NEVER LOST', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000150', '2021-04-15 11:52:51.000150', NULL),
	(10000152, 10000001, 'PW21A-JK100095AR-L', 100095, 'NEVER LOST', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.000151', '2021-04-15 11:52:51.000151', NULL),
	(10000153, 10000001, 'PW21A-JK100095AR-XL', 100095, 'NEVER LOST', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000152', '2021-04-15 11:52:51.000152', NULL),
	(10000154, 10000001, 'PW21A-JK100095AR-XXL', 100095, 'NEVER LOST', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000153', '2021-04-15 11:52:51.000153', NULL),
	(10000155, 10000001, 'PW21A-JK100096BL-XS', 100096, 'UNRIVALED', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000154', '2021-04-15 11:52:51.000154', NULL),
	(10000156, 10000001, 'PW21A-JK100096BL-S', 100096, 'UNRIVALED', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.000155', '2021-04-15 11:52:51.000155', NULL),
	(10000157, 10000001, 'PW21A-JK100096BL-M', 100096, 'UNRIVALED', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000156', '2021-04-15 11:52:51.000156', NULL),
	(10000158, 10000001, 'PW21A-JK100096BL-L', 100096, 'UNRIVALED', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.000157', '2021-04-15 11:52:51.000157', NULL),
	(10000159, 10000001, 'PW21A-JK100096BL-XL', 100096, 'UNRIVALED', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.000158', '2021-04-15 11:52:51.000158', NULL),
	(10000160, 10000001, 'PW21A-JK100096BL-XXL', 100096, 'UNRIVALED', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.000159', '2021-04-15 11:52:51.000159', NULL),
	(10000161, 10000001, 'PW21A-JK100097WT-XS', 100097, 'PRIDE OF INDONESIA', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000160', '2021-04-15 11:52:51.000160', NULL),
	(10000162, 10000001, 'PW21A-JK100097WT-S', 100097, 'PRIDE OF INDONESIA', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 48, 1, 'Piece', '2021-04-15 11:52:51.000161', '2021-04-15 11:52:51.000161', NULL),
	(10000163, 10000001, 'PW21A-JK100097WT-M', 100097, 'PRIDE OF INDONESIA', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 50, 1, 'Piece', '2021-04-15 11:52:51.000162', '2021-04-15 11:52:51.000162', NULL),
	(10000164, 10000001, 'PW21A-JK100097WT-L', 100097, 'PRIDE OF INDONESIA', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 60, 1, 'Piece', '2021-04-15 11:52:51.000163', '2021-04-15 11:52:51.000163', NULL),
	(10000165, 10000001, 'PW21A-JK100097WT-XL', 100097, 'PRIDE OF INDONESIA', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 41, 1, 'Piece', '2021-04-15 11:52:51.000164', '2021-04-15 11:52:51.000164', NULL),
	(10000166, 10000001, 'PW21A-JK100097WT-XXL', 100097, 'PRIDE OF INDONESIA', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.000165', '2021-04-15 11:52:51.000165', NULL),
	(10000167, 10000001, 'PW21A-JK100098BL-XS', 100098, 'CHRYSANT DEMON WINDBREAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000166', '2021-04-15 11:52:51.000166', NULL),
	(10000168, 10000001, 'PW21A-JK100098BL-S', 100098, 'CHRYSANT DEMON WINDBREAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000167', '2021-04-15 11:52:51.000167', NULL),
	(10000169, 10000001, 'PW21A-JK100098BL-M', 100098, 'CHRYSANT DEMON WINDBREAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000168', '2021-04-15 11:52:51.000168', NULL),
	(10000170, 10000001, 'PW21A-JK100098BL-L', 100098, 'CHRYSANT DEMON WINDBREAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.000169', '2021-04-15 11:52:51.000169', NULL),
	(10000171, 10000001, 'PW21A-JK100098BL-XL', 100098, 'CHRYSANT DEMON WINDBREAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000170', '2021-04-15 11:52:51.000170', NULL),
	(10000172, 10000001, 'PW21A-JK100098BL-XXL', 100098, 'CHRYSANT DEMON WINDBREAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000171', '2021-04-15 11:52:51.000171', NULL),
	(10000173, 10000001, 'PW21A-JK100099BL-XS', 100099, 'BLACK EAGLE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000172', '2021-04-15 11:52:51.000172', NULL),
	(10000174, 10000001, 'PW21A-JK100099BL-S', 100099, 'BLACK EAGLE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000173', '2021-04-15 11:52:51.000173', NULL),
	(10000175, 10000001, 'PW21A-JK100099BL-M', 100099, 'BLACK EAGLE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000174', '2021-04-15 11:52:51.000174', NULL),
	(10000176, 10000001, 'PW21A-JK100099BL-L', 100099, 'BLACK EAGLE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000175', '2021-04-15 11:52:51.000175', NULL),
	(10000177, 10000001, 'PW21A-JK100099BL-XL', 100099, 'BLACK EAGLE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000176', '2021-04-15 11:52:51.000176', NULL),
	(10000178, 10000001, 'PW21A-JK100099BL-XXL', 100099, 'BLACK EAGLE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000177', '2021-04-15 11:52:51.000177', NULL),
	(10000179, 10000001, 'PW21A-JK100100DM-XS', 100100, 'LIBERATOR DENIM', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000178', '2021-04-15 11:52:51.000178', NULL),
	(10000180, 10000001, 'PW21A-JK100100DM-S', 100100, 'LIBERATOR DENIM', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000179', '2021-04-15 11:52:51.000179', NULL),
	(10000181, 10000001, 'PW21A-JK100100DM-M', 100100, 'LIBERATOR DENIM', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000180', '2021-04-15 11:52:51.000180', NULL),
	(10000182, 10000001, 'PW21A-JK100100DM-L', 100100, 'LIBERATOR DENIM', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000181', '2021-04-15 11:52:51.000181', NULL),
	(10000183, 10000001, 'PW21A-JK100100DM-XL', 100100, 'LIBERATOR DENIM', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000182', '2021-04-15 11:52:51.000182', NULL),
	(10000184, 10000001, 'PW21A-JK100100DM-XXL', 100100, 'LIBERATOR DENIM', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000183', '2021-04-15 11:52:51.000183', NULL),
	(10000185, 10000001, 'PW21A-JK100101NV-XS', 100101, 'INTERCEPTOR RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000184', '2021-04-15 11:52:51.000184', NULL),
	(10000186, 10000001, 'PW21A-JK100101NV-S', 100101, 'INTERCEPTOR RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000185', '2021-04-15 11:52:51.000185', NULL),
	(10000187, 10000001, 'PW21A-JK100101NV-M', 100101, 'INTERCEPTOR RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000186', '2021-04-15 11:52:51.000186', NULL),
	(10000188, 10000001, 'PW21A-JK100101NV-L', 100101, 'INTERCEPTOR RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000187', '2021-04-15 11:52:51.000187', NULL),
	(10000189, 10000001, 'PW21A-JK100101NV-XL', 100101, 'INTERCEPTOR RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000188', '2021-04-15 11:52:51.000188', NULL),
	(10000190, 10000001, 'PW21A-JK100101NV-XXL', 100101, 'INTERCEPTOR RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000189', '2021-04-15 11:52:51.000189', NULL),
	(10000191, 10000001, 'PW21A-JK100102BW-XS', 100102, 'BRADFORD JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000190', '2021-04-15 11:52:51.000190', NULL),
	(10000192, 10000001, 'PW21A-JK100102BW-S', 100102, 'BRADFORD JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000191', '2021-04-15 11:52:51.000191', NULL),
	(10000193, 10000001, 'PW21A-JK100102BW-M', 100102, 'BRADFORD JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000192', '2021-04-15 11:52:51.000192', NULL),
	(10000194, 10000001, 'PW21A-JK100102BW-L', 100102, 'BRADFORD JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000193', '2021-04-15 11:52:51.000193', NULL),
	(10000195, 10000001, 'PW21A-JK100102BW-XL', 100102, 'BRADFORD JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000194', '2021-04-15 11:52:51.000194', NULL),
	(10000196, 10000001, 'PW21A-JK100102BW-XXL', 100102, 'BRADFORD JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000195', '2021-04-15 11:52:51.000195', NULL),
	(10000197, 10000001, 'PW21A-JK100103BL-XS', 100103, 'RIDE OR DIE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000196', '2021-04-15 11:52:51.000196', NULL),
	(10000198, 10000001, 'PW21A-JK100103BL-S', 100103, 'RIDE OR DIE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000197', '2021-04-15 11:52:51.000197', NULL),
	(10000199, 10000001, 'PW21A-JK100103BL-M', 100103, 'RIDE OR DIE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000198', '2021-04-15 11:52:51.000198', NULL),
	(10000200, 10000001, 'PW21A-JK100103BL-L', 100103, 'RIDE OR DIE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000199', '2021-04-15 11:52:51.000199', NULL),
	(10000201, 10000001, 'PW21A-JK100103BL-XL', 100103, 'RIDE OR DIE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000200', '2021-04-15 11:52:51.000200', NULL),
	(10000202, 10000001, 'PW21A-JK100103BL-XXL', 100103, 'RIDE OR DIE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000201', '2021-04-15 11:52:51.000201', NULL),
	(10000203, 10000001, 'PW21A-JK100104BL-XS', 100104, 'MC CARTHY PARKA 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000202', '2021-04-15 11:52:51.000202', NULL),
	(10000204, 10000001, 'PW21A-JK100104BL-S', 100104, 'MC CARTHY PARKA 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.000203', '2021-04-15 11:52:51.000203', NULL),
	(10000205, 10000001, 'PW21A-JK100104BL-M', 100104, 'MC CARTHY PARKA 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000204', '2021-04-15 11:52:51.000204', NULL),
	(10000206, 10000001, 'PW21A-JK100104BL-L', 100104, 'MC CARTHY PARKA 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000205', '2021-04-15 11:52:51.000205', NULL),
	(10000207, 10000001, 'PW21A-JK100104BL-XL', 100104, 'MC CARTHY PARKA 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000206', '2021-04-15 11:52:51.000206', NULL),
	(10000208, 10000001, 'PW21A-JK100104BL-XXL', 100104, 'MC CARTHY PARKA 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000207', '2021-04-15 11:52:51.000207', NULL),
	(10000209, 10000001, 'PW21A-JK100105TC-XS', 100105, 'NIPPON 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000208', '2021-04-15 11:52:51.000208', NULL),
	(10000210, 10000001, 'PW21A-JK100105TC-S', 100105, 'NIPPON 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000209', '2021-04-15 11:52:51.000209', NULL),
	(10000211, 10000001, 'PW21A-JK100105TC-M', 100105, 'NIPPON 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000210', '2021-04-15 11:52:51.000210', NULL),
	(10000212, 10000001, 'PW21A-JK100105TC-L', 100105, 'NIPPON 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000211', '2021-04-15 11:52:51.000211', NULL),
	(10000213, 10000001, 'PW21A-JK100105TC-XL', 100105, 'NIPPON 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000212', '2021-04-15 11:52:51.000212', NULL),
	(10000214, 10000001, 'PW21A-JK100105TC-XXL', 100105, 'NIPPON 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000213', '2021-04-15 11:52:51.000213', NULL),
	(10000215, 10000001, 'PW21A-JK100106BL-XS', 100106, 'ROAD HUNTER WINDBREAKER 3', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000214', '2021-04-15 11:52:51.000214', NULL),
	(10000216, 10000001, 'PW21A-JK100106BL-S', 100106, 'ROAD HUNTER WINDBREAKER 3', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000215', '2021-04-15 11:52:51.000215', NULL),
	(10000217, 10000001, 'PW21A-JK100106BL-M', 100106, 'ROAD HUNTER WINDBREAKER 3', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000216', '2021-04-15 11:52:51.000216', NULL),
	(10000218, 10000001, 'PW21A-JK100106BL-L', 100106, 'ROAD HUNTER WINDBREAKER 3', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.000217', '2021-04-15 11:52:51.000217', NULL),
	(10000219, 10000001, 'PW21A-JK100106BL-XL', 100106, 'ROAD HUNTER WINDBREAKER 3', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000218', '2021-04-15 11:52:51.000218', NULL),
	(10000220, 10000001, 'PW21A-JK100106BL-XXL', 100106, 'ROAD HUNTER WINDBREAKER 3', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000219', '2021-04-15 11:52:51.000219', NULL),
	(10000221, 10000001, 'PW21A-JK100107BL-XS', 100107, 'PW MC WINDBEAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000220', '2021-04-15 11:52:51.000220', NULL),
	(10000222, 10000001, 'PW21A-JK100107BL-S', 100107, 'PW MC WINDBEAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000221', '2021-04-15 11:52:51.000221', NULL),
	(10000223, 10000001, 'PW21A-JK100107BL-M', 100107, 'PW MC WINDBEAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000222', '2021-04-15 11:52:51.000222', NULL),
	(10000224, 10000001, 'PW21A-JK100107BL-L', 100107, 'PW MC WINDBEAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000223', '2021-04-15 11:52:51.000223', NULL),
	(10000225, 10000001, 'PW21A-JK100107BL-XL', 100107, 'PW MC WINDBEAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000224', '2021-04-15 11:52:51.000224', NULL),
	(10000226, 10000001, 'PW21A-JK100107BL-XXL', 100107, 'PW MC WINDBEAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000225', '2021-04-15 11:52:51.000225', NULL),
	(10000227, 10000001, 'PW21A-JK100108BL-XS', 100108, 'BORN TO RIDE 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000226', '2021-04-15 11:52:51.000226', NULL),
	(10000228, 10000001, 'PW21A-JK100108BL-S', 100108, 'BORN TO RIDE 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 26, 1, 'Piece', '2021-04-15 11:52:51.000227', '2021-04-15 11:52:51.000227', NULL),
	(10000229, 10000001, 'PW21A-JK100108BL-M', 100108, 'BORN TO RIDE 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000228', '2021-04-15 11:52:51.000228', NULL),
	(10000230, 10000001, 'PW21A-JK100108BL-L', 100108, 'BORN TO RIDE 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 26, 1, 'Piece', '2021-04-15 11:52:51.000229', '2021-04-15 11:52:51.000229', NULL),
	(10000231, 10000001, 'PW21A-JK100108BL-XL', 100108, 'BORN TO RIDE 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000230', '2021-04-15 11:52:51.000230', NULL),
	(10000232, 10000001, 'PW21A-JK100108BL-XXL', 100108, 'BORN TO RIDE 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000231', '2021-04-15 11:52:51.000231', NULL),
	(10000233, 10000001, 'PW21A-JK100109BL-XS', 100109, 'HERITAGE WINDBREAKER 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000232', '2021-04-15 11:52:51.000232', NULL),
	(10000234, 10000001, 'PW21A-JK100109BL-S', 100109, 'HERITAGE WINDBREAKER 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000233', '2021-04-15 11:52:51.000233', NULL),
	(10000235, 10000001, 'PW21A-JK100109BL-M', 100109, 'HERITAGE WINDBREAKER 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000234', '2021-04-15 11:52:51.000234', NULL),
	(10000236, 10000001, 'PW21A-JK100109BL-L', 100109, 'HERITAGE WINDBREAKER 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000235', '2021-04-15 11:52:51.000235', NULL),
	(10000237, 10000001, 'PW21A-JK100109BL-XL', 100109, 'HERITAGE WINDBREAKER 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000236', '2021-04-15 11:52:51.000236', NULL),
	(10000238, 10000001, 'PW21A-JK100109BL-XXL', 100109, 'HERITAGE WINDBREAKER 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000237', '2021-04-15 11:52:51.000237', NULL),
	(10000239, 10000001, 'PW21A-JK100110BL-XS', 100110, 'VARSITY HIGH SCHOOL', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.000238', '2021-04-15 11:52:51.000238', NULL),
	(10000240, 10000001, 'PW21A-JK100110BL-S', 100110, 'VARSITY HIGH SCHOOL', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 41, 1, 'Piece', '2021-04-15 11:52:51.000239', '2021-04-15 11:52:51.000239', NULL),
	(10000241, 10000001, 'PW21A-JK100110BL-M', 100110, 'VARSITY HIGH SCHOOL', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 47, 1, 'Piece', '2021-04-15 11:52:51.000240', '2021-04-15 11:52:51.000240', NULL),
	(10000242, 10000001, 'PW21A-JK100110BL-L', 100110, 'VARSITY HIGH SCHOOL', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 57, 1, 'Piece', '2021-04-15 11:52:51.000241', '2021-04-15 11:52:51.000241', NULL),
	(10000243, 10000001, 'PW21A-JK100110BL-XL', 100110, 'VARSITY HIGH SCHOOL', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 31, 1, 'Piece', '2021-04-15 11:52:51.000242', '2021-04-15 11:52:51.000242', NULL),
	(10000244, 10000001, 'PW21A-JK100110BL-XXL', 100110, 'VARSITY HIGH SCHOOL', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.000243', '2021-04-15 11:52:51.000243', NULL),
	(10000245, 10000001, 'PW21A-JK100111BL-XS', 100111, 'VARSITY COLLEGE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000244', '2021-04-15 11:52:51.000244', NULL),
	(10000246, 10000001, 'PW21A-JK100111BL-S', 100111, 'VARSITY COLLEGE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000245', '2021-04-15 11:52:51.000245', NULL),
	(10000247, 10000001, 'PW21A-JK100111BL-M', 100111, 'VARSITY COLLEGE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000246', '2021-04-15 11:52:51.000246', NULL),
	(10000248, 10000001, 'PW21A-JK100111BL-L', 100111, 'VARSITY COLLEGE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000247', '2021-04-15 11:52:51.000247', NULL),
	(10000249, 10000001, 'PW21A-JK100111BL-XL', 100111, 'VARSITY COLLEGE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000248', '2021-04-15 11:52:51.000248', NULL),
	(10000250, 10000001, 'PW21A-JK100111BL-XXL', 100111, 'VARSITY COLLEGE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000249', '2021-04-15 11:52:51.000249', NULL),
	(10000251, 10000001, 'PW21A-JK100112CM-XS', 100112, 'JUNGLE AERO', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000250', '2021-04-15 11:52:51.000250', NULL),
	(10000252, 10000001, 'PW21A-JK100112CM-S', 100112, 'JUNGLE AERO', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 32, 1, 'Piece', '2021-04-15 11:52:51.000251', '2021-04-15 11:52:51.000251', NULL),
	(10000253, 10000001, 'PW21A-JK100112CM-M', 100112, 'JUNGLE AERO', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 41, 1, 'Piece', '2021-04-15 11:52:51.000252', '2021-04-15 11:52:51.000252', NULL),
	(10000254, 10000001, 'PW21A-JK100112CM-L', 100112, 'JUNGLE AERO', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 43, 1, 'Piece', '2021-04-15 11:52:51.000253', '2021-04-15 11:52:51.000253', NULL),
	(10000255, 10000001, 'PW21A-JK100112CM-XL', 100112, 'JUNGLE AERO', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.000254', '2021-04-15 11:52:51.000254', NULL),
	(10000256, 10000001, 'PW21A-JK100112CM-XXL', 100112, 'JUNGLE AERO', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000255', '2021-04-15 11:52:51.000255', NULL),
	(10000257, 10000001, 'PW21A-JK100113CM-XS', 100113, 'JUNGLE SPEED', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000256', '2021-04-15 11:52:51.000256', NULL),
	(10000258, 10000001, 'PW21A-JK100113CM-S', 100113, 'JUNGLE SPEED', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 31, 1, 'Piece', '2021-04-15 11:52:51.000257', '2021-04-15 11:52:51.000257', NULL),
	(10000259, 10000001, 'PW21A-JK100113CM-M', 100113, 'JUNGLE SPEED', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 39, 1, 'Piece', '2021-04-15 11:52:51.000258', '2021-04-15 11:52:51.000258', NULL),
	(10000260, 10000001, 'PW21A-JK100113CM-L', 100113, 'JUNGLE SPEED', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 39, 1, 'Piece', '2021-04-15 11:52:51.000259', '2021-04-15 11:52:51.000259', NULL),
	(10000261, 10000001, 'PW21A-JK100113CM-XL', 100113, 'JUNGLE SPEED', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.000260', '2021-04-15 11:52:51.000260', NULL),
	(10000262, 10000001, 'PW21A-JK100113CM-XXL', 100113, 'JUNGLE SPEED', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.000261', '2021-04-15 11:52:51.000261', NULL),
	(10000263, 10000001, 'PW21A-JK100114CM-XS', 100114, 'BLACK FALCON 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000262', '2021-04-15 11:52:51.000262', NULL),
	(10000264, 10000001, 'PW21A-JK100114CM-S', 100114, 'BLACK FALCON 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000263', '2021-04-15 11:52:51.000263', NULL),
	(10000265, 10000001, 'PW21A-JK100114CM-M', 100114, 'BLACK FALCON 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000264', '2021-04-15 11:52:51.000264', NULL),
	(10000266, 10000001, 'PW21A-JK100114CM-L', 100114, 'BLACK FALCON 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.000265', '2021-04-15 11:52:51.000265', NULL),
	(10000267, 10000001, 'PW21A-JK100114CM-XL', 100114, 'BLACK FALCON 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000266', '2021-04-15 11:52:51.000266', NULL),
	(10000268, 10000001, 'PW21A-JK100114CM-XXL', 100114, 'BLACK FALCON 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000267', '2021-04-15 11:52:51.000267', NULL),
	(10000269, 10000001, 'PW21A-JK100115DM-XS', 100115, 'BELFAST 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000268', '2021-04-15 11:52:51.000268', NULL),
	(10000270, 10000001, 'PW21A-JK100115DM-S', 100115, 'BELFAST 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000269', '2021-04-15 11:52:51.000269', NULL),
	(10000271, 10000001, 'PW21A-JK100115DM-M', 100115, 'BELFAST 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000270', '2021-04-15 11:52:51.000270', NULL),
	(10000272, 10000001, 'PW21A-JK100115DM-L', 100115, 'BELFAST 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000271', '2021-04-15 11:52:51.000271', NULL),
	(10000273, 10000001, 'PW21A-JK100115DM-XL', 100115, 'BELFAST 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000272', '2021-04-15 11:52:51.000272', NULL),
	(10000274, 10000001, 'PW21A-JK100115DM-XXL', 100115, 'BELFAST 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000273', '2021-04-15 11:52:51.000273', NULL),
	(10000275, 10000001, 'PW21A-JK100116RD-XS', 100116, 'MOTEGI', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000274', '2021-04-15 11:52:51.000274', NULL),
	(10000276, 10000001, 'PW21A-JK100116RD-S', 100116, 'MOTEGI', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000275', '2021-04-15 11:52:51.000275', NULL),
	(10000277, 10000001, 'PW21A-JK100116RD-M', 100116, 'MOTEGI', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000276', '2021-04-15 11:52:51.000276', NULL),
	(10000278, 10000001, 'PW21A-JK100116RD-L', 100116, 'MOTEGI', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000277', '2021-04-15 11:52:51.000277', NULL),
	(10000279, 10000001, 'PW21A-JK100116RD-XL', 100116, 'MOTEGI', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000278', '2021-04-15 11:52:51.000278', NULL),
	(10000280, 10000001, 'PW21A-JK100116RD-XXL', 100116, 'MOTEGI', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000279', '2021-04-15 11:52:51.000279', NULL),
	(10000281, 10000001, 'PW21A-JK100117BL-XS', 100117, 'MAVERICK BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000280', '2021-04-15 11:52:51.000280', NULL),
	(10000282, 10000001, 'PW21A-JK100117BL-S', 100117, 'MAVERICK BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000281', '2021-04-15 11:52:51.000281', NULL),
	(10000283, 10000001, 'PW21A-JK100117BL-M', 100117, 'MAVERICK BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000282', '2021-04-15 11:52:51.000282', NULL),
	(10000284, 10000001, 'PW21A-JK100117BL-L', 100117, 'MAVERICK BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000283', '2021-04-15 11:52:51.000283', NULL),
	(10000285, 10000001, 'PW21A-JK100117BL-XL', 100117, 'MAVERICK BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000284', '2021-04-15 11:52:51.000284', NULL),
	(10000286, 10000001, 'PW21A-JK100117BL-XXL', 100117, 'MAVERICK BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000285', '2021-04-15 11:52:51.000285', NULL),
	(10000287, 10000001, 'PW21A-JK100118AR-XS', 100118, 'SHERMAN BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000286', '2021-04-15 11:52:51.000286', NULL),
	(10000288, 10000001, 'PW21A-JK100118AR-S', 100118, 'SHERMAN BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.000287', '2021-04-15 11:52:51.000287', NULL),
	(10000289, 10000001, 'PW21A-JK100118AR-M', 100118, 'SHERMAN BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.000288', '2021-04-15 11:52:51.000288', NULL),
	(10000290, 10000001, 'PW21A-JK100118AR-L', 100118, 'SHERMAN BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000289', '2021-04-15 11:52:51.000289', NULL),
	(10000291, 10000001, 'PW21A-JK100118AR-XL', 100118, 'SHERMAN BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000290', '2021-04-15 11:52:51.000290', NULL),
	(10000292, 10000001, 'PW21A-JK100118AR-XXL', 100118, 'SHERMAN BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000291', '2021-04-15 11:52:51.000291', NULL),
	(10000293, 10000001, 'PW21A-JK100119BL-XS', 100119, 'CONTINENTAL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000292', '2021-04-15 11:52:51.000292', NULL),
	(10000294, 10000001, 'PW21A-JK100119BL-S', 100119, 'CONTINENTAL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.000293', '2021-04-15 11:52:51.000293', NULL),
	(10000295, 10000001, 'PW21A-JK100119BL-M', 100119, 'CONTINENTAL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.000294', '2021-04-15 11:52:51.000294', NULL),
	(10000296, 10000001, 'PW21A-JK100119BL-L', 100119, 'CONTINENTAL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 27, 1, 'Piece', '2021-04-15 11:52:51.000295', '2021-04-15 11:52:51.000295', NULL),
	(10000297, 10000001, 'PW21A-JK100119BL-XL', 100119, 'CONTINENTAL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.000296', '2021-04-15 11:52:51.000296', NULL),
	(10000298, 10000001, 'PW21A-JK100119BL-XXL', 100119, 'CONTINENTAL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.000297', '2021-04-15 11:52:51.000297', NULL),
	(10000299, 10000001, 'PW21A-JK100120BL-XS', 100120, 'VELOCITY', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000298', '2021-04-15 11:52:51.000298', NULL),
	(10000300, 10000001, 'PW21A-JK100120BL-S', 100120, 'VELOCITY', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.000299', '2021-04-15 11:52:51.000299', NULL),
	(10000301, 10000001, 'PW21A-JK100120BL-M', 100120, 'VELOCITY', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000300', '2021-04-15 11:52:51.000300', NULL),
	(10000302, 10000001, 'PW21A-JK100120BL-L', 100120, 'VELOCITY', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 30, 1, 'Piece', '2021-04-15 11:52:51.000301', '2021-04-15 11:52:51.000301', NULL),
	(10000303, 10000001, 'PW21A-JK100120BL-XL', 100120, 'VELOCITY', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.000302', '2021-04-15 11:52:51.000302', NULL),
	(10000304, 10000001, 'PW21A-JK100120BL-XXL', 100120, 'VELOCITY', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000303', '2021-04-15 11:52:51.000303', NULL),
	(10000305, 10000001, 'PW21A-JK100121MR-XS', 100121, 'GO RIDE WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000304', '2021-04-15 11:52:51.000304', NULL),
	(10000306, 10000001, 'PW21A-JK100121MR-S', 100121, 'GO RIDE WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 28, 1, 'Piece', '2021-04-15 11:52:51.000305', '2021-04-15 11:52:51.000305', NULL),
	(10000307, 10000001, 'PW21A-JK100121MR-M', 100121, 'GO RIDE WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 31, 1, 'Piece', '2021-04-15 11:52:51.000306', '2021-04-15 11:52:51.000306', NULL),
	(10000308, 10000001, 'PW21A-JK100121MR-L', 100121, 'GO RIDE WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 39, 1, 'Piece', '2021-04-15 11:52:51.000307', '2021-04-15 11:52:51.000307', NULL),
	(10000309, 10000001, 'PW21A-JK100121MR-XL', 100121, 'GO RIDE WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.000308', '2021-04-15 11:52:51.000308', NULL),
	(10000310, 10000001, 'PW21A-JK100121MR-XXL', 100121, 'GO RIDE WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000309', '2021-04-15 11:52:51.000309', NULL),
	(10000311, 10000001, 'PW21A-JK100122RD-XS', 100122, 'CONCORDE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000310', '2021-04-15 11:52:51.000310', NULL),
	(10000312, 10000001, 'PW21A-JK100122RD-S', 100122, 'CONCORDE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000311', '2021-04-15 11:52:51.000311', NULL),
	(10000313, 10000001, 'PW21A-JK100122RD-M', 100122, 'CONCORDE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000312', '2021-04-15 11:52:51.000312', NULL),
	(10000314, 10000001, 'PW21A-JK100122RD-L', 100122, 'CONCORDE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000313', '2021-04-15 11:52:51.000313', NULL),
	(10000315, 10000001, 'PW21A-JK100122RD-XL', 100122, 'CONCORDE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000314', '2021-04-15 11:52:51.000314', NULL),
	(10000316, 10000001, 'PW21A-JK100122RD-XXL', 100122, 'CONCORDE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000315', '2021-04-15 11:52:51.000315', NULL),
	(10000317, 10000001, 'PW21A-JK100123BL-XS', 100123, 'PHILLIP SPORTY JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000316', '2021-04-15 11:52:51.000316', NULL),
	(10000318, 10000001, 'PW21A-JK100123BL-S', 100123, 'PHILLIP SPORTY JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.000317', '2021-04-15 11:52:51.000317', NULL),
	(10000319, 10000001, 'PW21A-JK100123BL-M', 100123, 'PHILLIP SPORTY JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000318', '2021-04-15 11:52:51.000318', NULL),
	(10000320, 10000001, 'PW21A-JK100123BL-L', 100123, 'PHILLIP SPORTY JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000319', '2021-04-15 11:52:51.000319', NULL),
	(10000321, 10000001, 'PW21A-JK100123BL-XL', 100123, 'PHILLIP SPORTY JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000320', '2021-04-15 11:52:51.000320', NULL),
	(10000322, 10000001, 'PW21A-JK100123BL-XXL', 100123, 'PHILLIP SPORTY JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000321', '2021-04-15 11:52:51.000321', NULL),
	(10000323, 10000001, 'PW21A-JK100124BL-XS', 100124, 'WARRIOR PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000322', '2021-04-15 11:52:51.000322', NULL),
	(10000324, 10000001, 'PW21A-JK100124BL-S', 100124, 'WARRIOR PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.000323', '2021-04-15 11:52:51.000323', NULL),
	(10000325, 10000001, 'PW21A-JK100124BL-M', 100124, 'WARRIOR PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.000324', '2021-04-15 11:52:51.000324', NULL),
	(10000326, 10000001, 'PW21A-JK100124BL-L', 100124, 'WARRIOR PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 30, 1, 'Piece', '2021-04-15 11:52:51.000325', '2021-04-15 11:52:51.000325', NULL),
	(10000327, 10000001, 'PW21A-JK100124BL-XL', 100124, 'WARRIOR PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.000326', '2021-04-15 11:52:51.000326', NULL),
	(10000328, 10000001, 'PW21A-JK100124BL-XXL', 100124, 'WARRIOR PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000327', '2021-04-15 11:52:51.000327', NULL),
	(10000329, 10000001, 'PW21A-JK100125AR-XS', 100125, 'WILD AND FREE PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000328', '2021-04-15 11:52:51.000328', NULL),
	(10000330, 10000001, 'PW21A-JK100125AR-S', 100125, 'WILD AND FREE PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.000329', '2021-04-15 11:52:51.000329', NULL),
	(10000331, 10000001, 'PW21A-JK100125AR-M', 100125, 'WILD AND FREE PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.000330', '2021-04-15 11:52:51.000330', NULL),
	(10000332, 10000001, 'PW21A-JK100125AR-L', 100125, 'WILD AND FREE PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.000331', '2021-04-15 11:52:51.000331', NULL),
	(10000333, 10000001, 'PW21A-JK100125AR-XL', 100125, 'WILD AND FREE PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000332', '2021-04-15 11:52:51.000332', NULL),
	(10000334, 10000001, 'PW21A-JK100125AR-XXL', 100125, 'WILD AND FREE PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000333', '2021-04-15 11:52:51.000333', NULL),
	(10000335, 10000001, 'PW21A-JK100126BL-XS', 100126, 'RAVEN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000334', '2021-04-15 11:52:51.000334', NULL),
	(10000336, 10000001, 'PW21A-JK100126BL-S', 100126, 'RAVEN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000335', '2021-04-15 11:52:51.000335', NULL),
	(10000337, 10000001, 'PW21A-JK100126BL-M', 100126, 'RAVEN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000336', '2021-04-15 11:52:51.000336', NULL),
	(10000338, 10000001, 'PW21A-JK100126BL-L', 100126, 'RAVEN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000337', '2021-04-15 11:52:51.000337', NULL),
	(10000339, 10000001, 'PW21A-JK100126BL-XL', 100126, 'RAVEN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000338', '2021-04-15 11:52:51.000338', NULL),
	(10000340, 10000001, 'PW21A-JK100126BL-XXL', 100126, 'RAVEN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000339', '2021-04-15 11:52:51.000339', NULL),
	(10000341, 10000001, 'PW21A-JK100127BL-XS', 100127, 'YEAGER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000340', '2021-04-15 11:52:51.000340', NULL),
	(10000342, 10000001, 'PW21A-JK100127BL-S', 100127, 'YEAGER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000341', '2021-04-15 11:52:51.000341', NULL),
	(10000343, 10000001, 'PW21A-JK100127BL-M', 100127, 'YEAGER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000342', '2021-04-15 11:52:51.000342', NULL),
	(10000344, 10000001, 'PW21A-JK100127BL-L', 100127, 'YEAGER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000343', '2021-04-15 11:52:51.000343', NULL),
	(10000345, 10000001, 'PW21A-JK100127BL-XL', 100127, 'YEAGER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000344', '2021-04-15 11:52:51.000344', NULL),
	(10000346, 10000001, 'PW21A-JK100127BL-XXL', 100127, 'YEAGER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000345', '2021-04-15 11:52:51.000345', NULL),
	(10000347, 10000001, 'PW21A-JK100128BL-XS', 100128, 'MAGNUS', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000346', '2021-04-15 11:52:51.000346', NULL),
	(10000348, 10000001, 'PW21A-JK100128BL-S', 100128, 'MAGNUS', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000347', '2021-04-15 11:52:51.000347', NULL),
	(10000349, 10000001, 'PW21A-JK100128BL-M', 100128, 'MAGNUS', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000348', '2021-04-15 11:52:51.000348', NULL),
	(10000350, 10000001, 'PW21A-JK100128BL-L', 100128, 'MAGNUS', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000349', '2021-04-15 11:52:51.000349', NULL),
	(10000351, 10000001, 'PW21A-JK100128BL-XL', 100128, 'MAGNUS', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000350', '2021-04-15 11:52:51.000350', NULL),
	(10000352, 10000001, 'PW21A-JK100128BL-XXL', 100128, 'MAGNUS', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000351', '2021-04-15 11:52:51.000351', NULL),
	(10000353, 10000001, 'PW21A-JK100129YW -XS', 100129, 'FORTIUS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000352', '2021-04-15 11:52:51.000352', NULL),
	(10000354, 10000001, 'PW21A-JK100129YW -S', 100129, 'FORTIUS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000353', '2021-04-15 11:52:51.000353', NULL),
	(10000355, 10000001, 'PW21A-JK100129YW -M', 100129, 'FORTIUS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000354', '2021-04-15 11:52:51.000354', NULL),
	(10000356, 10000001, 'PW21A-JK100129YW -L', 100129, 'FORTIUS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000355', '2021-04-15 11:52:51.000355', NULL),
	(10000357, 10000001, 'PW21A-JK100129YW -XL', 100129, 'FORTIUS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000356', '2021-04-15 11:52:51.000356', NULL),
	(10000358, 10000001, 'PW21A-JK100129YW -XXL', 100129, 'FORTIUS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000357', '2021-04-15 11:52:51.000357', NULL),
	(10000359, 10000001, 'PW21A-JK100130YW -XS', 100130, 'SHIBUYA JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000358', '2021-04-15 11:52:51.000358', NULL),
	(10000360, 10000001, 'PW21A-JK100130YW -S', 100130, 'SHIBUYA JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 43, 1, 'Piece', '2021-04-15 11:52:51.000359', '2021-04-15 11:52:51.000359', NULL),
	(10000361, 10000001, 'PW21A-JK100130YW -M', 100130, 'SHIBUYA JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 46, 1, 'Piece', '2021-04-15 11:52:51.000360', '2021-04-15 11:52:51.000360', NULL),
	(10000362, 10000001, 'PW21A-JK100130YW -L', 100130, 'SHIBUYA JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 52, 1, 'Piece', '2021-04-15 11:52:51.000361', '2021-04-15 11:52:51.000361', NULL),
	(10000363, 10000001, 'PW21A-JK100130YW -XL', 100130, 'SHIBUYA JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 38, 1, 'Piece', '2021-04-15 11:52:51.000362', '2021-04-15 11:52:51.000362', NULL),
	(10000364, 10000001, 'PW21A-JK100130YW -XXL', 100130, 'SHIBUYA JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.000363', '2021-04-15 11:52:51.000363', NULL),
	(10000365, 10000001, 'PW21A-JK100131YW -XS', 100131, 'SPEEDSTER RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000364', '2021-04-15 11:52:51.000364', NULL),
	(10000366, 10000001, 'PW21A-JK100131YW -S', 100131, 'SPEEDSTER RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000365', '2021-04-15 11:52:51.000365', NULL),
	(10000367, 10000001, 'PW21A-JK100131YW -M', 100131, 'SPEEDSTER RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000366', '2021-04-15 11:52:51.000366', NULL),
	(10000368, 10000001, 'PW21A-JK100131YW -L', 100131, 'SPEEDSTER RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000367', '2021-04-15 11:52:51.000367', NULL),
	(10000369, 10000001, 'PW21A-JK100131YW -XL', 100131, 'SPEEDSTER RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000368', '2021-04-15 11:52:51.000368', NULL),
	(10000370, 10000001, 'PW21A-JK100131YW -XXL', 100131, 'SPEEDSTER RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000369', '2021-04-15 11:52:51.000369', NULL),
	(10000371, 10000001, 'PW21A-JK100132BL-XS', 100132, 'BARETTA VEST BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000370', '2021-04-15 11:52:51.000370', NULL),
	(10000372, 10000001, 'PW21A-JK100132BL-S', 100132, 'BARETTA VEST BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000371', '2021-04-15 11:52:51.000371', NULL),
	(10000373, 10000001, 'PW21A-JK100132BL-M', 100132, 'BARETTA VEST BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000372', '2021-04-15 11:52:51.000372', NULL),
	(10000374, 10000001, 'PW21A-JK100132BL-L', 100132, 'BARETTA VEST BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000373', '2021-04-15 11:52:51.000373', NULL),
	(10000375, 10000001, 'PW21A-JK100132BL-XL', 100132, 'BARETTA VEST BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000374', '2021-04-15 11:52:51.000374', NULL),
	(10000376, 10000001, 'PW21A-JK100132BL-XXL', 100132, 'BARETTA VEST BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000375', '2021-04-15 11:52:51.000375', NULL),
	(10000377, 10000001, 'PW21A-JK100133BL-XS', 100133, 'MISANO RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000376', '2021-04-15 11:52:51.000376', NULL),
	(10000378, 10000001, 'PW21A-JK100133BL-S', 100133, 'MISANO RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.000377', '2021-04-15 11:52:51.000377', NULL),
	(10000379, 10000001, 'PW21A-JK100133BL-M', 100133, 'MISANO RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000378', '2021-04-15 11:52:51.000378', NULL),
	(10000380, 10000001, 'PW21A-JK100133BL-L', 100133, 'MISANO RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000379', '2021-04-15 11:52:51.000379', NULL),
	(10000381, 10000001, 'PW21A-JK100133BL-XL', 100133, 'MISANO RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000380', '2021-04-15 11:52:51.000380', NULL),
	(10000382, 10000001, 'PW21A-JK100133BL-XXL', 100133, 'MISANO RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000381', '2021-04-15 11:52:51.000381', NULL),
	(10000383, 10000001, 'PW21A-JK100134OL-XS', 100134, 'BARETTA VEST OLIVE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000382', '2021-04-15 11:52:51.000382', NULL),
	(10000384, 10000001, 'PW21A-JK100134OL-S', 100134, 'BARETTA VEST OLIVE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000383', '2021-04-15 11:52:51.000383', NULL),
	(10000385, 10000001, 'PW21A-JK100134OL-M', 100134, 'BARETTA VEST OLIVE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000384', '2021-04-15 11:52:51.000384', NULL),
	(10000386, 10000001, 'PW21A-JK100134OL-L', 100134, 'BARETTA VEST OLIVE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000385', '2021-04-15 11:52:51.000385', NULL),
	(10000387, 10000001, 'PW21A-JK100134OL-XL', 100134, 'BARETTA VEST OLIVE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000386', '2021-04-15 11:52:51.000386', NULL),
	(10000388, 10000001, 'PW21A-JK100134OL-XXL', 100134, 'BARETTA VEST OLIVE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000387', '2021-04-15 11:52:51.000387', NULL),
	(10000389, 10000001, 'PW21A-JK100135BL-XS', 100135, 'KAMIKAZE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000388', '2021-04-15 11:52:51.000388', NULL),
	(10000390, 10000001, 'PW21A-JK100135BL-S', 100135, 'KAMIKAZE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000389', '2021-04-15 11:52:51.000389', NULL),
	(10000391, 10000001, 'PW21A-JK100135BL-M', 100135, 'KAMIKAZE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000390', '2021-04-15 11:52:51.000390', NULL),
	(10000392, 10000001, 'PW21A-JK100135BL-L', 100135, 'KAMIKAZE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000391', '2021-04-15 11:52:51.000391', NULL),
	(10000393, 10000001, 'PW21A-JK100135BL-XL', 100135, 'KAMIKAZE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000392', '2021-04-15 11:52:51.000392', NULL),
	(10000394, 10000001, 'PW21A-JK100135BL-XXL', 100135, 'KAMIKAZE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000393', '2021-04-15 11:52:51.000393', NULL),
	(10000395, 10000001, 'PW21A-JK100136OL-XS', 100136, 'JUNGLE SNAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000394', '2021-04-15 11:52:51.000394', NULL),
	(10000396, 10000001, 'PW21A-JK100136OL-S', 100136, 'JUNGLE SNAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.000395', '2021-04-15 11:52:51.000395', NULL),
	(10000397, 10000001, 'PW21A-JK100136OL-M', 100136, 'JUNGLE SNAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.000396', '2021-04-15 11:52:51.000396', NULL),
	(10000398, 10000001, 'PW21A-JK100136OL-L', 100136, 'JUNGLE SNAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000397', '2021-04-15 11:52:51.000397', NULL),
	(10000399, 10000001, 'PW21A-JK100136OL-XL', 100136, 'JUNGLE SNAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.000398', '2021-04-15 11:52:51.000398', NULL),
	(10000400, 10000001, 'PW21A-JK100136OL-XXL', 100136, 'JUNGLE SNAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000399', '2021-04-15 11:52:51.000399', NULL),
	(10000401, 10000001, 'PW21A-JK100137BL-XS', 100137, 'PRIDE OF INDONESIA BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 22, 1, 'Piece', '2021-04-15 11:52:51.000400', '2021-04-15 11:52:51.000400', NULL),
	(10000402, 10000001, 'PW21A-JK100137BL-S', 100137, 'PRIDE OF INDONESIA BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 44, 1, 'Piece', '2021-04-15 11:52:51.000401', '2021-04-15 11:52:51.000401', NULL),
	(10000403, 10000001, 'PW21A-JK100137BL-M', 100137, 'PRIDE OF INDONESIA BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 54, 1, 'Piece', '2021-04-15 11:52:51.000402', '2021-04-15 11:52:51.000402', NULL),
	(10000404, 10000001, 'PW21A-JK100137BL-L', 100137, 'PRIDE OF INDONESIA BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 60, 1, 'Piece', '2021-04-15 11:52:51.000403', '2021-04-15 11:52:51.000403', NULL),
	(10000405, 10000001, 'PW21A-JK100137BL-XL', 100137, 'PRIDE OF INDONESIA BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 39, 1, 'Piece', '2021-04-15 11:52:51.000404', '2021-04-15 11:52:51.000404', NULL),
	(10000406, 10000001, 'PW21A-JK100137BL-XXL', 100137, 'PRIDE OF INDONESIA BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.000405', '2021-04-15 11:52:51.000405', NULL),
	(10000407, 10000001, 'PW21A-JK100138OL-XS', 100138, 'JUNGLE PANTHER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000406', '2021-04-15 11:52:51.000406', NULL),
	(10000408, 10000001, 'PW21A-JK100138OL-S', 100138, 'JUNGLE PANTHER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000407', '2021-04-15 11:52:51.000407', NULL),
	(10000409, 10000001, 'PW21A-JK100138OL-M', 100138, 'JUNGLE PANTHER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000408', '2021-04-15 11:52:51.000408', NULL),
	(10000410, 10000001, 'PW21A-JK100138OL-L', 100138, 'JUNGLE PANTHER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000409', '2021-04-15 11:52:51.000409', NULL),
	(10000411, 10000001, 'PW21A-JK100138OL-XL', 100138, 'JUNGLE PANTHER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000410', '2021-04-15 11:52:51.000410', NULL),
	(10000412, 10000001, 'PW21A-JK100138OL-XXL', 100138, 'JUNGLE PANTHER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000411', '2021-04-15 11:52:51.000411', NULL),
	(10000413, 10000001, 'PW21A-JK100139BL-XS', 100139, 'VENOM WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000412', '2021-04-15 11:52:51.000412', NULL),
	(10000414, 10000001, 'PW21A-JK100139BL-S', 100139, 'VENOM WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000413', '2021-04-15 11:52:51.000413', NULL),
	(10000415, 10000001, 'PW21A-JK100139BL-M', 100139, 'VENOM WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000414', '2021-04-15 11:52:51.000414', NULL),
	(10000416, 10000001, 'PW21A-JK100139BL-L', 100139, 'VENOM WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000415', '2021-04-15 11:52:51.000415', NULL),
	(10000417, 10000001, 'PW21A-JK100139BL-XL', 100139, 'VENOM WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000416', '2021-04-15 11:52:51.000416', NULL),
	(10000418, 10000001, 'PW21A-JK100139BL-XXL', 100139, 'VENOM WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000417', '2021-04-15 11:52:51.000417', NULL),
	(10000419, 10000001, 'PW21A-JK100140OL-XS', 100140, 'SPEED BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000418', '2021-04-15 11:52:51.000418', NULL),
	(10000420, 10000001, 'PW21A-JK100140OL-S', 100140, 'SPEED BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000419', '2021-04-15 11:52:51.000419', NULL),
	(10000421, 10000001, 'PW21A-JK100140OL-M', 100140, 'SPEED BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.000420', '2021-04-15 11:52:51.000420', NULL),
	(10000422, 10000001, 'PW21A-JK100140OL-L', 100140, 'SPEED BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.000421', '2021-04-15 11:52:51.000421', NULL),
	(10000423, 10000001, 'PW21A-JK100140OL-XL', 100140, 'SPEED BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000422', '2021-04-15 11:52:51.000422', NULL),
	(10000424, 10000001, 'PW21A-JK100140OL-XXL', 100140, 'SPEED BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000423', '2021-04-15 11:52:51.000423', NULL),
	(10000425, 10000001, 'PW21A-JK100141BL-XS', 100141, 'DOMINATION SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000424', '2021-04-15 11:52:51.000424', NULL),
	(10000426, 10000001, 'PW21A-JK100141BL-S', 100141, 'DOMINATION SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000425', '2021-04-15 11:52:51.000425', NULL),
	(10000427, 10000001, 'PW21A-JK100141BL-M', 100141, 'DOMINATION SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000426', '2021-04-15 11:52:51.000426', NULL),
	(10000428, 10000001, 'PW21A-JK100141BL-L', 100141, 'DOMINATION SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000427', '2021-04-15 11:52:51.000427', NULL),
	(10000429, 10000001, 'PW21A-JK100141BL-XL', 100141, 'DOMINATION SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000428', '2021-04-15 11:52:51.000428', NULL),
	(10000430, 10000001, 'PW21A-JK100141BL-XXL', 100141, 'DOMINATION SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000429', '2021-04-15 11:52:51.000429', NULL),
	(10000431, 10000001, 'PW21A-JK100142OL-XS', 100142, 'AERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000430', '2021-04-15 11:52:51.000430', NULL),
	(10000432, 10000001, 'PW21A-JK100142OL-S', 100142, 'AERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000431', '2021-04-15 11:52:51.000431', NULL),
	(10000433, 10000001, 'PW21A-JK100142OL-M', 100142, 'AERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.000432', '2021-04-15 11:52:51.000432', NULL),
	(10000434, 10000001, 'PW21A-JK100142OL-L', 100142, 'AERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.000433', '2021-04-15 11:52:51.000433', NULL),
	(10000435, 10000001, 'PW21A-JK100142OL-XL', 100142, 'AERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000434', '2021-04-15 11:52:51.000434', NULL),
	(10000436, 10000001, 'PW21A-JK100142OL-XXL', 100142, 'AERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000435', '2021-04-15 11:52:51.000435', NULL),
	(10000437, 10000001, 'PW21A-JK100143BL-XS', 100143, 'BLACK SQUADRON', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000436', '2021-04-15 11:52:51.000436', NULL),
	(10000438, 10000001, 'PW21A-JK100143BL-S', 100143, 'BLACK SQUADRON', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000437', '2021-04-15 11:52:51.000437', NULL),
	(10000439, 10000001, 'PW21A-JK100143BL-M', 100143, 'BLACK SQUADRON', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000438', '2021-04-15 11:52:51.000438', NULL),
	(10000440, 10000001, 'PW21A-JK100143BL-L', 100143, 'BLACK SQUADRON', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000439', '2021-04-15 11:52:51.000439', NULL),
	(10000441, 10000001, 'PW21A-JK100143BL-XL', 100143, 'BLACK SQUADRON', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000440', '2021-04-15 11:52:51.000440', NULL),
	(10000442, 10000001, 'PW21A-JK100143BL-XXL', 100143, 'BLACK SQUADRON', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000441', '2021-04-15 11:52:51.000441', NULL),
	(10000443, 10000001, 'PW21A-JK100144AR-XS', 100144, 'SKULL BARR', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000442', '2021-04-15 11:52:51.000442', NULL),
	(10000444, 10000001, 'PW21A-JK100144AR-S', 100144, 'SKULL BARR', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000443', '2021-04-15 11:52:51.000443', NULL),
	(10000445, 10000001, 'PW21A-JK100144AR-M', 100144, 'SKULL BARR', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000444', '2021-04-15 11:52:51.000444', NULL),
	(10000446, 10000001, 'PW21A-JK100144AR-L', 100144, 'SKULL BARR', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.000445', '2021-04-15 11:52:51.000445', NULL),
	(10000447, 10000001, 'PW21A-JK100144AR-XL', 100144, 'SKULL BARR', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000446', '2021-04-15 11:52:51.000446', NULL),
	(10000448, 10000001, 'PW21A-JK100144AR-XXL', 100144, 'SKULL BARR', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000447', '2021-04-15 11:52:51.000447', NULL),
	(10000449, 10000001, 'PW21A-JK100145RD-XS', 100145, 'KONOTORI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000448', '2021-04-15 11:52:51.000448', NULL),
	(10000450, 10000001, 'PW21A-JK100145RD-S', 100145, 'KONOTORI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000449', '2021-04-15 11:52:51.000449', NULL),
	(10000451, 10000001, 'PW21A-JK100145RD-M', 100145, 'KONOTORI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000450', '2021-04-15 11:52:51.000450', NULL),
	(10000452, 10000001, 'PW21A-JK100145RD-L', 100145, 'KONOTORI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000451', '2021-04-15 11:52:51.000451', NULL),
	(10000453, 10000001, 'PW21A-JK100145RD-XL', 100145, 'KONOTORI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000452', '2021-04-15 11:52:51.000452', NULL),
	(10000454, 10000001, 'PW21A-JK100145RD-XXL', 100145, 'KONOTORI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000453', '2021-04-15 11:52:51.000453', NULL),
	(10000455, 10000001, 'PW21A-JK100146BL-XS', 100146, 'FREEDOM FIGHTER SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000454', '2021-04-15 11:52:51.000454', NULL),
	(10000456, 10000001, 'PW21A-JK100146BL-S', 100146, 'FREEDOM FIGHTER SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000455', '2021-04-15 11:52:51.000455', NULL),
	(10000457, 10000001, 'PW21A-JK100146BL-M', 100146, 'FREEDOM FIGHTER SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000456', '2021-04-15 11:52:51.000456', NULL),
	(10000458, 10000001, 'PW21A-JK100146BL-L', 100146, 'FREEDOM FIGHTER SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.000457', '2021-04-15 11:52:51.000457', NULL),
	(10000459, 10000001, 'PW21A-JK100146BL-XL', 100146, 'FREEDOM FIGHTER SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000458', '2021-04-15 11:52:51.000458', NULL),
	(10000460, 10000001, 'PW21A-JK100146BL-XXL', 100146, 'FREEDOM FIGHTER SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000459', '2021-04-15 11:52:51.000459', NULL),
	(10000461, 10000001, 'PW21A-JK100147BL-XS', 100147, 'SUPERIOR WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000460', '2021-04-15 11:52:51.000460', NULL),
	(10000462, 10000001, 'PW21A-JK100147BL-S', 100147, 'SUPERIOR WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000461', '2021-04-15 11:52:51.000461', NULL),
	(10000463, 10000001, 'PW21A-JK100147BL-M', 100147, 'SUPERIOR WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000462', '2021-04-15 11:52:51.000462', NULL),
	(10000464, 10000001, 'PW21A-JK100147BL-L', 100147, 'SUPERIOR WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.000463', '2021-04-15 11:52:51.000463', NULL),
	(10000465, 10000001, 'PW21A-JK100147BL-XL', 100147, 'SUPERIOR WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000464', '2021-04-15 11:52:51.000464', NULL),
	(10000466, 10000001, 'PW21A-JK100147BL-XXL', 100147, 'SUPERIOR WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000465', '2021-04-15 11:52:51.000465', NULL),
	(10000467, 10000001, 'PW21A-JK100148BL-XS', 100148, 'UNFORGIVEN WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000466', '2021-04-15 11:52:51.000466', NULL),
	(10000468, 10000001, 'PW21A-JK100148BL-S', 100148, 'UNFORGIVEN WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000467', '2021-04-15 11:52:51.000467', NULL),
	(10000469, 10000001, 'PW21A-JK100148BL-M', 100148, 'UNFORGIVEN WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.000468', '2021-04-15 11:52:51.000468', NULL),
	(10000470, 10000001, 'PW21A-JK100148BL-L', 100148, 'UNFORGIVEN WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.000469', '2021-04-15 11:52:51.000469', NULL),
	(10000471, 10000001, 'PW21A-JK100148BL-XL', 100148, 'UNFORGIVEN WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.000470', '2021-04-15 11:52:51.000470', NULL),
	(10000472, 10000001, 'PW21A-JK100148BL-XXL', 100148, 'UNFORGIVEN WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000471', '2021-04-15 11:52:51.000471', NULL),
	(10000473, 10000001, 'PW21A-JK100149BL-XS', 100149, 'FREAKLESS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000472', '2021-04-15 11:52:51.000472', NULL),
	(10000474, 10000001, 'PW21A-JK100149BL-S', 100149, 'FREAKLESS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.000473', '2021-04-15 11:52:51.000473', NULL),
	(10000475, 10000001, 'PW21A-JK100149BL-M', 100149, 'FREAKLESS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000474', '2021-04-15 11:52:51.000474', NULL),
	(10000476, 10000001, 'PW21A-JK100149BL-L', 100149, 'FREAKLESS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000475', '2021-04-15 11:52:51.000475', NULL),
	(10000477, 10000001, 'PW21A-JK100149BL-XL', 100149, 'FREAKLESS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000476', '2021-04-15 11:52:51.000476', NULL),
	(10000478, 10000001, 'PW21A-JK100149BL-XXL', 100149, 'FREAKLESS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000477', '2021-04-15 11:52:51.000477', NULL),
	(10000479, 10000001, 'PW21A-JK100150BL-XS', 100150, 'BURNING SKULL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000478', '2021-04-15 11:52:51.000478', NULL),
	(10000480, 10000001, 'PW21A-JK100150BL-S', 100150, 'BURNING SKULL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000479', '2021-04-15 11:52:51.000479', NULL),
	(10000481, 10000001, 'PW21A-JK100150BL-M', 100150, 'BURNING SKULL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.000480', '2021-04-15 11:52:51.000480', NULL),
	(10000482, 10000001, 'PW21A-JK100150BL-L', 100150, 'BURNING SKULL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.000481', '2021-04-15 11:52:51.000481', NULL),
	(10000483, 10000001, 'PW21A-JK100150BL-XL', 100150, 'BURNING SKULL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.000482', '2021-04-15 11:52:51.000482', NULL),
	(10000484, 10000001, 'PW21A-JK100150BL-XXL', 100150, 'BURNING SKULL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000483', '2021-04-15 11:52:51.000483', NULL),
	(10000485, 10000001, 'PW21A-JK100151BL-XS', 100151, 'PISTON HEAD WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000484', '2021-04-15 11:52:51.000484', NULL),
	(10000486, 10000001, 'PW21A-JK100151BL-S', 100151, 'PISTON HEAD WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000485', '2021-04-15 11:52:51.000485', NULL),
	(10000487, 10000001, 'PW21A-JK100151BL-M', 100151, 'PISTON HEAD WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000486', '2021-04-15 11:52:51.000486', NULL),
	(10000488, 10000001, 'PW21A-JK100151BL-L', 100151, 'PISTON HEAD WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.000487', '2021-04-15 11:52:51.000487', NULL),
	(10000489, 10000001, 'PW21A-JK100151BL-XL', 100151, 'PISTON HEAD WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.000488', '2021-04-15 11:52:51.000488', NULL),
	(10000490, 10000001, 'PW21A-JK100151BL-XXL', 100151, 'PISTON HEAD WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000489', '2021-04-15 11:52:51.000489', NULL),
	(10000491, 10000001, 'PW21A-JK100152BL-XS', 100152, 'JAPAN KOI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000490', '2021-04-15 11:52:51.000490', NULL),
	(10000492, 10000001, 'PW21A-JK100152BL-S', 100152, 'JAPAN KOI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000491', '2021-04-15 11:52:51.000491', NULL),
	(10000493, 10000001, 'PW21A-JK100152BL-M', 100152, 'JAPAN KOI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.000492', '2021-04-15 11:52:51.000492', NULL),
	(10000494, 10000001, 'PW21A-JK100152BL-L', 100152, 'JAPAN KOI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.000493', '2021-04-15 11:52:51.000493', NULL),
	(10000495, 10000001, 'PW21A-JK100152BL-XL', 100152, 'JAPAN KOI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.000494', '2021-04-15 11:52:51.000494', NULL),
	(10000496, 10000001, 'PW21A-JK100152BL-XXL', 100152, 'JAPAN KOI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000495', '2021-04-15 11:52:51.000495', NULL),
	(10000497, 10000001, 'PW21A-JK100153GN-XS', 100153, 'TENGUHEBI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000496', '2021-04-15 11:52:51.000496', NULL),
	(10000498, 10000001, 'PW21A-JK100153GN-S', 100153, 'TENGUHEBI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.000497', '2021-04-15 11:52:51.000497', NULL),
	(10000499, 10000001, 'PW21A-JK100153GN-M', 100153, 'TENGUHEBI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.000498', '2021-04-15 11:52:51.000498', NULL),
	(10000500, 10000001, 'PW21A-JK100153GN-L', 100153, 'TENGUHEBI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.000499', '2021-04-15 11:52:51.000499', NULL),
	(10000501, 10000001, 'PW21A-JK100153GN-XL', 100153, 'TENGUHEBI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000500', '2021-04-15 11:52:51.000500', NULL),
	(10000502, 10000001, 'PW21A-JK100153GN-XXL', 100153, 'TENGUHEBI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000501', '2021-04-15 11:52:51.000501', NULL),
	(10000503, 10000001, 'PW21A-JD100154BL-XS', 100154, 'HERITAGE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000502', '2021-04-15 11:52:51.000502', NULL),
	(10000504, 10000001, 'PW21A-JD100154BL-S', 100154, 'HERITAGE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.000503', '2021-04-15 11:52:51.000503', NULL),
	(10000505, 10000001, 'PW21A-JD100154BL-M', 100154, 'HERITAGE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000504', '2021-04-15 11:52:51.000504', NULL),
	(10000506, 10000001, 'PW21A-JD100154BL-L', 100154, 'HERITAGE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.000505', '2021-04-15 11:52:51.000505', NULL),
	(10000507, 10000001, 'PW21A-JD100154BL-XL', 100154, 'HERITAGE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.000506', '2021-04-15 11:52:51.000506', NULL),
	(10000508, 10000001, 'PW21A-JD100154BL-XXL', 100154, 'HERITAGE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.000507', '2021-04-15 11:52:51.000507', NULL),
	(10000509, 10000001, 'PW21A-JK100155OL-XS', 100155, 'IGNORANT JUNGLE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000508', '2021-04-15 11:52:51.000508', NULL),
	(10000510, 10000001, 'PW21A-JK100155OL-S', 100155, 'IGNORANT JUNGLE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000509', '2021-04-15 11:52:51.000509', NULL),
	(10000511, 10000001, 'PW21A-JK100155OL-M', 100155, 'IGNORANT JUNGLE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000510', '2021-04-15 11:52:51.000510', NULL),
	(10000512, 10000001, 'PW21A-JK100155OL-L', 100155, 'IGNORANT JUNGLE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000511', '2021-04-15 11:52:51.000511', NULL),
	(10000513, 10000001, 'PW21A-JK100155OL-XL', 100155, 'IGNORANT JUNGLE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000512', '2021-04-15 11:52:51.000512', NULL),
	(10000514, 10000001, 'PW21A-JK100155OL-XXL', 100155, 'IGNORANT JUNGLE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000513', '2021-04-15 11:52:51.000513', NULL),
	(10000515, 10000001, 'PW21A-JK100156YW -XS', 100156, 'ROAD KILLER WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000514', '2021-04-15 11:52:51.000514', NULL),
	(10000516, 10000001, 'PW21A-JK100156YW -S', 100156, 'ROAD KILLER WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000515', '2021-04-15 11:52:51.000515', NULL),
	(10000517, 10000001, 'PW21A-JK100156YW -M', 100156, 'ROAD KILLER WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000516', '2021-04-15 11:52:51.000516', NULL),
	(10000518, 10000001, 'PW21A-JK100156YW -L', 100156, 'ROAD KILLER WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000517', '2021-04-15 11:52:51.000517', NULL),
	(10000519, 10000001, 'PW21A-JK100156YW -XL', 100156, 'ROAD KILLER WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000518', '2021-04-15 11:52:51.000518', NULL),
	(10000520, 10000001, 'PW21A-JK100156YW -XXL', 100156, 'ROAD KILLER WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000519', '2021-04-15 11:52:51.000519', NULL),
	(10000521, 10000001, 'PW21A-JK100157BL-XS', 100157, 'ONIMUSHA SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000520', '2021-04-15 11:52:51.000520', NULL),
	(10000522, 10000001, 'PW21A-JK100157BL-S', 100157, 'ONIMUSHA SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000521', '2021-04-15 11:52:51.000521', NULL),
	(10000523, 10000001, 'PW21A-JK100157BL-M', 100157, 'ONIMUSHA SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000522', '2021-04-15 11:52:51.000522', NULL),
	(10000524, 10000001, 'PW21A-JK100157BL-L', 100157, 'ONIMUSHA SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000523', '2021-04-15 11:52:51.000523', NULL),
	(10000525, 10000001, 'PW21A-JK100157BL-XL', 100157, 'ONIMUSHA SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000524', '2021-04-15 11:52:51.000524', NULL),
	(10000526, 10000001, 'PW21A-JK100157BL-XXL', 100157, 'ONIMUSHA SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000525', '2021-04-15 11:52:51.000525', NULL),
	(10000527, 10000001, 'PW21A-JK100158AR-XS', 100158, 'KNOCK OUT PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000526', '2021-04-15 11:52:51.000526', NULL),
	(10000528, 10000001, 'PW21A-JK100158AR-S', 100158, 'KNOCK OUT PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000527', '2021-04-15 11:52:51.000527', NULL),
	(10000529, 10000001, 'PW21A-JK100158AR-M', 100158, 'KNOCK OUT PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000528', '2021-04-15 11:52:51.000528', NULL),
	(10000530, 10000001, 'PW21A-JK100158AR-L', 100158, 'KNOCK OUT PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000529', '2021-04-15 11:52:51.000529', NULL),
	(10000531, 10000001, 'PW21A-JK100158AR-XL', 100158, 'KNOCK OUT PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000530', '2021-04-15 11:52:51.000530', NULL),
	(10000532, 10000001, 'PW21A-JK100158AR-XXL', 100158, 'KNOCK OUT PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000531', '2021-04-15 11:52:51.000531', NULL),
	(10000533, 10000001, 'PW21A-JD100159MR-XS', 100159, 'GO RIDE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000532', '2021-04-15 11:52:51.000532', NULL),
	(10000534, 10000001, 'PW21A-JD100159MR-S', 100159, 'GO RIDE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000533', '2021-04-15 11:52:51.000533', NULL),
	(10000535, 10000001, 'PW21A-JD100159MR-M', 100159, 'GO RIDE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000534', '2021-04-15 11:52:51.000534', NULL),
	(10000536, 10000001, 'PW21A-JD100159MR-L', 100159, 'GO RIDE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000535', '2021-04-15 11:52:51.000535', NULL),
	(10000537, 10000001, 'PW21A-JD100159MR-XL', 100159, 'GO RIDE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000536', '2021-04-15 11:52:51.000536', NULL),
	(10000538, 10000001, 'PW21A-JD100159MR-XXL', 100159, 'GO RIDE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000537', '2021-04-15 11:52:51.000537', NULL),
	(10000539, 10000001, 'PW21A-JK100160TC-XS', 100160, 'NIPPON 4.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000538', '2021-04-15 11:52:51.000538', NULL),
	(10000540, 10000001, 'PW21A-JK100160TC-S', 100160, 'NIPPON 4.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000539', '2021-04-15 11:52:51.000539', NULL),
	(10000541, 10000001, 'PW21A-JK100160TC-M', 100160, 'NIPPON 4.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000540', '2021-04-15 11:52:51.000540', NULL),
	(10000542, 10000001, 'PW21A-JK100160TC-L', 100160, 'NIPPON 4.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000541', '2021-04-15 11:52:51.000541', NULL),
	(10000543, 10000001, 'PW21A-JK100160TC-XL', 100160, 'NIPPON 4.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000542', '2021-04-15 11:52:51.000542', NULL),
	(10000544, 10000001, 'PW21A-JK100160TC-XXL', 100160, 'NIPPON 4.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000543', '2021-04-15 11:52:51.000543', NULL),
	(10000545, 10000001, 'PW21A-JK100161BL-XS', 100161, 'DIRTY DEES WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000544', '2021-04-15 11:52:51.000544', NULL),
	(10000546, 10000001, 'PW21A-JK100161BL-S', 100161, 'DIRTY DEES WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000545', '2021-04-15 11:52:51.000545', NULL),
	(10000547, 10000001, 'PW21A-JK100161BL-M', 100161, 'DIRTY DEES WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.000546', '2021-04-15 11:52:51.000546', NULL),
	(10000548, 10000001, 'PW21A-JK100161BL-L', 100161, 'DIRTY DEES WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.000547', '2021-04-15 11:52:51.000547', NULL),
	(10000549, 10000001, 'PW21A-JK100161BL-XL', 100161, 'DIRTY DEES WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000548', '2021-04-15 11:52:51.000548', NULL),
	(10000550, 10000001, 'PW21A-JK100161BL-XXL', 100161, 'DIRTY DEES WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000549', '2021-04-15 11:52:51.000549', NULL),
	(10000551, 10000001, 'PW21A-JD100162BL-XS', 100162, 'PW MC WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000550', '2021-04-15 11:52:51.000550', NULL),
	(10000552, 10000001, 'PW21A-JD100162BL-S', 100162, 'PW MC WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000551', '2021-04-15 11:52:51.000551', NULL),
	(10000553, 10000001, 'PW21A-JD100162BL-M', 100162, 'PW MC WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000552', '2021-04-15 11:52:51.000552', NULL),
	(10000554, 10000001, 'PW21A-JD100162BL-L', 100162, 'PW MC WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000553', '2021-04-15 11:52:51.000553', NULL),
	(10000555, 10000001, 'PW21A-JD100162BL-XL', 100162, 'PW MC WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000554', '2021-04-15 11:52:51.000554', NULL),
	(10000556, 10000001, 'PW21A-JD100162BL-XXL', 100162, 'PW MC WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000555', '2021-04-15 11:52:51.000555', NULL),
	(10000557, 10000001, 'PW21A-JK100163RD-XS', 100163, 'MOTEGI 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.000556', '2021-04-15 11:52:51.000556', NULL),
	(10000558, 10000001, 'PW21A-JK100163RD-S', 100163, 'MOTEGI 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 49, 1, 'Piece', '2021-04-15 11:52:51.000557', '2021-04-15 11:52:51.000557', NULL),
	(10000559, 10000001, 'PW21A-JK100163RD-M', 100163, 'MOTEGI 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 58, 1, 'Piece', '2021-04-15 11:52:51.000558', '2021-04-15 11:52:51.000558', NULL),
	(10000560, 10000001, 'PW21A-JK100163RD-L', 100163, 'MOTEGI 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 67, 1, 'Piece', '2021-04-15 11:52:51.000559', '2021-04-15 11:52:51.000559', NULL),
	(10000561, 10000001, 'PW21A-JK100163RD-XL', 100163, 'MOTEGI 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 43, 1, 'Piece', '2021-04-15 11:52:51.000560', '2021-04-15 11:52:51.000560', NULL),
	(10000562, 10000001, 'PW21A-JK100163RD-XXL', 100163, 'MOTEGI 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 28, 1, 'Piece', '2021-04-15 11:52:51.000561', '2021-04-15 11:52:51.000561', NULL),
	(10000563, 10000001, 'PW21A-JD100164BL-XS', 100164, 'BLACK EAGLE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000562', '2021-04-15 11:52:51.000562', NULL),
	(10000564, 10000001, 'PW21A-JD100164BL-S', 100164, 'BLACK EAGLE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000563', '2021-04-15 11:52:51.000563', NULL),
	(10000565, 10000001, 'PW21A-JD100164BL-M', 100164, 'BLACK EAGLE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000564', '2021-04-15 11:52:51.000564', NULL),
	(10000566, 10000001, 'PW21A-JD100164BL-L', 100164, 'BLACK EAGLE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000565', '2021-04-15 11:52:51.000565', NULL),
	(10000567, 10000001, 'PW21A-JD100164BL-XL', 100164, 'BLACK EAGLE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000566', '2021-04-15 11:52:51.000566', NULL),
	(10000568, 10000001, 'PW21A-JD100164BL-XXL', 100164, 'BLACK EAGLE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000567', '2021-04-15 11:52:51.000567', NULL),
	(10000569, 10000001, 'PW21A-JK100165NV-XS', 100165, 'UNIT ZERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000568', '2021-04-15 11:52:51.000568', NULL),
	(10000570, 10000001, 'PW21A-JK100165NV-S', 100165, 'UNIT ZERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000569', '2021-04-15 11:52:51.000569', NULL),
	(10000571, 10000001, 'PW21A-JK100165NV-M', 100165, 'UNIT ZERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000570', '2021-04-15 11:52:51.000570', NULL),
	(10000572, 10000001, 'PW21A-JK100165NV-L', 100165, 'UNIT ZERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000571', '2021-04-15 11:52:51.000571', NULL),
	(10000573, 10000001, 'PW21A-JK100165NV-XL', 100165, 'UNIT ZERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000572', '2021-04-15 11:52:51.000572', NULL),
	(10000574, 10000001, 'PW21A-JK100165NV-XXL', 100165, 'UNIT ZERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000573', '2021-04-15 11:52:51.000573', NULL),
	(10000575, 10000001, 'PW21A-JK100166MR-XS', 100166, 'BIRD BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000574', '2021-04-15 11:52:51.000574', NULL),
	(10000576, 10000001, 'PW21A-JK100166MR-S', 100166, 'BIRD BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000575', '2021-04-15 11:52:51.000575', NULL),
	(10000577, 10000001, 'PW21A-JK100166MR-M', 100166, 'BIRD BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000576', '2021-04-15 11:52:51.000576', NULL),
	(10000578, 10000001, 'PW21A-JK100166MR-L', 100166, 'BIRD BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000577', '2021-04-15 11:52:51.000577', NULL),
	(10000579, 10000001, 'PW21A-JK100166MR-XL', 100166, 'BIRD BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000578', '2021-04-15 11:52:51.000578', NULL),
	(10000580, 10000001, 'PW21A-JK100166MR-XXL', 100166, 'BIRD BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000579', '2021-04-15 11:52:51.000579', NULL),
	(10000581, 10000001, 'PW21A-JK100167WT-XS', 100167, 'OKAMI WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000580', '2021-04-15 11:52:51.000580', NULL),
	(10000582, 10000001, 'PW21A-JK100167WT-S', 100167, 'OKAMI WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.000581', '2021-04-15 11:52:51.000581', NULL),
	(10000583, 10000001, 'PW21A-JK100167WT-M', 100167, 'OKAMI WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.000582', '2021-04-15 11:52:51.000582', NULL),
	(10000584, 10000001, 'PW21A-JK100167WT-L', 100167, 'OKAMI WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 29, 1, 'Piece', '2021-04-15 11:52:51.000583', '2021-04-15 11:52:51.000583', NULL),
	(10000585, 10000001, 'PW21A-JK100167WT-XL', 100167, 'OKAMI WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000584', '2021-04-15 11:52:51.000584', NULL),
	(10000586, 10000001, 'PW21A-JK100167WT-XXL', 100167, 'OKAMI WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.000585', '2021-04-15 11:52:51.000585', NULL),
	(10000587, 10000001, 'PW21A-JK100168BL-XS', 100168, 'JAVA ANORAK JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000586', '2021-04-15 11:52:51.000586', NULL),
	(10000588, 10000001, 'PW21A-JK100168BL-S', 100168, 'JAVA ANORAK JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000587', '2021-04-15 11:52:51.000587', NULL),
	(10000589, 10000001, 'PW21A-JK100168BL-M', 100168, 'JAVA ANORAK JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000588', '2021-04-15 11:52:51.000588', NULL),
	(10000590, 10000001, 'PW21A-JK100168BL-L', 100168, 'JAVA ANORAK JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.000589', '2021-04-15 11:52:51.000589', NULL),
	(10000591, 10000001, 'PW21A-JK100168BL-XL', 100168, 'JAVA ANORAK JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000590', '2021-04-15 11:52:51.000590', NULL),
	(10000592, 10000001, 'PW21A-JK100168BL-XXL', 100168, 'JAVA ANORAK JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000591', '2021-04-15 11:52:51.000591', NULL),
	(10000593, 10000001, 'PW21A-JK100169BL-XS', 100169, 'RACING DIVISION BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000592', '2021-04-15 11:52:51.000592', NULL),
	(10000594, 10000001, 'PW21A-JK100169BL-S', 100169, 'RACING DIVISION BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000593', '2021-04-15 11:52:51.000593', NULL),
	(10000595, 10000001, 'PW21A-JK100169BL-M', 100169, 'RACING DIVISION BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000594', '2021-04-15 11:52:51.000594', NULL),
	(10000596, 10000001, 'PW21A-JK100169BL-L', 100169, 'RACING DIVISION BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000595', '2021-04-15 11:52:51.000595', NULL),
	(10000597, 10000001, 'PW21A-JK100169BL-XL', 100169, 'RACING DIVISION BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000596', '2021-04-15 11:52:51.000596', NULL),
	(10000598, 10000001, 'PW21A-JK100169BL-XXL', 100169, 'RACING DIVISION BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000597', '2021-04-15 11:52:51.000597', NULL),
	(10000599, 10000001, 'PW21A-JK100170RD-XS', 100170, 'RACING DIVISION RED', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000598', '2021-04-15 11:52:51.000598', NULL),
	(10000600, 10000001, 'PW21A-JK100170RD-S', 100170, 'RACING DIVISION RED', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000599', '2021-04-15 11:52:51.000599', NULL),
	(10000601, 10000001, 'PW21A-JK100170RD-M', 100170, 'RACING DIVISION RED', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000600', '2021-04-15 11:52:51.000600', NULL),
	(10000602, 10000001, 'PW21A-JK100170RD-L', 100170, 'RACING DIVISION RED', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000601', '2021-04-15 11:52:51.000601', NULL),
	(10000603, 10000001, 'PW21A-JK100170RD-XL', 100170, 'RACING DIVISION RED', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000602', '2021-04-15 11:52:51.000602', NULL),
	(10000604, 10000001, 'PW21A-JK100170RD-XXL', 100170, 'RACING DIVISION RED', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000603', '2021-04-15 11:52:51.000603', NULL),
	(10000605, 10000001, 'PW21A-JK100171WT-XS', 100171, 'RACING DIVISION WHITE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000604', '2021-04-15 11:52:51.000604', NULL),
	(10000606, 10000001, 'PW21A-JK100171WT-S', 100171, 'RACING DIVISION WHITE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000605', '2021-04-15 11:52:51.000605', NULL),
	(10000607, 10000001, 'PW21A-JK100171WT-M', 100171, 'RACING DIVISION WHITE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000606', '2021-04-15 11:52:51.000606', NULL),
	(10000608, 10000001, 'PW21A-JK100171WT-L', 100171, 'RACING DIVISION WHITE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000607', '2021-04-15 11:52:51.000607', NULL),
	(10000609, 10000001, 'PW21A-JK100171WT-XL', 100171, 'RACING DIVISION WHITE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000608', '2021-04-15 11:52:51.000608', NULL),
	(10000610, 10000001, 'PW21A-JK100171WT-XXL', 100171, 'RACING DIVISION WHITE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000609', '2021-04-15 11:52:51.000609', NULL),
	(10000611, 10000001, 'PW21A-JK100172BL-XS', 100172, 'ECHOPLEX WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000610', '2021-04-15 11:52:51.000610', NULL),
	(10000612, 10000001, 'PW21A-JK100172BL-S', 100172, 'ECHOPLEX WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.000611', '2021-04-15 11:52:51.000611', NULL),
	(10000613, 10000001, 'PW21A-JK100172BL-M', 100172, 'ECHOPLEX WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000612', '2021-04-15 11:52:51.000612', NULL),
	(10000614, 10000001, 'PW21A-JK100172BL-L', 100172, 'ECHOPLEX WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.000613', '2021-04-15 11:52:51.000613', NULL),
	(10000615, 10000001, 'PW21A-JK100172BL-XL', 100172, 'ECHOPLEX WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.000614', '2021-04-15 11:52:51.000614', NULL),
	(10000616, 10000001, 'PW21A-JK100172BL-XXL', 100172, 'ECHOPLEX WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000615', '2021-04-15 11:52:51.000615', NULL),
	(10000617, 10000001, 'PW21A-TS100173BL-XS', 100173, 'CB 1972', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000616', '2021-04-15 11:52:51.000616', NULL),
	(10000618, 10000001, 'PW21A-TS100173BL-M', 100173, 'CB 1972', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000617', '2021-04-15 11:52:51.000617', NULL),
	(10000619, 10000001, 'PW21A-TS100173BL-L', 100173, 'CB 1972', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000618', '2021-04-15 11:52:51.000618', NULL),
	(10000620, 10000001, 'PW21A-TS100173BL-XL', 100173, 'CB 1972', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000619', '2021-04-15 11:52:51.000619', NULL),
	(10000621, 10000001, 'PW21A-TS100173BL-XXL', 100173, 'CB 1972', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000620', '2021-04-15 11:52:51.000620', NULL),
	(10000622, 10000001, 'PW21A-TS100174NV-XS', 100174, 'DUST AND WHEELS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000621', '2021-04-15 11:52:51.000621', NULL),
	(10000623, 10000001, 'PW21A-TS100174NV-S', 100174, 'DUST AND WHEELS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000622', '2021-04-15 11:52:51.000622', NULL),
	(10000624, 10000001, 'PW21A-TS100174NV-M', 100174, 'DUST AND WHEELS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000623', '2021-04-15 11:52:51.000623', NULL),
	(10000625, 10000001, 'PW21A-TS100174NV-L', 100174, 'DUST AND WHEELS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000624', '2021-04-15 11:52:51.000624', NULL),
	(10000626, 10000001, 'PW21A-TS100174NV-XL', 100174, 'DUST AND WHEELS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000625', '2021-04-15 11:52:51.000625', NULL),
	(10000627, 10000001, 'PW21A-TS100174NV-XXL', 100174, 'DUST AND WHEELS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000626', '2021-04-15 11:52:51.000626', NULL),
	(10000628, 10000001, 'PW21A-TS100175BL-XS', 100175, 'NO FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000627', '2021-04-15 11:52:51.000627', NULL),
	(10000629, 10000001, 'PW21A-TS100175BL-S', 100175, 'NO FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000628', '2021-04-15 11:52:51.000628', NULL),
	(10000630, 10000001, 'PW21A-TS100175BL-M', 100175, 'NO FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000629', '2021-04-15 11:52:51.000629', NULL),
	(10000631, 10000001, 'PW21A-TS100175BL-L', 100175, 'NO FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000630', '2021-04-15 11:52:51.000630', NULL),
	(10000632, 10000001, 'PW21A-TS100175BL-XL', 100175, 'NO FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000631', '2021-04-15 11:52:51.000631', NULL),
	(10000633, 10000001, 'PW21A-TS100175BL-XXL', 100175, 'NO FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000632', '2021-04-15 11:52:51.000632', NULL),
	(10000634, 10000001, 'PW21A-TS100176BL-XS', 100176, 'NEVER TRUST', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000633', '2021-04-15 11:52:51.000633', NULL),
	(10000635, 10000001, 'PW21A-TS100176BL-S', 100176, 'NEVER TRUST', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000634', '2021-04-15 11:52:51.000634', NULL),
	(10000636, 10000001, 'PW21A-TS100176BL-M', 100176, 'NEVER TRUST', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000635', '2021-04-15 11:52:51.000635', NULL),
	(10000637, 10000001, 'PW21A-TS100176BL-L', 100176, 'NEVER TRUST', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000636', '2021-04-15 11:52:51.000636', NULL),
	(10000638, 10000001, 'PW21A-TS100176BL-XL', 100176, 'NEVER TRUST', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000637', '2021-04-15 11:52:51.000637', NULL),
	(10000639, 10000001, 'PW21A-TS100176BL-XXL', 100176, 'NEVER TRUST', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000638', '2021-04-15 11:52:51.000638', NULL),
	(10000640, 10000001, 'PW21A-TS100177BL-XS', 100177, 'JAPAN CULTURE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000639', '2021-04-15 11:52:51.000639', NULL),
	(10000641, 10000001, 'PW21A-TS100177BL-S', 100177, 'JAPAN CULTURE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000640', '2021-04-15 11:52:51.000640', NULL),
	(10000642, 10000001, 'PW21A-TS100177BL-M', 100177, 'JAPAN CULTURE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000641', '2021-04-15 11:52:51.000641', NULL),
	(10000643, 10000001, 'PW21A-TS100177BL-L', 100177, 'JAPAN CULTURE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000642', '2021-04-15 11:52:51.000642', NULL),
	(10000644, 10000001, 'PW21A-TS100177BL-XL', 100177, 'JAPAN CULTURE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000643', '2021-04-15 11:52:51.000643', NULL),
	(10000645, 10000001, 'PW21A-TS100177BL-XXL', 100177, 'JAPAN CULTURE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000644', '2021-04-15 11:52:51.000644', NULL),
	(10000646, 10000001, 'PW21A-TS100178BL-XS', 100178, 'THE ROOT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000645', '2021-04-15 11:52:51.000645', NULL),
	(10000647, 10000001, 'PW21A-TS100178BL-S', 100178, 'THE ROOT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000646', '2021-04-15 11:52:51.000646', NULL),
	(10000648, 10000001, 'PW21A-TS100178BL-M', 100178, 'THE ROOT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000647', '2021-04-15 11:52:51.000647', NULL),
	(10000649, 10000001, 'PW21A-TS100178BL-L', 100178, 'THE ROOT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000648', '2021-04-15 11:52:51.000648', NULL),
	(10000650, 10000001, 'PW21A-TS100178BL-XL', 100178, 'THE ROOT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000649', '2021-04-15 11:52:51.000649', NULL),
	(10000651, 10000001, 'PW21A-TS100178BL-XXL', 100178, 'THE ROOT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000650', '2021-04-15 11:52:51.000650', NULL),
	(10000652, 10000001, 'PW21A-TS100179BL-XS', 100179, 'HERITAGE TEE REBORN', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000651', '2021-04-15 11:52:51.000651', NULL),
	(10000653, 10000001, 'PW21A-TS100179BL-S', 100179, 'HERITAGE TEE REBORN', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000652', '2021-04-15 11:52:51.000652', NULL),
	(10000654, 10000001, 'PW21A-TS100179BL-M', 100179, 'HERITAGE TEE REBORN', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000653', '2021-04-15 11:52:51.000653', NULL),
	(10000655, 10000001, 'PW21A-TS100179BL-L', 100179, 'HERITAGE TEE REBORN', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000654', '2021-04-15 11:52:51.000654', NULL),
	(10000656, 10000001, 'PW21A-TS100179BL-XL', 100179, 'HERITAGE TEE REBORN', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000655', '2021-04-15 11:52:51.000655', NULL),
	(10000657, 10000001, 'PW21A-TS100179BL-XXL', 100179, 'HERITAGE TEE REBORN', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000656', '2021-04-15 11:52:51.000656', NULL),
	(10000658, 10000001, 'PW21A-TS100180BL-XS', 100180, 'DETROIT CITY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000657', '2021-04-15 11:52:51.000657', NULL),
	(10000659, 10000001, 'PW21A-TS100180BL-S', 100180, 'DETROIT CITY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000658', '2021-04-15 11:52:51.000658', NULL),
	(10000660, 10000001, 'PW21A-TS100180BL-M', 100180, 'DETROIT CITY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000659', '2021-04-15 11:52:51.000659', NULL),
	(10000661, 10000001, 'PW21A-TS100180BL-L', 100180, 'DETROIT CITY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000660', '2021-04-15 11:52:51.000660', NULL),
	(10000662, 10000001, 'PW21A-TS100180BL-XL', 100180, 'DETROIT CITY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000661', '2021-04-15 11:52:51.000661', NULL),
	(10000663, 10000001, 'PW21A-TS100180BL-XXL', 100180, 'DETROIT CITY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000662', '2021-04-15 11:52:51.000662', NULL),
	(10000664, 10000001, 'PW21A-TS100181BL-XS', 100181, 'WILD ENGINE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000663', '2021-04-15 11:52:51.000663', NULL),
	(10000665, 10000001, 'PW21A-TS100181BL-S', 100181, 'WILD ENGINE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000664', '2021-04-15 11:52:51.000664', NULL),
	(10000666, 10000001, 'PW21A-TS100181BL-M', 100181, 'WILD ENGINE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000665', '2021-04-15 11:52:51.000665', NULL),
	(10000667, 10000001, 'PW21A-TS100181BL-L', 100181, 'WILD ENGINE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000666', '2021-04-15 11:52:51.000666', NULL),
	(10000668, 10000001, 'PW21A-TS100181BL-XL', 100181, 'WILD ENGINE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000667', '2021-04-15 11:52:51.000667', NULL),
	(10000669, 10000001, 'PW21A-TS100181BL-XXL', 100181, 'WILD ENGINE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000668', '2021-04-15 11:52:51.000668', NULL),
	(10000670, 10000001, 'PW21A-TS100182BL-XS', 100182, 'RECKLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000669', '2021-04-15 11:52:51.000669', NULL),
	(10000671, 10000001, 'PW21A-TS100182BL-S', 100182, 'RECKLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000670', '2021-04-15 11:52:51.000670', NULL),
	(10000672, 10000001, 'PW21A-TS100182BL-M', 100182, 'RECKLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000671', '2021-04-15 11:52:51.000671', NULL),
	(10000673, 10000001, 'PW21A-TS100182BL-L', 100182, 'RECKLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000672', '2021-04-15 11:52:51.000672', NULL),
	(10000674, 10000001, 'PW21A-TS100182BL-XL', 100182, 'RECKLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000673', '2021-04-15 11:52:51.000673', NULL),
	(10000675, 10000001, 'PW21A-TS100182BL-XXL', 100182, 'RECKLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000674', '2021-04-15 11:52:51.000674', NULL),
	(10000676, 10000001, 'PW21A-TS100183BL-XS', 100183, 'STREET TRACKER 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000675', '2021-04-15 11:52:51.000675', NULL),
	(10000677, 10000001, 'PW21A-TS100183BL-S', 100183, 'STREET TRACKER 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000676', '2021-04-15 11:52:51.000676', NULL),
	(10000678, 10000001, 'PW21A-TS100183BL-M', 100183, 'STREET TRACKER 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000677', '2021-04-15 11:52:51.000677', NULL),
	(10000679, 10000001, 'PW21A-TS100183BL-L', 100183, 'STREET TRACKER 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000678', '2021-04-15 11:52:51.000678', NULL),
	(10000680, 10000001, 'PW21A-TS100183BL-XL', 100183, 'STREET TRACKER 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000679', '2021-04-15 11:52:51.000679', NULL),
	(10000681, 10000001, 'PW21A-TS100183BL-XXL', 100183, 'STREET TRACKER 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000680', '2021-04-15 11:52:51.000680', NULL),
	(10000682, 10000001, 'PW21A-TS100184BL-XS', 100184, 'NO REGRET', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000681', '2021-04-15 11:52:51.000681', NULL),
	(10000683, 10000001, 'PW21A-TS100184BL-S', 100184, 'NO REGRET', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000682', '2021-04-15 11:52:51.000682', NULL),
	(10000684, 10000001, 'PW21A-TS100184BL-M', 100184, 'NO REGRET', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000683', '2021-04-15 11:52:51.000683', NULL),
	(10000685, 10000001, 'PW21A-TS100184BL-L', 100184, 'NO REGRET', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000684', '2021-04-15 11:52:51.000684', NULL),
	(10000686, 10000001, 'PW21A-TS100184BL-XL', 100184, 'NO REGRET', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000685', '2021-04-15 11:52:51.000685', NULL),
	(10000687, 10000001, 'PW21A-TS100184BL-XXL', 100184, 'NO REGRET', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000686', '2021-04-15 11:52:51.000686', NULL),
	(10000688, 10000001, 'PW21A-TS100185BL-XS', 100185, 'SHUTEN DOJI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000687', '2021-04-15 11:52:51.000687', NULL),
	(10000689, 10000001, 'PW21A-TS100185BL-S', 100185, 'SHUTEN DOJI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000688', '2021-04-15 11:52:51.000688', NULL),
	(10000690, 10000001, 'PW21A-TS100185BL-M', 100185, 'SHUTEN DOJI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000689', '2021-04-15 11:52:51.000689', NULL),
	(10000691, 10000001, 'PW21A-TS100185BL-L', 100185, 'SHUTEN DOJI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000690', '2021-04-15 11:52:51.000690', NULL),
	(10000692, 10000001, 'PW21A-TS100185BL-XL', 100185, 'SHUTEN DOJI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000691', '2021-04-15 11:52:51.000691', NULL),
	(10000693, 10000001, 'PW21A-TS100185BL-XXL', 100185, 'SHUTEN DOJI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000692', '2021-04-15 11:52:51.000692', NULL),
	(10000694, 10000001, 'PW21A-TS100186BL-XS', 100186, 'CHRYSANT DEMON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000693', '2021-04-15 11:52:51.000693', NULL),
	(10000695, 10000001, 'PW21A-TS100186BL-S', 100186, 'CHRYSANT DEMON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000694', '2021-04-15 11:52:51.000694', NULL),
	(10000696, 10000001, 'PW21A-TS100186BL-M', 100186, 'CHRYSANT DEMON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000695', '2021-04-15 11:52:51.000695', NULL),
	(10000697, 10000001, 'PW21A-TS100186BL-L', 100186, 'CHRYSANT DEMON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000696', '2021-04-15 11:52:51.000696', NULL),
	(10000698, 10000001, 'PW21A-TS100186BL-XL', 100186, 'CHRYSANT DEMON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000697', '2021-04-15 11:52:51.000697', NULL),
	(10000699, 10000001, 'PW21A-TS100186BL-XXL', 100186, 'CHRYSANT DEMON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000698', '2021-04-15 11:52:51.000698', NULL),
	(10000700, 10000001, 'PW21A-TS100187BL-XS', 100187, 'INVOLVED 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000699', '2021-04-15 11:52:51.000699', NULL),
	(10000701, 10000001, 'PW21A-TS100187BL-S', 100187, 'INVOLVED 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000700', '2021-04-15 11:52:51.000700', NULL),
	(10000702, 10000001, 'PW21A-TS100187BL-M', 100187, 'INVOLVED 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000701', '2021-04-15 11:52:51.000701', NULL),
	(10000703, 10000001, 'PW21A-TS100187BL-L', 100187, 'INVOLVED 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000702', '2021-04-15 11:52:51.000702', NULL),
	(10000704, 10000001, 'PW21A-TS100187BL-XL', 100187, 'INVOLVED 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000703', '2021-04-15 11:52:51.000703', NULL),
	(10000705, 10000001, 'PW21A-TS100187BL-XXL', 100187, 'INVOLVED 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000704', '2021-04-15 11:52:51.000704', NULL),
	(10000706, 10000001, 'PW21A-TS100188BL-XS', 100188, 'OSAKA TIGER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000705', '2021-04-15 11:52:51.000705', NULL),
	(10000707, 10000001, 'PW21A-TS100188BL-S', 100188, 'OSAKA TIGER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000706', '2021-04-15 11:52:51.000706', NULL),
	(10000708, 10000001, 'PW21A-TS100188BL-M', 100188, 'OSAKA TIGER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000707', '2021-04-15 11:52:51.000707', NULL),
	(10000709, 10000001, 'PW21A-TS100188BL-L', 100188, 'OSAKA TIGER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000708', '2021-04-15 11:52:51.000708', NULL),
	(10000710, 10000001, 'PW21A-TS100188BL-XL', 100188, 'OSAKA TIGER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000709', '2021-04-15 11:52:51.000709', NULL),
	(10000711, 10000001, 'PW21A-TS100188BL-XXL', 100188, 'OSAKA TIGER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000710', '2021-04-15 11:52:51.000710', NULL),
	(10000712, 10000001, 'PW21A-TS100189BL-XS', 100189, 'KARASU TENGU', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000711', '2021-04-15 11:52:51.000711', NULL),
	(10000713, 10000001, 'PW21A-TS100189BL-S', 100189, 'KARASU TENGU', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000712', '2021-04-15 11:52:51.000712', NULL),
	(10000714, 10000001, 'PW21A-TS100189BL-M', 100189, 'KARASU TENGU', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000713', '2021-04-15 11:52:51.000713', NULL),
	(10000715, 10000001, 'PW21A-TS100189BL-L', 100189, 'KARASU TENGU', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000714', '2021-04-15 11:52:51.000714', NULL),
	(10000716, 10000001, 'PW21A-TS100189BL-XL', 100189, 'KARASU TENGU', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000715', '2021-04-15 11:52:51.000715', NULL),
	(10000717, 10000001, 'PW21A-TS100189BL-XXL', 100189, 'KARASU TENGU', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000716', '2021-04-15 11:52:51.000716', NULL),
	(10000718, 10000001, 'PW21A-TS100190WT-XS', 100190, 'NO FEAR WHITE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000717', '2021-04-15 11:52:51.000717', NULL),
	(10000719, 10000001, 'PW21A-TS100190WT-S', 100190, 'NO FEAR WHITE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000718', '2021-04-15 11:52:51.000718', NULL),
	(10000720, 10000001, 'PW21A-TS100190WT-M', 100190, 'NO FEAR WHITE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000719', '2021-04-15 11:52:51.000719', NULL),
	(10000721, 10000001, 'PW21A-TS100190WT-L', 100190, 'NO FEAR WHITE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000720', '2021-04-15 11:52:51.000720', NULL),
	(10000722, 10000001, 'PW21A-TS100190WT-XL', 100190, 'NO FEAR WHITE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 22, 1, 'Piece', '2021-04-15 11:52:51.000721', '2021-04-15 11:52:51.000721', NULL),
	(10000723, 10000001, 'PW21A-TS100190WT-XXL', 100190, 'NO FEAR WHITE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000722', '2021-04-15 11:52:51.000722', NULL),
	(10000724, 10000001, 'PW21A-TS100191YW -XS', 100191, 'BRAVERY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000723', '2021-04-15 11:52:51.000723', NULL),
	(10000725, 10000001, 'PW21A-TS100191YW -S', 100191, 'BRAVERY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000724', '2021-04-15 11:52:51.000724', NULL),
	(10000726, 10000001, 'PW21A-TS100191YW -M', 100191, 'BRAVERY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000725', '2021-04-15 11:52:51.000725', NULL),
	(10000727, 10000001, 'PW21A-TS100191YW -L', 100191, 'BRAVERY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000726', '2021-04-15 11:52:51.000726', NULL),
	(10000728, 10000001, 'PW21A-TS100191YW -XL', 100191, 'BRAVERY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000727', '2021-04-15 11:52:51.000727', NULL),
	(10000729, 10000001, 'PW21A-TS100191YW -XXL', 100191, 'BRAVERY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000728', '2021-04-15 11:52:51.000728', NULL),
	(10000730, 10000001, 'PW21A-TS100192GN-XS', 100192, 'PW MC TEES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000729', '2021-04-15 11:52:51.000729', NULL),
	(10000731, 10000001, 'PW21A-TS100192GN-S', 100192, 'PW MC TEES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000730', '2021-04-15 11:52:51.000730', NULL),
	(10000732, 10000001, 'PW21A-TS100192GN-M', 100192, 'PW MC TEES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000731', '2021-04-15 11:52:51.000731', NULL),
	(10000733, 10000001, 'PW21A-TS100192GN-L', 100192, 'PW MC TEES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000732', '2021-04-15 11:52:51.000732', NULL),
	(10000734, 10000001, 'PW21A-TS100192GN-XL', 100192, 'PW MC TEES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000733', '2021-04-15 11:52:51.000733', NULL),
	(10000735, 10000001, 'PW21A-TS100192GN-XXL', 100192, 'PW MC TEES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000734', '2021-04-15 11:52:51.000734', NULL),
	(10000736, 10000001, 'PW21A-TS100193BL-XS', 100193, 'EL FUERTE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000735', '2021-04-15 11:52:51.000735', NULL),
	(10000737, 10000001, 'PW21A-TS100193BL-S', 100193, 'EL FUERTE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000736', '2021-04-15 11:52:51.000736', NULL),
	(10000738, 10000001, 'PW21A-TS100193BL-M', 100193, 'EL FUERTE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000737', '2021-04-15 11:52:51.000737', NULL),
	(10000739, 10000001, 'PW21A-TS100193BL-L', 100193, 'EL FUERTE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000738', '2021-04-15 11:52:51.000738', NULL),
	(10000740, 10000001, 'PW21A-TS100193BL-XL', 100193, 'EL FUERTE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.000739', '2021-04-15 11:52:51.000739', NULL),
	(10000741, 10000001, 'PW21A-TS100193BL-XXL', 100193, 'EL FUERTE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000740', '2021-04-15 11:52:51.000740', NULL),
	(10000742, 10000001, 'PW21A-TS100194RD-XS', 100194, 'GO RIDE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000741', '2021-04-15 11:52:51.000741', NULL),
	(10000743, 10000001, 'PW21A-TS100194RD-S', 100194, 'GO RIDE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000742', '2021-04-15 11:52:51.000742', NULL),
	(10000744, 10000001, 'PW21A-TS100194RD-M', 100194, 'GO RIDE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000743', '2021-04-15 11:52:51.000743', NULL),
	(10000745, 10000001, 'PW21A-TS100194RD-L', 100194, 'GO RIDE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000744', '2021-04-15 11:52:51.000744', NULL),
	(10000746, 10000001, 'PW21A-TS100194RD-XL', 100194, 'GO RIDE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000745', '2021-04-15 11:52:51.000745', NULL),
	(10000747, 10000001, 'PW21A-TS100194RD-XXL', 100194, 'GO RIDE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000746', '2021-04-15 11:52:51.000746', NULL),
	(10000748, 10000001, 'PW21A-TS100195BL-XS', 100195, 'THE WILD', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000747', '2021-04-15 11:52:51.000747', NULL),
	(10000749, 10000001, 'PW21A-TS100195BL-S', 100195, 'THE WILD', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 29, 1, 'Piece', '2021-04-15 11:52:51.000748', '2021-04-15 11:52:51.000748', NULL),
	(10000750, 10000001, 'PW21A-TS100195BL-M', 100195, 'THE WILD', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 26, 1, 'Piece', '2021-04-15 11:52:51.000749', '2021-04-15 11:52:51.000749', NULL),
	(10000751, 10000001, 'PW21A-TS100195BL-L', 100195, 'THE WILD', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 29, 1, 'Piece', '2021-04-15 11:52:51.000750', '2021-04-15 11:52:51.000750', NULL),
	(10000752, 10000001, 'PW21A-TS100195BL-XL', 100195, 'THE WILD', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.000751', '2021-04-15 11:52:51.000751', NULL),
	(10000753, 10000001, 'PW21A-TS100195BL-XXL', 100195, 'THE WILD', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000752', '2021-04-15 11:52:51.000752', NULL),
	(10000754, 10000001, 'PW21A-TS100196BL-XS', 100196, 'SNAKE DAGGER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000753', '2021-04-15 11:52:51.000753', NULL),
	(10000755, 10000001, 'PW21A-TS100196BL-S', 100196, 'SNAKE DAGGER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.000754', '2021-04-15 11:52:51.000754', NULL),
	(10000756, 10000001, 'PW21A-TS100196BL-M', 100196, 'SNAKE DAGGER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.000755', '2021-04-15 11:52:51.000755', NULL),
	(10000757, 10000001, 'PW21A-TS100196BL-L', 100196, 'SNAKE DAGGER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000756', '2021-04-15 11:52:51.000756', NULL),
	(10000758, 10000001, 'PW21A-TS100196BL-XL', 100196, 'SNAKE DAGGER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 27, 1, 'Piece', '2021-04-15 11:52:51.000757', '2021-04-15 11:52:51.000757', NULL),
	(10000759, 10000001, 'PW21A-TS100196BL-XXL', 100196, 'SNAKE DAGGER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.000758', '2021-04-15 11:52:51.000758', NULL),
	(10000760, 10000001, 'PW21A-TS100197BL-XS', 100197, 'END OF WAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000759', '2021-04-15 11:52:51.000759', NULL),
	(10000761, 10000001, 'PW21A-TS100197BL-S', 100197, 'END OF WAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000760', '2021-04-15 11:52:51.000760', NULL),
	(10000762, 10000001, 'PW21A-TS100197BL-M', 100197, 'END OF WAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000761', '2021-04-15 11:52:51.000761', NULL),
	(10000763, 10000001, 'PW21A-TS100197BL-L', 100197, 'END OF WAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000762', '2021-04-15 11:52:51.000762', NULL),
	(10000764, 10000001, 'PW21A-TS100197BL-XL', 100197, 'END OF WAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000763', '2021-04-15 11:52:51.000763', NULL),
	(10000765, 10000001, 'PW21A-TS100197BL-XXL', 100197, 'END OF WAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000764', '2021-04-15 11:52:51.000764', NULL),
	(10000766, 10000001, 'PW21A-TS100198BL-XS', 100198, 'LIBERATOR TEES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000765', '2021-04-15 11:52:51.000765', NULL),
	(10000767, 10000001, 'PW21A-TS100198BL-S', 100198, 'LIBERATOR TEES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.000766', '2021-04-15 11:52:51.000766', NULL),
	(10000768, 10000001, 'PW21A-TS100198BL-M', 100198, 'LIBERATOR TEES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000767', '2021-04-15 11:52:51.000767', NULL),
	(10000769, 10000001, 'PW21A-TS100198BL-L', 100198, 'LIBERATOR TEES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.000768', '2021-04-15 11:52:51.000768', NULL),
	(10000770, 10000001, 'PW21A-TS100198BL-XL', 100198, 'LIBERATOR TEES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.000769', '2021-04-15 11:52:51.000769', NULL),
	(10000771, 10000001, 'PW21A-TS100198BL-XXL', 100198, 'LIBERATOR TEES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.000770', '2021-04-15 11:52:51.000770', NULL),
	(10000772, 10000001, 'PW21A-TS100199BL-XS', 100199, 'KIRIN 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000771', '2021-04-15 11:52:51.000771', NULL),
	(10000773, 10000001, 'PW21A-TS100199BL-S', 100199, 'KIRIN 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000772', '2021-04-15 11:52:51.000772', NULL),
	(10000774, 10000001, 'PW21A-TS100199BL-M', 100199, 'KIRIN 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000773', '2021-04-15 11:52:51.000773', NULL),
	(10000775, 10000001, 'PW21A-TS100199BL-L', 100199, 'KIRIN 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000774', '2021-04-15 11:52:51.000774', NULL),
	(10000776, 10000001, 'PW21A-TS100199BL-XL', 100199, 'KIRIN 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000775', '2021-04-15 11:52:51.000775', NULL),
	(10000777, 10000001, 'PW21A-TS100199BL-XXL', 100199, 'KIRIN 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000776', '2021-04-15 11:52:51.000776', NULL),
	(10000778, 10000001, 'PW21A-TS100200BL-XS', 100200, 'POSER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000777', '2021-04-15 11:52:51.000777', NULL),
	(10000779, 10000001, 'PW21A-TS100200BL-S', 100200, 'POSER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000778', '2021-04-15 11:52:51.000778', NULL),
	(10000780, 10000001, 'PW21A-TS100200BL-M', 100200, 'POSER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000779', '2021-04-15 11:52:51.000779', NULL),
	(10000781, 10000001, 'PW21A-TS100200BL-L', 100200, 'POSER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000780', '2021-04-15 11:52:51.000780', NULL),
	(10000782, 10000001, 'PW21A-TS100200BL-XL', 100200, 'POSER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000781', '2021-04-15 11:52:51.000781', NULL),
	(10000783, 10000001, 'PW21A-TS100200BL-XXL', 100200, 'POSER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000782', '2021-04-15 11:52:51.000782', NULL),
	(10000784, 10000001, 'PW21A-TS100201BL-XS', 100201, 'SERPENT ROSE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000783', '2021-04-15 11:52:51.000783', NULL),
	(10000785, 10000001, 'PW21A-TS100201BL-S', 100201, 'SERPENT ROSE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000784', '2021-04-15 11:52:51.000784', NULL),
	(10000786, 10000001, 'PW21A-TS100201BL-M', 100201, 'SERPENT ROSE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000785', '2021-04-15 11:52:51.000785', NULL),
	(10000787, 10000001, 'PW21A-TS100201BL-L', 100201, 'SERPENT ROSE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000786', '2021-04-15 11:52:51.000786', NULL),
	(10000788, 10000001, 'PW21A-TS100201BL-XL', 100201, 'SERPENT ROSE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000787', '2021-04-15 11:52:51.000787', NULL),
	(10000789, 10000001, 'PW21A-TS100201BL-XXL', 100201, 'SERPENT ROSE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000788', '2021-04-15 11:52:51.000788', NULL),
	(10000790, 10000001, 'PW21A-TS100202BL-XS', 100202, 'RISING DRAGON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000789', '2021-04-15 11:52:51.000789', NULL),
	(10000791, 10000001, 'PW21A-TS100202BL-S', 100202, 'RISING DRAGON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000790', '2021-04-15 11:52:51.000790', NULL),
	(10000792, 10000001, 'PW21A-TS100202BL-M', 100202, 'RISING DRAGON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000791', '2021-04-15 11:52:51.000791', NULL),
	(10000793, 10000001, 'PW21A-TS100202BL-L', 100202, 'RISING DRAGON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000792', '2021-04-15 11:52:51.000792', NULL),
	(10000794, 10000001, 'PW21A-TS100202BL-XL', 100202, 'RISING DRAGON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000793', '2021-04-15 11:52:51.000793', NULL),
	(10000795, 10000001, 'PW21A-TS100202BL-XXL', 100202, 'RISING DRAGON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000794', '2021-04-15 11:52:51.000794', NULL),
	(10000796, 10000001, 'PW21A-TS100203BL-XS', 100203, 'GREEDY SOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000795', '2021-04-15 11:52:51.000795', NULL),
	(10000797, 10000001, 'PW21A-TS100203BL-S', 100203, 'GREEDY SOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.000796', '2021-04-15 11:52:51.000796', NULL),
	(10000798, 10000001, 'PW21A-TS100203BL-M', 100203, 'GREEDY SOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.000797', '2021-04-15 11:52:51.000797', NULL),
	(10000799, 10000001, 'PW21A-TS100203BL-L', 100203, 'GREEDY SOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 40, 1, 'Piece', '2021-04-15 11:52:51.000798', '2021-04-15 11:52:51.000798', NULL),
	(10000800, 10000001, 'PW21A-TS100203BL-XL', 100203, 'GREEDY SOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.000799', '2021-04-15 11:52:51.000799', NULL),
	(10000801, 10000001, 'PW21A-TS100203BL-XXL', 100203, 'GREEDY SOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000800', '2021-04-15 11:52:51.000800', NULL),
	(10000802, 10000001, 'PW21A-TS100204BL-XS', 100204, 'KILLER CROC', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000801', '2021-04-15 11:52:51.000801', NULL),
	(10000803, 10000001, 'PW21A-TS100204BL-S', 100204, 'KILLER CROC', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000802', '2021-04-15 11:52:51.000802', NULL),
	(10000804, 10000001, 'PW21A-TS100204BL-M', 100204, 'KILLER CROC', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000803', '2021-04-15 11:52:51.000803', NULL),
	(10000805, 10000001, 'PW21A-TS100204BL-L', 100204, 'KILLER CROC', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000804', '2021-04-15 11:52:51.000804', NULL),
	(10000806, 10000001, 'PW21A-TS100204BL-XL', 100204, 'KILLER CROC', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000805', '2021-04-15 11:52:51.000805', NULL),
	(10000807, 10000001, 'PW21A-TS100204BL-XXL', 100204, 'KILLER CROC', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000806', '2021-04-15 11:52:51.000806', NULL),
	(10000808, 10000001, 'PW21A-TS100205WT-XS', 100205, 'NEKO SHENSI 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000807', '2021-04-15 11:52:51.000807', NULL),
	(10000809, 10000001, 'PW21A-TS100205WT-S', 100205, 'NEKO SHENSI 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000808', '2021-04-15 11:52:51.000808', NULL),
	(10000810, 10000001, 'PW21A-TS100205WT-M', 100205, 'NEKO SHENSI 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000809', '2021-04-15 11:52:51.000809', NULL),
	(10000811, 10000001, 'PW21A-TS100205WT-L', 100205, 'NEKO SHENSI 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000810', '2021-04-15 11:52:51.000810', NULL),
	(10000812, 10000001, 'PW21A-TS100205WT-XL', 100205, 'NEKO SHENSI 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000811', '2021-04-15 11:52:51.000811', NULL),
	(10000813, 10000001, 'PW21A-TS100205WT-XXL', 100205, 'NEKO SHENSI 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000812', '2021-04-15 11:52:51.000812', NULL),
	(10000814, 10000001, 'PW21A-TS100206WT-XS', 100206, 'ONI MASK WHITE 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000813', '2021-04-15 11:52:51.000813', NULL),
	(10000815, 10000001, 'PW21A-TS100206WT-S', 100206, 'ONI MASK WHITE 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000814', '2021-04-15 11:52:51.000814', NULL),
	(10000816, 10000001, 'PW21A-TS100206WT-M', 100206, 'ONI MASK WHITE 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000815', '2021-04-15 11:52:51.000815', NULL),
	(10000817, 10000001, 'PW21A-TS100206WT-L', 100206, 'ONI MASK WHITE 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000816', '2021-04-15 11:52:51.000816', NULL),
	(10000818, 10000001, 'PW21A-TS100206WT-XL', 100206, 'ONI MASK WHITE 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000817', '2021-04-15 11:52:51.000817', NULL),
	(10000819, 10000001, 'PW21A-TS100206WT-XXL', 100206, 'ONI MASK WHITE 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000818', '2021-04-15 11:52:51.000818', NULL),
	(10000820, 10000001, 'PW21A-TS100207BL-XS', 100207, 'SAMURAI SPIRIT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000819', '2021-04-15 11:52:51.000819', NULL),
	(10000821, 10000001, 'PW21A-TS100207BL-S', 100207, 'SAMURAI SPIRIT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 29, 1, 'Piece', '2021-04-15 11:52:51.000820', '2021-04-15 11:52:51.000820', NULL),
	(10000822, 10000001, 'PW21A-TS100207BL-M', 100207, 'SAMURAI SPIRIT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.000821', '2021-04-15 11:52:51.000821', NULL),
	(10000823, 10000001, 'PW21A-TS100207BL-L', 100207, 'SAMURAI SPIRIT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.000822', '2021-04-15 11:52:51.000822', NULL),
	(10000824, 10000001, 'PW21A-TS100207BL-XL', 100207, 'SAMURAI SPIRIT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000823', '2021-04-15 11:52:51.000823', NULL),
	(10000825, 10000001, 'PW21A-TS100207BL-XXL', 100207, 'SAMURAI SPIRIT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000824', '2021-04-15 11:52:51.000824', NULL),
	(10000826, 10000001, 'PW21A-TS100208BL-XS', 100208, 'ETERNITY FLAMES 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000825', '2021-04-15 11:52:51.000825', NULL),
	(10000827, 10000001, 'PW21A-TS100208BL-S', 100208, 'ETERNITY FLAMES 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000826', '2021-04-15 11:52:51.000826', NULL),
	(10000828, 10000001, 'PW21A-TS100208BL-M', 100208, 'ETERNITY FLAMES 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000827', '2021-04-15 11:52:51.000827', NULL),
	(10000829, 10000001, 'PW21A-TS100208BL-L', 100208, 'ETERNITY FLAMES 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000828', '2021-04-15 11:52:51.000828', NULL),
	(10000830, 10000001, 'PW21A-TS100208BL-XL', 100208, 'ETERNITY FLAMES 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000829', '2021-04-15 11:52:51.000829', NULL),
	(10000831, 10000001, 'PW21A-TS100208BL-XXL', 100208, 'ETERNITY FLAMES 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000830', '2021-04-15 11:52:51.000830', NULL),
	(10000832, 10000001, 'PW21A-TS100209BL-XS', 100209, 'LOCAL FIGHTER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000831', '2021-04-15 11:52:51.000831', NULL),
	(10000833, 10000001, 'PW21A-TS100209BL-S', 100209, 'LOCAL FIGHTER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 26, 1, 'Piece', '2021-04-15 11:52:51.000832', '2021-04-15 11:52:51.000832', NULL),
	(10000834, 10000001, 'PW21A-TS100209BL-M', 100209, 'LOCAL FIGHTER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.000833', '2021-04-15 11:52:51.000833', NULL),
	(10000835, 10000001, 'PW21A-TS100209BL-L', 100209, 'LOCAL FIGHTER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000834', '2021-04-15 11:52:51.000834', NULL),
	(10000836, 10000001, 'PW21A-TS100209BL-XL', 100209, 'LOCAL FIGHTER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000835', '2021-04-15 11:52:51.000835', NULL),
	(10000837, 10000001, 'PW21A-TS100209BL-XXL', 100209, 'LOCAL FIGHTER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000836', '2021-04-15 11:52:51.000836', NULL),
	(10000838, 10000001, 'PW21A-TS100210BL-XS', 100210, 'WRATH DRAGON 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000837', '2021-04-15 11:52:51.000837', NULL),
	(10000839, 10000001, 'PW21A-TS100210BL-S', 100210, 'WRATH DRAGON 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000838', '2021-04-15 11:52:51.000838', NULL),
	(10000840, 10000001, 'PW21A-TS100210BL-M', 100210, 'WRATH DRAGON 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000839', '2021-04-15 11:52:51.000839', NULL),
	(10000841, 10000001, 'PW21A-TS100210BL-L', 100210, 'WRATH DRAGON 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000840', '2021-04-15 11:52:51.000840', NULL),
	(10000842, 10000001, 'PW21A-TS100210BL-XL', 100210, 'WRATH DRAGON 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000841', '2021-04-15 11:52:51.000841', NULL),
	(10000843, 10000001, 'PW21A-TS100210BL-XXL', 100210, 'WRATH DRAGON 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000842', '2021-04-15 11:52:51.000842', NULL),
	(10000844, 10000001, 'PW21A-TS100211BL-XS', 100211, 'SUMO SHENSO 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000843', '2021-04-15 11:52:51.000843', NULL),
	(10000845, 10000001, 'PW21A-TS100211BL-S', 100211, 'SUMO SHENSO 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000844', '2021-04-15 11:52:51.000844', NULL),
	(10000846, 10000001, 'PW21A-TS100211BL-M', 100211, 'SUMO SHENSO 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000845', '2021-04-15 11:52:51.000845', NULL),
	(10000847, 10000001, 'PW21A-TS100211BL-L', 100211, 'SUMO SHENSO 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000846', '2021-04-15 11:52:51.000846', NULL),
	(10000848, 10000001, 'PW21A-TS100211BL-XL', 100211, 'SUMO SHENSO 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000847', '2021-04-15 11:52:51.000847', NULL),
	(10000849, 10000001, 'PW21A-TS100211BL-XXL', 100211, 'SUMO SHENSO 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000848', '2021-04-15 11:52:51.000848', NULL),
	(10000850, 10000001, 'PW21A-TS100212GN-XS', 100212, 'SPEED JUNKIES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000849', '2021-04-15 11:52:51.000849', NULL),
	(10000851, 10000001, 'PW21A-TS100212GN-S', 100212, 'SPEED JUNKIES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000850', '2021-04-15 11:52:51.000850', NULL),
	(10000852, 10000001, 'PW21A-TS100212GN-M', 100212, 'SPEED JUNKIES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000851', '2021-04-15 11:52:51.000851', NULL),
	(10000853, 10000001, 'PW21A-TS100212GN-L', 100212, 'SPEED JUNKIES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000852', '2021-04-15 11:52:51.000852', NULL),
	(10000854, 10000001, 'PW21A-TS100212GN-XL', 100212, 'SPEED JUNKIES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000853', '2021-04-15 11:52:51.000853', NULL),
	(10000855, 10000001, 'PW21A-TS100212GN-XXL', 100212, 'SPEED JUNKIES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000854', '2021-04-15 11:52:51.000854', NULL),
	(10000856, 10000001, 'PW21A-TS100213BL-XS', 100213, 'RECKLESS LEAP', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000855', '2021-04-15 11:52:51.000855', NULL),
	(10000857, 10000001, 'PW21A-TS100213BL-S', 100213, 'RECKLESS LEAP', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000856', '2021-04-15 11:52:51.000856', NULL),
	(10000858, 10000001, 'PW21A-TS100213BL-M', 100213, 'RECKLESS LEAP', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000857', '2021-04-15 11:52:51.000857', NULL),
	(10000859, 10000001, 'PW21A-TS100213BL-L', 100213, 'RECKLESS LEAP', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.000858', '2021-04-15 11:52:51.000858', NULL),
	(10000860, 10000001, 'PW21A-TS100213BL-XL', 100213, 'RECKLESS LEAP', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.000859', '2021-04-15 11:52:51.000859', NULL),
	(10000861, 10000001, 'PW21A-TS100213BL-XXL', 100213, 'RECKLESS LEAP', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000860', '2021-04-15 11:52:51.000860', NULL),
	(10000862, 10000001, 'PW21A-TS100214BL-XS', 100214, 'ONI MASK BLACK 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000861', '2021-04-15 11:52:51.000861', NULL),
	(10000863, 10000001, 'PW21A-TS100214BL-S', 100214, 'ONI MASK BLACK 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000862', '2021-04-15 11:52:51.000862', NULL),
	(10000864, 10000001, 'PW21A-TS100214BL-M', 100214, 'ONI MASK BLACK 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000863', '2021-04-15 11:52:51.000863', NULL),
	(10000865, 10000001, 'PW21A-TS100214BL-L', 100214, 'ONI MASK BLACK 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000864', '2021-04-15 11:52:51.000864', NULL),
	(10000866, 10000001, 'PW21A-TS100214BL-XL', 100214, 'ONI MASK BLACK 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000865', '2021-04-15 11:52:51.000865', NULL),
	(10000867, 10000001, 'PW21A-TS100214BL-XXL', 100214, 'ONI MASK BLACK 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000866', '2021-04-15 11:52:51.000866', NULL),
	(10000868, 10000001, 'PW21A-TS100215BL-XS', 100215, 'FLAMES CHOPPER 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000867', '2021-04-15 11:52:51.000867', NULL),
	(10000869, 10000001, 'PW21A-TS100215BL-S', 100215, 'FLAMES CHOPPER 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000868', '2021-04-15 11:52:51.000868', NULL),
	(10000870, 10000001, 'PW21A-TS100215BL-M', 100215, 'FLAMES CHOPPER 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000869', '2021-04-15 11:52:51.000869', NULL),
	(10000871, 10000001, 'PW21A-TS100215BL-L', 100215, 'FLAMES CHOPPER 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000870', '2021-04-15 11:52:51.000870', NULL),
	(10000872, 10000001, 'PW21A-TS100215BL-XL', 100215, 'FLAMES CHOPPER 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000871', '2021-04-15 11:52:51.000871', NULL),
	(10000873, 10000001, 'PW21A-TS100215BL-XXL', 100215, 'FLAMES CHOPPER 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000872', '2021-04-15 11:52:51.000872', NULL),
	(10000874, 10000001, 'PW21A-TS100216NV-XS', 100216, 'TIGER FLAMES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000873', '2021-04-15 11:52:51.000873', NULL),
	(10000875, 10000001, 'PW21A-TS100216NV-S', 100216, 'TIGER FLAMES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000874', '2021-04-15 11:52:51.000874', NULL),
	(10000876, 10000001, 'PW21A-TS100216NV-M', 100216, 'TIGER FLAMES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000875', '2021-04-15 11:52:51.000875', NULL),
	(10000877, 10000001, 'PW21A-TS100216NV-L', 100216, 'TIGER FLAMES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000876', '2021-04-15 11:52:51.000876', NULL),
	(10000878, 10000001, 'PW21A-TS100216NV-XL', 100216, 'TIGER FLAMES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000877', '2021-04-15 11:52:51.000877', NULL),
	(10000879, 10000001, 'PW21A-TS100216NV-XXL', 100216, 'TIGER FLAMES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000878', '2021-04-15 11:52:51.000878', NULL),
	(10000880, 10000001, 'PW21A-TS100217BL-XS', 100217, 'INDIAN OWL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000879', '2021-04-15 11:52:51.000879', NULL),
	(10000881, 10000001, 'PW21A-TS100217BL-S', 100217, 'INDIAN OWL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000880', '2021-04-15 11:52:51.000880', NULL),
	(10000882, 10000001, 'PW21A-TS100217BL-M', 100217, 'INDIAN OWL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000881', '2021-04-15 11:52:51.000881', NULL),
	(10000883, 10000001, 'PW21A-TS100217BL-L', 100217, 'INDIAN OWL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000882', '2021-04-15 11:52:51.000882', NULL),
	(10000884, 10000001, 'PW21A-TS100217BL-XL', 100217, 'INDIAN OWL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000883', '2021-04-15 11:52:51.000883', NULL),
	(10000885, 10000001, 'PW21A-TS100217BL-XXL', 100217, 'INDIAN OWL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000884', '2021-04-15 11:52:51.000884', NULL),
	(10000886, 10000001, 'PW21A-TS100218BL-XS', 100218, 'NORTON MANX 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000885', '2021-04-15 11:52:51.000885', NULL),
	(10000887, 10000001, 'PW21A-TS100218BL-S', 100218, 'NORTON MANX 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000886', '2021-04-15 11:52:51.000886', NULL),
	(10000888, 10000001, 'PW21A-TS100218BL-M', 100218, 'NORTON MANX 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000887', '2021-04-15 11:52:51.000887', NULL),
	(10000889, 10000001, 'PW21A-TS100218BL-L', 100218, 'NORTON MANX 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.000888', '2021-04-15 11:52:51.000888', NULL),
	(10000890, 10000001, 'PW21A-TS100218BL-XL', 100218, 'NORTON MANX 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000889', '2021-04-15 11:52:51.000889', NULL),
	(10000891, 10000001, 'PW21A-TS100218BL-XXL', 100218, 'NORTON MANX 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000890', '2021-04-15 11:52:51.000890', NULL),
	(10000892, 10000001, 'PW21A-TS100219BL-XS', 100219, 'KONOTORI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000891', '2021-04-15 11:52:51.000891', NULL),
	(10000893, 10000001, 'PW21A-TS100219BL-S', 100219, 'KONOTORI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.000892', '2021-04-15 11:52:51.000892', NULL),
	(10000894, 10000001, 'PW21A-TS100219BL-M', 100219, 'KONOTORI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.000893', '2021-04-15 11:52:51.000893', NULL),
	(10000895, 10000001, 'PW21A-TS100219BL-L', 100219, 'KONOTORI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 32, 1, 'Piece', '2021-04-15 11:52:51.000894', '2021-04-15 11:52:51.000894', NULL),
	(10000896, 10000001, 'PW21A-TS100219BL-XL', 100219, 'KONOTORI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.000895', '2021-04-15 11:52:51.000895', NULL),
	(10000897, 10000001, 'PW21A-TS100219BL-XXL', 100219, 'KONOTORI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000896', '2021-04-15 11:52:51.000896', NULL),
	(10000898, 10000001, 'PW21A-TS100220BL-XS', 100220, 'DEMAND FREEDOM TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000897', '2021-04-15 11:52:51.000897', NULL),
	(10000899, 10000001, 'PW21A-TS100220BL-S', 100220, 'DEMAND FREEDOM TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.000898', '2021-04-15 11:52:51.000898', NULL),
	(10000900, 10000001, 'PW21A-TS100220BL-M', 100220, 'DEMAND FREEDOM TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.000899', '2021-04-15 11:52:51.000899', NULL),
	(10000901, 10000001, 'PW21A-TS100220BL-L', 100220, 'DEMAND FREEDOM TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.000900', '2021-04-15 11:52:51.000900', NULL),
	(10000902, 10000001, 'PW21A-TS100220BL-XL', 100220, 'DEMAND FREEDOM TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000901', '2021-04-15 11:52:51.000901', NULL),
	(10000903, 10000001, 'PW21A-TS100220BL-XXL', 100220, 'DEMAND FREEDOM TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000902', '2021-04-15 11:52:51.000902', NULL),
	(10000904, 10000001, 'PW21A-TK100221BL-XS', 100221, 'RECKLESS LEAP KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000903', '2021-04-15 11:52:51.000903', NULL),
	(10000905, 10000001, 'PW21A-TK100221BL-S', 100221, 'RECKLESS LEAP KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000904', '2021-04-15 11:52:51.000904', NULL),
	(10000906, 10000001, 'PW21A-TK100221BL-M', 100221, 'RECKLESS LEAP KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000905', '2021-04-15 11:52:51.000905', NULL),
	(10000907, 10000001, 'PW21A-TK100221BL-L', 100221, 'RECKLESS LEAP KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.000906', '2021-04-15 11:52:51.000906', NULL),
	(10000908, 10000001, 'PW21A-TK100221BL-XL', 100221, 'RECKLESS LEAP KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000907', '2021-04-15 11:52:51.000907', NULL),
	(10000909, 10000001, 'PW21A-TK100221BL-XXL', 100221, 'RECKLESS LEAP KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000908', '2021-04-15 11:52:51.000908', NULL),
	(10000910, 10000001, 'PW21A-TS100222BL-XS', 100222, 'FREEDOM FIGHTER TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000909', '2021-04-15 11:52:51.000909', NULL),
	(10000911, 10000001, 'PW21A-TS100222BL-S', 100222, 'FREEDOM FIGHTER TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.000910', '2021-04-15 11:52:51.000910', NULL),
	(10000912, 10000001, 'PW21A-TS100222BL-M', 100222, 'FREEDOM FIGHTER TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.000911', '2021-04-15 11:52:51.000911', NULL),
	(10000913, 10000001, 'PW21A-TS100222BL-L', 100222, 'FREEDOM FIGHTER TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 32, 1, 'Piece', '2021-04-15 11:52:51.000912', '2021-04-15 11:52:51.000912', NULL),
	(10000914, 10000001, 'PW21A-TS100222BL-XL', 100222, 'FREEDOM FIGHTER TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000913', '2021-04-15 11:52:51.000913', NULL),
	(10000915, 10000001, 'PW21A-TS100222BL-XXL', 100222, 'FREEDOM FIGHTER TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000914', '2021-04-15 11:52:51.000914', NULL),
	(10000916, 10000001, 'PW21A-TS100223BL-XS', 100223, 'FREAKLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000915', '2021-04-15 11:52:51.000915', NULL),
	(10000917, 10000001, 'PW21A-TS100223BL-S', 100223, 'FREAKLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000916', '2021-04-15 11:52:51.000916', NULL),
	(10000918, 10000001, 'PW21A-TS100223BL-M', 100223, 'FREAKLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000917', '2021-04-15 11:52:51.000917', NULL),
	(10000919, 10000001, 'PW21A-TS100223BL-L', 100223, 'FREAKLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.000918', '2021-04-15 11:52:51.000918', NULL),
	(10000920, 10000001, 'PW21A-TS100223BL-XL', 100223, 'FREAKLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.000919', '2021-04-15 11:52:51.000919', NULL),
	(10000921, 10000001, 'PW21A-TS100223BL-XXL', 100223, 'FREAKLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000920', '2021-04-15 11:52:51.000920', NULL),
	(10000922, 10000001, 'PW21A-TK100224BL-XS', 100224, 'VINTAGE CAT KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000921', '2021-04-15 11:52:51.000921', NULL),
	(10000923, 10000001, 'PW21A-TK100224BL-S', 100224, 'VINTAGE CAT KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000922', '2021-04-15 11:52:51.000922', NULL),
	(10000924, 10000001, 'PW21A-TK100224BL-M', 100224, 'VINTAGE CAT KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000923', '2021-04-15 11:52:51.000923', NULL),
	(10000925, 10000001, 'PW21A-TK100224BL-L', 100224, 'VINTAGE CAT KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000924', '2021-04-15 11:52:51.000924', NULL),
	(10000926, 10000001, 'PW21A-TK100224BL-XL', 100224, 'VINTAGE CAT KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000925', '2021-04-15 11:52:51.000925', NULL),
	(10000927, 10000001, 'PW21A-TK100224BL-XXL', 100224, 'VINTAGE CAT KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000926', '2021-04-15 11:52:51.000926', NULL),
	(10000928, 10000001, 'PW21A-TK100225BL-XS', 100225, 'NORTON MANX KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000927', '2021-04-15 11:52:51.000927', NULL),
	(10000929, 10000001, 'PW21A-TK100225BL-S', 100225, 'NORTON MANX KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000928', '2021-04-15 11:52:51.000928', NULL),
	(10000930, 10000001, 'PW21A-TK100225BL-M', 100225, 'NORTON MANX KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000929', '2021-04-15 11:52:51.000929', NULL),
	(10000931, 10000001, 'PW21A-TK100225BL-L', 100225, 'NORTON MANX KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.000930', '2021-04-15 11:52:51.000930', NULL),
	(10000932, 10000001, 'PW21A-TK100225BL-XL', 100225, 'NORTON MANX KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000931', '2021-04-15 11:52:51.000931', NULL),
	(10000933, 10000001, 'PW21A-TK100225BL-XXL', 100225, 'NORTON MANX KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000932', '2021-04-15 11:52:51.000932', NULL),
	(10000934, 10000001, 'PW21A-TS100226BL-XS', 100226, 'WOLF SPIRIT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000933', '2021-04-15 11:52:51.000933', NULL),
	(10000935, 10000001, 'PW21A-TS100226BL-S', 100226, 'WOLF SPIRIT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000934', '2021-04-15 11:52:51.000934', NULL),
	(10000936, 10000001, 'PW21A-TS100226BL-M', 100226, 'WOLF SPIRIT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000935', '2021-04-15 11:52:51.000935', NULL),
	(10000937, 10000001, 'PW21A-TS100226BL-L', 100226, 'WOLF SPIRIT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.000936', '2021-04-15 11:52:51.000936', NULL),
	(10000938, 10000001, 'PW21A-TS100226BL-XL', 100226, 'WOLF SPIRIT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000937', '2021-04-15 11:52:51.000937', NULL),
	(10000939, 10000001, 'PW21A-TS100226BL-XXL', 100226, 'WOLF SPIRIT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000938', '2021-04-15 11:52:51.000938', NULL),
	(10000940, 10000001, 'PW21A-TK100227BL-XS', 100227, 'GREEDY SOUL KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000939', '2021-04-15 11:52:51.000939', NULL),
	(10000941, 10000001, 'PW21A-TK100227BL-S', 100227, 'GREEDY SOUL KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000940', '2021-04-15 11:52:51.000940', NULL),
	(10000942, 10000001, 'PW21A-TK100227BL-M', 100227, 'GREEDY SOUL KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.000941', '2021-04-15 11:52:51.000941', NULL),
	(10000943, 10000001, 'PW21A-TK100227BL-L', 100227, 'GREEDY SOUL KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000942', '2021-04-15 11:52:51.000942', NULL),
	(10000944, 10000001, 'PW21A-TK100227BL-XL', 100227, 'GREEDY SOUL KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000943', '2021-04-15 11:52:51.000943', NULL),
	(10000945, 10000001, 'PW21A-TK100227BL-XXL', 100227, 'GREEDY SOUL KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000944', '2021-04-15 11:52:51.000944', NULL),
	(10000946, 10000001, 'PW21A-TS100228BL-XS', 100228, 'REVENGER TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000945', '2021-04-15 11:52:51.000945', NULL),
	(10000947, 10000001, 'PW21A-TS100228BL-S', 100228, 'REVENGER TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.000946', '2021-04-15 11:52:51.000946', NULL),
	(10000948, 10000001, 'PW21A-TS100228BL-M', 100228, 'REVENGER TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000947', '2021-04-15 11:52:51.000947', NULL),
	(10000949, 10000001, 'PW21A-TS100228BL-L', 100228, 'REVENGER TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000948', '2021-04-15 11:52:51.000948', NULL),
	(10000950, 10000001, 'PW21A-TS100228BL-XL', 100228, 'REVENGER TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000949', '2021-04-15 11:52:51.000949', NULL),
	(10000951, 10000001, 'PW21A-TS100228BL-XXL', 100228, 'REVENGER TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000950', '2021-04-15 11:52:51.000950', NULL),
	(10000952, 10000001, 'PW21A-TK100229BL-XS', 100229, 'EL FUERTE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000951', '2021-04-15 11:52:51.000951', NULL),
	(10000953, 10000001, 'PW21A-TK100229BL-S', 100229, 'EL FUERTE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000952', '2021-04-15 11:52:51.000952', NULL),
	(10000954, 10000001, 'PW21A-TK100229BL-M', 100229, 'EL FUERTE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000953', '2021-04-15 11:52:51.000953', NULL),
	(10000955, 10000001, 'PW21A-TK100229BL-L', 100229, 'EL FUERTE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.000954', '2021-04-15 11:52:51.000954', NULL),
	(10000956, 10000001, 'PW21A-TK100229BL-XL', 100229, 'EL FUERTE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000955', '2021-04-15 11:52:51.000955', NULL),
	(10000957, 10000001, 'PW21A-TK100229BL-XXL', 100229, 'EL FUERTE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000956', '2021-04-15 11:52:51.000956', NULL),
	(10000958, 10000001, 'PW21A-TK100230BL-XS', 100230, 'FREEDOM DIVISION KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000957', '2021-04-15 11:52:51.000957', NULL),
	(10000959, 10000001, 'PW21A-TK100230BL-S', 100230, 'FREEDOM DIVISION KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000958', '2021-04-15 11:52:51.000958', NULL),
	(10000960, 10000001, 'PW21A-TK100230BL-M', 100230, 'FREEDOM DIVISION KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.000959', '2021-04-15 11:52:51.000959', NULL),
	(10000961, 10000001, 'PW21A-TK100230BL-L', 100230, 'FREEDOM DIVISION KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.000960', '2021-04-15 11:52:51.000960', NULL),
	(10000962, 10000001, 'PW21A-TK100230BL-XL', 100230, 'FREEDOM DIVISION KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.000961', '2021-04-15 11:52:51.000961', NULL),
	(10000963, 10000001, 'PW21A-TK100230BL-XXL', 100230, 'FREEDOM DIVISION KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000962', '2021-04-15 11:52:51.000962', NULL),
	(10000964, 10000001, 'PW21A-TS100231BL-XS', 100231, 'AKUMA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000963', '2021-04-15 11:52:51.000963', NULL),
	(10000965, 10000001, 'PW21A-TS100231BL-S', 100231, 'AKUMA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000964', '2021-04-15 11:52:51.000964', NULL),
	(10000966, 10000001, 'PW21A-TS100231BL-M', 100231, 'AKUMA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000965', '2021-04-15 11:52:51.000965', NULL),
	(10000967, 10000001, 'PW21A-TS100231BL-L', 100231, 'AKUMA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000966', '2021-04-15 11:52:51.000966', NULL),
	(10000968, 10000001, 'PW21A-TS100231BL-XL', 100231, 'AKUMA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000967', '2021-04-15 11:52:51.000967', NULL),
	(10000969, 10000001, 'PW21A-TS100231BL-XXL', 100231, 'AKUMA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000968', '2021-04-15 11:52:51.000968', NULL),
	(10000970, 10000001, 'PW21A-TK100232GN-XS', 100232, 'SPEED JUNKIES KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000969', '2021-04-15 11:52:51.000969', NULL),
	(10000971, 10000001, 'PW21A-TK100232GN-S', 100232, 'SPEED JUNKIES KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000970', '2021-04-15 11:52:51.000970', NULL),
	(10000972, 10000001, 'PW21A-TK100232GN-M', 100232, 'SPEED JUNKIES KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000971', '2021-04-15 11:52:51.000971', NULL),
	(10000973, 10000001, 'PW21A-TK100232GN-L', 100232, 'SPEED JUNKIES KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000972', '2021-04-15 11:52:51.000972', NULL),
	(10000974, 10000001, 'PW21A-TK100232GN-XL', 100232, 'SPEED JUNKIES KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000973', '2021-04-15 11:52:51.000973', NULL),
	(10000975, 10000001, 'PW21A-TK100232GN-XXL', 100232, 'SPEED JUNKIES KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000974', '2021-04-15 11:52:51.000974', NULL),
	(10000976, 10000001, 'PW21A-TS100233BL-XS', 100233, 'SENSHI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000975', '2021-04-15 11:52:51.000975', NULL),
	(10000977, 10000001, 'PW21A-TS100233BL-S', 100233, 'SENSHI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000976', '2021-04-15 11:52:51.000976', NULL),
	(10000978, 10000001, 'PW21A-TS100233BL-M', 100233, 'SENSHI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000977', '2021-04-15 11:52:51.000977', NULL),
	(10000979, 10000001, 'PW21A-TS100233BL-L', 100233, 'SENSHI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000978', '2021-04-15 11:52:51.000978', NULL),
	(10000980, 10000001, 'PW21A-TS100233BL-XL', 100233, 'SENSHI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000979', '2021-04-15 11:52:51.000979', NULL),
	(10000981, 10000001, 'PW21A-TS100233BL-XXL', 100233, 'SENSHI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000980', '2021-04-15 11:52:51.000980', NULL),
	(10000982, 10000001, 'PW21A-TK100234BL-XS', 100234, 'HERITAGE TEE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000981', '2021-04-15 11:52:51.000981', NULL),
	(10000983, 10000001, 'PW21A-TK100234BL-S', 100234, 'HERITAGE TEE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000982', '2021-04-15 11:52:51.000982', NULL),
	(10000984, 10000001, 'PW21A-TK100234BL-M', 100234, 'HERITAGE TEE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000983', '2021-04-15 11:52:51.000983', NULL),
	(10000985, 10000001, 'PW21A-TK100234BL-L', 100234, 'HERITAGE TEE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000984', '2021-04-15 11:52:51.000984', NULL),
	(10000986, 10000001, 'PW21A-TK100234BL-XL', 100234, 'HERITAGE TEE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000985', '2021-04-15 11:52:51.000985', NULL),
	(10000987, 10000001, 'PW21A-TK100234BL-XXL', 100234, 'HERITAGE TEE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000986', '2021-04-15 11:52:51.000986', NULL),
	(10000988, 10000001, 'PW21A-TS100235BL-XS', 100235, 'UMA SENSHI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000987', '2021-04-15 11:52:51.000987', NULL),
	(10000989, 10000001, 'PW21A-TS100235BL-S', 100235, 'UMA SENSHI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000988', '2021-04-15 11:52:51.000988', NULL),
	(10000990, 10000001, 'PW21A-TS100235BL-M', 100235, 'UMA SENSHI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000989', '2021-04-15 11:52:51.000989', NULL),
	(10000991, 10000001, 'PW21A-TS100235BL-L', 100235, 'UMA SENSHI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000990', '2021-04-15 11:52:51.000990', NULL),
	(10000992, 10000001, 'PW21A-TS100235BL-XL', 100235, 'UMA SENSHI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000991', '2021-04-15 11:52:51.000991', NULL),
	(10000993, 10000001, 'PW21A-TS100235BL-XXL', 100235, 'UMA SENSHI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000992', '2021-04-15 11:52:51.000992', NULL),
	(10000994, 10000001, 'PW21A-TK100236WT-XS', 100236, 'BIG BAD WOLF KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000993', '2021-04-15 11:52:51.000993', NULL),
	(10000995, 10000001, 'PW21A-TK100236WT-S', 100236, 'BIG BAD WOLF KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000994', '2021-04-15 11:52:51.000994', NULL),
	(10000996, 10000001, 'PW21A-TK100236WT-M', 100236, 'BIG BAD WOLF KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.000995', '2021-04-15 11:52:51.000995', NULL),
	(10000997, 10000001, 'PW21A-TK100236WT-L', 100236, 'BIG BAD WOLF KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.000996', '2021-04-15 11:52:51.000996', NULL),
	(10000998, 10000001, 'PW21A-TK100236WT-XL', 100236, 'BIG BAD WOLF KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.000997', '2021-04-15 11:52:51.000997', NULL),
	(10000999, 10000001, 'PW21A-TK100236WT-XXL', 100236, 'BIG BAD WOLF KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.000998', '2021-04-15 11:52:51.000998', NULL),
	(10001000, 10000001, 'PW21A-TS100237BL-XS', 100237, 'SAKURAGI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.000999', '2021-04-15 11:52:51.000999', NULL),
	(10001001, 10000001, 'PW21A-TS100237BL-S', 100237, 'SAKURAGI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001000', '2021-04-15 11:52:51.001000', NULL),
	(10001002, 10000001, 'PW21A-TS100237BL-M', 100237, 'SAKURAGI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001001', '2021-04-15 11:52:51.001001', NULL),
	(10001003, 10000001, 'PW21A-TS100237BL-L', 100237, 'SAKURAGI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001002', '2021-04-15 11:52:51.001002', NULL),
	(10001004, 10000001, 'PW21A-TS100237BL-XL', 100237, 'SAKURAGI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001003', '2021-04-15 11:52:51.001003', NULL),
	(10001005, 10000001, 'PW21A-TS100237BL-XXL', 100237, 'SAKURAGI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001004', '2021-04-15 11:52:51.001004', NULL),
	(10001006, 10000001, 'PW21A-TS100238BL-XS', 100238, 'KEMONO TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001005', '2021-04-15 11:52:51.001005', NULL),
	(10001007, 10000001, 'PW21A-TS100238BL-S', 100238, 'KEMONO TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001006', '2021-04-15 11:52:51.001006', NULL),
	(10001008, 10000001, 'PW21A-TS100238BL-M', 100238, 'KEMONO TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001007', '2021-04-15 11:52:51.001007', NULL),
	(10001009, 10000001, 'PW21A-TS100238BL-L', 100238, 'KEMONO TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001008', '2021-04-15 11:52:51.001008', NULL),
	(10001010, 10000001, 'PW21A-TS100238BL-XL', 100238, 'KEMONO TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001009', '2021-04-15 11:52:51.001009', NULL),
	(10001011, 10000001, 'PW21A-TS100238BL-XXL', 100238, 'KEMONO TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001010', '2021-04-15 11:52:51.001010', NULL),
	(10001012, 10000001, 'PW21A-TK100239OG-XS', 100239, 'EASY WAY KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001011', '2021-04-15 11:52:51.001011', NULL),
	(10001013, 10000001, 'PW21A-TK100239OG-S', 100239, 'EASY WAY KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001012', '2021-04-15 11:52:51.001012', NULL),
	(10001014, 10000001, 'PW21A-TK100239OG-M', 100239, 'EASY WAY KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001013', '2021-04-15 11:52:51.001013', NULL),
	(10001015, 10000001, 'PW21A-TK100239OG-L', 100239, 'EASY WAY KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001014', '2021-04-15 11:52:51.001014', NULL),
	(10001016, 10000001, 'PW21A-TK100239OG-XL', 100239, 'EASY WAY KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001015', '2021-04-15 11:52:51.001015', NULL),
	(10001017, 10000001, 'PW21A-TK100239OG-XXL', 100239, 'EASY WAY KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001016', '2021-04-15 11:52:51.001016', NULL),
	(10001018, 10000001, 'PW21A-TK100240OG-XS', 100240, 'THE BRAVE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001017', '2021-04-15 11:52:51.001017', NULL),
	(10001019, 10000001, 'PW21A-TK100240OG-S', 100240, 'THE BRAVE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001018', '2021-04-15 11:52:51.001018', NULL),
	(10001020, 10000001, 'PW21A-TK100240OG-M', 100240, 'THE BRAVE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001019', '2021-04-15 11:52:51.001019', NULL),
	(10001021, 10000001, 'PW21A-TK100240OG-L', 100240, 'THE BRAVE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001020', '2021-04-15 11:52:51.001020', NULL),
	(10001022, 10000001, 'PW21A-TK100240OG-XL', 100240, 'THE BRAVE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001021', '2021-04-15 11:52:51.001021', NULL),
	(10001023, 10000001, 'PW21A-TK100240OG-XXL', 100240, 'THE BRAVE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001022', '2021-04-15 11:52:51.001022', NULL),
	(10001024, 10000001, 'PW21A-TS100241YW -XS', 100241, 'FORTIUS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001023', '2021-04-15 11:52:51.001023', NULL),
	(10001025, 10000001, 'PW21A-TS100241YW -S', 100241, 'FORTIUS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001024', '2021-04-15 11:52:51.001024', NULL),
	(10001026, 10000001, 'PW21A-TS100241YW -M', 100241, 'FORTIUS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001025', '2021-04-15 11:52:51.001025', NULL),
	(10001027, 10000001, 'PW21A-TS100241YW -L', 100241, 'FORTIUS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001026', '2021-04-15 11:52:51.001026', NULL),
	(10001028, 10000001, 'PW21A-TS100241YW -XL', 100241, 'FORTIUS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001027', '2021-04-15 11:52:51.001027', NULL),
	(10001029, 10000001, 'PW21A-TS100241YW -XXL', 100241, 'FORTIUS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001028', '2021-04-15 11:52:51.001028', NULL),
	(10001030, 10000001, 'PW21A-TS100242BL-XS', 100242, 'MOTOR CULTURE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001029', '2021-04-15 11:52:51.001029', NULL),
	(10001031, 10000001, 'PW21A-TS100242BL-S', 100242, 'MOTOR CULTURE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.001030', '2021-04-15 11:52:51.001030', NULL),
	(10001032, 10000001, 'PW21A-TS100242BL-M', 100242, 'MOTOR CULTURE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 22, 1, 'Piece', '2021-04-15 11:52:51.001031', '2021-04-15 11:52:51.001031', NULL),
	(10001033, 10000001, 'PW21A-TS100242BL-L', 100242, 'MOTOR CULTURE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.001032', '2021-04-15 11:52:51.001032', NULL),
	(10001034, 10000001, 'PW21A-TS100242BL-XL', 100242, 'MOTOR CULTURE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001033', '2021-04-15 11:52:51.001033', NULL),
	(10001035, 10000001, 'PW21A-TS100242BL-XXL', 100242, 'MOTOR CULTURE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001034', '2021-04-15 11:52:51.001034', NULL),
	(10001036, 10000001, 'PW21A-TK100243BL-XS', 100243, 'NO FEAR KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001035', '2021-04-15 11:52:51.001035', NULL),
	(10001037, 10000001, 'PW21A-TK100243BL-S', 100243, 'NO FEAR KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001036', '2021-04-15 11:52:51.001036', NULL),
	(10001038, 10000001, 'PW21A-TK100243BL-M', 100243, 'NO FEAR KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001037', '2021-04-15 11:52:51.001037', NULL),
	(10001039, 10000001, 'PW21A-TK100243BL-L', 100243, 'NO FEAR KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001038', '2021-04-15 11:52:51.001038', NULL),
	(10001040, 10000001, 'PW21A-TK100243BL-XL', 100243, 'NO FEAR KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001039', '2021-04-15 11:52:51.001039', NULL),
	(10001041, 10000001, 'PW21A-TK100243BL-XXL', 100243, 'NO FEAR KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001040', '2021-04-15 11:52:51.001040', NULL),
	(10001042, 10000001, 'PW21A-TS100244BL-XS', 100244, 'THE STRONGEST 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001041', '2021-04-15 11:52:51.001041', NULL),
	(10001043, 10000001, 'PW21A-TS100244BL-S', 100244, 'THE STRONGEST 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001042', '2021-04-15 11:52:51.001042', NULL),
	(10001044, 10000001, 'PW21A-TS100244BL-M', 100244, 'THE STRONGEST 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001043', '2021-04-15 11:52:51.001043', NULL),
	(10001045, 10000001, 'PW21A-TS100244BL-L', 100244, 'THE STRONGEST 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001044', '2021-04-15 11:52:51.001044', NULL),
	(10001046, 10000001, 'PW21A-TS100244BL-XL', 100244, 'THE STRONGEST 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001045', '2021-04-15 11:52:51.001045', NULL),
	(10001047, 10000001, 'PW21A-TS100244BL-XXL', 100244, 'THE STRONGEST 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001046', '2021-04-15 11:52:51.001046', NULL),
	(10001048, 10000001, 'PW21A-TS100245RD-XS', 100245, 'RIDE AND FREE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001047', '2021-04-15 11:52:51.001047', NULL),
	(10001049, 10000001, 'PW21A-TS100245RD-S', 100245, 'RIDE AND FREE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001048', '2021-04-15 11:52:51.001048', NULL),
	(10001050, 10000001, 'PW21A-TS100245RD-M', 100245, 'RIDE AND FREE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001049', '2021-04-15 11:52:51.001049', NULL),
	(10001051, 10000001, 'PW21A-TS100245RD-L', 100245, 'RIDE AND FREE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001050', '2021-04-15 11:52:51.001050', NULL),
	(10001052, 10000001, 'PW21A-TS100245RD-XL', 100245, 'RIDE AND FREE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001051', '2021-04-15 11:52:51.001051', NULL),
	(10001053, 10000001, 'PW21A-TS100245RD-XXL', 100245, 'RIDE AND FREE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001052', '2021-04-15 11:52:51.001052', NULL),
	(10001054, 10000001, 'PW21A-TK100246BL-XS', 100246, 'LOCAL FIGHTER KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001053', '2021-04-15 11:52:51.001053', NULL),
	(10001055, 10000001, 'PW21A-TK100246BL-S', 100246, 'LOCAL FIGHTER KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001054', '2021-04-15 11:52:51.001054', NULL),
	(10001056, 10000001, 'PW21A-TK100246BL-M', 100246, 'LOCAL FIGHTER KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001055', '2021-04-15 11:52:51.001055', NULL),
	(10001057, 10000001, 'PW21A-TK100246BL-L', 100246, 'LOCAL FIGHTER KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001056', '2021-04-15 11:52:51.001056', NULL),
	(10001058, 10000001, 'PW21A-TK100246BL-XL', 100246, 'LOCAL FIGHTER KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001057', '2021-04-15 11:52:51.001057', NULL),
	(10001059, 10000001, 'PW21A-TK100246BL-XXL', 100246, 'LOCAL FIGHTER KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001058', '2021-04-15 11:52:51.001058', NULL),
	(10001060, 10000001, 'PW21A-TS100247NV-XS', 100247, 'GRAND PRIX TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001059', '2021-04-15 11:52:51.001059', NULL),
	(10001061, 10000001, 'PW21A-TS100247NV-S', 100247, 'GRAND PRIX TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001060', '2021-04-15 11:52:51.001060', NULL),
	(10001062, 10000001, 'PW21A-TS100247NV-M', 100247, 'GRAND PRIX TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001061', '2021-04-15 11:52:51.001061', NULL),
	(10001063, 10000001, 'PW21A-TS100247NV-L', 100247, 'GRAND PRIX TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001062', '2021-04-15 11:52:51.001062', NULL),
	(10001064, 10000001, 'PW21A-TS100247NV-XL', 100247, 'GRAND PRIX TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001063', '2021-04-15 11:52:51.001063', NULL),
	(10001065, 10000001, 'PW21A-TS100247NV-XXL', 100247, 'GRAND PRIX TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001064', '2021-04-15 11:52:51.001064', NULL),
	(10001066, 10000001, 'PW21A-TS100248BL-XS', 100248, 'NEVER QUIT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001065', '2021-04-15 11:52:51.001065', NULL),
	(10001067, 10000001, 'PW21A-TS100248BL-S', 100248, 'NEVER QUIT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.001066', '2021-04-15 11:52:51.001066', NULL),
	(10001068, 10000001, 'PW21A-TS100248BL-M', 100248, 'NEVER QUIT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.001067', '2021-04-15 11:52:51.001067', NULL),
	(10001069, 10000001, 'PW21A-TS100248BL-L', 100248, 'NEVER QUIT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 31, 1, 'Piece', '2021-04-15 11:52:51.001068', '2021-04-15 11:52:51.001068', NULL),
	(10001070, 10000001, 'PW21A-TS100248BL-XL', 100248, 'NEVER QUIT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001069', '2021-04-15 11:52:51.001069', NULL),
	(10001071, 10000001, 'PW21A-TS100248BL-XXL', 100248, 'NEVER QUIT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001070', '2021-04-15 11:52:51.001070', NULL),
	(10001072, 10000001, 'PW21A-TK100249WT-XS', 100249, 'SEISHIN KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001071', '2021-04-15 11:52:51.001071', NULL),
	(10001073, 10000001, 'PW21A-TK100249WT-S', 100249, 'SEISHIN KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001072', '2021-04-15 11:52:51.001072', NULL),
	(10001074, 10000001, 'PW21A-TK100249WT-M', 100249, 'SEISHIN KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001073', '2021-04-15 11:52:51.001073', NULL),
	(10001075, 10000001, 'PW21A-TK100249WT-L', 100249, 'SEISHIN KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001074', '2021-04-15 11:52:51.001074', NULL),
	(10001076, 10000001, 'PW21A-TK100249WT-XL', 100249, 'SEISHIN KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001075', '2021-04-15 11:52:51.001075', NULL),
	(10001077, 10000001, 'PW21A-TK100249WT-XXL', 100249, 'SEISHIN KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001076', '2021-04-15 11:52:51.001076', NULL),
	(10001078, 10000001, 'PW21A-TS100250WT-XS', 100250, 'SEISHIN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001077', '2021-04-15 11:52:51.001077', NULL),
	(10001079, 10000001, 'PW21A-TS100250WT-S', 100250, 'SEISHIN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001078', '2021-04-15 11:52:51.001078', NULL),
	(10001080, 10000001, 'PW21A-TS100250WT-M', 100250, 'SEISHIN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001079', '2021-04-15 11:52:51.001079', NULL),
	(10001081, 10000001, 'PW21A-TS100250WT-L', 100250, 'SEISHIN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001080', '2021-04-15 11:52:51.001080', NULL),
	(10001082, 10000001, 'PW21A-TS100250WT-XL', 100250, 'SEISHIN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001081', '2021-04-15 11:52:51.001081', NULL),
	(10001083, 10000001, 'PW21A-TS100250WT-XXL', 100250, 'SEISHIN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001082', '2021-04-15 11:52:51.001082', NULL),
	(10001084, 10000001, 'PW21A-TS100251BL-XS', 100251, 'DEATH GLORY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001083', '2021-04-15 11:52:51.001083', NULL),
	(10001085, 10000001, 'PW21A-TS100251BL-S', 100251, 'DEATH GLORY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001084', '2021-04-15 11:52:51.001084', NULL),
	(10001086, 10000001, 'PW21A-TS100251BL-M', 100251, 'DEATH GLORY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001085', '2021-04-15 11:52:51.001085', NULL),
	(10001087, 10000001, 'PW21A-TS100251BL-L', 100251, 'DEATH GLORY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001086', '2021-04-15 11:52:51.001086', NULL),
	(10001088, 10000001, 'PW21A-TS100251BL-XL', 100251, 'DEATH GLORY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001087', '2021-04-15 11:52:51.001087', NULL),
	(10001089, 10000001, 'PW21A-TS100251BL-XXL', 100251, 'DEATH GLORY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001088', '2021-04-15 11:52:51.001088', NULL),
	(10001090, 10000001, 'PW21A-TS100252WT-XS', 100252, 'DARUMA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001089', '2021-04-15 11:52:51.001089', NULL),
	(10001091, 10000001, 'PW21A-TS100252WT-S', 100252, 'DARUMA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.001090', '2021-04-15 11:52:51.001090', NULL),
	(10001092, 10000001, 'PW21A-TS100252WT-M', 100252, 'DARUMA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 28, 1, 'Piece', '2021-04-15 11:52:51.001091', '2021-04-15 11:52:51.001091', NULL),
	(10001093, 10000001, 'PW21A-TS100252WT-L', 100252, 'DARUMA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 38, 1, 'Piece', '2021-04-15 11:52:51.001092', '2021-04-15 11:52:51.001092', NULL),
	(10001094, 10000001, 'PW21A-TS100252WT-XL', 100252, 'DARUMA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.001093', '2021-04-15 11:52:51.001093', NULL),
	(10001095, 10000001, 'PW21A-TS100252WT-XXL', 100252, 'DARUMA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001094', '2021-04-15 11:52:51.001094', NULL),
	(10001096, 10000001, 'PW21A-TS100253BL-XS', 100253, 'DIGGER FREAK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001095', '2021-04-15 11:52:51.001095', NULL),
	(10001097, 10000001, 'PW21A-TS100253BL-S', 100253, 'DIGGER FREAK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.001096', '2021-04-15 11:52:51.001096', NULL),
	(10001098, 10000001, 'PW21A-TS100253BL-M', 100253, 'DIGGER FREAK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.001097', '2021-04-15 11:52:51.001097', NULL),
	(10001099, 10000001, 'PW21A-TS100253BL-L', 100253, 'DIGGER FREAK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001098', '2021-04-15 11:52:51.001098', NULL),
	(10001100, 10000001, 'PW21A-TS100253BL-XL', 100253, 'DIGGER FREAK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001099', '2021-04-15 11:52:51.001099', NULL),
	(10001101, 10000001, 'PW21A-TS100253BL-XXL', 100253, 'DIGGER FREAK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001100', '2021-04-15 11:52:51.001100', NULL),
	(10001102, 10000001, 'PW21A-TK100254BL-XS', 100254, 'UMA SENSHI KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001101', '2021-04-15 11:52:51.001101', NULL),
	(10001103, 10000001, 'PW21A-TK100254BL-S', 100254, 'UMA SENSHI KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001102', '2021-04-15 11:52:51.001102', NULL),
	(10001104, 10000001, 'PW21A-TK100254BL-M', 100254, 'UMA SENSHI KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001103', '2021-04-15 11:52:51.001103', NULL),
	(10001105, 10000001, 'PW21A-TK100254BL-L', 100254, 'UMA SENSHI KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001104', '2021-04-15 11:52:51.001104', NULL),
	(10001106, 10000001, 'PW21A-TK100254BL-XL', 100254, 'UMA SENSHI KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001105', '2021-04-15 11:52:51.001105', NULL),
	(10001107, 10000001, 'PW21A-TK100254BL-XXL', 100254, 'UMA SENSHI KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001106', '2021-04-15 11:52:51.001106', NULL),
	(10001108, 10000001, 'PW21A-TS100255BL-XS', 100255, 'VENOM TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001107', '2021-04-15 11:52:51.001107', NULL),
	(10001109, 10000001, 'PW21A-TS100255BL-S', 100255, 'VENOM TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.001108', '2021-04-15 11:52:51.001108', NULL),
	(10001110, 10000001, 'PW21A-TS100255BL-M', 100255, 'VENOM TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001109', '2021-04-15 11:52:51.001109', NULL),
	(10001111, 10000001, 'PW21A-TS100255BL-L', 100255, 'VENOM TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 44, 1, 'Piece', '2021-04-15 11:52:51.001110', '2021-04-15 11:52:51.001110', NULL),
	(10001112, 10000001, 'PW21A-TS100255BL-XL', 100255, 'VENOM TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.001111', '2021-04-15 11:52:51.001111', NULL),
	(10001113, 10000001, 'PW21A-TS100255BL-XXL', 100255, 'VENOM TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001112', '2021-04-15 11:52:51.001112', NULL),
	(10001114, 10000001, 'PW21A-TK100256BL-XS', 100256, 'LIBERATOR TEE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001113', '2021-04-15 11:52:51.001113', NULL),
	(10001115, 10000001, 'PW21A-TK100256BL-S', 100256, 'LIBERATOR TEE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001114', '2021-04-15 11:52:51.001114', NULL),
	(10001116, 10000001, 'PW21A-TK100256BL-M', 100256, 'LIBERATOR TEE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001115', '2021-04-15 11:52:51.001115', NULL),
	(10001117, 10000001, 'PW21A-TK100256BL-L', 100256, 'LIBERATOR TEE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001116', '2021-04-15 11:52:51.001116', NULL),
	(10001118, 10000001, 'PW21A-TK100256BL-XL', 100256, 'LIBERATOR TEE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001117', '2021-04-15 11:52:51.001117', NULL),
	(10001119, 10000001, 'PW21A-TK100256BL-XXL', 100256, 'LIBERATOR TEE KIDS', 11, 'T-Shirt Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001118', '2021-04-15 11:52:51.001118', NULL),
	(10001120, 10000001, 'PW21A-TS100257WT-XS', 100257, 'SASORI TEE 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001119', '2021-04-15 11:52:51.001119', NULL),
	(10001121, 10000001, 'PW21A-TS100257WT-S', 100257, 'SASORI TEE 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001120', '2021-04-15 11:52:51.001120', NULL),
	(10001122, 10000001, 'PW21A-TS100257WT-M', 100257, 'SASORI TEE 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001121', '2021-04-15 11:52:51.001121', NULL),
	(10001123, 10000001, 'PW21A-TS100257WT-L', 100257, 'SASORI TEE 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001122', '2021-04-15 11:52:51.001122', NULL),
	(10001124, 10000001, 'PW21A-TS100257WT-XL', 100257, 'SASORI TEE 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001123', '2021-04-15 11:52:51.001123', NULL),
	(10001125, 10000001, 'PW21A-TS100257WT-XXL', 100257, 'SASORI TEE 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001124', '2021-04-15 11:52:51.001124', NULL),
	(10001126, 10000001, 'PW21A-TS100258WT-XS', 100258, 'COBALT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001125', '2021-04-15 11:52:51.001125', NULL),
	(10001127, 10000001, 'PW21A-TS100258WT-S', 100258, 'COBALT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.001126', '2021-04-15 11:52:51.001126', NULL),
	(10001128, 10000001, 'PW21A-TS100258WT-M', 100258, 'COBALT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.001127', '2021-04-15 11:52:51.001127', NULL),
	(10001129, 10000001, 'PW21A-TS100258WT-L', 100258, 'COBALT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 26, 1, 'Piece', '2021-04-15 11:52:51.001128', '2021-04-15 11:52:51.001128', NULL),
	(10001130, 10000001, 'PW21A-TS100258WT-XL', 100258, 'COBALT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.001129', '2021-04-15 11:52:51.001129', NULL),
	(10001131, 10000001, 'PW21A-TS100258WT-XXL', 100258, 'COBALT TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001130', '2021-04-15 11:52:51.001130', NULL),
	(10001132, 10000001, 'PW21A-TS100259BL-XS', 100259, 'DEADSOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001131', '2021-04-15 11:52:51.001131', NULL),
	(10001133, 10000001, 'PW21A-TS100259BL-S', 100259, 'DEADSOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.001132', '2021-04-15 11:52:51.001132', NULL),
	(10001134, 10000001, 'PW21A-TS100259BL-M', 100259, 'DEADSOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.001133', '2021-04-15 11:52:51.001133', NULL),
	(10001135, 10000001, 'PW21A-TS100259BL-L', 100259, 'DEADSOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.001134', '2021-04-15 11:52:51.001134', NULL),
	(10001136, 10000001, 'PW21A-TS100259BL-XL', 100259, 'DEADSOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.001135', '2021-04-15 11:52:51.001135', NULL),
	(10001137, 10000001, 'PW21A-TS100259BL-XXL', 100259, 'DEADSOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001136', '2021-04-15 11:52:51.001136', NULL),
	(10001138, 10000001, 'PW21A-TS100260BL-XS', 100260, 'OKAMI DEMON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001137', '2021-04-15 11:52:51.001137', NULL),
	(10001139, 10000001, 'PW21A-TS100260BL-S', 100260, 'OKAMI DEMON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001138', '2021-04-15 11:52:51.001138', NULL),
	(10001140, 10000001, 'PW21A-TS100260BL-M', 100260, 'OKAMI DEMON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 38, 1, 'Piece', '2021-04-15 11:52:51.001139', '2021-04-15 11:52:51.001139', NULL),
	(10001141, 10000001, 'PW21A-TS100260BL-L', 100260, 'OKAMI DEMON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 49, 1, 'Piece', '2021-04-15 11:52:51.001140', '2021-04-15 11:52:51.001140', NULL),
	(10001142, 10000001, 'PW21A-TS100260BL-XL', 100260, 'OKAMI DEMON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.001141', '2021-04-15 11:52:51.001141', NULL),
	(10001143, 10000001, 'PW21A-TS100260BL-XXL', 100260, 'OKAMI DEMON', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001142', '2021-04-15 11:52:51.001142', NULL),
	(10001144, 10000001, 'PW21A-TS100261BL-XS', 100261, 'FLYING SKULL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001143', '2021-04-15 11:52:51.001143', NULL),
	(10001145, 10000001, 'PW21A-TS100261BL-S', 100261, 'FLYING SKULL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.001144', '2021-04-15 11:52:51.001144', NULL),
	(10001146, 10000001, 'PW21A-TS100261BL-M', 100261, 'FLYING SKULL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 22, 1, 'Piece', '2021-04-15 11:52:51.001145', '2021-04-15 11:52:51.001145', NULL),
	(10001147, 10000001, 'PW21A-TS100261BL-L', 100261, 'FLYING SKULL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001146', '2021-04-15 11:52:51.001146', NULL),
	(10001148, 10000001, 'PW21A-TS100261BL-XL', 100261, 'FLYING SKULL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001147', '2021-04-15 11:52:51.001147', NULL),
	(10001149, 10000001, 'PW21A-TS100261BL-XXL', 100261, 'FLYING SKULL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001148', '2021-04-15 11:52:51.001148', NULL),
	(10001150, 10000001, 'PW21A-TS100262BL-XS', 100262, 'RAIJIN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001149', '2021-04-15 11:52:51.001149', NULL),
	(10001151, 10000001, 'PW21A-TS100262BL-S', 100262, 'RAIJIN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 28, 1, 'Piece', '2021-04-15 11:52:51.001150', '2021-04-15 11:52:51.001150', NULL),
	(10001152, 10000001, 'PW21A-TS100262BL-M', 100262, 'RAIJIN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 36, 1, 'Piece', '2021-04-15 11:52:51.001151', '2021-04-15 11:52:51.001151', NULL),
	(10001153, 10000001, 'PW21A-TS100262BL-L', 100262, 'RAIJIN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 43, 1, 'Piece', '2021-04-15 11:52:51.001152', '2021-04-15 11:52:51.001152', NULL),
	(10001154, 10000001, 'PW21A-TS100262BL-XL', 100262, 'RAIJIN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.001153', '2021-04-15 11:52:51.001153', NULL),
	(10001155, 10000001, 'PW21A-TS100262BL-XXL', 100262, 'RAIJIN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001154', '2021-04-15 11:52:51.001154', NULL),
	(10001156, 10000001, 'PW21A-TS100263BL-XS', 100263, 'KIRIN GIVEAWAY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001155', '2021-04-15 11:52:51.001155', NULL),
	(10001157, 10000001, 'PW21A-TS100263BL-S', 100263, 'KIRIN GIVEAWAY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001156', '2021-04-15 11:52:51.001156', NULL),
	(10001158, 10000001, 'PW21A-TS100263BL-M', 100263, 'KIRIN GIVEAWAY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001157', '2021-04-15 11:52:51.001157', NULL),
	(10001159, 10000001, 'PW21A-TS100263BL-L', 100263, 'KIRIN GIVEAWAY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.001158', '2021-04-15 11:52:51.001158', NULL),
	(10001160, 10000001, 'PW21A-TS100263BL-XL', 100263, 'KIRIN GIVEAWAY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001159', '2021-04-15 11:52:51.001159', NULL),
	(10001161, 10000001, 'PW21A-TS100263BL-XXL', 100263, 'KIRIN GIVEAWAY', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001160', '2021-04-15 11:52:51.001160', NULL),
	(10001162, 10000001, 'PW21A-TS100264WH-XS', 100264, 'TWIN HORSE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001161', '2021-04-15 11:52:51.001161', NULL),
	(10001163, 10000001, 'PW21A-TS100264WH-S', 100264, 'TWIN HORSE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001162', '2021-04-15 11:52:51.001162', NULL),
	(10001164, 10000001, 'PW21A-TS100264WH-M', 100264, 'TWIN HORSE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001163', '2021-04-15 11:52:51.001163', NULL),
	(10001165, 10000001, 'PW21A-TS100264WH-L', 100264, 'TWIN HORSE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001164', '2021-04-15 11:52:51.001164', NULL),
	(10001166, 10000001, 'PW21A-TS100264WH-XL', 100264, 'TWIN HORSE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001165', '2021-04-15 11:52:51.001165', NULL),
	(10001167, 10000001, 'PW21A-TS100264WH-XXL', 100264, 'TWIN HORSE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001166', '2021-04-15 11:52:51.001166', NULL),
	(10001168, 10000001, 'PW21A-TS100265RD-XS', 100265, 'ENDLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001167', '2021-04-15 11:52:51.001167', NULL),
	(10001169, 10000001, 'PW21A-TS100265RD-S', 100265, 'ENDLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001168', '2021-04-15 11:52:51.001168', NULL),
	(10001170, 10000001, 'PW21A-TS100265RD-M', 100265, 'ENDLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001169', '2021-04-15 11:52:51.001169', NULL),
	(10001171, 10000001, 'PW21A-TS100265RD-L', 100265, 'ENDLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001170', '2021-04-15 11:52:51.001170', NULL),
	(10001172, 10000001, 'PW21A-TS100265RD-XL', 100265, 'ENDLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001171', '2021-04-15 11:52:51.001171', NULL),
	(10001173, 10000001, 'PW21A-TS100265RD-XXL', 100265, 'ENDLESS TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001172', '2021-04-15 11:52:51.001172', NULL),
	(10001174, 10000001, 'PW21A-TS100266BL-XS', 100266, 'SUPERIOR TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001173', '2021-04-15 11:52:51.001173', NULL),
	(10001175, 10000001, 'PW21A-TS100266BL-S', 100266, 'SUPERIOR TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001174', '2021-04-15 11:52:51.001174', NULL),
	(10001176, 10000001, 'PW21A-TS100266BL-M', 100266, 'SUPERIOR TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001175', '2021-04-15 11:52:51.001175', NULL),
	(10001177, 10000001, 'PW21A-TS100266BL-L', 100266, 'SUPERIOR TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001176', '2021-04-15 11:52:51.001176', NULL),
	(10001178, 10000001, 'PW21A-TS100266BL-XL', 100266, 'SUPERIOR TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001177', '2021-04-15 11:52:51.001177', NULL),
	(10001179, 10000001, 'PW21A-TS100266BL-XXL', 100266, 'SUPERIOR TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001178', '2021-04-15 11:52:51.001178', NULL),
	(10001180, 10000001, 'PW21A-TS100267BL-XS', 100267, 'DOMINATION TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001179', '2021-04-15 11:52:51.001179', NULL),
	(10001181, 10000001, 'PW21A-TS100267BL-S', 100267, 'DOMINATION TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.001180', '2021-04-15 11:52:51.001180', NULL),
	(10001182, 10000001, 'PW21A-TS100267BL-M', 100267, 'DOMINATION TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 22, 1, 'Piece', '2021-04-15 11:52:51.001181', '2021-04-15 11:52:51.001181', NULL),
	(10001183, 10000001, 'PW21A-TS100267BL-L', 100267, 'DOMINATION TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001182', '2021-04-15 11:52:51.001182', NULL),
	(10001184, 10000001, 'PW21A-TS100267BL-XL', 100267, 'DOMINATION TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001183', '2021-04-15 11:52:51.001183', NULL),
	(10001185, 10000001, 'PW21A-TS100267BL-XXL', 100267, 'DOMINATION TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001184', '2021-04-15 11:52:51.001184', NULL),
	(10001186, 10000001, 'PW21A-TS100268BL-XS', 100268, 'KAERU SENSHI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001185', '2021-04-15 11:52:51.001185', NULL),
	(10001187, 10000001, 'PW21A-TS100268BL-S', 100268, 'KAERU SENSHI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.001186', '2021-04-15 11:52:51.001186', NULL),
	(10001188, 10000001, 'PW21A-TS100268BL-M', 100268, 'KAERU SENSHI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001187', '2021-04-15 11:52:51.001187', NULL),
	(10001189, 10000001, 'PW21A-TS100268BL-L', 100268, 'KAERU SENSHI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 30, 1, 'Piece', '2021-04-15 11:52:51.001188', '2021-04-15 11:52:51.001188', NULL),
	(10001190, 10000001, 'PW21A-TS100268BL-XL', 100268, 'KAERU SENSHI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.001189', '2021-04-15 11:52:51.001189', NULL),
	(10001191, 10000001, 'PW21A-TS100268BL-XXL', 100268, 'KAERU SENSHI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001190', '2021-04-15 11:52:51.001190', NULL),
	(10001192, 10000001, 'PW21A-TS100269BL-XS', 100269, 'UNFORGIVEN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001191', '2021-04-15 11:52:51.001191', NULL),
	(10001193, 10000001, 'PW21A-TS100269BL-S', 100269, 'UNFORGIVEN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 22, 1, 'Piece', '2021-04-15 11:52:51.001192', '2021-04-15 11:52:51.001192', NULL),
	(10001194, 10000001, 'PW21A-TS100269BL-M', 100269, 'UNFORGIVEN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.001193', '2021-04-15 11:52:51.001193', NULL),
	(10001195, 10000001, 'PW21A-TS100269BL-L', 100269, 'UNFORGIVEN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.001194', '2021-04-15 11:52:51.001194', NULL),
	(10001196, 10000001, 'PW21A-TS100269BL-XL', 100269, 'UNFORGIVEN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001195', '2021-04-15 11:52:51.001195', NULL),
	(10001197, 10000001, 'PW21A-TS100269BL-XXL', 100269, 'UNFORGIVEN TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001196', '2021-04-15 11:52:51.001196', NULL),
	(10001198, 10000001, 'PW21A-TS100270BL-XS', 100270, 'ETNIC BEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001197', '2021-04-15 11:52:51.001197', NULL),
	(10001199, 10000001, 'PW21A-TS100270BL-S', 100270, 'ETNIC BEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001198', '2021-04-15 11:52:51.001198', NULL),
	(10001200, 10000001, 'PW21A-TS100270BL-M', 100270, 'ETNIC BEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001199', '2021-04-15 11:52:51.001199', NULL),
	(10001201, 10000001, 'PW21A-TS100270BL-L', 100270, 'ETNIC BEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001200', '2021-04-15 11:52:51.001200', NULL),
	(10001202, 10000001, 'PW21A-TS100270BL-XL', 100270, 'ETNIC BEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001201', '2021-04-15 11:52:51.001201', NULL),
	(10001203, 10000001, 'PW21A-TS100270BL-XXL', 100270, 'ETNIC BEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001202', '2021-04-15 11:52:51.001202', NULL),
	(10001204, 10000001, 'PW21A-TS100271BL-XS', 100271, 'BATOSAI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001203', '2021-04-15 11:52:51.001203', NULL),
	(10001205, 10000001, 'PW21A-TS100271BL-S', 100271, 'BATOSAI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.001204', '2021-04-15 11:52:51.001204', NULL),
	(10001206, 10000001, 'PW21A-TS100271BL-M', 100271, 'BATOSAI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 27, 1, 'Piece', '2021-04-15 11:52:51.001205', '2021-04-15 11:52:51.001205', NULL),
	(10001207, 10000001, 'PW21A-TS100271BL-L', 100271, 'BATOSAI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 26, 1, 'Piece', '2021-04-15 11:52:51.001206', '2021-04-15 11:52:51.001206', NULL),
	(10001208, 10000001, 'PW21A-TS100271BL-XL', 100271, 'BATOSAI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.001207', '2021-04-15 11:52:51.001207', NULL),
	(10001209, 10000001, 'PW21A-TS100271BL-XXL', 100271, 'BATOSAI TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001208', '2021-04-15 11:52:51.001208', NULL),
	(10001210, 10000001, 'PW21A-TS100272BL-XS', 100272, 'DIRTY DEEDS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001209', '2021-04-15 11:52:51.001209', NULL),
	(10001211, 10000001, 'PW21A-TS100272BL-S', 100272, 'DIRTY DEEDS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001210', '2021-04-15 11:52:51.001210', NULL),
	(10001212, 10000001, 'PW21A-TS100272BL-M', 100272, 'DIRTY DEEDS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.001211', '2021-04-15 11:52:51.001211', NULL),
	(10001213, 10000001, 'PW21A-TS100272BL-L', 100272, 'DIRTY DEEDS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.001212', '2021-04-15 11:52:51.001212', NULL),
	(10001214, 10000001, 'PW21A-TS100272BL-XL', 100272, 'DIRTY DEEDS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.001213', '2021-04-15 11:52:51.001213', NULL),
	(10001215, 10000001, 'PW21A-TS100272BL-XXL', 100272, 'DIRTY DEEDS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001214', '2021-04-15 11:52:51.001214', NULL),
	(10001216, 10000001, 'PW21A-TS100273WT-XS', 100273, 'BARONG TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001215', '2021-04-15 11:52:51.001215', NULL),
	(10001217, 10000001, 'PW21A-TS100273WT-S', 100273, 'BARONG TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.001216', '2021-04-15 11:52:51.001216', NULL),
	(10001218, 10000001, 'PW21A-TS100273WT-M', 100273, 'BARONG TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001217', '2021-04-15 11:52:51.001217', NULL),
	(10001219, 10000001, 'PW21A-TS100273WT-L', 100273, 'BARONG TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.001218', '2021-04-15 11:52:51.001218', NULL),
	(10001220, 10000001, 'PW21A-TS100273WT-XL', 100273, 'BARONG TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001219', '2021-04-15 11:52:51.001219', NULL),
	(10001221, 10000001, 'PW21A-TS100273WT-XXL', 100273, 'BARONG TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001220', '2021-04-15 11:52:51.001220', NULL),
	(10001222, 10000001, 'PW21A-TS100274BL-XS', 100274, 'BURNING FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001221', '2021-04-15 11:52:51.001221', NULL),
	(10001223, 10000001, 'PW21A-TS100274BL-S', 100274, 'BURNING FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001222', '2021-04-15 11:52:51.001222', NULL),
	(10001224, 10000001, 'PW21A-TS100274BL-M', 100274, 'BURNING FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 22, 1, 'Piece', '2021-04-15 11:52:51.001223', '2021-04-15 11:52:51.001223', NULL),
	(10001225, 10000001, 'PW21A-TS100274BL-L', 100274, 'BURNING FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.001224', '2021-04-15 11:52:51.001224', NULL),
	(10001226, 10000001, 'PW21A-TS100274BL-XL', 100274, 'BURNING FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.001225', '2021-04-15 11:52:51.001225', NULL),
	(10001227, 10000001, 'PW21A-TS100274BL-XXL', 100274, 'BURNING FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001226', '2021-04-15 11:52:51.001226', NULL),
	(10001228, 10000001, 'PW21A-TS100275BL-XS', 100275, 'TENGU HEBI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001227', '2021-04-15 11:52:51.001227', NULL),
	(10001229, 10000001, 'PW21A-TS100275BL-S', 100275, 'TENGU HEBI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.001228', '2021-04-15 11:52:51.001228', NULL),
	(10001230, 10000001, 'PW21A-TS100275BL-M', 100275, 'TENGU HEBI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 32, 1, 'Piece', '2021-04-15 11:52:51.001229', '2021-04-15 11:52:51.001229', NULL),
	(10001231, 10000001, 'PW21A-TS100275BL-L', 100275, 'TENGU HEBI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 31, 1, 'Piece', '2021-04-15 11:52:51.001230', '2021-04-15 11:52:51.001230', NULL),
	(10001232, 10000001, 'PW21A-TS100275BL-XL', 100275, 'TENGU HEBI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.001231', '2021-04-15 11:52:51.001231', NULL),
	(10001233, 10000001, 'PW21A-TS100275BL-XXL', 100275, 'TENGU HEBI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001232', '2021-04-15 11:52:51.001232', NULL),
	(10001234, 10000001, 'PW21A-TS100276WT-XS', 100276, 'KYOGEN MASK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001233', '2021-04-15 11:52:51.001233', NULL),
	(10001235, 10000001, 'PW21A-TS100276WT-S', 100276, 'KYOGEN MASK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001234', '2021-04-15 11:52:51.001234', NULL),
	(10001236, 10000001, 'PW21A-TS100276WT-M', 100276, 'KYOGEN MASK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.001235', '2021-04-15 11:52:51.001235', NULL),
	(10001237, 10000001, 'PW21A-TS100276WT-L', 100276, 'KYOGEN MASK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001236', '2021-04-15 11:52:51.001236', NULL),
	(10001238, 10000001, 'PW21A-TS100276WT-XL', 100276, 'KYOGEN MASK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.001237', '2021-04-15 11:52:51.001237', NULL),
	(10001239, 10000001, 'PW21A-TS100276WT-XXL', 100276, 'KYOGEN MASK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001238', '2021-04-15 11:52:51.001238', NULL),
	(10001240, 10000001, 'PW21A-TS100277BL-XS', 100277, 'HELL DRIVER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001239', '2021-04-15 11:52:51.001239', NULL),
	(10001241, 10000001, 'PW21A-TS100277BL-S', 100277, 'HELL DRIVER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001240', '2021-04-15 11:52:51.001240', NULL),
	(10001242, 10000001, 'PW21A-TS100277BL-M', 100277, 'HELL DRIVER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.001241', '2021-04-15 11:52:51.001241', NULL),
	(10001243, 10000001, 'PW21A-TS100277BL-L', 100277, 'HELL DRIVER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001242', '2021-04-15 11:52:51.001242', NULL),
	(10001244, 10000001, 'PW21A-TS100277BL-XL', 100277, 'HELL DRIVER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.001243', '2021-04-15 11:52:51.001243', NULL),
	(10001245, 10000001, 'PW21A-TS100277BL-XXL', 100277, 'HELL DRIVER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001244', '2021-04-15 11:52:51.001244', NULL),
	(10001246, 10000001, 'PW21A-TS100278BL-XS', 100278, 'GEISHA BLACK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001245', '2021-04-15 11:52:51.001245', NULL),
	(10001247, 10000001, 'PW21A-TS100278BL-S', 100278, 'GEISHA BLACK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001246', '2021-04-15 11:52:51.001246', NULL),
	(10001248, 10000001, 'PW21A-TS100278BL-M', 100278, 'GEISHA BLACK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.001247', '2021-04-15 11:52:51.001247', NULL),
	(10001249, 10000001, 'PW21A-TS100278BL-L', 100278, 'GEISHA BLACK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.001248', '2021-04-15 11:52:51.001248', NULL),
	(10001250, 10000001, 'PW21A-TS100278BL-XL', 100278, 'GEISHA BLACK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001249', '2021-04-15 11:52:51.001249', NULL),
	(10001251, 10000001, 'PW21A-TS100278BL-XXL', 100278, 'GEISHA BLACK', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001250', '2021-04-15 11:52:51.001250', NULL),
	(10001252, 10000001, 'PW21A-TS100279WT-XS', 100279, 'GEISHA WHITE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001251', '2021-04-15 11:52:51.001251', NULL),
	(10001253, 10000001, 'PW21A-TS100279WT-S', 100279, 'GEISHA WHITE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.001252', '2021-04-15 11:52:51.001252', NULL),
	(10001254, 10000001, 'PW21A-TS100279WT-M', 100279, 'GEISHA WHITE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.001253', '2021-04-15 11:52:51.001253', NULL),
	(10001255, 10000001, 'PW21A-TS100279WT-L', 100279, 'GEISHA WHITE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.001254', '2021-04-15 11:52:51.001254', NULL),
	(10001256, 10000001, 'PW21A-TS100279WT-XL', 100279, 'GEISHA WHITE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.001255', '2021-04-15 11:52:51.001255', NULL),
	(10001257, 10000001, 'PW21A-TS100279WT-XXL', 100279, 'GEISHA WHITE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001256', '2021-04-15 11:52:51.001256', NULL),
	(10001258, 10000001, 'PW21A-TS100280BL-XS', 100280, 'FUTAGO ONI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001257', '2021-04-15 11:52:51.001257', NULL),
	(10001259, 10000001, 'PW21A-TS100280BL-S', 100280, 'FUTAGO ONI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001258', '2021-04-15 11:52:51.001258', NULL),
	(10001260, 10000001, 'PW21A-TS100280BL-M', 100280, 'FUTAGO ONI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001259', '2021-04-15 11:52:51.001259', NULL),
	(10001261, 10000001, 'PW21A-TS100280BL-L', 100280, 'FUTAGO ONI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001260', '2021-04-15 11:52:51.001260', NULL),
	(10001262, 10000001, 'PW21A-TS100280BL-XL', 100280, 'FUTAGO ONI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001261', '2021-04-15 11:52:51.001261', NULL),
	(10001263, 10000001, 'PW21A-TS100280BL-XXL', 100280, 'FUTAGO ONI', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001262', '2021-04-15 11:52:51.001262', NULL),
	(10001264, 10000001, 'PW21A-TS100281BL-XS', 100281, 'TORA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001263', '2021-04-15 11:52:51.001263', NULL),
	(10001265, 10000001, 'PW21A-TS100281BL-S', 100281, 'TORA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001264', '2021-04-15 11:52:51.001264', NULL),
	(10001266, 10000001, 'PW21A-TS100281BL-M', 100281, 'TORA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001265', '2021-04-15 11:52:51.001265', NULL),
	(10001267, 10000001, 'PW21A-TS100281BL-L', 100281, 'TORA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001266', '2021-04-15 11:52:51.001266', NULL),
	(10001268, 10000001, 'PW21A-TS100281BL-XL', 100281, 'TORA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001267', '2021-04-15 11:52:51.001267', NULL),
	(10001269, 10000001, 'PW21A-TS100281BL-XXL', 100281, 'TORA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001268', '2021-04-15 11:52:51.001268', NULL),
	(10001270, 10000001, 'PW21A-TS100282BL-XS', 100282, 'SKULL JUNKIES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001269', '2021-04-15 11:52:51.001269', NULL),
	(10001271, 10000001, 'PW21A-TS100282BL-S', 100282, 'SKULL JUNKIES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001270', '2021-04-15 11:52:51.001270', NULL),
	(10001272, 10000001, 'PW21A-TS100282BL-M', 100282, 'SKULL JUNKIES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001271', '2021-04-15 11:52:51.001271', NULL),
	(10001273, 10000001, 'PW21A-TS100282BL-L', 100282, 'SKULL JUNKIES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001272', '2021-04-15 11:52:51.001272', NULL),
	(10001274, 10000001, 'PW21A-TS100282BL-XL', 100282, 'SKULL JUNKIES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001273', '2021-04-15 11:52:51.001273', NULL),
	(10001275, 10000001, 'PW21A-TS100282BL-XXL', 100282, 'SKULL JUNKIES', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001274', '2021-04-15 11:52:51.001274', NULL),
	(10001276, 10000001, 'PW21A-TS100283BL-XS', 100283, 'ROAD KILLER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001275', '2021-04-15 11:52:51.001275', NULL),
	(10001277, 10000001, 'PW21A-TS100283BL-S', 100283, 'ROAD KILLER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001276', '2021-04-15 11:52:51.001276', NULL),
	(10001278, 10000001, 'PW21A-TS100283BL-M', 100283, 'ROAD KILLER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001277', '2021-04-15 11:52:51.001277', NULL),
	(10001279, 10000001, 'PW21A-TS100283BL-L', 100283, 'ROAD KILLER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001278', '2021-04-15 11:52:51.001278', NULL),
	(10001280, 10000001, 'PW21A-TS100283BL-XL', 100283, 'ROAD KILLER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001279', '2021-04-15 11:52:51.001279', NULL),
	(10001281, 10000001, 'PW21A-TS100283BL-XXL', 100283, 'ROAD KILLER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001280', '2021-04-15 11:52:51.001280', NULL),
	(10001282, 10000001, 'PW21A-TS100284BL-XS', 100284, 'ONIMUSHA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001281', '2021-04-15 11:52:51.001281', NULL),
	(10001283, 10000001, 'PW21A-TS100284BL-S', 100284, 'ONIMUSHA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001282', '2021-04-15 11:52:51.001282', NULL),
	(10001284, 10000001, 'PW21A-TS100284BL-M', 100284, 'ONIMUSHA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001283', '2021-04-15 11:52:51.001283', NULL),
	(10001285, 10000001, 'PW21A-TS100284BL-L', 100284, 'ONIMUSHA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001284', '2021-04-15 11:52:51.001284', NULL),
	(10001286, 10000001, 'PW21A-TS100284BL-XL', 100284, 'ONIMUSHA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001285', '2021-04-15 11:52:51.001285', NULL),
	(10001287, 10000001, 'PW21A-TS100284BL-XXL', 100284, 'ONIMUSHA TEE', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001286', '2021-04-15 11:52:51.001286', NULL),
	(10001288, 10000001, 'PW21A-TS100285BL-XS', 100285, 'GYPSY SOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001287', '2021-04-15 11:52:51.001287', NULL),
	(10001289, 10000001, 'PW21A-TS100285BL-S', 100285, 'GYPSY SOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001288', '2021-04-15 11:52:51.001288', NULL),
	(10001290, 10000001, 'PW21A-TS100285BL-M', 100285, 'GYPSY SOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001289', '2021-04-15 11:52:51.001289', NULL),
	(10001291, 10000001, 'PW21A-TS100285BL-L', 100285, 'GYPSY SOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001290', '2021-04-15 11:52:51.001290', NULL),
	(10001292, 10000001, 'PW21A-TS100285BL-XL', 100285, 'GYPSY SOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001291', '2021-04-15 11:52:51.001291', NULL),
	(10001293, 10000001, 'PW21A-TS100285BL-XXL', 100285, 'GYPSY SOUL', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001292', '2021-04-15 11:52:51.001292', NULL),
	(10001294, 10000001, 'PW21A-TS100286BL-XS', 100286, 'FUJIN ', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001293', '2021-04-15 11:52:51.001293', NULL),
	(10001295, 10000001, 'PW21A-TS100286BL-S', 100286, 'FUJIN ', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001294', '2021-04-15 11:52:51.001294', NULL),
	(10001296, 10000001, 'PW21A-TS100286BL-M', 100286, 'FUJIN ', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001295', '2021-04-15 11:52:51.001295', NULL),
	(10001297, 10000001, 'PW21A-TS100286BL-L', 100286, 'FUJIN ', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001296', '2021-04-15 11:52:51.001296', NULL),
	(10001298, 10000001, 'PW21A-TS100286BL-XL', 100286, 'FUJIN ', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001297', '2021-04-15 11:52:51.001297', NULL),
	(10001299, 10000001, 'PW21A-TS100286BL-XXL', 100286, 'FUJIN ', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001298', '2021-04-15 11:52:51.001298', NULL),
	(10001300, 10000001, 'PW21A-TS100287BL-XS', 100287, 'SHORT BLUE PW', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001299', '2021-04-15 11:52:51.001299', NULL),
	(10001301, 10000001, 'PW21A-TS100287BL-S', 100287, 'SHORT BLUE PW', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001300', '2021-04-15 11:52:51.001300', NULL),
	(10001302, 10000001, 'PW21A-TS100287BL-M', 100287, 'SHORT BLUE PW', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001301', '2021-04-15 11:52:51.001301', NULL),
	(10001303, 10000001, 'PW21A-TS100287BL-L', 100287, 'SHORT BLUE PW', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001302', '2021-04-15 11:52:51.001302', NULL),
	(10001304, 10000001, 'PW21A-TS100287BL-XL', 100287, 'SHORT BLUE PW', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001303', '2021-04-15 11:52:51.001303', NULL),
	(10001305, 10000001, 'PW21A-TS100287BL-XXL', 100287, 'SHORT BLUE PW', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001304', '2021-04-15 11:52:51.001304', NULL),
	(10001306, 10000001, 'PW21A-TS100288BL-XS', 100288, 'MIDNIGHT RIDER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001305', '2021-04-15 11:52:51.001305', NULL),
	(10001307, 10000001, 'PW21A-TS100288BL-S', 100288, 'MIDNIGHT RIDER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001306', '2021-04-15 11:52:51.001306', NULL),
	(10001308, 10000001, 'PW21A-TS100288BL-M', 100288, 'MIDNIGHT RIDER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001307', '2021-04-15 11:52:51.001307', NULL),
	(10001309, 10000001, 'PW21A-TS100288BL-L', 100288, 'MIDNIGHT RIDER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001308', '2021-04-15 11:52:51.001308', NULL),
	(10001310, 10000001, 'PW21A-TS100288BL-XL', 100288, 'MIDNIGHT RIDER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001309', '2021-04-15 11:52:51.001309', NULL),
	(10001311, 10000001, 'PW21A-TS100288BL-XXL', 100288, 'MIDNIGHT RIDER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001310', '2021-04-15 11:52:51.001310', NULL),
	(10001312, 10000001, 'PW21A-TS100289BL-XS', 100289, 'RIDE AND CONQUER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001311', '2021-04-15 11:52:51.001311', NULL),
	(10001313, 10000001, 'PW21A-TS100289BL-S', 100289, 'RIDE AND CONQUER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001312', '2021-04-15 11:52:51.001312', NULL),
	(10001314, 10000001, 'PW21A-TS100289BL-M', 100289, 'RIDE AND CONQUER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001313', '2021-04-15 11:52:51.001313', NULL),
	(10001315, 10000001, 'PW21A-TS100289BL-L', 100289, 'RIDE AND CONQUER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001314', '2021-04-15 11:52:51.001314', NULL),
	(10001316, 10000001, 'PW21A-TS100289BL-XL', 100289, 'RIDE AND CONQUER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001315', '2021-04-15 11:52:51.001315', NULL),
	(10001317, 10000001, 'PW21A-TS100289BL-XXL', 100289, 'RIDE AND CONQUER', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001316', '2021-04-15 11:52:51.001316', NULL),
	(10001318, 10000001, 'PW21A-TS100290OL-XS', 100290, 'FEARLESS 3.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001317', '2021-04-15 11:52:51.001317', NULL),
	(10001319, 10000001, 'PW21A-TS100290OL-S', 100290, 'FEARLESS 3.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001318', '2021-04-15 11:52:51.001318', NULL),
	(10001320, 10000001, 'PW21A-TS100290OL-M', 100290, 'FEARLESS 3.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001319', '2021-04-15 11:52:51.001319', NULL),
	(10001321, 10000001, 'PW21A-TS100290OL-L', 100290, 'FEARLESS 3.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001320', '2021-04-15 11:52:51.001320', NULL),
	(10001322, 10000001, 'PW21A-TS100290OL-XL', 100290, 'FEARLESS 3.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.001321', '2021-04-15 11:52:51.001321', NULL),
	(10001323, 10000001, 'PW21A-TS100290OL-XXL', 100290, 'FEARLESS 3.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001322', '2021-04-15 11:52:51.001322', NULL),
	(10001324, 10000001, 'PW21A-TS100291BL-XS', 100291, 'CHRYSANT DEMON OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001323', '2021-04-15 11:52:51.001323', NULL),
	(10001325, 10000001, 'PW21A-TS100291BL-S', 100291, 'CHRYSANT DEMON OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001324', '2021-04-15 11:52:51.001324', NULL),
	(10001326, 10000001, 'PW21A-TS100291BL-M', 100291, 'CHRYSANT DEMON OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001325', '2021-04-15 11:52:51.001325', NULL),
	(10001327, 10000001, 'PW21A-TS100291BL-L', 100291, 'CHRYSANT DEMON OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001326', '2021-04-15 11:52:51.001326', NULL),
	(10001328, 10000001, 'PW21A-TS100291BL-XL', 100291, 'CHRYSANT DEMON OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001327', '2021-04-15 11:52:51.001327', NULL),
	(10001329, 10000001, 'PW21A-TS100291BL-XXL', 100291, 'CHRYSANT DEMON OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001328', '2021-04-15 11:52:51.001328', NULL),
	(10001330, 10000001, 'PW21A-TS100292NV-XS', 100292, 'PHILLIP WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001329', '2021-04-15 11:52:51.001329', NULL),
	(10001331, 10000001, 'PW21A-TS100292NV-S', 100292, 'PHILLIP WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001330', '2021-04-15 11:52:51.001330', NULL),
	(10001332, 10000001, 'PW21A-TS100292NV-M', 100292, 'PHILLIP WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001331', '2021-04-15 11:52:51.001331', NULL),
	(10001333, 10000001, 'PW21A-TS100292NV-L', 100292, 'PHILLIP WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001332', '2021-04-15 11:52:51.001332', NULL),
	(10001334, 10000001, 'PW21A-TS100292NV-XL', 100292, 'PHILLIP WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001333', '2021-04-15 11:52:51.001333', NULL),
	(10001335, 10000001, 'PW21A-TS100292NV-XXL', 100292, 'PHILLIP WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001334', '2021-04-15 11:52:51.001334', NULL),
	(10001336, 10000001, 'PW21A-TS100293OL-XS', 100293, 'THE LIBERATOR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001335', '2021-04-15 11:52:51.001335', NULL),
	(10001337, 10000001, 'PW21A-TS100293OL-S', 100293, 'THE LIBERATOR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001336', '2021-04-15 11:52:51.001336', NULL),
	(10001338, 10000001, 'PW21A-TS100293OL-M', 100293, 'THE LIBERATOR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001337', '2021-04-15 11:52:51.001337', NULL),
	(10001339, 10000001, 'PW21A-TS100293OL-L', 100293, 'THE LIBERATOR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001338', '2021-04-15 11:52:51.001338', NULL),
	(10001340, 10000001, 'PW21A-TS100293OL-XL', 100293, 'THE LIBERATOR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001339', '2021-04-15 11:52:51.001339', NULL),
	(10001341, 10000001, 'PW21A-TS100293OL-XXL', 100293, 'THE LIBERATOR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001340', '2021-04-15 11:52:51.001340', NULL),
	(10001342, 10000001, 'PW21A-TS100294OL-XS', 100294, 'THE LIBERATOR 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001341', '2021-04-15 11:52:51.001341', NULL),
	(10001343, 10000001, 'PW21A-TS100294OL-S', 100294, 'THE LIBERATOR 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001342', '2021-04-15 11:52:51.001342', NULL),
	(10001344, 10000001, 'PW21A-TS100294OL-M', 100294, 'THE LIBERATOR 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001343', '2021-04-15 11:52:51.001343', NULL),
	(10001345, 10000001, 'PW21A-TS100294OL-L', 100294, 'THE LIBERATOR 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001344', '2021-04-15 11:52:51.001344', NULL),
	(10001346, 10000001, 'PW21A-TS100294OL-XL', 100294, 'THE LIBERATOR 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001345', '2021-04-15 11:52:51.001345', NULL),
	(10001347, 10000001, 'PW21A-TS100294OL-XXL', 100294, 'THE LIBERATOR 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001346', '2021-04-15 11:52:51.001346', NULL),
	(10001348, 10000001, 'PW21A-TS100295NV-XS', 100295, 'MEMENTO MORI 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001347', '2021-04-15 11:52:51.001347', NULL),
	(10001349, 10000001, 'PW21A-TS100295NV-S', 100295, 'MEMENTO MORI 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.001348', '2021-04-15 11:52:51.001348', NULL),
	(10001350, 10000001, 'PW21A-TS100295NV-M', 100295, 'MEMENTO MORI 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.001349', '2021-04-15 11:52:51.001349', NULL),
	(10001351, 10000001, 'PW21A-TS100295NV-L', 100295, 'MEMENTO MORI 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 32, 1, 'Piece', '2021-04-15 11:52:51.001350', '2021-04-15 11:52:51.001350', NULL),
	(10001352, 10000001, 'PW21A-TS100295NV-XL', 100295, 'MEMENTO MORI 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 31, 1, 'Piece', '2021-04-15 11:52:51.001351', '2021-04-15 11:52:51.001351', NULL),
	(10001353, 10000001, 'PW21A-TS100295NV-XXL', 100295, 'MEMENTO MORI 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001352', '2021-04-15 11:52:51.001352', NULL),
	(10001354, 10000001, 'PW21A-TS100296BL-XS', 100296, 'CHRYSANT DEMON OVERSHIRT ', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001353', '2021-04-15 11:52:51.001353', NULL),
	(10001355, 10000001, 'PW21A-TS100296BL-S', 100296, 'CHRYSANT DEMON OVERSHIRT ', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001354', '2021-04-15 11:52:51.001354', NULL),
	(10001356, 10000001, 'PW21A-TS100296BL-M', 100296, 'CHRYSANT DEMON OVERSHIRT ', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001355', '2021-04-15 11:52:51.001355', NULL),
	(10001357, 10000001, 'PW21A-TS100296BL-L', 100296, 'CHRYSANT DEMON OVERSHIRT ', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001356', '2021-04-15 11:52:51.001356', NULL),
	(10001358, 10000001, 'PW21A-TS100296BL-XL', 100296, 'CHRYSANT DEMON OVERSHIRT ', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.001357', '2021-04-15 11:52:51.001357', NULL),
	(10001359, 10000001, 'PW21A-TS100296BL-XXL', 100296, 'CHRYSANT DEMON OVERSHIRT ', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001358', '2021-04-15 11:52:51.001358', NULL),
	(10001360, 10000001, 'PW21A-TS100297OL-XS', 100297, 'STRONGER THAN DEATH 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001359', '2021-04-15 11:52:51.001359', NULL),
	(10001361, 10000001, 'PW21A-TS100297OL-S', 100297, 'STRONGER THAN DEATH 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001360', '2021-04-15 11:52:51.001360', NULL),
	(10001362, 10000001, 'PW21A-TS100297OL-M', 100297, 'STRONGER THAN DEATH 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001361', '2021-04-15 11:52:51.001361', NULL),
	(10001363, 10000001, 'PW21A-TS100297OL-L', 100297, 'STRONGER THAN DEATH 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001362', '2021-04-15 11:52:51.001362', NULL),
	(10001364, 10000001, 'PW21A-TS100297OL-XL', 100297, 'STRONGER THAN DEATH 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001363', '2021-04-15 11:52:51.001363', NULL),
	(10001365, 10000001, 'PW21A-TS100297OL-XXL', 100297, 'STRONGER THAN DEATH 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001364', '2021-04-15 11:52:51.001364', NULL),
	(10001366, 10000001, 'PW21A-TS100298OL-XS', 100298, 'EL LUCHADOR 4.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001365', '2021-04-15 11:52:51.001365', NULL),
	(10001367, 10000001, 'PW21A-TS100298OL-S', 100298, 'EL LUCHADOR 4.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001366', '2021-04-15 11:52:51.001366', NULL),
	(10001368, 10000001, 'PW21A-TS100298OL-M', 100298, 'EL LUCHADOR 4.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.001367', '2021-04-15 11:52:51.001367', NULL),
	(10001369, 10000001, 'PW21A-TS100298OL-L', 100298, 'EL LUCHADOR 4.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 40, 1, 'Piece', '2021-04-15 11:52:51.001368', '2021-04-15 11:52:51.001368', NULL),
	(10001370, 10000001, 'PW21A-TS100298OL-XL', 100298, 'EL LUCHADOR 4.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001369', '2021-04-15 11:52:51.001369', NULL),
	(10001371, 10000001, 'PW21A-TS100298OL-XXL', 100298, 'EL LUCHADOR 4.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001370', '2021-04-15 11:52:51.001370', NULL),
	(10001372, 10000001, 'PW21A-TS100299BL-XS', 100299, 'LE MANS WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001371', '2021-04-15 11:52:51.001371', NULL),
	(10001373, 10000001, 'PW21A-TS100299BL-S', 100299, 'LE MANS WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.001372', '2021-04-15 11:52:51.001372', NULL),
	(10001374, 10000001, 'PW21A-TS100299BL-M', 100299, 'LE MANS WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001373', '2021-04-15 11:52:51.001373', NULL),
	(10001375, 10000001, 'PW21A-TS100299BL-L', 100299, 'LE MANS WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001374', '2021-04-15 11:52:51.001374', NULL),
	(10001376, 10000001, 'PW21A-TS100299BL-XL', 100299, 'LE MANS WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001375', '2021-04-15 11:52:51.001375', NULL),
	(10001377, 10000001, 'PW21A-TS100299BL-XXL', 100299, 'LE MANS WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001376', '2021-04-15 11:52:51.001376', NULL),
	(10001378, 10000001, 'PW21A-TS100300MR-XS', 100300, 'MONZA WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001377', '2021-04-15 11:52:51.001377', NULL),
	(10001379, 10000001, 'PW21A-TS100300MR-S', 100300, 'MONZA WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.001378', '2021-04-15 11:52:51.001378', NULL),
	(10001380, 10000001, 'PW21A-TS100300MR-M', 100300, 'MONZA WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.001379', '2021-04-15 11:52:51.001379', NULL),
	(10001381, 10000001, 'PW21A-TS100300MR-L', 100300, 'MONZA WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.001380', '2021-04-15 11:52:51.001380', NULL),
	(10001382, 10000001, 'PW21A-TS100300MR-XL', 100300, 'MONZA WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001381', '2021-04-15 11:52:51.001381', NULL),
	(10001383, 10000001, 'PW21A-TS100300MR-XXL', 100300, 'MONZA WORKSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001382', '2021-04-15 11:52:51.001382', NULL),
	(10001384, 10000001, 'PW21A-TS100301BL-XS', 100301, 'FREEDOM FIGHTER OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001383', '2021-04-15 11:52:51.001383', NULL),
	(10001385, 10000001, 'PW21A-TS100301BL-S', 100301, 'FREEDOM FIGHTER OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 28, 1, 'Piece', '2021-04-15 11:52:51.001384', '2021-04-15 11:52:51.001384', NULL),
	(10001386, 10000001, 'PW21A-TS100301BL-M', 100301, 'FREEDOM FIGHTER OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.001385', '2021-04-15 11:52:51.001385', NULL),
	(10001387, 10000001, 'PW21A-TS100301BL-L', 100301, 'FREEDOM FIGHTER OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 37, 1, 'Piece', '2021-04-15 11:52:51.001386', '2021-04-15 11:52:51.001386', NULL),
	(10001388, 10000001, 'PW21A-TS100301BL-XL', 100301, 'FREEDOM FIGHTER OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.001387', '2021-04-15 11:52:51.001387', NULL),
	(10001389, 10000001, 'PW21A-TS100301BL-XXL', 100301, 'FREEDOM FIGHTER OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001388', '2021-04-15 11:52:51.001388', NULL),
	(10001390, 10000001, 'PW21A-TS100302BL-XS', 100302, 'WOLF SPIRIT OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001389', '2021-04-15 11:52:51.001389', NULL),
	(10001391, 10000001, 'PW21A-TS100302BL-S', 100302, 'WOLF SPIRIT OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001390', '2021-04-15 11:52:51.001390', NULL),
	(10001392, 10000001, 'PW21A-TS100302BL-M', 100302, 'WOLF SPIRIT OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001391', '2021-04-15 11:52:51.001391', NULL),
	(10001393, 10000001, 'PW21A-TS100302BL-L', 100302, 'WOLF SPIRIT OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001392', '2021-04-15 11:52:51.001392', NULL),
	(10001394, 10000001, 'PW21A-TS100302BL-XL', 100302, 'WOLF SPIRIT OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001393', '2021-04-15 11:52:51.001393', NULL),
	(10001395, 10000001, 'PW21A-TS100302BL-XXL', 100302, 'WOLF SPIRIT OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001394', '2021-04-15 11:52:51.001394', NULL),
	(10001396, 10000001, 'PW21A-TS100303BL-XS', 100303, 'DEVIL MASK OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001395', '2021-04-15 11:52:51.001395', NULL),
	(10001397, 10000001, 'PW21A-TS100303BL-S', 100303, 'DEVIL MASK OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.001396', '2021-04-15 11:52:51.001396', NULL),
	(10001398, 10000001, 'PW21A-TS100303BL-M', 100303, 'DEVIL MASK OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 27, 1, 'Piece', '2021-04-15 11:52:51.001397', '2021-04-15 11:52:51.001397', NULL),
	(10001399, 10000001, 'PW21A-TS100303BL-L', 100303, 'DEVIL MASK OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 23, 1, 'Piece', '2021-04-15 11:52:51.001398', '2021-04-15 11:52:51.001398', NULL),
	(10001400, 10000001, 'PW21A-TS100303BL-XL', 100303, 'DEVIL MASK OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 21, 1, 'Piece', '2021-04-15 11:52:51.001399', '2021-04-15 11:52:51.001399', NULL),
	(10001401, 10000001, 'PW21A-TS100303BL-XXL', 100303, 'DEVIL MASK OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001400', '2021-04-15 11:52:51.001400', NULL),
	(10001402, 10000001, 'PW21A-TS100304OL-XS', 100304, 'THE LIBERATOR 3.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001401', '2021-04-15 11:52:51.001401', NULL),
	(10001403, 10000001, 'PW21A-TS100304OL-S', 100304, 'THE LIBERATOR 3.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001402', '2021-04-15 11:52:51.001402', NULL),
	(10001404, 10000001, 'PW21A-TS100304OL-M', 100304, 'THE LIBERATOR 3.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.001403', '2021-04-15 11:52:51.001403', NULL),
	(10001405, 10000001, 'PW21A-TS100304OL-L', 100304, 'THE LIBERATOR 3.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.001404', '2021-04-15 11:52:51.001404', NULL),
	(10001406, 10000001, 'PW21A-TS100304OL-XL', 100304, 'THE LIBERATOR 3.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.001405', '2021-04-15 11:52:51.001405', NULL),
	(10001407, 10000001, 'PW21A-TS100304OL-XXL', 100304, 'THE LIBERATOR 3.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001406', '2021-04-15 11:52:51.001406', NULL),
	(10001408, 10000001, 'PW21A-TS100305AR-XS', 100305, 'UNDEFEATED 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001407', '2021-04-15 11:52:51.001407', NULL),
	(10001409, 10000001, 'PW21A-TS100305AR-S', 100305, 'UNDEFEATED 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001408', '2021-04-15 11:52:51.001408', NULL),
	(10001410, 10000001, 'PW21A-TS100305AR-M', 100305, 'UNDEFEATED 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.001409', '2021-04-15 11:52:51.001409', NULL),
	(10001411, 10000001, 'PW21A-TS100305AR-L', 100305, 'UNDEFEATED 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 27, 1, 'Piece', '2021-04-15 11:52:51.001410', '2021-04-15 11:52:51.001410', NULL),
	(10001412, 10000001, 'PW21A-TS100305AR-XL', 100305, 'UNDEFEATED 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.001411', '2021-04-15 11:52:51.001411', NULL),
	(10001413, 10000001, 'PW21A-TS100305AR-XXL', 100305, 'UNDEFEATED 2.0', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001412', '2021-04-15 11:52:51.001412', NULL),
	(10001414, 10000001, 'PW21A-TS100306GN-XS', 100306, 'AERO OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001413', '2021-04-15 11:52:51.001413', NULL),
	(10001415, 10000001, 'PW21A-TS100306GN-S', 100306, 'AERO OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001414', '2021-04-15 11:52:51.001414', NULL),
	(10001416, 10000001, 'PW21A-TS100306GN-M', 100306, 'AERO OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001415', '2021-04-15 11:52:51.001415', NULL),
	(10001417, 10000001, 'PW21A-TS100306GN-L', 100306, 'AERO OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001416', '2021-04-15 11:52:51.001416', NULL),
	(10001418, 10000001, 'PW21A-TS100306GN-XL', 100306, 'AERO OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001417', '2021-04-15 11:52:51.001417', NULL),
	(10001419, 10000001, 'PW21A-TS100306GN-XXL', 100306, 'AERO OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001418', '2021-04-15 11:52:51.001418', NULL),
	(10001420, 10000001, 'PW21A-TS100307GN-XS', 100307, 'SPEED OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001419', '2021-04-15 11:52:51.001419', NULL),
	(10001421, 10000001, 'PW21A-TS100307GN-S', 100307, 'SPEED OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001420', '2021-04-15 11:52:51.001420', NULL),
	(10001422, 10000001, 'PW21A-TS100307GN-M', 100307, 'SPEED OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.001421', '2021-04-15 11:52:51.001421', NULL),
	(10001423, 10000001, 'PW21A-TS100307GN-L', 100307, 'SPEED OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.001422', '2021-04-15 11:52:51.001422', NULL),
	(10001424, 10000001, 'PW21A-TS100307GN-XL', 100307, 'SPEED OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001423', '2021-04-15 11:52:51.001423', NULL),
	(10001425, 10000001, 'PW21A-TS100307GN-XXL', 100307, 'SPEED OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001424', '2021-04-15 11:52:51.001424', NULL),
	(10001426, 10000001, 'PW21A-TS100308GN-XS', 100308, 'GRYPHON OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001425', '2021-04-15 11:52:51.001425', NULL),
	(10001427, 10000001, 'PW21A-TS100308GN-S', 100308, 'GRYPHON OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001426', '2021-04-15 11:52:51.001426', NULL),
	(10001428, 10000001, 'PW21A-TS100308GN-M', 100308, 'GRYPHON OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001427', '2021-04-15 11:52:51.001427', NULL),
	(10001429, 10000001, 'PW21A-TS100308GN-L', 100308, 'GRYPHON OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001428', '2021-04-15 11:52:51.001428', NULL),
	(10001430, 10000001, 'PW21A-TS100308GN-XL', 100308, 'GRYPHON OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001429', '2021-04-15 11:52:51.001429', NULL),
	(10001431, 10000001, 'PW21A-TS100308GN-XXL', 100308, 'GRYPHON OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001430', '2021-04-15 11:52:51.001430', NULL),
	(10001432, 10000001, 'PW21A-TS100309GN-XS', 100309, 'THE DESTROYER OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001431', '2021-04-15 11:52:51.001431', NULL),
	(10001433, 10000001, 'PW21A-TS100309GN-S', 100309, 'THE DESTROYER OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001432', '2021-04-15 11:52:51.001432', NULL),
	(10001434, 10000001, 'PW21A-TS100309GN-M', 100309, 'THE DESTROYER OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001433', '2021-04-15 11:52:51.001433', NULL),
	(10001435, 10000001, 'PW21A-TS100309GN-L', 100309, 'THE DESTROYER OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001434', '2021-04-15 11:52:51.001434', NULL),
	(10001436, 10000001, 'PW21A-TS100309GN-XL', 100309, 'THE DESTROYER OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001435', '2021-04-15 11:52:51.001435', NULL),
	(10001437, 10000001, 'PW21A-TS100309GN-XXL', 100309, 'THE DESTROYER OVERSHIRT', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001436', '2021-04-15 11:52:51.001436', NULL),
	(10001438, 10000001, 'PW21A-SW100310BL-XS', 100310, 'RECKLESS HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001437', '2021-04-15 11:52:51.001437', NULL),
	(10001439, 10000001, 'PW21A-SW100310BL-S', 100310, 'RECKLESS HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001438', '2021-04-15 11:52:51.001438', NULL),
	(10001440, 10000001, 'PW21A-SW100310BL-M', 100310, 'RECKLESS HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001439', '2021-04-15 11:52:51.001439', NULL),
	(10001441, 10000001, 'PW21A-SW100310BL-L', 100310, 'RECKLESS HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001440', '2021-04-15 11:52:51.001440', NULL),
	(10001442, 10000001, 'PW21A-SW100310BL-XL', 100310, 'RECKLESS HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001441', '2021-04-15 11:52:51.001441', NULL),
	(10001443, 10000001, 'PW21A-SW100310BL-XXL', 100310, 'RECKLESS HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001442', '2021-04-15 11:52:51.001442', NULL),
	(10001444, 10000001, 'PW21A-SW100311BL-XS', 100311, 'HERITAGE HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001443', '2021-04-15 11:52:51.001443', NULL),
	(10001445, 10000001, 'PW21A-SW100311BL-S', 100311, 'HERITAGE HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001444', '2021-04-15 11:52:51.001444', NULL),
	(10001446, 10000001, 'PW21A-SW100311BL-M', 100311, 'HERITAGE HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.001445', '2021-04-15 11:52:51.001445', NULL),
	(10001447, 10000001, 'PW21A-SW100311BL-L', 100311, 'HERITAGE HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001446', '2021-04-15 11:52:51.001446', NULL),
	(10001448, 10000001, 'PW21A-SW100311BL-XL', 100311, 'HERITAGE HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001447', '2021-04-15 11:52:51.001447', NULL),
	(10001449, 10000001, 'PW21A-SW100311BL-XXL', 100311, 'HERITAGE HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001448', '2021-04-15 11:52:51.001448', NULL),
	(10001450, 10000001, 'PW21A-SW100312BL-XS', 100312, 'SERPENT ROSE HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001449', '2021-04-15 11:52:51.001449', NULL),
	(10001451, 10000001, 'PW21A-SW100312BL-S', 100312, 'SERPENT ROSE HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001450', '2021-04-15 11:52:51.001450', NULL),
	(10001452, 10000001, 'PW21A-SW100312BL-M', 100312, 'SERPENT ROSE HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001451', '2021-04-15 11:52:51.001451', NULL),
	(10001453, 10000001, 'PW21A-SW100312BL-L', 100312, 'SERPENT ROSE HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001452', '2021-04-15 11:52:51.001452', NULL),
	(10001454, 10000001, 'PW21A-SW100312BL-XL', 100312, 'SERPENT ROSE HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001453', '2021-04-15 11:52:51.001453', NULL),
	(10001455, 10000001, 'PW21A-SW100312BL-XXL', 100312, 'SERPENT ROSE HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001454', '2021-04-15 11:52:51.001454', NULL),
	(10001456, 10000001, 'PW21A-SW100313BL-XS', 100313, 'POSER HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001455', '2021-04-15 11:52:51.001455', NULL),
	(10001457, 10000001, 'PW21A-SW100313BL-S', 100313, 'POSER HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001456', '2021-04-15 11:52:51.001456', NULL),
	(10001458, 10000001, 'PW21A-SW100313BL-M', 100313, 'POSER HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001457', '2021-04-15 11:52:51.001457', NULL),
	(10001459, 10000001, 'PW21A-SW100313BL-L', 100313, 'POSER HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001458', '2021-04-15 11:52:51.001458', NULL),
	(10001460, 10000001, 'PW21A-SW100313BL-XL', 100313, 'POSER HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001459', '2021-04-15 11:52:51.001459', NULL),
	(10001461, 10000001, 'PW21A-SW100313BL-XXL', 100313, 'POSER HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001460', '2021-04-15 11:52:51.001460', NULL),
	(10001462, 10000001, 'PW21A-SW100314DK-XS', 100314, 'STORM ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001461', '2021-04-15 11:52:51.001461', NULL),
	(10001463, 10000001, 'PW21A-SW100314DK-S', 100314, 'STORM ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001462', '2021-04-15 11:52:51.001462', NULL),
	(10001464, 10000001, 'PW21A-SW100314DK-M', 100314, 'STORM ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001463', '2021-04-15 11:52:51.001463', NULL),
	(10001465, 10000001, 'PW21A-SW100314DK-L', 100314, 'STORM ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001464', '2021-04-15 11:52:51.001464', NULL),
	(10001466, 10000001, 'PW21A-SW100314DK-XL', 100314, 'STORM ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001465', '2021-04-15 11:52:51.001465', NULL),
	(10001467, 10000001, 'PW21A-SW100314DK-XXL', 100314, 'STORM ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001466', '2021-04-15 11:52:51.001466', NULL),
	(10001468, 10000001, 'PW21A-SW100315BL-XS', 100315, 'OSAKA TIGER HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001467', '2021-04-15 11:52:51.001467', NULL),
	(10001469, 10000001, 'PW21A-SW100315BL-S', 100315, 'OSAKA TIGER HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001468', '2021-04-15 11:52:51.001468', NULL),
	(10001470, 10000001, 'PW21A-SW100315BL-M', 100315, 'OSAKA TIGER HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001469', '2021-04-15 11:52:51.001469', NULL),
	(10001471, 10000001, 'PW21A-SW100315BL-L', 100315, 'OSAKA TIGER HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001470', '2021-04-15 11:52:51.001470', NULL),
	(10001472, 10000001, 'PW21A-SW100315BL-XL', 100315, 'OSAKA TIGER HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001471', '2021-04-15 11:52:51.001471', NULL),
	(10001473, 10000001, 'PW21A-SW100315BL-XXL', 100315, 'OSAKA TIGER HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001472', '2021-04-15 11:52:51.001472', NULL),
	(10001474, 10000001, 'PW21A-SW100316BL-XS', 100316, 'KARASU TENGU HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001473', '2021-04-15 11:52:51.001473', NULL),
	(10001475, 10000001, 'PW21A-SW100316BL-S', 100316, 'KARASU TENGU HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001474', '2021-04-15 11:52:51.001474', NULL),
	(10001476, 10000001, 'PW21A-SW100316BL-M', 100316, 'KARASU TENGU HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001475', '2021-04-15 11:52:51.001475', NULL),
	(10001477, 10000001, 'PW21A-SW100316BL-L', 100316, 'KARASU TENGU HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001476', '2021-04-15 11:52:51.001476', NULL),
	(10001478, 10000001, 'PW21A-SW100316BL-XL', 100316, 'KARASU TENGU HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001477', '2021-04-15 11:52:51.001477', NULL),
	(10001479, 10000001, 'PW21A-SW100316BL-XXL', 100316, 'KARASU TENGU HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001478', '2021-04-15 11:52:51.001478', NULL),
	(10001480, 10000001, 'PW21A-SW100317BL-XS', 100317, 'INTERSTELLAR BLACK', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001479', '2021-04-15 11:52:51.001479', NULL),
	(10001481, 10000001, 'PW21A-SW100317BL-S', 100317, 'INTERSTELLAR BLACK', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001480', '2021-04-15 11:52:51.001480', NULL),
	(10001482, 10000001, 'PW21A-SW100317BL-M', 100317, 'INTERSTELLAR BLACK', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001481', '2021-04-15 11:52:51.001481', NULL),
	(10001483, 10000001, 'PW21A-SW100317BL-L', 100317, 'INTERSTELLAR BLACK', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001482', '2021-04-15 11:52:51.001482', NULL),
	(10001484, 10000001, 'PW21A-SW100317BL-XL', 100317, 'INTERSTELLAR BLACK', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001483', '2021-04-15 11:52:51.001483', NULL),
	(10001485, 10000001, 'PW21A-SW100317BL-XXL', 100317, 'INTERSTELLAR BLACK', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001484', '2021-04-15 11:52:51.001484', NULL),
	(10001486, 10000001, 'PW21A-SW100318OL-XS', 100318, 'INTERSTELLAR OLIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001485', '2021-04-15 11:52:51.001485', NULL),
	(10001487, 10000001, 'PW21A-SW100318OL-S', 100318, 'INTERSTELLAR OLIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001486', '2021-04-15 11:52:51.001486', NULL),
	(10001488, 10000001, 'PW21A-SW100318OL-M', 100318, 'INTERSTELLAR OLIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001487', '2021-04-15 11:52:51.001487', NULL),
	(10001489, 10000001, 'PW21A-SW100318OL-L', 100318, 'INTERSTELLAR OLIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001488', '2021-04-15 11:52:51.001488', NULL),
	(10001490, 10000001, 'PW21A-SW100318OL-XL', 100318, 'INTERSTELLAR OLIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001489', '2021-04-15 11:52:51.001489', NULL),
	(10001491, 10000001, 'PW21A-SW100318OL-XXL', 100318, 'INTERSTELLAR OLIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001490', '2021-04-15 11:52:51.001490', NULL),
	(10001492, 10000001, 'PW21A-SW100319WT-XS', 100319, 'INTERSTELLAR WHITE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001491', '2021-04-15 11:52:51.001491', NULL),
	(10001493, 10000001, 'PW21A-SW100319WT-S', 100319, 'INTERSTELLAR WHITE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001492', '2021-04-15 11:52:51.001492', NULL),
	(10001494, 10000001, 'PW21A-SW100319WT-M', 100319, 'INTERSTELLAR WHITE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001493', '2021-04-15 11:52:51.001493', NULL),
	(10001495, 10000001, 'PW21A-SW100319WT-L', 100319, 'INTERSTELLAR WHITE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001494', '2021-04-15 11:52:51.001494', NULL),
	(10001496, 10000001, 'PW21A-SW100319WT-XL', 100319, 'INTERSTELLAR WHITE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001495', '2021-04-15 11:52:51.001495', NULL),
	(10001497, 10000001, 'PW21A-SW100319WT-XXL', 100319, 'INTERSTELLAR WHITE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001496', '2021-04-15 11:52:51.001496', NULL),
	(10001498, 10000001, 'PW21A-SW100320BL-XS', 100320, 'KARASU TENGU HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001497', '2021-04-15 11:52:51.001497', NULL),
	(10001499, 10000001, 'PW21A-SW100320BL-S', 100320, 'KARASU TENGU HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001498', '2021-04-15 11:52:51.001498', NULL),
	(10001500, 10000001, 'PW21A-SW100320BL-M', 100320, 'KARASU TENGU HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001499', '2021-04-15 11:52:51.001499', NULL),
	(10001501, 10000001, 'PW21A-SW100320BL-L', 100320, 'KARASU TENGU HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001500', '2021-04-15 11:52:51.001500', NULL),
	(10001502, 10000001, 'PW21A-SW100320BL-XL', 100320, 'KARASU TENGU HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001501', '2021-04-15 11:52:51.001501', NULL),
	(10001503, 10000001, 'PW21A-SW100320BL-XXL', 100320, 'KARASU TENGU HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001502', '2021-04-15 11:52:51.001502', NULL),
	(10001504, 10000001, 'PW21A-SW100321BL-XS', 100321, 'OSAKA TIGER HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001503', '2021-04-15 11:52:51.001503', NULL),
	(10001505, 10000001, 'PW21A-SW100321BL-S', 100321, 'OSAKA TIGER HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001504', '2021-04-15 11:52:51.001504', NULL),
	(10001506, 10000001, 'PW21A-SW100321BL-M', 100321, 'OSAKA TIGER HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001505', '2021-04-15 11:52:51.001505', NULL),
	(10001507, 10000001, 'PW21A-SW100321BL-L', 100321, 'OSAKA TIGER HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001506', '2021-04-15 11:52:51.001506', NULL),
	(10001508, 10000001, 'PW21A-SW100321BL-XL', 100321, 'OSAKA TIGER HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001507', '2021-04-15 11:52:51.001507', NULL),
	(10001509, 10000001, 'PW21A-SW100321BL-XXL', 100321, 'OSAKA TIGER HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001508', '2021-04-15 11:52:51.001508', NULL),
	(10001510, 10000001, 'PW21A-SW100322BL-XS', 100322, 'CHRYSANT DEMON HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001509', '2021-04-15 11:52:51.001509', NULL),
	(10001511, 10000001, 'PW21A-SW100322BL-S', 100322, 'CHRYSANT DEMON HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001510', '2021-04-15 11:52:51.001510', NULL),
	(10001512, 10000001, 'PW21A-SW100322BL-M', 100322, 'CHRYSANT DEMON HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001511', '2021-04-15 11:52:51.001511', NULL),
	(10001513, 10000001, 'PW21A-SW100322BL-L', 100322, 'CHRYSANT DEMON HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001512', '2021-04-15 11:52:51.001512', NULL),
	(10001514, 10000001, 'PW21A-SW100322BL-XL', 100322, 'CHRYSANT DEMON HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001513', '2021-04-15 11:52:51.001513', NULL),
	(10001515, 10000001, 'PW21A-SW100322BL-XXL', 100322, 'CHRYSANT DEMON HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001514', '2021-04-15 11:52:51.001514', NULL),
	(10001516, 10000001, 'PW21A-SW100323BL-XS', 100323, 'DEMAND FREEDOM HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001515', '2021-04-15 11:52:51.001515', NULL),
	(10001517, 10000001, 'PW21A-SW100323BL-S', 100323, 'DEMAND FREEDOM HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001516', '2021-04-15 11:52:51.001516', NULL),
	(10001518, 10000001, 'PW21A-SW100323BL-M', 100323, 'DEMAND FREEDOM HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001517', '2021-04-15 11:52:51.001517', NULL),
	(10001519, 10000001, 'PW21A-SW100323BL-L', 100323, 'DEMAND FREEDOM HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001518', '2021-04-15 11:52:51.001518', NULL),
	(10001520, 10000001, 'PW21A-SW100323BL-XL', 100323, 'DEMAND FREEDOM HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001519', '2021-04-15 11:52:51.001519', NULL),
	(10001521, 10000001, 'PW21A-SW100323BL-XXL', 100323, 'DEMAND FREEDOM HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001520', '2021-04-15 11:52:51.001520', NULL),
	(10001522, 10000001, 'PW21A-SW100324BL-XS', 100324, 'RECKLESS HOODIE ZIP', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001521', '2021-04-15 11:52:51.001521', NULL),
	(10001523, 10000001, 'PW21A-SW100324BL-S', 100324, 'RECKLESS HOODIE ZIP', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.001522', '2021-04-15 11:52:51.001522', NULL),
	(10001524, 10000001, 'PW21A-SW100324BL-M', 100324, 'RECKLESS HOODIE ZIP', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.001523', '2021-04-15 11:52:51.001523', NULL),
	(10001525, 10000001, 'PW21A-SW100324BL-L', 100324, 'RECKLESS HOODIE ZIP', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001524', '2021-04-15 11:52:51.001524', NULL),
	(10001526, 10000001, 'PW21A-SW100324BL-XL', 100324, 'RECKLESS HOODIE ZIP', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001525', '2021-04-15 11:52:51.001525', NULL),
	(10001527, 10000001, 'PW21A-SW100324BL-XXL', 100324, 'RECKLESS HOODIE ZIP', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001526', '2021-04-15 11:52:51.001526', NULL),
	(10001528, 10000001, 'PW21A-SW100325BL-XS', 100325, 'STRATO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001527', '2021-04-15 11:52:51.001527', NULL),
	(10001529, 10000001, 'PW21A-SW100325BL-S', 100325, 'STRATO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.001528', '2021-04-15 11:52:51.001528', NULL),
	(10001530, 10000001, 'PW21A-SW100325BL-M', 100325, 'STRATO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 26, 1, 'Piece', '2021-04-15 11:52:51.001529', '2021-04-15 11:52:51.001529', NULL),
	(10001531, 10000001, 'PW21A-SW100325BL-L', 100325, 'STRATO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 38, 1, 'Piece', '2021-04-15 11:52:51.001530', '2021-04-15 11:52:51.001530', NULL),
	(10001532, 10000001, 'PW21A-SW100325BL-XL', 100325, 'STRATO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001531', '2021-04-15 11:52:51.001531', NULL),
	(10001533, 10000001, 'PW21A-SW100325BL-XXL', 100325, 'STRATO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001532', '2021-04-15 11:52:51.001532', NULL),
	(10001534, 10000001, 'PW21A-SW100326BL-XS', 100326, 'BURNING SKULL HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001533', '2021-04-15 11:52:51.001533', NULL),
	(10001535, 10000001, 'PW21A-SW100326BL-S', 100326, 'BURNING SKULL HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.001534', '2021-04-15 11:52:51.001534', NULL),
	(10001536, 10000001, 'PW21A-SW100326BL-M', 100326, 'BURNING SKULL HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.001535', '2021-04-15 11:52:51.001535', NULL),
	(10001537, 10000001, 'PW21A-SW100326BL-L', 100326, 'BURNING SKULL HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.001536', '2021-04-15 11:52:51.001536', NULL),
	(10001538, 10000001, 'PW21A-SW100326BL-XL', 100326, 'BURNING SKULL HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001537', '2021-04-15 11:52:51.001537', NULL),
	(10001539, 10000001, 'PW21A-SW100326BL-XXL', 100326, 'BURNING SKULL HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001538', '2021-04-15 11:52:51.001538', NULL),
	(10001540, 10000001, 'PW21A-SW100327BL-XS', 100327, 'DEATH GLORY HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001539', '2021-04-15 11:52:51.001539', NULL),
	(10001541, 10000001, 'PW21A-SW100327BL-S', 100327, 'DEATH GLORY HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.001540', '2021-04-15 11:52:51.001540', NULL),
	(10001542, 10000001, 'PW21A-SW100327BL-M', 100327, 'DEATH GLORY HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.001541', '2021-04-15 11:52:51.001541', NULL),
	(10001543, 10000001, 'PW21A-SW100327BL-L', 100327, 'DEATH GLORY HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 24, 1, 'Piece', '2021-04-15 11:52:51.001542', '2021-04-15 11:52:51.001542', NULL),
	(10001544, 10000001, 'PW21A-SW100327BL-XL', 100327, 'DEATH GLORY HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.001543', '2021-04-15 11:52:51.001543', NULL),
	(10001545, 10000001, 'PW21A-SW100327BL-XXL', 100327, 'DEATH GLORY HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001544', '2021-04-15 11:52:51.001544', NULL),
	(10001546, 10000001, 'PW21A-SW100328BL-XS', 100328, 'RIDE AND FREE HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001545', '2021-04-15 11:52:51.001545', NULL),
	(10001547, 10000001, 'PW21A-SW100328BL-S', 100328, 'RIDE AND FREE HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.001546', '2021-04-15 11:52:51.001546', NULL),
	(10001548, 10000001, 'PW21A-SW100328BL-M', 100328, 'RIDE AND FREE HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.001547', '2021-04-15 11:52:51.001547', NULL),
	(10001549, 10000001, 'PW21A-SW100328BL-L', 100328, 'RIDE AND FREE HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.001548', '2021-04-15 11:52:51.001548', NULL),
	(10001550, 10000001, 'PW21A-SW100328BL-XL', 100328, 'RIDE AND FREE HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.001549', '2021-04-15 11:52:51.001549', NULL),
	(10001551, 10000001, 'PW21A-SW100328BL-XXL', 100328, 'RIDE AND FREE HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001550', '2021-04-15 11:52:51.001550', NULL),
	(10001552, 10000001, 'PW21A-SW100329BL-XS', 100329, 'PISTON HEAD HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001551', '2021-04-15 11:52:51.001551', NULL),
	(10001553, 10000001, 'PW21A-SW100329BL-S', 100329, 'PISTON HEAD HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001552', '2021-04-15 11:52:51.001552', NULL),
	(10001554, 10000001, 'PW21A-SW100329BL-M', 100329, 'PISTON HEAD HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.001553', '2021-04-15 11:52:51.001553', NULL),
	(10001555, 10000001, 'PW21A-SW100329BL-L', 100329, 'PISTON HEAD HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 25, 1, 'Piece', '2021-04-15 11:52:51.001554', '2021-04-15 11:52:51.001554', NULL),
	(10001556, 10000001, 'PW21A-SW100329BL-XL', 100329, 'PISTON HEAD HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001555', '2021-04-15 11:52:51.001555', NULL),
	(10001557, 10000001, 'PW21A-SW100329BL-XXL', 100329, 'PISTON HEAD HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001556', '2021-04-15 11:52:51.001556', NULL),
	(10001558, 10000001, 'PW21A-SW100330BL-XS', 100330, 'MOTOR CO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001557', '2021-04-15 11:52:51.001557', NULL),
	(10001559, 10000001, 'PW21A-SW100330BL-S', 100330, 'MOTOR CO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001558', '2021-04-15 11:52:51.001558', NULL),
	(10001560, 10000001, 'PW21A-SW100330BL-M', 100330, 'MOTOR CO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.001559', '2021-04-15 11:52:51.001559', NULL),
	(10001561, 10000001, 'PW21A-SW100330BL-L', 100330, 'MOTOR CO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.001560', '2021-04-15 11:52:51.001560', NULL),
	(10001562, 10000001, 'PW21A-SW100330BL-XL', 100330, 'MOTOR CO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001561', '2021-04-15 11:52:51.001561', NULL),
	(10001563, 10000001, 'PW21A-SW100330BL-XXL', 100330, 'MOTOR CO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001562', '2021-04-15 11:52:51.001562', NULL),
	(10001564, 10000001, 'PW21A-PN100331BL-28', 100331, 'NIGHT RIDER', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001563', '2021-04-15 11:52:51.001563', NULL),
	(10001565, 10000001, 'PW21A-PN100331BL-30', 100331, 'NIGHT RIDER', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001564', '2021-04-15 11:52:51.001564', NULL),
	(10001566, 10000001, 'PW21A-PN100331BL-32', 100331, 'NIGHT RIDER', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001565', '2021-04-15 11:52:51.001565', NULL),
	(10001567, 10000001, 'PW21A-PN100331BL-34', 100331, 'NIGHT RIDER', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001566', '2021-04-15 11:52:51.001566', NULL),
	(10001568, 10000001, 'PW21A-PN100331BL-36', 100331, 'NIGHT RIDER', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001567', '2021-04-15 11:52:51.001567', NULL),
	(10001569, 10000001, 'PW21A-PN100332BL-28', 100332, 'BLACK HAWK', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001568', '2021-04-15 11:52:51.001568', NULL),
	(10001570, 10000001, 'PW21A-PN100332BL-30', 100332, 'BLACK HAWK', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001569', '2021-04-15 11:52:51.001569', NULL),
	(10001571, 10000001, 'PW21A-PN100332BL-32', 100332, 'BLACK HAWK', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001570', '2021-04-15 11:52:51.001570', NULL),
	(10001572, 10000001, 'PW21A-PN100332BL-34', 100332, 'BLACK HAWK', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001571', '2021-04-15 11:52:51.001571', NULL),
	(10001573, 10000001, 'PW21A-PN100332BL-36', 100332, 'BLACK HAWK', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001572', '2021-04-15 11:52:51.001572', NULL),
	(10001574, 10000001, 'PW21A-PN100333BL-28', 100333, 'BLUE WELDER', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001573', '2021-04-15 11:52:51.001573', NULL),
	(10001575, 10000001, 'PW21A-PN100333BL-30', 100333, 'BLUE WELDER', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001574', '2021-04-15 11:52:51.001574', NULL),
	(10001576, 10000001, 'PW21A-PN100333BL-32', 100333, 'BLUE WELDER', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001575', '2021-04-15 11:52:51.001575', NULL),
	(10001577, 10000001, 'PW21A-PN100333BL-34', 100333, 'BLUE WELDER', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001576', '2021-04-15 11:52:51.001576', NULL),
	(10001578, 10000001, 'PW21A-PN100333BL-36', 100333, 'BLUE WELDER', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001577', '2021-04-15 11:52:51.001577', NULL),
	(10001579, 10000001, 'PW21A-PN100334BL-28', 100334, 'NIGHT RIDER 2.0', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001578', '2021-04-15 11:52:51.001578', NULL),
	(10001580, 10000001, 'PW21A-PN100334BL-30', 100334, 'NIGHT RIDER 2.0', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001579', '2021-04-15 11:52:51.001579', NULL),
	(10001581, 10000001, 'PW21A-PN100334BL-32', 100334, 'NIGHT RIDER 2.0', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001580', '2021-04-15 11:52:51.001580', NULL),
	(10001582, 10000001, 'PW21A-PN100334BL-34', 100334, 'NIGHT RIDER 2.0', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001581', '2021-04-15 11:52:51.001581', NULL),
	(10001583, 10000001, 'PW21A-PN100334BL-36', 100334, 'NIGHT RIDER 2.0', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001582', '2021-04-15 11:52:51.001582', NULL),
	(10001584, 10000001, 'PW21A-PN100335BL-28', 100335, 'REMINGTON PANTS BLACK', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001583', '2021-04-15 11:52:51.001583', NULL),
	(10001585, 10000001, 'PW21A-PN100335BL-30', 100335, 'REMINGTON PANTS BLACK', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001584', '2021-04-15 11:52:51.001584', NULL),
	(10001586, 10000001, 'PW21A-PN100335BL-32', 100335, 'REMINGTON PANTS BLACK', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001585', '2021-04-15 11:52:51.001585', NULL),
	(10001587, 10000001, 'PW21A-PN100335BL-34', 100335, 'REMINGTON PANTS BLACK', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001586', '2021-04-15 11:52:51.001586', NULL),
	(10001588, 10000001, 'PW21A-PN100335BL-36', 100335, 'REMINGTON PANTS BLACK', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001587', '2021-04-15 11:52:51.001587', NULL),
	(10001589, 10000001, 'PW21A-PN100336GN-28', 100336, 'REMINGTON PANTS GREEN', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001588', '2021-04-15 11:52:51.001588', NULL),
	(10001590, 10000001, 'PW21A-PN100336GN-30', 100336, 'REMINGTON PANTS GREEN', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001589', '2021-04-15 11:52:51.001589', NULL),
	(10001591, 10000001, 'PW21A-PN100336GN-32', 100336, 'REMINGTON PANTS GREEN', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001590', '2021-04-15 11:52:51.001590', NULL),
	(10001592, 10000001, 'PW21A-PN100336GN-34', 100336, 'REMINGTON PANTS GREEN', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001591', '2021-04-15 11:52:51.001591', NULL),
	(10001593, 10000001, 'PW21A-PN100336GN-36', 100336, 'REMINGTON PANTS GREEN', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001592', '2021-04-15 11:52:51.001592', NULL),
	(10001594, 10000001, 'PW21A-PN100337CM-28', 100337, 'REMINGTON PANTS CAMO', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001593', '2021-04-15 11:52:51.001593', NULL),
	(10001595, 10000001, 'PW21A-PN100337CM-30', 100337, 'REMINGTON PANTS CAMO', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001594', '2021-04-15 11:52:51.001594', NULL),
	(10001596, 10000001, 'PW21A-PN100337CM-32', 100337, 'REMINGTON PANTS CAMO', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001595', '2021-04-15 11:52:51.001595', NULL),
	(10001597, 10000001, 'PW21A-PN100337CM-34', 100337, 'REMINGTON PANTS CAMO', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001596', '2021-04-15 11:52:51.001596', NULL),
	(10001598, 10000001, 'PW21A-PN100337CM-36', 100337, 'REMINGTON PANTS CAMO', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001597', '2021-04-15 11:52:51.001597', NULL),
	(10001599, 10000001, 'PW21A-PN100338BL-28', 100338, 'TEMPERDOWN BLACK', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001598', '2021-04-15 11:52:51.001598', NULL),
	(10001600, 10000001, 'PW21A-PN100338BL-30', 100338, 'TEMPERDOWN BLACK', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001599', '2021-04-15 11:52:51.001599', NULL),
	(10001601, 10000001, 'PW21A-PN100338BL-32', 100338, 'TEMPERDOWN BLACK', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 13, 1, 'Piece', '2021-04-15 11:52:51.001600', '2021-04-15 11:52:51.001600', NULL),
	(10001602, 10000001, 'PW21A-PN100338BL-34', 100338, 'TEMPERDOWN BLACK', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001601', '2021-04-15 11:52:51.001601', NULL),
	(10001603, 10000001, 'PW21A-PN100338BL-36', 100338, 'TEMPERDOWN BLACK', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001602', '2021-04-15 11:52:51.001602', NULL),
	(10001604, 10000001, 'PW21A-PN100339CM-28', 100339, 'TEMPERDOWN CAMO', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001603', '2021-04-15 11:52:51.001603', NULL),
	(10001605, 10000001, 'PW21A-PN100339CM-30', 100339, 'TEMPERDOWN CAMO', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.001604', '2021-04-15 11:52:51.001604', NULL),
	(10001606, 10000001, 'PW21A-PN100339CM-32', 100339, 'TEMPERDOWN CAMO', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 20, 1, 'Piece', '2021-04-15 11:52:51.001605', '2021-04-15 11:52:51.001605', NULL),
	(10001607, 10000001, 'PW21A-PN100339CM-34', 100339, 'TEMPERDOWN CAMO', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001606', '2021-04-15 11:52:51.001606', NULL),
	(10001608, 10000001, 'PW21A-PN100339CM-36', 100339, 'TEMPERDOWN CAMO', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001607', '2021-04-15 11:52:51.001607', NULL),
	(10001609, 10000001, 'PW21A-PN100340OL-28', 100340, 'TEMPERDOWN OLIVE', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001608', '2021-04-15 11:52:51.001608', NULL),
	(10001610, 10000001, 'PW21A-PN100340OL-30', 100340, 'TEMPERDOWN OLIVE', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 14, 1, 'Piece', '2021-04-15 11:52:51.001609', '2021-04-15 11:52:51.001609', NULL),
	(10001611, 10000001, 'PW21A-PN100340OL-32', 100340, 'TEMPERDOWN OLIVE', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.001610', '2021-04-15 11:52:51.001610', NULL),
	(10001612, 10000001, 'PW21A-PN100340OL-34', 100340, 'TEMPERDOWN OLIVE', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001611', '2021-04-15 11:52:51.001611', NULL),
	(10001613, 10000001, 'PW21A-PN100340OL-36', 100340, 'TEMPERDOWN OLIVE', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001612', '2021-04-15 11:52:51.001612', NULL),
	(10001614, 10000001, 'PW21A-PN100341DM-28', 100341, 'BLUE STONE', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001613', '2021-04-15 11:52:51.001613', NULL),
	(10001615, 10000001, 'PW21A-PN100341DM-30', 100341, 'BLUE STONE', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001614', '2021-04-15 11:52:51.001614', NULL),
	(10001616, 10000001, 'PW21A-PN100341DM-32', 100341, 'BLUE STONE', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 15, 1, 'Piece', '2021-04-15 11:52:51.001615', '2021-04-15 11:52:51.001615', NULL),
	(10001617, 10000001, 'PW21A-PN100341DM-34', 100341, 'BLUE STONE', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001616', '2021-04-15 11:52:51.001616', NULL),
	(10001618, 10000001, 'PW21A-PN100341DM-36', 100341, 'BLUE STONE', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001617', '2021-04-15 11:52:51.001617', NULL),
	(10001619, 10000001, 'PW21A-PN100342DM-28', 100342, 'STARLEY', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001618', '2021-04-15 11:52:51.001618', NULL),
	(10001620, 10000001, 'PW21A-PN100342DM-30', 100342, 'STARLEY', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001619', '2021-04-15 11:52:51.001619', NULL),
	(10001621, 10000001, 'PW21A-PN100342DM-32', 100342, 'STARLEY', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.001620', '2021-04-15 11:52:51.001620', NULL),
	(10001622, 10000001, 'PW21A-PN100342DM-34', 100342, 'STARLEY', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001621', '2021-04-15 11:52:51.001621', NULL),
	(10001623, 10000001, 'PW21A-PN100342DM-36', 100342, 'STARLEY', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001622', '2021-04-15 11:52:51.001622', NULL),
	(10001624, 10000001, 'PW21A-PN100343DM-28', 100343, 'WILD ONE', 13, 'Pants', 1, 'Phillip Works ', 10000007, '28', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001623', '2021-04-15 11:52:51.001623', NULL),
	(10001625, 10000001, 'PW21A-PN100343DM-30', 100343, 'WILD ONE', 13, 'Pants', 1, 'Phillip Works ', 10000008, '30', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001624', '2021-04-15 11:52:51.001624', NULL),
	(10001626, 10000001, 'PW21A-PN100343DM-32', 100343, 'WILD ONE', 13, 'Pants', 1, 'Phillip Works ', 10000009, '32', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.001625', '2021-04-15 11:52:51.001625', NULL),
	(10001627, 10000001, 'PW21A-PN100343DM-34', 100343, 'WILD ONE', 13, 'Pants', 1, 'Phillip Works ', 10000010, '34', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001626', '2021-04-15 11:52:51.001626', NULL),
	(10001628, 10000001, 'PW21A-PN100343DM-36', 100343, 'WILD ONE', 13, 'Pants', 1, 'Phillip Works ', 10000011, '36', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001627', '2021-04-15 11:52:51.001627', NULL),
	(10001629, 10000001, 'PW21A-WL100344BW-All', 100344, 'VAQUERO', 14, 'Wallet', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.001628', '2021-04-15 11:52:51.001628', NULL),
	(10001630, 10000001, 'PW21A-WL100345BW-All', 100345, 'RODEO', 14, 'Wallet', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.001629', '2021-04-15 11:52:51.001629', NULL),
	(10001631, 10000001, 'PW21A-WL100346BW-All', 100346, 'TEXAS', 14, 'Wallet', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001630', '2021-04-15 11:52:51.001630', NULL),
	(10001632, 10000001, 'PW21A-HM100347BL-XS', 100347, 'BLACK ROVER DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001631', '2021-04-15 11:52:51.001631', NULL),
	(10001633, 10000001, 'PW21A-HM100347BL-S', 100347, 'BLACK ROVER DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001632', '2021-04-15 11:52:51.001632', NULL),
	(10001634, 10000001, 'PW21A-HM100347BL-M', 100347, 'BLACK ROVER DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001633', '2021-04-15 11:52:51.001633', NULL),
	(10001635, 10000001, 'PW21A-HM100347BL-L', 100347, 'BLACK ROVER DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001634', '2021-04-15 11:52:51.001634', NULL),
	(10001636, 10000001, 'PW21A-HM100347BL-XL', 100347, 'BLACK ROVER DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001635', '2021-04-15 11:52:51.001635', NULL),
	(10001637, 10000001, 'PW21A-HM100347BL-XXL', 100347, 'BLACK ROVER DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001636', '2021-04-15 11:52:51.001636', NULL),
	(10001638, 10000001, 'PW21A-HM100348WT-XS', 100348, 'WHITE ROVER', 9, 'Helmet', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001637', '2021-04-15 11:52:51.001637', NULL),
	(10001639, 10000001, 'PW21A-HM100348WT-S', 100348, 'WHITE ROVER', 9, 'Helmet', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001638', '2021-04-15 11:52:51.001638', NULL),
	(10001640, 10000001, 'PW21A-HM100348WT-M', 100348, 'WHITE ROVER', 9, 'Helmet', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001639', '2021-04-15 11:52:51.001639', NULL),
	(10001641, 10000001, 'PW21A-HM100348WT-L', 100348, 'WHITE ROVER', 9, 'Helmet', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001640', '2021-04-15 11:52:51.001640', NULL),
	(10001642, 10000001, 'PW21A-HM100348WT-XL', 100348, 'WHITE ROVER', 9, 'Helmet', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001641', '2021-04-15 11:52:51.001641', NULL),
	(10001643, 10000001, 'PW21A-HM100348WT-XXL', 100348, 'WHITE ROVER', 9, 'Helmet', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001642', '2021-04-15 11:52:51.001642', NULL),
	(10001644, 10000001, 'PW21A-HM100349BL-XS', 100349, 'RAMBLER BLACK DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001643', '2021-04-15 11:52:51.001643', NULL),
	(10001645, 10000001, 'PW21A-HM100349BL-S', 100349, 'RAMBLER BLACK DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001644', '2021-04-15 11:52:51.001644', NULL),
	(10001646, 10000001, 'PW21A-HM100349BL-M', 100349, 'RAMBLER BLACK DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001645', '2021-04-15 11:52:51.001645', NULL),
	(10001647, 10000001, 'PW21A-HM100349BL-L', 100349, 'RAMBLER BLACK DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001646', '2021-04-15 11:52:51.001646', NULL),
	(10001648, 10000001, 'PW21A-HM100349BL-XL', 100349, 'RAMBLER BLACK DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001647', '2021-04-15 11:52:51.001647', NULL),
	(10001649, 10000001, 'PW21A-HM100349BL-XXL', 100349, 'RAMBLER BLACK DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001648', '2021-04-15 11:52:51.001648', NULL),
	(10001650, 10000001, 'PW21A-HM100350BL-XS', 100350, 'RAMBLER BLACK GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001649', '2021-04-15 11:52:51.001649', NULL),
	(10001651, 10000001, 'PW21A-HM100350BL-S', 100350, 'RAMBLER BLACK GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001650', '2021-04-15 11:52:51.001650', NULL),
	(10001652, 10000001, 'PW21A-HM100350BL-M', 100350, 'RAMBLER BLACK GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001651', '2021-04-15 11:52:51.001651', NULL),
	(10001653, 10000001, 'PW21A-HM100350BL-L', 100350, 'RAMBLER BLACK GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001652', '2021-04-15 11:52:51.001652', NULL),
	(10001654, 10000001, 'PW21A-HM100350BL-XL', 100350, 'RAMBLER BLACK GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001653', '2021-04-15 11:52:51.001653', NULL),
	(10001655, 10000001, 'PW21A-HM100350BL-XXL', 100350, 'RAMBLER BLACK GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001654', '2021-04-15 11:52:51.001654', NULL),
	(10001656, 10000001, 'PW21A-HM100351BL-XS', 100351, 'BLACK ROVER GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001655', '2021-04-15 11:52:51.001655', NULL),
	(10001657, 10000001, 'PW21A-HM100351BL-S', 100351, 'BLACK ROVER GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001656', '2021-04-15 11:52:51.001656', NULL),
	(10001658, 10000001, 'PW21A-HM100351BL-M', 100351, 'BLACK ROVER GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001657', '2021-04-15 11:52:51.001657', NULL),
	(10001659, 10000001, 'PW21A-HM100351BL-L', 100351, 'BLACK ROVER GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001658', '2021-04-15 11:52:51.001658', NULL),
	(10001660, 10000001, 'PW21A-HM100351BL-XL', 100351, 'BLACK ROVER GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001659', '2021-04-15 11:52:51.001659', NULL),
	(10001661, 10000001, 'PW21A-HM100351BL-XXL', 100351, 'BLACK ROVER GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001660', '2021-04-15 11:52:51.001660', NULL),
	(10001662, 10000001, 'PW21A-HM100352BL-XS', 100352, 'ROVER BLACK DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001661', '2021-04-15 11:52:51.001661', NULL),
	(10001663, 10000001, 'PW21A-HM100352BL-S', 100352, 'ROVER BLACK DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001662', '2021-04-15 11:52:51.001662', NULL),
	(10001664, 10000001, 'PW21A-HM100352BL-M', 100352, 'ROVER BLACK DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001663', '2021-04-15 11:52:51.001663', NULL),
	(10001665, 10000001, 'PW21A-HM100352BL-L', 100352, 'ROVER BLACK DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001664', '2021-04-15 11:52:51.001664', NULL),
	(10001666, 10000001, 'PW21A-HM100352BL-XL', 100352, 'ROVER BLACK DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001665', '2021-04-15 11:52:51.001665', NULL),
	(10001667, 10000001, 'PW21A-HM100352BL-XXL', 100352, 'ROVER BLACK DOFF', 9, 'Helmet', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001666', '2021-04-15 11:52:51.001666', NULL),
	(10001668, 10000001, 'PW21A-HM100353WT-XS', 100353, 'ROVER WHITE GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001667', '2021-04-15 11:52:51.001667', NULL),
	(10001669, 10000001, 'PW21A-HM100353WT-S', 100353, 'ROVER WHITE GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001668', '2021-04-15 11:52:51.001668', NULL),
	(10001670, 10000001, 'PW21A-HM100353WT-M', 100353, 'ROVER WHITE GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001669', '2021-04-15 11:52:51.001669', NULL),
	(10001671, 10000001, 'PW21A-HM100353WT-L', 100353, 'ROVER WHITE GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001670', '2021-04-15 11:52:51.001670', NULL),
	(10001672, 10000001, 'PW21A-HM100353WT-XL', 100353, 'ROVER WHITE GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001671', '2021-04-15 11:52:51.001671', NULL),
	(10001673, 10000001, 'PW21A-HM100353WT-XXL', 100353, 'ROVER WHITE GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001672', '2021-04-15 11:52:51.001672', NULL),
	(10001674, 10000001, 'PW21A-HM100354WT-XS', 100354, 'RAMBLER WHITE GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001673', '2021-04-15 11:52:51.001673', NULL),
	(10001675, 10000001, 'PW21A-HM100354WT-S', 100354, 'RAMBLER WHITE GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001674', '2021-04-15 11:52:51.001674', NULL),
	(10001676, 10000001, 'PW21A-HM100354WT-M', 100354, 'RAMBLER WHITE GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001675', '2021-04-15 11:52:51.001675', NULL),
	(10001677, 10000001, 'PW21A-HM100354WT-L', 100354, 'RAMBLER WHITE GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001676', '2021-04-15 11:52:51.001676', NULL),
	(10001678, 10000001, 'PW21A-HM100354WT-XL', 100354, 'RAMBLER WHITE GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001677', '2021-04-15 11:52:51.001677', NULL),
	(10001679, 10000001, 'PW21A-HM100354WT-XXL', 100354, 'RAMBLER WHITE GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001678', '2021-04-15 11:52:51.001678', NULL),
	(10001680, 10000001, 'PW21A-HM100355RD-XS', 100355, 'ROVER RED GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001679', '2021-04-15 11:52:51.001679', NULL),
	(10001681, 10000001, 'PW21A-HM100355RD-S', 100355, 'ROVER RED GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001680', '2021-04-15 11:52:51.001680', NULL),
	(10001682, 10000001, 'PW21A-HM100355RD-M', 100355, 'ROVER RED GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001681', '2021-04-15 11:52:51.001681', NULL),
	(10001683, 10000001, 'PW21A-HM100355RD-L', 100355, 'ROVER RED GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001682', '2021-04-15 11:52:51.001682', NULL),
	(10001684, 10000001, 'PW21A-HM100355RD-XL', 100355, 'ROVER RED GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001683', '2021-04-15 11:52:51.001683', NULL),
	(10001685, 10000001, 'PW21A-HM100355RD-XXL', 100355, 'ROVER RED GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001684', '2021-04-15 11:52:51.001684', NULL),
	(10001686, 10000001, 'PW21A-HM100356YW -XS', 100356, 'RAMBLER YELLOW GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001685', '2021-04-15 11:52:51.001685', NULL),
	(10001687, 10000001, 'PW21A-HM100356YW -S', 100356, 'RAMBLER YELLOW GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001686', '2021-04-15 11:52:51.001686', NULL),
	(10001688, 10000001, 'PW21A-HM100356YW -M', 100356, 'RAMBLER YELLOW GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001687', '2021-04-15 11:52:51.001687', NULL),
	(10001689, 10000001, 'PW21A-HM100356YW -L', 100356, 'RAMBLER YELLOW GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001688', '2021-04-15 11:52:51.001688', NULL),
	(10001690, 10000001, 'PW21A-HM100356YW -XL', 100356, 'RAMBLER YELLOW GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001689', '2021-04-15 11:52:51.001689', NULL),
	(10001691, 10000001, 'PW21A-HM100356YW -XXL', 100356, 'RAMBLER YELLOW GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001690', '2021-04-15 11:52:51.001690', NULL),
	(10001692, 10000001, 'PW21A-HM100357YW -XS', 100357, 'ROVER YELLOW GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001691', '2021-04-15 11:52:51.001691', NULL),
	(10001693, 10000001, 'PW21A-HM100357YW -S', 100357, 'ROVER YELLOW GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001692', '2021-04-15 11:52:51.001692', NULL),
	(10001694, 10000001, 'PW21A-HM100357YW -M', 100357, 'ROVER YELLOW GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001693', '2021-04-15 11:52:51.001693', NULL),
	(10001695, 10000001, 'PW21A-HM100357YW -L', 100357, 'ROVER YELLOW GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001694', '2021-04-15 11:52:51.001694', NULL),
	(10001696, 10000001, 'PW21A-HM100357YW -XL', 100357, 'ROVER YELLOW GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001695', '2021-04-15 11:52:51.001695', NULL),
	(10001697, 10000001, 'PW21A-HM100357YW -XXL', 100357, 'ROVER YELLOW GLOSSY', 9, 'Helmet', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001696', '2021-04-15 11:52:51.001696', NULL),
	(10001698, 10000001, 'PW21A-HM100358WT-XS', 100358, 'ROVER X LOKALHERO', 9, 'Helmet', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001697', '2021-04-15 11:52:51.001697', NULL),
	(10001699, 10000001, 'PW21A-HM100358WT-S', 100358, 'ROVER X LOKALHERO', 9, 'Helmet', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001698', '2021-04-15 11:52:51.001698', NULL),
	(10001700, 10000001, 'PW21A-HM100358WT-M', 100358, 'ROVER X LOKALHERO', 9, 'Helmet', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001699', '2021-04-15 11:52:51.001699', NULL),
	(10001701, 10000001, 'PW21A-HM100358WT-L', 100358, 'ROVER X LOKALHERO', 9, 'Helmet', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001700', '2021-04-15 11:52:51.001700', NULL),
	(10001702, 10000001, 'PW21A-HM100358WT-XL', 100358, 'ROVER X LOKALHERO', 9, 'Helmet', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001701', '2021-04-15 11:52:51.001701', NULL),
	(10001703, 10000001, 'PW21A-HM100358WT-XXL', 100358, 'ROVER X LOKALHERO', 9, 'Helmet', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001702', '2021-04-15 11:52:51.001702', NULL),
	(10001704, 10000001, 'PW21A-JK100359NV-XS', 100359, 'RIDE TO GLORY PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001703', '2021-04-15 11:52:51.001703', NULL),
	(10001705, 10000001, 'PW21A-JK100359NV-S', 100359, 'RIDE TO GLORY PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001704', '2021-04-15 11:52:51.001704', NULL),
	(10001706, 10000001, 'PW21A-JK100359NV-M', 100359, 'RIDE TO GLORY PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001705', '2021-04-15 11:52:51.001705', NULL),
	(10001707, 10000001, 'PW21A-JK100359NV-L', 100359, 'RIDE TO GLORY PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001706', '2021-04-15 11:52:51.001706', NULL),
	(10001708, 10000001, 'PW21A-JK100359NV-XL', 100359, 'RIDE TO GLORY PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001707', '2021-04-15 11:52:51.001707', NULL),
	(10001709, 10000001, 'PW21A-JK100359NV-XXL', 100359, 'RIDE TO GLORY PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001708', '2021-04-15 11:52:51.001708', NULL),
	(10001710, 10000001, 'PW21A-SH100360DM-XS', 100360, 'DENIM BLUE PW', 10, 'Shirt', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001709', '2021-04-15 11:52:51.001709', NULL),
	(10001711, 10000001, 'PW21A-SH100360DM-S', 100360, 'DENIM BLUE PW', 10, 'Shirt', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001710', '2021-04-15 11:52:51.001710', NULL),
	(10001712, 10000001, 'PW21A-SH100360DM-M', 100360, 'DENIM BLUE PW', 10, 'Shirt', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001711', '2021-04-15 11:52:51.001711', NULL),
	(10001713, 10000001, 'PW21A-SH100360DM-L', 100360, 'DENIM BLUE PW', 10, 'Shirt', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001712', '2021-04-15 11:52:51.001712', NULL),
	(10001714, 10000001, 'PW21A-SH100360DM-XL', 100360, 'DENIM BLUE PW', 10, 'Shirt', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001713', '2021-04-15 11:52:51.001713', NULL),
	(10001715, 10000001, 'PW21A-SH100360DM-XXL', 100360, 'DENIM BLUE PW', 10, 'Shirt', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001714', '2021-04-15 11:52:51.001714', NULL),
	(10001716, 10000001, 'PW21A-SH100361BL-XS', 100361, 'CLOUD', 10, 'Shirt', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001715', '2021-04-15 11:52:51.001715', NULL),
	(10001717, 10000001, 'PW21A-SH100361BL-S', 100361, 'CLOUD', 10, 'Shirt', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001716', '2021-04-15 11:52:51.001716', NULL),
	(10001718, 10000001, 'PW21A-SH100361BL-M', 100361, 'CLOUD', 10, 'Shirt', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001717', '2021-04-15 11:52:51.001717', NULL),
	(10001719, 10000001, 'PW21A-SH100361BL-L', 100361, 'CLOUD', 10, 'Shirt', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001718', '2021-04-15 11:52:51.001718', NULL),
	(10001720, 10000001, 'PW21A-SH100361BL-XL', 100361, 'CLOUD', 10, 'Shirt', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001719', '2021-04-15 11:52:51.001719', NULL),
	(10001721, 10000001, 'PW21A-SH100361BL-XXL', 100361, 'CLOUD', 10, 'Shirt', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001720', '2021-04-15 11:52:51.001720', NULL),
	(10001722, 10000001, 'PW21A-SH100362BL-XS', 100362, 'STEVIE', 10, 'Shirt', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001721', '2021-04-15 11:52:51.001721', NULL),
	(10001723, 10000001, 'PW21A-SH100362BL-S', 100362, 'STEVIE', 10, 'Shirt', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001722', '2021-04-15 11:52:51.001722', NULL),
	(10001724, 10000001, 'PW21A-SH100362BL-M', 100362, 'STEVIE', 10, 'Shirt', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001723', '2021-04-15 11:52:51.001723', NULL),
	(10001725, 10000001, 'PW21A-SH100362BL-L', 100362, 'STEVIE', 10, 'Shirt', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001724', '2021-04-15 11:52:51.001724', NULL),
	(10001726, 10000001, 'PW21A-SH100362BL-XL', 100362, 'STEVIE', 10, 'Shirt', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001725', '2021-04-15 11:52:51.001725', NULL),
	(10001727, 10000001, 'PW21A-SH100362BL-XXL', 100362, 'STEVIE', 10, 'Shirt', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001726', '2021-04-15 11:52:51.001726', NULL),
	(10001728, 10000001, 'PW21A-JK100363BL-XS', 100363, 'CRUISER GORETEX', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001727', '2021-04-15 11:52:51.001727', NULL),
	(10001729, 10000001, 'PW21A-JK100363BL-S', 100363, 'CRUISER GORETEX', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001728', '2021-04-15 11:52:51.001728', NULL),
	(10001730, 10000001, 'PW21A-JK100363BL-M', 100363, 'CRUISER GORETEX', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001729', '2021-04-15 11:52:51.001729', NULL),
	(10001731, 10000001, 'PW21A-JK100363BL-L', 100363, 'CRUISER GORETEX', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001730', '2021-04-15 11:52:51.001730', NULL),
	(10001732, 10000001, 'PW21A-JK100363BL-XL', 100363, 'CRUISER GORETEX', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001731', '2021-04-15 11:52:51.001731', NULL),
	(10001733, 10000001, 'PW21A-JK100363BL-XXL', 100363, 'CRUISER GORETEX', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001732', '2021-04-15 11:52:51.001732', NULL),
	(10001734, 10000001, 'PW21A-SH100364BL-XS', 100364, 'DEVON', 10, 'Shirt', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001733', '2021-04-15 11:52:51.001733', NULL),
	(10001735, 10000001, 'PW21A-SH100364BL-S', 100364, 'DEVON', 10, 'Shirt', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001734', '2021-04-15 11:52:51.001734', NULL),
	(10001736, 10000001, 'PW21A-SH100364BL-M', 100364, 'DEVON', 10, 'Shirt', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001735', '2021-04-15 11:52:51.001735', NULL),
	(10001737, 10000001, 'PW21A-SH100364BL-L', 100364, 'DEVON', 10, 'Shirt', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001736', '2021-04-15 11:52:51.001736', NULL),
	(10001738, 10000001, 'PW21A-SH100364BL-XL', 100364, 'DEVON', 10, 'Shirt', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001737', '2021-04-15 11:52:51.001737', NULL),
	(10001739, 10000001, 'PW21A-SH100364BL-XXL', 100364, 'DEVON', 10, 'Shirt', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001738', '2021-04-15 11:52:51.001738', NULL),
	(10001740, 10000001, 'PW21A-SW100365GY-XS', 100365, 'SACRAMENTO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001739', '2021-04-15 11:52:51.001739', NULL),
	(10001741, 10000001, 'PW21A-SW100365GY-S', 100365, 'SACRAMENTO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001740', '2021-04-15 11:52:51.001740', NULL),
	(10001742, 10000001, 'PW21A-SW100365GY-M', 100365, 'SACRAMENTO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001741', '2021-04-15 11:52:51.001741', NULL),
	(10001743, 10000001, 'PW21A-SW100365GY-L', 100365, 'SACRAMENTO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001742', '2021-04-15 11:52:51.001742', NULL),
	(10001744, 10000001, 'PW21A-SW100365GY-XL', 100365, 'SACRAMENTO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001743', '2021-04-15 11:52:51.001743', NULL),
	(10001745, 10000001, 'PW21A-SW100365GY-XXL', 100365, 'SACRAMENTO HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001744', '2021-04-15 11:52:51.001744', NULL),
	(10001746, 10000001, 'PW21A-SW100366GY-XS', 100366, 'MC CARTHY HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001745', '2021-04-15 11:52:51.001745', NULL),
	(10001747, 10000001, 'PW21A-SW100366GY-S', 100366, 'MC CARTHY HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001746', '2021-04-15 11:52:51.001746', NULL),
	(10001748, 10000001, 'PW21A-SW100366GY-M', 100366, 'MC CARTHY HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001747', '2021-04-15 11:52:51.001747', NULL),
	(10001749, 10000001, 'PW21A-SW100366GY-L', 100366, 'MC CARTHY HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001748', '2021-04-15 11:52:51.001748', NULL),
	(10001750, 10000001, 'PW21A-SW100366GY-XL', 100366, 'MC CARTHY HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001749', '2021-04-15 11:52:51.001749', NULL),
	(10001751, 10000001, 'PW21A-SW100366GY-XXL', 100366, 'MC CARTHY HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001750', '2021-04-15 11:52:51.001750', NULL),
	(10001752, 10000001, 'PW21A-SW100367BL-XS', 100367, 'BLACK TERRA', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001751', '2021-04-15 11:52:51.001751', NULL),
	(10001753, 10000001, 'PW21A-SW100367BL-S', 100367, 'BLACK TERRA', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001752', '2021-04-15 11:52:51.001752', NULL),
	(10001754, 10000001, 'PW21A-SW100367BL-M', 100367, 'BLACK TERRA', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001753', '2021-04-15 11:52:51.001753', NULL),
	(10001755, 10000001, 'PW21A-SW100367BL-L', 100367, 'BLACK TERRA', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001754', '2021-04-15 11:52:51.001754', NULL),
	(10001756, 10000001, 'PW21A-SW100367BL-XL', 100367, 'BLACK TERRA', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001755', '2021-04-15 11:52:51.001755', NULL),
	(10001757, 10000001, 'PW21A-SW100367BL-XXL', 100367, 'BLACK TERRA', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001756', '2021-04-15 11:52:51.001756', NULL),
	(10001758, 10000001, 'PW21A-SW100368NV-XS', 100368, 'STRONGER THAN FEAR', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001757', '2021-04-15 11:52:51.001757', NULL),
	(10001759, 10000001, 'PW21A-SW100368NV-S', 100368, 'STRONGER THAN FEAR', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001758', '2021-04-15 11:52:51.001758', NULL),
	(10001760, 10000001, 'PW21A-SW100368NV-M', 100368, 'STRONGER THAN FEAR', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001759', '2021-04-15 11:52:51.001759', NULL),
	(10001761, 10000001, 'PW21A-SW100368NV-L', 100368, 'STRONGER THAN FEAR', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001760', '2021-04-15 11:52:51.001760', NULL),
	(10001762, 10000001, 'PW21A-SW100368NV-XL', 100368, 'STRONGER THAN FEAR', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001761', '2021-04-15 11:52:51.001761', NULL),
	(10001763, 10000001, 'PW21A-SW100368NV-XXL', 100368, 'STRONGER THAN FEAR', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001762', '2021-04-15 11:52:51.001762', NULL),
	(10001764, 10000001, 'PW21A-JK100369BL-XS', 100369, 'INDIAN GORETEX', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001763', '2021-04-15 11:52:51.001763', NULL),
	(10001765, 10000001, 'PW21A-JK100369BL-S', 100369, 'INDIAN GORETEX', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001764', '2021-04-15 11:52:51.001764', NULL),
	(10001766, 10000001, 'PW21A-JK100369BL-M', 100369, 'INDIAN GORETEX', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001765', '2021-04-15 11:52:51.001765', NULL),
	(10001767, 10000001, 'PW21A-JK100369BL-L', 100369, 'INDIAN GORETEX', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001766', '2021-04-15 11:52:51.001766', NULL),
	(10001768, 10000001, 'PW21A-JK100369BL-XL', 100369, 'INDIAN GORETEX', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001767', '2021-04-15 11:52:51.001767', NULL),
	(10001769, 10000001, 'PW21A-JK100369BL-XXL', 100369, 'INDIAN GORETEX', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001768', '2021-04-15 11:52:51.001768', NULL),
	(10001770, 10000001, 'PW21A-SH100370NV-XS', 100370, 'BROOKLYN', 10, 'Shirt', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001769', '2021-04-15 11:52:51.001769', NULL),
	(10001771, 10000001, 'PW21A-SH100370NV-S', 100370, 'BROOKLYN', 10, 'Shirt', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001770', '2021-04-15 11:52:51.001770', NULL),
	(10001772, 10000001, 'PW21A-SH100370NV-M', 100370, 'BROOKLYN', 10, 'Shirt', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001771', '2021-04-15 11:52:51.001771', NULL),
	(10001773, 10000001, 'PW21A-SH100370NV-L', 100370, 'BROOKLYN', 10, 'Shirt', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001772', '2021-04-15 11:52:51.001772', NULL),
	(10001774, 10000001, 'PW21A-SH100370NV-XL', 100370, 'BROOKLYN', 10, 'Shirt', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001773', '2021-04-15 11:52:51.001773', NULL),
	(10001775, 10000001, 'PW21A-SH100370NV-XXL', 100370, 'BROOKLYN', 10, 'Shirt', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001774', '2021-04-15 11:52:51.001774', NULL),
	(10001776, 10000001, 'PW21A-SH100371BL-XS', 100371, 'OKLAHOMA', 10, 'Shirt', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001775', '2021-04-15 11:52:51.001775', NULL),
	(10001777, 10000001, 'PW21A-SH100371BL-S', 100371, 'OKLAHOMA', 10, 'Shirt', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001776', '2021-04-15 11:52:51.001776', NULL),
	(10001778, 10000001, 'PW21A-SH100371BL-M', 100371, 'OKLAHOMA', 10, 'Shirt', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001777', '2021-04-15 11:52:51.001777', NULL),
	(10001779, 10000001, 'PW21A-SH100371BL-L', 100371, 'OKLAHOMA', 10, 'Shirt', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001778', '2021-04-15 11:52:51.001778', NULL),
	(10001780, 10000001, 'PW21A-SH100371BL-XL', 100371, 'OKLAHOMA', 10, 'Shirt', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001779', '2021-04-15 11:52:51.001779', NULL),
	(10001781, 10000001, 'PW21A-SH100371BL-XXL', 100371, 'OKLAHOMA', 10, 'Shirt', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001780', '2021-04-15 11:52:51.001780', NULL),
	(10001782, 10000001, 'PW21A-SH100372DK-XS', 100372, 'PHANTOM', 10, 'Shirt', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001781', '2021-04-15 11:52:51.001781', NULL),
	(10001783, 10000001, 'PW21A-SH100372DK-S', 100372, 'PHANTOM', 10, 'Shirt', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001782', '2021-04-15 11:52:51.001782', NULL),
	(10001784, 10000001, 'PW21A-SH100372DK-M', 100372, 'PHANTOM', 10, 'Shirt', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001783', '2021-04-15 11:52:51.001783', NULL),
	(10001785, 10000001, 'PW21A-SH100372DK-L', 100372, 'PHANTOM', 10, 'Shirt', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001784', '2021-04-15 11:52:51.001784', NULL),
	(10001786, 10000001, 'PW21A-SH100372DK-XL', 100372, 'PHANTOM', 10, 'Shirt', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001785', '2021-04-15 11:52:51.001785', NULL),
	(10001787, 10000001, 'PW21A-SH100372DK-XXL', 100372, 'PHANTOM', 10, 'Shirt', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001786', '2021-04-15 11:52:51.001786', NULL),
	(10001788, 10000001, 'PW21A-SH100373GY-XS', 100373, 'MAJESTY', 10, 'Shirt', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001787', '2021-04-15 11:52:51.001787', NULL),
	(10001789, 10000001, 'PW21A-SH100373GY-S', 100373, 'MAJESTY', 10, 'Shirt', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001788', '2021-04-15 11:52:51.001788', NULL),
	(10001790, 10000001, 'PW21A-SH100373GY-M', 100373, 'MAJESTY', 10, 'Shirt', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001789', '2021-04-15 11:52:51.001789', NULL),
	(10001791, 10000001, 'PW21A-SH100373GY-L', 100373, 'MAJESTY', 10, 'Shirt', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001790', '2021-04-15 11:52:51.001790', NULL),
	(10001792, 10000001, 'PW21A-SH100373GY-XL', 100373, 'MAJESTY', 10, 'Shirt', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001791', '2021-04-15 11:52:51.001791', NULL),
	(10001793, 10000001, 'PW21A-SH100373GY-XXL', 100373, 'MAJESTY', 10, 'Shirt', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001792', '2021-04-15 11:52:51.001792', NULL),
	(10001794, 10000001, 'PW21A-SH100374GY-XS', 100374, 'LONDON PRINTED SHIRT', 10, 'Shirt', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001793', '2021-04-15 11:52:51.001793', NULL),
	(10001795, 10000001, 'PW21A-SH100374GY-S', 100374, 'LONDON PRINTED SHIRT', 10, 'Shirt', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.001794', '2021-04-15 11:52:51.001794', NULL),
	(10001796, 10000001, 'PW21A-SH100374GY-M', 100374, 'LONDON PRINTED SHIRT', 10, 'Shirt', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001795', '2021-04-15 11:52:51.001795', NULL),
	(10001797, 10000001, 'PW21A-SH100374GY-L', 100374, 'LONDON PRINTED SHIRT', 10, 'Shirt', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001796', '2021-04-15 11:52:51.001796', NULL),
	(10001798, 10000001, 'PW21A-SH100374GY-XL', 100374, 'LONDON PRINTED SHIRT', 10, 'Shirt', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001797', '2021-04-15 11:52:51.001797', NULL),
	(10001799, 10000001, 'PW21A-SH100374GY-XXL', 100374, 'LONDON PRINTED SHIRT', 10, 'Shirt', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001798', '2021-04-15 11:52:51.001798', NULL),
	(10001800, 10000001, 'PW21A-SH100375BL-XS', 100375, 'NORDIC URBAN', 10, 'Shirt', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001799', '2021-04-15 11:52:51.001799', NULL),
	(10001801, 10000001, 'PW21A-SH100375BL-S', 100375, 'NORDIC URBAN', 10, 'Shirt', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 17, 1, 'Piece', '2021-04-15 11:52:51.001800', '2021-04-15 11:52:51.001800', NULL),
	(10001802, 10000001, 'PW21A-SH100375BL-M', 100375, 'NORDIC URBAN', 10, 'Shirt', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 18, 1, 'Piece', '2021-04-15 11:52:51.001801', '2021-04-15 11:52:51.001801', NULL),
	(10001803, 10000001, 'PW21A-SH100375BL-L', 100375, 'NORDIC URBAN', 10, 'Shirt', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.001802', '2021-04-15 11:52:51.001802', NULL),
	(10001804, 10000001, 'PW21A-SH100375BL-XL', 100375, 'NORDIC URBAN', 10, 'Shirt', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001803', '2021-04-15 11:52:51.001803', NULL),
	(10001805, 10000001, 'PW21A-SH100375BL-XXL', 100375, 'NORDIC URBAN', 10, 'Shirt', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001804', '2021-04-15 11:52:51.001804', NULL),
	(10001806, 10000001, 'PW21A-SH100376CM-XS', 100376, 'ROOKIE CAMO SHIRT', 10, 'Shirt', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001805', '2021-04-15 11:52:51.001805', NULL),
	(10001807, 10000001, 'PW21A-SH100376CM-S', 100376, 'ROOKIE CAMO SHIRT', 10, 'Shirt', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.001806', '2021-04-15 11:52:51.001806', NULL),
	(10001808, 10000001, 'PW21A-SH100376CM-M', 100376, 'ROOKIE CAMO SHIRT', 10, 'Shirt', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 19, 1, 'Piece', '2021-04-15 11:52:51.001807', '2021-04-15 11:52:51.001807', NULL),
	(10001809, 10000001, 'PW21A-SH100376CM-L', 100376, 'ROOKIE CAMO SHIRT', 10, 'Shirt', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001808', '2021-04-15 11:52:51.001808', NULL),
	(10001810, 10000001, 'PW21A-SH100376CM-XL', 100376, 'ROOKIE CAMO SHIRT', 10, 'Shirt', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001809', '2021-04-15 11:52:51.001809', NULL),
	(10001811, 10000001, 'PW21A-SH100376CM-XXL', 100376, 'ROOKIE CAMO SHIRT', 10, 'Shirt', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001810', '2021-04-15 11:52:51.001810', NULL),
	(10001812, 10000001, 'PW21A-SW100377BL-XS', 100377, 'RECKLESS HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001811', '2021-04-15 11:52:51.001811', NULL),
	(10001813, 10000001, 'PW21A-SW100377BL-S', 100377, 'RECKLESS HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001812', '2021-04-15 11:52:51.001812', NULL),
	(10001814, 10000001, 'PW21A-SW100377BL-M', 100377, 'RECKLESS HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001813', '2021-04-15 11:52:51.001813', NULL),
	(10001815, 10000001, 'PW21A-SW100377BL-L', 100377, 'RECKLESS HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001814', '2021-04-15 11:52:51.001814', NULL),
	(10001816, 10000001, 'PW21A-SW100377BL-XL', 100377, 'RECKLESS HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001815', '2021-04-15 11:52:51.001815', NULL),
	(10001817, 10000001, 'PW21A-SW100377BL-XXL', 100377, 'RECKLESS HOODIE 2.0', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001816', '2021-04-15 11:52:51.001816', NULL),
	(10001818, 10000001, 'PW21A-SW100314DK-XS', 100314, 'STORM ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001817', '2021-04-15 11:52:51.001817', NULL),
	(10001819, 10000001, 'PW21A-SW100314DK-S', 100314, 'STORM ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001818', '2021-04-15 11:52:51.001818', NULL),
	(10001820, 10000001, 'PW21A-SW100314DK-M', 100314, 'STORM ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001819', '2021-04-15 11:52:51.001819', NULL),
	(10001821, 10000001, 'PW21A-SW100314DK-L', 100314, 'STORM ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001820', '2021-04-15 11:52:51.001820', NULL),
	(10001822, 10000001, 'PW21A-SW100314DK-XL', 100314, 'STORM ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001821', '2021-04-15 11:52:51.001821', NULL),
	(10001823, 10000001, 'PW21A-SW100314DK-XXL', 100314, 'STORM ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001822', '2021-04-15 11:52:51.001822', NULL),
	(10001824, 10000001, 'PW21A-SW100379GY-XS', 100379, 'BLIZZARD ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001823', '2021-04-15 11:52:51.001823', NULL),
	(10001825, 10000001, 'PW21A-SW100379GY-S', 100379, 'BLIZZARD ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.001824', '2021-04-15 11:52:51.001824', NULL),
	(10001826, 10000001, 'PW21A-SW100379GY-M', 100379, 'BLIZZARD ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.001825', '2021-04-15 11:52:51.001825', NULL),
	(10001827, 10000001, 'PW21A-SW100379GY-L', 100379, 'BLIZZARD ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.001826', '2021-04-15 11:52:51.001826', NULL),
	(10001828, 10000001, 'PW21A-SW100379GY-XL', 100379, 'BLIZZARD ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 9, 1, 'Piece', '2021-04-15 11:52:51.001827', '2021-04-15 11:52:51.001827', NULL),
	(10001829, 10000001, 'PW21A-SW100379GY-XXL', 100379, 'BLIZZARD ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001828', '2021-04-15 11:52:51.001828', NULL),
	(10001830, 10000001, 'PW21A-SW100380NV-XS', 100380, 'LIGHTNING ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001829', '2021-04-15 11:52:51.001829', NULL),
	(10001831, 10000001, 'PW21A-SW100380NV-S', 100380, 'LIGHTNING ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 16, 1, 'Piece', '2021-04-15 11:52:51.001830', '2021-04-15 11:52:51.001830', NULL),
	(10001832, 10000001, 'PW21A-SW100380NV-M', 100380, 'LIGHTNING ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 11, 1, 'Piece', '2021-04-15 11:52:51.001831', '2021-04-15 11:52:51.001831', NULL),
	(10001833, 10000001, 'PW21A-SW100380NV-L', 100380, 'LIGHTNING ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 10, 1, 'Piece', '2021-04-15 11:52:51.001832', '2021-04-15 11:52:51.001832', NULL),
	(10001834, 10000001, 'PW21A-SW100380NV-XL', 100380, 'LIGHTNING ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001833', '2021-04-15 11:52:51.001833', NULL),
	(10001835, 10000001, 'PW21A-SW100380NV-XXL', 100380, 'LIGHTNING ACTIVE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001834', '2021-04-15 11:52:51.001834', NULL),
	(10001836, 10000001, 'PW21A-SW100381BL-XS', 100381, 'CHRYSANT DEMON HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001835', '2021-04-15 11:52:51.001835', NULL),
	(10001837, 10000001, 'PW21A-SW100381BL-S', 100381, 'CHRYSANT DEMON HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001836', '2021-04-15 11:52:51.001836', NULL),
	(10001838, 10000001, 'PW21A-SW100381BL-M', 100381, 'CHRYSANT DEMON HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001837', '2021-04-15 11:52:51.001837', NULL),
	(10001839, 10000001, 'PW21A-SW100381BL-L', 100381, 'CHRYSANT DEMON HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001838', '2021-04-15 11:52:51.001838', NULL),
	(10001840, 10000001, 'PW21A-SW100381BL-XL', 100381, 'CHRYSANT DEMON HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001839', '2021-04-15 11:52:51.001839', NULL),
	(10001841, 10000001, 'PW21A-SW100381BL-XXL', 100381, 'CHRYSANT DEMON HOODIE', 12, 'Sweater', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001840', '2021-04-15 11:52:51.001840', NULL),
	(10001842, 10000002, 'PW21A-AC100001BL-All', 100001, 'PHILLIP LOGO ENAMEL', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001841', '2021-04-15 11:52:51.001841', NULL),
	(10001843, 10000002, 'PW21A-AC100002YW -All', 100002, 'PHILLIP PLATE ENAMEL', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001842', '2021-04-15 11:52:51.001842', NULL),
	(10001844, 10000002, 'PW21A-AC100003BL-All', 100003, 'PHILLIP PATCH ENAMEL', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001843', '2021-04-15 11:52:51.001843', NULL),
	(10001845, 10000002, 'PW21A-AC100004BL-All', 100004, 'PHILLIP UMBRELLA', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001844', '2021-04-15 11:52:51.001844', NULL),
	(10001846, 10000002, 'PW21A-AC100005BL-All', 100005, 'PHILLIP ASHTRAY', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001845', '2021-04-15 11:52:51.001845', NULL),
	(10001847, 10000002, 'PW21A-AC100006BL-All', 100006, 'PHILLIP BOTTLE SPORT', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 12, 1, 'Piece', '2021-04-15 11:52:51.001846', '2021-04-15 11:52:51.001846', NULL),
	(10001848, 10000002, 'PW21A-AC100007BL-All', 100007, 'PHILLIP BOTTLE SPORT 2.0', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 7, 1, 'Piece', '2021-04-15 11:52:51.001847', '2021-04-15 11:52:51.001847', NULL),
	(10001849, 10000002, 'PW21A-AC100008BL-All', 100008, 'PHILLIP KEYCHAIN BLACK', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001848', '2021-04-15 11:52:51.001848', NULL),
	(10001850, 10000002, 'PW21A-AC100009BW-All', 100009, 'PHILLIP KEYCHAIN BROWN', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001849', '2021-04-15 11:52:51.001849', NULL),
	(10001851, 10000002, 'PW21A-AC100010MC-All', 100010, 'PHILLIP KEYCHAIN MOCCA', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001850', '2021-04-15 11:52:51.001850', NULL),
	(10001852, 10000002, 'PW21A-AC100011OG-All', 100011, 'PHILLIP KEYCHAIN ORANGE', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001851', '2021-04-15 11:52:51.001851', NULL),
	(10001853, 10000002, 'PW21A-AC100012BL-All', 100012, 'PW MOTO KEYCHAIN BLACK', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001852', '2021-04-15 11:52:51.001852', NULL),
	(10001854, 10000002, 'PW21A-AC100013OG-All', 100013, 'PW MOTO KEYCHAIN ORANGE', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001853', '2021-04-15 11:52:51.001853', NULL),
	(10001855, 10000002, 'PW21A-AC100014OL-All', 100014, 'PW MOTO KEYCHAIN OLIVE', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001854', '2021-04-15 11:52:51.001854', NULL),
	(10001856, 10000002, 'PW21A-AC100015MR-All', 100015, 'PW MOTO KEYCHAIN MAROON', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001855', '2021-04-15 11:52:51.001855', NULL),
	(10001857, 10000002, 'PW21A-AC100016BL-All', 100016, 'PHILLIP COIN CASE', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001856', '2021-04-15 11:52:51.001856', NULL),
	(10001858, 10000002, 'PW21A-AC100017BL-All', 100017, 'DEMAND FREEDOM COIN CASE', 3, 'Accesories', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001857', '2021-04-15 11:52:51.001857', NULL),
	(10001859, 10000002, 'PW21A-BG100018WT-All', 100018, 'SPENCER WAISTBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001858', '2021-04-15 11:52:51.001858', NULL),
	(10001860, 10000002, 'PW21A-BG100019BL-All', 100019, 'OLIVER WAISTBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001859', '2021-04-15 11:52:51.001859', NULL),
	(10001861, 10000002, 'PW21A-BG100020BL-All', 100020, 'JOHNSON WAISTBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001860', '2021-04-15 11:52:51.001860', NULL),
	(10001862, 10000002, 'PW21A-BG100021BL-All', 100021, 'URBAN BACKPACK', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001861', '2021-04-15 11:52:51.001861', NULL),
	(10001863, 10000002, 'PW21A-BG100022BL-All', 100022, 'XJ-030 WAISTBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001862', '2021-04-15 11:52:51.001862', NULL),
	(10001864, 10000002, 'PW21A-BG100023BL-All', 100023, 'XJ-077 SLINGBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001863', '2021-04-15 11:52:51.001863', NULL),
	(10001865, 10000002, 'PW21A-BG100024BL-All', 100024, 'XJ-012 HOLSTER', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001864', '2021-04-15 11:52:51.001864', NULL),
	(10001866, 10000002, 'PW21A-BG100025BL-All', 100025, 'XJ-069 MESSENGER', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001865', '2021-04-15 11:52:51.001865', NULL),
	(10001867, 10000002, 'PW21A-BG100026CM-All', 100026, 'XJ-012 HOLSTER GREY', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001866', '2021-04-15 11:52:51.001866', NULL),
	(10001868, 10000002, 'PW21A-BG100027CM-All', 100027, 'XJ-012 HOLSTER ARMY', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001867', '2021-04-15 11:52:51.001867', NULL),
	(10001869, 10000002, 'PW21A-BG100028CM-All', 100028, '2 IN 1 BACKPACK GREY', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001868', '2021-04-15 11:52:51.001868', NULL),
	(10001870, 10000002, 'PW21A-BG100029CM-All', 100029, '2 IN 1 BACKPACK GREEN', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001869', '2021-04-15 11:52:51.001869', NULL),
	(10001871, 10000002, 'PW21A-BG100030BL-All', 100030, 'XJ-099 3 LAYER SLINGBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001870', '2021-04-15 11:52:51.001870', NULL),
	(10001872, 10000002, 'PW21A-BG100031BL-All', 100031, 'URBAN TRAVEL BAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001871', '2021-04-15 11:52:51.001871', NULL),
	(10001873, 10000002, 'PW21A-BG100032BL-All', 100032, 'LOGO TOTE BAG YELLOW', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001872', '2021-04-15 11:52:51.001872', NULL),
	(10001874, 10000002, 'PW21A-BG100033BL-All', 100033, 'LOGO TOTE BAG WHITE', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001873', '2021-04-15 11:52:51.001873', NULL),
	(10001875, 10000002, 'PW21A-BG100034BL-All', 100034, 'CLASSIC LOGO TOTE BAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001874', '2021-04-15 11:52:51.001874', NULL),
	(10001876, 10000002, 'PW21A-BG100035BL-All', 100035, 'RIVERA BACKPACK', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001875', '2021-04-15 11:52:51.001875', NULL),
	(10001877, 10000002, 'PW21A-BG100036BL-All', 100036, 'PATHFINDER BACKPACK', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001876', '2021-04-15 11:52:51.001876', NULL),
	(10001878, 10000002, 'PW21A-BG100037OG-All', 100037, 'STING RAY', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001877', '2021-04-15 11:52:51.001877', NULL),
	(10001879, 10000002, 'PW21A-BG100038BL-All', 100038, 'SHELBY', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001878', '2021-04-15 11:52:51.001878', NULL),
	(10001880, 10000002, 'PW21A-BG100039GN-All', 100039, 'CABRIO', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001879', '2021-04-15 11:52:51.001879', NULL),
	(10001881, 10000002, 'PW21A-BG100040WT-All', 100040, 'ELEANOR', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001880', '2021-04-15 11:52:51.001880', NULL),
	(10001882, 10000002, 'PW21A-BG100041BL-All', 100041, 'BIKE POUCH', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001881', '2021-04-15 11:52:51.001881', NULL),
	(10001883, 10000002, 'PW21A-BG100042BL-All', 100042, 'MARINO BAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001882', '2021-04-15 11:52:51.001882', NULL),
	(10001884, 10000002, 'PW21A-BG100043BL-All', 100043, 'FLOYD WAISTBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001883', '2021-04-15 11:52:51.001883', NULL),
	(10001885, 10000002, 'PW21A-BG100044BL-All', 100044, 'HAMILTON POUCH', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001884', '2021-04-15 11:52:51.001884', NULL),
	(10001886, 10000002, 'PW21A-BG100045BL-All', 100045, 'JAVAS SLINGBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001885', '2021-04-15 11:52:51.001885', NULL),
	(10001887, 10000002, 'PW21A-BG100046BL-All', 100046, 'SPECTER TOTEBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001886', '2021-04-15 11:52:51.001886', NULL),
	(10001888, 10000002, 'PW21A-BG100047BL-All', 100047, 'STRATO BACKPACK', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001887', '2021-04-15 11:52:51.001887', NULL),
	(10001889, 10000002, 'PW21A-BG100048BL-All', 100048, 'JAMES SLINGBAG', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001888', '2021-04-15 11:52:51.001888', NULL),
	(10001890, 10000002, 'PW21A-BG100049BL-All', 100049, 'SMALL LAPTOP CASE', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001889', '2021-04-15 11:52:51.001889', NULL),
	(10001891, 10000002, 'PW21A-BG100050BL-All', 100050, 'LARGE LAPTOP CASE', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001890', '2021-04-15 11:52:51.001890', NULL),
	(10001892, 10000002, 'PW21A-BG100051BL-All', 100051, 'SMITH', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001891', '2021-04-15 11:52:51.001891', NULL),
	(10001893, 10000002, 'PW21A-BG100052BL-All', 100052, 'HYBRID WP', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001892', '2021-04-15 11:52:51.001892', NULL),
	(10001894, 10000002, 'PW21A-BG100053BL-All', 100053, 'RUNNING PACK', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001893', '2021-04-15 11:52:51.001893', NULL),
	(10001895, 10000002, 'PW21A-BG100054BL-All', 100054, 'PATHFINDER BACKPACK 2.0', 4, 'Bag', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001894', '2021-04-15 11:52:51.001894', NULL),
	(10001896, 10000002, 'PW21A-GL100055YW -S', 100055, 'YELLOW BANDIT', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001895', '2021-04-15 11:52:51.001895', NULL),
	(10001897, 10000002, 'PW21A-GL100055YW -M', 100055, 'YELLOW BANDIT', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001896', '2021-04-15 11:52:51.001896', NULL),
	(10001898, 10000002, 'PW21A-GL100055YW -L', 100055, 'YELLOW BANDIT', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001897', '2021-04-15 11:52:51.001897', NULL),
	(10001899, 10000002, 'PW21A-GL100055YW -XL', 100055, 'YELLOW BANDIT', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001898', '2021-04-15 11:52:51.001898', NULL),
	(10001900, 10000002, 'PW21A-GL100056BW-S', 100056, 'ROAD RUNNER', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001899', '2021-04-15 11:52:51.001899', NULL),
	(10001901, 10000002, 'PW21A-GL100056BW-M', 100056, 'ROAD RUNNER', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001900', '2021-04-15 11:52:51.001900', NULL),
	(10001902, 10000002, 'PW21A-GL100056BW-L', 100056, 'ROAD RUNNER', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001901', '2021-04-15 11:52:51.001901', NULL),
	(10001903, 10000002, 'PW21A-GL100056BW-XL', 100056, 'ROAD RUNNER', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001902', '2021-04-15 11:52:51.001902', NULL),
	(10001904, 10000002, 'PW21A-GL100057CM-S', 100057, 'BOLD HUNTER', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001903', '2021-04-15 11:52:51.001903', NULL),
	(10001905, 10000002, 'PW21A-GL100057CM-M', 100057, 'BOLD HUNTER', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001904', '2021-04-15 11:52:51.001904', NULL),
	(10001906, 10000002, 'PW21A-GL100057CM-L', 100057, 'BOLD HUNTER', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001905', '2021-04-15 11:52:51.001905', NULL),
	(10001907, 10000002, 'PW21A-GL100057CM-XL', 100057, 'BOLD HUNTER', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001906', '2021-04-15 11:52:51.001906', NULL),
	(10001908, 10000002, 'PW21A-GL100058BW-S', 100058, 'MAD GREASER', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001907', '2021-04-15 11:52:51.001907', NULL),
	(10001909, 10000002, 'PW21A-GL100058BW-M', 100058, 'MAD GREASER', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001908', '2021-04-15 11:52:51.001908', NULL),
	(10001910, 10000002, 'PW21A-GL100058BW-L', 100058, 'MAD GREASER', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001909', '2021-04-15 11:52:51.001909', NULL),
	(10001911, 10000002, 'PW21A-GL100058BW-XL', 100058, 'MAD GREASER', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001910', '2021-04-15 11:52:51.001910', NULL),
	(10001912, 10000002, 'PW21A-GL100059BL-S', 100059, 'HITMAN', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001911', '2021-04-15 11:52:51.001911', NULL),
	(10001913, 10000002, 'PW21A-GL100059BL-M', 100059, 'HITMAN', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001912', '2021-04-15 11:52:51.001912', NULL),
	(10001914, 10000002, 'PW21A-GL100059BL-L', 100059, 'HITMAN', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001913', '2021-04-15 11:52:51.001913', NULL),
	(10001915, 10000002, 'PW21A-GL100059BL-XL', 100059, 'HITMAN', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001914', '2021-04-15 11:52:51.001914', NULL),
	(10001916, 10000002, 'PW21A-GL100060BL-S', 100060, 'DARE DEVIL', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001915', '2021-04-15 11:52:51.001915', NULL),
	(10001917, 10000002, 'PW21A-GL100060BL-M', 100060, 'DARE DEVIL', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001916', '2021-04-15 11:52:51.001916', NULL),
	(10001918, 10000002, 'PW21A-GL100060BL-L', 100060, 'DARE DEVIL', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001917', '2021-04-15 11:52:51.001917', NULL),
	(10001919, 10000002, 'PW21A-GL100060BL-XL', 100060, 'DARE DEVIL', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001918', '2021-04-15 11:52:51.001918', NULL),
	(10001920, 10000002, 'PW21A-GL100061RD-S', 100061, 'DARK INFERNO', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001919', '2021-04-15 11:52:51.001919', NULL),
	(10001921, 10000002, 'PW21A-GL100061RD-M', 100061, 'DARK INFERNO', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001920', '2021-04-15 11:52:51.001920', NULL),
	(10001922, 10000002, 'PW21A-GL100061RD-L', 100061, 'DARK INFERNO', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001921', '2021-04-15 11:52:51.001921', NULL),
	(10001923, 10000002, 'PW21A-GL100061RD-XL', 100061, 'DARK INFERNO', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001922', '2021-04-15 11:52:51.001922', NULL),
	(10001924, 10000002, 'PW21A-GL100062WT-S', 100062, 'HURRICANE', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001923', '2021-04-15 11:52:51.001923', NULL),
	(10001925, 10000002, 'PW21A-GL100062WT-M', 100062, 'HURRICANE', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001924', '2021-04-15 11:52:51.001924', NULL),
	(10001926, 10000002, 'PW21A-GL100062WT-L', 100062, 'HURRICANE', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001925', '2021-04-15 11:52:51.001925', NULL),
	(10001927, 10000002, 'PW21A-GL100062WT-XL', 100062, 'HURRICANE', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001926', '2021-04-15 11:52:51.001926', NULL),
	(10001928, 10000002, 'PW21A-GL100063BW-S', 100063, 'CRUSADER', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001927', '2021-04-15 11:52:51.001927', NULL),
	(10001929, 10000002, 'PW21A-GL100063BW-M', 100063, 'CRUSADER', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001928', '2021-04-15 11:52:51.001928', NULL),
	(10001930, 10000002, 'PW21A-GL100063BW-L', 100063, 'CRUSADER', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001929', '2021-04-15 11:52:51.001929', NULL),
	(10001931, 10000002, 'PW21A-GL100063BW-XL', 100063, 'CRUSADER', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001930', '2021-04-15 11:52:51.001930', NULL),
	(10001932, 10000002, 'PW21A-GL100064WT-S', 100064, 'MARK I', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001931', '2021-04-15 11:52:51.001931', NULL),
	(10001933, 10000002, 'PW21A-GL100064WT-M', 100064, 'MARK I', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001932', '2021-04-15 11:52:51.001932', NULL),
	(10001934, 10000002, 'PW21A-GL100064WT-L', 100064, 'MARK I', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001933', '2021-04-15 11:52:51.001933', NULL),
	(10001935, 10000002, 'PW21A-GL100064WT-XL', 100064, 'MARK I', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001934', '2021-04-15 11:52:51.001934', NULL),
	(10001936, 10000002, 'PW21A-GL100065BL-S', 100065, 'MARK II', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001935', '2021-04-15 11:52:51.001935', NULL),
	(10001937, 10000002, 'PW21A-GL100065BL-M', 100065, 'MARK II', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001936', '2021-04-15 11:52:51.001936', NULL),
	(10001938, 10000002, 'PW21A-GL100065BL-L', 100065, 'MARK II', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001937', '2021-04-15 11:52:51.001937', NULL),
	(10001939, 10000002, 'PW21A-GL100065BL-XL', 100065, 'MARK II', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001938', '2021-04-15 11:52:51.001938', NULL),
	(10001940, 10000002, 'PW21A-GL100066YW -S', 100066, 'DAYTONA', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001939', '2021-04-15 11:52:51.001939', NULL),
	(10001941, 10000002, 'PW21A-GL100066YW -M', 100066, 'DAYTONA', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001940', '2021-04-15 11:52:51.001940', NULL),
	(10001942, 10000002, 'PW21A-GL100066YW -L', 100066, 'DAYTONA', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001941', '2021-04-15 11:52:51.001941', NULL),
	(10001943, 10000002, 'PW21A-GL100066YW -XL', 100066, 'DAYTONA', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001942', '2021-04-15 11:52:51.001942', NULL),
	(10001944, 10000002, 'PW21A-GL100067BW-S', 100067, 'DOMINATOR', 5, 'Gloves', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001943', '2021-04-15 11:52:51.001943', NULL),
	(10001945, 10000002, 'PW21A-GL100067BW-M', 100067, 'DOMINATOR', 5, 'Gloves', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001944', '2021-04-15 11:52:51.001944', NULL),
	(10001946, 10000002, 'PW21A-GL100067BW-L', 100067, 'DOMINATOR', 5, 'Gloves', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001945', '2021-04-15 11:52:51.001945', NULL),
	(10001947, 10000002, 'PW21A-GL100067BW-XL', 100067, 'DOMINATOR', 5, 'Gloves', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001946', '2021-04-15 11:52:51.001946', NULL),
	(10001948, 10000002, 'PW21A-HT100068BL-All', 100068, 'BLACK COBRA TRUCKER', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001947', '2021-04-15 11:52:51.001947', NULL),
	(10001949, 10000002, 'PW21A-HT100069BL-All', 100069, 'SIGNATURE TRUCKER', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001948', '2021-04-15 11:52:51.001948', NULL),
	(10001950, 10000002, 'PW21A-HT100070BL-All', 100070, 'EAGLE SNAKE TRUCKER', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001949', '2021-04-15 11:52:51.001949', NULL),
	(10001951, 10000002, 'PW21A-HT100071BL-All', 100071, 'IRON BEAST', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001950', '2021-04-15 11:52:51.001950', NULL),
	(10001952, 10000002, 'PW21A-HT100072BL-All', 100072, 'PARTS AND BUILD 2.0', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001951', '2021-04-15 11:52:51.001951', NULL),
	(10001953, 10000002, 'PW21A-HT100073BL-All', 100073, 'GARAGE TRUCKER', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001952', '2021-04-15 11:52:51.001952', NULL),
	(10001954, 10000002, 'PW21A-HT100074BL-All', 100074, 'PIRATE TRUCKER', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001953', '2021-04-15 11:52:51.001953', NULL),
	(10001955, 10000002, 'PW21A-HT100075BL-All', 100075, 'TROOPER TRUCKER', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001954', '2021-04-15 11:52:51.001954', NULL),
	(10001956, 10000002, 'PW21A-HT100076BL-All', 100076, 'WING TRUCKER 2.0', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001955', '2021-04-15 11:52:51.001955', NULL),
	(10001957, 10000002, 'PW21A-HT100077BL-All', 100077, 'EQUADOR', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001956', '2021-04-15 11:52:51.001956', NULL),
	(10001958, 10000002, 'PW21A-HT100078BL-All', 100078, 'SHALLOW CAP', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001957', '2021-04-15 11:52:51.001957', NULL),
	(10001959, 10000002, 'PW21A-HT100079AR-All', 100079, 'DELTA CAP ARMY', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001958', '2021-04-15 11:52:51.001958', NULL),
	(10001960, 10000002, 'PW21A-HT100080BL-All', 100080, 'DELTA CAP BLACK', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001959', '2021-04-15 11:52:51.001959', NULL),
	(10001961, 10000002, 'PW21A-HT100081CM-All', 100081, 'DELTA CAP ARMY CAMO', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001960', '2021-04-15 11:52:51.001960', NULL),
	(10001962, 10000002, 'PW21A-HT100082DS-All', 100082, 'DELTA CAP ARMY DESERT', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.001961', '2021-04-15 11:52:51.001961', NULL),
	(10001963, 10000002, 'PW21A-HT100083CM-All', 100083, 'EQUADOR CAMO', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001962', '2021-04-15 11:52:51.001962', NULL),
	(10001964, 10000002, 'PW21A-HT100084DS-All', 100084, 'EQUADOR DESERT', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001963', '2021-04-15 11:52:51.001963', NULL),
	(10001965, 10000002, 'PW21A-HT100085MR-All', 100085, 'SHALLOW MAROON', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001964', '2021-04-15 11:52:51.001964', NULL),
	(10001966, 10000002, 'PW21A-HT100086NV-All', 100086, 'SHALLOW NAVY', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001965', '2021-04-15 11:52:51.001965', NULL),
	(10001967, 10000002, 'PW21A-HT100087BL-All', 100087, 'SIGNATURE TRUCKER 2.0', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001966', '2021-04-15 11:52:51.001966', NULL),
	(10001968, 10000002, 'PW21A-HT100088NV-All', 100088, 'HIGHWAY CAP NAVY', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001967', '2021-04-15 11:52:51.001967', NULL),
	(10001969, 10000002, 'PW21A-HT100089RD-All', 100089, 'HIGHWAY CAP RED', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001968', '2021-04-15 11:52:51.001968', NULL),
	(10001970, 10000002, 'PW21A-HT100090BL-All', 100090, 'PETROL TRUCKER BLACK', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001969', '2021-04-15 11:52:51.001969', NULL),
	(10001971, 10000002, 'PW21A-HT100091RD-All', 100091, 'PETROL TRUCKER RED', 6, 'Hat', 1, 'Phillip Works ', 10000012, 'All', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001970', '2021-04-15 11:52:51.001970', NULL),
	(10001972, 10000002, 'PW21A-JK100092BL-XS', 100092, 'BLACK VIPER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001971', '2021-04-15 11:52:51.001971', NULL),
	(10001973, 10000002, 'PW21A-JK100092BL-S', 100092, 'BLACK VIPER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001972', '2021-04-15 11:52:51.001972', NULL),
	(10001974, 10000002, 'PW21A-JK100092BL-M', 100092, 'BLACK VIPER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001973', '2021-04-15 11:52:51.001973', NULL),
	(10001975, 10000002, 'PW21A-JK100092BL-L', 100092, 'BLACK VIPER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.001974', '2021-04-15 11:52:51.001974', NULL),
	(10001976, 10000002, 'PW21A-JK100092BL-XL', 100092, 'BLACK VIPER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.001975', '2021-04-15 11:52:51.001975', NULL),
	(10001977, 10000002, 'PW21A-JK100092BL-XXL', 100092, 'BLACK VIPER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.001976', '2021-04-15 11:52:51.001976', NULL),
	(10001978, 10000002, 'PW21A-JK100093BL-XS', 100093, 'BLACK FALCON', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001977', '2021-04-15 11:52:51.001977', NULL),
	(10001979, 10000002, 'PW21A-JK100093BL-S', 100093, 'BLACK FALCON', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001978', '2021-04-15 11:52:51.001978', NULL),
	(10001980, 10000002, 'PW21A-JK100093BL-M', 100093, 'BLACK FALCON', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001979', '2021-04-15 11:52:51.001979', NULL),
	(10001981, 10000002, 'PW21A-JK100093BL-L', 100093, 'BLACK FALCON', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001980', '2021-04-15 11:52:51.001980', NULL),
	(10001982, 10000002, 'PW21A-JK100093BL-XL', 100093, 'BLACK FALCON', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001981', '2021-04-15 11:52:51.001981', NULL),
	(10001983, 10000002, 'PW21A-JK100093BL-XXL', 100093, 'BLACK FALCON', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001982', '2021-04-15 11:52:51.001982', NULL),
	(10001984, 10000002, 'PW21A-JK100094GY-XS', 100094, 'THE BRAVE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001983', '2021-04-15 11:52:51.001983', NULL),
	(10001985, 10000002, 'PW21A-JK100094GY-S', 100094, 'THE BRAVE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001984', '2021-04-15 11:52:51.001984', NULL),
	(10001986, 10000002, 'PW21A-JK100094GY-M', 100094, 'THE BRAVE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001985', '2021-04-15 11:52:51.001985', NULL),
	(10001987, 10000002, 'PW21A-JK100094GY-L', 100094, 'THE BRAVE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001986', '2021-04-15 11:52:51.001986', NULL),
	(10001988, 10000002, 'PW21A-JK100094GY-XL', 100094, 'THE BRAVE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001987', '2021-04-15 11:52:51.001987', NULL),
	(10001989, 10000002, 'PW21A-JK100094GY-XXL', 100094, 'THE BRAVE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001988', '2021-04-15 11:52:51.001988', NULL),
	(10001990, 10000002, 'PW21A-JK100095AR-XS', 100095, 'NEVER LOST', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001989', '2021-04-15 11:52:51.001989', NULL),
	(10001991, 10000002, 'PW21A-JK100095AR-S', 100095, 'NEVER LOST', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001990', '2021-04-15 11:52:51.001990', NULL),
	(10001992, 10000002, 'PW21A-JK100095AR-M', 100095, 'NEVER LOST', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001991', '2021-04-15 11:52:51.001991', NULL),
	(10001993, 10000002, 'PW21A-JK100095AR-L', 100095, 'NEVER LOST', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001992', '2021-04-15 11:52:51.001992', NULL),
	(10001994, 10000002, 'PW21A-JK100095AR-XL', 100095, 'NEVER LOST', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001993', '2021-04-15 11:52:51.001993', NULL),
	(10001995, 10000002, 'PW21A-JK100095AR-XXL', 100095, 'NEVER LOST', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001994', '2021-04-15 11:52:51.001994', NULL),
	(10001996, 10000002, 'PW21A-JK100096BL-XS', 100096, 'UNRIVALED', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001995', '2021-04-15 11:52:51.001995', NULL),
	(10001997, 10000002, 'PW21A-JK100096BL-S', 100096, 'UNRIVALED', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001996', '2021-04-15 11:52:51.001996', NULL),
	(10001998, 10000002, 'PW21A-JK100096BL-M', 100096, 'UNRIVALED', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001997', '2021-04-15 11:52:51.001997', NULL),
	(10001999, 10000002, 'PW21A-JK100096BL-L', 100096, 'UNRIVALED', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001998', '2021-04-15 11:52:51.001998', NULL),
	(10002000, 10000002, 'PW21A-JK100096BL-XL', 100096, 'UNRIVALED', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.001999', '2021-04-15 11:52:51.001999', NULL),
	(10002001, 10000002, 'PW21A-JK100096BL-XXL', 100096, 'UNRIVALED', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002000', '2021-04-15 11:52:51.002000', NULL),
	(10002002, 10000002, 'PW21A-JK100097WT-XS', 100097, 'PRIDE OF INDONESIA', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002001', '2021-04-15 11:52:51.002001', NULL),
	(10002003, 10000002, 'PW21A-JK100097WT-S', 100097, 'PRIDE OF INDONESIA', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002002', '2021-04-15 11:52:51.002002', NULL),
	(10002004, 10000002, 'PW21A-JK100097WT-M', 100097, 'PRIDE OF INDONESIA', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002003', '2021-04-15 11:52:51.002003', NULL),
	(10002005, 10000002, 'PW21A-JK100097WT-L', 100097, 'PRIDE OF INDONESIA', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.002004', '2021-04-15 11:52:51.002004', NULL),
	(10002006, 10000002, 'PW21A-JK100097WT-XL', 100097, 'PRIDE OF INDONESIA', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.002005', '2021-04-15 11:52:51.002005', NULL),
	(10002007, 10000002, 'PW21A-JK100097WT-XXL', 100097, 'PRIDE OF INDONESIA', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002006', '2021-04-15 11:52:51.002006', NULL),
	(10002008, 10000002, 'PW21A-JK100098BL-XS', 100098, 'CHRYSANT DEMON WINDBREAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002007', '2021-04-15 11:52:51.002007', NULL),
	(10002009, 10000002, 'PW21A-JK100098BL-S', 100098, 'CHRYSANT DEMON WINDBREAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002008', '2021-04-15 11:52:51.002008', NULL),
	(10002010, 10000002, 'PW21A-JK100098BL-M', 100098, 'CHRYSANT DEMON WINDBREAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002009', '2021-04-15 11:52:51.002009', NULL),
	(10002011, 10000002, 'PW21A-JK100098BL-L', 100098, 'CHRYSANT DEMON WINDBREAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002010', '2021-04-15 11:52:51.002010', NULL),
	(10002012, 10000002, 'PW21A-JK100098BL-XL', 100098, 'CHRYSANT DEMON WINDBREAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002011', '2021-04-15 11:52:51.002011', NULL),
	(10002013, 10000002, 'PW21A-JK100098BL-XXL', 100098, 'CHRYSANT DEMON WINDBREAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002012', '2021-04-15 11:52:51.002012', NULL),
	(10002014, 10000002, 'PW21A-JK100099BL-XS', 100099, 'BLACK EAGLE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002013', '2021-04-15 11:52:51.002013', NULL),
	(10002015, 10000002, 'PW21A-JK100099BL-S', 100099, 'BLACK EAGLE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002014', '2021-04-15 11:52:51.002014', NULL),
	(10002016, 10000002, 'PW21A-JK100099BL-M', 100099, 'BLACK EAGLE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002015', '2021-04-15 11:52:51.002015', NULL),
	(10002017, 10000002, 'PW21A-JK100099BL-L', 100099, 'BLACK EAGLE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002016', '2021-04-15 11:52:51.002016', NULL),
	(10002018, 10000002, 'PW21A-JK100099BL-XL', 100099, 'BLACK EAGLE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002017', '2021-04-15 11:52:51.002017', NULL),
	(10002019, 10000002, 'PW21A-JK100099BL-XXL', 100099, 'BLACK EAGLE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002018', '2021-04-15 11:52:51.002018', NULL),
	(10002020, 10000002, 'PW21A-JK100100DM-XS', 100100, 'LIBERATOR DENIM', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002019', '2021-04-15 11:52:51.002019', NULL),
	(10002021, 10000002, 'PW21A-JK100100DM-S', 100100, 'LIBERATOR DENIM', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002020', '2021-04-15 11:52:51.002020', NULL),
	(10002022, 10000002, 'PW21A-JK100100DM-M', 100100, 'LIBERATOR DENIM', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002021', '2021-04-15 11:52:51.002021', NULL),
	(10002023, 10000002, 'PW21A-JK100100DM-L', 100100, 'LIBERATOR DENIM', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002022', '2021-04-15 11:52:51.002022', NULL),
	(10002024, 10000002, 'PW21A-JK100100DM-XL', 100100, 'LIBERATOR DENIM', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002023', '2021-04-15 11:52:51.002023', NULL),
	(10002025, 10000002, 'PW21A-JK100100DM-XXL', 100100, 'LIBERATOR DENIM', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002024', '2021-04-15 11:52:51.002024', NULL),
	(10002026, 10000002, 'PW21A-JK100101NV-XS', 100101, 'INTERCEPTOR RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002025', '2021-04-15 11:52:51.002025', NULL),
	(10002027, 10000002, 'PW21A-JK100101NV-S', 100101, 'INTERCEPTOR RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002026', '2021-04-15 11:52:51.002026', NULL),
	(10002028, 10000002, 'PW21A-JK100101NV-M', 100101, 'INTERCEPTOR RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002027', '2021-04-15 11:52:51.002027', NULL),
	(10002029, 10000002, 'PW21A-JK100101NV-L', 100101, 'INTERCEPTOR RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002028', '2021-04-15 11:52:51.002028', NULL),
	(10002030, 10000002, 'PW21A-JK100101NV-XL', 100101, 'INTERCEPTOR RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002029', '2021-04-15 11:52:51.002029', NULL),
	(10002031, 10000002, 'PW21A-JK100101NV-XXL', 100101, 'INTERCEPTOR RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002030', '2021-04-15 11:52:51.002030', NULL),
	(10002032, 10000002, 'PW21A-JK100102BW-XS', 100102, 'BRADFORD JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002031', '2021-04-15 11:52:51.002031', NULL),
	(10002033, 10000002, 'PW21A-JK100102BW-S', 100102, 'BRADFORD JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002032', '2021-04-15 11:52:51.002032', NULL),
	(10002034, 10000002, 'PW21A-JK100102BW-M', 100102, 'BRADFORD JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002033', '2021-04-15 11:52:51.002033', NULL),
	(10002035, 10000002, 'PW21A-JK100102BW-L', 100102, 'BRADFORD JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002034', '2021-04-15 11:52:51.002034', NULL),
	(10002036, 10000002, 'PW21A-JK100102BW-XL', 100102, 'BRADFORD JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002035', '2021-04-15 11:52:51.002035', NULL),
	(10002037, 10000002, 'PW21A-JK100102BW-XXL', 100102, 'BRADFORD JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002036', '2021-04-15 11:52:51.002036', NULL),
	(10002038, 10000002, 'PW21A-JK100103BL-XS', 100103, 'RIDE OR DIE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002037', '2021-04-15 11:52:51.002037', NULL),
	(10002039, 10000002, 'PW21A-JK100103BL-S', 100103, 'RIDE OR DIE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002038', '2021-04-15 11:52:51.002038', NULL),
	(10002040, 10000002, 'PW21A-JK100103BL-M', 100103, 'RIDE OR DIE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002039', '2021-04-15 11:52:51.002039', NULL),
	(10002041, 10000002, 'PW21A-JK100103BL-L', 100103, 'RIDE OR DIE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002040', '2021-04-15 11:52:51.002040', NULL),
	(10002042, 10000002, 'PW21A-JK100103BL-XL', 100103, 'RIDE OR DIE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002041', '2021-04-15 11:52:51.002041', NULL),
	(10002043, 10000002, 'PW21A-JK100103BL-XXL', 100103, 'RIDE OR DIE 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002042', '2021-04-15 11:52:51.002042', NULL),
	(10002044, 10000002, 'PW21A-JK100104BL-XS', 100104, 'MC CARTHY PARKA 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002043', '2021-04-15 11:52:51.002043', NULL),
	(10002045, 10000002, 'PW21A-JK100104BL-S', 100104, 'MC CARTHY PARKA 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002044', '2021-04-15 11:52:51.002044', NULL),
	(10002046, 10000002, 'PW21A-JK100104BL-M', 100104, 'MC CARTHY PARKA 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002045', '2021-04-15 11:52:51.002045', NULL),
	(10002047, 10000002, 'PW21A-JK100104BL-L', 100104, 'MC CARTHY PARKA 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002046', '2021-04-15 11:52:51.002046', NULL),
	(10002048, 10000002, 'PW21A-JK100104BL-XL', 100104, 'MC CARTHY PARKA 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002047', '2021-04-15 11:52:51.002047', NULL),
	(10002049, 10000002, 'PW21A-JK100104BL-XXL', 100104, 'MC CARTHY PARKA 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002048', '2021-04-15 11:52:51.002048', NULL),
	(10002050, 10000002, 'PW21A-JK100105TC-XS', 100105, 'NIPPON 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002049', '2021-04-15 11:52:51.002049', NULL),
	(10002051, 10000002, 'PW21A-JK100105TC-S', 100105, 'NIPPON 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002050', '2021-04-15 11:52:51.002050', NULL),
	(10002052, 10000002, 'PW21A-JK100105TC-M', 100105, 'NIPPON 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002051', '2021-04-15 11:52:51.002051', NULL),
	(10002053, 10000002, 'PW21A-JK100105TC-L', 100105, 'NIPPON 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002052', '2021-04-15 11:52:51.002052', NULL),
	(10002054, 10000002, 'PW21A-JK100105TC-XL', 100105, 'NIPPON 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002053', '2021-04-15 11:52:51.002053', NULL),
	(10002055, 10000002, 'PW21A-JK100105TC-XXL', 100105, 'NIPPON 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002054', '2021-04-15 11:52:51.002054', NULL),
	(10002056, 10000002, 'PW21A-JK100106BL-XS', 100106, 'ROAD HUNTER WINDBREAKER 3', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002055', '2021-04-15 11:52:51.002055', NULL),
	(10002057, 10000002, 'PW21A-JK100106BL-S', 100106, 'ROAD HUNTER WINDBREAKER 3', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002056', '2021-04-15 11:52:51.002056', NULL),
	(10002058, 10000002, 'PW21A-JK100106BL-M', 100106, 'ROAD HUNTER WINDBREAKER 3', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002057', '2021-04-15 11:52:51.002057', NULL),
	(10002059, 10000002, 'PW21A-JK100106BL-L', 100106, 'ROAD HUNTER WINDBREAKER 3', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002058', '2021-04-15 11:52:51.002058', NULL),
	(10002060, 10000002, 'PW21A-JK100106BL-XL', 100106, 'ROAD HUNTER WINDBREAKER 3', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002059', '2021-04-15 11:52:51.002059', NULL),
	(10002061, 10000002, 'PW21A-JK100106BL-XXL', 100106, 'ROAD HUNTER WINDBREAKER 3', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002060', '2021-04-15 11:52:51.002060', NULL),
	(10002062, 10000002, 'PW21A-JK100107BL-XS', 100107, 'PW MC WINDBEAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002061', '2021-04-15 11:52:51.002061', NULL),
	(10002063, 10000002, 'PW21A-JK100107BL-S', 100107, 'PW MC WINDBEAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002062', '2021-04-15 11:52:51.002062', NULL),
	(10002064, 10000002, 'PW21A-JK100107BL-M', 100107, 'PW MC WINDBEAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002063', '2021-04-15 11:52:51.002063', NULL),
	(10002065, 10000002, 'PW21A-JK100107BL-L', 100107, 'PW MC WINDBEAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002064', '2021-04-15 11:52:51.002064', NULL),
	(10002066, 10000002, 'PW21A-JK100107BL-XL', 100107, 'PW MC WINDBEAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002065', '2021-04-15 11:52:51.002065', NULL),
	(10002067, 10000002, 'PW21A-JK100107BL-XXL', 100107, 'PW MC WINDBEAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002066', '2021-04-15 11:52:51.002066', NULL),
	(10002068, 10000002, 'PW21A-JK100108BL-XS', 100108, 'BORN TO RIDE 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002067', '2021-04-15 11:52:51.002067', NULL),
	(10002069, 10000002, 'PW21A-JK100108BL-S', 100108, 'BORN TO RIDE 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002068', '2021-04-15 11:52:51.002068', NULL),
	(10002070, 10000002, 'PW21A-JK100108BL-M', 100108, 'BORN TO RIDE 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002069', '2021-04-15 11:52:51.002069', NULL),
	(10002071, 10000002, 'PW21A-JK100108BL-L', 100108, 'BORN TO RIDE 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002070', '2021-04-15 11:52:51.002070', NULL),
	(10002072, 10000002, 'PW21A-JK100108BL-XL', 100108, 'BORN TO RIDE 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002071', '2021-04-15 11:52:51.002071', NULL),
	(10002073, 10000002, 'PW21A-JK100108BL-XXL', 100108, 'BORN TO RIDE 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002072', '2021-04-15 11:52:51.002072', NULL),
	(10002074, 10000002, 'PW21A-JK100109BL-XS', 100109, 'HERITAGE WINDBREAKER 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002073', '2021-04-15 11:52:51.002073', NULL),
	(10002075, 10000002, 'PW21A-JK100109BL-S', 100109, 'HERITAGE WINDBREAKER 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002074', '2021-04-15 11:52:51.002074', NULL),
	(10002076, 10000002, 'PW21A-JK100109BL-M', 100109, 'HERITAGE WINDBREAKER 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002075', '2021-04-15 11:52:51.002075', NULL),
	(10002077, 10000002, 'PW21A-JK100109BL-L', 100109, 'HERITAGE WINDBREAKER 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002076', '2021-04-15 11:52:51.002076', NULL),
	(10002078, 10000002, 'PW21A-JK100109BL-XL', 100109, 'HERITAGE WINDBREAKER 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002077', '2021-04-15 11:52:51.002077', NULL),
	(10002079, 10000002, 'PW21A-JK100109BL-XXL', 100109, 'HERITAGE WINDBREAKER 3.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002078', '2021-04-15 11:52:51.002078', NULL),
	(10002080, 10000002, 'PW21A-JK100110BL-XS', 100110, 'VARSITY HIGH SCHOOL', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002079', '2021-04-15 11:52:51.002079', NULL),
	(10002081, 10000002, 'PW21A-JK100110BL-S', 100110, 'VARSITY HIGH SCHOOL', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002080', '2021-04-15 11:52:51.002080', NULL),
	(10002082, 10000002, 'PW21A-JK100110BL-M', 100110, 'VARSITY HIGH SCHOOL', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002081', '2021-04-15 11:52:51.002081', NULL),
	(10002083, 10000002, 'PW21A-JK100110BL-L', 100110, 'VARSITY HIGH SCHOOL', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002082', '2021-04-15 11:52:51.002082', NULL),
	(10002084, 10000002, 'PW21A-JK100110BL-XL', 100110, 'VARSITY HIGH SCHOOL', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.002083', '2021-04-15 11:52:51.002083', NULL),
	(10002085, 10000002, 'PW21A-JK100110BL-XXL', 100110, 'VARSITY HIGH SCHOOL', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002084', '2021-04-15 11:52:51.002084', NULL),
	(10002086, 10000002, 'PW21A-JK100111BL-XS', 100111, 'VARSITY COLLEGE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002085', '2021-04-15 11:52:51.002085', NULL),
	(10002087, 10000002, 'PW21A-JK100111BL-S', 100111, 'VARSITY COLLEGE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002086', '2021-04-15 11:52:51.002086', NULL),
	(10002088, 10000002, 'PW21A-JK100111BL-M', 100111, 'VARSITY COLLEGE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002087', '2021-04-15 11:52:51.002087', NULL),
	(10002089, 10000002, 'PW21A-JK100111BL-L', 100111, 'VARSITY COLLEGE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002088', '2021-04-15 11:52:51.002088', NULL),
	(10002090, 10000002, 'PW21A-JK100111BL-XL', 100111, 'VARSITY COLLEGE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002089', '2021-04-15 11:52:51.002089', NULL),
	(10002091, 10000002, 'PW21A-JK100111BL-XXL', 100111, 'VARSITY COLLEGE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002090', '2021-04-15 11:52:51.002090', NULL),
	(10002092, 10000002, 'PW21A-JK100112CM-XS', 100112, 'JUNGLE AERO', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002091', '2021-04-15 11:52:51.002091', NULL),
	(10002093, 10000002, 'PW21A-JK100112CM-S', 100112, 'JUNGLE AERO', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002092', '2021-04-15 11:52:51.002092', NULL),
	(10002094, 10000002, 'PW21A-JK100112CM-M', 100112, 'JUNGLE AERO', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002093', '2021-04-15 11:52:51.002093', NULL),
	(10002095, 10000002, 'PW21A-JK100112CM-L', 100112, 'JUNGLE AERO', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002094', '2021-04-15 11:52:51.002094', NULL),
	(10002096, 10000002, 'PW21A-JK100112CM-XL', 100112, 'JUNGLE AERO', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002095', '2021-04-15 11:52:51.002095', NULL),
	(10002097, 10000002, 'PW21A-JK100112CM-XXL', 100112, 'JUNGLE AERO', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002096', '2021-04-15 11:52:51.002096', NULL),
	(10002098, 10000002, 'PW21A-JK100113CM-XS', 100113, 'JUNGLE SPEED', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002097', '2021-04-15 11:52:51.002097', NULL),
	(10002099, 10000002, 'PW21A-JK100113CM-S', 100113, 'JUNGLE SPEED', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002098', '2021-04-15 11:52:51.002098', NULL),
	(10002100, 10000002, 'PW21A-JK100113CM-M', 100113, 'JUNGLE SPEED', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002099', '2021-04-15 11:52:51.002099', NULL),
	(10002101, 10000002, 'PW21A-JK100113CM-L', 100113, 'JUNGLE SPEED', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002100', '2021-04-15 11:52:51.002100', NULL),
	(10002102, 10000002, 'PW21A-JK100113CM-XL', 100113, 'JUNGLE SPEED', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002101', '2021-04-15 11:52:51.002101', NULL),
	(10002103, 10000002, 'PW21A-JK100113CM-XXL', 100113, 'JUNGLE SPEED', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002102', '2021-04-15 11:52:51.002102', NULL),
	(10002104, 10000002, 'PW21A-JK100114CM-XS', 100114, 'BLACK FALCON 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002103', '2021-04-15 11:52:51.002103', NULL),
	(10002105, 10000002, 'PW21A-JK100114CM-S', 100114, 'BLACK FALCON 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002104', '2021-04-15 11:52:51.002104', NULL),
	(10002106, 10000002, 'PW21A-JK100114CM-M', 100114, 'BLACK FALCON 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002105', '2021-04-15 11:52:51.002105', NULL),
	(10002107, 10000002, 'PW21A-JK100114CM-L', 100114, 'BLACK FALCON 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002106', '2021-04-15 11:52:51.002106', NULL),
	(10002108, 10000002, 'PW21A-JK100114CM-XL', 100114, 'BLACK FALCON 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002107', '2021-04-15 11:52:51.002107', NULL),
	(10002109, 10000002, 'PW21A-JK100114CM-XXL', 100114, 'BLACK FALCON 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002108', '2021-04-15 11:52:51.002108', NULL),
	(10002110, 10000002, 'PW21A-JK100115DM-XS', 100115, 'BELFAST 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002109', '2021-04-15 11:52:51.002109', NULL),
	(10002111, 10000002, 'PW21A-JK100115DM-S', 100115, 'BELFAST 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002110', '2021-04-15 11:52:51.002110', NULL),
	(10002112, 10000002, 'PW21A-JK100115DM-M', 100115, 'BELFAST 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002111', '2021-04-15 11:52:51.002111', NULL),
	(10002113, 10000002, 'PW21A-JK100115DM-L', 100115, 'BELFAST 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002112', '2021-04-15 11:52:51.002112', NULL),
	(10002114, 10000002, 'PW21A-JK100115DM-XL', 100115, 'BELFAST 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002113', '2021-04-15 11:52:51.002113', NULL),
	(10002115, 10000002, 'PW21A-JK100115DM-XXL', 100115, 'BELFAST 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002114', '2021-04-15 11:52:51.002114', NULL),
	(10002116, 10000002, 'PW21A-JK100116RD-XS', 100116, 'MOTEGI', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002115', '2021-04-15 11:52:51.002115', NULL),
	(10002117, 10000002, 'PW21A-JK100116RD-S', 100116, 'MOTEGI', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002116', '2021-04-15 11:52:51.002116', NULL),
	(10002118, 10000002, 'PW21A-JK100116RD-M', 100116, 'MOTEGI', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002117', '2021-04-15 11:52:51.002117', NULL),
	(10002119, 10000002, 'PW21A-JK100116RD-L', 100116, 'MOTEGI', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002118', '2021-04-15 11:52:51.002118', NULL),
	(10002120, 10000002, 'PW21A-JK100116RD-XL', 100116, 'MOTEGI', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002119', '2021-04-15 11:52:51.002119', NULL),
	(10002121, 10000002, 'PW21A-JK100116RD-XXL', 100116, 'MOTEGI', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002120', '2021-04-15 11:52:51.002120', NULL),
	(10002122, 10000002, 'PW21A-JK100117BL-XS', 100117, 'MAVERICK BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002121', '2021-04-15 11:52:51.002121', NULL),
	(10002123, 10000002, 'PW21A-JK100117BL-S', 100117, 'MAVERICK BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002122', '2021-04-15 11:52:51.002122', NULL),
	(10002124, 10000002, 'PW21A-JK100117BL-M', 100117, 'MAVERICK BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002123', '2021-04-15 11:52:51.002123', NULL),
	(10002125, 10000002, 'PW21A-JK100117BL-L', 100117, 'MAVERICK BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002124', '2021-04-15 11:52:51.002124', NULL),
	(10002126, 10000002, 'PW21A-JK100117BL-XL', 100117, 'MAVERICK BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002125', '2021-04-15 11:52:51.002125', NULL),
	(10002127, 10000002, 'PW21A-JK100117BL-XXL', 100117, 'MAVERICK BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002126', '2021-04-15 11:52:51.002126', NULL),
	(10002128, 10000002, 'PW21A-JK100118AR-XS', 100118, 'SHERMAN BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002127', '2021-04-15 11:52:51.002127', NULL),
	(10002129, 10000002, 'PW21A-JK100118AR-S', 100118, 'SHERMAN BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002128', '2021-04-15 11:52:51.002128', NULL),
	(10002130, 10000002, 'PW21A-JK100118AR-M', 100118, 'SHERMAN BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002129', '2021-04-15 11:52:51.002129', NULL),
	(10002131, 10000002, 'PW21A-JK100118AR-L', 100118, 'SHERMAN BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002130', '2021-04-15 11:52:51.002130', NULL),
	(10002132, 10000002, 'PW21A-JK100118AR-XL', 100118, 'SHERMAN BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002131', '2021-04-15 11:52:51.002131', NULL),
	(10002133, 10000002, 'PW21A-JK100118AR-XXL', 100118, 'SHERMAN BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002132', '2021-04-15 11:52:51.002132', NULL),
	(10002134, 10000002, 'PW21A-JK100119BL-XS', 100119, 'CONTINENTAL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002133', '2021-04-15 11:52:51.002133', NULL),
	(10002135, 10000002, 'PW21A-JK100119BL-S', 100119, 'CONTINENTAL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002134', '2021-04-15 11:52:51.002134', NULL),
	(10002136, 10000002, 'PW21A-JK100119BL-M', 100119, 'CONTINENTAL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002135', '2021-04-15 11:52:51.002135', NULL),
	(10002137, 10000002, 'PW21A-JK100119BL-L', 100119, 'CONTINENTAL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002136', '2021-04-15 11:52:51.002136', NULL),
	(10002138, 10000002, 'PW21A-JK100119BL-XL', 100119, 'CONTINENTAL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002137', '2021-04-15 11:52:51.002137', NULL),
	(10002139, 10000002, 'PW21A-JK100119BL-XXL', 100119, 'CONTINENTAL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002138', '2021-04-15 11:52:51.002138', NULL),
	(10002140, 10000002, 'PW21A-JK100120BL-XS', 100120, 'VELOCITY', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002139', '2021-04-15 11:52:51.002139', NULL),
	(10002141, 10000002, 'PW21A-JK100120BL-S', 100120, 'VELOCITY', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.002140', '2021-04-15 11:52:51.002140', NULL),
	(10002142, 10000002, 'PW21A-JK100120BL-M', 100120, 'VELOCITY', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 6, 1, 'Piece', '2021-04-15 11:52:51.002141', '2021-04-15 11:52:51.002141', NULL),
	(10002143, 10000002, 'PW21A-JK100120BL-L', 100120, 'VELOCITY', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 8, 1, 'Piece', '2021-04-15 11:52:51.002142', '2021-04-15 11:52:51.002142', NULL),
	(10002144, 10000002, 'PW21A-JK100120BL-XL', 100120, 'VELOCITY', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 5, 1, 'Piece', '2021-04-15 11:52:51.002143', '2021-04-15 11:52:51.002143', NULL),
	(10002145, 10000002, 'PW21A-JK100120BL-XXL', 100120, 'VELOCITY', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002144', '2021-04-15 11:52:51.002144', NULL),
	(10002146, 10000002, 'PW21A-JK100121MR-XS', 100121, 'GO RIDE WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002145', '2021-04-15 11:52:51.002145', NULL),
	(10002147, 10000002, 'PW21A-JK100121MR-S', 100121, 'GO RIDE WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002146', '2021-04-15 11:52:51.002146', NULL),
	(10002148, 10000002, 'PW21A-JK100121MR-M', 100121, 'GO RIDE WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002147', '2021-04-15 11:52:51.002147', NULL),
	(10002149, 10000002, 'PW21A-JK100121MR-L', 100121, 'GO RIDE WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002148', '2021-04-15 11:52:51.002148', NULL),
	(10002150, 10000002, 'PW21A-JK100121MR-XL', 100121, 'GO RIDE WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002149', '2021-04-15 11:52:51.002149', NULL),
	(10002151, 10000002, 'PW21A-JK100121MR-XXL', 100121, 'GO RIDE WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002150', '2021-04-15 11:52:51.002150', NULL),
	(10002152, 10000002, 'PW21A-JK100122RD-XS', 100122, 'CONCORDE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002151', '2021-04-15 11:52:51.002151', NULL),
	(10002153, 10000002, 'PW21A-JK100122RD-S', 100122, 'CONCORDE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002152', '2021-04-15 11:52:51.002152', NULL),
	(10002154, 10000002, 'PW21A-JK100122RD-M', 100122, 'CONCORDE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002153', '2021-04-15 11:52:51.002153', NULL),
	(10002155, 10000002, 'PW21A-JK100122RD-L', 100122, 'CONCORDE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002154', '2021-04-15 11:52:51.002154', NULL),
	(10002156, 10000002, 'PW21A-JK100122RD-XL', 100122, 'CONCORDE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002155', '2021-04-15 11:52:51.002155', NULL),
	(10002157, 10000002, 'PW21A-JK100122RD-XXL', 100122, 'CONCORDE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002156', '2021-04-15 11:52:51.002156', NULL),
	(10002158, 10000002, 'PW21A-JK100123BL-XS', 100123, 'PHILLIP SPORTY JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002157', '2021-04-15 11:52:51.002157', NULL),
	(10002159, 10000002, 'PW21A-JK100123BL-S', 100123, 'PHILLIP SPORTY JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002158', '2021-04-15 11:52:51.002158', NULL),
	(10002160, 10000002, 'PW21A-JK100123BL-M', 100123, 'PHILLIP SPORTY JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002159', '2021-04-15 11:52:51.002159', NULL),
	(10002161, 10000002, 'PW21A-JK100123BL-L', 100123, 'PHILLIP SPORTY JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002160', '2021-04-15 11:52:51.002160', NULL),
	(10002162, 10000002, 'PW21A-JK100123BL-XL', 100123, 'PHILLIP SPORTY JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002161', '2021-04-15 11:52:51.002161', NULL),
	(10002163, 10000002, 'PW21A-JK100123BL-XXL', 100123, 'PHILLIP SPORTY JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002162', '2021-04-15 11:52:51.002162', NULL),
	(10002164, 10000002, 'PW21A-JK100124BL-XS', 100124, 'WARRIOR PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002163', '2021-04-15 11:52:51.002163', NULL),
	(10002165, 10000002, 'PW21A-JK100124BL-S', 100124, 'WARRIOR PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002164', '2021-04-15 11:52:51.002164', NULL),
	(10002166, 10000002, 'PW21A-JK100124BL-M', 100124, 'WARRIOR PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002165', '2021-04-15 11:52:51.002165', NULL),
	(10002167, 10000002, 'PW21A-JK100124BL-L', 100124, 'WARRIOR PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002166', '2021-04-15 11:52:51.002166', NULL),
	(10002168, 10000002, 'PW21A-JK100124BL-XL', 100124, 'WARRIOR PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002167', '2021-04-15 11:52:51.002167', NULL),
	(10002169, 10000002, 'PW21A-JK100124BL-XXL', 100124, 'WARRIOR PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002168', '2021-04-15 11:52:51.002168', NULL),
	(10002170, 10000002, 'PW21A-JK100125AR-XS', 100125, 'WILD AND FREE PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002169', '2021-04-15 11:52:51.002169', NULL),
	(10002171, 10000002, 'PW21A-JK100125AR-S', 100125, 'WILD AND FREE PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002170', '2021-04-15 11:52:51.002170', NULL),
	(10002172, 10000002, 'PW21A-JK100125AR-M', 100125, 'WILD AND FREE PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002171', '2021-04-15 11:52:51.002171', NULL),
	(10002173, 10000002, 'PW21A-JK100125AR-L', 100125, 'WILD AND FREE PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002172', '2021-04-15 11:52:51.002172', NULL),
	(10002174, 10000002, 'PW21A-JK100125AR-XL', 100125, 'WILD AND FREE PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002173', '2021-04-15 11:52:51.002173', NULL),
	(10002175, 10000002, 'PW21A-JK100125AR-XXL', 100125, 'WILD AND FREE PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002174', '2021-04-15 11:52:51.002174', NULL),
	(10002176, 10000002, 'PW21A-JK100126BL-XS', 100126, 'RAVEN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002175', '2021-04-15 11:52:51.002175', NULL),
	(10002177, 10000002, 'PW21A-JK100126BL-S', 100126, 'RAVEN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002176', '2021-04-15 11:52:51.002176', NULL),
	(10002178, 10000002, 'PW21A-JK100126BL-M', 100126, 'RAVEN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002177', '2021-04-15 11:52:51.002177', NULL),
	(10002179, 10000002, 'PW21A-JK100126BL-L', 100126, 'RAVEN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002178', '2021-04-15 11:52:51.002178', NULL),
	(10002180, 10000002, 'PW21A-JK100126BL-XL', 100126, 'RAVEN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002179', '2021-04-15 11:52:51.002179', NULL),
	(10002181, 10000002, 'PW21A-JK100126BL-XXL', 100126, 'RAVEN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002180', '2021-04-15 11:52:51.002180', NULL),
	(10002182, 10000002, 'PW21A-JK100127BL-XS', 100127, 'YEAGER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002181', '2021-04-15 11:52:51.002181', NULL),
	(10002183, 10000002, 'PW21A-JK100127BL-S', 100127, 'YEAGER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002182', '2021-04-15 11:52:51.002182', NULL),
	(10002184, 10000002, 'PW21A-JK100127BL-M', 100127, 'YEAGER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002183', '2021-04-15 11:52:51.002183', NULL),
	(10002185, 10000002, 'PW21A-JK100127BL-L', 100127, 'YEAGER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002184', '2021-04-15 11:52:51.002184', NULL),
	(10002186, 10000002, 'PW21A-JK100127BL-XL', 100127, 'YEAGER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002185', '2021-04-15 11:52:51.002185', NULL),
	(10002187, 10000002, 'PW21A-JK100127BL-XXL', 100127, 'YEAGER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002186', '2021-04-15 11:52:51.002186', NULL),
	(10002188, 10000002, 'PW21A-JK100128BL-XS', 100128, 'MAGNUS', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002187', '2021-04-15 11:52:51.002187', NULL),
	(10002189, 10000002, 'PW21A-JK100128BL-S', 100128, 'MAGNUS', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002188', '2021-04-15 11:52:51.002188', NULL),
	(10002190, 10000002, 'PW21A-JK100128BL-M', 100128, 'MAGNUS', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002189', '2021-04-15 11:52:51.002189', NULL),
	(10002191, 10000002, 'PW21A-JK100128BL-L', 100128, 'MAGNUS', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002190', '2021-04-15 11:52:51.002190', NULL),
	(10002192, 10000002, 'PW21A-JK100128BL-XL', 100128, 'MAGNUS', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002191', '2021-04-15 11:52:51.002191', NULL),
	(10002193, 10000002, 'PW21A-JK100128BL-XXL', 100128, 'MAGNUS', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002192', '2021-04-15 11:52:51.002192', NULL),
	(10002194, 10000002, 'PW21A-JK100129YW -XS', 100129, 'FORTIUS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002193', '2021-04-15 11:52:51.002193', NULL),
	(10002195, 10000002, 'PW21A-JK100129YW -S', 100129, 'FORTIUS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002194', '2021-04-15 11:52:51.002194', NULL),
	(10002196, 10000002, 'PW21A-JK100129YW -M', 100129, 'FORTIUS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002195', '2021-04-15 11:52:51.002195', NULL),
	(10002197, 10000002, 'PW21A-JK100129YW -L', 100129, 'FORTIUS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002196', '2021-04-15 11:52:51.002196', NULL),
	(10002198, 10000002, 'PW21A-JK100129YW -XL', 100129, 'FORTIUS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002197', '2021-04-15 11:52:51.002197', NULL),
	(10002199, 10000002, 'PW21A-JK100129YW -XXL', 100129, 'FORTIUS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002198', '2021-04-15 11:52:51.002198', NULL),
	(10002200, 10000002, 'PW21A-JK100130YW -XS', 100130, 'SHIBUYA JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002199', '2021-04-15 11:52:51.002199', NULL),
	(10002201, 10000002, 'PW21A-JK100130YW -S', 100130, 'SHIBUYA JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002200', '2021-04-15 11:52:51.002200', NULL),
	(10002202, 10000002, 'PW21A-JK100130YW -M', 100130, 'SHIBUYA JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002201', '2021-04-15 11:52:51.002201', NULL),
	(10002203, 10000002, 'PW21A-JK100130YW -L', 100130, 'SHIBUYA JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002202', '2021-04-15 11:52:51.002202', NULL),
	(10002204, 10000002, 'PW21A-JK100130YW -XL', 100130, 'SHIBUYA JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002203', '2021-04-15 11:52:51.002203', NULL),
	(10002205, 10000002, 'PW21A-JK100130YW -XXL', 100130, 'SHIBUYA JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002204', '2021-04-15 11:52:51.002204', NULL),
	(10002206, 10000002, 'PW21A-JK100131YW -XS', 100131, 'SPEEDSTER RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002205', '2021-04-15 11:52:51.002205', NULL),
	(10002207, 10000002, 'PW21A-JK100131YW -S', 100131, 'SPEEDSTER RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002206', '2021-04-15 11:52:51.002206', NULL),
	(10002208, 10000002, 'PW21A-JK100131YW -M', 100131, 'SPEEDSTER RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002207', '2021-04-15 11:52:51.002207', NULL),
	(10002209, 10000002, 'PW21A-JK100131YW -L', 100131, 'SPEEDSTER RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002208', '2021-04-15 11:52:51.002208', NULL),
	(10002210, 10000002, 'PW21A-JK100131YW -XL', 100131, 'SPEEDSTER RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002209', '2021-04-15 11:52:51.002209', NULL),
	(10002211, 10000002, 'PW21A-JK100131YW -XXL', 100131, 'SPEEDSTER RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002210', '2021-04-15 11:52:51.002210', NULL),
	(10002212, 10000002, 'PW21A-JK100132BL-XS', 100132, 'BARETTA VEST BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002211', '2021-04-15 11:52:51.002211', NULL),
	(10002213, 10000002, 'PW21A-JK100132BL-S', 100132, 'BARETTA VEST BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002212', '2021-04-15 11:52:51.002212', NULL),
	(10002214, 10000002, 'PW21A-JK100132BL-M', 100132, 'BARETTA VEST BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002213', '2021-04-15 11:52:51.002213', NULL),
	(10002215, 10000002, 'PW21A-JK100132BL-L', 100132, 'BARETTA VEST BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002214', '2021-04-15 11:52:51.002214', NULL),
	(10002216, 10000002, 'PW21A-JK100132BL-XL', 100132, 'BARETTA VEST BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002215', '2021-04-15 11:52:51.002215', NULL),
	(10002217, 10000002, 'PW21A-JK100132BL-XXL', 100132, 'BARETTA VEST BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002216', '2021-04-15 11:52:51.002216', NULL),
	(10002218, 10000002, 'PW21A-JK100133BL-XS', 100133, 'MISANO RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002217', '2021-04-15 11:52:51.002217', NULL),
	(10002219, 10000002, 'PW21A-JK100133BL-S', 100133, 'MISANO RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002218', '2021-04-15 11:52:51.002218', NULL),
	(10002220, 10000002, 'PW21A-JK100133BL-M', 100133, 'MISANO RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002219', '2021-04-15 11:52:51.002219', NULL),
	(10002221, 10000002, 'PW21A-JK100133BL-L', 100133, 'MISANO RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002220', '2021-04-15 11:52:51.002220', NULL),
	(10002222, 10000002, 'PW21A-JK100133BL-XL', 100133, 'MISANO RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002221', '2021-04-15 11:52:51.002221', NULL),
	(10002223, 10000002, 'PW21A-JK100133BL-XXL', 100133, 'MISANO RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002222', '2021-04-15 11:52:51.002222', NULL),
	(10002224, 10000002, 'PW21A-JK100134OL-XS', 100134, 'BARETTA VEST OLIVE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002223', '2021-04-15 11:52:51.002223', NULL),
	(10002225, 10000002, 'PW21A-JK100134OL-S', 100134, 'BARETTA VEST OLIVE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002224', '2021-04-15 11:52:51.002224', NULL),
	(10002226, 10000002, 'PW21A-JK100134OL-M', 100134, 'BARETTA VEST OLIVE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002225', '2021-04-15 11:52:51.002225', NULL),
	(10002227, 10000002, 'PW21A-JK100134OL-L', 100134, 'BARETTA VEST OLIVE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002226', '2021-04-15 11:52:51.002226', NULL),
	(10002228, 10000002, 'PW21A-JK100134OL-XL', 100134, 'BARETTA VEST OLIVE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002227', '2021-04-15 11:52:51.002227', NULL),
	(10002229, 10000002, 'PW21A-JK100134OL-XXL', 100134, 'BARETTA VEST OLIVE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002228', '2021-04-15 11:52:51.002228', NULL),
	(10002230, 10000002, 'PW21A-JK100135BL-XS', 100135, 'KAMIKAZE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002229', '2021-04-15 11:52:51.002229', NULL),
	(10002231, 10000002, 'PW21A-JK100135BL-S', 100135, 'KAMIKAZE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002230', '2021-04-15 11:52:51.002230', NULL),
	(10002232, 10000002, 'PW21A-JK100135BL-M', 100135, 'KAMIKAZE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002231', '2021-04-15 11:52:51.002231', NULL),
	(10002233, 10000002, 'PW21A-JK100135BL-L', 100135, 'KAMIKAZE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002232', '2021-04-15 11:52:51.002232', NULL),
	(10002234, 10000002, 'PW21A-JK100135BL-XL', 100135, 'KAMIKAZE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002233', '2021-04-15 11:52:51.002233', NULL),
	(10002235, 10000002, 'PW21A-JK100135BL-XXL', 100135, 'KAMIKAZE RIDER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002234', '2021-04-15 11:52:51.002234', NULL),
	(10002236, 10000002, 'PW21A-JK100136OL-XS', 100136, 'JUNGLE SNAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002235', '2021-04-15 11:52:51.002235', NULL),
	(10002237, 10000002, 'PW21A-JK100136OL-S', 100136, 'JUNGLE SNAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002236', '2021-04-15 11:52:51.002236', NULL),
	(10002238, 10000002, 'PW21A-JK100136OL-M', 100136, 'JUNGLE SNAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002237', '2021-04-15 11:52:51.002237', NULL),
	(10002239, 10000002, 'PW21A-JK100136OL-L', 100136, 'JUNGLE SNAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002238', '2021-04-15 11:52:51.002238', NULL),
	(10002240, 10000002, 'PW21A-JK100136OL-XL', 100136, 'JUNGLE SNAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002239', '2021-04-15 11:52:51.002239', NULL),
	(10002241, 10000002, 'PW21A-JK100136OL-XXL', 100136, 'JUNGLE SNAKE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002240', '2021-04-15 11:52:51.002240', NULL),
	(10002242, 10000002, 'PW21A-JK100137BL-XS', 100137, 'PRIDE OF INDONESIA BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002241', '2021-04-15 11:52:51.002241', NULL),
	(10002243, 10000002, 'PW21A-JK100137BL-S', 100137, 'PRIDE OF INDONESIA BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002242', '2021-04-15 11:52:51.002242', NULL),
	(10002244, 10000002, 'PW21A-JK100137BL-M', 100137, 'PRIDE OF INDONESIA BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002243', '2021-04-15 11:52:51.002243', NULL),
	(10002245, 10000002, 'PW21A-JK100137BL-L', 100137, 'PRIDE OF INDONESIA BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002244', '2021-04-15 11:52:51.002244', NULL),
	(10002246, 10000002, 'PW21A-JK100137BL-XL', 100137, 'PRIDE OF INDONESIA BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002245', '2021-04-15 11:52:51.002245', NULL),
	(10002247, 10000002, 'PW21A-JK100137BL-XXL', 100137, 'PRIDE OF INDONESIA BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002246', '2021-04-15 11:52:51.002246', NULL),
	(10002248, 10000002, 'PW21A-JK100138OL-XS', 100138, 'JUNGLE PANTHER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002247', '2021-04-15 11:52:51.002247', NULL),
	(10002249, 10000002, 'PW21A-JK100138OL-S', 100138, 'JUNGLE PANTHER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002248', '2021-04-15 11:52:51.002248', NULL),
	(10002250, 10000002, 'PW21A-JK100138OL-M', 100138, 'JUNGLE PANTHER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002249', '2021-04-15 11:52:51.002249', NULL),
	(10002251, 10000002, 'PW21A-JK100138OL-L', 100138, 'JUNGLE PANTHER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002250', '2021-04-15 11:52:51.002250', NULL),
	(10002252, 10000002, 'PW21A-JK100138OL-XL', 100138, 'JUNGLE PANTHER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002251', '2021-04-15 11:52:51.002251', NULL),
	(10002253, 10000002, 'PW21A-JK100138OL-XXL', 100138, 'JUNGLE PANTHER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002252', '2021-04-15 11:52:51.002252', NULL),
	(10002254, 10000002, 'PW21A-JK100139BL-XS', 100139, 'VENOM WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002253', '2021-04-15 11:52:51.002253', NULL),
	(10002255, 10000002, 'PW21A-JK100139BL-S', 100139, 'VENOM WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002254', '2021-04-15 11:52:51.002254', NULL),
	(10002256, 10000002, 'PW21A-JK100139BL-M', 100139, 'VENOM WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002255', '2021-04-15 11:52:51.002255', NULL),
	(10002257, 10000002, 'PW21A-JK100139BL-L', 100139, 'VENOM WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002256', '2021-04-15 11:52:51.002256', NULL),
	(10002258, 10000002, 'PW21A-JK100139BL-XL', 100139, 'VENOM WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002257', '2021-04-15 11:52:51.002257', NULL),
	(10002259, 10000002, 'PW21A-JK100139BL-XXL', 100139, 'VENOM WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002258', '2021-04-15 11:52:51.002258', NULL),
	(10002260, 10000002, 'PW21A-JK100140OL-XS', 100140, 'SPEED BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002259', '2021-04-15 11:52:51.002259', NULL),
	(10002261, 10000002, 'PW21A-JK100140OL-S', 100140, 'SPEED BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002260', '2021-04-15 11:52:51.002260', NULL),
	(10002262, 10000002, 'PW21A-JK100140OL-M', 100140, 'SPEED BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002261', '2021-04-15 11:52:51.002261', NULL),
	(10002263, 10000002, 'PW21A-JK100140OL-L', 100140, 'SPEED BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002262', '2021-04-15 11:52:51.002262', NULL),
	(10002264, 10000002, 'PW21A-JK100140OL-XL', 100140, 'SPEED BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002263', '2021-04-15 11:52:51.002263', NULL),
	(10002265, 10000002, 'PW21A-JK100140OL-XXL', 100140, 'SPEED BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002264', '2021-04-15 11:52:51.002264', NULL),
	(10002266, 10000002, 'PW21A-JK100141BL-XS', 100141, 'DOMINATION SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002265', '2021-04-15 11:52:51.002265', NULL),
	(10002267, 10000002, 'PW21A-JK100141BL-S', 100141, 'DOMINATION SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002266', '2021-04-15 11:52:51.002266', NULL),
	(10002268, 10000002, 'PW21A-JK100141BL-M', 100141, 'DOMINATION SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002267', '2021-04-15 11:52:51.002267', NULL),
	(10002269, 10000002, 'PW21A-JK100141BL-L', 100141, 'DOMINATION SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002268', '2021-04-15 11:52:51.002268', NULL),
	(10002270, 10000002, 'PW21A-JK100141BL-XL', 100141, 'DOMINATION SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002269', '2021-04-15 11:52:51.002269', NULL),
	(10002271, 10000002, 'PW21A-JK100141BL-XXL', 100141, 'DOMINATION SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002270', '2021-04-15 11:52:51.002270', NULL),
	(10002272, 10000002, 'PW21A-JK100142OL-XS', 100142, 'AERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002271', '2021-04-15 11:52:51.002271', NULL),
	(10002273, 10000002, 'PW21A-JK100142OL-S', 100142, 'AERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002272', '2021-04-15 11:52:51.002272', NULL),
	(10002274, 10000002, 'PW21A-JK100142OL-M', 100142, 'AERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002273', '2021-04-15 11:52:51.002273', NULL),
	(10002275, 10000002, 'PW21A-JK100142OL-L', 100142, 'AERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002274', '2021-04-15 11:52:51.002274', NULL),
	(10002276, 10000002, 'PW21A-JK100142OL-XL', 100142, 'AERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002275', '2021-04-15 11:52:51.002275', NULL),
	(10002277, 10000002, 'PW21A-JK100142OL-XXL', 100142, 'AERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002276', '2021-04-15 11:52:51.002276', NULL),
	(10002278, 10000002, 'PW21A-JK100143BL-XS', 100143, 'BLACK SQUADRON', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002277', '2021-04-15 11:52:51.002277', NULL),
	(10002279, 10000002, 'PW21A-JK100143BL-S', 100143, 'BLACK SQUADRON', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002278', '2021-04-15 11:52:51.002278', NULL),
	(10002280, 10000002, 'PW21A-JK100143BL-M', 100143, 'BLACK SQUADRON', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002279', '2021-04-15 11:52:51.002279', NULL),
	(10002281, 10000002, 'PW21A-JK100143BL-L', 100143, 'BLACK SQUADRON', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002280', '2021-04-15 11:52:51.002280', NULL),
	(10002282, 10000002, 'PW21A-JK100143BL-XL', 100143, 'BLACK SQUADRON', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002281', '2021-04-15 11:52:51.002281', NULL),
	(10002283, 10000002, 'PW21A-JK100143BL-XXL', 100143, 'BLACK SQUADRON', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002282', '2021-04-15 11:52:51.002282', NULL),
	(10002284, 10000002, 'PW21A-JK100144AR-XS', 100144, 'SKULL BARR', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002283', '2021-04-15 11:52:51.002283', NULL),
	(10002285, 10000002, 'PW21A-JK100144AR-S', 100144, 'SKULL BARR', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002284', '2021-04-15 11:52:51.002284', NULL),
	(10002286, 10000002, 'PW21A-JK100144AR-M', 100144, 'SKULL BARR', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002285', '2021-04-15 11:52:51.002285', NULL),
	(10002287, 10000002, 'PW21A-JK100144AR-L', 100144, 'SKULL BARR', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002286', '2021-04-15 11:52:51.002286', NULL),
	(10002288, 10000002, 'PW21A-JK100144AR-XL', 100144, 'SKULL BARR', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002287', '2021-04-15 11:52:51.002287', NULL),
	(10002289, 10000002, 'PW21A-JK100144AR-XXL', 100144, 'SKULL BARR', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002288', '2021-04-15 11:52:51.002288', NULL),
	(10002290, 10000002, 'PW21A-JK100145RD-XS', 100145, 'KONOTORI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002289', '2021-04-15 11:52:51.002289', NULL),
	(10002291, 10000002, 'PW21A-JK100145RD-S', 100145, 'KONOTORI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002290', '2021-04-15 11:52:51.002290', NULL),
	(10002292, 10000002, 'PW21A-JK100145RD-M', 100145, 'KONOTORI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002291', '2021-04-15 11:52:51.002291', NULL),
	(10002293, 10000002, 'PW21A-JK100145RD-L', 100145, 'KONOTORI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002292', '2021-04-15 11:52:51.002292', NULL),
	(10002294, 10000002, 'PW21A-JK100145RD-XL', 100145, 'KONOTORI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002293', '2021-04-15 11:52:51.002293', NULL),
	(10002295, 10000002, 'PW21A-JK100145RD-XXL', 100145, 'KONOTORI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002294', '2021-04-15 11:52:51.002294', NULL),
	(10002296, 10000002, 'PW21A-JK100146BL-XS', 100146, 'FREEDOM FIGHTER SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002295', '2021-04-15 11:52:51.002295', NULL),
	(10002297, 10000002, 'PW21A-JK100146BL-S', 100146, 'FREEDOM FIGHTER SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002296', '2021-04-15 11:52:51.002296', NULL),
	(10002298, 10000002, 'PW21A-JK100146BL-M', 100146, 'FREEDOM FIGHTER SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002297', '2021-04-15 11:52:51.002297', NULL),
	(10002299, 10000002, 'PW21A-JK100146BL-L', 100146, 'FREEDOM FIGHTER SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002298', '2021-04-15 11:52:51.002298', NULL),
	(10002300, 10000002, 'PW21A-JK100146BL-XL', 100146, 'FREEDOM FIGHTER SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002299', '2021-04-15 11:52:51.002299', NULL),
	(10002301, 10000002, 'PW21A-JK100146BL-XXL', 100146, 'FREEDOM FIGHTER SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002300', '2021-04-15 11:52:51.002300', NULL),
	(10002302, 10000002, 'PW21A-JK100147BL-XS', 100147, 'SUPERIOR WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002301', '2021-04-15 11:52:51.002301', NULL),
	(10002303, 10000002, 'PW21A-JK100147BL-S', 100147, 'SUPERIOR WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002302', '2021-04-15 11:52:51.002302', NULL),
	(10002304, 10000002, 'PW21A-JK100147BL-M', 100147, 'SUPERIOR WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002303', '2021-04-15 11:52:51.002303', NULL),
	(10002305, 10000002, 'PW21A-JK100147BL-L', 100147, 'SUPERIOR WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002304', '2021-04-15 11:52:51.002304', NULL),
	(10002306, 10000002, 'PW21A-JK100147BL-XL', 100147, 'SUPERIOR WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002305', '2021-04-15 11:52:51.002305', NULL),
	(10002307, 10000002, 'PW21A-JK100147BL-XXL', 100147, 'SUPERIOR WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002306', '2021-04-15 11:52:51.002306', NULL),
	(10002308, 10000002, 'PW21A-JK100148BL-XS', 100148, 'UNFORGIVEN WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002307', '2021-04-15 11:52:51.002307', NULL),
	(10002309, 10000002, 'PW21A-JK100148BL-S', 100148, 'UNFORGIVEN WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002308', '2021-04-15 11:52:51.002308', NULL),
	(10002310, 10000002, 'PW21A-JK100148BL-M', 100148, 'UNFORGIVEN WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002309', '2021-04-15 11:52:51.002309', NULL),
	(10002311, 10000002, 'PW21A-JK100148BL-L', 100148, 'UNFORGIVEN WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002310', '2021-04-15 11:52:51.002310', NULL),
	(10002312, 10000002, 'PW21A-JK100148BL-XL', 100148, 'UNFORGIVEN WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002311', '2021-04-15 11:52:51.002311', NULL),
	(10002313, 10000002, 'PW21A-JK100148BL-XXL', 100148, 'UNFORGIVEN WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002312', '2021-04-15 11:52:51.002312', NULL),
	(10002314, 10000002, 'PW21A-JK100149BL-XS', 100149, 'FREAKLESS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002313', '2021-04-15 11:52:51.002313', NULL),
	(10002315, 10000002, 'PW21A-JK100149BL-S', 100149, 'FREAKLESS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002314', '2021-04-15 11:52:51.002314', NULL),
	(10002316, 10000002, 'PW21A-JK100149BL-M', 100149, 'FREAKLESS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002315', '2021-04-15 11:52:51.002315', NULL),
	(10002317, 10000002, 'PW21A-JK100149BL-L', 100149, 'FREAKLESS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002316', '2021-04-15 11:52:51.002316', NULL),
	(10002318, 10000002, 'PW21A-JK100149BL-XL', 100149, 'FREAKLESS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002317', '2021-04-15 11:52:51.002317', NULL),
	(10002319, 10000002, 'PW21A-JK100149BL-XXL', 100149, 'FREAKLESS WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002318', '2021-04-15 11:52:51.002318', NULL),
	(10002320, 10000002, 'PW21A-JK100150BL-XS', 100150, 'BURNING SKULL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002319', '2021-04-15 11:52:51.002319', NULL),
	(10002321, 10000002, 'PW21A-JK100150BL-S', 100150, 'BURNING SKULL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002320', '2021-04-15 11:52:51.002320', NULL),
	(10002322, 10000002, 'PW21A-JK100150BL-M', 100150, 'BURNING SKULL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002321', '2021-04-15 11:52:51.002321', NULL),
	(10002323, 10000002, 'PW21A-JK100150BL-L', 100150, 'BURNING SKULL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002322', '2021-04-15 11:52:51.002322', NULL),
	(10002324, 10000002, 'PW21A-JK100150BL-XL', 100150, 'BURNING SKULL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002323', '2021-04-15 11:52:51.002323', NULL),
	(10002325, 10000002, 'PW21A-JK100150BL-XXL', 100150, 'BURNING SKULL WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002324', '2021-04-15 11:52:51.002324', NULL),
	(10002326, 10000002, 'PW21A-JK100151BL-XS', 100151, 'PISTON HEAD WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002325', '2021-04-15 11:52:51.002325', NULL),
	(10002327, 10000002, 'PW21A-JK100151BL-S', 100151, 'PISTON HEAD WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002326', '2021-04-15 11:52:51.002326', NULL),
	(10002328, 10000002, 'PW21A-JK100151BL-M', 100151, 'PISTON HEAD WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002327', '2021-04-15 11:52:51.002327', NULL),
	(10002329, 10000002, 'PW21A-JK100151BL-L', 100151, 'PISTON HEAD WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002328', '2021-04-15 11:52:51.002328', NULL),
	(10002330, 10000002, 'PW21A-JK100151BL-XL', 100151, 'PISTON HEAD WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002329', '2021-04-15 11:52:51.002329', NULL),
	(10002331, 10000002, 'PW21A-JK100151BL-XXL', 100151, 'PISTON HEAD WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002330', '2021-04-15 11:52:51.002330', NULL),
	(10002332, 10000002, 'PW21A-JK100152BL-XS', 100152, 'JAPAN KOI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002331', '2021-04-15 11:52:51.002331', NULL),
	(10002333, 10000002, 'PW21A-JK100152BL-S', 100152, 'JAPAN KOI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002332', '2021-04-15 11:52:51.002332', NULL),
	(10002334, 10000002, 'PW21A-JK100152BL-M', 100152, 'JAPAN KOI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002333', '2021-04-15 11:52:51.002333', NULL),
	(10002335, 10000002, 'PW21A-JK100152BL-L', 100152, 'JAPAN KOI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002334', '2021-04-15 11:52:51.002334', NULL),
	(10002336, 10000002, 'PW21A-JK100152BL-XL', 100152, 'JAPAN KOI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002335', '2021-04-15 11:52:51.002335', NULL),
	(10002337, 10000002, 'PW21A-JK100152BL-XXL', 100152, 'JAPAN KOI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002336', '2021-04-15 11:52:51.002336', NULL),
	(10002338, 10000002, 'PW21A-JK100153GN-XS', 100153, 'TENGUHEBI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002337', '2021-04-15 11:52:51.002337', NULL),
	(10002339, 10000002, 'PW21A-JK100153GN-S', 100153, 'TENGUHEBI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002338', '2021-04-15 11:52:51.002338', NULL),
	(10002340, 10000002, 'PW21A-JK100153GN-M', 100153, 'TENGUHEBI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002339', '2021-04-15 11:52:51.002339', NULL),
	(10002341, 10000002, 'PW21A-JK100153GN-L', 100153, 'TENGUHEBI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002340', '2021-04-15 11:52:51.002340', NULL),
	(10002342, 10000002, 'PW21A-JK100153GN-XL', 100153, 'TENGUHEBI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002341', '2021-04-15 11:52:51.002341', NULL),
	(10002343, 10000002, 'PW21A-JK100153GN-XXL', 100153, 'TENGUHEBI SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002342', '2021-04-15 11:52:51.002342', NULL),
	(10002344, 10000002, 'PW21A-JD100154BL-XS', 100154, 'HERITAGE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002343', '2021-04-15 11:52:51.002343', NULL),
	(10002345, 10000002, 'PW21A-JD100154BL-S', 100154, 'HERITAGE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002344', '2021-04-15 11:52:51.002344', NULL),
	(10002346, 10000002, 'PW21A-JD100154BL-M', 100154, 'HERITAGE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002345', '2021-04-15 11:52:51.002345', NULL),
	(10002347, 10000002, 'PW21A-JD100154BL-L', 100154, 'HERITAGE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002346', '2021-04-15 11:52:51.002346', NULL),
	(10002348, 10000002, 'PW21A-JD100154BL-XL', 100154, 'HERITAGE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002347', '2021-04-15 11:52:51.002347', NULL),
	(10002349, 10000002, 'PW21A-JD100154BL-XXL', 100154, 'HERITAGE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 1, 1, 'Piece', '2021-04-15 11:52:51.002348', '2021-04-15 11:52:51.002348', NULL),
	(10002350, 10000002, 'PW21A-JK100155OL-XS', 100155, 'IGNORANT JUNGLE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002349', '2021-04-15 11:52:51.002349', NULL),
	(10002351, 10000002, 'PW21A-JK100155OL-S', 100155, 'IGNORANT JUNGLE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002350', '2021-04-15 11:52:51.002350', NULL),
	(10002352, 10000002, 'PW21A-JK100155OL-M', 100155, 'IGNORANT JUNGLE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002351', '2021-04-15 11:52:51.002351', NULL),
	(10002353, 10000002, 'PW21A-JK100155OL-L', 100155, 'IGNORANT JUNGLE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002352', '2021-04-15 11:52:51.002352', NULL),
	(10002354, 10000002, 'PW21A-JK100155OL-XL', 100155, 'IGNORANT JUNGLE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002353', '2021-04-15 11:52:51.002353', NULL),
	(10002355, 10000002, 'PW21A-JK100155OL-XXL', 100155, 'IGNORANT JUNGLE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002354', '2021-04-15 11:52:51.002354', NULL),
	(10002356, 10000002, 'PW21A-JK100156YW -XS', 100156, 'ROAD KILLER WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002355', '2021-04-15 11:52:51.002355', NULL),
	(10002357, 10000002, 'PW21A-JK100156YW -S', 100156, 'ROAD KILLER WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002356', '2021-04-15 11:52:51.002356', NULL),
	(10002358, 10000002, 'PW21A-JK100156YW -M', 100156, 'ROAD KILLER WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002357', '2021-04-15 11:52:51.002357', NULL),
	(10002359, 10000002, 'PW21A-JK100156YW -L', 100156, 'ROAD KILLER WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002358', '2021-04-15 11:52:51.002358', NULL),
	(10002360, 10000002, 'PW21A-JK100156YW -XL', 100156, 'ROAD KILLER WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002359', '2021-04-15 11:52:51.002359', NULL),
	(10002361, 10000002, 'PW21A-JK100156YW -XXL', 100156, 'ROAD KILLER WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002360', '2021-04-15 11:52:51.002360', NULL),
	(10002362, 10000002, 'PW21A-JK100157BL-XS', 100157, 'ONIMUSHA SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002361', '2021-04-15 11:52:51.002361', NULL),
	(10002363, 10000002, 'PW21A-JK100157BL-S', 100157, 'ONIMUSHA SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002362', '2021-04-15 11:52:51.002362', NULL),
	(10002364, 10000002, 'PW21A-JK100157BL-M', 100157, 'ONIMUSHA SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002363', '2021-04-15 11:52:51.002363', NULL),
	(10002365, 10000002, 'PW21A-JK100157BL-L', 100157, 'ONIMUSHA SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002364', '2021-04-15 11:52:51.002364', NULL),
	(10002366, 10000002, 'PW21A-JK100157BL-XL', 100157, 'ONIMUSHA SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002365', '2021-04-15 11:52:51.002365', NULL),
	(10002367, 10000002, 'PW21A-JK100157BL-XXL', 100157, 'ONIMUSHA SUKAJAN', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002366', '2021-04-15 11:52:51.002366', NULL),
	(10002368, 10000002, 'PW21A-JK100158AR-XS', 100158, 'KNOCK OUT PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002367', '2021-04-15 11:52:51.002367', NULL),
	(10002369, 10000002, 'PW21A-JK100158AR-S', 100158, 'KNOCK OUT PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002368', '2021-04-15 11:52:51.002368', NULL),
	(10002370, 10000002, 'PW21A-JK100158AR-M', 100158, 'KNOCK OUT PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002369', '2021-04-15 11:52:51.002369', NULL),
	(10002371, 10000002, 'PW21A-JK100158AR-L', 100158, 'KNOCK OUT PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002370', '2021-04-15 11:52:51.002370', NULL),
	(10002372, 10000002, 'PW21A-JK100158AR-XL', 100158, 'KNOCK OUT PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002371', '2021-04-15 11:52:51.002371', NULL),
	(10002373, 10000002, 'PW21A-JK100158AR-XXL', 100158, 'KNOCK OUT PARKA', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002372', '2021-04-15 11:52:51.002372', NULL),
	(10002374, 10000002, 'PW21A-JD100159MR-XS', 100159, 'GO RIDE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002373', '2021-04-15 11:52:51.002373', NULL),
	(10002375, 10000002, 'PW21A-JD100159MR-S', 100159, 'GO RIDE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002374', '2021-04-15 11:52:51.002374', NULL),
	(10002376, 10000002, 'PW21A-JD100159MR-M', 100159, 'GO RIDE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002375', '2021-04-15 11:52:51.002375', NULL),
	(10002377, 10000002, 'PW21A-JD100159MR-L', 100159, 'GO RIDE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002376', '2021-04-15 11:52:51.002376', NULL),
	(10002378, 10000002, 'PW21A-JD100159MR-XL', 100159, 'GO RIDE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002377', '2021-04-15 11:52:51.002377', NULL),
	(10002379, 10000002, 'PW21A-JD100159MR-XXL', 100159, 'GO RIDE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002378', '2021-04-15 11:52:51.002378', NULL),
	(10002380, 10000002, 'PW21A-JK100160TC-XS', 100160, 'NIPPON 4.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002379', '2021-04-15 11:52:51.002379', NULL),
	(10002381, 10000002, 'PW21A-JK100160TC-S', 100160, 'NIPPON 4.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002380', '2021-04-15 11:52:51.002380', NULL),
	(10002382, 10000002, 'PW21A-JK100160TC-M', 100160, 'NIPPON 4.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002381', '2021-04-15 11:52:51.002381', NULL),
	(10002383, 10000002, 'PW21A-JK100160TC-L', 100160, 'NIPPON 4.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002382', '2021-04-15 11:52:51.002382', NULL),
	(10002384, 10000002, 'PW21A-JK100160TC-XL', 100160, 'NIPPON 4.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002383', '2021-04-15 11:52:51.002383', NULL),
	(10002385, 10000002, 'PW21A-JK100160TC-XXL', 100160, 'NIPPON 4.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002384', '2021-04-15 11:52:51.002384', NULL),
	(10002386, 10000002, 'PW21A-JK100161BL-XS', 100161, 'DIRTY DEES WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002385', '2021-04-15 11:52:51.002385', NULL),
	(10002387, 10000002, 'PW21A-JK100161BL-S', 100161, 'DIRTY DEES WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002386', '2021-04-15 11:52:51.002386', NULL),
	(10002388, 10000002, 'PW21A-JK100161BL-M', 100161, 'DIRTY DEES WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002387', '2021-04-15 11:52:51.002387', NULL),
	(10002389, 10000002, 'PW21A-JK100161BL-L', 100161, 'DIRTY DEES WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002388', '2021-04-15 11:52:51.002388', NULL),
	(10002390, 10000002, 'PW21A-JK100161BL-XL', 100161, 'DIRTY DEES WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002389', '2021-04-15 11:52:51.002389', NULL),
	(10002391, 10000002, 'PW21A-JK100161BL-XXL', 100161, 'DIRTY DEES WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002390', '2021-04-15 11:52:51.002390', NULL),
	(10002392, 10000002, 'PW21A-JD100162BL-XS', 100162, 'PW MC WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002391', '2021-04-15 11:52:51.002391', NULL),
	(10002393, 10000002, 'PW21A-JD100162BL-S', 100162, 'PW MC WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002392', '2021-04-15 11:52:51.002392', NULL),
	(10002394, 10000002, 'PW21A-JD100162BL-M', 100162, 'PW MC WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002393', '2021-04-15 11:52:51.002393', NULL),
	(10002395, 10000002, 'PW21A-JD100162BL-L', 100162, 'PW MC WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002394', '2021-04-15 11:52:51.002394', NULL),
	(10002396, 10000002, 'PW21A-JD100162BL-XL', 100162, 'PW MC WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002395', '2021-04-15 11:52:51.002395', NULL),
	(10002397, 10000002, 'PW21A-JD100162BL-XXL', 100162, 'PW MC WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002396', '2021-04-15 11:52:51.002396', NULL),
	(10002398, 10000002, 'PW21A-JK100163RD-XS', 100163, 'MOTEGI 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002397', '2021-04-15 11:52:51.002397', NULL),
	(10002399, 10000002, 'PW21A-JK100163RD-S', 100163, 'MOTEGI 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002398', '2021-04-15 11:52:51.002398', NULL),
	(10002400, 10000002, 'PW21A-JK100163RD-M', 100163, 'MOTEGI 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002399', '2021-04-15 11:52:51.002399', NULL),
	(10002401, 10000002, 'PW21A-JK100163RD-L', 100163, 'MOTEGI 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002400', '2021-04-15 11:52:51.002400', NULL),
	(10002402, 10000002, 'PW21A-JK100163RD-XL', 100163, 'MOTEGI 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002401', '2021-04-15 11:52:51.002401', NULL),
	(10002403, 10000002, 'PW21A-JK100163RD-XXL', 100163, 'MOTEGI 2.0', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002402', '2021-04-15 11:52:51.002402', NULL),
	(10002404, 10000002, 'PW21A-JD100164BL-XS', 100164, 'BLACK EAGLE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002403', '2021-04-15 11:52:51.002403', NULL),
	(10002405, 10000002, 'PW21A-JD100164BL-S', 100164, 'BLACK EAGLE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002404', '2021-04-15 11:52:51.002404', NULL),
	(10002406, 10000002, 'PW21A-JD100164BL-M', 100164, 'BLACK EAGLE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002405', '2021-04-15 11:52:51.002405', NULL),
	(10002407, 10000002, 'PW21A-JD100164BL-L', 100164, 'BLACK EAGLE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002406', '2021-04-15 11:52:51.002406', NULL),
	(10002408, 10000002, 'PW21A-JD100164BL-XL', 100164, 'BLACK EAGLE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002407', '2021-04-15 11:52:51.002407', NULL),
	(10002409, 10000002, 'PW21A-JD100164BL-XXL', 100164, 'BLACK EAGLE WB KIDS', 8, 'Jacket Kids', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002408', '2021-04-15 11:52:51.002408', NULL),
	(10002410, 10000002, 'PW21A-JK100165NV-XS', 100165, 'UNIT ZERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002409', '2021-04-15 11:52:51.002409', NULL),
	(10002411, 10000002, 'PW21A-JK100165NV-S', 100165, 'UNIT ZERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002410', '2021-04-15 11:52:51.002410', NULL),
	(10002412, 10000002, 'PW21A-JK100165NV-M', 100165, 'UNIT ZERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002411', '2021-04-15 11:52:51.002411', NULL),
	(10002413, 10000002, 'PW21A-JK100165NV-L', 100165, 'UNIT ZERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002412', '2021-04-15 11:52:51.002412', NULL),
	(10002414, 10000002, 'PW21A-JK100165NV-XL', 100165, 'UNIT ZERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002413', '2021-04-15 11:52:51.002413', NULL),
	(10002415, 10000002, 'PW21A-JK100165NV-XXL', 100165, 'UNIT ZERO BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002414', '2021-04-15 11:52:51.002414', NULL),
	(10002416, 10000002, 'PW21A-JK100166MR-XS', 100166, 'BIRD BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002415', '2021-04-15 11:52:51.002415', NULL),
	(10002417, 10000002, 'PW21A-JK100166MR-S', 100166, 'BIRD BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002416', '2021-04-15 11:52:51.002416', NULL),
	(10002418, 10000002, 'PW21A-JK100166MR-M', 100166, 'BIRD BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002417', '2021-04-15 11:52:51.002417', NULL),
	(10002419, 10000002, 'PW21A-JK100166MR-L', 100166, 'BIRD BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002418', '2021-04-15 11:52:51.002418', NULL),
	(10002420, 10000002, 'PW21A-JK100166MR-XL', 100166, 'BIRD BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002419', '2021-04-15 11:52:51.002419', NULL),
	(10002421, 10000002, 'PW21A-JK100166MR-XXL', 100166, 'BIRD BOMBER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002420', '2021-04-15 11:52:51.002420', NULL),
	(10002422, 10000002, 'PW21A-JK100167WT-XS', 100167, 'OKAMI WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002421', '2021-04-15 11:52:51.002421', NULL),
	(10002423, 10000002, 'PW21A-JK100167WT-S', 100167, 'OKAMI WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002422', '2021-04-15 11:52:51.002422', NULL),
	(10002424, 10000002, 'PW21A-JK100167WT-M', 100167, 'OKAMI WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002423', '2021-04-15 11:52:51.002423', NULL),
	(10002425, 10000002, 'PW21A-JK100167WT-L', 100167, 'OKAMI WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002424', '2021-04-15 11:52:51.002424', NULL),
	(10002426, 10000002, 'PW21A-JK100167WT-XL', 100167, 'OKAMI WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002425', '2021-04-15 11:52:51.002425', NULL),
	(10002427, 10000002, 'PW21A-JK100167WT-XXL', 100167, 'OKAMI WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002426', '2021-04-15 11:52:51.002426', NULL),
	(10002428, 10000002, 'PW21A-JK100168BL-XS', 100168, 'JAVA ANORAK JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002427', '2021-04-15 11:52:51.002427', NULL),
	(10002429, 10000002, 'PW21A-JK100168BL-S', 100168, 'JAVA ANORAK JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002428', '2021-04-15 11:52:51.002428', NULL),
	(10002430, 10000002, 'PW21A-JK100168BL-M', 100168, 'JAVA ANORAK JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002429', '2021-04-15 11:52:51.002429', NULL),
	(10002431, 10000002, 'PW21A-JK100168BL-L', 100168, 'JAVA ANORAK JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002430', '2021-04-15 11:52:51.002430', NULL),
	(10002432, 10000002, 'PW21A-JK100168BL-XL', 100168, 'JAVA ANORAK JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002431', '2021-04-15 11:52:51.002431', NULL),
	(10002433, 10000002, 'PW21A-JK100168BL-XXL', 100168, 'JAVA ANORAK JACKET', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002432', '2021-04-15 11:52:51.002432', NULL),
	(10002434, 10000002, 'PW21A-JK100169BL-XS', 100169, 'RACING DIVISION BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002433', '2021-04-15 11:52:51.002433', NULL),
	(10002435, 10000002, 'PW21A-JK100169BL-S', 100169, 'RACING DIVISION BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002434', '2021-04-15 11:52:51.002434', NULL),
	(10002436, 10000002, 'PW21A-JK100169BL-M', 100169, 'RACING DIVISION BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002435', '2021-04-15 11:52:51.002435', NULL),
	(10002437, 10000002, 'PW21A-JK100169BL-L', 100169, 'RACING DIVISION BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002436', '2021-04-15 11:52:51.002436', NULL),
	(10002438, 10000002, 'PW21A-JK100169BL-XL', 100169, 'RACING DIVISION BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002437', '2021-04-15 11:52:51.002437', NULL),
	(10002439, 10000002, 'PW21A-JK100169BL-XXL', 100169, 'RACING DIVISION BLACK', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002438', '2021-04-15 11:52:51.002438', NULL),
	(10002440, 10000002, 'PW21A-JK100170RD-XS', 100170, 'RACING DIVISION RED', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002439', '2021-04-15 11:52:51.002439', NULL),
	(10002441, 10000002, 'PW21A-JK100170RD-S', 100170, 'RACING DIVISION RED', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002440', '2021-04-15 11:52:51.002440', NULL),
	(10002442, 10000002, 'PW21A-JK100170RD-M', 100170, 'RACING DIVISION RED', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002441', '2021-04-15 11:52:51.002441', NULL),
	(10002443, 10000002, 'PW21A-JK100170RD-L', 100170, 'RACING DIVISION RED', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002442', '2021-04-15 11:52:51.002442', NULL),
	(10002444, 10000002, 'PW21A-JK100170RD-XL', 100170, 'RACING DIVISION RED', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002443', '2021-04-15 11:52:51.002443', NULL),
	(10002445, 10000002, 'PW21A-JK100170RD-XXL', 100170, 'RACING DIVISION RED', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002444', '2021-04-15 11:52:51.002444', NULL),
	(10002446, 10000002, 'PW21A-JK100171WT-XS', 100171, 'RACING DIVISION WHITE', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002445', '2021-04-15 11:52:51.002445', NULL),
	(10002447, 10000002, 'PW21A-JK100171WT-S', 100171, 'RACING DIVISION WHITE', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002446', '2021-04-15 11:52:51.002446', NULL),
	(10002448, 10000002, 'PW21A-JK100171WT-M', 100171, 'RACING DIVISION WHITE', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002447', '2021-04-15 11:52:51.002447', NULL),
	(10002449, 10000002, 'PW21A-JK100171WT-L', 100171, 'RACING DIVISION WHITE', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002448', '2021-04-15 11:52:51.002448', NULL),
	(10002450, 10000002, 'PW21A-JK100171WT-XL', 100171, 'RACING DIVISION WHITE', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002449', '2021-04-15 11:52:51.002449', NULL),
	(10002451, 10000002, 'PW21A-JK100171WT-XXL', 100171, 'RACING DIVISION WHITE', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002450', '2021-04-15 11:52:51.002450', NULL),
	(10002452, 10000002, 'PW21A-JK100172BL-XS', 100172, 'ECHOPLEX WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002451', '2021-04-15 11:52:51.002451', NULL),
	(10002453, 10000002, 'PW21A-JK100172BL-S', 100172, 'ECHOPLEX WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002452', '2021-04-15 11:52:51.002452', NULL),
	(10002454, 10000002, 'PW21A-JK100172BL-M', 100172, 'ECHOPLEX WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002453', '2021-04-15 11:52:51.002453', NULL),
	(10002455, 10000002, 'PW21A-JK100172BL-L', 100172, 'ECHOPLEX WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 4, 1, 'Piece', '2021-04-15 11:52:51.002454', '2021-04-15 11:52:51.002454', NULL),
	(10002456, 10000002, 'PW21A-JK100172BL-XL', 100172, 'ECHOPLEX WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 3, 1, 'Piece', '2021-04-15 11:52:51.002455', '2021-04-15 11:52:51.002455', NULL),
	(10002457, 10000002, 'PW21A-JK100172BL-XXL', 100172, 'ECHOPLEX WINDBREAKER', 7, 'Jacket', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 2, 1, 'Piece', '2021-04-15 11:52:51.002456', '2021-04-15 11:52:51.002456', NULL),
	(10002458, 10000002, 'PW21A-TS100173BL-XS', 100173, 'CB 1972', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002457', '2021-04-15 11:52:51.002457', NULL),
	(10002459, 10000002, 'PW21A-TS100173BL-M', 100173, 'CB 1972', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002458', '2021-04-15 11:52:51.002458', NULL),
	(10002460, 10000002, 'PW21A-TS100173BL-L', 100173, 'CB 1972', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002459', '2021-04-15 11:52:51.002459', NULL),
	(10002461, 10000002, 'PW21A-TS100173BL-XL', 100173, 'CB 1972', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002460', '2021-04-15 11:52:51.002460', NULL),
	(10002462, 10000002, 'PW21A-TS100173BL-XXL', 100173, 'CB 1972', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002461', '2021-04-15 11:52:51.002461', NULL),
	(10002463, 10000002, 'PW21A-TS100174NV-XS', 100174, 'DUST AND WHEELS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002462', '2021-04-15 11:52:51.002462', NULL),
	(10002464, 10000002, 'PW21A-TS100174NV-S', 100174, 'DUST AND WHEELS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002463', '2021-04-15 11:52:51.002463', NULL),
	(10002465, 10000002, 'PW21A-TS100174NV-M', 100174, 'DUST AND WHEELS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002464', '2021-04-15 11:52:51.002464', NULL),
	(10002466, 10000002, 'PW21A-TS100174NV-L', 100174, 'DUST AND WHEELS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002465', '2021-04-15 11:52:51.002465', NULL),
	(10002467, 10000002, 'PW21A-TS100174NV-XL', 100174, 'DUST AND WHEELS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002466', '2021-04-15 11:52:51.002466', NULL),
	(10002468, 10000002, 'PW21A-TS100174NV-XXL', 100174, 'DUST AND WHEELS', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000006, 'XXL', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002467', '2021-04-15 11:52:51.002467', NULL),
	(10002469, 10000002, 'PW21A-TS100175BL-XS', 100175, 'NO FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000001, 'XS', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002468', '2021-04-15 11:52:51.002468', NULL),
	(10002470, 10000002, 'PW21A-TS100175BL-S', 100175, 'NO FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000002, 'S', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002469', '2021-04-15 11:52:51.002469', NULL),
	(10002471, 10000002, 'PW21A-TS100175BL-M', 100175, 'NO FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000003, 'M', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002470', '2021-04-15 11:52:51.002470', NULL),
	(10002472, 10000002, 'PW21A-TS100175BL-L', 100175, 'NO FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000004, 'L', 0, 0, 0, 0, 1, 'Piece', '2021-04-15 11:52:51.002471', '2021-04-15 11:52:51.002471', NULL),
	(10002473, 10000002, 'PW21A-TS100175BL-XL', 100175, 'NO FEAR', 2, 'T-Shirt ', 1, 'Phillip Works ', 10000005, 'XL', 0, 0, 0, 0, 