-- --------------------------------------------------------
-- Host:                         54.151.227.26
-- Server version:               8.0.23 - MySQL Community Server - GPL
-- Server OS:                    Linux
-- HeidiSQL Version:             11.2.0.6213
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Dumping structure for table phillip.edc
CREATE TABLE IF NOT EXISTS `edc` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.edc: ~0 rows (approximately)
/*!40000 ALTER TABLE `edc` DISABLE KEYS */;
/*!40000 ALTER TABLE `edc` ENABLE KEYS */;

-- Dumping structure for table phillip.edc_item
CREATE TABLE IF NOT EXISTS `edc_item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `status` tinyint NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  `branch_id` int DEFAULT NULL,
  `edc_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_7d1b1473467c4ca87fcfb59a204` (`branch_id`),
  KEY `FK_a210a39a0002f5a4ab4ad68aed5` (`edc_id`),
  CONSTRAINT `FK_7d1b1473467c4ca87fcfb59a204` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_a210a39a0002f5a4ab4ad68aed5` FOREIGN KEY (`edc_id`) REFERENCES `edc` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.edc_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `edc_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `edc_item` ENABLE KEYS */;

-- Dumping structure for table phillip.invoice
CREATE TABLE IF NOT EXISTS `invoice` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(225) NOT NULL,
  `contact_id` int NOT NULL,
  `branch_id` int DEFAULT NULL,
  `created_by_contact_id` int NOT NULL,
  `updated_by_contact_id` int DEFAULT NULL,
  `confirmed_by_contact_id` int DEFAULT NULL,
  `date` date NOT NULL,
  `due_date` date NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `status` enum('draft','confirmed','closed') NOT NULL,
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_8de8b14ca9092b02a794c172773` (`contact_id`),
  KEY `FK_81a2a3283b4b6eafe3ea6dfdaa1` (`created_by_contact_id`),
  KEY `FK_87f845b6759c9c049688f05ec93` (`updated_by_contact_id`),
  KEY `FK_88f69e23f368f4da1bf27439611` (`confirmed_by_contact_id`),
  KEY `FK_1a9acbae68dbaa913c969eda740` (`branch_id`),
  CONSTRAINT `FK_1a9acbae68dbaa913c969eda740` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`),
  CONSTRAINT `FK_81a2a3283b4b6eafe3ea6dfdaa1` FOREIGN KEY (`created_by_contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_87f845b6759c9c049688f05ec93` FOREIGN KEY (`updated_by_contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_88f69e23f368f4da1bf27439611` FOREIGN KEY (`confirmed_by_contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_8de8b14ca9092b02a794c172773` FOREIGN KEY (`contact_id`) REFERENCES `contact` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.invoice: ~0 rows (approximately)
/*!40000 ALTER TABLE `invoice` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice` ENABLE KEYS */;

-- Dumping structure for table phillip.invoice_item
CREATE TABLE IF NOT EXISTS `invoice_item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` int DEFAULT NULL,
  `product_id` int NOT NULL,
  `variant_type_id` int DEFAULT NULL,
  `price` int NOT NULL,
  `uom_id` int NOT NULL,
  `discount` float NOT NULL DEFAULT '0',
  `qty` int NOT NULL,
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_9830c1881dd701d440c2164c3cd` (`invoice_id`),
  KEY `FK_7e6e8d3c1449a7ec83b2b5491f6` (`product_id`),
  KEY `FK_dacd30412874720d99b86882cd4` (`variant_type_id`),
  KEY `FK_6fae9d1f5bd81a2d9c5e15c3c72` (`uom_id`),
  CONSTRAINT `FK_6fae9d1f5bd81a2d9c5e15c3c72` FOREIGN KEY (`uom_id`) REFERENCES `unit` (`id`),
  CONSTRAINT `FK_7e6e8d3c1449a7ec83b2b5491f6` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  CONSTRAINT `FK_9830c1881dd701d440c2164c3cd` FOREIGN KEY (`invoice_id`) REFERENCES `invoice` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_dacd30412874720d99b86882cd4` FOREIGN KEY (`variant_type_id`) REFERENCES `variant_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.invoice_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `invoice_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_item` ENABLE KEYS */;

-- Dumping structure for table phillip.log_activity
CREATE TABLE IF NOT EXISTS `log_activity` (
  `id` int NOT NULL AUTO_INCREMENT,
  `module` varchar(255) NOT NULL,
  `activity` varchar(255) NOT NULL,
  `branch` varchar(255) NOT NULL,
  `user` varchar(255) NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10000015 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.log_activity: ~14 rows (approximately)
/*!40000 ALTER TABLE `log_activity` DISABLE KEYS */;
INSERT INTO `log_activity` (`id`, `module`, `activity`, `branch`, `user`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(10000001, 'Stock Opname', 'UPDATE STATUS TO CHECK', 'Main Office', 'Admin', '2021-04-15 12:43:27.000000', '2021-04-15 12:43:27.000000', NULL),
	(10000002, 'Stock Opname', 'UPDATE STATUS TO CHECK', 'Main Office', 'Admin', '2021-04-15 12:51:18.000000', '2021-04-15 12:51:18.000000', NULL),
	(10000003, 'Stock Opname', 'UPDATE STATUS TO CHECK', 'Karang Sari', 'Admin', '2021-04-15 12:58:18.000000', '2021-04-15 12:58:18.000000', NULL),
	(10000004, 'Stock Opname', 'UPDATE STATUS TO CHECK', 'Maulana Yusuf', 'Admin', '2021-04-15 13:01:05.000000', '2021-04-15 13:01:05.000000', NULL),
	(10000005, 'Stock Opname', 'UPDATE STATUS TO CHECK', 'Bahureksa', 'Admin', '2021-04-15 13:03:20.000000', '2021-04-15 13:03:20.000000', NULL),
	(10000006, 'Stock Opname', 'UPDATE STATUS TO CHECK', 'Gudang Selatan', 'Admin', '2021-04-15 13:06:34.000000', '2021-04-15 13:06:34.000000', NULL),
	(10000007, 'Category', 'UPDATE', 'Main Office', 'Admin 2', '2021-05-24 05:51:32.000080', '2021-05-24 05:51:32.000080', NULL),
	(10000008, 'User Category', 'INSERT', 'Main Office', 'Admin 2', '2021-05-24 06:05:37.000000', '2021-05-24 06:05:37.000000', NULL),
	(10000009, 'Contact', 'INSERT', 'Main Office', 'Admin 2', '2021-05-24 06:10:36.000000', '2021-05-24 06:10:36.000000', NULL),
	(10000010, 'Branch', 'UPDATE', 'Main Office', 'Jubey', '2021-05-25 06:07:08.000000', '2021-05-25 06:07:08.000000', NULL),
	(10000011, 'User Category', 'INSERT', 'Yogyakarta', 'Jubey', '2021-05-25 10:54:12.000000', '2021-05-25 10:54:12.000000', NULL),
	(10000012, 'Contact', 'INSERT', 'Yogyakarta', 'Jubey', '2021-05-25 11:06:34.000000', '2021-05-25 11:06:34.000000', NULL),
	(10000013, 'User Category', 'INSERT', 'Yogyakarta', 'Jubey', '2021-05-25 12:10:59.000000', '2021-05-25 12:10:59.000000', NULL),
	(10000014, 'Contact', 'INSERT', 'Yogyakarta', 'Jubey', '2021-05-25 12:15:56.000000', '2021-05-25 12:15:56.000000', NULL);
/*!40000 ALTER TABLE `log_activity` ENABLE KEYS */;

-- Dumping structure for table phillip.payment
CREATE TABLE IF NOT EXISTS `payment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `contact_id` int NOT NULL,
  `branch_id` int DEFAULT NULL,
  `payment_method` enum('cash','transfer') NOT NULL,
  `code` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `note` varchar(255) DEFAULT NULL,
  `status` enum('draft','open','paid') NOT NULL,
  `created_by_contact_id` int NOT NULL,
  `updated_by_contact_id` int DEFAULT NULL,
  `confirmed_by_contact_id` int DEFAULT NULL,
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_359012060e1aa5e96fb9c22952f` (`contact_id`),
  KEY `FK_a1717a81f8d41567a7d72fa6643` (`created_by_contact_id`),
  KEY `FK_15780aeab1980fe7ed5776215b0` (`updated_by_contact_id`),
  KEY `FK_43ead5258c4c5bd972216d341b2` (`confirmed_by_contact_id`),
  KEY `FK_2c462ff83e2ae67f603719ddb14` (`branch_id`),
  CONSTRAINT `FK_15780aeab1980fe7ed5776215b0` FOREIGN KEY (`updated_by_contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_2c462ff83e2ae67f603719ddb14` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`),
  CONSTRAINT `FK_359012060e1aa5e96fb9c22952f` FOREIGN KEY (`contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_43ead5258c4c5bd972216d341b2` FOREIGN KEY (`confirmed_by_contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_a1717a81f8d41567a7d72fa6643` FOREIGN KEY (`created_by_contact_id`) REFERENCES `contact` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.payment: ~0 rows (approximately)
/*!40000 ALTER TABLE `payment` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment` ENABLE KEYS */;

-- Dumping structure for table phillip.payment_item
CREATE TABLE IF NOT EXISTS `payment_item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `payment_id` int DEFAULT NULL,
  `invoice_id` int DEFAULT NULL,
  `payment_amount` int NOT NULL,
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_4a68ebebc1fa3a668585bd8c724` (`payment_id`),
  KEY `FK_3a5d20ca4bdeabc23c9e4544325` (`invoice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.payment_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `payment_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_item` ENABLE KEYS */;

-- Dumping structure for table phillip.pos
CREATE TABLE IF NOT EXISTS `pos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `member_id` int DEFAULT NULL,
  `branch_id` int NOT NULL,
  `voucher` varchar(255) DEFAULT NULL,
  `transaction_date` date NOT NULL,
  `category` enum('sales','return') NOT NULL DEFAULT 'sales',
  `note` varchar(255) DEFAULT NULL,
  `status` enum('draft','paid') NOT NULL,
  `proof_member` varchar(255) DEFAULT NULL,
  `payment_method` text,
  `discount` int DEFAULT NULL,
  `total` int NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  `created_by_contact_id` int DEFAULT NULL,
  `updated_by_contact_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_287bdf629337d91b27b74f6e148` (`branch_id`),
  KEY `FK_36192abe1c5ad83aafd341ad029` (`member_id`),
  KEY `FK_18f026f45883a22ab4bae0a993d` (`created_by_contact_id`),
  KEY `FK_65effae54c723e18f810511c366` (`updated_by_contact_id`),
  FULLTEXT KEY `IDX_494ad2f99cb068df5f04ed4e5c` (`code`),
  CONSTRAINT `FK_18f026f45883a22ab4bae0a993d` FOREIGN KEY (`created_by_contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_287bdf629337d91b27b74f6e148` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`),
  CONSTRAINT `FK_36192abe1c5ad83aafd341ad029` FOREIGN KEY (`member_id`) REFERENCES `member` (`id`),
  CONSTRAINT `FK_65effae54c723e18f810511c366` FOREIGN KEY (`updated_by_contact_id`) REFERENCES `contact` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.pos: ~0 rows (approximately)
/*!40000 ALTER TABLE `pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `pos` ENABLE KEYS */;

-- Dumping structure for table phillip.pos_item
CREATE TABLE IF NOT EXISTS `pos_item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `pos_id` int DEFAULT NULL,
  `pos_item_promotion_id` int DEFAULT NULL,
  `uom_id` int NOT NULL,
  `variant_type_id` int DEFAULT NULL,
  `pos_retur_id` int DEFAULT NULL,
  `qty` int NOT NULL,
  `price` int NOT NULL,
  `category` enum('sales','return') NOT NULL,
  `discount` int DEFAULT NULL,
  `total` int NOT NULL,
  `proof_retur` text,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_3dce9e6ba8c72cc6927d6ae4306` (`pos_id`),
  KEY `FK_2dd16d3dc3e0bbf87ab58755318` (`product_id`),
  KEY `FK_4cd4bbd8db64898876fbcefdacc` (`variant_type_id`),
  KEY `FK_a65ed855f29d9bbfecaac05ca7d` (`pos_item_promotion_id`),
  KEY `FK_62676bd9b1949dfd2802530fea8` (`uom_id`),
  KEY `FK_1f8059cdac5fa26c06dbdc5ea94` (`pos_retur_id`),
  CONSTRAINT `FK_1f8059cdac5fa26c06dbdc5ea94` FOREIGN KEY (`pos_retur_id`) REFERENCES `pos_item` (`id`),
  CONSTRAINT `FK_2dd16d3dc3e0bbf87ab58755318` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  CONSTRAINT `FK_3dce9e6ba8c72cc6927d6ae4306` FOREIGN KEY (`pos_id`) REFERENCES `pos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_4cd4bbd8db64898876fbcefdacc` FOREIGN KEY (`variant_type_id`) REFERENCES `variant_type` (`id`),
  CONSTRAINT `FK_62676bd9b1949dfd2802530fea8` FOREIGN KEY (`uom_id`) REFERENCES `unit` (`id`),
  CONSTRAINT `FK_a65ed855f29d9bbfecaac05ca7d` FOREIGN KEY (`pos_item_promotion_id`) REFERENCES `promotion` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.pos_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `pos_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `pos_item` ENABLE KEYS */;

-- Dumping structure for table phillip.pos_item_promotion
CREATE TABLE IF NOT EXISTS `pos_item_promotion` (
  `id` int NOT NULL AUTO_INCREMENT,
  `pos_item_id` int NOT NULL,
  `promotion_id` int NOT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_953691c466533ddcbfdbfde8014` (`pos_item_id`),
  KEY `FK_de1c65e23fb3a61518c71af483f` (`promotion_id`),
  CONSTRAINT `FK_953691c466533ddcbfdbfde8014` FOREIGN KEY (`pos_item_id`) REFERENCES `pos_item` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_de1c65e23fb3a61518c71af483f` FOREIGN KEY (`promotion_id`) REFERENCES `promotion` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.pos_item_promotion: ~0 rows (approximately)
/*!40000 ALTER TABLE `pos_item_promotion` DISABLE KEYS */;
/*!40000 ALTER TABLE `pos_item_promotion` ENABLE KEYS */;

-- Dumping structure for table phillip.promotion
CREATE TABLE IF NOT EXISTS `promotion` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` enum('percent','quantity','giveaway','voucher') NOT NULL,
  `brand_target` text,
  `item_target` text,
  `values` text NOT NULL,
  `user_target` text NOT NULL,
  `date_start` date NOT NULL,
  `date_end` date NOT NULL,
  `created_by_contact_id` int DEFAULT NULL,
  `updated_by_contact_id` int DEFAULT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_dde27af28c5be5d35e8d6b8ba59` (`created_by_contact_id`),
  KEY `FK_93c749de008dd1169d7aeaae307` (`updated_by_contact_id`),
  CONSTRAINT `FK_93c749de008dd1169d7aeaae307` FOREIGN KEY (`updated_by_contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_dde27af28c5be5d35e8d6b8ba59` FOREIGN KEY (`created_by_contact_id`) REFERENCES `contact` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.promotion: ~0 rows (approximately)
/*!40000 ALTER TABLE `promotion` DISABLE KEYS */;
INSERT INTO `promotion` (`id`, `code`, `name`, `type`, `brand_target`, `item_target`, `values`, `user_target`, `date_start`, `date_end`, `created_by_contact_id`, `updated_by_contact_id`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(1, 'DEFAULT-MEMBER', 'Member Total Transaction', 'percent', '[]', '[]', '{"minimum":0,"discount":0}', '[]', '1975-01-01', '4000-01-01', 1, 1, '2021-04-07 17:27:42.003942', '2021-04-07 17:27:42.003942', NULL);
/*!40000 ALTER TABLE `promotion` ENABLE KEYS */;

-- Dumping structure for table phillip.promotion_brand
CREATE TABLE IF NOT EXISTS `promotion_brand` (
  `id` int NOT NULL AUTO_INCREMENT,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  `promotion_ids` int DEFAULT NULL,
  `brand_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_889b788aa78b0089a2290506fca` (`promotion_ids`),
  KEY `FK_bbc9f8752650b29dae5ee7238f7` (`brand_id`),
  CONSTRAINT `FK_889b788aa78b0089a2290506fca` FOREIGN KEY (`promotion_ids`) REFERENCES `promotion` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_bbc9f8752650b29dae5ee7238f7` FOREIGN KEY (`brand_id`) REFERENCES `brand` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.promotion_brand: ~0 rows (approximately)
/*!40000 ALTER TABLE `promotion_brand` DISABLE KEYS */;
/*!40000 ALTER TABLE `promotion_brand` ENABLE KEYS */;

-- Dumping structure for table phillip.promotion_category
CREATE TABLE IF NOT EXISTS `promotion_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  `promotion_ids` int DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_9133941bdf31aa29267624ce37c` (`promotion_ids`),
  KEY `FK_2b6d80a7bf1b56baaeb14bbc34b` (`category_id`),
  CONSTRAINT `FK_2b6d80a7bf1b56baaeb14bbc34b` FOREIGN KEY (`category_id`) REFERENCES `category` (`id`),
  CONSTRAINT `FK_9133941bdf31aa29267624ce37c` FOREIGN KEY (`promotion_ids`) REFERENCES `promotion` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.promotion_category: ~0 rows (approximately)
/*!40000 ALTER TABLE `promotion_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `promotion_category` ENABLE KEYS */;

-- Dumping structure for table phillip.promotion_product
CREATE TABLE IF NOT EXISTS `promotion_product` (
  `id` int NOT NULL AUTO_INCREMENT,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  `promotion_ids` int DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_55ab7e926bea25e31f023132a9f` (`promotion_ids`),
  KEY `FK_a16e17a90c2106ee13dad46b3f2` (`product_id`),
  CONSTRAINT `FK_55ab7e926bea25e31f023132a9f` FOREIGN KEY (`promotion_ids`) REFERENCES `promotion` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_a16e17a90c2106ee13dad46b3f2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.promotion_product: ~0 rows (approximately)
/*!40000 ALTER TABLE `promotion_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `promotion_product` ENABLE KEYS */;

-- Dumping structure for table phillip.warehouse
CREATE TABLE IF NOT EXISTS `warehouse` (
  `id` int NOT NULL AUTO_INCREMENT,
  `branch_id` int DEFAULT NULL,
  `warehouse_code` varchar(20) NOT NULL,
  `location_name` varchar(40) NOT NULL,
  `address` text,
  `phone` varchar(30) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  `is_store` tinyint DEFAULT NULL,
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_ec8556342bfd257da8898c2fe43` (`branch_id`),
  CONSTRAINT `FK_ec8556342bfd257da8898c2fe43` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.warehouse: ~7 rows (approximately)
/*!40000 ALTER TABLE `warehouse` DISABLE KEYS */;
INSERT INTO `warehouse` (`id`, `branch_id`, `warehouse_code`, `location_name`, `address`, `phone`, `status`, `is_store`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(1, 1, 'PW-01-warehouse', 'Main Office', 'Jalan Bahureksa no 1, Jawa Barat, Bandung, , 13450', '02254168097', 1, 1, '2021-04-07 17:27:41.382487', '2021-04-07 17:27:41.382487', NULL),
	(2, 2, 'PW-02-warehouse', 'Karang Sari', 'Jl. Karang Sari no 3, Jawa Barat, Bandung', NULL, 1, 1, '2021-04-12 14:21:10.000000', '2021-04-12 14:21:13.000000', NULL),
	(3, 3, 'PW-03-warehouse', 'Maulana Yusuf', 'Jalan Maulana Yusuf, Jawa Barat, Bandung', NULL, 1, 1, '2021-04-12 14:21:15.000000', '2021-04-12 14:21:18.000000', NULL),
	(4, 4, 'PW-04-warehouse', 'Bahureksa', 'Jalan Bahureksa no 1, Jawa Barat, Bandung', NULL, 1, 1, '2021-04-12 14:21:15.000000', '2021-04-12 14:21:18.000000', NULL),
	(5, 5, 'PW-05-warehouse', 'Gudang Selatan', 'Jl.Gudang Selatan no.22 Blok A, Jawa Barat, Bandung', NULL, 1, 1, '2021-04-12 14:21:15.000000', '2021-04-12 14:21:18.000000', NULL),
	(6, 5, 'PW-06-warehouse', 'Yogyakarta', 'Jl.Cendrawasih', NULL, 0, 1, '2021-04-12 14:21:15.000000', '2021-04-12 14:21:18.000000', NULL),
	(7, 6, 'PW-06-warehouse', 'Yogyakarta', 'Jl.Cendrawasih', NULL, 1, 1, '2021-05-25 06:07:08.000000', '2021-05-25 06:07:08.000000', NULL);
/*!40000 ALTER TABLE `warehouse` ENABLE KEYS */;

-- Dumping structure for table phillip.warehouse_product
CREATE TABLE IF NOT EXISTS `warehouse_product` (
  `id` int NOT NULL AUTO_INCREMENT,
  `warehouse_id` int NOT NULL,
  `product_id` varchar(255) NOT NULL,
  `stock` int NOT NULL DEFAULT '0',
  `reject` int NOT NULL DEFAULT '0',
  `updated_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `created_at` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),
  `deleted_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_0807ef7b83c85174136ec70052f` (`warehouse_id`),
  CONSTRAINT `FK_0807ef7b83c85174136ec70052f` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouse` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10009206 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table phillip.warehouse_product: ~9.086 rows (approximately)
/*!40000 ALTER TABLE `warehouse_product` DISABLE KEYS */;
INSERT INTO `warehouse_product` (`id`, `warehouse_id`, `product_id`, `stock`, `reject`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(10000001, 1, 'PW21A-AC100001BL-All', 15, 0, '2021-04-15 12:50:50.850630', '2021-04-15 12:50:50.850630', NULL),
	(10000002, 1, 'PW21A-AC100002YW -All', 30, 0, '2021-04-15 12:50:50.862858', '2021-04-15 12:50:50.862858', NULL),
	(10000003, 1, 'PW21A-AC100003BL-All', 28, 0, '2021-04-15 12:50:50.851441', '2021-04-15 12:50:50.851441', NULL),
	(10000004, 1, 'PW21A-AC100004BL-All', 0, 0, '2021-04-15 12:50:50.851947', '2021-04-15 12:50:50.851947', NULL),
	(10000005, 1, 'PW21A-AC100005BL-All', 24, 0, '2021-04-15 12:50:50.853077', '2021-04-15 12:50:50.853077', NULL),
	(10000006, 1, 'PW21A-AC100006BL-All', 23, 0, '2021-04-15 12:50:50.852489', '2021-04-15 12:50:50.852489', NULL),
	(10000007, 1, 'PW21A-AC100007BL-All', 0, 0, '2021-04-15 12:50:50.861454', '2021-04-15 12:50:50.861454', NULL),
	(10000008, 1, 'PW21A-AC100008BL-All', 0, 0, '2021-04-15 12:50:50.860563', '2021-04-15 12:50:50.860563', NULL),
	(10000009, 1, 'PW21A-AC100009BW-All', 87, 0, '2021-04-15 12:50:50.860281', '2021-04-15 12:50:50.860281', NULL),
	(10000010, 1, 'PW21A-AC100010MC-All', 30, 0, '2021-04-15 12:50:50.862041', '2021-04-15 12:50:50.862041', NULL),
	(10000011, 1, 'PW21A-AC100011OG-All', 34, 0, '2021-04-15 12:50:50.889264', '2021-04-15 12:50:50.889264', NULL),
	(10000012, 1, 'PW21A-AC100012BL-All', 54, 0, '2021-04-15 12:50:50.889710', '2021-04-15 12:50:50.889710', NULL),
	(10000013, 1, 'PW21A-AC100013OG-All', 58, 0, '2021-04-15 12:50:50.890181', '2021-04-15 12:50:50.890181', NULL),
	(10000014, 1, 'PW21A-AC100014OL-All', 89, 0, '2021-04-15 12:50:50.890692', '2021-04-15 12:50:50.890692', NULL),
	(10000015, 1, 'PW21A-AC100015MR-All', 79, 0, '2021-04-15 12:50:50.891216', '2021-04-15 12:50:50.891216', NULL),
	(10000016, 1, 'PW21A-AC100016BL-All', 42, 0, '2021-04-15 12:50:50.891740', '2021-04-15 12:50:50.891740', NULL),
	(10000017, 1, 'PW21A-AC100017BL-All', 40, 0, '2021-04-15 12:50:50.892403', '2021-04-15 12:50:50.892403', NULL),
	(10000018, 1, 'PW21A-BG100018WT-All', 30, 0, '2021-04-15 12:50:50.892827', '2021-04-15 12:50:50.892827', NULL),
	(10000019, 1, 'PW21A-BG100019BL-All', 63, 0, '2021-04-15 12:50:50.893254', '2021-04-15 12:50:50.893254', NULL),
	(10000020, 1, 'PW21A-BG100020BL-All', 66, 0, '2021-04-15 12:50:50.893735', '2021-04-15 12:50:50.893735', NULL),
	(10000021, 1, 'PW21A-BG100021BL-All', 1, 0, '2021-04-15 12:50:50.912260', '2021-04-15 12:50:50.912260', NULL),
	(10000022, 1, 'PW21A-BG100022BL-All', 0, 0, '2021-04-15 12:50:50.913470', '2021-04-15 12:50:50.913470', NULL),
	(10000023, 1, 'PW21A-BG100023BL-All', 15, 0, '2021-04-15 12:50:50.914111', '2021-04-15 12:50:50.914111', NULL),
	(10000024, 1, 'PW21A-BG100024BL-All', 38, 0, '2021-04-15 12:50:50.914555', '2021-04-15 12:50:50.914555', NULL),
	(10000025, 1, 'PW21A-BG100025BL-All', 47, 0, '2021-04-15 12:50:50.914994', '2021-04-15 12:50:50.914994', NULL),
	(10000026, 1, 'PW21A-BG100026CM-All', 28, 0, '2021-04-15 12:50:50.915439', '2021-04-15 12:50:50.915439', NULL),
	(10000027, 1, 'PW21A-BG100027CM-All', 33, 0, '2021-04-15 12:50:50.915875', '2021-04-15 12:50:50.915875', NULL),
	(10000028, 1, 'PW21A-BG100028CM-All', 23, 0, '2021-04-15 12:50:50.916326', '2021-04-15 12:50:50.916326', NULL),
	(10000029, 1, 'PW21A-BG100029CM-All', 24, 0, '2021-04-15 12:50:50.917261', '2021-04-15 12:50:50.917261', NULL),
	(10000030, 1, 'PW21A-BG100030BL-All', 24, 0, '2021-04-15 12:50:50.917693', '2021-04-15 12:50:50.917693', NULL),
	(10000031, 1, 'PW21A-BG100031BL-All', 9, 0, '2021-04-15 12:50:50.939550', '2021-04-15 12:50:50.939550', NULL),
	(10000032, 1, 'PW21A-BG100032BL-All', 0, 0, '2021-04-15 12:50:50.940123', '2021-04-15 12:50:50.940123', NULL),
	(10000033, 1, 'PW21A-BG100033BL-All', 0, 0, '2021-04-15 12:50:50.941296', '2021-04-15 12:50:50.941296', NULL),
	(10000034, 1, 'PW21A-BG100034BL-All', 0, 0, '2021-04-15 12:50:50.941976', '2021-04-15 12:50:50.941976', NULL),
	(10000035, 1, 'PW21A-BG100035BL-All', 40, 0, '2021-04-15 12:50:50.942657', '2021-04-15 12:50:50.942657', NULL),
	(10000036, 1, 'PW21A-BG100036BL-All', 0, 0, '2021-04-15 12:50:50.943422', '2021-04-15 12:50:50.943422', NULL),
	(10000037, 1, 'PW21A-BG100037OG-All', 52, 0, '2021-04-15 12:50:50.944062', '2021-04-15 12:50:50.944062', NULL),
	(10000038, 1, 'PW21A-BG100038BL-All', 184, 0, '2021-04-15 12:50:50.944725', '2021-04-15 12:50:50.944725', NULL),
	(10000039, 1, 'PW21A-BG100039GN-All', 42, 0, '2021-04-15 12:50:50.945381', '2021-04-15 12:50:50.945381', NULL),
	(10000040, 1, 'PW21A-BG100040WT-All', 56, 0, '2021-04-15 12:50:50.954853', '2021-04-15 12:50:50.954853', NULL),
	(10000041, 1, 'PW21A-BG100041BL-All', 33, 0, '2021-04-15 12:50:50.980051', '2021-04-15 12:50:50.980051', NULL),
	(10000042, 1, 'PW21A-BG100042BL-All', 33, 0, '2021-04-15 12:50:50.980565', '2021-04-15 12:50:50.980565', NULL),
	(10000043, 1, 'PW21A-BG100043BL-All', 58, 0, '2021-04-15 12:50:50.981905', '2021-04-15 12:50:50.981905', NULL),
	(10000044, 1, 'PW21A-BG100044BL-All', 256, 0, '2021-04-15 12:50:50.982633', '2021-04-15 12:50:50.982633', NULL),
	(10000045, 1, 'PW21A-BG100045BL-All', 43, 0, '2021-04-15 12:50:50.983398', '2021-04-15 12:50:50.983398', NULL),
	(10000046, 1, 'PW21A-BG100046BL-All', 49, 0, '2021-04-15 12:50:50.984048', '2021-04-15 12:50:50.984048', NULL),
	(10000047, 1, 'PW21A-BG100047BL-All', 53, 0, '2021-04-15 12:50:50.984674', '2021-04-15 12:50:50.984674', NULL),
	(10000048, 1, 'PW21A-BG100048BL-All', 82, 0, '2021-04-15 12:50:50.985245', '2021-04-15 12:50:50.985245', NULL),
	(10000049, 1, 'PW21A-BG100049BL-All', 32, 0, '2021-04-15 12:50:50.986701', '2021-04-15 12:50:50.986701', NULL),
	(10000050, 1, 'PW21A-BG100050BL-All', 40, 0, '2021-04-15 12:50:50.988103', '2021-04-15 12:50:50.988103', NULL),
	(10000051, 1, 'PW21A-BG100051BL-All', 42, 0, '2021-04-15 12:50:51.026291', '2021-04-15 12:50:51.026291', NULL),
	(10000052, 1, 'PW21A-BG100052BL-All', 39, 0, '2021-04-15 12:50:51.023791', '2021-04-15 12:50:51.023791', NULL),
	(10000053, 1, 'PW21A-BG100053BL-All', 47, 0, '2021-04-15 12:50:51.028063', '2021-04-15 12:50:51.028063', NULL),
	(10000054, 1, 'PW21A-BG100054BL-All', 9, 0, '2021-04-15 12:50:51.024879', '2021-04-15 12:50:51.024879', NULL),
	(10000055, 1, 'PW21A-GL100055YW -S', 0, 0, '2021-04-15 12:50:51.028818', '2021-04-15 12:50:51.028818', NULL),
	(10000056, 1, 'PW21A-GL100055YW -M', 7, 0, '2021-04-15 12:50:51.029505', '2021-04-15 12:50:51.029505', NULL),
	(10000057, 1, 'PW21A-GL100055YW -L', 9, 0, '2021-04-15 12:50:51.030903', '2021-04-15 12:50:51.030903', NULL),
	(10000058, 1, 'PW21A-GL100055YW -XL', 6, 0, '2021-04-15 12:50:51.030217', '2021-04-15 12:50:51.030217', NULL),
	(10000059, 1, 'PW21A-GL100056BW-S', 0, 0, '2021-04-15 12:50:51.035013', '2021-04-15 12:50:51.035013', NULL),
	(10000060, 1, 'PW21A-GL100056BW-M', 1, 0, '2021-04-15 12:50:51.031622', '2021-04-15 12:50:51.031622', NULL),
	(10000061, 1, 'PW21A-GL100056BW-L', 4, 0, '2021-04-15 12:50:51.066115', '2021-04-15 12:50:51.066115', NULL),
	(10000062, 1, 'PW21A-GL100056BW-XL', 0, 0, '2021-04-15 12:50:51.067357', '2021-04-15 12:50:51.067357', NULL),
	(10000063, 1, 'PW21A-GL100057CM-S', 0, 0, '2021-04-15 12:50:51.068367', '2021-04-15 12:50:51.068367', NULL),
	(10000064, 1, 'PW21A-GL100057CM-M', 6, 0, '2021-04-15 12:50:51.068987', '2021-04-15 12:50:51.068987', NULL),
	(10000065, 1, 'PW21A-GL100057CM-L', 3, 0, '2021-04-15 12:50:51.070253', '2021-04-15 12:50:51.070253', NULL),
	(10000066, 1, 'PW21A-GL100057CM-XL', 0, 0, '2021-04-15 12:50:51.070894', '2021-04-15 12:50:51.070894', NULL),
	(10000067, 1, 'PW21A-GL100058BW-S', 3, 0, '2021-04-15 12:50:51.069623', '2021-04-15 12:50:51.069623', NULL),
	(10000068, 1, 'PW21A-GL100058BW-M', 7, 0, '2021-04-15 12:50:51.071442', '2021-04-15 12:50:51.071442', NULL),
	(10000069, 1, 'PW21A-GL100058BW-L', 10, 0, '2021-04-15 12:50:51.072064', '2021-04-15 12:50:51.072064', NULL),
	(10000070, 1, 'PW21A-GL100058BW-XL', 6, 0, '2021-04-15 12:50:51.073534', '2021-04-15 12:50:51.073534', NULL),
	(10000071, 1, 'PW21A-GL100059BL-S', 1, 0, '2021-04-15 12:50:51.098938', '2021-04-15 12:50:51.098938', NULL),
	(10000072, 1, 'PW21A-GL100059BL-M', 3, 0, '2021-04-15 12:50:51.100172', '2021-04-15 12:50:51.100172', NULL),
	(10000073, 1, 'PW21A-GL100059BL-L', 0, 0, '2021-04-15 12:50:51.100774', '2021-04-15 12:50:51.100774', NULL),
	(10000074, 1, 'PW21A-GL100059BL-XL', 2, 0, '2021-04-15 12:50:51.101358', '2021-04-15 12:50:51.101358', NULL),
	(10000075, 1, 'PW21A-GL100060BL-S', 0, 0, '2021-04-15 12:50:51.101969', '2021-04-15 12:50:51.101969', NULL),
	(10000076, 1, 'PW21A-GL100060BL-M', 0, 0, '2021-04-15 12:50:51.102812', '2021-04-15 12:50:51.102812', NULL),
	(10000077, 1, 'PW21A-GL100060BL-L', 2, 0, '2021-04-15 12:50:51.103415', '2021-04-15 12:50:51.103415', NULL),
	(10000078, 1, 'PW21A-GL100060BL-XL', 4, 0, '2021-04-15 12:50:51.104021', '2021-04-15 12:50:51.104021', NULL),
	(10000079, 1, 'PW21A-GL100061RD-S', 3, 0, '2021-04-15 12:50:51.104691', '2021-04-15 12:50:51.104691', NULL),
	(10000080, 1, 'PW21A-GL100061RD-M', 9, 0, '2021-04-15 12:50:51.105374', '2021-04-15 12:50:51.105374', NULL),
	(10000081, 1, 'PW21A-GL100061RD-L', 7, 0, '2021-04-15 12:50:51.136418', '2021-04-15 12:50:51.136418', NULL),
	(10000082, 1, 'PW21A-GL100061RD-XL', 1, 0, '2021-04-15 12:50:51.137000', '2021-04-15 12:50:51.137000', NULL),
	(10000083, 1, 'PW21A-GL100062WT-S', 1, 0, '2021-04-15 12:50:51.137577', '2021-04-15 12:50:51.137577', NULL),
	(10000084, 1, 'PW21A-GL100062WT-M', 4, 0, '2021-04-15 12:50:51.138212', '2021-04-15 12:50:51.138212', NULL),
	(10000085, 1, 'PW21A-GL100062WT-L', 14, 0, '2021-04-15 12:50:51.138758', '2021-04-15 12:50:51.138758', NULL),
	(10000086, 1, 'PW21A-GL100062WT-XL', 3, 0, '2021-04-15 12:50:51.139385', '2021-04-15 12:50:51.139385', NULL),
	(10000087, 1, 'PW21A-GL100063BW-S', 2, 0, '2021-04-15 12:50:51.139959', '2021-04-15 12:50:51.139959', NULL),
	(10000088, 1, 'PW21A-GL100063BW-M', 9, 0, '2021-04-15 12:50:51.140557', '2021-04-15 12:50:51.140557', NULL),
	(10000089, 1, 'PW21A-GL100063BW-L', 9, 0, '2021-04-15 12:50:51.141097', '2021-04-15 12:50:51.141097', NULL),
	(10000090, 1, 'PW21A-GL100063BW-XL', 0, 0, '2021-04-15 12:50:51.141656', '2021-04-15 12:50:51.141656', NULL),
	(10000091, 1, 'PW21A-GL100064WT-S', 5, 0, '2021-04-15 12:50:51.169375', '2021-04-15 12:50:51.169375', NULL),
	(10000092, 1, 'PW21A-GL100064WT-M', 7, 0, '2021-04-15 12:50:51.170550', '2021-04-15 12:50:51.170550', NULL),
	(10000093, 1, 'PW21A-GL100064WT-L', 6, 0, '2021-04-15 12:50:51.171078', '2021-04-15 12:50:51.171078', NULL),
	(10000094, 1, 'PW21A-GL100064WT-XL', 4, 0, '2021-04-15 12:50:51.171593', '2021-04-15 12:50:51.171593', NULL),
	(10000095, 1, 'PW21A-GL100065BL-S', 1, 0, '2021-04-15 12:50:51.172172', '2021-04-15 12:50:51.172172', NULL),
	(10000096, 1, 'PW21A-GL100065BL-M', 0, 0, '2021-04-15 12:50:51.172775', '2021-04-15 12:50:51.172775', NULL),
	(10000097, 1, 'PW21A-GL100065BL-L', 0, 0, '2021-04-15 12:50:51.173458', '2021-04-15 12:50:51.173458', NULL),
	(10000098, 1, 'PW21A-GL100065BL-XL', 0, 0, '2021-04-15 12:50:51.174156', '2021-04-15 12:50:51.174156', NULL),
	(10000099, 1, 'PW21A-GL100066YW -S', 1, 0, '2021-04-15 12:50:51.174840', '2021-04-15 12:50:51.174840', NULL),
	(10000100, 1, 'PW21A-GL100066YW -M', 7, 0, '2021-04-15 12:50:51.175840', '2021-04-15 12:50:51.175840', NULL),
	(10000101, 1, 'PW21A-GL100066YW -L', 5, 0, '2021-04-15 12:50:51.206394', '2021-04-15 12:50:51.206394', NULL),
	(10000102, 1, 'PW21A-GL100066YW -XL', 0, 0, '2021-04-15 12:50:51.207383', '2021-04-15 12:50:51.207383', NULL),
	(10000103, 1, 'PW21A-GL100067BW-S', 7, 0, '2021-04-15 12:50:51.207953', '2021-04-15 12:50:51.207953', NULL),
	(10000104, 1, 'PW21A-GL100067BW-M', 5, 0, '2021-04-15 12:50:51.205399', '2021-04-15 12:50:51.205399', NULL),
	(10000105, 1, 'PW21A-GL100067BW-L', 1, 0, '2021-04-15 12:50:51.208567', '2021-04-15 12:50:51.208567', NULL),
	(10000106, 1, 'PW21A-GL100067BW-XL', 1, 0, '2021-04-15 12:50:51.209166', '2021-04-15 12:50:51.209166', NULL),
	(10000107, 1, 'PW21A-HT100068BL-All', 33, 0, '2021-04-15 12:50:51.209874', '2021-04-15 12:50:51.209874', NULL),
	(10000108, 1, 'PW21A-HT100069BL-All', 1, 0, '2021-04-15 12:50:51.210508', '2021-04-15 12:50:51.210508', NULL),
	(10000109, 1, 'PW21A-HT100070BL-All', 1, 0, '2021-04-15 12:50:51.211109', '2021-04-15 12:50:51.211109', NULL),
	(10000110, 1, 'PW21A-HT100071BL-All', 1, 0, '2021-04-15 12:50:51.238731', '2021-04-15 12:50:51.238731', NULL),
	(10000111, 1, 'PW21A-HT100072BL-All', 1, 0, '2021-04-15 12:50:51.237890', '2021-04-15 12:50:51.237890', NULL),
	(10000112, 1, 'PW21A-HT100073BL-All', 0, 0, '2021-04-15 12:50:51.236906', '2021-04-15 12:50:51.236906', NULL),
	(10000113, 1, 'PW21A-HT100074BL-All', 0, 0, '2021-04-15 12:50:51.212510', '2021-04-15 12:50:51.212510', NULL),
	(10000114, 1, 'PW21A-HT100075BL-All', 0, 0, '2021-04-15 12:50:51.237402', '2021-04-15 12:50:51.237402', NULL),
	(10000115, 1, 'PW21A-HT100076BL-All', 3, 0, '2021-04-15 12:50:51.243372', '2021-04-15 12:50:51.243372', NULL),
	(10000116, 1, 'PW21A-HT100077BL-All', 16, 0, '2021-04-15 12:50:51.269549', '2021-04-15 12:50:51.269549', NULL),
	(10000117, 1, 'PW21A-HT100078BL-All', 28, 0, '2021-04-15 12:50:51.270572', '2021-04-15 12:50:51.270572', NULL),
	(10000118, 1, 'PW21A-HT100079AR-All', 40, 0, '2021-04-15 12:50:51.241274', '2021-04-15 12:50:51.241274', NULL),
	(10000119, 1, 'PW21A-HT100080BL-All', 41, 0, '2021-04-15 12:50:51.240732', '2021-04-15 12:50:51.240732', NULL),
	(10000120, 1, 'PW21A-HT100081CM-All', 41, 0, '2021-04-15 12:50:51.240241', '2021-04-15 12:50:51.240241', NULL),
	(10000121, 1, 'PW21A-HT100082DS-All', 49, 0, '2021-04-15 12:50:51.239752', '2021-04-15 12:50:51.239752', NULL),
	(10000122, 1, 'PW21A-HT100083CM-All', 43, 0, '2021-04-15 12:50:51.239230', '2021-04-15 12:50:51.239230', NULL),
	(10000123, 1, 'PW21A-HT100084DS-All', 47, 0, '2021-04-15 12:50:51.272881', '2021-04-15 12:50:51.272881', NULL),
	(10000124, 1, 'PW21A-HT100085MR-All', 51, 0, '2021-04-15 12:50:51.273905', '2021-04-15 12:50:51.273905', NULL),
	(10000125, 1, 'PW21A-HT100086NV-All', 45, 0, '2021-04-15 12:50:51.280201', '2021-04-15 12:50:51.280201', NULL),
	(10000126, 1, 'PW21A-HT100087BL-All', 98, 0, '2021-04-15 12:50:51.309207', '2021-04-15 12:50:51.309207', NULL),
	(10000127, 1, 'PW21A-HT100088NV-All', 0, 0, '2021-04-15 12:50:51.272303', '2021-04-15 12:50:51.272303', NULL),
	(10000128, 1, 'PW21A-HT100089RD-All', 0, 0, '2021-04-15 12:50:51.271751', '2021-04-15 12:50:51.271751', NULL),
	(10000129, 1, 'PW21A-HT100090BL-All', 0, 0, '2021-04-15 12:50:51.271175', '2021-04-15 12:50:51.271175', NULL),
	(10000130, 1, 'PW21A-HT100091RD-All', 0, 0, '2021-04-15 12:50:51.273384', '2021-04-15 12:50:51.273384', NULL),
	(10000131, 1, 'PW21A-JK100092BL-XS', 0, 0, '2021-04-15 12:50:51.274429', '2021-04-15 12:50:51.274429', NULL),
	(10000132, 1, 'PW21A-JK100092BL-S', 1, 0, '2021-04-15 12:50:51.348030', '2021-04-15 12:50:51.348030', NULL),
	(10000133, 1, 'PW21A-JK100092BL-M', 0, 0, '2021-04-15 12:50:51.349722', '2021-04-15 12:50:51.349722', NULL),
	(10000134, 1, 'PW21A-JK100092BL-L', 1, 0, '2021-04-15 12:50:51.350219', '2021-04-15 12:50:51.350219', NULL),
	(10000135, 1, 'PW21A-JK100092BL-XL', 0, 0, '2021-04-15 12:50:51.313785', '2021-04-15 12:50:51.313785', NULL),
	(10000136, 1, 'PW21A-JK100092BL-XXL', 0, 0, '2021-04-15 12:50:51.313139', '2021-04-15 12:50:51.313139', NULL),
	(10000137, 1, 'PW21A-JK100093BL-XS', 0, 0, '2021-04-15 12:50:51.312491', '2021-04-15 12:50:51.312491', NULL),
	(10000138, 1, 'PW21A-JK100093BL-S', 0, 0, '2021-04-15 12:50:51.310586', '2021-04-15 12:50:51.310586', NULL),
	(10000139, 1, 'PW21A-JK100093BL-M', 0, 0, '2021-04-15 12:50:51.307088', '2021-04-15 12:50:51.307088', NULL),
	(10000140, 1, 'PW21A-JK100093BL-L', 0, 0, '2021-04-15 12:50:51.344658', '2021-04-15 12:50:51.344658', NULL),
	(10000141, 1, 'PW21A-JK100093BL-XL', 0, 0, '2021-04-15 12:50:51.343483', '2021-04-15 12:50:51.343483', NULL),
	(10000142, 1, 'PW21A-JK100093BL-XXL', 0, 0, '2021-04-15 12:50:51.340827', '2021-04-15 12:50:51.340827', NULL),
	(10000143, 1, 'PW21A-JK100094GY-XS', 0, 0, '2021-04-15 12:50:51.318399', '2021-04-15 12:50:51.318399', NULL),
	(10000144, 1, 'PW21A-JK100094GY-S', 19, 0, '2021-04-15 12:50:51.316897', '2021-04-15 12:50:51.316897', NULL),
	(10000145, 1, 'PW21A-JK100094GY-M', 12, 0, '2021-04-15 12:50:51.316274', '2021-04-15 12:50:51.316274', NULL),
	(10000146, 1, 'PW21A-JK100094GY-L', 21, 0, '2021-04-15 12:50:51.314427', '2021-04-15 12:50:51.314427', NULL),
	(10000147, 1, 'PW21A-JK100094GY-XL', 9, 0, '2021-04-15 12:50:51.347505', '2021-04-15 12:50:51.347505', NULL),
	(10000148, 1, 'PW21A-JK100094GY-XXL', 4, 0, '2021-04-15 12:50:51.346410', '2021-04-15 12:50:51.346410', NULL),
	(10000149, 1, 'PW21A-JK100095AR-XS', 0, 0, '2021-04-15 12:50:51.348515', '2021-04-15 12:50:51.348515', NULL),
	(10000150, 1, 'PW21A-JK100095AR-S', 0, 0, '2021-04-15 12:50:51.352869', '2021-04-15 12:50:51.352869', NULL),
	(10000151, 1, 'PW21A-JK100095AR-M', 9, 0, '2021-04-15 12:50:51.376603', '2021-04-15 12:50:51.376603', NULL),
	(10000152, 1, 'PW21A-JK100095AR-L', 23, 0, '2021-04-15 12:50:51.380149', '2021-04-15 12:50:51.380149', NULL),
	(10000153, 1, 'PW21A-JK100095AR-XL', 10, 0, '2021-04-15 12:50:51.390334', '2021-04-15 12:50:51.390334', NULL),
	(10000154, 1, 'PW21A-JK100095AR-XXL', 5, 0, '2021-04-15 12:50:51.418880', '2021-04-15 12:50:51.418880', NULL),
	(10000155, 1, 'PW21A-JK100096BL-XS', 0, 0, '2021-04-15 12:50:51.419507', '2021-04-15 12:50:51.419507', NULL),
	(10000156, 1, 'PW21A-JK100096BL-S', 14, 0, '2021-04-15 12:50:51.387912', '2021-04-15 12:50:51.387912', NULL),
	(10000157, 1, 'PW21A-JK100096BL-M', 7, 0, '2021-04-15 12:50:51.387298', '2021-04-15 12:50:51.387298', NULL),
	(10000158, 1, 'PW21A-JK100096BL-L', 23, 0, '2021-04-15 12:50:51.385578', '2021-04-15 12:50:51.385578', NULL),
	(10000159, 1, 'PW21A-JK100096BL-XL', 25, 0, '2021-04-15 12:50:51.384956', '2021-04-15 12:50:51.384956', NULL),
	(10000160, 1, 'PW21A-JK100096BL-XXL', 11, 0, '2021-04-15 12:50:51.383363', '2021-04-15 12:50:51.383363', NULL),
	(10000161, 1, 'PW21A-JK100097WT-XS', 12, 0, '2021-04-15 12:50:51.381357', '2021-04-15 12:50:51.381357', NULL),
	(10000162, 1, 'PW21A-JK100097WT-S', 48, 0, '2021-04-15 12:50:51.409488', '2021-04-15 12:50:51.409488', NULL),
	(10000163, 1, 'PW21A-JK100097WT-M', 50, 0, '2021-04-15 12:50:51.413072', '2021-04-15 12:50:51.413072', NULL),
	(10000164, 1, 'PW21A-JK100097WT-L', 60, 0, '2021-04-15 12:50:51.390928', '2021-04-15 12:50:51.390928', NULL),
	(10000165, 1, 'PW21A-JK100097WT-XL', 41, 0, '2021-04-15 12:50:51.416589', '2021-04-15 12:50:51.416589', NULL),
	(10000166, 1, 'PW21A-JK100097WT-XXL', 19, 0, '2021-04-15 12:50:51.420098', '2021-04-15 12:50:51.420098', NULL),
	(10000167, 1, 'PW21A-JK100098BL-XS', 0, 0, '2021-04-15 12:50:51.421492', '2021-04-15 12:50:51.421492', NULL),
	(10000168, 1, 'PW21A-JK100098BL-S', 1, 0, '2021-04-15 12:50:51.422896', '2021-04-15 12:50:51.422896', NULL),
	(10000169, 1, 'PW21A-JK100098BL-M', 7, 0, '2021-04-15 12:50:51.424336', '2021-04-15 12:50:51.424336', NULL),
	(10000170, 1, 'PW21A-JK100098BL-L', 14, 0, '2021-04-15 12:50:51.425860', '2021-04-15 12:50:51.425860', NULL),
	(10000171, 1, 'PW21A-JK100098BL-XL', 1, 0, '2021-04-15 12:50:51.450166', '2021-04-15 12:50:51.450166', NULL),
	(10000172, 1, 'PW21A-JK100098BL-XXL', 3, 0, '2021-04-15 12:50:51.452960', '2021-04-15 12:50:51.452960', NULL),
	(10000173, 1, 'PW21A-JK100099BL-XS', 0, 0, '2021-04-15 12:50:51.457551', '2021-04-15 12:50:51.457551', NULL),
	(10000174, 1, 'PW21A-JK100099BL-S', 4, 0, '2021-04-15 12:50:51.461550', '2021-04-15 12:50:51.461550', NULL),
	(10000175, 1, 'PW21A-JK100099BL-M', 1, 0, '2021-04-15 12:50:51.462166', '2021-04-15 12:50:51.462166', NULL),
	(10000176, 1, 'PW21A-JK100099BL-L', 1, 0, '2021-04-15 12:50:51.464254', '2021-04-15 12:50:51.464254', NULL),
	(10000177, 1, 'PW21A-JK100099BL-XL', 1, 0, '2021-04-15 12:50:51.464849', '2021-04-15 12:50:51.464849', NULL),
	(10000178, 1, 'PW21A-JK100099BL-XXL', 3, 0, '2021-04-15 12:50:51.466251', '2021-04-15 12:50:51.466251', NULL),
	(10000179, 1, 'PW21A-JK100100DM-XS', 0, 0, '2021-04-15 12:50:51.466892', '2021-04-15 12:50:51.466892', NULL),
	(10000180, 1, 'PW21A-JK100100DM-S', 2, 0, '2021-04-15 12:50:51.467613', '2021-04-15 12:50:51.467613', NULL),
	(10000181, 1, 'PW21A-JK100100DM-M', 0, 0, '2021-04-15 12:50:51.488610', '2021-04-15 12:50:51.488610', NULL),
	(10000182, 1, 'PW21A-JK100100DM-L', 2, 0, '2021-04-15 12:50:51.489232', '2021-04-15 12:50:51.489232', NULL),
	(10000183, 1, 'PW21A-JK100100DM-XL', 1, 0, '2021-04-15 12:50:51.493157', '2021-04-15 12:50:51.493157', NULL),
	(10000184, 1, 'PW21A-JK100100DM-XXL', 0, 0, '2021-04-15 12:50:51.497030', '2021-04-15 12:50:51.497030', NULL),
	(10000185, 1, 'PW21A-JK100101NV-XS', 0, 0, '2021-04-15 12:50:51.497614', '2021-04-15 12:50:51.497614', NULL),
	(10000186, 1, 'PW21A-JK100101NV-S', 4, 0, '2021-04-15 12:50:51.499088', '2021-04-15 12:50:51.499088', NULL),
	(10000187, 1, 'PW21A-JK100101NV-M', 0, 0, '2021-04-15 12:50:51.499658', '2021-04-15 12:50:51.499658', NULL),
	(10000188, 1, 'PW21A-JK100101NV-L', 0, 0, '2021-04-15 12:50:51.501569', '2021-04-15 12:50:51.501569', NULL),
	(10000189, 1, 'PW21A-JK100101NV-XL', 1, 0, '2021-04-15 12:50:51.502099', '2021-04-15 12:50:51.502099', NULL),
	(10000190, 1, 'PW21A-JK100101NV-XXL', 3, 0, '2021-04-15 12:50:51.502684', '2021-04-15 12:50:51.502684', NULL),
	(10000191, 1, 'PW21A-JK100102BW-XS', 0, 0, '2021-04-15 12:50:51.523149', '2021-04-15 12:50:51.523149', NULL),
	(10000192, 1, 'PW21A-JK100102BW-S', 0, 0, '2021-04-15 12:50:51.524979', '2021-04-15 12:50:51.524979', NULL),
	(10000193, 1, 'PW21A-JK100102BW-M', 0, 0, '2021-04-15 12:50:51.529522', '2021-04-15 12:50:51.529522', NULL),
	(10000194, 1, 'PW21A-JK100102BW-L', 0, 0, '2021-04-15 12:50:51.533689', '2021-04-15 12:50:51.533689', NULL),
	(10000195, 1, 'PW21A-JK100102BW-XL', 7, 0, '2021-04-15 12:50:51.534178', '2021-04-15 12:50:51.534178', NULL),
	(10000196, 1, 'PW21A-JK100102BW-XXL', 1, 0, '2021-04-15 12:50:51.535470', '2021-04-15 12:50:51.535470', NULL),
	(10000197, 1, 'PW21A-JK100103BL-XS', 0, 0, '2021-04-15 12:50:51.536774', '2021-04-15 12:50:51.536774', NULL),
	(10000198, 1, 'PW21A-JK100103BL-S', 0, 0, '2021-04-15 12:50:51.538074', '2021-04-15 12:50:51.538074', NULL),
	(10000199, 1, 'PW21A-JK100103BL-M', 0, 0, '2021-04-15 12:50:51.538706', '2021-04-15 12:50:51.538706', NULL),
	(10000200, 1, 'PW21A-JK100103BL-L', 0, 0, '2021-04-15 12:50:51.542966', '2021-04-15 12:50:51.542966', NULL),
	(10000201, 1, 'PW21A-JK100103BL-XL', 5, 0, '2021-04-15 12:50:51.566205', '2021-04-15 12:50:51.566205', NULL),
	(10000202, 1, 'PW21A-JK100103BL-XXL', 0, 0, '2021-04-15 12:50:51.565700', '2021-04-15 12:50:51.565700', NULL),
	(10000203, 1, 'PW21A-JK100104BL-XS', 0, 0, '2021-04-15 12:50:51.570817', '2021-04-15 12:50:51.570817', NULL),
	(10000204, 1, 'PW21A-JK100104BL-S', 8, 0, '2021-04-15 12:50:51.574138', '2021-04-15 12:50:51.574138', NULL),
	(10000205, 1, 'PW21A-JK100104BL-M', 12, 0, '2021-04-15 12:50:51.576059', '2021-04-15 12:50:51.576059', NULL),
	(10000206, 1, 'PW21A-JK100104BL-L', 7, 0, '2021-04-15 12:50:51.578143', '2021-04-15 12:50:51.578143', NULL),
	(10000207, 1, 'PW21A-JK100104BL-XL', 4, 0, '2021-04-15 12:50:51.579935', '2021-04-15 12:50:51.579935', NULL),
	(10000208, 1, 'PW21A-JK100104BL-XXL', 0, 0, '2021-04-15 12:50:51.580453', '2021-04-15 12:50:51.580453', NULL),
	(10000209, 1, 'PW21A-JK100105TC-XS', 0, 0, '2021-04-15 12:50:51.581111', '2021-04-15 12:50:51.581111', NULL),
	(10000210, 1, 'PW21A-JK100105TC-S', 1, 0, '2021-04-15 12:50:51.576775', '2021-04-15 12:50:51.576775', NULL),
	(10000211, 1, 'PW21A-JK100105TC-M', 0, 0, '2021-04-15 12:50:51.598808', '2021-04-15 12:50:51.598808', NULL),
	(10000212, 1, 'PW21A-JK100105TC-L', 0, 0, '2021-04-15 12:50:51.601044', '2021-04-15 12:50:51.601044', NULL),
	(10000213, 1, 'PW21A-JK100105TC-XL', 0, 0, '2021-04-15 12:50:51.604391', '2021-04-15 12:50:51.604391', NULL),
	(10000214, 1, 'PW21A-JK100105TC-XXL', 0, 0, '2021-04-15 12:50:51.608408', '2021-04-15 12:50:51.608408', NULL),
	(10000215, 1, 'PW21A-JK100106BL-XS', 0, 0, '2021-04-15 12:50:51.608790', '2021-04-15 12:50:51.608790', NULL),
	(10000216, 1, 'PW21A-JK100106BL-S', 9, 0, '2021-04-15 12:50:51.610180', '2021-04-15 12:50:51.610180', NULL),
	(10000217, 1, 'PW21A-JK100106BL-M', 4, 0, '2021-04-15 12:50:51.606109', '2021-04-15 12:50:51.606109', NULL),
	(10000218, 1, 'PW21A-JK100106BL-L', 16, 0, '2021-04-15 12:50:51.611101', '2021-04-15 12:50:51.611101', NULL),
	(10000219, 1, 'PW21A-JK100106BL-XL', 7, 0, '2021-04-15 12:50:51.616333', '2021-04-15 12:50:51.616333', NULL),
	(10000220, 1, 'PW21A-JK100106BL-XXL', 0, 0, '2021-04-15 12:50:51.616765', '2021-04-15 12:50:51.616765', NULL),
	(10000221, 1, 'PW21A-JK100107BL-XS', 0, 0, '2021-04-15 12:50:51.627820', '2021-04-15 12:50:51.627820', NULL),
	(10000222, 1, 'PW21A-JK100107BL-S', 0, 0, '2021-04-15 12:50:51.630620', '2021-04-15 12:50:51.630620', NULL),
	(10000223, 1, 'PW21A-JK100107BL-M', 0, 0, '2021-04-15 12:50:51.633985', '2021-04-15 12:50:51.633985', NULL),
	(10000224, 1, 'PW21A-JK100107BL-L', 0, 0, '2021-04-15 12:50:51.634844', '2021-04-15 12:50:51.634844', NULL),
	(10000225, 1, 'PW21A-JK100107BL-XL', 3, 0, '2021-04-15 12:50:51.636675', '2021-04-15 12:50:51.636675', NULL),
	(10000226, 1, 'PW21A-JK100107BL-XXL', 1, 0, '2021-04-15 12:50:51.637032', '2021-04-15 12:50:51.637032', NULL),
	(10000227, 1, 'PW21A-JK100108BL-XS', 0, 0, '2021-04-15 12:50:51.637363', '2021-04-15 12:50:51.637363', NULL),
	(10000228, 1, 'PW21A-JK100108BL-S', 26, 0, '2021-04-15 12:50:51.640916', '2021-04-15 12:50:51.640916', NULL),
	(10000229, 1, 'PW21A-JK100108BL-M', 12, 0, '2021-04-15 12:50:51.641450', '2021-04-15 12:50:51.641450', NULL),
	(10000230, 1, 'PW21A-JK100108BL-L', 26, 0, '2021-04-15 12:50:51.654096', '2021-04-15 12:50:51.654096', NULL),
	(10000231, 1, 'PW21A-JK100108BL-XL', 7, 0, '2021-04-15 12:50:51.631227', '2021-04-15 12:50:51.631227', NULL),
	(10000232, 1, 'PW21A-JK100108BL-XXL', 0, 0, '2021-04-15 12:50:51.657109', '2021-04-15 12:50:51.657109', NULL),
	(10000233, 1, 'PW21A-JK100109BL-XS', 0, 0, '2021-04-15 12:50:51.657477', '2021-04-15 12:50:51.657477', NULL),
	(10000234, 1, 'PW21A-JK100109BL-S', 2, 0, '2021-04-15 12:50:51.657856', '2021-04-15 12:50:51.657856', NULL),
	(10000235, 1, 'PW21A-JK100109BL-M', 0, 0, '2021-04-15 12:50:51.660757', '2021-04-15 12:50:51.660757', NULL),
	(10000236, 1, 'PW21A-JK100109BL-L', 1, 0, '2021-04-15 12:50:51.662948', '2021-04-15 12:50:51.662948', NULL),
	(10000237, 1, 'PW21A-JK100109BL-XL', 2, 0, '2021-04-15 12:50:51.663748', '2021-04-15 12:50:51.663748', NULL),
	(10000238, 1, 'PW21A-JK100109BL-XXL', 1, 0, '2021-04-15 12:50:51.664075', '2021-04-15 12:50:51.664075', NULL),
	(10000239, 1, 'PW21A-JK100110BL-XS', 20, 0, '2021-04-15 12:50:51.666747', '2021-04-15 12:50:51.666747', NULL),
	(10000240, 1, 'PW21A-JK100110BL-S', 41, 0, '2021-04-15 12:50:51.667266', '2021-04-15 12:50:51.667266', NULL),
	(10000241, 1, 'PW21A-JK100110BL-M', 47, 0, '2021-04-15 12:50:51.678149', '2021-04-15 12:50:51.678149', NULL),
	(10000242, 1, 'PW21A-JK100110BL-L', 57, 0, '2021-04-15 12:50:51.678651', '2021-04-15 12:50:51.678651', NULL),
	(10000243, 1, 'PW21A-JK100110BL-XL', 31, 0, '2021-04-15 12:50:51.681496', '2021-04-15 12:50:51.681496', NULL),
	(10000244, 1, 'PW21A-JK100110BL-XXL', 20, 0, '2021-04-15 12:50:51.683738', '2021-04-15 12:50:51.683738', NULL),
	(10000245, 1, 'PW21A-JK100111BL-XS', 0, 0, '2021-04-15 12:50:51.686041', '2021-04-15 12:50:51.686041', NULL),
	(10000246, 1, 'PW21A-JK100111BL-S', 0, 0, '2021-04-15 12:50:51.686882', '2021-04-15 12:50:51.686882', NULL),
	(10000247, 1, 'PW21A-JK100111BL-M', 0, 0, '2021-04-15 12:50:51.690263', '2021-04-15 12:50:51.690263', NULL),
	(10000248, 1, 'PW21A-JK100111BL-L', 7, 0, '2021-04-15 12:50:51.691128', '2021-04-15 12:50:51.691128', NULL),
	(10000249, 1, 'PW21A-JK100111BL-XL', 0, 0, '2021-04-15 12:50:51.688250', '2021-04-15 12:50:51.688250', NULL),
	(10000250, 1, 'PW21A-JK100111BL-XXL', 1, 0, '2021-04-15 12:50:51.694810', '2021-04-15 12:50:51.694810', NULL),
	(10000251, 1, 'PW21A-JK100112CM-XS', 0, 0, '2021-04-15 12:50:51.708386', '2021-04-15 12:50:51.708386', NULL),
	(10000252, 1, 'PW21A-JK100112CM-S', 32, 0, '2021-04-15 12:50:51.710492', '2021-04-15 12:50:51.710492', NULL),
	(10000253, 1, 'PW21A-JK100112CM-M', 41, 0, '2021-04-15 12:50:51.711862', '2021-04-15 12:50:51.711862', NULL),
	(10000254, 1, 'PW21A-JK100112CM-L', 43, 0, '2021-04-15 12:50:51.713182', '2021-04-15 12:50:51.713182', NULL),
	(10000255, 1, 'PW21A-JK100112CM-XL', 21, 0, '2021-04-15 12:50:51.714329', '2021-04-15 12:50:51.714329', NULL),
	(10000256, 1, 'PW21A-JK100112CM-XXL', 12, 0, '2021-04-15 12:50:51.715435', '2021-04-15 12:50:51.715435', NULL),
	(10000257, 1, 'PW21A-JK100113CM-XS', 0, 0, '2021-04-15 12:50:51.716528', '2021-04-15 12:50:51.716528', NULL),
	(10000258, 1, 'PW21A-JK100113CM-S', 31, 0, '2021-04-15 12:50:51.717897', '2021-04-15 12:50:51.717897', NULL),
	(10000259, 1, 'PW21A-JK100113CM-M', 39, 0, '2021-04-15 12:50:51.719331', '2021-04-15 12:50:51.719331', NULL),
	(10000260, 1, 'PW21A-JK100113CM-L', 39, 0, '2021-04-15 12:50:51.720884', '2021-04-15 12:50:51.720884', NULL),
	(10000261, 1, 'PW21A-JK100113CM-XL', 21, 0, '2021-04-15 12:50:51.738691', '2021-04-15 12:50:51.738691', NULL),
	(10000262, 1, 'PW21A-JK100113CM-XXL', 11, 0, '2021-04-15 12:50:51.740305', '2021-04-15 12:50:51.740305', NULL),
	(10000263, 1, 'PW21A-JK100114CM-XS', 0, 0, '2021-04-15 12:50:51.742175', '2021-04-15 12:50:51.742175', NULL),
	(10000264, 1, 'PW21A-JK100114CM-S', 18, 0, '2021-04-15 12:50:51.742733', '2021-04-15 12:50:51.742733', NULL),
	(10000265, 1, 'PW21A-JK100114CM-M', 12, 0, '2021-04-15 12:50:51.743805', '2021-04-15 12:50:51.743805', NULL),
	(10000266, 1, 'PW21A-JK100114CM-L', 15, 0, '2021-04-15 12:50:51.745033', '2021-04-15 12:50:51.745033', NULL),
	(10000267, 1, 'PW21A-JK100114CM-XL', 12, 0, '2021-04-15 12:50:51.745834', '2021-04-15 12:50:51.745834', NULL),
	(10000268, 1, 'PW21A-JK100114CM-XXL', 3, 0, '2021-04-15 12:50:51.747082', '2021-04-15 12:50:51.747082', NULL),
	(10000269, 1, 'PW21A-JK100115DM-XS', 0, 0, '2021-04-15 12:50:51.748465', '2021-04-15 12:50:51.748465', NULL),
	(10000270, 1, 'PW21A-JK100115DM-S', 3, 0, '2021-04-15 12:50:51.748824', '2021-04-15 12:50:51.748824', NULL),
	(10000271, 1, 'PW21A-JK100115DM-M', 2, 0, '2021-04-15 12:50:51.760423', '2021-04-15 12:50:51.760423', NULL),
	(10000272, 1, 'PW21A-JK100115DM-L', 1, 0, '2021-04-15 12:50:51.762980', '2021-04-15 12:50:51.762980', NULL),
	(10000273, 1, 'PW21A-JK100115DM-XL', 1, 0, '2021-04-15 12:50:51.764190', '2021-04-15 12:50:51.764190', NULL),
	(10000274, 1, 'PW21A-JK100115DM-XXL', 0, 0, '2021-04-15 12:50:51.765006', '2021-04-15 12:50:51.765006', NULL),
	(10000275, 1, 'PW21A-JK100116RD-XS', 0, 0, '2021-04-15 12:50:51.765603', '2021-04-15 12:50:51.765603', NULL),
	(10000276, 1, 'PW21A-JK100116RD-S', 0, 0, '2021-04-15 12:50:51.766877', '2021-04-15 12:50:51.766877', NULL),
	(10000277, 1, 'PW21A-JK100116RD-M', 0, 0, '2021-04-15 12:50:51.768863', '2021-04-15 12:50:51.768863', NULL),
	(10000278, 1, 'PW21A-JK100116RD-L', 0, 0, '2021-04-15 12:50:51.769674', '2021-04-15 12:50:51.769674', NULL),
	(10000279, 1, 'PW21A-JK100116RD-XL', 0, 0, '2021-04-15 12:50:51.770007', '2021-04-15 12:50:51.770007', NULL),
	(10000280, 1, 'PW21A-JK100116RD-XXL', 0, 0, '2021-04-15 12:50:51.771296', '2021-04-15 12:50:51.771296', NULL),
	(10000281, 1, 'PW21A-JK100117BL-XS', 0, 0, '2021-04-15 12:50:51.783196', '2021-04-15 12:50:51.783196', NULL),
	(10000282, 1, 'PW21A-JK100117BL-S', 0, 0, '2021-04-15 12:50:51.787015', '2021-04-15 12:50:51.787015', NULL),
	(10000283, 1, 'PW21A-JK100117BL-M', 0, 0, '2021-04-15 12:50:51.787439', '2021-04-15 12:50:51.787439', NULL),
	(10000284, 1, 'PW21A-JK100117BL-L', 0, 0, '2021-04-15 12:50:51.787894', '2021-04-15 12:50:51.787894', NULL),
	(10000285, 1, 'PW21A-JK100117BL-XL', 2, 0, '2021-04-15 12:50:51.790637', '2021-04-15 12:50:51.790637', NULL),
	(10000286, 1, 'PW21A-JK100117BL-XXL', 0, 0, '2021-04-15 12:50:51.791393', '2021-04-15 12:50:51.791393', NULL),
	(10000287, 1, 'PW21A-JK100118AR-XS', 0, 0, '2021-04-15 12:50:51.795003', '2021-04-15 12:50:51.795003', NULL),
	(10000288, 1, 'PW21A-JK100118AR-S', 16, 0, '2021-04-15 12:50:51.796319', '2021-04-15 12:50:51.796319', NULL),
	(10000289, 1, 'PW21A-JK100118AR-M', 16, 0, '2021-04-15 12:50:51.796684', '2021-04-15 12:50:51.796684', NULL),
	(10000290, 1, 'PW21A-JK100118AR-L', 12, 0, '2021-04-15 12:50:51.798494', '2021-04-15 12:50:51.798494', NULL),
	(10000291, 1, 'PW21A-JK100118AR-XL', 9, 0, '2021-04-15 12:50:51.812386', '2021-04-15 12:50:51.812386', NULL),
	(10000292, 1, 'PW21A-JK100118AR-XXL', 7, 0, '2021-04-15 12:50:51.816870', '2021-04-15 12:50:51.816870', NULL),
	(10000293, 1, 'PW21A-JK100119BL-XS', 0, 0, '2021-04-15 12:50:51.826120', '2021-04-15 12:50:51.826120', NULL),
	(10000294, 1, 'PW21A-JK100119BL-S', 19, 0, '2021-04-15 12:50:51.814989', '2021-04-15 12:50:51.814989', NULL),
	(10000295, 1, 'PW21A-JK100119BL-M', 21, 0, '2021-04-15 12:50:51.826969', '2021-04-15 12:50:51.826969', NULL),
	(10000296, 1, 'PW21A-JK100119BL-L', 27, 0, '2021-04-15 12:50:51.829367', '2021-04-15 12:50:51.829367', NULL),
	(10000297, 1, 'PW21A-JK100119BL-XL', 19, 0, '2021-04-15 12:50:51.833260', '2021-04-15 12:50:51.833260', NULL),
	(10000298, 1, 'PW21A-JK100119BL-XXL', 11, 0, '2021-04-15 12:50:51.835280', '2021-04-15 12:50:51.835280', NULL),
	(10000299, 1, 'PW21A-JK100120BL-XS', 4, 0, '2021-04-15 12:50:51.836596', '2021-04-15 12:50:51.836596', NULL),
	(10000300, 1, 'PW21A-JK100120BL-S', 13, 0, '2021-04-15 12:50:51.837306', '2021-04-15 12:50:51.837306', NULL),
	(10000301, 1, 'PW21A-JK100120BL-M', 18, 0, '2021-04-15 12:50:51.857672', '2021-04-15 12:50:51.857672', NULL),
	(10000302, 1, 'PW21A-JK100120BL-L', 30, 0, '2021-04-15 12:50:51.862002', '2021-04-15 12:50:51.862002', NULL),
	(10000303, 1, 'PW21A-JK100120BL-XL', 14, 0, '2021-04-15 12:50:51.864711', '2021-04-15 12:50:51.864711', NULL),
	(10000304, 1, 'PW21A-JK100120BL-XXL', 9, 0, '2021-04-15 12:50:51.865200', '2021-04-15 12:50:51.865200', NULL),
	(10000305, 1, 'PW21A-JK100121MR-XS', 0, 0, '2021-04-15 12:50:51.866362', '2021-04-15 12:50:51.866362', NULL),
	(10000306, 1, 'PW21A-JK100121MR-S', 28, 0, '2021-04-15 12:50:51.867202', '2021-04-15 12:50:51.867202', NULL),
	(10000307, 1, 'PW21A-JK100121MR-M', 31, 0, '2021-04-15 12:50:51.874425', '2021-04-15 12:50:51.874425', NULL),
	(10000308, 1, 'PW21A-JK100121MR-L', 39, 0, '2021-04-15 12:50:51.875811', '2021-04-15 12:50:51.875811', NULL),
	(10000309, 1, 'PW21A-JK100121MR-XL', 23, 0, '2021-04-15 12:50:51.880549', '2021-04-15 12:50:51.880549', NULL),
	(10000310, 1, 'PW21A-JK100121MR-XXL', 10, 0, '2021-04-15 12:50:51.882893', '2021-04-15 12:50:51.882893', NULL),
	(10000311, 1, 'PW21A-JK100122RD-XS', 0, 0, '2021-04-15 12:50:51.892295', '2021-04-15 12:50:51.892295', NULL),
	(10000312, 1, 'PW21A-JK100122RD-S', 0, 0, '2021-04-15 12:50:51.911959', '2021-04-15 12:50:51.911959', NULL),
	(10000313, 1, 'PW21A-JK100122RD-M', 0, 0, '2021-04-15 12:50:51.911567', '2021-04-15 12:50:51.911567', NULL),
	(10000314, 1, 'PW21A-JK100122RD-L', 0, 0, '2021-04-15 12:50:51.912316', '2021-04-15 12:50:51.912316', NULL),
	(10000315, 1, 'PW21A-JK100122RD-XL', 0, 0, '2021-04-15 12:50:51.913200', '2021-04-15 12:50:51.913200', NULL),
	(10000316, 1, 'PW21A-JK100122RD-XXL', 0, 0, '2021-04-15 12:50:51.914356', '2021-04-15 12:50:51.914356', NULL),
	(10000317, 1, 'PW21A-JK100123BL-XS', 0, 0, '2021-04-15 12:50:51.912674', '2021-04-15 12:50:51.912674', NULL),
	(10000318, 1, 'PW21A-JK100123BL-S', 19, 0, '2021-04-15 12:50:51.913586', '2021-04-15 12:50:51.913586', NULL),
	(10000319, 1, 'PW21A-JK100123BL-M', 17, 0, '2021-04-15 12:50:51.924842', '2021-04-15 12:50:51.924842', NULL),
	(10000320, 1, 'PW21A-JK100123BL-L', 18, 0, '2021-04-15 12:50:51.926090', '2021-04-15 12:50:51.926090', NULL),
	(10000321, 1, 'PW21A-JK100123BL-XL', 18, 0, '2021-04-15 12:50:51.927519', '2021-04-15 12:50:51.927519', NULL),
	(10000322, 1, 'PW21A-JK100123BL-XXL', 2, 0, '2021-04-15 12:50:51.929763', '2021-04-15 12:50:51.929763', NULL),
	(10000323, 1, 'PW21A-JK100124BL-XS', 0, 0, '2021-04-15 12:50:51.933214', '2021-04-15 12:50:51.933214', NULL),
	(10000324, 1, 'PW21A-JK100124BL-S', 16, 0, '2021-04-15 12:50:51.934895', '2021-04-15 12:50:51.934895', NULL),
	(10000325, 1, 'PW21A-JK100124BL-M', 20, 0, '2021-04-15 12:50:51.935799', '2021-04-15 12:50:51.935799', NULL),
	(10000326, 1, 'PW21A-JK100124BL-L', 30, 0, '2021-04-15 12:50:51.936269', '2021-04-15 12:50:51.936269', NULL),
	(10000327, 1, 'PW21A-JK100124BL-XL', 20, 0, '2021-04-15 12:50:51.938227', '2021-04-15 12:50:51.938227', NULL),
	(10000328, 1, 'PW21A-JK100124BL-XXL', 6, 0, '2021-04-15 12:50:51.938756', '2021-04-15 12:50:51.938756', NULL),
	(10000329, 1, 'PW21A-JK100125AR-XS', 0, 0, '2021-04-15 12:50:51.948735', '2021-04-15 12:50:51.948735', NULL),
	(10000330, 1, 'PW21A-JK100125AR-S', 11, 0, '2021-04-15 12:50:51.949234', '2021-04-15 12:50:51.949234', NULL),
	(10000331, 1, 'PW21A-JK100125AR-M', 20, 0, '2021-04-15 12:50:51.950641', '2021-04-15 12:50:51.950641', NULL),
	(10000332, 1, 'PW21A-JK100125AR-L', 23, 0, '2021-04-15 12:50:51.955517', '2021-04-15 12:50:51.955517', NULL),
	(10000333, 1, 'PW21A-JK100125AR-XL', 10, 0, '2021-04-15 12:50:51.957380', '2021-04-15 12:50:51.957380', NULL),
	(10000334, 1, 'PW21A-JK100125AR-XXL', 3, 0, '2021-04-15 12:50:51.959764', '2021-04-15 12:50:51.959764', NULL),
	(10000335, 1, 'PW21A-JK100126BL-XS', 0, 0, '2021-04-15 12:50:51.960168', '2021-04-15 12:50:51.960168', NULL),
	(10000336, 1, 'PW21A-JK100126BL-S', 1, 0, '2021-04-15 12:50:51.961717', '2021-04-15 12:50:51.961717', NULL),
	(10000337, 1, 'PW21A-JK100126BL-M', 1, 0, '2021-04-15 12:50:51.962063', '2021-04-15 12:50:51.962063', NULL),
	(10000338, 1, 'PW21A-JK100126BL-L', 1, 0, '2021-04-15 12:50:51.950305', '2021-04-15 12:50:51.950305', NULL),
	(10000339, 1, 'PW21A-JK100126BL-XL', 2, 0, '2021-04-15 12:50:51.968751', '2021-04-15 12:50:51.968751', NULL),
	(10000340, 1, 'PW21A-JK100126BL-XXL', 1, 0, '2021-04-15 12:50:51.975030', '2021-04-15 12:50:51.975030', NULL),
	(10000341, 1, 'PW21A-JK100127BL-XS', 0, 0, '2021-04-15 12:50:51.976749', '2021-04-15 12:50:51.976749', NULL),
	(10000342, 1, 'PW21A-JK100127BL-S', 2, 0, '2021-04-15 12:50:51.978627', '2021-04-15 12:50:51.978627', NULL),
	(10000343, 1, 'PW21A-JK100127BL-M', 1, 0, '2021-04-15 12:50:51.984428', '2021-04-15 12:50:51.984428', NULL),
	(10000344, 1, 'PW21A-JK100127BL-L', 2, 0, '2021-04-15 12:50:51.986032', '2021-04-15 12:50:51.986032', NULL),
	(10000345, 1, 'PW21A-JK100127BL-XL', 3, 0, '2021-04-15 12:50:51.983941', '2021-04-15 12:50:51.983941', NULL),
	(10000346, 1, 'PW21A-JK100127BL-XXL', 1, 0, '2021-04-15 12:50:51.990567', '2021-04-15 12:50:51.990567', NULL),
	(10000347, 1, 'PW21A-JK100128BL-XS', 0, 0, '2021-04-15 12:50:51.991117', '2021-04-15 12:50:51.991117', NULL),
	(10000348, 1, 'PW21A-JK100128BL-S', 2, 0, '2021-04-15 12:50:51.991986', '2021-04-15 12:50:51.991986', NULL),
	(10000349, 1, 'PW21A-JK100128BL-M', 1, 0, '2021-04-15 12:50:51.999801', '2021-04-15 12:50:51.999801', NULL),
	(10000350, 1, 'PW21A-JK100128BL-L', 2, 0, '2021-04-15 12:50:52.006925', '2021-04-15 12:50:52.006925', NULL),
	(10000351, 1, 'PW21A-JK100128BL-XL', 1, 0, '2021-04-15 12:50:52.007506', '2021-04-15 12:50:52.007506', NULL),
	(10000352, 1, 'PW21A-JK100128BL-XXL', 1, 0, '2021-04-15 12:50:52.009370', '2021-04-15 12:50:52.009370', NULL),
	(10000353, 1, 'PW21A-JK100129YW -XS', 0, 0, '2021-04-15 12:50:52.012734', '2021-04-15 12:50:52.012734', NULL),
	(10000354, 1, 'PW21A-JK100129YW -S', 0, 0, '2021-04-15 12:50:52.013182', '2021-04-15 12:50:52.013182', NULL),
	(10000355, 1, 'PW21A-JK100129YW -M', 0, 0, '2021-04-15 12:50:52.012278', '2021-04-15 12:50:52.012278', NULL),
	(10000356, 1, 'PW21A-JK100129YW -L', 0, 0, '2021-04-15 12:50:52.029659', '2021-04-15 12:50:52.029659', NULL),
	(10000357, 1, 'PW21A-JK100129YW -XL', 0, 0, '2021-04-15 12:50:52.030976', '2021-04-15 12:50:52.030976', NULL),
	(10000358, 1, 'PW21A-JK100129YW -XXL', 0, 0, '2021-04-15 12:50:52.034900', '2021-04-15 12:50:52.034900', NULL),
	(10000359, 1, 'PW21A-JK100130YW -XS', 18, 0, '2021-04-15 12:50:52.037154', '2021-04-15 12:50:52.037154', NULL),
	(10000360, 1, 'PW21A-JK100130YW -S', 43, 0, '2021-04-15 12:50:52.041377', '2021-04-15 12:50:52.041377', NULL),
	(10000361, 1, 'PW21A-JK100130YW -M', 46, 0, '2021-04-15 12:50:52.043102', '2021-04-15 12:50:52.043102', NULL),
	(10000362, 1, 'PW21A-JK100130YW -L', 52, 0, '2021-04-15 12:50:52.045089', '2021-04-15 12:50:52.045089', NULL),
	(10000363, 1, 'PW21A-JK100130YW -XL', 38, 0, '2021-04-15 12:50:52.046797', '2021-04-15 12:50:52.046797', NULL),
	(10000364, 1, 'PW21A-JK100130YW -XXL', 20, 0, '2021-04-15 12:50:52.048458', '2021-04-15 12:50:52.048458', NULL),
	(10000365, 1, 'PW21A-JK100131YW -XS', 0, 0, '2021-04-15 12:50:52.048825', '2021-04-15 12:50:52.048825', NULL),
	(10000366, 1, 'PW21A-JK100131YW -S', 0, 0, '2021-04-15 12:50:52.054829', '2021-04-15 12:50:52.054829', NULL),
	(10000367, 1, 'PW21A-JK100131YW -M', 0, 0, '2021-04-15 12:50:52.056756', '2021-04-15 12:50:52.056756', NULL),
	(10000368, 1, 'PW21A-JK100131YW -L', 0, 0, '2021-04-15 12:50:52.059299', '2021-04-15 12:50:52.059299', NULL),
	(10000369, 1, 'PW21A-JK100131YW -XL', 0, 0, '2021-04-15 12:50:52.060820', '2021-04-15 12:50:52.060820', NULL),
	(10000370, 1, 'PW21A-JK100131YW -XXL', 0, 0, '2021-04-15 12:50:52.065023', '2021-04-15 12:50:52.065023', NULL),
	(10000371, 1, 'PW21A-JK100132BL-XS', 0, 0, '2021-04-15 12:50:52.067469', '2021-04-15 12:50:52.067469', NULL),
	(10000372, 1, 'PW21A-JK100132BL-S', 3, 0, '2021-04-15 12:50:52.070655', '2021-04-15 12:50:52.070655', NULL),
	(10000373, 1, 'PW21A-JK100132BL-M', 0, 0, '2021-04-15 12:50:52.071055', '2021-04-15 12:50:52.071055', NULL),
	(10000374, 1, 'PW21A-JK100132BL-L', 1, 0, '2021-04-15 12:50:52.072600', '2021-04-15 12:50:52.072600', NULL),
	(10000375, 1, 'PW21A-JK100132BL-XL', 0, 0, '2021-04-15 12:50:52.073594', '2021-04-15 12:50:52.073594', NULL),
	(10000376, 1, 'PW21A-JK100132BL-XXL', 0, 0, '2021-04-15 12:50:52.077895', '2021-04-15 12:50:52.077895', NULL),
	(10000377, 1, 'PW21A-JK100133BL-XS', 0, 0, '2021-04-15 12:50:52.080728', '2021-04-15 12:50:52.080728', NULL),
	(10000378, 1, 'PW21A-JK100133BL-S', 8, 0, '2021-04-15 12:50:52.083608', '2021-04-15 12:50:52.083608', NULL),
	(10000379, 1, 'PW21A-JK100133BL-M', 0, 0, '2021-04-15 12:50:52.083969', '2021-04-15 12:50:52.083969', NULL),
	(10000380, 1, 'PW21A-JK100133BL-L', 0, 0, '2021-04-15 12:50:52.089587', '2021-04-15 12:50:52.089587', NULL),
	(10000381, 1, 'PW21A-JK100133BL-XL', 0, 0, '2021-04-15 12:50:52.095097', '2021-04-15 12:50:52.095097', NULL),
	(10000382, 1, 'PW21A-JK100133BL-XXL', 0, 0, '2021-04-15 12:50:52.099163', '2021-04-15 12:50:52.099163', NULL),
	(10000383, 1, 'PW21A-JK100134OL-XS', 0, 0, '2021-04-15 12:50:52.096279', '2021-04-15 12:50:52.096279', NULL),
	(10000384, 1, 'PW21A-JK100134OL-S', 0, 0, '2021-04-15 12:50:52.102094', '2021-04-15 12:50:52.102094', NULL),
	(10000385, 1, 'PW21A-JK100134OL-M', 0, 0, '2021-04-15 12:50:52.102517', '2021-04-15 12:50:52.102517', NULL),
	(10000386, 1, 'PW21A-JK100134OL-L', 0, 0, '2021-04-15 12:50:52.105117', '2021-04-15 12:50:52.105117', NULL),
	(10000387, 1, 'PW21A-JK100134OL-XL', 0, 0, '2021-04-15 12:50:52.110881', '2021-04-15 12:50:52.110881', NULL),
	(10000388, 1, 'PW21A-JK100134OL-XXL', 0, 0, '2021-04-15 12:50:52.115756', '2021-04-15 12:50:52.115756', NULL),
	(10000389, 1, 'PW21A-JK100135BL-XS', 0, 0, '2021-04-15 12:50:52.120390', '2021-04-15 12:50:52.120390', NULL),
	(10000390, 1, 'PW21A-JK100135BL-S', 0, 0, '2021-04-15 12:50:52.121808', '2021-04-15 12:50:52.121808', NULL),
	(10000391, 1, 'PW21A-JK100135BL-M', 0, 0, '2021-04-15 12:50:52.127066', '2021-04-15 12:50:52.127066', NULL),
	(10000392, 1, 'PW21A-JK100135BL-L', 0, 0, '2021-04-15 12:50:52.127409', '2021-04-15 12:50:52.127409', NULL),
	(10000393, 1, 'PW21A-JK100135BL-XL', 0, 0, '2021-04-15 12:50:52.129364', '2021-04-15 12:50:52.129364', NULL),
	(10000394, 1, 'PW21A-JK100135BL-XXL', 0, 0, '2021-04-15 12:50:52.132797', '2021-04-15 12:50:52.132797', NULL),
	(10000395, 1, 'PW21A-JK100136OL-XS', 0, 0, '2021-04-15 12:50:52.133208', '2021-04-15 12:50:52.133208', NULL),
	(10000396, 1, 'PW21A-JK100136OL-S', 14, 0, '2021-04-15 12:50:52.133660', '2021-04-15 12:50:52.133660', NULL),
	(10000397, 1, 'PW21A-JK100136OL-M', 19, 0, '2021-04-15 12:50:52.142604', '2021-04-15 12:50:52.142604', NULL),
	(10000398, 1, 'PW21A-JK100136OL-L', 17, 0, '2021-04-15 12:50:52.147757', '2021-04-15 12:50:52.147757', NULL),
	(10000399, 1, 'PW21A-JK100136OL-XL', 11, 0, '2021-04-15 12:50:52.150511', '2021-04-15 12:50:52.150511', NULL),
	(10000400, 1, 'PW21A-JK100136OL-XXL', 7, 0, '2021-04-15 12:50:52.159237', '2021-04-15 12:50:52.159237', NULL),
	(10000401, 1, 'PW21A-JK100137BL-XS', 22, 0, '2021-04-15 12:50:52.161463', '2021-04-15 12:50:52.161463', NULL),
	(10000402, 1, 'PW21A-JK100137BL-S', 44, 0, '2021-04-15 12:50:52.162839', '2021-04-15 12:50:52.162839', NULL),
	(10000403, 1, 'PW21A-JK100137BL-M', 54, 0, '2021-04-15 12:50:52.167648', '2021-04-15 12:50:52.167648', NULL),
	(10000404, 1, 'PW21A-JK100137BL-L', 60, 0, '2021-04-15 12:50:52.171072', '2021-04-15 12:50:52.171072', NULL),
	(10000405, 1, 'PW21A-JK100137BL-XL', 39, 0, '2021-04-15 12:50:52.171565', '2021-04-15 12:50:52.171565', NULL),
	(10000406, 1, 'PW21A-JK100137BL-XXL', 24, 0, '2021-04-15 12:50:52.173599', '2021-04-15 12:50:52.173599', NULL),
	(10000407, 1, 'PW21A-JK100138OL-XS', 0, 0, '2021-04-15 12:50:52.181092', '2021-04-15 12:50:52.181092', NULL),
	(10000408, 1, 'PW21A-JK100138OL-S', 4, 0, '2021-04-15 12:50:52.185251', '2021-04-15 12:50:52.185251', NULL),
	(10000409, 1, 'PW21A-JK100138OL-M', 17, 0, '2021-04-15 12:50:52.190996', '2021-04-15 12:50:52.190996', NULL),
	(10000410, 1, 'PW21A-JK100138OL-L', 17, 0, '2021-04-15 12:50:52.194264', '2021-04-15 12:50:52.194264', NULL),
	(10000411, 1, 'PW21A-JK100138OL-XL', 10, 0, '2021-04-15 12:50:52.197645', '2021-04-15 12:50:52.197645', NULL),
	(10000412, 1, 'PW21A-JK100138OL-XXL', 5, 0, '2021-04-15 12:50:52.199302', '2021-04-15 12:50:52.199302', NULL),
	(10000413, 1, 'PW21A-JK100139BL-XS', 0, 0, '2021-04-15 12:50:52.201841', '2021-04-15 12:50:52.201841', NULL),
	(10000414, 1, 'PW21A-JK100139BL-S', 10, 0, '2021-04-15 12:50:52.204723', '2021-04-15 12:50:52.204723', NULL),
	(10000415, 1, 'PW21A-JK100139BL-M', 17, 0, '2021-04-15 12:50:52.207489', '2021-04-15 12:50:52.207489', NULL),
	(10000416, 1, 'PW21A-JK100139BL-L', 18, 0, '2021-04-15 12:50:52.208006', '2021-04-15 12:50:52.208006', NULL),
	(10000417, 1, 'PW21A-JK100139BL-XL', 7, 0, '2021-04-15 12:50:52.216542', '2021-04-15 12:50:52.216542', NULL),
	(10000418, 1, 'PW21A-JK100139BL-XXL', 3, 0, '2021-04-15 12:50:52.220004', '2021-04-15 12:50:52.220004', NULL),
	(10000419, 1, 'PW21A-JK100140OL-XS', 0, 0, '2021-04-15 12:50:52.225306', '2021-04-15 12:50:52.225306', NULL),
	(10000420, 1, 'PW21A-JK100140OL-S', 9, 0, '2021-04-15 12:50:52.226617', '2021-04-15 12:50:52.226617', NULL),
	(10000421, 1, 'PW21A-JK100140OL-M', 14, 0, '2021-04-15 12:50:52.230331', '2021-04-15 12:50:52.230331', NULL),
	(10000422, 1, 'PW21A-JK100140OL-L', 21, 0, '2021-04-15 12:50:52.231472', '2021-04-15 12:50:52.231472', NULL),
	(10000423, 1, 'PW21A-JK100140OL-XL', 6, 0, '2021-04-15 12:50:52.236197', '2021-04-15 12:50:52.236197', NULL),
	(10000424, 1, 'PW21A-JK100140OL-XXL', 3, 0, '2021-04-15 12:50:52.238218', '2021-04-15 12:50:52.238218', NULL),
	(10000425, 1, 'PW21A-JK100141BL-XS', 0, 0, '2021-04-15 12:50:52.242739', '2021-04-15 12:50:52.242739', NULL),
	(10000426, 1, 'PW21A-JK100141BL-S', 0, 0, '2021-04-15 12:50:52.244376', '2021-04-15 12:50:52.244376', NULL),
	(10000427, 1, 'PW21A-JK100141BL-M', 0, 0, '2021-04-15 12:50:52.250548', '2021-04-15 12:50:52.250548', NULL),
	(10000428, 1, 'PW21A-JK100141BL-L', 5, 0, '2021-04-15 12:50:52.252531', '2021-04-15 12:50:52.252531', NULL),
	(10000429, 1, 'PW21A-JK100141BL-XL', 2, 0, '2021-04-15 12:50:52.261372', '2021-04-15 12:50:52.261372', NULL),
	(10000430, 1, 'PW21A-JK100141BL-XXL', 4, 0, '2021-04-15 12:50:52.262236', '2021-04-15 12:50:52.262236', NULL),
	(10000431, 1, 'PW21A-JK100142OL-XS', 0, 0, '2021-04-15 12:50:52.266788', '2021-04-15 12:50:52.266788', NULL),
	(10000432, 1, 'PW21A-JK100142OL-S', 7, 0, '2021-04-15 12:50:52.268189', '2021-04-15 12:50:52.268189', NULL),
	(10000433, 1, 'PW21A-JK100142OL-M', 13, 0, '2021-04-15 12:50:52.271216', '2021-04-15 12:50:52.271216', NULL),
	(10000434, 1, 'PW21A-JK100142OL-L', 19, 0, '2021-04-15 12:50:52.271780', '2021-04-15 12:50:52.271780', NULL),
	(10000435, 1, 'PW21A-JK100142OL-XL', 1, 0, '2021-04-15 12:50:52.275751', '2021-04-15 12:50:52.275751', NULL),
	(10000436, 1, 'PW21A-JK100142OL-XXL', 1, 0, '2021-04-15 12:50:52.277261', '2021-04-15 12:50:52.277261', NULL),
	(10000437, 1, 'PW21A-JK100143BL-XS', 0, 0, '2021-04-15 12:50:52.283529', '2021-04-15 12:50:52.283529', NULL),
	(10000438, 1, 'PW21A-JK100143BL-S', 4, 0, '2021-04-15 12:50:52.288423', '2021-04-15 12:50:52.288423', NULL),
	(10000439, 1, 'PW21A-JK100143BL-M', 9, 0, '2021-04-15 12:50:52.292405', '2021-04-15 12:50:52.292405', NULL),
	(10000440, 1, 'PW21A-JK100143BL-L', 0, 0, '2021-04-15 12:50:52.297860', '2021-04-15 12:50:52.297860', NULL),
	(10000441, 1, 'PW21A-JK100143BL-XL', 0, 0, '2021-04-15 12:50:52.300473', '2021-04-15 12:50:52.300473', NULL),
	(10000442, 1, 'PW21A-JK100143BL-XXL', 0, 0, '2021-04-15 12:50:52.302024', '2021-04-15 12:50:52.302024', NULL),
	(10000443, 1, 'PW21A-JK100144AR-XS', 0, 0, '2021-04-15 12:50:52.305697', '2021-04-15 12:50:52.305697', NULL),
	(10000444, 1, 'PW21A-JK100144AR-S', 3, 0, '2021-04-15 12:50:52.307035', '2021-04-15 12:50:52.307035', NULL),
	(10000445, 1, 'PW21A-JK100144AR-M', 1, 0, '2021-04-15 12:50:52.314074', '2021-04-15 12:50:52.314074', NULL),
	(10000446, 1, 'PW21A-JK100144AR-L', 16, 0, '2021-04-15 12:50:52.315720', '2021-04-15 12:50:52.315720', NULL),
	(10000447, 1, 'PW21A-JK100144AR-XL', 9, 0, '2021-04-15 12:50:52.326567', '2021-04-15 12:50:52.326567', NULL),
	(10000448, 1, 'PW21A-JK100144AR-XXL', 3, 0, '2021-04-15 12:50:52.331205', '2021-04-15 12:50:52.331205', NULL),
	(10000449, 1, 'PW21A-JK100145RD-XS', 0, 0, '2021-04-15 12:50:52.335026', '2021-04-15 12:50:52.335026', NULL),
	(10000450, 1, 'PW21A-JK100145RD-S', 0, 0, '2021-04-15 12:50:52.339093', '2021-04-15 12:50:52.339093', NULL),
	(10000451, 1, 'PW21A-JK100145RD-M', 0, 0, '2021-04-15 12:50:52.346333', '2021-04-15 12:50:52.346333', NULL),
	(10000452, 1, 'PW21A-JK100145RD-L', 1, 0, '2021-04-15 12:50:52.348742', '2021-04-15 12:50:52.348742', NULL),
	(10000453, 1, 'PW21A-JK100145RD-XL', 0, 0, '2021-04-15 12:50:52.353567', '2021-04-15 12:50:52.353567', NULL),
	(10000454, 1, 'PW21A-JK100145RD-XXL', 2, 0, '2021-04-15 12:50:52.354063', '2021-04-15 12:50:52.354063', NULL),
	(10000455, 1, 'PW21A-JK100146BL-XS', 0, 0, '2021-04-15 12:50:52.354580', '2021-04-15 12:50:52.354580', NULL),
	(10000456, 1, 'PW21A-JK100146BL-S', 0, 0, '2021-04-15 12:50:52.357541', '2021-04-15 12:50:52.357541', NULL),
	(10000457, 1, 'PW21A-JK100146BL-M', 3, 0, '2021-04-15 12:50:52.363712', '2021-04-15 12:50:52.363712', NULL),
	(10000458, 1, 'PW21A-JK100146BL-L', 14, 0, '2021-04-15 12:50:52.368345', '2021-04-15 12:50:52.368345', NULL),
	(10000459, 1, 'PW21A-JK100146BL-XL', 4, 0, '2021-04-15 12:50:52.371062', '2021-04-15 12:50:52.371062', NULL),
	(10000460, 1, 'PW21A-JK100146BL-XXL', 0, 0, '2021-04-15 12:50:52.380939', '2021-04-15 12:50:52.380939', NULL),
	(10000461, 1, 'PW21A-JK100147BL-XS', 0, 0, '2021-04-15 12:50:52.382262', '2021-04-15 12:50:52.382262', NULL),
	(10000462, 1, 'PW21A-JK100147BL-S', 1, 0, '2021-04-15 12:50:52.385106', '2021-04-15 12:50:52.385106', NULL),
	(10000463, 1, 'PW21A-JK100147BL-M', 10, 0, '2021-04-15 12:50:52.387511', '2021-04-15 12:50:52.387511', NULL),
	(10000464, 1, 'PW21A-JK100147BL-L', 14, 0, '2021-04-15 12:50:52.387996', '2021-04-15 12:50:52.387996', NULL),
	(10000465, 1, 'PW21A-JK100147BL-XL', 3, 0, '2021-04-15 12:50:52.388474', '2021-04-15 12:50:52.388474', NULL),
	(10000466, 1, 'PW21A-JK100147BL-XXL', 2, 0, '2021-04-15 12:50:52.389355', '2021-04-15 12:50:52.389355', NULL),
	(10000467, 1, 'PW21A-JK100148BL-XS', 0, 0, '2021-04-15 12:50:52.396892', '2021-04-15 12:50:52.396892', NULL),
	(10000468, 1, 'PW21A-JK100148BL-S', 6, 0, '2021-04-15 12:50:52.412223', '2021-04-15 12:50:52.412223', NULL),
	(10000469, 1, 'PW21A-JK100148BL-M', 8, 0, '2021-04-15 12:50:52.415127', '2021-04-15 12:50:52.415127', NULL),
	(10000470, 1, 'PW21A-JK100148BL-L', 19, 0, '2021-04-15 12:50:52.423772', '2021-04-15 12:50:52.423772', NULL),
	(10000471, 1, 'PW21A-JK100148BL-XL', 8, 0, '2021-04-15 12:50:52.424429', '2021-04-15 12:50:52.424429', NULL),
	(10000472, 1, 'PW21A-JK100148BL-XXL', 0, 0, '2021-04-15 12:50:52.428718', '2021-04-15 12:50:52.428718', NULL),
	(10000473, 1, 'PW21A-JK100149BL-XS', 0, 0, '2021-04-15 12:50:52.432595', '2021-04-15 12:50:52.432595', NULL),
	(10000474, 1, 'PW21A-JK100149BL-S', 11, 0, '2021-04-15 12:50:52.429981', '2021-04-15 12:50:52.429981', NULL),
	(10000475, 1, 'PW21A-JK100149BL-M', 17, 0, '2021-04-15 12:50:52.433755', '2021-04-15 12:50:52.433755', NULL),
	(10000476, 1, 'PW21A-JK100149BL-L', 17, 0, '2021-04-15 12:50:52.434308', '2021-04-15 12:50:52.434308', NULL),
	(10000477, 1, 'PW21A-JK100149BL-XL', 9, 0, '2021-04-15 12:50:52.434854', '2021-04-15 12:50:52.434854', NULL),
	(10000478, 1, 'PW21A-JK100149BL-XXL', 5, 0, '2021-04-15 12:50:52.454277', '2021-04-15 12:50:52.454277', NULL),
	(10000479, 1, 'PW21A-JK100150BL-XS', 0, 0, '2021-04-15 12:50:52.455165', '2021-04-15 12:50:52.455165', NULL),
	(10000480, 1, 'PW21A-JK100150BL-S', 12, 0, '2021-04-15 12:50:52.463550', '2021-04-15 12:50:52.463550', NULL),
	(10000481, 1, 'PW21A-JK100150BL-M', 20, 0, '2021-04-15 12:50:52.465025', '2021-04-15 12:50:52.465025', NULL),
	(10000482, 1, 'PW21A-JK100150BL-L', 23, 0, '2021-04-15 12:50:52.467291', '2021-04-15 12:50:52.467291', NULL),
	(10000483, 1, 'PW21A-JK100150BL-XL', 11, 0, '2021-04-15 12:50:52.468544', '2021-04-15 12:50:52.468544', NULL),
	(10000484, 1, 'PW21A-JK100150BL-XXL', 6, 0, '2021-04-15 12:50:52.469062', '2021-04-15 12:50:52.469062', NULL),
	(10000485, 1, 'PW21A-JK100151BL-XS', 0, 0, '2021-04-15 12:50:52.469584', '2021-04-15 12:50:52.469584', NULL),
	(10000486, 1, 'PW21A-JK100151BL-S', 6, 0, '2021-04-15 12:50:52.470852', '2021-04-15 12:50:52.470852', NULL),
	(10000487, 1, 'PW21A-JK100151BL-M', 12, 0, '2021-04-15 12:50:52.471328', '2021-04-15 12:50:52.471328', NULL),
	(10000488, 1, 'PW21A-JK100151BL-L', 16, 0, '2021-04-15 12:50:52.491316', '2021-04-15 12:50:52.491316', NULL),
	(10000489, 1, 'PW21A-JK100151BL-XL', 8, 0, '2021-04-15 12:50:52.494798', '2021-04-15 12:50:52.494798', NULL),
	(10000490, 1, 'PW21A-JK100151BL-XXL', 6, 0, '2021-04-15 12:50:52.503727', '2021-04-15 12:50:52.503727', NULL),
	(10000491, 1, 'PW21A-JK100152BL-XS', 0, 0, '2021-04-15 12:50:52.512784', '2021-04-15 12:50:52.512784', NULL),
	(10000492, 1, 'PW21A-JK100152BL-S', 5, 0, '2021-04-15 12:50:52.514503', '2021-04-15 12:50:52.514503', NULL),
	(10000493, 1, 'PW21A-JK100152BL-M', 16, 0, '2021-04-15 12:50:52.516539', '2021-04-15 12:50:52.516539', NULL),
	(10000494, 1, 'PW21A-JK100152BL-L', 19, 0, '2021-04-15 12:50:52.517531', '2021-04-15 12:50:52.517531', NULL),
	(10000495, 1, 'PW21A-JK100152BL-XL', 11, 0, '2021-04-15 12:50:52.515106', '2021-04-15 12:50:52.515106', NULL),
	(10000496, 1, 'PW21A-JK100152BL-XXL', 6, 0, '2021-04-15 12:50:52.519873', '2021-04-15 12:50:52.519873', NULL),
	(10000497, 1, 'PW21A-JK100153GN-XS', 0, 0, '2021-04-15 12:50:52.532414', '2021-04-15 12:50:52.532414', NULL),
	(10000498, 1, 'PW21A-JK100153GN-S', 15, 0, '2021-04-15 12:50:52.536139', '2021-04-15 12:50:52.536139', NULL),
	(10000499, 1, 'PW21A-JK100153GN-M', 21, 0, '2021-04-15 12:50:52.550142', '2021-04-15 12:50:52.550142', NULL),
	(10000500, 1, 'PW21A-JK100153GN-L', 25, 0, '2021-04-15 12:50:52.583250', '2021-04-15 12:50:52.583250', NULL),
	(10000501, 1, 'PW21A-JK100153GN-XL', 12, 0, '2021-04-15 12:50:52.606250', '2021-04-15 12:50:52.606250', NULL),
	(10000502, 1, 'PW21A-JK100153GN-XXL', 7, 0, '2021-04-15 12:50:52.585659', '2021-04-15 12:50:52.585659', NULL),
	(10000503, 1, 'PW21A-JD100154BL-XS', 0, 0, '2021-04-15 12:50:52.605505', '2021-04-15 12:50:52.605505', NULL),
	(10000504, 1, 'PW21A-JD100154BL-S', 8, 0, '2021-04-15 12:50:52.586406', '2021-04-15 12:50:52.586406', NULL),
	(10000505, 1, 'PW21A-JD100154BL-M', 10, 0, '2021-04-15 12:50:52.614528', '2021-04-15 12:50:52.614528', NULL),
	(10000506, 1, 'PW21A-JD100154BL-L', 13, 0, '2021-04-15 12:50:52.627918', '2021-04-15 12:50:52.627918', NULL),
	(10000507, 1, 'PW21A-JD100154BL-XL', 14, 0, '2021-04-15 12:50:52.638991', '2021-04-15 12:50:52.638991', NULL),
	(10000508, 1, 'PW21A-JD100154BL-XXL', 16, 0, '2021-04-15 12:50:52.634416', '2021-04-15 12:50:52.634416', NULL),
	(10000509, 1, 'PW21A-JK100155OL-XS', 0, 0, '2021-04-15 12:50:52.642738', '2021-04-15 12:50:52.642738', NULL),
	(10000510, 1, 'PW21A-JK100155OL-S', 0, 0, '2021-04-15 12:50:52.663340', '2021-04-15 12:50:52.663340', NULL),
	(10000511, 1, 'PW21A-JK100155OL-M', 0, 0, '2021-04-15 12:50:52.664852', '2021-04-15 12:50:52.664852', NULL),
	(10000512, 1, 'PW21A-JK100155OL-L', 0, 0, '2021-04-15 12:50:52.615535', '2021-04-15 12:50:52.615535', NULL),
	(10000513, 1, 'PW21A-JK100155OL-XL', 0, 0, '2021-04-15 12:50:52.665439', '2021-04-15 12:50:52.665439', NULL),
	(10000514, 1, 'PW21A-JK100155OL-XXL', 0, 0, '2021-04-15 12:50:52.664280', '2021-04-15 12:50:52.664280', NULL),
	(10000515, 1, 'PW21A-JK100156YW -XS', 0, 0, '2021-04-15 12:50:52.676659', '2021-04-15 12:50:52.676659', NULL),
	(10000516, 1, 'PW21A-JK100156YW -S', 0, 0, '2021-04-15 12:50:52.675980', '2021-04-15 12:50:52.675980', NULL),
	(10000517, 1, 'PW21A-JK100156YW -M', 0, 0, '2021-04-15 12:50:52.674793', '2021-04-15 12:50:52.674793', NULL),
	(10000518, 1, 'PW21A-JK100156YW -L', 0, 0, '2021-04-15 12:50:52.679868', '2021-04-15 12:50:52.679868', NULL),
	(10000519, 1, 'PW21A-JK100156YW -XL', 0, 0, '2021-04-15 12:50:52.697763', '2021-04-15 12:50:52.697763', NULL),
	(10000520, 1, 'PW21A-JK100156YW -XXL', 0, 0, '2021-04-15 12:50:52.691043', '2021-04-15 12:50:52.691043', NULL),
	(10000521, 1, 'PW21A-JK100157BL-XS', 0, 0, '2021-04-15 12:50:52.698638', '2021-04-15 12:50:52.698638', NULL),
	(10000522, 1, 'PW21A-JK100157BL-S', 6, 0, '2021-04-15 12:50:52.701051', '2021-04-15 12:50:52.701051', NULL),
	(10000523, 1, 'PW21A-JK100157BL-M', 6, 0, '2021-04-15 12:50:52.701516', '2021-04-15 12:50:52.701516', NULL),
	(10000524, 1, 'PW21A-JK100157BL-L', 12, 0, '2021-04-15 12:50:52.704732', '2021-04-15 12:50:52.704732', NULL),
	(10000525, 1, 'PW21A-JK100157BL-XL', 6, 0, '2021-04-15 12:50:52.704254', '2021-04-15 12:50:52.704254', NULL),
	(10000526, 1, 'PW21A-JK100157BL-XXL', 3, 0, '2021-04-15 12:50:52.711216', '2021-04-15 12:50:52.711216', NULL),
	(10000527, 1, 'PW21A-JK100158AR-XS', 0, 0, '2021-04-15 12:50:52.711718', '2021-04-15 12:50:52.711718', NULL),
	(10000528, 1, 'PW21A-JK100158AR-S', 0, 0, '2021-04-15 12:50:52.715275', '2021-04-15 12:50:52.715275', NULL),
	(10000529, 1, 'PW21A-JK100158AR-M', 0, 0, '2021-04-15 12:50:52.722091', '2021-04-15 12:50:52.722091', NULL),
	(10000530, 1, 'PW21A-JK100158AR-L', 0, 0, '2021-04-15 12:50:52.731928', '2021-04-15 12:50:52.731928', NULL),
	(10000531, 1, 'PW21A-JK100158AR-XL', 0, 0, '2021-04-15 12:50:52.732868', '2021-04-15 12:50:52.732868', NULL),
	(10000532, 1, 'PW21A-JK100158AR-XXL', 0, 0, '2021-04-15 12:50:52.733448', '2021-04-15 12:50:52.733448', NULL),
	(10000533, 1, 'PW21A-JD100159MR-XS', 0, 0, '2021-04-15 12:50:52.736281', '2021-04-15 12:50:52.736281', NULL),
	(10000534, 1, 'PW21A-JD100159MR-S', 0, 0, '2021-04-15 12:50:52.737788', '2021-04-15 12:50:52.737788', NULL),
	(10000535, 1, 'PW21A-JD100159MR-M', 0, 0, '2021-04-15 12:50:52.739401', '2021-04-15 12:50:52.739401', NULL),
	(10000536, 1, 'PW21A-JD100159MR-L', 0, 0, '2021-04-15 12:50:52.749821', '2021-04-15 12:50:52.749821', NULL),
	(10000537, 1, 'PW21A-JD100159MR-XL', 0, 0, '2021-04-15 12:50:52.750498', '2021-04-15 12:50:52.750498', NULL),
	(10000538, 1, 'PW21A-JD100159MR-XXL', 0, 0, '2021-04-15 12:50:52.753113', '2021-04-15 12:50:52.753113', NULL),
	(10000539, 1, 'PW21A-JK100160TC-XS', 0, 0, '2021-04-15 12:50:52.759253', '2021-04-15 12:50:52.759253', NULL),
	(10000540, 1, 'PW21A-JK100160TC-S', 0, 0, '2021-04-15 12:50:52.776082', '2021-04-15 12:50:52.776082', NULL),
	(10000541, 1, 'PW21A-JK100160TC-M', 0, 0, '2021-04-15 12:50:52.776390', '2021-04-15 12:50:52.776390', NULL),
	(10000542, 1, 'PW21A-JK100160TC-L', 0, 0, '2021-04-15 12:50:52.776600', '2021-04-15 12:50:52.776600', NULL),
	(10000543, 1, 'PW21A-JK100160TC-XL', 0, 0, '2021-04-15 12:50:52.779283', '2021-04-15 12:50:52.779283', NULL),
	(10000544, 1, 'PW21A-JK100160TC-XXL', 0, 0, '2021-04-15 12:50:52.779818', '2021-04-15 12:50:52.779818', NULL),
	(10000545, 1, 'PW21A-JK100161BL-XS', 0, 0, '2021-04-15 12:50:52.781163', '2021-04-15 12:50:52.781163', NULL),
	(10000546, 1, 'PW21A-JK100161BL-S', 17, 0, '2021-04-15 12:50:52.788806', '2021-04-15 12:50:52.788806', NULL),
	(10000547, 1, 'PW21A-JK100161BL-M', 24, 0, '2021-04-15 12:50:52.789350', '2021-04-15 12:50:52.789350', NULL),
	(10000548, 1, 'PW21A-JK100161BL-L', 25, 0, '2021-04-15 12:50:52.792230', '2021-04-15 12:50:52.792230', NULL),
	(10000549, 1, 'PW21A-JK100161BL-XL', 18, 0, '2021-04-15 12:50:52.797358', '2021-04-15 12:50:52.797358', NULL),
	(10000550, 1, 'PW21A-JK100161BL-XXL', 10, 0, '2021-04-15 12:50:52.805184', '2021-04-15 12:50:52.805184', NULL),
	(10000551, 1, 'PW21A-JD100162BL-XS', 0, 0, '2021-04-15 12:50:52.808027', '2021-04-15 12:50:52.808027', NULL),
	(10000552, 1, 'PW21A-JD100162BL-S', 0, 0, '2021-04-15 12:50:52.808562', '2021-04-15 12:50:52.808562', NULL),
	(10000553, 1, 'PW21A-JD100162BL-M', 0, 0, '2021-04-15 12:50:52.810716', '2021-04-15 12:50:52.810716', NULL),
	(10000554, 1, 'PW21A-JD100162BL-L', 18, 0, '2021-04-15 12:50:52.812088', '2021-04-15 12:50:52.812088', NULL),
	(10000555, 1, 'PW21A-JD100162BL-XL', 18, 0, '2021-04-15 12:50:52.813736', '2021-04-15 12:50:52.813736', NULL),
	(10000556, 1, 'PW21A-JD100162BL-XXL', 17, 0, '2021-04-15 12:50:52.819210', '2021-04-15 12:50:52.819210', NULL),
	(10000557, 1, 'PW21A-JK100163RD-XS', 25, 0, '2021-04-15 12:50:52.822056', '2021-04-15 12:50:52.822056', NULL),
	(10000558, 1, 'PW21A-JK100163RD-S', 49, 0, '2021-04-15 12:50:52.824791', '2021-04-15 12:50:52.824791', NULL),
	(10000559, 1, 'PW21A-JK100163RD-M', 58, 0, '2021-04-15 12:50:52.831138', '2021-04-15 12:50:52.831138', NULL),
	(10000560, 1, 'PW21A-JK100163RD-L', 67, 0, '2021-04-15 12:50:52.839257', '2021-04-15 12:50:52.839257', NULL),
	(10000561, 1, 'PW21A-JK100163RD-XL', 43, 0, '2021-04-15 12:50:52.841939', '2021-04-15 12:50:52.841939', NULL),
	(10000562, 1, 'PW21A-JK100163RD-XXL', 28, 0, '2021-04-15 12:50:52.842516', '2021-04-15 12:50:52.842516', NULL),
	(10000563, 1, 'PW21A-JD100164BL-XS', 0, 0, '2021-04-15 12:50:52.844618', '2021-04-15 12:50:52.844618', NULL),
	(10000564, 1, 'PW21A-JD100164BL-S', 0, 0, '2021-04-15 12:50:52.846245', '2021-04-15 12:50:52.846245', NULL),
	(10000565, 1, 'PW21A-JD100164BL-M', 0, 0, '2021-04-15 12:50:52.847806', '2021-04-15 12:50:52.847806', NULL),
	(10000566, 1, 'PW21A-JD100164BL-L', 0, 0, '2021-04-15 12:50:52.852868', '2021-04-15 12:50:52.852868', NULL),
	(10000567, 1, 'PW21A-JD100164BL-XL', 0, 0, '2021-04-15 12:50:52.855247', '2021-04-15 12:50:52.855247', NULL),
	(10000568, 1, 'PW21A-JD100164BL-XXL', 0, 0, '2021-04-15 12:50:52.856868', '2021-04-15 12:50:52.856868', NULL),
	(10000569, 1, 'PW21A-JK100165NV-XS', 0, 0, '2021-04-15 12:50:52.861910', '2021-04-15 12:50:52.861910', NULL),
	(10000570, 1, 'PW21A-JK100165NV-S', 0, 0, '2021-04-15 12:50:52.870725', '2021-04-15 12:50:52.870725', NULL),
	(10000571, 1, 'PW21A-JK100165NV-M', 0, 0, '2021-04-15 12:50:52.872689', '2021-04-15 12:50:52.872689', NULL),
	(10000572, 1, 'PW21A-JK100165NV-L', 0, 0, '2021-04-15 12:50:52.874683', '2021-04-15 12:50:52.874683', NULL),
	(10000573, 1, 'PW21A-JK100165NV-XL', 0, 0, '2021-04-15 12:50:52.875346', '2021-04-15 12:50:52.875346', NULL),
	(10000574, 1, 'PW21A-JK100165NV-XXL', 0, 0, '2021-04-15 12:50:52.876541', '2021-04-15 12:50:52.876541', NULL),
	(10000575, 1, 'PW21A-JK100166MR-XS', 0, 0, '2021-04-15 12:50:52.879312', '2021-04-15 12:50:52.879312', NULL),
	(10000576, 1, 'PW21A-JK100166MR-S', 0, 0, '2021-04-15 12:50:52.892877', '2021-04-15 12:50:52.892877', NULL),
	(10000577, 1, 'PW21A-JK100166MR-M', 0, 0, '2021-04-15 12:50:52.894061', '2021-04-15 12:50:52.894061', NULL),
	(10000578, 1, 'PW21A-JK100166MR-L', 0, 0, '2021-04-15 12:50:52.899274', '2021-04-15 12:50:52.899274', NULL),
	(10000579, 1, 'PW21A-JK100166MR-XL', 0, 0, '2021-04-15 12:50:52.903281', '2021-04-15 12:50:52.903281', NULL),
	(10000580, 1, 'PW21A-JK100166MR-XXL', 0, 0, '2021-04-15 12:50:52.910796', '2021-04-15 12:50:52.910796', NULL),
	(10000581, 1, 'PW21A-JK100167WT-XS', 0, 0, '2021-04-15 12:50:52.913320', '2021-04-15 12:50:52.913320', NULL),
	(10000582, 1, 'PW21A-JK100167WT-S', 15, 0, '2021-04-15 12:50:52.913980', '2021-04-15 12:50:52.913980', NULL),
	(10000583, 1, 'PW21A-JK100167WT-M', 25, 0, '2021-04-15 12:50:52.916317', '2021-04-15 12:50:52.916317', NULL),
	(10000584, 1, 'PW21A-JK100167WT-L', 29, 0, '2021-04-15 12:50:52.912802', '2021-04-15 12:50:52.912802', NULL),
	(10000585, 1, 'PW21A-JK100167WT-XL', 17, 0, '2021-04-15 12:50:52.918567', '2021-04-15 12:50:52.918567', NULL),
	(10000586, 1, 'PW21A-JK100167WT-XXL', 13, 0, '2021-04-15 12:50:52.927879', '2021-04-15 12:50:52.927879', NULL),
	(10000587, 1, 'PW21A-JK100168BL-XS', 0, 0, '2021-04-15 12:50:52.928474', '2021-04-15 12:50:52.928474', NULL),
	(10000588, 1, 'PW21A-JK100168BL-S', 9, 0, '2021-04-15 12:50:52.929066', '2021-04-15 12:50:52.929066', NULL),
	(10000589, 1, 'PW21A-JK100168BL-M', 18, 0, '2021-04-15 12:50:52.947639', '2021-04-15 12:50:52.947639', NULL),
	(10000590, 1, 'PW21A-JK100168BL-L', 23, 0, '2021-04-15 12:50:52.952755', '2021-04-15 12:50:52.952755', NULL),
	(10000591, 1, 'PW21A-JK100168BL-XL', 10, 0, '2021-04-15 12:50:52.956277', '2021-04-15 12:50:52.956277', NULL),
	(10000592, 1, 'PW21A-JK100168BL-XXL', 6, 0, '2021-04-15 12:50:52.958474', '2021-04-15 12:50:52.958474', NULL),
	(10000593, 1, 'PW21A-JK100169BL-XS', 0, 0, '2021-04-15 12:50:52.959008', '2021-04-15 12:50:52.959008', NULL),
	(10000594, 1, 'PW21A-JK100169BL-S', 0, 0, '2021-04-15 12:50:52.959464', '2021-04-15 12:50:52.959464', NULL),
	(10000595, 1, 'PW21A-JK100169BL-M', 0, 0, '2021-04-15 12:50:52.959911', '2021-04-15 12:50:52.959911', NULL),
	(10000596, 1, 'PW21A-JK100169BL-L', 0, 0, '2021-04-15 12:50:52.960396', '2021-04-15 12:50:52.960396', NULL),
	(10000597, 1, 'PW21A-JK100169BL-XL', 0, 0, '2021-04-15 12:50:52.964354', '2021-04-15 12:50:52.964354', NULL),
	(10000598, 1, 'PW21A-JK100169BL-XXL', 0, 0, '2021-04-15 12:50:52.966231', '2021-04-15 12:50:52.966231', NULL),
	(10000599, 1, 'PW21A-JK100170RD-XS', 0, 0, '2021-04-15 12:50:52.978170', '2021-04-15 12:50:52.978170', NULL),
	(10000600, 1, 'PW21A-JK100170RD-S', 0, 0, '2021-04-15 12:50:52.981259', '2021-04-15 12:50:52.981259', NULL),
	(10000601, 1, 'PW21A-JK100170RD-M', 0, 0, '2021-04-15 12:50:52.988778', '2021-04-15 12:50:52.988778', NULL),
	(10000602, 1, 'PW21A-JK100170RD-L', 0, 0, '2021-04-15 12:50:52.997943', '2021-04-15 12:50:52.997943', NULL),
	(10000603, 1, 'PW21A-JK100170RD-XL', 0, 0, '2021-04-15 12:50:53.000828', '2021-04-15 12:50:53.000828', NULL),
	(10000604, 1, 'PW21A-JK100170RD-XXL', 0, 0, '2021-04-15 12:50:52.995646', '2021-04-15 12:50:52.995646', NULL),
	(10000605, 1, 'PW21A-JK100171WT-XS', 0, 0, '2021-04-15 12:50:53.002521', '2021-04-15 12:50:53.002521', NULL),
	(10000606, 1, 'PW21A-JK100171WT-S', 0, 0, '2021-04-15 12:50:52.996825', '2021-04-15 12:50:52.996825', NULL),
	(10000607, 1, 'PW21A-JK100171WT-M', 0, 0, '2021-04-15 12:50:53.006935', '2021-04-15 12:50:53.006935', NULL),
	(10000608, 1, 'PW21A-JK100171WT-L', 0, 0, '2021-04-15 12:50:53.007600', '2021-04-15 12:50:53.007600', NULL),
	(10000609, 1, 'PW21A-JK100171WT-XL', 0, 0, '2021-04-15 12:50:53.015712', '2021-04-15 12:50:53.015712', NULL),
	(10000610, 1, 'PW21A-JK100171WT-XXL', 0, 0, '2021-04-15 12:50:53.022014', '2021-04-15 12:50:53.022014', NULL),
	(10000611, 1, 'PW21A-JK100172BL-XS', 0, 0, '2021-04-15 12:50:53.026931', '2021-04-15 12:50:53.026931', NULL),
	(10000612, 1, 'PW21A-JK100172BL-S', 14, 0, '2021-04-15 12:50:53.031767', '2021-04-15 12:50:53.031767', NULL),
	(10000613, 1, 'PW21A-JK100172BL-M', 9, 0, '2021-04-15 12:50:53.033948', '2021-04-15 12:50:53.033948', NULL),
	(10000614, 1, 'PW21A-JK100172BL-L', 21, 0, '2021-04-15 12:50:53.034559', '2021-04-15 12:50:53.034559', NULL),
	(10000615, 1, 'PW21A-JK100172BL-XL', 20, 0, '2021-04-15 12:50:53.036222', '2021-04-15 12:50:53.036222', NULL),
	(10000616, 1, 'PW21A-JK100172BL-XXL', 6, 0, '2021-04-15 12:50:53.036708', '2021-04-15 12:50:53.036708', NULL),
	(10000617, 1, 'PW21A-TS100173BL-XS', 0, 0, '2021-04-15 12:50:53.039481', '2021-04-15 12:50:53.039481', NULL),
	(10000618, 1, 'PW21A-TS100173BL-M', 0, 0, '2021-04-15 12:50:53.042097', '2021-04-15 12:50:53.042097', NULL),
	(10000619, 1, 'PW21A-TS100173BL-L', 0, 0, '2021-04-15 12:50:53.052501', '2021-04-15 12:50:53.052501', NULL),
	(10000620, 1, 'PW21A-TS100173BL-XL', 0, 0, '2021-04-15 12:50:53.058675', '2021-04-15 12:50:53.058675', NULL),
	(10000621, 1, 'PW21A-TS100173BL-XXL', 0, 0, '2021-04-15 12:50:53.059310', '2021-04-15 12:50:53.059310', NULL),
	(10000622, 1, 'PW21A-TS100174NV-XS', 0, 0, '2021-04-15 12:50:53.066263', '2021-04-15 12:50:53.066263', NULL),
	(10000623, 1, 'PW21A-TS100174NV-S', 0, 0, '2021-04-15 12:50:53.066867', '2021-04-15 12:50:53.066867', NULL),
	(10000624, 1, 'PW21A-TS100174NV-M', 0, 0, '2021-04-15 12:50:53.071092', '2021-04-15 12:50:53.071092', NULL),
	(10000625, 1, 'PW21A-TS100174NV-L', 0, 0, '2021-04-15 12:50:53.074549', '2021-04-15 12:50:53.074549', NULL),
	(10000626, 1, 'PW21A-TS100174NV-XL', 0, 0, '2021-04-15 12:50:53.075098', '2021-04-15 12:50:53.075098', NULL),
	(10000627, 1, 'PW21A-TS100174NV-XXL', 0, 0, '2021-04-15 12:50:53.076659', '2021-04-15 12:50:53.076659', NULL),
	(10000628, 1, 'PW21A-TS100175BL-XS', 0, 0, '2021-04-15 12:50:53.077287', '2021-04-15 12:50:53.077287', NULL),
	(10000629, 1, 'PW21A-TS100175BL-S', 0, 0, '2021-04-15 12:50:53.094486', '2021-04-15 12:50:53.094486', NULL),
	(10000630, 1, 'PW21A-TS100175BL-M', 0, 0, '2021-04-15 12:50:53.097888', '2021-04-15 12:50:53.097888', NULL),
	(10000631, 1, 'PW21A-TS100175BL-L', 0, 0, '2021-04-15 12:50:53.093669', '2021-04-15 12:50:53.093669', NULL),
	(10000632, 1, 'PW21A-TS100175BL-XL', 0, 0, '2021-04-15 12:50:53.109428', '2021-04-15 12:50:53.109428', NULL),
	(10000633, 1, 'PW21A-TS100175BL-XXL', 0, 0, '2021-04-15 12:50:53.100354', '2021-04-15 12:50:53.100354', NULL),
	(10000634, 1, 'PW21A-TS100176BL-XS', 0, 0, '2021-04-15 12:50:53.117442', '2021-04-15 12:50:53.117442', NULL),
	(10000635, 1, 'PW21A-TS100176BL-S', 0, 0, '2021-04-15 12:50:53.119192', '2021-04-15 12:50:53.119192', NULL),
	(10000636, 1, 'PW21A-TS100176BL-M', 0, 0, '2021-04-15 12:50:53.119865', '2021-04-15 12:50:53.119865', NULL),
	(10000637, 1, 'PW21A-TS100176BL-L', 0, 0, '2021-04-15 12:50:53.122823', '2021-04-15 12:50:53.122823', NULL),
	(10000638, 1, 'PW21A-TS100176BL-XL', 0, 0, '2021-04-15 12:50:53.127161', '2021-04-15 12:50:53.127161', NULL),
	(10000639, 1, 'PW21A-TS100176BL-XXL', 0, 0, '2021-04-15 12:50:53.136685', '2021-04-15 12:50:53.136685', NULL),
	(10000640, 1, 'PW21A-TS100177BL-XS', 0, 0, '2021-04-15 12:50:53.138323', '2021-04-15 12:50:53.138323', NULL),
	(10000641, 1, 'PW21A-TS100177BL-S', 0, 0, '2021-04-15 12:50:53.142469', '2021-04-15 12:50:53.142469', NULL),
	(10000642, 1, 'PW21A-TS100177BL-M', 0, 0, '2021-04-15 12:50:53.143812', '2021-04-15 12:50:53.143812', NULL),
	(10000643, 1, 'PW21A-TS100177BL-L', 0, 0, '2021-04-15 12:50:53.146170', '2021-04-15 12:50:53.146170', NULL),
	(10000644, 1, 'PW21A-TS100177BL-XL', 0, 0, '2021-04-15 12:50:53.153291', '2021-04-15 12:50:53.153291', NULL),
	(10000645, 1, 'PW21A-TS100177BL-XXL', 0, 0, '2021-04-15 12:50:53.160086', '2021-04-15 12:50:53.160086', NULL),
	(10000646, 1, 'PW21A-TS100178BL-XS', 0, 0, '2021-04-15 12:50:53.162583', '2021-04-15 12:50:53.162583', NULL),
	(10000647, 1, 'PW21A-TS100178BL-S', 0, 0, '2021-04-15 12:50:53.163988', '2021-04-15 12:50:53.163988', NULL),
	(10000648, 1, 'PW21A-TS100178BL-M', 0, 0, '2021-04-15 12:50:53.164461', '2021-04-15 12:50:53.164461', NULL),
	(10000649, 1, 'PW21A-TS100178BL-L', 0, 0, '2021-04-15 12:50:53.176514', '2021-04-15 12:50:53.176514', NULL),
	(10000650, 1, 'PW21A-TS100178BL-XL', 0, 0, '2021-04-15 12:50:53.178178', '2021-04-15 12:50:53.178178', NULL),
	(10000651, 1, 'PW21A-TS100178BL-XXL', 0, 0, '2021-04-15 12:50:53.178724', '2021-04-15 12:50:53.178724', NULL),
	(10000652, 1, 'PW21A-TS100179BL-XS', 0, 0, '2021-04-15 12:50:53.179215', '2021-04-15 12:50:53.179215', NULL),
	(10000653, 1, 'PW21A-TS100179BL-S', 1, 0, '2021-04-15 12:50:53.181361', '2021-04-15 12:50:53.181361', NULL),
	(10000654, 1, 'PW21A-TS100179BL-M', 0, 0, '2021-04-15 12:50:53.187336', '2021-04-15 12:50:53.187336', NULL),
	(10000655, 1, 'PW21A-TS100179BL-L', 0, 0, '2021-04-15 12:50:53.195583', '2021-04-15 12:50:53.195583', NULL),
	(10000656, 1, 'PW21A-TS100179BL-XL', 0, 0, '2021-04-15 12:50:53.197568', '2021-04-15 12:50:53.197568', NULL),
	(10000657, 1, 'PW21A-TS100179BL-XXL', 1, 0, '2021-04-15 12:50:53.199757', '2021-04-15 12:50:53.199757', NULL),
	(10000658, 1, 'PW21A-TS100180BL-XS', 0, 0, '2021-04-15 12:50:53.200756', '2021-04-15 12:50:53.200756', NULL),
	(10000659, 1, 'PW21A-TS100180BL-S', 0, 0, '2021-04-15 12:50:53.209218', '2021-04-15 12:50:53.209218', NULL),
	(10000660, 1, 'PW21A-TS100180BL-M', 0, 0, '2021-04-15 12:50:53.209651', '2021-04-15 12:50:53.209651', NULL),
	(10000661, 1, 'PW21A-TS100180BL-L', 0, 0, '2021-04-15 12:50:53.210444', '2021-04-15 12:50:53.210444', NULL),
	(10000662, 1, 'PW21A-TS100180BL-XL', 0, 0, '2021-04-15 12:50:53.211571', '2021-04-15 12:50:53.211571', NULL),
	(10000663, 1, 'PW21A-TS100180BL-XXL', 0, 0, '2021-04-15 12:50:53.211928', '2021-04-15 12:50:53.211928', NULL),
	(10000664, 1, 'PW21A-TS100181BL-XS', 0, 0, '2021-04-15 12:50:53.216624', '2021-04-15 12:50:53.216624', NULL),
	(10000665, 1, 'PW21A-TS100181BL-S', 0, 0, '2021-04-15 12:50:53.220143', '2021-04-15 12:50:53.220143', NULL),
	(10000666, 1, 'PW21A-TS100181BL-M', 0, 0, '2021-04-15 12:50:53.221322', '2021-04-15 12:50:53.221322', NULL),
	(10000667, 1, 'PW21A-TS100181BL-L', 0, 0, '2021-04-15 12:50:53.222342', '2021-04-15 12:50:53.222342', NULL),
	(10000668, 1, 'PW21A-TS100181BL-XL', 0, 0, '2021-04-15 12:50:53.225173', '2021-04-15 12:50:53.225173', NULL),
	(10000669, 1, 'PW21A-TS100181BL-XXL', 0, 0, '2021-04-15 12:50:53.233868', '2021-04-15 12:50:53.233868', NULL),
	(10000670, 1, 'PW21A-TS100182BL-XS', 0, 0, '2021-04-15 12:50:53.235102', '2021-04-15 12:50:53.235102', NULL),
	(10000671, 1, 'PW21A-TS100182BL-S', 0, 0, '2021-04-15 12:50:53.237815', '2021-04-15 12:50:53.237815', NULL),
	(10000672, 1, 'PW21A-TS100182BL-M', 0, 0, '2021-04-15 12:50:53.238150', '2021-04-15 12:50:53.238150', NULL),
	(10000673, 1, 'PW21A-TS100182BL-L', 0, 0, '2021-04-15 12:50:53.239157', '2021-04-15 12:50:53.239157', NULL),
	(10000674, 1, 'PW21A-TS100182BL-XL', 0, 0, '2021-04-15 12:50:53.243286', '2021-04-15 12:50:53.243286', NULL),
	(10000675, 1, 'PW21A-TS100182BL-XXL', 0, 0, '2021-04-15 12:50:53.252012', '2021-04-15 12:50:53.252012', NULL),
	(10000676, 1, 'PW21A-TS100183BL-XS', 0, 0, '2021-04-15 12:50:53.253929', '2021-04-15 12:50:53.253929', NULL),
	(10000677, 1, 'PW21A-TS100183BL-S', 0, 0, '2021-04-15 12:50:53.255975', '2021-04-15 12:50:53.255975', NULL),
	(10000678, 1, 'PW21A-TS100183BL-M', 0, 0, '2021-04-15 12:50:53.259806', '2021-04-15 12:50:53.259806', NULL),
	(10000679, 1, 'PW21A-TS100183BL-L', 0, 0, '2021-04-15 12:50:53.261922', '2021-04-15 12:50:53.261922', NULL),
	(10000680, 1, 'PW21A-TS100183BL-XL', 0, 0, '2021-04-15 12:50:53.275012', '2021-04-15 12:50:53.275012', NULL),
	(10000681, 1, 'PW21A-TS100183BL-XXL', 0, 0, '2021-04-15 12:50:53.277155', '2021-04-15 12:50:53.277155', NULL),
	(10000682, 1, 'PW21A-TS100184BL-XS', 0, 0, '2021-04-15 12:50:53.276003', '2021-04-15 12:50:53.276003', NULL),
	(10000683, 1, 'PW21A-TS100184BL-S', 0, 0, '2021-04-15 12:50:53.279337', '2021-04-15 12:50:53.279337', NULL),
	(10000684, 1, 'PW21A-TS100184BL-M', 0, 0, '2021-04-15 12:50:53.282543', '2021-04-15 12:50:53.282543', NULL),
	(10000685, 1, 'PW21A-TS100184BL-L', 0, 0, '2021-04-15 12:50:53.291677', '2021-04-15 12:50:53.291677', NULL),
	(10000686, 1, 'PW21A-TS100184BL-XL', 0, 0, '2021-04-15 12:50:53.296931', '2021-04-15 12:50:53.296931', NULL),
	(10000687, 1, 'PW21A-TS100184BL-XXL', 0, 0, '2021-04-15 12:50:53.299110', '2021-04-15 12:50:53.299110', NULL),
	(10000688, 1, 'PW21A-TS100185BL-XS', 0, 0, '2021-04-15 12:50:53.301586', '2021-04-15 12:50:53.301586', NULL),
	(10000689, 1, 'PW21A-TS100185BL-S', 0, 0, '2021-04-15 12:50:53.302018', '2021-04-15 12:50:53.302018', NULL),
	(10000690, 1, 'PW21A-TS100185BL-M', 0, 0, '2021-04-15 12:50:53.318587', '2021-04-15 12:50:53.318587', NULL),
	(10000691, 1, 'PW21A-TS100185BL-L', 0, 0, '2021-04-15 12:50:53.317364', '2021-04-15 12:50:53.317364', NULL),
	(10000692, 1, 'PW21A-TS100185BL-XL', 0, 0, '2021-04-15 12:50:53.320035', '2021-04-15 12:50:53.320035', NULL),
	(10000693, 1, 'PW21A-TS100185BL-XXL', 0, 0, '2021-04-15 12:50:53.322658', '2021-04-15 12:50:53.322658', NULL),
	(10000694, 1, 'PW21A-TS100186BL-XS', 0, 0, '2021-04-15 12:50:53.324907', '2021-04-15 12:50:53.324907', NULL),
	(10000695, 1, 'PW21A-TS100186BL-S', 0, 0, '2021-04-15 12:50:53.332410', '2021-04-15 12:50:53.332410', NULL),
	(10000696, 1, 'PW21A-TS100186BL-M', 0, 0, '2021-04-15 12:50:53.336122', '2021-04-15 12:50:53.336122', NULL),
	(10000697, 1, 'PW21A-TS100186BL-L', 0, 0, '2021-04-15 12:50:53.337938', '2021-04-15 12:50:53.337938', NULL),
	(10000698, 1, 'PW21A-TS100186BL-XL', 0, 0, '2021-04-15 12:50:53.336806', '2021-04-15 12:50:53.336806', NULL),
	(10000699, 1, 'PW21A-TS100186BL-XXL', 0, 0, '2021-04-15 12:50:53.339181', '2021-04-15 12:50:53.339181', NULL),
	(10000700, 1, 'PW21A-TS100187BL-XS', 0, 0, '2021-04-15 12:50:53.342892', '2021-04-15 12:50:53.342892', NULL),
	(10000701, 1, 'PW21A-TS100187BL-S', 1, 0, '2021-04-15 12:50:53.349341', '2021-04-15 12:50:53.349341', NULL),
	(10000702, 1, 'PW21A-TS100187BL-M', 0, 0, '2021-04-15 12:50:53.350388', '2021-04-15 12:50:53.350388', NULL),
	(10000703, 1, 'PW21A-TS100187BL-L', 0, 0, '2021-04-15 12:50:53.351744', '2021-04-15 12:50:53.351744', NULL),
	(10000704, 1, 'PW21A-TS100187BL-XL', 0, 0, '2021-04-15 12:50:53.352284', '2021-04-15 12:50:53.352284', NULL),
	(10000705, 1, 'PW21A-TS100187BL-XXL', 2, 0, '2021-04-15 12:50:53.360378', '2021-04-15 12:50:53.360378', NULL),
	(10000706, 1, 'PW21A-TS100188BL-XS', 0, 0, '2021-04-15 12:50:53.363115', '2021-04-15 12:50:53.363115', NULL),
	(10000707, 1, 'PW21A-TS100188BL-S', 0, 0, '2021-04-15 12:50:53.364755', '2021-04-15 12:50:53.364755', NULL),
	(10000708, 1, 'PW21A-TS100188BL-M', 0, 0, '2021-04-15 12:50:53.365179', '2021-04-15 12:50:53.365179', NULL),
	(10000709, 1, 'PW21A-TS100188BL-L', 0, 0, '2021-04-15 12:50:53.366806', '2021-04-15 12:50:53.366806', NULL),
	(10000710, 1, 'PW21A-TS100188BL-XL', 0, 0, '2021-04-15 12:50:53.367239', '2021-04-15 12:50:53.367239', NULL),
	(10000711, 1, 'PW21A-TS100188BL-XXL', 0, 0, '2021-04-15 12:50:53.374152', '2021-04-15 12:50:53.374152', NULL),
	(10000712, 1, 'PW21A-TS100189BL-XS', 0, 0, '2021-04-15 12:50:53.375651', '2021-04-15 12:50:53.375651', NULL),
	(10000713, 1, 'PW21A-TS100189BL-S', 0, 0, '2021-04-15 12:50:53.376131', '2021-04-15 12:50:53.376131', NULL),
	(10000714, 1, 'PW21A-TS100189BL-M', 0, 0, '2021-04-15 12:50:53.377587', '2021-04-15 12:50:53.377587', NULL),
	(10000715, 1, 'PW21A-TS100189BL-L', 0, 0, '2021-04-15 12:50:53.380325', '2021-04-15 12:50:53.380325', NULL),
	(10000716, 1, 'PW21A-TS100189BL-XL', 0, 0, '2021-04-15 12:50:53.385949', '2021-04-15 12:50:53.385949', NULL),
	(10000717, 1, 'PW21A-TS100189BL-XXL', 0, 0, '2021-04-15 12:50:53.386271', '2021-04-15 12:50:53.386271', NULL),
	(10000718, 1, 'PW21A-TS100190WT-XS', 0, 0, '2021-04-15 12:50:53.387196', '2021-04-15 12:50:53.387196', NULL),
	(10000719, 1, 'PW21A-TS100190WT-S', 0, 0, '2021-04-15 12:50:53.388279', '2021-04-15 12:50:53.388279', NULL),
	(10000720, 1, 'PW21A-TS100190WT-M', 1, 0, '2021-04-15 12:50:53.388619', '2021-04-15 12:50:53.388619', NULL),
	(10000721, 1, 'PW21A-TS100190WT-L', 1, 0, '2021-04-15 12:50:53.395554', '2021-04-15 12:50:53.395554', NULL),
	(10000722, 1, 'PW21A-TS100190WT-XL', 22, 0, '2021-04-15 12:50:53.397304', '2021-04-15 12:50:53.397304', NULL),
	(10000723, 1, 'PW21A-TS100190WT-XXL', 5, 0, '2021-04-15 12:50:53.397636', '2021-04-15 12:50:53.397636', NULL),
	(10000724, 1, 'PW21A-TS100191YW -XS', 0, 0, '2021-04-15 12:50:53.397963', '2021-04-15 12:50:53.397963', NULL),
	(10000725, 1, 'PW21A-TS100191YW -S', 4, 0, '2021-04-15 12:50:53.401681', '2021-04-15 12:50:53.401681', NULL),
	(10000726, 1, 'PW21A-TS100191YW -M', 0, 0, '2021-04-15 12:50:53.413680', '2021-04-15 12:50:53.413680', NULL),
	(10000727, 1, 'PW21A-TS100191YW -L', 0, 0, '2021-04-15 12:50:53.414101', '2021-04-15 12:50:53.414101', NULL),
	(10000728, 1, 'PW21A-TS100191YW -XL', 0, 0, '2021-04-15 12:50:53.415058', '2021-04-15 12:50:53.415058', NULL),
	(10000729, 1, 'PW21A-TS100191YW -XXL', 0, 0, '2021-04-15 12:50:53.416394', '2021-04-15 12:50:53.416394', NULL),
	(10000730, 1, 'PW21A-TS100192GN-XS', 0, 0, '2021-04-15 12:50:53.416788', '2021-04-15 12:50:53.416788', NULL),
	(10000731, 1, 'PW21A-TS100192GN-S', 10, 0, '2021-04-15 12:50:53.423144', '2021-04-15 12:50:53.423144', NULL),
	(10000732, 1, 'PW21A-TS100192GN-M', 0, 0, '2021-04-15 12:50:53.425437', '2021-04-15 12:50:53.425437', NULL),
	(10000733, 1, 'PW21A-TS100192GN-L', 0, 0, '2021-04-15 12:50:53.425927', '2021-04-15 12:50:53.425927', NULL),
	(10000734, 1, 'PW21A-TS100192GN-XL', 0, 0, '2021-04-15 12:50:53.426292', '2021-04-15 12:50:53.426292', NULL),
	(10000735, 1, 'PW21A-TS100192GN-XXL', 0, 0, '2021-04-15 12:50:53.427681', '2021-04-15 12:50:53.427681', NULL),
	(10000736, 1, 'PW21A-TS100193BL-XS', 0, 0, '2021-04-15 12:50:53.432374', '2021-04-15 12:50:53.432374', NULL),
	(10000737, 1, 'PW21A-TS100193BL-S', 10, 0, '2021-04-15 12:50:53.435221', '2021-04-15 12:50:53.435221', NULL),
	(10000738, 1, 'PW21A-TS100193BL-M', 9, 0, '2021-04-15 12:50:53.436623', '2021-04-15 12:50:53.436623', NULL),
	(10000739, 1, 'PW21A-TS100193BL-L', 12, 0, '2021-04-15 12:50:53.436973', '2021-04-15 12:50:53.436973', NULL),
	(10000740, 1, 'PW21A-TS100193BL-XL', 11, 0, '2021-04-15 12:50:53.437611', '2021-04-15 12:50:53.437611', NULL),
	(10000741, 1, 'PW21A-TS100193BL-XXL', 2, 0, '2021-04-15 12:50:53.441626', '2021-04-15 12:50:53.441626', NULL),
	(10000742, 1, 'PW21A-TS100194RD-XS', 0, 0, '2021-04-15 12:50:53.445881', '2021-04-15 12:50:53.445881', NULL),
	(10000743, 1, 'PW21A-TS100194RD-S', 0, 0, '2021-04-15 12:50:53.446456', '2021-04-15 12:50:53.446456', NULL),
	(10000744, 1, 'PW21A-TS100194RD-M', 0, 0, '2021-04-15 12:50:53.446944', '2021-04-15 12:50:53.446944', NULL),
	(10000745, 1, 'PW21A-TS100194RD-L', 0, 0, '2021-04-15 12:50:53.447976', '2021-04-15 12:50:53.447976', NULL),
	(10000746, 1, 'PW21A-TS100194RD-XL', 2, 0, '2021-04-15 12:50:53.452595', '2021-04-15 12:50:53.452595', NULL),
	(10000747, 1, 'PW21A-TS100194RD-XXL', 1, 0, '2021-04-15 12:50:53.455518', '2021-04-15 12:50:53.455518', NULL),
	(10000748, 1, 'PW21A-TS100195BL-XS', 0, 0, '2021-04-15 12:50:53.456510', '2021-04-15 12:50:53.456510', NULL),
	(10000749, 1, 'PW21A-TS100195BL-S', 29, 0, '2021-04-15 12:50:53.457340', '2021-04-15 12:50:53.457340', NULL),
	(10000750, 1, 'PW21A-TS100195BL-M', 26, 0, '2021-04-15 12:50:53.456861', '2021-04-15 12:50:53.456861', NULL),
	(10000751, 1, 'PW21A-TS100195BL-L', 29, 0, '2021-04-15 12:50:53.467663', '2021-04-15 12:50:53.467663', NULL),
	(10000752, 1, 'PW21A-TS100195BL-XL', 13, 0, '2021-04-15 12:50:53.474403', '2021-04-15 12:50:53.474403', NULL),
	(10000753, 1, 'PW21A-TS100195BL-XXL', 7, 0, '2021-04-15 12:50:53.472056', '2021-04-15 12:50:53.472056', NULL),
	(10000754, 1, 'PW21A-TS100196BL-XS', 0, 0, '2021-04-15 12:50:53.475562', '2021-04-15 12:50:53.475562', NULL),
	(10000755, 1, 'PW21A-TS100196BL-S', 21, 0, '2021-04-15 12:50:53.471614', '2021-04-15 12:50:53.471614', NULL),
	(10000756, 1, 'PW21A-TS100196BL-M', 19, 0, '2021-04-15 12:50:53.482097', '2021-04-15 12:50:53.482097', NULL),
	(10000757, 1, 'PW21A-TS100196BL-L', 18, 0, '2021-04-15 12:50:53.482468', '2021-04-15 12:50:53.482468', NULL),
	(10000758, 1, 'PW21A-TS100196BL-XL', 27, 0, '2021-04-15 12:50:53.483253', '2021-04-15 12:50:53.483253', NULL),
	(10000759, 1, 'PW21A-TS100196BL-XXL', 11, 0, '2021-04-15 12:50:53.484167', '2021-04-15 12:50:53.484167', NULL),
	(10000760, 1, 'PW21A-TS100197BL-XS', 0, 0, '2021-04-15 12:50:53.484581', '2021-04-15 12:50:53.484581', NULL),
	(10000761, 1, 'PW21A-TS100197BL-S', 0, 0, '2021-04-15 12:50:53.492608', '2021-04-15 12:50:53.492608', NULL),
	(10000762, 1, 'PW21A-TS100197BL-M', 0, 0, '2021-04-15 12:50:53.493135', '2021-04-15 12:50:53.493135', NULL),
	(10000763, 1, 'PW21A-TS100197BL-L', 0, 0, '2021-04-15 12:50:53.494664', '2021-04-15 12:50:53.494664', NULL),
	(10000764, 1, 'PW21A-TS100197BL-XL', 0, 0, '2021-04-15 12:50:53.495046', '2021-04-15 12:50:53.495046', NULL),
	(10000765, 1, 'PW21A-TS100197BL-XXL', 0, 0, '2021-04-15 12:50:53.496783', '2021-04-15 12:50:53.496783', NULL),
	(10000766, 1, 'PW21A-TS100198BL-XS', 0, 0, '2021-04-15 12:50:53.501244', '2021-04-15 12:50:53.501244', NULL),
	(10000767, 1, 'PW21A-TS100198BL-S', 23, 0, '2021-04-15 12:50:53.503098', '2021-04-15 12:50:53.503098', NULL),
	(10000768, 1, 'PW21A-TS100198BL-M', 10, 0, '2021-04-15 12:50:53.504651', '2021-04-15 12:50:53.504651', NULL),
	(10000769, 1, 'PW21A-TS100198BL-L', 21, 0, '2021-04-15 12:50:53.505607', '2021-04-15 12:50:53.505607', NULL),
	(10000770, 1, 'PW21A-TS100198BL-XL', 14, 0, '2021-04-15 12:50:53.505978', '2021-04-15 12:50:53.505978', NULL),
	(10000771, 1, 'PW21A-TS100198BL-XXL', 8, 0, '2021-04-15 12:50:53.512315', '2021-04-15 12:50:53.512315', NULL),
	(10000772, 1, 'PW21A-TS100199BL-XS', 0, 0, '2021-04-15 12:50:53.519166', '2021-04-15 12:50:53.519166', NULL),
	(10000773, 1, 'PW21A-TS100199BL-S', 0, 0, '2021-04-15 12:50:53.519627', '2021-04-15 12:50:53.519627', NULL),
	(10000774, 1, 'PW21A-TS100199BL-M', 0, 0, '2021-04-15 12:50:53.520048', '2021-04-15 12:50:53.520048', NULL),
	(10000775, 1, 'PW21A-TS100199BL-L', 0, 0, '2021-04-15 12:50:53.524499', '2021-04-15 12:50:53.524499', NULL),
	(10000776, 1, 'PW21A-TS100199BL-XL', 0, 0, '2021-04-15 12:50:53.527285', '2021-04-15 12:50:53.527285', NULL),
	(10000777, 1, 'PW21A-TS100199BL-XXL', 0, 0, '2021-04-15 12:50:53.529733', '2021-04-15 12:50:53.529733', NULL),
	(10000778, 1, 'PW21A-TS100200BL-XS', 0, 0, '2021-04-15 12:50:53.530625', '2021-04-15 12:50:53.530625', NULL),
	(10000779, 1, 'PW21A-TS100200BL-S', 0, 0, '2021-04-15 12:50:53.530952', '2021-04-15 12:50:53.530952', NULL),
	(10000780, 1, 'PW21A-TS100200BL-M', 0, 0, '2021-04-15 12:50:53.532314', '2021-04-15 12:50:53.532314', NULL),
	(10000781, 1, 'PW21A-TS100200BL-L', 0, 0, '2021-04-15 12:50:53.539610', '2021-04-15 12:50:53.539610', NULL),
	(10000782, 1, 'PW21A-TS100200BL-XL', 0, 0, '2021-04-15 12:50:53.541352', '2021-04-15 12:50:53.541352', NULL),
	(10000783, 1, 'PW21A-TS100200BL-XXL', 0, 0, '2021-04-15 12:50:53.541686', '2021-04-15 12:50:53.541686', NULL),
	(10000784, 1, 'PW21A-TS100201BL-XS', 0, 0, '2021-04-15 12:50:53.542242', '2021-04-15 12:50:53.542242', NULL),
	(10000785, 1, 'PW21A-TS100201BL-S', 0, 0, '2021-04-15 12:50:53.544633', '2021-04-15 12:50:53.544633', NULL),
	(10000786, 1, 'PW21A-TS100201BL-M', 0, 0, '2021-04-15 12:50:53.545763', '2021-04-15 12:50:53.545763', NULL),
	(10000787, 1, 'PW21A-TS100201BL-L', 2, 0, '2021-04-15 12:50:53.551677', '2021-04-15 12:50:53.551677', NULL),
	(10000788, 1, 'PW21A-TS100201BL-XL', 7, 0, '2021-04-15 12:50:53.552453', '2021-04-15 12:50:53.552453', NULL),
	(10000789, 1, 'PW21A-TS100201BL-XXL', 4, 0, '2021-04-15 12:50:53.552887', '2021-04-15 12:50:53.552887', NULL),
	(10000790, 1, 'PW21A-TS100202BL-XS', 0, 0, '2021-04-15 12:50:53.552103', '2021-04-15 12:50:53.552103', NULL),
	(10000791, 1, 'PW21A-TS100202BL-S', 7, 0, '2021-04-15 12:50:53.562385', '2021-04-15 12:50:53.562385', NULL),
	(10000792, 1, 'PW21A-TS100202BL-M', 2, 0, '2021-04-15 12:50:53.563015', '2021-04-15 12:50:53.563015', NULL),
	(10000793, 1, 'PW21A-TS100202BL-L', 1, 0, '2021-04-15 12:50:53.563334', '2021-04-15 12:50:53.563334', NULL),
	(10000794, 1, 'PW21A-TS100202BL-XL', 1, 0, '2021-04-15 12:50:53.563894', '2021-04-15 12:50:53.563894', NULL),
	(10000795, 1, 'PW21A-TS100202BL-XXL', 0, 0, '2021-04-15 12:50:53.565283', '2021-04-15 12:50:53.565283', NULL),
	(10000796, 1, 'PW21A-TS100203BL-XS', 0, 0, '2021-04-15 12:50:53.566417', '2021-04-15 12:50:53.566417', NULL),
	(10000797, 1, 'PW21A-TS100203BL-S', 21, 0, '2021-04-15 12:50:53.572853', '2021-04-15 12:50:53.572853', NULL),
	(10000798, 1, 'PW21A-TS100203BL-M', 20, 0, '2021-04-15 12:50:53.574952', '2021-04-15 12:50:53.574952', NULL),
	(10000799, 1, 'PW21A-TS100203BL-L', 40, 0, '2021-04-15 12:50:53.575324', '2021-04-15 12:50:53.575324', NULL),
	(10000800, 1, 'PW21A-TS100203BL-XL', 21, 0, '2021-04-15 12:50:53.576355', '2021-04-15 12:50:53.576355', NULL),
	(10000801, 1, 'PW21A-TS100203BL-XXL', 10, 0, '2021-04-15 12:50:53.581881', '2021-04-15 12:50:53.581881', NULL),
	(10000802, 1, 'PW21A-TS100204BL-XS', 0, 0, '2021-04-15 12:50:53.583309', '2021-04-15 12:50:53.583309', NULL),
	(10000803, 1, 'PW21A-TS100204BL-S', 0, 0, '2021-04-15 12:50:53.584114', '2021-04-15 12:50:53.584114', NULL),
	(10000804, 1, 'PW21A-TS100204BL-M', 0, 0, '2021-04-15 12:50:53.584804', '2021-04-15 12:50:53.584804', NULL),
	(10000805, 1, 'PW21A-TS100204BL-L', 0, 0, '2021-04-15 12:50:53.586242', '2021-04-15 12:50:53.586242', NULL),
	(10000806, 1, 'PW21A-TS100204BL-XL', 10, 0, '2021-04-15 12:50:53.587953', '2021-04-15 12:50:53.587953', NULL),
	(10000807, 1, 'PW21A-TS100204BL-XXL', 0, 0, '2021-04-15 12:50:53.591920', '2021-04-15 12:50:53.591920', NULL),
	(10000808, 1, 'PW21A-TS100205WT-XS', 0, 0, '2021-04-15 12:50:53.602070', '2021-04-15 12:50:53.602070', NULL),
	(10000809, 1, 'PW21A-TS100205WT-S', 0, 0, '2021-04-15 12:50:53.599676', '2021-04-15 12:50:53.599676', NULL),
	(10000810, 1, 'PW21A-TS100205WT-M', 0, 0, '2021-04-15 12:50:53.605215', '2021-04-15 12:50:53.605215', NULL),
	(10000811, 1, 'PW21A-TS100205WT-L', 0, 0, '2021-04-15 12:50:53.622762', '2021-04-15 12:50:53.622762', NULL),
	(10000812, 1, 'PW21A-TS100205WT-XL', 0, 0, '2021-04-15 12:50:53.617269', '2021-04-15 12:50:53.617269', NULL),
	(10000813, 1, 'PW21A-TS100205WT-XXL', 0, 0, '2021-04-15 12:50:53.624198', '2021-04-15 12:50:53.624198', NULL),
	(10000814, 1, 'PW21A-TS100206WT-XS', 0, 0, '2021-04-15 12:50:53.625309', '2021-04-15 12:50:53.625309', NULL),
	(10000815, 1, 'PW21A-TS100206WT-S', 0, 0, '2021-04-15 12:50:53.626007', '2021-04-15 12:50:53.626007', NULL),
	(10000816, 1, 'PW21A-TS100206WT-M', 0, 0, '2021-04-15 12:50:53.634608', '2021-04-15 12:50:53.634608', NULL),
	(10000817, 1, 'PW21A-TS100206WT-L', 0, 0, '2021-04-15 12:50:53.635147', '2021-04-15 12:50:53.635147', NULL),
	(10000818, 1, 'PW21A-TS100206WT-XL', 0, 0, '2021-04-15 12:50:53.638219', '2021-04-15 12:50:53.638219', NULL),
	(10000819, 1, 'PW21A-TS100206WT-XXL', 0, 0, '2021-04-15 12:50:53.638909', '2021-04-15 12:50:53.638909', NULL),
	(10000820, 1, 'PW21A-TS100207BL-XS', 0, 0, '2021-04-15 12:50:53.641531', '2021-04-15 12:50:53.641531', NULL),
	(10000821, 1, 'PW21A-TS100207BL-S', 29, 0, '2021-04-15 12:50:53.656107', '2021-04-15 12:50:53.656107', NULL),
	(10000822, 1, 'PW21A-TS100207BL-M', 23, 0, '2021-04-15 12:50:53.657101', '2021-04-15 12:50:53.657101', NULL),
	(10000823, 1, 'PW21A-TS100207BL-L', 25, 0, '2021-04-15 12:50:53.657611', '2021-04-15 12:50:53.657611', NULL),
	(10000824, 1, 'PW21A-TS100207BL-XL', 17, 0, '2021-04-15 12:50:53.658046', '2021-04-15 12:50:53.658046', NULL),
	(10000825, 1, 'PW21A-TS100207BL-XXL', 7, 0, '2021-04-15 12:50:53.659149', '2021-04-15 12:50:53.659149', NULL),
	(10000826, 1, 'PW21A-TS100208BL-XS', 0, 0, '2021-04-15 12:50:53.667346', '2021-04-15 12:50:53.667346', NULL),
	(10000827, 1, 'PW21A-TS100208BL-S', 0, 0, '2021-04-15 12:50:53.670106', '2021-04-15 12:50:53.670106', NULL),
	(10000828, 1, 'PW21A-TS100208BL-M', 0, 0, '2021-04-15 12:50:53.671226', '2021-04-15 12:50:53.671226', NULL),
	(10000829, 1, 'PW21A-TS100208BL-L', 0, 0, '2021-04-15 12:50:53.671617', '2021-04-15 12:50:53.671617', NULL),
	(10000830, 1, 'PW21A-TS100208BL-XL', 0, 0, '2021-04-15 12:50:53.672617', '2021-04-15 12:50:53.672617', NULL),
	(10000831, 1, 'PW21A-TS100208BL-XXL', 0, 0, '2021-04-15 12:50:53.684130', '2021-04-15 12:50:53.684130', NULL),
	(10000832, 1, 'PW21A-TS100209BL-XS', 0, 0, '2021-04-15 12:50:53.685387', '2021-04-15 12:50:53.685387', NULL),
	(10000833, 1, 'PW21A-TS100209BL-S', 26, 0, '2021-04-15 12:50:53.686002', '2021-04-15 12:50:53.686002', NULL),
	(10000834, 1, 'PW21A-TS100209BL-M', 19, 0, '2021-04-15 12:50:53.687339', '2021-04-15 12:50:53.687339', NULL),
	(10000835, 1, 'PW21A-TS100209BL-L', 18, 0, '2021-04-15 12:50:53.687834', '2021-04-15 12:50:53.687834', NULL),
	(10000836, 1, 'PW21A-TS100209BL-XL', 6, 0, '2021-04-15 12:50:53.694788', '2021-04-15 12:50:53.694788', NULL),
	(10000837, 1, 'PW21A-TS100209BL-XXL', 7, 0, '2021-04-15 12:50:53.697174', '2021-04-15 12:50:53.697174', NULL),
	(10000838, 1, 'PW21A-TS100210BL-XS', 0, 0, '2021-04-15 12:50:53.698848', '2021-04-15 12:50:53.698848', NULL),
	(10000839, 1, 'PW21A-TS100210BL-S', 0, 0, '2021-04-15 12:50:53.703002', '2021-04-15 12:50:53.703002', NULL),
	(10000840, 1, 'PW21A-TS100210BL-M', 0, 0, '2021-04-15 12:50:53.703522', '2021-04-15 12:50:53.703522', NULL),
	(10000841, 1, 'PW21A-TS100210BL-L', 0, 0, '2021-04-15 12:50:53.714294', '2021-04-15 12:50:53.714294', NULL),
	(10000842, 1, 'PW21A-TS100210BL-XL', 0, 0, '2021-04-15 12:50:53.714782', '2021-04-15 12:50:53.714782', NULL),
	(10000843, 1, 'PW21A-TS100210BL-XXL', 0, 0, '2021-04-15 12:50:53.715214', '2021-04-15 12:50:53.715214', NULL),
	(10000844, 1, 'PW21A-TS100211BL-XS', 0, 0, '2021-04-15 12:50:53.716852', '2021-04-15 12:50:53.716852', NULL),
	(10000845, 1, 'PW21A-TS100211BL-S', 0, 0, '2021-04-15 12:50:53.717399', '2021-04-15 12:50:53.717399', NULL),
	(10000846, 1, 'PW21A-TS100211BL-M', 0, 0, '2021-04-15 12:50:53.723626', '2021-04-15 12:50:53.723626', NULL),
	(10000847, 1, 'PW21A-TS100211BL-L', 0, 0, '2021-04-15 12:50:53.726584', '2021-04-15 12:50:53.726584', NULL),
	(10000848, 1, 'PW21A-TS100211BL-XL', 0, 0, '2021-04-15 12:50:53.729134', '2021-04-15 12:50:53.729134', NULL),
	(10000849, 1, 'PW21A-TS100211BL-XXL', 0, 0, '2021-04-15 12:50:53.729698', '2021-04-15 12:50:53.729698', NULL),
	(10000850, 1, 'PW21A-TS100212GN-XS', 0, 0, '2021-04-15 12:50:53.730762', '2021-04-15 12:50:53.730762', NULL),
	(10000851, 1, 'PW21A-TS100212GN-S', 0, 0, '2021-04-15 12:50:53.739516', '2021-04-15 12:50:53.739516', NULL),
	(10000852, 1, 'PW21A-TS100212GN-M', 1, 0, '2021-04-15 12:50:53.740484', '2021-04-15 12:50:53.740484', NULL),
	(10000853, 1, 'PW21A-TS100212GN-L', 0, 0, '2021-04-15 12:50:53.740834', '2021-04-15 12:50:53.740834', NULL),
	(10000854, 1, 'PW21A-TS100212GN-XL', 0, 0, '2021-04-15 12:50:53.741961', '2021-04-15 12:50:53.741961', NULL),
	(10000855, 1, 'PW21A-TS100212GN-XXL', 2, 0, '2021-04-15 12:50:53.742367', '2021-04-15 12:50:53.742367', NULL),
	(10000856, 1, 'PW21A-TS100213BL-XS', 0, 0, '2021-04-15 12:50:53.745092', '2021-04-15 12:50:53.745092', NULL),
	(10000857, 1, 'PW21A-TS100213BL-S', 17, 0, '2021-04-15 12:50:53.758423', '2021-04-15 12:50:53.758423', NULL),
	(10000858, 1, 'PW21A-TS100213BL-M', 4, 0, '2021-04-15 12:50:53.767355', '2021-04-15 12:50:53.767355', NULL),
	(10000859, 1, 'PW21A-TS100213BL-L', 20, 0, '2021-04-15 12:50:53.767744', '2021-04-15 12:50:53.767744', NULL),
	(10000860, 1, 'PW21A-TS100213BL-XL', 8, 0, '2021-04-15 12:50:53.771476', '2021-04-15 12:50:53.771476', NULL),
	(10000861, 1, 'PW21A-TS100213BL-XXL', 5, 0, '2021-04-15 12:50:53.775825', '2021-04-15 12:50:53.775825', NULL),
	(10000862, 1, 'PW21A-TS100214BL-XS', 0, 0, '2021-04-15 12:50:53.779144', '2021-04-15 12:50:53.779144', NULL),
	(10000863, 1, 'PW21A-TS100214BL-S', 0, 0, '2021-04-15 12:50:53.779927', '2021-04-15 12:50:53.779927', NULL),
	(10000864, 1, 'PW21A-TS100214BL-M', 0, 0, '2021-04-15 12:50:53.781694', '2021-04-15 12:50:53.781694', NULL),
	(10000865, 1, 'PW21A-TS100214BL-L', 0, 0, '2021-04-15 12:50:53.782281', '2021-04-15 12:50:53.782281', NULL),
	(10000866, 1, 'PW21A-TS100214BL-XL', 0, 0, '2021-04-15 12:50:53.783486', '2021-04-15 12:50:53.783486', NULL),
	(10000867, 1, 'PW21A-TS100214BL-XXL', 0, 0, '2021-04-15 12:50:53.786534', '2021-04-15 12:50:53.786534', NULL),
	(10000868, 1, 'PW21A-TS100215BL-XS', 0, 0, '2021-04-15 12:50:53.798049', '2021-04-15 12:50:53.798049', NULL),
	(10000869, 1, 'PW21A-TS100215BL-S', 5, 0, '2021-04-15 12:50:53.798396', '2021-04-15 12:50:53.798396', NULL),
	(10000870, 1, 'PW21A-TS100215BL-M', 2, 0, '2021-04-15 12:50:53.800254', '2021-04-15 12:50:53.800254', NULL),
	(10000871, 1, 'PW21A-TS100215BL-L', 5, 0, '2021-04-15 12:50:53.803403', '2021-04-15 12:50:53.803403', NULL),
	(10000872, 1, 'PW21A-TS100215BL-XL', 1, 0, '2021-04-15 12:50:53.804874', '2021-04-15 12:50:53.804874', NULL),
	(10000873, 1, 'PW21A-TS100215BL-XXL', 0, 0, '2021-04-15 12:50:53.807593', '2021-04-15 12:50:53.807593', NULL),
	(10000874, 1, 'PW21A-TS100216NV-XS', 0, 0, '2021-04-15 12:50:53.809703', '2021-04-15 12:50:53.809703', NULL),
	(10000875, 1, 'PW21A-TS100216NV-S', 1, 0, '2021-04-15 12:50:53.810969', '2021-04-15 12:50:53.810969', NULL),
	(10000876, 1, 'PW21A-TS100216NV-M', 0, 0, '2021-04-15 12:50:53.811516', '2021-04-15 12:50:53.811516', NULL),
	(10000877, 1, 'PW21A-TS100216NV-L', 0, 0, '2021-04-15 12:50:53.814635', '2021-04-15 12:50:53.814635', NULL),
	(10000878, 1, 'PW21A-TS100216NV-XL', 0, 0, '2021-04-15 12:50:53.820526', '2021-04-15 12:50:53.820526', NULL),
	(10000879, 1, 'PW21A-TS100216NV-XXL', 0, 0, '2021-04-15 12:50:53.822295', '2021-04-15 12:50:53.822295', NULL),
	(10000880, 1, 'PW21A-TS100217BL-XS', 0, 0, '2021-04-15 12:50:53.824032', '2021-04-15 12:50:53.824032', NULL),
	(10000881, 1, 'PW21A-TS100217BL-S', 1, 0, '2021-04-15 12:50:53.829263', '2021-04-15 12:50:53.829263', NULL),
	(10000882, 1, 'PW21A-TS100217BL-M', 0, 0, '2021-04-15 12:50:53.832538', '2021-04-15 12:50:53.832538', NULL),
	(10000883, 1, 'PW21A-TS100217BL-L', 0, 0, '2021-04-15 12:50:53.833827', '2021-04-15 12:50:53.833827', NULL),
	(10000884, 1, 'PW21A-TS100217BL-XL', 1, 0, '2021-04-15 12:50:53.841050', '2021-04-15 12:50:53.841050', NULL),
	(10000885, 1, 'PW21A-TS100217BL-XXL', 0, 0, '2021-04-15 12:50:53.842869', '2021-04-15 12:50:53.842869', NULL),
	(10000886, 1, 'PW21A-TS100218BL-XS', 0, 0, '2021-04-15 12:50:53.843440', '2021-04-15 12:50:53.843440', NULL),
	(10000887, 1, 'PW21A-TS100218BL-S', 12, 0, '2021-04-15 12:50:53.844739', '2021-04-15 12:50:53.844739', NULL),
	(10000888, 1, 'PW21A-TS100218BL-M', 12, 0, '2021-04-15 12:50:53.853095', '2021-04-15 12:50:53.853095', NULL),
	(10000889, 1, 'PW21A-TS100218BL-L', 13, 0, '2021-04-15 12:50:53.858261', '2021-04-15 12:50:53.858261', NULL),
	(10000890, 1, 'PW21A-TS100218BL-XL', 0, 0, '2021-04-15 12:50:53.862908', '2021-04-15 12:50:53.862908', NULL),
	(10000891, 1, 'PW21A-TS100218BL-XXL', 0, 0, '2021-04-15 12:50:53.869915', '2021-04-15 12:50:53.869915', NULL),
	(10000892, 1, 'PW21A-TS100219BL-XS', 0, 0, '2021-04-15 12:50:53.873599', '2021-04-15 12:50:53.873599', NULL),
	(10000893, 1, 'PW21A-TS100219BL-S', 18, 0, '2021-04-15 12:50:53.871963', '2021-04-15 12:50:53.871963', NULL),
	(10000894, 1, 'PW21A-TS100219BL-M', 24, 0, '2021-04-15 12:50:53.873015', '2021-04-15 12:50:53.873015', NULL),
	(10000895, 1, 'PW21A-TS100219BL-L', 32, 0, '2021-04-15 12:50:53.877938', '2021-04-15 12:50:53.877938', NULL),
	(10000896, 1, 'PW21A-TS100219BL-XL', 17, 0, '2021-04-15 12:50:53.882437', '2021-04-15 12:50:53.882437', NULL),
	(10000897, 1, 'PW21A-TS100219BL-XXL', 4, 0, '2021-04-15 12:50:53.883707', '2021-04-15 12:50:53.883707', NULL),
	(10000898, 1, 'PW21A-TS100220BL-XS', 0, 0, '2021-04-15 12:50:53.888828', '2021-04-15 12:50:53.888828', NULL),
	(10000899, 1, 'PW21A-TS100220BL-S', 21, 0, '2021-04-15 12:50:53.890626', '2021-04-15 12:50:53.890626', NULL),
	(10000900, 1, 'PW21A-TS100220BL-M', 25, 0, '2021-04-15 12:50:53.898492', '2021-04-15 12:50:53.898492', NULL),
	(10000901, 1, 'PW21A-TS100220BL-L', 23, 0, '2021-04-15 12:50:53.908492', '2021-04-15 12:50:53.908492', NULL),
	(10000902, 1, 'PW21A-TS100220BL-XL', 2, 0, '2021-04-15 12:50:53.909614', '2021-04-15 12:50:53.909614', NULL),
	(10000903, 1, 'PW21A-TS100220BL-XXL', 4, 0, '2021-04-15 12:50:53.910428', '2021-04-15 12:50:53.910428', NULL),
	(10000904, 1, 'PW21A-TK100221BL-XS', 0, 0, '2021-04-15 12:50:53.910777', '2021-04-15 12:50:53.910777', NULL),
	(10000905, 1, 'PW21A-TK100221BL-S', 0, 0, '2021-04-15 12:50:53.914017', '2021-04-15 12:50:53.914017', NULL),
	(10000906, 1, 'PW21A-TK100221BL-M', 3, 0, '2021-04-15 12:50:53.914352', '2021-04-15 12:50:53.914352', NULL),
	(10000907, 1, 'PW21A-TK100221BL-L', 13, 0, '2021-04-15 12:50:53.916945', '2021-04-15 12:50:53.916945', NULL),
	(10000908, 1, 'PW21A-TK100221BL-XL', 4, 0, '2021-04-15 12:50:53.920147', '2021-04-15 12:50:53.920147', NULL),
	(10000909, 1, 'PW21A-TK100221BL-XXL', 2, 0, '2021-04-15 12:50:53.920780', '2021-04-15 12:50:53.920780', NULL),
	(10000910, 1, 'PW21A-TS100222BL-XS', 0, 0, '2021-04-15 12:50:53.921586', '2021-04-15 12:50:53.921586', NULL),
	(10000911, 1, 'PW21A-TS100222BL-S', 11, 0, '2021-04-15 12:50:53.930918', '2021-04-15 12:50:53.930918', NULL),
	(10000912, 1, 'PW21A-TS100222BL-M', 20, 0, '2021-04-15 12:50:53.931246', '2021-04-15 12:50:53.931246', NULL),
	(10000913, 1, 'PW21A-TS100222BL-L', 32, 0, '2021-04-15 12:50:53.937513', '2021-04-15 12:50:53.937513', NULL),
	(10000914, 1, 'PW21A-TS100222BL-XL', 5, 0, '2021-04-15 12:50:53.937875', '2021-04-15 12:50:53.937875', NULL),
	(10000915, 1, 'PW21A-TS100222BL-XXL', 1, 0, '2021-04-15 12:50:53.940420', '2021-04-15 12:50:53.940420', NULL),
	(10000916, 1, 'PW21A-TS100223BL-XS', 0, 0, '2021-04-15 12:50:53.941129', '2021-04-15 12:50:53.941129', NULL),
	(10000917, 1, 'PW21A-TS100223BL-S', 7, 0, '2021-04-15 12:50:53.943881', '2021-04-15 12:50:53.943881', NULL),
	(10000918, 1, 'PW21A-TS100223BL-M', 4, 0, '2021-04-15 12:50:53.944276', '2021-04-15 12:50:53.944276', NULL),
	(10000919, 1, 'PW21A-TS100223BL-L', 20, 0, '2021-04-15 12:50:53.946122', '2021-04-15 12:50:53.946122', NULL),
	(10000920, 1, 'PW21A-TS100223BL-XL', 8, 0, '2021-04-15 12:50:53.946452', '2021-04-15 12:50:53.946452', NULL),
	(10000921, 1, 'PW21A-TS100223BL-XXL', 3, 0, '2021-04-15 12:50:53.956845', '2021-04-15 12:50:53.956845', NULL),
	(10000922, 1, 'PW21A-TK100224BL-XS', 0, 0, '2021-04-15 12:50:53.957251', '2021-04-15 12:50:53.957251', NULL),
	(10000923, 1, 'PW21A-TK100224BL-S', 0, 0, '2021-04-15 12:50:53.957738', '2021-04-15 12:50:53.957738', NULL),
	(10000924, 1, 'PW21A-TK100224BL-M', 0, 0, '2021-04-15 12:50:53.958857', '2021-04-15 12:50:53.958857', NULL),
	(10000925, 1, 'PW21A-TK100224BL-L', 4, 0, '2021-04-15 12:50:53.959509', '2021-04-15 12:50:53.959509', NULL),
	(10000926, 1, 'PW21A-TK100224BL-XL', 0, 0, '2021-04-15 12:50:53.963395', '2021-04-15 12:50:53.963395', NULL),
	(10000927, 1, 'PW21A-TK100224BL-XXL', 0, 0, '2021-04-15 12:50:53.971127', '2021-04-15 12:50:53.971127', NULL),
	(10000928, 1, 'PW21A-TK100225BL-XS', 0, 0, '2021-04-15 12:50:53.974699', '2021-04-15 12:50:53.974699', NULL),
	(10000929, 1, 'PW21A-TK100225BL-S', 0, 0, '2021-04-15 12:50:53.975271', '2021-04-15 12:50:53.975271', NULL),
	(10000930, 1, 'PW21A-TK100225BL-M', 1, 0, '2021-04-15 12:50:53.975667', '2021-04-15 12:50:53.975667', NULL),
	(10000931, 1, 'PW21A-TK100225BL-L', 10, 0, '2021-04-15 12:50:53.984063', '2021-04-15 12:50:53.984063', NULL),
	(10000932, 1, 'PW21A-TK100225BL-XL', 2, 0, '2021-04-15 12:50:53.989073', '2021-04-15 12:50:53.989073', NULL),
	(10000933, 1, 'PW21A-TK100225BL-XXL', 0, 0, '2021-04-15 12:50:53.992131', '2021-04-15 12:50:53.992131', NULL),
	(10000934, 1, 'PW21A-TS100226BL-XS', 0, 0, '2021-04-15 12:50:53.992627', '2021-04-15 12:50:53.992627', NULL),
	(10000935, 1, 'PW21A-TS100226BL-S', 7, 0, '2021-04-15 12:50:53.993168', '2021-04-15 12:50:53.993168', NULL),
	(10000936, 1, 'PW21A-TS100226BL-M', 0, 0, '2021-04-15 12:50:53.993663', '2021-04-15 12:50:53.993663', NULL),
	(10000937, 1, 'PW21A-TS100226BL-L', 13, 0, '2021-04-15 12:50:53.999338', '2021-04-15 12:50:53.999338', NULL),
	(10000938, 1, 'PW21A-TS100226BL-XL', 3, 0, '2021-04-15 12:50:53.999708', '2021-04-15 12:50:53.999708', NULL),
	(10000939, 1, 'PW21A-TS100226BL-XXL', 0, 0, '2021-04-15 12:50:54.002161', '2021-04-15 12:50:54.002161', NULL),
	(10000940, 1, 'PW21A-TK100227BL-XS', 0, 0, '2021-04-15 12:50:54.002559', '2021-04-15 12:50:54.002559', NULL),
	(10000941, 1, 'PW21A-TK100227BL-S', 0, 0, '2021-04-15 12:50:54.010677', '2021-04-15 12:50:54.010677', NULL),
	(10000942, 1, 'PW21A-TK100227BL-M', 5, 0, '2021-04-15 12:50:54.014632', '2021-04-15 12:50:54.014632', NULL),
	(10000943, 1, 'PW21A-TK100227BL-L', 12, 0, '2021-04-15 12:50:54.016142', '2021-04-15 12:50:54.016142', NULL),
	(10000944, 1, 'PW21A-TK100227BL-XL', 3, 0, '2021-04-15 12:50:54.016507', '2021-04-15 12:50:54.016507', NULL),
	(10000945, 1, 'PW21A-TK100227BL-XXL', 0, 0, '2021-04-15 12:50:54.017790', '2021-04-15 12:50:54.017790', NULL),
	(10000946, 1, 'PW21A-TS100228BL-XS', 0, 0, '2021-04-15 12:50:54.018222', '2021-04-15 12:50:54.018222', NULL),
	(10000947, 1, 'PW21A-TS100228BL-S', 15, 0, '2021-04-15 12:50:54.025835', '2021-04-15 12:50:54.025835', NULL),
	(10000948, 1, 'PW21A-TS100228BL-M', 0, 0, '2021-04-15 12:50:54.031280', '2021-04-15 12:50:54.031280', NULL),
	(10000949, 1, 'PW21A-TS100228BL-L', 12, 0, '2021-04-15 12:50:54.026479', '2021-04-15 12:50:54.026479', NULL),
	(10000950, 1, 'PW21A-TS100228BL-XL', 6, 0, '2021-04-15 12:50:54.036072', '2021-04-15 12:50:54.036072', NULL),
	(10000951, 1, 'PW21A-TS100228BL-XXL', 1, 0, '2021-04-15 12:50:54.044597', '2021-04-15 12:50:54.044597', NULL),
	(10000952, 1, 'PW21A-TK100229BL-XS', 0, 0, '2021-04-15 12:50:54.048269', '2021-04-15 12:50:54.048269', NULL),
	(10000953, 1, 'PW21A-TK100229BL-S', 0, 0, '2021-04-15 12:50:54.050146', '2021-04-15 12:50:54.050146', NULL),
	(10000954, 1, 'PW21A-TK100229BL-M', 7, 0, '2021-04-15 12:50:54.050593', '2021-04-15 12:50:54.050593', NULL),
	(10000955, 1, 'PW21A-TK100229BL-L', 12, 0, '2021-04-15 12:50:54.052193', '2021-04-15 12:50:54.052193', NULL),
	(10000956, 1, 'PW21A-TK100229BL-XL', 6, 0, '2021-04-15 12:50:54.052916', '2021-04-15 12:50:54.052916', NULL),
	(10000957, 1, 'PW21A-TK100229BL-XXL', 1, 0, '2021-04-15 12:50:54.056703', '2021-04-15 12:50:54.056703', NULL),
	(10000958, 1, 'PW21A-TK100230BL-XS', 0, 0, '2021-04-15 12:50:54.057541', '2021-04-15 12:50:54.057541', NULL),
	(10000959, 1, 'PW21A-TK100230BL-S', 0, 0, '2021-04-15 12:50:54.058919', '2021-04-15 12:50:54.058919', NULL),
	(10000960, 1, 'PW21A-TK100230BL-M', 6, 0, '2021-04-15 12:50:54.060877', '2021-04-15 12:50:54.060877', NULL),
	(10000961, 1, 'PW21A-TK100230BL-L', 9, 0, '2021-04-15 12:50:54.075017', '2021-04-15 12:50:54.075017', NULL),
	(10000962, 1, 'PW21A-TK100230BL-XL', 3, 0, '2021-04-15 12:50:54.078028', '2021-04-15 12:50:54.078028', NULL),
	(10000963, 1, 'PW21A-TK100230BL-XXL', 0, 0, '2021-04-15 12:50:54.079960', '2021-04-15 12:50:54.079960', NULL),
	(10000964, 1, 'PW21A-TS100231BL-XS', 0, 0, '2021-04-15 12:50:54.080309', '2021-04-15 12:50:54.080309', NULL),
	(10000965, 1, 'PW21A-TS100231BL-S', 0, 0, '2021-04-15 12:50:54.078375', '2021-04-15 12:50:54.078375', NULL),
	(10000966, 1, 'PW21A-TS100231BL-M', 0, 0, '2021-04-15 12:50:54.081455', '2021-04-15 12:50:54.081455', NULL),
	(10000967, 1, 'PW21A-TS100231BL-L', 0, 0, '2021-04-15 12:50:54.083295', '2021-04-15 12:50:54.083295', NULL),
	(10000968, 1, 'PW21A-TS100231BL-XL', 0, 0, '2021-04-15 12:50:54.085623', '2021-04-15 12:50:54.085623', NULL),
	(10000969, 1, 'PW21A-TS100231BL-XXL', 0, 0, '2021-04-15 12:50:54.087959', '2021-04-15 12:50:54.087959', NULL),
	(10000970, 1, 'PW21A-TK100232GN-XS', 0, 0, '2021-04-15 12:50:54.091293', '2021-04-15 12:50:54.091293', NULL),
	(10000971, 1, 'PW21A-TK100232GN-S', 0, 0, '2021-04-15 12:50:54.099398', '2021-04-15 12:50:54.099398', NULL),
	(10000972, 1, 'PW21A-TK100232GN-M', 0, 0, '2021-04-15 12:50:54.103893', '2021-04-15 12:50:54.103893', NULL),
	(10000973, 1, 'PW21A-TK100232GN-L', 1, 0, '2021-04-15 12:50:54.109107', '2021-04-15 12:50:54.109107', NULL),
	(10000974, 1, 'PW21A-TK100232GN-XL', 0, 0, '2021-04-15 12:50:54.110881', '2021-04-15 12:50:54.110881', NULL),
	(10000975, 1, 'PW21A-TK100232GN-XXL', 1, 0, '2021-04-15 12:50:54.107473', '2021-04-15 12:50:54.107473', NULL),
	(10000976, 1, 'PW21A-TS100233BL-XS', 0, 0, '2021-04-15 12:50:54.107982', '2021-04-15 12:50:54.107982', NULL),
	(10000977, 1, 'PW21A-TS100233BL-S', 0, 0, '2021-04-15 12:50:54.114012', '2021-04-15 12:50:54.114012', NULL),
	(10000978, 1, 'PW21A-TS100233BL-M', 0, 0, '2021-04-15 12:50:54.115173', '2021-04-15 12:50:54.115173', NULL),
	(10000979, 1, 'PW21A-TS100233BL-L', 0, 0, '2021-04-15 12:50:54.117440', '2021-04-15 12:50:54.117440', NULL),
	(10000980, 1, 'PW21A-TS100233BL-XL', 0, 0, '2021-04-15 12:50:54.119054', '2021-04-15 12:50:54.119054', NULL),
	(10000981, 1, 'PW21A-TS100233BL-XXL', 0, 0, '2021-04-15 12:50:54.124945', '2021-04-15 12:50:54.124945', NULL),
	(10000982, 1, 'PW21A-TK100234BL-XS', 0, 0, '2021-04-15 12:50:54.127815', '2021-04-15 12:50:54.127815', NULL),
	(10000983, 1, 'PW21A-TK100234BL-S', 0, 0, '2021-04-15 12:50:54.130632', '2021-04-15 12:50:54.130632', NULL),
	(10000984, 1, 'PW21A-TK100234BL-M', 0, 0, '2021-04-15 12:50:54.131106', '2021-04-15 12:50:54.131106', NULL),
	(10000985, 1, 'PW21A-TK100234BL-L', 2, 0, '2021-04-15 12:50:54.131474', '2021-04-15 12:50:54.131474', NULL),
	(10000986, 1, 'PW21A-TK100234BL-XL', 0, 0, '2021-04-15 12:50:54.134265', '2021-04-15 12:50:54.134265', NULL),
	(10000987, 1, 'PW21A-TK100234BL-XXL', 1, 0, '2021-04-15 12:50:54.136800', '2021-04-15 12:50:54.136800', NULL),
	(10000988, 1, 'PW21A-TS100235BL-XS', 0, 0, '2021-04-15 12:50:54.141314', '2021-04-15 12:50:54.141314', NULL),
	(10000989, 1, 'PW21A-TS100235BL-S', 4, 0, '2021-04-15 12:50:54.142677', '2021-04-15 12:50:54.142677', NULL),
	(10000990, 1, 'PW21A-TS100235BL-M', 7, 0, '2021-04-15 12:50:54.144597', '2021-04-15 12:50:54.144597', NULL),
	(10000991, 1, 'PW21A-TS100235BL-L', 1, 0, '2021-04-15 12:50:54.148577', '2021-04-15 12:50:54.148577', NULL),
	(10000992, 1, 'PW21A-TS100235BL-XL', 0, 0, '2021-04-15 12:50:54.151491', '2021-04-15 12:50:54.151491', NULL),
	(10000993, 1, 'PW21A-TS100235BL-XXL', 0, 0, '2021-04-15 12:50:54.154330', '2021-04-15 12:50:54.154330', NULL),
	(10000994, 1, 'PW21A-TK100236WT-XS', 0, 0, '2021-04-15 12:50:54.154670', '2021-04-15 12:50:54.154670', NULL),
	(10000995, 1, 'PW21A-TK100236WT-S', 0, 0, '2021-04-15 12:50:54.156144', '2021-04-15 12:50:54.156144', NULL),
	(10000996, 1, 'PW21A-TK100236WT-M', 2, 0, '2021-04-15 12:50:54.158852', '2021-04-15 12:50:54.158852', NULL),
	(10000997, 1, 'PW21A-TK100236WT-L', 7, 0, '2021-04-15 12:50:54.162513', '2021-04-15 12:50:54.162513', NULL),
	(10000998, 1, 'PW21A-TK100236WT-XL', 4, 0, '2021-04-15 12:50:54.165090', '2021-04-15 12:50:54.165090', NULL),
	(10000999, 1, 'PW21A-TK100236WT-XXL', 1, 0, '2021-04-15 12:50:54.165875', '2021-04-15 12:50:54.165875', NULL),
	(10001000, 1, 'PW21A-TS100237BL-XS', 0, 0, '2021-04-15 12:50:54.168540', '2021-04-15 12:50:54.168540', NULL),
	(10001001, 1, 'PW21A-TS100237BL-S', 0, 0, '2021-04-15 12:50:54.173349', '2021-04-15 12:50:54.173349', NULL),
	(10001002, 1, 'PW21A-TS100237BL-M', 0, 0, '2021-04-15 12:50:54.177118', '2021-04-15 12:50:54.177118', NULL),
	(10001003, 1, 'PW21A-TS100237BL-L', 0, 0, '2021-04-15 12:50:54.179525', '2021-04-15 12:50:54.179525', NULL),
	(10001004, 1, 'PW21A-TS100237BL-XL', 0, 0, '2021-04-15 12:50:54.180356', '2021-04-15 12:50:54.180356', NULL),
	(10001005, 1, 'PW21A-TS100237BL-XXL', 0, 0, '2021-04-15 12:50:54.180956', '2021-04-15 12:50:54.180956', NULL),
	(10001006, 1, 'PW21A-TS100238BL-XS', 0, 0, '2021-04-15 12:50:54.183457', '2021-04-15 12:50:54.183457', NULL),
	(10001007, 1, 'PW21A-TS100238BL-S', 0, 0, '2021-04-15 12:50:54.187177', '2021-04-15 12:50:54.187177', NULL),
	(10001008, 1, 'PW21A-TS100238BL-M', 0, 0, '2021-04-15 12:50:54.195106', '2021-04-15 12:50:54.195106', NULL),
	(10001009, 1, 'PW21A-TS100238BL-L', 0, 0, '2021-04-15 12:50:54.197216', '2021-04-15 12:50:54.197216', NULL),
	(10001010, 1, 'PW21A-TS100238BL-XL', 0, 0, '2021-04-15 12:50:54.197557', '2021-04-15 12:50:54.197557', NULL),
	(10001011, 1, 'PW21A-TS100238BL-XXL', 0, 0, '2021-04-15 12:50:54.199792', '2021-04-15 12:50:54.199792', NULL),
	(10001012, 1, 'PW21A-TK100239OG-XS', 0, 0, '2021-04-15 12:50:54.203207', '2021-04-15 12:50:54.203207', NULL),
	(10001013, 1, 'PW21A-TK100239OG-S', 0, 0, '2021-04-15 12:50:54.206393', '2021-04-15 12:50:54.206393', NULL),
	(10001014, 1, 'PW21A-TK100239OG-M', 1, 0, '2021-04-15 12:50:54.209415', '2021-04-15 12:50:54.209415', NULL),
	(10001015, 1, 'PW21A-TK100239OG-L', 10, 0, '2021-04-15 12:50:54.209949', '2021-04-15 12:50:54.209949', NULL),
	(10001016, 1, 'PW21A-TK100239OG-XL', 2, 0, '2021-04-15 12:50:54.210312', '2021-04-15 12:50:54.210312', NULL),
	(10001017, 1, 'PW21A-TK100239OG-XXL', 0, 0, '2021-04-15 12:50:54.213011', '2021-04-15 12:50:54.213011', NULL),
	(10001018, 1, 'PW21A-TK100240OG-XS', 0, 0, '2021-04-15 12:50:54.212483', '2021-04-15 12:50:54.212483', NULL),
	(10001019, 1, 'PW21A-TK100240OG-S', 0, 0, '2021-04-15 12:50:54.216880', '2021-04-15 12:50:54.216880', NULL),
	(10001020, 1, 'PW21A-TK100240OG-M', 0, 0, '2021-04-15 12:50:54.223064', '2021-04-15 12:50:54.223064', NULL),
	(10001021, 1, 'PW21A-TK100240OG-L', 0, 0, '2021-04-15 12:50:54.223909', '2021-04-15 12:50:54.223909', NULL),
	(10001022, 1, 'PW21A-TK100240OG-XL', 0, 0, '2021-04-15 12:50:54.227040', '2021-04-15 12:50:54.227040', NULL),
	(10001023, 1, 'PW21A-TK100240OG-XXL', 0, 0, '2021-04-15 12:50:54.229397', '2021-04-15 12:50:54.229397', NULL),
	(10001024, 1, 'PW21A-TS100241YW -XS', 0, 0, '2021-04-15 12:50:54.233504', '2021-04-15 12:50:54.233504', NULL),
	(10001025, 1, 'PW21A-TS100241YW -S', 0, 0, '2021-04-15 12:50:54.233856', '2021-04-15 12:50:54.233856', NULL),
	(10001026, 1, 'PW21A-TS100241YW -M', 0, 0, '2021-04-15 12:50:54.234319', '2021-04-15 12:50:54.234319', NULL),
	(10001027, 1, 'PW21A-TS100241YW -L', 0, 0, '2021-04-15 12:50:54.235354', '2021-04-15 12:50:54.235354', NULL),
	(10001028, 1, 'PW21A-TS100241YW -XL', 0, 0, '2021-04-15 12:50:54.237221', '2021-04-15 12:50:54.237221', NULL),
	(10001029, 1, 'PW21A-TS100241YW -XXL', 0, 0, '2021-04-15 12:50:54.241423', '2021-04-15 12:50:54.241423', NULL),
	(10001030, 1, 'PW21A-TS100242BL-XS', 0, 0, '2021-04-15 12:50:54.251155', '2021-04-15 12:50:54.251155', NULL),
	(10001031, 1, 'PW21A-TS100242BL-S', 11, 0, '2021-04-15 12:50:54.253791', '2021-04-15 12:50:54.253791', NULL),
	(10001032, 1, 'PW21A-TS100242BL-M', 22, 0, '2021-04-15 12:50:54.256604', '2021-04-15 12:50:54.256604', NULL),
	(10001033, 1, 'PW21A-TS100242BL-L', 15, 0, '2021-04-15 12:50:54.256976', '2021-04-15 12:50:54.256976', NULL),
	(10001034, 1, 'PW21A-TS100242BL-XL', 9, 0, '2021-04-15 12:50:54.262536', '2021-04-15 12:50:54.262536', NULL),
	(10001035, 1, 'PW21A-TS100242BL-XXL', 6, 0, '2021-04-15 12:50:54.263641', '2021-04-15 12:50:54.263641', NULL),
	(10001036, 1, 'PW21A-TK100243BL-XS', 0, 0, '2021-04-15 12:50:54.263957', '2021-04-15 12:50:54.263957', NULL),
	(10001037, 1, 'PW21A-TK100243BL-S', 8, 0, '2021-04-15 12:50:54.265210', '2021-04-15 12:50:54.265210', NULL),
	(10001038, 1, 'PW21A-TK100243BL-M', 7, 0, '2021-04-15 12:50:54.265578', '2021-04-15 12:50:54.265578', NULL),
	(10001039, 1, 'PW21A-TK100243BL-L', 12, 0, '2021-04-15 12:50:54.266983', '2021-04-15 12:50:54.266983', NULL),
	(10001040, 1, 'PW21A-TK100243BL-XL', 6, 0, '2021-04-15 12:50:54.274650', '2021-04-15 12:50:54.274650', NULL),
	(10001041, 1, 'PW21A-TK100243BL-XXL', 0, 0, '2021-04-15 12:50:54.276158', '2021-04-15 12:50:54.276158', NULL),
	(10001042, 1, 'PW21A-TS100244BL-XS', 0, 0, '2021-04-15 12:50:54.277629', '2021-04-15 12:50:54.277629', NULL),
	(10001043, 1, 'PW21A-TS100244BL-S', 0, 0, '2021-04-15 12:50:54.277967', '2021-04-15 12:50:54.277967', NULL),
	(10001044, 1, 'PW21A-TS100244BL-M', 0, 0, '2021-04-15 12:50:54.283661', '2021-04-15 12:50:54.283661', NULL),
	(10001045, 1, 'PW21A-TS100244BL-L', 0, 0, '2021-04-15 12:50:54.284389', '2021-04-15 12:50:54.284389', NULL),
	(10001046, 1, 'PW21A-TS100244BL-XL', 0, 0, '2021-04-15 12:50:54.285136', '2021-04-15 12:50:54.285136', NULL),
	(10001047, 1, 'PW21A-TS100244BL-XXL', 0, 0, '2021-04-15 12:50:54.286393', '2021-04-15 12:50:54.286393', NULL),
	(10001048, 1, 'PW21A-TS100245RD-XS', 0, 0, '2021-04-15 12:50:54.288476', '2021-04-15 12:50:54.288476', NULL),
	(10001049, 1, 'PW21A-TS100245RD-S', 1, 0, '2021-04-15 12:50:54.289255', '2021-04-15 12:50:54.289255', NULL),
	(10001050, 1, 'PW21A-TS100245RD-M', 0, 0, '2021-04-15 12:50:54.296136', '2021-04-15 12:50:54.296136', NULL),
	(10001051, 1, 'PW21A-TS100245RD-L', 10, 0, '2021-04-15 12:50:54.299298', '2021-04-15 12:50:54.299298', NULL),
	(10001052, 1, 'PW21A-TS100245RD-XL', 7, 0, '2021-04-15 12:50:54.299776', '2021-04-15 12:50:54.299776', NULL),
	(10001053, 1, 'PW21A-TS100245RD-XXL', 1, 0, '2021-04-15 12:50:54.297812', '2021-04-15 12:50:54.297812', NULL),
	(10001054, 1, 'PW21A-TK100246BL-XS', 0, 0, '2021-04-15 12:50:54.306003', '2021-04-15 12:50:54.306003', NULL),
	(10001055, 1, 'PW21A-TK100246BL-S', 0, 0, '2021-04-15 12:50:54.311452', '2021-04-15 12:50:54.311452', NULL),
	(10001056, 1, 'PW21A-TK100246BL-M', 6, 0, '2021-04-15 12:50:54.313060', '2021-04-15 12:50:54.313060', NULL),
	(10001057, 1, 'PW21A-TK100246BL-L', 9, 0, '2021-04-15 12:50:54.314508', '2021-04-15 12:50:54.314508', NULL),
	(10001058, 1, 'PW21A-TK100246BL-XL', 3, 0, '2021-04-15 12:50:54.315342', '2021-04-15 12:50:54.315342', NULL),
	(10001059, 1, 'PW21A-TK100246BL-XXL', 0, 0, '2021-04-15 12:50:54.316332', '2021-04-15 12:50:54.316332', NULL),
	(10001060, 1, 'PW21A-TS100247NV-XS', 0, 0, '2021-04-15 12:50:54.323020', '2021-04-15 12:50:54.323020', NULL),
	(10001061, 1, 'PW21A-TS100247NV-S', 4, 0, '2021-04-15 12:50:54.324531', '2021-04-15 12:50:54.324531', NULL),
	(10001062, 1, 'PW21A-TS100247NV-M', 0, 0, '2021-04-15 12:50:54.326804', '2021-04-15 12:50:54.326804', NULL),
	(10001063, 1, 'PW21A-TS100247NV-L', 0, 0, '2021-04-15 12:50:54.327600', '2021-04-15 12:50:54.327600', NULL),
	(10001064, 1, 'PW21A-TS100247NV-XL', 0, 0, '2021-04-15 12:50:54.332122', '2021-04-15 12:50:54.332122', NULL),
	(10001065, 1, 'PW21A-TS100247NV-XXL', 2, 0, '2021-04-15 12:50:54.335752', '2021-04-15 12:50:54.335752', NULL),
	(10001066, 1, 'PW21A-TS100248BL-XS', 0, 0, '2021-04-15 12:50:54.336501', '2021-04-15 12:50:54.336501', NULL),
	(10001067, 1, 'PW21A-TS100248BL-S', 20, 0, '2021-04-15 12:50:54.340328', '2021-04-15 12:50:54.340328', NULL),
	(10001068, 1, 'PW21A-TS100248BL-M', 14, 0, '2021-04-15 12:50:54.341489', '2021-04-15 12:50:54.341489', NULL),
	(10001069, 1, 'PW21A-TS100248BL-L', 31, 0, '2021-04-15 12:50:54.344841', '2021-04-15 12:50:54.344841', NULL),
	(10001070, 1, 'PW21A-TS100248BL-XL', 10, 0, '2021-04-15 12:50:54.349176', '2021-04-15 12:50:54.349176', NULL),
	(10001071, 1, 'PW21A-TS100248BL-XXL', 0, 0, '2021-04-15 12:50:54.351029', '2021-04-15 12:50:54.351029', NULL),
	(10001072, 1, 'PW21A-TK100249WT-XS', 0, 0, '2021-04-15 12:50:54.352879', '2021-04-15 12:50:54.352879', NULL),
	(10001073, 1, 'PW21A-TK100249WT-S', 0, 0, '2021-04-15 12:50:54.353280', '2021-04-15 12:50:54.353280', NULL),
	(10001074, 1, 'PW21A-TK100249WT-M', 1, 0, '2021-04-15 12:50:54.357481', '2021-04-15 12:50:54.357481', NULL),
	(10001075, 1, 'PW21A-TK100249WT-L', 9, 0, '2021-04-15 12:50:54.362034', '2021-04-15 12:50:54.362034', NULL),
	(10001076, 1, 'PW21A-TK100249WT-XL', 1, 0, '2021-04-15 12:50:54.364188', '2021-04-15 12:50:54.364188', NULL),
	(10001077, 1, 'PW21A-TK100249WT-XXL', 0, 0, '2021-04-15 12:50:54.363022', '2021-04-15 12:50:54.363022', NULL),
	(10001078, 1, 'PW21A-TS100250WT-XS', 0, 0, '2021-04-15 12:50:54.370473', '2021-04-15 12:50:54.370473', NULL),
	(10001079, 1, 'PW21A-TS100250WT-S', 6, 0, '2021-04-15 12:50:54.370822', '2021-04-15 12:50:54.370822', NULL),
	(10001080, 1, 'PW21A-TS100250WT-M', 0, 0, '2021-04-15 12:50:54.377031', '2021-04-15 12:50:54.377031', NULL),
	(10001081, 1, 'PW21A-TS100250WT-L', 12, 0, '2021-04-15 12:50:54.377557', '2021-04-15 12:50:54.377557', NULL),
	(10001082, 1, 'PW21A-TS100250WT-XL', 2, 0, '2021-04-15 12:50:54.380258', '2021-04-15 12:50:54.380258', NULL),
	(10001083, 1, 'PW21A-TS100250WT-XXL', 0, 0, '2021-04-15 12:50:54.381741', '2021-04-15 12:50:54.381741', NULL),
	(10001084, 1, 'PW21A-TS100251BL-XS', 0, 0, '2021-04-15 12:50:54.382707', '2021-04-15 12:50:54.382707', NULL),
	(10001085, 1, 'PW21A-TS100251BL-S', 6, 0, '2021-04-15 12:50:54.386446', '2021-04-15 12:50:54.386446', NULL),
	(10001086, 1, 'PW21A-TS100251BL-M', 1, 0, '2021-04-15 12:50:54.387370', '2021-04-15 12:50:54.387370', NULL),
	(10001087, 1, 'PW21A-TS100251BL-L', 1, 0, '2021-04-15 12:50:54.388587', '2021-04-15 12:50:54.388587', NULL),
	(10001088, 1, 'PW21A-TS100251BL-XL', 2, 0, '2021-04-15 12:50:54.392674', '2021-04-15 12:50:54.392674', NULL),
	(10001089, 1, 'PW21A-TS100251BL-XXL', 2, 0, '2021-04-15 12:50:54.393469', '2021-04-15 12:50:54.393469', NULL),
	(10001090, 1, 'PW21A-TS100252WT-XS', 0, 0, '2021-04-15 12:50:54.398527', '2021-04-15 12:50:54.398527', NULL),
	(10001091, 1, 'PW21A-TS100252WT-S', 21, 0, '2021-04-15 12:50:54.399875', '2021-04-15 12:50:54.399875', NULL),
	(10001092, 1, 'PW21A-TS100252WT-M', 28, 0, '2021-04-15 12:50:54.403308', '2021-04-15 12:50:54.403308', NULL),
	(10001093, 1, 'PW21A-TS100252WT-L', 38, 0, '2021-04-15 12:50:54.403659', '2021-04-15 12:50:54.403659', NULL),
	(10001094, 1, 'PW21A-TS100252WT-XL', 14, 0, '2021-04-15 12:50:54.404653', '2021-04-15 12:50:54.404653', NULL),
	(10001095, 1, 'PW21A-TS100252WT-XXL', 3, 0, '2021-04-15 12:50:54.408566', '2021-04-15 12:50:54.408566', NULL),
	(10001096, 1, 'PW21A-TS100253BL-XS', 0, 0, '2021-04-15 12:50:54.410128', '2021-04-15 12:50:54.410128', NULL),
	(10001097, 1, 'PW21A-TS100253BL-S', 16, 0, '2021-04-15 12:50:54.410702', '2021-04-15 12:50:54.410702', NULL),
	(10001098, 1, 'PW21A-TS100253BL-M', 23, 0, '2021-04-15 12:50:54.414715', '2021-04-15 12:50:54.414715', NULL),
	(10001099, 1, 'PW21A-TS100253BL-L', 24, 0, '2021-04-15 12:50:54.416231', '2021-04-15 12:50:54.416231', NULL),
	(10001100, 1, 'PW21A-TS100253BL-XL', 9, 0, '2021-04-15 12:50:54.422540', '2021-04-15 12:50:54.422540', NULL),
	(10001101, 1, 'PW21A-TS100253BL-XXL', 5, 0, '2021-04-15 12:50:54.423190', '2021-04-15 12:50:54.423190', NULL),
	(10001102, 1, 'PW21A-TK100254BL-XS', 0, 0, '2021-04-15 12:50:54.431911', '2021-04-15 12:50:54.431911', NULL),
	(10001103, 1, 'PW21A-TK100254BL-S', 3, 0, '2021-04-15 12:50:54.432842', '2021-04-15 12:50:54.432842', NULL),
	(10001104, 1, 'PW21A-TK100254BL-M', 8, 0, '2021-04-15 12:50:54.433687', '2021-04-15 12:50:54.433687', NULL),
	(10001105, 1, 'PW21A-TK100254BL-L', 10, 0, '2021-04-15 12:50:54.436110', '2021-04-15 12:50:54.436110', NULL),
	(10001106, 1, 'PW21A-TK100254BL-XL', 2, 0, '2021-04-15 12:50:54.437769', '2021-04-15 12:50:54.437769', NULL),
	(10001107, 1, 'PW21A-TK100254BL-XXL', 0, 0, '2021-04-15 12:50:54.438631', '2021-04-15 12:50:54.438631', NULL),
	(10001108, 1, 'PW21A-TS100255BL-XS', 0, 0, '2021-04-15 12:50:54.440872', '2021-04-15 12:50:54.440872', NULL),
	(10001109, 1, 'PW21A-TS100255BL-S', 25, 0, '2021-04-15 12:50:54.443897', '2021-04-15 12:50:54.443897', NULL),
	(10001110, 1, 'PW21A-TS100255BL-M', 24, 0, '2021-04-15 12:50:54.449954', '2021-04-15 12:50:54.449954', NULL),
	(10001111, 1, 'PW21A-TS100255BL-L', 44, 0, '2021-04-15 12:50:54.450262', '2021-04-15 12:50:54.450262', NULL),
	(10001112, 1, 'PW21A-TS100255BL-XL', 23, 0, '2021-04-15 12:50:54.451176', '2021-04-15 12:50:54.451176', NULL),
	(10001113, 1, 'PW21A-TS100255BL-XXL', 4, 0, '2021-04-15 12:50:54.453045', '2021-04-15 12:50:54.453045', NULL),
	(10001114, 1, 'PW21A-TK100256BL-XS', 0, 0, '2021-04-15 12:50:54.454312', '2021-04-15 12:50:54.454312', NULL),
	(10001115, 1, 'PW21A-TK100256BL-S', 0, 0, '2021-04-15 12:50:54.456444', '2021-04-15 12:50:54.456444', NULL),
	(10001116, 1, 'PW21A-TK100256BL-M', 1, 0, '2021-04-15 12:50:54.459440', '2021-04-15 12:50:54.459440', NULL),
	(10001117, 1, 'PW21A-TK100256BL-L', 8, 0, '2021-04-15 12:50:54.460391', '2021-04-15 12:50:54.460391', NULL),
	(10001118, 1, 'PW21A-TK100256BL-XL', 3, 0, '2021-04-15 12:50:54.461780', '2021-04-15 12:50:54.461780', NULL),
	(10001119, 1, 'PW21A-TK100256BL-XXL', 1, 0, '2021-04-15 12:50:54.462081', '2021-04-15 12:50:54.462081', NULL),
	(10001120, 1, 'PW21A-TS100257WT-XS', 0, 0, '2021-04-15 12:50:54.471229', '2021-04-15 12:50:54.471229', NULL),
	(10001121, 1, 'PW21A-TS100257WT-S', 0, 0, '2021-04-15 12:50:54.471916', '2021-04-15 12:50:54.471916', NULL),
	(10001122, 1, 'PW21A-TS100257WT-M', 0, 0, '2021-04-15 12:50:54.472343', '2021-04-15 12:50:54.472343', NULL),
	(10001123, 1, 'PW21A-TS100257WT-L', 0, 0, '2021-04-15 12:50:54.474413', '2021-04-15 12:50:54.474413', NULL),
	(10001124, 1, 'PW21A-TS100257WT-XL', 0, 0, '2021-04-15 12:50:54.476851', '2021-04-15 12:50:54.476851', NULL),
	(10001125, 1, 'PW21A-TS100257WT-XXL', 0, 0, '2021-04-15 12:50:54.478878', '2021-04-15 12:50:54.478878', NULL),
	(10001126, 1, 'PW21A-TS100258WT-XS', 0, 0, '2021-04-15 12:50:54.482978', '2021-04-15 12:50:54.482978', NULL),
	(10001127, 1, 'PW21A-TS100258WT-S', 20, 0, '2021-04-15 12:50:54.483541', '2021-04-15 12:50:54.483541', NULL),
	(10001128, 1, 'PW21A-TS100258WT-M', 17, 0, '2021-04-15 12:50:54.485630', '2021-04-15 12:50:54.485630', NULL),
	(10001129, 1, 'PW21A-TS100258WT-L', 26, 0, '2021-04-15 12:50:54.480963', '2021-04-15 12:50:54.480963', NULL),
	(10001130, 1, 'PW21A-TS100258WT-XL', 19, 0, '2021-04-15 12:50:54.495008', '2021-04-15 12:50:54.495008', NULL),
	(10001131, 1, 'PW21A-TS100258WT-XXL', 4, 0, '2021-04-15 12:50:54.495406', '2021-04-15 12:50:54.495406', NULL),
	(10001132, 1, 'PW21A-TS100259BL-XS', 0, 0, '2021-04-15 12:50:54.497073', '2021-04-15 12:50:54.497073', NULL),
	(10001133, 1, 'PW21A-TS100259BL-S', 11, 0, '2021-04-15 12:50:54.497678', '2021-04-15 12:50:54.497678', NULL),
	(10001134, 1, 'PW21A-TS100259BL-M', 25, 0, '2021-04-15 12:50:54.501095', '2021-04-15 12:50:54.501095', NULL),
	(10001135, 1, 'PW21A-TS100259BL-L', 15, 0, '2021-04-15 12:50:54.502712', '2021-04-15 12:50:54.502712', NULL),
	(10001136, 1, 'PW21A-TS100259BL-XL', 11, 0, '2021-04-15 12:50:54.504655', '2021-04-15 12:50:54.504655', NULL),
	(10001137, 1, 'PW21A-TS100259BL-XXL', 5, 0, '2021-04-15 12:50:54.506055', '2021-04-15 12:50:54.506055', NULL),
	(10001138, 1, 'PW21A-TS100260BL-XS', 0, 0, '2021-04-15 12:50:54.506780', '2021-04-15 12:50:54.506780', NULL),
	(10001139, 1, 'PW21A-TS100260BL-S', 24, 0, '2021-04-15 12:50:54.507088', '2021-04-15 12:50:54.507088', NULL),
	(10001140, 1, 'PW21A-TS100260BL-M', 38, 0, '2021-04-15 12:50:54.516885', '2021-04-15 12:50:54.516885', NULL),
	(10001141, 1, 'PW21A-TS100260BL-L', 49, 0, '2021-04-15 12:50:54.517219', '2021-04-15 12:50:54.517219', NULL),
	(10001142, 1, 'PW21A-TS100260BL-XL', 21, 0, '2021-04-15 12:50:54.517819', '2021-04-15 12:50:54.517819', NULL),
	(10001143, 1, 'PW21A-TS100260BL-XXL', 2, 0, '2021-04-15 12:50:54.520665', '2021-04-15 12:50:54.520665', NULL),
	(10001144, 1, 'PW21A-TS100261BL-XS', 0, 0, '2021-04-15 12:50:54.521205', '2021-04-15 12:50:54.521205', NULL),
	(10001145, 1, 'PW21A-TS100261BL-S', 11, 0, '2021-04-15 12:50:54.526527', '2021-04-15 12:50:54.526527', NULL),
	(10001146, 1, 'PW21A-TS100261BL-M', 22, 0, '2021-04-15 12:50:54.528143', '2021-04-15 12:50:54.528143', NULL),
	(10001147, 1, 'PW21A-TS100261BL-L', 12, 0, '2021-04-15 12:50:54.528464', '2021-04-15 12:50:54.528464', NULL),
	(10001148, 1, 'PW21A-TS100261BL-XL', 12, 0, '2021-04-15 12:50:54.531513', '2021-04-15 12:50:54.531513', NULL),
	(10001149, 1, 'PW21A-TS100261BL-XXL', 1, 0, '2021-04-15 12:50:54.531969', '2021-04-15 12:50:54.531969', NULL),
	(10001150, 1, 'PW21A-TS100262BL-XS', 0, 0, '2021-04-15 12:50:54.546558', '2021-04-15 12:50:54.546558', NULL),
	(10001151, 1, 'PW21A-TS100262BL-S', 28, 0, '2021-04-15 12:50:54.546902', '2021-04-15 12:50:54.546902', NULL),
	(10001152, 1, 'PW21A-TS100262BL-M', 36, 0, '2021-04-15 12:50:54.544586', '2021-04-15 12:50:54.544586', NULL),
	(10001153, 1, 'PW21A-TS100262BL-L', 43, 0, '2021-04-15 12:50:54.547778', '2021-04-15 12:50:54.547778', NULL),
	(10001154, 1, 'PW21A-TS100262BL-XL', 19, 0, '2021-04-15 12:50:54.550366', '2021-04-15 12:50:54.550366', NULL),
	(10001155, 1, 'PW21A-TS100262BL-XXL', 4, 0, '2021-04-15 12:50:54.551600', '2021-04-15 12:50:54.551600', NULL),
	(10001156, 1, 'PW21A-TS100263BL-XS', 0, 0, '2021-04-15 12:50:54.553787', '2021-04-15 12:50:54.553787', NULL),
	(10001157, 1, 'PW21A-TS100263BL-S', 8, 0, '2021-04-15 12:50:54.556865', '2021-04-15 12:50:54.556865', NULL),
	(10001158, 1, 'PW21A-TS100263BL-M', 6, 0, '2021-04-15 12:50:54.557241', '2021-04-15 12:50:54.557241', NULL),
	(10001159, 1, 'PW21A-TS100263BL-L', 13, 0, '2021-04-15 12:50:54.559746', '2021-04-15 12:50:54.559746', NULL),
	(10001160, 1, 'PW21A-TS100263BL-XL', 4, 0, '2021-04-15 12:50:54.566382', '2021-04-15 12:50:54.566382', NULL),
	(10001161, 1, 'PW21A-TS100263BL-XXL', 0, 0, '2021-04-15 12:50:54.568591', '2021-04-15 12:50:54.568591', NULL),
	(10001162, 1, 'PW21A-TS100264WH-XS', 0, 0, '2021-04-15 12:50:54.569206', '2021-04-15 12:50:54.569206', NULL),
	(10001163, 1, 'PW21A-TS100264WH-S', 0, 0, '2021-04-15 12:50:54.571397', '2021-04-15 12:50:54.571397', NULL),
	(10001164, 1, 'PW21A-TS100264WH-M', 0, 0, '2021-04-15 12:50:54.571792', '2021-04-15 12:50:54.571792', NULL),
	(10001165, 1, 'PW21A-TS100264WH-L', 0, 0, '2021-04-15 12:50:54.572601', '2021-04-15 12:50:54.572601', NULL),
	(10001166, 1, 'PW21A-TS100264WH-XL', 0, 0, '2021-04-15 12:50:54.574824', '2021-04-15 12:50:54.574824', NULL),
	(10001167, 1, 'PW21A-TS100264WH-XXL', 0, 0, '2021-04-15 12:50:54.577525', '2021-04-15 12:50:54.577525', NULL),
	(10001168, 1, 'PW21A-TS100265RD-XS', 0, 0, '2021-04-15 12:50:54.577820', '2021-04-15 12:50:54.577820', NULL),
	(10001169, 1, 'PW21A-TS100265RD-S', 24, 0, '2021-04-15 12:50:54.580582', '2021-04-15 12:50:54.580582', NULL),
	(10001170, 1, 'PW21A-TS100265RD-M', 12, 0, '2021-04-15 12:50:54.587252', '2021-04-15 12:50:54.587252', NULL),
	(10001171, 1, 'PW21A-TS100265RD-L', 24, 0, '2021-04-15 12:50:54.589269', '2021-04-15 12:50:54.589269', NULL),
	(10001172, 1, 'PW21A-TS100265RD-XL', 4, 0, '2021-04-15 12:50:54.590604', '2021-04-15 12:50:54.590604', NULL),
	(10001173, 1, 'PW21A-TS100265RD-XXL', 1, 0, '2021-04-15 12:50:54.590961', '2021-04-15 12:50:54.590961', NULL),
	(10001174, 1, 'PW21A-TS100266BL-XS', 0, 0, '2021-04-15 12:50:54.593749', '2021-04-15 12:50:54.593749', NULL),
	(10001175, 1, 'PW21A-TS100266BL-S', 1, 0, '2021-04-15 12:50:54.594092', '2021-04-15 12:50:54.594092', NULL),
	(10001176, 1, 'PW21A-TS100266BL-M', 5, 0, '2021-04-15 12:50:54.594436', '2021-04-15 12:50:54.594436', NULL),
	(10001177, 1, 'PW21A-TS100266BL-L', 7, 0, '2021-04-15 12:50:54.596939', '2021-04-15 12:50:54.596939', NULL),
	(10001178, 1, 'PW21A-TS100266BL-XL', 0, 0, '2021-04-15 12:50:54.598945', '2021-04-15 12:50:54.598945', NULL),
	(10001179, 1, 'PW21A-TS100266BL-XXL', 0, 0, '2021-04-15 12:50:54.599847', '2021-04-15 12:50:54.599847', NULL),
	(10001180, 1, 'PW21A-TS100267BL-XS', 0, 0, '2021-04-15 12:50:54.609023', '2021-04-15 12:50:54.609023', NULL),
	(10001181, 1, 'PW21A-TS100267BL-S', 20, 0, '2021-04-15 12:50:54.609817', '2021-04-15 12:50:54.609817', NULL),
	(10001182, 1, 'PW21A-TS100267BL-M', 22, 0, '2021-04-15 12:50:54.611465', '2021-04-15 12:50:54.611465', NULL),
	(10001183, 1, 'PW21A-TS100267BL-L', 24, 0, '2021-04-15 12:50:54.612453', '2021-04-15 12:50:54.612453', NULL),
	(10001184, 1, 'PW21A-TS100267BL-XL', 12, 0, '2021-04-15 12:50:54.612758', '2021-04-15 12:50:54.612758', NULL),
	(10001185, 1, 'PW21A-TS100267BL-XXL', 2, 0, '2021-04-15 12:50:54.614438', '2021-04-15 12:50:54.614438', NULL),
	(10001186, 1, 'PW21A-TS100268BL-XS', 0, 0, '2021-04-15 12:50:54.615165', '2021-04-15 12:50:54.615165', NULL),
	(10001187, 1, 'PW21A-TS100268BL-S', 21, 0, '2021-04-15 12:50:54.617658', '2021-04-15 12:50:54.617658', NULL),
	(10001188, 1, 'PW21A-TS100268BL-M', 24, 0, '2021-04-15 12:50:54.618325', '2021-04-15 12:50:54.618325', NULL),
	(10001189, 1, 'PW21A-TS100268BL-L', 30, 0, '2021-04-15 12:50:54.625128', '2021-04-15 12:50:54.625128', NULL),
	(10001190, 1, 'PW21A-TS100268BL-XL', 15, 0, '2021-04-15 12:50:54.632619', '2021-04-15 12:50:54.632619', NULL),
	(10001191, 1, 'PW21A-TS100268BL-XXL', 5, 0, '2021-04-15 12:50:54.638542', '2021-04-15 12:50:54.638542', NULL),
	(10001192, 1, 'PW21A-TS100269BL-XS', 0, 0, '2021-04-15 12:50:54.639072', '2021-04-15 12:50:54.639072', NULL),
	(10001193, 1, 'PW21A-TS100269BL-S', 22, 0, '2021-04-15 12:50:54.641093', '2021-04-15 12:50:54.641093', NULL),
	(10001194, 1, 'PW21A-TS100269BL-M', 15, 0, '2021-04-15 12:50:54.641587', '2021-04-15 12:50:54.641587', NULL),
	(10001195, 1, 'PW21A-TS100269BL-L', 16, 0, '2021-04-15 12:50:54.645694', '2021-04-15 12:50:54.645694', NULL),
	(10001196, 1, 'PW21A-TS100269BL-XL', 1, 0, '2021-04-15 12:50:54.646119', '2021-04-15 12:50:54.646119', NULL),
	(10001197, 1, 'PW21A-TS100269BL-XXL', 3, 0, '2021-04-15 12:50:54.650418', '2021-04-15 12:50:54.650418', NULL),
	(10001198, 1, 'PW21A-TS100270BL-XS', 0, 0, '2021-04-15 12:50:54.661950', '2021-04-15 12:50:54.661950', NULL),
	(10001199, 1, 'PW21A-TS100270BL-S', 0, 0, '2021-04-15 12:50:54.662576', '2021-04-15 12:50:54.662576', NULL),
	(10001200, 1, 'PW21A-TS100270BL-M', 0, 0, '2021-04-15 12:50:54.666015', '2021-04-15 12:50:54.666015', NULL),
	(10001201, 1, 'PW21A-TS100270BL-L', 0, 0, '2021-04-15 12:50:54.674248', '2021-04-15 12:50:54.674248', NULL),
	(10001202, 1, 'PW21A-TS100270BL-XL', 0, 0, '2021-04-15 12:50:54.674923', '2021-04-15 12:50:54.674923', NULL),
	(10001203, 1, 'PW21A-TS100270BL-XXL', 0, 0, '2021-04-15 12:50:54.677471', '2021-04-15 12:50:54.677471', NULL),
	(10001204, 1, 'PW21A-TS100271BL-XS', 0, 0, '2021-04-15 12:50:54.673098', '2021-04-15 12:50:54.673098', NULL),
	(10001205, 1, 'PW21A-TS100271BL-S', 16, 0, '2021-04-15 12:50:54.681043', '2021-04-15 12:50:54.681043', NULL),
	(10001206, 1, 'PW21A-TS100271BL-M', 27, 0, '2021-04-15 12:50:54.681382', '2021-04-15 12:50:54.681382', NULL),
	(10001207, 1, 'PW21A-TS100271BL-L', 26, 0, '2021-04-15 12:50:54.683225', '2021-04-15 12:50:54.683225', NULL),
	(10001208, 1, 'PW21A-TS100271BL-XL', 16, 0, '2021-04-15 12:50:54.684320', '2021-04-15 12:50:54.684320', NULL),
	(10001209, 1, 'PW21A-TS100271BL-XXL', 9, 0, '2021-04-15 12:50:54.685518', '2021-04-15 12:50:54.685518', NULL),
	(10001210, 1, 'PW21A-TS100272BL-XS', 0, 0, '2021-04-15 12:50:54.686696', '2021-04-15 12:50:54.686696', NULL),
	(10001211, 1, 'PW21A-TS100272BL-S', 10, 0, '2021-04-15 12:50:54.702286', '2021-04-15 12:50:54.702286', NULL),
	(10001212, 1, 'PW21A-TS100272BL-M', 18, 0, '2021-04-15 12:50:54.704356', '2021-04-15 12:50:54.704356', NULL),
	(10001213, 1, 'PW21A-TS100272BL-L', 17, 0, '2021-04-15 12:50:54.704041', '2021-04-15 12:50:54.704041', NULL),
	(10001214, 1, 'PW21A-TS100272BL-XL', 11, 0, '2021-04-15 12:50:54.710596', '2021-04-15 12:50:54.710596', NULL),
	(10001215, 1, 'PW21A-TS100272BL-XXL', 2, 0, '2021-04-15 12:50:54.710209', '2021-04-15 12:50:54.710209', NULL),
	(10001216, 1, 'PW21A-TS100273WT-XS', 0, 0, '2021-04-15 12:50:54.712653', '2021-04-15 12:50:54.712653', NULL),
	(10001217, 1, 'PW21A-TS100273WT-S', 15, 0, '2021-04-15 12:50:54.713931', '2021-04-15 12:50:54.713931', NULL),
	(10001218, 1, 'PW21A-TS100273WT-M', 24, 0, '2021-04-15 12:50:54.716388', '2021-04-15 12:50:54.716388', NULL),
	(10001219, 1, 'PW21A-TS100273WT-L', 20, 0, '2021-04-15 12:50:54.716745', '2021-04-15 12:50:54.716745', NULL),
	(10001220, 1, 'PW21A-TS100273WT-XL', 12, 0, '2021-04-15 12:50:54.717641', '2021-04-15 12:50:54.717641', NULL),
	(10001221, 1, 'PW21A-TS100273WT-XXL', 7, 0, '2021-04-15 12:50:54.727411', '2021-04-15 12:50:54.727411', NULL),
	(10001222, 1, 'PW21A-TS100274BL-XS', 0, 0, '2021-04-15 12:50:54.736409', '2021-04-15 12:50:54.736409', NULL),
	(10001223, 1, 'PW21A-TS100274BL-S', 8, 0, '2021-04-15 12:50:54.737477', '2021-04-15 12:50:54.737477', NULL),
	(10001224, 1, 'PW21A-TS100274BL-M', 22, 0, '2021-04-15 12:50:54.742209', '2021-04-15 12:50:54.742209', NULL),
	(10001225, 1, 'PW21A-TS100274BL-L', 21, 0, '2021-04-15 12:50:54.743927', '2021-04-15 12:50:54.743927', NULL),
	(10001226, 1, 'PW21A-TS100274BL-XL', 16, 0, '2021-04-15 12:50:54.744543', '2021-04-15 12:50:54.744543', NULL),
	(10001227, 1, 'PW21A-TS100274BL-XXL', 4, 0, '2021-04-15 12:50:54.745822', '2021-04-15 12:50:54.745822', NULL),
	(10001228, 1, 'PW21A-TS100275BL-XS', 0, 0, '2021-04-15 12:50:54.747362', '2021-04-15 12:50:54.747362', NULL),
	(10001229, 1, 'PW21A-TS100275BL-S', 18, 0, '2021-04-15 12:50:54.747841', '2021-04-15 12:50:54.747841', NULL),
	(10001230, 1, 'PW21A-TS100275BL-M', 32, 0, '2021-04-15 12:50:54.748151', '2021-04-15 12:50:54.748151', NULL),
	(10001231, 1, 'PW21A-TS100275BL-L', 31, 0, '2021-04-15 12:50:54.756647', '2021-04-15 12:50:54.756647', NULL),
	(10001232, 1, 'PW21A-TS100275BL-XL', 17, 0, '2021-04-15 12:50:54.765066', '2021-04-15 12:50:54.765066', NULL),
	(10001233, 1, 'PW21A-TS100275BL-XXL', 7, 0, '2021-04-15 12:50:54.767550', '2021-04-15 12:50:54.767550', NULL),
	(10001234, 1, 'PW21A-TS100276WT-XS', 0, 0, '2021-04-15 12:50:54.768536', '2021-04-15 12:50:54.768536', NULL),
	(10001235, 1, 'PW21A-TS100276WT-S', 12, 0, '2021-04-15 12:50:54.769663', '2021-04-15 12:50:54.769663', NULL),
	(10001236, 1, 'PW21A-TS100276WT-M', 23, 0, '2021-04-15 12:50:54.770002', '2021-04-15 12:50:54.770002', NULL),
	(10001237, 1, 'PW21A-TS100276WT-L', 24, 0, '2021-04-15 12:50:54.770341', '2021-04-15 12:50:54.770341', NULL),
	(10001238, 1, 'PW21A-TS100276WT-XL', 16, 0, '2021-04-15 12:50:54.770780', '2021-04-15 12:50:54.770780', NULL),
	(10001239, 1, 'PW21A-TS100276WT-XXL', 4, 0, '2021-04-15 12:50:54.774447', '2021-04-15 12:50:54.774447', NULL),
	(10001240, 1, 'PW21A-TS100277BL-XS', 0, 0, '2021-04-15 12:50:54.776226', '2021-04-15 12:50:54.776226', NULL),
	(10001241, 1, 'PW21A-TS100277BL-S', 10, 0, '2021-04-15 12:50:54.780952', '2021-04-15 12:50:54.780952', NULL),
	(10001242, 1, 'PW21A-TS100277BL-M', 25, 0, '2021-04-15 12:50:54.791841', '2021-04-15 12:50:54.791841', NULL),
	(10001243, 1, 'PW21A-TS100277BL-L', 24, 0, '2021-04-15 12:50:54.803414', '2021-04-15 12:50:54.803414', NULL),
	(10001244, 1, 'PW21A-TS100277BL-XL', 13, 0, '2021-04-15 12:50:54.796389', '2021-04-15 12:50:54.796389', NULL),
	(10001245, 1, 'PW21A-TS100277BL-XXL', 2, 0, '2021-04-15 12:50:54.808531', '2021-04-15 12:50:54.808531', NULL),
	(10001246, 1, 'PW21A-TS100278BL-XS', 0, 0, '2021-04-15 12:50:54.811504', '2021-04-15 12:50:54.811504', NULL),
	(10001247, 1, 'PW21A-TS100278BL-S', 8, 0, '2021-04-15 12:50:54.811980', '2021-04-15 12:50:54.811980', NULL),
	(10001248, 1, 'PW21A-TS100278BL-M', 17, 0, '2021-04-15 12:50:54.812502', '2021-04-15 12:50:54.812502', NULL),
	(10001249, 1, 'PW21A-TS100278BL-L', 25, 0, '2021-04-15 12:50:54.805639', '2021-04-15 12:50:54.805639', NULL),
	(10001250, 1, 'PW21A-TS100278BL-XL', 9, 0, '2021-04-15 12:50:54.815352', '2021-04-15 12:50:54.815352', NULL),
	(10001251, 1, 'PW21A-TS100278BL-XXL', 5, 0, '2021-04-15 12:50:54.822080', '2021-04-15 12:50:54.822080', NULL),
	(10001252, 1, 'PW21A-TS100279WT-XS', 0, 0, '2021-04-15 12:50:54.835815', '2021-04-15 12:50:54.835815', NULL),
	(10001253, 1, 'PW21A-TS100279WT-S', 11, 0, '2021-04-15 12:50:54.836279', '2021-04-15 12:50:54.836279', NULL),
	(10001254, 1, 'PW21A-TS100279WT-M', 20, 0, '2021-04-15 12:50:54.839389', '2021-04-15 12:50:54.839389', NULL),
	(10001255, 1, 'PW21A-TS100279WT-L', 16, 0, '2021-04-15 12:50:54.841014', '2021-04-15 12:50:54.841014', NULL),
	(10001256, 1, 'PW21A-TS100279WT-XL', 14, 0, '2021-04-15 12:50:54.843204', '2021-04-15 12:50:54.843204', NULL),
	(10001257, 1, 'PW21A-TS100279WT-XXL', 7, 0, '2021-04-15 12:50:54.843528', '2021-04-15 12:50:54.843528', NULL),
	(10001258, 1, 'PW21A-TS100280BL-XS', 0, 0, '2021-04-15 12:50:54.844464', '2021-04-15 12:50:54.844464', NULL),
	(10001259, 1, 'PW21A-TS100280BL-S', 0, 0, '2021-04-15 12:50:54.846224', '2021-04-15 12:50:54.846224', NULL),
	(10001260, 1, 'PW21A-TS100280BL-M', 0, 0, '2021-04-15 12:50:54.847845', '2021-04-15 12:50:54.847845', NULL),
	(10001261, 1, 'PW21A-TS100280BL-L', 0, 0, '2021-04-15 12:50:54.849577', '2021-04-15 12:50:54.849577', NULL),
	(10001262, 1, 'PW21A-TS100280BL-XL', 0, 0, '2021-04-15 12:50:54.861268', '2021-04-15 12:50:54.861268', NULL),
	(10001263, 1, 'PW21A-TS100280BL-XXL', 0, 0, '2021-04-15 12:50:54.862011', '2021-04-15 12:50:54.862011', NULL),
	(10001264, 1, 'PW21A-TS100281BL-XS', 0, 0, '2021-04-15 12:50:54.862856', '2021-04-15 12:50:54.862856', NULL),
	(10001265, 1, 'PW21A-TS100281BL-S', 0, 0, '2021-04-15 12:50:54.867682', '2021-04-15 12:50:54.867682', NULL),
	(10001266, 1, 'PW21A-TS100281BL-M', 0, 0, '2021-04-15 12:50:54.869952', '2021-04-15 12:50:54.869952', NULL),
	(10001267, 1, 'PW21A-TS100281BL-L', 0, 0, '2021-04-15 12:50:54.870908', '2021-04-15 12:50:54.870908', NULL),
	(10001268, 1, 'PW21A-TS100281BL-XL', 0, 0, '2021-04-15 12:50:54.876423', '2021-04-15 12:50:54.876423', NULL),
	(10001269, 1, 'PW21A-TS100281BL-XXL', 0, 0, '2021-04-15 12:50:54.876968', '2021-04-15 12:50:54.876968', NULL),
	(10001270, 1, 'PW21A-TS100282BL-XS', 0, 0, '2021-04-15 12:50:54.881257', '2021-04-15 12:50:54.881257', NULL),
	(10001271, 1, 'PW21A-TS100282BL-S', 0, 0, '2021-04-15 12:50:54.882406', '2021-04-15 12:50:54.882406', NULL),
	(10001272, 1, 'PW21A-TS100282BL-M', 0, 0, '2021-04-15 12:50:54.900491', '2021-04-15 12:50:54.900491', NULL),
	(10001273, 1, 'PW21A-TS100282BL-L', 0, 0, '2021-04-15 12:50:54.901667', '2021-04-15 12:50:54.901667', NULL),
	(10001274, 1, 'PW21A-TS100282BL-XL', 0, 0, '2021-04-15 12:50:54.902197', '2021-04-15 12:50:54.902197', NULL),
	(10001275, 1, 'PW21A-TS100282BL-XXL', 0, 0, '2021-04-15 12:50:54.904054', '2021-04-15 12:50:54.904054', NULL),
	(10001276, 1, 'PW21A-TS100283BL-XS', 0, 0, '2021-04-15 12:50:54.907162', '2021-04-15 12:50:54.907162', NULL),
	(10001277, 1, 'PW21A-TS100283BL-S', 0, 0, '2021-04-15 12:50:54.907668', '2021-04-15 12:50:54.907668', NULL),
	(10001278, 1, 'PW21A-TS100283BL-M', 0, 0, '2021-04-15 12:50:54.911666', '2021-04-15 12:50:54.911666', NULL),
	(10001279, 1, 'PW21A-TS100283BL-L', 0, 0, '2021-04-15 12:50:54.912558', '2021-04-15 12:50:54.912558', NULL),
	(10001280, 1, 'PW21A-TS100283BL-XL', 0, 0, '2021-04-15 12:50:54.924218', '2021-04-15 12:50:54.924218', NULL),
	(10001281, 1, 'PW21A-TS100283BL-XXL', 0, 0, '2021-04-15 12:50:54.925660', '2021-04-15 12:50:54.925660', NULL),
	(10001282, 1, 'PW21A-TS100284BL-XS', 0, 0, '2021-04-15 12:50:54.936321', '2021-04-15 12:50:54.936321', NULL),
	(10001283, 1, 'PW21A-TS100284BL-S', 0, 0, '2021-04-15 12:50:54.937866', '2021-04-15 12:50:54.937866', NULL),
	(10001284, 1, 'PW21A-TS100284BL-M', 0, 0, '2021-04-15 12:50:54.940408', '2021-04-15 12:50:54.940408', NULL),
	(10001285, 1, 'PW21A-TS100284BL-L', 0, 0, '2021-04-15 12:50:54.941238', '2021-04-15 12:50:54.941238', NULL),
	(10001286, 1, 'PW21A-TS100284BL-XL', 0, 0, '2021-04-15 12:50:54.943540', '2021-04-15 12:50:54.943540', NULL),
	(10001287, 1, 'PW21A-TS100284BL-XXL', 0, 0, '2021-04-15 12:50:54.944290', '2021-04-15 12:50:54.944290', NULL),
	(10001288, 1, 'PW21A-TS100285BL-XS', 0, 0, '2021-04-15 12:50:54.944748', '2021-04-15 12:50:54.944748', NULL),
	(10001289, 1, 'PW21A-TS100285BL-S', 0, 0, '2021-04-15 12:50:54.945770', '2021-04-15 12:50:54.945770', NULL),
	(10001290, 1, 'PW21A-TS100285BL-M', 0, 0, '2021-04-15 12:50:54.948549', '2021-04-15 12:50:54.948549', NULL),
	(10001291, 1, 'PW21A-TS100285BL-L', 0, 0, '2021-04-15 12:50:54.951187', '2021-04-15 12:50:54.951187', NULL),
	(10001292, 1, 'PW21A-TS100285BL-XL', 0, 0, '2021-04-15 12:50:54.966325', '2021-04-15 12:50:54.966325', NULL),
	(10001293, 1, 'PW21A-TS100285BL-XXL', 0, 0, '2021-04-15 12:50:54.966773', '2021-04-15 12:50:54.966773', NULL),
	(10001294, 1, 'PW21A-TS100286BL-XS', 0, 0, '2021-04-15 12:50:54.967695', '2021-04-15 12:50:54.967695', NULL),
	(10001295, 1, 'PW21A-TS100286BL-S', 0, 0, '2021-04-15 12:50:54.968308', '2021-04-15 12:50:54.968308', NULL),
	(10001296, 1, 'PW21A-TS100286BL-M', 0, 0, '2021-04-15 12:50:54.969544', '2021-04-15 12:50:54.969544', NULL),
	(10001297, 1, 'PW21A-TS100286BL-L', 0, 0, '2021-04-15 12:50:54.970905', '2021-04-15 12:50:54.970905', NULL),
	(10001298, 1, 'PW21A-TS100286BL-XL', 0, 0, '2021-04-15 12:50:54.971353', '2021-04-15 12:50:54.971353', NULL),
	(10001299, 1, 'PW21A-TS100286BL-XXL', 0, 0, '2021-04-15 12:50:54.972795', '2021-04-15 12:50:54.972795', NULL),
	(10001300, 1, 'PW21A-TS100287BL-XS', 0, 0, '2021-04-15 12:50:54.974174', '2021-04-15 12:50:54.974174', NULL),
	(10001301, 1, 'PW21A-TS100287BL-S', 0, 0, '2021-04-15 12:50:54.977280', '2021-04-15 12:50:54.977280', NULL),
	(10001302, 1, 'PW21A-TS100287BL-M', 4, 0, '2021-04-15 12:50:54.981276', '2021-04-15 12:50:54.981276', NULL),
	(10001303, 1, 'PW21A-TS100287BL-L', 0, 0, '2021-04-15 12:50:54.987715', '2021-04-15 12:50:54.987715', NULL),
	(10001304, 1, 'PW21A-TS100287BL-XL', 4, 0, '2021-04-15 12:50:54.988175', '2021-04-15 12:50:54.988175', NULL),
	(10001305, 1, 'PW21A-TS100287BL-XXL', 0, 0, '2021-04-15 12:50:54.989190', '2021-04-15 12:50:54.989190', NULL),
	(10001306, 1, 'PW21A-TS100288BL-XS', 0, 0, '2021-04-15 12:50:54.995506', '2021-04-15 12:50:54.995506', NULL),
	(10001307, 1, 'PW21A-TS100288BL-S', 0, 0, '2021-04-15 12:50:54.999704', '2021-04-15 12:50:54.999704', NULL),
	(10001308, 1, 'PW21A-TS100288BL-M', 1, 0, '2021-04-15 12:50:55.000436', '2021-04-15 12:50:55.000436', NULL),
	(10001309, 1, 'PW21A-TS100288BL-L', 0, 0, '2021-04-15 12:50:55.001188', '2021-04-15 12:50:55.001188', NULL),
	(10001310, 1, 'PW21A-TS100288BL-XL', 0, 0, '2021-04-15 12:50:55.002006', '2021-04-15 12:50:55.002006', NULL),
	(10001311, 1, 'PW21A-TS100288BL-XXL', 0, 0, '2021-04-15 12:50:55.003178', '2021-04-15 12:50:55.003178', NULL),
	(10001312, 1, 'PW21A-TS100289BL-XS', 0, 0, '2021-04-15 12:50:55.003600', '2021-04-15 12:50:55.003600', NULL),
	(10001313, 1, 'PW21A-TS100289BL-S', 0, 0, '2021-04-15 12:50:55.007898', '2021-04-15 12:50:55.007898', NULL),
	(10001314, 1, 'PW21A-TS100289BL-M', 0, 0, '2021-04-15 12:50:55.012190', '2021-04-15 12:50:55.012190', NULL),
	(10001315, 1, 'PW21A-TS100289BL-L', 0, 0, '2021-04-15 12:50:55.012625', '2021-04-15 12:50:55.012625', NULL),
	(10001316, 1, 'PW21A-TS100289BL-XL', 1, 0, '2021-04-15 12:50:55.014123', '2021-04-15 12:50:55.014123', NULL),
	(10001317, 1, 'PW21A-TS100289BL-XXL', 0, 0, '2021-04-15 12:50:55.017395', '2021-04-15 12:50:55.017395', NULL),
	(10001318, 1, 'PW21A-TS100290OL-XS', 0, 0, '2021-04-15 12:50:55.021387', '2021-04-15 12:50:55.021387', NULL),
	(10001319, 1, 'PW21A-TS100290OL-S', 0, 0, '2021-04-15 12:50:55.023494', '2021-04-15 12:50:55.023494', NULL),
	(10001320, 1, 'PW21A-TS100290OL-M', 2, 0, '2021-04-15 12:50:55.024297', '2021-04-15 12:50:55.024297', NULL),
	(10001321, 1, 'PW21A-TS100290OL-L', 12, 0, '2021-04-15 12:50:55.024812', '2021-04-15 12:50:55.024812', NULL),
	(10001322, 1, 'PW21A-TS100290OL-XL', 21, 0, '2021-04-15 12:50:55.029007', '2021-04-15 12:50:55.029007', NULL),
	(10001323, 1, 'PW21A-TS100290OL-XXL', 4, 0, '2021-04-15 12:50:55.031102', '2021-04-15 12:50:55.031102', NULL),
	(10001324, 1, 'PW21A-TS100291BL-XS', 0, 0, '2021-04-15 12:50:55.040471', '2021-04-15 12:50:55.040471', NULL),
	(10001325, 1, 'PW21A-TS100291BL-S', 0, 0, '2021-04-15 12:50:55.041370', '2021-04-15 12:50:55.041370', NULL),
	(10001326, 1, 'PW21A-TS100291BL-M', 0, 0, '2021-04-15 12:50:55.043182', '2021-04-15 12:50:55.043182', NULL),
	(10001327, 1, 'PW21A-TS100291BL-L', 0, 0, '2021-04-15 12:50:55.045604', '2021-04-15 12:50:55.045604', NULL),
	(10001328, 1, 'PW21A-TS100291BL-XL', 0, 0, '2021-04-15 12:50:55.057162', '2021-04-15 12:50:55.057162', NULL),
	(10001329, 1, 'PW21A-TS100291BL-XXL', 0, 0, '2021-04-15 12:50:55.058007', '2021-04-15 12:50:55.058007', NULL),
	(10001330, 1, 'PW21A-TS100292NV-XS', 0, 0, '2021-04-15 12:50:55.056491', '2021-04-15 12:50:55.056491', NULL),
	(10001331, 1, 'PW21A-TS100292NV-S', 4, 0, '2021-04-15 12:50:55.061145', '2021-04-15 12:50:55.061145', NULL),
	(10001332, 1, 'PW21A-TS100292NV-M', 6, 0, '2021-04-15 12:50:55.063313', '2021-04-15 12:50:55.063313', NULL),
	(10001333, 1, 'PW21A-TS100292NV-L', 0, 0, '2021-04-15 12:50:55.064849', '2021-04-15 12:50:55.064849', NULL),
	(10001334, 1, 'PW21A-TS100292NV-XL', 0, 0, '2021-04-15 12:50:55.071081', '2021-04-15 12:50:55.071081', NULL),
	(10001335, 1, 'PW21A-TS100292NV-XXL', 0, 0, '2021-04-15 12:50:55.074242', '2021-04-15 12:50:55.074242', NULL),
	(10001336, 1, 'PW21A-TS100293OL-XS', 0, 0, '2021-04-15 12:50:55.076509', '2021-04-15 12:50:55.076509', NULL),
	(10001337, 1, 'PW21A-TS100293OL-S', 0, 0, '2021-04-15 12:50:55.078849', '2021-04-15 12:50:55.078849', NULL),
	(10001338, 1, 'PW21A-TS100293OL-M', 0, 0, '2021-04-15 12:50:55.089001', '2021-04-15 12:50:55.089001', NULL),
	(10001339, 1, 'PW21A-TS100293OL-L', 0, 0, '2021-04-15 12:50:55.089618', '2021-04-15 12:50:55.089618', NULL),
	(10001340, 1, 'PW21A-TS100293OL-XL', 0, 0, '2021-04-15 12:50:55.090793', '2021-04-15 12:50:55.090793', NULL),
	(10001341, 1, 'PW21A-TS100293OL-XXL', 0, 0, '2021-04-15 12:50:55.092759', '2021-04-15 12:50:55.092759', NULL),
	(10001342, 1, 'PW21A-TS100294OL-XS', 0, 0, '2021-04-15 12:50:55.093367', '2021-04-15 12:50:55.093367', NULL),
	(10001343, 1, 'PW21A-TS100294OL-S', 0, 0, '2021-04-15 12:50:55.095534', '2021-04-15 12:50:55.095534', NULL),
	(10001344, 1, 'PW21A-TS100294OL-M', 0, 0, '2021-04-15 12:50:55.100478', '2021-04-15 12:50:55.100478', NULL),
	(10001345, 1, 'PW21A-TS100294OL-L', 0, 0, '2021-04-15 12:50:55.101362', '2021-04-15 12:50:55.101362', NULL),
	(10001346, 1, 'PW21A-TS100294OL-XL', 0, 0, '2021-04-15 12:50:55.102929', '2021-04-15 12:50:55.102929', NULL),
	(10001347, 1, 'PW21A-TS100294OL-XXL', 0, 0, '2021-04-15 12:50:55.103260', '2021-04-15 12:50:55.103260', NULL),
	(10001348, 1, 'PW21A-TS100295NV-XS', 0, 0, '2021-04-15 12:50:55.112562', '2021-04-15 12:50:55.112562', NULL),
	(10001349, 1, 'PW21A-TS100295NV-S', 18, 0, '2021-04-15 12:50:55.113482', '2021-04-15 12:50:55.113482', NULL),
	(10001350, 1, 'PW21A-TS100295NV-M', 23, 0, '2021-04-15 12:50:55.113805', '2021-04-15 12:50:55.113805', NULL),
	(10001351, 1, 'PW21A-TS100295NV-L', 32, 0, '2021-04-15 12:50:55.114136', '2021-04-15 12:50:55.114136', NULL),
	(10001352, 1, 'PW21A-TS100295NV-XL', 31, 0, '2021-04-15 12:50:55.116855', '2021-04-15 12:50:55.116855', NULL),
	(10001353, 1, 'PW21A-TS100295NV-XXL', 10, 0, '2021-04-15 12:50:55.117345', '2021-04-15 12:50:55.117345', NULL),
	(10001354, 1, 'PW21A-TS100296BL-XS', 0, 0, '2021-04-15 12:50:55.123553', '2021-04-15 12:50:55.123553', NULL),
	(10001355, 1, 'PW21A-TS100296BL-S', 8, 0, '2021-04-15 12:50:55.124006', '2021-04-15 12:50:55.124006', NULL),
	(10001356, 1, 'PW21A-TS100296BL-M', 12, 0, '2021-04-15 12:50:55.124420', '2021-04-15 12:50:55.124420', NULL),
	(10001357, 1, 'PW21A-TS100296BL-L', 24, 0, '2021-04-15 12:50:55.126417', '2021-04-15 12:50:55.126417', NULL),
	(10001358, 1, 'PW21A-TS100296BL-XL', 18, 0, '2021-04-15 12:50:55.133419', '2021-04-15 12:50:55.133419', NULL),
	(10001359, 1, 'PW21A-TS100296BL-XXL', 1, 0, '2021-04-15 12:50:55.134849', '2021-04-15 12:50:55.134849', NULL),
	(10001360, 1, 'PW21A-TS100297OL-XS', 0, 0, '2021-04-15 12:50:55.135589', '2021-04-15 12:50:55.135589', NULL),
	(10001361, 1, 'PW21A-TS100297OL-S', 0, 0, '2021-04-15 12:50:55.135924', '2021-04-15 12:50:55.135924', NULL),
	(10001362, 1, 'PW21A-TS100297OL-M', 0, 0, '2021-04-15 12:50:55.136325', '2021-04-15 12:50:55.136325', NULL),
	(10001363, 1, 'PW21A-TS100297OL-L', 0, 0, '2021-04-15 12:50:55.139617', '2021-04-15 12:50:55.139617', NULL),
	(10001364, 1, 'PW21A-TS100297OL-XL', 4, 0, '2021-04-15 12:50:55.147393', '2021-04-15 12:50:55.147393', NULL),
	(10001365, 1, 'PW21A-TS100297OL-XXL', 2, 0, '2021-04-15 12:50:55.147946', '2021-04-15 12:50:55.147946', NULL),
	(10001366, 1, 'PW21A-TS100298OL-XS', 0, 0, '2021-04-15 12:50:55.148551', '2021-04-15 12:50:55.148551', NULL),
	(10001367, 1, 'PW21A-TS100298OL-S', 5, 0, '2021-04-15 12:50:55.149211', '2021-04-15 12:50:55.149211', NULL),
	(10001368, 1, 'PW21A-TS100298OL-M', 18, 0, '2021-04-15 12:50:55.162541', '2021-04-15 12:50:55.162541', NULL),
	(10001369, 1, 'PW21A-TS100298OL-L', 40, 0, '2021-04-15 12:50:55.162882', '2021-04-15 12:50:55.162882', NULL),
	(10001370, 1, 'PW21A-TS100298OL-XL', 24, 0, '2021-04-15 12:50:55.163331', '2021-04-15 12:50:55.163331', NULL),
	(10001371, 1, 'PW21A-TS100298OL-XXL', 12, 0, '2021-04-15 12:50:55.163760', '2021-04-15 12:50:55.163760', NULL),
	(10001372, 1, 'PW21A-TS100299BL-XS', 0, 0, '2021-04-15 12:50:55.164847', '2021-04-15 12:50:55.164847', NULL),
	(10001373, 1, 'PW21A-TS100299BL-S', 17, 0, '2021-04-15 12:50:55.166836', '2021-04-15 12:50:55.166836', NULL),
	(10001374, 1, 'PW21A-TS100299BL-M', 12, 0, '2021-04-15 12:50:55.172690', '2021-04-15 12:50:55.172690', NULL),
	(10001375, 1, 'PW21A-TS100299BL-L', 2, 0, '2021-04-15 12:50:55.173070', '2021-04-15 12:50:55.173070', NULL),
	(10001376, 1, 'PW21A-TS100299BL-XL', 0, 0, '2021-04-15 12:50:55.175873', '2021-04-15 12:50:55.175873', NULL),
	(10001377, 1, 'PW21A-TS100299BL-XXL', 0, 0, '2021-04-15 12:50:55.176257', '2021-04-15 12:50:55.176257', NULL),
	(10001378, 1, 'PW21A-TS100300MR-XS', 0, 0, '2021-04-15 12:50:55.182512', '2021-04-15 12:50:55.182512', NULL),
	(10001379, 1, 'PW21A-TS100300MR-S', 20, 0, '2021-04-15 12:50:55.185801', '2021-04-15 12:50:55.185801', NULL),
	(10001380, 1, 'PW21A-TS100300MR-M', 15, 0, '2021-04-15 12:50:55.186870', '2021-04-15 12:50:55.186870', NULL),
	(10001381, 1, 'PW21A-TS100300MR-L', 13, 0, '2021-04-15 12:50:55.189184', '2021-04-15 12:50:55.189184', NULL),
	(10001382, 1, 'PW21A-TS100300MR-XL', 4, 0, '2021-04-15 12:50:55.192023', '2021-04-15 12:50:55.192023', NULL),
	(10001383, 1, 'PW21A-TS100300MR-XXL', 9, 0, '2021-04-15 12:50:55.193180', '2021-04-15 12:50:55.193180', NULL),
	(10001384, 1, 'PW21A-TS100301BL-XS', 0, 0, '2021-04-15 12:50:55.199137', '2021-04-15 12:50:55.199137', NULL),
	(10001385, 1, 'PW21A-TS100301BL-S', 28, 0, '2021-04-15 12:50:55.200575', '2021-04-15 12:50:55.200575', NULL),
	(10001386, 1, 'PW21A-TS100301BL-M', 25, 0, '2021-04-15 12:50:55.200983', '2021-04-15 12:50:55.200983', NULL),
	(10001387, 1, 'PW21A-TS100301BL-L', 37, 0, '2021-04-15 12:50:55.201426', '2021-04-15 12:50:55.201426', NULL),
	(10001388, 1, 'PW21A-TS100301BL-XL', 14, 0, '2021-04-15 12:50:55.216053', '2021-04-15 12:50:55.216053', NULL),
	(10001389, 1, 'PW21A-TS100301BL-XXL', 10, 0, '2021-04-15 12:50:55.216774', '2021-04-15 12:50:55.216774', NULL),
	(10001390, 1, 'PW21A-TS100302BL-XS', 0, 0, '2021-04-15 12:50:55.217864', '2021-04-15 12:50:55.217864', NULL),
	(10001391, 1, 'PW21A-TS100302BL-S', 7, 0, '2021-04-15 12:50:55.218198', '2021-04-15 12:50:55.218198', NULL),
	(10001392, 1, 'PW21A-TS100302BL-M', 1, 0, '2021-04-15 12:50:55.218510', '2021-04-15 12:50:55.218510', NULL),
	(10001393, 1, 'PW21A-TS100302BL-L', 8, 0, '2021-04-15 12:50:55.221246', '2021-04-15 12:50:55.221246', NULL),
	(10001394, 1, 'PW21A-TS100302BL-XL', 2, 0, '2021-04-15 12:50:55.229100', '2021-04-15 12:50:55.229100', NULL),
	(10001395, 1, 'PW21A-TS100302BL-XXL', 0, 0, '2021-04-15 12:50:55.230700', '2021-04-15 12:50:55.230700', NULL),
	(10001396, 1, 'PW21A-TS100303BL-XS', 0, 0, '2021-04-15 12:50:55.231280', '2021-04-15 12:50:55.231280', NULL),
	(10001397, 1, 'PW21A-TS100303BL-S', 20, 0, '2021-04-15 12:50:55.233118', '2021-04-15 12:50:55.233118', NULL),
	(10001398, 1, 'PW21A-TS100303BL-M', 27, 0, '2021-04-15 12:50:55.237772', '2021-04-15 12:50:55.237772', NULL),
	(10001399, 1, 'PW21A-TS100303BL-L', 23, 0, '2021-04-15 12:50:55.239090', '2021-04-15 12:50:55.239090', NULL),
	(10001400, 1, 'PW21A-TS100303BL-XL', 21, 0, '2021-04-15 12:50:55.239401', '2021-04-15 12:50:55.239401', NULL),
	(10001401, 1, 'PW21A-TS100303BL-XXL', 8, 0, '2021-04-15 12:50:55.240618', '2021-04-15 12:50:55.240618', NULL),
	(10001402, 1, 'PW21A-TS100304OL-XS', 0, 0, '2021-04-15 12:50:55.242118', '2021-04-15 12:50:55.242118', NULL),
	(10001403, 1, 'PW21A-TS100304OL-S', 1, 0, '2021-04-15 12:50:55.243131', '2021-04-15 12:50:55.243131', NULL),
	(10001404, 1, 'PW21A-TS100304OL-M', 14, 0, '2021-04-15 12:50:55.248244', '2021-04-15 12:50:55.248244', NULL),
	(10001405, 1, 'PW21A-TS100304OL-L', 15, 0, '2021-04-15 12:50:55.249968', '2021-04-15 12:50:55.249968', NULL),
	(10001406, 1, 'PW21A-TS100304OL-XL', 16, 0, '2021-04-15 12:50:55.250314', '2021-04-15 12:50:55.250314', NULL),
	(10001407, 1, 'PW21A-TS100304OL-XXL', 2, 0, '2021-04-15 12:50:55.250620', '2021-04-15 12:50:55.250620', NULL),
	(10001408, 1, 'PW21A-TS100305AR-XS', 0, 0, '2021-04-15 12:50:55.256809', '2021-04-15 12:50:55.256809', NULL),
	(10001409, 1, 'PW21A-TS100305AR-S', 9, 0, '2021-04-15 12:50:55.259292', '2021-04-15 12:50:55.259292', NULL),
	(10001410, 1, 'PW21A-TS100305AR-M', 17, 0, '2021-04-15 12:50:55.259673', '2021-04-15 12:50:55.259673', NULL),
	(10001411, 1, 'PW21A-TS100305AR-L', 27, 0, '2021-04-15 12:50:55.260291', '2021-04-15 12:50:55.260291', NULL),
	(10001412, 1, 'PW21A-TS100305AR-XL', 19, 0, '2021-04-15 12:50:55.261018', '2021-04-15 12:50:55.261018', NULL),
	(10001413, 1, 'PW21A-TS100305AR-XXL', 1, 0, '2021-04-15 12:50:55.259985', '2021-04-15 12:50:55.259985', NULL),
	(10001414, 1, 'PW21A-TS100306GN-XS', 0, 0, '2021-04-15 12:50:55.265647', '2021-04-15 12:50:55.265647', NULL),
	(10001415, 1, 'PW21A-TS100306GN-S', 0, 0, '2021-04-15 12:50:55.268454', '2021-04-15 12:50:55.268454', NULL),
	(10001416, 1, 'PW21A-TS100306GN-M', 8, 0, '2021-04-15 12:50:55.269571', '2021-04-15 12:50:55.269571', NULL),
	(10001417, 1, 'PW21A-TS100306GN-L', 8, 0, '2021-04-15 12:50:55.270615', '2021-04-15 12:50:55.270615', NULL),
	(10001418, 1, 'PW21A-TS100306GN-XL', 3, 0, '2021-04-15 12:50:55.277839', '2021-04-15 12:50:55.277839', NULL),
	(10001419, 1, 'PW21A-TS100306GN-XXL', 0, 0, '2021-04-15 12:50:55.278934', '2021-04-15 12:50:55.278934', NULL),
	(10001420, 1, 'PW21A-TS100307GN-XS', 0, 0, '2021-04-15 12:50:55.279309', '2021-04-15 12:50:55.279309', NULL),
	(10001421, 1, 'PW21A-TS100307GN-S', 7, 0, '2021-04-15 12:50:55.279681', '2021-04-15 12:50:55.279681', NULL),
	(10001422, 1, 'PW21A-TS100307GN-M', 14, 0, '2021-04-15 12:50:55.280610', '2021-04-15 12:50:55.280610', NULL),
	(10001423, 1, 'PW21A-TS100307GN-L', 17, 0, '2021-04-15 12:50:55.278178', '2021-04-15 12:50:55.278178', NULL),
	(10001424, 1, 'PW21A-TS100307GN-XL', 9, 0, '2021-04-15 12:50:55.284945', '2021-04-15 12:50:55.284945', NULL),
	(10001425, 1, 'PW21A-TS100307GN-XXL', 0, 0, '2021-04-15 12:50:55.287634', '2021-04-15 12:50:55.287634', NULL),
	(10001426, 1, 'PW21A-TS100308GN-XS', 0, 0, '2021-04-15 12:50:55.289095', '2021-04-15 12:50:55.289095', NULL),
	(10001427, 1, 'PW21A-TS100308GN-S', 5, 0, '2021-04-15 12:50:55.290022', '2021-04-15 12:50:55.290022', NULL),
	(10001428, 1, 'PW21A-TS100308GN-M', 2, 0, '2021-04-15 12:50:55.299385', '2021-04-15 12:50:55.299385', NULL),
	(10001429, 1, 'PW21A-TS100308GN-L', 12, 0, '2021-04-15 12:50:55.298747', '2021-04-15 12:50:55.298747', NULL),
	(10001430, 1, 'PW21A-TS100308GN-XL', 2, 0, '2021-04-15 12:50:55.301051', '2021-04-15 12:50:55.301051', NULL),
	(10001431, 1, 'PW21A-TS100308GN-XXL', 0, 0, '2021-04-15 12:50:55.301390', '2021-04-15 12:50:55.301390', NULL),
	(10001432, 1, 'PW21A-TS100309GN-XS', 0, 0, '2021-04-15 12:50:55.299083', '2021-04-15 12:50:55.299083', NULL),
	(10001433, 1, 'PW21A-TS100309GN-S', 3, 0, '2021-04-15 12:50:55.301897', '2021-04-15 12:50:55.301897', NULL),
	(10001434, 1, 'PW21A-TS100309GN-M', 7, 0, '2021-04-15 12:50:55.305365', '2021-04-15 12:50:55.305365', NULL),
	(10001435, 1, 'PW21A-TS100309GN-L', 10, 0, '2021-04-15 12:50:55.311776', '2021-04-15 12:50:55.311776', NULL),
	(10001436, 1, 'PW21A-TS100309GN-XL', 10, 0, '2021-04-15 12:50:55.314714', '2021-04-15 12:50:55.314714', NULL),
	(10001437, 1, 'PW21A-TS100309GN-XXL', 0, 0, '2021-04-15 12:50:55.315792', '2021-04-15 12:50:55.315792', NULL),
	(10001438, 1, 'PW21A-SW100310BL-XS', 0, 0, '2021-04-15 12:50:55.328010', '2021-04-15 12:50:55.328010', NULL),
	(10001439, 1, 'PW21A-SW100310BL-S', 0, 0, '2021-04-15 12:50:55.329163', '2021-04-15 12:50:55.329163', NULL),
	(10001440, 1, 'PW21A-SW100310BL-M', 0, 0, '2021-04-15 12:50:55.327554', '2021-04-15 12:50:55.327554', NULL),
	(10001441, 1, 'PW21A-SW100310BL-L', 0, 0, '2021-04-15 12:50:55.329878', '2021-04-15 12:50:55.329878', NULL),
	(10001442, 1, 'PW21A-SW100310BL-XL', 1, 0, '2021-04-15 12:50:55.330295', '2021-04-15 12:50:55.330295', NULL),
	(10001443, 1, 'PW21A-SW100310BL-XXL', 0, 0, '2021-04-15 12:50:55.330838', '2021-04-15 12:50:55.330838', NULL),
	(10001444, 1, 'PW21A-SW100311BL-XS', 0, 0, '2021-04-15 12:50:55.334625', '2021-04-15 12:50:55.334625', NULL),
	(10001445, 1, 'PW21A-SW100311BL-S', 10, 0, '2021-04-15 12:50:55.337346', '2021-04-15 12:50:55.337346', NULL),
	(10001446, 1, 'PW21A-SW100311BL-M', 16, 0, '2021-04-15 12:50:55.340195', '2021-04-15 12:50:55.340195', NULL),
	(10001447, 1, 'PW21A-SW100311BL-L', 9, 0, '2021-04-15 12:50:55.340594', '2021-04-15 12:50:55.340594', NULL),
	(10001448, 1, 'PW21A-SW100311BL-XL', 8, 0, '2021-04-15 12:50:55.350794', '2021-04-15 12:50:55.350794', NULL),
	(10001449, 1, 'PW21A-SW100311BL-XXL', 0, 0, '2021-04-15 12:50:55.351124', '2021-04-15 12:50:55.351124', NULL),
	(10001450, 1, 'PW21A-SW100312BL-XS', 0, 0, '2021-04-15 12:50:55.352479', '2021-04-15 12:50:55.352479', NULL),
	(10001451, 1, 'PW21A-SW100312BL-S', 0, 0, '2021-04-15 12:50:55.352805', '2021-04-15 12:50:55.352805', NULL),
	(10001452, 1, 'PW21A-SW100312BL-M', 0, 0, '2021-04-15 12:50:55.353308', '2021-04-15 12:50:55.353308', NULL),
	(10001453, 1, 'PW21A-SW100312BL-L', 0, 0, '2021-04-15 12:50:55.356471', '2021-04-15 12:50:55.356471', NULL),
	(10001454, 1, 'PW21A-SW100312BL-XL', 1, 0, '2021-04-15 12:50:55.358292', '2021-04-15 12:50:55.358292', NULL),
	(10001455, 1, 'PW21A-SW100312BL-XXL', 0, 0, '2021-04-15 12:50:55.360061', '2021-04-15 12:50:55.360061', NULL),
	(10001456, 1, 'PW21A-SW100313BL-XS', 0, 0, '2021-04-15 12:50:55.363099', '2021-04-15 12:50:55.363099', NULL),
	(10001457, 1, 'PW21A-SW100313BL-S', 0, 0, '2021-04-15 12:50:55.364928', '2021-04-15 12:50:55.364928', NULL),
	(10001458, 1, 'PW21A-SW100313BL-M', 0, 0, '2021-04-15 12:50:55.374135', '2021-04-15 12:50:55.374135', NULL),
	(10001459, 1, 'PW21A-SW100313BL-L', 0, 0, '2021-04-15 12:50:55.374470', '2021-04-15 12:50:55.374470', NULL),
	(10001460, 1, 'PW21A-SW100313BL-XL', 1, 0, '2021-04-15 12:50:55.375861', '2021-04-15 12:50:55.375861', NULL),
	(10001461, 1, 'PW21A-SW100313BL-XXL', 0, 0, '2021-04-15 12:50:55.376159', '2021-04-15 12:50:55.376159', NULL),
	(10001462, 1, 'PW21A-SW100314DK-XS', 0, 0, '2021-04-15 12:50:55.376738', '2021-04-15 12:50:55.376738', NULL),
	(10001463, 1, 'PW21A-SW100314DK-S', 0, 0, '2021-04-15 12:50:55.378464', '2021-04-15 12:50:55.378464', NULL),
	(10001464, 1, 'PW21A-SW100314DK-M', 0, 0, '2021-04-15 12:50:55.376456', '2021-04-15 12:50:55.376456', NULL),
	(10001465, 1, 'PW21A-SW100314DK-L', 0, 0, '2021-04-15 12:50:55.382870', '2021-04-15 12:50:55.382870', NULL),
	(10001466, 1, 'PW21A-SW100314DK-XL', 0, 0, '2021-04-15 12:50:55.385172', '2021-04-15 12:50:55.385172', NULL),
	(10001467, 1, 'PW21A-SW100314DK-XXL', 0, 0, '2021-04-15 12:50:55.386534', '2021-04-15 12:50:55.386534', NULL),
	(10001468, 1, 'PW21A-SW100315BL-XS', 0, 0, '2021-04-15 12:50:55.396589', '2021-04-15 12:50:55.396589', NULL),
	(10001469, 1, 'PW21A-SW100315BL-S', 0, 0, '2021-04-15 12:50:55.396893', '2021-04-15 12:50:55.396893', NULL),
	(10001470, 1, 'PW21A-SW100315BL-M', 0, 0, '2021-04-15 12:50:55.397208', '2021-04-15 12:50:55.397208', NULL),
	(10001471, 1, 'PW21A-SW100315BL-L', 0, 0, '2021-04-15 12:50:55.397483', '2021-04-15 12:50:55.397483', NULL),
	(10001472, 1, 'PW21A-SW100315BL-XL', 0, 0, '2021-04-15 12:50:55.397753', '2021-04-15 12:50:55.397753', NULL),
	(10001473, 1, 'PW21A-SW100315BL-XXL', 0, 0, '2021-04-15 12:50:55.399388', '2021-04-15 12:50:55.399388', NULL),
	(10001474, 1, 'PW21A-SW100316BL-XS', 0, 0, '2021-04-15 12:50:55.399691', '2021-04-15 12:50:55.399691', NULL),
	(10001475, 1, 'PW21A-SW100316BL-S', 0, 0, '2021-04-15 12:50:55.401965', '2021-04-15 12:50:55.401965', NULL),
	(10001476, 1, 'PW21A-SW100316BL-M', 0, 0, '2021-04-15 12:50:55.408836', '2021-04-15 12:50:55.408836', NULL),
	(10001477, 1, 'PW21A-SW100316BL-L', 1, 0, '2021-04-15 12:50:55.410118', '2021-04-15 12:50:55.410118', NULL),
	(10001478, 1, 'PW21A-SW100316BL-XL', 0, 0, '2021-04-15 12:50:55.425644', '2021-04-15 12:50:55.425644', NULL),
	(10001479, 1, 'PW21A-SW100316BL-XXL', 0, 0, '2021-04-15 12:50:55.424029', '2021-04-15 12:50:55.424029', NULL),
	(10001480, 1, 'PW21A-SW100317BL-XS', 0, 0, '2021-04-15 12:50:55.430794', '2021-04-15 12:50:55.430794', NULL),
	(10001481, 1, 'PW21A-SW100317BL-S', 0, 0, '2021-04-15 12:50:55.431184', '2021-04-15 12:50:55.431184', NULL),
	(10001482, 1, 'PW21A-SW100317BL-M', 3, 0, '2021-04-15 12:50:55.424410', '2021-04-15 12:50:55.424410', NULL),
	(10001483, 1, 'PW21A-SW100317BL-L', 0, 0, '2021-04-15 12:50:55.433191', '2021-04-15 12:50:55.433191', NULL),
	(10001484, 1, 'PW21A-SW100317BL-XL', 1, 0, '2021-04-15 12:50:55.434503', '2021-04-15 12:50:55.434503', NULL),
	(10001485, 1, 'PW21A-SW100317BL-XXL', 0, 0, '2021-04-15 12:50:55.435939', '2021-04-15 12:50:55.435939', NULL),
	(10001486, 1, 'PW21A-SW100318OL-XS', 0, 0, '2021-04-15 12:50:55.441117', '2021-04-15 12:50:55.441117', NULL),
	(10001487, 1, 'PW21A-SW100318OL-S', 1, 0, '2021-04-15 12:50:55.450233', '2021-04-15 12:50:55.450233', NULL),
	(10001488, 1, 'PW21A-SW100318OL-M', 6, 0, '2021-04-15 12:50:55.451433', '2021-04-15 12:50:55.451433', NULL),
	(10001489, 1, 'PW21A-SW100318OL-L', 3, 0, '2021-04-15 12:50:55.452122', '2021-04-15 12:50:55.452122', NULL),
	(10001490, 1, 'PW21A-SW100318OL-XL', 3, 0, '2021-04-15 12:50:55.452428', '2021-04-15 12:50:55.452428', NULL),
	(10001491, 1, 'PW21A-SW100318OL-XXL', 0, 0, '2021-04-15 12:50:55.452711', '2021-04-15 12:50:55.452711', NULL),
	(10001492, 1, 'PW21A-SW100319WT-XS', 0, 0, '2021-04-15 12:50:55.442524', '2021-04-15 12:50:55.442524', NULL),
	(10001493, 1, 'PW21A-SW100319WT-S', 2, 0, '2021-04-15 12:50:55.454268', '2021-04-15 12:50:55.454268', NULL),
	(10001494, 1, 'PW21A-SW100319WT-M', 0, 0, '2021-04-15 12:50:55.455326', '2021-04-15 12:50:55.455326', NULL),
	(10001495, 1, 'PW21A-SW100319WT-L', 1, 0, '2021-04-15 12:50:55.457807', '2021-04-15 12:50:55.457807', NULL),
	(10001496, 1, 'PW21A-SW100319WT-XL', 0, 0, '2021-04-15 12:50:55.461991', '2021-04-15 12:50:55.461991', NULL),
	(10001497, 1, 'PW21A-SW100319WT-XXL', 0, 0, '2021-04-15 12:50:55.464477', '2021-04-15 12:50:55.464477', NULL),
	(10001498, 1, 'PW21A-SW100320BL-XS', 0, 0, '2021-04-15 12:50:55.471721', '2021-04-15 12:50:55.471721', NULL),
	(10001499, 1, 'PW21A-SW100320BL-S', 0, 0, '2021-04-15 12:50:55.473694', '2021-04-15 12:50:55.473694', NULL),
	(10001500, 1, 'PW21A-SW100320BL-M', 0, 0, '2021-04-15 12:50:55.475497', '2021-04-15 12:50:55.475497', NULL),
	(10001501, 1, 'PW21A-SW100320BL-L', 0, 0, '2021-04-15 12:50:55.476130', '2021-04-15 12:50:55.476130', NULL),
	(10001502, 1, 'PW21A-SW100320BL-XL', 0, 0, '2021-04-15 12:50:55.477818', '2021-04-15 12:50:55.477818', NULL),
	(10001503, 1, 'PW21A-SW100320BL-XXL', 0, 0, '2021-04-15 12:50:55.479964', '2021-04-15 12:50:55.479964', NULL),
	(10001504, 1, 'PW21A-SW100321BL-XS', 0, 0, '2021-04-15 12:50:55.481298', '2021-04-15 12:50:55.481298', NULL),
	(10001505, 1, 'PW21A-SW100321BL-S', 0, 0, '2021-04-15 12:50:55.484539', '2021-04-15 12:50:55.484539', NULL),
	(10001506, 1, 'PW21A-SW100321BL-M', 0, 0, '2021-04-15 12:50:55.487431', '2021-04-15 12:50:55.487431', NULL),
	(10001507, 1, 'PW21A-SW100321BL-L', 0, 0, '2021-04-15 12:50:55.491180', '2021-04-15 12:50:55.491180', NULL),
	(10001508, 1, 'PW21A-SW100321BL-XL', 0, 0, '2021-04-15 12:50:55.507741', '2021-04-15 12:50:55.507741', NULL),
	(10001509, 1, 'PW21A-SW100321BL-XXL', 0, 0, '2021-04-15 12:50:55.501722', '2021-04-15 12:50:55.501722', NULL),
	(10001510, 1, 'PW21A-SW100322BL-XS', 0, 0, '2021-04-15 12:50:55.502472', '2021-04-15 12:50:55.502472', NULL),
	(10001511, 1, 'PW21A-SW100322BL-S', 0, 0, '2021-04-15 12:50:55.513228', '2021-04-15 12:50:55.513228', NULL),
	(10001512, 1, 'PW21A-SW100322BL-M', 0, 0, '2021-04-15 12:50:55.513756', '2021-04-15 12:50:55.513756', NULL),
	(10001513, 1, 'PW21A-SW100322BL-L', 0, 0, '2021-04-15 12:50:55.516456', '2021-04-15 12:50:55.516456', NULL),
	(10001514, 1, 'PW21A-SW100322BL-XL', 0, 0, '2021-04-15 12:50:55.517230', '2021-04-15 12:50:55.517230', NULL),
	(10001515, 1, 'PW21A-SW100322BL-XXL', 0, 0, '2021-04-15 12:50:55.520099', '2021-04-15 12:50:55.520099', NULL),
	(10001516, 1, 'PW21A-SW100323BL-XS', 0, 0, '2021-04-15 12:50:55.524345', '2021-04-15 12:50:55.524345', NULL),
	(10001517, 1, 'PW21A-SW100323BL-S', 0, 0, '2021-04-15 12:50:55.529665', '2021-04-15 12:50:55.529665', NULL),
	(10001518, 1, 'PW21A-SW100323BL-M', 0, 0, '2021-04-15 12:50:55.532977', '2021-04-15 12:50:55.532977', NULL),
	(10001519, 1, 'PW21A-SW100323BL-L', 0, 0, '2021-04-15 12:50:55.535582', '2021-04-15 12:50:55.535582', NULL),
	(10001520, 1, 'PW21A-SW100323BL-XL', 0, 0, '2021-04-15 12:50:55.536150', '2021-04-15 12:50:55.536150', NULL),
	(10001521, 1, 'PW21A-SW100323BL-XXL', 0, 0, '2021-04-15 12:50:55.540649', '2021-04-15 12:50:55.540649', NULL),
	(10001522, 1, 'PW21A-SW100324BL-XS', 0, 0, '2021-04-15 12:50:55.543864', '2021-04-15 12:50:55.543864', NULL),
	(10001523, 1, 'PW21A-SW100324BL-S', 14, 0, '2021-04-15 12:50:55.543553', '2021-04-15 12:50:55.543553', NULL),
	(10001524, 1, 'PW21A-SW100324BL-M', 15, 0, '2021-04-15 12:50:55.544235', '2021-04-15 12:50:55.544235', NULL),
	(10001525, 1, 'PW21A-SW100324BL-L', 24, 0, '2021-04-15 12:50:55.546843', '2021-04-15 12:50:55.546843', NULL),
	(10001526, 1, 'PW21A-SW100324BL-XL', 9, 0, '2021-04-15 12:50:55.550340', '2021-04-15 12:50:55.550340', NULL),
	(10001527, 1, 'PW21A-SW100324BL-XXL', 3, 0, '2021-04-15 12:50:55.546484', '2021-04-15 12:50:55.546484', NULL),
	(10001528, 1, 'PW21A-SW100325BL-XS', 0, 0, '2021-04-15 12:50:55.565420', '2021-04-15 12:50:55.565420', NULL),
	(10001529, 1, 'PW21A-SW100325BL-S', 11, 0, '2021-04-15 12:50:55.559100', '2021-04-15 12:50:55.559100', NULL),
	(10001530, 1, 'PW21A-SW100325BL-M', 26, 0, '2021-04-15 12:50:55.570022', '2021-04-15 12:50:55.570022', NULL),
	(10001531, 1, 'PW21A-SW100325BL-L', 38, 0, '2021-04-15 12:50:55.571418', '2021-04-15 12:50:55.571418', NULL),
	(10001532, 1, 'PW21A-SW100325BL-XL', 24, 0, '2021-04-15 12:50:55.574204', '2021-04-15 12:50:55.574204', NULL),
	(10001533, 1, 'PW21A-SW100325BL-XXL', 5, 0, '2021-04-15 12:50:55.574632', '2021-04-15 12:50:55.574632', NULL),
	(10001534, 1, 'PW21A-SW100326BL-XS', 0, 0, '2021-04-15 12:50:55.575633', '2021-04-15 12:50:55.575633', NULL),
	(10001535, 1, 'PW21A-SW100326BL-S', 13, 0, '2021-04-15 12:50:55.575960', '2021-04-15 12:50:55.575960', NULL),
	(10001536, 1, 'PW21A-SW100326BL-M', 16, 0, '2021-04-15 12:50:55.576283', '2021-04-15 12:50:55.576283', NULL),
	(10001537, 1, 'PW21A-SW100326BL-L', 20, 0, '2021-04-15 12:50:55.579566', '2021-04-15 12:50:55.579566', NULL),
	(10001538, 1, 'PW21A-SW100326BL-XL', 9, 0, '2021-04-15 12:50:55.585554', '2021-04-15 12:50:55.585554', NULL),
	(10001539, 1, 'PW21A-SW100326BL-XXL', 3, 0, '2021-04-15 12:50:55.584801', '2021-04-15 12:50:55.584801', NULL),
	(10001540, 1, 'PW21A-SW100327BL-XS', 0, 0, '2021-04-15 12:50:55.592244', '2021-04-15 12:50:55.592244', NULL),
	(10001541, 1, 'PW21A-SW100327BL-S', 14, 0, '2021-04-15 12:50:55.595114', '2021-04-15 12:50:55.595114', NULL),
	(10001542, 1, 'PW21A-SW100327BL-M', 17, 0, '2021-04-15 12:50:55.600455', '2021-04-15 12:50:55.600455', NULL),
	(10001543, 1, 'PW21A-SW100327BL-L', 24, 0, '2021-04-15 12:50:55.614094', '2021-04-15 12:50:55.614094', NULL),
	(10001544, 1, 'PW21A-SW100327BL-XL', 14, 0, '2021-04-15 12:50:55.616770', '2021-04-15 12:50:55.616770', NULL),
	(10001545, 1, 'PW21A-SW100327BL-XXL', 1, 0, '2021-04-15 12:50:55.605358', '2021-04-15 12:50:55.605358', NULL),
	(10001546, 1, 'PW21A-SW100328BL-XS', 0, 0, '2021-04-15 12:50:55.619739', '2021-04-15 12:50:55.619739', NULL),
	(10001547, 1, 'PW21A-SW100328BL-S', 13, 0, '2021-04-15 12:50:55.625612', '2021-04-15 12:50:55.625612', NULL),
	(10001548, 1, 'PW21A-SW100328BL-M', 18, 0, '2021-04-15 12:50:55.636833', '2021-04-15 12:50:55.636833', NULL),
	(10001549, 1, 'PW21A-SW100328BL-L', 20, 0, '2021-04-15 12:50:55.639641', '2021-04-15 12:50:55.639641', NULL),
	(10001550, 1, 'PW21A-SW100328BL-XL', 11, 0, '2021-04-15 12:50:55.645850', '2021-04-15 12:50:55.645850', NULL),
	(10001551, 1, 'PW21A-SW100328BL-XXL', 7, 0, '2021-04-15 12:50:55.657444', '2021-04-15 12:50:55.657444', NULL),
	(10001552, 1, 'PW21A-SW100329BL-XS', 0, 0, '2021-04-15 12:50:55.651251', '2021-04-15 12:50:55.651251', NULL),
	(10001553, 1, 'PW21A-SW100329BL-S', 12, 0, '2021-04-15 12:50:55.665620', '2021-04-15 12:50:55.665620', NULL),
	(10001554, 1, 'PW21A-SW100329BL-M', 20, 0, '2021-04-15 12:50:55.664623', '2021-04-15 12:50:55.664623', NULL),
	(10001555, 1, 'PW21A-SW100329BL-L', 25, 0, '2021-04-15 12:50:55.665960', '2021-04-15 12:50:55.665960', NULL),
	(10001556, 1, 'PW21A-SW100329BL-XL', 10, 0, '2021-04-15 12:50:55.667101', '2021-04-15 12:50:55.667101', NULL),
	(10001557, 1, 'PW21A-SW100329BL-XXL', 5, 0, '2021-04-15 12:50:55.668098', '2021-04-15 12:50:55.668098', NULL),
	(10001558, 1, 'PW21A-SW100330BL-XS', 0, 0, '2021-04-15 12:50:55.675785', '2021-04-15 12:50:55.675785', NULL),
	(10001559, 1, 'PW21A-SW100330BL-S', 10, 0, '2021-04-15 12:50:55.677372', '2021-04-15 12:50:55.677372', NULL),
	(10001560, 1, 'PW21A-SW100330BL-M', 17, 0, '2021-04-15 12:50:55.678050', '2021-04-15 12:50:55.678050', NULL),
	(10001561, 1, 'PW21A-SW100330BL-L', 17, 0, '2021-04-15 12:50:55.681613', '2021-04-15 12:50:55.681613', NULL),
	(10001562, 1, 'PW21A-SW100330BL-XL', 9, 0, '2021-04-15 12:50:55.684024', '2021-04-15 12:50:55.684024', NULL),
	(10001563, 1, 'PW21A-SW100330BL-XXL', 4, 0, '2021-04-15 12:50:55.686590', '2021-04-15 12:50:55.686590', NULL),
	(10001564, 1, 'PW21A-PN100331BL-28', 0, 0, '2021-04-15 12:50:55.687057', '2021-04-15 12:50:55.687057', NULL),
	(10001565, 1, 'PW21A-PN100331BL-30', 0, 0, '2021-04-15 12:50:55.687422', '2021-04-15 12:50:55.687422', NULL),
	(10001566, 1, 'PW21A-PN100331BL-32', 0, 0, '2021-04-15 12:50:55.688226', '2021-04-15 12:50:55.688226', NULL),
	(10001567, 1, 'PW21A-PN100331BL-34', 0, 0, '2021-04-15 12:50:55.689826', '2021-04-15 12:50:55.689826', NULL),
	(10001568, 1, 'PW21A-PN100331BL-36', 0, 0, '2021-04-15 12:50:55.697787', '2021-04-15 12:50:55.697787', NULL),
	(10001569, 1, 'PW21A-PN100332BL-28', 0, 0, '2021-04-15 12:50:55.698601', '2021-04-15 12:50:55.698601', NULL),
	(10001570, 1, 'PW21A-PN100332BL-30', 4, 0, '2021-04-15 12:50:55.699208', '2021-04-15 12:50:55.699208', NULL),
	(10001571, 1, 'PW21A-PN100332BL-32', 2, 0, '2021-04-15 12:50:55.702560', '2021-04-15 12:50:55.702560', NULL),
	(10001572, 1, 'PW21A-PN100332BL-34', 0, 0, '2021-04-15 12:50:55.705415', '2021-04-15 12:50:55.705415', NULL),
	(10001573, 1, 'PW21A-PN100332BL-36', 0, 0, '2021-04-15 12:50:55.706688', '2021-04-15 12:50:55.706688', NULL),
	(10001574, 1, 'PW21A-PN100333BL-28', 3, 0, '2021-04-15 12:50:55.709545', '2021-04-15 12:50:55.709545', NULL),
	(10001575, 1, 'PW21A-PN100333BL-30', 7, 0, '2021-04-15 12:50:55.707250', '2021-04-15 12:50:55.707250', NULL),
	(10001576, 1, 'PW21A-PN100333BL-32', 3, 0, '2021-04-15 12:50:55.712158', '2021-04-15 12:50:55.712158', NULL),
	(10001577, 1, 'PW21A-PN100333BL-34', 0, 0, '2021-04-15 12:50:55.723714', '2021-04-15 12:50:55.723714', NULL),
	(10001578, 1, 'PW21A-PN100333BL-36', 0, 0, '2021-04-15 12:50:55.713281', '2021-04-15 12:50:55.713281', NULL),
	(10001579, 1, 'PW21A-PN100334BL-28', 2, 0, '2021-04-15 12:50:55.726643', '2021-04-15 12:50:55.726643', NULL),
	(10001580, 1, 'PW21A-PN100334BL-30', 2, 0, '2021-04-15 12:50:55.727576', '2021-04-15 12:50:55.727576', NULL),
	(10001581, 1, 'PW21A-PN100334BL-32', 2, 0, '2021-04-15 12:50:55.730234', '2021-04-15 12:50:55.730234', NULL),
	(10001582, 1, 'PW21A-PN100334BL-34', 0, 0, '2021-04-15 12:50:55.731984', '2021-04-15 12:50:55.731984', NULL),
	(10001583, 1, 'PW21A-PN100334BL-36', 0, 0, '2021-04-15 12:50:55.733465', '2021-04-15 12:50:55.733465', NULL),
	(10001584, 1, 'PW21A-PN100335BL-28', 0, 0, '2021-04-15 12:50:55.734206', '2021-04-15 12:50:55.734206', NULL),
	(10001585, 1, 'PW21A-PN100335BL-30', 3, 0, '2021-04-15 12:50:55.738884', '2021-04-15 12:50:55.738884', NULL),
	(10001586, 1, 'PW21A-PN100335BL-32', 4, 0, '2021-04-15 12:50:55.739967', '2021-04-15 12:50:55.739967', NULL),
	(10001587, 1, 'PW21A-PN100335BL-34', 0, 0, '2021-04-15 12:50:55.744016', '2021-04-15 12:50:55.744016', NULL),
	(10001588, 1, 'PW21A-PN100335BL-36', 0, 0, '2021-04-15 12:50:55.748770', '2021-04-15 12:50:55.748770', NULL),
	(10001589, 1, 'PW21A-PN100336GN-28', 0, 0, '2021-04-15 12:50:55.758314', '2021-04-15 12:50:55.758314', NULL),
	(10001590, 1, 'PW21A-PN100336GN-30', 8, 0, '2021-04-15 12:50:55.755202', '2021-04-15 12:50:55.755202', NULL),
	(10001591, 1, 'PW21A-PN100336GN-32', 6, 0, '2021-04-15 12:50:55.765919', '2021-04-15 12:50:55.765919', NULL),
	(10001592, 1, 'PW21A-PN100336GN-34', 1, 0, '2021-04-15 12:50:55.768353', '2021-04-15 12:50:55.768353', NULL),
	(10001593, 1, 'PW21A-PN100336GN-36', 0, 0, '2021-04-15 12:50:55.766344', '2021-04-15 12:50:55.766344', NULL),
	(10001594, 1, 'PW21A-PN100337CM-28', 5, 0, '2021-04-15 12:50:55.773961', '2021-04-15 12:50:55.773961', NULL),
	(10001595, 1, 'PW21A-PN100337CM-30', 5, 0, '2021-04-15 12:50:55.775341', '2021-04-15 12:50:55.775341', NULL),
	(10001596, 1, 'PW21A-PN100337CM-32', 6, 0, '2021-04-15 12:50:55.763984', '2021-04-15 12:50:55.763984', NULL),
	(10001597, 1, 'PW21A-PN100337CM-34', 0, 0, '2021-04-15 12:50:55.779481', '2021-04-15 12:50:55.779481', NULL),
	(10001598, 1, 'PW21A-PN100337CM-36', 0, 0, '2021-04-15 12:50:55.784647', '2021-04-15 12:50:55.784647', NULL),
	(10001599, 1, 'PW21A-PN100338BL-28', 6, 0, '2021-04-15 12:50:55.785182', '2021-04-15 12:50:55.785182', NULL),
	(10001600, 1, 'PW21A-PN100338BL-30', 9, 0, '2021-04-15 12:50:55.790486', '2021-04-15 12:50:55.790486', NULL),
	(10001601, 1, 'PW21A-PN100338BL-32', 13, 0, '2021-04-15 12:50:55.793819', '2021-04-15 12:50:55.793819', NULL),
	(10001602, 1, 'PW21A-PN100338BL-34', 3, 0, '2021-04-15 12:50:55.797931', '2021-04-15 12:50:55.797931', NULL),
	(10001603, 1, 'PW21A-PN100338BL-36', 1, 0, '2021-04-15 12:50:55.798487', '2021-04-15 12:50:55.798487', NULL),
	(10001604, 1, 'PW21A-PN100339CM-28', 9, 0, '2021-04-15 12:50:55.799875', '2021-04-15 12:50:55.799875', NULL),
	(10001605, 1, 'PW21A-PN100339CM-30', 14, 0, '2021-04-15 12:50:55.806716', '2021-04-15 12:50:55.806716', NULL),
	(10001606, 1, 'PW21A-PN100339CM-32', 20, 0, '2021-04-15 12:50:55.803131', '2021-04-15 12:50:55.803131', NULL),
	(10001607, 1, 'PW21A-PN100339CM-34', 6, 0, '2021-04-15 12:50:55.809762', '2021-04-15 12:50:55.809762', NULL),
	(10001608, 1, 'PW21A-PN100339CM-36', 3, 0, '2021-04-15 12:50:55.812180', '2021-04-15 12:50:55.812180', NULL),
	(10001609, 1, 'PW21A-PN100340OL-28', 6, 0, '2021-04-15 12:50:55.813578', '2021-04-15 12:50:55.813578', NULL),
	(10001610, 1, 'PW21A-PN100340OL-30', 14, 0, '2021-04-15 12:50:55.818029', '2021-04-15 12:50:55.818029', NULL),
	(10001611, 1, 'PW21A-PN100340OL-32', 16, 0, '2021-04-15 12:50:55.821817', '2021-04-15 12:50:55.821817', NULL),
	(10001612, 1, 'PW21A-PN100340OL-34', 5, 0, '2021-04-15 12:50:55.828091', '2021-04-15 12:50:55.828091', NULL),
	(10001613, 1, 'PW21A-PN100340OL-36', 3, 0, '2021-04-15 12:50:55.828530', '2021-04-15 12:50:55.828530', NULL),
	(10001614, 1, 'PW21A-PN100341DM-28', 1, 0, '2021-04-15 12:50:55.828950', '2021-04-15 12:50:55.828950', NULL),
	(10001615, 1, 'PW21A-PN100341DM-30', 7, 0, '2021-04-15 12:50:55.832679', '2021-04-15 12:50:55.832679', NULL),
	(10001616, 1, 'PW21A-PN100341DM-32', 15, 0, '2021-04-15 12:50:55.835179', '2021-04-15 12:50:55.835179', NULL),
	(10001617, 1, 'PW21A-PN100341DM-34', 6, 0, '2021-04-15 12:50:55.836114', '2021-04-15 12:50:55.836114', NULL),
	(10001618, 1, 'PW21A-PN100341DM-36', 0, 0, '2021-04-15 12:50:55.841283', '2021-04-15 12:50:55.841283', NULL),
	(10001619, 1, 'PW21A-PN100342DM-28', 1, 0, '2021-04-15 12:50:55.841709', '2021-04-15 12:50:55.841709', NULL),
	(10001620, 1, 'PW21A-PN100342DM-30', 8, 0, '2021-04-15 12:50:55.848184', '2021-04-15 12:50:55.848184', NULL),
	(10001621, 1, 'PW21A-PN100342DM-32', 18, 0, '2021-04-15 12:50:55.853401', '2021-04-15 12:50:55.853401', NULL),
	(10001622, 1, 'PW21A-PN100342DM-34', 7, 0, '2021-04-15 12:50:55.856434', '2021-04-15 12:50:55.856434', NULL),
	(10001623, 1, 'PW21A-PN100342DM-36', 0, 0, '2021-04-15 12:50:55.857882', '2021-04-15 12:50:55.857882', NULL),
	(10001624, 1, 'PW21A-PN100343DM-28', 0, 0, '2021-04-15 12:50:55.858411', '2021-04-15 12:50:55.858411', NULL),
	(10001625, 1, 'PW21A-PN100343DM-30', 9, 0, '2021-04-15 12:50:55.869367', '2021-04-15 12:50:55.869367', NULL),
	(10001626, 1, 'PW21A-PN100343DM-32', 17, 0, '2021-04-15 12:50:55.874774', '2021-04-15 12:50:55.874774', NULL),
	(10001627, 1, 'PW21A-PN100343DM-34', 8, 0, '2021-04-15 12:50:55.879259', '2021-04-15 12:50:55.879259', NULL),
	(10001628, 1, 'PW21A-PN100343DM-36', 0, 0, '2021-04-15 12:50:55.880294', '2021-04-15 12:50:55.880294', NULL),
	(10001629, 1, 'PW21A-WL100344BW-All', 18, 0, '2021-04-15 12:50:55.882755', '2021-04-15 12:50:55.882755', NULL),
	(10001630, 1, 'PW21A-WL100345BW-All', 18, 0, '2021-04-15 12:50:55.886564', '2021-04-15 12:50:55.886564', NULL),
	(10001631, 1, 'PW21A-WL100346BW-All', 4, 0, '2021-04-15 12:50:55.890422', '2021-04-15 12:50:55.890422', NULL),
	(10001632, 1, 'PW21A-HM100347BL-XS', 0, 0, '2021-04-15 12:50:55.890789', '2021-04-15 12:50:55.890789', NULL),
	(10001633, 1, 'PW21A-HM100347BL-S', 0, 0, '2021-04-15 12:50:55.892458', '2021-04-15 12:50:55.892458', NULL),
	(10001634, 1, 'PW21A-HM100347BL-M', 0, 0, '2021-04-15 12:50:55.892793', '2021-04-15 12:50:55.892793', NULL),
	(10001635, 1, 'PW21A-HM100347BL-L', 0, 0, '2021-04-15 12:50:55.895735', '2021-04-15 12:50:55.895735', NULL),
	(10001636, 1, 'PW21A-HM100347BL-XL', 0, 0, '2021-04-15 12:50:55.896875', '2021-04-15 12:50:55.896875', NULL),
	(10001637, 1, 'PW21A-HM100347BL-XXL', 0, 0, '2021-04-15 12:50:55.901847', '2021-04-15 12:50:55.901847', NULL),
	(10001638, 1, 'PW21A-HM100348WT-XS', 0, 0, '2021-04-15 12:50:55.902192', '2021-04-15 12:50:55.902192', NULL),
	(10001639, 1, 'PW21A-HM100348WT-S', 0, 0, '2021-04-15 12:50:55.905396', '2021-04-15 12:50:55.905396', NULL),
	(10001640, 1, 'PW21A-HM100348WT-M', 0, 0, '2021-04-15 12:50:55.907888', '2021-04-15 12:50:55.907888', NULL),
	(10001641, 1, 'PW21A-HM100348WT-L', 0, 0, '2021-04-15 12:50:55.911416', '2021-04-15 12:50:55.911416', NULL),
	(10001642, 1, 'PW21A-HM100348WT-XL', 0, 0, '2021-04-15 12:50:55.912507', '2021-04-15 12:50:55.912507', NULL),
	(10001643, 1, 'PW21A-HM100348WT-XXL', 0, 0, '2021-04-15 12:50:55.914347', '2021-04-15 12:50:55.914347', NULL),
	(10001644, 1, 'PW21A-HM100349BL-XS', 0, 0, '2021-04-15 12:50:55.914805', '2021-04-15 12:50:55.914805', NULL),
	(10001645, 1, 'PW21A-HM100349BL-S', 0, 0, '2021-04-15 12:50:55.916729', '2021-04-15 12:50:55.916729', NULL),
	(10001646, 1, 'PW21A-HM100349BL-M', 0, 0, '2021-04-15 12:50:55.918302', '2021-04-15 12:50:55.918302', NULL),
	(10001647, 1, 'PW21A-HM100349BL-L', 0, 0, '2021-04-15 12:50:55.924299', '2021-04-15 12:50:55.924299', NULL),
	(10001648, 1, 'PW21A-HM100349BL-XL', 0, 0, '2021-04-15 12:50:55.926010', '2021-04-15 12:50:55.926010', NULL),
	(10001649, 1, 'PW21A-HM100349BL-XXL', 0, 0, '2021-04-15 12:50:55.933451', '2021-04-15 12:50:55.933451', NULL),
	(10001650, 1, 'PW21A-HM100350BL-XS', 0, 0, '2021-04-15 12:50:55.938802', '2021-04-15 12:50:55.938802', NULL),
	(10001651, 1, 'PW21A-HM100350BL-S', 0, 0, '2021-04-15 12:50:55.942758', '2021-04-15 12:50:55.942758', NULL),
	(10001652, 1, 'PW21A-HM100350BL-M', 0, 0, '2021-04-15 12:50:55.941904', '2021-04-15 12:50:55.941904', NULL),
	(10001653, 1, 'PW21A-HM100350BL-L', 0, 0, '2021-04-15 12:50:55.947655', '2021-04-15 12:50:55.947655', NULL),
	(10001654, 1, 'PW21A-HM100350BL-XL', 0, 0, '2021-04-15 12:50:55.947952', '2021-04-15 12:50:55.947952', NULL),
	(10001655, 1, 'PW21A-HM100350BL-XXL', 0, 0, '2021-04-15 12:50:55.949491', '2021-04-15 12:50:55.949491', NULL),
	(10001656, 1, 'PW21A-HM100351BL-XS', 0, 0, '2021-04-15 12:50:55.951640', '2021-04-15 12:50:55.951640', NULL),
	(10001657, 1, 'PW21A-HM100351BL-S', 0, 0, '2021-04-15 12:50:55.954271', '2021-04-15 12:50:55.954271', NULL),
	(10001658, 1, 'PW21A-HM100351BL-M', 1, 0, '2021-04-15 12:50:55.957891', '2021-04-15 12:50:55.957891', NULL),
	(10001659, 1, 'PW21A-HM100351BL-L', 0, 0, '2021-04-15 12:50:55.960054', '2021-04-15 12:50:55.960054', NULL),
	(10001660, 1, 'PW21A-HM100351BL-XL', 0, 0, '2021-04-15 12:50:55.964321', '2021-04-15 12:50:55.964321', NULL),
	(10001661, 1, 'PW21A-HM100351BL-XXL', 0, 0, '2021-04-15 12:50:55.965480', '2021-04-15 12:50:55.965480', NULL),
	(10001662, 1, 'PW21A-HM100352BL-XS', 0, 0, '2021-04-15 12:50:55.967343', '2021-04-15 12:50:55.967343', NULL),
	(10001663, 1, 'PW21A-HM100352BL-S', 0, 0, '2021-04-15 12:50:55.971379', '2021-04-15 12:50:55.971379', NULL),
	(10001664, 1, 'PW21A-HM100352BL-M', 0, 0, '2021-04-15 12:50:55.972846', '2021-04-15 12:50:55.972846', NULL),
	(10001665, 1, 'PW21A-HM100352BL-L', 0, 0, '2021-04-15 12:50:55.975801', '2021-04-15 12:50:55.975801', NULL),
	(10001666, 1, 'PW21A-HM100352BL-XL', 0, 0, '2021-04-15 12:50:55.977743', '2021-04-15 12:50:55.977743', NULL),
	(10001667, 1, 'PW21A-HM100352BL-XXL', 0, 0, '2021-04-15 12:50:55.979398', '2021-04-15 12:50:55.979398', NULL),
	(10001668, 1, 'PW21A-HM100353WT-XS', 0, 0, '2021-04-15 12:50:55.984818', '2021-04-15 12:50:55.984818', NULL),
	(10001669, 1, 'PW21A-HM100353WT-S', 1, 0, '2021-04-15 12:50:55.986586', '2021-04-15 12:50:55.986586', NULL),
	(10001670, 1, 'PW21A-HM100353WT-M', 1, 0, '2021-04-15 12:50:55.991625', '2021-04-15 12:50:55.991625', NULL),
	(10001671, 1, 'PW21A-HM100353WT-L', 2, 0, '2021-04-15 12:50:55.996266', '2021-04-15 12:50:55.996266', NULL),
	(10001672, 1, 'PW21A-HM100353WT-XL', 1, 0, '2021-04-15 12:50:56.002820', '2021-04-15 12:50:56.002820', NULL),
	(10001673, 1, 'PW21A-HM100353WT-XXL', 0, 0, '2021-04-15 12:50:56.005867', '2021-04-15 12:50:56.005867', NULL),
	(10001674, 1, 'PW21A-HM100354WT-XS', 0, 0, '2021-04-15 12:50:56.007938', '2021-04-15 12:50:56.007938', NULL),
	(10001675, 1, 'PW21A-HM100354WT-S', 0, 0, '2021-04-15 12:50:56.008824', '2021-04-15 12:50:56.008824', NULL),
	(10001676, 1, 'PW21A-HM100354WT-M', 1, 0, '2021-04-15 12:50:56.011444', '2021-04-15 12:50:56.011444', NULL),
	(10001677, 1, 'PW21A-HM100354WT-L', 0, 0, '2021-04-15 12:50:56.009320', '2021-04-15 12:50:56.009320', NULL),
	(10001678, 1, 'PW21A-HM100354WT-XL', 1, 0, '2021-04-15 12:50:56.015510', '2021-04-15 12:50:56.015510', NULL),
	(10001679, 1, 'PW21A-HM100354WT-XXL', 0, 0, '2021-04-15 12:50:56.017248', '2021-04-15 12:50:56.017248', NULL),
	(10001680, 1, 'PW21A-HM100355RD-XS', 0, 0, '2021-04-15 12:50:56.026706', '2021-04-15 12:50:56.026706', NULL),
	(10001681, 1, 'PW21A-HM100355RD-S', 0, 0, '2021-04-15 12:50:56.086164', '2021-04-15 12:50:56.086164', NULL),
	(10001682, 1, 'PW21A-HM100355RD-M', 2, 0, '2021-04-15 12:50:56.096352', '2021-04-15 12:50:56.096352', NULL),
	(10001683, 1, 'PW21A-HM100355RD-L', 1, 0, '2021-04-15 12:50:56.089555', '2021-04-15 12:50:56.089555', NULL),
	(10001684, 1, 'PW21A-HM100355RD-XL', 1, 0, '2021-04-15 12:50:56.096071', '2021-04-15 12:50:56.096071', NULL),
	(10001685, 1, 'PW21A-HM100355RD-XXL', 0, 0, '2021-04-15 12:50:56.088775', '2021-04-15 12:50:56.088775', NULL),
	(10001686, 1, 'PW21A-HM100356YW -XS', 0, 0, '2021-04-15 12:50:56.089153', '2021-04-15 12:50:56.089153', NULL),
	(10001687, 1, 'PW21A-HM100356YW -S', 0, 0, '2021-04-15 12:50:56.089328', '2021-04-15 12:50:56.089328', NULL),
	(10001688, 1, 'PW21A-HM100356YW -M', 1, 0, '2021-04-15 12:50:56.102981', '2021-04-15 12:50:56.102981', NULL),
	(10001689, 1, 'PW21A-HM100356YW -L', 1, 0, '2021-04-15 12:50:56.090448', '2021-04-15 12:50:56.090448', NULL),
	(10001690, 1, 'PW21A-HM100356YW -XL', 0, 0, '2021-04-15 12:50:56.099061', '2021-04-15 12:50:56.099061', NULL),
	(10001691, 1, 'PW21A-HM100356YW -XXL', 0, 0, '2021-04-15 12:50:56.102488', '2021-04-15 12:50:56.102488', NULL),
	(10001692, 1, 'PW21A-HM100357YW -XS', 0, 0, '2021-04-15 12:50:56.108312', '2021-04-15 12:50:56.108312', NULL),
	(10001693, 1, 'PW21A-HM100357YW -S', 1, 0, '2021-04-15 12:50:56.108788', '2021-04-15 12:50:56.108788', NULL),
	(10001694, 1, 'PW21A-HM100357YW -M', 2, 0, '2021-04-15 12:50:56.109590', '2021-04-15 12:50:56.109590', NULL),
	(10001695, 1, 'PW21A-HM100357YW -L', 0, 0, '2021-04-15 12:50:56.114875', '2021-04-15 12:50:56.114875', NULL),
	(10001696, 1, 'PW21A-HM100357YW -XL', 0, 0, '2021-04-15 12:50:56.120001', '2021-04-15 12:50:56.120001', NULL),
	(10001697, 1, 'PW21A-HM100357YW -XXL', 0, 0, '2021-04-15 12:50:56.120993', '2021-04-15 12:50:56.120993', NULL),
	(10001698, 1, 'PW21A-HM100358WT-XS', 0, 0, '2021-04-15 12:50:56.140318', '2021-04-15 12:50:56.140318', NULL),
	(10001699, 1, 'PW21A-HM100358WT-S', 0, 0, '2021-04-15 12:50:56.125741', '2021-04-15 12:50:56.125741', NULL),
	(10001700, 1, 'PW21A-HM100358WT-M', 0, 0, '2021-04-15 12:50:56.128203', '2021-04-15 12:50:56.128203', NULL),
	(10001701, 1, 'PW21A-HM100358WT-L', 0, 0, '2021-04-15 12:50:56.129290', '2021-04-15 12:50:56.129290', NULL),
	(10001702, 1, 'PW21A-HM100358WT-XL', 0, 0, '2021-04-15 12:50:56.134467', '2021-04-15 12:50:56.134467', NULL),
	(10001703, 1, 'PW21A-HM100358WT-XXL', 0, 0, '2021-04-15 12:50:56.139181', '2021-04-15 12:50:56.139181', NULL),
	(10001704, 1, 'PW21A-JK100359NV-XS', 0, 0, '2021-04-15 12:50:56.138890', '2021-04-15 12:50:56.138890', NULL),
	(10001705, 1, 'PW21A-JK100359NV-S', 0, 0, '2021-04-15 12:50:56.138408', '2021-04-15 12:50:56.138408', NULL),
	(10001706, 1, 'PW21A-JK100359NV-M', 0, 0, '2021-04-15 12:50:56.180949', '2021-04-15 12:50:56.180949', NULL),
	(10001707, 1, 'PW21A-JK100359NV-L', 0, 0, '2021-04-15 12:50:56.148066', '2021-04-15 12:50:56.148066', NULL),
	(10001708, 1, 'PW21A-JK100359NV-XL', 4, 0, '2021-04-15 12:50:56.149071', '2021-04-15 12:50:56.149071', NULL),
	(10001709, 1, 'PW21A-JK100359NV-XXL', 0, 0, '2021-04-15 12:50:56.151906', '2021-04-15 12:50:56.151906', NULL),
	(10001710, 1, 'PW21A-SH100360DM-XS', 0, 0, '2021-04-15 12:50:56.152524', '2021-04-15 12:50:56.152524', NULL),
	(10001711, 1, 'PW21A-SH100360DM-S', 1, 0, '2021-04-15 12:50:56.154870', '2021-04-15 12:50:56.154870', NULL),
	(10001712, 1, 'PW21A-SH100360DM-M', 0, 0, '2021-04-15 12:50:56.157186', '2021-04-15 12:50:56.157186', NULL),
	(10001713, 1, 'PW21A-SH100360DM-L', 4, 0, '2021-04-15 12:50:56.165058', '2021-04-15 12:50:56.165058', NULL),
	(10001714, 1, 'PW21A-SH100360DM-XL', 4, 0, '2021-04-15 12:50:56.167592', '2021-04-15 12:50:56.167592', NULL),
	(10001715, 1, 'PW21A-SH100360DM-XXL', 0, 0, '2021-04-15 12:50:56.168673', '2021-04-15 12:50:56.168673', NULL),
	(10001716, 1, 'PW21A-SH100361BL-XS', 0, 0, '2021-04-15 12:50:56.169681', '2021-04-15 12:50:56.169681', NULL),
	(10001717, 1, 'PW21A-SH100361BL-S', 1, 0, '2021-04-15 12:50:56.173082', '2021-04-15 12:50:56.173082', NULL),
	(10001718, 1, 'PW21A-SH100361BL-M', 0, 0, '2021-04-15 12:50:56.173211', '2021-04-15 12:50:56.173211', NULL),
	(10001719, 1, 'PW21A-SH100361BL-L', 0, 0, '2021-04-15 12:50:56.192535', '2021-04-15 12:50:56.192535', NULL),
	(10001720, 1, 'PW21A-SH100361BL-XL', 0, 0, '2021-04-15 12:50:56.198929', '2021-04-15 12:50:56.198929', NULL),
	(10001721, 1, 'PW21A-SH100361BL-XXL', 0, 0, '2021-04-15 12:50:56.200186', '2021-04-15 12:50:56.200186', NULL),
	(10001722, 1, 'PW21A-SH100362BL-XS', 0, 0, '2021-04-15 12:50:56.205675', '2021-04-15 12:50:56.205675', NULL),
	(10001723, 1, 'PW21A-SH100362BL-S', 1, 0, '2021-04-15 12:50:56.206183', '2021-04-15 12:50:56.206183', NULL),
	(10001724, 1, 'PW21A-SH100362BL-M', 0, 0, '2021-04-15 12:50:56.207100', '2021-04-15 12:50:56.207100', NULL),
	(10001725, 1, 'PW21A-SH100362BL-L', 0, 0, '2021-04-15 12:50:56.207581', '2021-04-15 12:50:56.207581', NULL),
	(10001726, 1, 'PW21A-SH100362BL-XL', 0, 0, '2021-04-15 12:50:56.208751', '2021-04-15 12:50:56.208751', NULL),
	(10001727, 1, 'PW21A-SH100362BL-XXL', 0, 0, '2021-04-15 12:50:56.213037', '2021-04-15 12:50:56.213037', NULL),
	(10001728, 1, 'PW21A-JK100363BL-XS', 0, 0, '2021-04-15 12:50:56.219952', '2021-04-15 12:50:56.219952', NULL),
	(10001729, 1, 'PW21A-JK100363BL-S', 0, 0, '2021-04-15 12:50:56.227246', '2021-04-15 12:50:56.227246', NULL),
	(10001730, 1, 'PW21A-JK100363BL-M', 0, 0, '2021-04-15 12:50:56.232849', '2021-04-15 12:50:56.232849', NULL),
	(10001731, 1, 'PW21A-JK100363BL-L', 0, 0, '2021-04-15 12:50:56.238102', '2021-04-15 12:50:56.238102', NULL),
	(10001732, 1, 'PW21A-JK100363BL-XL', 0, 0, '2021-04-15 12:50:56.242002', '2021-04-15 12:50:56.242002', NULL),
	(10001733, 1, 'PW21A-JK100363BL-XXL', 0, 0, '2021-04-15 12:50:56.244230', '2021-04-15 12:50:56.244230', NULL),
	(10001734, 1, 'PW21A-SH100364BL-XS', 0, 0, '2021-04-15 12:50:56.243790', '2021-04-15 12:50:56.243790', NULL),
	(10001735, 1, 'PW21A-SH100364BL-S', 6, 0, '2021-04-15 12:50:56.246324', '2021-04-15 12:50:56.246324', NULL),
	(10001736, 1, 'PW21A-SH100364BL-M', 0, 0, '2021-04-15 12:50:56.246742', '2021-04-15 12:50:56.246742', NULL),
	(10001737, 1, 'PW21A-SH100364BL-L', 0, 0, '2021-04-15 12:50:56.248038', '2021-04-15 12:50:56.248038', NULL),
	(10001738, 1, 'PW21A-SH100364BL-XL', 0, 0, '2021-04-15 12:50:56.253250', '2021-04-15 12:50:56.253250', NULL),
	(10001739, 1, 'PW21A-SH100364BL-XXL', 0, 0, '2021-04-15 12:50:56.257187', '2021-04-15 12:50:56.257187', NULL),
	(10001740, 1, 'PW21A-SW100365GY-XS', 0, 0, '2021-04-15 12:50:56.260931', '2021-04-15 12:50:56.260931', NULL),
	(10001741, 1, 'PW21A-SW100365GY-S', 0, 0, '2021-04-15 12:50:56.265790', '2021-04-15 12:50:56.265790', NULL),
	(10001742, 1, 'PW21A-SW100365GY-M', 0, 0, '2021-04-15 12:50:56.268889', '2021-04-15 12:50:56.268889', NULL),
	(10001743, 1, 'PW21A-SW100365GY-L', 0, 0, '2021-04-15 12:50:56.272483', '2021-04-15 12:50:56.272483', NULL),
	(10001744, 1, 'PW21A-SW100365GY-XL', 0, 0, '2021-04-15 12:50:56.273693', '2021-04-15 12:50:56.273693', NULL),
	(10001745, 1, 'PW21A-SW100365GY-XXL', 0, 0, '2021-04-15 12:50:56.274863', '2021-04-15 12:50:56.274863', NULL),
	(10001746, 1, 'PW21A-SW100366GY-XS', 0, 0, '2021-04-15 12:50:56.275314', '2021-04-15 12:50:56.275314', NULL),
	(10001747, 1, 'PW21A-SW100366GY-S', 0, 0, '2021-04-15 12:50:56.278750', '2021-04-15 12:50:56.278750', NULL),
	(10001748, 1, 'PW21A-SW100366GY-M', 0, 0, '2021-04-15 12:50:56.281753', '2021-04-15 12:50:56.281753', NULL),
	(10001749, 1, 'PW21A-SW100366GY-L', 0, 0, '2021-04-15 12:50:56.286842', '2021-04-15 12:50:56.286842', NULL),
	(10001750, 1, 'PW21A-SW100366GY-XL', 0, 0, '2021-04-15 12:50:56.288584', '2021-04-15 12:50:56.288584', NULL),
	(10001751, 1, 'PW21A-SW100366GY-XXL', 0, 0, '2021-04-15 12:50:56.296119', '2021-04-15 12:50:56.296119', NULL),
	(10001752, 1, 'PW21A-SW100367BL-XS', 0, 0, '2021-04-15 12:50:56.298027', '2021-04-15 12:50:56.298027', NULL),
	(10001753, 1, 'PW21A-SW100367BL-S', 0, 0, '2021-04-15 12:50:56.301506', '2021-04-15 12:50:56.301506', NULL),
	(10001754, 1, 'PW21A-SW100367BL-M', 0, 0, '2021-04-15 12:50:56.301926', '2021-04-15 12:50:56.301926', NULL),
	(10001755, 1, 'PW21A-SW100367BL-L', 0, 0, '2021-04-15 12:50:56.303235', '2021-04-15 12:50:56.303235', NULL),
	(10001756, 1, 'PW21A-SW100367BL-XL', 0, 0, '2021-04-15 12:50:56.304117', '2021-04-15 12:50:56.304117', NULL),
	(10001757, 1, 'PW21A-SW100367BL-XXL', 0, 0, '2021-04-15 12:50:56.308214', '2021-04-15 12:50:56.308214', NULL),
	(10001758, 1, 'PW21A-SW100368NV-XS', 0, 0, '2021-04-15 12:50:56.312033', '2021-04-15 12:50:56.312033', NULL),
	(10001759, 1, 'PW21A-SW100368NV-S', 6, 0, '2021-04-15 12:50:56.318623', '2021-04-15 12:50:56.318623', NULL),
	(10001760, 1, 'PW21A-SW100368NV-M', 0, 0, '2021-04-15 12:50:56.319360', '2021-04-15 12:50:56.319360', NULL),
	(10001761, 1, 'PW21A-SW100368NV-L', 1, 0, '2021-04-15 12:50:56.327276', '2021-04-15 12:50:56.327276', NULL),
	(10001762, 1, 'PW21A-SW100368NV-XL', 0, 0, '2021-04-15 12:50:56.324010', '2021-04-15 12:50:56.324010', NULL),
	(10001763, 1, 'PW21A-SW100368NV-XXL', 0, 0, '2021-04-15 12:50:56.329632', '2021-04-15 12:50:56.329632', NULL),
	(10001764, 1, 'PW21A-JK100369BL-XS', 0, 0, '2021-04-15 12:50:56.333865', '2021-04-15 12:50:56.333865', NULL),
	(10001765, 1, 'PW21A-JK100369BL-S', 0, 0, '2021-04-15 12:50:56.336020', '2021-04-15 12:50:56.336020', NULL),
	(10001766, 1, 'PW21A-JK100369BL-M', 0, 0, '2021-04-15 12:50:56.337210', '2021-04-15 12:50:56.337210', NULL),
	(10001767, 1, 'PW21A-JK100369BL-L', 0, 0, '2021-04-15 12:50:56.346641', '2021-04-15 12:50:56.346641', NULL),
	(10001768, 1, 'PW21A-JK100369BL-XL', 2, 0, '2021-04-15 12:50:56.349264', '2021-04-15 12:50:56.349264', NULL),
	(10001769, 1, 'PW21A-JK100369BL-XXL', 0, 0, '2021-04-15 12:50:56.357649', '2021-04-15 12:50:56.357649', NULL),
	(10001770, 1, 'PW21A-SH100370NV-XS', 0, 0, '2021-04-15 12:50:56.360757', '2021-04-15 12:50:56.360757', NULL),
	(10001771, 1, 'PW21A-SH100370NV-S', 1, 0, '2021-04-15 12:50:56.363987', '2021-04-15 12:50:56.363987', NULL),
	(10001772, 1, 'PW21A-SH100370NV-M', 0, 0, '2021-04-15 12:50:56.364563', '2021-04-15 12:50:56.364563', NULL),
	(10001773, 1, 'PW21A-SH100370NV-L', 2, 0, '2021-04-15 12:50:56.369016', '2021-04-15 12:50:56.369016', NULL),
	(10001774, 1, 'PW21A-SH100370NV-XL', 0, 0, '2021-04-15 12:50:56.374232', '2021-04-15 12:50:56.374232', NULL),
	(10001775, 1, 'PW21A-SH100370NV-XXL', 0, 0, '2021-04-15 12:50:56.375945', '2021-04-15 12:50:56.375945', NULL),
	(10001776, 1, 'PW21A-SH100371BL-XS', 0, 0, '2021-04-15 12:50:56.377245', '2021-04-15 12:50:56.377245', NULL),
	(10001777, 1, 'PW21A-SH100371BL-S', 0, 0, '2021-04-15 12:50:56.377567', '2021-04-15 12:50:56.377567', NULL),
	(10001778, 1, 'PW21A-SH100371BL-M', 0, 0, '2021-04-15 12:50:56.381693', '2021-04-15 12:50:56.381693', NULL),
	(10001779, 1, 'PW21A-SH100371BL-L', 0, 0, '2021-04-15 12:50:56.389011', '2021-04-15 12:50:56.389011', NULL),
	(10001780, 1, 'PW21A-SH100371BL-XL', 0, 0, '2021-04-15 12:50:56.389872', '2021-04-15 12:50:56.389872', NULL),
	(10001781, 1, 'PW21A-SH100371BL-XXL', 0, 0, '2021-04-15 12:50:56.390358', '2021-04-15 12:50:56.390358', NULL),
	(10001782, 1, 'PW21A-SH100372DK-XS', 0, 0, '2021-04-15 12:50:56.393256', '2021-04-15 12:50:56.393256', NULL),
	(10001783, 1, 'PW21A-SH100372DK-S', 0, 0, '2021-04-15 12:50:56.392812', '2021-04-15 12:50:56.392812', NULL),
	(10001784, 1, 'PW21A-SH100372DK-M', 1, 0, '2021-04-15 12:50:56.401875', '2021-04-15 12:50:56.401875', NULL),
	(10001785, 1, 'PW21A-SH100372DK-L', 0, 0, '2021-04-15 12:50:56.402374', '2021-04-15 12:50:56.402374', NULL),
	(10001786, 1, 'PW21A-SH100372DK-XL', 0, 0, '2021-04-15 12:50:56.404242', '2021-04-15 12:50:56.404242', NULL),
	(10001787, 1, 'PW21A-SH100372DK-XXL', 0, 0, '2021-04-15 12:50:56.404981', '2021-04-15 12:50:56.404981', NULL),
	(10001788, 1, 'PW21A-SH100373GY-XS', 0, 0, '2021-04-15 12:50:56.408772', '2021-04-15 12:50:56.408772', NULL),
	(10001789, 1, 'PW21A-SH100373GY-S', 1, 0, '2021-04-15 12:50:56.416227', '2021-04-15 12:50:56.416227', NULL),
	(10001790, 1, 'PW21A-SH100373GY-M', 0, 0, '2021-04-15 12:50:56.416735', '2021-04-15 12:50:56.416735', NULL),
	(10001791, 1, 'PW21A-SH100373GY-L', 0, 0, '2021-04-15 12:50:56.417221', '2021-04-15 12:50:56.417221', NULL),
	(10001792, 1, 'PW21A-SH100373GY-XL', 0, 0, '2021-04-15 12:50:56.419934', '2021-04-15 12:50:56.419934', NULL),
	(10001793, 1, 'PW21A-SH100373GY-XXL', 0, 0, '2021-04-15 12:50:56.420641', '2021-04-15 12:50:56.420641', NULL),
	(10001794, 1, 'PW21A-SH100374GY-XS', 0, 0, '2021-04-15 12:50:56.429551', '2021-04-15 12:50:56.429551', NULL),
	(10001795, 1, 'PW21A-SH100374GY-S', 11, 0, '2021-04-15 12:50:56.429989', '2021-04-15 12:50:56.429989', NULL),
	(10001796, 1, 'PW21A-SH100374GY-M', 2, 0, '2021-04-15 12:50:56.432020', '2021-04-15 12:50:56.432020', NULL),
	(10001797, 1, 'PW21A-SH100374GY-L', 0, 0, '2021-04-15 12:50:56.433546', '2021-04-15 12:50:56.433546', NULL),
	(10001798, 1, 'PW21A-SH100374GY-XL', 1, 0, '2021-04-15 12:50:56.436255', '2021-04-15 12:50:56.436255', NULL),
	(10001799, 1, 'PW21A-SH100374GY-XXL', 1, 0, '2021-04-15 12:50:56.443454', '2021-04-15 12:50:56.443454', NULL),
	(10001800, 1, 'PW21A-SH100375BL-XS', 0, 0, '2021-04-15 12:50:56.444919', '2021-04-15 12:50:56.444919', NULL),
	(10001801, 1, 'PW21A-SH100375BL-S', 17, 0, '2021-04-15 12:50:56.446517', '2021-04-15 12:50:56.446517', NULL),
	(10001802, 1, 'PW21A-SH100375BL-M', 18, 0, '2021-04-15 12:50:56.448941', '2021-04-15 12:50:56.448941', NULL),
	(10001803, 1, 'PW21A-SH100375BL-L', 5, 0, '2021-04-15 12:50:56.449968', '2021-04-15 12:50:56.449968', NULL),
	(10001804, 1, 'PW21A-SH100375BL-XL', 0, 0, '2021-04-15 12:50:56.457932', '2021-04-15 12:50:56.457932', NULL),
	(10001805, 1, 'PW21A-SH100375BL-XXL', 0, 0, '2021-04-15 12:50:56.458712', '2021-04-15 12:50:56.458712', NULL),
	(10001806, 1, 'PW21A-SH100376CM-XS', 0, 0, '2021-04-15 12:50:56.460413', '2021-04-15 12:50:56.460413', NULL),
	(10001807, 1, 'PW21A-SH100376CM-S', 19, 0, '2021-04-15 12:50:56.461657', '2021-04-15 12:50:56.461657', NULL),
	(10001808, 1, 'PW21A-SH100376CM-M', 19, 0, '2021-04-15 12:50:56.463491', '2021-04-15 12:50:56.463491', NULL),
	(10001809, 1, 'PW21A-SH100376CM-L', 7, 0, '2021-04-15 12:50:56.472017', '2021-04-15 12:50:56.472017', NULL),
	(10001810, 1, 'PW21A-SH100376CM-XL', 1, 0, '2021-04-15 12:50:56.473519', '2021-04-15 12:50:56.473519', NULL),
	(10001811, 1, 'PW21A-SH100376CM-XXL', 0, 0, '2021-04-15 12:50:56.474703', '2021-04-15 12:50:56.474703', NULL),
	(10001812, 1, 'PW21A-SW100377BL-XS', 0, 0, '2021-04-15 12:50:56.476323', '2021-04-15 12:50:56.476323', NULL),
	(10001813, 1, 'PW21A-SW100377BL-S', 0, 0, '2021-04-15 12:50:56.480607', '2021-04-15 12:50:56.480607', NULL),
	(10001814, 1, 'PW21A-SW100377BL-M', 0, 0, '2021-04-15 12:50:56.497197', '2021-04-15 12:50:56.497197', NULL),
	(10001815, 1, 'PW21A-SW100377BL-L', 0, 0, '2021-04-15 12:50:56.498423', '2021-04-15 12:50:56.498423', NULL),
	(10001816, 1, 'PW21A-SW100377BL-XL', 1, 0, '2021-04-15 12:50:56.500403', '2021-04-15 12:50:56.500403', NULL),
	(10001817, 1, 'PW21A-SW100377BL-XXL', 0, 0, '2021-04-15 12:50:56.501603', '2021-04-15 12:50:56.501603', NULL),
	(10001818, 1, 'PW21A-SW100314DK-XS', 0, 0, '2021-04-15 12:50:56.502128', '2021-04-15 12:50:56.502128', NULL),
	(10001819, 1, 'PW21A-SW100314DK-S', 1, 0, '2021-04-15 12:50:56.510469', '2021-04-15 12:50:56.510469', NULL),
	(10001820, 1, 'PW21A-SW100314DK-M', 0, 0, '2021-04-15 12:50:56.512261', '2021-04-15 12:50:56.512261', NULL),
	(10001821, 1, 'PW21A-SW100314DK-L', 0, 0, '2021-04-15 12:50:56.513628', '2021-04-15 12:50:56.513628', NULL),
	(10001822, 1, 'PW21A-SW100314DK-XL', 0, 0, '2021-04-15 12:50:56.514757', '2021-04-15 12:50:56.514757', NULL),
	(10001823, 1, 'PW21A-SW100314DK-XXL', 0, 0, '2021-04-15 12:50:56.515141', '2021-04-15 12:50:56.515141', NULL),
	(10001824, 1, 'PW21A-SW100379GY-XS', 0, 0, '2021-04-15 12:50:56.528182', '2021-04-15 12:50:56.528182', NULL),
	(10001825, 1, 'PW21A-SW100379GY-S', 11, 0, '2021-04-15 12:50:56.528952', '2021-04-15 12:50:56.528952', NULL),
	(10001826, 1, 'PW21A-SW100379GY-M', 8, 0, '2021-04-15 12:50:56.529459', '2021-04-15 12:50:56.529459', NULL),
	(10001827, 1, 'PW21A-SW100379GY-L', 6, 0, '2021-04-15 12:50:56.530727', '2021-04-15 12:50:56.530727', NULL),
	(10001828, 1, 'PW21A-SW100379GY-XL', 9, 0, '2021-04-15 12:50:56.531268', '2021-04-15 12:50:56.531268', NULL),
	(10001829, 1, 'PW21A-SW100379GY-XXL', 0, 0, '2021-04-15 12:50:56.538771', '2021-04-15 12:50:56.538771', NULL),
	(10001830, 1, 'PW21A-SW100380NV-XS', 0, 0, '2021-04-15 12:50:56.541324', '2021-04-15 12:50:56.541324', NULL),
	(10001831, 1, 'PW21A-SW100380NV-S', 16, 0, '2021-04-15 12:50:56.543108', '2021-04-15 12:50:56.543108', NULL),
	(10001832, 1, 'PW21A-SW100380NV-M', 11, 0, '2021-04-15 12:50:56.543575', '2021-04-15 12:50:56.543575', NULL),
	(10001833, 1, 'PW21A-SW100380NV-L', 10, 0, '2021-04-15 12:50:56.544564', '2021-04-15 12:50:56.544564', NULL),
	(10001834, 1, 'PW21A-SW100380NV-XL', 4, 0, '2021-04-15 12:50:56.556226', '2021-04-15 12:50:56.556226', NULL),
	(10001835, 1, 'PW21A-SW100380NV-XXL', 0, 0, '2021-04-15 12:50:56.556745', '2021-04-15 12:50:56.556745', NULL),
	(10001836, 1, 'PW21A-SW100381BL-XS', 0, 0, '2021-04-15 12:50:56.557227', '2021-04-15 12:50:56.557227', NULL),
	(10001837, 1, 'PW21A-SW100381BL-S', 0, 0, '2021-04-15 12:50:56.559805', '2021-04-15 12:50:56.559805', NULL),
	(10001838, 1, 'PW21A-SW100381BL-M', 0, 0, '2021-04-15 12:50:56.560395', '2021-04-15 12:50:56.560395', NULL),
	(10001839, 1, 'PW21A-SW100381BL-L', 0, 0, '2021-04-15 12:50:56.566940', '2021-04-15 12:50:56.566940', NULL),
	(10001840, 1, 'PW21A-SW100381BL-XL', 0, 0, '2021-04-15 12:50:56.569861', '2021-04-15 12:50:56.569861', NULL),
	(10001841, 1, 'PW21A-SW100381BL-XXL', 0, 0, '2021-04-15 12:50:56.570610', '2021-04-15 12:50:56.570610', NULL),
	(10001842, 2, 'PW21A-AC100001BL-All', 3, 0, '2021-04-15 12:57:50.916927', '2021-04-15 12:57:50.916927', NULL),
	(10001843, 2, 'PW21A-AC100002YW -All', 3, 0, '2021-04-15 12:57:50.928544', '2021-04-15 12:57:50.928544', NULL),
	(10001844, 2, 'PW21A-AC100003BL-All', 3, 0, '2021-04-15 12:57:50.945190', '2021-04-15 12:57:50.945190', NULL),
	(10001845, 2, 'PW21A-AC100004BL-All', 0, 0, '2021-04-15 12:57:50.946158', '2021-04-15 12:57:50.946158', NULL),
	(10001846, 2, 'PW21A-AC100005BL-All', 7, 0, '2021-04-15 12:57:50.926026', '2021-04-15 12:57:50.926026', NULL),
	(10001847, 2, 'PW21A-AC100006BL-All', 12, 0, '2021-04-15 12:57:50.927146', '2021-04-15 12:57:50.927146', NULL),
	(10001848, 2, 'PW21A-AC100007BL-All', 7, 0, '2021-04-15 12:57:50.926603', '2021-04-15 12:57:50.926603', NULL),
	(10001849, 2, 'PW21A-AC100008BL-All', 1, 0, '2021-04-15 12:57:50.924818', '2021-04-15 12:57:50.924818', NULL),
	(10001850, 2, 'PW21A-AC100009BW-All', 2, 0, '2021-04-15 12:57:50.918689', '2021-04-15 12:57:50.918689', NULL),
	(10001851, 2, 'PW21A-AC100010MC-All', 4, 0, '2021-04-15 12:57:50.916206', '2021-04-15 12:57:50.916206', NULL),
	(10001852, 2, 'PW21A-AC100011OG-All', 3, 0, '2021-04-15 12:57:50.966005', '2021-04-15 12:57:50.966005', NULL),
	(10001853, 2, 'PW21A-AC100012BL-All', 3, 0, '2021-04-15 12:57:50.964160', '2021-04-15 12:57:50.964160', NULL),
	(10001854, 2, 'PW21A-AC100013OG-All', 3, 0, '2021-04-15 12:57:51.012997', '2021-04-15 12:57:51.012997', NULL),
	(10001855, 2, 'PW21A-AC100014OL-All', 3, 0, '2021-04-15 12:57:50.977034', '2021-04-15 12:57:50.977034', NULL),
	(10001856, 2, 'PW21A-AC100015MR-All', 3, 0, '2021-04-15 12:57:51.143567', '2021-04-15 12:57:51.143567', NULL),
	(10001857, 2, 'PW21A-AC100016BL-All', 2, 0, '2021-04-15 12:57:51.004008', '2021-04-15 12:57:51.004008', NULL),
	(10001858, 2, 'PW21A-AC100017BL-All', 1, 0, '2021-04-15 12:57:50.993485', '2021-04-15 12:57:50.993485', NULL),
	(10001859, 2, 'PW21A-BG100018WT-All', 2, 0, '2021-04-15 12:57:50.972020', '2021-04-15 12:57:50.972020', NULL),
	(10001860, 2, 'PW21A-BG100019BL-All', 3, 0, '2021-04-15 12:57:50.966551', '2021-04-15 12:57:50.966551', NULL),
	(10001861, 2, 'PW21A-BG100020BL-All', 2, 0, '2021-04-15 12:57:50.972885', '2021-04-15 12:57:50.972885', NULL),
	(10001862, 2, 'PW21A-BG100021BL-All', 2, 0, '2021-04-15 12:57:50.975274', '2021-04-15 12:57:50.975274', NULL),
	(10001863, 2, 'PW21A-BG100022BL-All', 2, 0, '2021-04-15 12:57:50.973367', '2021-04-15 12:57:50.973367', NULL),
	(10001864, 2, 'PW21A-BG100023BL-All', 3, 0, '2021-04-15 12:57:50.994005', '2021-04-15 12:57:50.994005', NULL),
	(10001865, 2, 'PW21A-BG100024BL-All', 0, 0, '2021-04-15 12:57:50.968764', '2021-04-15 12:57:50.968764', NULL),
	(10001866, 2, 'PW21A-BG100025BL-All', 0, 0, '2021-04-15 12:57:50.999622', '2021-04-15 12:57:50.999622', NULL),
	(10001867, 2, 'PW21A-BG100026CM-All', 0, 0, '2021-04-15 12:57:51.002311', '2021-04-15 12:57:51.002311', NULL),
	(10001868, 2, 'PW21A-BG100027CM-All', 0, 0, '2021-04-15 12:57:51.030595', '2021-04-15 12:57:51.030595', NULL),
	(10001869, 2, 'PW21A-BG100028CM-All', 0, 0, '2021-04-15 12:57:50.995656', '2021-04-15 12:57:50.995656', NULL),
	(10001870, 2, 'PW21A-BG100029CM-All', 0, 0, '2021-04-15 12:57:50.998323', '2021-04-15 12:57:50.998323', NULL),
	(10001871, 2, 'PW21A-BG100030BL-All', 2, 0, '2021-04-15 12:57:50.980282', '2021-04-15 12:57:50.980282', NULL),
	(10001872, 2, 'PW21A-BG100031BL-All', 2, 0, '2021-04-15 12:57:51.067948', '2021-04-15 12:57:51.067948', NULL),
	(10001873, 2, 'PW21A-BG100032BL-All', 1, 0, '2021-04-15 12:57:51.024889', '2021-04-15 12:57:51.024889', NULL),
	(10001874, 2, 'PW21A-BG100033BL-All', 0, 0, '2021-04-15 12:57:51.025539', '2021-04-15 12:57:51.025539', NULL),
	(10001875, 2, 'PW21A-BG100034BL-All', 0, 0, '2021-04-15 12:57:51.052706', '2021-04-15 12:57:51.052706', NULL),
	(10001876, 2, 'PW21A-BG100035BL-All', 2, 0, '2021-04-15 12:57:51.011783', '2021-04-15 12:57:51.011783', NULL),
	(10001877, 2, 'PW21A-BG100036BL-All', 0, 0, '2021-04-15 12:57:51.008638', '2021-04-15 12:57:51.008638', NULL),
	(10001878, 2, 'PW21A-BG100037OG-All', 1, 0, '2021-04-15 12:57:51.039234', '2021-04-15 12:57:51.039234', NULL),
	(10001879, 2, 'PW21A-BG100038BL-All', 4, 0, '2021-04-15 12:57:51.032723', '2021-04-15 12:57:51.032723', NULL),
	(10001880, 2, 'PW21A-BG100039GN-All', 2, 0, '2021-04-15 12:57:51.028974', '2021-04-15 12:57:51.028974', NULL),
	(10001881, 2, 'PW21A-BG100040WT-All', 2, 0, '2021-04-15 12:57:51.028543', '2021-04-15 12:57:51.028543', NULL),
	(10001882, 2, 'PW21A-BG100041BL-All', 2, 0, '2021-04-15 12:57:51.026181', '2021-04-15 12:57:51.026181', NULL),
	(10001883, 2, 'PW21A-BG100042BL-All', 2, 0, '2021-04-15 12:57:51.062580', '2021-04-15 12:57:51.062580', NULL),
	(10001884, 2, 'PW21A-BG100043BL-All', 3, 0, '2021-04-15 12:57:51.053975', '2021-04-15 12:57:51.053975', NULL),
	(10001885, 2, 'PW21A-BG100044BL-All', 4, 0, '2021-04-15 12:57:51.037085', '2021-04-15 12:57:51.037085', NULL),
	(10001886, 2, 'PW21A-BG100045BL-All', 2, 0, '2021-04-15 12:57:51.053380', '2021-04-15 12:57:51.053380', NULL),
	(10001887, 2, 'PW21A-BG100046BL-All', 2, 0, '2021-04-15 12:57:51.036648', '2021-04-15 12:57:51.036648', NULL),
	(10001888, 2, 'PW21A-BG100047BL-All', 2, 0, '2021-04-15 12:57:51.073747', '2021-04-15 12:57:51.073747', NULL),
	(10001889, 2, 'PW21A-BG100048BL-All', 2, 0, '2021-04-15 12:57:51.071851', '2021-04-15 12:57:51.071851', NULL),
	(10001890, 2, 'PW21A-BG100049BL-All', 2, 0, '2021-04-15 12:57:51.071251', '2021-04-15 12:57:51.071251', NULL),
	(10001891, 2, 'PW21A-BG100050BL-All', 2, 0, '2021-04-15 12:57:51.049927', '2021-04-15 12:57:51.049927', NULL),
	(10001892, 2, 'PW21A-BG100051BL-All', 2, 0, '2021-04-15 12:57:51.063446', '2021-04-15 12:57:51.063446', NULL),
	(10001893, 2, 'PW21A-BG100052BL-All', 2, 0, '2021-04-15 12:57:51.102534', '2021-04-15 12:57:51.102534', NULL),
	(10001894, 2, 'PW21A-BG100053BL-All', 2, 0, '2021-04-15 12:57:51.083256', '2021-04-15 12:57:51.083256', NULL),
	(10001895, 2, 'PW21A-BG100054BL-All', 2, 0, '2021-04-15 12:57:51.088619', '2021-04-15 12:57:51.088619', NULL),
	(10001896, 2, 'PW21A-GL100055YW -S', 1, 0, '2021-04-15 12:57:51.085788', '2021-04-15 12:57:51.085788', NULL),
	(10001897, 2, 'PW21A-GL100055YW -M', 1, 0, '2021-04-15 12:57:51.086189', '2021-04-15 12:57:51.086189', NULL),
	(10001898, 2, 'PW21A-GL100055YW -L', 1, 0, '2021-04-15 12:57:51.105826', '2021-04-15 12:57:51.105826', NULL),
	(10001899, 2, 'PW21A-GL100055YW -XL', 1, 0, '2021-04-15 12:57:51.097329', '2021-04-15 12:57:51.097329', NULL),
	(10001900, 2, 'PW21A-GL100056BW-S', 0, 0, '2021-04-15 12:57:51.089010', '2021-04-15 12:57:51.089010', NULL),
	(10001901, 2, 'PW21A-GL100056BW-M', 1, 0, '2021-04-15 12:57:51.093592', '2021-04-15 12:57:51.093592', NULL),
	(10001902, 2, 'PW21A-GL100056BW-L', 1, 0, '2021-04-15 12:57:51.114271', '2021-04-15 12:57:51.114271', NULL),
	(10001903, 2, 'PW21A-GL100056BW-XL', 0, 0, '2021-04-15 12:57:51.126848', '2021-04-15 12:57:51.126848', NULL),
	(10001904, 2, 'PW21A-GL100057CM-S', 1, 0, '2021-04-15 12:57:51.101948', '2021-04-15 12:57:51.101948', NULL),
	(10001905, 2, 'PW21A-GL100057CM-M', 1, 0, '2021-04-15 12:57:51.129812', '2021-04-15 12:57:51.129812', NULL),
	(10001906, 2, 'PW21A-GL100057CM-L', 1, 0, '2021-04-15 12:57:51.132594', '2021-04-15 12:57:51.132594', NULL),
	(10001907, 2, 'PW21A-GL100057CM-XL', 1, 0, '2021-04-15 12:57:51.124300', '2021-04-15 12:57:51.124300', NULL),
	(10001908, 2, 'PW21A-GL100058BW-S', 1, 0, '2021-04-15 12:57:51.139507', '2021-04-15 12:57:51.139507', NULL),
	(10001909, 2, 'PW21A-GL100058BW-M', 1, 0, '2021-04-15 12:57:51.133115', '2021-04-15 12:57:51.133115', NULL),
	(10001910, 2, 'PW21A-GL100058BW-L', 1, 0, '2021-04-15 12:57:51.243169', '2021-04-15 12:57:51.243169', NULL),
	(10001911, 2, 'PW21A-GL100058BW-XL', 1, 0, '2021-04-15 12:57:51.139936', '2021-04-15 12:57:51.139936', NULL),
	(10001912, 2, 'PW21A-GL100059BL-S', 1, 0, '2021-04-15 12:57:51.145827', '2021-04-15 12:57:51.145827', NULL),
	(10001913, 2, 'PW21A-GL100059BL-M', 1, 0, '2021-04-15 12:57:51.133523', '2021-04-15 12:57:51.133523', NULL),
	(10001914, 2, 'PW21A-GL100059BL-L', 1, 0, '2021-04-15 12:57:51.286535', '2021-04-15 12:57:51.286535', NULL),
	(10001915, 2, 'PW21A-GL100059BL-XL', 1, 0, '2021-04-15 12:57:51.155989', '2021-04-15 12:57:51.155989', NULL),
	(10001916, 2, 'PW21A-GL100060BL-S', 0, 0, '2021-04-15 12:57:51.151963', '2021-04-15 12:57:51.151963', NULL),
	(10001917, 2, 'PW21A-GL100060BL-M', 0, 0, '2021-04-15 12:57:51.153421', '2021-04-15 12:57:51.153421', NULL),
	(10001918, 2, 'PW21A-GL100060BL-L', 1, 0, '2021-04-15 12:57:51.156834', '2021-04-15 12:57:51.156834', NULL),
	(10001919, 2, 'PW21A-GL100060BL-XL', 1, 0, '2021-04-15 12:57:51.162951', '2021-04-15 12:57:51.162951', NULL),
	(10001920, 2, 'PW21A-GL100061RD-S', 1, 0, '2021-04-15 12:57:51.157195', '2021-04-15 12:57:51.157195', NULL),
	(10001921, 2, 'PW21A-GL100061RD-M', 1, 0, '2021-04-15 12:57:51.202486', '2021-04-15 12:57:51.202486', NULL),
	(10001922, 2, 'PW21A-GL100061RD-L', 1, 0, '2021-04-15 12:57:51.158011', '2021-04-15 12:57:51.158011', NULL),
	(10001923, 2, 'PW21A-GL100061RD-XL', 1, 0, '2021-04-15 12:57:51.164111', '2021-04-15 12:57:51.164111', NULL),
	(10001924, 2, 'PW21A-GL100062WT-S', 1, 0, '2021-04-15 12:57:51.168998', '2021-04-15 12:57:51.168998', NULL),
	(10001925, 2, 'PW21A-GL100062WT-M', 1, 0, '2021-04-15 12:57:51.168535', '2021-04-15 12:57:51.168535', NULL),
	(10001926, 2, 'PW21A-GL100062WT-L', 1, 0, '2021-04-15 12:57:51.259785', '2021-04-15 12:57:51.259785', NULL),
	(10001927, 2, 'PW21A-GL100062WT-XL', 1, 0, '2021-04-15 12:57:51.242349', '2021-04-15 12:57:51.242349', NULL),
	(10001928, 2, 'PW21A-GL100063BW-S', 2, 0, '2021-04-15 12:57:51.183044', '2021-04-15 12:57:51.183044', NULL),
	(10001929, 2, 'PW21A-GL100063BW-M', 1, 0, '2021-04-15 12:57:51.180425', '2021-04-15 12:57:51.180425', NULL),
	(10001930, 2, 'PW21A-GL100063BW-L', 1, 0, '2021-04-15 12:57:51.194629', '2021-04-15 12:57:51.194629', NULL),
	(10001931, 2, 'PW21A-GL100063BW-XL', 1, 0, '2021-04-15 12:57:51.184601', '2021-04-15 12:57:51.184601', NULL),
	(10001932, 2, 'PW21A-GL100064WT-S', 1, 0, '2021-04-15 12:57:51.185175', '2021-04-15 12:57:51.185175', NULL),
	(10001933, 2, 'PW21A-GL100064WT-M', 1, 0, '2021-04-15 12:57:51.192053', '2021-04-15 12:57:51.192053', NULL),
	(10001934, 2, 'PW21A-GL100064WT-L', 1, 0, '2021-04-15 12:57:51.224714', '2021-04-15 12:57:51.224714', NULL),
	(10001935, 2, 'PW21A-GL100064WT-XL', 1, 0, '2021-04-15 12:57:51.208304', '2021-04-15 12:57:51.208304', NULL),
	(10001936, 2, 'PW21A-GL100065BL-S', 1, 0, '2021-04-15 12:57:51.224140', '2021-04-15 12:57:51.224140', NULL),
	(10001937, 2, 'PW21A-GL100065BL-M', 0, 0, '2021-04-15 12:57:51.255084', '2021-04-15 12:57:51.255084', NULL),
	(10001938, 2, 'PW21A-GL100065BL-L', 1, 0, '2021-04-15 12:57:51.243988', '2021-04-15 12:57:51.243988', NULL),
	(10001939, 2, 'PW21A-GL100065BL-XL', 1, 0, '2021-04-15 12:57:51.246548', '2021-04-15 12:57:51.246548', NULL),
	(10001940, 2, 'PW21A-GL100066YW -S', 1, 0, '2021-04-15 12:57:51.255921', '2021-04-15 12:57:51.255921', NULL),
	(10001941, 2, 'PW21A-GL100066YW -M', 1, 0, '2021-04-15 12:57:51.270851', '2021-04-15 12:57:51.270851', NULL),
	(10001942, 2, 'PW21A-GL100066YW -L', 1, 0, '2021-04-15 12:57:51.335275', '2021-04-15 12:57:51.335275', NULL),
	(10001943, 2, 'PW21A-GL100066YW -XL', 1, 0, '2021-04-15 12:57:51.282577', '2021-04-15 12:57:51.282577', NULL),
	(10001944, 2, 'PW21A-GL100067BW-S', 1, 0, '2021-04-15 12:57:51.262272', '2021-04-15 12:57:51.262272', NULL),
	(10001945, 2, 'PW21A-GL100067BW-M', 1, 0, '2021-04-15 12:57:51.270268', '2021-04-15 12:57:51.270268', NULL),
	(10001946, 2, 'PW21A-GL100067BW-L', 2, 0, '2021-04-15 12:57:51.275784', '2021-04-15 12:57:51.275784', NULL),
	(10001947, 2, 'PW21A-GL100067BW-XL', 0, 0, '2021-04-15 12:57:51.437973', '2021-04-15 12:57:51.437973', NULL),
	(10001948, 2, 'PW21A-HT100068BL-All', 2, 0, '2021-04-15 12:57:51.293689', '2021-04-15 12:57:51.293689', NULL),
	(10001949, 2, 'PW21A-HT100069BL-All', 0, 0, '2021-04-15 12:57:51.303874', '2021-04-15 12:57:51.303874', NULL),
	(10001950, 2, 'PW21A-HT100070BL-All', 0, 0, '2021-04-15 12:57:51.289211', '2021-04-15 12:57:51.289211', NULL),
	(10001951, 2, 'PW21A-HT100071BL-All', 1, 0, '2021-04-15 12:57:51.291583', '2021-04-15 12:57:51.291583', NULL),
	(10001952, 2, 'PW21A-HT100072BL-All', 0, 0, '2021-04-15 12:57:51.296536', '2021-04-15 12:57:51.296536', NULL),
	(10001953, 2, 'PW21A-HT100073BL-All', 0, 0, '2021-04-15 12:57:51.308063', '2021-04-15 12:57:51.308063', NULL),
	(10001954, 2, 'PW21A-HT100074BL-All', 0, 0, '2021-04-15 12:57:51.311148', '2021-04-15 12:57:51.311148', NULL),
	(10001955, 2, 'PW21A-HT100075BL-All', 0, 0, '2021-04-15 12:57:51.310511', '2021-04-15 12:57:51.310511', NULL),
	(10001956, 2, 'PW21A-HT100076BL-All', 2, 0, '2021-04-15 12:57:51.327554', '2021-04-15 12:57:51.327554', NULL),
	(10001957, 2, 'PW21A-HT100077BL-All', 2, 0, '2021-04-15 12:57:51.314239', '2021-04-15 12:57:51.314239', NULL),
	(10001958, 2, 'PW21A-HT100078BL-All', 2, 0, '2021-04-15 12:57:51.438519', '2021-04-15 12:57:51.438519', NULL),
	(10001959, 2, 'PW21A-HT100079AR-All', 2, 0, '2021-04-15 12:57:51.316532', '2021-04-15 12:57:51.316532', NULL),
	(10001960, 2, 'PW21A-HT100080BL-All', 2, 0, '2021-04-15 12:57:51.321487', '2021-04-15 12:57:51.321487', NULL),
	(10001961, 2, 'PW21A-HT100081CM-All', 2, 0, '2021-04-15 12:57:51.352980', '2021-04-15 12:57:51.352980', NULL),
	(10001962, 2, 'PW21A-HT100082DS-All', 1, 0, '2021-04-15 12:57:51.328672', '2021-04-15 12:57:51.328672', NULL),
	(10001963, 2, 'PW21A-HT100083CM-All', 3, 0, '2021-04-15 12:57:51.334771', '2021-04-15 12:57:51.334771', NULL),
	(10001964, 2, 'PW21A-HT100084DS-All', 3, 0, '2021-04-15 12:57:51.353538', '2021-04-15 12:57:51.353538', NULL),
	(10001965, 2, 'PW21A-HT100085MR-All', 2, 0, '2021-04-15 12:57:51.352290', '2021-04-15 12:57:51.352290', NULL),
	(10001966, 2, 'PW21A-HT100086NV-All', 2, 0, '2021-04-15 12:57:51.369531', '2021-04-15 12:57:51.369531', NULL),
	(10001967, 2, 'PW21A-HT100087BL-All', 4, 0, '2021-04-15 12:57:51.357052', '2021-04-15 12:57:51.357052', NULL),
	(10001968, 2, 'PW21A-HT100088NV-All', 0, 0, '2021-04-15 12:57:51.370873', '2021-04-15 12:57:51.370873', NULL),
	(10001969, 2, 'PW21A-HT100089RD-All', 0, 0, '2021-04-15 12:57:51.367686', '2021-04-15 12:57:51.367686', NULL),
	(10001970, 2, 'PW21A-HT100090BL-All', 0, 0, '2021-04-15 12:57:51.361948', '2021-04-15 12:57:51.361948', NULL),
	(10001971, 2, 'PW21A-HT100091RD-All', 0, 0, '2021-04-15 12:57:51.385897', '2021-04-15 12:57:51.385897', NULL),
	(10001972, 2, 'PW21A-JK100092BL-XS', 0, 0, '2021-04-15 12:57:51.371743', '2021-04-15 12:57:51.371743', NULL),
	(10001973, 2, 'PW21A-JK100092BL-S', 3, 0, '2021-04-15 12:57:51.390003', '2021-04-15 12:57:51.390003', NULL),
	(10001974, 2, 'PW21A-JK100092BL-M', 3, 0, '2021-04-15 12:57:51.383131', '2021-04-15 12:57:51.383131', NULL),
	(10001975, 2, 'PW21A-JK100092BL-L', 4, 0, '2021-04-15 12:57:51.374873', '2021-04-15 12:57:51.374873', NULL),
	(10001976, 2, 'PW21A-JK100092BL-XL', 3, 0, '2021-04-15 12:57:51.409057', '2021-04-15 12:57:51.409057', NULL),
	(10001977, 2, 'PW21A-JK100092BL-XXL', 2, 0, '2021-04-15 12:57:51.379964', '2021-04-15 12:57:51.379964', NULL),
	(10001978, 2, 'PW21A-JK100093BL-XS', 0, 0, '2021-04-15 12:57:51.410222', '2021-04-15 12:57:51.410222', NULL),
	(10001979, 2, 'PW21A-JK100093BL-S', 0, 0, '2021-04-15 12:57:51.417102', '2021-04-15 12:57:51.417102', NULL),
	(10001980, 2, 'PW21A-JK100093BL-M', 0, 0, '2021-04-15 12:57:51.414660', '2021-04-15 12:57:51.414660', NULL),
	(10001981, 2, 'PW21A-JK100093BL-L', 0, 0, '2021-04-15 12:57:51.391643', '2021-04-15 12:57:51.391643', NULL),
	(10001982, 2, 'PW21A-JK100093BL-XL', 0, 0, '2021-04-15 12:57:51.425154', '2021-04-15 12:57:51.425154', NULL),
	(10001983, 2, 'PW21A-JK100093BL-XXL', 0, 0, '2021-04-15 12:57:51.424309', '2021-04-15 12:57:51.424309', NULL),
	(10001984, 2, 'PW21A-JK100094GY-XS', 0, 0, '2021-04-15 12:57:51.412748', '2021-04-15 12:57:51.412748', NULL),
	(10001985, 2, 'PW21A-JK100094GY-S', 0, 0, '2021-04-15 12:57:51.422524', '2021-04-15 12:57:51.422524', NULL),
	(10001986, 2, 'PW21A-JK100094GY-M', 0, 0, '2021-04-15 12:57:51.427712', '2021-04-15 12:57:51.427712', NULL),
	(10001987, 2, 'PW21A-JK100094GY-L', 0, 0, '2021-04-15 12:57:51.427344', '2021-04-15 12:57:51.427344', NULL),
	(10001988, 2, 'PW21A-JK100094GY-XL', 0, 0, '2021-04-15 12:57:51.457163', '2021-04-15 12:57:51.457163', NULL),
	(10001989, 2, 'PW21A-JK100094GY-XXL', 0, 0, '2021-04-15 12:57:51.472263', '2021-04-15 12:57:51.472263', NULL),
	(10001990, 2, 'PW21A-JK100095AR-XS', 0, 0, '2021-04-15 12:57:51.519854', '2021-04-15 12:57:51.519854', NULL),
	(10001991, 2, 'PW21A-JK100095AR-S', 0, 0, '2021-04-15 12:57:51.555602', '2021-04-15 12:57:51.555602', NULL),
	(10001992, 2, 'PW21A-JK100095AR-M', 0, 0, '2021-04-15 12:57:51.452986', '2021-04-15 12:57:51.452986', NULL),
	(10001993, 2, 'PW21A-JK100095AR-L', 0, 0, '2021-04-15 12:57:51.441253', '2021-04-15 12:57:51.441253', NULL),
	(10001994, 2, 'PW21A-JK100095AR-XL', 0, 0, '2021-04-15 12:57:51.440667', '2021-04-15 12:57:51.440667', NULL),
	(10001995, 2, 'PW21A-JK100095AR-XXL', 0, 0, '2021-04-15 12:57:51.456171', '2021-04-15 12:57:51.456171', NULL),
	(10001996, 2, 'PW21A-JK100096BL-XS', 0, 0, '2021-04-15 12:57:51.460541', '2021-04-15 12:57:51.460541', NULL),
	(10001997, 2, 'PW21A-JK100096BL-S', 0, 0, '2021-04-15 12:57:51.449388', '2021-04-15 12:57:51.449388', NULL),
	(10001998, 2, 'PW21A-JK100096BL-M', 0, 0, '2021-04-15 12:57:51.471243', '2021-04-15 12:57:51.471243', NULL),
	(10001999, 2, 'PW21A-JK100096BL-L', 0, 0, '2021-04-15 12:57:51.470830', '2021-04-15 12:57:51.470830', NULL),
	(10002000, 2, 'PW21A-JK100096BL-XL', 0, 0, '2021-04-15 12:57:51.456690', '2021-04-15 12:57:51.456690', NULL),
	(10002001, 2, 'PW21A-JK100096BL-XXL', 0, 0, '2021-04-15 12:57:51.502061', '2021-04-15 12:57:51.502061', NULL),
	(10002002, 2, 'PW21A-JK100097WT-XS', 2, 0, '2021-04-15 12:57:51.483826', '2021-04-15 12:57:51.483826', NULL),
	(10002003, 2, 'PW21A-JK100097WT-S', 3, 0, '2021-04-15 12:57:51.483392', '2021-04-15 12:57:51.483392', NULL),
	(10002004, 2, 'PW21A-JK100097WT-M', 4, 0, '2021-04-15 12:57:51.481228', '2021-04-15 12:57:51.481228', NULL),
	(10002005, 2, 'PW21A-JK100097WT-L', 5, 0, '2021-04-15 12:57:51.476961', '2021-04-15 12:57:51.476961', NULL),
	(10002006, 2, 'PW21A-JK100097WT-XL', 5, 0, '2021-04-15 12:57:51.473648', '2021-04-15 12:57:51.473648', NULL),
	(10002007, 2, 'PW21A-JK100097WT-XXL', 4, 0, '2021-04-15 12:57:51.498121', '2021-04-15 12:57:51.498121', NULL),
	(10002008, 2, 'PW21A-JK100098BL-XS', 0, 0, '2021-04-15 12:57:51.494694', '2021-04-15 12:57:51.494694', NULL),
	(10002009, 2, 'PW21A-JK100098BL-S', 3, 0, '2021-04-15 12:57:51.495394', '2021-04-15 12:57:51.495394', NULL),
	(10002010, 2, 'PW21A-JK100098BL-M', 4, 0, '2021-04-15 12:57:51.486971', '2021-04-15 12:57:51.486971', NULL),
	(10002011, 2, 'PW21A-JK100098BL-L', 4, 0, '2021-04-15 12:57:51.486504', '2021-04-15 12:57:51.486504', NULL),
	(10002012, 2, 'PW21A-JK100098BL-XL', 3, 0, '2021-04-15 12:57:51.509046', '2021-04-15 12:57:51.509046', NULL),
	(10002013, 2, 'PW21A-JK100098BL-XXL', 1, 0, '2021-04-15 12:57:51.509971', '2021-04-15 12:57:51.509971', NULL),
	(10002014, 2, 'PW21A-JK100099BL-XS', 0, 0, '2021-04-15 12:57:51.505483', '2021-04-15 12:57:51.505483', NULL),
	(10002015, 2, 'PW21A-JK100099BL-S', 0, 0, '2021-04-15 12:57:51.499742', '2021-04-15 12:57:51.499742', NULL),
	(10002016, 2, 'PW21A-JK100099BL-M', 0, 0, '2021-04-15 12:57:51.517926', '2021-04-15 12:57:51.517926', NULL),
	(10002017, 2, 'PW21A-JK100099BL-L', 0, 0, '2021-04-15 12:57:51.523137', '2021-04-15 12:57:51.523137', NULL),
	(10002018, 2, 'PW21A-JK100099BL-XL', 0, 0, '2021-04-15 12:57:51.570069', '2021-04-15 12:57:51.570069', NULL),
	(10002019, 2, 'PW21A-JK100099BL-XXL', 0, 0, '2021-04-15 12:57:51.512714', '2021-04-15 12:57:51.512714', NULL),
	(10002020, 2, 'PW21A-JK100100DM-XS', 0, 0, '2021-04-15 12:57:51.507153', '2021-04-15 12:57:51.507153', NULL),
	(10002021, 2, 'PW21A-JK100100DM-S', 3, 0, '2021-04-15 12:57:51.543544', '2021-04-15 12:57:51.543544', NULL),
	(10002022, 2, 'PW21A-JK100100DM-M', 1, 0, '2021-04-15 12:57:51.529306', '2021-04-15 12:57:51.529306', NULL),
	(10002023, 2, 'PW21A-JK100100DM-L', 3, 0, '2021-04-15 12:57:51.577309', '2021-04-15 12:57:51.577309', NULL),
	(10002024, 2, 'PW21A-JK100100DM-XL', 3, 0, '2021-04-15 12:57:51.523510', '2021-04-15 12:57:51.523510', NULL),
	(10002025, 2, 'PW21A-JK100100DM-XXL', 1, 0, '2021-04-15 12:57:51.520953', '2021-04-15 12:57:51.520953', NULL),
	(10002026, 2, 'PW21A-JK100101NV-XS', 0, 0, '2021-04-15 12:57:51.551212', '2021-04-15 12:57:51.551212', NULL),
	(10002027, 2, 'PW21A-JK100101NV-S', 0, 0, '2021-04-15 12:57:51.537140', '2021-04-15 12:57:51.537140', NULL),
	(10002028, 2, 'PW21A-JK100101NV-M', 0, 0, '2021-04-15 12:57:51.534825', '2021-04-15 12:57:51.534825', NULL),
	(10002029, 2, 'PW21A-JK100101NV-L', 0, 0, '2021-04-15 12:57:51.548905', '2021-04-15 12:57:51.548905', NULL),
	(10002030, 2, 'PW21A-JK100101NV-XL', 0, 0, '2021-04-15 12:57:51.541085', '2021-04-15 12:57:51.541085', NULL),
	(10002031, 2, 'PW21A-JK100101NV-XXL', 0, 0, '2021-04-15 12:57:51.565879', '2021-04-15 12:57:51.565879', NULL),
	(10002032, 2, 'PW21A-JK100102BW-XS', 0, 0, '2021-04-15 12:57:51.553076', '2021-04-15 12:57:51.553076', NULL),
	(10002033, 2, 'PW21A-JK100102BW-S', 0, 0, '2021-04-15 12:57:51.556102', '2021-04-15 12:57:51.556102', NULL),
	(10002034, 2, 'PW21A-JK100102BW-M', 0, 0, '2021-04-15 12:57:51.563662', '2021-04-15 12:57:51.563662', NULL),
	(10002035, 2, 'PW21A-JK100102BW-L', 3, 0, '2021-04-15 12:57:51.571486', '2021-04-15 12:57:51.571486', NULL),
	(10002036, 2, 'PW21A-JK100102BW-XL', 0, 0, '2021-04-15 12:57:51.590832', '2021-04-15 12:57:51.590832', NULL),
	(10002037, 2, 'PW21A-JK100102BW-XXL', 2, 0, '2021-04-15 12:57:51.567733', '2021-04-15 12:57:51.567733', NULL),
	(10002038, 2, 'PW21A-JK100103BL-XS', 0, 0, '2021-04-15 12:57:51.604570', '2021-04-15 12:57:51.604570', NULL),
	(10002039, 2, 'PW21A-JK100103BL-S', 0, 0, '2021-04-15 12:57:51.742972', '2021-04-15 12:57:51.742972', NULL),
	(10002040, 2, 'PW21A-JK100103BL-M', 0, 0, '2021-04-15 12:57:51.582147', '2021-04-15 12:57:51.582147', NULL),
	(10002041, 2, 'PW21A-JK100103BL-L', 0, 0, '2021-04-15 12:57:51.574325', '2021-04-15 12:57:51.574325', NULL),
	(10002042, 2, 'PW21A-JK100103BL-XL', 0, 0, '2021-04-15 12:57:51.579394', '2021-04-15 12:57:51.579394', NULL),
	(10002043, 2, 'PW21A-JK100103BL-XXL', 0, 0, '2021-04-15 12:57:51.580235', '2021-04-15 12:57:51.580235', NULL),
	(10002044, 2, 'PW21A-JK100104BL-XS', 0, 0, '2021-04-15 12:57:51.594761', '2021-04-15 12:57:51.594761', NULL),
	(10002045, 2, 'PW21A-JK100104BL-S', 3, 0, '2021-04-15 12:57:51.595295', '2021-04-15 12:57:51.595295', NULL),
	(10002046, 2, 'PW21A-JK100104BL-M', 4, 0, '2021-04-15 12:57:51.601581', '2021-04-15 12:57:51.601581', NULL),
	(10002047, 2, 'PW21A-JK100104BL-L', 4, 0, '2021-04-15 12:57:51.597998', '2021-04-15 12:57:51.597998', NULL),
	(10002048, 2, 'PW21A-JK100104BL-XL', 3, 0, '2021-04-15 12:57:51.598364', '2021-04-15 12:57:51.598364', NULL),
	(10002049, 2, 'PW21A-JK100104BL-XXL', 2, 0, '2021-04-15 12:57:51.609608', '2021-04-15 12:57:51.609608', NULL),
	(10002050, 2, 'PW21A-JK100105TC-XS', 0, 0, '2021-04-15 12:57:51.608692', '2021-04-15 12:57:51.608692', NULL),
	(10002051, 2, 'PW21A-JK100105TC-S', 0, 0, '2021-04-15 12:57:51.606200', '2021-04-15 12:57:51.606200', NULL),
	(10002052, 2, 'PW21A-JK100105TC-M', 0, 0, '2021-04-15 12:57:51.626198', '2021-04-15 12:57:51.626198', NULL),
	(10002053, 2, 'PW21A-JK100105TC-L', 0, 0, '2021-04-15 12:57:51.638281', '2021-04-15 12:57:51.638281', NULL),
	(10002054, 2, 'PW21A-JK100105TC-XL', 0, 0, '2021-04-15 12:57:51.629157', '2021-04-15 12:57:51.629157', NULL),
	(10002055, 2, 'PW21A-JK100105TC-XXL', 0, 0, '2021-04-15 12:57:51.630630', '2021-04-15 12:57:51.630630', NULL),
	(10002056, 2, 'PW21A-JK100106BL-XS', 0, 0, '2021-04-15 12:57:51.627315', '2021-04-15 12:57:51.627315', NULL),
	(10002057, 2, 'PW21A-JK100106BL-S', 2, 0, '2021-04-15 12:57:51.627856', '2021-04-15 12:57:51.627856', NULL),
	(10002058, 2, 'PW21A-JK100106BL-M', 4, 0, '2021-04-15 12:57:51.632276', '2021-04-15 12:57:51.632276', NULL),
	(10002059, 2, 'PW21A-JK100106BL-L', 4, 0, '2021-04-15 12:57:51.640611', '2021-04-15 12:57:51.640611', NULL),
	(10002060, 2, 'PW21A-JK100106BL-XL', 3, 0, '2021-04-15 12:57:51.642143', '2021-04-15 12:57:51.642143', NULL),
	(10002061, 2, 'PW21A-JK100106BL-XXL', 2, 0, '2021-04-15 12:57:51.639870', '2021-04-15 12:57:51.639870', NULL),
	(10002062, 2, 'PW21A-JK100107BL-XS', 0, 0, '2021-04-15 12:57:51.667801', '2021-04-15 12:57:51.667801', NULL),
	(10002063, 2, 'PW21A-JK100107BL-S', 0, 0, '2021-04-15 12:57:51.653039', '2021-04-15 12:57:51.653039', NULL),
	(10002064, 2, 'PW21A-JK100107BL-M', 0, 0, '2021-04-15 12:57:51.640946', '2021-04-15 12:57:51.640946', NULL),
	(10002065, 2, 'PW21A-JK100107BL-L', 0, 0, '2021-04-15 12:57:51.662535', '2021-04-15 12:57:51.662535', NULL),
	(10002066, 2, 'PW21A-JK100107BL-XL', 0, 0, '2021-04-15 12:57:51.658646', '2021-04-15 12:57:51.658646', NULL),
	(10002067, 2, 'PW21A-JK100107BL-XXL', 0, 0, '2021-04-15 12:57:51.654572', '2021-04-15 12:57:51.654572', NULL),
	(10002068, 2, 'PW21A-JK100108BL-XS', 0, 0, '2021-04-15 12:57:51.669210', '2021-04-15 12:57:51.669210', NULL),
	(10002069, 2, 'PW21A-JK100108BL-S', 4, 0, '2021-04-15 12:57:51.668805', '2021-04-15 12:57:51.668805', NULL),
	(10002070, 2, 'PW21A-JK100108BL-M', 4, 0, '2021-04-15 12:57:51.683469', '2021-04-15 12:57:51.683469', NULL),
	(10002071, 2, 'PW21A-JK100108BL-L', 4, 0, '2021-04-15 12:57:51.670433', '2021-04-15 12:57:51.670433', NULL),
	(10002072, 2, 'PW21A-JK100108BL-XL', 3, 0, '2021-04-15 12:57:51.694455', '2021-04-15 12:57:51.694455', NULL),
	(10002073, 2, 'PW21A-JK100108BL-XXL', 2, 0, '2021-04-15 12:57:51.669620', '2021-04-15 12:57:51.669620', NULL),
	(10002074, 2, 'PW21A-JK100109BL-XS', 0, 0, '2021-04-15 12:57:51.670072', '2021-04-15 12:57:51.670072', NULL),
	(10002075, 2, 'PW21A-JK100109BL-S', 0, 0, '2021-04-15 12:57:51.687985', '2021-04-15 12:57:51.687985', NULL),
	(10002076, 2, 'PW21A-JK100109BL-M', 0, 0, '2021-04-15 12:57:51.685271', '2021-04-15 12:57:51.685271', NULL),
	(10002077, 2, 'PW21A-JK100109BL-L', 1, 0, '2021-04-15 12:57:51.693444', '2021-04-15 12:57:51.693444', NULL),
	(10002078, 2, 'PW21A-JK100109BL-XL', 1, 0, '2021-04-15 12:57:51.696334', '2021-04-15 12:57:51.696334', NULL),
	(10002079, 2, 'PW21A-JK100109BL-XXL', 0, 0, '2021-04-15 12:57:51.694923', '2021-04-15 12:57:51.694923', NULL),
	(10002080, 2, 'PW21A-JK100110BL-XS', 2, 0, '2021-04-15 12:57:51.695897', '2021-04-15 12:57:51.695897', NULL),
	(10002081, 2, 'PW21A-JK100110BL-S', 3, 0, '2021-04-15 12:57:51.707793', '2021-04-15 12:57:51.707793', NULL),
	(10002082, 2, 'PW21A-JK100110BL-M', 4, 0, '2021-04-15 12:57:51.699642', '2021-04-15 12:57:51.699642', NULL),
	(10002083, 2, 'PW21A-JK100110BL-L', 4, 0, '2021-04-15 12:57:51.700111', '2021-04-15 12:57:51.700111', NULL),
	(10002084, 2, 'PW21A-JK100110BL-XL', 5, 0, '2021-04-15 12:57:51.713741', '2021-04-15 12:57:51.713741', NULL),
	(10002085, 2, 'PW21A-JK100110BL-XXL', 2, 0, '2021-04-15 12:57:51.726657', '2021-04-15 12:57:51.726657', NULL),
	(10002086, 2, 'PW21A-JK100111BL-XS', 0, 0, '2021-04-15 12:57:51.722054', '2021-04-15 12:57:51.722054', NULL),
	(10002087, 2, 'PW21A-JK100111BL-S', 0, 0, '2021-04-15 12:57:51.710490', '2021-04-15 12:57:51.710490', NULL),
	(10002088, 2, 'PW21A-JK100111BL-M', 1, 0, '2021-04-15 12:57:51.725411', '2021-04-15 12:57:51.725411', NULL),
	(10002089, 2, 'PW21A-JK100111BL-L', 0, 0, '2021-04-15 12:57:51.796213', '2021-04-15 12:57:51.796213', NULL),
	(10002090, 2, 'PW21A-JK100111BL-XL', 1, 0, '2021-04-15 12:57:51.724775', '2021-04-15 12:57:51.724775', NULL),
	(10002091, 2, 'PW21A-JK100111BL-XXL', 1, 0, '2021-04-15 12:57:51.723623', '2021-04-15 12:57:51.723623', NULL),
	(10002092, 2, 'PW21A-JK100112CM-XS', 0, 0, '2021-04-15 12:57:51.724212', '2021-04-15 12:57:51.724212', NULL),
	(10002093, 2, 'PW21A-JK100112CM-S', 0, 0, '2021-04-15 12:57:51.728215', '2021-04-15 12:57:51.728215', NULL),
	(10002094, 2, 'PW21A-JK100112CM-M', 0, 0, '2021-04-15 12:57:51.741818', '2021-04-15 12:57:51.741818', NULL),
	(10002095, 2, 'PW21A-JK100112CM-L', 0, 0, '2021-04-15 12:57:51.746599', '2021-04-15 12:57:51.746599', NULL),
	(10002096, 2, 'PW21A-JK100112CM-XL', 0, 0, '2021-04-15 12:57:51.756476', '2021-04-15 12:57:51.756476', NULL),
	(10002097, 2, 'PW21A-JK100112CM-XXL', 0, 0, '2021-04-15 12:57:51.758372', '2021-04-15 12:57:51.758372', NULL),
	(10002098, 2, 'PW21A-JK100113CM-XS', 0, 0, '2021-04-15 12:57:51.755937', '2021-04-15 12:57:51.755937', NULL),
	(10002099, 2, 'PW21A-JK100113CM-S', 0, 0, '2021-04-15 12:57:51.759344', '2021-04-15 12:57:51.759344', NULL),
	(10002100, 2, 'PW21A-JK100113CM-M', 0, 0, '2021-04-15 12:57:51.757060', '2021-04-15 12:57:51.757060', NULL),
	(10002101, 2, 'PW21A-JK100113CM-L', 0, 0, '2021-04-15 12:57:51.797820', '2021-04-15 12:57:51.797820', NULL),
	(10002102, 2, 'PW21A-JK100113CM-XL', 0, 0, '2021-04-15 12:57:51.759981', '2021-04-15 12:57:51.759981', NULL),
	(10002103, 2, 'PW21A-JK100113CM-XXL', 0, 0, '2021-04-15 12:57:51.761675', '2021-04-15 12:57:51.761675', NULL),
	(10002104, 2, 'PW21A-JK100114CM-XS', 0, 0, '2021-04-15 12:57:51.780138', '2021-04-15 12:57:51.780138', NULL),
	(10002105, 2, 'PW21A-JK100114CM-S', 0, 0, '2021-04-15 12:57:51.777717', '2021-04-15 12:57:51.777717', NULL),
	(10002106, 2, 'PW21A-JK100114CM-M', 0, 0, '2021-04-15 12:57:51.793397', '2021-04-15 12:57:51.793397', NULL),
	(10002107, 2, 'PW21A-JK100114CM-L', 0, 0, '2021-04-15 12:57:51.776015', '2021-04-15 12:57:51.776015', NULL),
	(10002108, 2, 'PW21A-JK100114CM-XL', 0, 0, '2021-04-15 12:57:51.905411', '2021-04-15 12:57:51.905411', NULL),
	(10002109, 2, 'PW21A-JK100114CM-XXL', 0, 0, '2021-04-15 12:57:51.798598', '2021-04-15 12:57:51.798598', NULL),
	(10002110, 2, 'PW21A-JK100115DM-XS', 0, 0, '2021-04-15 12:57:51.796812', '2021-04-15 12:57:51.796812', NULL),
	(10002111, 2, 'PW21A-JK100115DM-S', 2, 0, '2021-04-15 12:57:51.799267', '2021-04-15 12:57:51.799267', NULL),
	(10002112, 2, 'PW21A-JK100115DM-M', 4, 0, '2021-04-15 12:57:51.815702', '2021-04-15 12:57:51.815702', NULL),
	(10002113, 2, 'PW21A-JK100115DM-L', 2, 0, '2021-04-15 12:57:51.801815', '2021-04-15 12:57:51.801815', NULL),
	(10002114, 2, 'PW21A-JK100115DM-XL', 0, 0, '2021-04-15 12:57:51.821646', '2021-04-15 12:57:51.821646', NULL),
	(10002115, 2, 'PW21A-JK100115DM-XXL', 0, 0, '2021-04-15 12:57:51.843245', '2021-04-15 12:57:51.843245', NULL),
	(10002116, 2, 'PW21A-JK100116RD-XS', 0, 0, '2021-04-15 12:57:51.823157', '2021-04-15 12:57:51.823157', NULL),
	(10002117, 2, 'PW21A-JK100116RD-S', 0, 0, '2021-04-15 12:57:51.835894', '2021-04-15 12:57:51.835894', NULL),
	(10002118, 2, 'PW21A-JK100116RD-M', 0, 0, '2021-04-15 12:57:51.833847', '2021-04-15 12:57:51.833847', NULL),
	(10002119, 2, 'PW21A-JK100116RD-L', 0, 0, '2021-04-15 12:57:51.840329', '2021-04-15 12:57:51.840329', NULL),
	(10002120, 2, 'PW21A-JK100116RD-XL', 0, 0, '2021-04-15 12:57:51.836522', '2021-04-15 12:57:51.836522', NULL),
	(10002121, 2, 'PW21A-JK100116RD-XXL', 0, 0, '2021-04-15 12:57:51.835392', '2021-04-15 12:57:51.835392', NULL),
	(10002122, 2, 'PW21A-JK100117BL-XS', 0, 0, '2021-04-15 12:57:51.864281', '2021-04-15 12:57:51.864281', NULL),
	(10002123, 2, 'PW21A-JK100117BL-S', 0, 0, '2021-04-15 12:57:51.841073', '2021-04-15 12:57:51.841073', NULL),
	(10002124, 2, 'PW21A-JK100117BL-M', 0, 0, '2021-04-15 12:57:51.862816', '2021-04-15 12:57:51.862816', NULL),
	(10002125, 2, 'PW21A-JK100117BL-L', 0, 0, '2021-04-15 12:57:51.902457', '2021-04-15 12:57:51.902457', NULL),
	(10002126, 2, 'PW21A-JK100117BL-XL', 0, 0, '2021-04-15 12:57:51.906769', '2021-04-15 12:57:51.906769', NULL),
	(10002127, 2, 'PW21A-JK100117BL-XXL', 0, 0, '2021-04-15 12:57:51.866695', '2021-04-15 12:57:51.866695', NULL),
	(10002128, 2, 'PW21A-JK100118AR-XS', 0, 0, '2021-04-15 12:57:51.900293', '2021-04-15 12:57:51.900293', NULL),
	(10002129, 2, 'PW21A-JK100118AR-S', 3, 0, '2021-04-15 12:57:51.903876', '2021-04-15 12:57:51.903876', NULL),
	(10002130, 2, 'PW21A-JK100118AR-M', 4, 0, '2021-04-15 12:57:51.906171', '2021-04-15 12:57:51.906171', NULL),
	(10002131, 2, 'PW21A-JK100118AR-L', 4, 0, '2021-04-15 12:57:51.903211', '2021-04-15 12:57:51.903211', NULL),
	(10002132, 2, 'PW21A-JK100118AR-XL', 3, 0, '2021-04-15 12:57:52.127121', '2021-04-15 12:57:52.127121', NULL),
	(10002133, 2, 'PW21A-JK100118AR-XXL', 2, 0, '2021-04-15 12:57:52.002922', '2021-04-15 12:57:52.002922', NULL),
	(10002134, 2, 'PW21A-JK100119BL-XS', 0, 0, '2021-04-15 12:57:51.927214', '2021-04-15 12:57:51.927214', NULL),
	(10002135, 2, 'PW21A-JK100119BL-S', 3, 0, '2021-04-15 12:57:51.956483', '2021-04-15 12:57:51.956483', NULL),
	(10002136, 2, 'PW21A-JK100119BL-M', 4, 0, '2021-04-15 12:57:51.927935', '2021-04-15 12:57:51.927935', NULL),
	(10002137, 2, 'PW21A-JK100119BL-L', 4, 0, '2021-04-15 12:57:51.929578', '2021-04-15 12:57:51.929578', NULL),
	(10002138, 2, 'PW21A-JK100119BL-XL', 3, 0, '2021-04-15 12:57:51.955212', '2021-04-15 12:57:51.955212', NULL),
	(10002139, 2, 'PW21A-JK100119BL-XXL', 2, 0, '2021-04-15 12:57:51.957098', '2021-04-15 12:57:51.957098', NULL),
	(10002140, 2, 'PW21A-JK100120BL-XS', 2, 0, '2021-04-15 12:57:51.952986', '2021-04-15 12:57:51.952986', NULL),
	(10002141, 2, 'PW21A-JK100120BL-S', 5, 0, '2021-04-15 12:57:51.953484', '2021-04-15 12:57:51.953484', NULL),
	(10002142, 2, 'PW21A-JK100120BL-M', 6, 0, '2021-04-15 12:57:51.983133', '2021-04-15 12:57:51.983133', NULL),
	(10002143, 2, 'PW21A-JK100120BL-L', 8, 0, '2021-04-15 12:57:51.958013', '2021-04-15 12:57:51.958013', NULL),
	(10002144, 2, 'PW21A-JK100120BL-XL', 5, 0, '2021-04-15 12:57:51.957575', '2021-04-15 12:57:51.957575', NULL),
	(10002145, 2, 'PW21A-JK100120BL-XXL', 4, 0, '2021-04-15 12:57:51.984011', '2021-04-15 12:57:51.984011', NULL),
	(10002146, 2, 'PW21A-JK100121MR-XS', 0, 0, '2021-04-15 12:57:51.987703', '2021-04-15 12:57:51.987703', NULL),
	(10002147, 2, 'PW21A-JK100121MR-S', 3, 0, '2021-04-15 12:57:51.997437', '2021-04-15 12:57:51.997437', NULL),
	(10002148, 2, 'PW21A-JK100121MR-M', 4, 0, '2021-04-15 12:57:52.183507', '2021-04-15 12:57:52.183507', NULL),
	(10002149, 2, 'PW21A-JK100121MR-L', 4, 0, '2021-04-15 12:57:52.004678', '2021-04-15 12:57:52.004678', NULL),
	(10002150, 2, 'PW21A-JK100121MR-XL', 3, 0, '2021-04-15 12:57:52.002378', '2021-04-15 12:57:52.002378', NULL),
	(10002151, 2, 'PW21A-JK100121MR-XXL', 2, 0, '2021-04-15 12:57:51.994584', '2021-04-15 12:57:51.994584', NULL),
	(10002152, 2, 'PW21A-JK100122RD-XS', 0, 0, '2021-04-15 12:57:52.006507', '2021-04-15 12:57:52.006507', NULL),
	(10002153, 2, 'PW21A-JK100122RD-S', 0, 0, '2021-04-15 12:57:52.005223', '2021-04-15 12:57:52.005223', NULL),
	(10002154, 2, 'PW21A-JK100122RD-M', 0, 0, '2021-04-15 12:57:52.014710', '2021-04-15 12:57:52.014710', NULL),
	(10002155, 2, 'PW21A-JK100122RD-L', 0, 0, '2021-04-15 12:57:52.022573', '2021-04-15 12:57:52.022573', NULL),
	(10002156, 2, 'PW21A-JK100122RD-XL', 0, 0, '2021-04-15 12:57:52.024846', '2021-04-15 12:57:52.024846', NULL),
	(10002157, 2, 'PW21A-JK100122RD-XXL', 0, 0, '2021-04-15 12:57:52.040680', '2021-04-15 12:57:52.040680', NULL),
	(10002158, 2, 'PW21A-JK100123BL-XS', 0, 0, '2021-04-15 12:57:52.053207', '2021-04-15 12:57:52.053207', NULL),
	(10002159, 2, 'PW21A-JK100123BL-S', 0, 0, '2021-04-15 12:57:52.035434', '2021-04-15 12:57:52.035434', NULL),
	(10002160, 2, 'PW21A-JK100123BL-M', 0, 0, '2021-04-15 12:57:52.033793', '2021-04-15 12:57:52.033793', NULL),
	(10002161, 2, 'PW21A-JK100123BL-L', 0, 0, '2021-04-15 12:57:52.053840', '2021-04-15 12:57:52.053840', NULL),
	(10002162, 2, 'PW21A-JK100123BL-XL', 0, 0, '2021-04-15 12:57:52.054418', '2021-04-15 12:57:52.054418', NULL),
	(10002163, 2, 'PW21A-JK100123BL-XXL', 0, 0, '2021-04-15 12:57:52.055745', '2021-04-15 12:57:52.055745', NULL),
	(10002164, 2, 'PW21A-JK100124BL-XS', 0, 0, '2021-04-15 12:57:52.071248', '2021-04-15 12:57:52.071248', NULL),
	(10002165, 2, 'PW21A-JK100124BL-S', 0, 0, '2021-04-15 12:57:52.075076', '2021-04-15 12:57:52.075076', NULL),
	(10002166, 2, 'PW21A-JK100124BL-M', 0, 0, '2021-04-15 12:57:52.074377', '2021-04-15 12:57:52.074377', NULL),
	(10002167, 2, 'PW21A-JK100124BL-L', 0, 0, '2021-04-15 12:57:52.078148', '2021-04-15 12:57:52.078148', NULL),
	(10002168, 2, 'PW21A-JK100124BL-XL', 0, 0, '2021-04-15 12:57:52.078791', '2021-04-15 12:57:52.078791', NULL),
	(10002169, 2, 'PW21A-JK100124BL-XXL', 0, 0, '2021-04-15 12:57:52.107527', '2021-04-15 12:57:52.107527', NULL),
	(10002170, 2, 'PW21A-JK100125AR-XS', 0, 0, '2021-04-15 12:57:52.110275', '2021-04-15 12:57:52.110275', NULL),
	(10002171, 2, 'PW21A-JK100125AR-S', 0, 0, '2021-04-15 12:57:52.100015', '2021-04-15 12:57:52.100015', NULL),
	(10002172, 2, 'PW21A-JK100125AR-M', 0, 0, '2021-04-15 12:57:52.098447', '2021-04-15 12:57:52.098447', NULL),
	(10002173, 2, 'PW21A-JK100125AR-L', 0, 0, '2021-04-15 12:57:52.124379', '2021-04-15 12:57:52.124379', NULL),
	(10002174, 2, 'PW21A-JK100125AR-XL', 0, 0, '2021-04-15 12:57:52.242098', '2021-04-15 12:57:52.242098', NULL),
	(10002175, 2, 'PW21A-JK100125AR-XXL', 0, 0, '2021-04-15 12:57:52.163943', '2021-04-15 12:57:52.163943', NULL),
	(10002176, 2, 'PW21A-JK100126BL-XS', 0, 0, '2021-04-15 12:57:52.112364', '2021-04-15 12:57:52.112364', NULL),
	(10002177, 2, 'PW21A-JK100126BL-S', 1, 0, '2021-04-15 12:57:52.128498', '2021-04-15 12:57:52.128498', NULL),
	(10002178, 2, 'PW21A-JK100126BL-M', 3, 0, '2021-04-15 12:57:52.140621', '2021-04-15 12:57:52.140621', NULL),
	(10002179, 2, 'PW21A-JK100126BL-L', 2, 0, '2021-04-15 12:57:52.153269', '2021-04-15 12:57:52.153269', NULL),
	(10002180, 2, 'PW21A-JK100126BL-XL', 2, 0, '2021-04-15 12:57:52.151903', '2021-04-15 12:57:52.151903', NULL),
	(10002181, 2, 'PW21A-JK100126BL-XXL', 1, 0, '2021-04-15 12:57:52.141421', '2021-04-15 12:57:52.141421', NULL),
	(10002182, 2, 'PW21A-JK100127BL-XS', 0, 0, '2021-04-15 12:57:52.152578', '2021-04-15 12:57:52.152578', NULL),
	(10002183, 2, 'PW21A-JK100127BL-S', 2, 0, '2021-04-15 12:57:52.158418', '2021-04-15 12:57:52.158418', NULL),
	(10002184, 2, 'PW21A-JK100127BL-M', 1, 0, '2021-04-15 12:57:52.157558', '2021-04-15 12:57:52.157558', NULL),
	(10002185, 2, 'PW21A-JK100127BL-L', 2, 0, '2021-04-15 12:57:52.166906', '2021-04-15 12:57:52.166906', NULL),
	(10002186, 2, 'PW21A-JK100127BL-XL', 1, 0, '2021-04-15 12:57:52.169110', '2021-04-15 12:57:52.169110', NULL),
	(10002187, 2, 'PW21A-JK100127BL-XXL', 1, 0, '2021-04-15 12:57:52.167592', '2021-04-15 12:57:52.167592', NULL),
	(10002188, 2, 'PW21A-JK100128BL-XS', 0, 0, '2021-04-15 12:57:52.185141', '2021-04-15 12:57:52.185141', NULL),
	(10002189, 2, 'PW21A-JK100128BL-S', 2, 0, '2021-04-15 12:57:52.175777', '2021-04-15 12:57:52.175777', NULL),
	(10002190, 2, 'PW21A-JK100128BL-M', 2, 0, '2021-04-15 12:57:52.187116', '2021-04-15 12:57:52.187116', NULL),
	(10002191, 2, 'PW21A-JK100128BL-L', 2, 0, '2021-04-15 12:57:52.184763', '2021-04-15 12:57:52.184763', NULL),
	(10002192, 2, 'PW21A-JK100128BL-XL', 2, 0, '2021-04-15 12:57:52.253731', '2021-04-15 12:57:52.253731', NULL),
	(10002193, 2, 'PW21A-JK100128BL-XXL', 1, 0, '2021-04-15 12:57:52.191567', '2021-04-15 12:57:52.191567', NULL),
	(10002194, 2, 'PW21A-JK100129YW -XS', 0, 0, '2021-04-15 12:57:52.185991', '2021-04-15 12:57:52.185991', NULL),
	(10002195, 2, 'PW21A-JK100129YW -S', 1, 0, '2021-04-15 12:57:52.194363', '2021-04-15 12:57:52.194363', NULL),
	(10002196, 2, 'PW21A-JK100129YW -M', 3, 0, '2021-04-15 12:57:52.192705', '2021-04-15 12:57:52.192705', NULL),
	(10002197, 2, 'PW21A-JK100129YW -L', 0, 0, '2021-04-15 12:57:52.202210', '2021-04-15 12:57:52.202210', NULL),
	(10002198, 2, 'PW21A-JK100129YW -XL', 1, 0, '2021-04-15 12:57:52.208576', '2021-04-15 12:57:52.208576', NULL),
	(10002199, 2, 'PW21A-JK100129YW -XXL', 0, 0, '2021-04-15 12:57:52.208217', '2021-04-15 12:57:52.208217', NULL),
	(10002200, 2, 'PW21A-JK100130YW -XS', 2, 0, '2021-04-15 12:57:52.209560', '2021-04-15 12:57:52.209560', NULL),
	(10002201, 2, 'PW21A-JK100130YW -S', 3, 0, '2021-04-15 12:57:52.197499', '2021-04-15 12:57:52.197499', NULL),
	(10002202, 2, 'PW21A-JK100130YW -M', 4, 0, '2021-04-15 12:57:52.222660', '2021-04-15 12:57:52.222660', NULL),
	(10002203, 2, 'PW21A-JK100130YW -L', 4, 0, '2021-04-15 12:57:52.211777', '2021-04-15 12:57:52.211777', NULL),
	(10002204, 2, 'PW21A-JK100130YW -XL', 3, 0, '2021-04-15 12:57:52.231784', '2021-04-15 12:57:52.231784', NULL),
	(10002205, 2, 'PW21A-JK100130YW -XXL', 2, 0, '2021-04-15 12:57:52.223205', '2021-04-15 12:57:52.223205', NULL),
	(10002206, 2, 'PW21A-JK100131YW -XS', 0, 0, '2021-04-15 12:57:52.220820', '2021-04-15 12:57:52.220820', NULL),
	(10002207, 2, 'PW21A-JK100131YW -S', 0, 0, '2021-04-15 12:57:52.212145', '2021-04-15 12:57:52.212145', NULL),
	(10002208, 2, 'PW21A-JK100131YW -M', 0, 0, '2021-04-15 12:57:52.234510', '2021-04-15 12:57:52.234510', NULL),
	(10002209, 2, 'PW21A-JK100131YW -L', 0, 0, '2021-04-15 12:57:52.241679', '2021-04-15 12:57:52.241679', NULL),
	(10002210, 2, 'PW21A-JK100131YW -XL', 0, 0, '2021-04-15 12:57:52.249322', '2021-04-15 12:57:52.249322', NULL),
	(10002211, 2, 'PW21A-JK100131YW -XXL', 0, 0, '2021-04-15 12:57:52.243073', '2021-04-15 12:57:52.243073', NULL),
	(10002212, 2, 'PW21A-JK100132BL-XS', 0, 0, '2021-04-15 12:57:52.251605', '2021-04-15 12:57:52.251605', NULL),
	(10002213, 2, 'PW21A-JK100132BL-S', 0, 0, '2021-04-15 12:57:52.243470', '2021-04-15 12:57:52.243470', NULL),
	(10002214, 2, 'PW21A-JK100132BL-M', 1, 0, '2021-04-15 12:57:52.244477', '2021-04-15 12:57:52.244477', NULL),
	(10002215, 2, 'PW21A-JK100132BL-L', 1, 0, '2021-04-15 12:57:52.252498', '2021-04-15 12:57:52.252498', NULL),
	(10002216, 2, 'PW21A-JK100132BL-XL', 0, 0, '2021-04-15 12:57:52.343066', '2021-04-15 12:57:52.343066', NULL),
	(10002217, 2, 'PW21A-JK100132BL-XXL', 0, 0, '2021-04-15 12:57:52.269172', '2021-04-15 12:57:52.269172', NULL),
	(10002218, 2, 'PW21A-JK100133BL-XS', 0, 0, '2021-04-15 12:57:52.262798', '2021-04-15 12:57:52.262798', NULL),
	(10002219, 2, 'PW21A-JK100133BL-S', 0, 0, '2021-04-15 12:57:52.253352', '2021-04-15 12:57:52.253352', NULL),
	(10002220, 2, 'PW21A-JK100133BL-M', 0, 0, '2021-04-15 12:57:52.359153', '2021-04-15 12:57:52.359153', NULL),
	(10002221, 2, 'PW21A-JK100133BL-L', 0, 0, '2021-04-15 12:57:52.279411', '2021-04-15 12:57:52.279411', NULL),
	(10002222, 2, 'PW21A-JK100133BL-XL', 0, 0, '2021-04-15 12:57:52.269715', '2021-04-15 12:57:52.269715', NULL),
	(10002223, 2, 'PW21A-JK100133BL-XXL', 0, 0, '2021-04-15 12:57:52.414211', '2021-04-15 12:57:52.414211', NULL),
	(10002224, 2, 'PW21A-JK100134OL-XS', 0, 0, '2021-04-15 12:57:52.274019', '2021-04-15 12:57:52.274019', NULL),
	(10002225, 2, 'PW21A-JK100134OL-S', 2, 0, '2021-04-15 12:57:52.279048', '2021-04-15 12:57:52.279048', NULL),
	(10002226, 2, 'PW21A-JK100134OL-M', 2, 0, '2021-04-15 12:57:52.270231', '2021-04-15 12:57:52.270231', NULL),
	(10002227, 2, 'PW21A-JK100134OL-L', 1, 0, '2021-04-15 12:57:52.296344', '2021-04-15 12:57:52.296344', NULL),
	(10002228, 2, 'PW21A-JK100134OL-XL', 0, 0, '2021-04-15 12:57:52.298493', '2021-04-15 12:57:52.298493', NULL),
	(10002229, 2, 'PW21A-JK100134OL-XXL', 0, 0, '2021-04-15 12:57:52.276945', '2021-04-15 12:57:52.276945', NULL),
	(10002230, 2, 'PW21A-JK100135BL-XS', 0, 0, '2021-04-15 12:57:52.328606', '2021-04-15 12:57:52.328606', NULL),
	(10002231, 2, 'PW21A-JK100135BL-S', 0, 0, '2021-04-15 12:57:52.280302', '2021-04-15 12:57:52.280302', NULL),
	(10002232, 2, 'PW21A-JK100135BL-M', 0, 0, '2021-04-15 12:57:52.418719', '2021-04-15 12:57:52.418719', NULL),
	(10002233, 2, 'PW21A-JK100135BL-L', 0, 0, '2021-04-15 12:57:52.298007', '2021-04-15 12:57:52.298007', NULL),
	(10002234, 2, 'PW21A-JK100135BL-XL', 0, 0, '2021-04-15 12:57:52.306699', '2021-04-15 12:57:52.306699', NULL),
	(10002235, 2, 'PW21A-JK100135BL-XXL', 0, 0, '2021-04-15 12:57:52.279789', '2021-04-15 12:57:52.279789', NULL),
	(10002236, 2, 'PW21A-JK100136OL-XS', 0, 0, '2021-04-15 12:57:52.299822', '2021-04-15 12:57:52.299822', NULL),
	(10002237, 2, 'PW21A-JK100136OL-S', 3, 0, '2021-04-15 12:57:52.309730', '2021-04-15 12:57:52.309730', NULL),
	(10002238, 2, 'PW21A-JK100136OL-M', 4, 0, '2021-04-15 12:57:52.310219', '2021-04-15 12:57:52.310219', NULL),
	(10002239, 2, 'PW21A-JK100136OL-L', 4, 0, '2021-04-15 12:57:52.302939', '2021-04-15 12:57:52.302939', NULL),
	(10002240, 2, 'PW21A-JK100136OL-XL', 3, 0, '2021-04-15 12:57:52.322858', '2021-04-15 12:57:52.322858', NULL),
	(10002241, 2, 'PW21A-JK100136OL-XXL', 2, 0, '2021-04-15 12:57:52.308360', '2021-04-15 12:57:52.308360', NULL),
	(10002242, 2, 'PW21A-JK100137BL-XS', 2, 0, '2021-04-15 12:57:52.321643', '2021-04-15 12:57:52.321643', NULL),
	(10002243, 2, 'PW21A-JK100137BL-S', 3, 0, '2021-04-15 12:57:52.333145', '2021-04-15 12:57:52.333145', NULL),
	(10002244, 2, 'PW21A-JK100137BL-M', 4, 0, '2021-04-15 12:57:52.320836', '2021-04-15 12:57:52.320836', NULL),
	(10002245, 2, 'PW21A-JK100137BL-L', 4, 0, '2021-04-15 12:57:52.331856', '2021-04-15 12:57:52.331856', NULL),
	(10002246, 2, 'PW21A-JK100137BL-XL', 3, 0, '2021-04-15 12:57:52.310575', '2021-04-15 12:57:52.310575', NULL),
	(10002247, 2, 'PW21A-JK100137BL-XXL', 2, 0, '2021-04-15 12:57:52.331442', '2021-04-15 12:57:52.331442', NULL),
	(10002248, 2, 'PW21A-JK100138OL-XS', 0, 0, '2021-04-15 12:57:52.341332', '2021-04-15 12:57:52.341332', NULL),
	(10002249, 2, 'PW21A-JK100138OL-S', 3, 0, '2021-04-15 12:57:52.323202', '2021-04-15 12:57:52.323202', NULL),
	(10002250, 2, 'PW21A-JK100138OL-M', 4, 0, '2021-04-15 12:57:52.342327', '2021-04-15 12:57:52.342327', NULL),
	(10002251, 2, 'PW21A-JK100138OL-L', 4, 0, '2021-04-15 12:57:52.323508', '2021-04-15 12:57:52.323508', NULL),
	(10002252, 2, 'PW21A-JK100138OL-XL', 3, 0, '2021-04-15 12:57:52.356897', '2021-04-15 12:57:52.356897', NULL),
	(10002253, 2, 'PW21A-JK100138OL-XXL', 2, 0, '2021-04-15 12:57:52.332809', '2021-04-15 12:57:52.332809', NULL),
	(10002254, 2, 'PW21A-JK100139BL-XS', 0, 0, '2021-04-15 12:57:52.357324', '2021-04-15 12:57:52.357324', NULL),
	(10002255, 2, 'PW21A-JK100139BL-S', 3, 0, '2021-04-15 12:57:52.357765', '2021-04-15 12:57:52.357765', NULL),
	(10002256, 2, 'PW21A-JK100139BL-M', 4, 0, '2021-04-15 12:57:52.342703', '2021-04-15 12:57:52.342703', NULL),
	(10002257, 2, 'PW21A-JK100139BL-L', 4, 0, '2021-04-15 12:57:52.373373', '2021-04-15 12:57:52.373373', NULL),
	(10002258, 2, 'PW21A-JK100139BL-XL', 3, 0, '2021-04-15 12:57:52.434606', '2021-04-15 12:57:52.434606', NULL),
	(10002259, 2, 'PW21A-JK100139BL-XXL', 2, 0, '2021-04-15 12:57:52.370127', '2021-04-15 12:57:52.370127', NULL),
	(10002260, 2, 'PW21A-JK100140OL-XS', 0, 0, '2021-04-15 12:57:52.354733', '2021-04-15 12:57:52.354733', NULL),
	(10002261, 2, 'PW21A-JK100140OL-S', 3, 0, '2021-04-15 12:57:52.343390', '2021-04-15 12:57:52.343390', NULL),
	(10002262, 2, 'PW21A-JK100140OL-M', 4, 0, '2021-04-15 12:57:52.372818', '2021-04-15 12:57:52.372818', NULL),
	(10002263, 2, 'PW21A-JK100140OL-L', 4, 0, '2021-04-15 12:57:52.371451', '2021-04-15 12:57:52.371451', NULL),
	(10002264, 2, 'PW21A-JK100140OL-XL', 3, 0, '2021-04-15 12:57:52.389468', '2021-04-15 12:57:52.389468', NULL),
	(10002265, 2, 'PW21A-JK100140OL-XXL', 2, 0, '2021-04-15 12:57:52.375339', '2021-04-15 12:57:52.375339', NULL),
	(10002266, 2, 'PW21A-JK100141BL-XS', 0, 0, '2021-04-15 12:57:52.383051', '2021-04-15 12:57:52.383051', NULL),
	(10002267, 2, 'PW21A-JK100141BL-S', 0, 0, '2021-04-15 12:57:52.385282', '2021-04-15 12:57:52.385282', NULL),
	(10002268, 2, 'PW21A-JK100141BL-M', 3, 0, '2021-04-15 12:57:52.388434', '2021-04-15 12:57:52.388434', NULL),
	(10002269, 2, 'PW21A-JK100141BL-L', 4, 0, '2021-04-15 12:57:52.386120', '2021-04-15 12:57:52.386120', NULL),
	(10002270, 2, 'PW21A-JK100141BL-XL', 3, 0, '2021-04-15 12:57:52.402482', '2021-04-15 12:57:52.402482', NULL),
	(10002271, 2, 'PW21A-JK100141BL-XXL', 2, 0, '2021-04-15 12:57:52.402067', '2021-04-15 12:57:52.402067', NULL),
	(10002272, 2, 'PW21A-JK100142OL-XS', 0, 0, '2021-04-15 12:57:52.404035', '2021-04-15 12:57:52.404035', NULL),
	(10002273, 2, 'PW21A-JK100142OL-S', 3, 0, '2021-04-15 12:57:52.415274', '2021-04-15 12:57:52.415274', NULL),
	(10002274, 2, 'PW21A-JK100142OL-M', 4, 0, '2021-04-15 12:57:52.405361', '2021-04-15 12:57:52.405361', NULL),
	(10002275, 2, 'PW21A-JK100142OL-L', 4, 0, '2021-04-15 12:57:52.411078', '2021-04-15 12:57:52.411078', NULL),
	(10002276, 2, 'PW21A-JK100142OL-XL', 3, 0, '2021-04-15 12:57:52.404435', '2021-04-15 12:57:52.404435', NULL),
	(10002277, 2, 'PW21A-JK100142OL-XXL', 2, 0, '2021-04-15 12:57:52.509322', '2021-04-15 12:57:52.509322', NULL),
	(10002278, 2, 'PW21A-JK100143BL-XS', 0, 0, '2021-04-15 12:57:52.412808', '2021-04-15 12:57:52.412808', NULL),
	(10002279, 2, 'PW21A-JK100143BL-S', 3, 0, '2021-04-15 12:57:52.556266', '2021-04-15 12:57:52.556266', NULL),
	(10002280, 2, 'PW21A-JK100143BL-M', 4, 0, '2021-04-15 12:57:52.432639', '2021-04-15 12:57:52.432639', NULL),
	(10002281, 2, 'PW21A-JK100143BL-L', 2, 0, '2021-04-15 12:57:52.541762', '2021-04-15 12:57:52.541762', NULL),
	(10002282, 2, 'PW21A-JK100143BL-XL', 1, 0, '2021-04-15 12:57:52.602374', '2021-04-15 12:57:52.602374', NULL),
	(10002283, 2, 'PW21A-JK100143BL-XXL', 0, 0, '2021-04-15 12:57:52.432122', '2021-04-15 12:57:52.432122', NULL),
	(10002284, 2, 'PW21A-JK100144AR-XS', 0, 0, '2021-04-15 12:57:52.448084', '2021-04-15 12:57:52.448084', NULL),
	(10002285, 2, 'PW21A-JK100144AR-S', 3, 0, '2021-04-15 12:57:52.448502', '2021-04-15 12:57:52.448502', NULL),
	(10002286, 2, 'PW21A-JK100144AR-M', 4, 0, '2021-04-15 12:57:52.444513', '2021-04-15 12:57:52.444513', NULL),
	(10002287, 2, 'PW21A-JK100144AR-L', 4, 0, '2021-04-15 12:57:52.447500', '2021-04-15 12:57:52.447500', NULL),
	(10002288, 2, 'PW21A-JK100144AR-XL', 3, 0, '2021-04-15 12:57:52.431488', '2021-04-15 12:57:52.431488', NULL),
	(10002289, 2, 'PW21A-JK100144AR-XXL', 2, 0, '2021-04-15 12:57:52.433953', '2021-04-15 12:57:52.433953', NULL),
	(10002290, 2, 'PW21A-JK100145RD-XS', 0, 0, '2021-04-15 12:57:52.458259', '2021-04-15 12:57:52.458259', NULL),
	(10002291, 2, 'PW21A-JK100145RD-S', 1, 0, '2021-04-15 12:57:52.467751', '2021-04-15 12:57:52.467751', NULL),
	(10002292, 2, 'PW21A-JK100145RD-M', 4, 0, '2021-04-15 12:57:52.446844', '2021-04-15 12:57:52.446844', NULL),
	(10002293, 2, 'PW21A-JK100145RD-L', 4, 0, '2021-04-15 12:57:52.469148', '2021-04-15 12:57:52.469148', NULL),
	(10002294, 2, 'PW21A-JK100145RD-XL', 3, 0, '2021-04-15 12:57:52.460040', '2021-04-15 12:57:52.460040', NULL),
	(10002295, 2, 'PW21A-JK100145RD-XXL', 2, 0, '2021-04-15 12:57:52.459081', '2021-04-15 12:57:52.459081', NULL),
	(10002296, 2, 'PW21A-JK100146BL-XS', 0, 0, '2021-04-15 12:57:52.458732', '2021-04-15 12:57:52.458732', NULL),
	(10002297, 2, 'PW21A-JK100146BL-S', 3, 0, '2021-04-15 12:57:52.460377', '2021-04-15 12:57:52.460377', NULL),
	(10002298, 2, 'PW21A-JK100146BL-M', 4, 0, '2021-04-15 12:57:52.470210', '2021-04-15 12:57:52.470210', NULL),
	(10002299, 2, 'PW21A-JK100146BL-L', 4, 0, '2021-04-15 12:57:52.484151', '2021-04-15 12:57:52.484151', NULL),
	(10002300, 2, 'PW21A-JK100146BL-XL', 3, 0, '2021-04-15 12:57:52.483830', '2021-04-15 12:57:52.483830', NULL),
	(10002301, 2, 'PW21A-JK100146BL-XXL', 2, 0, '2021-04-15 12:57:52.469850', '2021-04-15 12:57:52.469850', NULL),
	(10002302, 2, 'PW21A-JK100147BL-XS', 0, 0, '2021-04-15 12:57:52.469491', '2021-04-15 12:57:52.469491', NULL),
	(10002303, 2, 'PW21A-JK100147BL-S', 3, 0, '2021-04-15 12:57:52.486398', '2021-04-15 12:57:52.486398', NULL),
	(10002304, 2, 'PW21A-JK100147BL-M', 4, 0, '2021-04-15 12:57:52.493091', '2021-04-15 12:57:52.493091', NULL),
	(10002305, 2, 'PW21A-JK100147BL-L', 4, 0, '2021-04-15 12:57:52.491817', '2021-04-15 12:57:52.491817', NULL),
	(10002306, 2, 'PW21A-JK100147BL-XL', 3, 0, '2021-04-15 12:57:52.508670', '2021-04-15 12:57:52.508670', NULL),
	(10002307, 2, 'PW21A-JK100147BL-XXL', 2, 0, '2021-04-15 12:57:52.485516', '2021-04-15 12:57:52.485516', NULL),
	(10002308, 2, 'PW21A-JK100148BL-XS', 0, 0, '2021-04-15 12:57:52.495780', '2021-04-15 12:57:52.495780', NULL),
	(10002309, 2, 'PW21A-JK100148BL-S', 3, 0, '2021-04-15 12:57:52.484460', '2021-04-15 12:57:52.484460', NULL),
	(10002310, 2, 'PW21A-JK100148BL-M', 4, 0, '2021-04-15 12:57:52.494863', '2021-04-15 12:57:52.494863', NULL),
	(10002311, 2, 'PW21A-JK100148BL-L', 4, 0, '2021-04-15 12:57:52.543109', '2021-04-15 12:57:52.543109', NULL),
	(10002312, 2, 'PW21A-JK100148BL-XL', 3, 0, '2021-04-15 12:57:52.494333', '2021-04-15 12:57:52.494333', NULL),
	(10002313, 2, 'PW21A-JK100148BL-XXL', 1, 0, '2021-04-15 12:57:52.508228', '2021-04-15 12:57:52.508228', NULL),
	(10002314, 2, 'PW21A-JK100149BL-XS', 0, 0, '2021-04-15 12:57:52.518754', '2021-04-15 12:57:52.518754', NULL),
	(10002315, 2, 'PW21A-JK100149BL-S', 3, 0, '2021-04-15 12:57:52.523601', '2021-04-15 12:57:52.523601', NULL),
	(10002316, 2, 'PW21A-JK100149BL-M', 4, 0, '2021-04-15 12:57:52.510217', '2021-04-15 12:57:52.510217', NULL),
	(10002317, 2, 'PW21A-JK100149BL-L', 4, 0, '2021-04-15 12:57:52.514681', '2021-04-15 12:57:52.514681', NULL),
	(10002318, 2, 'PW21A-JK100149BL-XL', 3, 0, '2021-04-15 12:57:52.543471', '2021-04-15 12:57:52.543471', NULL),
	(10002319, 2, 'PW21A-JK100149BL-XXL', 2, 0, '2021-04-15 12:57:52.524195', '2021-04-15 12:57:52.524195', NULL),
	(10002320, 2, 'PW21A-JK100150BL-XS', 0, 0, '2021-04-15 12:57:52.577857', '2021-04-15 12:57:52.577857', NULL),
	(10002321, 2, 'PW21A-JK100150BL-S', 3, 0, '2021-04-15 12:57:52.525124', '2021-04-15 12:57:52.525124', NULL),
	(10002322, 2, 'PW21A-JK100150BL-M', 4, 0, '2021-04-15 12:57:52.542133', '2021-04-15 12:57:52.542133', NULL),
	(10002323, 2, 'PW21A-JK100150BL-L', 4, 0, '2021-04-15 12:57:52.526621', '2021-04-15 12:57:52.526621', NULL),
	(10002324, 2, 'PW21A-JK100150BL-XL', 3, 0, '2021-04-15 12:57:52.547535', '2021-04-15 12:57:52.547535', NULL),
	(10002325, 2, 'PW21A-JK100150BL-XXL', 2, 0, '2021-04-15 12:57:52.553639', '2021-04-15 12:57:52.553639', NULL),
	(10002326, 2, 'PW21A-JK100151BL-XS', 0, 0, '2021-04-15 12:57:52.630118', '2021-04-15 12:57:52.630118', NULL),
	(10002327, 2, 'PW21A-JK100151BL-S', 3, 0, '2021-04-15 12:57:52.560339', '2021-04-15 12:57:52.560339', NULL),
	(10002328, 2, 'PW21A-JK100151BL-M', 4, 0, '2021-04-15 12:57:52.557750', '2021-04-15 12:57:52.557750', NULL),
	(10002329, 2, 'PW21A-JK100151BL-L', 4, 0, '2021-04-15 12:57:52.573684', '2021-04-15 12:57:52.573684', NULL),
	(10002330, 2, 'PW21A-JK100151BL-XL', 3, 0, '2021-04-15 12:57:52.559526', '2021-04-15 12:57:52.559526', NULL),
	(10002331, 2, 'PW21A-JK100151BL-XXL', 2, 0, '2021-04-15 12:57:52.572999', '2021-04-15 12:57:52.572999', NULL),
	(10002332, 2, 'PW21A-JK100152BL-XS', 0, 0, '2021-04-15 12:57:52.582778', '2021-04-15 12:57:52.582778', NULL),
	(10002333, 2, 'PW21A-JK100152BL-S', 3, 0, '2021-04-15 12:57:52.576366', '2021-04-15 12:57:52.576366', NULL),
	(10002334, 2, 'PW21A-JK100152BL-M', 4, 0, '2021-04-15 12:57:52.604168', '2021-04-15 12:57:52.604168', NULL),
	(10002335, 2, 'PW21A-JK100152BL-L', 4, 0, '2021-04-15 12:57:52.575340', '2021-04-15 12:57:52.575340', NULL),
	(10002336, 2, 'PW21A-JK100152BL-XL', 3, 0, '2021-04-15 12:57:52.589304', '2021-04-15 12:57:52.589304', NULL),
	(10002337, 2, 'PW21A-JK100152BL-XXL', 2, 0, '2021-04-15 12:57:52.588470', '2021-04-15 12:57:52.588470', NULL),
	(10002338, 2, 'PW21A-JK100153GN-XS', 0, 0, '2021-04-15 12:57:52.586726', '2021-04-15 12:57:52.586726', NULL),
	(10002339, 2, 'PW21A-JK100153GN-S', 3, 0, '2021-04-15 12:57:52.601012', '2021-04-15 12:57:52.601012', NULL),
	(10002340, 2, 'PW21A-JK100153GN-M', 4, 0, '2021-04-15 12:57:52.589638', '2021-04-15 12:57:52.589638', NULL),
	(10002341, 2, 'PW21A-JK100153GN-L', 4, 0, '2021-04-15 12:57:52.611487', '2021-04-15 12:57:52.611487', NULL),
	(10002342, 2, 'PW21A-JK100153GN-XL', 3, 0, '2021-04-15 12:57:52.602017', '2021-04-15 12:57:52.602017', NULL),
	(10002343, 2, 'PW21A-JK100153GN-XXL', 2, 0, '2021-04-15 12:57:52.627407', '2021-04-15 12:57:52.627407', NULL),
	(10002344, 2, 'PW21A-JD100154BL-XS', 0, 0, '2021-04-15 12:57:52.601395', '2021-04-15 12:57:52.601395', NULL),
	(10002345, 2, 'PW21A-JD100154BL-S', 2, 0, '2021-04-15 12:57:52.607519', '2021-04-15 12:57:52.607519', NULL),
	(10002346, 2, 'PW21A-JD100154BL-M', 2, 0, '2021-04-15 12:57:52.605985', '2021-04-15 12:57:52.605985', NULL),
	(10002347, 2, 'PW21A-JD100154BL-L', 2, 0, '2021-04-15 12:57:52.616904', '2021-04-15 12:57:52.616904', NULL),
	(10002348, 2, 'PW21A-JD100154BL-XL', 2, 0, '2021-04-15 12:57:52.719655', '2021-04-15 12:57:52.719655', NULL),
	(10002349, 2, 'PW21A-JD100154BL-XXL', 1, 0, '2021-04-15 12:57:52.610715', '2021-04-15 12:57:52.610715', NULL),
	(10002350, 2, 'PW21A-JK100155OL-XS', 0, 0, '2021-04-15 12:57:52.641664', '2021-04-15 12:57:52.641664', NULL),
	(10002351, 2, 'PW21A-JK100155OL-S', 0, 0, '2021-04-15 12:57:52.741633', '2021-04-15 12:57:52.741633', NULL),
	(10002352, 2, 'PW21A-JK100155OL-M', 0, 0, '2021-04-15 12:57:52.626860', '2021-04-15 12:57:52.626860', NULL),
	(10002353, 2, 'PW21A-JK100155OL-L', 0, 0, '2021-04-15 12:57:52.628029', '2021-04-15 12:57:52.628029', NULL),
	(10002354, 2, 'PW21A-JK100155OL-XL', 0, 0, '2021-04-15 12:57:52.635068', '2021-04-15 12:57:52.635068', NULL),
	(10002355, 2, 'PW21A-JK100155OL-XXL', 0, 0, '2021-04-15 12:57:52.628402', '2021-04-15 12:57:52.628402', NULL),
	(10002356, 2, 'PW21A-JK100156YW -XS', 0, 0, '2021-04-15 12:57:52.652866', '2021-04-15 12:57:52.652866', NULL),
	(10002357, 2, 'PW21A-JK100156YW -S', 0, 0, '2021-04-15 12:57:52.659499', '2021-04-15 12:57:52.659499', NULL),
	(10002358, 2, 'PW21A-JK100156YW -M', 0, 0, '2021-04-15 12:57:52.652507', '2021-04-15 12:57:52.652507', NULL),
	(10002359, 2, 'PW21A-JK100156YW -L', 0, 0, '2021-04-15 12:57:52.633211', '2021-04-15 12:57:52.633211', NULL),
	(10002360, 2, 'PW21A-JK100156YW -XL', 0, 0, '2021-04-15 12:57:52.641261', '2021-04-15 12:57:52.641261', NULL),
	(10002361, 2, 'PW21A-JK100156YW -XXL', 0, 0, '2021-04-15 12:57:52.639400', '2021-04-15 12:57:52.639400', NULL),
	(10002362, 2, 'PW21A-JK100157BL-XS', 0, 0, '2021-04-15 12:57:52.660657', '2021-04-15 12:57:52.660657', NULL),
	(10002363, 2, 'PW21A-JK100157BL-S', 3, 0, '2021-04-15 12:57:52.836536', '2021-04-15 12:57:52.836536', NULL),
	(10002364, 2, 'PW21A-JK100157BL-M', 4, 0, '2021-04-15 12:57:52.771522', '2021-04-15 12:57:52.771522', NULL),
	(10002365, 2, 'PW21A-JK100157BL-L', 4, 0, '2021-04-15 12:57:52.657695', '2021-04-15 12:57:52.657695', NULL),
	(10002366, 2, 'PW21A-JK100157BL-XL', 3, 0, '2021-04-15 12:57:52.744142', '2021-04-15 12:57:52.744142', NULL),
	(10002367, 2, 'PW21A-JK100157BL-XXL', 2, 0, '2021-04-15 12:57:52.653743', '2021-04-15 12:57:52.653743', NULL),
	(10002368, 2, 'PW21A-JK100158AR-XS', 0, 0, '2021-04-15 12:57:52.655712', '2021-04-15 12:57:52.655712', NULL),
	(10002369, 2, 'PW21A-JK100158AR-S', 0, 0, '2021-04-15 12:57:52.656782', '2021-04-15 12:57:52.656782', NULL),
	(10002370, 2, 'PW21A-JK100158AR-M', 0, 0, '2021-04-15 12:57:52.659914', '2021-04-15 12:57:52.659914', NULL),
	(10002371, 2, 'PW21A-JK100158AR-L', 0, 0, '2021-04-15 12:57:52.653385', '2021-04-15 12:57:52.653385', NULL),
	(10002372, 2, 'PW21A-JK100158AR-XL', 0, 0, '2021-04-15 12:57:52.677612', '2021-04-15 12:57:52.677612', NULL),
	(10002373, 2, 'PW21A-JK100158AR-XXL', 0, 0, '2021-04-15 12:57:52.678358', '2021-04-15 12:57:52.678358', NULL),
	(10002374, 2, 'PW21A-JD100159MR-XS', 0, 0, '2021-04-15 12:57:52.690096', '2021-04-15 12:57:52.690096', NULL),
	(10002375, 2, 'PW21A-JD100159MR-S', 0, 0, '2021-04-15 12:57:52.689113', '2021-04-15 12:57:52.689113', NULL),
	(10002376, 2, 'PW21A-JD100159MR-M', 0, 0, '2021-04-15 12:57:52.688666', '2021-04-15 12:57:52.688666', NULL),
	(10002377, 2, 'PW21A-JD100159MR-L', 0, 0, '2021-04-15 12:57:52.678024', '2021-04-15 12:57:52.678024', NULL),
	(10002378, 2, 'PW21A-JD100159MR-XL', 0, 0, '2021-04-15 12:57:52.689647', '2021-04-15 12:57:52.689647', NULL),
	(10002379, 2, 'PW21A-JD100159MR-XXL', 0, 0, '2021-04-15 12:57:52.690426', '2021-04-15 12:57:52.690426', NULL),
	(10002380, 2, 'PW21A-JK100160TC-XS', 0, 0, '2021-04-15 12:57:52.691222', '2021-04-15 12:57:52.691222', NULL),
	(10002381, 2, 'PW21A-JK100160TC-S', 0, 0, '2021-04-15 12:57:52.699146', '2021-04-15 12:57:52.699146', NULL),
	(10002382, 2, 'PW21A-JK100160TC-M', 0, 0, '2021-04-15 12:57:52.699762', '2021-04-15 12:57:52.699762', NULL),
	(10002383, 2, 'PW21A-JK100160TC-L', 0, 0, '2021-04-15 12:57:52.773604', '2021-04-15 12:57:52.773604', NULL),
	(10002384, 2, 'PW21A-JK100160TC-XL', 0, 0, '2021-04-15 12:57:52.690796', '2021-04-15 12:57:52.690796', NULL),
	(10002385, 2, 'PW21A-JK100160TC-XXL', 0, 0, '2021-04-15 12:57:52.714192', '2021-04-15 12:57:52.714192', NULL),
	(10002386, 2, 'PW21A-JK100161BL-XS', 0, 0, '2021-04-15 12:57:52.699473', '2021-04-15 12:57:52.699473', NULL),
	(10002387, 2, 'PW21A-JK100161BL-S', 3, 0, '2021-04-15 12:57:52.710709', '2021-04-15 12:57:52.710709', NULL),
	(10002388, 2, 'PW21A-JK100161BL-M', 4, 0, '2021-04-15 12:57:52.712554', '2021-04-15 12:57:52.712554', NULL),
	(10002389, 2, 'PW21A-JK100161BL-L', 4, 0, '2021-04-15 12:57:52.708888', '2021-04-15 12:57:52.708888', NULL),
	(10002390, 2, 'PW21A-JK100161BL-XL', 3, 0, '2021-04-15 12:57:52.712227', '2021-04-15 12:57:52.712227', NULL),
	(10002391, 2, 'PW21A-JK100161BL-XXL', 2, 0, '2021-04-15 12:57:52.711771', '2021-04-15 12:57:52.711771', NULL),
	(10002392, 2, 'PW21A-JD100162BL-XS', 0, 0, '2021-04-15 12:57:52.736649', '2021-04-15 12:57:52.736649', NULL),
	(10002393, 2, 'PW21A-JD100162BL-S', 0, 0, '2021-04-15 12:57:52.713306', '2021-04-15 12:57:52.713306', NULL),
	(10002394, 2, 'PW21A-JD100162BL-M', 0, 0, '2021-04-15 12:57:52.722870', '2021-04-15 12:57:52.722870', NULL),
	(10002395, 2, 'PW21A-JD100162BL-L', 0, 0, '2021-04-15 12:57:52.743526', '2021-04-15 12:57:52.743526', NULL),
	(10002396, 2, 'PW21A-JD100162BL-XL', 0, 0, '2021-04-15 12:57:52.718463', '2021-04-15 12:57:52.718463', NULL),
	(10002397, 2, 'PW21A-JD100162BL-XXL', 0, 0, '2021-04-15 12:57:52.927002', '2021-04-15 12:57:52.927002', NULL),
	(10002398, 2, 'PW21A-JK100163RD-XS', 2, 0, '2021-04-15 12:57:52.742957', '2021-04-15 12:57:52.742957', NULL),
	(10002399, 2, 'PW21A-JK100163RD-S', 3, 0, '2021-04-15 12:57:52.740501', '2021-04-15 12:57:52.740501', NULL),
	(10002400, 2, 'PW21A-JK100163RD-M', 4, 0, '2021-04-15 12:57:52.752729', '2021-04-15 12:57:52.752729', NULL),
	(10002401, 2, 'PW21A-JK100163RD-L', 4, 0, '2021-04-15 12:57:52.757149', '2021-04-15 12:57:52.757149', NULL),
	(10002402, 2, 'PW21A-JK100163RD-XL', 3, 0, '2021-04-15 12:57:52.741057', '2021-04-15 12:57:52.741057', NULL),
	(10002403, 2, 'PW21A-JK100163RD-XXL', 2, 0, '2021-04-15 12:57:52.915196', '2021-04-15 12:57:52.915196', NULL),
	(10002404, 2, 'PW21A-JD100164BL-XS', 0, 0, '2021-04-15 12:57:52.752224', '2021-04-15 12:57:52.752224', NULL),
	(10002405, 2, 'PW21A-JD100164BL-S', 0, 0, '2021-04-15 12:57:52.769087', '2021-04-15 12:57:52.769087', NULL),
	(10002406, 2, 'PW21A-JD100164BL-M', 0, 0, '2021-04-15 12:57:52.766470', '2021-04-15 12:57:52.766470', NULL),
	(10002407, 2, 'PW21A-JD100164BL-L', 0, 0, '2021-04-15 12:57:52.772645', '2021-04-15 12:57:52.772645', NULL),
	(10002408, 2, 'PW21A-JD100164BL-XL', 0, 0, '2021-04-15 12:57:52.909504', '2021-04-15 12:57:52.909504', NULL),
	(10002409, 2, 'PW21A-JD100164BL-XXL', 0, 0, '2021-04-15 12:57:52.773119', '2021-04-15 12:57:52.773119', NULL),
	(10002410, 2, 'PW21A-JK100165NV-XS', 0, 0, '2021-04-15 12:57:52.962328', '2021-04-15 12:57:52.962328', NULL),
	(10002411, 2, 'PW21A-JK100165NV-S', 0, 0, '2021-04-15 12:57:52.774114', '2021-04-15 12:57:52.774114', NULL),
	(10002412, 2, 'PW21A-JK100165NV-M', 0, 0, '2021-04-15 12:57:52.786727', '2021-04-15 12:57:52.786727', NULL),
	(10002413, 2, 'PW21A-JK100165NV-L', 0, 0, '2021-04-15 12:57:52.800056', '2021-04-15 12:57:52.800056', NULL),
	(10002414, 2, 'PW21A-JK100165NV-XL', 0, 0, '2021-04-15 12:57:52.781220', '2021-04-15 12:57:52.781220', NULL),
	(10002415, 2, 'PW21A-JK100165NV-XXL', 0, 0, '2021-04-15 12:57:52.781702', '2021-04-15 12:57:52.781702', NULL),
	(10002416, 2, 'PW21A-JK100166MR-XS', 0, 0, '2021-04-15 12:57:52.803855', '2021-04-15 12:57:52.803855', NULL),
	(10002417, 2, 'PW21A-JK100166MR-S', 0, 0, '2021-04-15 12:57:52.797539', '2021-04-15 12:57:52.797539', NULL),
	(10002418, 2, 'PW21A-JK100166MR-M', 0, 0, '2021-04-15 12:57:52.804430', '2021-04-15 12:57:52.804430', NULL),
	(10002419, 2, 'PW21A-JK100166MR-L', 0, 0, '2021-04-15 12:57:52.802487', '2021-04-15 12:57:52.802487', NULL),
	(10002420, 2, 'PW21A-JK100166MR-XL', 0, 0, '2021-04-15 12:57:52.829988', '2021-04-15 12:57:52.829988', NULL),
	(10002421, 2, 'PW21A-JK100166MR-XXL', 0, 0, '2021-04-15 12:57:52.805011', '2021-04-15 12:57:52.805011', NULL),
	(10002422, 2, 'PW21A-JK100167WT-XS', 0, 0, '2021-04-15 12:57:52.800679', '2021-04-15 12:57:52.800679', NULL),
	(10002423, 2, 'PW21A-JK100167WT-S', 3, 0, '2021-04-15 12:57:52.833944', '2021-04-15 12:57:52.833944', NULL),
	(10002424, 2, 'PW21A-JK100167WT-M', 4, 0, '2021-04-15 12:57:52.818059', '2021-04-15 12:57:52.818059', NULL),
	(10002425, 2, 'PW21A-JK100167WT-L', 4, 0, '2021-04-15 12:57:52.833451', '2021-04-15 12:57:52.833451', NULL),
	(10002426, 2, 'PW21A-JK100167WT-XL', 3, 0, '2021-04-15 12:57:52.819369', '2021-04-15 12:57:52.819369', NULL),
	(10002427, 2, 'PW21A-JK100167WT-XXL', 2, 0, '2021-04-15 12:57:52.813359', '2021-04-15 12:57:52.813359', NULL),
	(10002428, 2, 'PW21A-JK100168BL-XS', 0, 0, '2021-04-15 12:57:52.845573', '2021-04-15 12:57:52.845573', NULL),
	(10002429, 2, 'PW21A-JK100168BL-S', 3, 0, '2021-04-15 12:57:52.835387', '2021-04-15 12:57:52.835387', NULL),
	(10002430, 2, 'PW21A-JK100168BL-M', 4, 0, '2021-04-15 12:57:52.910200', '2021-04-15 12:57:52.910200', NULL),
	(10002431, 2, 'PW21A-JK100168BL-L', 4, 0, '2021-04-15 12:57:52.832761', '2021-04-15 12:57:52.832761', NULL),
	(10002432, 2, 'PW21A-JK100168BL-XL', 3, 0, '2021-04-15 12:57:52.837019', '2021-04-15 12:57:52.837019', NULL),
	(10002433, 2, 'PW21A-JK100168BL-XXL', 2, 0, '2021-04-15 12:57:52.849444', '2021-04-15 12:57:52.849444', NULL),
	(10002434, 2, 'PW21A-JK100169BL-XS', 0, 0, '2021-04-15 12:57:52.861597', '2021-04-15 12:57:52.861597', NULL),
	(10002435, 2, 'PW21A-JK100169BL-S', 0, 0, '2021-04-15 12:57:52.859065', '2021-04-15 12:57:52.859065', NULL),
	(10002436, 2, 'PW21A-JK100169BL-M', 0, 0, '2021-04-15 12:57:52.862694', '2021-04-15 12:57:52.862694', NULL),
	(10002437, 2, 'PW21A-JK100169BL-L', 0, 0, '2021-04-15 12:57:52.850263', '2021-04-15 12:57:52.850263', NULL),
	(10002438, 2, 'PW21A-JK100169BL-XL', 0, 0, '2021-04-15 12:57:52.862163', '2021-04-15 12:57:52.862163', NULL),
	(10002439, 2, 'PW21A-JK100169BL-XXL', 0, 0, '2021-04-15 12:57:52.869702', '2021-04-15 12:57:52.869702', NULL),
	(10002440, 2, 'PW21A-JK100170RD-XS', 0, 0, '2021-04-15 12:57:52.879498', '2021-04-15 12:57:52.879498', NULL),
	(10002441, 2, 'PW21A-JK100170RD-S', 0, 0, '2021-04-15 12:57:52.887698', '2021-04-15 12:57:52.887698', NULL),
	(10002442, 2, 'PW21A-JK100170RD-M', 0, 0, '2021-04-15 12:57:52.867200', '2021-04-15 12:57:52.867200', NULL),
	(10002443, 2, 'PW21A-JK100170RD-L', 0, 0, '2021-04-15 12:57:52.868582', '2021-04-15 12:57:52.868582', NULL),
	(10002444, 2, 'PW21A-JK100170RD-XL', 0, 0, '2021-04-15 12:57:53.087714', '2021-04-15 12:57:53.087714', NULL),
	(10002445, 2, 'PW21A-JK100170RD-XXL', 0, 0, '2021-04-15 12:57:52.888228', '2021-04-15 12:57:52.888228', NULL),
	(10002446, 2, 'PW21A-JK100171WT-XS', 0, 0, '2021-04-15 12:57:53.028389', '2021-04-15 12:57:53.028389', NULL),
	(10002447, 2, 'PW21A-JK100171WT-S', 0, 0, '2021-04-15 12:57:53.041685', '2021-04-15 12:57:53.041685', NULL),
	(10002448, 2, 'PW21A-JK100171WT-M', 0, 0, '2021-04-15 12:57:53.043318', '2021-04-15 12:57:53.043318', NULL),
	(10002449, 2, 'PW21A-JK100171WT-L', 0, 0, '2021-04-15 12:57:52.913664', '2021-04-15 12:57:52.913664', NULL),
	(10002450, 2, 'PW21A-JK100171WT-XL', 0, 0, '2021-04-15 12:57:52.911409', '2021-04-15 12:57:52.911409', NULL),
	(10002451, 2, 'PW21A-JK100171WT-XXL', 0, 0, '2021-04-15 12:57:52.937274', '2021-04-15 12:57:52.937274', NULL),
	(10002452, 2, 'PW21A-JK100172BL-XS', 0, 0, '2021-04-15 12:57:52.917645', '2021-04-15 12:57:52.917645', NULL),
	(10002453, 2, 'PW21A-JK100172BL-S', 3, 0, '2021-04-15 12:57:52.917184', '2021-04-15 12:57:52.917184', NULL),
	(10002454, 2, 'PW21A-JK100172BL-M', 4, 0, '2021-04-15 12:57:52.958503', '2021-04-15 12:57:52.958503', NULL),
	(10002455, 2, 'PW21A-JK100172BL-L', 4, 0, '2021-04-15 12:57:52.957321', '2021-04-15 12:57:52.957321', NULL),
	(10002456, 2, 'PW21A-JK100172BL-XL', 3, 0, '2021-04-15 12:57:52.959061', '2021-04-15 12:57:52.959061', NULL),
	(10002457, 2, 'PW21A-JK100172BL-XXL', 2, 0, '2021-04-15 12:57:52.945341', '2021-04-15 12:57:52.945341', NULL),
	(10002458, 2, 'PW21A-TS100173BL-XS', 0, 0, '2021-04-15 12:57:52.975669', '2021-04-15 12:57:52.975669', NULL),
	(10002459, 2, 'PW21A-TS100173BL-M', 0, 0, '2021-04-15 12:57:52.977209', '2021-04-15 12:57:52.977209', NULL),
	(10002460, 2, 'PW21A-TS100173BL-L', 0, 0, '2021-04-15 12:57:52.940074', '2021-04-15 12:57:52.940074', NULL),
	(10002461, 2, 'PW21A-TS100173BL-XL', 0, 0, '2021-04-15 12:57:53.077128', '2021-04-15 12:57:53.077128', NULL),
	(10002462, 2, 'PW21A-TS100173BL-XXL', 0, 0, '2021-04-15 12:57:52.993151', '2021-04-15 12:57:52.993151', NULL),
	(10002463, 2, 'PW21A-TS100174NV-XS', 0, 0, '2021-04-15 12:57:52.960146', '2021-04-15 12:57:52.960146', NULL),
	(10002464, 2, 'PW21A-TS100174NV-S', 0, 0, '2021-04-15 12:57:52.959633', '2021-04-15 12:57:52.959633', NULL),
	(10002465, 2, 'PW21A-TS100174NV-M', 0, 0, '2021-04-15 12:57:52.992006', '2021-04-15 12:57:52.992006', NULL),
	(10002466, 2, 'PW21A-TS100174NV-L', 0, 0, '2021-04-15 12:57:52.993775', '2021-04-15 12:57:52.993775', NULL),
	(10002467, 2, 'PW21A-TS100174NV-XL', 0, 0, '2021-04-15 12:57:53.019718', '2021-04-15 12:57:53.019718', NULL),
	(10002468, 2, 'PW21A-TS100174NV-XXL', 0, 0, '2021-04-15 12:57:52.983185', '2021-04-15 12:57:52.983185', NULL),
	(10002469, 2, 'PW21A-TS100175BL-XS', 0, 0, '2021-04-15 12:57:53.017300', '2021-04-15 12:57:53.017300', NULL),
	(10002470, 2, 'PW21A-TS100175BL-S', 0, 0, '2021-04-15 12:57:52.977725', '2021-04-15 12:57:52.977725', NULL),
	(10002471, 2, 'PW21A-TS100175BL-M', 0, 0, '2021-04-15 12:57:52.999494', '2021-04-15 12:57:52.999494', NULL),
	(10002472, 2, 'PW21A-TS100175BL-L', 0, 0, '2021-04-15 12:57:53.011746', '2021-04-15 12:57:53.011746', NULL),
	(10002473, 2, 'PW21A-TS100175BL-XL', 0, 0, '2021-04-15 12:57:52.998865', '2021-04-15 12:57:52.998865', NULL),
	(10002474, 2, 'PW21A-TS100175BL-XXL', 0, 0, '2021-04-15 12:57:53.023856', '2021-04-15 12:57:53.023856', NULL),
	(10002475, 2, 'PW21A-TS100176BL-XS', 0, 0, '2021-04-15 12:57:52.990223', '2021-04-15 12:57:52.990223', NULL),
	(10002476, 2, 'PW21A-TS100176BL-S', 0, 0, '2021-04-15 12:57:53.041216', '2021-04-15 12:57:53.041216', NULL),
	(10002477, 2, 'PW21A-TS100176BL-M', 0, 0, '2021-04-15 12:57:53.025376', '2021-04-15 12:57:53.025376', NULL),
	(10002478, 2, 'PW21A-TS100176BL-L', 0, 0, '2021-04-15 12:57:53.104897', '2021-04-15 12:57:53.104897', NULL),
	(10002479, 2, 'PW21A-TS100176BL-XL', 0, 0, '2021-04-15 12:57:53.015318', '2021-04-15 12:57:53.015318', NULL),
	(10002480, 2, 'PW21A-TS100176BL-XXL', 0, 0, '2021-04-15 12:57:53.026631', '2021-04-15 12:57:53.026631', NULL),
	(10002481, 2, 'PW21A-TS100177BL-XS', 0, 0, '2021-04-15 12:57:53.086714', '2021-04-15 12:57:53.086714', NULL),
	(10002482, 2, 'PW21A-TS100177BL-S', 0, 0, '2021-04-15 12:57:53.054201', '2021-04-15 12:57:53.054201', NULL),
	(10002483, 2, 'PW21A-TS100177BL-M', 0, 0, '2021-04-15 12:57:53.028021', '2021-04-15 12:57:53.028021', NULL),
	(10002484, 2, 'PW21A-TS100177BL-L', 0, 0, '2021-04-15 12:57:53.026270', '2021-04-15 12:57:53.026270', NULL),
	(10002485, 2, 'PW21A-TS100177BL-XL', 0, 0, '2021-04-15 12:57:53.054599', '2021-04-15 12:57:53.054599', NULL),
	(10002486, 2, 'PW21A-TS100177BL-XXL', 0, 0, '2021-04-15 12:57:53.042098', '2021-04-15 12:57:53.042098', NULL),
	(10002487, 2, 'PW21A-TS100178BL-XS', 0, 0, '2021-04-15 12:57:53.052542', '2021-04-15 12:57:53.052542', NULL),
	(10002488, 2, 'PW21A-TS100178BL-S', 0, 0, '2021-04-15 12:57:53.060801', '2021-04-15 12:57:53.060801', NULL),
	(10002489, 2, 'PW21A-TS100178BL-M', 0, 0, '2021-04-15 12:57:53.049413', '2021-04-15 12:57:53.049413', NULL),
	(10002490, 2, 'PW21A-TS100178BL-L', 0, 0, '2021-04-15 12:57:53.054983', '2021-04-15 12:57:53.054983', NULL),
	(10002491, 2, 'PW21A-TS100178BL-XL', 0, 0, '2021-04-15 12:57:53.074199', '2021-04-15 12:57:53.074199', NULL),
	(10002492, 2, 'PW21A-TS100178BL-XXL', 0, 0, '2021-04-15 12:57:53.073833', '2021-04-15 12:57:53.073833', NULL),
	(10002493, 2, 'PW21A-TS100179BL-XS', 0, 0, '2021-04-15 12:57:53.134190', '2021-04-15 12:57:53.134190', NULL),
	(10002494, 2, 'PW21A-TS100179BL-S', 1, 0, '2021-04-15 12:57:53.076097', '2021-04-15 12:57:53.076097', NULL),
	(10002495, 2, 'PW21A-TS100179BL-M', 3, 0, '2021-04-15 12:57:53.080995', '2021-04-15 12:57:53.080995', NULL),
	(10002496, 2, 'PW21A-TS100179BL-L', 1, 0, '2021-04-15 12:57:53.109528', '2021-04-15 12:57:53.109528', NULL),
	(10002497, 2, 'PW21A-TS100179BL-XL', 3, 0, '2021-04-15 12:57:53.131218', '2021-04-15 12:57:53.131218', NULL),
	(10002498, 2, 'PW21A-TS100179BL-XXL', 2, 0, '2021-04-15 12:57:53.111135', '2021-04-15 12:57:53.111135', NULL),
	(10002499, 2, 'PW21A-TS100180BL-XS', 0, 0, '2021-04-15 12:57:53.085331', '2021-04-15 12:57:53.085331', NULL),
	(10002500, 2, 'PW21A-TS100180BL-S', 0, 0, '2021-04-15 12:57:53.099032', '2021-04-15 12:57:53.099032', NULL),
	(10002501, 2, 'PW21A-TS100180BL-M', 0, 0, '2021-04-15 12:57:53.152760', '2021-04-15 12:57:53.152760', NULL),
	(10002502, 2, 'PW21A-TS100180BL-L', 0, 0, '2021-04-15 12:57:53.109145', '2021-04-15 12:57:53.109145', NULL),
	(10002503, 2, 'PW21A-TS100180BL-XL', 0, 0, '2021-04-15 12:57:53.088053', '2021-04-15 12:57:53.088053', NULL),
	(10002504, 2, 'PW21A-TS100180BL-XXL', 0, 0, '2021-04-15 12:57:53.084903', '2021-04-15 12:57:53.084903', NULL),
	(10002505, 2, 'PW21A-TS100181BL-XS', 0, 0, '2021-04-15 12:57:53.102971', '2021-04-15 12:57:53.102971', NULL),
	(10002506, 2, 'PW21A-TS100181BL-S', 2, 0, '2021-04-15 12:57:53.108679', '2021-04-15 12:57:53.108679', NULL),
	(10002507, 2, 'PW21A-TS100181BL-M', 1, 0, '2021-04-15 12:57:53.107901', '2021-04-15 12:57:53.107901', NULL),
	(10002508, 2, 'PW21A-TS100181BL-L', 4, 0, '2021-04-15 12:57:53.122946', '2021-04-15 12:57:53.122946', NULL),
	(10002509, 2, 'PW21A-TS100181BL-XL', 1, 0, '2021-04-15 12:57:53.097752', '2021-04-15 12:57:53.097752', NULL),
	(10002510, 2, 'PW21A-TS100181BL-XXL', 2, 0, '2021-04-15 12:57:53.099402', '2021-04-15 12:57:53.099402', NULL),
	(10002511, 2, 'PW21A-TS100182BL-XS', 0, 0, '2021-04-15 12:57:53.165256', '2021-04-15 12:57:53.165256', NULL),
	(10002512, 2, 'PW21A-TS100182BL-S', 0, 0, '2021-04-15 12:57:53.121719', '2021-04-15 12:57:53.121719', NULL),
	(10002513, 2, 'PW21A-TS100182BL-M', 0, 0, '2021-04-15 12:57:53.132106', '2021-04-15 12:57:53.132106', NULL),
	(10002514, 2, 'PW21A-TS100182BL-L', 0, 0, '2021-04-15 12:57:53.120424', '2021-04-15 12:57:53.120424', NULL),
	(10002515, 2, 'PW21A-TS100182BL-XL', 0, 0, '2021-04-15 12:57:53.124707', '2021-04-15 12:57:53.124707', NULL),
	(10002516, 2, 'PW21A-TS100182BL-XXL', 0, 0, '2021-04-15 12:57:53.124389', '2021-04-15 12:57:53.124389', NULL),
	(10002517, 2, 'PW21A-TS100183BL-XS', 0, 0, '2021-04-15 12:57:53.249920', '2021-04-15 12:57:53.249920', NULL),
	(10002518, 2, 'PW21A-TS100183BL-S', 0, 0, '2021-04-15 12:57:53.141431', '2021-04-15 12:57:53.141431', NULL),
	(10002519, 2, 'PW21A-TS100183BL-M', 0, 0, '2021-04-15 12:57:53.130865', '2021-04-15 12:57:53.130865', NULL),
	(10002520, 2, 'PW21A-TS100183BL-L', 0, 0, '2021-04-15 12:57:53.134800', '2021-04-15 12:57:53.134800', NULL),
	(10002521, 2, 'PW21A-TS100183BL-XL', 0, 0, '2021-04-15 12:57:53.143235', '2021-04-15 12:57:53.143235', NULL),
	(10002522, 2, 'PW21A-TS100183BL-XXL', 0, 0, '2021-04-15 12:57:53.143552', '2021-04-15 12:57:53.143552', NULL),
	(10002523, 2, 'PW21A-TS100184BL-XS', 0, 0, '2021-04-15 12:57:53.144443', '2021-04-15 12:57:53.144443', NULL),
	(10002524, 2, 'PW21A-TS100184BL-S', 0, 0, '2021-04-15 12:57:53.160708', '2021-04-15 12:57:53.160708', NULL),
	(10002525, 2, 'PW21A-TS100184BL-M', 0, 0, '2021-04-15 12:57:53.158007', '2021-04-15 12:57:53.158007', NULL),
	(10002526, 2, 'PW21A-TS100184BL-L', 0, 0, '2021-04-15 12:57:53.154675', '2021-04-15 12:57:53.154675', NULL),
	(10002527, 2, 'PW21A-TS100184BL-XL', 0, 0, '2021-04-15 12:57:53.155007', '2021-04-15 12:57:53.155007', NULL),
	(10002528, 2, 'PW21A-TS100184BL-XXL', 0, 0, '2021-04-15 12:57:53.155352', '2021-04-15 12:57:53.155352', NULL),
	(10002529, 2, 'PW21A-TS100185BL-XS', 0, 0, '2021-04-15 12:57:53.145428', '2021-04-15 12:57:53.145428', NULL),
	(10002530, 2, 'PW21A-TS100185BL-S', 0, 0, '2021-04-15 12:57:53.165600', '2021-04-15 12:57:53.165600', NULL),
	(10002531, 2, 'PW21A-TS100185BL-M', 0, 0, '2021-04-15 12:57:53.174446', '2021-04-15 12:57:53.174446', NULL),
	(10002532, 2, 'PW21A-TS100185BL-L', 0, 0, '2021-04-15 12:57:53.180711', '2021-04-15 12:57:53.180711', NULL),
	(10002533, 2, 'PW21A-TS100185BL-XL', 0, 0, '2021-04-15 12:57:53.166525', '2021-04-15 12:57:53.166525', NULL),
	(10002534, 2, 'PW21A-TS100185BL-XXL', 0, 0, '2021-04-15 12:57:53.163685', '2021-04-15 12:57:53.163685', NULL),
	(10002535, 2, 'PW21A-TS100186BL-XS', 0, 0, '2021-04-15 12:57:53.190224', '2021-04-15 12:57:53.190224', NULL),
	(10002536, 2, 'PW21A-TS100186BL-S', 0, 0, '2021-04-15 12:57:53.228845', '2021-04-15 12:57:53.228845', NULL),
	(10002537, 2, 'PW21A-TS100186BL-M', 0, 0, '2021-04-15 12:57:53.183340', '2021-04-15 12:57:53.183340', NULL),
	(10002538, 2, 'PW21A-TS100186BL-L', 0, 0, '2021-04-15 12:57:53.179867', '2021-04-15 12:57:53.179867', NULL),
	(10002539, 2, 'PW21A-TS100186BL-XL', 0, 0, '2021-04-15 12:57:53.180396', '2021-04-15 12:57:53.180396', NULL),
	(10002540, 2, 'PW21A-TS100186BL-XXL', 0, 0, '2021-04-15 12:57:53.200506', '2021-04-15 12:57:53.200506', NULL),
	(10002541, 2, 'PW21A-TS100187BL-XS', 0, 0, '2021-04-15 12:57:53.195464', '2021-04-15 12:57:53.195464', NULL),
	(10002542, 2, 'PW21A-TS100187BL-S', 0, 0, '2021-04-15 12:57:53.192267', '2021-04-15 12:57:53.192267', NULL),
	(10002543, 2, 'PW21A-TS100187BL-M', 0, 0, '2021-04-15 12:57:53.189573', '2021-04-15 12:57:53.189573', NULL),
	(10002544, 2, 'PW21A-TS100187BL-L', 0, 0, '2021-04-15 12:57:53.186805', '2021-04-15 12:57:53.186805', NULL),
	(10002545, 2, 'PW21A-TS100187BL-XL', 0, 0, '2021-04-15 12:57:53.193515', '2021-04-15 12:57:53.193515', NULL),
	(10002546, 2, 'PW21A-TS100187BL-XXL', 0, 0, '2021-04-15 12:57:53.227914', '2021-04-15 12:57:53.227914', NULL),
	(10002547, 2, 'PW21A-TS100188BL-XS', 0, 0, '2021-04-15 12:57:53.218381', '2021-04-15 12:57:53.218381', NULL),
	(10002548, 2, 'PW21A-TS100188BL-S', 0, 0, '2021-04-15 12:57:53.204658', '2021-04-15 12:57:53.204658', NULL),
	(10002549, 2, 'PW21A-TS100188BL-M', 0, 0, '2021-04-15 12:57:53.217929', '2021-04-15 12:57:53.217929', NULL),
	(10002550, 2, 'PW21A-TS100188BL-L', 0, 0, '2021-04-15 12:57:53.201678', '2021-04-15 12:57:53.201678', NULL),
	(10002551, 2, 'PW21A-TS100188BL-XL', 0, 0, '2021-04-15 12:57:53.286230', '2021-04-15 12:57:53.286230', NULL),
	(10002552, 2, 'PW21A-TS100188BL-XXL', 0, 0, '2021-04-15 12:57:53.198414', '2021-04-15 12:57:53.198414', NULL),
	(10002553, 2, 'PW21A-TS100189BL-XS', 0, 0, '2021-04-15 12:57:53.317837', '2021-04-15 12:57:53.317837', NULL),
	(10002554, 2, 'PW21A-TS100189BL-S', 0, 0, '2021-04-15 12:57:53.229854', '2021-04-15 12:57:53.229854', NULL),
	(10002555, 2, 'PW21A-TS100189BL-M', 0, 0, '2021-04-15 12:57:53.222240', '2021-04-15 12:57:53.222240', NULL),
	(10002556, 2, 'PW21A-TS100189BL-L', 0, 0, '2021-04-15 12:57:53.208091', '2021-04-15 12:57:53.208091', NULL),
	(10002557, 2, 'PW21A-TS100189BL-XL', 0, 0, '2021-04-15 12:57:53.212990', '2021-04-15 12:57:53.212990', NULL),
	(10002558, 2, 'PW21A-TS100189BL-XXL', 0, 0, '2021-04-15 12:57:53.213423', '2021-04-15 12:57:53.213423', NULL),
	(10002559, 2, 'PW21A-TS100190WT-XS', 0, 0, '2021-04-15 12:57:53.260148', '2021-04-15 12:57:53.260148', NULL),
	(10002560, 2, 'PW21A-TS100190WT-S', 0, 0, '2021-04-15 12:57:53.249049', '2021-04-15 12:57:53.249049', NULL),
	(10002561, 2, 'PW21A-TS100190WT-M', 0, 0, '2021-04-15 12:57:53.236167', '2021-04-15 12:57:53.236167', NULL),
	(10002562, 2, 'PW21A-TS100190WT-L', 0, 0, '2021-04-15 12:57:53.251845', '2021-04-15 12:57:53.251845', NULL),
	(10002563, 2, 'PW21A-TS100190WT-XL', 0, 0, '2021-04-15 12:57:53.330233', '2021-04-15 12:57:53.330233', NULL),
	(10002564, 2, 'PW21A-TS100190WT-XXL', 0, 0, '2021-04-15 12:57:53.290933', '2021-04-15 12:57:53.290933', NULL),
	(10002565, 2, 'PW21A-TS100191YW -XS', 0, 0, '2021-04-15 12:57:53.271118', '2021-04-15 12:57:53.271118', NULL),
	(10002566, 2, 'PW21A-TS100191YW -S', 2, 0, '2021-04-15 12:57:53.259763', '2021-04-15 12:57:53.259763', NULL),
	(10002567, 2, 'PW21A-TS100191YW -M', 2, 0, '2021-04-15 12:57:53.256860', '2021-04-15 12:57:53.256860', NULL),
	(10002568, 2, 'PW21A-TS100191YW -L', 1, 0, '2021-04-15 12:57:53.248055', '2021-04-15 12:57:53.248055', NULL),
	(10002569, 2, 'PW21A-TS100191YW -XL', 2, 0, '2021-04-15 12:57:53.245006', '2021-04-15 12:57:53.245006', NULL),
	(10002570, 2, 'PW21A-TS100191YW -XXL', 1, 0, '2021-04-15 12:57:53.273624', '2021-04-15 12:57:53.273624', NULL),
	(10002571, 2, 'PW21A-TS100192GN-XS', 0, 0, '2021-04-15 12:57:53.255447', '2021-04-15 12:57:53.255447', NULL),
	(10002572, 2, 'PW21A-TS100192GN-S', 3, 0, '2021-04-15 12:57:53.273196', '2021-04-15 12:57:53.273196', NULL),
	(10002573, 2, 'PW21A-TS100192GN-M', 3, 0, '2021-04-15 12:57:53.285403', '2021-04-15 12:57:53.285403', NULL),
	(10002574, 2, 'PW21A-TS100192GN-L', 4, 0, '2021-04-15 12:57:53.261740', '2021-04-15 12:57:53.261740', NULL),
	(10002575, 2, 'PW21A-TS100192GN-XL', 1, 0, '2021-04-15 12:57:53.268395', '2021-04-15 12:57:53.268395', NULL),
	(10002576, 2, 'PW21A-TS100192GN-XXL', 2, 0, '2021-04-15 12:57:53.278838', '2021-04-15 12:57:53.278838', NULL),
	(10002577, 2, 'PW21A-TS100193BL-XS', 0, 0, '2021-04-15 12:57:53.271568', '2021-04-15 12:57:53.271568', NULL),
	(10002578, 2, 'PW21A-TS100193BL-S', 4, 0, '2021-04-15 12:57:53.284460', '2021-04-15 12:57:53.284460', NULL),
	(10002579, 2, 'PW21A-TS100193BL-M', 4, 0, '2021-04-15 12:57:53.333252', '2021-04-15 12:57:53.333252', NULL),
	(10002580, 2, 'PW21A-TS100193BL-L', 4, 0, '2021-04-15 12:57:53.281782', '2021-04-15 12:57:53.281782', NULL),
	(10002581, 2, 'PW21A-TS100193BL-XL', 3, 0, '2021-04-15 12:57:53.296784', '2021-04-15 12:57:53.296784', NULL),
	(10002582, 2, 'PW21A-TS100193BL-XXL', 2, 0, '2021-04-15 12:57:53.354147', '2021-04-15 12:57:53.354147', NULL),
	(10002583, 2, 'PW21A-TS100194RD-XS', 0, 0, '2021-04-15 12:57:53.326910', '2021-04-15 12:57:53.326910', NULL),
	(10002584, 2, 'PW21A-TS100194RD-S', 3, 0, '2021-04-15 12:57:53.300217', '2021-04-15 12:57:53.300217', NULL),
	(10002585, 2, 'PW21A-TS100194RD-M', 0, 0, '2021-04-15 12:57:53.301012', '2021-04-15 12:57:53.301012', NULL),
	(10002586, 2, 'PW21A-TS100194RD-L', 2, 0, '2021-04-15 12:57:53.299912', '2021-04-15 12:57:53.299912', NULL),
	(10002587, 2, 'PW21A-TS100194RD-XL', 3, 0, '2021-04-15 12:57:53.309285', '2021-04-15 12:57:53.309285', NULL),
	(10002588, 2, 'PW21A-TS100194RD-XXL', 1, 0, '2021-04-15 12:57:53.306472', '2021-04-15 12:57:53.306472', NULL),
	(10002589, 2, 'PW21A-TS100195BL-XS', 0, 0, '2021-04-15 12:57:53.305571', '2021-04-15 12:57:53.305571', NULL),
	(10002590, 2, 'PW21A-TS100195BL-S', 3, 0, '2021-04-15 12:57:53.320937', '2021-04-15 12:57:53.320937', NULL),
	(10002591, 2, 'PW21A-TS100195BL-M', 4, 0, '2021-04-15 12:57:53.320590', '2021-04-15 12:57:53.320590', NULL),
	(10002592, 2, 'PW21A-TS100195BL-L', 4, 0, '2021-04-15 12:57:53.340209', '2021-04-15 12:57:53.340209', NULL),
	(10002593, 2, 'PW21A-TS100195BL-XL', 3, 0, '2021-04-15 12:57:53.309631', '2021-04-15 12:57:53.309631', NULL),
	(10002594, 2, 'PW21A-TS100195BL-XXL', 1, 0, '2021-04-15 12:57:53.313471', '2021-04-15 12:57:53.313471', NULL),
	(10002595, 2, 'PW21A-TS100196BL-XS', 0, 0, '2021-04-15 12:57:53.394313', '2021-04-15 12:57:53.394313', NULL),
	(10002596, 2, 'PW21A-TS100196BL-S', 3, 0, '2021-04-15 12:57:53.342223', '2021-04-15 12:57:53.342223', NULL),
	(10002597, 2, 'PW21A-TS100196BL-M', 3, 0, '2021-04-15 12:57:53.342615', '2021-04-15 12:57:53.342615', NULL),
	(10002598, 2, 'PW21A-TS100196BL-L', 3, 0, '2021-04-15 12:57:53.323430', '2021-04-15 12:57:53.323430', NULL),
	(10002599, 2, 'PW21A-TS100196BL-XL', 3, 0, '2021-04-15 12:57:53.332666', '2021-04-15 12:57:53.332666', NULL),
	(10002600, 2, 'PW21A-TS100196BL-XXL', 2, 0, '2021-04-15 12:57:53.322853', '2021-04-15 12:57:53.322853', NULL),
	(10002601, 2, 'PW21A-TS100197BL-XS', 0, 0, '2021-04-15 12:57:53.341901', '2021-04-15 12:57:53.341901', NULL),
	(10002602, 2, 'PW21A-TS100197BL-S', 23, 0, '2021-04-15 12:57:53.387648', '2021-04-15 12:57:53.387648', NULL),
	(10002603, 2, 'PW21A-TS100197BL-M', 31, 0, '2021-04-15 12:57:53.532141', '2021-04-15 12:57:53.532141', NULL),
	(10002604, 2, 'PW21A-TS100197BL-L', 55, 0, '2021-04-15 12:57:53.337474', '2021-04-15 12:57:53.337474', NULL),
	(10002605, 2, 'PW21A-TS100197BL-XL', 30, 0, '2021-04-15 12:57:53.352222', '2021-04-15 12:57:53.352222', NULL),
	(10002606, 2, 'PW21A-TS100197BL-XXL', 29, 0, '2021-04-15 12:57:53.348453', '2021-04-15 12:57:53.348453', NULL),
	(10002607, 2, 'PW21A-TS100198BL-XS', 0, 0, '2021-04-15 12:57:53.344094', '2021-04-15 12:57:53.344094', NULL),
	(10002608, 2, 'PW21A-TS100198BL-S', 2, 0, '2021-04-15 12:57:53.358398', '2021-04-15 12:57:53.358398', NULL),
	(10002609, 2, 'PW21A-TS100198BL-M', 4, 0, '2021-04-15 12:57:53.364785', '2021-04-15 12:57:53.364785', NULL),
	(10002610, 2, 'PW21A-TS100198BL-L', 4, 0, '2021-04-15 12:57:53.360809', '2021-04-15 12:57:53.360809', NULL),
	(10002611, 2, 'PW21A-TS100198BL-XL', 3, 0, '2021-04-15 12:57:53.365537', '2021-04-15 12:57:53.365537', NULL),
	(10002612, 2, 'PW21A-TS100198BL-XXL', 3, 0, '2021-04-15 12:57:53.371619', '2021-04-15 12:57:53.371619', NULL),
	(10002613, 2, 'PW21A-TS100199BL-XS', 0, 0, '2021-04-15 12:57:53.354738', '2021-04-15 12:57:53.354738', NULL),
	(10002614, 2, 'PW21A-TS100199BL-S', 0, 0, '2021-04-15 12:57:53.364278', '2021-04-15 12:57:53.364278', NULL),
	(10002615, 2, 'PW21A-TS100199BL-M', 0, 0, '2021-04-15 12:57:53.387024', '2021-04-15 12:57:53.387024', NULL),
	(10002616, 2, 'PW21A-TS100199BL-L', 0, 0, '2021-04-15 12:57:53.367385', '2021-04-15 12:57:53.367385', NULL),
	(10002617, 2, 'PW21A-TS100199BL-XL', 0, 0, '2021-04-15 12:57:53.375675', '2021-04-15 12:57:53.375675', NULL),
	(10002618, 2, 'PW21A-TS100199BL-XXL', 0, 0, '2021-04-15 12:57:53.379555', '2021-04-15 12:57:53.379555', NULL),
	(10002619, 2, 'PW21A-TS100200BL-XS', 0, 0, '2021-04-15 12:57:53.382540', '2021-04-15 12:57:53.382540', NULL),
	(10002620, 2, 'PW21A-TS100200BL-S', 0, 0, '2021-04-15 12:57:53.387931', '2021-04-15 12:57:53.387931', NULL),
	(10002621, 2, 'PW21A-TS100200BL-M', 0, 0, '2021-04-15 12:57:53.387339', '2021-04-15 12:57:53.387339', NULL),
	(10002622, 2, 'PW21A-TS100200BL-L', 0, 0, '2021-04-15 12:57:53.384383', '2021-04-15 12:57:53.384383', NULL),
	(10002623, 2, 'PW21A-TS100200BL-XL', 0, 0, '2021-04-15 12:57:53.384064', '2021-04-15 12:57:53.384064', NULL),
	(10002624, 2, 'PW21A-TS100200BL-XXL', 0, 0, '2021-04-15 12:57:53.409630', '2021-04-15 12:57:53.409630', NULL),
	(10002625, 2, 'PW21A-TS100201BL-XS', 0, 0, '2021-04-15 12:57:53.467951', '2021-04-15 12:57:53.467951', NULL),
	(10002626, 2, 'PW21A-TS100201BL-S', 3, 0, '2021-04-15 12:57:53.431997', '2021-04-15 12:57:53.431997', NULL),
	(10002627, 2, 'PW21A-TS100201BL-M', 4, 0, '2021-04-15 12:57:53.415993', '2021-04-15 12:57:53.415993', NULL),
	(10002628, 2, 'PW21A-TS100201BL-L', 3, 0, '2021-04-15 12:57:53.414916', '2021-04-15 12:57:53.414916', NULL),
	(10002629, 2, 'PW21A-TS100201BL-XL', 3, 0, '2021-04-15 12:57:53.399338', '2021-04-15 12:57:53.399338', NULL),
	(10002630, 2, 'PW21A-TS100201BL-XXL', 2, 0, '2021-04-15 12:57:53.437348', '2021-04-15 12:57:53.437348', NULL),
	(10002631, 2, 'PW21A-TS100202BL-XS', 0, 0, '2021-04-15 12:57:53.405896', '2021-04-15 12:57:53.405896', NULL),
	(10002632, 2, 'PW21A-TS100202BL-S', 4, 0, '2021-04-15 12:57:53.472900', '2021-04-15 12:57:53.472900', NULL),
	(10002633, 2, 'PW21A-TS100202BL-M', 3, 0, '2021-04-15 12:57:53.415499', '2021-04-15 12:57:53.415499', NULL),
	(10002634, 2, 'PW21A-TS100202BL-L', 4, 0, '2021-04-15 12:57:53.411543', '2021-04-15 12:57:53.411543', NULL),
	(10002635, 2, 'PW21A-TS100202BL-XL', 4, 0, '2021-04-15 12:57:53.417859', '2021-04-15 12:57:53.417859', NULL),
	(10002636, 2, 'PW21A-TS100202BL-XXL', 1, 0, '2021-04-15 12:57:53.419865', '2021-04-15 12:57:53.419865', NULL),
	(10002637, 2, 'PW21A-TS100203BL-XS', 0, 0, '2021-04-15 12:57:53.446229', '2021-04-15 12:57:53.446229', NULL),
	(10002638, 2, 'PW21A-TS100203BL-S', 3, 0, '2021-04-15 12:57:53.436099', '2021-04-15 12:57:53.436099', NULL),
	(10002639, 2, 'PW21A-TS100203BL-M', 4, 0, '2021-04-15 12:57:53.455414', '2021-04-15 12:57:53.455414', NULL),
	(10002640, 2, 'PW21A-TS100203BL-L', 4, 0, '2021-04-15 12:57:53.449959', '2021-04-15 12:57:53.449959', NULL),
	(10002641, 2, 'PW21A-TS100203BL-XL', 2, 0, '2021-04-15 12:57:53.448150', '2021-04-15 12:57:53.448150', NULL),
	(10002642, 2, 'PW21A-TS100203BL-XXL', 2, 0, '2021-04-15 12:57:53.445278', '2021-04-15 12:57:53.445278', NULL),
	(10002643, 2, 'PW21A-TS100204BL-XS', 0, 0, '2021-04-15 12:57:53.471178', '2021-04-15 12:57:53.471178', NULL),
	(10002644, 2, 'PW21A-TS100204BL-S', 3, 0, '2021-04-15 12:57:53.470196', '2021-04-15 12:57:53.470196', NULL),
	(10002645, 2, 'PW21A-TS100204BL-M', 4, 0, '2021-04-15 12:57:53.449417', '2021-04-15 12:57:53.449417', NULL),
	(10002646, 2, 'PW21A-TS100204BL-L', 4, 0, '2021-04-15 12:57:53.457132', '2021-04-15 12:57:53.457132', NULL),
	(10002647, 2, 'PW21A-TS100204BL-XL', 3, 0, '2021-04-15 12:57:53.522786', '2021-04-15 12:57:53.522786', NULL),
	(10002648, 2, 'PW21A-TS100204BL-XXL', 2, 0, '2021-04-15 12:57:53.481987', '2021-04-15 12:57:53.481987', NULL),
	(10002649, 2, 'PW21A-TS100205WT-XS', 0, 0, '2021-04-15 12:57:53.494638', '2021-04-15 12:57:53.494638', NULL),
	(10002650, 2, 'PW21A-TS100205WT-S', 0, 0, '2021-04-15 12:57:53.494293', '2021-04-15 12:57:53.494293', NULL),
	(10002651, 2, 'PW21A-TS100205WT-M', 0, 0, '2021-04-15 12:57:53.523556', '2021-04-15 12:57:53.523556', NULL),
	(10002652, 2, 'PW21A-TS100205WT-L', 0, 0, '2021-04-15 12:57:53.476881', '2021-04-15 12:57:53.476881', NULL),
	(10002653, 2, 'PW21A-TS100205WT-XL', 0, 0, '2021-04-15 12:57:53.493237', '2021-04-15 12:57:53.493237', NULL),
	(10002654, 2, 'PW21A-TS100205WT-XXL', 0, 0, '2021-04-15 12:57:53.478569', '2021-04-15 12:57:53.478569', NULL),
	(10002655, 2, 'PW21A-TS100206WT-XS', 0, 0, '2021-04-15 12:57:53.484856', '2021-04-15 12:57:53.484856', NULL),
	(10002656, 2, 'PW21A-TS100206WT-S', 0, 0, '2021-04-15 12:57:53.505282', '2021-04-15 12:57:53.505282', NULL),
	(10002657, 2, 'PW21A-TS100206WT-M', 0, 0, '2021-04-15 12:57:53.483890', '2021-04-15 12:57:53.483890', NULL),
	(10002658, 2, 'PW21A-TS100206WT-L', 0, 0, '2021-04-15 12:57:53.555934', '2021-04-15 12:57:53.555934', NULL),
	(10002659, 2, 'PW21A-TS100206WT-XL', 0, 0, '2021-04-15 12:57:53.505794', '2021-04-15 12:57:53.505794', NULL),
	(10002660, 2, 'PW21A-TS100206WT-XXL', 0, 0, '2021-04-15 12:57:53.496163', '2021-04-15 12:57:53.496163', NULL),
	(10002661, 2, 'PW21A-TS100207BL-XS', 0, 0, '2021-04-15 12:57:53.483508', '2021-04-15 12:57:53.483508', NULL),
	(10002662, 2, 'PW21A-TS100207BL-S', 3, 0, '2021-04-15 12:57:53.519752', '2021-04-15 12:57:53.519752', NULL),
	(10002663, 2, 'PW21A-TS100207BL-M', 4, 0, '2021-04-15 12:57:53.572783', '2021-04-15 12:57:53.572783', NULL),
	(10002664, 2, 'PW21A-TS100207BL-L', 4, 0, '2021-04-15 12:57:53.502810', '2021-04-15 12:57:53.502810', NULL),
	(10002665, 2, 'PW21A-TS100207BL-XL', 3, 0, '2021-04-15 12:57:53.557418', '2021-04-15 12:57:53.557418', NULL),
	(10002666, 2, 'PW21A-TS100207BL-XXL', 2, 0, '2021-04-15 12:57:53.508741', '2021-04-15 12:57:53.508741', NULL),
	(10002667, 2, 'PW21A-TS100208BL-XS', 0, 0, '2021-04-15 12:57:53.506811', '2021-04-15 12:57:53.506811', NULL),
	(10002668, 2, 'PW21A-TS100208BL-S', 0, 0, '2021-04-15 12:57:53.525250', '2021-04-15 12:57:53.525250', NULL),
	(10002669, 2, 'PW21A-TS100208BL-M', 0, 0, '2021-04-15 12:57:53.563508', '2021-04-15 12:57:53.563508', NULL),
	(10002670, 2, 'PW21A-TS100208BL-L', 0, 0, '2021-04-15 12:57:53.507170', '2021-04-15 12:57:53.507170', NULL),
	(10002671, 2, 'PW21A-TS100208BL-XL', 0, 0, '2021-04-15 12:57:53.538015', '2021-04-15 12:57:53.538015', NULL),
	(10002672, 2, 'PW21A-TS100208BL-XXL', 0, 0, '2021-04-15 12:57:53.536112', '2021-04-15 12:57:53.536112', NULL),
	(10002673, 2, 'PW21A-TS100209BL-XS', 0, 0, '2021-04-15 12:57:53.600844', '2021-04-15 12:57:53.600844', NULL),
	(10002674, 2, 'PW21A-TS100209BL-S', 3, 0, '2021-04-15 12:57:53.533195', '2021-04-15 12:57:53.533195', NULL),
	(10002675, 2, 'PW21A-TS100209BL-M', 4, 0, '2021-04-15 12:57:53.537581', '2021-04-15 12:57:53.537581', NULL),
	(10002676, 2, 'PW21A-TS100209BL-L', 4, 0, '2021-04-15 12:57:53.538727', '2021-04-15 12:57:53.538727', NULL),
	(10002677, 2, 'PW21A-TS100209BL-XL', 3, 0, '2021-04-15 12:57:53.557116', '2021-04-15 12:57:53.557116', NULL),
	(10002678, 2, 'PW21A-TS100209BL-XXL', 2, 0, '2021-04-15 12:57:53.621150', '2021-04-15 12:57:53.621150', NULL),
	(10002679, 2, 'PW21A-TS100210BL-XS', 0, 0, '2021-04-15 12:57:53.555535', '2021-04-15 12:57:53.555535', NULL),
	(10002680, 2, 'PW21A-TS100210BL-S', 0, 0, '2021-04-15 12:57:53.601757', '2021-04-15 12:57:53.601757', NULL),
	(10002681, 2, 'PW21A-TS100210BL-M', 0, 0, '2021-04-15 12:57:53.565650', '2021-04-15 12:57:53.565650', NULL),
	(10002682, 2, 'PW21A-TS100210BL-L', 0, 0, '2021-04-15 12:57:53.661269', '2021-04-15 12:57:53.661269', NULL),
	(10002683, 2, 'PW21A-TS100210BL-XL', 0, 0, '2021-04-15 12:57:53.594001', '2021-04-15 12:57:53.594001', NULL),
	(10002684, 2, 'PW21A-TS100210BL-XXL', 0, 0, '2021-04-15 12:57:53.573670', '2021-04-15 12:57:53.573670', NULL),
	(10002685, 2, 'PW21A-TS100211BL-XS', 0, 0, '2021-04-15 12:57:53.770028', '2021-04-15 12:57:53.770028', NULL),
	(10002686, 2, 'PW21A-TS100211BL-S', 0, 0, '2021-04-15 12:57:53.588997', '2021-04-15 12:57:53.588997', NULL),
	(10002687, 2, 'PW21A-TS100211BL-M', 0, 0, '2021-04-15 12:57:53.698936', '2021-04-15 12:57:53.698936', NULL),
	(10002688, 2, 'PW21A-TS100211BL-L', 0, 0, '2021-04-15 12:57:53.628402', '2021-04-15 12:57:53.628402', NULL),
	(10002689, 2, 'PW21A-TS100211BL-XL', 0, 0, '2021-04-15 12:57:53.575272', '2021-04-15 12:57:53.575272', NULL),
	(10002690, 2, 'PW21A-TS100211BL-XXL', 0, 0, '2021-04-15 12:57:53.574481', '2021-04-15 12:57:53.574481', NULL),
	(10002691, 2, 'PW21A-TS100212GN-XS', 0, 0, '2021-04-15 12:57:53.590634', '2021-04-15 12:57:53.590634', NULL),
	(10002692, 2, 'PW21A-TS100212GN-S', 0, 0, '2021-04-15 12:57:53.608355', '2021-04-15 12:57:53.608355', NULL),
	(10002693, 2, 'PW21A-TS100212GN-M', 1, 0, '2021-04-15 12:57:53.620122', '2021-04-15 12:57:53.620122', NULL),
	(10002694, 2, 'PW21A-TS100212GN-L', 2, 0, '2021-04-15 12:57:53.594770', '2021-04-15 12:57:53.594770', NULL),
	(10002695, 2, 'PW21A-TS100212GN-XL', 1, 0, '2021-04-15 12:57:53.589429', '2021-04-15 12:57:53.589429', NULL),
	(10002696, 2, 'PW21A-TS100212GN-XXL', 0, 0, '2021-04-15 12:57:53.595441', '2021-04-15 12:57:53.595441', NULL),
	(10002697, 2, 'PW21A-TS100213BL-XS', 0, 0, '2021-04-15 12:57:53.626399', '2021-04-15 12:57:53.626399', NULL),
	(10002698, 2, 'PW21A-TS100213BL-S', 2, 0, '2021-04-15 12:57:53.654109', '2021-04-15 12:57:53.654109', NULL),
	(10002699, 2, 'PW21A-TS100213BL-M', 4, 0, '2021-04-15 12:57:53.626919', '2021-04-15 12:57:53.626919', NULL),
	(10002700, 2, 'PW21A-TS100213BL-L', 3, 0, '2021-04-15 12:57:53.635917', '2021-04-15 12:57:53.635917', NULL),
	(10002701, 2, 'PW21A-TS100213BL-XL', 3, 0, '2021-04-15 12:57:53.602276', '2021-04-15 12:57:53.602276', NULL),
	(10002702, 2, 'PW21A-TS100213BL-XXL', 2, 0, '2021-04-15 12:57:53.619634', '2021-04-15 12:57:53.619634', NULL),
	(10002703, 2, 'PW21A-TS100214BL-XS', 0, 0, '2021-04-15 12:57:53.667032', '2021-04-15 12:57:53.667032', NULL),
	(10002704, 2, 'PW21A-TS100214BL-S', 0, 0, '2021-04-15 12:57:53.637089', '2021-04-15 12:57:53.637089', NULL),
	(10002705, 2, 'PW21A-TS100214BL-M', 0, 0, '2021-04-15 12:57:53.772502', '2021-04-15 12:57:53.772502', NULL),
	(10002706, 2, 'PW21A-TS100214BL-L', 0, 0, '2021-04-15 12:57:53.639173', '2021-04-15 12:57:53.639173', NULL),
	(10002707, 2, 'PW21A-TS100214BL-XL', 0, 0, '2021-04-15 12:57:53.646030', '2021-04-15 12:57:53.646030', NULL),
	(10002708, 2, 'PW21A-TS100214BL-XXL', 0, 0, '2021-04-15 12:57:53.663609', '2021-04-15 12:57:53.663609', NULL),
	(10002709, 2, 'PW21A-TS100215BL-XS', 0, 0, '2021-04-15 12:57:53.674526', '2021-04-15 12:57:53.674526', NULL),
	(10002710, 2, 'PW21A-TS100215BL-S', 3, 0, '2021-04-15 12:57:53.657392', '2021-04-15 12:57:53.657392', NULL),
	(10002711, 2, 'PW21A-TS100215BL-M', 3, 0, '2021-04-15 12:57:53.688163', '2021-04-15 12:57:53.688163', NULL),
	(10002712, 2, 'PW21A-TS100215BL-L', 4, 0, '2021-04-15 12:57:53.672413', '2021-04-15 12:57:53.672413', NULL),
	(10002713, 2, 'PW21A-TS100215BL-XL', 1, 0, '2021-04-15 12:57:53.656408', '2021-04-15 12:57:53.656408', NULL),
	(10002714, 2, 'PW21A-TS100215BL-XXL', 0, 0, '2021-04-15 12:57:53.694218', '2021-04-15 12:57:53.694218', NULL),
	(10002715, 2, 'PW21A-TS100216NV-XS', 0, 0, '2021-04-15 12:57:53.683352', '2021-04-15 12:57:53.683352', NULL),
	(10002716, 2, 'PW21A-TS100216NV-S', 0, 0, '2021-04-15 12:57:53.674012', '2021-04-15 12:57:53.674012', NULL),
	(10002717, 2, 'PW21A-TS100216NV-M', 1, 0, '2021-04-15 12:57:53.690116', '2021-04-15 12:57:53.690116', NULL),
	(10002718, 2, 'PW21A-TS100216NV-L', 0, 0, '2021-04-15 12:57:53.727642', '2021-04-15 12:57:53.727642', NULL),
	(10002719, 2, 'PW21A-TS100216NV-XL', 2, 0, '2021-04-15 12:57:53.690758', '2021-04-15 12:57:53.690758', NULL),
	(10002720, 2, 'PW21A-TS100216NV-XXL', 0, 0, '2021-04-15 12:57:53.699443', '2021-04-15 12:57:53.699443', NULL),
	(10002721, 2, 'PW21A-TS100217BL-XS', 0, 0, '2021-04-15 12:57:53.688769', '2021-04-15 12:57:53.688769', NULL),
	(10002722, 2, 'PW21A-TS100217BL-S', 3, 0, '2021-04-15 12:57:53.691373', '2021-04-15 12:57:53.691373', NULL),
	(10002723, 2, 'PW21A-TS100217BL-M', 1, 0, '2021-04-15 12:57:53.727185', '2021-04-15 12:57:53.727185', NULL),
	(10002724, 2, 'PW21A-TS100217BL-L', 3, 0, '2021-04-15 12:57:53.773365', '2021-04-15 12:57:53.773365', NULL),
	(10002725, 2, 'PW21A-TS100217BL-XL', 3, 0, '2021-04-15 12:57:53.733454', '2021-04-15 12:57:53.733454', NULL),
	(10002726, 2, 'PW21A-TS100217BL-XXL', 1, 0, '2021-04-15 12:57:53.719677', '2021-04-15 12:57:53.719677', NULL),
	(10002727, 2, 'PW21A-TS100218BL-XS', 0, 0, '2021-04-15 12:57:53.874051', '2021-04-15 12:57:53.874051', NULL),
	(10002728, 2, 'PW21A-TS100218BL-S', 3, 0, '2021-04-15 12:57:53.733037', '2021-04-15 12:57:53.733037', NULL),
	(10002729, 2, 'PW21A-TS100218BL-M', 4, 0, '2021-04-15 12:57:53.735997', '2021-04-15 12:57:53.735997', NULL),
	(10002730, 2, 'PW21A-TS100218BL-L', 4, 0, '2021-04-15 12:57:53.734305', '2021-04-15 12:57:53.734305', NULL),
	(10002731, 2, 'PW21A-TS100218BL-XL', 3, 0, '2021-04-15 12:57:53.733313', '2021-04-15 12:57:53.733313', NULL),
	(10002732, 2, 'PW21A-TS100218BL-XXL', 2, 0, '2021-04-15 12:57:53.733690', '2021-04-15 12:57:53.733690', NULL),
	(10002733, 2, 'PW21A-TS100219BL-XS', 0, 0, '2021-04-15 12:57:53.893472', '2021-04-15 12:57:53.893472', NULL),
	(10002734, 2, 'PW21A-TS100219BL-S', 3, 0, '2021-04-15 12:57:53.738930', '2021-04-15 12:57:53.738930', NULL),
	(10002735, 2, 'PW21A-TS100219BL-M', 4, 0, '2021-04-15 12:57:53.764709', '2021-04-15 12:57:53.764709', NULL),
	(10002736, 2, 'PW21A-TS100219BL-L', 4, 0, '2021-04-15 12:57:53.769605', '2021-04-15 12:57:53.769605', NULL),
	(10002737, 2, 'PW21A-TS100219BL-XL', 3, 0, '2021-04-15 12:57:53.772025', '2021-04-15 12:57:53.772025', NULL),
	(10002738, 2, 'PW21A-TS100219BL-XXL', 2, 0, '2021-04-15 12:57:53.766986', '2021-04-15 12:57:53.766986', NULL),
	(10002739, 2, 'PW21A-TS100220BL-XS', 0, 0, '2021-04-15 12:57:53.776030', '2021-04-15 12:57:53.776030', NULL),
	(10002740, 2, 'PW21A-TS100220BL-S', 4, 0, '2021-04-15 12:57:53.767458', '2021-04-15 12:57:53.767458', NULL),
	(10002741, 2, 'PW21A-TS100220BL-M', 3, 0, '2021-04-15 12:57:53.802067', '2021-04-15 12:57:53.802067', NULL),
	(10002742, 2, 'PW21A-TS100220BL-L', 4, 0, '2021-04-15 12:57:53.772938', '2021-04-15 12:57:53.772938', NULL),
	(10002743, 2, 'PW21A-TS100220BL-XL', 2, 0, '2021-04-15 12:57:53.795069', '2021-04-15 12:57:53.795069', NULL),
	(10002744, 2, 'PW21A-TS100220BL-XXL', 2, 0, '2021-04-15 12:57:53.824823', '2021-04-15 12:57:53.824823', NULL),
	(10002745, 2, 'PW21A-TK100221BL-XS', 0, 0, '2021-04-15 12:57:53.797147', '2021-04-15 12:57:53.797147', NULL),
	(10002746, 2, 'PW21A-TK100221BL-S', 2, 0, '2021-04-15 12:57:53.803657', '2021-04-15 12:57:53.803657', NULL),
	(10002747, 2, 'PW21A-TK100221BL-M', 2, 0, '2021-04-15 12:57:53.805539', '2021-04-15 12:57:53.805539', NULL),
	(10002748, 2, 'PW21A-TK100221BL-L', 2, 0, '2021-04-15 12:57:53.807304', '2021-04-15 12:57:53.807304', NULL),
	(10002749, 2, 'PW21A-TK100221BL-XL', 2, 0, '2021-04-15 12:57:53.804992', '2021-04-15 12:57:53.804992', NULL),
	(10002750, 2, 'PW21A-TK100221BL-XXL', 2, 0, '2021-04-15 12:57:53.843988', '2021-04-15 12:57:53.843988', NULL),
	(10002751, 2, 'PW21A-TS100222BL-XS', 0, 0, '2021-04-15 12:57:53.806739', '2021-04-15 12:57:53.806739', NULL),
	(10002752, 2, 'PW21A-TS100222BL-S', 3, 0, '2021-04-15 12:57:53.809366', '2021-04-15 12:57:53.809366', NULL),
	(10002753, 2, 'PW21A-TS100222BL-M', 4, 0, '2021-04-15 12:57:53.810768', '2021-04-15 12:57:53.810768', NULL),
	(10002754, 2, 'PW21A-TS100222BL-L', 4, 0, '2021-04-15 12:57:53.826360', '2021-04-15 12:57:53.826360', NULL),
	(10002755, 2, 'PW21A-TS100222BL-XL', 3, 0, '2021-04-15 12:57:53.873333', '2021-04-15 12:57:53.873333', NULL),
	(10002756, 2, 'PW21A-TS100222BL-XXL', 2, 0, '2021-04-15 12:57:53.842314', '2021-04-15 12:57:53.842314', NULL),
	(10002757, 2, 'PW21A-TS100223BL-XS', 0, 0, '2021-04-15 12:57:53.833320', '2021-04-15 12:57:53.833320', NULL),
	(10002758, 2, 'PW21A-TS100223BL-S', 4, 0, '2021-04-15 12:57:53.858937', '2021-04-15 12:57:53.858937', NULL),
	(10002759, 2, 'PW21A-TS100223BL-M', 1, 0, '2021-04-15 12:57:53.836745', '2021-04-15 12:57:53.836745', NULL),
	(10002760, 2, 'PW21A-TS100223BL-L', 4, 0, '2021-04-15 12:57:53.843380', '2021-04-15 12:57:53.843380', NULL),
	(10002761, 2, 'PW21A-TS100223BL-XL', 2, 0, '2021-04-15 12:57:53.841742', '2021-04-15 12:57:53.841742', NULL),
	(10002762, 2, 'PW21A-TS100223BL-XXL', 2, 0, '2021-04-15 12:57:53.839118', '2021-04-15 12:57:53.839118', NULL),
	(10002763, 2, 'PW21A-TK100224BL-XS', 0, 0, '2021-04-15 12:57:53.985587', '2021-04-15 12:57:53.985587', NULL),
	(10002764, 2, 'PW21A-TK100224BL-S', 0, 0, '2021-04-15 12:57:53.842842', '2021-04-15 12:57:53.842842', NULL),
	(10002765, 2, 'PW21A-TK100224BL-M', 2, 0, '2021-04-15 12:57:53.989204', '2021-04-15 12:57:53.989204', NULL),
	(10002766, 2, 'PW21A-TK100224BL-L', 2, 0, '2021-04-15 12:57:53.885313', '2021-04-15 12:57:53.885313', NULL),
	(10002767, 2, 'PW21A-TK100224BL-XL', 2, 0, '2021-04-15 12:57:53.857200', '2021-04-15 12:57:53.857200', NULL),
	(10002768, 2, 'PW21A-TK100224BL-XXL', 1, 0, '2021-04-15 12:57:53.867450', '2021-04-15 12:57:53.867450', NULL),
	(10002769, 2, 'PW21A-TK100225BL-XS', 0, 0, '2021-04-15 12:57:54.012410', '2021-04-15 12:57:54.012410', NULL),
	(10002770, 2, 'PW21A-TK100225BL-S', 0, 0, '2021-04-15 12:57:53.872817', '2021-04-15 12:57:53.872817', NULL),
	(10002771, 2, 'PW21A-TK100225BL-M', 2, 0, '2021-04-15 12:57:53.873702', '2021-04-15 12:57:53.873702', NULL),
	(10002772, 2, 'PW21A-TK100225BL-L', 2, 0, '2021-04-15 12:57:53.883795', '2021-04-15 12:57:53.883795', NULL),
	(10002773, 2, 'PW21A-TK100225BL-XL', 2, 0, '2021-04-15 12:57:53.863666', '2021-04-15 12:57:53.863666', NULL),
	(10002774, 2, 'PW21A-TK100225BL-XXL', 0, 0, '2021-04-15 12:57:53.996366', '2021-04-15 12:57:53.996366', NULL),
	(10002775, 2, 'PW21A-TS100226BL-XS', 0, 0, '2021-04-15 12:57:53.893070', '2021-04-15 12:57:53.893070', NULL),
	(10002776, 2, 'PW21A-TS100226BL-S', 3, 0, '2021-04-15 12:57:53.874435', '2021-04-15 12:57:53.874435', NULL),
	(10002777, 2, 'PW21A-TS100226BL-M', 2, 0, '2021-04-15 12:57:53.892114', '2021-04-15 12:57:53.892114', NULL),
	(10002778, 2, 'PW21A-TS100226BL-L', 4, 0, '2021-04-15 12:57:53.893828', '2021-04-15 12:57:53.893828', NULL),
	(10002779, 2, 'PW21A-TS100226BL-XL', 3, 0, '2021-04-15 12:57:53.894182', '2021-04-15 12:57:53.894182', NULL),
	(10002780, 2, 'PW21A-TS100226BL-XXL', 1, 0, '2021-04-15 12:57:53.875461', '2021-04-15 12:57:53.875461', NULL),
	(10002781, 2, 'PW21A-TK100227BL-XS', 0, 0, '2021-04-15 12:57:53.887886', '2021-04-15 12:57:53.887886', NULL),
	(10002782, 2, 'PW21A-TK100227BL-S', 2, 0, '2021-04-15 12:57:53.895423', '2021-04-15 12:57:53.895423', NULL),
	(10002783, 2, 'PW21A-TK100227BL-M', 2, 0, '2021-04-15 12:57:53.926245', '2021-04-15 12:57:53.926245', NULL),
	(10002784, 2, 'PW21A-TK100227BL-L', 2, 0, '2021-04-15 12:57:53.906244', '2021-04-15 12:57:53.906244', NULL),
	(10002785, 2, 'PW21A-TK100227BL-XL', 2, 0, '2021-04-15 12:57:53.895085', '2021-04-15 12:57:53.895085', NULL),
	(10002786, 2, 'PW21A-TK100227BL-XXL', 2, 0, '2021-04-15 12:57:53.905615', '2021-04-15 12:57:53.905615', NULL),
	(10002787, 2, 'PW21A-TS100228BL-XS', 0, 0, '2021-04-15 12:57:53.925577', '2021-04-15 12:57:53.925577', NULL),
	(10002788, 2, 'PW21A-TS100228BL-S', 3, 0, '2021-04-15 12:57:53.934406', '2021-04-15 12:57:53.934406', NULL),
	(10002789, 2, 'PW21A-TS100228BL-M', 4, 0, '2021-04-15 12:57:53.906580', '2021-04-15 12:57:53.906580', NULL),
	(10002790, 2, 'PW21A-TS100228BL-L', 4, 0, '2021-04-15 12:57:53.913602', '2021-04-15 12:57:53.913602', NULL),
	(10002791, 2, 'PW21A-TS100228BL-XL', 3, 0, '2021-04-15 12:57:53.937059', '2021-04-15 12:57:53.937059', NULL),
	(10002792, 2, 'PW21A-TS100228BL-XXL', 2, 0, '2021-04-15 12:57:53.944835', '2021-04-15 12:57:53.944835', NULL),
	(10002793, 2, 'PW21A-TK100229BL-XS', 0, 0, '2021-04-15 12:57:53.958551', '2021-04-15 12:57:53.958551', NULL),
	(10002794, 2, 'PW21A-TK100229BL-S', 2, 0, '2021-04-15 12:57:54.027515', '2021-04-15 12:57:54.027515', NULL),
	(10002795, 2, 'PW21A-TK100229BL-M', 2, 0, '2021-04-15 12:57:53.939227', '2021-04-15 12:57:53.939227', NULL),
	(10002796, 2, 'PW21A-TK100229BL-L', 2, 0, '2021-04-15 12:57:53.957175', '2021-04-15 12:57:53.957175', NULL),
	(10002797, 2, 'PW21A-TK100229BL-XL', 2, 0, '2021-04-15 12:57:53.959630', '2021-04-15 12:57:53.959630', NULL),
	(10002798, 2, 'PW21A-TK100229BL-XXL', 2, 0, '2021-04-15 12:57:53.967851', '2021-04-15 12:57:53.967851', NULL),
	(10002799, 2, 'PW21A-TK100230BL-XS', 0, 0, '2021-04-15 12:57:53.972688', '2021-04-15 12:57:53.972688', NULL),
	(10002800, 2, 'PW21A-TK100230BL-S', 1, 0, '2021-04-15 12:57:53.971827', '2021-04-15 12:57:53.971827', NULL),
	(10002801, 2, 'PW21A-TK100230BL-M', 2, 0, '2021-04-15 12:57:53.973064', '2021-04-15 12:57:53.973064', NULL),
	(10002802, 2, 'PW21A-TK100230BL-L', 2, 0, '2021-04-15 12:57:53.973814', '2021-04-15 12:57:53.973814', NULL),
	(10002803, 2, 'PW21A-TK100230BL-XL', 2, 0, '2021-04-15 12:57:53.974818', '2021-04-15 12:57:53.974818', NULL),
	(10002804, 2, 'PW21A-TK100230BL-XXL', 1, 0, '2021-04-15 12:57:53.983821', '2021-04-15 12:57:53.983821', NULL),
	(10002805, 2, 'PW21A-TS100231BL-XS', 0, 0, '2021-04-15 12:57:53.994052', '2021-04-15 12:57:53.994052', NULL),
	(10002806, 2, 'PW21A-TS100231BL-S', 0, 0, '2021-04-15 12:57:53.975145', '2021-04-15 12:57:53.975145', NULL),
	(10002807, 2, 'PW21A-TS100231BL-M', 0, 0, '2021-04-15 12:57:53.985250', '2021-04-15 12:57:53.985250', NULL),
	(10002808, 2, 'PW21A-TS100231BL-L', 0, 0, '2021-04-15 12:57:54.131428', '2021-04-15 12:57:54.131428', NULL),
	(10002809, 2, 'PW21A-TS100231BL-XL', 0, 0, '2021-04-15 12:57:53.993709', '2021-04-15 12:57:53.993709', NULL),
	(10002810, 2, 'PW21A-TS100231BL-XXL', 0, 0, '2021-04-15 12:57:53.995877', '2021-04-15 12:57:53.995877', NULL),
	(10002811, 2, 'PW21A-TK100232GN-XS', 0, 0, '2021-04-15 12:57:54.008027', '2021-04-15 12:57:54.008027', NULL),
	(10002812, 2, 'PW21A-TK100232GN-S', 0, 0, '2021-04-15 12:57:54.026627', '2021-04-15 12:57:54.026627', NULL),
	(10002813, 2, 'PW21A-TK100232GN-M', 0, 0, '2021-04-15 12:57:53.996732', '2021-04-15 12:57:53.996732', NULL),
	(10002814, 2, 'PW21A-TK100232GN-L', 0, 0, '2021-04-15 12:57:54.008538', '2021-04-15 12:57:54.008538', NULL),
	(10002815, 2, 'PW21A-TK100232GN-XL', 0, 0, '2021-04-15 12:57:54.000639', '2021-04-15 12:57:54.000639', NULL),
	(10002816, 2, 'PW21A-TK100232GN-XXL', 0, 0, '2021-04-15 12:57:54.086523', '2021-04-15 12:57:54.086523', NULL),
	(10002817, 2, 'PW21A-TS100233BL-XS', 0, 0, '2021-04-15 12:57:54.030177', '2021-04-15 12:57:54.030177', NULL),
	(10002818, 2, 'PW21A-TS100233BL-S', 0, 0, '2021-04-15 12:57:54.036842', '2021-04-15 12:57:54.036842', NULL),
	(10002819, 2, 'PW21A-TS100233BL-M', 0, 0, '2021-04-15 12:57:54.020287', '2021-04-15 12:57:54.020287', NULL),
	(10002820, 2, 'PW21A-TS100233BL-L', 0, 0, '2021-04-15 12:57:54.142834', '2021-04-15 12:57:54.142834', NULL),
	(10002821, 2, 'PW21A-TS100233BL-XL', 0, 0, '2021-04-15 12:57:54.024632', '2021-04-15 12:57:54.024632', NULL),
	(10002822, 2, 'PW21A-TS100233BL-XXL', 0, 0, '2021-04-15 12:57:54.038829', '2021-04-15 12:57:54.038829', NULL),
	(10002823, 2, 'PW21A-TK100234BL-XS', 0, 0, '2021-04-15 12:57:54.030510', '2021-04-15 12:57:54.030510', NULL),
	(10002824, 2, 'PW21A-TK100234BL-S', 0, 0, '2021-04-15 12:57:54.114511', '2021-04-15 12:57:54.114511', NULL),
	(10002825, 2, 'PW21A-TK100234BL-M', 0, 0, '2021-04-15 12:57:54.045448', '2021-04-15 12:57:54.045448', NULL),
	(10002826, 2, 'PW21A-TK100234BL-L', 0, 0, '2021-04-15 12:57:54.027085', '2021-04-15 12:57:54.027085', NULL),
	(10002827, 2, 'PW21A-TK100234BL-XL', 1, 0, '2021-04-15 12:57:54.148659', '2021-04-15 12:57:54.148659', NULL),
	(10002828, 2, 'PW21A-TK100234BL-XXL', 0, 0, '2021-04-15 12:57:54.051698', '2021-04-15 12:57:54.051698', NULL),
	(10002829, 2, 'PW21A-TS100235BL-XS', 0, 0, '2021-04-15 12:57:54.048315', '2021-04-15 12:57:54.048315', NULL),
	(10002830, 2, 'PW21A-TS100235BL-S', 3, 0, '2021-04-15 12:57:54.039426', '2021-04-15 12:57:54.039426', NULL),
	(10002831, 2, 'PW21A-TS100235BL-M', 4, 0, '2021-04-15 12:57:54.062550', '2021-04-15 12:57:54.062550', NULL),
	(10002832, 2, 'PW21A-TS100235BL-L', 4, 0, '2021-04-15 12:57:54.050599', '2021-04-15 12:57:54.050599', NULL),
	(10002833, 2, 'PW21A-TS100235BL-XL', 3, 0, '2021-04-15 12:57:54.042570', '2021-04-15 12:57:54.042570', NULL),
	(10002834, 2, 'PW21A-TS100235BL-XXL', 2, 0, '2021-04-15 12:57:54.050243', '2021-04-15 12:57:54.050243', NULL),
	(10002835, 2, 'PW21A-TK100236WT-XS', 0, 0, '2021-04-15 12:57:54.057660', '2021-04-15 12:57:54.057660', NULL),
	(10002836, 2, 'PW21A-TK100236WT-S', 0, 0, '2021-04-15 12:57:54.065701', '2021-04-15 12:57:54.065701', NULL),
	(10002837, 2, 'PW21A-TK100236WT-M', 2, 0, '2021-04-15 12:57:54.049339', '2021-04-15 12:57:54.049339', NULL),
	(10002838, 2, 'PW21A-TK100236WT-L', 2, 0, '2021-04-15 12:57:54.077622', '2021-04-15 12:57:54.077622', NULL),
	(10002839, 2, 'PW21A-TK100236WT-XL', 2, 0, '2021-04-15 12:57:54.067864', '2021-04-15 12:57:54.067864', NULL),
	(10002840, 2, 'PW21A-TK100236WT-XXL', 2, 0, '2021-04-15 12:57:54.070981', '2021-04-15 12:57:54.070981', NULL),
	(10002841, 2, 'PW21A-TS100237BL-XS', 0, 0, '2021-04-15 12:57:54.063577', '2021-04-15 12:57:54.063577', NULL),
	(10002842, 2, 'PW21A-TS100237BL-S', 0, 0, '2021-04-15 12:57:54.073922', '2021-04-15 12:57:54.073922', NULL),
	(10002843, 2, 'PW21A-TS100237BL-M', 0, 0, '2021-04-15 12:57:54.074247', '2021-04-15 12:57:54.074247', NULL),
	(10002844, 2, 'PW21A-TS100237BL-L', 0, 0, '2021-04-15 12:57:54.094518', '2021-04-15 12:57:54.094518', NULL),
	(10002845, 2, 'PW21A-TS100237BL-XL', 0, 0, '2021-04-15 12:57:54.072262', '2021-04-15 12:57:54.072262', NULL),
	(10002846, 2, 'PW21A-TS100237BL-XXL', 0, 0, '2021-04-15 12:57:54.072655', '2021-04-15 12:57:54.072655', NULL),
	(10002847, 2, 'PW21A-TS100238BL-XS', 0, 0, '2021-04-15 12:57:54.086207', '2021-04-15 12:57:54.086207', NULL),
	(10002848, 2, 'PW21A-TS100238BL-S', 0, 0, '2021-04-15 12:57:54.083973', '2021-04-15 12:57:54.083973', NULL),
	(10002849, 2, 'PW21A-TS100238BL-M', 0, 0, '2021-04-15 12:57:54.083613', '2021-04-15 12:57:54.083613', NULL),
	(10002850, 2, 'PW21A-TS100238BL-L', 0, 0, '2021-04-15 12:57:54.097020', '2021-04-15 12:57:54.097020', NULL),
	(10002851, 2, 'PW21A-TS100238BL-XL', 0, 0, '2021-04-15 12:57:54.092397', '2021-04-15 12:57:54.092397', NULL),
	(10002852, 2, 'PW21A-TS100238BL-XXL', 0, 0, '2021-04-15 12:57:54.092680', '2021-04-15 12:57:54.092680', NULL),
	(10002853, 2, 'PW21A-TK100239OG-XS', 0, 0, '2021-04-15 12:57:54.105688', '2021-04-15 12:57:54.105688', NULL),
	(10002854, 2, 'PW21A-TK100239OG-S', 1, 0, '2021-04-15 12:57:54.095286', '2021-04-15 12:57:54.095286', NULL),
	(10002855, 2, 'PW21A-TK100239OG-M', 2, 0, '2021-04-15 12:57:54.094852', '2021-04-15 12:57:54.094852', NULL),
	(10002856, 2, 'PW21A-TK100239OG-L', 1, 0, '2021-04-15 12:57:54.112897', '2021-04-15 12:57:54.112897', NULL),
	(10002857, 2, 'PW21A-TK100239OG-XL', 2, 0, '2021-04-15 12:57:54.107170', '2021-04-15 12:57:54.107170', NULL),
	(10002858, 2, 'PW21A-TK100239OG-XXL', 2, 0, '2021-04-15 12:57:54.104097', '2021-04-15 12:57:54.104097', NULL),
	(10002859, 2, 'PW21A-TK100240OG-XS', 0, 0, '2021-04-15 12:57:54.106027', '2021-04-15 12:57:54.106027', NULL),
	(10002860, 2, 'PW21A-TK100240OG-S', 0, 0, '2021-04-15 12:57:54.116504', '2021-04-15 12:57:54.116504', NULL),
	(10002861, 2, 'PW21A-TK100240OG-M', 0, 0, '2021-04-15 12:57:54.138796', '2021-04-15 12:57:54.138796', NULL),
	(10002862, 2, 'PW21A-TK100240OG-L', 2, 0, '2021-04-15 12:57:54.222947', '2021-04-15 12:57:54.222947', NULL),
	(10002863, 2, 'PW21A-TK100240OG-XL', 1, 0, '2021-04-15 12:57:54.115951', '2021-04-15 12:57:54.115951', NULL),
	(10002864, 2, 'PW21A-TK100240OG-XXL', 2, 0, '2021-04-15 12:57:54.118280', '2021-04-15 12:57:54.118280', NULL),
	(10002865, 2, 'PW21A-TS100241YW -XS', 0, 0, '2021-04-15 12:57:54.117742', '2021-04-15 12:57:54.117742', NULL),
	(10002866, 2, 'PW21A-TS100241YW -S', 1, 0, '2021-04-15 12:57:54.131744', '2021-04-15 12:57:54.131744', NULL),
	(10002867, 2, 'PW21A-TS100241YW -M', 0, 0, '2021-04-15 12:57:54.129175', '2021-04-15 12:57:54.129175', NULL),
	(10002868, 2, 'PW21A-TS100241YW -L', 0, 0, '2021-04-15 12:57:54.149366', '2021-04-15 12:57:54.149366', NULL),
	(10002869, 2, 'PW21A-TS100241YW -XL', 1, 0, '2021-04-15 12:57:54.131089', '2021-04-15 12:57:54.131089', NULL),
	(10002870, 2, 'PW21A-TS100241YW -XXL', 2, 0, '2021-04-15 12:57:54.141500', '2021-04-15 12:57:54.141500', NULL),
	(10002871, 2, 'PW21A-TS100242BL-XS', 0, 0, '2021-04-15 12:57:54.263488', '2021-04-15 12:57:54.263488', NULL),
	(10002872, 2, 'PW21A-TS100242BL-S', 3, 0, '2021-04-15 12:57:54.162952', '2021-04-15 12:57:54.162952', NULL),
	(10002873, 2, 'PW21A-TS100242BL-M', 4, 0, '2021-04-15 12:57:54.140256', '2021-04-15 12:57:54.140256', NULL),
	(10002874, 2, 'PW21A-TS100242BL-L', 4, 0, '2021-04-15 12:57:54.139966', '2021-04-15 12:57:54.139966', NULL),
	(10002875, 2, 'PW21A-TS100242BL-XL', 3, 0, '2021-04-15 12:57:54.139657', '2021-04-15 12:57:54.139657', NULL),
	(10002876, 2, 'PW21A-TS100242BL-XXL', 2, 0, '2021-04-15 12:57:54.158798', '2021-04-15 12:57:54.158798', NULL),
	(10002877, 2, 'PW21A-TK100243BL-XS', 0, 0, '2021-04-15 12:57:54.158040', '2021-04-15 12:57:54.158040', NULL),
	(10002878, 2, 'PW21A-TK100243BL-S', 2, 0, '2021-04-15 12:57:54.261117', '2021-04-15 12:57:54.261117', NULL),
	(10002879, 2, 'PW21A-TK100243BL-M', 2, 0, '2021-04-15 12:57:54.150628', '2021-04-15 12:57:54.150628', NULL),
	(10002880, 2, 'PW21A-TK100243BL-L', 2, 0, '2021-04-15 12:57:54.363803', '2021-04-15 12:57:54.363803', NULL),
	(10002881, 2, 'PW21A-TK100243BL-XL', 2, 0, '2021-04-15 12:57:54.149682', '2021-04-15 12:57:54.149682', NULL),
	(10002882, 2, 'PW21A-TK100243BL-XXL', 2, 0, '2021-04-15 12:57:54.171944', '2021-04-15 12:57:54.171944', NULL),
	(10002883, 2, 'PW21A-TS100244BL-XS', 0, 0, '2021-04-15 12:57:54.165562', '2021-04-15 12:57:54.165562', NULL),
	(10002884, 2, 'PW21A-TS100244BL-S', 0, 0, '2021-04-15 12:57:54.159086', '2021-04-15 12:57:54.159086', NULL),
	(10002885, 2, 'PW21A-TS100244BL-M', 0, 0, '2021-04-15 12:57:54.161640', '2021-04-15 12:57:54.161640', NULL),
	(10002886, 2, 'PW21A-TS100244BL-L', 0, 0, '2021-04-15 12:57:54.175904', '2021-04-15 12:57:54.175904', NULL),
	(10002887, 2, 'PW21A-TS100244BL-XL', 0, 0, '2021-04-15 12:57:54.175131', '2021-04-15 12:57:54.175131', NULL),
	(10002888, 2, 'PW21A-TS100244BL-XXL', 0, 0, '2021-04-15 12:57:54.173928', '2021-04-15 12:57:54.173928', NULL),
	(10002889, 2, 'PW21A-TS100245RD-XS', 0, 0, '2021-04-15 12:57:54.196190', '2021-04-15 12:57:54.196190', NULL),
	(10002890, 2, 'PW21A-TS100245RD-S', 3, 0, '2021-04-15 12:57:54.195224', '2021-04-15 12:57:54.195224', NULL),
	(10002891, 2, 'PW21A-TS100245RD-M', 4, 0, '2021-04-15 12:57:54.191549', '2021-04-15 12:57:54.191549', NULL),
	(10002892, 2, 'PW21A-TS100245RD-L', 4, 0, '2021-04-15 12:57:54.194300', '2021-04-15 12:57:54.194300', NULL),
	(10002893, 2, 'PW21A-TS100245RD-XL', 4, 0, '2021-04-15 12:57:54.198568', '2021-04-15 12:57:54.198568', NULL),
	(10002894, 2, 'PW21A-TS100245RD-XXL', 2, 0, '2021-04-15 12:57:54.212412', '2021-04-15 12:57:54.212412', NULL),
	(10002895, 2, 'PW21A-TK100246BL-XS', 0, 0, '2021-04-15 12:57:54.211862', '2021-04-15 12:57:54.211862', NULL),
	(10002896, 2, 'PW21A-TK100246BL-S', 1, 0, '2021-04-15 12:57:54.212828', '2021-04-15 12:57:54.212828', NULL),
	(10002897, 2, 'PW21A-TK100246BL-M', 2, 0, '2021-04-15 12:57:54.205043', '2021-04-15 12:57:54.205043', NULL),
	(10002898, 2, 'PW21A-TK100246BL-L', 2, 0, '2021-04-15 12:57:54.218928', '2021-04-15 12:57:54.218928', NULL),
	(10002899, 2, 'PW21A-TK100246BL-XL', 2, 0, '2021-04-15 12:57:54.209980', '2021-04-15 12:57:54.209980', NULL),
	(10002900, 2, 'PW21A-TK100246BL-XXL', 0, 0, '2021-04-15 12:57:54.220723', '2021-04-15 12:57:54.220723', NULL),
	(10002901, 2, 'PW21A-TS100247NV-XS', 0, 0, '2021-04-15 12:57:54.339132', '2021-04-15 12:57:54.339132', NULL),
	(10002902, 2, 'PW21A-TS100247NV-S', 3, 0, '2021-04-15 12:57:54.221463', '2021-04-15 12:57:54.221463', NULL),
	(10002903, 2, 'PW21A-TS100247NV-M', 3, 0, '2021-04-15 12:57:54.233498', '2021-04-15 12:57:54.233498', NULL),
	(10002904, 2, 'PW21A-TS100247NV-L', 2, 0, '2021-04-15 12:57:54.223398', '2021-04-15 12:57:54.223398', NULL),
	(10002905, 2, 'PW21A-TS100247NV-XL', 1, 0, '2021-04-15 12:57:54.226186', '2021-04-15 12:57:54.226186', NULL),
	(10002906, 2, 'PW21A-TS100247NV-XXL', 0, 0, '2021-04-15 12:57:54.232508', '2021-04-15 12:57:54.232508', NULL),
	(10002907, 2, 'PW21A-TS100248BL-XS', 0, 0, '2021-04-15 12:57:54.250627', '2021-04-15 12:57:54.250627', NULL),
	(10002908, 2, 'PW21A-TS100248BL-S', 3, 0, '2021-04-15 12:57:54.235415', '2021-04-15 12:57:54.235415', NULL),
	(10002909, 2, 'PW21A-TS100248BL-M', 4, 0, '2021-04-15 12:57:54.242249', '2021-04-15 12:57:54.242249', NULL),
	(10002910, 2, 'PW21A-TS100248BL-L', 4, 0, '2021-04-15 12:57:54.233021', '2021-04-15 12:57:54.233021', NULL),
	(10002911, 2, 'PW21A-TS100248BL-XL', 3, 0, '2021-04-15 12:57:54.252850', '2021-04-15 12:57:54.252850', NULL),
	(10002912, 2, 'PW21A-TS100248BL-XXL', 2, 0, '2021-04-15 12:57:54.260556', '2021-04-15 12:57:54.260556', NULL),
	(10002913, 2, 'PW21A-TK100249WT-XS', 0, 0, '2021-04-15 12:57:54.255039', '2021-04-15 12:57:54.255039', NULL),
	(10002914, 2, 'PW21A-TK100249WT-S', 1, 0, '2021-04-15 12:57:54.252077', '2021-04-15 12:57:54.252077', NULL),
	(10002915, 2, 'PW21A-TK100249WT-M', 2, 0, '2021-04-15 12:57:54.260851', '2021-04-15 12:57:54.260851', NULL),
	(10002916, 2, 'PW21A-TK100249WT-L', 2, 0, '2021-04-15 12:57:54.255322', '2021-04-15 12:57:54.255322', NULL),
	(10002917, 2, 'PW21A-TK100249WT-XL', 1, 0, '2021-04-15 12:57:54.272747', '2021-04-15 12:57:54.272747', NULL),
	(10002918, 2, 'PW21A-TK100249WT-XXL', 1, 0, '2021-04-15 12:57:54.269706', '2021-04-15 12:57:54.269706', NULL),
	(10002919, 2, 'PW21A-TS100250WT-XS', 0, 0, '2021-04-15 12:57:54.266366', '2021-04-15 12:57:54.266366', NULL),
	(10002920, 2, 'PW21A-TS100250WT-S', 3, 0, '2021-04-15 12:57:54.274197', '2021-04-15 12:57:54.274197', NULL),
	(10002921, 2, 'PW21A-TS100250WT-M', 5, 0, '2021-04-15 12:57:54.288697', '2021-04-15 12:57:54.288697', NULL),
	(10002922, 2, 'PW21A-TS100250WT-L', 4, 0, '2021-04-15 12:57:54.271502', '2021-04-15 12:57:54.271502', NULL),
	(10002923, 2, 'PW21A-TS100250WT-XL', 3, 0, '2021-04-15 12:57:54.291925', '2021-04-15 12:57:54.291925', NULL),
	(10002924, 2, 'PW21A-TS100250WT-XXL', 0, 0, '2021-04-15 12:57:54.275412', '2021-04-15 12:57:54.275412', NULL),
	(10002925, 2, 'PW21A-TS100251BL-XS', 0, 0, '2021-04-15 12:57:54.286916', '2021-04-15 12:57:54.286916', NULL),
	(10002926, 2, 'PW21A-TS100251BL-S', 3, 0, '2021-04-15 12:57:54.362016', '2021-04-15 12:57:54.362016', NULL),
	(10002927, 2, 'PW21A-TS100251BL-M', 4, 0, '2021-04-15 12:57:54.288199', '2021-04-15 12:57:54.288199', NULL),
	(10002928, 2, 'PW21A-TS100251BL-L', 4, 0, '2021-04-15 12:57:54.303297', '2021-04-15 12:57:54.303297', NULL),
	(10002929, 2, 'PW21A-TS100251BL-XL', 3, 0, '2021-04-15 12:57:54.295314', '2021-04-15 12:57:54.295314', NULL),
	(10002930, 2, 'PW21A-TS100251BL-XXL', 2, 0, '2021-04-15 12:57:54.302356', '2021-04-15 12:57:54.302356', NULL),
	(10002931, 2, 'PW21A-TS100252WT-XS', 0, 0, '2021-04-15 12:57:54.290216', '2021-04-15 12:57:54.290216', NULL),
	(10002932, 2, 'PW21A-TS100252WT-S', 3, 0, '2021-04-15 12:57:54.299546', '2021-04-15 12:57:54.299546', NULL),
	(10002933, 2, 'PW21A-TS100252WT-M', 4, 0, '2021-04-15 12:57:54.301881', '2021-04-15 12:57:54.301881', NULL),
	(10002934, 2, 'PW21A-TS100252WT-L', 4, 0, '2021-04-15 12:57:54.315710', '2021-04-15 12:57:54.315710', NULL),
	(10002935, 2, 'PW21A-TS100252WT-XL', 3, 0, '2021-04-15 12:57:54.341163', '2021-04-15 12:57:54.341163', NULL),
	(10002936, 2, 'PW21A-TS100252WT-XXL', 2, 0, '2021-04-15 12:57:54.329134', '2021-04-15 12:57:54.329134', NULL),
	(10002937, 2, 'PW21A-TS100253BL-XS', 0, 0, '2021-04-15 12:57:54.313412', '2021-04-15 12:57:54.313412', NULL),
	(10002938, 2, 'PW21A-TS100253BL-S', 3, 0, '2021-04-15 12:57:54.319248', '2021-04-15 12:57:54.319248', NULL),
	(10002939, 2, 'PW21A-TS100253BL-M', 4, 0, '2021-04-15 12:57:54.338846', '2021-04-15 12:57:54.338846', NULL),
	(10002940, 2, 'PW21A-TS100253BL-L', 4, 0, '2021-04-15 12:57:54.321573', '2021-04-15 12:57:54.321573', NULL),
	(10002941, 2, 'PW21A-TS100253BL-XL', 3, 0, '2021-04-15 12:57:54.321949', '2021-04-15 12:57:54.321949', NULL),
	(10002942, 2, 'PW21A-TS100253BL-XXL', 2, 0, '2021-04-15 12:57:54.317347', '2021-04-15 12:57:54.317347', NULL),
	(10002943, 2, 'PW21A-TK100254BL-XS', 0, 0, '2021-04-15 12:57:54.430354', '2021-04-15 12:57:54.430354', NULL),
	(10002944, 2, 'PW21A-TK100254BL-S', 1, 0, '2021-04-15 12:57:54.329855', '2021-04-15 12:57:54.329855', NULL),
	(10002945, 2, 'PW21A-TK100254BL-M', 2, 0, '2021-04-15 12:57:54.332593', '2021-04-15 12:57:54.332593', NULL),
	(10002946, 2, 'PW21A-TK100254BL-L', 2, 0, '2021-04-15 12:57:54.333010', '2021-04-15 12:57:54.333010', NULL),
	(10002947, 2, 'PW21A-TK100254BL-XL', 2, 0, '2021-04-15 12:57:54.340857', '2021-04-15 12:57:54.340857', NULL),
	(10002948, 2, 'PW21A-TK100254BL-XXL', 1, 0, '2021-04-15 12:57:54.437784', '2021-04-15 12:57:54.437784', NULL),
	(10002949, 2, 'PW21A-TS100255BL-XS', 0, 0, '2021-04-15 12:57:54.343744', '2021-04-15 12:57:54.343744', NULL),
	(10002950, 2, 'PW21A-TS100255BL-S', 4, 0, '2021-04-15 12:57:54.352231', '2021-04-15 12:57:54.352231', NULL),
	(10002951, 2, 'PW21A-TS100255BL-M', 4, 0, '2021-04-15 12:57:54.342272', '2021-04-15 12:57:54.342272', NULL),
	(10002952, 2, 'PW21A-TS100255BL-L', 5, 0, '2021-04-15 12:57:54.445110', '2021-04-15 12:57:54.445110', NULL),
	(10002953, 2, 'PW21A-TS100255BL-XL', 3, 0, '2021-04-15 12:57:54.355949', '2021-04-15 12:57:54.355949', NULL),
	(10002954, 2, 'PW21A-TS100255BL-XXL', 2, 0, '2021-04-15 12:57:54.355366', '2021-04-15 12:57:54.355366', NULL),
	(10002955, 2, 'PW21A-TK100256BL-XS', 0, 0, '2021-04-15 12:57:54.353238', '2021-04-15 12:57:54.353238', NULL),
	(10002956, 2, 'PW21A-TK100256BL-S', 0, 0, '2021-04-15 12:57:54.365690', '2021-04-15 12:57:54.365690', NULL),
	(10002957, 2, 'PW21A-TK100256BL-M', 2, 0, '2021-04-15 12:57:54.372153', '2021-04-15 12:57:54.372153', NULL),
	(10002958, 2, 'PW21A-TK100256BL-L', 2, 0, '2021-04-15 12:57:54.366531', '2021-04-15 12:57:54.366531', NULL),
	(10002959, 2, 'PW21A-TK100256BL-XL', 2, 0, '2021-04-15 12:57:54.380417', '2021-04-15 12:57:54.380417', NULL),
	(10002960, 2, 'PW21A-TK100256BL-XXL', 2, 0, '2021-04-15 12:57:54.371843', '2021-04-15 12:57:54.371843', NULL),
	(10002961, 2, 'PW21A-TS100257WT-XS', 0, 0, '2021-04-15 12:57:54.382813', '2021-04-15 12:57:54.382813', NULL),
	(10002962, 2, 'PW21A-TS100257WT-S', 0, 0, '2021-04-15 12:57:54.380783', '2021-04-15 12:57:54.380783', NULL),
	(10002963, 2, 'PW21A-TS100257WT-M', 0, 0, '2021-04-15 12:57:54.386189', '2021-04-15 12:57:54.386189', NULL),
	(10002964, 2, 'PW21A-TS100257WT-L', 0, 0, '2021-04-15 12:57:54.381207', '2021-04-15 12:57:54.381207', NULL),
	(10002965, 2, 'PW21A-TS100257WT-XL', 0, 0, '2021-04-15 12:57:54.388772', '2021-04-15 12:57:54.388772', NULL),
	(10002966, 2, 'PW21A-TS100257WT-XXL', 0, 0, '2021-04-15 12:57:54.388469', '2021-04-15 12:57:54.388469', NULL),
	(10002967, 2, 'PW21A-TS100258WT-XS', 0, 0, '2021-04-15 12:57:54.399408', '2021-04-15 12:57:54.399408', NULL),
	(10002968, 2, 'PW21A-TS100258WT-S', 3, 0, '2021-04-15 12:57:54.390012', '2021-04-15 12:57:54.390012', NULL),
	(10002969, 2, 'PW21A-TS100258WT-M', 4, 0, '2021-04-15 12:57:54.399741', '2021-04-15 12:57:54.399741', NULL),
	(10002970, 2, 'PW21A-TS100258WT-L', 4, 0, '2021-04-15 12:57:54.390348', '2021-04-15 12:57:54.390348', NULL),
	(10002971, 2, 'PW21A-TS100258WT-XL', 3, 0, '2021-04-15 12:57:54.401924', '2021-04-15 12:57:54.401924', NULL),
	(10002972, 2, 'PW21A-TS100258WT-XXL', 2, 0, '2021-04-15 12:57:54.390658', '2021-04-15 12:57:54.390658', NULL),
	(10002973, 2, 'PW21A-TS100259BL-XS', 0, 0, '2021-04-15 12:57:54.409316', '2021-04-15 12:57:54.409316', NULL),
	(10002974, 2, 'PW21A-TS100259BL-S', 3, 0, '2021-04-15 12:57:54.400265', '2021-04-15 12:57:54.400265', NULL),
	(10002975, 2, 'PW21A-TS100259BL-M', 4, 0, '2021-04-15 12:57:54.405493', '2021-04-15 12:57:54.405493', NULL),
	(10002976, 2, 'PW21A-TS100259BL-L', 4, 0, '2021-04-15 12:57:54.424162', '2021-04-15 12:57:54.424162', NULL),
	(10002977, 2, 'PW21A-TS100259BL-XL', 3, 0, '2021-04-15 12:57:54.412429', '2021-04-15 12:57:54.412429', NULL),
	(10002978, 2, 'PW21A-TS100259BL-XXL', 2, 0, '2021-04-15 12:57:54.413478', '2021-04-15 12:57:54.413478', NULL),
	(10002979, 2, 'PW21A-TS100260BL-XS', 0, 0, '2021-04-15 12:57:54.422611', '2021-04-15 12:57:54.422611', NULL),
	(10002980, 2, 'PW21A-TS100260BL-S', 3, 0, '2021-04-15 12:57:54.413793', '2021-04-15 12:57:54.413793', NULL),
	(10002981, 2, 'PW21A-TS100260BL-M', 4, 0, '2021-04-15 12:57:54.415672', '2021-04-15 12:57:54.415672', NULL),
	(10002982, 2, 'PW21A-TS100260BL-L', 4, 0, '2021-04-15 12:57:54.433698', '2021-04-15 12:57:54.433698', NULL),
	(10002983, 2, 'PW21A-TS100260BL-XL', 3, 0, '2021-04-15 12:57:54.436060', '2021-04-15 12:57:54.436060', NULL),
	(10002984, 2, 'PW21A-TS100260BL-XXL', 2, 0, '2021-04-15 12:57:54.426675', '2021-04-15 12:57:54.426675', NULL),
	(10002985, 2, 'PW21A-TS100261BL-XS', 0, 0, '2021-04-15 12:57:54.424705', '2021-04-15 12:57:54.424705', NULL),
	(10002986, 2, 'PW21A-TS100261BL-S', 3, 0, '2021-04-15 12:57:54.425055', '2021-04-15 12:57:54.425055', NULL),
	(10002987, 2, 'PW21A-TS100261BL-M', 4, 0, '2021-04-15 12:57:54.445528', '2021-04-15 12:57:54.445528', NULL),
	(10002988, 2, 'PW21A-TS100261BL-L', 4, 0, '2021-04-15 12:57:54.435624', '2021-04-15 12:57:54.435624', NULL),
	(10002989, 2, 'PW21A-TS100261BL-XL', 3, 0, '2021-04-15 12:57:54.483977', '2021-04-15 12:57:54.483977', NULL),
	(10002990, 2, 'PW21A-TS100261BL-XXL', 2, 0, '2021-04-15 12:57:54.444762', '2021-04-15 12:57:54.444762', NULL),
	(10002991, 2, 'PW21A-TS100262BL-XS', 0, 0, '2021-04-15 12:57:54.453880', '2021-04-15 12:57:54.453880', NULL),
	(10002992, 2, 'PW21A-TS100262BL-S', 3, 0, '2021-04-15 12:57:54.446407', '2021-04-15 12:57:54.446407', NULL),
	(10002993, 2, 'PW21A-TS100262BL-M', 4, 0, '2021-04-15 12:57:54.457413', '2021-04-15 12:57:54.457413', NULL),
	(10002994, 2, 'PW21A-TS100262BL-L', 4, 0, '2021-04-15 12:57:54.446711', '2021-04-15 12:57:54.446711', NULL),
	(10002995, 2, 'PW21A-TS100262BL-XL', 3, 0, '2021-04-15 12:57:54.460875', '2021-04-15 12:57:54.460875', NULL),
	(10002996, 2, 'PW21A-TS100262BL-XXL', 2, 0, '2021-04-15 12:57:54.596842', '2021-04-15 12:57:54.596842', NULL),
	(10002997, 2, 'PW21A-TS100263BL-XS', 0, 0, '2021-04-15 12:57:54.458394', '2021-04-15 12:57:54.458394', NULL),
	(10002998, 2, 'PW21A-TS100263BL-S', 2, 0, '2021-04-15 12:57:54.468493', '2021-04-15 12:57:54.468493', NULL),
	(10002999, 2, 'PW21A-TS100263BL-M', 2, 0, '2021-04-15 12:57:54.458802', '2021-04-15 12:57:54.458802', NULL),
	(10003000, 2, 'PW21A-TS100263BL-L', 2, 0, '2021-04-15 12:57:54.469923', '2021-04-15 12:57:54.469923', NULL),
	(10003001, 2, 'PW21A-TS100263BL-XL', 2, 0, '2021-04-15 12:57:54.470248', '2021-04-15 12:57:54.470248', NULL),
	(10003002, 2, 'PW21A-TS100263BL-XXL', 2, 0, '2021-04-15 12:57:54.470863', '2021-04-15 12:57:54.470863', NULL),
	(10003003, 2, 'PW21A-TS100264WH-XS', 0, 0, '2021-04-15 12:57:54.478471', '2021-04-15 12:57:54.478471', NULL),
	(10003004, 2, 'PW21A-TS100264WH-S', 0, 0, '2021-04-15 12:57:54.471159', '2021-04-15 12:57:54.471159', NULL),
	(10003005, 2, 'PW21A-TS100264WH-M', 0, 0, '2021-04-15 12:57:54.484358', '2021-04-15 12:57:54.484358', NULL),
	(10003006, 2, 'PW21A-TS100264WH-L', 0, 0, '2021-04-15 12:57:54.480517', '2021-04-15 12:57:54.480517', NULL),
	(10003007, 2, 'PW21A-TS100264WH-XL', 1, 0, '2021-04-15 12:57:54.483240', '2021-04-15 12:57:54.483240', NULL),
	(10003008, 2, 'PW21A-TS100264WH-XXL', 1, 0, '2021-04-15 12:57:54.493249', '2021-04-15 12:57:54.493249', NULL),
	(10003009, 2, 'PW21A-TS100265RD-XS', 0, 0, '2021-04-15 12:57:54.493606', '2021-04-15 12:57:54.493606', NULL),
	(10003010, 2, 'PW21A-TS100265RD-S', 3, 0, '2021-04-15 12:57:54.494493', '2021-04-15 12:57:54.494493', NULL),
	(10003011, 2, 'PW21A-TS100265RD-M', 5, 0, '2021-04-15 12:57:54.493879', '2021-04-15 12:57:54.493879', NULL),
	(10003012, 2, 'PW21A-TS100265RD-L', 4, 0, '2021-04-15 12:57:54.503031', '2021-04-15 12:57:54.503031', NULL),
	(10003013, 2, 'PW21A-TS100265RD-XL', 2, 0, '2021-04-15 12:57:54.514350', '2021-04-15 12:57:54.514350', NULL),
	(10003014, 2, 'PW21A-TS100265RD-XXL', 2, 0, '2021-04-15 12:57:54.495576', '2021-04-15 12:57:54.495576', NULL),
	(10003015, 2, 'PW21A-TS100266BL-XS', 0, 0, '2021-04-15 12:57:54.497373', '2021-04-15 12:57:54.497373', NULL),
	(10003016, 2, 'PW21A-TS100266BL-S', 3, 0, '2021-04-15 12:57:54.504144', '2021-04-15 12:57:54.504144', NULL),
	(10003017, 2, 'PW21A-TS100266BL-M', 4, 0, '2021-04-15 12:57:54.503795', '2021-04-15 12:57:54.503795', NULL),
	(10003018, 2, 'PW21A-TS100266BL-L', 4, 0, '2021-04-15 12:57:54.498813', '2021-04-15 12:57:54.498813', NULL),
	(10003019, 2, 'PW21A-TS100266BL-XL', 2, 0, '2021-04-15 12:57:54.513435', '2021-04-15 12:57:54.513435', NULL),
	(10003020, 2, 'PW21A-TS100266BL-XXL', 2, 0, '2021-04-15 12:57:54.514075', '2021-04-15 12:57:54.514075', NULL),
	(10003021, 2, 'PW21A-TS100267BL-XS', 0, 0, '2021-04-15 12:57:54.512805', '2021-04-15 12:57:54.512805', NULL),
	(10003022, 2, 'PW21A-TS100267BL-S', 3, 0, '2021-04-15 12:57:54.517466', '2021-04-15 12:57:54.517466', NULL),
	(10003023, 2, 'PW21A-TS100267BL-M', 4, 0, '2021-04-15 12:57:54.513129', '2021-04-15 12:57:54.513129', NULL),
	(10003024, 2, 'PW21A-TS100267BL-L', 5, 0, '2021-04-15 12:57:54.517787', '2021-04-15 12:57:54.517787', NULL),
	(10003025, 2, 'PW21A-TS100267BL-XL', 2, 0, '2021-04-15 12:57:54.531135', '2021-04-15 12:57:54.531135', NULL),
	(10003026, 2, 'PW21A-TS100267BL-XXL', 2, 0, '2021-04-15 12:57:54.522232', '2021-04-15 12:57:54.522232', NULL),
	(10003027, 2, 'PW21A-TS100268BL-XS', 0, 0, '2021-04-15 12:57:54.522581', '2021-04-15 12:57:54.522581', NULL),
	(10003028, 2, 'PW21A-TS100268BL-S', 3, 0, '2021-04-15 12:57:54.532540', '2021-04-15 12:57:54.532540', NULL),
	(10003029, 2, 'PW21A-TS100268BL-M', 4, 0, '2021-04-15 12:57:54.532880', '2021-04-15 12:57:54.532880', NULL),
	(10003030, 2, 'PW21A-TS100268BL-L', 4, 0, '2021-04-15 12:57:54.531452', '2021-04-15 12:57:54.531452', NULL),
	(10003031, 2, 'PW21A-TS100268BL-XL', 3, 0, '2021-04-15 12:57:54.522922', '2021-04-15 12:57:54.522922', NULL),
	(10003032, 2, 'PW21A-TS100268BL-XXL', 2, 0, '2021-04-15 12:57:54.534905', '2021-04-15 12:57:54.534905', NULL),
	(10003033, 2, 'PW21A-TS100269BL-XS', 0, 0, '2021-04-15 12:57:54.533212', '2021-04-15 12:57:54.533212', NULL),
	(10003034, 2, 'PW21A-TS100269BL-S', 3, 0, '2021-04-15 12:57:54.585203', '2021-04-15 12:57:54.585203', NULL),
	(10003035, 2, 'PW21A-TS100269BL-M', 5, 0, '2021-04-15 12:57:54.543700', '2021-04-15 12:57:54.543700', NULL),
	(10003036, 2, 'PW21A-TS100269BL-L', 5, 0, '2021-04-15 12:57:54.535241', '2021-04-15 12:57:54.535241', NULL),
	(10003037, 2, 'PW21A-TS100269BL-XL', 2, 0, '2021-04-15 12:57:54.541553', '2021-04-15 12:57:54.541553', NULL),
	(10003038, 2, 'PW21A-TS100269BL-XXL', 2, 0, '2021-04-15 12:57:54.552767', '2021-04-15 12:57:54.552767', NULL),
	(10003039, 2, 'PW21A-TS100270BL-XS', 0, 0, '2021-04-15 12:57:54.543389', '2021-04-15 12:57:54.543389', NULL),
	(10003040, 2, 'PW21A-TS100270BL-S', 0, 0, '2021-04-15 12:57:54.551566', '2021-04-15 12:57:54.551566', NULL),
	(10003041, 2, 'PW21A-TS100270BL-M', 0, 0, '2021-04-15 12:57:54.549626', '2021-04-15 12:57:54.549626', NULL),
	(10003042, 2, 'PW21A-TS100270BL-L', 0, 0, '2021-04-15 12:57:54.553050', '2021-04-15 12:57:54.553050', NULL),
	(10003043, 2, 'PW21A-TS100270BL-XL', 0, 0, '2021-04-15 12:57:54.552018', '2021-04-15 12:57:54.552018', NULL),
	(10003044, 2, 'PW21A-TS100270BL-XXL', 0, 0, '2021-04-15 12:57:54.563985', '2021-04-15 12:57:54.563985', NULL),
	(10003045, 2, 'PW21A-TS100271BL-XS', 0, 0, '2021-04-15 12:57:54.553633', '2021-04-15 12:57:54.553633', NULL),
	(10003046, 2, 'PW21A-TS100271BL-S', 3, 0, '2021-04-15 12:57:54.561906', '2021-04-15 12:57:54.561906', NULL),
	(10003047, 2, 'PW21A-TS100271BL-M', 4, 0, '2021-04-15 12:57:54.553310', '2021-04-15 12:57:54.553310', NULL),
	(10003048, 2, 'PW21A-TS100271BL-L', 4, 0, '2021-04-15 12:57:54.574963', '2021-04-15 12:57:54.574963', NULL),
	(10003049, 2, 'PW21A-TS100271BL-XL', 3, 0, '2021-04-15 12:57:54.566829', '2021-04-15 12:57:54.566829', NULL),
	(10003050, 2, 'PW21A-TS100271BL-XXL', 2, 0, '2021-04-15 12:57:54.562432', '2021-04-15 12:57:54.562432', NULL),
	(10003051, 2, 'PW21A-TS100272BL-XS', 0, 0, '2021-04-15 12:57:54.576560', '2021-04-15 12:57:54.576560', NULL),
	(10003052, 2, 'PW21A-TS100272BL-S', 3, 0, '2021-04-15 12:57:54.576149', '2021-04-15 12:57:54.576149', NULL),
	(10003053, 2, 'PW21A-TS100272BL-M', 4, 0, '2021-04-15 12:57:54.576913', '2021-04-15 12:57:54.576913', NULL),
	(10003054, 2, 'PW21A-TS100272BL-L', 4, 0, '2021-04-15 12:57:54.587473', '2021-04-15 12:57:54.587473', NULL),
	(10003055, 2, 'PW21A-TS100272BL-XL', 3, 0, '2021-04-15 12:57:54.621354', '2021-04-15 12:57:54.621354', NULL),
	(10003056, 2, 'PW21A-TS100272BL-XXL', 2, 0, '2021-04-15 12:57:54.578762', '2021-04-15 12:57:54.578762', NULL),
	(10003057, 2, 'PW21A-TS100273WT-XS', 0, 0, '2021-04-15 12:57:54.592607', '2021-04-15 12:57:54.592607', NULL),
	(10003058, 2, 'PW21A-TS100273WT-S', 3, 0, '2021-04-15 12:57:54.579249', '2021-04-15 12:57:54.579249', NULL),
	(10003059, 2, 'PW21A-TS100273WT-M', 4, 0, '2021-04-15 12:57:54.590357', '2021-04-15 12:57:54.590357', NULL),
	(10003060, 2, 'PW21A-TS100273WT-L', 4, 0, '2021-04-15 12:57:54.587155', '2021-04-15 12:57:54.587155', NULL),
	(10003061, 2, 'PW21A-TS100273WT-XL', 3, 0, '2021-04-15 12:57:54.595317', '2021-04-15 12:57:54.595317', NULL),
	(10003062, 2, 'PW21A-TS100273WT-XXL', 2, 0, '2021-04-15 12:57:54.601249', '2021-04-15 12:57:54.601249', NULL),
	(10003063, 2, 'PW21A-TS100274BL-XS', 0, 0, '2021-04-15 12:57:54.596551', '2021-04-15 12:57:54.596551', NULL),
	(10003064, 2, 'PW21A-TS100274BL-S', 3, 0, '2021-04-15 12:57:54.637100', '2021-04-15 12:57:54.637100', NULL),
	(10003065, 2, 'PW21A-TS100274BL-M', 5, 0, '2021-04-15 12:57:54.612917', '2021-04-15 12:57:54.612917', NULL),
	(10003066, 2, 'PW21A-TS100274BL-L', 4, 0, '2021-04-15 12:57:54.596151', '2021-04-15 12:57:54.596151', NULL),
	(10003067, 2, 'PW21A-TS100274BL-XL', 2, 0, '2021-04-15 12:57:54.597659', '2021-04-15 12:57:54.597659', NULL),
	(10003068, 2, 'PW21A-TS100274BL-XXL', 2, 0, '2021-04-15 12:57:54.606412', '2021-04-15 12:57:54.606412', NULL),
	(10003069, 2, 'PW21A-TS100275BL-XS', 0, 0, '2021-04-15 12:57:54.607443', '2021-04-15 12:57:54.607443', NULL),
	(10003070, 2, 'PW21A-TS100275BL-S', 3, 0, '2021-04-15 12:57:54.611997', '2021-04-15 12:57:54.611997', NULL),
	(10003071, 2, 'PW21A-TS100275BL-M', 4, 0, '2021-04-15 12:57:54.614953', '2021-04-15 12:57:54.614953', NULL),
	(10003072, 2, 'PW21A-TS100275BL-L', 4, 0, '2021-04-15 12:57:54.700325', '2021-04-15 12:57:54.700325', NULL),
	(10003073, 2, 'PW21A-TS100275BL-XL', 3, 0, '2021-04-15 12:57:54.615651', '2021-04-15 12:57:54.615651', NULL),
	(10003074, 2, 'PW21A-TS100275BL-XXL', 2, 0, '2021-04-15 12:57:54.610176', '2021-04-15 12:57:54.610176', NULL),
	(10003075, 2, 'PW21A-TS100276WT-XS', 0, 0, '2021-04-15 12:57:54.624224', '2021-04-15 12:57:54.624224', NULL),
	(10003076, 2, 'PW21A-TS100276WT-S', 2, 0, '2021-04-15 12:57:54.618299', '2021-04-15 12:57:54.618299', NULL),
	(10003077, 2, 'PW21A-TS100276WT-M', 5, 0, '2021-04-15 12:57:54.636250', '2021-04-15 12:57:54.636250', NULL),
	(10003078, 2, 'PW21A-TS100276WT-L', 4, 0, '2021-04-15 12:57:54.617954', '2021-04-15 12:57:54.617954', NULL),
	(10003079, 2, 'PW21A-TS100276WT-XL', 3, 0, '2021-04-15 12:57:54.638085', '2021-04-15 12:57:54.638085', NULL),
	(10003080, 2, 'PW21A-TS100276WT-XXL', 2, 0, '2021-04-15 12:57:54.631022', '2021-04-15 12:57:54.631022', NULL),
	(10003081, 2, 'PW21A-TS100277BL-XS', 0, 0, '2021-04-15 12:57:54.637616', '2021-04-15 12:57:54.637616', NULL),
	(10003082, 2, 'PW21A-TS100277BL-S', 3, 0, '2021-04-15 12:57:54.641397', '2021-04-15 12:57:54.641397', NULL),
	(10003083, 2, 'PW21A-TS100277BL-M', 4, 0, '2021-04-15 12:57:54.647331', '2021-04-15 12:57:54.647331', NULL),
	(10003084, 2, 'PW21A-TS100277BL-L', 4, 0, '2021-04-15 12:57:54.642098', '2021-04-15 12:57:54.642098', NULL),
	(10003085, 2, 'PW21A-TS100277BL-XL', 2, 0, '2021-04-15 12:57:54.641108', '2021-04-15 12:57:54.641108', NULL),
	(10003086, 2, 'PW21A-TS100277BL-XXL', 2, 0, '2021-04-15 12:57:54.656507', '2021-04-15 12:57:54.656507', NULL),
	(10003087, 2, 'PW21A-TS100278BL-XS', 0, 0, '2021-04-15 12:57:54.659258', '2021-04-15 12:57:54.659258', NULL),
	(10003088, 2, 'PW21A-TS100278BL-S', 2, 0, '2021-04-15 12:57:54.659831', '2021-04-15 12:57:54.659831', NULL),
	(10003089, 2, 'PW21A-TS100278BL-M', 4, 0, '2021-04-15 12:57:54.661002', '2021-04-15 12:57:54.661002', NULL),
	(10003090, 2, 'PW21A-TS100278BL-L', 5, 0, '2021-04-15 12:57:54.662567', '2021-04-15 12:57:54.662567', NULL),
	(10003091, 2, 'PW21A-TS100278BL-XL', 3, 0, '2021-04-15 12:57:54.647710', '2021-04-15 12:57:54.647710', NULL),
	(10003092, 2, 'PW21A-TS100278BL-XXL', 2, 0, '2021-04-15 12:57:54.664288', '2021-04-15 12:57:54.664288', NULL),
	(10003093, 2, 'PW21A-TS100279WT-XS', 0, 0, '2021-04-15 12:57:54.795599', '2021-04-15 12:57:54.795599', NULL),
	(10003094, 2, 'PW21A-TS100279WT-S', 3, 0, '2021-04-15 12:57:54.661806', '2021-04-15 12:57:54.661806', NULL),
	(10003095, 2, 'PW21A-TS100279WT-M', 4, 0, '2021-04-15 12:57:54.671744', '2021-04-15 12:57:54.671744', NULL),
	(10003096, 2, 'PW21A-TS100279WT-L', 4, 0, '2021-04-15 12:57:54.672685', '2021-04-15 12:57:54.672685', NULL),
	(10003097, 2, 'PW21A-TS100279WT-XL', 3, 0, '2021-04-15 12:57:54.665603', '2021-04-15 12:57:54.665603', NULL),
	(10003098, 2, 'PW21A-TS100279WT-XXL', 2, 0, '2021-04-15 12:57:54.684747', '2021-04-15 12:57:54.684747', NULL),
	(10003099, 2, 'PW21A-TS100280BL-XS', 0, 0, '2021-04-15 12:57:54.683235', '2021-04-15 12:57:54.683235', NULL),
	(10003100, 2, 'PW21A-TS100280BL-S', 0, 0, '2021-04-15 12:57:54.681714', '2021-04-15 12:57:54.681714', NULL),
	(10003101, 2, 'PW21A-TS100280BL-M', 0, 0, '2021-04-15 12:57:54.686931', '2021-04-15 12:57:54.686931', NULL),
	(10003102, 2, 'PW21A-TS100280BL-L', 0, 0, '2021-04-15 12:57:54.686648', '2021-04-15 12:57:54.686648', NULL),
	(10003103, 2, 'PW21A-TS100280BL-XL', 0, 0, '2021-04-15 12:57:54.685483', '2021-04-15 12:57:54.685483', NULL),
	(10003104, 2, 'PW21A-TS100280BL-XXL', 0, 0, '2021-04-15 12:57:54.689371', '2021-04-15 12:57:54.689371', NULL),
	(10003105, 2, 'PW21A-TS100281BL-XS', 0, 0, '2021-04-15 12:57:54.695851', '2021-04-15 12:57:54.695851', NULL),
	(10003106, 2, 'PW21A-TS100281BL-S', 0, 0, '2021-04-15 12:57:54.689092', '2021-04-15 12:57:54.689092', NULL),
	(10003107, 2, 'PW21A-TS100281BL-M', 0, 0, '2021-04-15 12:57:54.704423', '2021-04-15 12:57:54.704423', NULL),
	(10003108, 2, 'PW21A-TS100281BL-L', 0, 0, '2021-04-15 12:57:54.702055', '2021-04-15 12:57:54.702055', NULL),
	(10003109, 2, 'PW21A-TS100281BL-XL', 0, 0, '2021-04-15 12:57:54.697995', '2021-04-15 12:57:54.697995', NULL),
	(10003110, 2, 'PW21A-TS100281BL-XXL', 0, 0, '2021-04-15 12:57:54.707088', '2021-04-15 12:57:54.707088', NULL),
	(10003111, 2, 'PW21A-TS100282BL-XS', 0, 0, '2021-04-15 12:57:54.706402', '2021-04-15 12:57:54.706402', NULL),
	(10003112, 2, 'PW21A-TS100282BL-S', 0, 0, '2021-04-15 12:57:54.706106', '2021-04-15 12:57:54.706106', NULL),
	(10003113, 2, 'PW21A-TS100282BL-M', 0, 0, '2021-04-15 12:57:54.723648', '2021-04-15 12:57:54.723648', NULL),
	(10003114, 2, 'PW21A-TS100282BL-L', 0, 0, '2021-04-15 12:57:54.707629', '2021-04-15 12:57:54.707629', NULL),
	(10003115, 2, 'PW21A-TS100282BL-XL', 0, 0, '2021-04-15 12:57:54.707366', '2021-04-15 12:57:54.707366', NULL),
	(10003116, 2, 'PW21A-TS100282BL-XXL', 0, 0, '2021-04-15 12:57:54.724063', '2021-04-15 12:57:54.724063', NULL),
	(10003117, 2, 'PW21A-TS100283BL-XS', 0, 0, '2021-04-15 12:57:54.730920', '2021-04-15 12:57:54.730920', NULL),
	(10003118, 2, 'PW21A-TS100283BL-S', 0, 0, '2021-04-15 12:57:54.723183', '2021-04-15 12:57:54.723183', NULL),
	(10003119, 2, 'PW21A-TS100283BL-M', 0, 0, '2021-04-15 12:57:54.728987', '2021-04-15 12:57:54.728987', NULL),
	(10003120, 2, 'PW21A-TS100283BL-L', 0, 0, '2021-04-15 12:57:54.744180', '2021-04-15 12:57:54.744180', NULL),
	(10003121, 2, 'PW21A-TS100283BL-XL', 0, 0, '2021-04-15 12:57:54.752694', '2021-04-15 12:57:54.752694', NULL),
	(10003122, 2, 'PW21A-TS100283BL-XXL', 0, 0, '2021-04-15 12:57:54.752228', '2021-04-15 12:57:54.752228', NULL),
	(10003123, 2, 'PW21A-TS100284BL-XS', 0, 0, '2021-04-15 12:57:54.738883', '2021-04-15 12:57:54.738883', NULL),
	(10003124, 2, 'PW21A-TS100284BL-S', 0, 0, '2021-04-15 12:57:54.742815', '2021-04-15 12:57:54.742815', NULL),
	(10003125, 2, 'PW21A-TS100284BL-M', 0, 0, '2021-04-15 12:57:54.756585', '2021-04-15 12:57:54.756585', NULL),
	(10003126, 2, 'PW21A-TS100284BL-L', 0, 0, '2021-04-15 12:57:54.754364', '2021-04-15 12:57:54.754364', NULL),
	(10003127, 2, 'PW21A-TS100284BL-XL', 0, 0, '2021-04-15 12:57:54.757187', '2021-04-15 12:57:54.757187', NULL),
	(10003128, 2, 'PW21A-TS100284BL-XXL', 0, 0, '2021-04-15 12:57:54.828635', '2021-04-15 12:57:54.828635', NULL),
	(10003129, 2, 'PW21A-TS100285BL-XS', 0, 0, '2021-04-15 12:57:54.756889', '2021-04-15 12:57:54.756889', NULL),
	(10003130, 2, 'PW21A-TS100285BL-S', 0, 0, '2021-04-15 12:57:54.765971', '2021-04-15 12:57:54.765971', NULL),
	(10003131, 2, 'PW21A-TS100285BL-M', 0, 0, '2021-04-15 12:57:54.759167', '2021-04-15 12:57:54.759167', NULL),
	(10003132, 2, 'PW21A-TS100285BL-L', 0, 0, '2021-04-15 12:57:54.763957', '2021-04-15 12:57:54.763957', NULL),
	(10003133, 2, 'PW21A-TS100285BL-XL', 0, 0, '2021-04-15 12:57:54.773119', '2021-04-15 12:57:54.773119', NULL),
	(10003134, 2, 'PW21A-TS100285BL-XXL', 0, 0, '2021-04-15 12:57:54.770627', '2021-04-15 12:57:54.770627', NULL),
	(10003135, 2, 'PW21A-TS100286BL-XS', 0, 0, '2021-04-15 12:57:54.767704', '2021-04-15 12:57:54.767704', NULL),
	(10003136, 2, 'PW21A-TS100286BL-S', 0, 0, '2021-04-15 12:57:54.775629', '2021-04-15 12:57:54.775629', NULL),
	(10003137, 2, 'PW21A-TS100286BL-M', 0, 0, '2021-04-15 12:57:54.775311', '2021-04-15 12:57:54.775311', NULL),
	(10003138, 2, 'PW21A-TS100286BL-L', 0, 0, '2021-04-15 12:57:54.770928', '2021-04-15 12:57:54.770928', NULL),
	(10003139, 2, 'PW21A-TS100286BL-XL', 0, 0, '2021-04-15 12:57:54.784583', '2021-04-15 12:57:54.784583', NULL),
	(10003140, 2, 'PW21A-TS100286BL-XXL', 0, 0, '2021-04-15 12:57:54.775922', '2021-04-15 12:57:54.775922', NULL),
	(10003141, 2, 'PW21A-TS100287BL-XS', 0, 0, '2021-04-15 12:57:54.778062', '2021-04-15 12:57:54.778062', NULL),
	(10003142, 2, 'PW21A-TS100287BL-S', 0, 0, '2021-04-15 12:57:54.840158', '2021-04-15 12:57:54.840158', NULL),
	(10003143, 2, 'PW21A-TS100287BL-M', 0, 0, '2021-04-15 12:57:54.781089', '2021-04-15 12:57:54.781089', NULL),
	(10003144, 2, 'PW21A-TS100287BL-L', 0, 0, '2021-04-15 12:57:54.786560', '2021-04-15 12:57:54.786560', NULL),
	(10003145, 2, 'PW21A-TS100287BL-XL', 0, 0, '2021-04-15 12:57:54.798582', '2021-04-15 12:57:54.798582', NULL),
	(10003146, 2, 'PW21A-TS100287BL-XXL', 0, 0, '2021-04-15 12:57:54.797785', '2021-04-15 12:57:54.797785', NULL),
	(10003147, 2, 'PW21A-TS100288BL-XS', 0, 0, '2021-04-15 12:57:54.795988', '2021-04-15 12:57:54.795988', NULL),
	(10003148, 2, 'PW21A-TS100288BL-S', 0, 0, '2021-04-15 12:57:54.802431', '2021-04-15 12:57:54.802431', NULL),
	(10003149, 2, 'PW21A-TS100288BL-M', 0, 0, '2021-04-15 12:57:54.799920', '2021-04-15 12:57:54.799920', NULL),
	(10003150, 2, 'PW21A-TS100288BL-L', 0, 0, '2021-04-15 12:57:54.800422', '2021-04-15 12:57:54.800422', NULL),
	(10003151, 2, 'PW21A-TS100288BL-XL', 0, 0, '2021-04-15 12:57:54.810139', '2021-04-15 12:57:54.810139', NULL),
	(10003152, 2, 'PW21A-TS100288BL-XXL', 0, 0, '2021-04-15 12:57:54.822400', '2021-04-15 12:57:54.822400', NULL),
	(10003153, 2, 'PW21A-TS100289BL-XS', 0, 0, '2021-04-15 12:57:54.822090', '2021-04-15 12:57:54.822090', NULL),
	(10003154, 2, 'PW21A-TS100289BL-S', 0, 0, '2021-04-15 12:57:54.808811', '2021-04-15 12:57:54.808811', NULL),
	(10003155, 2, 'PW21A-TS100289BL-M', 0, 0, '2021-04-15 12:57:54.804700', '2021-04-15 12:57:54.804700', NULL),
	(10003156, 2, 'PW21A-TS100289BL-L', 0, 0, '2021-04-15 12:57:54.838154', '2021-04-15 12:57:54.838154', NULL),
	(10003157, 2, 'PW21A-TS100289BL-XL', 0, 0, '2021-04-15 12:57:54.813297', '2021-04-15 12:57:54.813297', NULL),
	(10003158, 2, 'PW21A-TS100289BL-XXL', 0, 0, '2021-04-15 12:57:54.819385', '2021-04-15 12:57:54.819385', NULL),
	(10003159, 2, 'PW21A-TS100290OL-XS', 0, 0, '2021-04-15 12:57:54.815971', '2021-04-15 12:57:54.815971', NULL),
	(10003160, 2, 'PW21A-TS100290OL-S', 2, 0, '2021-04-15 12:57:54.829174', '2021-04-15 12:57:54.829174', NULL),
	(10003161, 2, 'PW21A-TS100290OL-M', 2, 0, '2021-04-15 12:57:54.818442', '2021-04-15 12:57:54.818442', NULL),
	(10003162, 2, 'PW21A-TS100290OL-L', 4, 0, '2021-04-15 12:57:54.821670', '2021-04-15 12:57:54.821670', NULL),
	(10003163, 2, 'PW21A-TS100290OL-XL', 3, 0, '2021-04-15 12:57:54.819074', '2021-04-15 12:57:54.819074', NULL),
	(10003164, 2, 'PW21A-TS100290OL-XXL', 2, 0, '2021-04-15 12:57:54.832049', '2021-04-15 12:57:54.832049', NULL),
	(10003165, 2, 'PW21A-TS100291BL-XS', 0, 0, '2021-04-15 12:57:54.838934', '2021-04-15 12:57:54.838934', NULL),
	(10003166, 2, 'PW21A-TS100291BL-S', 0, 0, '2021-04-15 12:57:54.882704', '2021-04-15 12:57:54.882704', NULL),
	(10003167, 2, 'PW21A-TS100291BL-M', 0, 0, '2021-04-15 12:57:54.863716', '2021-04-15 12:57:54.863716', NULL),
	(10003168, 2, 'PW21A-TS100291BL-L', 0, 0, '2021-04-15 12:57:54.840725', '2021-04-15 12:57:54.840725', NULL),
	(10003169, 2, 'PW21A-TS100291BL-XL', 0, 0, '2021-04-15 12:57:54.838454', '2021-04-15 12:57:54.838454', NULL),
	(10003170, 2, 'PW21A-TS100291BL-XXL', 0, 0, '2021-04-15 12:57:54.865964', '2021-04-15 12:57:54.865964', NULL),
	(10003171, 2, 'PW21A-TS100292NV-XS', 0, 0, '2021-04-15 12:57:54.958850', '2021-04-15 12:57:54.958850', NULL),
	(10003172, 2, 'PW21A-TS100292NV-S', 3, 0, '2021-04-15 12:57:54.913538', '2021-04-15 12:57:54.913538', NULL),
	(10003173, 2, 'PW21A-TS100292NV-M', 5, 0, '2021-04-15 12:57:54.855635', '2021-04-15 12:57:54.855635', NULL),
	(10003174, 2, 'PW21A-TS100292NV-L', 2, 0, '2021-04-15 12:57:54.843255', '2021-04-15 12:57:54.843255', NULL),
	(10003175, 2, 'PW21A-TS100292NV-XL', 1, 0, '2021-04-15 12:57:54.842310', '2021-04-15 12:57:54.842310', NULL),
	(10003176, 2, 'PW21A-TS100292NV-XXL', 0, 0, '2021-04-15 12:57:54.866725', '2021-04-15 12:57:54.866725', NULL),
	(10003177, 2, 'PW21A-TS100293OL-XS', 0, 0, '2021-04-15 12:57:54.870685', '2021-04-15 12:57:54.870685', NULL),
	(10003178, 2, 'PW21A-TS100293OL-S', 0, 0, '2021-04-15 12:57:54.868978', '2021-04-15 12:57:54.868978', NULL),
	(10003179, 2, 'PW21A-TS100293OL-M', 0, 0, '2021-04-15 12:57:54.856023', '2021-04-15 12:57:54.856023', NULL),
	(10003180, 2, 'PW21A-TS100293OL-L', 0, 0, '2021-04-15 12:57:54.851372', '2021-04-15 12:57:54.851372', NULL),
	(10003181, 2, 'PW21A-TS100293OL-XL', 0, 0, '2021-04-15 12:57:54.862778', '2021-04-15 12:57:54.862778', NULL),
	(10003182, 2, 'PW21A-TS100293OL-XXL', 0, 0, '2021-04-15 12:57:54.890437', '2021-04-15 12:57:54.890437', NULL),
	(10003183, 2, 'PW21A-TS100294OL-XS', 0, 0, '2021-04-15 12:57:54.883073', '2021-04-15 12:57:54.883073', NULL),
	(10003184, 2, 'PW21A-TS100294OL-S', 0, 0, '2021-04-15 12:57:54.867117', '2021-04-15 12:57:54.867117', NULL),
	(10003185, 2, 'PW21A-TS100294OL-M', 0, 0, '2021-04-15 12:57:54.915031', '2021-04-15 12:57:54.915031', NULL),
	(10003186, 2, 'PW21A-TS100294OL-L', 0, 0, '2021-04-15 12:57:54.890988', '2021-04-15 12:57:54.890988', NULL),
	(10003187, 2, 'PW21A-TS100294OL-XL', 0, 0, '2021-04-15 12:57:54.892872', '2021-04-15 12:57:54.892872', NULL),
	(10003188, 2, 'PW21A-TS100294OL-XXL', 0, 0, '2021-04-15 12:57:54.893592', '2021-04-15 12:57:54.893592', NULL),
	(10003189, 2, 'PW21A-TS100295NV-XS', 0, 0, '2021-04-15 12:57:54.932302', '2021-04-15 12:57:54.932302', NULL),
	(10003190, 2, 'PW21A-TS100295NV-S', 0, 0, '2021-04-15 12:57:54.879638', '2021-04-15 12:57:54.879638', NULL),
	(10003191, 2, 'PW21A-TS100295NV-M', 0, 0, '2021-04-15 12:57:54.906535', '2021-04-15 12:57:54.906535', NULL),
	(10003192, 2, 'PW21A-TS100295NV-L', 0, 0, '2021-04-15 12:57:54.893287', '2021-04-15 12:57:54.893287', NULL),
	(10003193, 2, 'PW21A-TS100295NV-XL', 0, 0, '2021-04-15 12:57:54.893882', '2021-04-15 12:57:54.893882', NULL),
	(10003194, 2, 'PW21A-TS100295NV-XXL', 0, 0, '2021-04-15 12:57:54.892420', '2021-04-15 12:57:54.892420', NULL),
	(10003195, 2, 'PW21A-TS100296BL-XS', 0, 0, '2021-04-15 12:57:54.914486', '2021-04-15 12:57:54.914486', NULL),
	(10003196, 2, 'PW21A-TS100296BL-S', 3, 0, '2021-04-15 12:57:54.907715', '2021-04-15 12:57:54.907715', NULL),
	(10003197, 2, 'PW21A-TS100296BL-M', 4, 0, '2021-04-15 12:57:54.924534', '2021-04-15 12:57:54.924534', NULL),
	(10003198, 2, 'PW21A-TS100296BL-L', 4, 0, '2021-04-15 12:57:54.906865', '2021-04-15 12:57:54.906865', NULL),
	(10003199, 2, 'PW21A-TS100296BL-XL', 3, 0, '2021-04-15 12:57:54.957762', '2021-04-15 12:57:54.957762', NULL),
	(10003200, 2, 'PW21A-TS100296BL-XXL', 2, 0, '2021-04-15 12:57:54.916933', '2021-04-15 12:57:54.916933', NULL),
	(10003201, 2, 'PW21A-TS100297OL-XS', 0, 0, '2021-04-15 12:57:54.915644', '2021-04-15 12:57:54.915644', NULL),
	(10003202, 2, 'PW21A-TS100297OL-S', 0, 0, '2021-04-15 12:57:54.914759', '2021-04-15 12:57:54.914759', NULL),
	(10003203, 2, 'PW21A-TS100297OL-M', 0, 0, '2021-04-15 12:57:54.915301', '2021-04-15 12:57:54.915301', NULL),
	(10003204, 2, 'PW21A-TS100297OL-L', 1, 0, '2021-04-15 12:57:54.932601', '2021-04-15 12:57:54.932601', NULL),
	(10003205, 2, 'PW21A-TS100297OL-XL', 2, 0, '2021-04-15 12:57:54.931981', '2021-04-15 12:57:54.931981', NULL),
	(10003206, 2, 'PW21A-TS100297OL-XXL', 1, 0, '2021-04-15 12:57:54.927155', '2021-04-15 12:57:54.927155', NULL),
	(10003207, 2, 'PW21A-TS100298OL-XS', 0, 0, '2021-04-15 12:57:54.923808', '2021-04-15 12:57:54.923808', NULL),
	(10003208, 2, 'PW21A-TS100298OL-S', 0, 0, '2021-04-15 12:57:54.936762', '2021-04-15 12:57:54.936762', NULL),
	(10003209, 2, 'PW21A-TS100298OL-M', 0, 0, '2021-04-15 12:57:54.940052', '2021-04-15 12:57:54.940052', NULL),
	(10003210, 2, 'PW21A-TS100298OL-L', 0, 0, '2021-04-15 12:57:54.933592', '2021-04-15 12:57:54.933592', NULL),
	(10003211, 2, 'PW21A-TS100298OL-XL', 0, 0, '2021-04-15 12:57:54.935799', '2021-04-15 12:57:54.935799', NULL),
	(10003212, 2, 'PW21A-TS100298OL-XXL', 0, 0, '2021-04-15 12:57:54.960451', '2021-04-15 12:57:54.960451', NULL),
	(10003213, 2, 'PW21A-TS100299BL-XS', 0, 0, '2021-04-15 12:57:55.005768', '2021-04-15 12:57:55.005768', NULL),
	(10003214, 2, 'PW21A-TS100299BL-S', 3, 0, '2021-04-15 12:57:55.009261', '2021-04-15 12:57:55.009261', NULL),
	(10003215, 2, 'PW21A-TS100299BL-M', 4, 0, '2021-04-15 12:57:54.970766', '2021-04-15 12:57:54.970766', NULL),
	(10003216, 2, 'PW21A-TS100299BL-L', 3, 0, '2021-04-15 12:57:54.971302', '2021-04-15 12:57:54.971302', NULL),
	(10003217, 2, 'PW21A-TS100299BL-XL', 3, 0, '2021-04-15 12:57:54.975968', '2021-04-15 12:57:54.975968', NULL),
	(10003218, 2, 'PW21A-TS100299BL-XXL', 2, 0, '2021-04-15 12:57:54.989427', '2021-04-15 12:57:54.989427', NULL),
	(10003219, 2, 'PW21A-TS100300MR-XS', 0, 0, '2021-04-15 12:57:54.975647', '2021-04-15 12:57:54.975647', NULL),
	(10003220, 2, 'PW21A-TS100300MR-S', 0, 0, '2021-04-15 12:57:55.133856', '2021-04-15 12:57:55.133856', NULL),
	(10003221, 2, 'PW21A-TS100300MR-M', 0, 0, '2021-04-15 12:57:54.975336', '2021-04-15 12:57:54.975336', NULL),
	(10003222, 2, 'PW21A-TS100300MR-L', 0, 0, '2021-04-15 12:57:54.973834', '2021-04-15 12:57:54.973834', NULL),
	(10003223, 2, 'PW21A-TS100300MR-XL', 0, 0, '2021-04-15 12:57:54.973076', '2021-04-15 12:57:54.973076', NULL),
	(10003224, 2, 'PW21A-TS100300MR-XXL', 0, 0, '2021-04-15 12:57:54.991733', '2021-04-15 12:57:54.991733', NULL),
	(10003225, 2, 'PW21A-TS100301BL-XS', 0, 0, '2021-04-15 12:57:55.021938', '2021-04-15 12:57:55.021938', NULL),
	(10003226, 2, 'PW21A-TS100301BL-S', 0, 0, '2021-04-15 12:57:55.003034', '2021-04-15 12:57:55.003034', NULL),
	(10003227, 2, 'PW21A-TS100301BL-M', 0, 0, '2021-04-15 12:57:55.006764', '2021-04-15 12:57:55.006764', NULL),
	(10003228, 2, 'PW21A-TS100301BL-L', 0, 0, '2021-04-15 12:57:54.991280', '2021-04-15 12:57:54.991280', NULL),
	(10003229, 2, 'PW21A-TS100301BL-XL', 0, 0, '2021-04-15 12:57:54.997990', '2021-04-15 12:57:54.997990', NULL),
	(10003230, 2, 'PW21A-TS100301BL-XXL', 0, 0, '2021-04-15 12:57:55.017538', '2021-04-15 12:57:55.017538', NULL),
	(10003231, 2, 'PW21A-TS100302BL-XS', 0, 0, '2021-04-15 12:57:55.011831', '2021-04-15 12:57:55.011831', NULL),
	(10003232, 2, 'PW21A-TS100302BL-S', 3, 0, '2021-04-15 12:57:55.009634', '2021-04-15 12:57:55.009634', NULL),
	(10003233, 2, 'PW21A-TS100302BL-M', 4, 0, '2021-04-15 12:57:55.026598', '2021-04-15 12:57:55.026598', NULL),
	(10003234, 2, 'PW21A-TS100302BL-L', 4, 0, '2021-04-15 12:57:55.019492', '2021-04-15 12:57:55.019492', NULL),
	(10003235, 2, 'PW21A-TS100302BL-XL', 3, 0, '2021-04-15 12:57:55.033198', '2021-04-15 12:57:55.033198', NULL),
	(10003236, 2, 'PW21A-TS100302BL-XXL', 2, 0, '2021-04-15 12:57:55.020979', '2021-04-15 12:57:55.020979', NULL),
	(10003237, 2, 'PW21A-TS100303BL-XS', 0, 0, '2021-04-15 12:57:55.031571', '2021-04-15 12:57:55.031571', NULL),
	(10003238, 2, 'PW21A-TS100303BL-S', 0, 0, '2021-04-15 12:57:55.030549', '2021-04-15 12:57:55.030549', NULL),
	(10003239, 2, 'PW21A-TS100303BL-M', 0, 0, '2021-04-15 12:57:55.028309', '2021-04-15 12:57:55.028309', NULL),
	(10003240, 2, 'PW21A-TS100303BL-L', 0, 0, '2021-04-15 12:57:55.046003', '2021-04-15 12:57:55.046003', NULL),
	(10003241, 2, 'PW21A-TS100303BL-XL', 0, 0, '2021-04-15 12:57:55.045236', '2021-04-15 12:57:55.045236', NULL),
	(10003242, 2, 'PW21A-TS100303BL-XXL', 0, 0, '2021-04-15 12:57:55.032302', '2021-04-15 12:57:55.032302', NULL),
	(10003243, 2, 'PW21A-TS100304OL-XS', 0, 0, '2021-04-15 12:57:55.042515', '2021-04-15 12:57:55.042515', NULL),
	(10003244, 2, 'PW21A-TS100304OL-S', 3, 0, '2021-04-15 12:57:55.160282', '2021-04-15 12:57:55.160282', NULL),
	(10003245, 2, 'PW21A-TS100304OL-M', 4, 0, '2021-04-15 12:57:55.084453', '2021-04-15 12:57:55.084453', NULL),
	(10003246, 2, 'PW21A-TS100304OL-L', 4, 0, '2021-04-15 12:57:55.047077', '2021-04-15 12:57:55.047077', NULL),
	(10003247, 2, 'PW21A-TS100304OL-XL', 3, 0, '2021-04-15 12:57:55.080493', '2021-04-15 12:57:55.080493', NULL),
	(10003248, 2, 'PW21A-TS100304OL-XXL', 2, 0, '2021-04-15 12:57:55.100557', '2021-04-15 12:57:55.100557', NULL),
	(10003249, 2, 'PW21A-TS100305AR-XS', 0, 0, '2021-04-15 12:57:55.096068', '2021-04-15 12:57:55.096068', NULL),
	(10003250, 2, 'PW21A-TS100305AR-S', 2, 0, '2021-04-15 12:57:55.085969', '2021-04-15 12:57:55.085969', NULL),
	(10003251, 2, 'PW21A-TS100305AR-M', 4, 0, '2021-04-15 12:57:55.110002', '2021-04-15 12:57:55.110002', NULL),
	(10003252, 2, 'PW21A-TS100305AR-L', 4, 0, '2021-04-15 12:57:55.146724', '2021-04-15 12:57:55.146724', NULL),
	(10003253, 2, 'PW21A-TS100305AR-XL', 3, 0, '2021-04-15 12:57:55.116600', '2021-04-15 12:57:55.116600', NULL),
	(10003254, 2, 'PW21A-TS100305AR-XXL', 2, 0, '2021-04-15 12:57:55.093525', '2021-04-15 12:57:55.093525', NULL),
	(10003255, 2, 'PW21A-TS100306GN-XS', 0, 0, '2021-04-15 12:57:55.130844', '2021-04-15 12:57:55.130844', NULL),
	(10003256, 2, 'PW21A-TS100306GN-S', 3, 0, '2021-04-15 12:57:55.113020', '2021-04-15 12:57:55.113020', NULL),
	(10003257, 2, 'PW21A-TS100306GN-M', 4, 0, '2021-04-15 12:57:55.118945', '2021-04-15 12:57:55.118945', NULL),
	(10003258, 2, 'PW21A-TS100306GN-L', 4, 0, '2021-04-15 12:57:55.132194', '2021-04-15 12:57:55.132194', NULL),
	(10003259, 2, 'PW21A-TS100306GN-XL', 3, 0, '2021-04-15 12:57:55.127454', '2021-04-15 12:57:55.127454', NULL),
	(10003260, 2, 'PW21A-TS100306GN-XXL', 2, 0, '2021-04-15 12:57:55.134291', '2021-04-15 12:57:55.134291', NULL),
	(10003261, 2, 'PW21A-TS100307GN-XS', 0, 0, '2021-04-15 12:57:55.329249', '2021-04-15 12:57:55.329249', NULL),
	(10003262, 2, 'PW21A-TS100307GN-S', 3, 0, '2021-04-15 12:57:55.157973', '2021-04-15 12:57:55.157973', NULL),
	(10003263, 2, 'PW21A-TS100307GN-M', 4, 0, '2021-04-15 12:57:55.137015', '2021-04-15 12:57:55.137015', NULL),
	(10003264, 2, 'PW21A-TS100307GN-L', 4, 0, '2021-04-15 12:57:55.148988', '2021-04-15 12:57:55.148988', NULL),
	(10003265, 2, 'PW21A-TS100307GN-XL', 2, 0, '2021-04-15 12:57:55.156009', '2021-04-15 12:57:55.156009', NULL),
	(10003266, 2, 'PW21A-TS100307GN-XXL', 2, 0, '2021-04-15 12:57:55.146220', '2021-04-15 12:57:55.146220', NULL),
	(10003267, 2, 'PW21A-TS100308GN-XS', 0, 0, '2021-04-15 12:57:55.148541', '2021-04-15 12:57:55.148541', NULL),
	(10003268, 2, 'PW21A-TS100308GN-S', 3, 0, '2021-04-15 12:57:55.173521', '2021-04-15 12:57:55.173521', NULL),
	(10003269, 2, 'PW21A-TS100308GN-M', 4, 0, '2021-04-15 12:57:55.161498', '2021-04-15 12:57:55.161498', NULL),
	(10003270, 2, 'PW21A-TS100308GN-L', 4, 0, '2021-04-15 12:57:55.159830', '2021-04-15 12:57:55.159830', NULL),
	(10003271, 2, 'PW21A-TS100308GN-XL', 3, 0, '2021-04-15 12:57:55.163321', '2021-04-15 12:57:55.163321', NULL),
	(10003272, 2, 'PW21A-TS100308GN-XXL', 2, 0, '2021-04-15 12:57:55.184077', '2021-04-15 12:57:55.184077', NULL),
	(10003273, 2, 'PW21A-TS100309GN-XS', 0, 0, '2021-04-15 12:57:55.177759', '2021-04-15 12:57:55.177759', NULL),
	(10003274, 2, 'PW21A-TS100309GN-S', 3, 0, '2021-04-15 12:57:55.174621', '2021-04-15 12:57:55.174621', NULL),
	(10003275, 2, 'PW21A-TS100309GN-M', 5, 0, '2021-04-15 12:57:55.175067', '2021-04-15 12:57:55.175067', NULL),
	(10003276, 2, 'PW21A-TS100309GN-L', 3, 0, '2021-04-15 12:57:55.186764', '2021-04-15 12:57:55.186764', NULL),
	(10003277, 2, 'PW21A-TS100309GN-XL', 3, 0, '2021-04-15 12:57:55.233156', '2021-04-15 12:57:55.233156', NULL),
	(10003278, 2, 'PW21A-TS100309GN-XXL', 1, 0, '2021-04-15 12:57:55.188775', '2021-04-15 12:57:55.188775', NULL),
	(10003279, 2, 'PW21A-SW100310BL-XS', 0, 0, '2021-04-15 12:57:55.187156', '2021-04-15 12:57:55.187156', NULL),
	(10003280, 2, 'PW21A-SW100310BL-S', 0, 0, '2021-04-15 12:57:55.204383', '2021-04-15 12:57:55.204383', NULL),
	(10003281, 2, 'PW21A-SW100310BL-M', 0, 0, '2021-04-15 12:57:55.190247', '2021-04-15 12:57:55.190247', NULL),
	(10003282, 2, 'PW21A-SW100310BL-L', 0, 0, '2021-04-15 12:57:55.189183', '2021-04-15 12:57:55.189183', NULL),
	(10003283, 2, 'PW21A-SW100310BL-XL', 0, 0, '2021-04-15 12:57:55.206725', '2021-04-15 12:57:55.206725', NULL),
	(10003284, 2, 'PW21A-SW100310BL-XXL', 0, 0, '2021-04-15 12:57:55.201787', '2021-04-15 12:57:55.201787', NULL),
	(10003285, 2, 'PW21A-SW100311BL-XS', 0, 0, '2021-04-15 12:57:55.220388', '2021-04-15 12:57:55.220388', NULL),
	(10003286, 2, 'PW21A-SW100311BL-S', 3, 0, '2021-04-15 12:57:55.208477', '2021-04-15 12:57:55.208477', NULL),
	(10003287, 2, 'PW21A-SW100311BL-M', 4, 0, '2021-04-15 12:57:55.203898', '2021-04-15 12:57:55.203898', NULL),
	(10003288, 2, 'PW21A-SW100311BL-L', 4, 0, '2021-04-15 12:57:55.221848', '2021-04-15 12:57:55.221848', NULL),
	(10003289, 2, 'PW21A-SW100311BL-XL', 3, 0, '2021-04-15 12:57:55.223811', '2021-04-15 12:57:55.223811', NULL),
	(10003290, 2, 'PW21A-SW100311BL-XXL', 0, 0, '2021-04-15 12:57:55.236065', '2021-04-15 12:57:55.236065', NULL),
	(10003291, 2, 'PW21A-SW100312BL-XS', 0, 0, '2021-04-15 12:57:55.220813', '2021-04-15 12:57:55.220813', NULL),
	(10003292, 2, 'PW21A-SW100312BL-S', 1, 0, '2021-04-15 12:57:55.224315', '2021-04-15 12:57:55.224315', NULL),
	(10003293, 2, 'PW21A-SW100312BL-M', 1, 0, '2021-04-15 12:57:55.238495', '2021-04-15 12:57:55.238495', NULL),
	(10003294, 2, 'PW21A-SW100312BL-L', 3, 0, '2021-04-15 12:57:55.251095', '2021-04-15 12:57:55.251095', NULL),
	(10003295, 2, 'PW21A-SW100312BL-XL', 2, 0, '2021-04-15 12:57:55.235150', '2021-04-15 12:57:55.235150', NULL),
	(10003296, 2, 'PW21A-SW100312BL-XXL', 2, 0, '2021-04-15 12:57:55.250512', '2021-04-15 12:57:55.250512', NULL),
	(10003297, 2, 'PW21A-SW100313BL-XS', 0, 0, '2021-04-15 12:57:55.240854', '2021-04-15 12:57:55.240854', NULL),
	(10003298, 2, 'PW21A-SW100313BL-S', 0, 0, '2021-04-15 12:57:55.254210', '2021-04-15 12:57:55.254210', NULL),
	(10003299, 2, 'PW21A-SW100313BL-M', 0, 0, '2021-04-15 12:57:55.247082', '2021-04-15 12:57:55.247082', NULL),
	(10003300, 2, 'PW21A-SW100313BL-L', 1, 0, '2021-04-15 12:57:55.255648', '2021-04-15 12:57:55.255648', NULL),
	(10003301, 2, 'PW21A-SW100313BL-XL', 2, 0, '2021-04-15 12:57:55.264183', '2021-04-15 12:57:55.264183', NULL),
	(10003302, 2, 'PW21A-SW100313BL-XXL', 1, 0, '2021-04-15 12:57:55.263335', '2021-04-15 12:57:55.263335', NULL),
	(10003303, 2, 'PW21A-SW100314DK-XS', 0, 0, '2021-04-15 12:57:55.267714', '2021-04-15 12:57:55.267714', NULL),
	(10003304, 2, 'PW21A-SW100314DK-S', 0, 0, '2021-04-15 12:57:55.271118', '2021-04-15 12:57:55.271118', NULL),
	(10003305, 2, 'PW21A-SW100314DK-M', 0, 0, '2021-04-15 12:57:55.275030', '2021-04-15 12:57:55.275030', NULL),
	(10003306, 2, 'PW21A-SW100314DK-L', 0, 0, '2021-04-15 12:57:55.276733', '2021-04-15 12:57:55.276733', NULL),
	(10003307, 2, 'PW21A-SW100314DK-XL', 0, 0, '2021-04-15 12:57:55.266281', '2021-04-15 12:57:55.266281', NULL),
	(10003308, 2, 'PW21A-SW100314DK-XXL', 0, 0, '2021-04-15 12:57:55.277932', '2021-04-15 12:57:55.277932', NULL),
	(10003309, 2, 'PW21A-SW100315BL-XS', 0, 0, '2021-04-15 12:57:55.303840', '2021-04-15 12:57:55.303840', NULL),
	(10003310, 2, 'PW21A-SW100315BL-S', 0, 0, '2021-04-15 12:57:55.278362', '2021-04-15 12:57:55.278362', NULL),
	(10003311, 2, 'PW21A-SW100315BL-M', 0, 0, '2021-04-15 12:57:55.290252', '2021-04-15 12:57:55.290252', NULL),
	(10003312, 2, 'PW21A-SW100315BL-L', 0, 0, '2021-04-15 12:57:55.282221', '2021-04-15 12:57:55.282221', NULL),
	(10003313, 2, 'PW21A-SW100315BL-XL', 0, 0, '2021-04-15 12:57:55.289804', '2021-04-15 12:57:55.289804', NULL),
	(10003314, 2, 'PW21A-SW100315BL-XXL', 0, 0, '2021-04-15 12:57:55.294199', '2021-04-15 12:57:55.294199', NULL),
	(10003315, 2, 'PW21A-SW100316BL-XS', 0, 0, '2021-04-15 12:57:55.292317', '2021-04-15 12:57:55.292317', NULL),
	(10003316, 2, 'PW21A-SW100316BL-S', 0, 0, '2021-04-15 12:57:55.303296', '2021-04-15 12:57:55.303296', NULL),
	(10003317, 2, 'PW21A-SW100316BL-M', 0, 0, '2021-04-15 12:57:55.300595', '2021-04-15 12:57:55.300595', NULL),
	(10003318, 2, 'PW21A-SW100316BL-L', 0, 0, '2021-04-15 12:57:55.307765', '2021-04-15 12:57:55.307765', NULL),
	(10003319, 2, 'PW21A-SW100316BL-XL', 0, 0, '2021-04-15 12:57:55.296669', '2021-04-15 12:57:55.296669', NULL),
	(10003320, 2, 'PW21A-SW100316BL-XXL', 0, 0, '2021-04-15 12:57:55.305036', '2021-04-15 12:57:55.305036', NULL),
	(10003321, 2, 'PW21A-SW100317BL-XS', 0, 0, '2021-04-15 12:57:55.320499', '2021-04-15 12:57:55.320499', NULL),
	(10003322, 2, 'PW21A-SW100317BL-S', 2, 0, '2021-04-15 12:57:55.316928', '2021-04-15 12:57:55.316928', NULL),
	(10003323, 2, 'PW21A-SW100317BL-M', 4, 0, '2021-04-15 12:57:55.319297', '2021-04-15 12:57:55.319297', NULL),
	(10003324, 2, 'PW21A-SW100317BL-L', 1, 0, '2021-04-15 12:57:55.328742', '2021-04-15 12:57:55.328742', NULL),
	(10003325, 2, 'PW21A-SW100317BL-XL', 0, 0, '2021-04-15 12:57:55.331678', '2021-04-15 12:57:55.331678', NULL),
	(10003326, 2, 'PW21A-SW100317BL-XXL', 1, 0, '2021-04-15 12:57:55.320950', '2021-04-15 12:57:55.320950', NULL),
	(10003327, 2, 'PW21A-SW100318OL-XS', 0, 0, '2021-04-15 12:57:55.324795', '2021-04-15 12:57:55.324795', NULL),
	(10003328, 2, 'PW21A-SW100318OL-S', 2, 0, '2021-04-15 12:57:55.332630', '2021-04-15 12:57:55.332630', NULL),
	(10003329, 2, 'PW21A-SW100318OL-M', 4, 0, '2021-04-15 12:57:55.379562', '2021-04-15 12:57:55.379562', NULL),
	(10003330, 2, 'PW21A-SW100318OL-L', 4, 0, '2021-04-15 12:57:55.332125', '2021-04-15 12:57:55.332125', NULL),
	(10003331, 2, 'PW21A-SW100318OL-XL', 0, 0, '2021-04-15 12:57:55.352654', '2021-04-15 12:57:55.352654', NULL),
	(10003332, 2, 'PW21A-SW100318OL-XXL', 1, 0, '2021-04-15 12:57:55.355646', '2021-04-15 12:57:55.355646', NULL),
	(10003333, 2, 'PW21A-SW100319WT-XS', 0, 0, '2021-04-15 12:57:55.349963', '2021-04-15 12:57:55.349963', NULL),
	(10003334, 2, 'PW21A-SW100319WT-S', 0, 0, '2021-04-15 12:57:55.424923', '2021-04-15 12:57:55.424923', NULL),
	(10003335, 2, 'PW21A-SW100319WT-M', 0, 0, '2021-04-15 12:57:55.343970', '2021-04-15 12:57:55.343970', NULL),
	(10003336, 2, 'PW21A-SW100319WT-L', 3, 0, '2021-04-15 12:57:55.362288', '2021-04-15 12:57:55.362288', NULL),
	(10003337, 2, 'PW21A-SW100319WT-XL', 2, 0, '2021-04-15 12:57:55.361818', '2021-04-15 12:57:55.361818', NULL),
	(10003338, 2, 'PW21A-SW100319WT-XXL', 1, 0, '2021-04-15 12:57:55.353121', '2021-04-15 12:57:55.353121', NULL),
	(10003339, 2, 'PW21A-SW100320BL-XS', 0, 0, '2021-04-15 12:57:55.359580', '2021-04-15 12:57:55.359580', NULL),
	(10003340, 2, 'PW21A-SW100320BL-S', 0, 0, '2021-04-15 12:57:55.379071', '2021-04-15 12:57:55.379071', NULL),
	(10003341, 2, 'PW21A-SW100320BL-M', 0, 0, '2021-04-15 12:57:55.364722', '2021-04-15 12:57:55.364722', NULL),
	(10003342, 2, 'PW21A-SW100320BL-L', 0, 0, '2021-04-15 12:57:55.365205', '2021-04-15 12:57:55.365205', NULL),
	(10003343, 2, 'PW21A-SW100320BL-XL', 0, 0, '2021-04-15 12:57:55.376354', '2021-04-15 12:57:55.376354', NULL),
	(10003344, 2, 'PW21A-SW100320BL-XXL', 0, 0, '2021-04-15 12:57:55.387484', '2021-04-15 12:57:55.387484', NULL),
	(10003345, 2, 'PW21A-SW100321BL-XS', 0, 0, '2021-04-15 12:57:55.382143', '2021-04-15 12:57:55.382143', NULL),
	(10003346, 2, 'PW21A-SW100321BL-S', 0, 0, '2021-04-15 12:57:55.382915', '2021-04-15 12:57:55.382915', NULL),
	(10003347, 2, 'PW21A-SW100321BL-M', 0, 0, '2021-04-15 12:57:55.392418', '2021-04-15 12:57:55.392418', NULL),
	(10003348, 2, 'PW21A-SW100321BL-L', 0, 0, '2021-04-15 12:57:55.391927', '2021-04-15 12:57:55.391927', NULL),
	(10003349, 2, 'PW21A-SW100321BL-XL', 0, 0, '2021-04-15 12:57:55.411648', '2021-04-15 12:57:55.411648', NULL),
	(10003350, 2, 'PW21A-SW100321BL-XXL', 0, 0, '2021-04-15 12:57:55.407614', '2021-04-15 12:57:55.407614', NULL),
	(10003351, 2, 'PW21A-SW100322BL-XS', 0, 0, '2021-04-15 12:57:55.396126', '2021-04-15 12:57:55.396126', NULL),
	(10003352, 2, 'PW21A-SW100322BL-S', 0, 0, '2021-04-15 12:57:55.397149', '2021-04-15 12:57:55.397149', NULL),
	(10003353, 2, 'PW21A-SW100322BL-M', 0, 0, '2021-04-15 12:57:55.411112', '2021-04-15 12:57:55.411112', NULL),
	(10003354, 2, 'PW21A-SW100322BL-L', 0, 0, '2021-04-15 12:57:55.420884', '2021-04-15 12:57:55.420884', NULL),
	(10003355, 2, 'PW21A-SW100322BL-XL', 0, 0, '2021-04-15 12:57:55.409588', '2021-04-15 12:57:55.409588', NULL),
	(10003356, 2, 'PW21A-SW100322BL-XXL', 0, 0, '2021-04-15 12:57:55.415386', '2021-04-15 12:57:55.415386', NULL),
	(10003357, 2, 'PW21A-SW100323BL-XS', 0, 0, '2021-04-15 12:57:55.502508', '2021-04-15 12:57:55.502508', NULL),
	(10003358, 2, 'PW21A-SW100323BL-S', 0, 0, '2021-04-15 12:57:55.424452', '2021-04-15 12:57:55.424452', NULL),
	(10003359, 2, 'PW21A-SW100323BL-M', 0, 0, '2021-04-15 12:57:55.428227', '2021-04-15 12:57:55.428227', NULL),
	(10003360, 2, 'PW21A-SW100323BL-L', 0, 0, '2021-04-15 12:57:55.437106', '2021-04-15 12:57:55.437106', NULL),
	(10003361, 2, 'PW21A-SW100323BL-XL', 0, 0, '2021-04-15 12:57:55.436633', '2021-04-15 12:57:55.436633', NULL),
	(10003362, 2, 'PW21A-SW100323BL-XXL', 0, 0, '2021-04-15 12:57:55.428581', '2021-04-15 12:57:55.428581', NULL),
	(10003363, 2, 'PW21A-SW100324BL-XS', 0, 0, '2021-04-15 12:57:55.439974', '2021-04-15 12:57:55.439974', NULL),
	(10003364, 2, 'PW21A-SW100324BL-S', 3, 0, '2021-04-15 12:57:55.448729', '2021-04-15 12:57:55.448729', NULL),
	(10003365, 2, 'PW21A-SW100324BL-M', 3, 0, '2021-04-15 12:57:55.455028', '2021-04-15 12:57:55.455028', NULL),
	(10003366, 2, 'PW21A-SW100324BL-L', 5, 0, '2021-04-15 12:57:55.441308', '2021-04-15 12:57:55.441308', NULL),
	(10003367, 2, 'PW21A-SW100324BL-XL', 3, 0, '2021-04-15 12:57:55.444007', '2021-04-15 12:57:55.444007', NULL),
	(10003368, 2, 'PW21A-SW100324BL-XXL', 2, 0, '2021-04-15 12:57:55.452380', '2021-04-15 12:57:55.452380', NULL),
	(10003369, 2, 'PW21A-SW100325BL-XS', 0, 0, '2021-04-15 12:57:55.464313', '2021-04-15 12:57:55.464313', NULL),
	(10003370, 2, 'PW21A-SW100325BL-S', 3, 0, '2021-04-15 12:57:55.450964', '2021-04-15 12:57:55.450964', NULL),
	(10003371, 2, 'PW21A-SW100325BL-M', 4, 0, '2021-04-15 12:57:55.456941', '2021-04-15 12:57:55.456941', NULL),
	(10003372, 2, 'PW21A-SW100325BL-L', 4, 0, '2021-04-15 12:57:55.468678', '2021-04-15 12:57:55.468678', NULL),
	(10003373, 2, 'PW21A-SW100325BL-XL', 3, 0, '2021-04-15 12:57:55.467063', '2021-04-15 12:57:55.467063', NULL),
	(10003374, 2, 'PW21A-SW100325BL-XXL', 2, 0, '2021-04-15 12:57:55.468148', '2021-04-15 12:57:55.468148', NULL),
	(10003375, 2, 'PW21A-SW100326BL-XS', 0, 0, '2021-04-15 12:57:55.475873', '2021-04-15 12:57:55.475873', NULL),
	(10003376, 2, 'PW21A-SW100326BL-S', 3, 0, '2021-04-15 12:57:55.564012', '2021-04-15 12:57:55.564012', NULL),
	(10003377, 2, 'PW21A-SW100326BL-M', 4, 0, '2021-04-15 12:57:55.471458', '2021-04-15 12:57:55.471458', NULL),
	(10003378, 2, 'PW21A-SW100326BL-L', 4, 0, '2021-04-15 12:57:55.479008', '2021-04-15 12:57:55.479008', NULL),
	(10003379, 2, 'PW21A-SW100326BL-XL', 3, 0, '2021-04-15 12:57:55.481852', '2021-04-15 12:57:55.481852', NULL),
	(10003380, 2, 'PW21A-SW100326BL-XXL', 2, 0, '2021-04-15 12:57:55.479419', '2021-04-15 12:57:55.479419', NULL),
	(10003381, 2, 'PW21A-SW100327BL-XS', 0, 0, '2021-04-15 12:57:55.483057', '2021-04-15 12:57:55.483057', NULL),
	(10003382, 2, 'PW21A-SW100327BL-S', 3, 0, '2021-04-15 12:57:55.495220', '2021-04-15 12:57:55.495220', NULL),
	(10003383, 2, 'PW21A-SW100327BL-M', 4, 0, '2021-04-15 12:57:55.499569', '2021-04-15 12:57:55.499569', NULL),
	(10003384, 2, 'PW21A-SW100327BL-L', 4, 0, '2021-04-15 12:57:55.497783', '2021-04-15 12:57:55.497783', NULL),
	(10003385, 2, 'PW21A-SW100327BL-XL', 3, 0, '2021-04-15 12:57:55.496419', '2021-04-15 12:57:55.496419', NULL),
	(10003386, 2, 'PW21A-SW100327BL-XXL', 2, 0, '2021-04-15 12:57:55.509901', '2021-04-15 12:57:55.509901', NULL),
	(10003387, 2, 'PW21A-SW100328BL-XS', 0, 0, '2021-04-15 12:57:55.497309', '2021-04-15 12:57:55.497309', NULL),
	(10003388, 2, 'PW21A-SW100328BL-S', 3, 0, '2021-04-15 12:57:55.506034', '2021-04-15 12:57:55.506034', NULL),
	(10003389, 2, 'PW21A-SW100328BL-M', 4, 0, '2021-04-15 12:57:55.513688', '2021-04-15 12:57:55.513688', NULL),
	(10003390, 2, 'PW21A-SW100328BL-L', 4, 0, '2021-04-15 12:57:55.512684', '2021-04-15 12:57:55.512684', NULL),
	(10003391, 2, 'PW21A-SW100328BL-XL', 3, 0, '2021-04-15 12:57:55.527762', '2021-04-15 12:57:55.527762', NULL),
	(10003392, 2, 'PW21A-SW100328BL-XXL', 2, 0, '2021-04-15 12:57:55.524451', '2021-04-15 12:57:55.524451', NULL),
	(10003393, 2, 'PW21A-SW100329BL-XS', 0, 0, '2021-04-15 12:57:55.521114', '2021-04-15 12:57:55.521114', NULL),
	(10003394, 2, 'PW21A-SW100329BL-S', 3, 0, '2021-04-15 12:57:55.526526', '2021-04-15 12:57:55.526526', NULL),
	(10003395, 2, 'PW21A-SW100329BL-M', 4, 0, '2021-04-15 12:57:55.521967', '2021-04-15 12:57:55.521967', NULL),
	(10003396, 2, 'PW21A-SW100329BL-L', 4, 0, '2021-04-15 12:57:55.535120', '2021-04-15 12:57:55.535120', NULL),
	(10003397, 2, 'PW21A-SW100329BL-XL', 3, 0, '2021-04-15 12:57:55.524866', '2021-04-15 12:57:55.524866', NULL),
	(10003398, 2, 'PW21A-SW100329BL-XXL', 2, 0, '2021-04-15 12:57:55.532350', '2021-04-15 12:57:55.532350', NULL),
	(10003399, 2, 'PW21A-SW100330BL-XS', 0, 0, '2021-04-15 12:57:55.546017', '2021-04-15 12:57:55.546017', NULL),
	(10003400, 2, 'PW21A-SW100330BL-S', 3, 0, '2021-04-15 12:57:55.539067', '2021-04-15 12:57:55.539067', NULL),
	(10003401, 2, 'PW21A-SW100330BL-M', 4, 0, '2021-04-15 12:57:55.541882', '2021-04-15 12:57:55.541882', NULL),
	(10003402, 2, 'PW21A-SW100330BL-L', 4, 0, '2021-04-15 12:57:55.549614', '2021-04-15 12:57:55.549614', NULL),
	(10003403, 2, 'PW21A-SW100330BL-XL', 3, 0, '2021-04-15 12:57:55.547491', '2021-04-15 12:57:55.547491', NULL),
	(10003404, 2, 'PW21A-SW100330BL-XXL', 2, 0, '2021-04-15 12:57:55.566093', '2021-04-15 12:57:55.566093', NULL),
	(10003405, 2, 'PW21A-PN100331BL-28', 0, 0, '2021-04-15 12:57:55.552134', '2021-04-15 12:57:55.552134', NULL),
	(10003406, 2, 'PW21A-PN100331BL-30', 0, 0, '2021-04-15 12:57:55.555101', '2021-04-15 12:57:55.555101', NULL),
	(10003407, 2, 'PW21A-PN100331BL-32', 0, 0, '2021-04-15 12:57:55.550967', '2021-04-15 12:57:55.550967', NULL),
	(10003408, 2, 'PW21A-PN100331BL-34', 0, 0, '2021-04-15 12:57:55.655123', '2021-04-15 12:57:55.655123', NULL),
	(10003409, 2, 'PW21A-PN100331BL-36', 0, 0, '2021-04-15 12:57:55.573216', '2021-04-15 12:57:55.573216', NULL),
	(10003410, 2, 'PW21A-PN100332BL-28', 1, 0, '2021-04-15 12:57:55.560447', '2021-04-15 12:57:55.560447', NULL),
	(10003411, 2, 'PW21A-PN100332BL-30', 2, 0, '2021-04-15 12:57:55.568787', '2021-04-15 12:57:55.568787', NULL),
	(10003412, 2, 'PW21A-PN100332BL-32', 2, 0, '2021-04-15 12:57:55.578670', '2021-04-15 12:57:55.578670', NULL),
	(10003413, 2, 'PW21A-PN100332BL-34', 0, 0, '2021-04-15 12:57:55.576794', '2021-04-15 12:57:55.576794', NULL),
	(10003414, 2, 'PW21A-PN100332BL-36', 1, 0, '2021-04-15 12:57:55.574980', '2021-04-15 12:57:55.574980', NULL),
	(10003415, 2, 'PW21A-PN100333BL-28', 2, 0, '2021-04-15 12:57:55.585658', '2021-04-15 12:57:55.585658', NULL),
	(10003416, 2, 'PW21A-PN100333BL-30', 2, 0, '2021-04-15 12:57:55.579814', '2021-04-15 12:57:55.579814', NULL),
	(10003417, 2, 'PW21A-PN100333BL-32', 2, 0, '2021-04-15 12:57:55.580540', '2021-04-15 12:57:55.580540', NULL),
	(10003418, 2, 'PW21A-PN100333BL-34', 2, 0, '2021-04-15 12:57:55.583826', '2021-04-15 12:57:55.583826', NULL),
	(10003419, 2, 'PW21A-PN100333BL-36', 0, 0, '2021-04-15 12:57:55.590346', '2021-04-15 12:57:55.590346', NULL),
	(10003420, 2, 'PW21A-PN100334BL-28', 0, 0, '2021-04-15 12:57:55.620312', '2021-04-15 12:57:55.620312', NULL),
	(10003421, 2, 'PW21A-PN100334BL-30', 0, 0, '2021-04-15 12:57:55.594216', '2021-04-15 12:57:55.594216', NULL),
	(10003422, 2, 'PW21A-PN100334BL-32', 0, 0, '2021-04-15 12:57:55.590935', '2021-04-15 12:57:55.590935', NULL),
	(10003423, 2, 'PW21A-PN100334BL-34', 0, 0, '2021-04-15 12:57:55.595517', '2021-04-15 12:57:55.595517', NULL),
	(10003424, 2, 'PW21A-PN100334BL-36', 0, 0, '2021-04-15 12:57:55.599854', '2021-04-15 12:57:55.599854', NULL),
	(10003425, 2, 'PW21A-PN100335BL-28', 2, 0, '2021-04-15 12:57:55.615852', '2021-04-15 12:57:55.615852', NULL),
	(10003426, 2, 'PW21A-PN100335BL-30', 2, 0, '2021-04-15 12:57:55.596775', '2021-04-15 12:57:55.596775', NULL),
	(10003427, 2, 'PW21A-PN100335BL-32', 2, 0, '2021-04-15 12:57:55.600158', '2021-04-15 12:57:55.600158', NULL),
	(10003428, 2, 'PW21A-PN100335BL-34', 1, 0, '2021-04-15 12:57:55.601401', '2021-04-15 12:57:55.601401', NULL),
	(10003429, 2, 'PW21A-PN100335BL-36', 0, 0, '2021-04-15 12:57:55.602964', '2021-04-15 12:57:55.602964', NULL),
	(10003430, 2, 'PW21A-PN100336GN-28', 2, 0, '2021-04-15 12:57:55.637909', '2021-04-15 12:57:55.637909', NULL),
	(10003431, 2, 'PW21A-PN100336GN-30', 2, 0, '2021-04-15 12:57:55.617888', '2021-04-15 12:57:55.617888', NULL),
	(10003432, 2, 'PW21A-PN100336GN-32', 2, 0, '2021-04-15 12:57:55.614156', '2021-04-15 12:57:55.614156', NULL),
	(10003433, 2, 'PW21A-PN100336GN-34', 2, 0, '2021-04-15 12:57:55.623798', '2021-04-15 12:57:55.623798', NULL),
	(10003434, 2, 'PW21A-PN100336GN-36', 1, 0, '2021-04-15 12:57:55.606073', '2021-04-15 12:57:55.606073', NULL),
	(10003435, 2, 'PW21A-PN100337CM-28', 2, 0, '2021-04-15 12:57:55.618232', '2021-04-15 12:57:55.618232', NULL),
	(10003436, 2, 'PW21A-PN100337CM-30', 2, 0, '2021-04-15 12:57:55.626212', '2021-04-15 12:57:55.626212', NULL),
	(10003437, 2, 'PW21A-PN100337CM-32', 2, 0, '2021-04-15 12:57:55.629599', '2021-04-15 12:57:55.629599', NULL),
	(10003438, 2, 'PW21A-PN100337CM-34', 2, 0, '2021-04-15 12:57:55.628221', '2021-04-15 12:57:55.628221', NULL),
	(10003439, 2, 'PW21A-PN100337CM-36', 1, 0, '2021-04-15 12:57:55.635077', '2021-04-15 12:57:55.635077', NULL),
	(10003440, 2, 'PW21A-PN100338BL-28', 2, 0, '2021-04-15 12:57:55.645926', '2021-04-15 12:57:55.645926', NULL),
	(10003441, 2, 'PW21A-PN100338BL-30', 2, 0, '2021-04-15 12:57:55.640680', '2021-04-15 12:57:55.640680', NULL),
	(10003442, 2, 'PW21A-PN100338BL-32', 2, 0, '2021-04-15 12:57:55.628660', '2021-04-15 12:57:55.628660', NULL),
	(10003443, 2, 'PW21A-PN100338BL-34', 2, 0, '2021-04-15 12:57:55.632409', '2021-04-15 12:57:55.632409', NULL),
	(10003444, 2, 'PW21A-PN100338BL-36', 1, 0, '2021-04-15 12:57:55.641013', '2021-04-15 12:57:55.641013', NULL),
	(10003445, 2, 'PW21A-PN100339CM-28', 2, 0, '2021-04-15 12:57:55.639346', '2021-04-15 12:57:55.639346', NULL),
	(10003446, 2, 'PW21A-PN100339CM-30', 2, 0, '2021-04-15 12:57:55.649493', '2021-04-15 12:57:55.649493', NULL),
	(10003447, 2, 'PW21A-PN100339CM-32', 1, 0, '2021-04-15 12:57:55.648747', '2021-04-15 12:57:55.648747', NULL),
	(10003448, 2, 'PW21A-PN100339CM-34', 2, 0, '2021-04-15 12:57:55.646845', '2021-04-15 12:57:55.646845', NULL),
	(10003449, 2, 'PW21A-PN100339CM-36', 0, 0, '2021-04-15 12:57:55.651919', '2021-04-15 12:57:55.651919', NULL),
	(10003450, 2, 'PW21A-PN100340OL-28', 2, 0, '2021-04-15 12:57:55.721760', '2021-04-15 12:57:55.721760', NULL),
	(10003451, 2, 'PW21A-PN100340OL-30', 2, 0, '2021-04-15 12:57:55.658249', '2021-04-15 12:57:55.658249', NULL),
	(10003452, 2, 'PW21A-PN100340OL-32', 2, 0, '2021-04-15 12:57:55.792547', '2021-04-15 12:57:55.792547', NULL),
	(10003453, 2, 'PW21A-PN100340OL-34', 2, 0, '2021-04-15 12:57:55.657501', '2021-04-15 12:57:55.657501', NULL),
	(10003454, 2, 'PW21A-PN100340OL-36', 1, 0, '2021-04-15 12:57:55.682229', '2021-04-15 12:57:55.682229', NULL),
	(10003455, 2, 'PW21A-PN100341DM-28', 2, 0, '2021-04-15 12:57:55.669273', '2021-04-15 12:57:55.669273', NULL),
	(10003456, 2, 'PW21A-PN100341DM-30', 2, 0, '2021-04-15 12:57:55.773558', '2021-04-15 12:57:55.773558', NULL),
	(10003457, 2, 'PW21A-PN100341DM-32', 2, 0, '2021-04-15 12:57:55.660295', '2021-04-15 12:57:55.660295', NULL),
	(10003458, 2, 'PW21A-PN100341DM-34', 2, 0, '2021-04-15 12:57:55.667871', '2021-04-15 12:57:55.667871', NULL),
	(10003459, 2, 'PW21A-PN100341DM-36', 0, 0, '2021-04-15 12:57:55.674541', '2021-04-15 12:57:55.674541', NULL),
	(10003460, 2, 'PW21A-PN100342DM-28', 2, 0, '2021-04-15 12:57:55.667495', '2021-04-15 12:57:55.667495', NULL),
	(10003461, 2, 'PW21A-PN100342DM-30', 2, 0, '2021-04-15 12:57:55.660621', '2021-04-15 12:57:55.660621', NULL),
	(10003462, 2, 'PW21A-PN100342DM-32', 2, 0, '2021-04-15 12:57:55.697548', '2021-04-15 12:57:55.697548', NULL),
	(10003463, 2, 'PW21A-PN100342DM-34', 2, 0, '2021-04-15 12:57:55.675536', '2021-04-15 12:57:55.675536', NULL),
	(10003464, 2, 'PW21A-PN100342DM-36', 0, 0, '2021-04-15 12:57:55.667062', '2021-04-15 12:57:55.667062', NULL),
	(10003465, 2, 'PW21A-PN100343DM-28', 2, 0, '2021-04-15 12:57:55.697278', '2021-04-15 12:57:55.697278', NULL),
	(10003466, 2, 'PW21A-PN100343DM-30', 2, 0, '2021-04-15 12:57:55.695522', '2021-04-15 12:57:55.695522', NULL),
	(10003467, 2, 'PW21A-PN100343DM-32', 2, 0, '2021-04-15 12:57:55.696768', '2021-04-15 12:57:55.696768', NULL),
	(10003468, 2, 'PW21A-PN100343DM-34', 2, 0, '2021-04-15 12:57:55.689233', '2021-04-15 12:57:55.689233', NULL),
	(10003469, 2, 'PW21A-PN100343DM-36', 0, 0, '2021-04-15 12:57:55.707877', '2021-04-15 12:57:55.707877', NULL),
	(10003470, 2, 'PW21A-WL100344BW-All', 2, 0, '2021-04-15 12:57:55.722111', '2021-04-15 12:57:55.722111', NULL),
	(10003471, 2, 'PW21A-WL100345BW-All', 2, 0, '2021-04-15 12:57:55.685509', '2021-04-15 12:57:55.685509', NULL),
	(10003472, 2, 'PW21A-WL100346BW-All', 2, 0, '2021-04-15 12:57:55.683096', '2021-04-15 12:57:55.683096', NULL),
	(10003473, 2, 'PW21A-HM100347BL-XS', 0, 0, '2021-04-15 12:57:55.700078', '2021-04-15 12:57:55.700078', NULL),
	(10003474, 2, 'PW21A-HM100347BL-S', 0, 0, '2021-04-15 12:57:55.708157', '2021-04-15 12:57:55.708157', NULL),
	(10003475, 2, 'PW21A-HM100347BL-M', 0, 0, '2021-04-15 12:57:55.700824', '2021-04-15 12:57:55.700824', NULL),
	(10003476, 2, 'PW21A-HM100347BL-L', 0, 0, '2021-04-15 12:57:55.710746', '2021-04-15 12:57:55.710746', NULL),
	(10003477, 2, 'PW21A-HM100347BL-XL', 0, 0, '2021-04-15 12:57:55.724238', '2021-04-15 12:57:55.724238', NULL),
	(10003478, 2, 'PW21A-HM100347BL-XXL', 0, 0, '2021-04-15 12:57:55.723607', '2021-04-15 12:57:55.723607', NULL),
	(10003479, 2, 'PW21A-HM100348WT-XS', 0, 0, '2021-04-15 12:57:55.752550', '2021-04-15 12:57:55.752550', NULL),
	(10003480, 2, 'PW21A-HM100348WT-S', 0, 0, '2021-04-15 12:57:55.711130', '2021-04-15 12:57:55.711130', NULL),
	(10003481, 2, 'PW21A-HM100348WT-M', 1, 0, '2021-04-15 12:57:55.745679', '2021-04-15 12:57:55.745679', NULL),
	(10003482, 2, 'PW21A-HM100348WT-L', 0, 0, '2021-04-15 12:57:55.750470', '2021-04-15 12:57:55.750470', NULL),
	(10003483, 2, 'PW21A-HM100348WT-XL', 0, 0, '2021-04-15 12:57:55.737711', '2021-04-15 12:57:55.737711', NULL),
	(10003484, 2, 'PW21A-HM100348WT-XXL', 0, 0, '2021-04-15 12:57:55.749288', '2021-04-15 12:57:55.749288', NULL),
	(10003485, 2, 'PW21A-HM100349BL-XS', 0, 0, '2021-04-15 12:57:55.724551', '2021-04-15 12:57:55.724551', NULL),
	(10003486, 2, 'PW21A-HM100349BL-S', 0, 0, '2021-04-15 12:57:55.723936', '2021-04-15 12:57:55.723936', NULL),
	(10003487, 2, 'PW21A-HM100349BL-M', 1, 0, '2021-04-15 12:57:55.752986', '2021-04-15 12:57:55.752986', NULL),
	(10003488, 2, 'PW21A-HM100349BL-L', 1, 0, '2021-04-15 12:57:55.744954', '2021-04-15 12:57:55.744954', NULL),
	(10003489, 2, 'PW21A-HM100349BL-XL', 1, 0, '2021-04-15 12:57:55.746972', '2021-04-15 12:57:55.746972', NULL),
	(10003490, 2, 'PW21A-HM100349BL-XXL', 0, 0, '2021-04-15 12:57:55.748732', '2021-04-15 12:57:55.748732', NULL),
	(10003491, 2, 'PW21A-HM100350BL-XS', 0, 0, '2021-04-15 12:57:55.844748', '2021-04-15 12:57:55.844748', NULL),
	(10003492, 2, 'PW21A-HM100350BL-S', 1, 0, '2021-04-15 12:57:55.756497', '2021-04-15 12:57:55.756497', NULL),
	(10003493, 2, 'PW21A-HM100350BL-M', 0, 0, '2021-04-15 12:57:55.769714', '2021-04-15 12:57:55.769714', NULL),
	(10003494, 2, 'PW21A-HM100350BL-L', 1, 0, '2021-04-15 12:57:55.763315', '2021-04-15 12:57:55.763315', NULL),
	(10003495, 2, 'PW21A-HM100350BL-XL', 0, 0, '2021-04-15 12:57:55.811548', '2021-04-15 12:57:55.811548', NULL),
	(10003496, 2, 'PW21A-HM100350BL-XXL', 0, 0, '2021-04-15 12:57:55.775996', '2021-04-15 12:57:55.775996', NULL),
	(10003497, 2, 'PW21A-HM100351BL-XS', 0, 0, '2021-04-15 12:57:55.770130', '2021-04-15 12:57:55.770130', NULL),
	(10003498, 2, 'PW21A-HM100351BL-S', 0, 0, '2021-04-15 12:57:55.780409', '2021-04-15 12:57:55.780409', NULL),
	(10003499, 2, 'PW21A-HM100351BL-M', 1, 0, '2021-04-15 12:57:55.778049', '2021-04-15 12:57:55.778049', NULL),
	(10003500, 2, 'PW21A-HM100351BL-L', 1, 0, '2021-04-15 12:57:55.773101', '2021-04-15 12:57:55.773101', NULL),
	(10003501, 2, 'PW21A-HM100351BL-XL', 0, 0, '2021-04-15 12:57:55.788418', '2021-04-15 12:57:55.788418', NULL),
	(10003502, 2, 'PW21A-HM100351BL-XXL', 0, 0, '2021-04-15 12:57:55.819929', '2021-04-15 12:57:55.819929', NULL),
	(10003503, 2, 'PW21A-HM100352BL-XS', 0, 0, '2021-04-15 12:57:55.776624', '2021-04-15 12:57:55.776624', NULL),
	(10003504, 2, 'PW21A-HM100352BL-S', 1, 0, '2021-04-15 12:57:55.793050', '2021-04-15 12:57:55.793050', NULL),
	(10003505, 2, 'PW21A-HM100352BL-M', 1, 0, '2021-04-15 12:57:55.778419', '2021-04-15 12:57:55.778419', NULL),
	(10003506, 2, 'PW21A-HM100352BL-L', 0, 0, '2021-04-15 12:57:55.821763', '2021-04-15 12:57:55.821763', NULL),
	(10003507, 2, 'PW21A-HM100352BL-XL', 0, 0, '2021-04-15 12:57:55.797787', '2021-04-15 12:57:55.797787', NULL),
	(10003508, 2, 'PW21A-HM100352BL-XXL', 0, 0, '2021-04-15 12:57:55.815098', '2021-04-15 12:57:55.815098', NULL),
	(10003509, 2, 'PW21A-HM100353WT-XS', 0, 0, '2021-04-15 12:57:55.793871', '2021-04-15 12:57:55.793871', NULL),
	(10003510, 2, 'PW21A-HM100353WT-S', 1, 0, '2021-04-15 12:57:55.795503', '2021-04-15 12:57:55.795503', NULL),
	(10003511, 2, 'PW21A-HM100353WT-M', 0, 0, '2021-04-15 12:57:55.806362', '2021-04-15 12:57:55.806362', NULL),
	(10003512, 2, 'PW21A-HM100353WT-L', 0, 0, '2021-04-15 12:57:55.796201', '2021-04-15 12:57:55.796201', NULL),
	(10003513, 2, 'PW21A-HM100353WT-XL', 0, 0, '2021-04-15 12:57:55.798088', '2021-04-15 12:57:55.798088', NULL),
	(10003514, 2, 'PW21A-HM100353WT-XXL', 0, 0, '2021-04-15 12:57:55.798912', '2021-04-15 12:57:55.798912', NULL),
	(10003515, 2, 'PW21A-HM100354WT-XS', 0, 0, '2021-04-15 12:57:55.801154', '2021-04-15 12:57:55.801154', NULL),
	(10003516, 2, 'PW21A-HM100354WT-S', 0, 0, '2021-04-15 12:57:55.812847', '2021-04-15 12:57:55.812847', NULL),
	(10003517, 2, 'PW21A-HM100354WT-M', 0, 0, '2021-04-15 12:57:55.814588', '2021-04-15 12:57:55.814588', NULL),
	(10003518, 2, 'PW21A-HM100354WT-L', 0, 0, '2021-04-15 12:57:55.817585', '2021-04-15 12:57:55.817585', NULL),
	(10003519, 2, 'PW21A-HM100354WT-XL', 0, 0, '2021-04-15 12:57:55.909375', '2021-04-15 12:57:55.909375', NULL),
	(10003520, 2, 'PW21A-HM100354WT-XXL', 0, 0, '2021-04-15 12:57:55.911912', '2021-04-15 12:57:55.911912', NULL),
	(10003521, 2, 'PW21A-HM100355RD-XS', 0, 0, '2021-04-15 12:57:55.816198', '2021-04-15 12:57:55.816198', NULL),
	(10003522, 2, 'PW21A-HM100355RD-S', 0, 0, '2021-04-15 12:57:55.902190', '2021-04-15 12:57:55.902190', NULL),
	(10003523, 2, 'PW21A-HM100355RD-M', 0, 0, '2021-04-15 12:57:55.817282', '2021-04-15 12:57:55.817282', NULL),
	(10003524, 2, 'PW21A-HM100355RD-L', 0, 0, '2021-04-15 12:57:55.836670', '2021-04-15 12:57:55.836670', NULL),
	(10003525, 2, 'PW21A-HM100355RD-XL', 0, 0, '2021-04-15 12:57:55.846138', '2021-04-15 12:57:55.846138', NULL),
	(10003526, 2, 'PW21A-HM100355RD-XXL', 0, 0, '2021-04-15 12:57:55.845235', '2021-04-15 12:57:55.845235', NULL),
	(10003527, 2, 'PW21A-HM100356YW -XS', 0, 0, '2021-04-15 12:57:55.898699', '2021-04-15 12:57:55.898699', NULL),
	(10003528, 2, 'PW21A-HM100356YW -S', 0, 0, '2021-04-15 12:57:55.828214', '2021-04-15 12:57:55.828214', NULL),
	(10003529, 2, 'PW21A-HM100356YW -M', 1, 0, '2021-04-15 12:57:55.850558', '2021-04-15 12:57:55.850558', NULL),
	(10003530, 2, 'PW21A-HM100356YW -L', 0, 0, '2021-04-15 12:57:55.851834', '2021-04-15 12:57:55.851834', NULL),
	(10003531, 2, 'PW21A-HM100356YW -XL', 0, 0, '2021-04-15 12:57:55.847244', '2021-04-15 12:57:55.847244', NULL),
	(10003532, 2, 'PW21A-HM100356YW -XXL', 0, 0, '2021-04-15 12:57:55.849232', '2021-04-15 12:57:55.849232', NULL),
	(10003533, 2, 'PW21A-HM100357YW -XS', 0, 0, '2021-04-15 12:57:55.870525', '2021-04-15 12:57:55.870525', NULL),
	(10003534, 2, 'PW21A-HM100357YW -S', 0, 0, '2021-04-15 12:57:55.863111', '2021-04-15 12:57:55.863111', NULL),
	(10003535, 2, 'PW21A-HM100357YW -M', 0, 0, '2021-04-15 12:57:55.848047', '2021-04-15 12:57:55.848047', NULL),
	(10003536, 2, 'PW21A-HM100357YW -L', 0, 0, '2021-04-15 12:57:55.862135', '2021-04-15 12:57:55.862135', NULL),
	(10003537, 2, 'PW21A-HM100357YW -XL', 0, 0, '2021-04-15 12:57:55.874046', '2021-04-15 12:57:55.874046', NULL),
	(10003538, 2, 'PW21A-HM100357YW -XXL', 0, 0, '2021-04-15 12:57:55.868875', '2021-04-15 12:57:55.868875', NULL),
	(10003539, 2, 'PW21A-HM100358WT-XS', 0, 0, '2021-04-15 12:57:55.871840', '2021-04-15 12:57:55.871840', NULL),
	(10003540, 2, 'PW21A-HM100358WT-S', 0, 0, '2021-04-15 12:57:55.873693', '2021-04-15 12:57:55.873693', NULL),
	(10003541, 2, 'PW21A-HM100358WT-M', 0, 0, '2021-04-15 12:57:56.003568', '2021-04-15 12:57:56.003568', NULL),
	(10003542, 2, 'PW21A-HM100358WT-L', 0, 0, '2021-04-15 12:57:55.873319', '2021-04-15 12:57:55.873319', NULL),
	(10003543, 2, 'PW21A-HM100358WT-XL', 0, 0, '2021-04-15 12:57:55.889355', '2021-04-15 12:57:55.889355', NULL),
	(10003544, 2, 'PW21A-HM100358WT-XXL', 0, 0, '2021-04-15 12:57:55.893021', '2021-04-15 12:57:55.893021', NULL),
	(10003545, 2, 'PW21A-JK100359NV-XS', 0, 0, '2021-04-15 12:57:55.868464', '2021-04-15 12:57:55.868464', NULL),
	(10003546, 2, 'PW21A-JK100359NV-S', 0, 0, '2021-04-15 12:57:55.914847', '2021-04-15 12:57:55.914847', NULL),
	(10003547, 2, 'PW21A-JK100359NV-M', 0, 0, '2021-04-15 12:57:55.886548', '2021-04-15 12:57:55.886548', NULL),
	(10003548, 2, 'PW21A-JK100359NV-L', 0, 0, '2021-04-15 12:57:55.875788', '2021-04-15 12:57:55.875788', NULL),
	(10003549, 2, 'PW21A-JK100359NV-XL', 0, 0, '2021-04-15 12:57:55.896391', '2021-04-15 12:57:55.896391', NULL),
	(10003550, 2, 'PW21A-JK100359NV-XXL', 0, 0, '2021-04-15 12:57:55.897700', '2021-04-15 12:57:55.897700', NULL),
	(10003551, 2, 'PW21A-SH100360DM-XS', 0, 0, '2021-04-15 12:57:55.894696', '2021-04-15 12:57:55.894696', NULL),
	(10003552, 2, 'PW21A-SH100360DM-S', 0, 0, '2021-04-15 12:57:55.898994', '2021-04-15 12:57:55.898994', NULL),
	(10003553, 2, 'PW21A-SH100360DM-M', 0, 0, '2021-04-15 12:57:55.900350', '2021-04-15 12:57:55.900350', NULL),
	(10003554, 2, 'PW21A-SH100360DM-L', 0, 0, '2021-04-15 12:57:55.921528', '2021-04-15 12:57:55.921528', NULL),
	(10003555, 2, 'PW21A-SH100360DM-XL', 0, 0, '2021-04-15 12:57:55.929487', '2021-04-15 12:57:55.929487', NULL),
	(10003556, 2, 'PW21A-SH100360DM-XXL', 0, 0, '2021-04-15 12:57:55.922807', '2021-04-15 12:57:55.922807', NULL),
	(10003557, 2, 'PW21A-SH100361BL-XS', 0, 0, '2021-04-15 12:57:55.933207', '2021-04-15 12:57:55.933207', NULL),
	(10003558, 2, 'PW21A-SH100361BL-S', 0, 0, '2021-04-15 12:57:55.972552', '2021-04-15 12:57:55.972552', NULL),
	(10003559, 2, 'PW21A-SH100361BL-M', 0, 0, '2021-04-15 12:57:55.919647', '2021-04-15 12:57:55.919647', NULL),
	(10003560, 2, 'PW21A-SH100361BL-L', 0, 0, '2021-04-15 12:57:55.934171', '2021-04-15 12:57:55.934171', NULL),
	(10003561, 2, 'PW21A-SH100361BL-XL', 0, 0, '2021-04-15 12:57:55.915149', '2021-04-15 12:57:55.915149', NULL),
	(10003562, 2, 'PW21A-SH100361BL-XXL', 0, 0, '2021-04-15 12:57:55.916309', '2021-04-15 12:57:55.916309', NULL),
	(10003563, 2, 'PW21A-SH100362BL-XS', 0, 0, '2021-04-15 12:57:55.915981', '2021-04-15 12:57:55.915981', NULL),
	(10003564, 2, 'PW21A-SH100362BL-S', 0, 0, '2021-04-15 12:57:55.920586', '2021-04-15 12:57:55.920586', NULL),
	(10003565, 2, 'PW21A-SH100362BL-M', 0, 0, '2021-04-15 12:57:55.933545', '2021-04-15 12:57:55.933545', NULL),
	(10003566, 2, 'PW21A-SH100362BL-L', 0, 0, '2021-04-15 12:57:55.933859', '2021-04-15 12:57:55.933859', NULL),
	(10003567, 2, 'PW21A-SH100362BL-XL', 0, 0, '2021-04-15 12:57:56.092158', '2021-04-15 12:57:56.092158', NULL),
	(10003568, 2, 'PW21A-SH100362BL-XXL', 0, 0, '2021-04-15 12:57:55.942369', '2021-04-15 12:57:55.942369', NULL),
	(10003569, 2, 'PW21A-JK100363BL-XS', 0, 0, '2021-04-15 12:57:56.024262', '2021-04-15 12:57:56.024262', NULL),
	(10003570, 2, 'PW21A-JK100363BL-S', 0, 0, '2021-04-15 12:57:55.938947', '2021-04-15 12:57:55.938947', NULL),
	(10003571, 2, 'PW21A-JK100363BL-M', 0, 0, '2021-04-15 12:57:55.939455', '2021-04-15 12:57:55.939455', NULL),
	(10003572, 2, 'PW21A-JK100363BL-L', 0, 0, '2021-04-15 12:57:55.934468', '2021-04-15 12:57:55.934468', NULL),
	(10003573, 2, 'PW21A-JK100363BL-XL', 0, 0, '2021-04-15 12:57:55.957862', '2021-04-15 12:57:55.957862', NULL),
	(10003574, 2, 'PW21A-JK100363BL-XXL', 0, 0, '2021-04-15 12:57:55.943225', '2021-04-15 12:57:55.943225', NULL),
	(10003575, 2, 'PW21A-SH100364BL-XS', 0, 0, '2021-04-15 12:57:56.045398', '2021-04-15 12:57:56.045398', NULL),
	(10003576, 2, 'PW21A-SH100364BL-S', 0, 0, '2021-04-15 12:57:55.973965', '2021-04-15 12:57:55.973965', NULL),
	(10003577, 2, 'PW21A-SH100364BL-M', 0, 0, '2021-04-15 12:57:56.045731', '2021-04-15 12:57:56.045731', NULL),
	(10003578, 2, 'PW21A-SH100364BL-L', 0, 0, '2021-04-15 12:57:55.988058', '2021-04-15 12:57:55.988058', NULL),
	(10003579, 2, 'PW21A-SH100364BL-XL', 0, 0, '2021-04-15 12:57:55.964585', '2021-04-15 12:57:55.964585', NULL),
	(10003580, 2, 'PW21A-SH100364BL-XXL', 0, 0, '2021-04-15 12:57:55.972241', '2021-04-15 12:57:55.972241', NULL),
	(10003581, 2, 'PW21A-SW100365GY-XS', 0, 0, '2021-04-15 12:57:55.981760', '2021-04-15 12:57:55.981760', NULL),
	(10003582, 2, 'PW21A-SW100365GY-S', 0, 0, '2021-04-15 12:57:55.972831', '2021-04-15 12:57:55.972831', NULL),
	(10003583, 2, 'PW21A-SW100365GY-M', 0, 0, '2021-04-15 12:57:55.986734', '2021-04-15 12:57:55.986734', NULL),
	(10003584, 2, 'PW21A-SW100365GY-L', 0, 0, '2021-04-15 12:57:55.995063', '2021-04-15 12:57:55.995063', NULL),
	(10003585, 2, 'PW21A-SW100365GY-XL', 0, 0, '2021-04-15 12:57:55.979939', '2021-04-15 12:57:55.979939', NULL),
	(10003586, 2, 'PW21A-SW100365GY-XXL', 0, 0, '2021-04-15 12:57:55.995873', '2021-04-15 12:57:55.995873', NULL),
	(10003587, 2, 'PW21A-SW100366GY-XS', 0, 0, '2021-04-15 12:57:56.067021', '2021-04-15 12:57:56.067021', NULL),
	(10003588, 2, 'PW21A-SW100366GY-S', 0, 0, '2021-04-15 12:57:55.996624', '2021-04-15 12:57:55.996624', NULL),
	(10003589, 2, 'PW21A-SW100366GY-M', 0, 0, '2021-04-15 12:57:56.002879', '2021-04-15 12:57:56.002879', NULL),
	(10003590, 2, 'PW21A-SW100366GY-L', 0, 0, '2021-04-15 12:57:56.002595', '2021-04-15 12:57:56.002595', NULL),
	(10003591, 2, 'PW21A-SW100366GY-XL', 0, 0, '2021-04-15 12:57:56.020601', '2021-04-15 12:57:56.020601', NULL),
	(10003592, 2, 'PW21A-SW100366GY-XXL', 0, 0, '2021-04-15 12:57:56.008439', '2021-04-15 12:57:56.008439', NULL),
	(10003593, 2, 'PW21A-SW100367BL-XS', 0, 0, '2021-04-15 12:57:56.014366', '2021-04-15 12:57:56.014366', NULL),
	(10003594, 2, 'PW21A-SW100367BL-S', 0, 0, '2021-04-15 12:57:56.021993', '2021-04-15 12:57:56.021993', NULL),
	(10003595, 2, 'PW21A-SW100367BL-M', 0, 0, '2021-04-15 12:57:56.008723', '2021-04-15 12:57:56.008723', NULL),
	(10003596, 2, 'PW21A-SW100367BL-L', 0, 0, '2021-04-15 12:57:56.012627', '2021-04-15 12:57:56.012627', NULL),
	(10003597, 2, 'PW21A-SW100367BL-XL', 0, 0, '2021-04-15 12:57:56.019646', '2021-04-15 12:57:56.019646', NULL),
	(10003598, 2, 'PW21A-SW100367BL-XXL', 0, 0, '2021-04-15 12:57:56.033796', '2021-04-15 12:57:56.033796', NULL),
	(10003599, 2, 'PW21A-SW100368NV-XS', 0, 0, '2021-04-15 12:57:56.021085', '2021-04-15 12:57:56.021085', NULL),
	(10003600, 2, 'PW21A-SW100368NV-S', 0, 0, '2021-04-15 12:57:56.035034', '2021-04-15 12:57:56.035034', NULL),
	(10003601, 2, 'PW21A-SW100368NV-M', 0, 0, '2021-04-15 12:57:56.031394', '2021-04-15 12:57:56.031394', NULL),
	(10003602, 2, 'PW21A-SW100368NV-L', 0, 0, '2021-04-15 12:57:56.023452', '2021-04-15 12:57:56.023452', NULL),
	(10003603, 2, 'PW21A-SW100368NV-XL', 0, 0, '2021-04-15 12:57:56.044272', '2021-04-15 12:57:56.044272', NULL),
	(10003604, 2, 'PW21A-SW100368NV-XXL', 0, 0, '2021-04-15 12:57:56.035555', '2021-04-15 12:57:56.035555', NULL),
	(10003605, 2, 'PW21A-JK100369BL-XS', 0, 0, '2021-04-15 12:57:56.066614', '2021-04-15 12:57:56.066614', NULL),
	(10003606, 2, 'PW21A-JK100369BL-S', 0, 0, '2021-04-15 12:57:56.100369', '2021-04-15 12:57:56.100369', NULL),
	(10003607, 2, 'PW21A-JK100369BL-M', 0, 0, '2021-04-15 12:57:56.040354', '2021-04-15 12:57:56.040354', NULL),
	(10003608, 2, 'PW21A-JK100369BL-L', 0, 0, '2021-04-15 12:57:56.054618', '2021-04-15 12:57:56.054618', NULL),
	(10003609, 2, 'PW21A-JK100369BL-XL', 0, 0, '2021-04-15 12:57:56.050726', '2021-04-15 12:57:56.050726', NULL),
	(10003610, 2, 'PW21A-JK100369BL-XXL', 0, 0, '2021-04-15 12:57:56.042171', '2021-04-15 12:57:56.042171', NULL),
	(10003611, 2, 'PW21A-SH100370NV-XS', 0, 0, '2021-04-15 12:57:56.061265', '2021-04-15 12:57:56.061265', NULL),
	(10003612, 2, 'PW21A-SH100370NV-S', 0, 0, '2021-04-15 12:57:56.094081', '2021-04-15 12:57:56.094081', NULL),
	(10003613, 2, 'PW21A-SH100370NV-M', 0, 0, '2021-04-15 12:57:56.055932', '2021-04-15 12:57:56.055932', NULL),
	(10003614, 2, 'PW21A-SH100370NV-L', 0, 0, '2021-04-15 12:57:56.055560', '2021-04-15 12:57:56.055560', NULL),
	(10003615, 2, 'PW21A-SH100370NV-XL', 0, 0, '2021-04-15 12:57:56.045063', '2021-04-15 12:57:56.045063', NULL),
	(10003616, 2, 'PW21A-SH100370NV-XXL', 0, 0, '2021-04-15 12:57:56.068790', '2021-04-15 12:57:56.068790', NULL),
	(10003617, 2, 'PW21A-SH100371BL-XS', 0, 0, '2021-04-15 12:57:56.059549', '2021-04-15 12:57:56.059549', NULL),
	(10003618, 2, 'PW21A-SH100371BL-S', 0, 0, '2021-04-15 12:57:56.084769', '2021-04-15 12:57:56.084769', NULL),
	(10003619, 2, 'PW21A-SH100371BL-M', 0, 0, '2021-04-15 12:57:56.073673', '2021-04-15 12:57:56.073673', NULL),
	(10003620, 2, 'PW21A-SH100371BL-L', 0, 0, '2021-04-15 12:57:56.067471', '2021-04-15 12:57:56.067471', NULL),
	(10003621, 2, 'PW21A-SH100371BL-XL', 0, 0, '2021-04-15 12:57:56.083782', '2021-04-15 12:57:56.083782', NULL),
	(10003622, 2, 'PW21A-SH100371BL-XXL', 0, 0, '2021-04-15 12:57:56.088197', '2021-04-15 12:57:56.088197', NULL),
	(10003623, 2, 'PW21A-SH100372DK-XS', 0, 0, '2021-04-15 12:57:56.083151', '2021-04-15 12:57:56.083151', NULL),
	(10003624, 2, 'PW21A-SH100372DK-S', 0, 0, '2021-04-15 12:57:56.125858', '2021-04-15 12:57:56.125858', NULL),
	(10003625, 2, 'PW21A-SH100372DK-M', 0, 0, '2021-04-15 12:57:56.157460', '2021-04-15 12:57:56.157460', NULL),
	(10003626, 2, 'PW21A-SH100372DK-L', 0, 0, '2021-04-15 12:57:56.119859', '2021-04-15 12:57:56.119859', NULL),
	(10003627, 2, 'PW21A-SH100372DK-XL', 0, 0, '2021-04-15 12:57:56.086006', '2021-04-15 12:57:56.086006', NULL),
	(10003628, 2, 'PW21A-SH100372DK-XXL', 0, 0, '2021-04-15 12:57:56.104182', '2021-04-15 12:57:56.104182', NULL),
	(10003629, 2, 'PW21A-SH100373GY-XS', 0, 0, '2021-04-15 12:57:56.093757', '2021-04-15 12:57:56.093757', NULL),
	(10003630, 2, 'PW21A-SH100373GY-S', 0, 0, '2021-04-15 12:57:56.158888', '2021-04-15 12:57:56.158888', NULL),
	(10003631, 2, 'PW21A-SH100373GY-M', 0, 0, '2021-04-15 12:57:56.095677', '2021-04-15 12:57:56.095677', NULL),
	(10003632, 2, 'PW21A-SH100373GY-L', 0, 0, '2021-04-15 12:57:56.094421', '2021-04-15 12:57:56.094421', NULL),
	(10003633, 2, 'PW21A-SH100373GY-XL', 0, 0, '2021-04-15 12:57:56.134424', '2021-04-15 12:57:56.134424', NULL),
	(10003634, 2, 'PW21A-SH100373GY-XXL', 0, 0, '2021-04-15 12:57:56.111662', '2021-04-15 12:57:56.111662', NULL),
	(10003635, 2, 'PW21A-SH100374GY-XS', 0, 0, '2021-04-15 12:57:56.106370', '2021-04-15 12:57:56.106370', NULL),
	(10003636, 2, 'PW21A-SH100374GY-S', 0, 0, '2021-04-15 12:57:56.105909', '2021-04-15 12:57:56.105909', NULL),
	(10003637, 2, 'PW21A-SH100374GY-M', 0, 0, '2021-04-15 12:57:56.102831', '2021-04-15 12:57:56.102831', NULL),
	(10003638, 2, 'PW21A-SH100374GY-L', 0, 0, '2021-04-15 12:57:56.116243', '2021-04-15 12:57:56.116243', NULL),
	(10003639, 2, 'PW21A-SH100374GY-XL', 0, 0, '2021-04-15 12:57:56.123885', '2021-04-15 12:57:56.123885', NULL),
	(10003640, 2, 'PW21A-SH100374GY-XXL', 0, 0, '2021-04-15 12:57:56.113852', '2021-04-15 12:57:56.113852', NULL),
	(10003641, 2, 'PW21A-SH100375BL-XS', 0, 0, '2021-04-15 12:57:56.114624', '2021-04-15 12:57:56.114624', NULL),
	(10003642, 2, 'PW21A-SH100375BL-S', 0, 0, '2021-04-15 12:57:56.113136', '2021-04-15 12:57:56.113136', NULL),
	(10003643, 2, 'PW21A-SH100375BL-M', 0, 0, '2021-04-15 12:57:56.127046', '2021-04-15 12:57:56.127046', NULL),
	(10003644, 2, 'PW21A-SH100375BL-L', 0, 0, '2021-04-15 12:57:56.127430', '2021-04-15 12:57:56.127430', NULL),
	(10003645, 2, 'PW21A-SH100375BL-XL', 0, 0, '2021-04-15 12:57:56.182524', '2021-04-15 12:57:56.182524', NULL),
	(10003646, 2, 'PW21A-SH100375BL-XXL', 0, 0, '2021-04-15 12:57:56.153669', '2021-04-15 12:57:56.153669', NULL),
	(10003647, 2, 'PW21A-SH100376CM-XS', 0, 0, '2021-04-15 12:57:56.137999', '2021-04-15 12:57:56.137999', NULL),
	(10003648, 2, 'PW21A-SH100376CM-S', 0, 0, '2021-04-15 12:57:56.136185', '2021-04-15 12:57:56.136185', NULL),
	(10003649, 2, 'PW21A-SH100376CM-M', 0, 0, '2021-04-15 12:57:56.135678', '2021-04-15 12:57:56.135678', NULL),
	(10003650, 2, 'PW21A-SH100376CM-L', 0, 0, '2021-04-15 12:57:56.132829', '2021-04-15 12:57:56.132829', NULL),
	(10003651, 2, 'PW21A-SH100376CM-XL', 0, 0, '2021-04-15 12:57:56.147423', '2021-04-15 12:57:56.147423', NULL),
	(10003652, 2, 'PW21A-SH100376CM-XXL', 0, 0, '2021-04-15 12:57:56.148227', '2021-04-15 12:57:56.148227', NULL),
	(10003653, 2, 'PW21A-SW100377BL-XS', 0, 0, '2021-04-15 12:57:56.146458', '2021-04-15 12:57:56.146458', NULL),
	(10003654, 2, 'PW21A-SW100377BL-S', 0, 0, '2021-04-15 12:57:56.144977', '2021-04-15 12:57:56.144977', NULL),
	(10003655, 2, 'PW21A-SW100377BL-M', 0, 0, '2021-04-15 12:57:56.155974', '2021-04-15 12:57:56.155974', NULL),
	(10003656, 2, 'PW21A-SW100377BL-L', 0, 0, '2021-04-15 12:57:56.141072', '2021-04-15 12:57:56.141072', NULL),
	(10003657, 2, 'PW21A-SW100377BL-XL', 0, 0, '2021-04-15 12:57:56.158199', '2021-04-15 12:57:56.158199', NULL),
	(10003658, 2, 'PW21A-SW100377BL-XXL', 0, 0, '2021-04-15 12:57:56.154708', '2021-04-15 12:57:56.154708', NULL),
	(10003659, 2, 'PW21A-SW100314DK-XS', 0, 0, '2021-04-15 12:57:56.173107', '2021-04-15 12:57:56.173107', NULL),
	(10003660, 2, 'PW21A-SW100314DK-S', 0, 0, '2021-04-15 12:57:56.164331', '2021-04-15 12:57:56.164331', NULL),
	(10003661, 2, 'PW21A-SW100314DK-M', 0, 0, '2021-04-15 12:57:56.181048', '2021-04-15 12:57:56.181048', NULL),
	(10003662, 2, 'PW21A-SW100314DK-L', 0, 0, '2021-04-15 12:57:56.216409', '2021-04-15 12:57:56.216409', NULL),
	(10003663, 2, 'PW21A-SW100314DK-XL', 0, 0, '2021-04-15 12:57:56.218434', '2021-04-15 12:57:56.218434', NULL),
	(10003664, 2, 'PW21A-SW100314DK-XXL', 0, 0, '2021-04-15 12:57:56.180295', '2021-04-15 12:57:56.180295', NULL),
	(10003665, 2, 'PW21A-SW100379GY-XS', 0, 0, '2021-04-15 12:57:56.167647', '2021-04-15 12:57:56.167647', NULL),
	(10003666, 2, 'PW21A-SW100379GY-S', 0, 0, '2021-04-15 12:57:56.218989', '2021-04-15 12:57:56.218989', NULL),
	(10003667, 2, 'PW21A-SW100379GY-M', 0, 0, '2021-04-15 12:57:56.167294', '2021-04-15 12:57:56.167294', NULL),
	(10003668, 2, 'PW21A-SW100379GY-L', 0, 0, '2021-04-15 12:57:56.173666', '2021-04-15 12:57:56.173666', NULL),
	(10003669, 2, 'PW21A-SW100379GY-XL', 0, 0, '2021-04-15 12:57:56.223452', '2021-04-15 12:57:56.223452', NULL),
	(10003670, 2, 'PW21A-SW100379GY-XXL', 0, 0, '2021-04-15 12:57:56.168076', '2021-04-15 12:57:56.168076', NULL),
	(10003671, 2, 'PW21A-SW100380NV-XS', 0, 0, '2021-04-15 12:57:56.190043', '2021-04-15 12:57:56.190043', NULL),
	(10003672, 2, 'PW21A-SW100380NV-S', 0, 0, '2021-04-15 12:57:56.195576', '2021-04-15 12:57:56.195576', NULL),
	(10003673, 2, 'PW21A-SW100380NV-M', 0, 0, '2021-04-15 12:57:56.183774', '2021-04-15 12:57:56.183774', NULL),
	(10003674, 2, 'PW21A-SW100380NV-L', 0, 0, '2021-04-15 12:57:56.201621', '2021-04-15 12:57:56.201621', NULL),
	(10003675, 2, 'PW21A-SW100380NV-XL', 0, 0, '2021-04-15 12:57:56.191451', '2021-04-15 12:57:56.191451', NULL),
	(10003676, 2, 'PW21A-SW100380NV-XXL', 0, 0, '2021-04-15 12:57:56.192776', '2021-04-15 12:57:56.192776', NULL),
	(10003677, 2, 'PW21A-SW100381BL-XS', 0, 0, '2021-04-15 12:57:56.192212', '2021-04-15 12:57:56.192212', NULL),
	(10003678, 2, 'PW21A-SW100381BL-S', 0, 0, '2021-04-15 12:57:56.204405', '2021-04-15 12:57:56.204405', NULL),
	(10003679, 2, 'PW21A-SW100381BL-M', 0, 0, '2021-04-15 12:57:56.221970', '2021-04-15 12:57:56.221970', NULL),
	(10003680, 2, 'PW21A-SW100381BL-L', 0, 0, '2021-04-15 12:57:56.207764', '2021-04-15 12:57:56.207764', NULL),
	(10003681, 2, 'PW21A-SW100381BL-XL', 0, 0, '2021-04-15 12:57:56.205384', '2021-04-15 12:57:56.205384', NULL),
	(10003682, 2, 'PW21A-SW100381BL-XXL', 0, 0, '2021-04-15 12:57:56.210138', '2021-04-15 12:57:56.210138', NULL),
	(10003683, 3, 'PW21A-AC100001BL-All', 2, 0, '2021-04-15 13:00:32.836699', '2021-04-15 13:00:32.836699', NULL),
	(10003684, 3, 'PW21A-AC100002YW -All', 2, 0, '2021-04-15 13:00:32.847064', '2021-04-15 13:00:32.847064', NULL),
	(10003685, 3, 'PW21A-AC100003BL-All', 2, 0, '2021-04-15 13:00:32.885751', '2021-04-15 13:00:32.885751', NULL),
	(10003686, 3, 'PW21A-AC100004BL-All', 0, 0, '2021-04-15 13:00:32.935823', '2021-04-15 13:00:32.935823', NULL),
	(10003687, 3, 'PW21A-AC100005BL-All', 10, 0, '2021-04-15 13:00:32.845943', '2021-04-15 13:00:32.845943', NULL),
	(10003688, 3, 'PW21A-AC100006BL-All', 8, 0, '2021-04-15 13:00:32.846480', '2021-04-15 13:00:32.846480', NULL),
	(10003689, 3, 'PW21A-AC100007BL-All', 2, 0, '2021-04-15 13:00:32.848694', '2021-04-15 13:00:32.848694', NULL),
	(10003690, 3, 'PW21A-AC100008BL-All', 2, 0, '2021-04-15 13:00:32.840387', '2021-04-15 13:00:32.840387', NULL),
	(10003691, 3, 'PW21A-AC100009BW-All', 2, 0, '2021-04-15 13:00:32.839429', '2021-04-15 13:00:32.839429', NULL),
	(10003692, 3, 'PW21A-AC100010MC-All', 2, 0, '2021-04-15 13:00:32.838745', '2021-04-15 13:00:32.838745', NULL),
	(10003693, 3, 'PW21A-AC100011OG-All', 2, 0, '2021-04-15 13:00:32.884225', '2021-04-15 13:00:32.884225', NULL),
	(10003694, 3, 'PW21A-AC100012BL-All', 2, 0, '2021-04-15 13:00:32.889245', '2021-04-15 13:00:32.889245', NULL),
	(10003695, 3, 'PW21A-AC100013OG-All', 2, 0, '2021-04-15 13:00:32.883518', '2021-04-15 13:00:32.883518', NULL),
	(10003696, 3, 'PW21A-AC100014OL-All', 1, 0, '2021-04-15 13:00:32.860327', '2021-04-15 13:00:32.860327', NULL),
	(10003697, 3, 'PW21A-AC100015MR-All', 2, 0, '2021-04-15 13:00:32.852925', '2021-04-15 13:00:32.852925', NULL),
	(10003698, 3, 'PW21A-AC100016BL-All', 2, 0, '2021-04-15 13:00:32.886686', '2021-04-15 13:00:32.886686', NULL),
	(10003699, 3, 'PW21A-AC100017BL-All', 2, 0, '2021-04-15 13:00:32.890932', '2021-04-15 13:00:32.890932', NULL),
	(10003700, 3, 'PW21A-BG100018WT-All', 2, 0, '2021-04-15 13:00:32.894926', '2021-04-15 13:00:32.894926', NULL),
	(10003701, 3, 'PW21A-BG100019BL-All', 4, 0, '2021-04-15 13:00:32.888175', '2021-04-15 13:00:32.888175', NULL),
	(10003702, 3, 'PW21A-BG100020BL-All', 2, 0, '2021-04-15 13:00:32.907921', '2021-04-15 13:00:32.907921', NULL),
	(10003703, 3, 'PW21A-BG100021BL-All', 2, 0, '2021-04-15 13:00:32.917508', '2021-04-15 13:00:32.917508', NULL),
	(10003704, 3, 'PW21A-BG100022BL-All', 2, 0, '2021-04-15 13:00:32.910992', '2021-04-15 13:00:32.910992', NULL),
	(10003705, 3, 'PW21A-BG100023BL-All', 2, 0, '2021-04-15 13:00:32.911387', '2021-04-15 13:00:32.911387', NULL),
	(10003706, 3, 'PW21A-BG100024BL-All', 0, 0, '2021-04-15 13:00:32.887775', '2021-04-15 13:00:32.887775', NULL),
	(10003707, 3, 'PW21A-BG100025BL-All', 0, 0, '2021-04-15 13:00:32.896879', '2021-04-15 13:00:32.896879', NULL),
	(10003708, 3, 'PW21A-BG100026CM-All', 0, 0, '2021-04-15 13:00:32.909934', '2021-04-15 13:00:32.909934', NULL),
	(10003709, 3, 'PW21A-BG100027CM-All', 0, 0, '2021-04-15 13:00:32.955666', '2021-04-15 13:00:32.955666', NULL),
	(10003710, 3, 'PW21A-BG100028CM-All', 0, 0, '2021-04-15 13:00:32.912517', '2021-04-15 13:00:32.912517', NULL),
	(10003711, 3, 'PW21A-BG100029CM-All', 0, 0, '2021-04-15 13:00:32.933249', '2021-04-15 13:00:32.933249', NULL),
	(10003712, 3, 'PW21A-BG100030BL-All', 2, 0, '2021-04-15 13:00:32.910346', '2021-04-15 13:00:32.910346', NULL),
	(10003713, 3, 'PW21A-BG100031BL-All', 2, 0, '2021-04-15 13:00:32.920803', '2021-04-15 13:00:32.920803', NULL),
	(10003714, 3, 'PW21A-BG100032BL-All', 0, 0, '2021-04-15 13:00:32.931685', '2021-04-15 13:00:32.931685', NULL),
	(10003715, 3, 'PW21A-BG100033BL-All', 0, 0, '2021-04-15 13:00:33.023676', '2021-04-15 13:00:33.023676', NULL),
	(10003716, 3, 'PW21A-BG100034BL-All', 0, 0, '2021-04-15 13:00:32.913667', '2021-04-15 13:00:32.913667', NULL),
	(10003717, 3, 'PW21A-BG100035BL-All', 2, 0, '2021-04-15 13:00:32.914973', '2021-04-15 13:00:32.914973', NULL),
	(10003718, 3, 'PW21A-BG100036BL-All', 0, 0, '2021-04-15 13:00:32.936198', '2021-04-15 13:00:32.936198', NULL),
	(10003719, 3, 'PW21A-BG100037OG-All', 2, 0, '2021-04-15 13:00:32.934241', '2021-04-15 13:00:32.934241', NULL),
	(10003720, 3, 'PW21A-BG100038BL-All', 3, 0, '2021-04-15 13:00:32.946202', '2021-04-15 13:00:32.946202', NULL),
	(10003721, 3, 'PW21A-BG100039GN-All', 4, 0, '2021-04-15 13:00:32.933635', '2021-04-15 13:00:32.933635', NULL),
	(10003722, 3, 'PW21A-BG100040WT-All', 2, 0, '2021-04-15 13:00:32.934625', '2021-04-15 13:00:32.934625', NULL),
	(10003723, 3, 'PW21A-BG100041BL-All', 2, 0, '2021-04-15 13:00:32.940027', '2021-04-15 13:00:32.940027', NULL),
	(10003724, 3, 'PW21A-BG100042BL-All', 2, 0, '2021-04-15 13:00:32.938091', '2021-04-15 13:00:32.938091', NULL),
	(10003725, 3, 'PW21A-BG100043BL-All', 3, 0, '2021-04-15 13:00:32.976423', '2021-04-15 13:00:32.976423', NULL),
	(10003726, 3, 'PW21A-BG100044BL-All', 14, 0, '2021-04-15 13:00:32.956588', '2021-04-15 13:00:32.956588', NULL),
	(10003727, 3, 'PW21A-BG100045BL-All', 2, 0, '2021-04-15 13:00:32.992770', '2021-04-15 13:00:32.992770', NULL),
	(10003728, 3, 'PW21A-BG100046BL-All', 1, 0, '2021-04-15 13:00:32.957328', '2021-04-15 13:00:32.957328', NULL),
	(10003729, 3, 'PW21A-BG100047BL-All', 2, 0, '2021-04-15 13:00:32.959046', '2021-04-15 13:00:32.959046', NULL),
	(10003730, 3, 'PW21A-BG100048BL-All', 2, 0, '2021-04-15 13:00:32.989960', '2021-04-15 13:00:32.989960', NULL),
	(10003731, 3, 'PW21A-BG100049BL-All', 1, 0, '2021-04-15 13:00:32.956955', '2021-04-15 13:00:32.956955', NULL),
	(10003732, 3, 'PW21A-BG100050BL-All', 2, 0, '2021-04-15 13:00:32.953774', '2021-04-15 13:00:32.953774', NULL),
	(10003733, 3, 'PW21A-BG100051BL-All', 2, 0, '2021-04-15 13:00:32.962124', '2021-04-15 13:00:32.962124', NULL),
	(10003734, 3, 'PW21A-BG100052BL-All', 2, 0, '2021-04-15 13:00:32.965915', '2021-04-15 13:00:32.965915', NULL),
	(10003735, 3, 'PW21A-BG100053BL-All', 2, 0, '2021-04-15 13:00:32.993744', '2021-04-15 13:00:32.993744', NULL),
	(10003736, 3, 'PW21A-BG100054BL-All', 2, 0, '2021-04-15 13:00:33.054039', '2021-04-15 13:00:33.054039', NULL),
	(10003737, 3, 'PW21A-GL100055YW -S', 1, 0, '2021-04-15 13:00:32.961540', '2021-04-15 13:00:32.961540', NULL),
	(10003738, 3, 'PW21A-GL100055YW -M', 1, 0, '2021-04-15 13:00:33.050311', '2021-04-15 13:00:33.050311', NULL),
	(10003739, 3, 'PW21A-GL100055YW -L', 1, 0, '2021-04-15 13:00:32.995279', '2021-04-15 13:00:32.995279', NULL),
	(10003740, 3, 'PW21A-GL100055YW -XL', 1, 0, '2021-04-15 13:00:32.990852', '2021-04-15 13:00:32.990852', NULL),
	(10003741, 3, 'PW21A-GL100056BW-S', 0, 0, '2021-04-15 13:00:32.998027', '2021-04-15 13:00:32.998027', NULL),
	(10003742, 3, 'PW21A-GL100056BW-M', 1, 0, '2021-04-15 13:00:32.993260', '2021-04-15 13:00:32.993260', NULL),
	(10003743, 3, 'PW21A-GL100056BW-L', 1, 0, '2021-04-15 13:00:33.020980', '2021-04-15 13:00:33.020980', NULL),
	(10003744, 3, 'PW21A-GL100056BW-XL', 1, 0, '2021-04-15 13:00:33.018419', '2021-04-15 13:00:33.018419', NULL),
	(10003745, 3, 'PW21A-GL100057CM-S', 0, 0, '2021-04-15 13:00:32.997500', '2021-04-15 13:00:32.997500', NULL),
	(10003746, 3, 'PW21A-GL100057CM-M', 1, 0, '2021-04-15 13:00:33.046498', '2021-04-15 13:00:33.046498', NULL),
	(10003747, 3, 'PW21A-GL100057CM-L', 1, 0, '2021-04-15 13:00:33.002493', '2021-04-15 13:00:33.002493', NULL),
	(10003748, 3, 'PW21A-GL100057CM-XL', 1, 0, '2021-04-15 13:00:33.027985', '2021-04-15 13:00:33.027985', NULL),
	(10003749, 3, 'PW21A-GL100058BW-S', 1, 0, '2021-04-15 13:00:33.005962', '2021-04-15 13:00:33.005962', NULL),
	(10003750, 3, 'PW21A-GL100058BW-M', 1, 0, '2021-04-15 13:00:33.023076', '2021-04-15 13:00:33.023076', NULL),
	(10003751, 3, 'PW21A-GL100058BW-L', 1, 0, '2021-04-15 13:00:33.024259', '2021-04-15 13:00:33.024259', NULL),
	(10003752, 3, 'PW21A-GL100058BW-XL', 1, 0, '2021-04-15 13:00:33.033044', '2021-04-15 13:00:33.033044', NULL),
	(10003753, 3, 'PW21A-GL100059BL-S', 1, 0, '2021-04-15 13:00:33.036514', '2021-04-15 13:00:33.036514', NULL),
	(10003754, 3, 'PW21A-GL100059BL-M', 1, 0, '2021-04-15 13:00:33.025956', '2021-04-15 13:00:33.025956', NULL),
	(10003755, 3, 'PW21A-GL100059BL-L', 1, 0, '2021-04-15 13:00:33.095187', '2021-04-15 13:00:33.095187', NULL),
	(10003756, 3, 'PW21A-GL100059BL-XL', 1, 0, '2021-04-15 13:00:33.028481', '2021-04-15 13:00:33.028481', NULL),
	(10003757, 3, 'PW21A-GL100060BL-S', 1, 0, '2021-04-15 13:00:33.057610', '2021-04-15 13:00:33.057610', NULL),
	(10003758, 3, 'PW21A-GL100060BL-M', 1, 0, '2021-04-15 13:00:33.054463', '2021-04-15 13:00:33.054463', NULL),
	(10003759, 3, 'PW21A-GL100060BL-L', 1, 0, '2021-04-15 13:00:33.051282', '2021-04-15 13:00:33.051282', NULL),
	(10003760, 3, 'PW21A-GL100060BL-XL', 1, 0, '2021-04-15 13:00:33.083279', '2021-04-15 13:00:33.083279', NULL),
	(10003761, 3, 'PW21A-GL100061RD-S', 1, 0, '2021-04-15 13:00:33.056860', '2021-04-15 13:00:33.056860', NULL),
	(10003762, 3, 'PW21A-GL100061RD-M', 1, 0, '2021-04-15 13:00:33.083722', '2021-04-15 13:00:33.083722', NULL),
	(10003763, 3, 'PW21A-GL100061RD-L', 1, 0, '2021-04-15 13:00:33.057998', '2021-04-15 13:00:33.057998', NULL),
	(10003764, 3, 'PW21A-GL100061RD-XL', 1, 0, '2021-04-15 13:00:33.054915', '2021-04-15 13:00:33.054915', NULL),
	(10003765, 3, 'PW21A-GL100062WT-S', 0, 0, '2021-04-15 13:00:33.061072', '2021-04-15 13:00:33.061072', NULL),
	(10003766, 3, 'PW21A-GL100062WT-M', 1, 0, '2021-04-15 13:00:33.079628', '2021-04-15 13:00:33.079628', NULL),
	(10003767, 3, 'PW21A-GL100062WT-L', 1, 0, '2021-04-15 13:00:33.082805', '2021-04-15 13:00:33.082805', NULL),
	(10003768, 3, 'PW21A-GL100062WT-XL', 1, 0, '2021-04-15 13:00:33.073325', '2021-04-15 13:00:33.073325', NULL),
	(10003769, 3, 'PW21A-GL100063BW-S', 1, 0, '2021-04-15 13:00:33.275228', '2021-04-15 13:00:33.275228', NULL),
	(10003770, 3, 'PW21A-GL100063BW-M', 1, 0, '2021-04-15 13:00:33.084982', '2021-04-15 13:00:33.084982', NULL),
	(10003771, 3, 'PW21A-GL100063BW-L', 1, 0, '2021-04-15 13:00:33.086765', '2021-04-15 13:00:33.086765', NULL),
	(10003772, 3, 'PW21A-GL100063BW-XL', 1, 0, '2021-04-15 13:00:33.078441', '2021-04-15 13:00:33.078441', NULL),
	(10003773, 3, 'PW21A-GL100064WT-S', 1, 0, '2021-04-15 13:00:33.088568', '2021-04-15 13:00:33.088568', NULL),
	(10003774, 3, 'PW21A-GL100064WT-M', 1, 0, '2021-04-15 13:00:33.120382', '2021-04-15 13:00:33.120382', NULL),
	(10003775, 3, 'PW21A-GL100064WT-L', 1, 0, '2021-04-15 13:00:33.116528', '2021-04-15 13:00:33.116528', NULL),
	(10003776, 3, 'PW21A-GL100064WT-XL', 1, 0, '2021-04-15 13:00:33.118161', '2021-04-15 13:00:33.118161', NULL),
	(10003777, 3, 'PW21A-GL100065BL-S', 1, 0, '2021-04-15 13:00:33.125640', '2021-04-15 13:00:33.125640', NULL),
	(10003778, 3, 'PW21A-GL100065BL-M', 1, 0, '2021-04-15 13:00:33.316425', '2021-04-15 13:00:33.316425', NULL),
	(10003779, 3, 'PW21A-GL100065BL-L', 1, 0, '2021-04-15 13:00:33.120961', '2021-04-15 13:00:33.120961', NULL),
	(10003780, 3, 'PW21A-GL100065BL-XL', 1, 0, '2021-04-15 13:00:33.295416', '2021-04-15 13:00:33.295416', NULL),
	(10003781, 3, 'PW21A-GL100066YW -S', 1, 0, '2021-04-15 13:00:33.119878', '2021-04-15 13:00:33.119878', NULL),
	(10003782, 3, 'PW21A-GL100066YW -M', 1, 0, '2021-04-15 13:00:33.117048', '2021-04-15 13:00:33.117048', NULL),
	(10003783, 3, 'PW21A-GL100066YW -L', 1, 0, '2021-04-15 13:00:33.133033', '2021-04-15 13:00:33.133033', NULL),
	(10003784, 3, 'PW21A-GL100066YW -XL', 1, 0, '2021-04-15 13:00:33.197658', '2021-04-15 13:00:33.197658', NULL),
	(10003785, 3, 'PW21A-GL100067BW-S', 1, 0, '2021-04-15 13:00:33.122675', '2021-04-15 13:00:33.122675', NULL),
	(10003786, 3, 'PW21A-GL100067BW-M', 1, 0, '2021-04-15 13:00:33.344333', '2021-04-15 13:00:33.344333', NULL),
	(10003787, 3, 'PW21A-GL100067BW-L', 1, 0, '2021-04-15 13:00:33.415556', '2021-04-15 13:00:33.415556', NULL),
	(10003788, 3, 'PW21A-GL100067BW-XL', 1, 0, '2021-04-15 13:00:33.297598', '2021-04-15 13:00:33.297598', NULL),
	(10003789, 3, 'PW21A-HT100068BL-All', 2, 0, '2021-04-15 13:00:33.299822', '2021-04-15 13:00:33.299822', NULL),
	(10003790, 3, 'PW21A-HT100069BL-All', 0, 0, '2021-04-15 13:00:33.318115', '2021-04-15 13:00:33.318115', NULL),
	(10003791, 3, 'PW21A-HT100070BL-All', 1, 0, '2021-04-15 13:00:33.317393', '2021-04-15 13:00:33.317393', NULL),
	(10003792, 3, 'PW21A-HT100071BL-All', 1, 0, '2021-04-15 13:00:33.340402', '2021-04-15 13:00:33.340402', NULL),
	(10003793, 3, 'PW21A-HT100072BL-All', 1, 0, '2021-04-15 13:00:33.300659', '2021-04-15 13:00:33.300659', NULL),
	(10003794, 3, 'PW21A-HT100073BL-All', 0, 0, '2021-04-15 13:00:33.337828', '2021-04-15 13:00:33.337828', NULL),
	(10003795, 3, 'PW21A-HT100074BL-All', 0, 0, '2021-04-15 13:00:33.339724', '2021-04-15 13:00:33.339724', NULL),
	(10003796, 3, 'PW21A-HT100075BL-All', 0, 0, '2021-04-15 13:00:33.319309', '2021-04-15 13:00:33.319309', NULL),
	(10003797, 3, 'PW21A-HT100076BL-All', 1, 0, '2021-04-15 13:00:33.318715', '2021-04-15 13:00:33.318715', NULL),
	(10003798, 3, 'PW21A-HT100077BL-All', 2, 0, '2021-04-15 13:00:33.350941', '2021-04-15 13:00:33.350941', NULL),
	(10003799, 3, 'PW21A-HT100078BL-All', 2, 0, '2021-04-15 13:00:33.341016', '2021-04-15 13:00:33.341016', NULL),
	(10003800, 3, 'PW21A-HT100079AR-All', 2, 0, '2021-04-15 13:00:33.381402', '2021-04-15 13:00:33.381402', NULL),
	(10003801, 3, 'PW21A-HT100080BL-All', 2, 0, '2021-04-15 13:00:33.359245', '2021-04-15 13:00:33.359245', NULL),
	(10003802, 3, 'PW21A-HT100081CM-All', 2, 0, '2021-04-15 13:00:33.353367', '2021-04-15 13:00:33.353367', NULL),
	(10003803, 3, 'PW21A-HT100082DS-All', 2, 0, '2021-04-15 13:00:33.378061', '2021-04-15 13:00:33.378061', NULL),
	(10003804, 3, 'PW21A-HT100083CM-All', 2, 0, '2021-04-15 13:00:33.403517', '2021-04-15 13:00:33.403517', NULL),
	(10003805, 3, 'PW21A-HT100084DS-All', 2, 0, '2021-04-15 13:00:33.357958', '2021-04-15 13:00:33.357958', NULL),
	(10003806, 3, 'PW21A-HT100085MR-All', 2, 0, '2021-04-15 13:00:33.380795', '2021-04-15 13:00:33.380795', NULL),
	(10003807, 3, 'PW21A-HT100086NV-All', 2, 0, '2021-04-15 13:00:33.380083', '2021-04-15 13:00:33.380083', NULL),
	(10003808, 3, 'PW21A-HT100087BL-All', 4, 0, '2021-04-15 13:00:33.358639', '2021-04-15 13:00:33.358639', NULL),
	(10003809, 3, 'PW21A-HT100088NV-All', 0, 0, '2021-04-15 13:00:33.391259', '2021-04-15 13:00:33.391259', NULL),
	(10003810, 3, 'PW21A-HT100089RD-All', 0, 0, '2021-04-15 13:00:33.399300', '2021-04-15 13:00:33.399300', NULL),
	(10003811, 3, 'PW21A-HT100090BL-All', 0, 0, '2021-04-15 13:00:33.466782', '2021-04-15 13:00:33.466782', NULL),
	(10003812, 3, 'PW21A-HT100091RD-All', 0, 0, '2021-04-15 13:00:33.457247', '2021-04-15 13:00:33.457247', NULL),
	(10003813, 3, 'PW21A-JK100092BL-XS', 0, 0, '2021-04-15 13:00:33.404081', '2021-04-15 13:00:33.404081', NULL),
	(10003814, 3, 'PW21A-JK100092BL-S', 2, 0, '2021-04-15 13:00:33.400145', '2021-04-15 13:00:33.400145', NULL),
	(10003815, 3, 'PW21A-JK100092BL-M', 1, 0, '2021-04-15 13:00:33.417177', '2021-04-15 13:00:33.417177', NULL),
	(10003816, 3, 'PW21A-JK100092BL-L', 1, 0, '2021-04-15 13:00:33.416645', '2021-04-15 13:00:33.416645', NULL),
	(10003817, 3, 'PW21A-JK100092BL-XL', 1, 0, '2021-04-15 13:00:33.404908', '2021-04-15 13:00:33.404908', NULL),
	(10003818, 3, 'PW21A-JK100092BL-XXL', 1, 0, '2021-04-15 13:00:33.418546', '2021-04-15 13:00:33.418546', NULL),
	(10003819, 3, 'PW21A-JK100093BL-XS', 0, 0, '2021-04-15 13:00:33.426622', '2021-04-15 13:00:33.426622', NULL),
	(10003820, 3, 'PW21A-JK100093BL-S', 0, 0, '2021-04-15 13:00:33.423502', '2021-04-15 13:00:33.423502', NULL),
	(10003821, 3, 'PW21A-JK100093BL-M', 0, 0, '2021-04-15 13:00:33.431987', '2021-04-15 13:00:33.431987', NULL),
	(10003822, 3, 'PW21A-JK100093BL-L', 0, 0, '2021-04-15 13:00:33.503489', '2021-04-15 13:00:33.503489', NULL),
	(10003823, 3, 'PW21A-JK100093BL-XL', 0, 0, '2021-04-15 13:00:33.433223', '2021-04-15 13:00:33.433223', NULL),
	(10003824, 3, 'PW21A-JK100093BL-XXL', 0, 0, '2021-04-15 13:00:33.434502', '2021-04-15 13:00:33.434502', NULL),
	(10003825, 3, 'PW21A-JK100094GY-XS', 0, 0, '2021-04-15 13:00:33.454287', '2021-04-15 13:00:33.454287', NULL),
	(10003826, 3, 'PW21A-JK100094GY-S', 0, 0, '2021-04-15 13:00:33.436566', '2021-04-15 13:00:33.436566', NULL),
	(10003827, 3, 'PW21A-JK100094GY-M', 0, 0, '2021-04-15 13:00:33.454864', '2021-04-15 13:00:33.454864', NULL),
	(10003828, 3, 'PW21A-JK100094GY-L', 0, 0, '2021-04-15 13:00:33.507492', '2021-04-15 13:00:33.507492', NULL),
	(10003829, 3, 'PW21A-JK100094GY-XL', 0, 0, '2021-04-15 13:00:33.463657', '2021-04-15 13:00:33.463657', NULL),
	(10003830, 3, 'PW21A-JK100094GY-XXL', 0, 0, '2021-04-15 13:00:33.461841', '2021-04-15 13:00:33.461841', NULL),
	(10003831, 3, 'PW21A-JK100095AR-XS', 0, 0, '2021-04-15 13:00:33.480684', '2021-04-15 13:00:33.480684', NULL),
	(10003832, 3, 'PW21A-JK100095AR-S', 0, 0, '2021-04-15 13:00:33.468664', '2021-04-15 13:00:33.468664', NULL),
	(10003833, 3, 'PW21A-JK100095AR-M', 0, 0, '2021-04-15 13:00:33.456175', '2021-04-15 13:00:33.456175', NULL),
	(10003834, 3, 'PW21A-JK100095AR-L', 0, 0, '2021-04-15 13:00:33.469051', '2021-04-15 13:00:33.469051', NULL),
	(10003835, 3, 'PW21A-JK100095AR-XL', 0, 0, '2021-04-15 13:00:33.500984', '2021-04-15 13:00:33.500984', NULL),
	(10003836, 3, 'PW21A-JK100095AR-XXL', 0, 0, '2021-04-15 13:00:33.479058', '2021-04-15 13:00:33.479058', NULL),
	(10003837, 3, 'PW21A-JK100096BL-XS', 0, 0, '2021-04-15 13:00:33.470763', '2021-04-15 13:00:33.470763', NULL),
	(10003838, 3, 'PW21A-JK100096BL-S', 0, 0, '2021-04-15 13:00:33.477109', '2021-04-15 13:00:33.477109', NULL),
	(10003839, 3, 'PW21A-JK100096BL-M', 0, 0, '2021-04-15 13:00:33.491366', '2021-04-15 13:00:33.491366', NULL),
	(10003840, 3, 'PW21A-JK100096BL-L', 0, 0, '2021-04-15 13:00:33.484090', '2021-04-15 13:00:33.484090', NULL),
	(10003841, 3, 'PW21A-JK100096BL-XL', 0, 0, '2021-04-15 13:00:33.490886', '2021-04-15 13:00:33.490886', NULL),
	(10003842, 3, 'PW21A-JK100096BL-XXL', 0, 0, '2021-04-15 13:00:33.486709', '2021-04-15 13:00:33.486709', NULL),
	(10003843, 3, 'PW21A-JK100097WT-XS', 2, 0, '2021-04-15 13:00:33.480095', '2021-04-15 13:00:33.480095', NULL),
	(10003844, 3, 'PW21A-JK100097WT-S', 1, 0, '2021-04-15 13:00:33.540883', '2021-04-15 13:00:33.540883', NULL),
	(10003845, 3, 'PW21A-JK100097WT-M', 1, 0, '2021-04-15 13:00:33.493965', '2021-04-15 13:00:33.493965', NULL),
	(10003846, 3, 'PW21A-JK100097WT-L', 1, 0, '2021-04-15 13:00:33.524643', '2021-04-15 13:00:33.524643', NULL),
	(10003847, 3, 'PW21A-JK100097WT-XL', 1, 0, '2021-04-15 13:00:33.502676', '2021-04-15 13:00:33.502676', NULL),
	(10003848, 3, 'PW21A-JK100097WT-XXL', 1, 0, '2021-04-15 13:00:33.493590', '2021-04-15 13:00:33.493590', NULL),
	(10003849, 3, 'PW21A-JK100098BL-XS', 0, 0, '2021-04-15 13:00:33.506993', '2021-04-15 13:00:33.506993', NULL),
	(10003850, 3, 'PW21A-JK100098BL-S', 1, 0, '2021-04-15 13:00:33.501336', '2021-04-15 13:00:33.501336', NULL),
	(10003851, 3, 'PW21A-JK100098BL-M', 1, 0, '2021-04-15 13:00:33.514354', '2021-04-15 13:00:33.514354', NULL),
	(10003852, 3, 'PW21A-JK100098BL-L', 1, 0, '2021-04-15 13:00:33.517903', '2021-04-15 13:00:33.517903', NULL),
	(10003853, 3, 'PW21A-JK100098BL-XL', 1, 0, '2021-04-15 13:00:33.518680', '2021-04-15 13:00:33.518680', NULL),
	(10003854, 3, 'PW21A-JK100098BL-XXL', 1, 0, '2021-04-15 13:00:33.527644', '2021-04-15 13:00:33.527644', NULL),
	(10003855, 3, 'PW21A-JK100099BL-XS', 0, 0, '2021-04-15 13:00:33.518299', '2021-04-15 13:00:33.518299', NULL),
	(10003856, 3, 'PW21A-JK100099BL-S', 0, 0, '2021-04-15 13:00:33.525675', '2021-04-15 13:00:33.525675', NULL),
	(10003857, 3, 'PW21A-JK100099BL-M', 0, 0, '2021-04-15 13:00:33.626453', '2021-04-15 13:00:33.626453', NULL),
	(10003858, 3, 'PW21A-JK100099BL-L', 0, 0, '2021-04-15 13:00:33.525306', '2021-04-15 13:00:33.525306', NULL),
	(10003859, 3, 'PW21A-JK100099BL-XL', 0, 0, '2021-04-15 13:00:33.529402', '2021-04-15 13:00:33.529402', NULL),
	(10003860, 3, 'PW21A-JK100099BL-XXL', 0, 0, '2021-04-15 13:00:33.547893', '2021-04-15 13:00:33.547893', NULL),
	(10003861, 3, 'PW21A-JK100100DM-XS', 0, 0, '2021-04-15 13:00:33.530652', '2021-04-15 13:00:33.530652', NULL),
	(10003862, 3, 'PW21A-JK100100DM-S', 0, 0, '2021-04-15 13:00:33.539206', '2021-04-15 13:00:33.539206', NULL),
	(10003863, 3, 'PW21A-JK100100DM-M', 0, 0, '2021-04-15 13:00:33.551481', '2021-04-15 13:00:33.551481', NULL),
	(10003864, 3, 'PW21A-JK100100DM-L', 0, 0, '2021-04-15 13:00:33.566434', '2021-04-15 13:00:33.566434', NULL),
	(10003865, 3, 'PW21A-JK100100DM-XL', 0, 0, '2021-04-15 13:00:33.546710', '2021-04-15 13:00:33.546710', NULL),
	(10003866, 3, 'PW21A-JK100100DM-XXL', 0, 0, '2021-04-15 13:00:33.537159', '2021-04-15 13:00:33.537159', NULL),
	(10003867, 3, 'PW21A-JK100101NV-XS', 0, 0, '2021-04-15 13:00:33.549855', '2021-04-15 13:00:33.549855', NULL),
	(10003868, 3, 'PW21A-JK100101NV-S', 0, 0, '2021-04-15 13:00:33.541258', '2021-04-15 13:00:33.541258', NULL),
	(10003869, 3, 'PW21A-JK100101NV-M', 0, 0, '2021-04-15 13:00:33.584610', '2021-04-15 13:00:33.584610', NULL),
	(10003870, 3, 'PW21A-JK100101NV-L', 0, 0, '2021-04-15 13:00:33.548485', '2021-04-15 13:00:33.548485', NULL),
	(10003871, 3, 'PW21A-JK100101NV-XL', 0, 0, '2021-04-15 13:00:33.566061', '2021-04-15 13:00:33.566061', NULL),
	(10003872, 3, 'PW21A-JK100101NV-XXL', 0, 0, '2021-04-15 13:00:33.552595', '2021-04-15 13:00:33.552595', NULL),
	(10003873, 3, 'PW21A-JK100102BW-XS', 0, 0, '2021-04-15 13:00:33.568891', '2021-04-15 13:00:33.568891', NULL),
	(10003874, 3, 'PW21A-JK100102BW-S', 0, 0, '2021-04-15 13:00:33.572880', '2021-04-15 13:00:33.572880', NULL),
	(10003875, 3, 'PW21A-JK100102BW-M', 0, 0, '2021-04-15 13:00:33.563608', '2021-04-15 13:00:33.563608', NULL),
	(10003876, 3, 'PW21A-JK100102BW-L', 0, 0, '2021-04-15 13:00:33.577855', '2021-04-15 13:00:33.577855', NULL),
	(10003877, 3, 'PW21A-JK100102BW-XL', 0, 0, '2021-04-15 13:00:33.576960', '2021-04-15 13:00:33.576960', NULL),
	(10003878, 3, 'PW21A-JK100102BW-XXL', 0, 0, '2021-04-15 13:00:33.592961', '2021-04-15 13:00:33.592961', NULL),
	(10003879, 3, 'PW21A-JK100103BL-XS', 0, 0, '2021-04-15 13:00:33.579962', '2021-04-15 13:00:33.579962', NULL),
	(10003880, 3, 'PW21A-JK100103BL-S', 0, 0, '2021-04-15 13:00:33.582691', '2021-04-15 13:00:33.582691', NULL),
	(10003881, 3, 'PW21A-JK100103BL-M', 0, 0, '2021-04-15 13:00:33.629354', '2021-04-15 13:00:33.629354', NULL),
	(10003882, 3, 'PW21A-JK100103BL-L', 0, 0, '2021-04-15 13:00:33.603857', '2021-04-15 13:00:33.603857', NULL),
	(10003883, 3, 'PW21A-JK100103BL-XL', 0, 0, '2021-04-15 13:00:33.596312', '2021-04-15 13:00:33.596312', NULL),
	(10003884, 3, 'PW21A-JK100103BL-XXL', 0, 0, '2021-04-15 13:00:33.593729', '2021-04-15 13:00:33.593729', NULL),
	(10003885, 3, 'PW21A-JK100104BL-XS', 0, 0, '2021-04-15 13:00:33.595419', '2021-04-15 13:00:33.595419', NULL),
	(10003886, 3, 'PW21A-JK100104BL-S', 2, 0, '2021-04-15 13:00:33.602000', '2021-04-15 13:00:33.602000', NULL),
	(10003887, 3, 'PW21A-JK100104BL-M', 1, 0, '2021-04-15 13:00:33.610408', '2021-04-15 13:00:33.610408', NULL),
	(10003888, 3, 'PW21A-JK100104BL-L', 1, 0, '2021-04-15 13:00:33.616647', '2021-04-15 13:00:33.616647', NULL),
	(10003889, 3, 'PW21A-JK100104BL-XL', 1, 0, '2021-04-15 13:00:33.606241', '2021-04-15 13:00:33.606241', NULL),
	(10003890, 3, 'PW21A-JK100104BL-XXL', 1, 0, '2021-04-15 13:00:33.640492', '2021-04-15 13:00:33.640492', NULL),
	(10003891, 3, 'PW21A-JK100105TC-XS', 0, 0, '2021-04-15 13:00:33.620271', '2021-04-15 13:00:33.620271', NULL),
	(10003892, 3, 'PW21A-JK100105TC-S', 0, 0, '2021-04-15 13:00:33.611244', '2021-04-15 13:00:33.611244', NULL),
	(10003893, 3, 'PW21A-JK100105TC-M', 0, 0, '2021-04-15 13:00:33.607205', '2021-04-15 13:00:33.607205', NULL),
	(10003894, 3, 'PW21A-JK100105TC-L', 0, 0, '2021-04-15 13:00:33.618174', '2021-04-15 13:00:33.618174', NULL),
	(10003895, 3, 'PW21A-JK100105TC-XL', 0, 0, '2021-04-15 13:00:33.617767', '2021-04-15 13:00:33.617767', NULL),
	(10003896, 3, 'PW21A-JK100105TC-XXL', 0, 0, '2021-04-15 13:00:33.627979', '2021-04-15 13:00:33.627979', NULL),
	(10003897, 3, 'PW21A-JK100106BL-XS', 0, 0, '2021-04-15 13:00:33.677031', '2021-04-15 13:00:33.677031', NULL),
	(10003898, 3, 'PW21A-JK100106BL-S', 2, 0, '2021-04-15 13:00:33.692392', '2021-04-15 13:00:33.692392', NULL),
	(10003899, 3, 'PW21A-JK100106BL-M', 1, 0, '2021-04-15 13:00:33.630254', '2021-04-15 13:00:33.630254', NULL),
	(10003900, 3, 'PW21A-JK100106BL-L', 1, 0, '2021-04-15 13:00:33.642566', '2021-04-15 13:00:33.642566', NULL),
	(10003901, 3, 'PW21A-JK100106BL-XL', 1, 0, '2021-04-15 13:00:33.639353', '2021-04-15 13:00:33.639353', NULL),
	(10003902, 3, 'PW21A-JK100106BL-XXL', 1, 0, '2021-04-15 13:00:33.632791', '2021-04-15 13:00:33.632791', NULL),
	(10003903, 3, 'PW21A-JK100107BL-XS', 0, 0, '2021-04-15 13:00:33.632453', '2021-04-15 13:00:33.632453', NULL),
	(10003904, 3, 'PW21A-JK100107BL-S', 0, 0, '2021-04-15 13:00:33.646281', '2021-04-15 13:00:33.646281', NULL),
	(10003905, 3, 'PW21A-JK100107BL-M', 0, 0, '2021-04-15 13:00:33.650078', '2021-04-15 13:00:33.650078', NULL),
	(10003906, 3, 'PW21A-JK100107BL-L', 0, 0, '2021-04-15 13:00:33.652700', '2021-04-15 13:00:33.652700', NULL),
	(10003907, 3, 'PW21A-JK100107BL-XL', 0, 0, '2021-04-15 13:00:33.662897', '2021-04-15 13:00:33.662897', NULL),
	(10003908, 3, 'PW21A-JK100107BL-XXL', 0, 0, '2021-04-15 13:00:33.642900', '2021-04-15 13:00:33.642900', NULL),
	(10003909, 3, 'PW21A-JK100108BL-XS', 0, 0, '2021-04-15 13:00:33.653071', '2021-04-15 13:00:33.653071', NULL),
	(10003910, 3, 'PW21A-JK100108BL-S', 4, 0, '2021-04-15 13:00:33.657467', '2021-04-15 13:00:33.657467', NULL),
	(10003911, 3, 'PW21A-JK100108BL-M', 1, 0, '2021-04-15 13:00:33.665135', '2021-04-15 13:00:33.665135', NULL),
	(10003912, 3, 'PW21A-JK100108BL-L', 1, 0, '2021-04-15 13:00:33.663231', '2021-04-15 13:00:33.663231', NULL),
	(10003913, 3, 'PW21A-JK100108BL-XL', 2, 0, '2021-04-15 13:00:33.668943', '2021-04-15 13:00:33.668943', NULL),
	(10003914, 3, 'PW21A-JK100108BL-XXL', 0, 0, '2021-04-15 13:00:33.655804', '2021-04-15 13:00:33.655804', NULL),
	(10003915, 3, 'PW21A-JK100109BL-XS', 0, 0, '2021-04-15 13:00:33.719032', '2021-04-15 13:00:33.719032', NULL),
	(10003916, 3, 'PW21A-JK100109BL-S', 0, 0, '2021-04-15 13:00:33.695520', '2021-04-15 13:00:33.695520', NULL),
	(10003917, 3, 'PW21A-JK100109BL-M', 0, 0, '2021-04-15 13:00:33.679648', '2021-04-15 13:00:33.679648', NULL),
	(10003918, 3, 'PW21A-JK100109BL-L', 0, 0, '2021-04-15 13:00:33.665491', '2021-04-15 13:00:33.665491', NULL),
	(10003919, 3, 'PW21A-JK100109BL-XL', 0, 0, '2021-04-15 13:00:33.688728', '2021-04-15 13:00:33.688728', NULL),
	(10003920, 3, 'PW21A-JK100109BL-XXL', 0, 0, '2021-04-15 13:00:33.681216', '2021-04-15 13:00:33.681216', NULL),
	(10003921, 3, 'PW21A-JK100110BL-XS', 2, 0, '2021-04-15 13:00:33.683166', '2021-04-15 13:00:33.683166', NULL),
	(10003922, 3, 'PW21A-JK100110BL-S', 1, 0, '2021-04-15 13:00:33.689929', '2021-04-15 13:00:33.689929', NULL),
	(10003923, 3, 'PW21A-JK100110BL-M', 0, 0, '2021-04-15 13:00:33.711981', '2021-04-15 13:00:33.711981', NULL),
	(10003924, 3, 'PW21A-JK100110BL-L', 1, 0, '2021-04-15 13:00:33.757416', '2021-04-15 13:00:33.757416', NULL),
	(10003925, 3, 'PW21A-JK100110BL-XL', 1, 0, '2021-04-15 13:00:33.693336', '2021-04-15 13:00:33.693336', NULL),
	(10003926, 3, 'PW21A-JK100110BL-XXL', 1, 0, '2021-04-15 13:00:33.682804', '2021-04-15 13:00:33.682804', NULL),
	(10003927, 3, 'PW21A-JK100111BL-XS', 0, 0, '2021-04-15 13:00:33.706320', '2021-04-15 13:00:33.706320', NULL),
	(10003928, 3, 'PW21A-JK100111BL-S', 0, 0, '2021-04-15 13:00:33.702381', '2021-04-15 13:00:33.702381', NULL),
	(10003929, 3, 'PW21A-JK100111BL-M', 0, 0, '2021-04-15 13:00:33.700190', '2021-04-15 13:00:33.700190', NULL),
	(10003930, 3, 'PW21A-JK100111BL-L', 0, 0, '2021-04-15 13:00:33.705644', '2021-04-15 13:00:33.705644', NULL),
	(10003931, 3, 'PW21A-JK100111BL-XL', 0, 0, '2021-04-15 13:00:33.703377', '2021-04-15 13:00:33.703377', NULL),
	(10003932, 3, 'PW21A-JK100111BL-XXL', 0, 0, '2021-04-15 13:00:33.713284', '2021-04-15 13:00:33.713284', NULL),
	(10003933, 3, 'PW21A-JK100112CM-XS', 0, 0, '2021-04-15 13:00:33.766698', '2021-04-15 13:00:33.766698', NULL),
	(10003934, 3, 'PW21A-JK100112CM-S', 0, 0, '2021-04-15 13:00:33.716115', '2021-04-15 13:00:33.716115', NULL),
	(10003935, 3, 'PW21A-JK100112CM-M', 0, 0, '2021-04-15 13:00:33.716605', '2021-04-15 13:00:33.716605', NULL),
	(10003936, 3, 'PW21A-JK100112CM-L', 0, 0, '2021-04-15 13:00:33.723474', '2021-04-15 13:00:33.723474', NULL),
	(10003937, 3, 'PW21A-JK100112CM-XL', 0, 0, '2021-04-15 13:00:33.752565', '2021-04-15 13:00:33.752565', NULL),
	(10003938, 3, 'PW21A-JK100112CM-XXL', 0, 0, '2021-04-15 13:00:33.737410', '2021-04-15 13:00:33.737410', NULL),
	(10003939, 3, 'PW21A-JK100113CM-XS', 0, 0, '2021-04-15 13:00:33.730803', '2021-04-15 13:00:33.730803', NULL),
	(10003940, 3, 'PW21A-JK100113CM-S', 0, 0, '2021-04-15 13:00:33.726181', '2021-04-15 13:00:33.726181', NULL),
	(10003941, 3, 'PW21A-JK100113CM-M', 0, 0, '2021-04-15 13:00:33.733783', '2021-04-15 13:00:33.733783', NULL),
	(10003942, 3, 'PW21A-JK100113CM-L', 0, 0, '2021-04-15 13:00:33.726901', '2021-04-15 13:00:33.726901', NULL),
	(10003943, 3, 'PW21A-JK100113CM-XL', 0, 0, '2021-04-15 13:00:33.729343', '2021-04-15 13:00:33.729343', NULL),
	(10003944, 3, 'PW21A-JK100113CM-XXL', 0, 0, '2021-04-15 13:00:33.740426', '2021-04-15 13:00:33.740426', NULL),
	(10003945, 3, 'PW21A-JK100114CM-XS', 0, 0, '2021-04-15 13:00:33.755001', '2021-04-15 13:00:33.755001', NULL),
	(10003946, 3, 'PW21A-JK100114CM-S', 0, 0, '2021-04-15 13:00:33.784329', '2021-04-15 13:00:33.784329', NULL),
	(10003947, 3, 'PW21A-JK100114CM-M', 0, 0, '2021-04-15 13:00:33.751080', '2021-04-15 13:00:33.751080', NULL),
	(10003948, 3, 'PW21A-JK100114CM-L', 0, 0, '2021-04-15 13:00:33.768319', '2021-04-15 13:00:33.768319', NULL),
	(10003949, 3, 'PW21A-JK100114CM-XL', 0, 0, '2021-04-15 13:00:33.782922', '2021-04-15 13:00:33.782922', NULL),
	(10003950, 3, 'PW21A-JK100114CM-XXL', 0, 0, '2021-04-15 13:00:33.743511', '2021-04-15 13:00:33.743511', NULL),
	(10003951, 3, 'PW21A-JK100115DM-XS', 0, 0, '2021-04-15 13:00:33.741154', '2021-04-15 13:00:33.741154', NULL),
	(10003952, 3, 'PW21A-JK100115DM-S', 0, 0, '2021-04-15 13:00:33.761429', '2021-04-15 13:00:33.761429', NULL),
	(10003953, 3, 'PW21A-JK100115DM-M', 0, 0, '2021-04-15 13:00:33.758461', '2021-04-15 13:00:33.758461', NULL),
	(10003954, 3, 'PW21A-JK100115DM-L', 0, 0, '2021-04-15 13:00:33.775465', '2021-04-15 13:00:33.775465', NULL),
	(10003955, 3, 'PW21A-JK100115DM-XL', 0, 0, '2021-04-15 13:00:33.769203', '2021-04-15 13:00:33.769203', NULL),
	(10003956, 3, 'PW21A-JK100115DM-XXL', 0, 0, '2021-04-15 13:00:33.764425', '2021-04-15 13:00:33.764425', NULL),
	(10003957, 3, 'PW21A-JK100116RD-XS', 0, 0, '2021-04-15 13:00:33.780992', '2021-04-15 13:00:33.780992', NULL),
	(10003958, 3, 'PW21A-JK100116RD-S', 0, 0, '2021-04-15 13:00:33.777899', '2021-04-15 13:00:33.777899', NULL),
	(10003959, 3, 'PW21A-JK100116RD-M', 0, 0, '2021-04-15 13:00:33.865726', '2021-04-15 13:00:33.865726', NULL),
	(10003960, 3, 'PW21A-JK100116RD-L', 0, 0, '2021-04-15 13:00:33.798571', '2021-04-15 13:00:33.798571', NULL),
	(10003961, 3, 'PW21A-JK100116RD-XL', 0, 0, '2021-04-15 13:00:33.795067', '2021-04-15 13:00:33.795067', NULL),
	(10003962, 3, 'PW21A-JK100116RD-XXL', 0, 0, '2021-04-15 13:00:33.792701', '2021-04-15 13:00:33.792701', NULL),
	(10003963, 3, 'PW21A-JK100117BL-XS', 0, 0, '2021-04-15 13:00:33.814838', '2021-04-15 13:00:33.814838', NULL),
	(10003964, 3, 'PW21A-JK100117BL-S', 0, 0, '2021-04-15 13:00:33.808118', '2021-04-15 13:00:33.808118', NULL),
	(10003965, 3, 'PW21A-JK100117BL-M', 0, 0, '2021-04-15 13:00:33.816961', '2021-04-15 13:00:33.816961', NULL),
	(10003966, 3, 'PW21A-JK100117BL-L', 0, 0, '2021-04-15 13:00:33.800149', '2021-04-15 13:00:33.800149', NULL),
	(10003967, 3, 'PW21A-JK100117BL-XL', 0, 0, '2021-04-15 13:00:33.807178', '2021-04-15 13:00:33.807178', NULL),
	(10003968, 3, 'PW21A-JK100117BL-XXL', 0, 0, '2021-04-15 13:00:33.800515', '2021-04-15 13:00:33.800515', NULL),
	(10003969, 3, 'PW21A-JK100118AR-XS', 0, 0, '2021-04-15 13:00:33.816488', '2021-04-15 13:00:33.816488', NULL),
	(10003970, 3, 'PW21A-JK100118AR-S', 2, 0, '2021-04-15 13:00:33.829483', '2021-04-15 13:00:33.829483', NULL),
	(10003971, 3, 'PW21A-JK100118AR-M', 1, 0, '2021-04-15 13:00:33.824943', '2021-04-15 13:00:33.824943', NULL),
	(10003972, 3, 'PW21A-JK100118AR-L', 1, 0, '2021-04-15 13:00:33.851976', '2021-04-15 13:00:33.851976', NULL),
	(10003973, 3, 'PW21A-JK100118AR-XL', 1, 0, '2021-04-15 13:00:33.839720', '2021-04-15 13:00:33.839720', NULL),
	(10003974, 3, 'PW21A-JK100118AR-XXL', 1, 0, '2021-04-15 13:00:33.819259', '2021-04-15 13:00:33.819259', NULL),
	(10003975, 3, 'PW21A-JK100119BL-XS', 0, 0, '2021-04-15 13:00:33.831965', '2021-04-15 13:00:33.831965', NULL),
	(10003976, 3, 'PW21A-JK100119BL-S', 2, 0, '2021-04-15 13:00:33.872699', '2021-04-15 13:00:33.872699', NULL),
	(10003977, 3, 'PW21A-JK100119BL-M', 1, 0, '2021-04-15 13:00:33.851289', '2021-04-15 13:00:33.851289', NULL),
	(10003978, 3, 'PW21A-JK100119BL-L', 1, 0, '2021-04-15 13:00:33.838054', '2021-04-15 13:00:33.838054', NULL),
	(10003979, 3, 'PW21A-JK100119BL-XL', 1, 0, '2021-04-15 13:00:33.858484', '2021-04-15 13:00:33.858484', NULL),
	(10003980, 3, 'PW21A-JK100119BL-XXL', 1, 0, '2021-04-15 13:00:33.830147', '2021-04-15 13:00:33.830147', NULL),
	(10003981, 3, 'PW21A-JK100120BL-XS', 2, 0, '2021-04-15 13:00:33.862785', '2021-04-15 13:00:33.862785', NULL),
	(10003982, 3, 'PW21A-JK100120BL-S', 1, 0, '2021-04-15 13:00:33.886752', '2021-04-15 13:00:33.886752', NULL),
	(10003983, 3, 'PW21A-JK100120BL-M', 1, 0, '2021-04-15 13:00:33.853873', '2021-04-15 13:00:33.853873', NULL),
	(10003984, 3, 'PW21A-JK100120BL-L', 1, 0, '2021-04-15 13:00:33.882141', '2021-04-15 13:00:33.882141', NULL),
	(10003985, 3, 'PW21A-JK100120BL-XL', 2, 0, '2021-04-15 13:00:33.877785', '2021-04-15 13:00:33.877785', NULL),
	(10003986, 3, 'PW21A-JK100120BL-XXL', 2, 0, '2021-04-15 13:00:33.893928', '2021-04-15 13:00:33.893928', NULL),
	(10003987, 3, 'PW21A-JK100121MR-XS', 0, 0, '2021-04-15 13:00:33.867965', '2021-04-15 13:00:33.867965', NULL),
	(10003988, 3, 'PW21A-JK100121MR-S', 2, 0, '2021-04-15 13:00:34.039836', '2021-04-15 13:00:34.039836', NULL),
	(10003989, 3, 'PW21A-JK100121MR-M', 1, 0, '2021-04-15 13:00:33.905957', '2021-04-15 13:00:33.905957', NULL),
	(10003990, 3, 'PW21A-JK100121MR-L', 1, 0, '2021-04-15 13:00:33.889206', '2021-04-15 13:00:33.889206', NULL),
	(10003991, 3, 'PW21A-JK100121MR-XL', 1, 0, '2021-04-15 13:00:33.888181', '2021-04-15 13:00:33.888181', NULL),
	(10003992, 3, 'PW21A-JK100121MR-XXL', 1, 0, '2021-04-15 13:00:33.890650', '2021-04-15 13:00:33.890650', NULL),
	(10003993, 3, 'PW21A-JK100122RD-XS', 0, 0, '2021-04-15 13:00:33.901524', '2021-04-15 13:00:33.901524', NULL),
	(10003994, 3, 'PW21A-JK100122RD-S', 0, 0, '2021-04-15 13:00:33.898084', '2021-04-15 13:00:33.898084', NULL),
	(10003995, 3, 'PW21A-JK100122RD-M', 0, 0, '2021-04-15 13:00:33.979568', '2021-04-15 13:00:33.979568', NULL),
	(10003996, 3, 'PW21A-JK100122RD-L', 0, 0, '2021-04-15 13:00:33.911899', '2021-04-15 13:00:33.911899', NULL),
	(10003997, 3, 'PW21A-JK100122RD-XL', 0, 0, '2021-04-15 13:00:33.894253', '2021-04-15 13:00:33.894253', NULL),
	(10003998, 3, 'PW21A-JK100122RD-XXL', 0, 0, '2021-04-15 13:00:33.931460', '2021-04-15 13:00:33.931460', NULL),
	(10003999, 3, 'PW21A-JK100123BL-XS', 0, 0, '2021-04-15 13:00:33.913917', '2021-04-15 13:00:33.913917', NULL),
	(10004000, 3, 'PW21A-JK100123BL-S', 0, 0, '2021-04-15 13:00:33.903875', '2021-04-15 13:00:33.903875', NULL),
	(10004001, 3, 'PW21A-JK100123BL-M', 0, 0, '2021-04-15 13:00:33.913070', '2021-04-15 13:00:33.913070', NULL),
	(10004002, 3, 'PW21A-JK100123BL-L', 0, 0, '2021-04-15 13:00:33.919613', '2021-04-15 13:00:33.919613', NULL),
	(10004003, 3, 'PW21A-JK100123BL-XL', 0, 0, '2021-04-15 13:00:33.909373', '2021-04-15 13:00:33.909373', NULL),
	(10004004, 3, 'PW21A-JK100123BL-XXL', 0, 0, '2021-04-15 13:00:33.929516', '2021-04-15 13:00:33.929516', NULL),
	(10004005, 3, 'PW21A-JK100124BL-XS', 0, 0, '2021-04-15 13:00:33.927008', '2021-04-15 13:00:33.927008', NULL),
	(10004006, 3, 'PW21A-JK100124BL-S', 0, 0, '2021-04-15 13:00:33.949381', '2021-04-15 13:00:33.949381', NULL),
	(10004007, 3, 'PW21A-JK100124BL-M', 0, 0, '2021-04-15 13:00:33.941384', '2021-04-15 13:00:33.941384', NULL),
	(10004008, 3, 'PW21A-JK100124BL-L', 0, 0, '2021-04-15 13:00:33.922569', '2021-04-15 13:00:33.922569', NULL),
	(10004009, 3, 'PW21A-JK100124BL-XL', 0, 0, '2021-04-15 13:00:33.962363', '2021-04-15 13:00:33.962363', NULL),
	(10004010, 3, 'PW21A-JK100124BL-XXL', 0, 0, '2021-04-15 13:00:33.958267', '2021-04-15 13:00:33.958267', NULL),
	(10004011, 3, 'PW21A-JK100125AR-XS', 0, 0, '2021-04-15 13:00:33.946987', '2021-04-15 13:00:33.946987', NULL),
	(10004012, 3, 'PW21A-JK100125AR-S', 0, 0, '2021-04-15 13:00:33.948192', '2021-04-15 13:00:33.948192', NULL),
	(10004013, 3, 'PW21A-JK100125AR-M', 0, 0, '2021-04-15 13:00:33.962730', '2021-04-15 13:00:33.962730', NULL),
	(10004014, 3, 'PW21A-JK100125AR-L', 0, 0, '2021-04-15 13:00:33.949772', '2021-04-15 13:00:33.949772', NULL),
	(10004015, 3, 'PW21A-JK100125AR-XL', 0, 0, '2021-04-15 13:00:33.973733', '2021-04-15 13:00:33.973733', NULL),
	(10004016, 3, 'PW21A-JK100125AR-XXL', 0, 0, '2021-04-15 13:00:33.955254', '2021-04-15 13:00:33.955254', NULL),
	(10004017, 3, 'PW21A-JK100126BL-XS', 0, 0, '2021-04-15 13:00:33.964361', '2021-04-15 13:00:33.964361', NULL),
	(10004018, 3, 'PW21A-JK100126BL-S', 0, 0, '2021-04-15 13:00:33.964743', '2021-04-15 13:00:33.964743', NULL),
	(10004019, 3, 'PW21A-JK100126BL-M', 0, 0, '2021-04-15 13:00:33.972431', '2021-04-15 13:00:33.972431', NULL),
	(10004020, 3, 'PW21A-JK100126BL-L', 0, 0, '2021-04-15 13:00:33.974540', '2021-04-15 13:00:33.974540', NULL),
	(10004021, 3, 'PW21A-JK100126BL-XL', 0, 0, '2021-04-15 13:00:33.976800', '2021-04-15 13:00:33.976800', NULL),
	(10004022, 3, 'PW21A-JK100126BL-XXL', 0, 0, '2021-04-15 13:00:33.974169', '2021-04-15 13:00:33.974169', NULL),
	(10004023, 3, 'PW21A-JK100127BL-XS', 0, 0, '2021-04-15 13:00:34.013818', '2021-04-15 13:00:34.013818', NULL),
	(10004024, 3, 'PW21A-JK100127BL-S', 0, 0, '2021-04-15 13:00:34.000875', '2021-04-15 13:00:34.000875', NULL),
	(10004025, 3, 'PW21A-JK100127BL-M', 0, 0, '2021-04-15 13:00:33.992324', '2021-04-15 13:00:33.992324', NULL),
	(10004026, 3, 'PW21A-JK100127BL-L', 0, 0, '2021-04-15 13:00:33.987151', '2021-04-15 13:00:33.987151', NULL),
	(10004027, 3, 'PW21A-JK100127BL-XL', 0, 0, '2021-04-15 13:00:33.989447', '2021-04-15 13:00:33.989447', NULL),
	(10004028, 3, 'PW21A-JK100127BL-XXL', 0, 0, '2021-04-15 13:00:34.002913', '2021-04-15 13:00:34.002913', NULL),
	(10004029, 3, 'PW21A-JK100128BL-XS', 0, 0, '2021-04-15 13:00:34.031526', '2021-04-15 13:00:34.031526', NULL),
	(10004030, 3, 'PW21A-JK100128BL-S', 0, 0, '2021-04-15 13:00:33.990007', '2021-04-15 13:00:33.990007', NULL),
	(10004031, 3, 'PW21A-JK100128BL-M', 0, 0, '2021-04-15 13:00:34.025625', '2021-04-15 13:00:34.025625', NULL),
	(10004032, 3, 'PW21A-JK100128BL-L', 0, 0, '2021-04-15 13:00:34.000000', '2021-04-15 13:00:34.000000', NULL),
	(10004033, 3, 'PW21A-JK100128BL-XL', 0, 0, '2021-04-15 13:00:34.001606', '2021-04-15 13:00:34.001606', NULL),
	(10004034, 3, 'PW21A-JK100128BL-XXL', 0, 0, '2021-04-15 13:00:34.001934', '2021-04-15 13:00:34.001934', NULL),
	(10004035, 3, 'PW21A-JK100129YW -XS', 0, 0, '2021-04-15 13:00:34.013484', '2021-04-15 13:00:34.013484', NULL),
	(10004036, 3, 'PW21A-JK100129YW -S', 0, 0, '2021-04-15 13:00:34.011728', '2021-04-15 13:00:34.011728', NULL),
	(10004037, 3, 'PW21A-JK100129YW -M', 0, 0, '2021-04-15 13:00:34.004900', '2021-04-15 13:00:34.004900', NULL),
	(10004038, 3, 'PW21A-JK100129YW -L', 0, 0, '2021-04-15 13:00:34.024630', '2021-04-15 13:00:34.024630', NULL),
	(10004039, 3, 'PW21A-JK100129YW -XL', 0, 0, '2021-04-15 13:00:34.075937', '2021-04-15 13:00:34.075937', NULL),
	(10004040, 3, 'PW21A-JK100129YW -XXL', 0, 0, '2021-04-15 13:00:34.012578', '2021-04-15 13:00:34.012578', NULL),
	(10004041, 3, 'PW21A-JK100130YW -XS', 2, 0, '2021-04-15 13:00:34.026175', '2021-04-15 13:00:34.026175', NULL),
	(10004042, 3, 'PW21A-JK100130YW -S', 1, 0, '2021-04-15 13:00:34.051806', '2021-04-15 13:00:34.051806', NULL),
	(10004043, 3, 'PW21A-JK100130YW -M', 1, 0, '2021-04-15 13:00:34.144046', '2021-04-15 13:00:34.144046', NULL),
	(10004044, 3, 'PW21A-JK100130YW -L', 1, 0, '2021-04-15 13:00:34.033056', '2021-04-15 13:00:34.033056', NULL),
	(10004045, 3, 'PW21A-JK100130YW -XL', 1, 0, '2021-04-15 13:00:34.031996', '2021-04-15 13:00:34.031996', NULL),
	(10004046, 3, 'PW21A-JK100130YW -XXL', 1, 0, '2021-04-15 13:00:34.039505', '2021-04-15 13:00:34.039505', NULL),
	(10004047, 3, 'PW21A-JK100131YW -XS', 0, 0, '2021-04-15 13:00:34.038814', '2021-04-15 13:00:34.038814', NULL),
	(10004048, 3, 'PW21A-JK100131YW -S', 0, 0, '2021-04-15 13:00:34.049705', '2021-04-15 13:00:34.049705', NULL),
	(10004049, 3, 'PW21A-JK100131YW -M', 0, 0, '2021-04-15 13:00:34.186438', '2021-04-15 13:00:34.186438', NULL),
	(10004050, 3, 'PW21A-JK100131YW -L', 0, 0, '2021-04-15 13:00:34.039176', '2021-04-15 13:00:34.039176', NULL),
	(10004051, 3, 'PW21A-JK100131YW -XL', 0, 0, '2021-04-15 13:00:34.053481', '2021-04-15 13:00:34.053481', NULL),
	(10004052, 3, 'PW21A-JK100131YW -XXL', 0, 0, '2021-04-15 13:00:34.063419', '2021-04-15 13:00:34.063419', NULL),
	(10004053, 3, 'PW21A-JK100132BL-XS', 0, 0, '2021-04-15 13:00:34.050401', '2021-04-15 13:00:34.050401', NULL),
	(10004054, 3, 'PW21A-JK100132BL-S', 0, 0, '2021-04-15 13:00:34.056143', '2021-04-15 13:00:34.056143', NULL),
	(10004055, 3, 'PW21A-JK100132BL-M', 0, 0, '2021-04-15 13:00:34.055530', '2021-04-15 13:00:34.055530', NULL),
	(10004056, 3, 'PW21A-JK100132BL-L', 0, 0, '2021-04-15 13:00:34.065543', '2021-04-15 13:00:34.065543', NULL),
	(10004057, 3, 'PW21A-JK100132BL-XL', 0, 0, '2021-04-15 13:00:34.065872', '2021-04-15 13:00:34.065872', NULL),
	(10004058, 3, 'PW21A-JK100132BL-XXL', 0, 0, '2021-04-15 13:00:34.075159', '2021-04-15 13:00:34.075159', NULL),
	(10004059, 3, 'PW21A-JK100133BL-XS', 0, 0, '2021-04-15 13:00:34.064753', '2021-04-15 13:00:34.064753', NULL),
	(10004060, 3, 'PW21A-JK100133BL-S', 0, 0, '2021-04-15 13:00:34.079984', '2021-04-15 13:00:34.079984', NULL),
	(10004061, 3, 'PW21A-JK100133BL-M', 0, 0, '2021-04-15 13:00:34.126170', '2021-04-15 13:00:34.126170', NULL),
	(10004062, 3, 'PW21A-JK100133BL-L', 0, 0, '2021-04-15 13:00:34.090796', '2021-04-15 13:00:34.090796', NULL),
	(10004063, 3, 'PW21A-JK100133BL-XL', 0, 0, '2021-04-15 13:00:34.081083', '2021-04-15 13:00:34.081083', NULL),
	(10004064, 3, 'PW21A-JK100133BL-XXL', 0, 0, '2021-04-15 13:00:34.100050', '2021-04-15 13:00:34.100050', NULL),
	(10004065, 3, 'PW21A-JK100134OL-XS', 0, 0, '2021-04-15 13:00:34.084154', '2021-04-15 13:00:34.084154', NULL),
	(10004066, 3, 'PW21A-JK100134OL-S', 0, 0, '2021-04-15 13:00:34.099322', '2021-04-15 13:00:34.099322', NULL),
	(10004067, 3, 'PW21A-JK100134OL-M', 0, 0, '2021-04-15 13:00:34.127001', '2021-04-15 13:00:34.127001', NULL),
	(10004068, 3, 'PW21A-JK100134OL-L', 0, 0, '2021-04-15 13:00:34.095594', '2021-04-15 13:00:34.095594', NULL),
	(10004069, 3, 'PW21A-JK100134OL-XL', 0, 0, '2021-04-15 13:00:34.171991', '2021-04-15 13:00:34.171991', NULL),
	(10004070, 3, 'PW21A-JK100134OL-XXL', 0, 0, '2021-04-15 13:00:34.100609', '2021-04-15 13:00:34.100609', NULL),
	(10004071, 3, 'PW21A-JK100135BL-XS', 0, 0, '2021-04-15 13:00:34.144567', '2021-04-15 13:00:34.144567', NULL),
	(10004072, 3, 'PW21A-JK100135BL-S', 0, 0, '2021-04-15 13:00:34.145833', '2021-04-15 13:00:34.145833', NULL),
	(10004073, 3, 'PW21A-JK100135BL-M', 0, 0, '2021-04-15 13:00:34.142292', '2021-04-15 13:00:34.142292', NULL),
	(10004074, 3, 'PW21A-JK100135BL-L', 0, 0, '2021-04-15 13:00:34.146941', '2021-04-15 13:00:34.146941', NULL),
	(10004075, 3, 'PW21A-JK100135BL-XL', 0, 0, '2021-04-15 13:00:34.145115', '2021-04-15 13:00:34.145115', NULL),
	(10004076, 3, 'PW21A-JK100135BL-XXL', 0, 0, '2021-04-15 13:00:34.172502', '2021-04-15 13:00:34.172502', NULL),
	(10004077, 3, 'PW21A-JK100136OL-XS', 0, 0, '2021-04-15 13:00:34.146344', '2021-04-15 13:00:34.146344', NULL),
	(10004078, 3, 'PW21A-JK100136OL-S', 2, 0, '2021-04-15 13:00:34.160014', '2021-04-15 13:00:34.160014', NULL),
	(10004079, 3, 'PW21A-JK100136OL-M', 1, 0, '2021-04-15 13:00:34.143454', '2021-04-15 13:00:34.143454', NULL),
	(10004080, 3, 'PW21A-JK100136OL-L', 1, 0, '2021-04-15 13:00:34.160531', '2021-04-15 13:00:34.160531', NULL),
	(10004081, 3, 'PW21A-JK100136OL-XL', 1, 0, '2021-04-15 13:00:34.173542', '2021-04-15 13:00:34.173542', NULL),
	(10004082, 3, 'PW21A-JK100136OL-XXL', 1, 0, '2021-04-15 13:00:34.228963', '2021-04-15 13:00:34.228963', NULL),
	(10004083, 3, 'PW21A-JK100137BL-XS', 2, 0, '2021-04-15 13:00:34.174922', '2021-04-15 13:00:34.174922', NULL),
	(10004084, 3, 'PW21A-JK100137BL-S', 1, 0, '2021-04-15 13:00:34.171143', '2021-04-15 13:00:34.171143', NULL),
	(10004085, 3, 'PW21A-JK100137BL-M', 1, 0, '2021-04-15 13:00:34.176213', '2021-04-15 13:00:34.176213', NULL),
	(10004086, 3, 'PW21A-JK100137BL-L', 1, 0, '2021-04-15 13:00:34.189822', '2021-04-15 13:00:34.189822', NULL),
	(10004087, 3, 'PW21A-JK100137BL-XL', 0, 0, '2021-04-15 13:00:34.179457', '2021-04-15 13:00:34.179457', NULL),
	(10004088, 3, 'PW21A-JK100137BL-XXL', 1, 0, '2021-04-15 13:00:34.250973', '2021-04-15 13:00:34.250973', NULL),
	(10004089, 3, 'PW21A-JK100138OL-XS', 0, 0, '2021-04-15 13:00:34.178967', '2021-04-15 13:00:34.178967', NULL),
	(10004090, 3, 'PW21A-JK100138OL-S', 2, 0, '2021-04-15 13:00:34.207140', '2021-04-15 13:00:34.207140', NULL),
	(10004091, 3, 'PW21A-JK100138OL-M', 0, 0, '2021-04-15 13:00:34.207658', '2021-04-15 13:00:34.207658', NULL),
	(10004092, 3, 'PW21A-JK100138OL-L', 2, 0, '2021-04-15 13:00:34.206115', '2021-04-15 13:00:34.206115', NULL),
	(10004093, 3, 'PW21A-JK100138OL-XL', 1, 0, '2021-04-15 13:00:34.215336', '2021-04-15 13:00:34.215336', NULL),
	(10004094, 3, 'PW21A-JK100138OL-XXL', 1, 0, '2021-04-15 13:00:34.453092', '2021-04-15 13:00:34.453092', NULL),
	(10004095, 3, 'PW21A-JK100139BL-XS', 0, 0, '2021-04-15 13:00:34.208738', '2021-04-15 13:00:34.208738', NULL),
	(10004096, 3, 'PW21A-JK100139BL-S', 2, 0, '2021-04-15 13:00:34.209206', '2021-04-15 13:00:34.209206', NULL),
	(10004097, 3, 'PW21A-JK100139BL-M', 1, 0, '2021-04-15 13:00:34.215926', '2021-04-15 13:00:34.215926', NULL),
	(10004098, 3, 'PW21A-JK100139BL-L', 1, 0, '2021-04-15 13:00:34.209666', '2021-04-15 13:00:34.209666', NULL),
	(10004099, 3, 'PW21A-JK100139BL-XL', 1, 0, '2021-04-15 13:00:34.250090', '2021-04-15 13:00:34.250090', NULL),
	(10004100, 3, 'PW21A-JK100139BL-XXL', 1, 0, '2021-04-15 13:00:34.255696', '2021-04-15 13:00:34.255696', NULL),
	(10004101, 3, 'PW21A-JK100140OL-XS', 0, 0, '2021-04-15 13:00:34.229532', '2021-04-15 13:00:34.229532', NULL),
	(10004102, 3, 'PW21A-JK100140OL-S', 2, 0, '2021-04-15 13:00:34.371102', '2021-04-15 13:00:34.371102', NULL),
	(10004103, 3, 'PW21A-JK100140OL-M', 1, 0, '2021-04-15 13:00:34.257598', '2021-04-15 13:00:34.257598', NULL),
	(10004104, 3, 'PW21A-JK100140OL-L', 1, 0, '2021-04-15 13:00:34.253125', '2021-04-15 13:00:34.253125', NULL),
	(10004105, 3, 'PW21A-JK100140OL-XL', 1, 0, '2021-04-15 13:00:34.254244', '2021-04-15 13:00:34.254244', NULL),
	(10004106, 3, 'PW21A-JK100140OL-XXL', 1, 0, '2021-04-15 13:00:34.264275', '2021-04-15 13:00:34.264275', NULL),
	(10004107, 3, 'PW21A-JK100141BL-XS', 0, 0, '2021-04-15 13:00:34.266083', '2021-04-15 13:00:34.266083', NULL),
	(10004108, 3, 'PW21A-JK100141BL-S', 0, 0, '2021-04-15 13:00:34.286116', '2021-04-15 13:00:34.286116', NULL),
	(10004109, 3, 'PW21A-JK100141BL-M', 0, 0, '2021-04-15 13:00:34.334593', '2021-04-15 13:00:34.334593', NULL),
	(10004110, 3, 'PW21A-JK100141BL-L', 1, 0, '2021-04-15 13:00:34.277216', '2021-04-15 13:00:34.277216', NULL),
	(10004111, 3, 'PW21A-JK100141BL-XL', 1, 0, '2021-04-15 13:00:34.278057', '2021-04-15 13:00:34.278057', NULL),
	(10004112, 3, 'PW21A-JK100141BL-XXL', 1, 0, '2021-04-15 13:00:34.352205', '2021-04-15 13:00:34.352205', NULL),
	(10004113, 3, 'PW21A-JK100142OL-XS', 0, 0, '2021-04-15 13:00:34.323459', '2021-04-15 13:00:34.323459', NULL),
	(10004114, 3, 'PW21A-JK100142OL-S', 2, 0, '2021-04-15 13:00:34.320487', '2021-04-15 13:00:34.320487', NULL),
	(10004115, 3, 'PW21A-JK100142OL-M', 1, 0, '2021-04-15 13:00:34.316415', '2021-04-15 13:00:34.316415', NULL),
	(10004116, 3, 'PW21A-JK100142OL-L', 1, 0, '2021-04-15 13:00:34.353551', '2021-04-15 13:00:34.353551', NULL),
	(10004117, 3, 'PW21A-JK100142OL-XL', 1, 0, '2021-04-15 13:00:34.325559', '2021-04-15 13:00:34.325559', NULL),
	(10004118, 3, 'PW21A-JK100142OL-XXL', 1, 0, '2021-04-15 13:00:34.382584', '2021-04-15 13:00:34.382584', NULL),
	(10004119, 3, 'PW21A-JK100143BL-XS', 0, 0, '2021-04-15 13:00:34.397840', '2021-04-15 13:00:34.397840', NULL),
	(10004120, 3, 'PW21A-JK100143BL-S', 2, 0, '2021-04-15 13:00:34.434980', '2021-04-15 13:00:34.434980', NULL),
	(10004121, 3, 'PW21A-JK100143BL-M', 1, 0, '2021-04-15 13:00:34.402709', '2021-04-15 13:00:34.402709', NULL),
	(10004122, 3, 'PW21A-JK100143BL-L', 1, 0, '2021-04-15 13:00:34.391975', '2021-04-15 13:00:34.391975', NULL),
	(10004123, 3, 'PW21A-JK100143BL-XL', 0, 0, '2021-04-15 13:00:34.393742', '2021-04-15 13:00:34.393742', NULL),
	(10004124, 3, 'PW21A-JK100143BL-XXL', 1, 0, '2021-04-15 13:00:34.397277', '2021-04-15 13:00:34.397277', NULL),
	(10004125, 3, 'PW21A-JK100144AR-XS', 0, 0, '2021-04-15 13:00:34.404690', '2021-04-15 13:00:34.404690', NULL),
	(10004126, 3, 'PW21A-JK100144AR-S', 2, 0, '2021-04-15 13:00:34.425526', '2021-04-15 13:00:34.425526', NULL),
	(10004127, 3, 'PW21A-JK100144AR-M', 1, 0, '2021-04-15 13:00:34.412397', '2021-04-15 13:00:34.412397', NULL),
	(10004128, 3, 'PW21A-JK100144AR-L', 1, 0, '2021-04-15 13:00:34.418153', '2021-04-15 13:00:34.418153', NULL),
	(10004129, 3, 'PW21A-JK100144AR-XL', 1, 0, '2021-04-15 13:00:34.481214', '2021-04-15 13:00:34.481214', NULL),
	(10004130, 3, 'PW21A-JK100144AR-XXL', 1, 0, '2021-04-15 13:00:34.411319', '2021-04-15 13:00:34.411319', NULL),
	(10004131, 3, 'PW21A-JK100145RD-XS', 0, 0, '2021-04-15 13:00:34.432007', '2021-04-15 13:00:34.432007', NULL),
	(10004132, 3, 'PW21A-JK100145RD-S', 0, 0, '2021-04-15 13:00:34.446722', '2021-04-15 13:00:34.446722', NULL),
	(10004133, 3, 'PW21A-JK100145RD-M', 0, 0, '2021-04-15 13:00:34.441544', '2021-04-15 13:00:34.441544', NULL),
	(10004134, 3, 'PW21A-JK100145RD-L', 1, 0, '2021-04-15 13:00:34.433743', '2021-04-15 13:00:34.433743', NULL),
	(10004135, 3, 'PW21A-JK100145RD-XL', 1, 0, '2021-04-15 13:00:34.584729', '2021-04-15 13:00:34.584729', NULL),
	(10004136, 3, 'PW21A-JK100145RD-XXL', 1, 0, '2021-04-15 13:00:34.477876', '2021-04-15 13:00:34.477876', NULL),
	(10004137, 3, 'PW21A-JK100146BL-XS', 0, 0, '2021-04-15 13:00:34.452557', '2021-04-15 13:00:34.452557', NULL),
	(10004138, 3, 'PW21A-JK100146BL-S', 2, 0, '2021-04-15 13:00:34.443877', '2021-04-15 13:00:34.443877', NULL),
	(10004139, 3, 'PW21A-JK100146BL-M', 1, 0, '2021-04-15 13:00:34.485699', '2021-04-15 13:00:34.485699', NULL),
	(10004140, 3, 'PW21A-JK100146BL-L', 1, 0, '2021-04-15 13:00:34.498776', '2021-04-15 13:00:34.498776', NULL),
	(10004141, 3, 'PW21A-JK100146BL-XL', 1, 0, '2021-04-15 13:00:34.458931', '2021-04-15 13:00:34.458931', NULL),
	(10004142, 3, 'PW21A-JK100146BL-XXL', 1, 0, '2021-04-15 13:00:34.475154', '2021-04-15 13:00:34.475154', NULL),
	(10004143, 3, 'PW21A-JK100147BL-XS', 0, 0, '2021-04-15 13:00:34.480604', '2021-04-15 13:00:34.480604', NULL),
	(10004144, 3, 'PW21A-JK100147BL-S', 2, 0, '2021-04-15 13:00:34.463229', '2021-04-15 13:00:34.463229', NULL),
	(10004145, 3, 'PW21A-JK100147BL-M', 1, 0, '2021-04-15 13:00:34.511231', '2021-04-15 13:00:34.511231', NULL),
	(10004146, 3, 'PW21A-JK100147BL-L', 1, 0, '2021-04-15 13:00:34.732716', '2021-04-15 13:00:34.732716', NULL),
	(10004147, 3, 'PW21A-JK100147BL-XL', 1, 0, '2021-04-15 13:00:34.577229', '2021-04-15 13:00:34.577229', NULL),
	(10004148, 3, 'PW21A-JK100147BL-XXL', 1, 0, '2021-04-15 13:00:34.522400', '2021-04-15 13:00:34.522400', NULL),
	(10004149, 3, 'PW21A-JK100148BL-XS', 0, 0, '2021-04-15 13:00:34.500797', '2021-04-15 13:00:34.500797', NULL),
	(10004150, 3, 'PW21A-JK100148BL-S', 2, 0, '2021-04-15 13:00:34.501601', '2021-04-15 13:00:34.501601', NULL),
	(10004151, 3, 'PW21A-JK100148BL-M', 1, 0, '2021-04-15 13:00:34.505173', '2021-04-15 13:00:34.505173', NULL),
	(10004152, 3, 'PW21A-JK100148BL-L', 1, 0, '2021-04-15 13:00:34.532258', '2021-04-15 13:00:34.532258', NULL),
	(10004153, 3, 'PW21A-JK100148BL-XL', 1, 0, '2021-04-15 13:00:34.525791', '2021-04-15 13:00:34.525791', NULL),
	(10004154, 3, 'PW21A-JK100148BL-XXL', 1, 0, '2021-04-15 13:00:34.557391', '2021-04-15 13:00:34.557391', NULL),
	(10004155, 3, 'PW21A-JK100149BL-XS', 0, 0, '2021-04-15 13:00:34.524123', '2021-04-15 13:00:34.524123', NULL),
	(10004156, 3, 'PW21A-JK100149BL-S', 2, 0, '2021-04-15 13:00:34.542232', '2021-04-15 13:00:34.542232', NULL),
	(10004157, 3, 'PW21A-JK100149BL-M', 1, 0, '2021-04-15 13:00:34.553899', '2021-04-15 13:00:34.553899', NULL),
	(10004158, 3, 'PW21A-JK100149BL-L', 1, 0, '2021-04-15 13:00:34.592891', '2021-04-15 13:00:34.592891', NULL),
	(10004159, 3, 'PW21A-JK100149BL-XL', 1, 0, '2021-04-15 13:00:34.563440', '2021-04-15 13:00:34.563440', NULL),
	(10004160, 3, 'PW21A-JK100149BL-XXL', 1, 0, '2021-04-15 13:00:34.579207', '2021-04-15 13:00:34.579207', NULL),
	(10004161, 3, 'PW21A-JK100150BL-XS', 0, 0, '2021-04-15 13:00:34.580656', '2021-04-15 13:00:34.580656', NULL),
	(10004162, 3, 'PW21A-JK100150BL-S', 2, 0, '2021-04-15 13:00:34.552744', '2021-04-15 13:00:34.552744', NULL),
	(10004163, 3, 'PW21A-JK100150BL-M', 1, 0, '2021-04-15 13:00:34.569689', '2021-04-15 13:00:34.569689', NULL),
	(10004164, 3, 'PW21A-JK100150BL-L', 1, 0, '2021-04-15 13:00:34.631184', '2021-04-15 13:00:34.631184', NULL),
	(10004165, 3, 'PW21A-JK100150BL-XL', 1, 0, '2021-04-15 13:00:34.590065', '2021-04-15 13:00:34.590065', NULL),
	(10004166, 3, 'PW21A-JK100150BL-XXL', 1, 0, '2021-04-15 13:00:34.581217', '2021-04-15 13:00:34.581217', NULL),
	(10004167, 3, 'PW21A-JK100151BL-XS', 0, 0, '2021-04-15 13:00:34.594759', '2021-04-15 13:00:34.594759', NULL),
	(10004168, 3, 'PW21A-JK100151BL-S', 2, 0, '2021-04-15 13:00:34.656078', '2021-04-15 13:00:34.656078', NULL),
	(10004169, 3, 'PW21A-JK100151BL-M', 1, 0, '2021-04-15 13:00:34.600922', '2021-04-15 13:00:34.600922', NULL),
	(10004170, 3, 'PW21A-JK100151BL-L', 1, 0, '2021-04-15 13:00:34.612086', '2021-04-15 13:00:34.612086', NULL),
	(10004171, 3, 'PW21A-JK100151BL-XL', 1, 0, '2021-04-15 13:00:34.608434', '2021-04-15 13:00:34.608434', NULL),
	(10004172, 3, 'PW21A-JK100151BL-XXL', 1, 0, '2021-04-15 13:00:34.596958', '2021-04-15 13:00:34.596958', NULL),
	(10004173, 3, 'PW21A-JK100152BL-XS', 0, 0, '2021-04-15 13:00:34.623678', '2021-04-15 13:00:34.623678', NULL),
	(10004174, 3, 'PW21A-JK100152BL-S', 2, 0, '2021-04-15 13:00:34.615173', '2021-04-15 13:00:34.615173', NULL),
	(10004175, 3, 'PW21A-JK100152BL-M', 1, 0, '2021-04-15 13:00:34.633710', '2021-04-15 13:00:34.633710', NULL),
	(10004176, 3, 'PW21A-JK100152BL-L', 1, 0, '2021-04-15 13:00:34.613211', '2021-04-15 13:00:34.613211', NULL),
	(10004177, 3, 'PW21A-JK100152BL-XL', 1, 0, '2021-04-15 13:00:34.616300', '2021-04-15 13:00:34.616300', NULL),
	(10004178, 3, 'PW21A-JK100152BL-XXL', 1, 0, '2021-04-15 13:00:34.651419', '2021-04-15 13:00:34.651419', NULL),
	(10004179, 3, 'PW21A-JK100153GN-XS', 0, 0, '2021-04-15 13:00:34.638890', '2021-04-15 13:00:34.638890', NULL),
	(10004180, 3, 'PW21A-JK100153GN-S', 2, 0, '2021-04-15 13:00:34.649798', '2021-04-15 13:00:34.649798', NULL),
	(10004181, 3, 'PW21A-JK100153GN-M', 1, 0, '2021-04-15 13:00:34.629754', '2021-04-15 13:00:34.629754', NULL),
	(10004182, 3, 'PW21A-JK100153GN-L', 1, 0, '2021-04-15 13:00:34.661252', '2021-04-15 13:00:34.661252', NULL),
	(10004183, 3, 'PW21A-JK100153GN-XL', 1, 0, '2021-04-15 13:00:34.645338', '2021-04-15 13:00:34.645338', NULL),
	(10004184, 3, 'PW21A-JK100153GN-XXL', 1, 0, '2021-04-15 13:00:34.654930', '2021-04-15 13:00:34.654930', NULL),
	(10004185, 3, 'PW21A-JD100154BL-XS', 0, 0, '2021-04-15 13:00:34.669115', '2021-04-15 13:00:34.669115', NULL),
	(10004186, 3, 'PW21A-JD100154BL-S', 0, 0, '2021-04-15 13:00:34.766146', '2021-04-15 13:00:34.766146', NULL),
	(10004187, 3, 'PW21A-JD100154BL-M', 0, 0, '2021-04-15 13:00:34.667825', '2021-04-15 13:00:34.667825', NULL),
	(10004188, 3, 'PW21A-JD100154BL-L', 0, 0, '2021-04-15 13:00:34.674342', '2021-04-15 13:00:34.674342', NULL),
	(10004189, 3, 'PW21A-JD100154BL-XL', 0, 0, '2021-04-15 13:00:34.695218', '2021-04-15 13:00:34.695218', NULL),
	(10004190, 3, 'PW21A-JD100154BL-XXL', 0, 0, '2021-04-15 13:00:34.692382', '2021-04-15 13:00:34.692382', NULL),
	(10004191, 3, 'PW21A-JK100155OL-XS', 0, 0, '2021-04-15 13:00:34.710736', '2021-04-15 13:00:34.710736', NULL),
	(10004192, 3, 'PW21A-JK100155OL-S', 0, 0, '2021-04-15 13:00:34.684002', '2021-04-15 13:00:34.684002', NULL),
	(10004193, 3, 'PW21A-JK100155OL-M', 0, 0, '2021-04-15 13:00:34.679303', '2021-04-15 13:00:34.679303', NULL),
	(10004194, 3, 'PW21A-JK100155OL-L', 0, 0, '2021-04-15 13:00:34.707928', '2021-04-15 13:00:34.707928', NULL),
	(10004195, 3, 'PW21A-JK100155OL-XL', 0, 0, '2021-04-15 13:00:34.696452', '2021-04-15 13:00:34.696452', NULL),
	(10004196, 3, 'PW21A-JK100155OL-XXL', 0, 0, '2021-04-15 13:00:34.693655', '2021-04-15 13:00:34.693655', NULL),
	(10004197, 3, 'PW21A-JK100156YW -XS', 0, 0, '2021-04-15 13:00:34.705369', '2021-04-15 13:00:34.705369', NULL),
	(10004198, 3, 'PW21A-JK100156YW -S', 0, 0, '2021-04-15 13:00:34.711147', '2021-04-15 13:00:34.711147', NULL),
	(10004199, 3, 'PW21A-JK100156YW -M', 0, 0, '2021-04-15 13:00:34.698417', '2021-04-15 13:00:34.698417', NULL),
	(10004200, 3, 'PW21A-JK100156YW -L', 0, 0, '2021-04-15 13:00:34.753000', '2021-04-15 13:00:34.753000', NULL),
	(10004201, 3, 'PW21A-JK100156YW -XL', 0, 0, '2021-04-15 13:00:34.717875', '2021-04-15 13:00:34.717875', NULL),
	(10004202, 3, 'PW21A-JK100156YW -XXL', 0, 0, '2021-04-15 13:00:34.725115', '2021-04-15 13:00:34.725115', NULL),
	(10004203, 3, 'PW21A-JK100157BL-XS', 0, 0, '2021-04-15 13:00:34.723885', '2021-04-15 13:00:34.723885', NULL),
	(10004204, 3, 'PW21A-JK100157BL-S', 2, 0, '2021-04-15 13:00:34.718566', '2021-04-15 13:00:34.718566', NULL),
	(10004205, 3, 'PW21A-JK100157BL-M', 1, 0, '2021-04-15 13:00:34.737184', '2021-04-15 13:00:34.737184', NULL),
	(10004206, 3, 'PW21A-JK100157BL-L', 1, 0, '2021-04-15 13:00:34.731924', '2021-04-15 13:00:34.731924', NULL),
	(10004207, 3, 'PW21A-JK100157BL-XL', 1, 0, '2021-04-15 13:00:34.762761', '2021-04-15 13:00:34.762761', NULL),
	(10004208, 3, 'PW21A-JK100157BL-XXL', 1, 0, '2021-04-15 13:00:34.724774', '2021-04-15 13:00:34.724774', NULL),
	(10004209, 3, 'PW21A-JK100158AR-XS', 0, 0, '2021-04-15 13:00:34.755323', '2021-04-15 13:00:34.755323', NULL),
	(10004210, 3, 'PW21A-JK100158AR-S', 0, 0, '2021-04-15 13:00:34.725430', '2021-04-15 13:00:34.725430', NULL),
	(10004211, 3, 'PW21A-JK100158AR-M', 0, 0, '2021-04-15 13:00:34.738897', '2021-04-15 13:00:34.738897', NULL),
	(10004212, 3, 'PW21A-JK100158AR-L', 0, 0, '2021-04-15 13:00:34.742283', '2021-04-15 13:00:34.742283', NULL),
	(10004213, 3, 'PW21A-JK100158AR-XL', 0, 0, '2021-04-15 13:00:34.746309', '2021-04-15 13:00:34.746309', NULL),
	(10004214, 3, 'PW21A-JK100158AR-XXL', 0, 0, '2021-04-15 13:00:34.754280', '2021-04-15 13:00:34.754280', NULL),
	(10004215, 3, 'PW21A-JD100159MR-XS', 0, 0, '2021-04-15 13:00:34.757762', '2021-04-15 13:00:34.757762', NULL),
	(10004216, 3, 'PW21A-JD100159MR-S', 0, 0, '2021-04-15 13:00:34.777001', '2021-04-15 13:00:34.777001', NULL),
	(10004217, 3, 'PW21A-JD100159MR-M', 0, 0, '2021-04-15 13:00:34.765561', '2021-04-15 13:00:34.765561', NULL),
	(10004218, 3, 'PW21A-JD100159MR-L', 0, 0, '2021-04-15 13:00:34.832770', '2021-04-15 13:00:34.832770', NULL),
	(10004219, 3, 'PW21A-JD100159MR-XL', 0, 0, '2021-04-15 13:00:34.761896', '2021-04-15 13:00:34.761896', NULL),
	(10004220, 3, 'PW21A-JD100159MR-XXL', 0, 0, '2021-04-15 13:00:34.768566', '2021-04-15 13:00:34.768566', NULL),
	(10004221, 3, 'PW21A-JK100160TC-XS', 0, 0, '2021-04-15 13:00:34.781571', '2021-04-15 13:00:34.781571', NULL),
	(10004222, 3, 'PW21A-JK100160TC-S', 0, 0, '2021-04-15 13:00:34.783826', '2021-04-15 13:00:34.783826', NULL),
	(10004223, 3, 'PW21A-JK100160TC-M', 0, 0, '2021-04-15 13:00:34.790167', '2021-04-15 13:00:34.790167', NULL),
	(10004224, 3, 'PW21A-JK100160TC-L', 0, 0, '2021-04-15 13:00:34.881632', '2021-04-15 13:00:34.881632', NULL),
	(10004225, 3, 'PW21A-JK100160TC-XL', 0, 0, '2021-04-15 13:00:34.784272', '2021-04-15 13:00:34.784272', NULL),
	(10004226, 3, 'PW21A-JK100160TC-XXL', 0, 0, '2021-04-15 13:00:34.782656', '2021-04-15 13:00:34.782656', NULL),
	(10004227, 3, 'PW21A-JK100161BL-XS', 0, 0, '2021-04-15 13:00:34.790908', '2021-04-15 13:00:34.790908', NULL),
	(10004228, 3, 'PW21A-JK100161BL-S', 2, 0, '2021-04-15 13:00:34.796969', '2021-04-15 13:00:34.796969', NULL),
	(10004229, 3, 'PW21A-JK100161BL-M', 1, 0, '2021-04-15 13:00:34.792750', '2021-04-15 13:00:34.792750', NULL),
	(10004230, 3, 'PW21A-JK100161BL-L', 1, 0, '2021-04-15 13:00:34.804704', '2021-04-15 13:00:34.804704', NULL),
	(10004231, 3, 'PW21A-JK100161BL-XL', 1, 0, '2021-04-15 13:00:34.811519', '2021-04-15 13:00:34.811519', NULL),
	(10004232, 3, 'PW21A-JK100161BL-XXL', 1, 0, '2021-04-15 13:00:34.795804', '2021-04-15 13:00:34.795804', NULL),
	(10004233, 3, 'PW21A-JD100162BL-XS', 0, 0, '2021-04-15 13:00:34.820693', '2021-04-15 13:00:34.820693', NULL),
	(10004234, 3, 'PW21A-JD100162BL-S', 0, 0, '2021-04-15 13:00:34.812028', '2021-04-15 13:00:34.812028', NULL),
	(10004235, 3, 'PW21A-JD100162BL-M', 0, 0, '2021-04-15 13:00:34.814464', '2021-04-15 13:00:34.814464', NULL),
	(10004236, 3, 'PW21A-JD100162BL-L', 0, 0, '2021-04-15 13:00:34.810075', '2021-04-15 13:00:34.810075', NULL),
	(10004237, 3, 'PW21A-JD100162BL-XL', 0, 0, '2021-04-15 13:00:34.824862', '2021-04-15 13:00:34.824862', NULL),
	(10004238, 3, 'PW21A-JD100162BL-XXL', 0, 0, '2021-04-15 13:00:34.896757', '2021-04-15 13:00:34.896757', NULL),
	(10004239, 3, 'PW21A-JK100163RD-XS', 2, 0, '2021-04-15 13:00:34.837446', '2021-04-15 13:00:34.837446', NULL),
	(10004240, 3, 'PW21A-JK100163RD-S', 1, 0, '2021-04-15 13:00:34.818959', '2021-04-15 13:00:34.818959', NULL),
	(10004241, 3, 'PW21A-JK100163RD-M', 1, 0, '2021-04-15 13:00:34.845668', '2021-04-15 13:00:34.845668', NULL),
	(10004242, 3, 'PW21A-JK100163RD-L', 1, 0, '2021-04-15 13:00:34.820273', '2021-04-15 13:00:34.820273', NULL),
	(10004243, 3, 'PW21A-JK100163RD-XL', 1, 0, '2021-04-15 13:00:34.874880', '2021-04-15 13:00:34.874880', NULL),
	(10004244, 3, 'PW21A-JK100163RD-XXL', 1, 0, '2021-04-15 13:00:34.846730', '2021-04-15 13:00:34.846730', NULL),
	(10004245, 3, 'PW21A-JD100164BL-XS', 0, 0, '2021-04-15 13:00:34.853268', '2021-04-15 13:00:34.853268', NULL),
	(10004246, 3, 'PW21A-JD100164BL-S', 0, 0, '2021-04-15 13:00:34.845309', '2021-04-15 13:00:34.845309', NULL),
	(10004247, 3, 'PW21A-JD100164BL-M', 0, 0, '2021-04-15 13:00:34.844938', '2021-04-15 13:00:34.844938', NULL),
	(10004248, 3, 'PW21A-JD100164BL-L', 0, 0, '2021-04-15 13:00:34.862004', '2021-04-15 13:00:34.862004', NULL),
	(10004249, 3, 'PW21A-JD100164BL-XL', 0, 0, '2021-04-15 13:00:34.853731', '2021-04-15 13:00:34.853731', NULL),
	(10004250, 3, 'PW21A-JD100164BL-XXL', 0, 0, '2021-04-15 13:00:34.867045', '2021-04-15 13:00:34.867045', NULL),
	(10004251, 3, 'PW21A-JK100165NV-XS', 0, 0, '2021-04-15 13:00:34.854261', '2021-04-15 13:00:34.854261', NULL),
	(10004252, 3, 'PW21A-JK100165NV-S', 0, 0, '2021-04-15 13:00:34.872019', '2021-04-15 13:00:34.872019', NULL),
	(10004253, 3, 'PW21A-JK100165NV-M', 0, 0, '2021-04-15 13:00:34.860027', '2021-04-15 13:00:34.860027', NULL),
	(10004254, 3, 'PW21A-JK100165NV-L', 0, 0, '2021-04-15 13:00:34.883775', '2021-04-15 13:00:34.883775', NULL),
	(10004255, 3, 'PW21A-JK100165NV-XL', 0, 0, '2021-04-15 13:00:34.919937', '2021-04-15 13:00:34.919937', NULL),
	(10004256, 3, 'PW21A-JK100165NV-XXL', 0, 0, '2021-04-15 13:00:34.884892', '2021-04-15 13:00:34.884892', NULL),
	(10004257, 3, 'PW21A-JK100166MR-XS', 0, 0, '2021-04-15 13:00:34.874108', '2021-04-15 13:00:34.874108', NULL),
	(10004258, 3, 'PW21A-JK100166MR-S', 0, 0, '2021-04-15 13:00:34.874500', '2021-04-15 13:00:34.874500', NULL),
	(10004259, 3, 'PW21A-JK100166MR-M', 0, 0, '2021-04-15 13:00:34.946867', '2021-04-15 13:00:34.946867', NULL),
	(10004260, 3, 'PW21A-JK100166MR-L', 0, 0, '2021-04-15 13:00:34.887347', '2021-04-15 13:00:34.887347', NULL),
	(10004261, 3, 'PW21A-JK100166MR-XL', 0, 0, '2021-04-15 13:00:34.916763', '2021-04-15 13:00:34.916763', NULL),
	(10004262, 3, 'PW21A-JK100166MR-XXL', 0, 0, '2021-04-15 13:00:34.904979', '2021-04-15 13:00:34.904979', NULL),
	(10004263, 3, 'PW21A-JK100167WT-XS', 0, 0, '2021-04-15 13:00:34.891904', '2021-04-15 13:00:34.891904', NULL),
	(10004264, 3, 'PW21A-JK100167WT-S', 2, 0, '2021-04-15 13:00:34.906319', '2021-04-15 13:00:34.906319', NULL),
	(10004265, 3, 'PW21A-JK100167WT-M', 1, 0, '2021-04-15 13:00:34.907920', '2021-04-15 13:00:34.907920', NULL),
	(10004266, 3, 'PW21A-JK100167WT-L', 1, 0, '2021-04-15 13:00:34.910227', '2021-04-15 13:00:34.910227', NULL),
	(10004267, 3, 'PW21A-JK100167WT-XL', 1, 0, '2021-04-15 13:00:34.906795', '2021-04-15 13:00:34.906795', NULL),
	(10004268, 3, 'PW21A-JK100167WT-XXL', 1, 0, '2021-04-15 13:00:34.918899', '2021-04-15 13:00:34.918899', NULL),
	(10004269, 3, 'PW21A-JK100168BL-XS', 0, 0, '2021-04-15 13:00:34.931762', '2021-04-15 13:00:34.931762', NULL),
	(10004270, 3, 'PW21A-JK100168BL-S', 2, 0, '2021-04-15 13:00:34.914948', '2021-04-15 13:00:34.914948', NULL),
	(10004271, 3, 'PW21A-JK100168BL-M', 1, 0, '2021-04-15 13:00:34.933153', '2021-04-15 13:00:34.933153', NULL),
	(10004272, 3, 'PW21A-JK100168BL-L', 1, 0, '2021-04-15 13:00:34.980808', '2021-04-15 13:00:34.980808', NULL),
	(10004273, 3, 'PW21A-JK100168BL-XL', 1, 0, '2021-04-15 13:00:34.934985', '2021-04-15 13:00:34.934985', NULL),
	(10004274, 3, 'PW21A-JK100168BL-XXL', 1, 0, '2021-04-15 13:00:34.959420', '2021-04-15 13:00:34.959420', NULL),
	(10004275, 3, 'PW21A-JK100169BL-XS', 0, 0, '2021-04-15 13:00:34.925330', '2021-04-15 13:00:34.925330', NULL),
	(10004276, 3, 'PW21A-JK100169BL-S', 0, 0, '2021-04-15 13:00:35.014817', '2021-04-15 13:00:35.014817', NULL),
	(10004277, 3, 'PW21A-JK100169BL-M', 0, 0, '2021-04-15 13:00:34.935341', '2021-04-15 13:00:34.935341', NULL),
	(10004278, 3, 'PW21A-JK100169BL-L', 0, 0, '2021-04-15 13:00:34.943893', '2021-04-15 13:00:34.943893', NULL),
	(10004279, 3, 'PW21A-JK100169BL-XL', 0, 0, '2021-04-15 13:00:34.937174', '2021-04-15 13:00:34.937174', NULL),
	(10004280, 3, 'PW21A-JK100169BL-XXL', 0, 0, '2021-04-15 13:00:34.949345', '2021-04-15 13:00:34.949345', NULL),
	(10004281, 3, 'PW21A-JK100170RD-XS', 0, 0, '2021-04-15 13:00:34.963711', '2021-04-15 13:00:34.963711', NULL),
	(10004282, 3, 'PW21A-JK100170RD-S', 0, 0, '2021-04-15 13:00:34.945499', '2021-04-15 13:00:34.945499', NULL),
	(10004283, 3, 'PW21A-JK100170RD-M', 0, 0, '2021-04-15 13:00:34.960315', '2021-04-15 13:00:34.960315', NULL),
	(10004284, 3, 'PW21A-JK100170RD-L', 0, 0, '2021-04-15 13:00:34.942425', '2021-04-15 13:00:34.942425', NULL),
	(10004285, 3, 'PW21A-JK100170RD-XL', 0, 0, '2021-04-15 13:00:34.958643', '2021-04-15 13:00:34.958643', NULL),
	(10004286, 3, 'PW21A-JK100170RD-XXL', 0, 0, '2021-04-15 13:00:35.036410', '2021-04-15 13:00:35.036410', NULL),
	(10004287, 3, 'PW21A-JK100171WT-XS', 0, 0, '2021-04-15 13:00:34.971215', '2021-04-15 13:00:34.971215', NULL),
	(10004288, 3, 'PW21A-JK100171WT-S', 0, 0, '2021-04-15 13:00:35.039451', '2021-04-15 13:00:35.039451', NULL),
	(10004289, 3, 'PW21A-JK100171WT-M', 0, 0, '2021-04-15 13:00:34.975223', '2021-04-15 13:00:34.975223', NULL),
	(10004290, 3, 'PW21A-JK100171WT-L', 0, 0, '2021-04-15 13:00:35.018072', '2021-04-15 13:00:35.018072', NULL),
	(10004291, 3, 'PW21A-JK100171WT-XL', 0, 0, '2021-04-15 13:00:34.984384', '2021-04-15 13:00:34.984384', NULL),
	(10004292, 3, 'PW21A-JK100171WT-XXL', 0, 0, '2021-04-15 13:00:34.976407', '2021-04-15 13:00:34.976407', NULL),
	(10004293, 3, 'PW21A-JK100172BL-XS', 0, 0, '2021-04-15 13:00:34.996052', '2021-04-15 13:00:34.996052', NULL),
	(10004294, 3, 'PW21A-JK100172BL-S', 2, 0, '2021-04-15 13:00:34.985415', '2021-04-15 13:00:34.985415', NULL),
	(10004295, 3, 'PW21A-JK100172BL-M', 1, 0, '2021-04-15 13:00:35.000167', '2021-04-15 13:00:35.000167', NULL),
	(10004296, 3, 'PW21A-JK100172BL-L', 1, 0, '2021-04-15 13:00:35.000854', '2021-04-15 13:00:35.000854', NULL),
	(10004297, 3, 'PW21A-JK100172BL-XL', 1, 0, '2021-04-15 13:00:35.015196', '2021-04-15 13:00:35.015196', NULL),
	(10004298, 3, 'PW21A-JK100172BL-XXL', 1, 0, '2021-04-15 13:00:35.003764', '2021-04-15 13:00:35.003764', NULL),
	(10004299, 3, 'PW21A-TS100173BL-XS', 0, 0, '2021-04-15 13:00:34.995462', '2021-04-15 13:00:34.995462', NULL),
	(10004300, 3, 'PW21A-TS100173BL-M', 0, 0, '2021-04-15 13:00:35.008955', '2021-04-15 13:00:35.008955', NULL),
	(10004301, 3, 'PW21A-TS100173BL-L', 0, 0, '2021-04-15 13:00:35.023311', '2021-04-15 13:00:35.023311', NULL),
	(10004302, 3, 'PW21A-TS100173BL-XL', 0, 0, '2021-04-15 13:00:35.030601', '2021-04-15 13:00:35.030601', NULL),
	(10004303, 3, 'PW21A-TS100173BL-XXL', 0, 0, '2021-04-15 13:00:35.066357', '2021-04-15 13:00:35.066357', NULL),
	(10004304, 3, 'PW21A-TS100174NV-XS', 0, 0, '2021-04-15 13:00:35.036060', '2021-04-15 13:00:35.036060', NULL),
	(10004305, 3, 'PW21A-TS100174NV-S', 0, 0, '2021-04-15 13:00:35.034263', '2021-04-15 13:00:35.034263', NULL),
	(10004306, 3, 'PW21A-TS100174NV-M', 0, 0, '2021-04-15 13:00:35.041071', '2021-04-15 13:00:35.041071', NULL),
	(10004307, 3, 'PW21A-TS100174NV-L', 0, 0, '2021-04-15 13:00:35.108004', '2021-04-15 13:00:35.108004', NULL),
	(10004308, 3, 'PW21A-TS100174NV-XL', 0, 0, '2021-04-15 13:00:35.044798', '2021-04-15 13:00:35.044798', NULL),
	(10004309, 3, 'PW21A-TS100174NV-XXL', 0, 0, '2021-04-15 13:00:35.055334', '2021-04-15 13:00:35.055334', NULL),
	(10004310, 3, 'PW21A-TS100175BL-XS', 0, 0, '2021-04-15 13:00:35.044226', '2021-04-15 13:00:35.044226', NULL),
	(10004311, 3, 'PW21A-TS100175BL-S', 0, 0, '2021-04-15 13:00:35.061525', '2021-04-15 13:00:35.061525', NULL),
	(10004312, 3, 'PW21A-TS100175BL-M', 0, 0, '2021-04-15 13:00:35.119439', '2021-04-15 13:00:35.119439', NULL),
	(10004313, 3, 'PW21A-TS100175BL-L', 0, 0, '2021-04-15 13:00:35.052411', '2021-04-15 13:00:35.052411', NULL),
	(10004314, 3, 'PW21A-TS100175BL-XL', 0, 0, '2021-04-15 13:00:35.078692', '2021-04-15 13:00:35.078692', NULL),
	(10004315, 3, 'PW21A-TS100175BL-XXL', 0, 0, '2021-04-15 13:00:35.075246', '2021-04-15 13:00:35.075246', NULL),
	(10004316, 3, 'PW21A-TS100176BL-XS', 0, 0, '2021-04-15 13:00:35.069603', '2021-04-15 13:00:35.069603', NULL),
	(10004317, 3, 'PW21A-TS100176BL-S', 0, 0, '2021-04-15 13:00:35.157516', '2021-04-15 13:00:35.157516', NULL),
	(10004318, 3, 'PW21A-TS100176BL-M', 0, 0, '2021-04-15 13:00:35.068999', '2021-04-15 13:00:35.068999', NULL),
	(10004319, 3, 'PW21A-TS100176BL-L', 0, 0, '2021-04-15 13:00:35.068357', '2021-04-15 13:00:35.068357', NULL),
	(10004320, 3, 'PW21A-TS100176BL-XL', 0, 0, '2021-04-15 13:00:35.094781', '2021-04-15 13:00:35.094781', NULL),
	(10004321, 3, 'PW21A-TS100176BL-XXL', 0, 0, '2021-04-15 13:00:35.097749', '2021-04-15 13:00:35.097749', NULL),
	(10004322, 3, 'PW21A-TS100177BL-XS', 0, 0, '2021-04-15 13:00:35.076684', '2021-04-15 13:00:35.076684', NULL),
	(10004323, 3, 'PW21A-TS100177BL-S', 0, 0, '2021-04-15 13:00:35.102111', '2021-04-15 13:00:35.102111', NULL),
	(10004324, 3, 'PW21A-TS100177BL-M', 0, 0, '2021-04-15 13:00:35.202431', '2021-04-15 13:00:35.202431', NULL),
	(10004325, 3, 'PW21A-TS100177BL-L', 0, 0, '2021-04-15 13:00:35.102568', '2021-04-15 13:00:35.102568', NULL),
	(10004326, 3, 'PW21A-TS100177BL-XL', 0, 0, '2021-04-15 13:00:35.108604', '2021-04-15 13:00:35.108604', NULL),
	(10004327, 3, 'PW21A-TS100177BL-XXL', 0, 0, '2021-04-15 13:00:35.125274', '2021-04-15 13:00:35.125274', NULL),
	(10004328, 3, 'PW21A-TS100178BL-XS', 0, 0, '2021-04-15 13:00:35.174888', '2021-04-15 13:00:35.174888', NULL),
	(10004329, 3, 'PW21A-TS100178BL-S', 0, 0, '2021-04-15 13:00:35.229912', '2021-04-15 13:00:35.229912', NULL),
	(10004330, 3, 'PW21A-TS100178BL-M', 0, 0, '2021-04-15 13:00:35.116943', '2021-04-15 13:00:35.116943', NULL),
	(10004331, 3, 'PW21A-TS100178BL-L', 0, 0, '2021-04-15 13:00:35.134052', '2021-04-15 13:00:35.134052', NULL),
	(10004332, 3, 'PW21A-TS100178BL-XL', 0, 0, '2021-04-15 13:00:35.243844', '2021-04-15 13:00:35.243844', NULL),
	(10004333, 3, 'PW21A-TS100178BL-XXL', 0, 0, '2021-04-15 13:00:35.158772', '2021-04-15 13:00:35.158772', NULL),
	(10004334, 3, 'PW21A-TS100179BL-XS', 0, 0, '2021-04-15 13:00:35.119881', '2021-04-15 13:00:35.119881', NULL),
	(10004335, 3, 'PW21A-TS100179BL-S', 0, 0, '2021-04-15 13:00:35.142846', '2021-04-15 13:00:35.142846', NULL),
	(10004336, 3, 'PW21A-TS100179BL-M', 0, 0, '2021-04-15 13:00:35.155661', '2021-04-15 13:00:35.155661', NULL),
	(10004337, 3, 'PW21A-TS100179BL-L', 0, 0, '2021-04-15 13:00:35.164120', '2021-04-15 13:00:35.164120', NULL),
	(10004338, 3, 'PW21A-TS100179BL-XL', 0, 0, '2021-04-15 13:00:35.160272', '2021-04-15 13:00:35.160272', NULL),
	(10004339, 3, 'PW21A-TS100179BL-XXL', 0, 0, '2021-04-15 13:00:35.210081', '2021-04-15 13:00:35.210081', NULL),
	(10004340, 3, 'PW21A-TS100180BL-XS', 0, 0, '2021-04-15 13:00:35.168408', '2021-04-15 13:00:35.168408', NULL),
	(10004341, 3, 'PW21A-TS100180BL-S', 0, 0, '2021-04-15 13:00:35.178471', '2021-04-15 13:00:35.178471', NULL),
	(10004342, 3, 'PW21A-TS100180BL-M', 0, 0, '2021-04-15 13:00:35.207656', '2021-04-15 13:00:35.207656', NULL),
	(10004343, 3, 'PW21A-TS100180BL-L', 0, 0, '2021-04-15 13:00:35.215153', '2021-04-15 13:00:35.215153', NULL),
	(10004344, 3, 'PW21A-TS100180BL-XL', 0, 0, '2021-04-15 13:00:35.211640', '2021-04-15 13:00:35.211640', NULL),
	(10004345, 3, 'PW21A-TS100180BL-XXL', 0, 0, '2021-04-15 13:00:35.221897', '2021-04-15 13:00:35.221897', NULL),
	(10004346, 3, 'PW21A-TS100181BL-XS', 0, 0, '2021-04-15 13:00:35.216924', '2021-04-15 13:00:35.216924', NULL),
	(10004347, 3, 'PW21A-TS100181BL-S', 2, 0, '2021-04-15 13:00:35.183254', '2021-04-15 13:00:35.183254', NULL),
	(10004348, 3, 'PW21A-TS100181BL-M', 2, 0, '2021-04-15 13:00:35.196769', '2021-04-15 13:00:35.196769', NULL),
	(10004349, 3, 'PW21A-TS100181BL-L', 0, 0, '2021-04-15 13:00:35.225917', '2021-04-15 13:00:35.225917', NULL),
	(10004350, 3, 'PW21A-TS100181BL-XL', 1, 0, '2021-04-15 13:00:35.212211', '2021-04-15 13:00:35.212211', NULL),
	(10004351, 3, 'PW21A-TS100181BL-XXL', 0, 0, '2021-04-15 13:00:35.240175', '2021-04-15 13:00:35.240175', NULL),
	(10004352, 3, 'PW21A-TS100182BL-XS', 0, 0, '2021-04-15 13:00:35.240841', '2021-04-15 13:00:35.240841', NULL),
	(10004353, 3, 'PW21A-TS100182BL-S', 0, 0, '2021-04-15 13:00:35.244450', '2021-04-15 13:00:35.244450', NULL),
	(10004354, 3, 'PW21A-TS100182BL-M', 0, 0, '2021-04-15 13:00:35.315917', '2021-04-15 13:00:35.315917', NULL),
	(10004355, 3, 'PW21A-TS100182BL-L', 0, 0, '2021-04-15 13:00:35.230401', '2021-04-15 13:00:35.230401', NULL),
	(10004356, 3, 'PW21A-TS100182BL-XL', 0, 0, '2021-04-15 13:00:35.248565', '2021-04-15 13:00:35.248565', NULL),
	(10004357, 3, 'PW21A-TS100182BL-XXL', 0, 0, '2021-04-15 13:00:35.277965', '2021-04-15 13:00:35.277965', NULL),
	(10004358, 3, 'PW21A-TS100183BL-XS', 0, 0, '2021-04-15 13:00:35.249928', '2021-04-15 13:00:35.249928', NULL),
	(10004359, 3, 'PW21A-TS100183BL-S', 0, 0, '2021-04-15 13:00:35.256807', '2021-04-15 13:00:35.256807', NULL),
	(10004360, 3, 'PW21A-TS100183BL-M', 0, 0, '2021-04-15 13:00:35.276651', '2021-04-15 13:00:35.276651', NULL),
	(10004361, 3, 'PW21A-TS100183BL-L', 0, 0, '2021-04-15 13:00:35.259213', '2021-04-15 13:00:35.259213', NULL),
	(10004362, 3, 'PW21A-TS100183BL-XL', 0, 0, '2021-04-15 13:00:35.291948', '2021-04-15 13:00:35.291948', NULL),
	(10004363, 3, 'PW21A-TS100183BL-XXL', 0, 0, '2021-04-15 13:00:35.268228', '2021-04-15 13:00:35.268228', NULL),
	(10004364, 3, 'PW21A-TS100184BL-XS', 0, 0, '2021-04-15 13:00:35.264083', '2021-04-15 13:00:35.264083', NULL),
	(10004365, 3, 'PW21A-TS100184BL-S', 0, 0, '2021-04-15 13:00:35.281020', '2021-04-15 13:00:35.281020', NULL),
	(10004366, 3, 'PW21A-TS100184BL-M', 0, 0, '2021-04-15 13:00:35.286558', '2021-04-15 13:00:35.286558', NULL),
	(10004367, 3, 'PW21A-TS100184BL-L', 0, 0, '2021-04-15 13:00:35.375051', '2021-04-15 13:00:35.375051', NULL),
	(10004368, 3, 'PW21A-TS100184BL-XL', 0, 0, '2021-04-15 13:00:35.278426', '2021-04-15 13:00:35.278426', NULL),
	(10004369, 3, 'PW21A-TS100184BL-XXL', 0, 0, '2021-04-15 13:00:35.282826', '2021-04-15 13:00:35.282826', NULL),
	(10004370, 3, 'PW21A-TS100185BL-XS', 0, 0, '2021-04-15 13:00:35.318776', '2021-04-15 13:00:35.318776', NULL),
	(10004371, 3, 'PW21A-TS100185BL-S', 0, 0, '2021-04-15 13:00:35.296345', '2021-04-15 13:00:35.296345', NULL),
	(10004372, 3, 'PW21A-TS100185BL-M', 0, 0, '2021-04-15 13:00:35.287148', '2021-04-15 13:00:35.287148', NULL),
	(10004373, 3, 'PW21A-TS100185BL-L', 0, 0, '2021-04-15 13:00:35.309860', '2021-04-15 13:00:35.309860', NULL),
	(10004374, 3, 'PW21A-TS100185BL-XL', 0, 0, '2021-04-15 13:00:35.310364', '2021-04-15 13:00:35.310364', NULL),
	(10004375, 3, 'PW21A-TS100185BL-XXL', 0, 0, '2021-04-15 13:00:35.305955', '2021-04-15 13:00:35.305955', NULL),
	(10004376, 3, 'PW21A-TS100186BL-XS', 0, 0, '2021-04-15 13:00:35.300591', '2021-04-15 13:00:35.300591', NULL),
	(10004377, 3, 'PW21A-TS100186BL-S', 0, 0, '2021-04-15 13:00:35.312750', '2021-04-15 13:00:35.312750', NULL),
	(10004378, 3, 'PW21A-TS100186BL-M', 0, 0, '2021-04-15 13:00:35.318252', '2021-04-15 13:00:35.318252', NULL),
	(10004379, 3, 'PW21A-TS100186BL-L', 0, 0, '2021-04-15 13:00:35.348395', '2021-04-15 13:00:35.348395', NULL),
	(10004380, 3, 'PW21A-TS100186BL-XL', 0, 0, '2021-04-15 13:00:35.314061', '2021-04-15 13:00:35.314061', NULL),
	(10004381, 3, 'PW21A-TS100186BL-XXL', 0, 0, '2021-04-15 13:00:35.372538', '2021-04-15 13:00:35.372538', NULL),
	(10004382, 3, 'PW21A-TS100187BL-XS', 0, 0, '2021-04-15 13:00:35.334835', '2021-04-15 13:00:35.334835', NULL),
	(10004383, 3, 'PW21A-TS100187BL-S', 0, 0, '2021-04-15 13:00:35.340452', '2021-04-15 13:00:35.340452', NULL),
	(10004384, 3, 'PW21A-TS100187BL-M', 0, 0, '2021-04-15 13:00:35.391960', '2021-04-15 13:00:35.391960', NULL),
	(10004385, 3, 'PW21A-TS100187BL-L', 0, 0, '2021-04-15 13:00:35.369429', '2021-04-15 13:00:35.369429', NULL),
	(10004386, 3, 'PW21A-TS100187BL-XL', 0, 0, '2021-04-15 13:00:35.345472', '2021-04-15 13:00:35.345472', NULL),
	(10004387, 3, 'PW21A-TS100187BL-XXL', 0, 0, '2021-04-15 13:00:35.371738', '2021-04-15 13:00:35.371738', NULL),
	(10004388, 3, 'PW21A-TS100188BL-XS', 0, 0, '2021-04-15 13:00:35.459627', '2021-04-15 13:00:35.459627', NULL),
	(10004389, 3, 'PW21A-TS100188BL-S', 0, 0, '2021-04-15 13:00:35.394841', '2021-04-15 13:00:35.394841', NULL),
	(10004390, 3, 'PW21A-TS100188BL-M', 0, 0, '2021-04-15 13:00:35.351531', '2021-04-15 13:00:35.351531', NULL),
	(10004391, 3, 'PW21A-TS100188BL-L', 0, 0, '2021-04-15 13:00:35.355118', '2021-04-15 13:00:35.355118', NULL),
	(10004392, 3, 'PW21A-TS100188BL-XL', 0, 0, '2021-04-15 13:00:35.408200', '2021-04-15 13:00:35.408200', NULL),
	(10004393, 3, 'PW21A-TS100188BL-XXL', 0, 0, '2021-04-15 13:00:35.383215', '2021-04-15 13:00:35.383215', NULL),
	(10004394, 3, 'PW21A-TS100189BL-XS', 0, 0, '2021-04-15 13:00:35.401300', '2021-04-15 13:00:35.401300', NULL),
	(10004395, 3, 'PW21A-TS100189BL-S', 0, 0, '2021-04-15 13:00:35.411483', '2021-04-15 13:00:35.411483', NULL),
	(10004396, 3, 'PW21A-TS100189BL-M', 0, 0, '2021-04-15 13:00:35.401736', '2021-04-15 13:00:35.401736', NULL),
	(10004397, 3, 'PW21A-TS100189BL-L', 0, 0, '2021-04-15 13:00:35.438249', '2021-04-15 13:00:35.438249', NULL),
	(10004398, 3, 'PW21A-TS100189BL-XL', 0, 0, '2021-04-15 13:00:35.406517', '2021-04-15 13:00:35.406517', NULL),
	(10004399, 3, 'PW21A-TS100189BL-XXL', 0, 0, '2021-04-15 13:00:35.420842', '2021-04-15 13:00:35.420842', NULL),
	(10004400, 3, 'PW21A-TS100190WT-XS', 0, 0, '2021-04-15 13:00:35.411980', '2021-04-15 13:00:35.411980', NULL),
	(10004401, 3, 'PW21A-TS100190WT-S', 0, 0, '2021-04-15 13:00:35.427138', '2021-04-15 13:00:35.427138', NULL),
	(10004402, 3, 'PW21A-TS100190WT-M', 0, 0, '2021-04-15 13:00:35.412434', '2021-04-15 13:00:35.412434', NULL),
	(10004403, 3, 'PW21A-TS100190WT-L', 0, 0, '2021-04-15 13:00:35.461378', '2021-04-15 13:00:35.461378', NULL),
	(10004404, 3, 'PW21A-TS100190WT-XL', 0, 0, '2021-04-15 13:00:35.459997', '2021-04-15 13:00:35.459997', NULL),
	(10004405, 3, 'PW21A-TS100190WT-XXL', 0, 0, '2021-04-15 13:00:35.430994', '2021-04-15 13:00:35.430994', NULL),
	(10004406, 3, 'PW21A-TS100191YW -XS', 0, 0, '2021-04-15 13:00:35.434149', '2021-04-15 13:00:35.434149', NULL),
	(10004407, 3, 'PW21A-TS100191YW -S', 1, 0, '2021-04-15 13:00:35.438899', '2021-04-15 13:00:35.438899', NULL),
	(10004408, 3, 'PW21A-TS100191YW -M', 2, 0, '2021-04-15 13:00:35.433506', '2021-04-15 13:00:35.433506', NULL),
	(10004409, 3, 'PW21A-TS100191YW -L', 2, 0, '2021-04-15 13:00:35.436591', '2021-04-15 13:00:35.436591', NULL),
	(10004410, 3, 'PW21A-TS100191YW -XL', 1, 0, '2021-04-15 13:00:35.437075', '2021-04-15 13:00:35.437075', NULL),
	(10004411, 3, 'PW21A-TS100191YW -XXL', 2, 0, '2021-04-15 13:00:35.458244', '2021-04-15 13:00:35.458244', NULL),
	(10004412, 3, 'PW21A-TS100192GN-XS', 0, 0, '2021-04-15 13:00:35.446775', '2021-04-15 13:00:35.446775', NULL),
	(10004413, 3, 'PW21A-TS100192GN-S', 2, 0, '2021-04-15 13:00:35.450746', '2021-04-15 13:00:35.450746', NULL),
	(10004414, 3, 'PW21A-TS100192GN-M', 2, 0, '2021-04-15 13:00:35.439307', '2021-04-15 13:00:35.439307', NULL),
	(10004415, 3, 'PW21A-TS100192GN-L', 1, 0, '2021-04-15 13:00:35.479283', '2021-04-15 13:00:35.479283', NULL),
	(10004416, 3, 'PW21A-TS100192GN-XL', 2, 0, '2021-04-15 13:00:35.514474', '2021-04-15 13:00:35.514474', NULL),
	(10004417, 3, 'PW21A-TS100192GN-XXL', 2, 0, '2021-04-15 13:00:35.461810', '2021-04-15 13:00:35.461810', NULL),
	(10004418, 3, 'PW21A-TS100193BL-XS', 0, 0, '2021-04-15 13:00:35.448675', '2021-04-15 13:00:35.448675', NULL),
	(10004419, 3, 'PW21A-TS100193BL-S', 2, 0, '2021-04-15 13:00:35.488095', '2021-04-15 13:00:35.488095', NULL),
	(10004420, 3, 'PW21A-TS100193BL-M', 2, 0, '2021-04-15 13:00:35.458672', '2021-04-15 13:00:35.458672', NULL),
	(10004421, 3, 'PW21A-TS100193BL-L', 2, 0, '2021-04-15 13:00:35.470642', '2021-04-15 13:00:35.470642', NULL),
	(10004422, 3, 'PW21A-TS100193BL-XL', 2, 0, '2021-04-15 13:00:35.538492', '2021-04-15 13:00:35.538492', NULL),
	(10004423, 3, 'PW21A-TS100193BL-XXL', 2, 0, '2021-04-15 13:00:35.478413', '2021-04-15 13:00:35.478413', NULL),
	(10004424, 3, 'PW21A-TS100194RD-XS', 0, 0, '2021-04-15 13:00:35.460295', '2021-04-15 13:00:35.460295', NULL),
	(10004425, 3, 'PW21A-TS100194RD-S', 2, 0, '2021-04-15 13:00:35.467545', '2021-04-15 13:00:35.467545', NULL),
	(10004426, 3, 'PW21A-TS100194RD-M', 0, 0, '2021-04-15 13:00:35.490925', '2021-04-15 13:00:35.490925', NULL),
	(10004427, 3, 'PW21A-TS100194RD-L', 1, 0, '2021-04-15 13:00:35.492080', '2021-04-15 13:00:35.492080', NULL),
	(10004428, 3, 'PW21A-TS100194RD-XL', 2, 0, '2021-04-15 13:00:35.470108', '2021-04-15 13:00:35.470108', NULL),
	(10004429, 3, 'PW21A-TS100194RD-XXL', 2, 0, '2021-04-15 13:00:35.577313', '2021-04-15 13:00:35.577313', NULL),
	(10004430, 3, 'PW21A-TS100195BL-XS', 0, 0, '2021-04-15 13:00:35.505642', '2021-04-15 13:00:35.505642', NULL),
	(10004431, 3, 'PW21A-TS100195BL-S', 2, 0, '2021-04-15 13:00:35.491515', '2021-04-15 13:00:35.491515', NULL),
	(10004432, 3, 'PW21A-TS100195BL-M', 2, 0, '2021-04-15 13:00:35.492648', '2021-04-15 13:00:35.492648', NULL),
	(10004433, 3, 'PW21A-TS100195BL-L', 2, 0, '2021-04-15 13:00:35.505189', '2021-04-15 13:00:35.505189', NULL),
	(10004434, 3, 'PW21A-TS100195BL-XL', 1, 0, '2021-04-15 13:00:35.519438', '2021-04-15 13:00:35.519438', NULL),
	(10004435, 3, 'PW21A-TS100195BL-XXL', 2, 0, '2021-04-15 13:00:35.501067', '2021-04-15 13:00:35.501067', NULL),
	(10004436, 3, 'PW21A-TS100196BL-XS', 0, 0, '2021-04-15 13:00:35.513611', '2021-04-15 13:00:35.513611', NULL),
	(10004437, 3, 'PW21A-TS100196BL-S', 2, 0, '2021-04-15 13:00:35.524795', '2021-04-15 13:00:35.524795', NULL),
	(10004438, 3, 'PW21A-TS100196BL-M', 1, 0, '2021-04-15 13:00:35.551717', '2021-04-15 13:00:35.551717', NULL),
	(10004439, 3, 'PW21A-TS100196BL-L', 2, 0, '2021-04-15 13:00:35.524371', '2021-04-15 13:00:35.524371', NULL),
	(10004440, 3, 'PW21A-TS100196BL-XL', 2, 0, '2021-04-15 13:00:35.521264', '2021-04-15 13:00:35.521264', NULL),
	(10004441, 3, 'PW21A-TS100196BL-XXL', 2, 0, '2021-04-15 13:00:35.552355', '2021-04-15 13:00:35.552355', NULL),
	(10004442, 3, 'PW21A-TS100197BL-XS', 0, 0, '2021-04-15 13:00:35.523930', '2021-04-15 13:00:35.523930', NULL),
	(10004443, 3, 'PW21A-TS100197BL-S', 0, 0, '2021-04-15 13:00:35.532556', '2021-04-15 13:00:35.532556', NULL),
	(10004444, 3, 'PW21A-TS100197BL-M', 0, 0, '2021-04-15 13:00:35.546150', '2021-04-15 13:00:35.546150', NULL),
	(10004445, 3, 'PW21A-TS100197BL-L', 0, 0, '2021-04-15 13:00:35.539426', '2021-04-15 13:00:35.539426', NULL),
	(10004446, 3, 'PW21A-TS100197BL-XL', 0, 0, '2021-04-15 13:00:35.591159', '2021-04-15 13:00:35.591159', NULL),
	(10004447, 3, 'PW21A-TS100197BL-XXL', 0, 0, '2021-04-15 13:00:35.556915', '2021-04-15 13:00:35.556915', NULL),
	(10004448, 3, 'PW21A-TS100198BL-XS', 0, 0, '2021-04-15 13:00:35.545286', '2021-04-15 13:00:35.545286', NULL),
	(10004449, 3, 'PW21A-TS100198BL-S', 2, 0, '2021-04-15 13:00:35.552040', '2021-04-15 13:00:35.552040', NULL),
	(10004450, 3, 'PW21A-TS100198BL-M', 2, 0, '2021-04-15 13:00:35.564216', '2021-04-15 13:00:35.564216', NULL),
	(10004451, 3, 'PW21A-TS100198BL-L', 2, 0, '2021-04-15 13:00:35.549128', '2021-04-15 13:00:35.549128', NULL),
	(10004452, 3, 'PW21A-TS100198BL-XL', 2, 0, '2021-04-15 13:00:35.550255', '2021-04-15 13:00:35.550255', NULL),
	(10004453, 3, 'PW21A-TS100198BL-XXL', 2, 0, '2021-04-15 13:00:35.563674', '2021-04-15 13:00:35.563674', NULL),
	(10004454, 3, 'PW21A-TS100199BL-XS', 0, 0, '2021-04-15 13:00:35.571556', '2021-04-15 13:00:35.571556', NULL),
	(10004455, 3, 'PW21A-TS100199BL-S', 0, 0, '2021-04-15 13:00:35.576656', '2021-04-15 13:00:35.576656', NULL),
	(10004456, 3, 'PW21A-TS100199BL-M', 0, 0, '2021-04-15 13:00:35.695306', '2021-04-15 13:00:35.695306', NULL),
	(10004457, 3, 'PW21A-TS100199BL-L', 0, 0, '2021-04-15 13:00:35.631319', '2021-04-15 13:00:35.631319', NULL),
	(10004458, 3, 'PW21A-TS100199BL-XL', 0, 0, '2021-04-15 13:00:35.581741', '2021-04-15 13:00:35.581741', NULL),
	(10004459, 3, 'PW21A-TS100199BL-XXL', 0, 0, '2021-04-15 13:00:35.575871', '2021-04-15 13:00:35.575871', NULL),
	(10004460, 3, 'PW21A-TS100200BL-XS', 0, 0, '2021-04-15 13:00:35.568473', '2021-04-15 13:00:35.568473', NULL),
	(10004461, 3, 'PW21A-TS100200BL-S', 0, 0, '2021-04-15 13:00:35.578783', '2021-04-15 13:00:35.578783', NULL),
	(10004462, 3, 'PW21A-TS100200BL-M', 0, 0, '2021-04-15 13:00:35.589829', '2021-04-15 13:00:35.589829', NULL),
	(10004463, 3, 'PW21A-TS100200BL-L', 0, 0, '2021-04-15 13:00:35.640760', '2021-04-15 13:00:35.640760', NULL),
	(10004464, 3, 'PW21A-TS100200BL-XL', 0, 0, '2021-04-15 13:00:35.598151', '2021-04-15 13:00:35.598151', NULL),
	(10004465, 3, 'PW21A-TS100200BL-XXL', 0, 0, '2021-04-15 13:00:35.579127', '2021-04-15 13:00:35.579127', NULL),
	(10004466, 3, 'PW21A-TS100201BL-XS', 0, 0, '2021-04-15 13:00:35.595771', '2021-04-15 13:00:35.595771', NULL),
	(10004467, 3, 'PW21A-TS100201BL-S', 2, 0, '2021-04-15 13:00:35.601647', '2021-04-15 13:00:35.601647', NULL),
	(10004468, 3, 'PW21A-TS100201BL-M', 2, 0, '2021-04-15 13:00:35.593539', '2021-04-15 13:00:35.593539', NULL),
	(10004469, 3, 'PW21A-TS100201BL-L', 2, 0, '2021-04-15 13:00:35.606524', '2021-04-15 13:00:35.606524', NULL),
	(10004470, 3, 'PW21A-TS100201BL-XL', 2, 0, '2021-04-15 13:00:35.615122', '2021-04-15 13:00:35.615122', NULL),
	(10004471, 3, 'PW21A-TS100201BL-XXL', 2, 0, '2021-04-15 13:00:35.628647', '2021-04-15 13:00:35.628647', NULL),
	(10004472, 3, 'PW21A-TS100202BL-XS', 0, 0, '2021-04-15 13:00:35.602915', '2021-04-15 13:00:35.602915', NULL),
	(10004473, 3, 'PW21A-TS100202BL-S', 2, 0, '2021-04-15 13:00:35.610198', '2021-04-15 13:00:35.610198', NULL),
	(10004474, 3, 'PW21A-TS100202BL-M', 2, 0, '2021-04-15 13:00:35.702184', '2021-04-15 13:00:35.702184', NULL),
	(10004475, 3, 'PW21A-TS100202BL-L', 1, 0, '2021-04-15 13:00:35.608010', '2021-04-15 13:00:35.608010', NULL),
	(10004476, 3, 'PW21A-TS100202BL-XL', 1, 0, '2021-04-15 13:00:35.646281', '2021-04-15 13:00:35.646281', NULL),
	(10004477, 3, 'PW21A-TS100202BL-XXL', 1, 0, '2021-04-15 13:00:35.623901', '2021-04-15 13:00:35.623901', NULL),
	(10004478, 3, 'PW21A-TS100203BL-XS', 0, 0, '2021-04-15 13:00:35.633956', '2021-04-15 13:00:35.633956', NULL),
	(10004479, 3, 'PW21A-TS100203BL-S', 2, 0, '2021-04-15 13:00:35.624995', '2021-04-15 13:00:35.624995', NULL),
	(10004480, 3, 'PW21A-TS100203BL-M', 2, 0, '2021-04-15 13:00:35.643203', '2021-04-15 13:00:35.643203', NULL),
	(10004481, 3, 'PW21A-TS100203BL-L', 2, 0, '2021-04-15 13:00:35.635303', '2021-04-15 13:00:35.635303', NULL),
	(10004482, 3, 'PW21A-TS100203BL-XL', 2, 0, '2021-04-15 13:00:35.639009', '2021-04-15 13:00:35.639009', NULL),
	(10004483, 3, 'PW21A-TS100203BL-XXL', 2, 0, '2021-04-15 13:00:35.662121', '2021-04-15 13:00:35.662121', NULL),
	(10004484, 3, 'PW21A-TS100204BL-XS', 0, 0, '2021-04-15 13:00:35.648536', '2021-04-15 13:00:35.648536', NULL),
	(10004485, 3, 'PW21A-TS100204BL-S', 2, 0, '2021-04-15 13:00:35.659062', '2021-04-15 13:00:35.659062', NULL),
	(10004486, 3, 'PW21A-TS100204BL-M', 0, 0, '2021-04-15 13:00:35.654308', '2021-04-15 13:00:35.654308', NULL),
	(10004487, 3, 'PW21A-TS100204BL-L', 2, 0, '2021-04-15 13:00:35.649904', '2021-04-15 13:00:35.649904', NULL),
	(10004488, 3, 'PW21A-TS100204BL-XL', 2, 0, '2021-04-15 13:00:35.665318', '2021-04-15 13:00:35.665318', NULL),
	(10004489, 3, 'PW21A-TS100204BL-XXL', 1, 0, '2021-04-15 13:00:35.664723', '2021-04-15 13:00:35.664723', NULL),
	(10004490, 3, 'PW21A-TS100205WT-XS', 0, 0, '2021-04-15 13:00:35.690824', '2021-04-15 13:00:35.690824', NULL),
	(10004491, 3, 'PW21A-TS100205WT-S', 0, 0, '2021-04-15 13:00:35.662453', '2021-04-15 13:00:35.662453', NULL),
	(10004492, 3, 'PW21A-TS100205WT-M', 0, 0, '2021-04-15 13:00:35.677830', '2021-04-15 13:00:35.677830', NULL),
	(10004493, 3, 'PW21A-TS100205WT-L', 0, 0, '2021-04-15 13:00:35.792237', '2021-04-15 13:00:35.792237', NULL),
	(10004494, 3, 'PW21A-TS100205WT-XL', 0, 0, '2021-04-15 13:00:35.672811', '2021-04-15 13:00:35.672811', NULL),
	(10004495, 3, 'PW21A-TS100205WT-XXL', 0, 0, '2021-04-15 13:00:35.734157', '2021-04-15 13:00:35.734157', NULL),
	(10004496, 3, 'PW21A-TS100206WT-XS', 0, 0, '2021-04-15 13:00:35.678958', '2021-04-15 13:00:35.678958', NULL),
	(10004497, 3, 'PW21A-TS100206WT-S', 0, 0, '2021-04-15 13:00:35.702979', '2021-04-15 13:00:35.702979', NULL),
	(10004498, 3, 'PW21A-TS100206WT-M', 0, 0, '2021-04-15 13:00:35.707093', '2021-04-15 13:00:35.707093', NULL),
	(10004499, 3, 'PW21A-TS100206WT-L', 0, 0, '2021-04-15 13:00:35.697808', '2021-04-15 13:00:35.697808', NULL),
	(10004500, 3, 'PW21A-TS100206WT-XL', 0, 0, '2021-04-15 13:00:35.692046', '2021-04-15 13:00:35.692046', NULL),
	(10004501, 3, 'PW21A-TS100206WT-XXL', 0, 0, '2021-04-15 13:00:35.746563', '2021-04-15 13:00:35.746563', NULL),
	(10004502, 3, 'PW21A-TS100207BL-XS', 0, 0, '2021-04-15 13:00:35.698411', '2021-04-15 13:00:35.698411', NULL),
	(10004503, 3, 'PW21A-TS100207BL-S', 2, 0, '2021-04-15 13:00:35.715038', '2021-04-15 13:00:35.715038', NULL),
	(10004504, 3, 'PW21A-TS100207BL-M', 2, 0, '2021-04-15 13:00:35.707693', '2021-04-15 13:00:35.707693', NULL),
	(10004505, 3, 'PW21A-TS100207BL-L', 2, 0, '2021-04-15 13:00:35.719560', '2021-04-15 13:00:35.719560', NULL),
	(10004506, 3, 'PW21A-TS100207BL-XL', 2, 0, '2021-04-15 13:00:35.718245', '2021-04-15 13:00:35.718245', NULL),
	(10004507, 3, 'PW21A-TS100207BL-XXL', 1, 0, '2021-04-15 13:00:35.711754', '2021-04-15 13:00:35.711754', NULL),
	(10004508, 3, 'PW21A-TS100208BL-XS', 0, 0, '2021-04-15 13:00:35.731944', '2021-04-15 13:00:35.731944', NULL),
	(10004509, 3, 'PW21A-TS100208BL-S', 0, 0, '2021-04-15 13:00:35.749444', '2021-04-15 13:00:35.749444', NULL),
	(10004510, 3, 'PW21A-TS100208BL-M', 0, 0, '2021-04-15 13:00:35.739284', '2021-04-15 13:00:35.739284', NULL),
	(10004511, 3, 'PW21A-TS100208BL-L', 0, 0, '2021-04-15 13:00:35.727579', '2021-04-15 13:00:35.727579', NULL),
	(10004512, 3, 'PW21A-TS100208BL-XL', 0, 0, '2021-04-15 13:00:35.726917', '2021-04-15 13:00:35.726917', NULL),
	(10004513, 3, 'PW21A-TS100208BL-XXL', 0, 0, '2021-04-15 13:00:35.746117', '2021-04-15 13:00:35.746117', NULL),
	(10004514, 3, 'PW21A-TS100209BL-XS', 0, 0, '2021-04-15 13:00:35.740736', '2021-04-15 13:00:35.740736', NULL),
	(10004515, 3, 'PW21A-TS100209BL-S', 2, 0, '2021-04-15 13:00:35.734564', '2021-04-15 13:00:35.734564', NULL),
	(10004516, 3, 'PW21A-TS100209BL-M', 2, 0, '2021-04-15 13:00:35.751927', '2021-04-15 13:00:35.751927', NULL),
	(10004517, 3, 'PW21A-TS100209BL-L', 2, 0, '2021-04-15 13:00:35.756930', '2021-04-15 13:00:35.756930', NULL),
	(10004518, 3, 'PW21A-TS100209BL-XL', 2, 0, '2021-04-15 13:00:35.759340', '2021-04-15 13:00:35.759340', NULL),
	(10004519, 3, 'PW21A-TS100209BL-XXL', 2, 0, '2021-04-15 13:00:35.751588', '2021-04-15 13:00:35.751588', NULL),
	(10004520, 3, 'PW21A-TS100210BL-XS', 0, 0, '2021-04-15 13:00:35.779035', '2021-04-15 13:00:35.779035', NULL),
	(10004521, 3, 'PW21A-TS100210BL-S', 0, 0, '2021-04-15 13:00:35.767633', '2021-04-15 13:00:35.767633', NULL),
	(10004522, 3, 'PW21A-TS100210BL-M', 0, 0, '2021-04-15 13:00:35.793887', '2021-04-15 13:00:35.793887', NULL),
	(10004523, 3, 'PW21A-TS100210BL-L', 0, 0, '2021-04-15 13:00:35.772460', '2021-04-15 13:00:35.772460', NULL),
	(10004524, 3, 'PW21A-TS100210BL-XL', 0, 0, '2021-04-15 13:00:35.840698', '2021-04-15 13:00:35.840698', NULL),
	(10004525, 3, 'PW21A-TS100210BL-XXL', 0, 0, '2021-04-15 13:00:35.778608', '2021-04-15 13:00:35.778608', NULL),
	(10004526, 3, 'PW21A-TS100211BL-XS', 0, 0, '2021-04-15 13:00:35.783787', '2021-04-15 13:00:35.783787', NULL),
	(10004527, 3, 'PW21A-TS100211BL-S', 0, 0, '2021-04-15 13:00:35.780619', '2021-04-15 13:00:35.780619', NULL),
	(10004528, 3, 'PW21A-TS100211BL-M', 0, 0, '2021-04-15 13:00:35.788381', '2021-04-15 13:00:35.788381', NULL),
	(10004529, 3, 'PW21A-TS100211BL-L', 0, 0, '2021-04-15 13:00:35.773948', '2021-04-15 13:00:35.773948', NULL),
	(10004530, 3, 'PW21A-TS100211BL-XL', 0, 0, '2021-04-15 13:00:35.785032', '2021-04-15 13:00:35.785032', NULL),
	(10004531, 3, 'PW21A-TS100211BL-XXL', 0, 0, '2021-04-15 13:00:35.800951', '2021-04-15 13:00:35.800951', NULL),
	(10004532, 3, 'PW21A-TS100212GN-XS', 0, 0, '2021-04-15 13:00:35.799652', '2021-04-15 13:00:35.799652', NULL),
	(10004533, 3, 'PW21A-TS100212GN-S', 0, 0, '2021-04-15 13:00:35.811565', '2021-04-15 13:00:35.811565', NULL),
	(10004534, 3, 'PW21A-TS100212GN-M', 0, 0, '2021-04-15 13:00:35.816988', '2021-04-15 13:00:35.816988', NULL),
	(10004535, 3, 'PW21A-TS100212GN-L', 0, 0, '2021-04-15 13:00:35.826039', '2021-04-15 13:00:35.826039', NULL),
	(10004536, 3, 'PW21A-TS100212GN-XL', 0, 0, '2021-04-15 13:00:35.810616', '2021-04-15 13:00:35.810616', NULL),
	(10004537, 3, 'PW21A-TS100212GN-XXL', 0, 0, '2021-04-15 13:00:35.876608', '2021-04-15 13:00:35.876608', NULL),
	(10004538, 3, 'PW21A-TS100213BL-XS', 0, 0, '2021-04-15 13:00:35.847571', '2021-04-15 13:00:35.847571', NULL),
	(10004539, 3, 'PW21A-TS100213BL-S', 2, 0, '2021-04-15 13:00:35.813941', '2021-04-15 13:00:35.813941', NULL),
	(10004540, 3, 'PW21A-TS100213BL-M', 2, 0, '2021-04-15 13:00:35.830472', '2021-04-15 13:00:35.830472', NULL),
	(10004541, 3, 'PW21A-TS100213BL-L', 2, 0, '2021-04-15 13:00:35.825103', '2021-04-15 13:00:35.825103', NULL),
	(10004542, 3, 'PW21A-TS100213BL-XL', 2, 0, '2021-04-15 13:00:35.824158', '2021-04-15 13:00:35.824158', NULL),
	(10004543, 3, 'PW21A-TS100213BL-XXL', 2, 0, '2021-04-15 13:00:35.820028', '2021-04-15 13:00:35.820028', NULL),
	(10004544, 3, 'PW21A-TS100214BL-XS', 0, 0, '2021-04-15 13:00:35.841061', '2021-04-15 13:00:35.841061', NULL),
	(10004545, 3, 'PW21A-TS100214BL-S', 0, 0, '2021-04-15 13:00:35.826997', '2021-04-15 13:00:35.826997', NULL),
	(10004546, 3, 'PW21A-TS100214BL-M', 0, 0, '2021-04-15 13:00:35.839783', '2021-04-15 13:00:35.839783', NULL),
	(10004547, 3, 'PW21A-TS100214BL-L', 0, 0, '2021-04-15 13:00:35.939209', '2021-04-15 13:00:35.939209', NULL),
	(10004548, 3, 'PW21A-TS100214BL-XL', 0, 0, '2021-04-15 13:00:35.853084', '2021-04-15 13:00:35.853084', NULL),
	(10004549, 3, 'PW21A-TS100214BL-XXL', 0, 0, '2021-04-15 13:00:35.842489', '2021-04-15 13:00:35.842489', NULL),
	(10004550, 3, 'PW21A-TS100215BL-XS', 0, 0, '2021-04-15 13:00:35.837341', '2021-04-15 13:00:35.837341', NULL),
	(10004551, 3, 'PW21A-TS100215BL-S', 0, 0, '2021-04-15 13:00:35.847053', '2021-04-15 13:00:35.847053', NULL),
	(10004552, 3, 'PW21A-TS100215BL-M', 0, 0, '2021-04-15 13:00:35.865154', '2021-04-15 13:00:35.865154', NULL),
	(10004553, 3, 'PW21A-TS100215BL-L', 0, 0, '2021-04-15 13:00:35.849404', '2021-04-15 13:00:35.849404', NULL),
	(10004554, 3, 'PW21A-TS100215BL-XL', 0, 0, '2021-04-15 13:00:35.851257', '2021-04-15 13:00:35.851257', NULL),
	(10004555, 3, 'PW21A-TS100215BL-XXL', 0, 0, '2021-04-15 13:00:35.863682', '2021-04-15 13:00:35.863682', NULL),
	(10004556, 3, 'PW21A-TS100216NV-XS', 0, 0, '2021-04-15 13:00:35.861088', '2021-04-15 13:00:35.861088', NULL),
	(10004557, 3, 'PW21A-TS100216NV-S', 0, 0, '2021-04-15 13:00:35.872023', '2021-04-15 13:00:35.872023', NULL),
	(10004558, 3, 'PW21A-TS100216NV-M', 0, 0, '2021-04-15 13:00:35.860741', '2021-04-15 13:00:35.860741', NULL),
	(10004559, 3, 'PW21A-TS100216NV-L', 0, 0, '2021-04-15 13:00:35.873470', '2021-04-15 13:00:35.873470', NULL),
	(10004560, 3, 'PW21A-TS100216NV-XL', 0, 0, '2021-04-15 13:00:35.906452', '2021-04-15 13:00:35.906452', NULL),
	(10004561, 3, 'PW21A-TS100216NV-XXL', 0, 0, '2021-04-15 13:00:35.875257', '2021-04-15 13:00:35.875257', NULL),
	(10004562, 3, 'PW21A-TS100217BL-XS', 0, 0, '2021-04-15 13:00:35.867485', '2021-04-15 13:00:35.867485', NULL),
	(10004563, 3, 'PW21A-TS100217BL-S', 1, 0, '2021-04-15 13:00:35.886086', '2021-04-15 13:00:35.886086', NULL),
	(10004564, 3, 'PW21A-TS100217BL-M', 1, 0, '2021-04-15 13:00:35.884033', '2021-04-15 13:00:35.884033', NULL),
	(10004565, 3, 'PW21A-TS100217BL-L', 1, 0, '2021-04-15 13:00:35.894601', '2021-04-15 13:00:35.894601', NULL),
	(10004566, 3, 'PW21A-TS100217BL-XL', 2, 0, '2021-04-15 13:00:35.961567', '2021-04-15 13:00:35.961567', NULL),
	(10004567, 3, 'PW21A-TS100217BL-XXL', 2, 0, '2021-04-15 13:00:35.894161', '2021-04-15 13:00:35.894161', NULL),
	(10004568, 3, 'PW21A-TS100218BL-XS', 0, 0, '2021-04-15 13:00:35.910602', '2021-04-15 13:00:35.910602', NULL),
	(10004569, 3, 'PW21A-TS100218BL-S', 2, 0, '2021-04-15 13:00:35.878538', '2021-04-15 13:00:35.878538', NULL),
	(10004570, 3, 'PW21A-TS100218BL-M', 2, 0, '2021-04-15 13:00:35.889080', '2021-04-15 13:00:35.889080', NULL),
	(10004571, 3, 'PW21A-TS100218BL-L', 2, 0, '2021-04-15 13:00:35.921234', '2021-04-15 13:00:35.921234', NULL),
	(10004572, 3, 'PW21A-TS100218BL-XL', 1, 0, '2021-04-15 13:00:35.910172', '2021-04-15 13:00:35.910172', NULL),
	(10004573, 3, 'PW21A-TS100218BL-XXL', 2, 0, '2021-04-15 13:00:35.923208', '2021-04-15 13:00:35.923208', NULL),
	(10004574, 3, 'PW21A-TS100219BL-XS', 0, 0, '2021-04-15 13:00:35.906867', '2021-04-15 13:00:35.906867', NULL),
	(10004575, 3, 'PW21A-TS100219BL-S', 2, 0, '2021-04-15 13:00:35.912985', '2021-04-15 13:00:35.912985', NULL),
	(10004576, 3, 'PW21A-TS100219BL-M', 1, 0, '2021-04-15 13:00:35.924556', '2021-04-15 13:00:35.924556', NULL),
	(10004577, 3, 'PW21A-TS100219BL-L', 1, 0, '2021-04-15 13:00:35.942449', '2021-04-15 13:00:35.942449', NULL),
	(10004578, 3, 'PW21A-TS100219BL-XL', 1, 0, '2021-04-15 13:00:35.929686', '2021-04-15 13:00:35.929686', NULL),
	(10004579, 3, 'PW21A-TS100219BL-XXL', 1, 0, '2021-04-15 13:00:35.958023', '2021-04-15 13:00:35.958023', NULL),
	(10004580, 3, 'PW21A-TS100220BL-XS', 0, 0, '2021-04-15 13:00:35.972598', '2021-04-15 13:00:35.972598', NULL),
	(10004581, 3, 'PW21A-TS100220BL-S', 2, 0, '2021-04-15 13:00:35.942760', '2021-04-15 13:00:35.942760', NULL),
	(10004582, 3, 'PW21A-TS100220BL-M', 1, 0, '2021-04-15 13:00:35.927066', '2021-04-15 13:00:35.927066', NULL),
	(10004583, 3, 'PW21A-TS100220BL-L', 1, 0, '2021-04-15 13:00:36.018453', '2021-04-15 13:00:36.018453', NULL),
	(10004584, 3, 'PW21A-TS100220BL-XL', 1, 0, '2021-04-15 13:00:35.952251', '2021-04-15 13:00:35.952251', NULL),
	(10004585, 3, 'PW21A-TS100220BL-XXL', 1, 0, '2021-04-15 13:00:35.946351', '2021-04-15 13:00:35.946351', NULL),
	(10004586, 3, 'PW21A-TK100221BL-XS', 0, 0, '2021-04-15 13:00:35.941986', '2021-04-15 13:00:35.941986', NULL),
	(10004587, 3, 'PW21A-TK100221BL-S', 0, 0, '2021-04-15 13:00:35.969630', '2021-04-15 13:00:35.969630', NULL),
	(10004588, 3, 'PW21A-TK100221BL-M', 0, 0, '2021-04-15 13:00:35.956350', '2021-04-15 13:00:35.956350', NULL),
	(10004589, 3, 'PW21A-TK100221BL-L', 0, 0, '2021-04-15 13:00:35.970602', '2021-04-15 13:00:35.970602', NULL),
	(10004590, 3, 'PW21A-TK100221BL-XL', 0, 0, '2021-04-15 13:00:35.985041', '2021-04-15 13:00:35.985041', NULL),
	(10004591, 3, 'PW21A-TK100221BL-XXL', 0, 0, '2021-04-15 13:00:35.957564', '2021-04-15 13:00:35.957564', NULL),
	(10004592, 3, 'PW21A-TS100222BL-XS', 0, 0, '2021-04-15 13:00:35.969330', '2021-04-15 13:00:35.969330', NULL),
	(10004593, 3, 'PW21A-TS100222BL-S', 2, 0, '2021-04-15 13:00:36.089741', '2021-04-15 13:00:36.089741', NULL),
	(10004594, 3, 'PW21A-TS100222BL-M', 1, 0, '2021-04-15 13:00:35.975057', '2021-04-15 13:00:35.975057', NULL),
	(10004595, 3, 'PW21A-TS100222BL-L', 1, 0, '2021-04-15 13:00:35.985402', '2021-04-15 13:00:35.985402', NULL),
	(10004596, 3, 'PW21A-TS100222BL-XL', 1, 0, '2021-04-15 13:00:36.002448', '2021-04-15 13:00:36.002448', NULL),
	(10004597, 3, 'PW21A-TS100222BL-XXL', 1, 0, '2021-04-15 13:00:35.986236', '2021-04-15 13:00:35.986236', NULL),
	(10004598, 3, 'PW21A-TS100223BL-XS', 0, 0, '2021-04-15 13:00:35.989425', '2021-04-15 13:00:35.989425', NULL),
	(10004599, 3, 'PW21A-TS100223BL-S', 0, 0, '2021-04-15 13:00:35.988132', '2021-04-15 13:00:35.988132', NULL),
	(10004600, 3, 'PW21A-TS100223BL-M', 0, 0, '2021-04-15 13:00:35.999982', '2021-04-15 13:00:35.999982', NULL),
	(10004601, 3, 'PW21A-TS100223BL-L', 0, 0, '2021-04-15 13:00:36.002865', '2021-04-15 13:00:36.002865', NULL),
	(10004602, 3, 'PW21A-TS100223BL-XL', 0, 0, '2021-04-15 13:00:36.001881', '2021-04-15 13:00:36.001881', NULL),
	(10004603, 3, 'PW21A-TS100223BL-XXL', 0, 0, '2021-04-15 13:00:36.015082', '2021-04-15 13:00:36.015082', NULL),
	(10004604, 3, 'PW21A-TK100224BL-XS', 0, 0, '2021-04-15 13:00:36.048950', '2021-04-15 13:00:36.048950', NULL),
	(10004605, 3, 'PW21A-TK100224BL-S', 0, 0, '2021-04-15 13:00:35.998010', '2021-04-15 13:00:35.998010', NULL),
	(10004606, 3, 'PW21A-TK100224BL-M', 0, 0, '2021-04-15 13:00:36.014527', '2021-04-15 13:00:36.014527', NULL),
	(10004607, 3, 'PW21A-TK100224BL-L', 0, 0, '2021-04-15 13:00:36.029346', '2021-04-15 13:00:36.029346', NULL),
	(10004608, 3, 'PW21A-TK100224BL-XL', 0, 0, '2021-04-15 13:00:36.045600', '2021-04-15 13:00:36.045600', NULL),
	(10004609, 3, 'PW21A-TK100224BL-XXL', 0, 0, '2021-04-15 13:00:36.015781', '2021-04-15 13:00:36.015781', NULL),
	(10004610, 3, 'PW21A-TK100225BL-XS', 0, 0, '2021-04-15 13:00:36.029953', '2021-04-15 13:00:36.029953', NULL),
	(10004611, 3, 'PW21A-TK100225BL-S', 0, 0, '2021-04-15 13:00:36.027980', '2021-04-15 13:00:36.027980', NULL),
	(10004612, 3, 'PW21A-TK100225BL-M', 0, 0, '2021-04-15 13:00:36.018024', '2021-04-15 13:00:36.018024', NULL),
	(10004613, 3, 'PW21A-TK100225BL-L', 0, 0, '2021-04-15 13:00:36.029666', '2021-04-15 13:00:36.029666', NULL),
	(10004614, 3, 'PW21A-TK100225BL-XL', 0, 0, '2021-04-15 13:00:36.050518', '2021-04-15 13:00:36.050518', NULL),
	(10004615, 3, 'PW21A-TK100225BL-XXL', 0, 0, '2021-04-15 13:00:36.048244', '2021-04-15 13:00:36.048244', NULL),
	(10004616, 3, 'PW21A-TS100226BL-XS', 0, 0, '2021-04-15 13:00:36.030246', '2021-04-15 13:00:36.030246', NULL),
	(10004617, 3, 'PW21A-TS100226BL-S', 2, 0, '2021-04-15 13:00:36.076556', '2021-04-15 13:00:36.076556', NULL),
	(10004618, 3, 'PW21A-TS100226BL-M', 0, 0, '2021-04-15 13:00:36.058961', '2021-04-15 13:00:36.058961', NULL),
	(10004619, 3, 'PW21A-TS100226BL-L', 2, 0, '2021-04-15 13:00:36.051443', '2021-04-15 13:00:36.051443', NULL),
	(10004620, 3, 'PW21A-TS100226BL-XL', 2, 0, '2021-04-15 13:00:36.061134', '2021-04-15 13:00:36.061134', NULL),
	(10004621, 3, 'PW21A-TS100226BL-XXL', 0, 0, '2021-04-15 13:00:36.085022', '2021-04-15 13:00:36.085022', NULL),
	(10004622, 3, 'PW21A-TK100227BL-XS', 0, 0, '2021-04-15 13:00:36.061491', '2021-04-15 13:00:36.061491', NULL),
	(10004623, 3, 'PW21A-TK100227BL-S', 0, 0, '2021-04-15 13:00:36.060404', '2021-04-15 13:00:36.060404', NULL),
	(10004624, 3, 'PW21A-TK100227BL-M', 0, 0, '2021-04-15 13:00:36.062612', '2021-04-15 13:00:36.062612', NULL),
	(10004625, 3, 'PW21A-TK100227BL-L', 0, 0, '2021-04-15 13:00:36.073887', '2021-04-15 13:00:36.073887', NULL),
	(10004626, 3, 'PW21A-TK100227BL-XL', 0, 0, '2021-04-15 13:00:36.080122', '2021-04-15 13:00:36.080122', NULL),
	(10004627, 3, 'PW21A-TK100227BL-XXL', 0, 0, '2021-04-15 13:00:36.076246', '2021-04-15 13:00:36.076246', NULL),
	(10004628, 3, 'PW21A-TS100228BL-XS', 0, 0, '2021-04-15 13:00:36.091472', '2021-04-15 13:00:36.091472', NULL),
	(10004629, 3, 'PW21A-TS100228BL-S', 2, 0, '2021-04-15 13:00:36.074918', '2021-04-15 13:00:36.074918', NULL),
	(10004630, 3, 'PW21A-TS100228BL-M', 2, 0, '2021-04-15 13:00:36.090122', '2021-04-15 13:00:36.090122', NULL),
	(10004631, 3, 'PW21A-TS100228BL-L', 2, 0, '2021-04-15 13:00:36.107124', '2021-04-15 13:00:36.107124', NULL),
	(10004632, 3, 'PW21A-TS100228BL-XL', 3, 0, '2021-04-15 13:00:36.090460', '2021-04-15 13:00:36.090460', NULL),
	(10004633, 3, 'PW21A-TS100228BL-XXL', 2, 0, '2021-04-15 13:00:36.112668', '2021-04-15 13:00:36.112668', NULL),
	(10004634, 3, 'PW21A-TK100229BL-XS', 0, 0, '2021-04-15 13:00:36.107992', '2021-04-15 13:00:36.107992', NULL),
	(10004635, 3, 'PW21A-TK100229BL-S', 0, 0, '2021-04-15 13:00:36.141223', '2021-04-15 13:00:36.141223', NULL),
	(10004636, 3, 'PW21A-TK100229BL-M', 0, 0, '2021-04-15 13:00:36.110674', '2021-04-15 13:00:36.110674', NULL),
	(10004637, 3, 'PW21A-TK100229BL-L', 0, 0, '2021-04-15 13:00:36.122199', '2021-04-15 13:00:36.122199', NULL),
	(10004638, 3, 'PW21A-TK100229BL-XL', 0, 0, '2021-04-15 13:00:36.189123', '2021-04-15 13:00:36.189123', NULL),
	(10004639, 3, 'PW21A-TK100229BL-XXL', 0, 0, '2021-04-15 13:00:36.139605', '2021-04-15 13:00:36.139605', NULL),
	(10004640, 3, 'PW21A-TK100230BL-XS', 0, 0, '2021-04-15 13:00:36.115665', '2021-04-15 13:00:36.115665', NULL),
	(10004641, 3, 'PW21A-TK100230BL-S', 0, 0, '2021-04-15 13:00:36.144542', '2021-04-15 13:00:36.144542', NULL),
	(10004642, 3, 'PW21A-TK100230BL-M', 0, 0, '2021-04-15 13:00:36.127351', '2021-04-15 13:00:36.127351', NULL),
	(10004643, 3, 'PW21A-TK100230BL-L', 0, 0, '2021-04-15 13:00:36.125066', '2021-04-15 13:00:36.125066', NULL),
	(10004644, 3, 'PW21A-TK100230BL-XL', 0, 0, '2021-04-15 13:00:36.143869', '2021-04-15 13:00:36.143869', NULL),
	(10004645, 3, 'PW21A-TK100230BL-XXL', 0, 0, '2021-04-15 13:00:36.123444', '2021-04-15 13:00:36.123444', NULL),
	(10004646, 3, 'PW21A-TS100231BL-XS', 0, 0, '2021-04-15 13:00:36.130394', '2021-04-15 13:00:36.130394', NULL),
	(10004647, 3, 'PW21A-TS100231BL-S', 0, 0, '2021-04-15 13:00:36.140384', '2021-04-15 13:00:36.140384', NULL),
	(10004648, 3, 'PW21A-TS100231BL-M', 0, 0, '2021-04-15 13:00:36.158264', '2021-04-15 13:00:36.158264', NULL),
	(10004649, 3, 'PW21A-TS100231BL-L', 0, 0, '2021-04-15 13:00:36.142925', '2021-04-15 13:00:36.142925', NULL),
	(10004650, 3, 'PW21A-TS100231BL-XL', 0, 0, '2021-04-15 13:00:36.221780', '2021-04-15 13:00:36.221780', NULL),
	(10004651, 3, 'PW21A-TS100231BL-XXL', 0, 0, '2021-04-15 13:00:36.246791', '2021-04-15 13:00:36.246791', NULL),
	(10004652, 3, 'PW21A-TK100232GN-XS', 0, 0, '2021-04-15 13:00:36.158677', '2021-04-15 13:00:36.158677', NULL),
	(10004653, 3, 'PW21A-TK100232GN-S', 0, 0, '2021-04-15 13:00:36.157748', '2021-04-15 13:00:36.157748', NULL),
	(10004654, 3, 'PW21A-TK100232GN-M', 0, 0, '2021-04-15 13:00:36.189636', '2021-04-15 13:00:36.189636', NULL),
	(10004655, 3, 'PW21A-TK100232GN-L', 0, 0, '2021-04-15 13:00:36.218409', '2021-04-15 13:00:36.218409', NULL),
	(10004656, 3, 'PW21A-TK100232GN-XL', 0, 0, '2021-04-15 13:00:36.157103', '2021-04-15 13:00:36.157103', NULL),
	(10004657, 3, 'PW21A-TK100232GN-XXL', 0, 0, '2021-04-15 13:00:36.190118', '2021-04-15 13:00:36.190118', NULL),
	(10004658, 3, 'PW21A-TS100233BL-XS', 0, 0, '2021-04-15 13:00:36.186710', '2021-04-15 13:00:36.186710', NULL),
	(10004659, 3, 'PW21A-TS100233BL-S', 0, 0, '2021-04-15 13:00:36.187999', '2021-04-15 13:00:36.187999', NULL),
	(10004660, 3, 'PW21A-TS100233BL-M', 0, 0, '2021-04-15 13:00:36.191108', '2021-04-15 13:00:36.191108', NULL),
	(10004661, 3, 'PW21A-TS100233BL-L', 0, 0, '2021-04-15 13:00:36.184866', '2021-04-15 13:00:36.184866', NULL),
	(10004662, 3, 'PW21A-TS100233BL-XL', 0, 0, '2021-04-15 13:00:36.195269', '2021-04-15 13:00:36.195269', NULL),
	(10004663, 3, 'PW21A-TS100233BL-XXL', 0, 0, '2021-04-15 13:00:36.193992', '2021-04-15 13:00:36.193992', NULL),
	(10004664, 3, 'PW21A-TK100234BL-XS', 0, 0, '2021-04-15 13:00:36.192017', '2021-04-15 13:00:36.192017', NULL),
	(10004665, 3, 'PW21A-TK100234BL-S', 0, 0, '2021-04-15 13:00:36.218854', '2021-04-15 13:00:36.218854', NULL),
	(10004666, 3, 'PW21A-TK100234BL-M', 0, 0, '2021-04-15 13:00:36.280945', '2021-04-15 13:00:36.280945', NULL),
	(10004667, 3, 'PW21A-TK100234BL-L', 0, 0, '2021-04-15 13:00:36.217580', '2021-04-15 13:00:36.217580', NULL),
	(10004668, 3, 'PW21A-TK100234BL-XL', 0, 0, '2021-04-15 13:00:36.217116', '2021-04-15 13:00:36.217116', NULL),
	(10004669, 3, 'PW21A-TK100234BL-XXL', 0, 0, '2021-04-15 13:00:36.215176', '2021-04-15 13:00:36.215176', NULL),
	(10004670, 3, 'PW21A-TS100235BL-XS', 0, 0, '2021-04-15 13:00:36.251754', '2021-04-15 13:00:36.251754', NULL),
	(10004671, 3, 'PW21A-TS100235BL-S', 2, 0, '2021-04-15 13:00:36.250111', '2021-04-15 13:00:36.250111', NULL),
	(10004672, 3, 'PW21A-TS100235BL-M', 2, 0, '2021-04-15 13:00:36.225973', '2021-04-15 13:00:36.225973', NULL),
	(10004673, 3, 'PW21A-TS100235BL-L', 2, 0, '2021-04-15 13:00:36.225213', '2021-04-15 13:00:36.225213', NULL),
	(10004674, 3, 'PW21A-TS100235BL-XL', 1, 0, '2021-04-15 13:00:36.223651', '2021-04-15 13:00:36.223651', NULL),
	(10004675, 3, 'PW21A-TS100235BL-XXL', 2, 0, '2021-04-15 13:00:36.224002', '2021-04-15 13:00:36.224002', NULL),
	(10004676, 3, 'PW21A-TK100236WT-XS', 0, 0, '2021-04-15 13:00:36.258010', '2021-04-15 13:00:36.258010', NULL),
	(10004677, 3, 'PW21A-TK100236WT-S', 0, 0, '2021-04-15 13:00:36.247382', '2021-04-15 13:00:36.247382', NULL),
	(10004678, 3, 'PW21A-TK100236WT-M', 0, 0, '2021-04-15 13:00:36.288481', '2021-04-15 13:00:36.288481', NULL),
	(10004679, 3, 'PW21A-TK100236WT-L', 0, 0, '2021-04-15 13:00:36.279960', '2021-04-15 13:00:36.279960', NULL),
	(10004680, 3, 'PW21A-TK100236WT-XL', 0, 0, '2021-04-15 13:00:36.252781', '2021-04-15 13:00:36.252781', NULL),
	(10004681, 3, 'PW21A-TK100236WT-XXL', 0, 0, '2021-04-15 13:00:36.257045', '2021-04-15 13:00:36.257045', NULL),
	(10004682, 3, 'PW21A-TS100237BL-XS', 0, 0, '2021-04-15 13:00:36.258456', '2021-04-15 13:00:36.258456', NULL),
	(10004683, 3, 'PW21A-TS100237BL-S', 0, 0, '2021-04-15 13:00:36.259253', '2021-04-15 13:00:36.259253', NULL),
	(10004684, 3, 'PW21A-TS100237BL-M', 0, 0, '2021-04-15 13:00:36.344304', '2021-04-15 13:00:36.344304', NULL),
	(10004685, 3, 'PW21A-TS100237BL-L', 0, 0, '2021-04-15 13:00:36.261729', '2021-04-15 13:00:36.261729', NULL),
	(10004686, 3, 'PW21A-TS100237BL-XL', 0, 0, '2021-04-15 13:00:36.277102', '2021-04-15 13:00:36.277102', NULL),
	(10004687, 3, 'PW21A-TS100237BL-XXL', 0, 0, '2021-04-15 13:00:36.277684', '2021-04-15 13:00:36.277684', NULL),
	(10004688, 3, 'PW21A-TS100238BL-XS', 0, 0, '2021-04-15 13:00:36.282409', '2021-04-15 13:00:36.282409', NULL),
	(10004689, 3, 'PW21A-TS100238BL-S', 0, 0, '2021-04-15 13:00:36.284869', '2021-04-15 13:00:36.284869', NULL),
	(10004690, 3, 'PW21A-TS100238BL-M', 0, 0, '2021-04-15 13:00:36.302717', '2021-04-15 13:00:36.302717', NULL),
	(10004691, 3, 'PW21A-TS100238BL-L', 0, 0, '2021-04-15 13:00:36.302398', '2021-04-15 13:00:36.302398', NULL),
	(10004692, 3, 'PW21A-TS100238BL-XL', 0, 0, '2021-04-15 13:00:36.284061', '2021-04-15 13:00:36.284061', NULL),
	(10004693, 3, 'PW21A-TS100238BL-XXL', 0, 0, '2021-04-15 13:00:36.279384', '2021-04-15 13:00:36.279384', NULL),
	(10004694, 3, 'PW21A-TK100239OG-XS', 0, 0, '2021-04-15 13:00:36.289671', '2021-04-15 13:00:36.289671', NULL),
	(10004695, 3, 'PW21A-TK100239OG-S', 0, 0, '2021-04-15 13:00:36.307571', '2021-04-15 13:00:36.307571', NULL),
	(10004696, 3, 'PW21A-TK100239OG-M', 0, 0, '2021-04-15 13:00:36.305591', '2021-04-15 13:00:36.305591', NULL),
	(10004697, 3, 'PW21A-TK100239OG-L', 0, 0, '2021-04-15 13:00:36.413663', '2021-04-15 13:00:36.413663', NULL),
	(10004698, 3, 'PW21A-TK100239OG-XL', 0, 0, '2021-04-15 13:00:36.344643', '2021-04-15 13:00:36.344643', NULL),
	(10004699, 3, 'PW21A-TK100239OG-XXL', 0, 0, '2021-04-15 13:00:36.312928', '2021-04-15 13:00:36.312928', NULL),
	(10004700, 3, 'PW21A-TK100240OG-XS', 0, 0, '2021-04-15 13:00:36.307119', '2021-04-15 13:00:36.307119', NULL),
	(10004701, 3, 'PW21A-TK100240OG-S', 0, 0, '2021-04-15 13:00:36.328318', '2021-04-15 13:00:36.328318', NULL),
	(10004702, 3, 'PW21A-TK100240OG-M', 0, 0, '2021-04-15 13:00:36.327682', '2021-04-15 13:00:36.327682', NULL),
	(10004703, 3, 'PW21A-TK100240OG-L', 0, 0, '2021-04-15 13:00:36.310340', '2021-04-15 13:00:36.310340', NULL),
	(10004704, 3, 'PW21A-TK100240OG-XL', 0, 0, '2021-04-15 13:00:36.312580', '2021-04-15 13:00:36.312580', NULL),
	(10004705, 3, 'PW21A-TK100240OG-XXL', 0, 0, '2021-04-15 13:00:36.331096', '2021-04-15 13:00:36.331096', NULL),
	(10004706, 3, 'PW21A-TS100241YW -XS', 0, 0, '2021-04-15 13:00:36.331440', '2021-04-15 13:00:36.331440', NULL),
	(10004707, 3, 'PW21A-TS100241YW -S', 0, 0, '2021-04-15 13:00:36.313630', '2021-04-15 13:00:36.313630', NULL),
	(10004708, 3, 'PW21A-TS100241YW -M', 0, 0, '2021-04-15 13:00:36.315887', '2021-04-15 13:00:36.315887', NULL),
	(10004709, 3, 'PW21A-TS100241YW -L', 0, 0, '2021-04-15 13:00:36.378108', '2021-04-15 13:00:36.378108', NULL),
	(10004710, 3, 'PW21A-TS100241YW -XL', 1, 0, '2021-04-15 13:00:36.405952', '2021-04-15 13:00:36.405952', NULL),
	(10004711, 3, 'PW21A-TS100241YW -XXL', 2, 0, '2021-04-15 13:00:36.375094', '2021-04-15 13:00:36.375094', NULL),
	(10004712, 3, 'PW21A-TS100242BL-XS', 0, 0, '2021-04-15 13:00:36.333297', '2021-04-15 13:00:36.333297', NULL),
	(10004713, 3, 'PW21A-TS100242BL-S', 2, 0, '2021-04-15 13:00:36.343931', '2021-04-15 13:00:36.343931', NULL),
	(10004714, 3, 'PW21A-TS100242BL-M', 1, 0, '2021-04-15 13:00:36.326182', '2021-04-15 13:00:36.326182', NULL),
	(10004715, 3, 'PW21A-TS100242BL-L', 1, 0, '2021-04-15 13:00:36.360628', '2021-04-15 13:00:36.360628', NULL),
	(10004716, 3, 'PW21A-TS100242BL-XL', 1, 0, '2021-04-15 13:00:36.362293', '2021-04-15 13:00:36.362293', NULL),
	(10004717, 3, 'PW21A-TS100242BL-XXL', 1, 0, '2021-04-15 13:00:36.358424', '2021-04-15 13:00:36.358424', NULL),
	(10004718, 3, 'PW21A-TK100243BL-XS', 0, 0, '2021-04-15 13:00:36.356458', '2021-04-15 13:00:36.356458', NULL),
	(10004719, 3, 'PW21A-TK100243BL-S', 0, 0, '2021-04-15 13:00:36.355002', '2021-04-15 13:00:36.355002', NULL),
	(10004720, 3, 'PW21A-TK100243BL-M', 0, 0, '2021-04-15 13:00:36.346922', '2021-04-15 13:00:36.346922', NULL),
	(10004721, 3, 'PW21A-TK100243BL-L', 0, 0, '2021-04-15 13:00:36.356856', '2021-04-15 13:00:36.356856', NULL),
	(10004722, 3, 'PW21A-TK100243BL-XL', 0, 0, '2021-04-15 13:00:36.372622', '2021-04-15 13:00:36.372622', NULL),
	(10004723, 3, 'PW21A-TK100243BL-XXL', 0, 0, '2021-04-15 13:00:36.401910', '2021-04-15 13:00:36.401910', NULL),
	(10004724, 3, 'PW21A-TS100244BL-XS', 0, 0, '2021-04-15 13:00:36.388510', '2021-04-15 13:00:36.388510', NULL),
	(10004725, 3, 'PW21A-TS100244BL-S', 0, 0, '2021-04-15 13:00:36.408983', '2021-04-15 13:00:36.408983', NULL),
	(10004726, 3, 'PW21A-TS100244BL-M', 0, 0, '2021-04-15 13:00:36.398884', '2021-04-15 13:00:36.398884', NULL),
	(10004727, 3, 'PW21A-TS100244BL-L', 0, 0, '2021-04-15 13:00:36.540794', '2021-04-15 13:00:36.540794', NULL),
	(10004728, 3, 'PW21A-TS100244BL-XL', 0, 0, '2021-04-15 13:00:36.417015', '2021-04-15 13:00:36.417015', NULL),
	(10004729, 3, 'PW21A-TS100244BL-XXL', 0, 0, '2021-04-15 13:00:36.402443', '2021-04-15 13:00:36.402443', NULL),
	(10004730, 3, 'PW21A-TS100245RD-XS', 0, 0, '2021-04-15 13:00:36.435622', '2021-04-15 13:00:36.435622', NULL),
	(10004731, 3, 'PW21A-TS100245RD-S', 2, 0, '2021-04-15 13:00:36.461361', '2021-04-15 13:00:36.461361', NULL),
	(10004732, 3, 'PW21A-TS100245RD-M', 1, 0, '2021-04-15 13:00:36.406467', '2021-04-15 13:00:36.406467', NULL),
	(10004733, 3, 'PW21A-TS100245RD-L', 1, 0, '2021-04-15 13:00:36.434077', '2021-04-15 13:00:36.434077', NULL),
	(10004734, 3, 'PW21A-TS100245RD-XL', 1, 0, '2021-04-15 13:00:36.423162', '2021-04-15 13:00:36.423162', NULL),
	(10004735, 3, 'PW21A-TS100245RD-XXL', 1, 0, '2021-04-15 13:00:36.431524', '2021-04-15 13:00:36.431524', NULL),
	(10004736, 3, 'PW21A-TK100246BL-XS', 0, 0, '2021-04-15 13:00:36.420345', '2021-04-15 13:00:36.420345', NULL),
	(10004737, 3, 'PW21A-TK100246BL-S', 0, 0, '2021-04-15 13:00:36.438412', '2021-04-15 13:00:36.438412', NULL),
	(10004738, 3, 'PW21A-TK100246BL-M', 0, 0, '2021-04-15 13:00:36.438721', '2021-04-15 13:00:36.438721', NULL),
	(10004739, 3, 'PW21A-TK100246BL-L', 0, 0, '2021-04-15 13:00:36.448102', '2021-04-15 13:00:36.448102', NULL),
	(10004740, 3, 'PW21A-TK100246BL-XL', 0, 0, '2021-04-15 13:00:36.488621', '2021-04-15 13:00:36.488621', NULL),
	(10004741, 3, 'PW21A-TK100246BL-XXL', 0, 0, '2021-04-15 13:00:36.444055', '2021-04-15 13:00:36.444055', NULL),
	(10004742, 3, 'PW21A-TS100247NV-XS', 0, 0, '2021-04-15 13:00:36.445256', '2021-04-15 13:00:36.445256', NULL),
	(10004743, 3, 'PW21A-TS100247NV-S', 0, 0, '2021-04-15 13:00:36.439008', '2021-04-15 13:00:36.439008', NULL),
	(10004744, 3, 'PW21A-TS100247NV-M', 0, 0, '2021-04-15 13:00:36.459762', '2021-04-15 13:00:36.459762', NULL),
	(10004745, 3, 'PW21A-TS100247NV-L', 0, 0, '2021-04-15 13:00:36.450504', '2021-04-15 13:00:36.450504', NULL),
	(10004746, 3, 'PW21A-TS100247NV-XL', 0, 0, '2021-04-15 13:00:36.458993', '2021-04-15 13:00:36.458993', NULL),
	(10004747, 3, 'PW21A-TS100247NV-XXL', 0, 0, '2021-04-15 13:00:36.529277', '2021-04-15 13:00:36.529277', NULL),
	(10004748, 3, 'PW21A-TS100248BL-XS', 0, 0, '2021-04-15 13:00:36.461693', '2021-04-15 13:00:36.461693', NULL),
	(10004749, 3, 'PW21A-TS100248BL-S', 2, 0, '2021-04-15 13:00:36.456410', '2021-04-15 13:00:36.456410', NULL),
	(10004750, 3, 'PW21A-TS100248BL-M', 2, 0, '2021-04-15 13:00:36.461983', '2021-04-15 13:00:36.461983', NULL),
	(10004751, 3, 'PW21A-TS100248BL-L', 2, 0, '2021-04-15 13:00:36.473146', '2021-04-15 13:00:36.473146', NULL),
	(10004752, 3, 'PW21A-TS100248BL-XL', 2, 0, '2021-04-15 13:00:36.474095', '2021-04-15 13:00:36.474095', NULL),
	(10004753, 3, 'PW21A-TS100248BL-XXL', 1, 0, '2021-04-15 13:00:36.471385', '2021-04-15 13:00:36.471385', NULL),
	(10004754, 3, 'PW21A-TK100249WT-XS', 0, 0, '2021-04-15 13:00:36.516632', '2021-04-15 13:00:36.516632', NULL),
	(10004755, 3, 'PW21A-TK100249WT-S', 0, 0, '2021-04-15 13:00:36.475863', '2021-04-15 13:00:36.475863', NULL),
	(10004756, 3, 'PW21A-TK100249WT-M', 0, 0, '2021-04-15 13:00:36.486366', '2021-04-15 13:00:36.486366', NULL),
	(10004757, 3, 'PW21A-TK100249WT-L', 0, 0, '2021-04-15 13:00:36.558201', '2021-04-15 13:00:36.558201', NULL),
	(10004758, 3, 'PW21A-TK100249WT-XL', 0, 0, '2021-04-15 13:00:36.489167', '2021-04-15 13:00:36.489167', NULL),
	(10004759, 3, 'PW21A-TK100249WT-XXL', 0, 0, '2021-04-15 13:00:36.529751', '2021-04-15 13:00:36.529751', NULL),
	(10004760, 3, 'PW21A-TS100250WT-XS', 0, 0, '2021-04-15 13:00:36.550291', '2021-04-15 13:00:36.550291', NULL),
	(10004761, 3, 'PW21A-TS100250WT-S', 2, 0, '2021-04-15 13:00:36.603211', '2021-04-15 13:00:36.603211', NULL),
	(10004762, 3, 'PW21A-TS100250WT-M', 2, 0, '2021-04-15 13:00:36.549886', '2021-04-15 13:00:36.549886', NULL),
	(10004763, 3, 'PW21A-TS100250WT-L', 2, 0, '2021-04-15 13:00:36.598186', '2021-04-15 13:00:36.598186', NULL),
	(10004764, 3, 'PW21A-TS100250WT-XL', 2, 0, '2021-04-15 13:00:36.639975', '2021-04-15 13:00:36.639975', NULL),
	(10004765, 3, 'PW21A-TS100250WT-XXL', 1, 0, '2021-04-15 13:00:36.566372', '2021-04-15 13:00:36.566372', NULL),
	(10004766, 3, 'PW21A-TS100251BL-XS', 0, 0, '2021-04-15 13:00:36.585133', '2021-04-15 13:00:36.585133', NULL),
	(10004767, 3, 'PW21A-TS100251BL-S', 2, 0, '2021-04-15 13:00:36.662838', '2021-04-15 13:00:36.662838', NULL),
	(10004768, 3, 'PW21A-TS100251BL-M', 1, 0, '2021-04-15 13:00:36.592749', '2021-04-15 13:00:36.592749', NULL),
	(10004769, 3, 'PW21A-TS100251BL-L', 1, 0, '2021-04-15 13:00:36.555352', '2021-04-15 13:00:36.555352', NULL),
	(10004770, 3, 'PW21A-TS100251BL-XL', 1, 0, '2021-04-15 13:00:36.568477', '2021-04-15 13:00:36.568477', NULL),
	(10004771, 3, 'PW21A-TS100251BL-XXL', 1, 0, '2021-04-15 13:00:36.594810', '2021-04-15 13:00:36.594810', NULL),
	(10004772, 3, 'PW21A-TS100252WT-XS', 0, 0, '2021-04-15 13:00:36.610776', '2021-04-15 13:00:36.610776', NULL),
	(10004773, 3, 'PW21A-TS100252WT-S', 2, 0, '2021-04-15 13:00:36.645986', '2021-04-15 13:00:36.645986', NULL),
	(10004774, 3, 'PW21A-TS100252WT-M', 4, 0, '2021-04-15 13:00:36.605597', '2021-04-15 13:00:36.605597', NULL),
	(10004775, 3, 'PW21A-TS100252WT-L', 2, 0, '2021-04-15 13:00:36.601751', '2021-04-15 13:00:36.601751', NULL),
	(10004776, 3, 'PW21A-TS100252WT-XL', 2, 0, '2021-04-15 13:00:36.609297', '2021-04-15 13:00:36.609297', NULL),
	(10004777, 3, 'PW21A-TS100252WT-XXL', 2, 0, '2021-04-15 13:00:36.676851', '2021-04-15 13:00:36.676851', NULL),
	(10004778, 3, 'PW21A-TS100253BL-XS', 0, 0, '2021-04-15 13:00:36.711302', '2021-04-15 13:00:36.711302', NULL),
	(10004779, 3, 'PW21A-TS100253BL-S', 2, 0, '2021-04-15 13:00:36.617319', '2021-04-15 13:00:36.617319', NULL),
	(10004780, 3, 'PW21A-TS100253BL-M', 1, 0, '2021-04-15 13:00:36.660975', '2021-04-15 13:00:36.660975', NULL),
	(10004781, 3, 'PW21A-TS100253BL-L', 1, 0, '2021-04-15 13:00:36.655081', '2021-04-15 13:00:36.655081', NULL),
	(10004782, 3, 'PW21A-TS100253BL-XL', 1, 0, '2021-04-15 13:00:36.649313', '2021-04-15 13:00:36.649313', NULL),
	(10004783, 3, 'PW21A-TS100253BL-XXL', 1, 0, '2021-04-15 13:00:36.651134', '2021-04-15 13:00:36.651134', NULL),
	(10004784, 3, 'PW21A-TK100254BL-XS', 0, 0, '2021-04-15 13:00:36.667978', '2021-04-15 13:00:36.667978', NULL),
	(10004785, 3, 'PW21A-TK100254BL-S', 0, 0, '2021-04-15 13:00:36.693777', '2021-04-15 13:00:36.693777', NULL),
	(10004786, 3, 'PW21A-TK100254BL-M', 0, 0, '2021-04-15 13:00:36.655995', '2021-04-15 13:00:36.655995', NULL),
	(10004787, 3, 'PW21A-TK100254BL-L', 0, 0, '2021-04-15 13:00:36.795262', '2021-04-15 13:00:36.795262', NULL),
	(10004788, 3, 'PW21A-TK100254BL-XL', 0, 0, '2021-04-15 13:00:36.717196', '2021-04-15 13:00:36.717196', NULL),
	(10004789, 3, 'PW21A-TK100254BL-XXL', 0, 0, '2021-04-15 13:00:36.715355', '2021-04-15 13:00:36.715355', NULL),
	(10004790, 3, 'PW21A-TS100255BL-XS', 0, 0, '2021-04-15 13:00:36.685610', '2021-04-15 13:00:36.685610', NULL),
	(10004791, 3, 'PW21A-TS100255BL-S', 2, 0, '2021-04-15 13:00:36.698686', '2021-04-15 13:00:36.698686', NULL),
	(10004792, 3, 'PW21A-TS100255BL-M', 2, 0, '2021-04-15 13:00:36.702398', '2021-04-15 13:00:36.702398', NULL),
	(10004793, 3, 'PW21A-TS100255BL-L', 2, 0, '2021-04-15 13:00:36.692910', '2021-04-15 13:00:36.692910', NULL),
	(10004794, 3, 'PW21A-TS100255BL-XL', 2, 0, '2021-04-15 13:00:36.697577', '2021-04-15 13:00:36.697577', NULL),
	(10004795, 3, 'PW21A-TS100255BL-XXL', 2, 0, '2021-04-15 13:00:36.730430', '2021-04-15 13:00:36.730430', NULL),
	(10004796, 3, 'PW21A-TK100256BL-XS', 0, 0, '2021-04-15 13:00:36.713378', '2021-04-15 13:00:36.713378', NULL),
	(10004797, 3, 'PW21A-TK100256BL-S', 0, 0, '2021-04-15 13:00:36.731267', '2021-04-15 13:00:36.731267', NULL),
	(10004798, 3, 'PW21A-TK100256BL-M', 0, 0, '2021-04-15 13:00:36.725517', '2021-04-15 13:00:36.725517', NULL),
	(10004799, 3, 'PW21A-TK100256BL-L', 0, 0, '2021-04-15 13:00:36.728874', '2021-04-15 13:00:36.728874', NULL),
	(10004800, 3, 'PW21A-TK100256BL-XL', 0, 0, '2021-04-15 13:00:36.749374', '2021-04-15 13:00:36.749374', NULL),
	(10004801, 3, 'PW21A-TK100256BL-XXL', 0, 0, '2021-04-15 13:00:36.735353', '2021-04-15 13:00:36.735353', NULL),
	(10004802, 3, 'PW21A-TS100257WT-XS', 0, 0, '2021-04-15 13:00:36.780214', '2021-04-15 13:00:36.780214', NULL),
	(10004803, 3, 'PW21A-TS100257WT-S', 0, 0, '2021-04-15 13:00:36.733320', '2021-04-15 13:00:36.733320', NULL),
	(10004804, 3, 'PW21A-TS100257WT-M', 0, 0, '2021-04-15 13:00:36.749092', '2021-04-15 13:00:36.749092', NULL),
	(10004805, 3, 'PW21A-TS100257WT-L', 0, 0, '2021-04-15 13:00:36.901583', '2021-04-15 13:00:36.901583', NULL),
	(10004806, 3, 'PW21A-TS100257WT-XL', 0, 0, '2021-04-15 13:00:36.766687', '2021-04-15 13:00:36.766687', NULL),
	(10004807, 3, 'PW21A-TS100257WT-XXL', 0, 0, '2021-04-15 13:00:36.751217', '2021-04-15 13:00:36.751217', NULL),
	(10004808, 3, 'PW21A-TS100258WT-XS', 0, 0, '2021-04-15 13:00:36.755583', '2021-04-15 13:00:36.755583', NULL),
	(10004809, 3, 'PW21A-TS100258WT-S', 2, 0, '2021-04-15 13:00:36.761244', '2021-04-15 13:00:36.761244', NULL),
	(10004810, 3, 'PW21A-TS100258WT-M', 2, 0, '2021-04-15 13:00:36.771714', '2021-04-15 13:00:36.771714', NULL),
	(10004811, 3, 'PW21A-TS100258WT-L', 2, 0, '2021-04-15 13:00:36.794608', '2021-04-15 13:00:36.794608', NULL),
	(10004812, 3, 'PW21A-TS100258WT-XL', 2, 0, '2021-04-15 13:00:36.802266', '2021-04-15 13:00:36.802266', NULL),
	(10004813, 3, 'PW21A-TS100258WT-XXL', 2, 0, '2021-04-15 13:00:36.795763', '2021-04-15 13:00:36.795763', NULL),
	(10004814, 3, 'PW21A-TS100259BL-XS', 0, 0, '2021-04-15 13:00:36.780904', '2021-04-15 13:00:36.780904', NULL),
	(10004815, 3, 'PW21A-TS100259BL-S', 2, 0, '2021-04-15 13:00:36.905837', '2021-04-15 13:00:36.905837', NULL),
	(10004816, 3, 'PW21A-TS100259BL-M', 1, 0, '2021-04-15 13:00:36.792715', '2021-04-15 13:00:36.792715', NULL),
	(10004817, 3, 'PW21A-TS100259BL-L', 1, 0, '2021-04-15 13:00:36.785005', '2021-04-15 13:00:36.785005', NULL),
	(10004818, 3, 'PW21A-TS100259BL-XL', 1, 0, '2021-04-15 13:00:36.875256', '2021-04-15 13:00:36.875256', NULL),
	(10004819, 3, 'PW21A-TS100259BL-XXL', 1, 0, '2021-04-15 13:00:36.801762', '2021-04-15 13:00:36.801762', NULL),
	(10004820, 3, 'PW21A-TS100260BL-XS', 0, 0, '2021-04-15 13:00:36.876212', '2021-04-15 13:00:36.876212', NULL),
	(10004821, 3, 'PW21A-TS100260BL-S', 2, 0, '2021-04-15 13:00:36.798527', '2021-04-15 13:00:36.798527', NULL),
	(10004822, 3, 'PW21A-TS100260BL-M', 2, 0, '2021-04-15 13:00:37.000321', '2021-04-15 13:00:37.000321', NULL),
	(10004823, 3, 'PW21A-TS100260BL-L', 2, 0, '2021-04-15 13:00:36.895964', '2021-04-15 13:00:36.895964', NULL),
	(10004824, 3, 'PW21A-TS100260BL-XL', 2, 0, '2021-04-15 13:00:36.817770', '2021-04-15 13:00:36.817770', NULL),
	(10004825, 3, 'PW21A-TS100260BL-XXL', 2, 0, '2021-04-15 13:00:37.023834', '2021-04-15 13:00:37.023834', NULL),
	(10004826, 3, 'PW21A-TS100261BL-XS', 0, 0, '2021-04-15 13:00:36.892251', '2021-04-15 13:00:36.892251', NULL),
	(10004827, 3, 'PW21A-TS100261BL-S', 2, 0, '2021-04-15 13:00:36.960628', '2021-04-15 13:00:36.960628', NULL),
	(10004828, 3, 'PW21A-TS100261BL-M', 1, 0, '2021-04-15 13:00:36.895272', '2021-04-15 13:00:36.895272', NULL),
	(10004829, 3, 'PW21A-TS100261BL-L', 1, 0, '2021-04-15 13:00:36.919639', '2021-04-15 13:00:36.919639', NULL),
	(10004830, 3, 'PW21A-TS100261BL-XL', 1, 0, '2021-04-15 13:00:36.940992', '2021-04-15 13:00:36.940992', NULL),
	(10004831, 3, 'PW21A-TS100261BL-XXL', 1, 0, '2021-04-15 13:00:36.963608', '2021-04-15 13:00:36.963608', NULL),
	(10004832, 3, 'PW21A-TS100262BL-XS', 0, 0, '2021-04-15 13:00:36.893376', '2021-04-15 13:00:36.893376', NULL),
	(10004833, 3, 'PW21A-TS100262BL-S', 2, 0, '2021-04-15 13:00:36.927569', '2021-04-15 13:00:36.927569', NULL),
	(10004834, 3, 'PW21A-TS100262BL-M', 2, 0, '2021-04-15 13:00:36.953913', '2021-04-15 13:00:36.953913', NULL),
	(10004835, 3, 'PW21A-TS100262BL-L', 2, 0, '2021-04-15 13:00:36.975606', '2021-04-15 13:00:36.975606', NULL),
	(10004836, 3, 'PW21A-TS100262BL-XL', 2, 0, '2021-04-15 13:00:36.958673', '2021-04-15 13:00:36.958673', NULL),
	(10004837, 3, 'PW21A-TS100262BL-XXL', 2, 0, '2021-04-15 13:00:36.957041', '2021-04-15 13:00:36.957041', NULL),
	(10004838, 3, 'PW21A-TS100263BL-XS', 0, 0, '2021-04-15 13:00:36.995170', '2021-04-15 13:00:36.995170', NULL),
	(10004839, 3, 'PW21A-TS100263BL-S', 3, 0, '2021-04-15 13:00:36.962188', '2021-04-15 13:00:36.962188', NULL),
	(10004840, 3, 'PW21A-TS100263BL-M', 3, 0, '2021-04-15 13:00:36.999662', '2021-04-15 13:00:36.999662', NULL),
	(10004841, 3, 'PW21A-TS100263BL-L', 3, 0, '2021-04-15 13:00:37.011431', '2021-04-15 13:00:37.011431', NULL),
	(10004842, 3, 'PW21A-TS100263BL-XL', 3, 0, '2021-04-15 13:00:37.058504', '2021-04-15 13:00:37.058504', NULL),
	(10004843, 3, 'PW21A-TS100263BL-XXL', 2, 0, '2021-04-15 13:00:37.019549', '2021-04-15 13:00:37.019549', NULL),
	(10004844, 3, 'PW21A-TS100264WH-XS', 0, 0, '2021-04-15 13:00:37.025596', '2021-04-15 13:00:37.025596', NULL),
	(10004845, 3, 'PW21A-TS100264WH-S', 0, 0, '2021-04-15 13:00:37.083132', '2021-04-15 13:00:37.083132', NULL),
	(10004846, 3, 'PW21A-TS100264WH-M', 0, 0, '2021-04-15 13:00:37.021116', '2021-04-15 13:00:37.021116', NULL),
	(10004847, 3, 'PW21A-TS100264WH-L', 0, 0, '2021-04-15 13:00:37.010230', '2021-04-15 13:00:37.010230', NULL),
	(10004848, 3, 'PW21A-TS100264WH-XL', 0, 0, '2021-04-15 13:00:37.144821', '2021-04-15 13:00:37.144821', NULL),
	(10004849, 3, 'PW21A-TS100264WH-XXL', 0, 0, '2021-04-15 13:00:37.020437', '2021-04-15 13:00:37.020437', NULL),
	(10004850, 3, 'PW21A-TS100265RD-XS', 0, 0, '2021-04-15 13:00:37.037918', '2021-04-15 13:00:37.037918', NULL),
	(10004851, 3, 'PW21A-TS100265RD-S', 2, 0, '2021-04-15 13:00:37.051456', '2021-04-15 13:00:37.051456', NULL),
	(10004852, 3, 'PW21A-TS100265RD-M', 2, 0, '2021-04-15 13:00:37.056185', '2021-04-15 13:00:37.056185', NULL),
	(10004853, 3, 'PW21A-TS100265RD-L', 2, 0, '2021-04-15 13:00:37.052388', '2021-04-15 13:00:37.052388', NULL),
	(10004854, 3, 'PW21A-TS100265RD-XL', 2, 0, '2021-04-15 13:00:37.046452', '2021-04-15 13:00:37.046452', NULL),
	(10004855, 3, 'PW21A-TS100265RD-XXL', 1, 0, '2021-04-15 13:00:37.057679', '2021-04-15 13:00:37.057679', NULL),
	(10004856, 3, 'PW21A-TS100266BL-XS', 0, 0, '2021-04-15 13:00:37.051036', '2021-04-15 13:00:37.051036', NULL),
	(10004857, 3, 'PW21A-TS100266BL-S', 2, 0, '2021-04-15 13:00:37.055740', '2021-04-15 13:00:37.055740', NULL),
	(10004858, 3, 'PW21A-TS100266BL-M', 2, 0, '2021-04-15 13:00:37.072002', '2021-04-15 13:00:37.072002', NULL),
	(10004859, 3, 'PW21A-TS100266BL-L', 1, 0, '2021-04-15 13:00:37.058107', '2021-04-15 13:00:37.058107', NULL),
	(10004860, 3, 'PW21A-TS100266BL-XL', 2, 0, '2021-04-15 13:00:37.083599', '2021-04-15 13:00:37.083599', NULL),
	(10004861, 3, 'PW21A-TS100266BL-XXL', 2, 0, '2021-04-15 13:00:37.109331', '2021-04-15 13:00:37.109331', NULL),
	(10004862, 3, 'PW21A-TS100267BL-XS', 0, 0, '2021-04-15 13:00:37.078402', '2021-04-15 13:00:37.078402', NULL),
	(10004863, 3, 'PW21A-TS100267BL-S', 2, 0, '2021-04-15 13:00:37.079646', '2021-04-15 13:00:37.079646', NULL),
	(10004864, 3, 'PW21A-TS100267BL-M', 2, 0, '2021-04-15 13:00:37.077011', '2021-04-15 13:00:37.077011', NULL),
	(10004865, 3, 'PW21A-TS100267BL-L', 2, 0, '2021-04-15 13:00:37.085155', '2021-04-15 13:00:37.085155', NULL),
	(10004866, 3, 'PW21A-TS100267BL-XL', 2, 0, '2021-04-15 13:00:37.082007', '2021-04-15 13:00:37.082007', NULL),
	(10004867, 3, 'PW21A-TS100267BL-XXL', 2, 0, '2021-04-15 13:00:37.117625', '2021-04-15 13:00:37.117625', NULL),
	(10004868, 3, 'PW21A-TS100268BL-XS', 0, 0, '2021-04-15 13:00:37.080375', '2021-04-15 13:00:37.080375', NULL),
	(10004869, 3, 'PW21A-TS100268BL-S', 2, 0, '2021-04-15 13:00:37.084038', '2021-04-15 13:00:37.084038', NULL),
	(10004870, 3, 'PW21A-TS100268BL-M', 2, 0, '2021-04-15 13:00:37.098496', '2021-04-15 13:00:37.098496', NULL),
	(10004871, 3, 'PW21A-TS100268BL-L', 2, 0, '2021-04-15 13:00:37.110457', '2021-04-15 13:00:37.110457', NULL),
	(10004872, 3, 'PW21A-TS100268BL-XL', 2, 0, '2021-04-15 13:00:37.113922', '2021-04-15 13:00:37.113922', NULL),
	(10004873, 3, 'PW21A-TS100268BL-XXL', 2, 0, '2021-04-15 13:00:37.111978', '2021-04-15 13:00:37.111978', NULL),
	(10004874, 3, 'PW21A-TS100269BL-XS', 0, 0, '2021-04-15 13:00:37.134926', '2021-04-15 13:00:37.134926', NULL),
	(10004875, 3, 'PW21A-TS100269BL-S', 2, 0, '2021-04-15 13:00:37.108891', '2021-04-15 13:00:37.108891', NULL),
	(10004876, 3, 'PW21A-TS100269BL-M', 2, 0, '2021-04-15 13:00:37.142622', '2021-04-15 13:00:37.142622', NULL),
	(10004877, 3, 'PW21A-TS100269BL-L', 2, 0, '2021-04-15 13:00:37.114333', '2021-04-15 13:00:37.114333', NULL),
	(10004878, 3, 'PW21A-TS100269BL-XL', 2, 0, '2021-04-15 13:00:37.120056', '2021-04-15 13:00:37.120056', NULL),
	(10004879, 3, 'PW21A-TS100269BL-XXL', 2, 0, '2021-04-15 13:00:37.377216', '2021-04-15 13:00:37.377216', NULL),
	(10004880, 3, 'PW21A-TS100270BL-XS', 0, 0, '2021-04-15 13:00:37.113500', '2021-04-15 13:00:37.113500', NULL),
	(10004881, 3, 'PW21A-TS100270BL-S', 0, 0, '2021-04-15 13:00:37.141787', '2021-04-15 13:00:37.141787', NULL),
	(10004882, 3, 'PW21A-TS100270BL-M', 0, 0, '2021-04-15 13:00:37.147069', '2021-04-15 13:00:37.147069', NULL),
	(10004883, 3, 'PW21A-TS100270BL-L', 0, 0, '2021-04-15 13:00:37.142195', '2021-04-15 13:00:37.142195', NULL),
	(10004884, 3, 'PW21A-TS100270BL-XL', 0, 0, '2021-04-15 13:00:37.148621', '2021-04-15 13:00:37.148621', NULL),
	(10004885, 3, 'PW21A-TS100270BL-XXL', 0, 0, '2021-04-15 13:00:37.316258', '2021-04-15 13:00:37.316258', NULL),
	(10004886, 3, 'PW21A-TS100271BL-XS', 0, 0, '2021-04-15 13:00:37.176457', '2021-04-15 13:00:37.176457', NULL),
	(10004887, 3, 'PW21A-TS100271BL-S', 2, 0, '2021-04-15 13:00:37.515785', '2021-04-15 13:00:37.515785', NULL),
	(10004888, 3, 'PW21A-TS100271BL-M', 1, 0, '2021-04-15 13:00:37.148160', '2021-04-15 13:00:37.148160', NULL),
	(10004889, 3, 'PW21A-TS100271BL-L', 0, 0, '2021-04-15 13:00:37.177658', '2021-04-15 13:00:37.177658', NULL),
	(10004890, 3, 'PW21A-TS100271BL-XL', 1, 0, '2021-04-15 13:00:37.147742', '2021-04-15 13:00:37.147742', NULL),
	(10004891, 3, 'PW21A-TS100271BL-XXL', 1, 0, '2021-04-15 13:00:37.177271', '2021-04-15 13:00:37.177271', NULL),
	(10004892, 3, 'PW21A-TS100272BL-XS', 0, 0, '2021-04-15 13:00:37.149068', '2021-04-15 13:00:37.149068', NULL),
	(10004893, 3, 'PW21A-TS100272BL-S', 2, 0, '2021-04-15 13:00:37.317876', '2021-04-15 13:00:37.317876', NULL),
	(10004894, 3, 'PW21A-TS100272BL-M', 1, 0, '2021-04-15 13:00:37.359552', '2021-04-15 13:00:37.359552', NULL),
	(10004895, 3, 'PW21A-TS100272BL-L', 0, 0, '2021-04-15 13:00:37.295079', '2021-04-15 13:00:37.295079', NULL),
	(10004896, 3, 'PW21A-TS100272BL-XL', 0, 0, '2021-04-15 13:00:37.342998', '2021-04-15 13:00:37.342998', NULL),
	(10004897, 3, 'PW21A-TS100272BL-XXL', 1, 0, '2021-04-15 13:00:37.313937', '2021-04-15 13:00:37.313937', NULL),
	(10004898, 3, 'PW21A-TS100273WT-XS', 0, 0, '2021-04-15 13:00:37.314595', '2021-04-15 13:00:37.314595', NULL),
	(10004899, 3, 'PW21A-TS100273WT-S', 2, 0, '2021-04-15 13:00:37.383394', '2021-04-15 13:00:37.383394', NULL),
	(10004900, 3, 'PW21A-TS100273WT-M', 1, 0, '2021-04-15 13:00:37.363670', '2021-04-15 13:00:37.363670', NULL),
	(10004901, 3, 'PW21A-TS100273WT-L', 2, 0, '2021-04-15 13:00:37.331995', '2021-04-15 13:00:37.331995', NULL),
	(10004902, 3, 'PW21A-TS100273WT-XL', 1, 0, '2021-04-15 13:00:37.331309', '2021-04-15 13:00:37.331309', NULL),
	(10004903, 3, 'PW21A-TS100273WT-XXL', 1, 0, '2021-04-15 13:00:37.339121', '2021-04-15 13:00:37.339121', NULL),
	(10004904, 3, 'PW21A-TS100274BL-XS', 0, 0, '2021-04-15 13:00:37.343294', '2021-04-15 13:00:37.343294', NULL),
	(10004905, 3, 'PW21A-TS100274BL-S', 1, 0, '2021-04-15 13:00:37.370886', '2021-04-15 13:00:37.370886', NULL),
	(10004906, 3, 'PW21A-TS100274BL-M', 1, 0, '2021-04-15 13:00:37.362634', '2021-04-15 13:00:37.362634', NULL),
	(10004907, 3, 'PW21A-TS100274BL-L', 1, 0, '2021-04-15 13:00:37.343519', '2021-04-15 13:00:37.343519', NULL),
	(10004908, 3, 'PW21A-TS100274BL-XL', 1, 0, '2021-04-15 13:00:37.382578', '2021-04-15 13:00:37.382578', NULL),
	(10004909, 3, 'PW21A-TS100274BL-XXL', 1, 0, '2021-04-15 13:00:37.361997', '2021-04-15 13:00:37.361997', NULL),
	(10004910, 3, 'PW21A-TS100275BL-XS', 0, 0, '2021-04-15 13:00:37.378730', '2021-04-15 13:00:37.378730', NULL),
	(10004911, 3, 'PW21A-TS100275BL-S', 2, 0, '2021-04-15 13:00:37.523120', '2021-04-15 13:00:37.523120', NULL),
	(10004912, 3, 'PW21A-TS100275BL-M', 1, 0, '2021-04-15 13:00:37.500710', '2021-04-15 13:00:37.500710', NULL),
	(10004913, 3, 'PW21A-TS100275BL-L', 1, 0, '2021-04-15 13:00:37.545192', '2021-04-15 13:00:37.545192', NULL),
	(10004914, 3, 'PW21A-TS100275BL-XL', 1, 0, '2021-04-15 13:00:37.424853', '2021-04-15 13:00:37.424853', NULL),
	(10004915, 3, 'PW21A-TS100275BL-XXL', 1, 0, '2021-04-15 13:00:37.423026', '2021-04-15 13:00:37.423026', NULL),
	(10004916, 3, 'PW21A-TS100276WT-XS', 0, 0, '2021-04-15 13:00:37.384199', '2021-04-15 13:00:37.384199', NULL),
	(10004917, 3, 'PW21A-TS100276WT-S', 2, 0, '2021-04-15 13:00:37.505668', '2021-04-15 13:00:37.505668', NULL),
	(10004918, 3, 'PW21A-TS100276WT-M', 1, 0, '2021-04-15 13:00:37.510055', '2021-04-15 13:00:37.510055', NULL),
	(10004919, 3, 'PW21A-TS100276WT-L', 1, 0, '2021-04-15 13:00:37.497683', '2021-04-15 13:00:37.497683', NULL),
	(10004920, 3, 'PW21A-TS100276WT-XL', 1, 0, '2021-04-15 13:00:37.501594', '2021-04-15 13:00:37.501594', NULL),
	(10004921, 3, 'PW21A-TS100276WT-XXL', 1, 0, '2021-04-15 13:00:37.492539', '2021-04-15 13:00:37.492539', NULL),
	(10004922, 3, 'PW21A-TS100277BL-XS', 0, 0, '2021-04-15 13:00:37.513552', '2021-04-15 13:00:37.513552', NULL),
	(10004923, 3, 'PW21A-TS100277BL-S', 2, 0, '2021-04-15 13:00:37.627202', '2021-04-15 13:00:37.627202', NULL),
	(10004924, 3, 'PW21A-TS100277BL-M', 1, 0, '2021-04-15 13:00:37.515005', '2021-04-15 13:00:37.515005', NULL),
	(10004925, 3, 'PW21A-TS100277BL-L', 0, 0, '2021-04-15 13:00:37.543468', '2021-04-15 13:00:37.543468', NULL),
	(10004926, 3, 'PW21A-TS100277BL-XL', 1, 0, '2021-04-15 13:00:37.521039', '2021-04-15 13:00:37.521039', NULL),
	(10004927, 3, 'PW21A-TS100277BL-XXL', 1, 0, '2021-04-15 13:00:37.547700', '2021-04-15 13:00:37.547700', NULL),
	(10004928, 3, 'PW21A-TS100278BL-XS', 0, 0, '2021-04-15 13:00:37.528209', '2021-04-15 13:00:37.528209', NULL),
	(10004929, 3, 'PW21A-TS100278BL-S', 2, 0, '2021-04-15 13:00:37.583200', '2021-04-15 13:00:37.583200', NULL),
	(10004930, 3, 'PW21A-TS100278BL-M', 1, 0, '2021-04-15 13:00:37.524694', '2021-04-15 13:00:37.524694', NULL),
	(10004931, 3, 'PW21A-TS100278BL-L', 1, 0, '2021-04-15 13:00:37.610724', '2021-04-15 13:00:37.610724', NULL),
	(10004932, 3, 'PW21A-TS100278BL-XL', 1, 0, '2021-04-15 13:00:37.575011', '2021-04-15 13:00:37.575011', NULL),
	(10004933, 3, 'PW21A-TS100278BL-XXL', 1, 0, '2021-04-15 13:00:37.567082', '2021-04-15 13:00:37.567082', NULL),
	(10004934, 3, 'PW21A-TS100279WT-XS', 0, 0, '2021-04-15 13:00:37.545920', '2021-04-15 13:00:37.545920', NULL),
	(10004935, 3, 'PW21A-TS100279WT-S', 2, 0, '2021-04-15 13:00:37.547245', '2021-04-15 13:00:37.547245', NULL),
	(10004936, 3, 'PW21A-TS100279WT-M', 1, 0, '2021-04-15 13:00:37.548129', '2021-04-15 13:00:37.548129', NULL),
	(10004937, 3, 'PW21A-TS100279WT-L', 1, 0, '2021-04-15 13:00:37.574415', '2021-04-15 13:00:37.574415', NULL),
	(10004938, 3, 'PW21A-TS100279WT-XL', 1, 0, '2021-04-15 13:00:37.563610', '2021-04-15 13:00:37.563610', NULL),
	(10004939, 3, 'PW21A-TS100279WT-XXL', 1, 0, '2021-04-15 13:00:37.574210', '2021-04-15 13:00:37.574210', NULL),
	(10004940, 3, 'PW21A-TS100280BL-XS', 0, 0, '2021-04-15 13:00:37.550333', '2021-04-15 13:00:37.550333', NULL),
	(10004941, 3, 'PW21A-TS100280BL-S', 0, 0, '2021-04-15 13:00:37.569023', '2021-04-15 13:00:37.569023', NULL),
	(10004942, 3, 'PW21A-TS100280BL-M', 0, 0, '2021-04-15 13:00:37.562957', '2021-04-15 13:00:37.562957', NULL),
	(10004943, 3, 'PW21A-TS100280BL-L', 0, 0, '2021-04-15 13:00:37.582686', '2021-04-15 13:00:37.582686', NULL),
	(10004944, 3, 'PW21A-TS100280BL-XL', 0, 0, '2021-04-15 13:00:37.576416', '2021-04-15 13:00:37.576416', NULL),
	(10004945, 3, 'PW21A-TS100280BL-XXL', 0, 0, '2021-04-15 13:00:37.606144', '2021-04-15 13:00:37.606144', NULL),
	(10004946, 3, 'PW21A-TS100281BL-XS', 0, 0, '2021-04-15 13:00:37.581316', '2021-04-15 13:00:37.581316', NULL),
	(10004947, 3, 'PW21A-TS100281BL-S', 0, 0, '2021-04-15 13:00:37.604924', '2021-04-15 13:00:37.604924', NULL),
	(10004948, 3, 'PW21A-TS100281BL-M', 0, 0, '2021-04-15 13:00:37.602552', '2021-04-15 13:00:37.602552', NULL),
	(10004949, 3, 'PW21A-TS100281BL-L', 0, 0, '2021-04-15 13:00:37.614179', '2021-04-15 13:00:37.614179', NULL),
	(10004950, 3, 'PW21A-TS100281BL-XL', 0, 0, '2021-04-15 13:00:37.704415', '2021-04-15 13:00:37.704415', NULL),
	(10004951, 3, 'PW21A-TS100281BL-XXL', 0, 0, '2021-04-15 13:00:37.605423', '2021-04-15 13:00:37.605423', NULL),
	(10004952, 3, 'PW21A-TS100282BL-XS', 0, 0, '2021-04-15 13:00:37.627843', '2021-04-15 13:00:37.627843', NULL),
	(10004953, 3, 'PW21A-TS100282BL-S', 0, 0, '2021-04-15 13:00:37.612757', '2021-04-15 13:00:37.612757', NULL),
	(10004954, 3, 'PW21A-TS100282BL-M', 0, 0, '2021-04-15 13:00:37.707939', '2021-04-15 13:00:37.707939', NULL),
	(10004955, 3, 'PW21A-TS100282BL-L', 0, 0, '2021-04-15 13:00:37.645954', '2021-04-15 13:00:37.645954', NULL),
	(10004956, 3, 'PW21A-TS100282BL-XL', 0, 0, '2021-04-15 13:00:37.628426', '2021-04-15 13:00:37.628426', NULL),
	(10004957, 3, 'PW21A-TS100282BL-XXL', 0, 0, '2021-04-15 13:00:37.741924', '2021-04-15 13:00:37.741924', NULL),
	(10004958, 3, 'PW21A-TS100283BL-XS', 0, 0, '2021-04-15 13:00:37.649852', '2021-04-15 13:00:37.649852', NULL),
	(10004959, 3, 'PW21A-TS100283BL-S', 0, 0, '2021-04-15 13:00:37.644597', '2021-04-15 13:00:37.644597', NULL),
	(10004960, 3, 'PW21A-TS100283BL-M', 0, 0, '2021-04-15 13:00:37.647349', '2021-04-15 13:00:37.647349', NULL),
	(10004961, 3, 'PW21A-TS100283BL-L', 0, 0, '2021-04-15 13:00:37.663074', '2021-04-15 13:00:37.663074', NULL),
	(10004962, 3, 'PW21A-TS100283BL-XL', 0, 0, '2021-04-15 13:00:37.655044', '2021-04-15 13:00:37.655044', NULL),
	(10004963, 3, 'PW21A-TS100283BL-XXL', 0, 0, '2021-04-15 13:00:37.651226', '2021-04-15 13:00:37.651226', NULL),
	(10004964, 3, 'PW21A-TS100284BL-XS', 0, 0, '2021-04-15 13:00:37.648573', '2021-04-15 13:00:37.648573', NULL),
	(10004965, 3, 'PW21A-TS100284BL-S', 0, 0, '2021-04-15 13:00:37.669007', '2021-04-15 13:00:37.669007', NULL),
	(10004966, 3, 'PW21A-TS100284BL-M', 0, 0, '2021-04-15 13:00:37.822375', '2021-04-15 13:00:37.822375', NULL),
	(10004967, 3, 'PW21A-TS100284BL-L', 0, 0, '2021-04-15 13:00:37.667636', '2021-04-15 13:00:37.667636', NULL),
	(10004968, 3, 'PW21A-TS100284BL-XL', 0, 0, '2021-04-15 13:00:37.676120', '2021-04-15 13:00:37.676120', NULL),
	(10004969, 3, 'PW21A-TS100284BL-XXL', 0, 0, '2021-04-15 13:00:37.707433', '2021-04-15 13:00:37.707433', NULL),
	(10004970, 3, 'PW21A-TS100285BL-XS', 0, 0, '2021-04-15 13:00:37.705584', '2021-04-15 13:00:37.705584', NULL),
	(10004971, 3, 'PW21A-TS100285BL-S', 0, 0, '2021-04-15 13:00:37.887865', '2021-04-15 13:00:37.887865', NULL),
	(10004972, 3, 'PW21A-TS100285BL-M', 0, 0, '2021-04-15 13:00:37.713631', '2021-04-15 13:00:37.713631', NULL),
	(10004973, 3, 'PW21A-TS100285BL-L', 0, 0, '2021-04-15 13:00:37.708405', '2021-04-15 13:00:37.708405', NULL),
	(10004974, 3, 'PW21A-TS100285BL-XL', 0, 0, '2021-04-15 13:00:37.724314', '2021-04-15 13:00:37.724314', NULL),
	(10004975, 3, 'PW21A-TS100285BL-XXL', 0, 0, '2021-04-15 13:00:37.729371', '2021-04-15 13:00:37.729371', NULL),
	(10004976, 3, 'PW21A-TS100286BL-XS', 0, 0, '2021-04-15 13:00:37.717759', '2021-04-15 13:00:37.717759', NULL),
	(10004977, 3, 'PW21A-TS100286BL-S', 0, 0, '2021-04-15 13:00:37.739441', '2021-04-15 13:00:37.739441', NULL),
	(10004978, 3, 'PW21A-TS100286BL-M', 0, 0, '2021-04-15 13:00:37.733927', '2021-04-15 13:00:37.733927', NULL),
	(10004979, 3, 'PW21A-TS100286BL-L', 0, 0, '2021-04-15 13:00:37.726166', '2021-04-15 13:00:37.726166', NULL),
	(10004980, 3, 'PW21A-TS100286BL-XL', 0, 0, '2021-04-15 13:00:37.771244', '2021-04-15 13:00:37.771244', NULL),
	(10004981, 3, 'PW21A-TS100286BL-XXL', 0, 0, '2021-04-15 13:00:37.737914', '2021-04-15 13:00:37.737914', NULL),
	(10004982, 3, 'PW21A-TS100287BL-XS', 0, 0, '2021-04-15 13:00:37.742496', '2021-04-15 13:00:37.742496', NULL),
	(10004983, 3, 'PW21A-TS100287BL-S', 0, 0, '2021-04-15 13:00:37.755422', '2021-04-15 13:00:37.755422', NULL),
	(10004984, 3, 'PW21A-TS100287BL-M', 0, 0, '2021-04-15 13:00:37.743115', '2021-04-15 13:00:37.743115', NULL),
	(10004985, 3, 'PW21A-TS100287BL-L', 0, 0, '2021-04-15 13:00:37.739999', '2021-04-15 13:00:37.739999', NULL),
	(10004986, 3, 'PW21A-TS100287BL-XL', 0, 0, '2021-04-15 13:00:37.776697', '2021-04-15 13:00:37.776697', NULL),
	(10004987, 3, 'PW21A-TS100287BL-XXL', 0, 0, '2021-04-15 13:00:37.766043', '2021-04-15 13:00:37.766043', NULL),
	(10004988, 3, 'PW21A-TS100288BL-XS', 0, 0, '2021-04-15 13:00:37.760456', '2021-04-15 13:00:37.760456', NULL),
	(10004989, 3, 'PW21A-TS100288BL-S', 0, 0, '2021-04-15 13:00:37.779830', '2021-04-15 13:00:37.779830', NULL),
	(10004990, 3, 'PW21A-TS100288BL-M', 0, 0, '2021-04-15 13:00:37.890108', '2021-04-15 13:00:37.890108', NULL),
	(10004991, 3, 'PW21A-TS100288BL-L', 0, 0, '2021-04-15 13:00:37.816280', '2021-04-15 13:00:37.816280', NULL),
	(10004992, 3, 'PW21A-TS100288BL-XL', 0, 0, '2021-04-15 13:00:37.819256', '2021-04-15 13:00:37.819256', NULL),
	(10004993, 3, 'PW21A-TS100288BL-XXL', 0, 0, '2021-04-15 13:00:37.777391', '2021-04-15 13:00:37.777391', NULL),
	(10004994, 3, 'PW21A-TS100289BL-XS', 0, 0, '2021-04-15 13:00:37.780322', '2021-04-15 13:00:37.780322', NULL),
	(10004995, 3, 'PW21A-TS100289BL-S', 0, 0, '2021-04-15 13:00:37.803710', '2021-04-15 13:00:37.803710', NULL),
	(10004996, 3, 'PW21A-TS100289BL-M', 0, 0, '2021-04-15 13:00:37.783449', '2021-04-15 13:00:37.783449', NULL),
	(10004997, 3, 'PW21A-TS100289BL-L', 0, 0, '2021-04-15 13:00:37.782858', '2021-04-15 13:00:37.782858', NULL),
	(10004998, 3, 'PW21A-TS100289BL-XL', 0, 0, '2021-04-15 13:00:37.811918', '2021-04-15 13:00:37.811918', NULL),
	(10004999, 3, 'PW21A-TS100289BL-XXL', 0, 0, '2021-04-15 13:00:37.809173', '2021-04-15 13:00:37.809173', NULL),
	(10005000, 3, 'PW21A-TS100290OL-XS', 0, 0, '2021-04-15 13:00:37.854419', '2021-04-15 13:00:37.854419', NULL),
	(10005001, 3, 'PW21A-TS100290OL-S', 0, 0, '2021-04-15 13:00:37.801139', '2021-04-15 13:00:37.801139', NULL),
	(10005002, 3, 'PW21A-TS100290OL-M', 0, 0, '2021-04-15 13:00:37.849084', '2021-04-15 13:00:37.849084', NULL),
	(10005003, 3, 'PW21A-TS100290OL-L', 0, 0, '2021-04-15 13:00:37.818040', '2021-04-15 13:00:37.818040', NULL),
	(10005004, 3, 'PW21A-TS100290OL-XL', 0, 0, '2021-04-15 13:00:37.819998', '2021-04-15 13:00:37.819998', NULL),
	(10005005, 3, 'PW21A-TS100290OL-XXL', 0, 0, '2021-04-15 13:00:37.825027', '2021-04-15 13:00:37.825027', NULL),
	(10005006, 3, 'PW21A-TS100291BL-XS', 0, 0, '2021-04-15 13:00:37.975359', '2021-04-15 13:00:37.975359', NULL),
	(10005007, 3, 'PW21A-TS100291BL-S', 0, 0, '2021-04-15 13:00:37.834430', '2021-04-15 13:00:37.834430', NULL),
	(10005008, 3, 'PW21A-TS100291BL-M', 0, 0, '2021-04-15 13:00:37.837789', '2021-04-15 13:00:37.837789', NULL),
	(10005009, 3, 'PW21A-TS100291BL-L', 0, 0, '2021-04-15 13:00:37.837209', '2021-04-15 13:00:37.837209', NULL),
	(10005010, 3, 'PW21A-TS100291BL-XL', 0, 0, '2021-04-15 13:00:37.853500', '2021-04-15 13:00:37.853500', NULL),
	(10005011, 3, 'PW21A-TS100291BL-XXL', 0, 0, '2021-04-15 13:00:37.854914', '2021-04-15 13:00:37.854914', NULL),
	(10005012, 3, 'PW21A-TS100292NV-XS', 0, 0, '2021-04-15 13:00:37.845826', '2021-04-15 13:00:37.845826', NULL),
	(10005013, 3, 'PW21A-TS100292NV-S', 2, 0, '2021-04-15 13:00:37.860842', '2021-04-15 13:00:37.860842', NULL),
	(10005014, 3, 'PW21A-TS100292NV-M', 2, 0, '2021-04-15 13:00:37.856110', '2021-04-15 13:00:37.856110', NULL),
	(10005015, 3, 'PW21A-TS100292NV-L', 0, 0, '2021-04-15 13:00:37.870071', '2021-04-15 13:00:37.870071', NULL),
	(10005016, 3, 'PW21A-TS100292NV-XL', 0, 0, '2021-04-15 13:00:37.873679', '2021-04-15 13:00:37.873679', NULL),
	(10005017, 3, 'PW21A-TS100292NV-XXL', 0, 0, '2021-04-15 13:00:37.871064', '2021-04-15 13:00:37.871064', NULL),
	(10005018, 3, 'PW21A-TS100293OL-XS', 0, 0, '2021-04-15 13:00:37.871706', '2021-04-15 13:00:37.871706', NULL),
	(10005019, 3, 'PW21A-TS100293OL-S', 0, 0, '2021-04-15 13:00:37.888543', '2021-04-15 13:00:37.888543', NULL),
	(10005020, 3, 'PW21A-TS100293OL-M', 0, 0, '2021-04-15 13:00:37.993090', '2021-04-15 13:00:37.993090', NULL),
	(10005021, 3, 'PW21A-TS100293OL-L', 0, 0, '2021-04-15 13:00:37.890655', '2021-04-15 13:00:37.890655', NULL),
	(10005022, 3, 'PW21A-TS100293OL-XL', 0, 0, '2021-04-15 13:00:37.909154', '2021-04-15 13:00:37.909154', NULL),
	(10005023, 3, 'PW21A-TS100293OL-XXL', 0, 0, '2021-04-15 13:00:37.908759', '2021-04-15 13:00:37.908759', NULL),
	(10005024, 3, 'PW21A-TS100294OL-XS', 0, 0, '2021-04-15 13:00:37.887336', '2021-04-15 13:00:37.887336', NULL),
	(10005025, 3, 'PW21A-TS100294OL-S', 0, 0, '2021-04-15 13:00:37.922464', '2021-04-15 13:00:37.922464', NULL),
	(10005026, 3, 'PW21A-TS100294OL-M', 0, 0, '2021-04-15 13:00:37.899192', '2021-04-15 13:00:37.899192', NULL),
	(10005027, 3, 'PW21A-TS100294OL-L', 0, 0, '2021-04-15 13:00:37.907963', '2021-04-15 13:00:37.907963', NULL),
	(10005028, 3, 'PW21A-TS100294OL-XL', 0, 0, '2021-04-15 13:00:37.924851', '2021-04-15 13:00:37.924851', NULL),
	(10005029, 3, 'PW21A-TS100294OL-XXL', 0, 0, '2021-04-15 13:00:37.914853', '2021-04-15 13:00:37.914853', NULL),
	(10005030, 3, 'PW21A-TS100295NV-XS', 0, 0, '2021-04-15 13:00:37.923121', '2021-04-15 13:00:37.923121', NULL),
	(10005031, 3, 'PW21A-TS100295NV-S', 0, 0, '2021-04-15 13:00:38.023929', '2021-04-15 13:00:38.023929', NULL),
	(10005032, 3, 'PW21A-TS100295NV-M', 0, 0, '2021-04-15 13:00:37.924287', '2021-04-15 13:00:37.924287', NULL),
	(10005033, 3, 'PW21A-TS100295NV-L', 0, 0, '2021-04-15 13:00:37.923737', '2021-04-15 13:00:37.923737', NULL),
	(10005034, 3, 'PW21A-TS100295NV-XL', 0, 0, '2021-04-15 13:00:38.118486', '2021-04-15 13:00:38.118486', NULL),
	(10005035, 3, 'PW21A-TS100295NV-XXL', 0, 0, '2021-04-15 13:00:37.939171', '2021-04-15 13:00:37.939171', NULL),
	(10005036, 3, 'PW21A-TS100296BL-XS', 0, 0, '2021-04-15 13:00:37.940418', '2021-04-15 13:00:37.940418', NULL),
	(10005037, 3, 'PW21A-TS100296BL-S', 2, 0, '2021-04-15 13:00:37.947725', '2021-04-15 13:00:37.947725', NULL),
	(10005038, 3, 'PW21A-TS100296BL-M', 1, 0, '2021-04-15 13:00:37.932735', '2021-04-15 13:00:37.932735', NULL),
	(10005039, 3, 'PW21A-TS100296BL-L', 1, 0, '2021-04-15 13:00:37.939645', '2021-04-15 13:00:37.939645', NULL),
	(10005040, 3, 'PW21A-TS100296BL-XL', 1, 0, '2021-04-15 13:00:37.961233', '2021-04-15 13:00:37.961233', NULL),
	(10005041, 3, 'PW21A-TS100296BL-XXL', 1, 0, '2021-04-15 13:00:37.960828', '2021-04-15 13:00:37.960828', NULL),
	(10005042, 3, 'PW21A-TS100297OL-XS', 0, 0, '2021-04-15 13:00:37.959842', '2021-04-15 13:00:37.959842', NULL),
	(10005043, 3, 'PW21A-TS100297OL-S', 1, 0, '2021-04-15 13:00:37.968360', '2021-04-15 13:00:37.968360', NULL),
	(10005044, 3, 'PW21A-TS100297OL-M', 1, 0, '2021-04-15 13:00:37.976292', '2021-04-15 13:00:37.976292', NULL),
	(10005045, 3, 'PW21A-TS100297OL-L', 0, 0, '2021-04-15 13:00:37.960377', '2021-04-15 13:00:37.960377', NULL),
	(10005046, 3, 'PW21A-TS100297OL-XL', 1, 0, '2021-04-15 13:00:37.961925', '2021-04-15 13:00:37.961925', NULL),
	(10005047, 3, 'PW21A-TS100297OL-XXL', 1, 0, '2021-04-15 13:00:37.989672', '2021-04-15 13:00:37.989672', NULL),
	(10005048, 3, 'PW21A-TS100298OL-XS', 0, 0, '2021-04-15 13:00:37.994198', '2021-04-15 13:00:37.994198', NULL),
	(10005049, 3, 'PW21A-TS100298OL-S', 0, 0, '2021-04-15 13:00:38.029257', '2021-04-15 13:00:38.029257', NULL),
	(10005050, 3, 'PW21A-TS100298OL-M', 0, 0, '2021-04-15 13:00:37.975847', '2021-04-15 13:00:37.975847', NULL),
	(10005051, 3, 'PW21A-TS100298OL-L', 0, 0, '2021-04-15 13:00:38.008087', '2021-04-15 13:00:38.008087', NULL),
	(10005052, 3, 'PW21A-TS100298OL-XL', 0, 0, '2021-04-15 13:00:37.984298', '2021-04-15 13:00:37.984298', NULL),
	(10005053, 3, 'PW21A-TS100298OL-XXL', 0, 0, '2021-04-15 13:00:37.994616', '2021-04-15 13:00:37.994616', NULL),
	(10005054, 3, 'PW21A-TS100299BL-XS', 0, 0, '2021-04-15 13:00:37.993787', '2021-04-15 13:00:37.993787', NULL),
	(10005055, 3, 'PW21A-TS100299BL-S', 2, 0, '2021-04-15 13:00:37.998224', '2021-04-15 13:00:37.998224', NULL),
	(10005056, 3, 'PW21A-TS100299BL-M', 1, 0, '2021-04-15 13:00:38.006703', '2021-04-15 13:00:38.006703', NULL),
	(10005057, 3, 'PW21A-TS100299BL-L', 1, 0, '2021-04-15 13:00:38.091306', '2021-04-15 13:00:38.091306', NULL),
	(10005058, 3, 'PW21A-TS100299BL-XL', 1, 0, '2021-04-15 13:00:38.011374', '2021-04-15 13:00:38.011374', NULL),
	(10005059, 3, 'PW21A-TS100299BL-XXL', 1, 0, '2021-04-15 13:00:38.108585', '2021-04-15 13:00:38.108585', NULL),
	(10005060, 3, 'PW21A-TS100300MR-XS', 0, 0, '2021-04-15 13:00:38.024482', '2021-04-15 13:00:38.024482', NULL),
	(10005061, 3, 'PW21A-TS100300MR-S', 0, 0, '2021-04-15 13:00:38.028205', '2021-04-15 13:00:38.028205', NULL),
	(10005062, 3, 'PW21A-TS100300MR-M', 0, 0, '2021-04-15 13:00:38.016555', '2021-04-15 13:00:38.016555', NULL),
	(10005063, 3, 'PW21A-TS100300MR-L', 0, 0, '2021-04-15 13:00:38.028734', '2021-04-15 13:00:38.028734', NULL),
	(10005064, 3, 'PW21A-TS100300MR-XL', 0, 0, '2021-04-15 13:00:38.051228', '2021-04-15 13:00:38.051228', NULL),
	(10005065, 3, 'PW21A-TS100300MR-XXL', 0, 0, '2021-04-15 13:00:38.061966', '2021-04-15 13:00:38.061966', NULL),
	(10005066, 3, 'PW21A-TS100301BL-XS', 0, 0, '2021-04-15 13:00:38.035863', '2021-04-15 13:00:38.035863', NULL),
	(10005067, 3, 'PW21A-TS100301BL-S', 0, 0, '2021-04-15 13:00:38.047130', '2021-04-15 13:00:38.047130', NULL),
	(10005068, 3, 'PW21A-TS100301BL-M', 0, 0, '2021-04-15 13:00:38.049232', '2021-04-15 13:00:38.049232', NULL),
	(10005069, 3, 'PW21A-TS100301BL-L', 0, 0, '2021-04-15 13:00:38.065735', '2021-04-15 13:00:38.065735', NULL),
	(10005070, 3, 'PW21A-TS100301BL-XL', 0, 0, '2021-04-15 13:00:38.087021', '2021-04-15 13:00:38.087021', NULL),
	(10005071, 3, 'PW21A-TS100301BL-XXL', 0, 0, '2021-04-15 13:00:38.085129', '2021-04-15 13:00:38.085129', NULL),
	(10005072, 3, 'PW21A-TS100302BL-XS', 0, 0, '2021-04-15 13:00:38.063466', '2021-04-15 13:00:38.063466', NULL),
	(10005073, 3, 'PW21A-TS100302BL-S', 2, 0, '2021-04-15 13:00:38.066257', '2021-04-15 13:00:38.066257', NULL),
	(10005074, 3, 'PW21A-TS100302BL-M', 0, 0, '2021-04-15 13:00:38.066734', '2021-04-15 13:00:38.066734', NULL),
	(10005075, 3, 'PW21A-TS100302BL-L', 1, 0, '2021-04-15 13:00:38.050588', '2021-04-15 13:00:38.050588', NULL),
	(10005076, 3, 'PW21A-TS100302BL-XL', 1, 0, '2021-04-15 13:00:38.069757', '2021-04-15 13:00:38.069757', NULL),
	(10005077, 3, 'PW21A-TS100302BL-XXL', 1, 0, '2021-04-15 13:00:38.150868', '2021-04-15 13:00:38.150868', NULL),
	(10005078, 3, 'PW21A-TS100303BL-XS', 0, 0, '2021-04-15 13:00:38.102295', '2021-04-15 13:00:38.102295', NULL),
	(10005079, 3, 'PW21A-TS100303BL-S', 0, 0, '2021-04-15 13:00:38.094582', '2021-04-15 13:00:38.094582', NULL),
	(10005080, 3, 'PW21A-TS100303BL-M', 0, 0, '2021-04-15 13:00:38.106249', '2021-04-15 13:00:38.106249', NULL),
	(10005081, 3, 'PW21A-TS100303BL-L', 0, 0, '2021-04-15 13:00:38.137599', '2021-04-15 13:00:38.137599', NULL),
	(10005082, 3, 'PW21A-TS100303BL-XL', 0, 0, '2021-04-15 13:00:38.101668', '2021-04-15 13:00:38.101668', NULL),
	(10005083, 3, 'PW21A-TS100303BL-XXL', 0, 0, '2021-04-15 13:00:38.103824', '2021-04-15 13:00:38.103824', NULL),
	(10005084, 3, 'PW21A-TS100304OL-XS', 0, 0, '2021-04-15 13:00:38.115999', '2021-04-15 13:00:38.115999', NULL),
	(10005085, 3, 'PW21A-TS100304OL-S', 2, 0, '2021-04-15 13:00:38.171631', '2021-04-15 13:00:38.171631', NULL),
	(10005086, 3, 'PW21A-TS100304OL-M', 1, 0, '2021-04-15 13:00:38.104298', '2021-04-15 13:00:38.104298', NULL),
	(10005087, 3, 'PW21A-TS100304OL-L', 1, 0, '2021-04-15 13:00:38.133544', '2021-04-15 13:00:38.133544', NULL),
	(10005088, 3, 'PW21A-TS100304OL-XL', 1, 0, '2021-04-15 13:00:38.119043', '2021-04-15 13:00:38.119043', NULL),
	(10005089, 3, 'PW21A-TS100304OL-XXL', 1, 0, '2021-04-15 13:00:38.120169', '2021-04-15 13:00:38.120169', NULL),
	(10005090, 3, 'PW21A-TS100305AR-XS', 0, 0, '2021-04-15 13:00:38.136623', '2021-04-15 13:00:38.136623', NULL),
	(10005091, 3, 'PW21A-TS100305AR-S', 2, 0, '2021-04-15 13:00:38.139935', '2021-04-15 13:00:38.139935', NULL),
	(10005092, 3, 'PW21A-TS100305AR-M', 1, 0, '2021-04-15 13:00:38.137133', '2021-04-15 13:00:38.137133', NULL),
	(10005093, 3, 'PW21A-TS100305AR-L', 1, 0, '2021-04-15 13:00:38.166754', '2021-04-15 13:00:38.166754', NULL),
	(10005094, 3, 'PW21A-TS100305AR-XL', 1, 0, '2021-04-15 13:00:38.198962', '2021-04-15 13:00:38.198962', NULL),
	(10005095, 3, 'PW21A-TS100305AR-XXL', 1, 0, '2021-04-15 13:00:38.150391', '2021-04-15 13:00:38.150391', NULL),
	(10005096, 3, 'PW21A-TS100306GN-XS', 0, 0, '2021-04-15 13:00:38.148195', '2021-04-15 13:00:38.148195', NULL),
	(10005097, 3, 'PW21A-TS100306GN-S', 2, 0, '2021-04-15 13:00:38.151609', '2021-04-15 13:00:38.151609', NULL),
	(10005098, 3, 'PW21A-TS100306GN-M', 1, 0, '2021-04-15 13:00:38.139392', '2021-04-15 13:00:38.139392', NULL),
	(10005099, 3, 'PW21A-TS100306GN-L', 1, 0, '2021-04-15 13:00:38.266333', '2021-04-15 13:00:38.266333', NULL),
	(10005100, 3, 'PW21A-TS100306GN-XL', 1, 0, '2021-04-15 13:00:38.167732', '2021-04-15 13:00:38.167732', NULL),
	(10005101, 3, 'PW21A-TS100306GN-XXL', 1, 0, '2021-04-15 13:00:38.167259', '2021-04-15 13:00:38.167259', NULL),
	(10005102, 3, 'PW21A-TS100307GN-XS', 0, 0, '2021-04-15 13:00:38.164136', '2021-04-15 13:00:38.164136', NULL),
	(10005103, 3, 'PW21A-TS100307GN-S', 2, 0, '2021-04-15 13:00:38.183720', '2021-04-15 13:00:38.183720', NULL),
	(10005104, 3, 'PW21A-TS100307GN-M', 1, 0, '2021-04-15 13:00:38.183290', '2021-04-15 13:00:38.183290', NULL),
	(10005105, 3, 'PW21A-TS100307GN-L', 1, 0, '2021-04-15 13:00:38.182793', '2021-04-15 13:00:38.182793', NULL),
	(10005106, 3, 'PW21A-TS100307GN-XL', 1, 0, '2021-04-15 13:00:38.171143', '2021-04-15 13:00:38.171143', NULL),
	(10005107, 3, 'PW21A-TS100307GN-XXL', 1, 0, '2021-04-15 13:00:38.262387', '2021-04-15 13:00:38.262387', NULL),
	(10005108, 3, 'PW21A-TS100308GN-XS', 0, 0, '2021-04-15 13:00:38.196200', '2021-04-15 13:00:38.196200', NULL),
	(10005109, 3, 'PW21A-TS100308GN-S', 1, 0, '2021-04-15 13:00:38.180604', '2021-04-15 13:00:38.180604', NULL),
	(10005110, 3, 'PW21A-TS100308GN-M', 1, 0, '2021-04-15 13:00:38.193030', '2021-04-15 13:00:38.193030', NULL),
	(10005111, 3, 'PW21A-TS100308GN-L', 1, 0, '2021-04-15 13:00:38.199409', '2021-04-15 13:00:38.199409', NULL),
	(10005112, 3, 'PW21A-TS100308GN-XL', 1, 0, '2021-04-15 13:00:38.198507', '2021-04-15 13:00:38.198507', NULL),
	(10005113, 3, 'PW21A-TS100308GN-XXL', 1, 0, '2021-04-15 13:00:38.196699', '2021-04-15 13:00:38.196699', NULL),
	(10005114, 3, 'PW21A-TS100309GN-XS', 0, 0, '2021-04-15 13:00:38.212360', '2021-04-15 13:00:38.212360', NULL),
	(10005115, 3, 'PW21A-TS100309GN-S', 2, 0, '2021-04-15 13:00:38.226316', '2021-04-15 13:00:38.226316', NULL),
	(10005116, 3, 'PW21A-TS100309GN-M', 1, 0, '2021-04-15 13:00:38.211854', '2021-04-15 13:00:38.211854', NULL),
	(10005117, 3, 'PW21A-TS100309GN-L', 1, 0, '2021-04-15 13:00:38.208667', '2021-04-15 13:00:38.208667', NULL),
	(10005118, 3, 'PW21A-TS100309GN-XL', 1, 0, '2021-04-15 13:00:38.224174', '2021-04-15 13:00:38.224174', NULL),
	(10005119, 3, 'PW21A-TS100309GN-XXL', 1, 0, '2021-04-15 13:00:38.212777', '2021-04-15 13:00:38.212777', NULL),
	(10005120, 3, 'PW21A-SW100310BL-XS', 0, 0, '2021-04-15 13:00:38.220768', '2021-04-15 13:00:38.220768', NULL),
	(10005121, 3, 'PW21A-SW100310BL-S', 0, 0, '2021-04-15 13:00:38.308267', '2021-04-15 13:00:38.308267', NULL),
	(10005122, 3, 'PW21A-SW100310BL-M', 1, 0, '2021-04-15 13:00:38.225460', '2021-04-15 13:00:38.225460', NULL),
	(10005123, 3, 'PW21A-SW100310BL-L', 0, 0, '2021-04-15 13:00:38.223706', '2021-04-15 13:00:38.223706', NULL),
	(10005124, 3, 'PW21A-SW100310BL-XL', 0, 0, '2021-04-15 13:00:38.225897', '2021-04-15 13:00:38.225897', NULL),
	(10005125, 3, 'PW21A-SW100310BL-XXL', 0, 0, '2021-04-15 13:00:38.235766', '2021-04-15 13:00:38.235766', NULL),
	(10005126, 3, 'PW21A-SW100311BL-XS', 0, 0, '2021-04-15 13:00:38.263060', '2021-04-15 13:00:38.263060', NULL),
	(10005127, 3, 'PW21A-SW100311BL-S', 2, 0, '2021-04-15 13:00:38.230418', '2021-04-15 13:00:38.230418', NULL),
	(10005128, 3, 'PW21A-SW100311BL-M', 1, 0, '2021-04-15 13:00:38.227055', '2021-04-15 13:00:38.227055', NULL),
	(10005129, 3, 'PW21A-SW100311BL-L', 1, 0, '2021-04-15 13:00:38.263845', '2021-04-15 13:00:38.263845', NULL),
	(10005130, 3, 'PW21A-SW100311BL-XL', 1, 0, '2021-04-15 13:00:38.265808', '2021-04-15 13:00:38.265808', NULL),
	(10005131, 3, 'PW21A-SW100311BL-XXL', 0, 0, '2021-04-15 13:00:38.236867', '2021-04-15 13:00:38.236867', NULL),
	(10005132, 3, 'PW21A-SW100312BL-XS', 0, 0, '2021-04-15 13:00:38.297156', '2021-04-15 13:00:38.297156', NULL),
	(10005133, 3, 'PW21A-SW100312BL-S', 0, 0, '2021-04-15 13:00:38.267543', '2021-04-15 13:00:38.267543', NULL),
	(10005134, 3, 'PW21A-SW100312BL-M', 0, 0, '2021-04-15 13:00:38.260449', '2021-04-15 13:00:38.260449', NULL),
	(10005135, 3, 'PW21A-SW100312BL-L', 1, 0, '2021-04-15 13:00:38.265267', '2021-04-15 13:00:38.265267', NULL),
	(10005136, 3, 'PW21A-SW100312BL-XL', 1, 0, '2021-04-15 13:00:38.270617', '2021-04-15 13:00:38.270617', NULL),
	(10005137, 3, 'PW21A-SW100312BL-XXL', 1, 0, '2021-04-15 13:00:38.301258', '2021-04-15 13:00:38.301258', NULL),
	(10005138, 3, 'PW21A-SW100313BL-XS', 0, 0, '2021-04-15 13:00:38.327978', '2021-04-15 13:00:38.327978', NULL),
	(10005139, 3, 'PW21A-SW100313BL-S', 0, 0, '2021-04-15 13:00:38.384095', '2021-04-15 13:00:38.384095', NULL),
	(10005140, 3, 'PW21A-SW100313BL-M', 0, 0, '2021-04-15 13:00:38.300492', '2021-04-15 13:00:38.300492', NULL),
	(10005141, 3, 'PW21A-SW100313BL-L', 0, 0, '2021-04-15 13:00:38.268954', '2021-04-15 13:00:38.268954', NULL),
	(10005142, 3, 'PW21A-SW100313BL-XL', 0, 0, '2021-04-15 13:00:38.298477', '2021-04-15 13:00:38.298477', NULL),
	(10005143, 3, 'PW21A-SW100313BL-XXL', 0, 0, '2021-04-15 13:00:38.307016', '2021-04-15 13:00:38.307016', NULL),
	(10005144, 3, 'PW21A-SW100314DK-XS', 0, 0, '2021-04-15 13:00:38.306221', '2021-04-15 13:00:38.306221', NULL),
	(10005145, 3, 'PW21A-SW100314DK-S', 0, 0, '2021-04-15 13:00:38.310527', '2021-04-15 13:00:38.310527', NULL),
	(10005146, 3, 'PW21A-SW100314DK-M', 0, 0, '2021-04-15 13:00:38.325499', '2021-04-15 13:00:38.325499', NULL),
	(10005147, 3, 'PW21A-SW100314DK-L', 0, 0, '2021-04-15 13:00:38.333730', '2021-04-15 13:00:38.333730', NULL),
	(10005148, 3, 'PW21A-SW100314DK-XL', 0, 0, '2021-04-15 13:00:38.311870', '2021-04-15 13:00:38.311870', NULL),
	(10005149, 3, 'PW21A-SW100314DK-XXL', 0, 0, '2021-04-15 13:00:38.308853', '2021-04-15 13:00:38.308853', NULL),
	(10005150, 3, 'PW21A-SW100315BL-XS', 0, 0, '2021-04-15 13:00:38.380107', '2021-04-15 13:00:38.380107', NULL),
	(10005151, 3, 'PW21A-SW100315BL-S', 0, 0, '2021-04-15 13:00:38.342906', '2021-04-15 13:00:38.342906', NULL),
	(10005152, 3, 'PW21A-SW100315BL-M', 0, 0, '2021-04-15 13:00:38.420357', '2021-04-15 13:00:38.420357', NULL),
	(10005153, 3, 'PW21A-SW100315BL-L', 0, 0, '2021-04-15 13:00:38.343987', '2021-04-15 13:00:38.343987', NULL),
	(10005154, 3, 'PW21A-SW100315BL-XL', 0, 0, '2021-04-15 13:00:38.350267', '2021-04-15 13:00:38.350267', NULL),
	(10005155, 3, 'PW21A-SW100315BL-XXL', 0, 0, '2021-04-15 13:00:38.347374', '2021-04-15 13:00:38.347374', NULL),
	(10005156, 3, 'PW21A-SW100316BL-XS', 0, 0, '2021-04-15 13:00:38.346911', '2021-04-15 13:00:38.346911', NULL),
	(10005157, 3, 'PW21A-SW100316BL-S', 0, 0, '2021-04-15 13:00:38.357411', '2021-04-15 13:00:38.357411', NULL),
	(10005158, 3, 'PW21A-SW100316BL-M', 0, 0, '2021-04-15 13:00:38.362589', '2021-04-15 13:00:38.362589', NULL),
	(10005159, 3, 'PW21A-SW100316BL-L', 0, 0, '2021-04-15 13:00:38.369289', '2021-04-15 13:00:38.369289', NULL),
	(10005160, 3, 'PW21A-SW100316BL-XL', 0, 0, '2021-04-15 13:00:38.351832', '2021-04-15 13:00:38.351832', NULL),
	(10005161, 3, 'PW21A-SW100316BL-XXL', 0, 0, '2021-04-15 13:00:38.478307', '2021-04-15 13:00:38.478307', NULL),
	(10005162, 3, 'PW21A-SW100317BL-XS', 0, 0, '2021-04-15 13:00:38.377184', '2021-04-15 13:00:38.377184', NULL),
	(10005163, 3, 'PW21A-SW100317BL-S', 1, 0, '2021-04-15 13:00:38.382534', '2021-04-15 13:00:38.382534', NULL),
	(10005164, 3, 'PW21A-SW100317BL-M', 1, 0, '2021-04-15 13:00:38.379152', '2021-04-15 13:00:38.379152', NULL),
	(10005165, 3, 'PW21A-SW100317BL-L', 0, 0, '2021-04-15 13:00:38.412624', '2021-04-15 13:00:38.412624', NULL),
	(10005166, 3, 'PW21A-SW100317BL-XL', 1, 0, '2021-04-15 13:00:38.397414', '2021-04-15 13:00:38.397414', NULL),
	(10005167, 3, 'PW21A-SW100317BL-XXL', 1, 0, '2021-04-15 13:00:38.385020', '2021-04-15 13:00:38.385020', NULL),
	(10005168, 3, 'PW21A-SW100318OL-XS', 0, 0, '2021-04-15 13:00:38.391151', '2021-04-15 13:00:38.391151', NULL),
	(10005169, 3, 'PW21A-SW100318OL-S', 2, 0, '2021-04-15 13:00:38.386930', '2021-04-15 13:00:38.386930', NULL),
	(10005170, 3, 'PW21A-SW100318OL-M', 1, 0, '2021-04-15 13:00:38.402044', '2021-04-15 13:00:38.402044', NULL),
	(10005171, 3, 'PW21A-SW100318OL-L', 1, 0, '2021-04-15 13:00:38.418302', '2021-04-15 13:00:38.418302', NULL),
	(10005172, 3, 'PW21A-SW100318OL-XL', 0, 0, '2021-04-15 13:00:38.421429', '2021-04-15 13:00:38.421429', NULL),
	(10005173, 3, 'PW21A-SW100318OL-XXL', 1, 0, '2021-04-15 13:00:38.510156', '2021-04-15 13:00:38.510156', NULL),
	(10005174, 3, 'PW21A-SW100319WT-XS', 0, 0, '2021-04-15 13:00:38.433034', '2021-04-15 13:00:38.433034', NULL),
	(10005175, 3, 'PW21A-SW100319WT-S', 2, 0, '2021-04-15 13:00:38.424548', '2021-04-15 13:00:38.424548', NULL),
	(10005176, 3, 'PW21A-SW100319WT-M', 0, 0, '2021-04-15 13:00:38.423194', '2021-04-15 13:00:38.423194', NULL),
	(10005177, 3, 'PW21A-SW100319WT-L', 0, 0, '2021-04-15 13:00:38.454308', '2021-04-15 13:00:38.454308', NULL),
	(10005178, 3, 'PW21A-SW100319WT-XL', 1, 0, '2021-04-15 13:00:38.425007', '2021-04-15 13:00:38.425007', NULL),
	(10005179, 3, 'PW21A-SW100319WT-XXL', 1, 0, '2021-04-15 13:00:38.429603', '2021-04-15 13:00:38.429603', NULL),
	(10005180, 3, 'PW21A-SW100320BL-XS', 0, 0, '2021-04-15 13:00:38.481502', '2021-04-15 13:00:38.481502', NULL),
	(10005181, 3, 'PW21A-SW100320BL-S', 0, 0, '2021-04-15 13:00:38.472105', '2021-04-15 13:00:38.472105', NULL),
	(10005182, 3, 'PW21A-SW100320BL-M', 0, 0, '2021-04-15 13:00:38.471222', '2021-04-15 13:00:38.471222', NULL),
	(10005183, 3, 'PW21A-SW100320BL-L', 0, 0, '2021-04-15 13:00:38.439801', '2021-04-15 13:00:38.439801', NULL),
	(10005184, 3, 'PW21A-SW100320BL-XL', 0, 0, '2021-04-15 13:00:38.538727', '2021-04-15 13:00:38.538727', NULL),
	(10005185, 3, 'PW21A-SW100320BL-XXL', 0, 0, '2021-04-15 13:00:38.472682', '2021-04-15 13:00:38.472682', NULL),
	(10005186, 3, 'PW21A-SW100321BL-XS', 0, 0, '2021-04-15 13:00:38.486677', '2021-04-15 13:00:38.486677', NULL),
	(10005187, 3, 'PW21A-SW100321BL-S', 0, 0, '2021-04-15 13:00:38.463047', '2021-04-15 13:00:38.463047', NULL),
	(10005188, 3, 'PW21A-SW100321BL-M', 0, 0, '2021-04-15 13:00:38.516671', '2021-04-15 13:00:38.516671', NULL),
	(10005189, 3, 'PW21A-SW100321BL-L', 0, 0, '2021-04-15 13:00:38.490500', '2021-04-15 13:00:38.490500', NULL),
	(10005190, 3, 'PW21A-SW100321BL-XL', 0, 0, '2021-04-15 13:00:38.475953', '2021-04-15 13:00:38.475953', NULL),
	(10005191, 3, 'PW21A-SW100321BL-XXL', 0, 0, '2021-04-15 13:00:38.511991', '2021-04-15 13:00:38.511991', NULL),
	(10005192, 3, 'PW21A-SW100322BL-XS', 0, 0, '2021-04-15 13:00:38.509420', '2021-04-15 13:00:38.509420', NULL),
	(10005193, 3, 'PW21A-SW100322BL-S', 0, 0, '2021-04-15 13:00:38.605272', '2021-04-15 13:00:38.605272', NULL),
	(10005194, 3, 'PW21A-SW100322BL-M', 0, 0, '2021-04-15 13:00:38.512483', '2021-04-15 13:00:38.512483', NULL),
	(10005195, 3, 'PW21A-SW100322BL-L', 0, 0, '2021-04-15 13:00:38.515438', '2021-04-15 13:00:38.515438', NULL),
	(10005196, 3, 'PW21A-SW100322BL-XL', 0, 0, '2021-04-15 13:00:38.505933', '2021-04-15 13:00:38.505933', NULL),
	(10005197, 3, 'PW21A-SW100322BL-XXL', 0, 0, '2021-04-15 13:00:38.530839', '2021-04-15 13:00:38.530839', NULL),
	(10005198, 3, 'PW21A-SW100323BL-XS', 0, 0, '2021-04-15 13:00:38.521365', '2021-04-15 13:00:38.521365', NULL),
	(10005199, 3, 'PW21A-SW100323BL-S', 0, 0, '2021-04-15 13:00:38.541315', '2021-04-15 13:00:38.541315', NULL),
	(10005200, 3, 'PW21A-SW100323BL-M', 0, 0, '2021-04-15 13:00:38.525545', '2021-04-15 13:00:38.525545', NULL),
	(10005201, 3, 'PW21A-SW100323BL-L', 0, 0, '2021-04-15 13:00:38.611725', '2021-04-15 13:00:38.611725', NULL),
	(10005202, 3, 'PW21A-SW100323BL-XL', 0, 0, '2021-04-15 13:00:38.546043', '2021-04-15 13:00:38.546043', NULL),
	(10005203, 3, 'PW21A-SW100323BL-XXL', 0, 0, '2021-04-15 13:00:38.548753', '2021-04-15 13:00:38.548753', NULL),
	(10005204, 3, 'PW21A-SW100324BL-XS', 0, 0, '2021-04-15 13:00:38.549949', '2021-04-15 13:00:38.549949', NULL),
	(10005205, 3, 'PW21A-SW100324BL-S', 2, 0, '2021-04-15 13:00:38.642296', '2021-04-15 13:00:38.642296', NULL),
	(10005206, 3, 'PW21A-SW100324BL-M', 1, 0, '2021-04-15 13:00:38.553523', '2021-04-15 13:00:38.553523', NULL),
	(10005207, 3, 'PW21A-SW100324BL-L', 1, 0, '2021-04-15 13:00:38.588096', '2021-04-15 13:00:38.588096', NULL),
	(10005208, 3, 'PW21A-SW100324BL-XL', 1, 0, '2021-04-15 13:00:38.588739', '2021-04-15 13:00:38.588739', NULL),
	(10005209, 3, 'PW21A-SW100324BL-XXL', 1, 0, '2021-04-15 13:00:38.552984', '2021-04-15 13:00:38.552984', NULL),
	(10005210, 3, 'PW21A-SW100325BL-XS', 0, 0, '2021-04-15 13:00:38.561524', '2021-04-15 13:00:38.561524', NULL),
	(10005211, 3, 'PW21A-SW100325BL-S', 2, 0, '2021-04-15 13:00:38.635414', '2021-04-15 13:00:38.635414', NULL),
	(10005212, 3, 'PW21A-SW100325BL-M', 1, 0, '2021-04-15 13:00:38.651046', '2021-04-15 13:00:38.651046', NULL),
	(10005213, 3, 'PW21A-SW100325BL-L', 1, 0, '2021-04-15 13:00:38.604624', '2021-04-15 13:00:38.604624', NULL),
	(10005214, 3, 'PW21A-SW100325BL-XL', 1, 0, '2021-04-15 13:00:38.605828', '2021-04-15 13:00:38.605828', NULL),
	(10005215, 3, 'PW21A-SW100325BL-XXL', 1, 0, '2021-04-15 13:00:38.643755', '2021-04-15 13:00:38.643755', NULL),
	(10005216, 3, 'PW21A-SW100326BL-XS', 0, 0, '2021-04-15 13:00:38.618167', '2021-04-15 13:00:38.618167', NULL),
	(10005217, 3, 'PW21A-SW100326BL-S', 2, 0, '2021-04-15 13:00:38.701395', '2021-04-15 13:00:38.701395', NULL),
	(10005218, 3, 'PW21A-SW100326BL-M', 1, 0, '2021-04-15 13:00:38.611154', '2021-04-15 13:00:38.611154', NULL),
	(10005219, 3, 'PW21A-SW100326BL-L', 1, 0, '2021-04-15 13:00:38.623522', '2021-04-15 13:00:38.623522', NULL),
	(10005220, 3, 'PW21A-SW100326BL-XL', 1, 0, '2021-04-15 13:00:38.610522', '2021-04-15 13:00:38.610522', NULL),
	(10005221, 3, 'PW21A-SW100326BL-XXL', 1, 0, '2021-04-15 13:00:38.621837', '2021-04-15 13:00:38.621837', NULL),
	(10005222, 3, 'PW21A-SW100327BL-XS', 0, 0, '2021-04-15 13:00:38.606601', '2021-04-15 13:00:38.606601', NULL),
	(10005223, 3, 'PW21A-SW100327BL-S', 2, 0, '2021-04-15 13:00:38.636591', '2021-04-15 13:00:38.636591', NULL),
	(10005224, 3, 'PW21A-SW100327BL-M', 1, 0, '2021-04-15 13:00:38.622487', '2021-04-15 13:00:38.622487', NULL),
	(10005225, 3, 'PW21A-SW100327BL-L', 1, 0, '2021-04-15 13:00:38.625525', '2021-04-15 13:00:38.625525', NULL),
	(10005226, 3, 'PW21A-SW100327BL-XL', 1, 0, '2021-04-15 13:00:38.624570', '2021-04-15 13:00:38.624570', NULL),
	(10005227, 3, 'PW21A-SW100327BL-XXL', 1, 0, '2021-04-15 13:00:38.672437', '2021-04-15 13:00:38.672437', NULL),
	(10005228, 3, 'PW21A-SW100328BL-XS', 0, 0, '2021-04-15 13:00:38.682609', '2021-04-15 13:00:38.682609', NULL),
	(10005229, 3, 'PW21A-SW100328BL-S', 2, 0, '2021-04-15 13:00:38.632498', '2021-04-15 13:00:38.632498', NULL),
	(10005230, 3, 'PW21A-SW100328BL-M', 1, 0, '2021-04-15 13:00:38.671490', '2021-04-15 13:00:38.671490', NULL),
	(10005231, 3, 'PW21A-SW100328BL-L', 1, 0, '2021-04-15 13:00:38.648845', '2021-04-15 13:00:38.648845', NULL),
	(10005232, 3, 'PW21A-SW100328BL-XL', 1, 0, '2021-04-15 13:00:38.658012', '2021-04-15 13:00:38.658012', NULL),
	(10005233, 3, 'PW21A-SW100328BL-XXL', 1, 0, '2021-04-15 13:00:38.657907', '2021-04-15 13:00:38.657907', NULL),
	(10005234, 3, 'PW21A-SW100329BL-XS', 0, 0, '2021-04-15 13:00:38.687219', '2021-04-15 13:00:38.687219', NULL),
	(10005235, 3, 'PW21A-SW100329BL-S', 2, 0, '2021-04-15 13:00:38.674665', '2021-04-15 13:00:38.674665', NULL),
	(10005236, 3, 'PW21A-SW100329BL-M', 1, 0, '2021-04-15 13:00:38.667227', '2021-04-15 13:00:38.667227', NULL),
	(10005237, 3, 'PW21A-SW100329BL-L', 1, 0, '2021-04-15 13:00:38.665368', '2021-04-15 13:00:38.665368', NULL),
	(10005238, 3, 'PW21A-SW100329BL-XL', 1, 0, '2021-04-15 13:00:38.660839', '2021-04-15 13:00:38.660839', NULL),
	(10005239, 3, 'PW21A-SW100329BL-XXL', 1, 0, '2021-04-15 13:00:38.663249', '2021-04-15 13:00:38.663249', NULL),
	(10005240, 3, 'PW21A-SW100330BL-XS', 0, 0, '2021-04-15 13:00:38.673798', '2021-04-15 13:00:38.673798', NULL),
	(10005241, 3, 'PW21A-SW100330BL-S', 2, 0, '2021-04-15 13:00:38.696667', '2021-04-15 13:00:38.696667', NULL),
	(10005242, 3, 'PW21A-SW100330BL-M', 1, 0, '2021-04-15 13:00:38.730301', '2021-04-15 13:00:38.730301', NULL),
	(10005243, 3, 'PW21A-SW100330BL-L', 1, 0, '2021-04-15 13:00:38.696183', '2021-04-15 13:00:38.696183', NULL),
	(10005244, 3, 'PW21A-SW100330BL-XL', 1, 0, '2021-04-15 13:00:38.701548', '2021-04-15 13:00:38.701548', NULL),
	(10005245, 3, 'PW21A-SW100330BL-XXL', 1, 0, '2021-04-15 13:00:38.697745', '2021-04-15 13:00:38.697745', NULL),
	(10005246, 3, 'PW21A-PN100331BL-28', 0, 0, '2021-04-15 13:00:38.684255', '2021-04-15 13:00:38.684255', NULL),
	(10005247, 3, 'PW21A-PN100331BL-30', 0, 0, '2021-04-15 13:00:38.684920', '2021-04-15 13:00:38.684920', NULL),
	(10005248, 3, 'PW21A-PN100331BL-32', 0, 0, '2021-04-15 13:00:38.698450', '2021-04-15 13:00:38.698450', NULL),
	(10005249, 3, 'PW21A-PN100331BL-34', 0, 0, '2021-04-15 13:00:38.739711', '2021-04-15 13:00:38.739711', NULL),
	(10005250, 3, 'PW21A-PN100331BL-36', 0, 0, '2021-04-15 13:00:38.689702', '2021-04-15 13:00:38.689702', NULL),
	(10005251, 3, 'PW21A-PN100332BL-28', 2, 0, '2021-04-15 13:00:38.733319', '2021-04-15 13:00:38.733319', NULL),
	(10005252, 3, 'PW21A-PN100332BL-30', 3, 0, '2021-04-15 13:00:38.720999', '2021-04-15 13:00:38.720999', NULL),
	(10005253, 3, 'PW21A-PN100332BL-32', 2, 0, '2021-04-15 13:00:38.718144', '2021-04-15 13:00:38.718144', NULL),
	(10005254, 3, 'PW21A-PN100332BL-34', 2, 0, '2021-04-15 13:00:38.769844', '2021-04-15 13:00:38.769844', NULL),
	(10005255, 3, 'PW21A-PN100332BL-36', 0, 0, '2021-04-15 13:00:38.727891', '2021-04-15 13:00:38.727891', NULL),
	(10005256, 3, 'PW21A-PN100333BL-28', 2, 0, '2021-04-15 13:00:38.747242', '2021-04-15 13:00:38.747242', NULL),
	(10005257, 3, 'PW21A-PN100333BL-30', 2, 0, '2021-04-15 13:00:38.729836', '2021-04-15 13:00:38.729836', NULL),
	(10005258, 3, 'PW21A-PN100333BL-32', 2, 0, '2021-04-15 13:00:38.844436', '2021-04-15 13:00:38.844436', NULL),
	(10005259, 3, 'PW21A-PN100333BL-34', 0, 0, '2021-04-15 13:00:38.771767', '2021-04-15 13:00:38.771767', NULL),
	(10005260, 3, 'PW21A-PN100333BL-36', 0, 0, '2021-04-15 13:00:38.742784', '2021-04-15 13:00:38.742784', NULL),
	(10005261, 3, 'PW21A-PN100334BL-28', 0, 0, '2021-04-15 13:00:38.741725', '2021-04-15 13:00:38.741725', NULL),
	(10005262, 3, 'PW21A-PN100334BL-30', 0, 0, '2021-04-15 13:00:38.744927', '2021-04-15 13:00:38.744927', NULL),
	(10005263, 3, 'PW21A-PN100334BL-32', 0, 0, '2021-04-15 13:00:38.730880', '2021-04-15 13:00:38.730880', NULL),
	(10005264, 3, 'PW21A-PN100334BL-34', 0, 0, '2021-04-15 13:00:38.751390', '2021-04-15 13:00:38.751390', NULL),
	(10005265, 3, 'PW21A-PN100334BL-36', 0, 0, '2021-04-15 13:00:38.754650', '2021-04-15 13:00:38.754650', NULL),
	(10005266, 3, 'PW21A-PN100335BL-28', 2, 0, '2021-04-15 13:00:38.757624', '2021-04-15 13:00:38.757624', NULL),
	(10005267, 3, 'PW21A-PN100335BL-30', 2, 0, '2021-04-15 13:00:38.772197', '2021-04-15 13:00:38.772197', NULL),
	(10005268, 3, 'PW21A-PN100335BL-32', 2, 0, '2021-04-15 13:00:38.758041', '2021-04-15 13:00:38.758041', NULL),
	(10005269, 3, 'PW21A-PN100335BL-34', 2, 0, '2021-04-15 13:00:38.764717', '2021-04-15 13:00:38.764717', NULL),
	(10005270, 3, 'PW21A-PN100335BL-36', 1, 0, '2021-04-15 13:00:38.760796', '2021-04-15 13:00:38.760796', NULL),
	(10005271, 3, 'PW21A-PN100336GN-28', 1, 0, '2021-04-15 13:00:38.819811', '2021-04-15 13:00:38.819811', NULL),
	(10005272, 3, 'PW21A-PN100336GN-30', 2, 0, '2021-04-15 13:00:38.769337', '2021-04-15 13:00:38.769337', NULL),
	(10005273, 3, 'PW21A-PN100336GN-32', 2, 0, '2021-04-15 13:00:38.785168', '2021-04-15 13:00:38.785168', NULL),
	(10005274, 3, 'PW21A-PN100336GN-34', 2, 0, '2021-04-15 13:00:38.776304', '2021-04-15 13:00:38.776304', NULL),
	(10005275, 3, 'PW21A-PN100336GN-36', 0, 0, '2021-04-15 13:00:38.784013', '2021-04-15 13:00:38.784013', NULL),
	(10005276, 3, 'PW21A-PN100337CM-28', 2, 0, '2021-04-15 13:00:38.784912', '2021-04-15 13:00:38.784912', NULL),
	(10005277, 3, 'PW21A-PN100337CM-30', 3, 0, '2021-04-15 13:00:38.789214', '2021-04-15 13:00:38.789214', NULL),
	(10005278, 3, 'PW21A-PN100337CM-32', 2, 0, '2021-04-15 13:00:38.799145', '2021-04-15 13:00:38.799145', NULL),
	(10005279, 3, 'PW21A-PN100337CM-34', 2, 0, '2021-04-15 13:00:38.805421', '2021-04-15 13:00:38.805421', NULL),
	(10005280, 3, 'PW21A-PN100337CM-36', 1, 0, '2021-04-15 13:00:38.802372', '2021-04-15 13:00:38.802372', NULL),
	(10005281, 3, 'PW21A-PN100338BL-28', 2, 0, '2021-04-15 13:00:38.818910', '2021-04-15 13:00:38.818910', NULL),
	(10005282, 3, 'PW21A-PN100338BL-30', 1, 0, '2021-04-15 13:00:38.805820', '2021-04-15 13:00:38.805820', NULL),
	(10005283, 3, 'PW21A-PN100338BL-32', 1, 0, '2021-04-15 13:00:38.822683', '2021-04-15 13:00:38.822683', NULL),
	(10005284, 3, 'PW21A-PN100338BL-34', 1, 0, '2021-04-15 13:00:38.804428', '2021-04-15 13:00:38.804428', NULL),
	(10005285, 3, 'PW21A-PN100338BL-36', 1, 0, '2021-04-15 13:00:38.830074', '2021-04-15 13:00:38.830074', NULL),
	(10005286, 3, 'PW21A-PN100339CM-28', 2, 0, '2021-04-15 13:00:38.806669', '2021-04-15 13:00:38.806669', NULL),
	(10005287, 3, 'PW21A-PN100339CM-30', 0, 0, '2021-04-15 13:00:38.826518', '2021-04-15 13:00:38.826518', NULL),
	(10005288, 3, 'PW21A-PN100339CM-32', 1, 0, '2021-04-15 13:00:38.818439', '2021-04-15 13:00:38.818439', NULL),
	(10005289, 3, 'PW21A-PN100339CM-34', 1, 0, '2021-04-15 13:00:38.819372', '2021-04-15 13:00:38.819372', NULL),
	(10005290, 3, 'PW21A-PN100339CM-36', 1, 0, '2021-04-15 13:00:38.829587', '2021-04-15 13:00:38.829587', NULL),
	(10005291, 3, 'PW21A-PN100340OL-28', 2, 0, '2021-04-15 13:00:38.880491', '2021-04-15 13:00:38.880491', NULL),
	(10005292, 3, 'PW21A-PN100340OL-30', 1, 0, '2021-04-15 13:00:38.830507', '2021-04-15 13:00:38.830507', NULL),
	(10005293, 3, 'PW21A-PN100340OL-32', 1, 0, '2021-04-15 13:00:38.845351', '2021-04-15 13:00:38.845351', NULL),
	(10005294, 3, 'PW21A-PN100340OL-34', 1, 0, '2021-04-15 13:00:38.872001', '2021-04-15 13:00:38.872001', NULL),
	(10005295, 3, 'PW21A-PN100340OL-36', 1, 0, '2021-04-15 13:00:38.832214', '2021-04-15 13:00:38.832214', NULL),
	(10005296, 3, 'PW21A-PN100341DM-28', 2, 0, '2021-04-15 13:00:38.923101', '2021-04-15 13:00:38.923101', NULL),
	(10005297, 3, 'PW21A-PN100341DM-30', 2, 0, '2021-04-15 13:00:38.855662', '2021-04-15 13:00:38.855662', NULL),
	(10005298, 3, 'PW21A-PN100341DM-32', 2, 0, '2021-04-15 13:00:38.843205', '2021-04-15 13:00:38.843205', NULL),
	(10005299, 3, 'PW21A-PN100341DM-34', 2, 0, '2021-04-15 13:00:38.847447', '2021-04-15 13:00:38.847447', NULL),
	(10005300, 3, 'PW21A-PN100341DM-36', 0, 0, '2021-04-15 13:00:38.905294', '2021-04-15 13:00:38.905294', NULL),
	(10005301, 3, 'PW21A-PN100342DM-28', 2, 0, '2021-04-15 13:00:38.857216', '2021-04-15 13:00:38.857216', NULL),
	(10005302, 3, 'PW21A-PN100342DM-30', 2, 0, '2021-04-15 13:00:38.844918', '2021-04-15 13:00:38.844918', NULL),
	(10005303, 3, 'PW21A-PN100342DM-32', 2, 0, '2021-04-15 13:00:38.851262', '2021-04-15 13:00:38.851262', NULL),
	(10005304, 3, 'PW21A-PN100342DM-34', 2, 0, '2021-04-15 13:00:38.878043', '2021-04-15 13:00:38.878043', NULL),
	(10005305, 3, 'PW21A-PN100342DM-36', 0, 0, '2021-04-15 13:00:38.870333', '2021-04-15 13:00:38.870333', NULL),
	(10005306, 3, 'PW21A-PN100343DM-28', 2, 0, '2021-04-15 13:00:38.853229', '2021-04-15 13:00:38.853229', NULL),
	(10005307, 3, 'PW21A-PN100343DM-30', 2, 0, '2021-04-15 13:00:38.859717', '2021-04-15 13:00:38.859717', NULL),
	(10005308, 3, 'PW21A-PN100343DM-32', 2, 0, '2021-04-15 13:00:38.869034', '2021-04-15 13:00:38.869034', NULL),
	(10005309, 3, 'PW21A-PN100343DM-34', 2, 0, '2021-04-15 13:00:38.871531', '2021-04-15 13:00:38.871531', NULL),
	(10005310, 3, 'PW21A-PN100343DM-36', 0, 0, '2021-04-15 13:00:38.882301', '2021-04-15 13:00:38.882301', NULL),
	(10005311, 3, 'PW21A-WL100344BW-All', 2, 0, '2021-04-15 13:00:38.955003', '2021-04-15 13:00:38.955003', NULL),
	(10005312, 3, 'PW21A-WL100345BW-All', 2, 0, '2021-04-15 13:00:38.922075', '2021-04-15 13:00:38.922075', NULL),
	(10005313, 3, 'PW21A-WL100346BW-All', 2, 0, '2021-04-15 13:00:38.873965', '2021-04-15 13:00:38.873965', NULL),
	(10005314, 3, 'PW21A-HM100347BL-XS', 0, 0, '2021-04-15 13:00:38.885103', '2021-04-15 13:00:38.885103', NULL),
	(10005315, 3, 'PW21A-HM100347BL-S', 0, 0, '2021-04-15 13:00:38.886777', '2021-04-15 13:00:38.886777', NULL),
	(10005316, 3, 'PW21A-HM100347BL-M', 0, 0, '2021-04-15 13:00:38.910900', '2021-04-15 13:00:38.910900', NULL),
	(10005317, 3, 'PW21A-HM100347BL-L', 1, 0, '2021-04-15 13:00:38.907017', '2021-04-15 13:00:38.907017', NULL),
	(10005318, 3, 'PW21A-HM100347BL-XL', 0, 0, '2021-04-15 13:00:38.918630', '2021-04-15 13:00:38.918630', NULL),
	(10005319, 3, 'PW21A-HM100347BL-XXL', 0, 0, '2021-04-15 13:00:38.903214', '2021-04-15 13:00:38.903214', NULL),
	(10005320, 3, 'PW21A-HM100348WT-XS', 0, 0, '2021-04-15 13:00:38.926072', '2021-04-15 13:00:38.926072', NULL),
	(10005321, 3, 'PW21A-HM100348WT-S', 0, 0, '2021-04-15 13:00:38.913362', '2021-04-15 13:00:38.913362', NULL),
	(10005322, 3, 'PW21A-HM100348WT-M', 0, 0, '2021-04-15 13:00:38.934732', '2021-04-15 13:00:38.934732', NULL),
	(10005323, 3, 'PW21A-HM100348WT-L', 0, 0, '2021-04-15 13:00:38.921608', '2021-04-15 13:00:38.921608', NULL),
	(10005324, 3, 'PW21A-HM100348WT-XL', 0, 0, '2021-04-15 13:00:38.942337', '2021-04-15 13:00:38.942337', NULL),
	(10005325, 3, 'PW21A-HM100348WT-XXL', 0, 0, '2021-04-15 13:00:38.939758', '2021-04-15 13:00:38.939758', NULL),
	(10005326, 3, 'PW21A-HM100349BL-XS', 0, 0, '2021-04-15 13:00:38.977905', '2021-04-15 13:00:38.977905', NULL),
	(10005327, 3, 'PW21A-HM100349BL-S', 0, 0, '2021-04-15 13:00:38.944431', '2021-04-15 13:00:38.944431', NULL),
	(10005328, 3, 'PW21A-HM100349BL-M', 0, 0, '2021-04-15 13:00:38.971923', '2021-04-15 13:00:38.971923', NULL),
	(10005329, 3, 'PW21A-HM100349BL-L', 1, 0, '2021-04-15 13:00:38.950097', '2021-04-15 13:00:38.950097', NULL),
	(10005330, 3, 'PW21A-HM100349BL-XL', 0, 0, '2021-04-15 13:00:39.008139', '2021-04-15 13:00:39.008139', NULL),
	(10005331, 3, 'PW21A-HM100349BL-XXL', 0, 0, '2021-04-15 13:00:38.945722', '2021-04-15 13:00:38.945722', NULL),
	(10005332, 3, 'PW21A-HM100350BL-XS', 0, 0, '2021-04-15 13:00:38.954428', '2021-04-15 13:00:38.954428', NULL),
	(10005333, 3, 'PW21A-HM100350BL-S', 0, 0, '2021-04-15 13:00:38.965902', '2021-04-15 13:00:38.965902', NULL),
	(10005334, 3, 'PW21A-HM100350BL-M', 0, 0, '2021-04-15 13:00:38.951867', '2021-04-15 13:00:38.951867', NULL),
	(10005335, 3, 'PW21A-HM100350BL-L', 0, 0, '2021-04-15 13:00:39.019755', '2021-04-15 13:00:39.019755', NULL),
	(10005336, 3, 'PW21A-HM100350BL-XL', 0, 0, '2021-04-15 13:00:38.970657', '2021-04-15 13:00:38.970657', NULL),
	(10005337, 3, 'PW21A-HM100350BL-XXL', 0, 0, '2021-04-15 13:00:38.960261', '2021-04-15 13:00:38.960261', NULL),
	(10005338, 3, 'PW21A-HM100351BL-XS', 0, 0, '2021-04-15 13:00:38.972451', '2021-04-15 13:00:38.972451', NULL),
	(10005339, 3, 'PW21A-HM100351BL-S', 0, 0, '2021-04-15 13:00:38.994557', '2021-04-15 13:00:38.994557', NULL),
	(10005340, 3, 'PW21A-HM100351BL-M', 0, 0, '2021-04-15 13:00:38.986194', '2021-04-15 13:00:38.986194', NULL),
	(10005341, 3, 'PW21A-HM100351BL-L', 0, 0, '2021-04-15 13:00:38.988728', '2021-04-15 13:00:38.988728', NULL),
	(10005342, 3, 'PW21A-HM100351BL-XL', 0, 0, '2021-04-15 13:00:39.008570', '2021-04-15 13:00:39.008570', NULL),
	(10005343, 3, 'PW21A-HM100351BL-XXL', 0, 0, '2021-04-15 13:00:39.005187', '2021-04-15 13:00:39.005187', NULL),
	(10005344, 3, 'PW21A-HM100352BL-XS', 0, 0, '2021-04-15 13:00:38.983340', '2021-04-15 13:00:38.983340', NULL),
	(10005345, 3, 'PW21A-HM100352BL-S', 0, 0, '2021-04-15 13:00:39.002651', '2021-04-15 13:00:39.002651', NULL),
	(10005346, 3, 'PW21A-HM100352BL-M', 0, 0, '2021-04-15 13:00:38.992627', '2021-04-15 13:00:38.992627', NULL),
	(10005347, 3, 'PW21A-HM100352BL-L', 0, 0, '2021-04-15 13:00:39.104856', '2021-04-15 13:00:39.104856', NULL),
	(10005348, 3, 'PW21A-HM100352BL-XL', 0, 0, '2021-04-15 13:00:39.028332', '2021-04-15 13:00:39.028332', NULL),
	(10005349, 3, 'PW21A-HM100352BL-XXL', 0, 0, '2021-04-15 13:00:39.020862', '2021-04-15 13:00:39.020862', NULL),
	(10005350, 3, 'PW21A-HM100353WT-XS', 0, 0, '2021-04-15 13:00:39.007114', '2021-04-15 13:00:39.007114', NULL),
	(10005351, 3, 'PW21A-HM100353WT-S', 0, 0, '2021-04-15 13:00:39.066007', '2021-04-15 13:00:39.066007', NULL),
	(10005352, 3, 'PW21A-HM100353WT-M', 1, 0, '2021-04-15 13:00:39.016368', '2021-04-15 13:00:39.016368', NULL),
	(10005353, 3, 'PW21A-HM100353WT-L', 0, 0, '2021-04-15 13:00:39.015001', '2021-04-15 13:00:39.015001', NULL),
	(10005354, 3, 'PW21A-HM100353WT-XL', 0, 0, '2021-04-15 13:00:39.031747', '2021-04-15 13:00:39.031747', NULL),
	(10005355, 3, 'PW21A-HM100353WT-XXL', 0, 0, '2021-04-15 13:00:39.078235', '2021-04-15 13:00:39.078235', NULL),
	(10005356, 3, 'PW21A-HM100354WT-XS', 0, 0, '2021-04-15 13:00:39.023619', '2021-04-15 13:00:39.023619', NULL),
	(10005357, 3, 'PW21A-HM100354WT-S', 0, 0, '2021-04-15 13:00:39.034975', '2021-04-15 13:00:39.034975', NULL),
	(10005358, 3, 'PW21A-HM100354WT-M', 1, 0, '2021-04-15 13:00:39.032233', '2021-04-15 13:00:39.032233', NULL),
	(10005359, 3, 'PW21A-HM100354WT-L', 0, 0, '2021-04-15 13:00:39.044988', '2021-04-15 13:00:39.044988', NULL),
	(10005360, 3, 'PW21A-HM100354WT-XL', 0, 0, '2021-04-15 13:00:39.035448', '2021-04-15 13:00:39.035448', NULL),
	(10005361, 3, 'PW21A-HM100354WT-XXL', 0, 0, '2021-04-15 13:00:39.053951', '2021-04-15 13:00:39.053951', NULL),
	(10005362, 3, 'PW21A-HM100355RD-XS', 0, 0, '2021-04-15 13:00:39.046793', '2021-04-15 13:00:39.046793', NULL),
	(10005363, 3, 'PW21A-HM100355RD-S', 0, 0, '2021-04-15 13:00:39.057216', '2021-04-15 13:00:39.057216', NULL),
	(10005364, 3, 'PW21A-HM100355RD-M', 1, 0, '2021-04-15 13:00:39.049535', '2021-04-15 13:00:39.049535', NULL),
	(10005365, 3, 'PW21A-HM100355RD-L', 0, 0, '2021-04-15 13:00:39.050840', '2021-04-15 13:00:39.050840', NULL),
	(10005366, 3, 'PW21A-HM100355RD-XL', 0, 0, '2021-04-15 13:00:39.110194', '2021-04-15 13:00:39.110194', NULL),
	(10005367, 3, 'PW21A-HM100355RD-XXL', 0, 0, '2021-04-15 13:00:39.077221', '2021-04-15 13:00:39.077221', NULL),
	(10005368, 3, 'PW21A-HM100356YW -XS', 0, 0, '2021-04-15 13:00:39.063695', '2021-04-15 13:00:39.063695', NULL),
	(10005369, 3, 'PW21A-HM100356YW -S', 0, 0, '2021-04-15 13:00:39.073501', '2021-04-15 13:00:39.073501', NULL),
	(10005370, 3, 'PW21A-HM100356YW -M', 1, 0, '2021-04-15 13:00:39.064182', '2021-04-15 13:00:39.064182', NULL),
	(10005371, 3, 'PW21A-HM100356YW -L', 0, 0, '2021-04-15 13:00:39.066463', '2021-04-15 13:00:39.066463', NULL),
	(10005372, 3, 'PW21A-HM100356YW -XL', 0, 0, '2021-04-15 13:00:39.075256', '2021-04-15 13:00:39.075256', NULL),
	(10005373, 3, 'PW21A-HM100356YW -XXL', 0, 0, '2021-04-15 13:00:39.134853', '2021-04-15 13:00:39.134853', NULL),
	(10005374, 3, 'PW21A-HM100357YW -XS', 0, 0, '2021-04-15 13:00:39.093720', '2021-04-15 13:00:39.093720', NULL),
	(10005375, 3, 'PW21A-HM100357YW -S', 0, 0, '2021-04-15 13:00:39.095307', '2021-04-15 13:00:39.095307', NULL),
	(10005376, 3, 'PW21A-HM100357YW -M', 1, 0, '2021-04-15 13:00:39.095713', '2021-04-15 13:00:39.095713', NULL),
	(10005377, 3, 'PW21A-HM100357YW -L', 0, 0, '2021-04-15 13:00:39.147165', '2021-04-15 13:00:39.147165', NULL),
	(10005378, 3, 'PW21A-HM100357YW -XL', 0, 0, '2021-04-15 13:00:39.079965', '2021-04-15 13:00:39.079965', NULL),
	(10005379, 3, 'PW21A-HM100357YW -XXL', 0, 0, '2021-04-15 13:00:39.097671', '2021-04-15 13:00:39.097671', NULL),
	(10005380, 3, 'PW21A-HM100358WT-XS', 0, 0, '2021-04-15 13:00:39.080430', '2021-04-15 13:00:39.080430', NULL),
	(10005381, 3, 'PW21A-HM100358WT-S', 0, 0, '2021-04-15 13:00:39.108211', '2021-04-15 13:00:39.108211', NULL),
	(10005382, 3, 'PW21A-HM100358WT-M', 0, 0, '2021-04-15 13:00:39.105556', '2021-04-15 13:00:39.105556', NULL),
	(10005383, 3, 'PW21A-HM100358WT-L', 0, 0, '2021-04-15 13:00:39.129698', '2021-04-15 13:00:39.129698', NULL),
	(10005384, 3, 'PW21A-HM100358WT-XL', 0, 0, '2021-04-15 13:00:39.127654', '2021-04-15 13:00:39.127654', NULL),
	(10005385, 3, 'PW21A-HM100358WT-XXL', 0, 0, '2021-04-15 13:00:39.107058', '2021-04-15 13:00:39.107058', NULL),
	(10005386, 3, 'PW21A-JK100359NV-XS', 0, 0, '2021-04-15 13:00:39.102029', '2021-04-15 13:00:39.102029', NULL),
	(10005387, 3, 'PW21A-JK100359NV-S', 0, 0, '2021-04-15 13:00:39.121437', '2021-04-15 13:00:39.121437', NULL),
	(10005388, 3, 'PW21A-JK100359NV-M', 0, 0, '2021-04-15 13:00:39.119677', '2021-04-15 13:00:39.119677', NULL),
	(10005389, 3, 'PW21A-JK100359NV-L', 0, 0, '2021-04-15 13:00:39.187893', '2021-04-15 13:00:39.187893', NULL),
	(10005390, 3, 'PW21A-JK100359NV-XL', 0, 0, '2021-04-15 13:00:39.132675', '2021-04-15 13:00:39.132675', NULL),
	(10005391, 3, 'PW21A-JK100359NV-XXL', 0, 0, '2021-04-15 13:00:39.121883', '2021-04-15 13:00:39.121883', NULL),
	(10005392, 3, 'PW21A-SH100360DM-XS', 0, 0, '2021-04-15 13:00:39.149066', '2021-04-15 13:00:39.149066', NULL),
	(10005393, 3, 'PW21A-SH100360DM-S', 0, 0, '2021-04-15 13:00:39.123378', '2021-04-15 13:00:39.123378', NULL),
	(10005394, 3, 'PW21A-SH100360DM-M', 0, 0, '2021-04-15 13:00:39.133731', '2021-04-15 13:00:39.133731', NULL),
	(10005395, 3, 'PW21A-SH100360DM-L', 0, 0, '2021-04-15 13:00:39.155572', '2021-04-15 13:00:39.155572', NULL),
	(10005396, 3, 'PW21A-SH100360DM-XL', 0, 0, '2021-04-15 13:00:39.135303', '2021-04-15 13:00:39.135303', NULL),
	(10005397, 3, 'PW21A-SH100360DM-XXL', 0, 0, '2021-04-15 13:00:39.147883', '2021-04-15 13:00:39.147883', NULL),
	(10005398, 3, 'PW21A-SH100361BL-XS', 0, 0, '2021-04-15 13:00:39.159051', '2021-04-15 13:00:39.159051', NULL),
	(10005399, 3, 'PW21A-SH100361BL-S', 0, 0, '2021-04-15 13:00:39.146672', '2021-04-15 13:00:39.146672', NULL),
	(10005400, 3, 'PW21A-SH100361BL-M', 0, 0, '2021-04-15 13:00:39.152253', '2021-04-15 13:00:39.152253', NULL),
	(10005401, 3, 'PW21A-SH100361BL-L', 0, 0, '2021-04-15 13:00:39.162885', '2021-04-15 13:00:39.162885', NULL),
	(10005402, 3, 'PW21A-SH100361BL-XL', 0, 0, '2021-04-15 13:00:39.161183', '2021-04-15 13:00:39.161183', NULL),
	(10005403, 3, 'PW21A-SH100361BL-XXL', 0, 0, '2021-04-15 13:00:39.256527', '2021-04-15 13:00:39.256527', NULL),
	(10005404, 3, 'PW21A-SH100362BL-XS', 0, 0, '2021-04-15 13:00:39.160705', '2021-04-15 13:00:39.160705', NULL),
	(10005405, 3, 'PW21A-SH100362BL-S', 0, 0, '2021-04-15 13:00:39.176112', '2021-04-15 13:00:39.176112', NULL),
	(10005406, 3, 'PW21A-SH100362BL-M', 0, 0, '2021-04-15 13:00:39.174335', '2021-04-15 13:00:39.174335', NULL),
	(10005407, 3, 'PW21A-SH100362BL-L', 0, 0, '2021-04-15 13:00:39.176563', '2021-04-15 13:00:39.176563', NULL),
	(10005408, 3, 'PW21A-SH100362BL-XL', 0, 0, '2021-04-15 13:00:39.174719', '2021-04-15 13:00:39.174719', NULL),
	(10005409, 3, 'PW21A-SH100362BL-XXL', 0, 0, '2021-04-15 13:00:39.172923', '2021-04-15 13:00:39.172923', NULL),
	(10005410, 3, 'PW21A-JK100363BL-XS', 0, 0, '2021-04-15 13:00:39.185225', '2021-04-15 13:00:39.185225', NULL),
	(10005411, 3, 'PW21A-JK100363BL-S', 0, 0, '2021-04-15 13:00:39.187429', '2021-04-15 13:00:39.187429', NULL),
	(10005412, 3, 'PW21A-JK100363BL-M', 0, 0, '2021-04-15 13:00:39.198686', '2021-04-15 13:00:39.198686', NULL),
	(10005413, 3, 'PW21A-JK100363BL-L', 0, 0, '2021-04-15 13:00:39.255847', '2021-04-15 13:00:39.255847', NULL),
	(10005414, 3, 'PW21A-JK100363BL-XL', 0, 0, '2021-04-15 13:00:39.180917', '2021-04-15 13:00:39.180917', NULL),
	(10005415, 3, 'PW21A-JK100363BL-XXL', 0, 0, '2021-04-15 13:00:39.201972', '2021-04-15 13:00:39.201972', NULL),
	(10005416, 3, 'PW21A-SH100364BL-XS', 0, 0, '2021-04-15 13:00:39.199965', '2021-04-15 13:00:39.199965', NULL),
	(10005417, 3, 'PW21A-SH100364BL-S', 0, 0, '2021-04-15 13:00:39.237052', '2021-04-15 13:00:39.237052', NULL),
	(10005418, 3, 'PW21A-SH100364BL-M', 0, 0, '2021-04-15 13:00:39.218294', '2021-04-15 13:00:39.218294', NULL),
	(10005419, 3, 'PW21A-SH100364BL-L', 0, 0, '2021-04-15 13:00:39.199221', '2021-04-15 13:00:39.199221', NULL),
	(10005420, 3, 'PW21A-SH100364BL-XL', 0, 0, '2021-04-15 13:00:39.200500', '2021-04-15 13:00:39.200500', NULL),
	(10005421, 3, 'PW21A-SH100364BL-XXL', 0, 0, '2021-04-15 13:00:39.188321', '2021-04-15 13:00:39.188321', NULL),
	(10005422, 3, 'PW21A-SW100365GY-XS', 0, 0, '2021-04-15 13:00:39.215168', '2021-04-15 13:00:39.215168', NULL),
	(10005423, 3, 'PW21A-SW100365GY-S', 0, 0, '2021-04-15 13:00:39.217387', '2021-04-15 13:00:39.217387', NULL),
	(10005424, 3, 'PW21A-SW100365GY-M', 0, 0, '2021-04-15 13:00:39.217855', '2021-04-15 13:00:39.217855', NULL),
	(10005425, 3, 'PW21A-SW100365GY-L', 0, 0, '2021-04-15 13:00:39.206902', '2021-04-15 13:00:39.206902', NULL),
	(10005426, 3, 'PW21A-SW100365GY-XL', 0, 0, '2021-04-15 13:00:39.230543', '2021-04-15 13:00:39.230543', NULL),
	(10005427, 3, 'PW21A-SW100365GY-XXL', 0, 0, '2021-04-15 13:00:39.229637', '2021-04-15 13:00:39.229637', NULL),
	(10005428, 3, 'PW21A-SW100366GY-XS', 0, 0, '2021-04-15 13:00:39.242008', '2021-04-15 13:00:39.242008', NULL),
	(10005429, 3, 'PW21A-SW100366GY-S', 0, 0, '2021-04-15 13:00:39.243164', '2021-04-15 13:00:39.243164', NULL),
	(10005430, 3, 'PW21A-SW100366GY-M', 0, 0, '2021-04-15 13:00:39.243613', '2021-04-15 13:00:39.243613', NULL),
	(10005431, 3, 'PW21A-SW100366GY-L', 0, 0, '2021-04-15 13:00:39.228793', '2021-04-15 13:00:39.228793', NULL),
	(10005432, 3, 'PW21A-SW100366GY-XL', 0, 0, '2021-04-15 13:00:39.230119', '2021-04-15 13:00:39.230119', NULL),
	(10005433, 3, 'PW21A-SW100366GY-XXL', 0, 0, '2021-04-15 13:00:39.297490', '2021-04-15 13:00:39.297490', NULL),
	(10005434, 3, 'PW21A-SW100367BL-XS', 0, 0, '2021-04-15 13:00:39.233297', '2021-04-15 13:00:39.233297', NULL),
	(10005435, 3, 'PW21A-SW100367BL-S', 0, 0, '2021-04-15 13:00:39.240993', '2021-04-15 13:00:39.240993', NULL),
	(10005436, 3, 'PW21A-SW100367BL-M', 0, 0, '2021-04-15 13:00:39.295515', '2021-04-15 13:00:39.295515', NULL),
	(10005437, 3, 'PW21A-SW100367BL-L', 0, 0, '2021-04-15 13:00:39.255015', '2021-04-15 13:00:39.255015', NULL),
	(10005438, 3, 'PW21A-SW100367BL-XL', 0, 0, '2021-04-15 13:00:39.263030', '2021-04-15 13:00:39.263030', NULL),
	(10005439, 3, 'PW21A-SW100367BL-XXL', 0, 0, '2021-04-15 13:00:39.317254', '2021-04-15 13:00:39.317254', NULL),
	(10005440, 3, 'PW21A-SW100368NV-XS', 0, 0, '2021-04-15 13:00:39.329755', '2021-04-15 13:00:39.329755', NULL),
	(10005441, 3, 'PW21A-SW100368NV-S', 0, 0, '2021-04-15 13:00:39.257728', '2021-04-15 13:00:39.257728', NULL),
	(10005442, 3, 'PW21A-SW100368NV-M', 0, 0, '2021-04-15 13:00:39.259382', '2021-04-15 13:00:39.259382', NULL),
	(10005443, 3, 'PW21A-SW100368NV-L', 0, 0, '2021-04-15 13:00:39.262704', '2021-04-15 13:00:39.262704', NULL),
	(10005444, 3, 'PW21A-SW100368NV-XL', 0, 0, '2021-04-15 13:00:39.259854', '2021-04-15 13:00:39.259854', NULL),
	(10005445, 3, 'PW21A-SW100368NV-XXL', 0, 0, '2021-04-15 13:00:39.262376', '2021-04-15 13:00:39.262376', NULL),
	(10005446, 3, 'PW21A-JK100369BL-XS', 0, 0, '2021-04-15 13:00:39.262030', '2021-04-15 13:00:39.262030', NULL),
	(10005447, 3, 'PW21A-JK100369BL-S', 0, 0, '2021-04-15 13:00:39.290939', '2021-04-15 13:00:39.290939', NULL),
	(10005448, 3, 'PW21A-JK100369BL-M', 0, 0, '2021-04-15 13:00:39.287222', '2021-04-15 13:00:39.287222', NULL),
	(10005449, 3, 'PW21A-JK100369BL-L', 0, 0, '2021-04-15 13:00:39.295103', '2021-04-15 13:00:39.295103', NULL),
	(10005450, 3, 'PW21A-JK100369BL-XL', 0, 0, '2021-04-15 13:00:39.294650', '2021-04-15 13:00:39.294650', NULL),
	(10005451, 3, 'PW21A-JK100369BL-XXL', 0, 0, '2021-04-15 13:00:39.315979', '2021-04-15 13:00:39.315979', NULL),
	(10005452, 3, 'PW21A-SH100370NV-XS', 0, 0, '2021-04-15 13:00:39.296968', '2021-04-15 13:00:39.296968', NULL),
	(10005453, 3, 'PW21A-SH100370NV-S', 0, 0, '2021-04-15 13:00:39.292331', '2021-04-15 13:00:39.292331', NULL),
	(10005454, 3, 'PW21A-SH100370NV-M', 0, 0, '2021-04-15 13:00:39.389357', '2021-04-15 13:00:39.389357', NULL),
	(10005455, 3, 'PW21A-SH100370NV-L', 0, 0, '2021-04-15 13:00:39.297932', '2021-04-15 13:00:39.297932', NULL),
	(10005456, 3, 'PW21A-SH100370NV-XL', 0, 0, '2021-04-15 13:00:39.316349', '2021-04-15 13:00:39.316349', NULL),
	(10005457, 3, 'PW21A-SH100370NV-XXL', 0, 0, '2021-04-15 13:00:39.298340', '2021-04-15 13:00:39.298340', NULL),
	(10005458, 3, 'PW21A-SH100371BL-XS', 0, 0, '2021-04-15 13:00:39.320144', '2021-04-15 13:00:39.320144', NULL),
	(10005459, 3, 'PW21A-SH100371BL-S', 0, 0, '2021-04-15 13:00:39.319625', '2021-04-15 13:00:39.319625', NULL),
	(10005460, 3, 'PW21A-SH100371BL-M', 0, 0, '2021-04-15 13:00:39.360495', '2021-04-15 13:00:39.360495', NULL),
	(10005461, 3, 'PW21A-SH100371BL-L', 0, 0, '2021-04-15 13:00:39.332304', '2021-04-15 13:00:39.332304', NULL),
	(10005462, 3, 'PW21A-SH100371BL-XL', 0, 0, '2021-04-15 13:00:39.321189', '2021-04-15 13:00:39.321189', NULL),
	(10005463, 3, 'PW21A-SH100371BL-XXL', 0, 0, '2021-04-15 13:00:39.330951', '2021-04-15 13:00:39.330951', NULL),
	(10005464, 3, 'PW21A-SH100372DK-XS', 0, 0, '2021-04-15 13:00:39.318674', '2021-04-15 13:00:39.318674', NULL),
	(10005465, 3, 'PW21A-SH100372DK-S', 0, 0, '2021-04-15 13:00:39.358651', '2021-04-15 13:00:39.358651', NULL),
	(10005466, 3, 'PW21A-SH100372DK-M', 0, 0, '2021-04-15 13:00:39.339941', '2021-04-15 13:00:39.339941', NULL),
	(10005467, 3, 'PW21A-SH100372DK-L', 0, 0, '2021-04-15 13:00:39.338306', '2021-04-15 13:00:39.338306', NULL),
	(10005468, 3, 'PW21A-SH100372DK-XL', 0, 0, '2021-04-15 13:00:39.342949', '2021-04-15 13:00:39.342949', NULL),
	(10005469, 3, 'PW21A-SH100372DK-XXL', 0, 0, '2021-04-15 13:00:39.360899', '2021-04-15 13:00:39.360899', NULL),
	(10005470, 3, 'PW21A-SH100373GY-XS', 0, 0, '2021-04-15 13:00:39.342554', '2021-04-15 13:00:39.342554', NULL),
	(10005471, 3, 'PW21A-SH100373GY-S', 0, 0, '2021-04-15 13:00:39.340723', '2021-04-15 13:00:39.340723', NULL),
	(10005472, 3, 'PW21A-SH100373GY-M', 0, 0, '2021-04-15 13:00:39.342129', '2021-04-15 13:00:39.342129', NULL),
	(10005473, 3, 'PW21A-SH100373GY-L', 0, 0, '2021-04-15 13:00:39.419895', '2021-04-15 13:00:39.419895', NULL),
	(10005474, 3, 'PW21A-SH100373GY-XL', 0, 0, '2021-04-15 13:00:39.367825', '2021-04-15 13:00:39.367825', NULL),
	(10005475, 3, 'PW21A-SH100373GY-XXL', 0, 0, '2021-04-15 13:00:39.363457', '2021-04-15 13:00:39.363457', NULL),
	(10005476, 3, 'PW21A-SH100374GY-XS', 0, 0, '2021-04-15 13:00:39.348469', '2021-04-15 13:00:39.348469', NULL),
	(10005477, 3, 'PW21A-SH100374GY-S', 0, 0, '2021-04-15 13:00:39.367060', '2021-04-15 13:00:39.367060', NULL),
	(10005478, 3, 'PW21A-SH100374GY-M', 0, 0, '2021-04-15 13:00:39.395592', '2021-04-15 13:00:39.395592', NULL),
	(10005479, 3, 'PW21A-SH100374GY-L', 0, 0, '2021-04-15 13:00:39.365914', '2021-04-15 13:00:39.365914', NULL),
	(10005480, 3, 'PW21A-SH100374GY-XL', 0, 0, '2021-04-15 13:00:39.382544', '2021-04-15 13:00:39.382544', NULL),
	(10005481, 3, 'PW21A-SH100374GY-XXL', 0, 0, '2021-04-15 13:00:39.370468', '2021-04-15 13:00:39.370468', NULL),
	(10005482, 3, 'PW21A-SH100375BL-XS', 0, 0, '2021-04-15 13:00:39.369441', '2021-04-15 13:00:39.369441', NULL),
	(10005483, 3, 'PW21A-SH100375BL-S', 0, 0, '2021-04-15 13:00:39.385316', '2021-04-15 13:00:39.385316', NULL),
	(10005484, 3, 'PW21A-SH100375BL-M', 0, 0, '2021-04-15 13:00:39.382092', '2021-04-15 13:00:39.382092', NULL),
	(10005485, 3, 'PW21A-SH100375BL-L', 0, 0, '2021-04-15 13:00:39.392379', '2021-04-15 13:00:39.392379', NULL),
	(10005486, 3, 'PW21A-SH100375BL-XL', 0, 0, '2021-04-15 13:00:39.372551', '2021-04-15 13:00:39.372551', NULL),
	(10005487, 3, 'PW21A-SH100375BL-XXL', 0, 0, '2021-04-15 13:00:39.383666', '2021-04-15 13:00:39.383666', NULL),
	(10005488, 3, 'PW21A-SH100376CM-XS', 0, 0, '2021-04-15 13:00:39.397419', '2021-04-15 13:00:39.397419', NULL),
	(10005489, 3, 'PW21A-SH100376CM-S', 0, 0, '2021-04-15 13:00:39.390066', '2021-04-15 13:00:39.390066', NULL),
	(10005490, 3, 'PW21A-SH100376CM-M', 0, 0, '2021-04-15 13:00:39.409061', '2021-04-15 13:00:39.409061', NULL),
	(10005491, 3, 'PW21A-SH100376CM-L', 0, 0, '2021-04-15 13:00:39.408318', '2021-04-15 13:00:39.408318', NULL),
	(10005492, 3, 'PW21A-SH100376CM-XL', 0, 0, '2021-04-15 13:00:39.420349', '2021-04-15 13:00:39.420349', NULL),
	(10005493, 3, 'PW21A-SH100376CM-XXL', 0, 0, '2021-04-15 13:00:39.405677', '2021-04-15 13:00:39.405677', NULL),
	(10005494, 3, 'PW21A-SW100377BL-XS', 0, 0, '2021-04-15 13:00:39.394150', '2021-04-15 13:00:39.394150', NULL),
	(10005495, 3, 'PW21A-SW100377BL-S', 0, 0, '2021-04-15 13:00:39.413906', '2021-04-15 13:00:39.413906', NULL),
	(10005496, 3, 'PW21A-SW100377BL-M', 0, 0, '2021-04-15 13:00:39.414305', '2021-04-15 13:00:39.414305', NULL),
	(10005497, 3, 'PW21A-SW100377BL-L', 0, 0, '2021-04-15 13:00:39.458060', '2021-04-15 13:00:39.458060', NULL),
	(10005498, 3, 'PW21A-SW100377BL-XL', 0, 0, '2021-04-15 13:00:39.445758', '2021-04-15 13:00:39.445758', NULL),
	(10005499, 3, 'PW21A-SW100377BL-XXL', 0, 0, '2021-04-15 13:00:39.436824', '2021-04-15 13:00:39.436824', NULL),
	(10005500, 3, 'PW21A-SW100314DK-XS', 0, 0, '2021-04-15 13:00:39.410819', '2021-04-15 13:00:39.410819', NULL),
	(10005501, 3, 'PW21A-SW100314DK-S', 0, 0, '2021-04-15 13:00:39.434154', '2021-04-15 13:00:39.434154', NULL),
	(10005502, 3, 'PW21A-SW100314DK-M', 0, 0, '2021-04-15 13:00:39.412441', '2021-04-15 13:00:39.412441', NULL),
	(10005503, 3, 'PW21A-SW100314DK-L', 0, 0, '2021-04-15 13:00:39.420788', '2021-04-15 13:00:39.420788', NULL),
	(10005504, 3, 'PW21A-SW100314DK-XL', 0, 0, '2021-04-15 13:00:39.432135', '2021-04-15 13:00:39.432135', NULL),
	(10005505, 3, 'PW21A-SW100314DK-XXL', 0, 0, '2021-04-15 13:00:39.434961', '2021-04-15 13:00:39.434961', NULL),
	(10005506, 3, 'PW21A-SW100379GY-XS', 0, 0, '2021-04-15 13:00:39.437963', '2021-04-15 13:00:39.437963', NULL),
	(10005507, 3, 'PW21A-SW100379GY-S', 0, 0, '2021-04-15 13:00:39.460057', '2021-04-15 13:00:39.460057', NULL),
	(10005508, 3, 'PW21A-SW100379GY-M', 0, 0, '2021-04-15 13:00:39.494552', '2021-04-15 13:00:39.494552', NULL),
	(10005509, 3, 'PW21A-SW100379GY-L', 0, 0, '2021-04-15 13:00:39.439158', '2021-04-15 13:00:39.439158', NULL),
	(10005510, 3, 'PW21A-SW100379GY-XL', 0, 0, '2021-04-15 13:00:39.442933', '2021-04-15 13:00:39.442933', NULL),
	(10005511, 3, 'PW21A-SW100379GY-XXL', 0, 0, '2021-04-15 13:00:39.438405', '2021-04-15 13:00:39.438405', NULL),
	(10005512, 3, 'PW21A-SW100380NV-XS', 0, 0, '2021-04-15 13:00:39.515541', '2021-04-15 13:00:39.515541', NULL),
	(10005513, 3, 'PW21A-SW100380NV-S', 0, 0, '2021-04-15 13:00:39.462062', '2021-04-15 13:00:39.462062', NULL),
	(10005514, 3, 'PW21A-SW100380NV-M', 0, 0, '2021-04-15 13:00:39.446161', '2021-04-15 13:00:39.446161', NULL),
	(10005515, 3, 'PW21A-SW100380NV-L', 0, 0, '2021-04-15 13:00:39.482880', '2021-04-15 13:00:39.482880', NULL),
	(10005516, 3, 'PW21A-SW100380NV-XL', 0, 0, '2021-04-15 13:00:39.462514', '2021-04-15 13:00:39.462514', NULL),
	(10005517, 3, 'PW21A-SW100380NV-XXL', 0, 0, '2021-04-15 13:00:39.460835', '2021-04-15 13:00:39.460835', NULL),
	(10005518, 3, 'PW21A-SW100381BL-XS', 0, 0, '2021-04-15 13:00:39.476190', '2021-04-15 13:00:39.476190', NULL),
	(10005519, 3, 'PW21A-SW100381BL-S', 0, 0, '2021-04-15 13:00:39.465027', '2021-04-15 13:00:39.465027', NULL),
	(10005520, 3, 'PW21A-SW100381BL-M', 0, 0, '2021-04-15 13:00:39.463718', '2021-04-15 13:00:39.463718', NULL),
	(10005521, 3, 'PW21A-SW100381BL-L', 0, 0, '2021-04-15 13:00:39.514150', '2021-04-15 13:00:39.514150', NULL),
	(10005522, 3, 'PW21A-SW100381BL-XL', 0, 0, '2021-04-15 13:00:39.516422', '2021-04-15 13:00:39.516422', NULL),
	(10005523, 3, 'PW21A-SW100381BL-XXL', 0, 0, '2021-04-15 13:00:39.512167', '2021-04-15 13:00:39.512167', NULL),
	(10005524, 4, 'PW21A-AC100001BL-All', 2, 0, '2021-04-15 13:02:46.880863', '2021-04-15 13:02:46.880863', NULL),
	(10005525, 4, 'PW21A-AC100002YW -All', 2, 0, '2021-04-15 13:02:46.879136', '2021-04-15 13:02:46.879136', NULL),
	(10005526, 4, 'PW21A-AC100003BL-All', 2, 0, '2021-04-15 13:02:46.879551', '2021-04-15 13:02:46.879551', NULL),
	(10005527, 4, 'PW21A-AC100004BL-All', 2, 0, '2021-04-15 13:02:46.897001', '2021-04-15 13:02:46.897001', NULL),
	(10005528, 4, 'PW21A-AC100005BL-All', 9, 0, '2021-04-15 13:02:46.986973', '2021-04-15 13:02:46.986973', NULL),
	(10005529, 4, 'PW21A-AC100006BL-All', 0, 0, '2021-04-15 13:02:46.895011', '2021-04-15 13:02:46.895011', NULL),
	(10005530, 4, 'PW21A-AC100007BL-All', 8, 0, '2021-04-15 13:02:46.888942', '2021-04-15 13:02:46.888942', NULL),
	(10005531, 4, 'PW21A-AC100008BL-All', 1, 0, '2021-04-15 13:02:46.880276', '2021-04-15 13:02:46.880276', NULL),
	(10005532, 4, 'PW21A-AC100009BW-All', 2, 0, '2021-04-15 13:02:46.984984', '2021-04-15 13:02:46.984984', NULL),
	(10005533, 4, 'PW21A-AC100010MC-All', 2, 0, '2021-04-15 13:02:46.890527', '2021-04-15 13:02:46.890527', NULL),
	(10005534, 4, 'PW21A-AC100011OG-All', 2, 0, '2021-04-15 13:02:46.921468', '2021-04-15 13:02:46.921468', NULL),
	(10005535, 4, 'PW21A-AC100012BL-All', 1, 0, '2021-04-15 13:02:46.895649', '2021-04-15 13:02:46.895649', NULL),
	(10005536, 4, 'PW21A-AC100013OG-All', 2, 0, '2021-04-15 13:02:46.919047', '2021-04-15 13:02:46.919047', NULL),
	(10005537, 4, 'PW21A-AC100014OL-All', 1, 0, '2021-04-15 13:02:46.935524', '2021-04-15 13:02:46.935524', NULL),
	(10005538, 4, 'PW21A-AC100015MR-All', 2, 0, '2021-04-15 13:02:46.896358', '2021-04-15 13:02:46.896358', NULL),
	(10005539, 4, 'PW21A-AC100016BL-All', 2, 0, '2021-04-15 13:02:46.925418', '2021-04-15 13:02:46.925418', NULL),
	(10005540, 4, 'PW21A-AC100017BL-All', 2, 0, '2021-04-15 13:02:46.920806', '2021-04-15 13:02:46.920806', NULL),
	(10005541, 4, 'PW21A-BG100018WT-All', 1, 0, '2021-04-15 13:02:47.027929', '2021-04-15 13:02:47.027929', NULL),
	(10005542, 4, 'PW21A-BG100019BL-All', 3, 0, '2021-04-15 13:02:46.915758', '2021-04-15 13:02:46.915758', NULL),
	(10005543, 4, 'PW21A-BG100020BL-All', 1, 0, '2021-04-15 13:02:46.943541', '2021-04-15 13:02:46.943541', NULL),
	(10005544, 4, 'PW21A-BG100021BL-All', 0, 0, '2021-04-15 13:02:46.944279', '2021-04-15 13:02:46.944279', NULL),
	(10005545, 4, 'PW21A-BG100022BL-All', 0, 0, '2021-04-15 13:02:46.945348', '2021-04-15 13:02:46.945348', NULL),
	(10005546, 4, 'PW21A-BG100023BL-All', 2, 0, '2021-04-15 13:02:47.011486', '2021-04-15 13:02:47.011486', NULL),
	(10005547, 4, 'PW21A-BG100024BL-All', 0, 0, '2021-04-15 13:02:46.976699', '2021-04-15 13:02:46.976699', NULL),
	(10005548, 4, 'PW21A-BG100025BL-All', 0, 0, '2021-04-15 13:02:46.985703', '2021-04-15 13:02:46.985703', NULL),
	(10005549, 4, 'PW21A-BG100026CM-All', 0, 0, '2021-04-15 13:02:46.948719', '2021-04-15 13:02:46.948719', NULL),
	(10005550, 4, 'PW21A-BG100027CM-All', 0, 0, '2021-04-15 13:02:46.989052', '2021-04-15 13:02:46.989052', NULL),
	(10005551, 4, 'PW21A-BG100028CM-All', 0, 0, '2021-04-15 13:02:47.037595', '2021-04-15 13:02:47.037595', NULL),
	(10005552, 4, 'PW21A-BG100029CM-All', 0, 0, '2021-04-15 13:02:47.015337', '2021-04-15 13:02:47.015337', NULL),
	(10005553, 4, 'PW21A-BG100030BL-All', 2, 0, '2021-04-15 13:02:47.014869', '2021-04-15 13:02:47.014869', NULL),
	(10005554, 4, 'PW21A-BG100031BL-All', 2, 0, '2021-04-15 13:02:47.023914', '2021-04-15 13:02:47.023914', NULL),
	(10005555, 4, 'PW21A-BG100032BL-All', 0, 0, '2021-04-15 13:02:47.014343', '2021-04-15 13:02:47.014343', NULL),
	(10005556, 4, 'PW21A-BG100033BL-All', 0, 0, '2021-04-15 13:02:47.013142', '2021-04-15 13:02:47.013142', NULL),
	(10005557, 4, 'PW21A-BG100034BL-All', 0, 0, '2021-04-15 13:02:47.028457', '2021-04-15 13:02:47.028457', NULL),
	(10005558, 4, 'PW21A-BG100035BL-All', 1, 0, '2021-04-15 13:02:47.064235', '2021-04-15 13:02:47.064235', NULL),
	(10005559, 4, 'PW21A-BG100036BL-All', 0, 0, '2021-04-15 13:02:47.041016', '2021-04-15 13:02:47.041016', NULL),
	(10005560, 4, 'PW21A-BG100037OG-All', 2, 0, '2021-04-15 13:02:47.048692', '2021-04-15 13:02:47.048692', NULL),
	(10005561, 4, 'PW21A-BG100038BL-All', 4, 0, '2021-04-15 13:02:47.030866', '2021-04-15 13:02:47.030866', NULL),
	(10005562, 4, 'PW21A-BG100039GN-All', 2, 0, '2021-04-15 13:02:47.029898', '2021-04-15 13:02:47.029898', NULL),
	(10005563, 4, 'PW21A-BG100040WT-All', 2, 0, '2021-04-15 13:02:47.038424', '2021-04-15 13:02:47.038424', NULL),
	(10005564, 4, 'PW21A-BG100041BL-All', 2, 0, '2021-04-15 13:02:47.107399', '2021-04-15 13:02:47.107399', NULL),
	(10005565, 4, 'PW21A-BG100042BL-All', 2, 0, '2021-04-15 13:02:47.041549', '2021-04-15 13:02:47.041549', NULL),
	(10005566, 4, 'PW21A-BG100043BL-All', 1, 0, '2021-04-15 13:02:47.042099', '2021-04-15 13:02:47.042099', NULL),
	(10005567, 4, 'PW21A-BG100044BL-All', 4, 0, '2021-04-15 13:02:47.052083', '2021-04-15 13:02:47.052083', NULL),
	(10005568, 4, 'PW21A-BG100045BL-All', 2, 0, '2021-04-15 13:02:47.054282', '2021-04-15 13:02:47.054282', NULL),
	(10005569, 4, 'PW21A-BG100046BL-All', 1, 0, '2021-04-15 13:02:47.067690', '2021-04-15 13:02:47.067690', NULL),
	(10005570, 4, 'PW21A-BG100047BL-All', 2, 0, '2021-04-15 13:02:47.051336', '2021-04-15 13:02:47.051336', NULL),
	(10005571, 4, 'PW21A-BG100048BL-All', 2, 0, '2021-04-15 13:02:47.051729', '2021-04-15 13:02:47.051729', NULL),
	(10005572, 4, 'PW21A-BG100049BL-All', 2, 0, '2021-04-15 13:02:47.071154', '2021-04-15 13:02:47.071154', NULL),
	(10005573, 4, 'PW21A-BG100050BL-All', 2, 0, '2021-04-15 13:02:47.083584', '2021-04-15 13:02:47.083584', NULL),
	(10005574, 4, 'PW21A-BG100051BL-All', 2, 0, '2021-04-15 13:02:47.069932', '2021-04-15 13:02:47.069932', NULL),
	(10005575, 4, 'PW21A-BG100052BL-All', 2, 0, '2021-04-15 13:02:47.071654', '2021-04-15 13:02:47.071654', NULL),
	(10005576, 4, 'PW21A-BG100053BL-All', 2, 0, '2021-04-15 13:02:47.084055', '2021-04-15 13:02:47.084055', NULL),
	(10005577, 4, 'PW21A-BG100054BL-All', 2, 0, '2021-04-15 13:02:47.096690', '2021-04-15 13:02:47.096690', NULL),
	(10005578, 4, 'PW21A-GL100055YW -S', 0, 0, '2021-04-15 13:02:47.079972', '2021-04-15 13:02:47.079972', NULL),
	(10005579, 4, 'PW21A-GL100055YW -M', 1, 0, '2021-04-15 13:02:47.088182', '2021-04-15 13:02:47.088182', NULL),
	(10005580, 4, 'PW21A-GL100055YW -L', 1, 0, '2021-04-15 13:02:47.096317', '2021-04-15 13:02:47.096317', NULL),
	(10005581, 4, 'PW21A-GL100055YW -XL', 1, 0, '2021-04-15 13:02:47.154425', '2021-04-15 13:02:47.154425', NULL),
	(10005582, 4, 'PW21A-GL100056BW-S', 1, 0, '2021-04-15 13:02:47.084811', '2021-04-15 13:02:47.084811', NULL),
	(10005583, 4, 'PW21A-GL100056BW-M', 1, 0, '2021-04-15 13:02:47.108965', '2021-04-15 13:02:47.108965', NULL),
	(10005584, 4, 'PW21A-GL100056BW-L', 1, 0, '2021-04-15 13:02:47.092936', '2021-04-15 13:02:47.092936', NULL),
	(10005585, 4, 'PW21A-GL100056BW-XL', 1, 0, '2021-04-15 13:02:47.150831', '2021-04-15 13:02:47.150831', NULL),
	(10005586, 4, 'PW21A-GL100057CM-S', 0, 0, '2021-04-15 13:02:47.107749', '2021-04-15 13:02:47.107749', NULL),
	(10005587, 4, 'PW21A-GL100057CM-M', 1, 0, '2021-04-15 13:02:47.100242', '2021-04-15 13:02:47.100242', NULL),
	(10005588, 4, 'PW21A-GL100057CM-L', 1, 0, '2021-04-15 13:02:47.097163', '2021-04-15 13:02:47.097163', NULL),
	(10005589, 4, 'PW21A-GL100057CM-XL', 1, 0, '2021-04-15 13:02:47.110338', '2021-04-15 13:02:47.110338', NULL),
	(10005590, 4, 'PW21A-GL100058BW-S', 1, 0, '2021-04-15 13:02:47.111573', '2021-04-15 13:02:47.111573', NULL),
	(10005591, 4, 'PW21A-GL100058BW-M', 1, 0, '2021-04-15 13:02:47.140367', '2021-04-15 13:02:47.140367', NULL),
	(10005592, 4, 'PW21A-GL100058BW-L', 1, 0, '2021-04-15 13:02:47.118283', '2021-04-15 13:02:47.118283', NULL),
	(10005593, 4, 'PW21A-GL100058BW-XL', 1, 0, '2021-04-15 13:02:47.126978', '2021-04-15 13:02:47.126978', NULL),
	(10005594, 4, 'PW21A-GL100059BL-S', 1, 0, '2021-04-15 13:02:47.119476', '2021-04-15 13:02:47.119476', NULL),
	(10005595, 4, 'PW21A-GL100059BL-M', 1, 0, '2021-04-15 13:02:47.143357', '2021-04-15 13:02:47.143357', NULL),
	(10005596, 4, 'PW21A-GL100059BL-L', 1, 0, '2021-04-15 13:02:47.143989', '2021-04-15 13:02:47.143989', NULL),
	(10005597, 4, 'PW21A-GL100059BL-XL', 1, 0, '2021-04-15 13:02:47.126357', '2021-04-15 13:02:47.126357', NULL),
	(10005598, 4, 'PW21A-GL100060BL-S', 0, 0, '2021-04-15 13:02:47.120558', '2021-04-15 13:02:47.120558', NULL),
	(10005599, 4, 'PW21A-GL100060BL-M', 1, 0, '2021-04-15 13:02:47.153487', '2021-04-15 13:02:47.153487', NULL),
	(10005600, 4, 'PW21A-GL100060BL-L', 1, 0, '2021-04-15 13:02:47.141640', '2021-04-15 13:02:47.141640', NULL),
	(10005601, 4, 'PW21A-GL100060BL-XL', 1, 0, '2021-04-15 13:02:47.196253', '2021-04-15 13:02:47.196253', NULL),
	(10005602, 4, 'PW21A-GL100061RD-S', 1, 0, '2021-04-15 13:02:47.140973', '2021-04-15 13:02:47.140973', NULL),
	(10005603, 4, 'PW21A-GL100061RD-M', 1, 0, '2021-04-15 13:02:47.175529', '2021-04-15 13:02:47.175529', NULL),
	(10005604, 4, 'PW21A-GL100061RD-L', 1, 0, '2021-04-15 13:02:47.152956', '2021-04-15 13:02:47.152956', NULL),
	(10005605, 4, 'PW21A-GL100061RD-XL', 1, 0, '2021-04-15 13:02:47.153967', '2021-04-15 13:02:47.153967', NULL),
	(10005606, 4, 'PW21A-GL100062WT-S', 0, 0, '2021-04-15 13:02:47.164902', '2021-04-15 13:02:47.164902', NULL),
	(10005607, 4, 'PW21A-GL100062WT-M', 1, 0, '2021-04-15 13:02:47.175986', '2021-04-15 13:02:47.175986', NULL),
	(10005608, 4, 'PW21A-GL100062WT-L', 1, 0, '2021-04-15 13:02:47.163705', '2021-04-15 13:02:47.163705', NULL),
	(10005609, 4, 'PW21A-GL100062WT-XL', 2, 0, '2021-04-15 13:02:47.164439', '2021-04-15 13:02:47.164439', NULL),
	(10005610, 4, 'PW21A-GL100063BW-S', 1, 0, '2021-04-15 13:02:47.174953', '2021-04-15 13:02:47.174953', NULL),
	(10005611, 4, 'PW21A-GL100063BW-M', 1, 0, '2021-04-15 13:02:47.165284', '2021-04-15 13:02:47.165284', NULL),
	(10005612, 4, 'PW21A-GL100063BW-L', 1, 0, '2021-04-15 13:02:47.174558', '2021-04-15 13:02:47.174558', NULL),
	(10005613, 4, 'PW21A-GL100063BW-XL', 1, 0, '2021-04-15 13:02:47.165732', '2021-04-15 13:02:47.165732', NULL),
	(10005614, 4, 'PW21A-GL100064WT-S', 1, 0, '2021-04-15 13:02:47.187065', '2021-04-15 13:02:47.187065', NULL),
	(10005615, 4, 'PW21A-GL100064WT-M', 2, 0, '2021-04-15 13:02:47.176479', '2021-04-15 13:02:47.176479', NULL),
	(10005616, 4, 'PW21A-GL100064WT-L', 2, 0, '2021-04-15 13:02:47.211279', '2021-04-15 13:02:47.211279', NULL),
	(10005617, 4, 'PW21A-GL100064WT-XL', 2, 0, '2021-04-15 13:02:47.184752', '2021-04-15 13:02:47.184752', NULL),
	(10005618, 4, 'PW21A-GL100065BL-S', 1, 0, '2021-04-15 13:02:47.186631', '2021-04-15 13:02:47.186631', NULL),
	(10005619, 4, 'PW21A-GL100065BL-M', 2, 0, '2021-04-15 13:02:47.222620', '2021-04-15 13:02:47.222620', NULL),
	(10005620, 4, 'PW21A-GL100065BL-L', 0, 0, '2021-04-15 13:02:47.198335', '2021-04-15 13:02:47.198335', NULL),
	(10005621, 4, 'PW21A-GL100065BL-XL', 1, 0, '2021-04-15 13:02:47.197605', '2021-04-15 13:02:47.197605', NULL),
	(10005622, 4, 'PW21A-GL100066YW -S', 2, 0, '2021-04-15 13:02:47.188043', '2021-04-15 13:02:47.188043', NULL),
	(10005623, 4, 'PW21A-GL100066YW -M', 1, 0, '2021-04-15 13:02:47.197990', '2021-04-15 13:02:47.197990', NULL),
	(10005624, 4, 'PW21A-GL100066YW -L', 1, 0, '2021-04-15 13:02:47.208534', '2021-04-15 13:02:47.208534', NULL),
	(10005625, 4, 'PW21A-GL100066YW -XL', 1, 0, '2021-04-15 13:02:47.188527', '2021-04-15 13:02:47.188527', NULL),
	(10005626, 4, 'PW21A-GL100067BW-S', 2, 0, '2021-04-15 13:02:47.198807', '2021-04-15 13:02:47.198807', NULL),
	(10005627, 4, 'PW21A-GL100067BW-M', 1, 0, '2021-04-15 13:02:47.208046', '2021-04-15 13:02:47.208046', NULL),
	(10005628, 4, 'PW21A-GL100067BW-L', 1, 0, '2021-04-15 13:02:47.251210', '2021-04-15 13:02:47.251210', NULL),
	(10005629, 4, 'PW21A-GL100067BW-XL', 2, 0, '2021-04-15 13:02:47.219671', '2021-04-15 13:02:47.219671', NULL),
	(10005630, 4, 'PW21A-HT100068BL-All', 2, 0, '2021-04-15 13:02:47.250804', '2021-04-15 13:02:47.250804', NULL),
	(10005631, 4, 'PW21A-HT100069BL-All', 0, 0, '2021-04-15 13:02:47.207646', '2021-04-15 13:02:47.207646', NULL),
	(10005632, 4, 'PW21A-HT100070BL-All', 0, 0, '2021-04-15 13:02:47.222240', '2021-04-15 13:02:47.222240', NULL),
	(10005633, 4, 'PW21A-HT100071BL-All', 0, 0, '2021-04-15 13:02:47.209467', '2021-04-15 13:02:47.209467', NULL),
	(10005634, 4, 'PW21A-HT100072BL-All', 0, 0, '2021-04-15 13:02:47.221853', '2021-04-15 13:02:47.221853', NULL),
	(10005635, 4, 'PW21A-HT100073BL-All', 0, 0, '2021-04-15 13:02:47.234662', '2021-04-15 13:02:47.234662', NULL),
	(10005636, 4, 'PW21A-HT100074BL-All', 0, 0, '2021-04-15 13:02:47.234239', '2021-04-15 13:02:47.234239', NULL),
	(10005637, 4, 'PW21A-HT100075BL-All', 0, 0, '2021-04-15 13:02:47.223903', '2021-04-15 13:02:47.223903', NULL),
	(10005638, 4, 'PW21A-HT100076BL-All', 0, 0, '2021-04-15 13:02:47.232327', '2021-04-15 13:02:47.232327', NULL),
	(10005639, 4, 'PW21A-HT100077BL-All', 2, 0, '2021-04-15 13:02:47.235042', '2021-04-15 13:02:47.235042', NULL),
	(10005640, 4, 'PW21A-HT100078BL-All', 2, 0, '2021-04-15 13:02:47.249495', '2021-04-15 13:02:47.249495', NULL),
	(10005641, 4, 'PW21A-HT100079AR-All', 2, 0, '2021-04-15 13:02:47.249888', '2021-04-15 13:02:47.249888', NULL),
	(10005642, 4, 'PW21A-HT100080BL-All', 2, 0, '2021-04-15 13:02:47.250246', '2021-04-15 13:02:47.250246', NULL),
	(10005643, 4, 'PW21A-HT100081CM-All', 2, 0, '2021-04-15 13:02:47.264260', '2021-04-15 13:02:47.264260', NULL),
	(10005644, 4, 'PW21A-HT100082DS-All', 2, 0, '2021-04-15 13:02:47.233858', '2021-04-15 13:02:47.233858', NULL),
	(10005645, 4, 'PW21A-HT100083CM-All', 2, 0, '2021-04-15 13:02:47.265394', '2021-04-15 13:02:47.265394', NULL),
	(10005646, 4, 'PW21A-HT100084DS-All', 2, 0, '2021-04-15 13:02:47.278790', '2021-04-15 13:02:47.278790', NULL),
	(10005647, 4, 'PW21A-HT100085MR-All', 2, 0, '2021-04-15 13:02:47.289587', '2021-04-15 13:02:47.289587', NULL),
	(10005648, 4, 'PW21A-HT100086NV-All', 2, 0, '2021-04-15 13:02:47.291055', '2021-04-15 13:02:47.291055', NULL),
	(10005649, 4, 'PW21A-HT100087BL-All', 4, 0, '2021-04-15 13:02:47.265870', '2021-04-15 13:02:47.265870', NULL),
	(10005650, 4, 'PW21A-HT100088NV-All', 0, 0, '2021-04-15 13:02:47.266352', '2021-04-15 13:02:47.266352', NULL),
	(10005651, 4, 'PW21A-HT100089RD-All', 0, 0, '2021-04-15 13:02:47.264896', '2021-04-15 13:02:47.264896', NULL),
	(10005652, 4, 'PW21A-HT100090BL-All', 0, 0, '2021-04-15 13:02:47.278283', '2021-04-15 13:02:47.278283', NULL),
	(10005653, 4, 'PW21A-HT100091RD-All', 0, 0, '2021-04-15 13:02:47.279167', '2021-04-15 13:02:47.279167', NULL),
	(10005654, 4, 'PW21A-JK100092BL-XS', 0, 0, '2021-04-15 13:02:47.279606', '2021-04-15 13:02:47.279606', NULL),
	(10005655, 4, 'PW21A-JK100092BL-S', 2, 0, '2021-04-15 13:02:47.279971', '2021-04-15 13:02:47.279971', NULL),
	(10005656, 4, 'PW21A-JK100092BL-M', 1, 0, '2021-04-15 13:02:47.289129', '2021-04-15 13:02:47.289129', NULL),
	(10005657, 4, 'PW21A-JK100092BL-L', 1, 0, '2021-04-15 13:02:47.333815', '2021-04-15 13:02:47.333815', NULL),
	(10005658, 4, 'PW21A-JK100092BL-XL', 2, 0, '2021-04-15 13:02:47.290024', '2021-04-15 13:02:47.290024', NULL),
	(10005659, 4, 'PW21A-JK100092BL-XXL', 1, 0, '2021-04-15 13:02:47.288607', '2021-04-15 13:02:47.288607', NULL),
	(10005660, 4, 'PW21A-JK100093BL-XS', 0, 0, '2021-04-15 13:02:47.322170', '2021-04-15 13:02:47.322170', NULL),
	(10005661, 4, 'PW21A-JK100093BL-S', 0, 0, '2021-04-15 13:02:47.312449', '2021-04-15 13:02:47.312449', NULL),
	(10005662, 4, 'PW21A-JK100093BL-M', 0, 0, '2021-04-15 13:02:47.300264', '2021-04-15 13:02:47.300264', NULL),
	(10005663, 4, 'PW21A-JK100093BL-L', 0, 0, '2021-04-15 13:02:47.299243', '2021-04-15 13:02:47.299243', NULL),
	(10005664, 4, 'PW21A-JK100093BL-XL', 0, 0, '2021-04-15 13:02:47.301516', '2021-04-15 13:02:47.301516', NULL),
	(10005665, 4, 'PW21A-JK100093BL-XXL', 0, 0, '2021-04-15 13:02:47.311397', '2021-04-15 13:02:47.311397', NULL),
	(10005666, 4, 'PW21A-JK100094GY-XS', 0, 0, '2021-04-15 13:02:47.300645', '2021-04-15 13:02:47.300645', NULL),
	(10005667, 4, 'PW21A-JK100094GY-S', 0, 0, '2021-04-15 13:02:47.312087', '2021-04-15 13:02:47.312087', NULL),
	(10005668, 4, 'PW21A-JK100094GY-M', 0, 0, '2021-04-15 13:02:47.301153', '2021-04-15 13:02:47.301153', NULL),
	(10005669, 4, 'PW21A-JK100094GY-L', 0, 0, '2021-04-15 13:02:47.312802', '2021-04-15 13:02:47.312802', NULL),
	(10005670, 4, 'PW21A-JK100094GY-XL', 0, 0, '2021-04-15 13:02:47.358697', '2021-04-15 13:02:47.358697', NULL),
	(10005671, 4, 'PW21A-JK100094GY-XXL', 0, 0, '2021-04-15 13:02:47.314876', '2021-04-15 13:02:47.314876', NULL),
	(10005672, 4, 'PW21A-JK100095AR-XS', 0, 0, '2021-04-15 13:02:47.321812', '2021-04-15 13:02:47.321812', NULL),
	(10005673, 4, 'PW21A-JK100095AR-S', 0, 0, '2021-04-15 13:02:47.323861', '2021-04-15 13:02:47.323861', NULL),
	(10005674, 4, 'PW21A-JK100095AR-M', 0, 0, '2021-04-15 13:02:47.380369', '2021-04-15 13:02:47.380369', NULL),
	(10005675, 4, 'PW21A-JK100095AR-L', 0, 0, '2021-04-15 13:02:47.334489', '2021-04-15 13:02:47.334489', NULL),
	(10005676, 4, 'PW21A-JK100095AR-XL', 0, 0, '2021-04-15 13:02:47.323060', '2021-04-15 13:02:47.323060', NULL),
	(10005677, 4, 'PW21A-JK100095AR-XXL', 0, 0, '2021-04-15 13:02:47.323478', '2021-04-15 13:02:47.323478', NULL),
	(10005678, 4, 'PW21A-JK100096BL-XS', 0, 0, '2021-04-15 13:02:47.333433', '2021-04-15 13:02:47.333433', NULL),
	(10005679, 4, 'PW21A-JK100096BL-S', 0, 0, '2021-04-15 13:02:47.335580', '2021-04-15 13:02:47.335580', NULL),
	(10005680, 4, 'PW21A-JK100096BL-M', 0, 0, '2021-04-15 13:02:47.361509', '2021-04-15 13:02:47.361509', NULL),
	(10005681, 4, 'PW21A-JK100096BL-L', 0, 0, '2021-04-15 13:02:47.343632', '2021-04-15 13:02:47.343632', NULL),
	(10005682, 4, 'PW21A-JK100096BL-XL', 0, 0, '2021-04-15 13:02:47.345029', '2021-04-15 13:02:47.345029', NULL),
	(10005683, 4, 'PW21A-JK100096BL-XXL', 0, 0, '2021-04-15 13:02:47.359631', '2021-04-15 13:02:47.359631', NULL),
	(10005684, 4, 'PW21A-JK100097WT-XS', 2, 0, '2021-04-15 13:02:47.346498', '2021-04-15 13:02:47.346498', NULL),
	(10005685, 4, 'PW21A-JK100097WT-S', 2, 0, '2021-04-15 13:02:47.334147', '2021-04-15 13:02:47.334147', NULL),
	(10005686, 4, 'PW21A-JK100097WT-M', 2, 0, '2021-04-15 13:02:47.344654', '2021-04-15 13:02:47.344654', NULL),
	(10005687, 4, 'PW21A-JK100097WT-L', 2, 0, '2021-04-15 13:02:47.369951', '2021-04-15 13:02:47.369951', NULL),
	(10005688, 4, 'PW21A-JK100097WT-XL', 2, 0, '2021-04-15 13:02:47.361083', '2021-04-15 13:02:47.361083', NULL),
	(10005689, 4, 'PW21A-JK100097WT-XXL', 1, 0, '2021-04-15 13:02:47.373149', '2021-04-15 13:02:47.373149', NULL),
	(10005690, 4, 'PW21A-JK100098BL-XS', 0, 0, '2021-04-15 13:02:47.345358', '2021-04-15 13:02:47.345358', NULL),
	(10005691, 4, 'PW21A-JK100098BL-S', 1, 0, '2021-04-15 13:02:47.371274', '2021-04-15 13:02:47.371274', NULL),
	(10005692, 4, 'PW21A-JK100098BL-M', 2, 0, '2021-04-15 13:02:47.360705', '2021-04-15 13:02:47.360705', NULL),
	(10005693, 4, 'PW21A-JK100098BL-L', 2, 0, '2021-04-15 13:02:47.368158', '2021-04-15 13:02:47.368158', NULL),
	(10005694, 4, 'PW21A-JK100098BL-XL', 2, 0, '2021-04-15 13:02:47.452415', '2021-04-15 13:02:47.452415', NULL),
	(10005695, 4, 'PW21A-JK100098BL-XXL', 0, 0, '2021-04-15 13:02:47.370412', '2021-04-15 13:02:47.370412', NULL),
	(10005696, 4, 'PW21A-JK100099BL-XS', 0, 0, '2021-04-15 13:02:47.382593', '2021-04-15 13:02:47.382593', NULL),
	(10005697, 4, 'PW21A-JK100099BL-S', 0, 0, '2021-04-15 13:02:47.383020', '2021-04-15 13:02:47.383020', NULL),
	(10005698, 4, 'PW21A-JK100099BL-M', 0, 0, '2021-04-15 13:02:47.381527', '2021-04-15 13:02:47.381527', NULL),
	(10005699, 4, 'PW21A-JK100099BL-L', 0, 0, '2021-04-15 13:02:47.383367', '2021-04-15 13:02:47.383367', NULL),
	(10005700, 4, 'PW21A-JK100099BL-XL', 0, 0, '2021-04-15 13:02:47.408384', '2021-04-15 13:02:47.408384', NULL),
	(10005701, 4, 'PW21A-JK100099BL-XXL', 0, 0, '2021-04-15 13:02:47.390173', '2021-04-15 13:02:47.390173', NULL),
	(10005702, 4, 'PW21A-JK100100DM-XS', 0, 0, '2021-04-15 13:02:47.392808', '2021-04-15 13:02:47.392808', NULL),
	(10005703, 4, 'PW21A-JK100100DM-S', 0, 0, '2021-04-15 13:02:47.392441', '2021-04-15 13:02:47.392441', NULL),
	(10005704, 4, 'PW21A-JK100100DM-M', 0, 0, '2021-04-15 13:02:47.433325', '2021-04-15 13:02:47.433325', NULL),
	(10005705, 4, 'PW21A-JK100100DM-L', 0, 0, '2021-04-15 13:02:47.392086', '2021-04-15 13:02:47.392086', NULL),
	(10005706, 4, 'PW21A-JK100100DM-XL', 0, 0, '2021-04-15 13:02:47.394389', '2021-04-15 13:02:47.394389', NULL),
	(10005707, 4, 'PW21A-JK100100DM-XXL', 0, 0, '2021-04-15 13:02:47.407238', '2021-04-15 13:02:47.407238', NULL),
	(10005708, 4, 'PW21A-JK100101NV-XS', 0, 0, '2021-04-15 13:02:47.409520', '2021-04-15 13:02:47.409520', NULL),
	(10005709, 4, 'PW21A-JK100101NV-S', 0, 0, '2021-04-15 13:02:47.424760', '2021-04-15 13:02:47.424760', NULL),
	(10005710, 4, 'PW21A-JK100101NV-M', 0, 0, '2021-04-15 13:02:47.409884', '2021-04-15 13:02:47.409884', NULL),
	(10005711, 4, 'PW21A-JK100101NV-L', 0, 0, '2021-04-15 13:02:47.407595', '2021-04-15 13:02:47.407595', NULL),
	(10005712, 4, 'PW21A-JK100101NV-XL', 0, 0, '2021-04-15 13:02:47.432222', '2021-04-15 13:02:47.432222', NULL),
	(10005713, 4, 'PW21A-JK100101NV-XXL', 0, 0, '2021-04-15 13:02:47.418920', '2021-04-15 13:02:47.418920', NULL),
	(10005714, 4, 'PW21A-JK100102BW-XS', 0, 0, '2021-04-15 13:02:47.428730', '2021-04-15 13:02:47.428730', NULL),
	(10005715, 4, 'PW21A-JK100102BW-S', 0, 0, '2021-04-15 13:02:47.421653', '2021-04-15 13:02:47.421653', NULL),
	(10005716, 4, 'PW21A-JK100102BW-M', 0, 0, '2021-04-15 13:02:47.419338', '2021-04-15 13:02:47.419338', NULL),
	(10005717, 4, 'PW21A-JK100102BW-L', 0, 0, '2021-04-15 13:02:47.441817', '2021-04-15 13:02:47.441817', NULL),
	(10005718, 4, 'PW21A-JK100102BW-XL', 0, 0, '2021-04-15 13:02:47.417356', '2021-04-15 13:02:47.417356', NULL),
	(10005719, 4, 'PW21A-JK100102BW-XXL', 0, 0, '2021-04-15 13:02:47.429889', '2021-04-15 13:02:47.429889', NULL),
	(10005720, 4, 'PW21A-JK100103BL-XS', 0, 0, '2021-04-15 13:02:47.448634', '2021-04-15 13:02:47.448634', NULL),
	(10005721, 4, 'PW21A-JK100103BL-S', 0, 0, '2021-04-15 13:02:47.472984', '2021-04-15 13:02:47.472984', NULL),
	(10005722, 4, 'PW21A-JK100103BL-M', 0, 0, '2021-04-15 13:02:47.430997', '2021-04-15 13:02:47.430997', NULL),
	(10005723, 4, 'PW21A-JK100103BL-L', 0, 0, '2021-04-15 13:02:47.440963', '2021-04-15 13:02:47.440963', NULL),
	(10005724, 4, 'PW21A-JK100103BL-XL', 0, 0, '2021-04-15 13:02:47.478003', '2021-04-15 13:02:47.478003', NULL),
	(10005725, 4, 'PW21A-JK100103BL-XXL', 0, 0, '2021-04-15 13:02:47.442876', '2021-04-15 13:02:47.442876', NULL),
	(10005726, 4, 'PW21A-JK100104BL-XS', 0, 0, '2021-04-15 13:02:47.450819', '2021-04-15 13:02:47.450819', NULL),
	(10005727, 4, 'PW21A-JK100104BL-S', 2, 0, '2021-04-15 13:02:47.443913', '2021-04-15 13:02:47.443913', NULL),
	(10005728, 4, 'PW21A-JK100104BL-M', 2, 0, '2021-04-15 13:02:47.454886', '2021-04-15 13:02:47.454886', NULL),
	(10005729, 4, 'PW21A-JK100104BL-L', 1, 0, '2021-04-15 13:02:47.456595', '2021-04-15 13:02:47.456595', NULL),
	(10005730, 4, 'PW21A-JK100104BL-XL', 2, 0, '2021-04-15 13:02:47.506320', '2021-04-15 13:02:47.506320', NULL),
	(10005731, 4, 'PW21A-JK100104BL-XXL', 0, 0, '2021-04-15 13:02:47.471004', '2021-04-15 13:02:47.471004', NULL),
	(10005732, 4, 'PW21A-JK100105TC-XS', 0, 0, '2021-04-15 13:02:47.473578', '2021-04-15 13:02:47.473578', NULL),
	(10005733, 4, 'PW21A-JK100105TC-S', 0, 0, '2021-04-15 13:02:47.454390', '2021-04-15 13:02:47.454390', NULL),
	(10005734, 4, 'PW21A-JK100105TC-M', 0, 0, '2021-04-15 13:02:47.472600', '2021-04-15 13:02:47.472600', NULL),
	(10005735, 4, 'PW21A-JK100105TC-L', 0, 0, '2021-04-15 13:02:47.496294', '2021-04-15 13:02:47.496294', NULL),
	(10005736, 4, 'PW21A-JK100105TC-XL', 0, 0, '2021-04-15 13:02:47.492583', '2021-04-15 13:02:47.492583', NULL),
	(10005737, 4, 'PW21A-JK100105TC-XXL', 0, 0, '2021-04-15 13:02:47.480367', '2021-04-15 13:02:47.480367', NULL),
	(10005738, 4, 'PW21A-JK100106BL-XS', 0, 0, '2021-04-15 13:02:47.484719', '2021-04-15 13:02:47.484719', NULL),
	(10005739, 4, 'PW21A-JK100106BL-S', 2, 0, '2021-04-15 13:02:47.485980', '2021-04-15 13:02:47.485980', NULL),
	(10005740, 4, 'PW21A-JK100106BL-M', 2, 0, '2021-04-15 13:02:47.494931', '2021-04-15 13:02:47.494931', NULL),
	(10005741, 4, 'PW21A-JK100106BL-L', 2, 0, '2021-04-15 13:02:47.483221', '2021-04-15 13:02:47.483221', NULL),
	(10005742, 4, 'PW21A-JK100106BL-XL', 2, 0, '2021-04-15 13:02:47.485087', '2021-04-15 13:02:47.485087', NULL),
	(10005743, 4, 'PW21A-JK100106BL-XXL', 1, 0, '2021-04-15 13:02:47.533485', '2021-04-15 13:02:47.533485', NULL),
	(10005744, 4, 'PW21A-JK100107BL-XS', 0, 0, '2021-04-15 13:02:47.502502', '2021-04-15 13:02:47.502502', NULL),
	(10005745, 4, 'PW21A-JK100107BL-S', 0, 0, '2021-04-15 13:02:47.505343', '2021-04-15 13:02:47.505343', NULL),
	(10005746, 4, 'PW21A-JK100107BL-M', 0, 0, '2021-04-15 13:02:47.508493', '2021-04-15 13:02:47.508493', NULL),
	(10005747, 4, 'PW21A-JK100107BL-L', 0, 0, '2021-04-15 13:02:47.495538', '2021-04-15 13:02:47.495538', NULL),
	(10005748, 4, 'PW21A-JK100107BL-XL', 0, 0, '2021-04-15 13:02:47.516545', '2021-04-15 13:02:47.516545', NULL),
	(10005749, 4, 'PW21A-JK100107BL-XXL', 0, 0, '2021-04-15 13:02:47.499345', '2021-04-15 13:02:47.499345', NULL),
	(10005750, 4, 'PW21A-JK100108BL-XS', 0, 0, '2021-04-15 13:02:47.516914', '2021-04-15 13:02:47.516914', NULL),
	(10005751, 4, 'PW21A-JK100108BL-S', 2, 0, '2021-04-15 13:02:47.518509', '2021-04-15 13:02:47.518509', NULL),
	(10005752, 4, 'PW21A-JK100108BL-M', 1, 0, '2021-04-15 13:02:47.529139', '2021-04-15 13:02:47.529139', NULL),
	(10005753, 4, 'PW21A-JK100108BL-L', 1, 0, '2021-04-15 13:02:47.508858', '2021-04-15 13:02:47.508858', NULL),
	(10005754, 4, 'PW21A-JK100108BL-XL', 2, 0, '2021-04-15 13:02:47.584240', '2021-04-15 13:02:47.584240', NULL),
	(10005755, 4, 'PW21A-JK100108BL-XXL', 1, 0, '2021-04-15 13:02:47.521791', '2021-04-15 13:02:47.521791', NULL),
	(10005756, 4, 'PW21A-JK100109BL-XS', 0, 0, '2021-04-15 13:02:47.529484', '2021-04-15 13:02:47.529484', NULL),
	(10005757, 4, 'PW21A-JK100109BL-S', 0, 0, '2021-04-15 13:02:47.519077', '2021-04-15 13:02:47.519077', NULL),
	(10005758, 4, 'PW21A-JK100109BL-M', 0, 0, '2021-04-15 13:02:47.522688', '2021-04-15 13:02:47.522688', NULL),
	(10005759, 4, 'PW21A-JK100109BL-L', 0, 0, '2021-04-15 13:02:47.544746', '2021-04-15 13:02:47.544746', NULL),
	(10005760, 4, 'PW21A-JK100109BL-XL', 0, 0, '2021-04-15 13:02:47.554918', '2021-04-15 13:02:47.554918', NULL),
	(10005761, 4, 'PW21A-JK100109BL-XXL', 0, 0, '2021-04-15 13:02:47.540067', '2021-04-15 13:02:47.540067', NULL),
	(10005762, 4, 'PW21A-JK100110BL-XS', 2, 0, '2021-04-15 13:02:47.532988', '2021-04-15 13:02:47.532988', NULL),
	(10005763, 4, 'PW21A-JK100110BL-S', 2, 0, '2021-04-15 13:02:47.538372', '2021-04-15 13:02:47.538372', NULL),
	(10005764, 4, 'PW21A-JK100110BL-M', 2, 0, '2021-04-15 13:02:47.540413', '2021-04-15 13:02:47.540413', NULL),
	(10005765, 4, 'PW21A-JK100110BL-L', 2, 0, '2021-04-15 13:02:47.545738', '2021-04-15 13:02:47.545738', NULL),
	(10005766, 4, 'PW21A-JK100110BL-XL', 2, 0, '2021-04-15 13:02:47.557206', '2021-04-15 13:02:47.557206', NULL),
	(10005767, 4, 'PW21A-JK100110BL-XXL', 1, 0, '2021-04-15 13:02:47.555849', '2021-04-15 13:02:47.555849', NULL),
	(10005768, 4, 'PW21A-JK100111BL-XS', 0, 0, '2021-04-15 13:02:47.543139', '2021-04-15 13:02:47.543139', NULL),
	(10005769, 4, 'PW21A-JK100111BL-S', 0, 0, '2021-04-15 13:02:47.558470', '2021-04-15 13:02:47.558470', NULL),
	(10005770, 4, 'PW21A-JK100111BL-M', 0, 0, '2021-04-15 13:02:47.562169', '2021-04-15 13:02:47.562169', NULL),
	(10005771, 4, 'PW21A-JK100111BL-L', 0, 0, '2021-04-15 13:02:47.566094', '2021-04-15 13:02:47.566094', NULL),
	(10005772, 4, 'PW21A-JK100111BL-XL', 0, 0, '2021-04-15 13:02:47.568182', '2021-04-15 13:02:47.568182', NULL),
	(10005773, 4, 'PW21A-JK100111BL-XXL', 0, 0, '2021-04-15 13:02:47.614107', '2021-04-15 13:02:47.614107', NULL),
	(10005774, 4, 'PW21A-JK100112CM-XS', 0, 0, '2021-04-15 13:02:47.563032', '2021-04-15 13:02:47.563032', NULL),
	(10005775, 4, 'PW21A-JK100112CM-S', 0, 0, '2021-04-15 13:02:47.585397', '2021-04-15 13:02:47.585397', NULL),
	(10005776, 4, 'PW21A-JK100112CM-M', 0, 0, '2021-04-15 13:02:47.583494', '2021-04-15 13:02:47.583494', NULL),
	(10005777, 4, 'PW21A-JK100112CM-L', 0, 0, '2021-04-15 13:02:47.564763', '2021-04-15 13:02:47.564763', NULL),
	(10005778, 4, 'PW21A-JK100112CM-XL', 0, 0, '2021-04-15 13:02:47.609917', '2021-04-15 13:02:47.609917', NULL),
	(10005779, 4, 'PW21A-JK100112CM-XXL', 0, 0, '2021-04-15 13:02:47.569132', '2021-04-15 13:02:47.569132', NULL),
	(10005780, 4, 'PW21A-JK100113CM-XS', 0, 0, '2021-04-15 13:02:47.588811', '2021-04-15 13:02:47.588811', NULL),
	(10005781, 4, 'PW21A-JK100113CM-S', 0, 0, '2021-04-15 13:02:47.591990', '2021-04-15 13:02:47.591990', NULL),
	(10005782, 4, 'PW21A-JK100113CM-M', 0, 0, '2021-04-15 13:02:47.590196', '2021-04-15 13:02:47.590196', NULL),
	(10005783, 4, 'PW21A-JK100113CM-L', 0, 0, '2021-04-15 13:02:47.583900', '2021-04-15 13:02:47.583900', NULL),
	(10005784, 4, 'PW21A-JK100113CM-XL', 0, 0, '2021-04-15 13:02:47.609542', '2021-04-15 13:02:47.609542', NULL),
	(10005785, 4, 'PW21A-JK100113CM-XXL', 0, 0, '2021-04-15 13:02:47.594850', '2021-04-15 13:02:47.594850', NULL),
	(10005786, 4, 'PW21A-JK100114CM-XS', 0, 0, '2021-04-15 13:02:47.594000', '2021-04-15 13:02:47.594000', NULL),
	(10005787, 4, 'PW21A-JK100114CM-S', 0, 0, '2021-04-15 13:02:47.589625', '2021-04-15 13:02:47.589625', NULL),
	(10005788, 4, 'PW21A-JK100114CM-M', 0, 0, '2021-04-15 13:02:47.622478', '2021-04-15 13:02:47.622478', NULL),
	(10005789, 4, 'PW21A-JK100114CM-L', 0, 0, '2021-04-15 13:02:47.614604', '2021-04-15 13:02:47.614604', NULL),
	(10005790, 4, 'PW21A-JK100114CM-XL', 0, 0, '2021-04-15 13:02:47.618882', '2021-04-15 13:02:47.618882', NULL),
	(10005791, 4, 'PW21A-JK100114CM-XXL', 0, 0, '2021-04-15 13:02:47.611264', '2021-04-15 13:02:47.611264', NULL),
	(10005792, 4, 'PW21A-JK100115DM-XS', 0, 0, '2021-04-15 13:02:47.613582', '2021-04-15 13:02:47.613582', NULL),
	(10005793, 4, 'PW21A-JK100115DM-S', 0, 0, '2021-04-15 13:02:47.624422', '2021-04-15 13:02:47.624422', NULL),
	(10005794, 4, 'PW21A-JK100115DM-M', 0, 0, '2021-04-15 13:02:47.644058', '2021-04-15 13:02:47.644058', NULL),
	(10005795, 4, 'PW21A-JK100115DM-L', 0, 0, '2021-04-15 13:02:47.621744', '2021-04-15 13:02:47.621744', NULL),
	(10005796, 4, 'PW21A-JK100115DM-XL', 0, 0, '2021-04-15 13:02:47.634950', '2021-04-15 13:02:47.634950', NULL),
	(10005797, 4, 'PW21A-JK100115DM-XXL', 0, 0, '2021-04-15 13:02:47.643139', '2021-04-15 13:02:47.643139', NULL),
	(10005798, 4, 'PW21A-JK100116RD-XS', 0, 0, '2021-04-15 13:02:47.730345', '2021-04-15 13:02:47.730345', NULL),
	(10005799, 4, 'PW21A-JK100116RD-S', 0, 0, '2021-04-15 13:02:47.700798', '2021-04-15 13:02:47.700798', NULL),
	(10005800, 4, 'PW21A-JK100116RD-M', 0, 0, '2021-04-15 13:02:47.645401', '2021-04-15 13:02:47.645401', NULL),
	(10005801, 4, 'PW21A-JK100116RD-L', 0, 0, '2021-04-15 13:02:47.644576', '2021-04-15 13:02:47.644576', NULL),
	(10005802, 4, 'PW21A-JK100116RD-XL', 0, 0, '2021-04-15 13:02:47.643613', '2021-04-15 13:02:47.643613', NULL),
	(10005803, 4, 'PW21A-JK100116RD-XXL', 0, 0, '2021-04-15 13:02:47.646524', '2021-04-15 13:02:47.646524', NULL),
	(10005804, 4, 'PW21A-JK100117BL-XS', 0, 0, '2021-04-15 13:02:47.645989', '2021-04-15 13:02:47.645989', NULL),
	(10005805, 4, 'PW21A-JK100117BL-S', 0, 0, '2021-04-15 13:02:47.660071', '2021-04-15 13:02:47.660071', NULL),
	(10005806, 4, 'PW21A-JK100117BL-M', 0, 0, '2021-04-15 13:02:47.661160', '2021-04-15 13:02:47.661160', NULL),
	(10005807, 4, 'PW21A-JK100117BL-L', 0, 0, '2021-04-15 13:02:47.659622', '2021-04-15 13:02:47.659622', NULL),
	(10005808, 4, 'PW21A-JK100117BL-XL', 0, 0, '2021-04-15 13:02:47.667700', '2021-04-15 13:02:47.667700', NULL),
	(10005809, 4, 'PW21A-JK100117BL-XXL', 0, 0, '2021-04-15 13:02:47.669702', '2021-04-15 13:02:47.669702', NULL),
	(10005810, 4, 'PW21A-JK100118AR-XS', 0, 0, '2021-04-15 13:02:47.672903', '2021-04-15 13:02:47.672903', NULL),
	(10005811, 4, 'PW21A-JK100118AR-S', 2, 0, '2021-04-15 13:02:47.671221', '2021-04-15 13:02:47.671221', NULL),
	(10005812, 4, 'PW21A-JK100118AR-M', 2, 0, '2021-04-15 13:02:47.671697', '2021-04-15 13:02:47.671697', NULL),
	(10005813, 4, 'PW21A-JK100118AR-L', 2, 0, '2021-04-15 13:02:47.673392', '2021-04-15 13:02:47.673392', NULL),
	(10005814, 4, 'PW21A-JK100118AR-XL', 2, 0, '2021-04-15 13:02:47.673867', '2021-04-15 13:02:47.673867', NULL),
	(10005815, 4, 'PW21A-JK100118AR-XXL', 1, 0, '2021-04-15 13:02:47.686479', '2021-04-15 13:02:47.686479', NULL),
	(10005816, 4, 'PW21A-JK100119BL-XS', 0, 0, '2021-04-15 13:02:47.694909', '2021-04-15 13:02:47.694909', NULL),
	(10005817, 4, 'PW21A-JK100119BL-S', 2, 0, '2021-04-15 13:02:47.701800', '2021-04-15 13:02:47.701800', NULL),
	(10005818, 4, 'PW21A-JK100119BL-M', 2, 0, '2021-04-15 13:02:47.687830', '2021-04-15 13:02:47.687830', NULL),
	(10005819, 4, 'PW21A-JK100119BL-L', 2, 0, '2021-04-15 13:02:47.703501', '2021-04-15 13:02:47.703501', NULL),
	(10005820, 4, 'PW21A-JK100119BL-XL', 2, 0, '2021-04-15 13:02:47.685955', '2021-04-15 13:02:47.685955', NULL),
	(10005821, 4, 'PW21A-JK100119BL-XXL', 1, 0, '2021-04-15 13:02:47.704331', '2021-04-15 13:02:47.704331', NULL),
	(10005822, 4, 'PW21A-JK100120BL-XS', 2, 0, '2021-04-15 13:02:47.703018', '2021-04-15 13:02:47.703018', NULL),
	(10005823, 4, 'PW21A-JK100120BL-S', 2, 0, '2021-04-15 13:02:47.725407', '2021-04-15 13:02:47.725407', NULL),
	(10005824, 4, 'PW21A-JK100120BL-M', 2, 0, '2021-04-15 13:02:47.764650', '2021-04-15 13:02:47.764650', NULL),
	(10005825, 4, 'PW21A-JK100120BL-L', 2, 0, '2021-04-15 13:02:47.722151', '2021-04-15 13:02:47.722151', NULL),
	(10005826, 4, 'PW21A-JK100120BL-XL', 2, 0, '2021-04-15 13:02:47.721585', '2021-04-15 13:02:47.721585', NULL),
	(10005827, 4, 'PW21A-JK100120BL-XXL', 1, 0, '2021-04-15 13:02:47.735213', '2021-04-15 13:02:47.735213', NULL),
	(10005828, 4, 'PW21A-JK100121MR-XS', 0, 0, '2021-04-15 13:02:47.703970', '2021-04-15 13:02:47.703970', NULL),
	(10005829, 4, 'PW21A-JK100121MR-S', 2, 0, '2021-04-15 13:02:47.779759', '2021-04-15 13:02:47.779759', NULL),
	(10005830, 4, 'PW21A-JK100121MR-M', 2, 0, '2021-04-15 13:02:47.736337', '2021-04-15 13:02:47.736337', NULL),
	(10005831, 4, 'PW21A-JK100121MR-L', 2, 0, '2021-04-15 13:02:47.734641', '2021-04-15 13:02:47.734641', NULL),
	(10005832, 4, 'PW21A-JK100121MR-XL', 2, 0, '2021-04-15 13:02:47.738817', '2021-04-15 13:02:47.738817', NULL),
	(10005833, 4, 'PW21A-JK100121MR-XXL', 1, 0, '2021-04-15 13:02:47.738255', '2021-04-15 13:02:47.738255', NULL),
	(10005834, 4, 'PW21A-JK100122RD-XS', 0, 0, '2021-04-15 13:02:47.751223', '2021-04-15 13:02:47.751223', NULL),
	(10005835, 4, 'PW21A-JK100122RD-S', 0, 0, '2021-04-15 13:02:47.731465', '2021-04-15 13:02:47.731465', NULL),
	(10005836, 4, 'PW21A-JK100122RD-M', 0, 0, '2021-04-15 13:02:47.759492', '2021-04-15 13:02:47.759492', NULL),
	(10005837, 4, 'PW21A-JK100122RD-L', 0, 0, '2021-04-15 13:02:47.747649', '2021-04-15 13:02:47.747649', NULL),
	(10005838, 4, 'PW21A-JK100122RD-XL', 0, 0, '2021-04-15 13:02:47.753241', '2021-04-15 13:02:47.753241', NULL),
	(10005839, 4, 'PW21A-JK100122RD-XXL', 0, 0, '2021-04-15 13:02:47.757236', '2021-04-15 13:02:47.757236', NULL),
	(10005840, 4, 'PW21A-JK100123BL-XS', 0, 0, '2021-04-15 13:02:47.759899', '2021-04-15 13:02:47.759899', NULL),
	(10005841, 4, 'PW21A-JK100123BL-S', 0, 0, '2021-04-15 13:02:47.764143', '2021-04-15 13:02:47.764143', NULL),
	(10005842, 4, 'PW21A-JK100123BL-M', 0, 0, '2021-04-15 13:02:47.761091', '2021-04-15 13:02:47.761091', NULL),
	(10005843, 4, 'PW21A-JK100123BL-L', 0, 0, '2021-04-15 13:02:47.798768', '2021-04-15 13:02:47.798768', NULL),
	(10005844, 4, 'PW21A-JK100123BL-XL', 0, 0, '2021-04-15 13:02:47.776224', '2021-04-15 13:02:47.776224', NULL),
	(10005845, 4, 'PW21A-JK100123BL-XXL', 0, 0, '2021-04-15 13:02:47.767498', '2021-04-15 13:02:47.767498', NULL),
	(10005846, 4, 'PW21A-JK100124BL-XS', 0, 0, '2021-04-15 13:02:47.788901', '2021-04-15 13:02:47.788901', NULL),
	(10005847, 4, 'PW21A-JK100124BL-S', 0, 0, '2021-04-15 13:02:47.794565', '2021-04-15 13:02:47.794565', NULL),
	(10005848, 4, 'PW21A-JK100124BL-M', 0, 0, '2021-04-15 13:02:47.817636', '2021-04-15 13:02:47.817636', NULL),
	(10005849, 4, 'PW21A-JK100124BL-L', 0, 0, '2021-04-15 13:02:47.786106', '2021-04-15 13:02:47.786106', NULL),
	(10005850, 4, 'PW21A-JK100124BL-XL', 0, 0, '2021-04-15 13:02:47.792347', '2021-04-15 13:02:47.792347', NULL),
	(10005851, 4, 'PW21A-JK100124BL-XXL', 0, 0, '2021-04-15 13:02:47.795693', '2021-04-15 13:02:47.795693', NULL),
	(10005852, 4, 'PW21A-JK100125AR-XS', 0, 0, '2021-04-15 13:02:47.804944', '2021-04-15 13:02:47.804944', NULL),
	(10005853, 4, 'PW21A-JK100125AR-S', 0, 0, '2021-04-15 13:02:47.793941', '2021-04-15 13:02:47.793941', NULL),
	(10005854, 4, 'PW21A-JK100125AR-M', 0, 0, '2021-04-15 13:02:47.797925', '2021-04-15 13:02:47.797925', NULL),
	(10005855, 4, 'PW21A-JK100125AR-L', 0, 0, '2021-04-15 13:02:47.810926', '2021-04-15 13:02:47.810926', NULL),
	(10005856, 4, 'PW21A-JK100125AR-XL', 0, 0, '2021-04-15 13:02:47.814371', '2021-04-15 13:02:47.814371', NULL),
	(10005857, 4, 'PW21A-JK100125AR-XXL', 0, 0, '2021-04-15 13:02:47.833900', '2021-04-15 13:02:47.833900', NULL),
	(10005858, 4, 'PW21A-JK100126BL-XS', 0, 0, '2021-04-15 13:02:47.818282', '2021-04-15 13:02:47.818282', NULL),
	(10005859, 4, 'PW21A-JK100126BL-S', 1, 0, '2021-04-15 13:02:47.807976', '2021-04-15 13:02:47.807976', NULL),
	(10005860, 4, 'PW21A-JK100126BL-M', 2, 0, '2021-04-15 13:02:47.815717', '2021-04-15 13:02:47.815717', NULL),
	(10005861, 4, 'PW21A-JK100126BL-L', 2, 0, '2021-04-15 13:02:47.858964', '2021-04-15 13:02:47.858964', NULL),
	(10005862, 4, 'PW21A-JK100126BL-XL', 2, 0, '2021-04-15 13:02:47.818590', '2021-04-15 13:02:47.818590', NULL),
	(10005863, 4, 'PW21A-JK100126BL-XXL', 1, 0, '2021-04-15 13:02:47.817952', '2021-04-15 13:02:47.817952', NULL),
	(10005864, 4, 'PW21A-JK100127BL-XS', 0, 0, '2021-04-15 13:02:47.817261', '2021-04-15 13:02:47.817261', NULL),
	(10005865, 4, 'PW21A-JK100127BL-S', 2, 0, '2021-04-15 13:02:47.845432', '2021-04-15 13:02:47.845432', NULL),
	(10005866, 4, 'PW21A-JK100127BL-M', 1, 0, '2021-04-15 13:02:47.842572', '2021-04-15 13:02:47.842572', NULL),
	(10005867, 4, 'PW21A-JK100127BL-L', 2, 0, '2021-04-15 13:02:47.844165', '2021-04-15 13:02:47.844165', NULL),
	(10005868, 4, 'PW21A-JK100127BL-XL', 2, 0, '2021-04-15 13:02:47.845060', '2021-04-15 13:02:47.845060', NULL),
	(10005869, 4, 'PW21A-JK100127BL-XXL', 1, 0, '2021-04-15 13:02:47.843686', '2021-04-15 13:02:47.843686', NULL),
	(10005870, 4, 'PW21A-JK100128BL-XS', 0, 0, '2021-04-15 13:02:47.828310', '2021-04-15 13:02:47.828310', NULL),
	(10005871, 4, 'PW21A-JK100128BL-S', 2, 0, '2021-04-15 13:02:47.844681', '2021-04-15 13:02:47.844681', NULL),
	(10005872, 4, 'PW21A-JK100128BL-M', 1, 0, '2021-04-15 13:02:47.828925', '2021-04-15 13:02:47.828925', NULL),
	(10005873, 4, 'PW21A-JK100128BL-L', 2, 0, '2021-04-15 13:02:47.865424', '2021-04-15 13:02:47.865424', NULL),
	(10005874, 4, 'PW21A-JK100128BL-XL', 2, 0, '2021-04-15 13:02:47.843083', '2021-04-15 13:02:47.843083', NULL),
	(10005875, 4, 'PW21A-JK100128BL-XXL', 1, 0, '2021-04-15 13:02:47.897668', '2021-04-15 13:02:47.897668', NULL),
	(10005876, 4, 'PW21A-JK100129YW -XS', 0, 0, '2021-04-15 13:02:47.900265', '2021-04-15 13:02:47.900265', NULL),
	(10005877, 4, 'PW21A-JK100129YW -S', 0, 0, '2021-04-15 13:02:47.870601', '2021-04-15 13:02:47.870601', NULL),
	(10005878, 4, 'PW21A-JK100129YW -M', 0, 0, '2021-04-15 13:02:47.859449', '2021-04-15 13:02:47.859449', NULL),
	(10005879, 4, 'PW21A-JK100129YW -L', 0, 0, '2021-04-15 13:02:47.871573', '2021-04-15 13:02:47.871573', NULL),
	(10005880, 4, 'PW21A-JK100129YW -XL', 0, 0, '2021-04-15 13:02:47.881078', '2021-04-15 13:02:47.881078', NULL),
	(10005881, 4, 'PW21A-JK100129YW -XXL', 0, 0, '2021-04-15 13:02:47.870209', '2021-04-15 13:02:47.870209', NULL),
	(10005882, 4, 'PW21A-JK100130YW -XS', 2, 0, '2021-04-15 13:02:47.871914', '2021-04-15 13:02:47.871914', NULL),
	(10005883, 4, 'PW21A-JK100130YW -S', 2, 0, '2021-04-15 13:02:47.896329', '2021-04-15 13:02:47.896329', NULL),
	(10005884, 4, 'PW21A-JK100130YW -M', 2, 0, '2021-04-15 13:02:47.873920', '2021-04-15 13:02:47.873920', NULL),
	(10005885, 4, 'PW21A-JK100130YW -L', 2, 0, '2021-04-15 13:02:47.874281', '2021-04-15 13:02:47.874281', NULL),
	(10005886, 4, 'PW21A-JK100130YW -XL', 2, 0, '2021-04-15 13:02:47.884271', '2021-04-15 13:02:47.884271', NULL),
	(10005887, 4, 'PW21A-JK100130YW -XXL', 1, 0, '2021-04-15 13:02:47.909063', '2021-04-15 13:02:47.909063', NULL),
	(10005888, 4, 'PW21A-JK100131YW -XS', 0, 0, '2021-04-15 13:02:47.873540', '2021-04-15 13:02:47.873540', NULL),
	(10005889, 4, 'PW21A-JK100131YW -S', 0, 0, '2021-04-15 13:02:47.888173', '2021-04-15 13:02:47.888173', NULL),
	(10005890, 4, 'PW21A-JK100131YW -M', 0, 0, '2021-04-15 13:02:47.930982', '2021-04-15 13:02:47.930982', NULL),
	(10005891, 4, 'PW21A-JK100131YW -L', 0, 0, '2021-04-15 13:02:47.924166', '2021-04-15 13:02:47.924166', NULL),
	(10005892, 4, 'PW21A-JK100131YW -XL', 0, 0, '2021-04-15 13:02:47.898313', '2021-04-15 13:02:47.898313', NULL),
	(10005893, 4, 'PW21A-JK100131YW -XXL', 0, 0, '2021-04-15 13:02:47.898829', '2021-04-15 13:02:47.898829', NULL),
	(10005894, 4, 'PW21A-JK100132BL-XS', 0, 0, '2021-04-15 13:02:47.901309', '2021-04-15 13:02:47.901309', NULL),
	(10005895, 4, 'PW21A-JK100132BL-S', 0, 0, '2021-04-15 13:02:47.923706', '2021-04-15 13:02:47.923706', NULL),
	(10005896, 4, 'PW21A-JK100132BL-M', 0, 0, '2021-04-15 13:02:47.910828', '2021-04-15 13:02:47.910828', NULL),
	(10005897, 4, 'PW21A-JK100132BL-L', 0, 0, '2021-04-15 13:02:48.022786', '2021-04-15 13:02:48.022786', NULL),
	(10005898, 4, 'PW21A-JK100132BL-XL', 0, 0, '2021-04-15 13:02:47.900788', '2021-04-15 13:02:47.900788', NULL),
	(10005899, 4, 'PW21A-JK100132BL-XXL', 0, 0, '2021-04-15 13:02:47.923187', '2021-04-15 13:02:47.923187', NULL),
	(10005900, 4, 'PW21A-JK100133BL-XS', 0, 0, '2021-04-15 13:02:47.919808', '2021-04-15 13:02:47.919808', NULL),
	(10005901, 4, 'PW21A-JK100133BL-S', 0, 0, '2021-04-15 13:02:47.940854', '2021-04-15 13:02:47.940854', NULL),
	(10005902, 4, 'PW21A-JK100133BL-M', 0, 0, '2021-04-15 13:02:47.911179', '2021-04-15 13:02:47.911179', NULL),
	(10005903, 4, 'PW21A-JK100133BL-L', 0, 0, '2021-04-15 13:02:47.960076', '2021-04-15 13:02:47.960076', NULL),
	(10005904, 4, 'PW21A-JK100133BL-XL', 0, 0, '2021-04-15 13:02:47.936217', '2021-04-15 13:02:47.936217', NULL),
	(10005905, 4, 'PW21A-JK100133BL-XXL', 0, 0, '2021-04-15 13:02:47.930477', '2021-04-15 13:02:47.930477', NULL),
	(10005906, 4, 'PW21A-JK100134OL-XS', 0, 0, '2021-04-15 13:02:47.924688', '2021-04-15 13:02:47.924688', NULL),
	(10005907, 4, 'PW21A-JK100134OL-S', 0, 0, '2021-04-15 13:02:47.925104', '2021-04-15 13:02:47.925104', NULL),
	(10005908, 4, 'PW21A-JK100134OL-M', 0, 0, '2021-04-15 13:02:47.953679', '2021-04-15 13:02:47.953679', NULL),
	(10005909, 4, 'PW21A-JK100134OL-L', 0, 0, '2021-04-15 13:02:47.958586', '2021-04-15 13:02:47.958586', NULL),
	(10005910, 4, 'PW21A-JK100134OL-XL', 0, 0, '2021-04-15 13:02:48.026344', '2021-04-15 13:02:48.026344', NULL),
	(10005911, 4, 'PW21A-JK100134OL-XXL', 0, 0, '2021-04-15 13:02:47.997381', '2021-04-15 13:02:47.997381', NULL),
	(10005912, 4, 'PW21A-JK100135BL-XS', 0, 0, '2021-04-15 13:02:47.957755', '2021-04-15 13:02:47.957755', NULL),
	(10005913, 4, 'PW21A-JK100135BL-S', 0, 0, '2021-04-15 13:02:47.970668', '2021-04-15 13:02:47.970668', NULL),
	(10005914, 4, 'PW21A-JK100135BL-M', 0, 0, '2021-04-15 13:02:47.959450', '2021-04-15 13:02:47.959450', NULL),
	(10005915, 4, 'PW21A-JK100135BL-L', 0, 0, '2021-04-15 13:02:48.022308', '2021-04-15 13:02:48.022308', NULL),
	(10005916, 4, 'PW21A-JK100135BL-XL', 0, 0, '2021-04-15 13:02:47.960600', '2021-04-15 13:02:47.960600', NULL),
	(10005917, 4, 'PW21A-JK100135BL-XXL', 0, 0, '2021-04-15 13:02:47.975741', '2021-04-15 13:02:47.975741', NULL),
	(10005918, 4, 'PW21A-JK100136OL-XS', 0, 0, '2021-04-15 13:02:48.023787', '2021-04-15 13:02:48.023787', NULL),
	(10005919, 4, 'PW21A-JK100136OL-S', 2, 0, '2021-04-15 13:02:48.062477', '2021-04-15 13:02:48.062477', NULL),
	(10005920, 4, 'PW21A-JK100136OL-M', 2, 0, '2021-04-15 13:02:48.007529', '2021-04-15 13:02:48.007529', NULL),
	(10005921, 4, 'PW21A-JK100136OL-L', 2, 0, '2021-04-15 13:02:48.021226', '2021-04-15 13:02:48.021226', NULL),
	(10005922, 4, 'PW21A-JK100136OL-XL', 2, 0, '2021-04-15 13:02:48.023265', '2021-04-15 13:02:48.023265', NULL),
	(10005923, 4, 'PW21A-JK100136OL-XXL', 1, 0, '2021-04-15 13:02:48.046947', '2021-04-15 13:02:48.046947', NULL),
	(10005924, 4, 'PW21A-JK100137BL-XS', 2, 0, '2021-04-15 13:02:48.045619', '2021-04-15 13:02:48.045619', NULL),
	(10005925, 4, 'PW21A-JK100137BL-S', 2, 0, '2021-04-15 13:02:48.065131', '2021-04-15 13:02:48.065131', NULL),
	(10005926, 4, 'PW21A-JK100137BL-M', 2, 0, '2021-04-15 13:02:48.037334', '2021-04-15 13:02:48.037334', NULL),
	(10005927, 4, 'PW21A-JK100137BL-L', 2, 0, '2021-04-15 13:02:48.038222', '2021-04-15 13:02:48.038222', NULL),
	(10005928, 4, 'PW21A-JK100137BL-XL', 2, 0, '2021-04-15 13:02:48.061103', '2021-04-15 13:02:48.061103', NULL),
	(10005929, 4, 'PW21A-JK100137BL-XXL', 1, 0, '2021-04-15 13:02:48.101500', '2021-04-15 13:02:48.101500', NULL),
	(10005930, 4, 'PW21A-JK100138OL-XS', 0, 0, '2021-04-15 13:02:48.063039', '2021-04-15 13:02:48.063039', NULL),
	(10005931, 4, 'PW21A-JK100138OL-S', 2, 0, '2021-04-15 13:02:48.170142', '2021-04-15 13:02:48.170142', NULL),
	(10005932, 4, 'PW21A-JK100138OL-M', 2, 0, '2021-04-15 13:02:48.059593', '2021-04-15 13:02:48.059593', NULL),
	(10005933, 4, 'PW21A-JK100138OL-L', 2, 0, '2021-04-15 13:02:48.067180', '2021-04-15 13:02:48.067180', NULL),
	(10005934, 4, 'PW21A-JK100138OL-XL', 2, 0, '2021-04-15 13:02:48.201097', '2021-04-15 13:02:48.201097', NULL),
	(10005935, 4, 'PW21A-JK100138OL-XXL', 1, 0, '2021-04-15 13:02:48.063893', '2021-04-15 13:02:48.063893', NULL),
	(10005936, 4, 'PW21A-JK100139BL-XS', 0, 0, '2021-04-15 13:02:48.170395', '2021-04-15 13:02:48.170395', NULL),
	(10005937, 4, 'PW21A-JK100139BL-S', 2, 0, '2021-04-15 13:02:48.069933', '2021-04-15 13:02:48.069933', NULL),
	(10005938, 4, 'PW21A-JK100139BL-M', 2, 0, '2021-04-15 13:02:48.080590', '2021-04-15 13:02:48.080590', NULL),
	(10005939, 4, 'PW21A-JK100139BL-L', 2, 0, '2021-04-15 13:02:48.093760', '2021-04-15 13:02:48.093760', NULL),
	(10005940, 4, 'PW21A-JK100139BL-XL', 2, 0, '2021-04-15 13:02:48.081848', '2021-04-15 13:02:48.081848', NULL),
	(10005941, 4, 'PW21A-JK100139BL-XXL', 1, 0, '2021-04-15 13:02:48.272558', '2021-04-15 13:02:48.272558', NULL),
	(10005942, 4, 'PW21A-JK100140OL-XS', 0, 0, '2021-04-15 13:02:48.196604', '2021-04-15 13:02:48.196604', NULL),
	(10005943, 4, 'PW21A-JK100140OL-S', 2, 0, '2021-04-15 13:02:48.170023', '2021-04-15 13:02:48.170023', NULL),
	(10005944, 4, 'PW21A-JK100140OL-M', 2, 0, '2021-04-15 13:02:48.221235', '2021-04-15 13:02:48.221235', NULL),
	(10005945, 4, 'PW21A-JK100140OL-L', 2, 0, '2021-04-15 13:02:48.200743', '2021-04-15 13:02:48.200743', NULL),
	(10005946, 4, 'PW21A-JK100140OL-XL', 2, 0, '2021-04-15 13:02:48.196011', '2021-04-15 13:02:48.196011', NULL),
	(10005947, 4, 'PW21A-JK100140OL-XXL', 1, 0, '2021-04-15 13:02:48.275897', '2021-04-15 13:02:48.275897', NULL),
	(10005948, 4, 'PW21A-JK100141BL-XS', 0, 0, '2021-04-15 13:02:48.185750', '2021-04-15 13:02:48.185750', NULL),
	(10005949, 4, 'PW21A-JK100141BL-S', 0, 0, '2021-04-15 13:02:48.228087', '2021-04-15 13:02:48.228087', NULL),
	(10005950, 4, 'PW21A-JK100141BL-M', 0, 0, '2021-04-15 13:02:48.235141', '2021-04-15 13:02:48.235141', NULL),
	(10005951, 4, 'PW21A-JK100141BL-L', 2, 0, '2021-04-15 13:02:48.315496', '2021-04-15 13:02:48.315496', NULL),
	(10005952, 4, 'PW21A-JK100141BL-XL', 2, 0, '2021-04-15 13:02:48.221851', '2021-04-15 13:02:48.221851', NULL),
	(10005953, 4, 'PW21A-JK100141BL-XXL', 1, 0, '2021-04-15 13:02:48.222224', '2021-04-15 13:02:48.222224', NULL),
	(10005954, 4, 'PW21A-JK100142OL-XS', 0, 0, '2021-04-15 13:02:48.265165', '2021-04-15 13:02:48.265165', NULL),
	(10005955, 4, 'PW21A-JK100142OL-S', 1, 0, '2021-04-15 13:02:48.262155', '2021-04-15 13:02:48.262155', NULL),
	(10005956, 4, 'PW21A-JK100142OL-M', 2, 0, '2021-04-15 13:02:48.249188', '2021-04-15 13:02:48.249188', NULL),
	(10005957, 4, 'PW21A-JK100142OL-L', 2, 0, '2021-04-15 13:02:48.280352', '2021-04-15 13:02:48.280352', NULL),
	(10005958, 4, 'PW21A-JK100142OL-XL', 3, 0, '2021-04-15 13:02:48.301252', '2021-04-15 13:02:48.301252', NULL),
	(10005959, 4, 'PW21A-JK100142OL-XXL', 1, 0, '2021-04-15 13:02:48.344878', '2021-04-15 13:02:48.344878', NULL),
	(10005960, 4, 'PW21A-JK100143BL-XS', 0, 0, '2021-04-15 13:02:48.384397', '2021-04-15 13:02:48.384397', NULL),
	(10005961, 4, 'PW21A-JK100143BL-S', 2, 0, '2021-04-15 13:02:48.277164', '2021-04-15 13:02:48.277164', NULL),
	(10005962, 4, 'PW21A-JK100143BL-M', 2, 0, '2021-04-15 13:02:48.369935', '2021-04-15 13:02:48.369935', NULL),
	(10005963, 4, 'PW21A-JK100143BL-L', 0, 0, '2021-04-15 13:02:48.265797', '2021-04-15 13:02:48.265797', NULL),
	(10005964, 4, 'PW21A-JK100143BL-XL', 1, 0, '2021-04-15 13:02:48.317963', '2021-04-15 13:02:48.317963', NULL),
	(10005965, 4, 'PW21A-JK100143BL-XXL', 0, 0, '2021-04-15 13:02:48.365172', '2021-04-15 13:02:48.365172', NULL),
	(10005966, 4, 'PW21A-JK100144AR-XS', 0, 0, '2021-04-15 13:02:48.344210', '2021-04-15 13:02:48.344210', NULL),
	(10005967, 4, 'PW21A-JK100144AR-S', 2, 0, '2021-04-15 13:02:48.369543', '2021-04-15 13:02:48.369543', NULL),
	(10005968, 4, 'PW21A-JK100144AR-M', 2, 0, '2021-04-15 13:02:48.345437', '2021-04-15 13:02:48.345437', NULL),
	(10005969, 4, 'PW21A-JK100144AR-L', 2, 0, '2021-04-15 13:02:48.392452', '2021-04-15 13:02:48.392452', NULL),
	(10005970, 4, 'PW21A-JK100144AR-XL', 1, 0, '2021-04-15 13:02:48.352273', '2021-04-15 13:02:48.352273', NULL),
	(10005971, 4, 'PW21A-JK100144AR-XXL', 1, 0, '2021-04-15 13:02:48.372489', '2021-04-15 13:02:48.372489', NULL),
	(10005972, 4, 'PW21A-JK100145RD-XS', 0, 0, '2021-04-15 13:02:48.376386', '2021-04-15 13:02:48.376386', NULL),
	(10005973, 4, 'PW21A-JK100145RD-S', 0, 0, '2021-04-15 13:02:48.442294', '2021-04-15 13:02:48.442294', NULL),
	(10005974, 4, 'PW21A-JK100145RD-M', 0, 0, '2021-04-15 13:02:48.350367', '2021-04-15 13:02:48.350367', NULL),
	(10005975, 4, 'PW21A-JK100145RD-L', 2, 0, '2021-04-15 13:02:48.405907', '2021-04-15 13:02:48.405907', NULL),
	(10005976, 4, 'PW21A-JK100145RD-XL', 2, 0, '2021-04-15 13:02:48.368179', '2021-04-15 13:02:48.368179', NULL),
	(10005977, 4, 'PW21A-JK100145RD-XXL', 1, 0, '2021-04-15 13:02:48.421075', '2021-04-15 13:02:48.421075', NULL),
	(10005978, 4, 'PW21A-JK100146BL-XS', 0, 0, '2021-04-15 13:02:48.433129', '2021-04-15 13:02:48.433129', NULL),
	(10005979, 4, 'PW21A-JK100146BL-S', 0, 0, '2021-04-15 13:02:48.381266', '2021-04-15 13:02:48.381266', NULL),
	(10005980, 4, 'PW21A-JK100146BL-M', 1, 0, '2021-04-15 13:02:48.507552', '2021-04-15 13:02:48.507552', NULL),
	(10005981, 4, 'PW21A-JK100146BL-L', 2, 0, '2021-04-15 13:02:48.402687', '2021-04-15 13:02:48.402687', NULL),
	(10005982, 4, 'PW21A-JK100146BL-XL', 2, 0, '2021-04-15 13:02:48.417275', '2021-04-15 13:02:48.417275', NULL),
	(10005983, 4, 'PW21A-JK100146BL-XXL', 1, 0, '2021-04-15 13:02:48.378090', '2021-04-15 13:02:48.378090', NULL),
	(10005984, 4, 'PW21A-JK100147BL-XS', 0, 0, '2021-04-15 13:02:48.447328', '2021-04-15 13:02:48.447328', NULL),
	(10005985, 4, 'PW21A-JK100147BL-S', 2, 0, '2021-04-15 13:02:48.457565', '2021-04-15 13:02:48.457565', NULL),
	(10005986, 4, 'PW21A-JK100147BL-M', 2, 0, '2021-04-15 13:02:48.449884', '2021-04-15 13:02:48.449884', NULL),
	(10005987, 4, 'PW21A-JK100147BL-L', 2, 0, '2021-04-15 13:02:48.433997', '2021-04-15 13:02:48.433997', NULL),
	(10005988, 4, 'PW21A-JK100147BL-XL', 2, 0, '2021-04-15 13:02:48.431912', '2021-04-15 13:02:48.431912', NULL),
	(10005989, 4, 'PW21A-JK100147BL-XXL', 1, 0, '2021-04-15 13:02:48.480966', '2021-04-15 13:02:48.480966', NULL),
	(10005990, 4, 'PW21A-JK100148BL-XS', 0, 0, '2021-04-15 13:02:48.470867', '2021-04-15 13:02:48.470867', NULL),
	(10005991, 4, 'PW21A-JK100148BL-S', 2, 0, '2021-04-15 13:02:48.478597', '2021-04-15 13:02:48.478597', NULL),
	(10005992, 4, 'PW21A-JK100148BL-M', 2, 0, '2021-04-15 13:02:48.471466', '2021-04-15 13:02:48.471466', NULL),
	(10005993, 4, 'PW21A-JK100148BL-L', 2, 0, '2021-04-15 13:02:48.461223', '2021-04-15 13:02:48.461223', NULL),
	(10005994, 4, 'PW21A-JK100148BL-XL', 2, 0, '2021-04-15 13:02:48.484197', '2021-04-15 13:02:48.484197', NULL),
	(10005995, 4, 'PW21A-JK100148BL-XXL', 1, 0, '2021-04-15 13:02:48.592267', '2021-04-15 13:02:48.592267', NULL),
	(10005996, 4, 'PW21A-JK100149BL-XS', 0, 0, '2021-04-15 13:02:48.480363', '2021-04-15 13:02:48.480363', NULL),
	(10005997, 4, 'PW21A-JK100149BL-S', 2, 0, '2021-04-15 13:02:48.506320', '2021-04-15 13:02:48.506320', NULL),
	(10005998, 4, 'PW21A-JK100149BL-M', 2, 0, '2021-04-15 13:02:48.490923', '2021-04-15 13:02:48.490923', NULL),
	(10005999, 4, 'PW21A-JK100149BL-L', 2, 0, '2021-04-15 13:02:48.548979', '2021-04-15 13:02:48.548979', NULL),
	(10006000, 4, 'PW21A-JK100149BL-XL', 2, 0, '2021-04-15 13:02:48.491606', '2021-04-15 13:02:48.491606', NULL),
	(10006001, 4, 'PW21A-JK100149BL-XXL', 1, 0, '2021-04-15 13:02:48.559068', '2021-04-15 13:02:48.559068', NULL),
	(10006002, 4, 'PW21A-JK100150BL-XS', 0, 0, '2021-04-15 13:02:48.527589', '2021-04-15 13:02:48.527589', NULL),
	(10006003, 4, 'PW21A-JK100150BL-S', 2, 0, '2021-04-15 13:02:48.534809', '2021-04-15 13:02:48.534809', NULL),
	(10006004, 4, 'PW21A-JK100150BL-M', 2, 0, '2021-04-15 13:02:48.520694', '2021-04-15 13:02:48.520694', NULL),
	(10006005, 4, 'PW21A-JK100150BL-L', 2, 0, '2021-04-15 13:02:48.561460', '2021-04-15 13:02:48.561460', NULL),
	(10006006, 4, 'PW21A-JK100150BL-XL', 2, 0, '2021-04-15 13:02:48.514881', '2021-04-15 13:02:48.514881', NULL),
	(10006007, 4, 'PW21A-JK100150BL-XXL', 1, 0, '2021-04-15 13:02:48.628613', '2021-04-15 13:02:48.628613', NULL),
	(10006008, 4, 'PW21A-JK100151BL-XS', 0, 0, '2021-04-15 13:02:48.531505', '2021-04-15 13:02:48.531505', NULL),
	(10006009, 4, 'PW21A-JK100151BL-S', 2, 0, '2021-04-15 13:02:48.523172', '2021-04-15 13:02:48.523172', NULL),
	(10006010, 4, 'PW21A-JK100151BL-M', 2, 0, '2021-04-15 13:02:48.559837', '2021-04-15 13:02:48.559837', NULL),
	(10006011, 4, 'PW21A-JK100151BL-L', 2, 0, '2021-04-15 13:02:48.582605', '2021-04-15 13:02:48.582605', NULL),
	(10006012, 4, 'PW21A-JK100151BL-XL', 2, 0, '2021-04-15 13:02:48.588472', '2021-04-15 13:02:48.588472', NULL),
	(10006013, 4, 'PW21A-JK100151BL-XXL', 1, 0, '2021-04-15 13:02:48.586940', '2021-04-15 13:02:48.586940', NULL),
	(10006014, 4, 'PW21A-JK100152BL-XS', 0, 0, '2021-04-15 13:02:48.665528', '2021-04-15 13:02:48.665528', NULL),
	(10006015, 4, 'PW21A-JK100152BL-S', 1, 0, '2021-04-15 13:02:48.592664', '2021-04-15 13:02:48.592664', NULL),
	(10006016, 4, 'PW21A-JK100152BL-M', 2, 0, '2021-04-15 13:02:48.604908', '2021-04-15 13:02:48.604908', NULL),
	(10006017, 4, 'PW21A-JK100152BL-L', 2, 0, '2021-04-15 13:02:48.599344', '2021-04-15 13:02:48.599344', NULL),
	(10006018, 4, 'PW21A-JK100152BL-XL', 2, 0, '2021-04-15 13:02:48.610680', '2021-04-15 13:02:48.610680', NULL),
	(10006019, 4, 'PW21A-JK100152BL-XXL', 1, 0, '2021-04-15 13:02:48.623677', '2021-04-15 13:02:48.623677', NULL),
	(10006020, 4, 'PW21A-JK100153GN-XS', 0, 0, '2021-04-15 13:02:48.634572', '2021-04-15 13:02:48.634572', NULL),
	(10006021, 4, 'PW21A-JK100153GN-S', 0, 0, '2021-04-15 13:02:48.611287', '2021-04-15 13:02:48.611287', NULL),
	(10006022, 4, 'PW21A-JK100153GN-M', 0, 0, '2021-04-15 13:02:48.632203', '2021-04-15 13:02:48.632203', NULL),
	(10006023, 4, 'PW21A-JK100153GN-L', 0, 0, '2021-04-15 13:02:48.644522', '2021-04-15 13:02:48.644522', NULL),
	(10006024, 4, 'PW21A-JK100153GN-XL', 0, 0, '2021-04-15 13:02:48.634008', '2021-04-15 13:02:48.634008', NULL),
	(10006025, 4, 'PW21A-JK100153GN-XXL', 0, 0, '2021-04-15 13:02:48.693287', '2021-04-15 13:02:48.693287', NULL),
	(10006026, 4, 'PW21A-JD100154BL-XS', 0, 0, '2021-04-15 13:02:48.612169', '2021-04-15 13:02:48.612169', NULL),
	(10006027, 4, 'PW21A-JD100154BL-S', 0, 0, '2021-04-15 13:02:48.654780', '2021-04-15 13:02:48.654780', NULL),
	(10006028, 4, 'PW21A-JD100154BL-M', 0, 0, '2021-04-15 13:02:48.646000', '2021-04-15 13:02:48.646000', NULL),
	(10006029, 4, 'PW21A-JD100154BL-L', 0, 0, '2021-04-15 13:02:48.658616', '2021-04-15 13:02:48.658616', NULL),
	(10006030, 4, 'PW21A-JD100154BL-XL', 0, 0, '2021-04-15 13:02:48.708430', '2021-04-15 13:02:48.708430', NULL),
	(10006031, 4, 'PW21A-JD100154BL-XXL', 0, 0, '2021-04-15 13:02:48.736963', '2021-04-15 13:02:48.736963', NULL),
	(10006032, 4, 'PW21A-JK100155OL-XS', 0, 0, '2021-04-15 13:02:48.651879', '2021-04-15 13:02:48.651879', NULL),
	(10006033, 4, 'PW21A-JK100155OL-S', 0, 0, '2021-04-15 13:02:48.687474', '2021-04-15 13:02:48.687474', NULL),
	(10006034, 4, 'PW21A-JK100155OL-M', 0, 0, '2021-04-15 13:02:48.710034', '2021-04-15 13:02:48.710034', NULL),
	(10006035, 4, 'PW21A-JK100155OL-L', 0, 0, '2021-04-15 13:02:48.701457', '2021-04-15 13:02:48.701457', NULL),
	(10006036, 4, 'PW21A-JK100155OL-XL', 0, 0, '2021-04-15 13:02:48.684149', '2021-04-15 13:02:48.684149', NULL),
	(10006037, 4, 'PW21A-JK100155OL-XXL', 0, 0, '2021-04-15 13:02:48.709336', '2021-04-15 13:02:48.709336', NULL),
	(10006038, 4, 'PW21A-JK100156YW -XS', 0, 0, '2021-04-15 13:02:48.882468', '2021-04-15 13:02:48.882468', NULL),
	(10006039, 4, 'PW21A-JK100156YW -S', 0, 0, '2021-04-15 13:02:48.702033', '2021-04-15 13:02:48.702033', NULL),
	(10006040, 4, 'PW21A-JK100156YW -M', 0, 0, '2021-04-15 13:02:48.712399', '2021-04-15 13:02:48.712399', NULL),
	(10006041, 4, 'PW21A-JK100156YW -L', 0, 0, '2021-04-15 13:02:48.710670', '2021-04-15 13:02:48.710670', NULL),
	(10006042, 4, 'PW21A-JK100156YW -XL', 0, 0, '2021-04-15 13:02:48.835043', '2021-04-15 13:02:48.835043', NULL),
	(10006043, 4, 'PW21A-JK100156YW -XXL', 0, 0, '2021-04-15 13:02:48.728159', '2021-04-15 13:02:48.728159', NULL),
	(10006044, 4, 'PW21A-JK100157BL-XS', 0, 0, '2021-04-15 13:02:48.730560', '2021-04-15 13:02:48.730560', NULL),
	(10006045, 4, 'PW21A-JK100157BL-S', 1, 0, '2021-04-15 13:02:48.749351', '2021-04-15 13:02:48.749351', NULL),
	(10006046, 4, 'PW21A-JK100157BL-M', 2, 0, '2021-04-15 13:02:48.729538', '2021-04-15 13:02:48.729538', NULL),
	(10006047, 4, 'PW21A-JK100157BL-L', 2, 0, '2021-04-15 13:02:48.741617', '2021-04-15 13:02:48.741617', NULL),
	(10006048, 4, 'PW21A-JK100157BL-XL', 2, 0, '2021-04-15 13:02:48.751246', '2021-04-15 13:02:48.751246', NULL),
	(10006049, 4, 'PW21A-JK100157BL-XXL', 1, 0, '2021-04-15 13:02:48.747176', '2021-04-15 13:02:48.747176', NULL),
	(10006050, 4, 'PW21A-JK100158AR-XS', 0, 0, '2021-04-15 13:02:48.807778', '2021-04-15 13:02:48.807778', NULL),
	(10006051, 4, 'PW21A-JK100158AR-S', 0, 0, '2021-04-15 13:02:48.754235', '2021-04-15 13:02:48.754235', NULL),
	(10006052, 4, 'PW21A-JK100158AR-M', 0, 0, '2021-04-15 13:02:48.817288', '2021-04-15 13:02:48.817288', NULL),
	(10006053, 4, 'PW21A-JK100158AR-L', 0, 0, '2021-04-15 13:02:48.767210', '2021-04-15 13:02:48.767210', NULL),
	(10006054, 4, 'PW21A-JK100158AR-XL', 0, 0, '2021-04-15 13:02:48.816371', '2021-04-15 13:02:48.816371', NULL),
	(10006055, 4, 'PW21A-JK100158AR-XXL', 0, 0, '2021-04-15 13:02:48.813813', '2021-04-15 13:02:48.813813', NULL),
	(10006056, 4, 'PW21A-JD100159MR-XS', 0, 0, '2021-04-15 13:02:49.213268', '2021-04-15 13:02:49.213268', NULL),
	(10006057, 4, 'PW21A-JD100159MR-S', 0, 0, '2021-04-15 13:02:48.877993', '2021-04-15 13:02:48.877993', NULL),
	(10006058, 4, 'PW21A-JD100159MR-M', 0, 0, '2021-04-15 13:02:48.884347', '2021-04-15 13:02:48.884347', NULL),
	(10006059, 4, 'PW21A-JD100159MR-L', 0, 0, '2021-04-15 13:02:48.819090', '2021-04-15 13:02:48.819090', NULL),
	(10006060, 4, 'PW21A-JD100159MR-XL', 0, 0, '2021-04-15 13:02:48.915656', '2021-04-15 13:02:48.915656', NULL),
	(10006061, 4, 'PW21A-JD100159MR-XXL', 0, 0, '2021-04-15 13:02:48.851053', '2021-04-15 13:02:48.851053', NULL),
	(10006062, 4, 'PW21A-JK100160TC-XS', 0, 0, '2021-04-15 13:02:48.895855', '2021-04-15 13:02:48.895855', NULL),
	(10006063, 4, 'PW21A-JK100160TC-S', 0, 0, '2021-04-15 13:02:48.859438', '2021-04-15 13:02:48.859438', NULL),
	(10006064, 4, 'PW21A-JK100160TC-M', 0, 0, '2021-04-15 13:02:48.849040', '2021-04-15 13:02:48.849040', NULL),
	(10006065, 4, 'PW21A-JK100160TC-L', 0, 0, '2021-04-15 13:02:48.943785', '2021-04-15 13:02:48.943785', NULL),
	(10006066, 4, 'PW21A-JK100160TC-XL', 0, 0, '2021-04-15 13:02:48.861753', '2021-04-15 13:02:48.861753', NULL),
	(10006067, 4, 'PW21A-JK100160TC-XXL', 0, 0, '2021-04-15 13:02:48.899270', '2021-04-15 13:02:48.899270', NULL),
	(10006068, 4, 'PW21A-JK100161BL-XS', 0, 0, '2021-04-15 13:02:48.949695', '2021-04-15 13:02:48.949695', NULL),
	(10006069, 4, 'PW21A-JK100161BL-S', 2, 0, '2021-04-15 13:02:48.902170', '2021-04-15 13:02:48.902170', NULL),
	(10006070, 4, 'PW21A-JK100161BL-M', 2, 0, '2021-04-15 13:02:48.886626', '2021-04-15 13:02:48.886626', NULL),
	(10006071, 4, 'PW21A-JK100161BL-L', 2, 0, '2021-04-15 13:02:48.944938', '2021-04-15 13:02:48.944938', NULL),
	(10006072, 4, 'PW21A-JK100161BL-XL', 2, 0, '2021-04-15 13:02:48.916725', '2021-04-15 13:02:48.916725', NULL),
	(10006073, 4, 'PW21A-JK100161BL-XXL', 1, 0, '2021-04-15 13:02:48.958379', '2021-04-15 13:02:48.958379', NULL),
	(10006074, 4, 'PW21A-JD100162BL-XS', 0, 0, '2021-04-15 13:02:49.114772', '2021-04-15 13:02:49.114772', NULL),
	(10006075, 4, 'PW21A-JD100162BL-S', 0, 0, '2021-04-15 13:02:48.972576', '2021-04-15 13:02:48.972576', NULL),
	(10006076, 4, 'PW21A-JD100162BL-M', 0, 0, '2021-04-15 13:02:49.097441', '2021-04-15 13:02:49.097441', NULL),
	(10006077, 4, 'PW21A-JD100162BL-L', 0, 0, '2021-04-15 13:02:48.955254', '2021-04-15 13:02:48.955254', NULL),
	(10006078, 4, 'PW21A-JD100162BL-XL', 0, 0, '2021-04-15 13:02:48.984266', '2021-04-15 13:02:48.984266', NULL),
	(10006079, 4, 'PW21A-JD100162BL-XXL', 0, 0, '2021-04-15 13:02:49.002323', '2021-04-15 13:02:49.002323', NULL),
	(10006080, 4, 'PW21A-JK100163RD-XS', 2, 0, '2021-04-15 13:02:49.005137', '2021-04-15 13:02:49.005137', NULL),
	(10006081, 4, 'PW21A-JK100163RD-S', 2, 0, '2021-04-15 13:02:49.037170', '2021-04-15 13:02:49.037170', NULL),
	(10006082, 4, 'PW21A-JK100163RD-M', 2, 0, '2021-04-15 13:02:49.115999', '2021-04-15 13:02:49.115999', NULL),
	(10006083, 4, 'PW21A-JK100163RD-L', 2, 0, '2021-04-15 13:02:49.066344', '2021-04-15 13:02:49.066344', NULL),
	(10006084, 4, 'PW21A-JK100163RD-XL', 2, 0, '2021-04-15 13:02:49.011724', '2021-04-15 13:02:49.011724', NULL),
	(10006085, 4, 'PW21A-JK100163RD-XXL', 1, 0, '2021-04-15 13:02:49.055393', '2021-04-15 13:02:49.055393', NULL),
	(10006086, 4, 'PW21A-JD100164BL-XS', 0, 0, '2021-04-15 13:02:49.145887', '2021-04-15 13:02:49.145887', NULL),
	(10006087, 4, 'PW21A-JD100164BL-S', 0, 0, '2021-04-15 13:02:49.147123', '2021-04-15 13:02:49.147123', NULL),
	(10006088, 4, 'PW21A-JD100164BL-M', 0, 0, '2021-04-15 13:02:49.143561', '2021-04-15 13:02:49.143561', NULL),
	(10006089, 4, 'PW21A-JD100164BL-L', 0, 0, '2021-04-15 13:02:49.080546', '2021-04-15 13:02:49.080546', NULL),
	(10006090, 4, 'PW21A-JD100164BL-XL', 0, 0, '2021-04-15 13:02:49.179062', '2021-04-15 13:02:49.179062', NULL),
	(10006091, 4, 'PW21A-JD100164BL-XXL', 0, 0, '2021-04-15 13:02:49.160580', '2021-04-15 13:02:49.160580', NULL),
	(10006092, 4, 'PW21A-JK100165NV-XS', 0, 0, '2021-04-15 13:02:49.197011', '2021-04-15 13:02:49.197011', NULL),
	(10006093, 4, 'PW21A-JK100165NV-S', 0, 0, '2021-04-15 13:02:49.350224', '2021-04-15 13:02:49.350224', NULL),
	(10006094, 4, 'PW21A-JK100165NV-M', 0, 0, '2021-04-15 13:02:49.216284', '2021-04-15 13:02:49.216284', NULL),
	(10006095, 4, 'PW21A-JK100165NV-L', 0, 0, '2021-04-15 13:02:49.348658', '2021-04-15 13:02:49.348658', NULL),
	(10006096, 4, 'PW21A-JK100165NV-XL', 0, 0, '2021-04-15 13:02:49.213786', '2021-04-15 13:02:49.213786', NULL),
	(10006097, 4, 'PW21A-JK100165NV-XXL', 0, 0, '2021-04-15 13:02:49.416499', '2021-04-15 13:02:49.416499', NULL),
	(10006098, 4, 'PW21A-JK100166MR-XS', 0, 0, '2021-04-15 13:02:49.199529', '2021-04-15 13:02:49.199529', NULL),
	(10006099, 4, 'PW21A-JK100166MR-S', 0, 0, '2021-04-15 13:02:49.281195', '2021-04-15 13:02:49.281195', NULL),
	(10006100, 4, 'PW21A-JK100166MR-M', 0, 0, '2021-04-15 13:02:49.349692', '2021-04-15 13:02:49.349692', NULL),
	(10006101, 4, 'PW21A-JK100166MR-L', 0, 0, '2021-04-15 13:02:49.284921', '2021-04-15 13:02:49.284921', NULL),
	(10006102, 4, 'PW21A-JK100166MR-XL', 0, 0, '2021-04-15 13:02:49.372084', '2021-04-15 13:02:49.372084', NULL),
	(10006103, 4, 'PW21A-JK100166MR-XXL', 0, 0, '2021-04-15 13:02:49.600072', '2021-04-15 13:02:49.600072', NULL),
	(10006104, 4, 'PW21A-JK100167WT-XS', 0, 0, '2021-04-15 13:02:49.397468', '2021-04-15 13:02:49.397468', NULL),
	(10006105, 4, 'PW21A-JK100167WT-S', 2, 0, '2021-04-15 13:02:49.464219', '2021-04-15 13:02:49.464219', NULL),
	(10006106, 4, 'PW21A-JK100167WT-M', 2, 0, '2021-04-15 13:02:49.376842', '2021-04-15 13:02:49.376842', NULL),
	(10006107, 4, 'PW21A-JK100167WT-L', 2, 0, '2021-04-15 13:02:49.387432', '2021-04-15 13:02:49.387432', NULL),
	(10006108, 4, 'PW21A-JK100167WT-XL', 2, 0, '2021-04-15 13:02:49.378254', '2021-04-15 13:02:49.378254', NULL),
	(10006109, 4, 'PW21A-JK100167WT-XXL', 1, 0, '2021-04-15 13:02:49.464576', '2021-04-15 13:02:49.464576', NULL),
	(10006110, 4, 'PW21A-JK100168BL-XS', 0, 0, '2021-04-15 13:02:49.377368', '2021-04-15 13:02:49.377368', NULL),
	(10006111, 4, 'PW21A-JK100168BL-S', 2, 0, '2021-04-15 13:02:49.395610', '2021-04-15 13:02:49.395610', NULL),
	(10006112, 4, 'PW21A-JK100168BL-M', 2, 0, '2021-04-15 13:02:49.417766', '2021-04-15 13:02:49.417766', NULL),
	(10006113, 4, 'PW21A-JK100168BL-L', 2, 0, '2021-04-15 13:02:49.405207', '2021-04-15 13:02:49.405207', NULL),
	(10006114, 4, 'PW21A-JK100168BL-XL', 2, 0, '2021-04-15 13:02:49.610771', '2021-04-15 13:02:49.610771', NULL),
	(10006115, 4, 'PW21A-JK100168BL-XXL', 1, 0, '2021-04-15 13:02:49.520417', '2021-04-15 13:02:49.520417', NULL),
	(10006116, 4, 'PW21A-JK100169BL-XS', 0, 0, '2021-04-15 13:02:49.399677', '2021-04-15 13:02:49.399677', NULL),
	(10006117, 4, 'PW21A-JK100169BL-S', 0, 0, '2021-04-15 13:02:49.546285', '2021-04-15 13:02:49.546285', NULL),
	(10006118, 4, 'PW21A-JK100169BL-M', 0, 0, '2021-04-15 13:02:49.566074', '2021-04-15 13:02:49.566074', NULL),
	(10006119, 4, 'PW21A-JK100169BL-L', 0, 0, '2021-04-15 13:02:49.464522', '2021-04-15 13:02:49.464522', NULL),
	(10006120, 4, 'PW21A-JK100169BL-XL', 0, 0, '2021-04-15 13:02:49.594850', '2021-04-15 13:02:49.594850', NULL),
	(10006121, 4, 'PW21A-JK100169BL-XXL', 0, 0, '2021-04-15 13:02:49.563766', '2021-04-15 13:02:49.563766', NULL),
	(10006122, 4, 'PW21A-JK100170RD-XS', 0, 0, '2021-04-15 13:02:49.531755', '2021-04-15 13:02:49.531755', NULL),
	(10006123, 4, 'PW21A-JK100170RD-S', 0, 0, '2021-04-15 13:02:49.527526', '2021-04-15 13:02:49.527526', NULL),
	(10006124, 4, 'PW21A-JK100170RD-M', 0, 0, '2021-04-15 13:02:49.579287', '2021-04-15 13:02:49.579287', NULL),
	(10006125, 4, 'PW21A-JK100170RD-L', 0, 0, '2021-04-15 13:02:49.538609', '2021-04-15 13:02:49.538609', NULL),
	(10006126, 4, 'PW21A-JK100170RD-XL', 0, 0, '2021-04-15 13:02:49.588577', '2021-04-15 13:02:49.588577', NULL),
	(10006127, 4, 'PW21A-JK100170RD-XXL', 0, 0, '2021-04-15 13:02:49.684442', '2021-04-15 13:02:49.684442', NULL),
	(10006128, 4, 'PW21A-JK100171WT-XS', 0, 0, '2021-04-15 13:02:49.631323', '2021-04-15 13:02:49.631323', NULL),
	(10006129, 4, 'PW21A-JK100171WT-S', 0, 0, '2021-04-15 13:02:49.585676', '2021-04-15 13:02:49.585676', NULL),
	(10006130, 4, 'PW21A-JK100171WT-M', 0, 0, '2021-04-15 13:02:49.620226', '2021-04-15 13:02:49.620226', NULL),
	(10006131, 4, 'PW21A-JK100171WT-L', 0, 0, '2021-04-15 13:02:49.685010', '2021-04-15 13:02:49.685010', NULL),
	(10006132, 4, 'PW21A-JK100171WT-XL', 0, 0, '2021-04-15 13:02:49.604146', '2021-04-15 13:02:49.604146', NULL),
	(10006133, 4, 'PW21A-JK100171WT-XXL', 0, 0, '2021-04-15 13:02:49.742519', '2021-04-15 13:02:49.742519', NULL),
	(10006134, 4, 'PW21A-JK100172BL-XS', 0, 0, '2021-04-15 13:02:49.615321', '2021-04-15 13:02:49.615321', NULL),
	(10006135, 4, 'PW21A-JK100172BL-S', 2, 0, '2021-04-15 13:02:49.637931', '2021-04-15 13:02:49.637931', NULL),
	(10006136, 4, 'PW21A-JK100172BL-M', 2, 0, '2021-04-15 13:02:49.699598', '2021-04-15 13:02:49.699598', NULL),
	(10006137, 4, 'PW21A-JK100172BL-L', 2, 0, '2021-04-15 13:02:49.711753', '2021-04-15 13:02:49.711753', NULL),
	(10006138, 4, 'PW21A-JK100172BL-XL', 1, 0, '2021-04-15 13:02:49.629341', '2021-04-15 13:02:49.629341', NULL),
	(10006139, 4, 'PW21A-JK100172BL-XXL', 1, 0, '2021-04-15 13:02:49.759413', '2021-04-15 13:02:49.759413', NULL),
	(10006140, 4, 'PW21A-TS100173BL-XS', 0, 0, '2021-04-15 13:02:49.699817', '2021-04-15 13:02:49.699817', NULL),
	(10006141, 4, 'PW21A-TS100173BL-M', 0, 0, '2021-04-15 13:02:49.682741', '2021-04-15 13:02:49.682741', NULL),
	(10006142, 4, 'PW21A-TS100173BL-L', 0, 0, '2021-04-15 13:02:49.725701', '2021-04-15 13:02:49.725701', NULL),
	(10006143, 4, 'PW21A-TS100173BL-XL', 0, 0, '2021-04-15 13:02:49.702779', '2021-04-15 13:02:49.702779', NULL),
	(10006144, 4, 'PW21A-TS100173BL-XXL', 0, 0, '2021-04-15 13:02:49.710499', '2021-04-15 13:02:49.710499', NULL),
	(10006145, 4, 'PW21A-TS100174NV-XS', 0, 0, '2021-04-15 13:02:49.870208', '2021-04-15 13:02:49.870208', NULL),
	(10006146, 4, 'PW21A-TS100174NV-S', 0, 0, '2021-04-15 13:02:49.725910', '2021-04-15 13:02:49.725910', NULL),
	(10006147, 4, 'PW21A-TS100174NV-M', 0, 0, '2021-04-15 13:02:49.746425', '2021-04-15 13:02:49.746425', NULL),
	(10006148, 4, 'PW21A-TS100174NV-L', 0, 0, '2021-04-15 13:02:49.748430', '2021-04-15 13:02:49.748430', NULL),
	(10006149, 4, 'PW21A-TS100174NV-XL', 0, 0, '2021-04-15 13:02:49.747933', '2021-04-15 13:02:49.747933', NULL),
	(10006150, 4, 'PW21A-TS100174NV-XXL', 0, 0, '2021-04-15 13:02:49.757685', '2021-04-15 13:02:49.757685', NULL),
	(10006151, 4, 'PW21A-TS100175BL-XS', 0, 0, '2021-04-15 13:02:49.749009', '2021-04-15 13:02:49.749009', NULL),
	(10006152, 4, 'PW21A-TS100175BL-S', 0, 0, '2021-04-15 13:02:49.758359', '2021-04-15 13:02:49.758359', NULL),
	(10006153, 4, 'PW21A-TS100175BL-M', 0, 0, '2021-04-15 13:02:49.763405', '2021-04-15 13:02:49.763405', NULL),
	(10006154, 4, 'PW21A-TS100175BL-L', 0, 0, '2021-04-15 13:02:49.795980', '2021-04-15 13:02:49.795980', NULL),
	(10006155, 4, 'PW21A-TS100175BL-XL', 0, 0, '2021-04-15 13:02:49.795225', '2021-04-15 13:02:49.795225', NULL),
	(10006156, 4, 'PW21A-TS100175BL-XXL', 0, 0, '2021-04-15 13:02:49.794563', '2021-04-15 13:02:49.794563', NULL),
	(10006157, 4, 'PW21A-TS100176BL-XS', 0, 0, '2021-04-15 13:02:49.793883', '2021-04-15 13:02:49.793883', NULL),
	(10006158, 4, 'PW21A-TS100176BL-S', 0, 0, '2021-04-15 13:02:49.787677', '2021-04-15 13:02:49.787677', NULL),
	(10006159, 4, 'PW21A-TS100176BL-M', 0, 0, '2021-04-15 13:02:49.793031', '2021-04-15 13:02:49.793031', NULL),
	(10006160, 4, 'PW21A-TS100176BL-L', 0, 0, '2021-04-15 13:02:49.765297', '2021-04-15 13:02:49.765297', NULL),
	(10006161, 4, 'PW21A-TS100176BL-XL', 0, 0, '2021-04-15 13:02:49.807516', '2021-04-15 13:02:49.807516', NULL),
	(10006162, 4, 'PW21A-TS100176BL-XXL', 0, 0, '2021-04-15 13:02:49.875398', '2021-04-15 13:02:49.875398', NULL),
	(10006163, 4, 'PW21A-TS100177BL-XS', 0, 0, '2021-04-15 13:02:49.796709', '2021-04-15 13:02:49.796709', NULL),
	(10006164, 4, 'PW21A-TS100177BL-S', 0, 0, '2021-04-15 13:02:49.863108', '2021-04-15 13:02:49.863108', NULL),
	(10006165, 4, 'PW21A-TS100177BL-M', 0, 0, '2021-04-15 13:02:49.867667', '2021-04-15 13:02:49.867667', NULL),
	(10006166, 4, 'PW21A-TS100177BL-L', 0, 0, '2021-04-15 13:02:49.799085', '2021-04-15 13:02:49.799085', NULL),
	(10006167, 4, 'PW21A-TS100177BL-XL', 0, 0, '2021-04-15 13:02:49.914839', '2021-04-15 13:02:49.914839', NULL),
	(10006168, 4, 'PW21A-TS100177BL-XXL', 0, 0, '2021-04-15 13:02:49.808203', '2021-04-15 13:02:49.808203', NULL),
	(10006169, 4, 'PW21A-TS100178BL-XS', 0, 0, '2021-04-15 13:02:49.921399', '2021-04-15 13:02:49.921399', NULL),
	(10006170, 4, 'PW21A-TS100178BL-S', 0, 0, '2021-04-15 13:02:49.868632', '2021-04-15 13:02:49.868632', NULL),
	(10006171, 4, 'PW21A-TS100178BL-M', 0, 0, '2021-04-15 13:02:49.865737', '2021-04-15 13:02:49.865737', NULL),
	(10006172, 4, 'PW21A-TS100178BL-L', 0, 0, '2021-04-15 13:02:49.864330', '2021-04-15 13:02:49.864330', NULL),
	(10006173, 4, 'PW21A-TS100178BL-XL', 0, 0, '2021-04-15 13:02:49.919088', '2021-04-15 13:02:49.919088', NULL),
	(10006174, 4, 'PW21A-TS100178BL-XXL', 0, 0, '2021-04-15 13:02:49.871344', '2021-04-15 13:02:49.871344', NULL),
	(10006175, 4, 'PW21A-TS100179BL-XS', 0, 0, '2021-04-15 13:02:49.967955', '2021-04-15 13:02:49.967955', NULL),
	(10006176, 4, 'PW21A-TS100179BL-S', 0, 0, '2021-04-15 13:02:49.874309', '2021-04-15 13:02:49.874309', NULL),
	(10006177, 4, 'PW21A-TS100179BL-M', 0, 0, '2021-04-15 13:02:49.918208', '2021-04-15 13:02:49.918208', NULL),
	(10006178, 4, 'PW21A-TS100179BL-L', 0, 0, '2021-04-15 13:02:49.916603', '2021-04-15 13:02:49.916603', NULL),
	(10006179, 4, 'PW21A-TS100179BL-XL', 0, 0, '2021-04-15 13:02:49.869215', '2021-04-15 13:02:49.869215', NULL),
	(10006180, 4, 'PW21A-TS100179BL-XXL', 0, 0, '2021-04-15 13:02:49.919740', '2021-04-15 13:02:49.919740', NULL),
	(10006181, 4, 'PW21A-TS100180BL-XS', 0, 0, '2021-04-15 13:02:49.920377', '2021-04-15 13:02:49.920377', NULL),
	(10006182, 4, 'PW21A-TS100180BL-S', 0, 0, '2021-04-15 13:02:49.917253', '2021-04-15 13:02:49.917253', NULL),
	(10006183, 4, 'PW21A-TS100180BL-M', 0, 0, '2021-04-15 13:02:49.965185', '2021-04-15 13:02:49.965185', NULL),
	(10006184, 4, 'PW21A-TS100180BL-L', 0, 0, '2021-04-15 13:02:49.923722', '2021-04-15 13:02:49.923722', NULL),
	(10006185, 4, 'PW21A-TS100180BL-XL', 0, 0, '2021-04-15 13:02:49.968652', '2021-04-15 13:02:49.968652', NULL),
	(10006186, 4, 'PW21A-TS100180BL-XXL', 0, 0, '2021-04-15 13:02:49.915718', '2021-04-15 13:02:49.915718', NULL),
	(10006187, 4, 'PW21A-TS100181BL-XS', 0, 0, '2021-04-15 13:02:49.964618', '2021-04-15 13:02:49.964618', NULL),
	(10006188, 4, 'PW21A-TS100181BL-S', 0, 0, '2021-04-15 13:02:50.009601', '2021-04-15 13:02:50.009601', NULL),
	(10006189, 4, 'PW21A-TS100181BL-M', 0, 0, '2021-04-15 13:02:49.962861', '2021-04-15 13:02:49.962861', NULL),
	(10006190, 4, 'PW21A-TS100181BL-L', 0, 0, '2021-04-15 13:02:50.008598', '2021-04-15 13:02:50.008598', NULL),
	(10006191, 4, 'PW21A-TS100181BL-XL', 0, 0, '2021-04-15 13:02:49.966199', '2021-04-15 13:02:49.966199', NULL),
	(10006192, 4, 'PW21A-TS100181BL-XXL', 0, 0, '2021-04-15 13:02:49.967203', '2021-04-15 13:02:49.967203', NULL),
	(10006193, 4, 'PW21A-TS100182BL-XS', 0, 0, '2021-04-15 13:02:50.011611', '2021-04-15 13:02:50.011611', NULL),
	(10006194, 4, 'PW21A-TS100182BL-S', 0, 0, '2021-04-15 13:02:49.970080', '2021-04-15 13:02:49.970080', NULL),
	(10006195, 4, 'PW21A-TS100182BL-M', 0, 0, '2021-04-15 13:02:49.970637', '2021-04-15 13:02:49.970637', NULL),
	(10006196, 4, 'PW21A-TS100182BL-L', 0, 0, '2021-04-15 13:02:50.066614', '2021-04-15 13:02:50.066614', NULL),
	(10006197, 4, 'PW21A-TS100182BL-XL', 0, 0, '2021-04-15 13:02:49.972191', '2021-04-15 13:02:49.972191', NULL),
	(10006198, 4, 'PW21A-TS100182BL-XXL', 0, 0, '2021-04-15 13:02:50.110793', '2021-04-15 13:02:50.110793', NULL),
	(10006199, 4, 'PW21A-TS100183BL-XS', 0, 0, '2021-04-15 13:02:50.013560', '2021-04-15 13:02:50.013560', NULL),
	(10006200, 4, 'PW21A-TS100183BL-S', 0, 0, '2021-04-15 13:02:50.011072', '2021-04-15 13:02:50.011072', NULL),
	(10006201, 4, 'PW21A-TS100183BL-M', 0, 0, '2021-04-15 13:02:50.010545', '2021-04-15 13:02:50.010545', NULL),
	(10006202, 4, 'PW21A-TS100183BL-L', 0, 0, '2021-04-15 13:02:50.012131', '2021-04-15 13:02:50.012131', NULL),
	(10006203, 4, 'PW21A-TS100183BL-XL', 0, 0, '2021-04-15 13:02:50.142035', '2021-04-15 13:02:50.142035', NULL),
	(10006204, 4, 'PW21A-TS100183BL-XXL', 0, 0, '2021-04-15 13:02:50.013117', '2021-04-15 13:02:50.013117', NULL),
	(10006205, 4, 'PW21A-TS100184BL-XS', 0, 0, '2021-04-15 13:02:50.012570', '2021-04-15 13:02:50.012570', NULL),
	(10006206, 4, 'PW21A-TS100184BL-S', 0, 0, '2021-04-15 13:02:50.079796', '2021-04-15 13:02:50.079796', NULL),
	(10006207, 4, 'PW21A-TS100184BL-M', 0, 0, '2021-04-15 13:02:50.061367', '2021-04-15 13:02:50.061367', NULL),
	(10006208, 4, 'PW21A-TS100184BL-L', 0, 0, '2021-04-15 13:02:50.070607', '2021-04-15 13:02:50.070607', NULL),
	(10006209, 4, 'PW21A-TS100184BL-XL', 0, 0, '2021-04-15 13:02:50.014946', '2021-04-15 13:02:50.014946', NULL),
	(10006210, 4, 'PW21A-TS100184BL-XXL', 0, 0, '2021-04-15 13:02:50.065444', '2021-04-15 13:02:50.065444', NULL),
	(10006211, 4, 'PW21A-TS100185BL-XS', 0, 0, '2021-04-15 13:02:50.066031', '2021-04-15 13:02:50.066031', NULL),
	(10006212, 4, 'PW21A-TS100185BL-S', 0, 0, '2021-04-15 13:02:50.064916', '2021-04-15 13:02:50.064916', NULL),
	(10006213, 4, 'PW21A-TS100185BL-M', 0, 0, '2021-04-15 13:02:50.067157', '2021-04-15 13:02:50.067157', NULL),
	(10006214, 4, 'PW21A-TS100185BL-L', 0, 0, '2021-04-15 13:02:50.071656', '2021-04-15 13:02:50.071656', NULL),
	(10006215, 4, 'PW21A-TS100185BL-XL', 0, 0, '2021-04-15 13:02:50.109945', '2021-04-15 13:02:50.109945', NULL),
	(10006216, 4, 'PW21A-TS100185BL-XXL', 0, 0, '2021-04-15 13:02:50.080456', '2021-04-15 13:02:50.080456', NULL),
	(10006217, 4, 'PW21A-TS100186BL-XS', 0, 0, '2021-04-15 13:02:50.103147', '2021-04-15 13:02:50.103147', NULL),
	(10006218, 4, 'PW21A-TS100186BL-S', 0, 0, '2021-04-15 13:02:50.141395', '2021-04-15 13:02:50.141395', NULL),
	(10006219, 4, 'PW21A-TS100186BL-M', 0, 0, '2021-04-15 13:02:50.109447', '2021-04-15 13:02:50.109447', NULL),
	(10006220, 4, 'PW21A-TS100186BL-L', 0, 0, '2021-04-15 13:02:50.112445', '2021-04-15 13:02:50.112445', NULL),
	(10006221, 4, 'PW21A-TS100186BL-XL', 0, 0, '2021-04-15 13:02:50.118254', '2021-04-15 13:02:50.118254', NULL),
	(10006222, 4, 'PW21A-TS100186BL-XXL', 0, 0, '2021-04-15 13:02:50.160411', '2021-04-15 13:02:50.160411', NULL),
	(10006223, 4, 'PW21A-TS100187BL-XS', 0, 0, '2021-04-15 13:02:50.113065', '2021-04-15 13:02:50.113065', NULL),
	(10006224, 4, 'PW21A-TS100187BL-S', 0, 0, '2021-04-15 13:02:50.110322', '2021-04-15 13:02:50.110322', NULL),
	(10006225, 4, 'PW21A-TS100187BL-M', 0, 0, '2021-04-15 13:02:50.105125', '2021-04-15 13:02:50.105125', NULL),
	(10006226, 4, 'PW21A-TS100187BL-L', 0, 0, '2021-04-15 13:02:50.143310', '2021-04-15 13:02:50.143310', NULL),
	(10006227, 4, 'PW21A-TS100187BL-XL', 0, 0, '2021-04-15 13:02:50.140502', '2021-04-15 13:02:50.140502', NULL),
	(10006228, 4, 'PW21A-TS100187BL-XXL', 0, 0, '2021-04-15 13:02:50.136339', '2021-04-15 13:02:50.136339', NULL),
	(10006229, 4, 'PW21A-TS100188BL-XS', 0, 0, '2021-04-15 13:02:50.120056', '2021-04-15 13:02:50.120056', NULL),
	(10006230, 4, 'PW21A-TS100188BL-S', 0, 0, '2021-04-15 13:02:50.151842', '2021-04-15 13:02:50.151842', NULL),
	(10006231, 4, 'PW21A-TS100188BL-M', 0, 0, '2021-04-15 13:02:50.176446', '2021-04-15 13:02:50.176446', NULL),
	(10006232, 4, 'PW21A-TS100188BL-L', 0, 0, '2021-04-15 13:02:50.178096', '2021-04-15 13:02:50.178096', NULL),
	(10006233, 4, 'PW21A-TS100188BL-XL', 0, 0, '2021-04-15 13:02:50.142694', '2021-04-15 13:02:50.142694', NULL),
	(10006234, 4, 'PW21A-TS100188BL-XXL', 0, 0, '2021-04-15 13:02:50.146320', '2021-04-15 13:02:50.146320', NULL),
	(10006235, 4, 'PW21A-TS100189BL-XS', 0, 0, '2021-04-15 13:02:50.175811', '2021-04-15 13:02:50.175811', NULL),
	(10006236, 4, 'PW21A-TS100189BL-S', 0, 0, '2021-04-15 13:02:50.144756', '2021-04-15 13:02:50.144756', NULL),
	(10006237, 4, 'PW21A-TS100189BL-M', 0, 0, '2021-04-15 13:02:50.172823', '2021-04-15 13:02:50.172823', NULL),
	(10006238, 4, 'PW21A-TS100189BL-L', 0, 0, '2021-04-15 13:02:50.185604', '2021-04-15 13:02:50.185604', NULL),
	(10006239, 4, 'PW21A-TS100189BL-XL', 0, 0, '2021-04-15 13:02:50.179204', '2021-04-15 13:02:50.179204', NULL),
	(10006240, 4, 'PW21A-TS100189BL-XXL', 0, 0, '2021-04-15 13:02:50.197469', '2021-04-15 13:02:50.197469', NULL),
	(10006241, 4, 'PW21A-TS100190WT-XS', 0, 0, '2021-04-15 13:02:50.236252', '2021-04-15 13:02:50.236252', NULL),
	(10006242, 4, 'PW21A-TS100190WT-S', 0, 0, '2021-04-15 13:02:50.207370', '2021-04-15 13:02:50.207370', NULL),
	(10006243, 4, 'PW21A-TS100190WT-M', 0, 0, '2021-04-15 13:02:50.177575', '2021-04-15 13:02:50.177575', NULL),
	(10006244, 4, 'PW21A-TS100190WT-L', 0, 0, '2021-04-15 13:02:50.182179', '2021-04-15 13:02:50.182179', NULL),
	(10006245, 4, 'PW21A-TS100190WT-XL', 0, 0, '2021-04-15 13:02:50.178624', '2021-04-15 13:02:50.178624', NULL),
	(10006246, 4, 'PW21A-TS100190WT-XXL', 0, 0, '2021-04-15 13:02:50.243978', '2021-04-15 13:02:50.243978', NULL),
	(10006247, 4, 'PW21A-TS100191YW -XS', 0, 0, '2021-04-15 13:02:50.210937', '2021-04-15 13:02:50.210937', NULL),
	(10006248, 4, 'PW21A-TS100191YW -S', 0, 0, '2021-04-15 13:02:50.212337', '2021-04-15 13:02:50.212337', NULL),
	(10006249, 4, 'PW21A-TS100191YW -M', 0, 0, '2021-04-15 13:02:50.210464', '2021-04-15 13:02:50.210464', NULL),
	(10006250, 4, 'PW21A-TS100191YW -L', 0, 0, '2021-04-15 13:02:50.211391', '2021-04-15 13:02:50.211391', NULL),
	(10006251, 4, 'PW21A-TS100191YW -XL', 0, 0, '2021-04-15 13:02:50.211831', '2021-04-15 13:02:50.211831', NULL),
	(10006252, 4, 'PW21A-TS100191YW -XXL', 0, 0, '2021-04-15 13:02:50.214511', '2021-04-15 13:02:50.214511', NULL),
	(10006253, 4, 'PW21A-TS100192GN-XS', 0, 0, '2021-04-15 13:02:50.208957', '2021-04-15 13:02:50.208957', NULL),
	(10006254, 4, 'PW21A-TS100192GN-S', 1, 0, '2021-04-15 13:02:50.220208', '2021-04-15 13:02:50.220208', NULL),
	(10006255, 4, 'PW21A-TS100192GN-M', 0, 0, '2021-04-15 13:02:50.226099', '2021-04-15 13:02:50.226099', NULL),
	(10006256, 4, 'PW21A-TS100192GN-L', 0, 0, '2021-04-15 13:02:50.234855', '2021-04-15 13:02:50.234855', NULL),
	(10006257, 4, 'PW21A-TS100192GN-XL', 0, 0, '2021-04-15 13:02:50.243020', '2021-04-15 13:02:50.243020', NULL),
	(10006258, 4, 'PW21A-TS100192GN-XXL', 2, 0, '2021-04-15 13:02:50.268305', '2021-04-15 13:02:50.268305', NULL),
	(10006259, 4, 'PW21A-TS100193BL-XS', 0, 0, '2021-04-15 13:02:50.242585', '2021-04-15 13:02:50.242585', NULL),
	(10006260, 4, 'PW21A-TS100193BL-S', 2, 0, '2021-04-15 13:02:50.241261', '2021-04-15 13:02:50.241261', NULL),
	(10006261, 4, 'PW21A-TS100193BL-M', 2, 0, '2021-04-15 13:02:50.263343', '2021-04-15 13:02:50.263343', NULL),
	(10006262, 4, 'PW21A-TS100193BL-L', 2, 0, '2021-04-15 13:02:50.240800', '2021-04-15 13:02:50.240800', NULL),
	(10006263, 4, 'PW21A-TS100193BL-XL', 2, 0, '2021-04-15 13:02:50.269799', '2021-04-15 13:02:50.269799', NULL),
	(10006264, 4, 'PW21A-TS100193BL-XXL', 2, 0, '2021-04-15 13:02:50.242144', '2021-04-15 13:02:50.242144', NULL),
	(10006265, 4, 'PW21A-TS100194RD-XS', 0, 0, '2021-04-15 13:02:50.266312', '2021-04-15 13:02:50.266312', NULL),
	(10006266, 4, 'PW21A-TS100194RD-S', 1, 0, '2021-04-15 13:02:50.241703', '2021-04-15 13:02:50.241703', NULL),
	(10006267, 4, 'PW21A-TS100194RD-M', 0, 0, '2021-04-15 13:02:50.259223', '2021-04-15 13:02:50.259223', NULL),
	(10006268, 4, 'PW21A-TS100194RD-L', 2, 0, '2021-04-15 13:02:50.255610', '2021-04-15 13:02:50.255610', NULL),
	(10006269, 4, 'PW21A-TS100194RD-XL', 1, 0, '2021-04-15 13:02:50.267493', '2021-04-15 13:02:50.267493', NULL),
	(10006270, 4, 'PW21A-TS100194RD-XXL', 0, 0, '2021-04-15 13:02:50.269354', '2021-04-15 13:02:50.269354', NULL),
	(10006271, 4, 'PW21A-TS100195BL-XS', 0, 0, '2021-04-15 13:02:50.282498', '2021-04-15 13:02:50.282498', NULL),
	(10006272, 4, 'PW21A-TS100195BL-S', 2, 0, '2021-04-15 13:02:50.293166', '2021-04-15 13:02:50.293166', NULL),
	(10006273, 4, 'PW21A-TS100195BL-M', 2, 0, '2021-04-15 13:02:50.270746', '2021-04-15 13:02:50.270746', NULL),
	(10006274, 4, 'PW21A-TS100195BL-L', 2, 0, '2021-04-15 13:02:50.267903', '2021-04-15 13:02:50.267903', NULL),
	(10006275, 4, 'PW21A-TS100195BL-XL', 2, 0, '2021-04-15 13:02:50.311394', '2021-04-15 13:02:50.311394', NULL),
	(10006276, 4, 'PW21A-TS100195BL-XXL', 2, 0, '2021-04-15 13:02:50.357984', '2021-04-15 13:02:50.357984', NULL),
	(10006277, 4, 'PW21A-TS100196BL-XS', 0, 0, '2021-04-15 13:02:50.285324', '2021-04-15 13:02:50.285324', NULL),
	(10006278, 4, 'PW21A-TS100196BL-S', 2, 0, '2021-04-15 13:02:50.295243', '2021-04-15 13:02:50.295243', NULL),
	(10006279, 4, 'PW21A-TS100196BL-M', 2, 0, '2021-04-15 13:02:50.336620', '2021-04-15 13:02:50.336620', NULL),
	(10006280, 4, 'PW21A-TS100196BL-L', 2, 0, '2021-04-15 13:02:50.296368', '2021-04-15 13:02:50.296368', NULL),
	(10006281, 4, 'PW21A-TS100196BL-XL', 2, 0, '2021-04-15 13:02:50.290080', '2021-04-15 13:02:50.290080', NULL),
	(10006282, 4, 'PW21A-TS100196BL-XXL', 2, 0, '2021-04-15 13:02:50.314374', '2021-04-15 13:02:50.314374', NULL),
	(10006283, 4, 'PW21A-TS100197BL-XS', 0, 0, '2021-04-15 13:02:50.294608', '2021-04-15 13:02:50.294608', NULL),
	(10006284, 4, 'PW21A-TS100197BL-S', 0, 0, '2021-04-15 13:02:50.298059', '2021-04-15 13:02:50.298059', NULL),
	(10006285, 4, 'PW21A-TS100197BL-M', 0, 0, '2021-04-15 13:02:50.335463', '2021-04-15 13:02:50.335463', NULL),
	(10006286, 4, 'PW21A-TS100197BL-L', 0, 0, '2021-04-15 13:02:50.297561', '2021-04-15 13:02:50.297561', NULL),
	(10006287, 4, 'PW21A-TS100197BL-XL', 0, 0, '2021-04-15 13:02:50.298543', '2021-04-15 13:02:50.298543', NULL),
	(10006288, 4, 'PW21A-TS100197BL-XXL', 0, 0, '2021-04-15 13:02:50.324918', '2021-04-15 13:02:50.324918', NULL),
	(10006289, 4, 'PW21A-TS100198BL-XS', 0, 0, '2021-04-15 13:02:50.338668', '2021-04-15 13:02:50.338668', NULL),
	(10006290, 4, 'PW21A-TS100198BL-S', 2, 0, '2021-04-15 13:02:50.345458', '2021-04-15 13:02:50.345458', NULL),
	(10006291, 4, 'PW21A-TS100198BL-M', 2, 0, '2021-04-15 13:02:50.327503', '2021-04-15 13:02:50.327503', NULL),
	(10006292, 4, 'PW21A-TS100198BL-L', 2, 0, '2021-04-15 13:02:50.317192', '2021-04-15 13:02:50.317192', NULL),
	(10006293, 4, 'PW21A-TS100198BL-XL', 1, 0, '2021-04-15 13:02:50.350676', '2021-04-15 13:02:50.350676', NULL),
	(10006294, 4, 'PW21A-TS100198BL-XXL', 2, 0, '2021-04-15 13:02:50.338211', '2021-04-15 13:02:50.338211', NULL),
	(10006295, 4, 'PW21A-TS100199BL-XS', 0, 0, '2021-04-15 13:02:50.328011', '2021-04-15 13:02:50.328011', NULL),
	(10006296, 4, 'PW21A-TS100199BL-S', 0, 0, '2021-04-15 13:02:50.353933', '2021-04-15 13:02:50.353933', NULL),
	(10006297, 4, 'PW21A-TS100199BL-M', 0, 0, '2021-04-15 13:02:50.375953', '2021-04-15 13:02:50.375953', NULL),
	(10006298, 4, 'PW21A-TS100199BL-L', 0, 0, '2021-04-15 13:02:50.364541', '2021-04-15 13:02:50.364541', NULL),
	(10006299, 4, 'PW21A-TS100199BL-XL', 0, 0, '2021-04-15 13:02:50.360813', '2021-04-15 13:02:50.360813', NULL),
	(10006300, 4, 'PW21A-TS100199BL-XXL', 0, 0, '2021-04-15 13:02:50.359501', '2021-04-15 13:02:50.359501', NULL),
	(10006301, 4, 'PW21A-TS100200BL-XS', 0, 0, '2021-04-15 13:02:50.363569', '2021-04-15 13:02:50.363569', NULL),
	(10006302, 4, 'PW21A-TS100200BL-S', 0, 0, '2021-04-15 13:02:50.361476', '2021-04-15 13:02:50.361476', NULL),
	(10006303, 4, 'PW21A-TS100200BL-M', 0, 0, '2021-04-15 13:02:50.439392', '2021-04-15 13:02:50.439392', NULL),
	(10006304, 4, 'PW21A-TS100200BL-L', 0, 0, '2021-04-15 13:02:50.378777', '2021-04-15 13:02:50.378777', NULL),
	(10006305, 4, 'PW21A-TS100200BL-XL', 0, 0, '2021-04-15 13:02:50.447385', '2021-04-15 13:02:50.447385', NULL),
	(10006306, 4, 'PW21A-TS100200BL-XXL', 0, 0, '2021-04-15 13:02:50.371968', '2021-04-15 13:02:50.371968', NULL),
	(10006307, 4, 'PW21A-TS100201BL-XS', 0, 0, '2021-04-15 13:02:50.384131', '2021-04-15 13:02:50.384131', NULL),
	(10006308, 4, 'PW21A-TS100201BL-S', 1, 0, '2021-04-15 13:02:50.386540', '2021-04-15 13:02:50.386540', NULL),
	(10006309, 4, 'PW21A-TS100201BL-M', 0, 0, '2021-04-15 13:02:50.387474', '2021-04-15 13:02:50.387474', NULL),
	(10006310, 4, 'PW21A-TS100201BL-L', 2, 0, '2021-04-15 13:02:50.365491', '2021-04-15 13:02:50.365491', NULL),
	(10006311, 4, 'PW21A-TS100201BL-XL', 2, 0, '2021-04-15 13:02:50.394144', '2021-04-15 13:02:50.394144', NULL),
	(10006312, 4, 'PW21A-TS100201BL-XXL', 1, 0, '2021-04-15 13:02:50.384981', '2021-04-15 13:02:50.384981', NULL),
	(10006313, 4, 'PW21A-TS100202BL-XS', 0, 0, '2021-04-15 13:02:50.433881', '2021-04-15 13:02:50.433881', NULL),
	(10006314, 4, 'PW21A-TS100202BL-S', 2, 0, '2021-04-15 13:02:50.395491', '2021-04-15 13:02:50.395491', NULL),
	(10006315, 4, 'PW21A-TS100202BL-M', 2, 0, '2021-04-15 13:02:50.421215', '2021-04-15 13:02:50.421215', NULL),
	(10006316, 4, 'PW21A-TS100202BL-L', 1, 0, '2021-04-15 13:02:50.408270', '2021-04-15 13:02:50.408270', NULL),
	(10006317, 4, 'PW21A-TS100202BL-XL', 3, 0, '2021-04-15 13:02:50.392245', '2021-04-15 13:02:50.392245', NULL),
	(10006318, 4, 'PW21A-TS100202BL-XXL', 0, 0, '2021-04-15 13:02:50.433036', '2021-04-15 13:02:50.433036', NULL),
	(10006319, 4, 'PW21A-TS100203BL-XS', 0, 0, '2021-04-15 13:02:50.417064', '2021-04-15 13:02:50.417064', NULL),
	(10006320, 4, 'PW21A-TS100203BL-S', 2, 0, '2021-04-15 13:02:50.548645', '2021-04-15 13:02:50.548645', NULL),
	(10006321, 4, 'PW21A-TS100203BL-M', 2, 0, '2021-04-15 13:02:50.495745', '2021-04-15 13:02:50.495745', NULL),
	(10006322, 4, 'PW21A-TS100203BL-L', 2, 0, '2021-04-15 13:02:50.449517', '2021-04-15 13:02:50.449517', NULL),
	(10006323, 4, 'PW21A-TS100203BL-XL', 2, 0, '2021-04-15 13:02:50.437387', '2021-04-15 13:02:50.437387', NULL),
	(10006324, 4, 'PW21A-TS100203BL-XXL', 2, 0, '2021-04-15 13:02:50.520751', '2021-04-15 13:02:50.520751', NULL),
	(10006325, 4, 'PW21A-TS100204BL-XS', 0, 0, '2021-04-15 13:02:50.489922', '2021-04-15 13:02:50.489922', NULL),
	(10006326, 4, 'PW21A-TS100204BL-S', 0, 0, '2021-04-15 13:02:50.451178', '2021-04-15 13:02:50.451178', NULL),
	(10006327, 4, 'PW21A-TS100204BL-M', 0, 0, '2021-04-15 13:02:50.516454', '2021-04-15 13:02:50.516454', NULL),
	(10006328, 4, 'PW21A-TS100204BL-L', 0, 0, '2021-04-15 13:02:50.519324', '2021-04-15 13:02:50.519324', NULL),
	(10006329, 4, 'PW21A-TS100204BL-XL', 0, 0, '2021-04-15 13:02:50.591808', '2021-04-15 13:02:50.591808', NULL),
	(10006330, 4, 'PW21A-TS100204BL-XXL', 0, 0, '2021-04-15 13:02:50.571907', '2021-04-15 13:02:50.571907', NULL),
	(10006331, 4, 'PW21A-TS100205WT-XS', 0, 0, '2021-04-15 13:02:50.517093', '2021-04-15 13:02:50.517093', NULL),
	(10006332, 4, 'PW21A-TS100205WT-S', 0, 0, '2021-04-15 13:02:50.519962', '2021-04-15 13:02:50.519962', NULL),
	(10006333, 4, 'PW21A-TS100205WT-M', 0, 0, '2021-04-15 13:02:50.494711', '2021-04-15 13:02:50.494711', NULL),
	(10006334, 4, 'PW21A-TS100205WT-L', 0, 0, '2021-04-15 13:02:50.546462', '2021-04-15 13:02:50.546462', NULL),
	(10006335, 4, 'PW21A-TS100205WT-XL', 0, 0, '2021-04-15 13:02:50.619094', '2021-04-15 13:02:50.619094', NULL),
	(10006336, 4, 'PW21A-TS100205WT-XXL', 0, 0, '2021-04-15 13:02:50.526117', '2021-04-15 13:02:50.526117', NULL),
	(10006337, 4, 'PW21A-TS100206WT-XS', 0, 0, '2021-04-15 13:02:50.576768', '2021-04-15 13:02:50.576768', NULL),
	(10006338, 4, 'PW21A-TS100206WT-S', 0, 0, '2021-04-15 13:02:50.579832', '2021-04-15 13:02:50.579832', NULL),
	(10006339, 4, 'PW21A-TS100206WT-M', 0, 0, '2021-04-15 13:02:50.522363', '2021-04-15 13:02:50.522363', NULL),
	(10006340, 4, 'PW21A-TS100206WT-L', 0, 0, '2021-04-15 13:02:50.545594', '2021-04-15 13:02:50.545594', NULL),
	(10006341, 4, 'PW21A-TS100206WT-XL', 0, 0, '2021-04-15 13:02:50.619684', '2021-04-15 13:02:50.619684', NULL),
	(10006342, 4, 'PW21A-TS100206WT-XXL', 0, 0, '2021-04-15 13:02:50.595396', '2021-04-15 13:02:50.595396', NULL),
	(10006343, 4, 'PW21A-TS100207BL-XS', 0, 0, '2021-04-15 13:02:50.704986', '2021-04-15 13:02:50.704986', NULL),
	(10006344, 4, 'PW21A-TS100207BL-S', 2, 0, '2021-04-15 13:02:50.590467', '2021-04-15 13:02:50.590467', NULL),
	(10006345, 4, 'PW21A-TS100207BL-M', 2, 0, '2021-04-15 13:02:50.704433', '2021-04-15 13:02:50.704433', NULL),
	(10006346, 4, 'PW21A-TS100207BL-L', 2, 0, '2021-04-15 13:02:50.577750', '2021-04-15 13:02:50.577750', NULL),
	(10006347, 4, 'PW21A-TS100207BL-XL', 2, 0, '2021-04-15 13:02:50.648622', '2021-04-15 13:02:50.648622', NULL),
	(10006348, 4, 'PW21A-TS100207BL-XXL', 1, 0, '2021-04-15 13:02:50.664223', '2021-04-15 13:02:50.664223', NULL),
	(10006349, 4, 'PW21A-TS100208BL-XS', 0, 0, '2021-04-15 13:02:50.624707', '2021-04-15 13:02:50.624707', NULL),
	(10006350, 4, 'PW21A-TS100208BL-S', 0, 0, '2021-04-15 13:02:50.649549', '2021-04-15 13:02:50.649549', NULL),
	(10006351, 4, 'PW21A-TS100208BL-M', 0, 0, '2021-04-15 13:02:50.644964', '2021-04-15 13:02:50.644964', NULL),
	(10006352, 4, 'PW21A-TS100208BL-L', 0, 0, '2021-04-15 13:02:50.643568', '2021-04-15 13:02:50.643568', NULL),
	(10006353, 4, 'PW21A-TS100208BL-XL', 0, 0, '2021-04-15 13:02:50.698313', '2021-04-15 13:02:50.698313', NULL),
	(10006354, 4, 'PW21A-TS100208BL-XXL', 0, 0, '2021-04-15 13:02:50.664741', '2021-04-15 13:02:50.664741', NULL),
	(10006355, 4, 'PW21A-TS100209BL-XS', 0, 0, '2021-04-15 13:02:50.670971', '2021-04-15 13:02:50.670971', NULL),
	(10006356, 4, 'PW21A-TS100209BL-S', 2, 0, '2021-04-15 13:02:50.654358', '2021-04-15 13:02:50.654358', NULL),
	(10006357, 4, 'PW21A-TS100209BL-M', 2, 0, '2021-04-15 13:02:50.675192', '2021-04-15 13:02:50.675192', NULL),
	(10006358, 4, 'PW21A-TS100209BL-L', 2, 0, '2021-04-15 13:02:50.675968', '2021-04-15 13:02:50.675968', NULL),
	(10006359, 4, 'PW21A-TS100209BL-XL', 3, 0, '2021-04-15 13:02:50.674197', '2021-04-15 13:02:50.674197', NULL),
	(10006360, 4, 'PW21A-TS100209BL-XXL', 0, 0, '2021-04-15 13:02:50.766432', '2021-04-15 13:02:50.766432', NULL),
	(10006361, 4, 'PW21A-TS100210BL-XS', 0, 0, '2021-04-15 13:02:50.685680', '2021-04-15 13:02:50.685680', NULL),
	(10006362, 4, 'PW21A-TS100210BL-S', 0, 0, '2021-04-15 13:02:50.702539', '2021-04-15 13:02:50.702539', NULL),
	(10006363, 4, 'PW21A-TS100210BL-M', 0, 0, '2021-04-15 13:02:50.689281', '2021-04-15 13:02:50.689281', NULL),
	(10006364, 4, 'PW21A-TS100210BL-L', 0, 0, '2021-04-15 13:02:50.696918', '2021-04-15 13:02:50.696918', NULL),
	(10006365, 4, 'PW21A-TS100210BL-XL', 0, 0, '2021-04-15 13:02:50.683333', '2021-04-15 13:02:50.683333', NULL),
	(10006366, 4, 'PW21A-TS100210BL-XXL', 0, 0, '2021-04-15 13:02:50.705628', '2021-04-15 13:02:50.705628', NULL),
	(10006367, 4, 'PW21A-TS100211BL-XS', 0, 0, '2021-04-15 13:02:50.690459', '2021-04-15 13:02:50.690459', NULL),
	(10006368, 4, 'PW21A-TS100211BL-S', 0, 0, '2021-04-15 13:02:50.732688', '2021-04-15 13:02:50.732688', NULL),
	(10006369, 4, 'PW21A-TS100211BL-M', 0, 0, '2021-04-15 13:02:50.735959', '2021-04-15 13:02:50.735959', NULL),
	(10006370, 4, 'PW21A-TS100211BL-L', 0, 0, '2021-04-15 13:02:50.712818', '2021-04-15 13:02:50.712818', NULL),
	(10006371, 4, 'PW21A-TS100211BL-XL', 0, 0, '2021-04-15 13:02:50.710866', '2021-04-15 13:02:50.710866', NULL),
	(10006372, 4, 'PW21A-TS100211BL-XXL', 0, 0, '2021-04-15 13:02:50.725749', '2021-04-15 13:02:50.725749', NULL),
	(10006373, 4, 'PW21A-TS100212GN-XS', 0, 0, '2021-04-15 13:02:50.752310', '2021-04-15 13:02:50.752310', NULL),
	(10006374, 4, 'PW21A-TS100212GN-S', 0, 0, '2021-04-15 13:02:50.726406', '2021-04-15 13:02:50.726406', NULL),
	(10006375, 4, 'PW21A-TS100212GN-M', 0, 0, '2021-04-15 13:02:50.771614', '2021-04-15 13:02:50.771614', NULL),
	(10006376, 4, 'PW21A-TS100212GN-L', 0, 0, '2021-04-15 13:02:50.756300', '2021-04-15 13:02:50.756300', NULL),
	(10006377, 4, 'PW21A-TS100212GN-XL', 0, 0, '2021-04-15 13:02:50.796650', '2021-04-15 13:02:50.796650', NULL),
	(10006378, 4, 'PW21A-TS100212GN-XXL', 0, 0, '2021-04-15 13:02:50.733974', '2021-04-15 13:02:50.733974', NULL),
	(10006379, 4, 'PW21A-TS100213BL-XS', 0, 0, '2021-04-15 13:02:50.756900', '2021-04-15 13:02:50.756900', NULL),
	(10006380, 4, 'PW21A-TS100213BL-S', 2, 0, '2021-04-15 13:02:50.740834', '2021-04-15 13:02:50.740834', NULL),
	(10006381, 4, 'PW21A-TS100213BL-M', 2, 0, '2021-04-15 13:02:50.752698', '2021-04-15 13:02:50.752698', NULL),
	(10006382, 4, 'PW21A-TS100213BL-L', 3, 0, '2021-04-15 13:02:50.793177', '2021-04-15 13:02:50.793177', NULL),
	(10006383, 4, 'PW21A-TS100213BL-XL', 2, 0, '2021-04-15 13:02:50.758272', '2021-04-15 13:02:50.758272', NULL),
	(10006384, 4, 'PW21A-TS100213BL-XXL', 2, 0, '2021-04-15 13:02:50.764002', '2021-04-15 13:02:50.764002', NULL),
	(10006385, 4, 'PW21A-TS100214BL-XS', 0, 0, '2021-04-15 13:02:50.767273', '2021-04-15 13:02:50.767273', NULL),
	(10006386, 4, 'PW21A-TS100214BL-S', 0, 0, '2021-04-15 13:02:50.757407', '2021-04-15 13:02:50.757407', NULL),
	(10006387, 4, 'PW21A-TS100214BL-M', 0, 0, '2021-04-15 13:02:50.834007', '2021-04-15 13:02:50.834007', NULL),
	(10006388, 4, 'PW21A-TS100214BL-L', 0, 0, '2021-04-15 13:02:50.792374', '2021-04-15 13:02:50.792374', NULL),
	(10006389, 4, 'PW21A-TS100214BL-XL', 0, 0, '2021-04-15 13:02:50.861726', '2021-04-15 13:02:50.861726', NULL),
	(10006390, 4, 'PW21A-TS100214BL-XXL', 0, 0, '2021-04-15 13:02:50.793839', '2021-04-15 13:02:50.793839', NULL),
	(10006391, 4, 'PW21A-TS100215BL-XS', 0, 0, '2021-04-15 13:02:50.796200', '2021-04-15 13:02:50.796200', NULL),
	(10006392, 4, 'PW21A-TS100215BL-S', 0, 0, '2021-04-15 13:02:50.797077', '2021-04-15 13:02:50.797077', NULL),
	(10006393, 4, 'PW21A-TS100215BL-M', 0, 0, '2021-04-15 13:02:50.825595', '2021-04-15 13:02:50.825595', NULL),
	(10006394, 4, 'PW21A-TS100215BL-L', 0, 0, '2021-04-15 13:02:50.829027', '2021-04-15 13:02:50.829027', NULL),
	(10006395, 4, 'PW21A-TS100215BL-XL', 0, 0, '2021-04-15 13:02:50.799961', '2021-04-15 13:02:50.799961', NULL),
	(10006396, 4, 'PW21A-TS100215BL-XXL', 0, 0, '2021-04-15 13:02:50.805167', '2021-04-15 13:02:50.805167', NULL),
	(10006397, 4, 'PW21A-TS100216NV-XS', 0, 0, '2021-04-15 13:02:50.869811', '2021-04-15 13:02:50.869811', NULL),
	(10006398, 4, 'PW21A-TS100216NV-S', 0, 0, '2021-04-15 13:02:50.808527', '2021-04-15 13:02:50.808527', NULL),
	(10006399, 4, 'PW21A-TS100216NV-M', 0, 0, '2021-04-15 13:02:50.805689', '2021-04-15 13:02:50.805689', NULL),
	(10006400, 4, 'PW21A-TS100216NV-L', 0, 0, '2021-04-15 13:02:50.830269', '2021-04-15 13:02:50.830269', NULL),
	(10006401, 4, 'PW21A-TS100216NV-XL', 0, 0, '2021-04-15 13:02:50.839784', '2021-04-15 13:02:50.839784', NULL),
	(10006402, 4, 'PW21A-TS100216NV-XXL', 0, 0, '2021-04-15 13:02:50.829652', '2021-04-15 13:02:50.829652', NULL),
	(10006403, 4, 'PW21A-TS100217BL-XS', 0, 0, '2021-04-15 13:02:50.834859', '2021-04-15 13:02:50.834859', NULL),
	(10006404, 4, 'PW21A-TS100217BL-S', 0, 0, '2021-04-15 13:02:50.824516', '2021-04-15 13:02:50.824516', NULL),
	(10006405, 4, 'PW21A-TS100217BL-M', 0, 0, '2021-04-15 13:02:50.944601', '2021-04-15 13:02:50.944601', NULL),
	(10006406, 4, 'PW21A-TS100217BL-L', 0, 0, '2021-04-15 13:02:50.866294', '2021-04-15 13:02:50.866294', NULL),
	(10006407, 4, 'PW21A-TS100217BL-XL', 0, 0, '2021-04-15 13:02:50.840262', '2021-04-15 13:02:50.840262', NULL),
	(10006408, 4, 'PW21A-TS100217BL-XXL', 0, 0, '2021-04-15 13:02:50.865742', '2021-04-15 13:02:50.865742', NULL),
	(10006409, 4, 'PW21A-TS100218BL-XS', 0, 0, '2021-04-15 13:02:50.940877', '2021-04-15 13:02:50.940877', NULL),
	(10006410, 4, 'PW21A-TS100218BL-S', 2, 0, '2021-04-15 13:02:50.843278', '2021-04-15 13:02:50.843278', NULL),
	(10006411, 4, 'PW21A-TS100218BL-M', 2, 0, '2021-04-15 13:02:50.864360', '2021-04-15 13:02:50.864360', NULL),
	(10006412, 4, 'PW21A-TS100218BL-L', 2, 0, '2021-04-15 13:02:50.877898', '2021-04-15 13:02:50.877898', NULL),
	(10006413, 4, 'PW21A-TS100218BL-XL', 0, 0, '2021-04-15 13:02:50.861155', '2021-04-15 13:02:50.861155', NULL),
	(10006414, 4, 'PW21A-TS100218BL-XXL', 0, 0, '2021-04-15 13:02:50.867223', '2021-04-15 13:02:50.867223', NULL),
	(10006415, 4, 'PW21A-TS100219BL-XS', 0, 0, '2021-04-15 13:02:50.874630', '2021-04-15 13:02:50.874630', NULL),
	(10006416, 4, 'PW21A-TS100219BL-S', 2, 0, '2021-04-15 13:02:50.894279', '2021-04-15 13:02:50.894279', NULL),
	(10006417, 4, 'PW21A-TS100219BL-M', 2, 0, '2021-04-15 13:02:50.899705', '2021-04-15 13:02:50.899705', NULL),
	(10006418, 4, 'PW21A-TS100219BL-L', 2, 0, '2021-04-15 13:02:50.876008', '2021-04-15 13:02:50.876008', NULL),
	(10006419, 4, 'PW21A-TS100219BL-XL', 2, 0, '2021-04-15 13:02:50.903385', '2021-04-15 13:02:50.903385', NULL),
	(10006420, 4, 'PW21A-TS100219BL-XXL', 2, 0, '2021-04-15 13:02:50.907572', '2021-04-15 13:02:50.907572', NULL),
	(10006421, 4, 'PW21A-TS100220BL-XS', 0, 0, '2021-04-15 13:02:50.900507', '2021-04-15 13:02:50.900507', NULL),
	(10006422, 4, 'PW21A-TS100220BL-S', 2, 0, '2021-04-15 13:02:50.904432', '2021-04-15 13:02:50.904432', NULL),
	(10006423, 4, 'PW21A-TS100220BL-M', 2, 0, '2021-04-15 13:02:50.911332', '2021-04-15 13:02:50.911332', NULL),
	(10006424, 4, 'PW21A-TS100220BL-L', 2, 0, '2021-04-15 13:02:50.933667', '2021-04-15 13:02:50.933667', NULL),
	(10006425, 4, 'PW21A-TS100220BL-XL', 2, 0, '2021-04-15 13:02:50.910170', '2021-04-15 13:02:50.910170', NULL),
	(10006426, 4, 'PW21A-TS100220BL-XXL', 2, 0, '2021-04-15 13:02:50.927759', '2021-04-15 13:02:50.927759', NULL),
	(10006427, 4, 'PW21A-TK100221BL-XS', 0, 0, '2021-04-15 13:02:50.915649', '2021-04-15 13:02:50.915649', NULL),
	(10006428, 4, 'PW21A-TK100221BL-S', 0, 0, '2021-04-15 13:02:50.938157', '2021-04-15 13:02:50.938157', NULL),
	(10006429, 4, 'PW21A-TK100221BL-M', 2, 0, '2021-04-15 13:02:50.911834', '2021-04-15 13:02:50.911834', NULL),
	(10006430, 4, 'PW21A-TK100221BL-L', 2, 0, '2021-04-15 13:02:50.934137', '2021-04-15 13:02:50.934137', NULL),
	(10006431, 4, 'PW21A-TK100221BL-XL', 2, 0, '2021-04-15 13:02:50.956506', '2021-04-15 13:02:50.956506', NULL),
	(10006432, 4, 'PW21A-TK100221BL-XXL', 1, 0, '2021-04-15 13:02:50.972058', '2021-04-15 13:02:50.972058', NULL),
	(10006433, 4, 'PW21A-TS100222BL-XS', 0, 0, '2021-04-15 13:02:50.952385', '2021-04-15 13:02:50.952385', NULL),
	(10006434, 4, 'PW21A-TS100222BL-S', 2, 0, '2021-04-15 13:02:50.981394', '2021-04-15 13:02:50.981394', NULL),
	(10006435, 4, 'PW21A-TS100222BL-M', 2, 0, '2021-04-15 13:02:50.975928', '2021-04-15 13:02:50.975928', NULL),
	(10006436, 4, 'PW21A-TS100222BL-L', 2, 0, '2021-04-15 13:02:50.939659', '2021-04-15 13:02:50.939659', NULL),
	(10006437, 4, 'PW21A-TS100222BL-XL', 2, 0, '2021-04-15 13:02:50.977175', '2021-04-15 13:02:50.977175', NULL),
	(10006438, 4, 'PW21A-TS100222BL-XXL', 2, 0, '2021-04-15 13:02:50.954216', '2021-04-15 13:02:50.954216', NULL),
	(10006439, 4, 'PW21A-TS100223BL-XS', 0, 0, '2021-04-15 13:02:50.976737', '2021-04-15 13:02:50.976737', NULL),
	(10006440, 4, 'PW21A-TS100223BL-S', 0, 0, '2021-04-15 13:02:50.977594', '2021-04-15 13:02:50.977594', NULL),
	(10006441, 4, 'PW21A-TS100223BL-M', 0, 0, '2021-04-15 13:02:51.057108', '2021-04-15 13:02:51.057108', NULL),
	(10006442, 4, 'PW21A-TS100223BL-L', 0, 0, '2021-04-15 13:02:51.008231', '2021-04-15 13:02:51.008231', NULL),
	(10006443, 4, 'PW21A-TS100223BL-XL', 0, 0, '2021-04-15 13:02:50.985130', '2021-04-15 13:02:50.985130', NULL),
	(10006444, 4, 'PW21A-TS100223BL-XXL', 0, 0, '2021-04-15 13:02:51.040295', '2021-04-15 13:02:51.040295', NULL),
	(10006445, 4, 'PW21A-TK100224BL-XS', 0, 0, '2021-04-15 13:02:50.993563', '2021-04-15 13:02:50.993563', NULL),
	(10006446, 4, 'PW21A-TK100224BL-S', 0, 0, '2021-04-15 13:02:51.012764', '2021-04-15 13:02:51.012764', NULL),
	(10006447, 4, 'PW21A-TK100224BL-M', 0, 0, '2021-04-15 13:02:50.983617', '2021-04-15 13:02:50.983617', NULL),
	(10006448, 4, 'PW21A-TK100224BL-L', 2, 0, '2021-04-15 13:02:51.044421', '2021-04-15 13:02:51.044421', NULL),
	(10006449, 4, 'PW21A-TK100224BL-XL', 0, 0, '2021-04-15 13:02:51.021885', '2021-04-15 13:02:51.021885', NULL),
	(10006450, 4, 'PW21A-TK100224BL-XXL', 0, 0, '2021-04-15 13:02:50.991338', '2021-04-15 13:02:50.991338', NULL),
	(10006451, 4, 'PW21A-TK100225BL-XS', 0, 0, '2021-04-15 13:02:51.011052', '2021-04-15 13:02:51.011052', NULL),
	(10006452, 4, 'PW21A-TK100225BL-S', 0, 0, '2021-04-15 13:02:51.013225', '2021-04-15 13:02:51.013225', NULL),
	(10006453, 4, 'PW21A-TK100225BL-M', 2, 0, '2021-04-15 13:02:51.024288', '2021-04-15 13:02:51.024288', NULL),
	(10006454, 4, 'PW21A-TK100225BL-L', 2, 0, '2021-04-15 13:02:51.039000', '2021-04-15 13:02:51.039000', NULL),
	(10006455, 4, 'PW21A-TK100225BL-XL', 2, 0, '2021-04-15 13:02:51.014306', '2021-04-15 13:02:51.014306', NULL),
	(10006456, 4, 'PW21A-TK100225BL-XXL', 0, 0, '2021-04-15 13:02:51.027065', '2021-04-15 13:02:51.027065', NULL),
	(10006457, 4, 'PW21A-TS100226BL-XS', 0, 0, '2021-04-15 13:02:51.013839', '2021-04-15 13:02:51.013839', NULL),
	(10006458, 4, 'PW21A-TS100226BL-S', 2, 0, '2021-04-15 13:02:51.039841', '2021-04-15 13:02:51.039841', NULL),
	(10006459, 4, 'PW21A-TS100226BL-M', 1, 0, '2021-04-15 13:02:51.023059', '2021-04-15 13:02:51.023059', NULL),
	(10006460, 4, 'PW21A-TS100226BL-L', 2, 0, '2021-04-15 13:02:51.040761', '2021-04-15 13:02:51.040761', NULL),
	(10006461, 4, 'PW21A-TS100226BL-XL', 2, 0, '2021-04-15 13:02:51.053172', '2021-04-15 13:02:51.053172', NULL),
	(10006462, 4, 'PW21A-TS100226BL-XXL', 0, 0, '2021-04-15 13:02:51.041226', '2021-04-15 13:02:51.041226', NULL),
	(10006463, 4, 'PW21A-TK100227BL-XS', 0, 0, '2021-04-15 13:02:51.059733', '2021-04-15 13:02:51.059733', NULL),
	(10006464, 4, 'PW21A-TK100227BL-S', 0, 0, '2021-04-15 13:02:51.084347', '2021-04-15 13:02:51.084347', NULL),
	(10006465, 4, 'PW21A-TK100227BL-M', 2, 0, '2021-04-15 13:02:51.058339', '2021-04-15 13:02:51.058339', NULL),
	(10006466, 4, 'PW21A-TK100227BL-L', 2, 0, '2021-04-15 13:02:51.083557', '2021-04-15 13:02:51.083557', NULL),
	(10006467, 4, 'PW21A-TK100227BL-XL', 2, 0, '2021-04-15 13:02:51.156034', '2021-04-15 13:02:51.156034', NULL),
	(10006468, 4, 'PW21A-TK100227BL-XXL', 1, 0, '2021-04-15 13:02:51.171079', '2021-04-15 13:02:51.171079', NULL),
	(10006469, 4, 'PW21A-TS100228BL-XS', 0, 0, '2021-04-15 13:02:51.085416', '2021-04-15 13:02:51.085416', NULL),
	(10006470, 4, 'PW21A-TS100228BL-S', 2, 0, '2021-04-15 13:02:51.087369', '2021-04-15 13:02:51.087369', NULL),
	(10006471, 4, 'PW21A-TS100228BL-M', 0, 0, '2021-04-15 13:02:51.084772', '2021-04-15 13:02:51.084772', NULL),
	(10006472, 4, 'PW21A-TS100228BL-L', 2, 0, '2021-04-15 13:02:51.101297', '2021-04-15 13:02:51.101297', NULL),
	(10006473, 4, 'PW21A-TS100228BL-XL', 2, 0, '2021-04-15 13:02:51.085989', '2021-04-15 13:02:51.085989', NULL),
	(10006474, 4, 'PW21A-TS100228BL-XXL', 2, 0, '2021-04-15 13:02:51.103291', '2021-04-15 13:02:51.103291', NULL),
	(10006475, 4, 'PW21A-TK100229BL-XS', 0, 0, '2021-04-15 13:02:51.155183', '2021-04-15 13:02:51.155183', NULL),
	(10006476, 4, 'PW21A-TK100229BL-S', 0, 0, '2021-04-15 13:02:51.102687', '2021-04-15 13:02:51.102687', NULL),
	(10006477, 4, 'PW21A-TK100229BL-M', 2, 0, '2021-04-15 13:02:51.119115', '2021-04-15 13:02:51.119115', NULL),
	(10006478, 4, 'PW21A-TK100229BL-L', 2, 0, '2021-04-15 13:02:51.120284', '2021-04-15 13:02:51.120284', NULL),
	(10006479, 4, 'PW21A-TK100229BL-XL', 2, 0, '2021-04-15 13:02:51.103749', '2021-04-15 13:02:51.103749', NULL),
	(10006480, 4, 'PW21A-TK100229BL-XXL', 2, 0, '2021-04-15 13:02:51.127011', '2021-04-15 13:02:51.127011', NULL),
	(10006481, 4, 'PW21A-TK100230BL-XS', 0, 0, '2021-04-15 13:02:51.119807', '2021-04-15 13:02:51.119807', NULL),
	(10006482, 4, 'PW21A-TK100230BL-S', 0, 0, '2021-04-15 13:02:51.127931', '2021-04-15 13:02:51.127931', NULL),
	(10006483, 4, 'PW21A-TK100230BL-M', 2, 0, '2021-04-15 13:02:51.127483', '2021-04-15 13:02:51.127483', NULL),
	(10006484, 4, 'PW21A-TK100230BL-L', 2, 0, '2021-04-15 13:02:51.154369', '2021-04-15 13:02:51.154369', NULL),
	(10006485, 4, 'PW21A-TK100230BL-XL', 2, 0, '2021-04-15 13:02:51.143772', '2021-04-15 13:02:51.143772', NULL),
	(10006486, 4, 'PW21A-TK100230BL-XXL', 0, 0, '2021-04-15 13:02:51.142240', '2021-04-15 13:02:51.142240', NULL),
	(10006487, 4, 'PW21A-TS100231BL-XS', 0, 0, '2021-04-15 13:02:51.142804', '2021-04-15 13:02:51.142804', NULL),
	(10006488, 4, 'PW21A-TS100231BL-S', 0, 0, '2021-04-15 13:02:51.143424', '2021-04-15 13:02:51.143424', NULL),
	(10006489, 4, 'PW21A-TS100231BL-M', 0, 0, '2021-04-15 13:02:51.154767', '2021-04-15 13:02:51.154767', NULL),
	(10006490, 4, 'PW21A-TS100231BL-L', 0, 0, '2021-04-15 13:02:51.156490', '2021-04-15 13:02:51.156490', NULL),
	(10006491, 4, 'PW21A-TS100231BL-XL', 0, 0, '2021-04-15 13:02:51.167126', '2021-04-15 13:02:51.167126', NULL),
	(10006492, 4, 'PW21A-TS100231BL-XXL', 0, 0, '2021-04-15 13:02:51.183897', '2021-04-15 13:02:51.183897', NULL),
	(10006493, 4, 'PW21A-TK100232GN-XS', 0, 0, '2021-04-15 13:02:51.155587', '2021-04-15 13:02:51.155587', NULL),
	(10006494, 4, 'PW21A-TK100232GN-S', 0, 0, '2021-04-15 13:02:51.204076', '2021-04-15 13:02:51.204076', NULL),
	(10006495, 4, 'PW21A-TK100232GN-M', 0, 0, '2021-04-15 13:02:51.182089', '2021-04-15 13:02:51.182089', NULL),
	(10006496, 4, 'PW21A-TK100232GN-L', 0, 0, '2021-04-15 13:02:51.184178', '2021-04-15 13:02:51.184178', NULL),
	(10006497, 4, 'PW21A-TK100232GN-XL', 0, 0, '2021-04-15 13:02:51.167558', '2021-04-15 13:02:51.167558', NULL),
	(10006498, 4, 'PW21A-TK100232GN-XXL', 0, 0, '2021-04-15 13:02:51.202866', '2021-04-15 13:02:51.202866', NULL),
	(10006499, 4, 'PW21A-TS100233BL-XS', 0, 0, '2021-04-15 13:02:51.183287', '2021-04-15 13:02:51.183287', NULL),
	(10006500, 4, 'PW21A-TS100233BL-S', 0, 0, '2021-04-15 13:02:51.168133', '2021-04-15 13:02:51.168133', NULL),
	(10006501, 4, 'PW21A-TS100233BL-M', 0, 0, '2021-04-15 13:02:51.183596', '2021-04-15 13:02:51.183596', NULL),
	(10006502, 4, 'PW21A-TS100233BL-L', 0, 0, '2021-04-15 13:02:51.193387', '2021-04-15 13:02:51.193387', NULL),
	(10006503, 4, 'PW21A-TS100233BL-XL', 0, 0, '2021-04-15 13:02:51.213025', '2021-04-15 13:02:51.213025', NULL),
	(10006504, 4, 'PW21A-TS100233BL-XXL', 0, 0, '2021-04-15 13:02:51.182477', '2021-04-15 13:02:51.182477', NULL),
	(10006505, 4, 'PW21A-TK100234BL-XS', 0, 0, '2021-04-15 13:02:51.193808', '2021-04-15 13:02:51.193808', NULL),
	(10006506, 4, 'PW21A-TK100234BL-S', 0, 0, '2021-04-15 13:02:51.194133', '2021-04-15 13:02:51.194133', NULL),
	(10006507, 4, 'PW21A-TK100234BL-M', 0, 0, '2021-04-15 13:02:51.231621', '2021-04-15 13:02:51.231621', NULL),
	(10006508, 4, 'PW21A-TK100234BL-L', 0, 0, '2021-04-15 13:02:51.201950', '2021-04-15 13:02:51.201950', NULL),
	(10006509, 4, 'PW21A-TK100234BL-XL', 0, 0, '2021-04-15 13:02:51.203430', '2021-04-15 13:02:51.203430', NULL),
	(10006510, 4, 'PW21A-TK100234BL-XXL', 0, 0, '2021-04-15 13:02:51.204385', '2021-04-15 13:02:51.204385', NULL),
	(10006511, 4, 'PW21A-TS100235BL-XS', 0, 0, '2021-04-15 13:02:51.195117', '2021-04-15 13:02:51.195117', NULL),
	(10006512, 4, 'PW21A-TS100235BL-S', 2, 0, '2021-04-15 13:02:51.203768', '2021-04-15 13:02:51.203768', NULL),
	(10006513, 4, 'PW21A-TS100235BL-M', 1, 0, '2021-04-15 13:02:51.223533', '2021-04-15 13:02:51.223533', NULL),
	(10006514, 4, 'PW21A-TS100235BL-L', 3, 0, '2021-04-15 13:02:51.213341', '2021-04-15 13:02:51.213341', NULL),
	(10006515, 4, 'PW21A-TS100235BL-XL', 2, 0, '2021-04-15 13:02:51.212580', '2021-04-15 13:02:51.212580', NULL),
	(10006516, 4, 'PW21A-TS100235BL-XXL', 0, 0, '2021-04-15 13:02:51.214346', '2021-04-15 13:02:51.214346', NULL),
	(10006517, 4, 'PW21A-TK100236WT-XS', 0, 0, '2021-04-15 13:02:51.221253', '2021-04-15 13:02:51.221253', NULL),
	(10006518, 4, 'PW21A-TK100236WT-S', 0, 0, '2021-04-15 13:02:51.222151', '2021-04-15 13:02:51.222151', NULL),
	(10006519, 4, 'PW21A-TK100236WT-M', 2, 0, '2021-04-15 13:02:51.250957', '2021-04-15 13:02:51.250957', NULL),
	(10006520, 4, 'PW21A-TK100236WT-L', 2, 0, '2021-04-15 13:02:51.223221', '2021-04-15 13:02:51.223221', NULL),
	(10006521, 4, 'PW21A-TK100236WT-XL', 2, 0, '2021-04-15 13:02:51.222568', '2021-04-15 13:02:51.222568', NULL),
	(10006522, 4, 'PW21A-TK100236WT-XXL', 2, 0, '2021-04-15 13:02:51.251487', '2021-04-15 13:02:51.251487', NULL),
	(10006523, 4, 'PW21A-TS100237BL-XS', 0, 0, '2021-04-15 13:02:51.222894', '2021-04-15 13:02:51.222894', NULL),
	(10006524, 4, 'PW21A-TS100237BL-S', 0, 0, '2021-04-15 13:02:51.233313', '2021-04-15 13:02:51.233313', NULL),
	(10006525, 4, 'PW21A-TS100237BL-M', 0, 0, '2021-04-15 13:02:51.232100', '2021-04-15 13:02:51.232100', NULL),
	(10006526, 4, 'PW21A-TS100237BL-L', 0, 0, '2021-04-15 13:02:51.248800', '2021-04-15 13:02:51.248800', NULL),
	(10006527, 4, 'PW21A-TS100237BL-XL', 0, 0, '2021-04-15 13:02:51.249767', '2021-04-15 13:02:51.249767', NULL),
	(10006528, 4, 'PW21A-TS100237BL-XXL', 0, 0, '2021-04-15 13:02:51.232419', '2021-04-15 13:02:51.232419', NULL),
	(10006529, 4, 'PW21A-TS100238BL-XS', 0, 0, '2021-04-15 13:02:51.287971', '2021-04-15 13:02:51.287971', NULL),
	(10006530, 4, 'PW21A-TS100238BL-S', 0, 0, '2021-04-15 13:02:51.251989', '2021-04-15 13:02:51.251989', NULL),
	(10006531, 4, 'PW21A-TS100238BL-M', 0, 0, '2021-04-15 13:02:51.329451', '2021-04-15 13:02:51.329451', NULL),
	(10006532, 4, 'PW21A-TS100238BL-L', 0, 0, '2021-04-15 13:02:51.263396', '2021-04-15 13:02:51.263396', NULL),
	(10006533, 4, 'PW21A-TS100238BL-XL', 0, 0, '2021-04-15 13:02:51.265871', '2021-04-15 13:02:51.265871', NULL),
	(10006534, 4, 'PW21A-TS100238BL-XXL', 0, 0, '2021-04-15 13:02:51.250409', '2021-04-15 13:02:51.250409', NULL),
	(10006535, 4, 'PW21A-TK100239OG-XS', 0, 0, '2021-04-15 13:02:51.319227', '2021-04-15 13:02:51.319227', NULL),
	(10006536, 4, 'PW21A-TK100239OG-S', 0, 0, '2021-04-15 13:02:51.283020', '2021-04-15 13:02:51.283020', NULL),
	(10006537, 4, 'PW21A-TK100239OG-M', 2, 0, '2021-04-15 13:02:51.280158', '2021-04-15 13:02:51.280158', NULL),
	(10006538, 4, 'PW21A-TK100239OG-L', 2, 0, '2021-04-15 13:02:51.265247', '2021-04-15 13:02:51.265247', NULL),
	(10006539, 4, 'PW21A-TK100239OG-XL', 2, 0, '2021-04-15 13:02:51.263918', '2021-04-15 13:02:51.263918', NULL),
	(10006540, 4, 'PW21A-TK100239OG-XXL', 1, 0, '2021-04-15 13:02:51.283935', '2021-04-15 13:02:51.283935', NULL),
	(10006541, 4, 'PW21A-TK100240OG-XS', 0, 0, '2021-04-15 13:02:51.285378', '2021-04-15 13:02:51.285378', NULL),
	(10006542, 4, 'PW21A-TK100240OG-S', 0, 0, '2021-04-15 13:02:51.303573', '2021-04-15 13:02:51.303573', NULL),
	(10006543, 4, 'PW21A-TK100240OG-M', 2, 0, '2021-04-15 13:02:51.286762', '2021-04-15 13:02:51.286762', NULL),
	(10006544, 4, 'PW21A-TK100240OG-L', 1, 0, '2021-04-15 13:02:51.303163', '2021-04-15 13:02:51.303163', NULL),
	(10006545, 4, 'PW21A-TK100240OG-XL', 2, 0, '2021-04-15 13:02:51.312685', '2021-04-15 13:02:51.312685', NULL),
	(10006546, 4, 'PW21A-TK100240OG-XXL', 0, 0, '2021-04-15 13:02:51.319688', '2021-04-15 13:02:51.319688', NULL),
	(10006547, 4, 'PW21A-TS100241YW -XS', 0, 0, '2021-04-15 13:02:51.298695', '2021-04-15 13:02:51.298695', NULL),
	(10006548, 4, 'PW21A-TS100241YW -S', 0, 0, '2021-04-15 13:02:51.302720', '2021-04-15 13:02:51.302720', NULL),
	(10006549, 4, 'PW21A-TS100241YW -M', 0, 0, '2021-04-15 13:02:51.338759', '2021-04-15 13:02:51.338759', NULL),
	(10006550, 4, 'PW21A-TS100241YW -L', 0, 0, '2021-04-15 13:02:51.320391', '2021-04-15 13:02:51.320391', NULL),
	(10006551, 4, 'PW21A-TS100241YW -XL', 0, 0, '2021-04-15 13:02:51.340929', '2021-04-15 13:02:51.340929', NULL),
	(10006552, 4, 'PW21A-TS100241YW -XXL', 0, 0, '2021-04-15 13:02:51.329934', '2021-04-15 13:02:51.329934', NULL),
	(10006553, 4, 'PW21A-TS100242BL-XS', 0, 0, '2021-04-15 13:02:51.316551', '2021-04-15 13:02:51.316551', NULL),
	(10006554, 4, 'PW21A-TS100242BL-S', 2, 0, '2021-04-15 13:02:51.335800', '2021-04-15 13:02:51.335800', NULL),
	(10006555, 4, 'PW21A-TS100242BL-M', 2, 0, '2021-04-15 13:02:51.320053', '2021-04-15 13:02:51.320053', NULL),
	(10006556, 4, 'PW21A-TS100242BL-L', 2, 0, '2021-04-15 13:02:51.342231', '2021-04-15 13:02:51.342231', NULL),
	(10006557, 4, 'PW21A-TS100242BL-XL', 2, 0, '2021-04-15 13:02:51.361567', '2021-04-15 13:02:51.361567', NULL),
	(10006558, 4, 'PW21A-TS100242BL-XXL', 1, 0, '2021-04-15 13:02:51.330787', '2021-04-15 13:02:51.330787', NULL),
	(10006559, 4, 'PW21A-TK100243BL-XS', 2, 0, '2021-04-15 13:02:51.330314', '2021-04-15 13:02:51.330314', NULL),
	(10006560, 4, 'PW21A-TK100243BL-S', 2, 0, '2021-04-15 13:02:51.398601', '2021-04-15 13:02:51.398601', NULL),
	(10006561, 4, 'PW21A-TK100243BL-M', 2, 0, '2021-04-15 13:02:51.353227', '2021-04-15 13:02:51.353227', NULL),
	(10006562, 4, 'PW21A-TK100243BL-L', 2, 0, '2021-04-15 13:02:51.341390', '2021-04-15 13:02:51.341390', NULL),
	(10006563, 4, 'PW21A-TK100243BL-XL', 2, 0, '2021-04-15 13:02:51.352727', '2021-04-15 13:02:51.352727', NULL),
	(10006564, 4, 'PW21A-TK100243BL-XXL', 2, 0, '2021-04-15 13:02:51.341824', '2021-04-15 13:02:51.341824', NULL),
	(10006565, 4, 'PW21A-TS100244BL-XS', 0, 0, '2021-04-15 13:02:51.354132', '2021-04-15 13:02:51.354132', NULL),
	(10006566, 4, 'PW21A-TS100244BL-S', 0, 0, '2021-04-15 13:02:51.365461', '2021-04-15 13:02:51.365461', NULL),
	(10006567, 4, 'PW21A-TS100244BL-M', 0, 0, '2021-04-15 13:02:51.365003', '2021-04-15 13:02:51.365003', NULL),
	(10006568, 4, 'PW21A-TS100244BL-L', 0, 0, '2021-04-15 13:02:51.354804', '2021-04-15 13:02:51.354804', NULL),
	(10006569, 4, 'PW21A-TS100244BL-XL', 0, 0, '2021-04-15 13:02:51.365777', '2021-04-15 13:02:51.365777', NULL),
	(10006570, 4, 'PW21A-TS100244BL-XXL', 0, 0, '2021-04-15 13:02:51.378486', '2021-04-15 13:02:51.378486', NULL),
	(10006571, 4, 'PW21A-TS100245RD-XS', 0, 0, '2021-04-15 13:02:51.364159', '2021-04-15 13:02:51.364159', NULL),
	(10006572, 4, 'PW21A-TS100245RD-S', 2, 0, '2021-04-15 13:02:51.404499', '2021-04-15 13:02:51.404499', NULL),
	(10006573, 4, 'PW21A-TS100245RD-M', 2, 0, '2021-04-15 13:02:51.377922', '2021-04-15 13:02:51.377922', NULL),
	(10006574, 4, 'PW21A-TS100245RD-L', 2, 0, '2021-04-15 13:02:51.381053', '2021-04-15 13:02:51.381053', NULL),
	(10006575, 4, 'PW21A-TS100245RD-XL', 2, 0, '2021-04-15 13:02:51.379358', '2021-04-15 13:02:51.379358', NULL),
	(10006576, 4, 'PW21A-TS100245RD-XXL', 0, 0, '2021-04-15 13:02:51.366070', '2021-04-15 13:02:51.366070', NULL),
	(10006577, 4, 'PW21A-TK100246BL-XS', 0, 0, '2021-04-15 13:02:51.385965', '2021-04-15 13:02:51.385965', NULL),
	(10006578, 4, 'PW21A-TK100246BL-S', 0, 0, '2021-04-15 13:02:51.386859', '2021-04-15 13:02:51.386859', NULL),
	(10006579, 4, 'PW21A-TK100246BL-M', 2, 0, '2021-04-15 13:02:51.387180', '2021-04-15 13:02:51.387180', NULL),
	(10006580, 4, 'PW21A-TK100246BL-L', 2, 0, '2021-04-15 13:02:51.381853', '2021-04-15 13:02:51.381853', NULL),
	(10006581, 4, 'PW21A-TK100246BL-XL', 2, 0, '2021-04-15 13:02:51.398012', '2021-04-15 13:02:51.398012', NULL),
	(10006582, 4, 'PW21A-TK100246BL-XXL', 2, 0, '2021-04-15 13:02:51.396596', '2021-04-15 13:02:51.396596', NULL),
	(10006583, 4, 'PW21A-TS100247NV-XS', 0, 0, '2021-04-15 13:02:51.432519', '2021-04-15 13:02:51.432519', NULL),
	(10006584, 4, 'PW21A-TS100247NV-S', 0, 0, '2021-04-15 13:02:51.387505', '2021-04-15 13:02:51.387505', NULL),
	(10006585, 4, 'PW21A-TS100247NV-M', 0, 0, '2021-04-15 13:02:51.388302', '2021-04-15 13:02:51.388302', NULL),
	(10006586, 4, 'PW21A-TS100247NV-L', 0, 0, '2021-04-15 13:02:51.406959', '2021-04-15 13:02:51.406959', NULL),
	(10006587, 4, 'PW21A-TS100247NV-XL', 0, 0, '2021-04-15 13:02:51.398324', '2021-04-15 13:02:51.398324', NULL),
	(10006588, 4, 'PW21A-TS100247NV-XXL', 0, 0, '2021-04-15 13:02:51.406628', '2021-04-15 13:02:51.406628', NULL),
	(10006589, 4, 'PW21A-TS100248BL-XS', 0, 0, '2021-04-15 13:02:51.475616', '2021-04-15 13:02:51.475616', NULL),
	(10006590, 4, 'PW21A-TS100248BL-S', 2, 0, '2021-04-15 13:02:51.400498', '2021-04-15 13:02:51.400498', NULL),
	(10006591, 4, 'PW21A-TS100248BL-M', 2, 0, '2021-04-15 13:02:51.419249', '2021-04-15 13:02:51.419249', NULL),
	(10006592, 4, 'PW21A-TS100248BL-L', 2, 0, '2021-04-15 13:02:51.419791', '2021-04-15 13:02:51.419791', NULL),
	(10006593, 4, 'PW21A-TS100248BL-XL', 2, 0, '2021-04-15 13:02:51.434586', '2021-04-15 13:02:51.434586', NULL),
	(10006594, 4, 'PW21A-TS100248BL-XXL', 0, 0, '2021-04-15 13:02:51.408314', '2021-04-15 13:02:51.408314', NULL),
	(10006595, 4, 'PW21A-TK100249WT-XS', 0, 0, '2021-04-15 13:02:51.421775', '2021-04-15 13:02:51.421775', NULL),
	(10006596, 4, 'PW21A-TK100249WT-S', 0, 0, '2021-04-15 13:02:51.408667', '2021-04-15 13:02:51.408667', NULL),
	(10006597, 4, 'PW21A-TK100249WT-M', 0, 0, '2021-04-15 13:02:51.420253', '2021-04-15 13:02:51.420253', NULL),
	(10006598, 4, 'PW21A-TK100249WT-L', 2, 0, '2021-04-15 13:02:51.448486', '2021-04-15 13:02:51.448486', NULL),
	(10006599, 4, 'PW21A-TK100249WT-XL', 2, 0, '2021-04-15 13:02:51.438907', '2021-04-15 13:02:51.438907', NULL),
	(10006600, 4, 'PW21A-TK100249WT-XXL', 2, 0, '2021-04-15 13:02:51.440535', '2021-04-15 13:02:51.440535', NULL),
	(10006601, 4, 'PW21A-TS100250WT-XS', 0, 0, '2021-04-15 13:02:51.422531', '2021-04-15 13:02:51.422531', NULL),
	(10006602, 4, 'PW21A-TS100250WT-S', 4, 0, '2021-04-15 13:02:51.450782', '2021-04-15 13:02:51.450782', NULL),
	(10006603, 4, 'PW21A-TS100250WT-M', 2, 0, '2021-04-15 13:02:51.562956', '2021-04-15 13:02:51.562956', NULL),
	(10006604, 4, 'PW21A-TS100250WT-L', 2, 0, '2021-04-15 13:02:51.442454', '2021-04-15 13:02:51.442454', NULL),
	(10006605, 4, 'PW21A-TS100250WT-XL', 2, 0, '2021-04-15 13:02:51.452952', '2021-04-15 13:02:51.452952', NULL),
	(10006606, 4, 'PW21A-TS100250WT-XXL', 0, 0, '2021-04-15 13:02:51.458582', '2021-04-15 13:02:51.458582', NULL),
	(10006607, 4, 'PW21A-TS100251BL-XS', 0, 0, '2021-04-15 13:02:51.500348', '2021-04-15 13:02:51.500348', NULL),
	(10006608, 4, 'PW21A-TS100251BL-S', 2, 0, '2021-04-15 13:02:51.463302', '2021-04-15 13:02:51.463302', NULL),
	(10006609, 4, 'PW21A-TS100251BL-M', 1, 0, '2021-04-15 13:02:51.457525', '2021-04-15 13:02:51.457525', NULL),
	(10006610, 4, 'PW21A-TS100251BL-L', 2, 0, '2021-04-15 13:02:51.455869', '2021-04-15 13:02:51.455869', NULL),
	(10006611, 4, 'PW21A-TS100251BL-XL', 2, 0, '2021-04-15 13:02:51.467763', '2021-04-15 13:02:51.467763', NULL),
	(10006612, 4, 'PW21A-TS100251BL-XXL', 1, 0, '2021-04-15 13:02:51.501453', '2021-04-15 13:02:51.501453', NULL),
	(10006613, 4, 'PW21A-TS100252WT-XS', 0, 0, '2021-04-15 13:02:51.465369', '2021-04-15 13:02:51.465369', NULL),
	(10006614, 4, 'PW21A-TS100252WT-S', 2, 0, '2021-04-15 13:02:51.478847', '2021-04-15 13:02:51.478847', NULL),
	(10006615, 4, 'PW21A-TS100252WT-M', 3, 0, '2021-04-15 13:02:51.480503', '2021-04-15 13:02:51.480503', NULL),
	(10006616, 4, 'PW21A-TS100252WT-L', 2, 0, '2021-04-15 13:02:51.482434', '2021-04-15 13:02:51.482434', NULL),
	(10006617, 4, 'PW21A-TS100252WT-XL', 2, 0, '2021-04-15 13:02:51.465978', '2021-04-15 13:02:51.465978', NULL),
	(10006618, 4, 'PW21A-TS100252WT-XXL', 2, 0, '2021-04-15 13:02:51.534041', '2021-04-15 13:02:51.534041', NULL),
	(10006619, 4, 'PW21A-TS100253BL-XS', 0, 0, '2021-04-15 13:02:51.482048', '2021-04-15 13:02:51.482048', NULL),
	(10006620, 4, 'PW21A-TS100253BL-S', 2, 0, '2021-04-15 13:02:51.651103', '2021-04-15 13:02:51.651103', NULL),
	(10006621, 4, 'PW21A-TS100253BL-M', 2, 0, '2021-04-15 13:02:51.490585', '2021-04-15 13:02:51.490585', NULL),
	(10006622, 4, 'PW21A-TS100253BL-L', 2, 0, '2021-04-15 13:02:51.578410', '2021-04-15 13:02:51.578410', NULL),
	(10006623, 4, 'PW21A-TS100253BL-XL', 2, 0, '2021-04-15 13:02:51.502113', '2021-04-15 13:02:51.502113', NULL),
	(10006624, 4, 'PW21A-TS100253BL-XXL', 1, 0, '2021-04-15 13:02:51.494479', '2021-04-15 13:02:51.494479', NULL),
	(10006625, 4, 'PW21A-TK100254BL-XS', 0, 0, '2021-04-15 13:02:51.579330', '2021-04-15 13:02:51.579330', NULL),
	(10006626, 4, 'PW21A-TK100254BL-S', 2, 0, '2021-04-15 13:02:51.550013', '2021-04-15 13:02:51.550013', NULL),
	(10006627, 4, 'PW21A-TK100254BL-M', 2, 0, '2021-04-15 13:02:51.673265', '2021-04-15 13:02:51.673265', NULL),
	(10006628, 4, 'PW21A-TK100254BL-L', 2, 0, '2021-04-15 13:02:51.622533', '2021-04-15 13:02:51.622533', NULL),
	(10006629, 4, 'PW21A-TK100254BL-XL', 2, 0, '2021-04-15 13:02:51.534281', '2021-04-15 13:02:51.534281', NULL),
	(10006630, 4, 'PW21A-TK100254BL-XXL', 1, 0, '2021-04-15 13:02:51.558461', '2021-04-15 13:02:51.558461', NULL),
	(10006631, 4, 'PW21A-TS100255BL-XS', 0, 0, '2021-04-15 13:02:51.598654', '2021-04-15 13:02:51.598654', NULL),
	(10006632, 4, 'PW21A-TS100255BL-S', 2, 0, '2021-04-15 13:02:51.596096', '2021-04-15 13:02:51.596096', NULL),
	(10006633, 4, 'PW21A-TS100255BL-M', 2, 0, '2021-04-15 13:02:51.617368', '2021-04-15 13:02:51.617368', NULL),
	(10006634, 4, 'PW21A-TS100255BL-L', 2, 0, '2021-04-15 13:02:51.680924', '2021-04-15 13:02:51.680924', NULL),
	(10006635, 4, 'PW21A-TS100255BL-XL', 2, 0, '2021-04-15 13:02:51.621821', '2021-04-15 13:02:51.621821', NULL),
	(10006636, 4, 'PW21A-TS100255BL-XXL', 2, 0, '2021-04-15 13:02:51.607951', '2021-04-15 13:02:51.607951', NULL),
	(10006637, 4, 'PW21A-TK100256BL-XS', 0, 0, '2021-04-15 13:02:51.802684', '2021-04-15 13:02:51.802684', NULL),
	(10006638, 4, 'PW21A-TK100256BL-S', 0, 0, '2021-04-15 13:02:51.590350', '2021-04-15 13:02:51.590350', NULL),
	(10006639, 4, 'PW21A-TK100256BL-M', 3, 0, '2021-04-15 13:02:51.656481', '2021-04-15 13:02:51.656481', NULL),
	(10006640, 4, 'PW21A-TK100256BL-L', 2, 0, '2021-04-15 13:02:51.782276', '2021-04-15 13:02:51.782276', NULL),
	(10006641, 4, 'PW21A-TK100256BL-XL', 2, 0, '2021-04-15 13:02:51.655711', '2021-04-15 13:02:51.655711', NULL),
	(10006642, 4, 'PW21A-TK100256BL-XXL', 0, 0, '2021-04-15 13:02:51.682043', '2021-04-15 13:02:51.682043', NULL),
	(10006643, 4, 'PW21A-TS100257WT-XS', 0, 0, '2021-04-15 13:02:51.749703', '2021-04-15 13:02:51.749703', NULL),
	(10006644, 4, 'PW21A-TS100257WT-S', 0, 0, '2021-04-15 13:02:51.643227', '2021-04-15 13:02:51.643227', NULL),
	(10006645, 4, 'PW21A-TS100257WT-M', 0, 0, '2021-04-15 13:02:51.784219', '2021-04-15 13:02:51.784219', NULL),
	(10006646, 4, 'PW21A-TS100257WT-L', 0, 0, '2021-04-15 13:02:51.785086', '2021-04-15 13:02:51.785086', NULL),
	(10006647, 4, 'PW21A-TS100257WT-XL', 0, 0, '2021-04-15 13:02:51.796152', '2021-04-15 13:02:51.796152', NULL),
	(10006648, 4, 'PW21A-TS100257WT-XXL', 0, 0, '2021-04-15 13:02:51.785576', '2021-04-15 13:02:51.785576', NULL),
	(10006649, 4, 'PW21A-TS100258WT-XS', 0, 0, '2021-04-15 13:02:51.705905', '2021-04-15 13:02:51.705905', NULL),
	(10006650, 4, 'PW21A-TS100258WT-S', 2, 0, '2021-04-15 13:02:51.835595', '2021-04-15 13:02:51.835595', NULL),
	(10006651, 4, 'PW21A-TS100258WT-M', 1, 0, '2021-04-15 13:02:51.800253', '2021-04-15 13:02:51.800253', NULL),
	(10006652, 4, 'PW21A-TS100258WT-L', 3, 0, '2021-04-15 13:02:51.780317', '2021-04-15 13:02:51.780317', NULL),
	(10006653, 4, 'PW21A-TS100258WT-XL', 2, 0, '2021-04-15 13:02:51.833197', '2021-04-15 13:02:51.833197', NULL),
	(10006654, 4, 'PW21A-TS100258WT-XXL', 2, 0, '2021-04-15 13:02:51.800181', '2021-04-15 13:02:51.800181', NULL),
	(10006655, 4, 'PW21A-TS100259BL-XS', 0, 0, '2021-04-15 13:02:51.809507', '2021-04-15 13:02:51.809507', NULL),
	(10006656, 4, 'PW21A-TS100259BL-S', 2, 0, '2021-04-15 13:02:51.850045', '2021-04-15 13:02:51.850045', NULL),
	(10006657, 4, 'PW21A-TS100259BL-M', 2, 0, '2021-04-15 13:02:51.819908', '2021-04-15 13:02:51.819908', NULL),
	(10006658, 4, 'PW21A-TS100259BL-L', 2, 0, '2021-04-15 13:02:51.825803', '2021-04-15 13:02:51.825803', NULL),
	(10006659, 4, 'PW21A-TS100259BL-XL', 2, 0, '2021-04-15 13:02:51.815263', '2021-04-15 13:02:51.815263', NULL),
	(10006660, 4, 'PW21A-TS100259BL-XXL', 1, 0, '2021-04-15 13:02:51.808635', '2021-04-15 13:02:51.808635', NULL),
	(10006661, 4, 'PW21A-TS100260BL-XS', 0, 0, '2021-04-15 13:02:51.829608', '2021-04-15 13:02:51.829608', NULL),
	(10006662, 4, 'PW21A-TS100260BL-S', 2, 0, '2021-04-15 13:02:51.828914', '2021-04-15 13:02:51.828914', NULL),
	(10006663, 4, 'PW21A-TS100260BL-M', 2, 0, '2021-04-15 13:02:51.894097', '2021-04-15 13:02:51.894097', NULL),
	(10006664, 4, 'PW21A-TS100260BL-L', 2, 0, '2021-04-15 13:02:51.853216', '2021-04-15 13:02:51.853216', NULL),
	(10006665, 4, 'PW21A-TS100260BL-XL', 2, 0, '2021-04-15 13:02:51.828033', '2021-04-15 13:02:51.828033', NULL),
	(10006666, 4, 'PW21A-TS100260BL-XXL', 2, 0, '2021-04-15 13:02:51.866218', '2021-04-15 13:02:51.866218', NULL),
	(10006667, 4, 'PW21A-TS100261BL-XS', 0, 0, '2021-04-15 13:02:51.842202', '2021-04-15 13:02:51.842202', NULL),
	(10006668, 4, 'PW21A-TS100261BL-S', 2, 0, '2021-04-15 13:02:51.834260', '2021-04-15 13:02:51.834260', NULL),
	(10006669, 4, 'PW21A-TS100261BL-M', 2, 0, '2021-04-15 13:02:51.869125', '2021-04-15 13:02:51.869125', NULL),
	(10006670, 4, 'PW21A-TS100261BL-L', 3, 0, '2021-04-15 13:02:51.846567', '2021-04-15 13:02:51.846567', NULL),
	(10006671, 4, 'PW21A-TS100261BL-XL', 1, 0, '2021-04-15 13:02:51.852864', '2021-04-15 13:02:51.852864', NULL),
	(10006672, 4, 'PW21A-TS100261BL-XXL', 1, 0, '2021-04-15 13:02:51.875976', '2021-04-15 13:02:51.875976', NULL),
	(10006673, 4, 'PW21A-TS100262BL-XS', 0, 0, '2021-04-15 13:02:51.855800', '2021-04-15 13:02:51.855800', NULL),
	(10006674, 4, 'PW21A-TS100262BL-S', 2, 0, '2021-04-15 13:02:51.864628', '2021-04-15 13:02:51.864628', NULL),
	(10006675, 4, 'PW21A-TS100262BL-M', 2, 0, '2021-04-15 13:02:51.888723', '2021-04-15 13:02:51.888723', NULL),
	(10006676, 4, 'PW21A-TS100262BL-L', 2, 0, '2021-04-15 13:02:51.910092', '2021-04-15 13:02:51.910092', NULL),
	(10006677, 4, 'PW21A-TS100262BL-XL', 2, 0, '2021-04-15 13:02:51.853495', '2021-04-15 13:02:51.853495', NULL),
	(10006678, 4, 'PW21A-TS100262BL-XXL', 2, 0, '2021-04-15 13:02:51.867285', '2021-04-15 13:02:51.867285', NULL),
	(10006679, 4, 'PW21A-TS100263BL-XS', 0, 0, '2021-04-15 13:02:51.882157', '2021-04-15 13:02:51.882157', NULL),
	(10006680, 4, 'PW21A-TS100263BL-S', 2, 0, '2021-04-15 13:02:51.934847', '2021-04-15 13:02:51.934847', NULL),
	(10006681, 4, 'PW21A-TS100263BL-M', 2, 0, '2021-04-15 13:02:51.894887', '2021-04-15 13:02:51.894887', NULL),
	(10006682, 4, 'PW21A-TS100263BL-L', 2, 0, '2021-04-15 13:02:51.901055', '2021-04-15 13:02:51.901055', NULL),
	(10006683, 4, 'PW21A-TS100263BL-XL', 2, 0, '2021-04-15 13:02:51.908172', '2021-04-15 13:02:51.908172', NULL),
	(10006684, 4, 'PW21A-TS100263BL-XXL', 0, 0, '2021-04-15 13:02:51.896447', '2021-04-15 13:02:51.896447', NULL),
	(10006685, 4, 'PW21A-TS100264WH-XS', 0, 0, '2021-04-15 13:02:51.910572', '2021-04-15 13:02:51.910572', NULL),
	(10006686, 4, 'PW21A-TS100264WH-S', 0, 0, '2021-04-15 13:02:51.956910', '2021-04-15 13:02:51.956910', NULL),
	(10006687, 4, 'PW21A-TS100264WH-M', 0, 0, '2021-04-15 13:02:51.932094', '2021-04-15 13:02:51.932094', NULL),
	(10006688, 4, 'PW21A-TS100264WH-L', 0, 0, '2021-04-15 13:02:51.918402', '2021-04-15 13:02:51.918402', NULL),
	(10006689, 4, 'PW21A-TS100264WH-XL', 0, 0, '2021-04-15 13:02:51.933460', '2021-04-15 13:02:51.933460', NULL),
	(10006690, 4, 'PW21A-TS100264WH-XXL', 0, 0, '2021-04-15 13:02:51.914287', '2021-04-15 13:02:51.914287', NULL),
	(10006691, 4, 'PW21A-TS100265RD-XS', 0, 0, '2021-04-15 13:02:51.936569', '2021-04-15 13:02:51.936569', NULL),
	(10006692, 4, 'PW21A-TS100265RD-S', 2, 0, '2021-04-15 13:02:51.927416', '2021-04-15 13:02:51.927416', NULL),
	(10006693, 4, 'PW21A-TS100265RD-M', 3, 0, '2021-04-15 13:02:51.966910', '2021-04-15 13:02:51.966910', NULL),
	(10006694, 4, 'PW21A-TS100265RD-L', 2, 0, '2021-04-15 13:02:51.937388', '2021-04-15 13:02:51.937388', NULL),
	(10006695, 4, 'PW21A-TS100265RD-XL', 2, 0, '2021-04-15 13:02:51.966546', '2021-04-15 13:02:51.966546', NULL),
	(10006696, 4, 'PW21A-TS100265RD-XXL', 1, 0, '2021-04-15 13:02:51.969494', '2021-04-15 13:02:51.969494', NULL),
	(10006697, 4, 'PW21A-TS100266BL-XS', 0, 0, '2021-04-15 13:02:51.933819', '2021-04-15 13:02:51.933819', NULL),
	(10006698, 4, 'PW21A-TS100266BL-S', 2, 0, '2021-04-15 13:02:51.958083', '2021-04-15 13:02:51.958083', NULL),
	(10006699, 4, 'PW21A-TS100266BL-M', 2, 0, '2021-04-15 13:02:51.938482', '2021-04-15 13:02:51.938482', NULL),
	(10006700, 4, 'PW21A-TS100266BL-L', 2, 0, '2021-04-15 13:02:51.939309', '2021-04-15 13:02:51.939309', NULL),
	(10006701, 4, 'PW21A-TS100266BL-XL', 1, 0, '2021-04-15 13:02:51.996285', '2021-04-15 13:02:51.996285', NULL),
	(10006702, 4, 'PW21A-TS100266BL-XXL', 0, 0, '2021-04-15 13:02:51.962525', '2021-04-15 13:02:51.962525', NULL),
	(10006703, 4, 'PW21A-TS100267BL-XS', 0, 0, '2021-04-15 13:02:52.008677', '2021-04-15 13:02:52.008677', NULL),
	(10006704, 4, 'PW21A-TS100267BL-S', 2, 0, '2021-04-15 13:02:51.967237', '2021-04-15 13:02:51.967237', NULL),
	(10006705, 4, 'PW21A-TS100267BL-M', 2, 0, '2021-04-15 13:02:51.967577', '2021-04-15 13:02:51.967577', NULL),
	(10006706, 4, 'PW21A-TS100267BL-L', 2, 0, '2021-04-15 13:02:51.969654', '2021-04-15 13:02:51.969654', NULL),
	(10006707, 4, 'PW21A-TS100267BL-XL', 2, 0, '2021-04-15 13:02:51.983471', '2021-04-15 13:02:51.983471', NULL),
	(10006708, 4, 'PW21A-TS100267BL-XXL', 2, 0, '2021-04-15 13:02:51.982581', '2021-04-15 13:02:51.982581', NULL),
	(10006709, 4, 'PW21A-TS100268BL-XS', 0, 0, '2021-04-15 13:02:51.995572', '2021-04-15 13:02:51.995572', NULL),
	(10006710, 4, 'PW21A-TS100268BL-S', 2, 0, '2021-04-15 13:02:52.009075', '2021-04-15 13:02:52.009075', NULL),
	(10006711, 4, 'PW21A-TS100268BL-M', 2, 0, '2021-04-15 13:02:51.995275', '2021-04-15 13:02:51.995275', NULL),
	(10006712, 4, 'PW21A-TS100268BL-L', 2, 0, '2021-04-15 13:02:51.993532', '2021-04-15 13:02:51.993532', NULL),
	(10006713, 4, 'PW21A-TS100268BL-XL', 2, 0, '2021-04-15 13:02:51.987158', '2021-04-15 13:02:51.987158', NULL),
	(10006714, 4, 'PW21A-TS100268BL-XXL', 2, 0, '2021-04-15 13:02:51.971676', '2021-04-15 13:02:51.971676', NULL),
	(10006715, 4, 'PW21A-TS100269BL-XS', 0, 0, '2021-04-15 13:02:51.995973', '2021-04-15 13:02:51.995973', NULL),
	(10006716, 4, 'PW21A-TS100269BL-S', 2, 0, '2021-04-15 13:02:51.998578', '2021-04-15 13:02:51.998578', NULL),
	(10006717, 4, 'PW21A-TS100269BL-M', 3, 0, '2021-04-15 13:02:52.015776', '2021-04-15 13:02:52.015776', NULL),
	(10006718, 4, 'PW21A-TS100269BL-L', 2, 0, '2021-04-15 13:02:52.006508', '2021-04-15 13:02:52.006508', NULL),
	(10006719, 4, 'PW21A-TS100269BL-XL', 2, 0, '2021-04-15 13:02:51.997685', '2021-04-15 13:02:51.997685', NULL),
	(10006720, 4, 'PW21A-TS100269BL-XXL', 2, 0, '2021-04-15 13:02:52.017975', '2021-04-15 13:02:52.017975', NULL),
	(10006721, 4, 'PW21A-TS100270BL-XS', 0, 0, '2021-04-15 13:02:52.017280', '2021-04-15 13:02:52.017280', NULL),
	(10006722, 4, 'PW21A-TS100270BL-S', 0, 0, '2021-04-15 13:02:52.028924', '2021-04-15 13:02:52.028924', NULL),
	(10006723, 4, 'PW21A-TS100270BL-M', 0, 0, '2021-04-15 13:02:52.015462', '2021-04-15 13:02:52.015462', NULL),
	(10006724, 4, 'PW21A-TS100270BL-L', 0, 0, '2021-04-15 13:02:52.017571', '2021-04-15 13:02:52.017571', NULL),
	(10006725, 4, 'PW21A-TS100270BL-XL', 0, 0, '2021-04-15 13:02:52.039956', '2021-04-15 13:02:52.039956', NULL),
	(10006726, 4, 'PW21A-TS100270BL-XXL', 0, 0, '2021-04-15 13:02:52.027235', '2021-04-15 13:02:52.027235', NULL),
	(10006727, 4, 'PW21A-TS100271BL-XS', 0, 0, '2021-04-15 13:02:52.031171', '2021-04-15 13:02:52.031171', NULL),
	(10006728, 4, 'PW21A-TS100271BL-S', 2, 0, '2021-04-15 13:02:52.018460', '2021-04-15 13:02:52.018460', NULL),
	(10006729, 4, 'PW21A-TS100271BL-M', 2, 0, '2021-04-15 13:02:52.036843', '2021-04-15 13:02:52.036843', NULL),
	(10006730, 4, 'PW21A-TS100271BL-L', 2, 0, '2021-04-15 13:02:52.020772', '2021-04-15 13:02:52.020772', NULL),
	(10006731, 4, 'PW21A-TS100271BL-XL', 2, 0, '2021-04-15 13:02:52.056502', '2021-04-15 13:02:52.056502', NULL),
	(10006732, 4, 'PW21A-TS100271BL-XXL', 1, 0, '2021-04-15 13:02:52.035728', '2021-04-15 13:02:52.035728', NULL),
	(10006733, 4, 'PW21A-TS100272BL-XS', 0, 0, '2021-04-15 13:02:52.095121', '2021-04-15 13:02:52.095121', NULL),
	(10006734, 4, 'PW21A-TS100272BL-S', 2, 0, '2021-04-15 13:02:52.038683', '2021-04-15 13:02:52.038683', NULL),
	(10006735, 4, 'PW21A-TS100272BL-M', 2, 0, '2021-04-15 13:02:52.037274', '2021-04-15 13:02:52.037274', NULL),
	(10006736, 4, 'PW21A-TS100272BL-L', 2, 0, '2021-04-15 13:02:52.037716', '2021-04-15 13:02:52.037716', NULL),
	(10006737, 4, 'PW21A-TS100272BL-XL', 2, 0, '2021-04-15 13:02:52.048593', '2021-04-15 13:02:52.048593', NULL),
	(10006738, 4, 'PW21A-TS100272BL-XXL', 1, 0, '2021-04-15 13:02:52.039013', '2021-04-15 13:02:52.039013', NULL),
	(10006739, 4, 'PW21A-TS100273WT-XS', 0, 0, '2021-04-15 13:02:52.058832', '2021-04-15 13:02:52.058832', NULL),
	(10006740, 4, 'PW21A-TS100273WT-S', 2, 0, '2021-04-15 13:02:52.048912', '2021-04-15 13:02:52.048912', NULL),
	(10006741, 4, 'PW21A-TS100273WT-M', 2, 0, '2021-04-15 13:02:52.057636', '2021-04-15 13:02:52.057636', NULL),
	(10006742, 4, 'PW21A-TS100273WT-L', 2, 0, '2021-04-15 13:02:52.055422', '2021-04-15 13:02:52.055422', NULL),
	(10006743, 4, 'PW21A-TS100273WT-XL', 2, 0, '2021-04-15 13:02:52.057936', '2021-04-15 13:02:52.057936', NULL),
	(10006744, 4, 'PW21A-TS100273WT-XXL', 1, 0, '2021-04-15 13:02:52.093707', '2021-04-15 13:02:52.093707', NULL),
	(10006745, 4, 'PW21A-TS100274BL-XS', 0, 0, '2021-04-15 13:02:52.049978', '2021-04-15 13:02:52.049978', NULL),
	(10006746, 4, 'PW21A-TS100274BL-S', 2, 0, '2021-04-15 13:02:52.058359', '2021-04-15 13:02:52.058359', NULL),
	(10006747, 4, 'PW21A-TS100274BL-M', 2, 0, '2021-04-15 13:02:52.070792', '2021-04-15 13:02:52.070792', NULL),
	(10006748, 4, 'PW21A-TS100274BL-L', 2, 0, '2021-04-15 13:02:52.075185', '2021-04-15 13:02:52.075185', NULL),
	(10006749, 4, 'PW21A-TS100274BL-XL', 2, 0, '2021-04-15 13:02:52.098667', '2021-04-15 13:02:52.098667', NULL),
	(10006750, 4, 'PW21A-TS100274BL-XXL', 1, 0, '2021-04-15 13:02:52.122650', '2021-04-15 13:02:52.122650', NULL),
	(10006751, 4, 'PW21A-TS100275BL-XS', 0, 0, '2021-04-15 13:02:52.091080', '2021-04-15 13:02:52.091080', NULL),
	(10006752, 4, 'PW21A-TS100275BL-S', 2, 0, '2021-04-15 13:02:52.093114', '2021-04-15 13:02:52.093114', NULL),
	(10006753, 4, 'PW21A-TS100275BL-M', 2, 0, '2021-04-15 13:02:52.079743', '2021-04-15 13:02:52.079743', NULL),
	(10006754, 4, 'PW21A-TS100275BL-L', 2, 0, '2021-04-15 13:02:52.096138', '2021-04-15 13:02:52.096138', NULL),
	(10006755, 4, 'PW21A-TS100275BL-XL', 2, 0, '2021-04-15 13:02:52.060114', '2021-04-15 13:02:52.060114', NULL),
	(10006756, 4, 'PW21A-TS100275BL-XXL', 1, 0, '2021-04-15 13:02:52.110330', '2021-04-15 13:02:52.110330', NULL),
	(10006757, 4, 'PW21A-TS100276WT-XS', 0, 0, '2021-04-15 13:02:52.151402', '2021-04-15 13:02:52.151402', NULL),
	(10006758, 4, 'PW21A-TS100276WT-S', 2, 0, '2021-04-15 13:02:52.150965', '2021-04-15 13:02:52.150965', NULL),
	(10006759, 4, 'PW21A-TS100276WT-M', 2, 0, '2021-04-15 13:02:52.112530', '2021-04-15 13:02:52.112530', NULL),
	(10006760, 4, 'PW21A-TS100276WT-L', 2, 0, '2021-04-15 13:02:52.098991', '2021-04-15 13:02:52.098991', NULL),
	(10006761, 4, 'PW21A-TS100276WT-XL', 2, 0, '2021-04-15 13:02:52.122026', '2021-04-15 13:02:52.122026', NULL),
	(10006762, 4, 'PW21A-TS100276WT-XXL', 1, 0, '2021-04-15 13:02:52.112193', '2021-04-15 13:02:52.112193', NULL),
	(10006763, 4, 'PW21A-TS100277BL-XS', 0, 0, '2021-04-15 13:02:52.118627', '2021-04-15 13:02:52.118627', NULL),
	(10006764, 4, 'PW21A-TS100277BL-S', 2, 0, '2021-04-15 13:02:52.121060', '2021-04-15 13:02:52.121060', NULL),
	(10006765, 4, 'PW21A-TS100277BL-M', 2, 0, '2021-04-15 13:02:52.123501', '2021-04-15 13:02:52.123501', NULL),
	(10006766, 4, 'PW21A-TS100277BL-L', 2, 0, '2021-04-15 13:02:52.148706', '2021-04-15 13:02:52.148706', NULL),
	(10006767, 4, 'PW21A-TS100277BL-XL', 2, 0, '2021-04-15 13:02:52.134134', '2021-04-15 13:02:52.134134', NULL),
	(10006768, 4, 'PW21A-TS100277BL-XXL', 1, 0, '2021-04-15 13:02:52.123033', '2021-04-15 13:02:52.123033', NULL),
	(10006769, 4, 'PW21A-TS100278BL-XS', 0, 0, '2021-04-15 13:02:52.124266', '2021-04-15 13:02:52.124266', NULL),
	(10006770, 4, 'PW21A-TS100278BL-S', 2, 0, '2021-04-15 13:02:52.138794', '2021-04-15 13:02:52.138794', NULL),
	(10006771, 4, 'PW21A-TS100278BL-M', 2, 0, '2021-04-15 13:02:52.150232', '2021-04-15 13:02:52.150232', NULL),
	(10006772, 4, 'PW21A-TS100278BL-L', 2, 0, '2021-04-15 13:02:52.160919', '2021-04-15 13:02:52.160919', NULL),
	(10006773, 4, 'PW21A-TS100278BL-XL', 2, 0, '2021-04-15 13:02:52.138195', '2021-04-15 13:02:52.138195', NULL),
	(10006774, 4, 'PW21A-TS100278BL-XXL', 1, 0, '2021-04-15 13:02:52.176939', '2021-04-15 13:02:52.176939', NULL),
	(10006775, 4, 'PW21A-TS100279WT-XS', 0, 0, '2021-04-15 13:02:52.150546', '2021-04-15 13:02:52.150546', NULL),
	(10006776, 4, 'PW21A-TS100279WT-S', 2, 0, '2021-04-15 13:02:52.148253', '2021-04-15 13:02:52.148253', NULL),
	(10006777, 4, 'PW21A-TS100279WT-M', 2, 0, '2021-04-15 13:02:52.152439', '2021-04-15 13:02:52.152439', NULL),
	(10006778, 4, 'PW21A-TS100279WT-L', 3, 0, '2021-04-15 13:02:52.176104', '2021-04-15 13:02:52.176104', NULL),
	(10006779, 4, 'PW21A-TS100279WT-XL', 1, 0, '2021-04-15 13:02:52.174343', '2021-04-15 13:02:52.174343', NULL),
	(10006780, 4, 'PW21A-TS100279WT-XXL', 1, 0, '2021-04-15 13:02:52.162123', '2021-04-15 13:02:52.162123', NULL),
	(10006781, 4, 'PW21A-TS100280BL-XS', 0, 0, '2021-04-15 13:02:52.175707', '2021-04-15 13:02:52.175707', NULL),
	(10006782, 4, 'PW21A-TS100280BL-S', 0, 0, '2021-04-15 13:02:52.160101', '2021-04-15 13:02:52.160101', NULL),
	(10006783, 4, 'PW21A-TS100280BL-M', 0, 0, '2021-04-15 13:02:52.176503', '2021-04-15 13:02:52.176503', NULL),
	(10006784, 4, 'PW21A-TS100280BL-L', 0, 0, '2021-04-15 13:02:52.186503', '2021-04-15 13:02:52.186503', NULL),
	(10006785, 4, 'PW21A-TS100280BL-XL', 0, 0, '2021-04-15 13:02:52.175359', '2021-04-15 13:02:52.175359', NULL),
	(10006786, 4, 'PW21A-TS100280BL-XXL', 0, 0, '2021-04-15 13:02:52.219132', '2021-04-15 13:02:52.219132', NULL),
	(10006787, 4, 'PW21A-TS100281BL-XS', 0, 0, '2021-04-15 13:02:52.177368', '2021-04-15 13:02:52.177368', NULL),
	(10006788, 4, 'PW21A-TS100281BL-S', 0, 0, '2021-04-15 13:02:52.209622', '2021-04-15 13:02:52.209622', NULL),
	(10006789, 4, 'PW21A-TS100281BL-M', 0, 0, '2021-04-15 13:02:52.187361', '2021-04-15 13:02:52.187361', NULL),
	(10006790, 4, 'PW21A-TS100281BL-L', 0, 0, '2021-04-15 13:02:52.200063', '2021-04-15 13:02:52.200063', NULL),
	(10006791, 4, 'PW21A-TS100281BL-XL', 0, 0, '2021-04-15 13:02:52.198983', '2021-04-15 13:02:52.198983', NULL),
	(10006792, 4, 'PW21A-TS100281BL-XXL', 0, 0, '2021-04-15 13:02:52.188471', '2021-04-15 13:02:52.188471', NULL),
	(10006793, 4, 'PW21A-TS100282BL-XS', 0, 0, '2021-04-15 13:02:52.201621', '2021-04-15 13:02:52.201621', NULL),
	(10006794, 4, 'PW21A-TS100282BL-S', 0, 0, '2021-04-15 13:02:52.200447', '2021-04-15 13:02:52.200447', NULL),
	(10006795, 4, 'PW21A-TS100282BL-M', 0, 0, '2021-04-15 13:02:52.199279', '2021-04-15 13:02:52.199279', NULL),
	(10006796, 4, 'PW21A-TS100282BL-L', 0, 0, '2021-04-15 13:02:52.208922', '2021-04-15 13:02:52.208922', NULL),
	(10006797, 4, 'PW21A-TS100282BL-XL', 0, 0, '2021-04-15 13:02:52.201252', '2021-04-15 13:02:52.201252', NULL),
	(10006798, 4, 'PW21A-TS100282BL-XXL', 0, 0, '2021-04-15 13:02:52.227802', '2021-04-15 13:02:52.227802', NULL),
	(10006799, 4, 'PW21A-TS100283BL-XS', 0, 0, '2021-04-15 13:02:52.200864', '2021-04-15 13:02:52.200864', NULL),
	(10006800, 4, 'PW21A-TS100283BL-S', 0, 0, '2021-04-15 13:02:52.209340', '2021-04-15 13:02:52.209340', NULL),
	(10006801, 4, 'PW21A-TS100283BL-M', 0, 0, '2021-04-15 13:02:52.216771', '2021-04-15 13:02:52.216771', NULL),
	(10006802, 4, 'PW21A-TS100283BL-L', 0, 0, '2021-04-15 13:02:52.217035', '2021-04-15 13:02:52.217035', NULL),
	(10006803, 4, 'PW21A-TS100283BL-XL', 0, 0, '2021-04-15 13:02:52.216066', '2021-04-15 13:02:52.216066', NULL),
	(10006804, 4, 'PW21A-TS100283BL-XXL', 0, 0, '2021-04-15 13:02:52.238808', '2021-04-15 13:02:52.238808', NULL),
	(10006805, 4, 'PW21A-TS100284BL-XS', 0, 0, '2021-04-15 13:02:52.217293', '2021-04-15 13:02:52.217293', NULL),
	(10006806, 4, 'PW21A-TS100284BL-S', 0, 0, '2021-04-15 13:02:52.217557', '2021-04-15 13:02:52.217557', NULL),
	(10006807, 4, 'PW21A-TS100284BL-M', 0, 0, '2021-04-15 13:02:52.236716', '2021-04-15 13:02:52.236716', NULL),
	(10006808, 4, 'PW21A-TS100284BL-L', 0, 0, '2021-04-15 13:02:52.292997', '2021-04-15 13:02:52.292997', NULL),
	(10006809, 4, 'PW21A-TS100284BL-XL', 0, 0, '2021-04-15 13:02:52.230407', '2021-04-15 13:02:52.230407', NULL),
	(10006810, 4, 'PW21A-TS100284BL-XXL', 0, 0, '2021-04-15 13:02:52.218845', '2021-04-15 13:02:52.218845', NULL),
	(10006811, 4, 'PW21A-TS100285BL-XS', 0, 0, '2021-04-15 13:02:52.238480', '2021-04-15 13:02:52.238480', NULL),
	(10006812, 4, 'PW21A-TS100285BL-S', 0, 0, '2021-04-15 13:02:52.230818', '2021-04-15 13:02:52.230818', NULL),
	(10006813, 4, 'PW21A-TS100285BL-M', 0, 0, '2021-04-15 13:02:52.240110', '2021-04-15 13:02:52.240110', NULL),
	(10006814, 4, 'PW21A-TS100285BL-L', 0, 0, '2021-04-15 13:02:52.239095', '2021-04-15 13:02:52.239095', NULL),
	(10006815, 4, 'PW21A-TS100285BL-XL', 0, 0, '2021-04-15 13:02:52.239379', '2021-04-15 13:02:52.239379', NULL),
	(10006816, 4, 'PW21A-TS100285BL-XXL', 0, 0, '2021-04-15 13:02:52.298576', '2021-04-15 13:02:52.298576', NULL),
	(10006817, 4, 'PW21A-TS100286BL-XS', 0, 0, '2021-04-15 13:02:52.247762', '2021-04-15 13:02:52.247762', NULL),
	(10006818, 4, 'PW21A-TS100286BL-S', 0, 0, '2021-04-15 13:02:52.256615', '2021-04-15 13:02:52.256615', NULL),
	(10006819, 4, 'PW21A-TS100286BL-M', 0, 0, '2021-04-15 13:02:52.249334', '2021-04-15 13:02:52.249334', NULL),
	(10006820, 4, 'PW21A-TS100286BL-L', 0, 0, '2021-04-15 13:02:52.249668', '2021-04-15 13:02:52.249668', NULL),
	(10006821, 4, 'PW21A-TS100286BL-XL', 0, 0, '2021-04-15 13:02:52.240973', '2021-04-15 13:02:52.240973', NULL),
	(10006822, 4, 'PW21A-TS100286BL-XXL', 0, 0, '2021-04-15 13:02:52.268867', '2021-04-15 13:02:52.268867', NULL),
	(10006823, 4, 'PW21A-TS100287BL-XS', 0, 0, '2021-04-15 13:02:52.294840', '2021-04-15 13:02:52.294840', NULL),
	(10006824, 4, 'PW21A-TS100287BL-S', 0, 0, '2021-04-15 13:02:52.262572', '2021-04-15 13:02:52.262572', NULL),
	(10006825, 4, 'PW21A-TS100287BL-M', 0, 0, '2021-04-15 13:02:52.267783', '2021-04-15 13:02:52.267783', NULL),
	(10006826, 4, 'PW21A-TS100287BL-L', 0, 0, '2021-04-15 13:02:52.281924', '2021-04-15 13:02:52.281924', NULL),
	(10006827, 4, 'PW21A-TS100287BL-XL', 0, 0, '2021-04-15 13:02:52.263965', '2021-04-15 13:02:52.263965', NULL),
	(10006828, 4, 'PW21A-TS100287BL-XXL', 0, 0, '2021-04-15 13:02:52.263301', '2021-04-15 13:02:52.263301', NULL),
	(10006829, 4, 'PW21A-TS100288BL-XS', 0, 0, '2021-04-15 13:02:52.285919', '2021-04-15 13:02:52.285919', NULL),
	(10006830, 4, 'PW21A-TS100288BL-S', 0, 0, '2021-04-15 13:02:52.297554', '2021-04-15 13:02:52.297554', NULL),
	(10006831, 4, 'PW21A-TS100288BL-M', 0, 0, '2021-04-15 13:02:52.283068', '2021-04-15 13:02:52.283068', NULL),
	(10006832, 4, 'PW21A-TS100288BL-L', 0, 0, '2021-04-15 13:02:52.290546', '2021-04-15 13:02:52.290546', NULL),
	(10006833, 4, 'PW21A-TS100288BL-XL', 0, 0, '2021-04-15 13:02:52.290247', '2021-04-15 13:02:52.290247', NULL),
	(10006834, 4, 'PW21A-TS100288BL-XXL', 0, 0, '2021-04-15 13:02:52.294110', '2021-04-15 13:02:52.294110', NULL),
	(10006835, 4, 'PW21A-TS100289BL-XS', 0, 0, '2021-04-15 13:02:52.273597', '2021-04-15 13:02:52.273597', NULL),
	(10006836, 4, 'PW21A-TS100289BL-S', 0, 0, '2021-04-15 13:02:52.327323', '2021-04-15 13:02:52.327323', NULL),
	(10006837, 4, 'PW21A-TS100289BL-M', 0, 0, '2021-04-15 13:02:52.310984', '2021-04-15 13:02:52.310984', NULL),
	(10006838, 4, 'PW21A-TS100289BL-L', 1, 0, '2021-04-15 13:02:52.347080', '2021-04-15 13:02:52.347080', NULL),
	(10006839, 4, 'PW21A-TS100289BL-XL', 2, 0, '2021-04-15 13:02:52.309242', '2021-04-15 13:02:52.309242', NULL),
	(10006840, 4, 'PW21A-TS100289BL-XXL', 0, 0, '2021-04-15 13:02:52.314349', '2021-04-15 13:02:52.314349', NULL),
	(10006841, 4, 'PW21A-TS100290OL-XS', 0, 0, '2021-04-15 13:02:52.374219', '2021-04-15 13:02:52.374219', NULL),
	(10006842, 4, 'PW21A-TS100290OL-S', 0, 0, '2021-04-15 13:02:52.315010', '2021-04-15 13:02:52.315010', NULL),
	(10006843, 4, 'PW21A-TS100290OL-M', 0, 0, '2021-04-15 13:02:52.325727', '2021-04-15 13:02:52.325727', NULL),
	(10006844, 4, 'PW21A-TS100290OL-L', 0, 0, '2021-04-15 13:02:52.325071', '2021-04-15 13:02:52.325071', NULL),
	(10006845, 4, 'PW21A-TS100290OL-XL', 0, 0, '2021-04-15 13:02:52.325410', '2021-04-15 13:02:52.325410', NULL),
	(10006846, 4, 'PW21A-TS100290OL-XXL', 0, 0, '2021-04-15 13:02:52.324286', '2021-04-15 13:02:52.324286', NULL),
	(10006847, 4, 'PW21A-TS100291BL-XS', 0, 0, '2021-04-15 13:02:52.322756', '2021-04-15 13:02:52.322756', NULL),
	(10006848, 4, 'PW21A-TS100291BL-S', 0, 0, '2021-04-15 13:02:52.335730', '2021-04-15 13:02:52.335730', NULL),
	(10006849, 4, 'PW21A-TS100291BL-M', 0, 0, '2021-04-15 13:02:52.339160', '2021-04-15 13:02:52.339160', NULL),
	(10006850, 4, 'PW21A-TS100291BL-L', 0, 0, '2021-04-15 13:02:52.336274', '2021-04-15 13:02:52.336274', NULL),
	(10006851, 4, 'PW21A-TS100291BL-XL', 0, 0, '2021-04-15 13:02:52.341377', '2021-04-15 13:02:52.341377', NULL),
	(10006852, 4, 'PW21A-TS100291BL-XXL', 0, 0, '2021-04-15 13:02:52.345152', '2021-04-15 13:02:52.345152', NULL),
	(10006853, 4, 'PW21A-TS100292NV-XS', 0, 0, '2021-04-15 13:02:52.339939', '2021-04-15 13:02:52.339939', NULL),
	(10006854, 4, 'PW21A-TS100292NV-S', 2, 0, '2021-04-15 13:02:52.344284', '2021-04-15 13:02:52.344284', NULL),
	(10006855, 4, 'PW21A-TS100292NV-M', 2, 0, '2021-04-15 13:02:52.361400', '2021-04-15 13:02:52.361400', NULL),
	(10006856, 4, 'PW21A-TS100292NV-L', 0, 0, '2021-04-15 13:02:52.345795', '2021-04-15 13:02:52.345795', NULL),
	(10006857, 4, 'PW21A-TS100292NV-XL', 0, 0, '2021-04-15 13:02:52.364526', '2021-04-15 13:02:52.364526', NULL),
	(10006858, 4, 'PW21A-TS100292NV-XXL', 0, 0, '2021-04-15 13:02:52.394568', '2021-04-15 13:02:52.394568', NULL),
	(10006859, 4, 'PW21A-TS100293OL-XS', 0, 0, '2021-04-15 13:02:52.359850', '2021-04-15 13:02:52.359850', NULL),
	(10006860, 4, 'PW21A-TS100293OL-S', 0, 0, '2021-04-15 13:02:52.345468', '2021-04-15 13:02:52.345468', NULL),
	(10006861, 4, 'PW21A-TS100293OL-M', 0, 0, '2021-04-15 13:02:52.401934', '2021-04-15 13:02:52.401934', NULL),
	(10006862, 4, 'PW21A-TS100293OL-L', 0, 0, '2021-04-15 13:02:52.366928', '2021-04-15 13:02:52.366928', NULL),
	(10006863, 4, 'PW21A-TS100293OL-XL', 0, 0, '2021-04-15 13:02:52.373789', '2021-04-15 13:02:52.373789', NULL),
	(10006864, 4, 'PW21A-TS100293OL-XXL', 0, 0, '2021-04-15 13:02:52.369328', '2021-04-15 13:02:52.369328', NULL),
	(10006865, 4, 'PW21A-TS100294OL-XS', 0, 0, '2021-04-15 13:02:52.387875', '2021-04-15 13:02:52.387875', NULL),
	(10006866, 4, 'PW21A-TS100294OL-S', 0, 0, '2021-04-15 13:02:52.375004', '2021-04-15 13:02:52.375004', NULL),
	(10006867, 4, 'PW21A-TS100294OL-M', 0, 0, '2021-04-15 13:02:52.399242', '2021-04-15 13:02:52.399242', NULL),
	(10006868, 4, 'PW21A-TS100294OL-L', 0, 0, '2021-04-15 13:02:52.365232', '2021-04-15 13:02:52.365232', NULL),
	(10006869, 4, 'PW21A-TS100294OL-XL', 0, 0, '2021-04-15 13:02:52.416418', '2021-04-15 13:02:52.416418', NULL),
	(10006870, 4, 'PW21A-TS100294OL-XXL', 0, 0, '2021-04-15 13:02:52.393188', '2021-04-15 13:02:52.393188', NULL),
	(10006871, 4, 'PW21A-TS100295NV-XS', 0, 0, '2021-04-15 13:02:52.388970', '2021-04-15 13:02:52.388970', NULL),
	(10006872, 4, 'PW21A-TS100295NV-S', 0, 0, '2021-04-15 13:02:52.374600', '2021-04-15 13:02:52.374600', NULL),
	(10006873, 4, 'PW21A-TS100295NV-M', 0, 0, '2021-04-15 13:02:52.398900', '2021-04-15 13:02:52.398900', NULL),
	(10006874, 4, 'PW21A-TS100295NV-L', 0, 0, '2021-04-15 13:02:52.395786', '2021-04-15 13:02:52.395786', NULL),
	(10006875, 4, 'PW21A-TS100295NV-XL', 0, 0, '2021-04-15 13:02:52.399971', '2021-04-15 13:02:52.399971', NULL),
	(10006876, 4, 'PW21A-TS100295NV-XXL', 0, 0, '2021-04-15 13:02:52.400288', '2021-04-15 13:02:52.400288', NULL),
	(10006877, 4, 'PW21A-TS100296BL-XS', 0, 0, '2021-04-15 13:02:52.422330', '2021-04-15 13:02:52.422330', NULL),
	(10006878, 4, 'PW21A-TS100296BL-S', 2, 0, '2021-04-15 13:02:52.413681', '2021-04-15 13:02:52.413681', NULL),
	(10006879, 4, 'PW21A-TS100296BL-M', 2, 0, '2021-04-15 13:02:52.411326', '2021-04-15 13:02:52.411326', NULL),
	(10006880, 4, 'PW21A-TS100296BL-L', 2, 0, '2021-04-15 13:02:52.459509', '2021-04-15 13:02:52.459509', NULL),
	(10006881, 4, 'PW21A-TS100296BL-XL', 2, 0, '2021-04-15 13:02:52.410359', '2021-04-15 13:02:52.410359', NULL),
	(10006882, 4, 'PW21A-TS100296BL-XXL', 0, 0, '2021-04-15 13:02:52.414407', '2021-04-15 13:02:52.414407', NULL),
	(10006883, 4, 'PW21A-TS100297OL-XS', 0, 0, '2021-04-15 13:02:52.436268', '2021-04-15 13:02:52.436268', NULL),
	(10006884, 4, 'PW21A-TS100297OL-S', 0, 0, '2021-04-15 13:02:52.419473', '2021-04-15 13:02:52.419473', NULL),
	(10006885, 4, 'PW21A-TS100297OL-M', 0, 0, '2021-04-15 13:02:52.439201', '2021-04-15 13:02:52.439201', NULL),
	(10006886, 4, 'PW21A-TS100297OL-L', 0, 0, '2021-04-15 13:02:52.458431', '2021-04-15 13:02:52.458431', NULL),
	(10006887, 4, 'PW21A-TS100297OL-XL', 0, 0, '2021-04-15 13:02:52.429043', '2021-04-15 13:02:52.429043', NULL),
	(10006888, 4, 'PW21A-TS100297OL-XXL', 0, 0, '2021-04-15 13:02:52.420627', '2021-04-15 13:02:52.420627', NULL),
	(10006889, 4, 'PW21A-TS100298OL-XS', 0, 0, '2021-04-15 13:02:52.420965', '2021-04-15 13:02:52.420965', NULL),
	(10006890, 4, 'PW21A-TS100298OL-S', 0, 0, '2021-04-15 13:02:52.446554', '2021-04-15 13:02:52.446554', NULL),
	(10006891, 4, 'PW21A-TS100298OL-M', 0, 0, '2021-04-15 13:02:52.423054', '2021-04-15 13:02:52.423054', NULL),
	(10006892, 4, 'PW21A-TS100298OL-L', 0, 0, '2021-04-15 13:02:52.443688', '2021-04-15 13:02:52.443688', NULL),
	(10006893, 4, 'PW21A-TS100298OL-XL', 0, 0, '2021-04-15 13:02:52.441062', '2021-04-15 13:02:52.441062', NULL),
	(10006894, 4, 'PW21A-TS100298OL-XXL', 0, 0, '2021-04-15 13:02:52.446182', '2021-04-15 13:02:52.446182', NULL),
	(10006895, 4, 'PW21A-TS100299BL-XS', 0, 0, '2021-04-15 13:02:52.439890', '2021-04-15 13:02:52.439890', NULL),
	(10006896, 4, 'PW21A-TS100299BL-S', 2, 0, '2021-04-15 13:02:52.449243', '2021-04-15 13:02:52.449243', NULL),
	(10006897, 4, 'PW21A-TS100299BL-M', 2, 0, '2021-04-15 13:02:52.480558', '2021-04-15 13:02:52.480558', NULL),
	(10006898, 4, 'PW21A-TS100299BL-L', 2, 0, '2021-04-15 13:02:52.467494', '2021-04-15 13:02:52.467494', NULL),
	(10006899, 4, 'PW21A-TS100299BL-XL', 1, 0, '2021-04-15 13:02:52.462248', '2021-04-15 13:02:52.462248', NULL),
	(10006900, 4, 'PW21A-TS100299BL-XXL', 0, 0, '2021-04-15 13:02:52.446934', '2021-04-15 13:02:52.446934', NULL),
	(10006901, 4, 'PW21A-TS100300MR-XS', 0, 0, '2021-04-15 13:02:52.471303', '2021-04-15 13:02:52.471303', NULL),
	(10006902, 4, 'PW21A-TS100300MR-S', 0, 0, '2021-04-15 13:02:52.466933', '2021-04-15 13:02:52.466933', NULL),
	(10006903, 4, 'PW21A-TS100300MR-M', 0, 0, '2021-04-15 13:02:52.464360', '2021-04-15 13:02:52.464360', NULL),
	(10006904, 4, 'PW21A-TS100300MR-L', 0, 0, '2021-04-15 13:02:52.464674', '2021-04-15 13:02:52.464674', NULL),
	(10006905, 4, 'PW21A-TS100300MR-XL', 0, 0, '2021-04-15 13:02:52.502861', '2021-04-15 13:02:52.502861', NULL),
	(10006906, 4, 'PW21A-TS100300MR-XXL', 0, 0, '2021-04-15 13:02:52.468797', '2021-04-15 13:02:52.468797', NULL),
	(10006907, 4, 'PW21A-TS100301BL-XS', 0, 0, '2021-04-15 13:02:52.497659', '2021-04-15 13:02:52.497659', NULL),
	(10006908, 4, 'PW21A-TS100301BL-S', 0, 0, '2021-04-15 13:02:52.519303', '2021-04-15 13:02:52.519303', NULL),
	(10006909, 4, 'PW21A-TS100301BL-M', 0, 0, '2021-04-15 13:02:52.470208', '2021-04-15 13:02:52.470208', NULL),
	(10006910, 4, 'PW21A-TS100301BL-L', 0, 0, '2021-04-15 13:02:52.476896', '2021-04-15 13:02:52.476896', NULL),
	(10006911, 4, 'PW21A-TS100301BL-XL', 0, 0, '2021-04-15 13:02:52.502348', '2021-04-15 13:02:52.502348', NULL),
	(10006912, 4, 'PW21A-TS100301BL-XXL', 0, 0, '2021-04-15 13:02:52.480097', '2021-04-15 13:02:52.480097', NULL),
	(10006913, 4, 'PW21A-TS100302BL-XS', 0, 0, '2021-04-15 13:02:52.495229', '2021-04-15 13:02:52.495229', NULL),
	(10006914, 4, 'PW21A-TS100302BL-S', 1, 0, '2021-04-15 13:02:52.494786', '2021-04-15 13:02:52.494786', NULL),
	(10006915, 4, 'PW21A-TS100302BL-M', 0, 0, '2021-04-15 13:02:52.513351', '2021-04-15 13:02:52.513351', NULL),
	(10006916, 4, 'PW21A-TS100302BL-L', 3, 0, '2021-04-15 13:02:52.520397', '2021-04-15 13:02:52.520397', NULL),
	(10006917, 4, 'PW21A-TS100302BL-XL', 2, 0, '2021-04-15 13:02:52.499312', '2021-04-15 13:02:52.499312', NULL),
	(10006918, 4, 'PW21A-TS100302BL-XXL', 2, 0, '2021-04-15 13:02:52.499843', '2021-04-15 13:02:52.499843', NULL),
	(10006919, 4, 'PW21A-TS100303BL-XS', 0, 0, '2021-04-15 13:02:52.547891', '2021-04-15 13:02:52.547891', NULL),
	(10006920, 4, 'PW21A-TS100303BL-S', 0, 0, '2021-04-15 13:02:52.510954', '2021-04-15 13:02:52.510954', NULL),
	(10006921, 4, 'PW21A-TS100303BL-M', 0, 0, '2021-04-15 13:02:52.523637', '2021-04-15 13:02:52.523637', NULL),
	(10006922, 4, 'PW21A-TS100303BL-L', 0, 0, '2021-04-15 13:02:52.589365', '2021-04-15 13:02:52.589365', NULL),
	(10006923, 4, 'PW21A-TS100303BL-XL', 0, 0, '2021-04-15 13:02:52.512982', '2021-04-15 13:02:52.512982', NULL),
	(10006924, 4, 'PW21A-TS100303BL-XXL', 0, 0, '2021-04-15 13:02:52.526213', '2021-04-15 13:02:52.526213', NULL),
	(10006925, 4, 'PW21A-TS100304OL-XS', 0, 0, '2021-04-15 13:02:52.522937', '2021-04-15 13:02:52.522937', NULL),
	(10006926, 4, 'PW21A-TS100304OL-S', 2, 0, '2021-04-15 13:02:52.526535', '2021-04-15 13:02:52.526535', NULL),
	(10006927, 4, 'PW21A-TS100304OL-M', 2, 0, '2021-04-15 13:02:52.525450', '2021-04-15 13:02:52.525450', NULL),
	(10006928, 4, 'PW21A-TS100304OL-L', 2, 0, '2021-04-15 13:02:52.559451', '2021-04-15 13:02:52.559451', NULL),
	(10006929, 4, 'PW21A-TS100304OL-XL', 2, 0, '2021-04-15 13:02:52.562948', '2021-04-15 13:02:52.562948', NULL),
	(10006930, 4, 'PW21A-TS100304OL-XXL', 2, 0, '2021-04-15 13:02:52.548694', '2021-04-15 13:02:52.548694', NULL),
	(10006931, 4, 'PW21A-TS100305AR-XS', 0, 0, '2021-04-15 13:02:52.532284', '2021-04-15 13:02:52.532284', NULL),
	(10006932, 4, 'PW21A-TS100305AR-S', 2, 0, '2021-04-15 13:02:52.535337', '2021-04-15 13:02:52.535337', NULL),
	(10006933, 4, 'PW21A-TS100305AR-M', 2, 0, '2021-04-15 13:02:52.543095', '2021-04-15 13:02:52.543095', NULL),
	(10006934, 4, 'PW21A-TS100305AR-L', 2, 0, '2021-04-15 13:02:52.543469', '2021-04-15 13:02:52.543469', NULL),
	(10006935, 4, 'PW21A-TS100305AR-XL', 2, 0, '2021-04-15 13:02:52.545605', '2021-04-15 13:02:52.545605', NULL),
	(10006936, 4, 'PW21A-TS100305AR-XXL', 2, 0, '2021-04-15 13:02:52.535790', '2021-04-15 13:02:52.535790', NULL),
	(10006937, 4, 'PW21A-TS100306GN-XS', 0, 0, '2021-04-15 13:02:52.545112', '2021-04-15 13:02:52.545112', NULL),
	(10006938, 4, 'PW21A-TS100306GN-S', 2, 0, '2021-04-15 13:02:52.568411', '2021-04-15 13:02:52.568411', NULL),
	(10006939, 4, 'PW21A-TS100306GN-M', 2, 0, '2021-04-15 13:02:52.565366', '2021-04-15 13:02:52.565366', NULL),
	(10006940, 4, 'PW21A-TS100306GN-L', 2, 0, '2021-04-15 13:02:52.547558', '2021-04-15 13:02:52.547558', NULL),
	(10006941, 4, 'PW21A-TS100306GN-XL', 2, 0, '2021-04-15 13:02:52.581213', '2021-04-15 13:02:52.581213', NULL),
	(10006942, 4, 'PW21A-TS100306GN-XXL', 1, 0, '2021-04-15 13:02:52.572385', '2021-04-15 13:02:52.572385', NULL),
	(10006943, 4, 'PW21A-TS100307GN-XS', 0, 0, '2021-04-15 13:02:52.573652', '2021-04-15 13:02:52.573652', NULL),
	(10006944, 4, 'PW21A-TS100307GN-S', 2, 0, '2021-04-15 13:02:52.589049', '2021-04-15 13:02:52.589049', NULL),
	(10006945, 4, 'PW21A-TS100307GN-M', 2, 0, '2021-04-15 13:02:52.568959', '2021-04-15 13:02:52.568959', NULL),
	(10006946, 4, 'PW21A-TS100307GN-L', 2, 0, '2021-04-15 13:02:52.662690', '2021-04-15 13:02:52.662690', NULL),
	(10006947, 4, 'PW21A-TS100307GN-XL', 3, 0, '2021-04-15 13:02:52.575840', '2021-04-15 13:02:52.575840', NULL),
	(10006948, 4, 'PW21A-TS100307GN-XXL', 1, 0, '2021-04-15 13:02:52.576187', '2021-04-15 13:02:52.576187', NULL),
	(10006949, 4, 'PW21A-TS100308GN-XS', 0, 0, '2021-04-15 13:02:52.573990', '2021-04-15 13:02:52.573990', NULL),
	(10006950, 4, 'PW21A-TS100308GN-S', 2, 0, '2021-04-15 13:02:52.583016', '2021-04-15 13:02:52.583016', NULL),
	(10006951, 4, 'PW21A-TS100308GN-M', 2, 0, '2021-04-15 13:02:52.600275', '2021-04-15 13:02:52.600275', NULL),
	(10006952, 4, 'PW21A-TS100308GN-L', 2, 0, '2021-04-15 13:02:52.640560', '2021-04-15 13:02:52.640560', NULL),
	(10006953, 4, 'PW21A-TS100308GN-XL', 2, 0, '2021-04-15 13:02:52.595178', '2021-04-15 13:02:52.595178', NULL),
	(10006954, 4, 'PW21A-TS100308GN-XXL', 1, 0, '2021-04-15 13:02:52.611798', '2021-04-15 13:02:52.611798', NULL),
	(10006955, 4, 'PW21A-TS100309GN-XS', 0, 0, '2021-04-15 13:02:52.598590', '2021-04-15 13:02:52.598590', NULL),
	(10006956, 4, 'PW21A-TS100309GN-S', 2, 0, '2021-04-15 13:02:52.596840', '2021-04-15 13:02:52.596840', NULL),
	(10006957, 4, 'PW21A-TS100309GN-M', 2, 0, '2021-04-15 13:02:52.590886', '2021-04-15 13:02:52.590886', NULL),
	(10006958, 4, 'PW21A-TS100309GN-L', 2, 0, '2021-04-15 13:02:52.606493', '2021-04-15 13:02:52.606493', NULL),
	(10006959, 4, 'PW21A-TS100309GN-XL', 2, 0, '2021-04-15 13:02:52.599835', '2021-04-15 13:02:52.599835', NULL),
	(10006960, 4, 'PW21A-TS100309GN-XXL', 1, 0, '2021-04-15 13:02:52.616300', '2021-04-15 13:02:52.616300', NULL),
	(10006961, 4, 'PW21A-SW100310BL-XS', 0, 0, '2021-04-15 13:02:52.651676', '2021-04-15 13:02:52.651676', NULL),
	(10006962, 4, 'PW21A-SW100310BL-S', 0, 0, '2021-04-15 13:02:52.612393', '2021-04-15 13:02:52.612393', NULL),
	(10006963, 4, 'PW21A-SW100310BL-M', 0, 0, '2021-04-15 13:02:52.617845', '2021-04-15 13:02:52.617845', NULL),
	(10006964, 4, 'PW21A-SW100310BL-L', 0, 0, '2021-04-15 13:02:52.607270', '2021-04-15 13:02:52.607270', NULL),
	(10006965, 4, 'PW21A-SW100310BL-XL', 0, 0, '2021-04-15 13:02:52.641467', '2021-04-15 13:02:52.641467', NULL),
	(10006966, 4, 'PW21A-SW100310BL-XXL', 0, 0, '2021-04-15 13:02:52.613219', '2021-04-15 13:02:52.613219', NULL),
	(10006967, 4, 'PW21A-SW100311BL-XS', 0, 0, '2021-04-15 13:02:52.650972', '2021-04-15 13:02:52.650972', NULL),
	(10006968, 4, 'PW21A-SW100311BL-S', 2, 0, '2021-04-15 13:02:52.626778', '2021-04-15 13:02:52.626778', NULL),
	(10006969, 4, 'PW21A-SW100311BL-M', 1, 0, '2021-04-15 13:02:52.623576', '2021-04-15 13:02:52.623576', NULL),
	(10006970, 4, 'PW21A-SW100311BL-L', 3, 0, '2021-04-15 13:02:52.651370', '2021-04-15 13:02:52.651370', NULL),
	(10006971, 4, 'PW21A-SW100311BL-XL', 1, 0, '2021-04-15 13:02:52.646314', '2021-04-15 13:02:52.646314', NULL),
	(10006972, 4, 'PW21A-SW100311BL-XXL', 2, 0, '2021-04-15 13:02:52.711691', '2021-04-15 13:02:52.711691', NULL),
	(10006973, 4, 'PW21A-SW100312BL-XS', 0, 0, '2021-04-15 13:02:52.625564', '2021-04-15 13:02:52.625564', NULL),
	(10006974, 4, 'PW21A-SW100312BL-S', 0, 0, '2021-04-15 13:02:52.651955', '2021-04-15 13:02:52.651955', NULL),
	(10006975, 4, 'PW21A-SW100312BL-M', 0, 0, '2021-04-15 13:02:52.655610', '2021-04-15 13:02:52.655610', NULL),
	(10006976, 4, 'PW21A-SW100312BL-L', 0, 0, '2021-04-15 13:02:52.658439', '2021-04-15 13:02:52.658439', NULL),
	(10006977, 4, 'PW21A-SW100312BL-XL', 0, 0, '2021-04-15 13:02:52.699835', '2021-04-15 13:02:52.699835', NULL),
	(10006978, 4, 'PW21A-SW100312BL-XXL', 0, 0, '2021-04-15 13:02:52.665615', '2021-04-15 13:02:52.665615', NULL),
	(10006979, 4, 'PW21A-SW100313BL-XS', 0, 0, '2021-04-15 13:02:52.675824', '2021-04-15 13:02:52.675824', NULL),
	(10006980, 4, 'PW21A-SW100313BL-S', 0, 0, '2021-04-15 13:02:52.674492', '2021-04-15 13:02:52.674492', NULL),
	(10006981, 4, 'PW21A-SW100313BL-M', 0, 0, '2021-04-15 13:02:52.663726', '2021-04-15 13:02:52.663726', NULL),
	(10006982, 4, 'PW21A-SW100313BL-L', 0, 0, '2021-04-15 13:02:52.658145', '2021-04-15 13:02:52.658145', NULL),
	(10006983, 4, 'PW21A-SW100313BL-XL', 0, 0, '2021-04-15 13:02:52.683652', '2021-04-15 13:02:52.683652', NULL),
	(10006984, 4, 'PW21A-SW100313BL-XXL', 0, 0, '2021-04-15 13:02:52.674058', '2021-04-15 13:02:52.674058', NULL),
	(10006985, 4, 'PW21A-SW100314DK-XS', 0, 0, '2021-04-15 13:02:52.676398', '2021-04-15 13:02:52.676398', NULL),
	(10006986, 4, 'PW21A-SW100314DK-S', 0, 0, '2021-04-15 13:02:52.682936', '2021-04-15 13:02:52.682936', NULL),
	(10006987, 4, 'PW21A-SW100314DK-M', 0, 0, '2021-04-15 13:02:52.690253', '2021-04-15 13:02:52.690253', NULL),
	(10006988, 4, 'PW21A-SW100314DK-L', 0, 0, '2021-04-15 13:02:52.707574', '2021-04-15 13:02:52.707574', NULL),
	(10006989, 4, 'PW21A-SW100314DK-XL', 0, 0, '2021-04-15 13:02:52.689925', '2021-04-15 13:02:52.689925', NULL),
	(10006990, 4, 'PW21A-SW100314DK-XXL', 0, 0, '2021-04-15 13:02:52.682596', '2021-04-15 13:02:52.682596', NULL),
	(10006991, 4, 'PW21A-SW100315BL-XS', 0, 0, '2021-04-15 13:02:52.700817', '2021-04-15 13:02:52.700817', NULL),
	(10006992, 4, 'PW21A-SW100315BL-S', 0, 0, '2021-04-15 13:02:52.705366', '2021-04-15 13:02:52.705366', NULL),
	(10006993, 4, 'PW21A-SW100315BL-M', 0, 0, '2021-04-15 13:02:52.742159', '2021-04-15 13:02:52.742159', NULL),
	(10006994, 4, 'PW21A-SW100315BL-L', 0, 0, '2021-04-15 13:02:52.693572', '2021-04-15 13:02:52.693572', NULL),
	(10006995, 4, 'PW21A-SW100315BL-XL', 0, 0, '2021-04-15 13:02:52.701131', '2021-04-15 13:02:52.701131', NULL),
	(10006996, 4, 'PW21A-SW100315BL-XXL', 0, 0, '2021-04-15 13:02:52.704422', '2021-04-15 13:02:52.704422', NULL),
	(10006997, 4, 'PW21A-SW100316BL-XS', 0, 0, '2021-04-15 13:02:52.726470', '2021-04-15 13:02:52.726470', NULL),
	(10006998, 4, 'PW21A-SW100316BL-S', 0, 0, '2021-04-15 13:02:52.713167', '2021-04-15 13:02:52.713167', NULL),
	(10006999, 4, 'PW21A-SW100316BL-M', 0, 0, '2021-04-15 13:02:52.727152', '2021-04-15 13:02:52.727152', NULL),
	(10007000, 4, 'PW21A-SW100316BL-L', 0, 0, '2021-04-15 13:02:52.715542', '2021-04-15 13:02:52.715542', NULL),
	(10007001, 4, 'PW21A-SW100316BL-XL', 0, 0, '2021-04-15 13:02:52.726801', '2021-04-15 13:02:52.726801', NULL),
	(10007002, 4, 'PW21A-SW100316BL-XXL', 0, 0, '2021-04-15 13:02:52.707245', '2021-04-15 13:02:52.707245', NULL),
	(10007003, 4, 'PW21A-SW100317BL-XS', 0, 0, '2021-04-15 13:02:52.728384', '2021-04-15 13:02:52.728384', NULL),
	(10007004, 4, 'PW21A-SW100317BL-S', 0, 0, '2021-04-15 13:02:52.756319', '2021-04-15 13:02:52.756319', NULL),
	(10007005, 4, 'PW21A-SW100317BL-M', 1, 0, '2021-04-15 13:02:52.722686', '2021-04-15 13:02:52.722686', NULL),
	(10007006, 4, 'PW21A-SW100317BL-L', 1, 0, '2021-04-15 13:02:52.733518', '2021-04-15 13:02:52.733518', NULL),
	(10007007, 4, 'PW21A-SW100317BL-XL', 1, 0, '2021-04-15 13:02:52.724738', '2021-04-15 13:02:52.724738', NULL),
	(10007008, 4, 'PW21A-SW100317BL-XXL', 1, 0, '2021-04-15 13:02:52.745332', '2021-04-15 13:02:52.745332', NULL),
	(10007009, 4, 'PW21A-SW100318OL-XS', 0, 0, '2021-04-15 13:02:52.728059', '2021-04-15 13:02:52.728059', NULL),
	(10007010, 4, 'PW21A-SW100318OL-S', 1, 0, '2021-04-15 13:02:52.746058', '2021-04-15 13:02:52.746058', NULL),
	(10007011, 4, 'PW21A-SW100318OL-M', 2, 0, '2021-04-15 13:02:52.731087', '2021-04-15 13:02:52.731087', NULL),
	(10007012, 4, 'PW21A-SW100318OL-L', 2, 0, '2021-04-15 13:02:52.776620', '2021-04-15 13:02:52.776620', NULL),
	(10007013, 4, 'PW21A-SW100318OL-XL', 0, 0, '2021-04-15 13:02:52.767476', '2021-04-15 13:02:52.767476', NULL),
	(10007014, 4, 'PW21A-SW100318OL-XXL', 1, 0, '2021-04-15 13:02:52.737207', '2021-04-15 13:02:52.737207', NULL),
	(10007015, 4, 'PW21A-SW100319WT-XS', 0, 0, '2021-04-15 13:02:52.749679', '2021-04-15 13:02:52.749679', NULL),
	(10007016, 4, 'PW21A-SW100319WT-S', 0, 0, '2021-04-15 13:02:52.791674', '2021-04-15 13:02:52.791674', NULL),
	(10007017, 4, 'PW21A-SW100319WT-M', 0, 0, '2021-04-15 13:02:52.747649', '2021-04-15 13:02:52.747649', NULL),
	(10007018, 4, 'PW21A-SW100319WT-L', 0, 0, '2021-04-15 13:02:52.747964', '2021-04-15 13:02:52.747964', NULL),
	(10007019, 4, 'PW21A-SW100319WT-XL', 0, 0, '2021-04-15 13:02:52.746537', '2021-04-15 13:02:52.746537', NULL),
	(10007020, 4, 'PW21A-SW100319WT-XXL', 0, 0, '2021-04-15 13:02:52.765026', '2021-04-15 13:02:52.765026', NULL),
	(10007021, 4, 'PW21A-SW100320BL-XS', 0, 0, '2021-04-15 13:02:52.761684', '2021-04-15 13:02:52.761684', NULL),
	(10007022, 4, 'PW21A-SW100320BL-S', 0, 0, '2021-04-15 13:02:52.751262', '2021-04-15 13:02:52.751262', NULL),
	(10007023, 4, 'PW21A-SW100320BL-M', 0, 0, '2021-04-15 13:02:52.758951', '2021-04-15 13:02:52.758951', NULL),
	(10007024, 4, 'PW21A-SW100320BL-L', 0, 0, '2021-04-15 13:02:52.769940', '2021-04-15 13:02:52.769940', NULL),
	(10007025, 4, 'PW21A-SW100320BL-XL', 0, 0, '2021-04-15 13:02:52.770646', '2021-04-15 13:02:52.770646', NULL),
	(10007026, 4, 'PW21A-SW100320BL-XXL', 0, 0, '2021-04-15 13:02:52.767788', '2021-04-15 13:02:52.767788', NULL),
	(10007027, 4, 'PW21A-SW100321BL-XS', 0, 0, '2021-04-15 13:02:52.781925', '2021-04-15 13:02:52.781925', NULL),
	(10007028, 4, 'PW21A-SW100321BL-S', 0, 0, '2021-04-15 13:02:52.779694', '2021-04-15 13:02:52.779694', NULL),
	(10007029, 4, 'PW21A-SW100321BL-M', 0, 0, '2021-04-15 13:02:52.772935', '2021-04-15 13:02:52.772935', NULL),
	(10007030, 4, 'PW21A-SW100321BL-L', 0, 0, '2021-04-15 13:02:52.770360', '2021-04-15 13:02:52.770360', NULL),
	(10007031, 4, 'PW21A-SW100321BL-XL', 0, 0, '2021-04-15 13:02:52.793255', '2021-04-15 13:02:52.793255', NULL),
	(10007032, 4, 'PW21A-SW100321BL-XXL', 0, 0, '2021-04-15 13:02:52.811023', '2021-04-15 13:02:52.811023', NULL),
	(10007033, 4, 'PW21A-SW100322BL-XS', 0, 0, '2021-04-15 13:02:52.810741', '2021-04-15 13:02:52.810741', NULL),
	(10007034, 4, 'PW21A-SW100322BL-S', 0, 0, '2021-04-15 13:02:52.781556', '2021-04-15 13:02:52.781556', NULL),
	(10007035, 4, 'PW21A-SW100322BL-M', 0, 0, '2021-04-15 13:02:52.821826', '2021-04-15 13:02:52.821826', NULL),
	(10007036, 4, 'PW21A-SW100322BL-L', 0, 0, '2021-04-15 13:02:52.793533', '2021-04-15 13:02:52.793533', NULL),
	(10007037, 4, 'PW21A-SW100322BL-XL', 0, 0, '2021-04-15 13:02:52.790977', '2021-04-15 13:02:52.790977', NULL),
	(10007038, 4, 'PW21A-SW100322BL-XXL', 0, 0, '2021-04-15 13:02:52.794062', '2021-04-15 13:02:52.794062', NULL),
	(10007039, 4, 'PW21A-SW100323BL-XS', 0, 0, '2021-04-15 13:02:52.815195', '2021-04-15 13:02:52.815195', NULL),
	(10007040, 4, 'PW21A-SW100323BL-S', 0, 0, '2021-04-15 13:02:52.809916', '2021-04-15 13:02:52.809916', NULL),
	(10007041, 4, 'PW21A-SW100323BL-M', 0, 0, '2021-04-15 13:02:52.793806', '2021-04-15 13:02:52.793806', NULL),
	(10007042, 4, 'PW21A-SW100323BL-L', 0, 0, '2021-04-15 13:02:52.808122', '2021-04-15 13:02:52.808122', NULL),
	(10007043, 4, 'PW21A-SW100323BL-XL', 0, 0, '2021-04-15 13:02:52.818668', '2021-04-15 13:02:52.818668', NULL),
	(10007044, 4, 'PW21A-SW100323BL-XXL', 0, 0, '2021-04-15 13:02:52.825165', '2021-04-15 13:02:52.825165', NULL),
	(10007045, 4, 'PW21A-SW100324BL-XS', 0, 0, '2021-04-15 13:02:52.820010', '2021-04-15 13:02:52.820010', NULL),
	(10007046, 4, 'PW21A-SW100324BL-S', 2, 0, '2021-04-15 13:02:52.840973', '2021-04-15 13:02:52.840973', NULL),
	(10007047, 4, 'PW21A-SW100324BL-M', 2, 0, '2021-04-15 13:02:52.816245', '2021-04-15 13:02:52.816245', NULL),
	(10007048, 4, 'PW21A-SW100324BL-L', 2, 0, '2021-04-15 13:02:52.841266', '2021-04-15 13:02:52.841266', NULL),
	(10007049, 4, 'PW21A-SW100324BL-XL', 2, 0, '2021-04-15 13:02:52.827668', '2021-04-15 13:02:52.827668', NULL),
	(10007050, 4, 'PW21A-SW100324BL-XXL', 1, 0, '2021-04-15 13:02:52.835396', '2021-04-15 13:02:52.835396', NULL),
	(10007051, 4, 'PW21A-SW100325BL-XS', 0, 0, '2021-04-15 13:02:52.831942', '2021-04-15 13:02:52.831942', NULL),
	(10007052, 4, 'PW21A-SW100325BL-S', 2, 0, '2021-04-15 13:02:52.829633', '2021-04-15 13:02:52.829633', NULL),
	(10007053, 4, 'PW21A-SW100325BL-M', 1, 0, '2021-04-15 13:02:52.871506', '2021-04-15 13:02:52.871506', NULL),
	(10007054, 4, 'PW21A-SW100325BL-L', 2, 0, '2021-04-15 13:02:52.859486', '2021-04-15 13:02:52.859486', NULL),
	(10007055, 4, 'PW21A-SW100325BL-XL', 2, 0, '2021-04-15 13:02:52.837704', '2021-04-15 13:02:52.837704', NULL),
	(10007056, 4, 'PW21A-SW100325BL-XXL', 1, 0, '2021-04-15 13:02:52.843363', '2021-04-15 13:02:52.843363', NULL),
	(10007057, 4, 'PW21A-SW100326BL-XS', 0, 0, '2021-04-15 13:02:52.846117', '2021-04-15 13:02:52.846117', NULL),
	(10007058, 4, 'PW21A-SW100326BL-S', 2, 0, '2021-04-15 13:02:52.829957', '2021-04-15 13:02:52.829957', NULL),
	(10007059, 4, 'PW21A-SW100326BL-M', 2, 0, '2021-04-15 13:02:52.840254', '2021-04-15 13:02:52.840254', NULL),
	(10007060, 4, 'PW21A-SW100326BL-L', 2, 0, '2021-04-15 13:02:52.861016', '2021-04-15 13:02:52.861016', NULL),
	(10007061, 4, 'PW21A-SW100326BL-XL', 2, 0, '2021-04-15 13:02:52.849073', '2021-04-15 13:02:52.849073', NULL),
	(10007062, 4, 'PW21A-SW100326BL-XXL', 1, 0, '2021-04-15 13:02:52.850032', '2021-04-15 13:02:52.850032', NULL),
	(10007063, 4, 'PW21A-SW100327BL-XS', 0, 0, '2021-04-15 13:02:52.877149', '2021-04-15 13:02:52.877149', NULL),
	(10007064, 4, 'PW21A-SW100327BL-S', 2, 0, '2021-04-15 13:02:52.854929', '2021-04-15 13:02:52.854929', NULL),
	(10007065, 4, 'PW21A-SW100327BL-M', 2, 0, '2021-04-15 13:02:52.856442', '2021-04-15 13:02:52.856442', NULL),
	(10007066, 4, 'PW21A-SW100327BL-L', 2, 0, '2021-04-15 13:02:52.861932', '2021-04-15 13:02:52.861932', NULL),
	(10007067, 4, 'PW21A-SW100327BL-XL', 2, 0, '2021-04-15 13:02:52.851581', '2021-04-15 13:02:52.851581', NULL),
	(10007068, 4, 'PW21A-SW100327BL-XXL', 1, 0, '2021-04-15 13:02:52.869638', '2021-04-15 13:02:52.869638', NULL),
	(10007069, 4, 'PW21A-SW100328BL-XS', 0, 0, '2021-04-15 13:02:52.907489', '2021-04-15 13:02:52.907489', NULL),
	(10007070, 4, 'PW21A-SW100328BL-S', 2, 0, '2021-04-15 13:02:52.864528', '2021-04-15 13:02:52.864528', NULL),
	(10007071, 4, 'PW21A-SW100328BL-M', 2, 0, '2021-04-15 13:02:52.920480', '2021-04-15 13:02:52.920480', NULL),
	(10007072, 4, 'PW21A-SW100328BL-L', 2, 0, '2021-04-15 13:02:52.867277', '2021-04-15 13:02:52.867277', NULL),
	(10007073, 4, 'PW21A-SW100328BL-XL', 2, 0, '2021-04-15 13:02:52.896223', '2021-04-15 13:02:52.896223', NULL),
	(10007074, 4, 'PW21A-SW100328BL-XXL', 1, 0, '2021-04-15 13:02:52.873946', '2021-04-15 13:02:52.873946', NULL),
	(10007075, 4, 'PW21A-SW100329BL-XS', 0, 0, '2021-04-15 13:02:52.883334', '2021-04-15 13:02:52.883334', NULL),
	(10007076, 4, 'PW21A-SW100329BL-S', 2, 0, '2021-04-15 13:02:52.880624', '2021-04-15 13:02:52.880624', NULL),
	(10007077, 4, 'PW21A-SW100329BL-M', 2, 0, '2021-04-15 13:02:52.878362', '2021-04-15 13:02:52.878362', NULL),
	(10007078, 4, 'PW21A-SW100329BL-L', 2, 0, '2021-04-15 13:02:52.887312', '2021-04-15 13:02:52.887312', NULL),
	(10007079, 4, 'PW21A-SW100329BL-XL', 2, 0, '2021-04-15 13:02:52.881019', '2021-04-15 13:02:52.881019', NULL),
	(10007080, 4, 'PW21A-SW100329BL-XXL', 1, 0, '2021-04-15 13:02:52.929908', '2021-04-15 13:02:52.929908', NULL),
	(10007081, 4, 'PW21A-SW100330BL-XS', 0, 0, '2021-04-15 13:02:52.895830', '2021-04-15 13:02:52.895830', NULL),
	(10007082, 4, 'PW21A-SW100330BL-S', 2, 0, '2021-04-15 13:02:52.889763', '2021-04-15 13:02:52.889763', NULL),
	(10007083, 4, 'PW21A-SW100330BL-M', 2, 0, '2021-04-15 13:02:52.905583', '2021-04-15 13:02:52.905583', NULL),
	(10007084, 4, 'PW21A-SW100330BL-L', 2, 0, '2021-04-15 13:02:52.906033', '2021-04-15 13:02:52.906033', NULL),
	(10007085, 4, 'PW21A-SW100330BL-XL', 2, 0, '2021-04-15 13:02:52.918589', '2021-04-15 13:02:52.918589', NULL),
	(10007086, 4, 'PW21A-SW100330BL-XXL', 1, 0, '2021-04-15 13:02:52.900477', '2021-04-15 13:02:52.900477', NULL),
	(10007087, 4, 'PW21A-PN100331BL-28', 0, 0, '2021-04-15 13:02:52.927095', '2021-04-15 13:02:52.927095', NULL),
	(10007088, 4, 'PW21A-PN100331BL-30', 0, 0, '2021-04-15 13:02:52.903318', '2021-04-15 13:02:52.903318', NULL),
	(10007089, 4, 'PW21A-PN100331BL-32', 0, 0, '2021-04-15 13:02:52.917382', '2021-04-15 13:02:52.917382', NULL),
	(10007090, 4, 'PW21A-PN100331BL-34', 0, 0, '2021-04-15 13:02:52.906436', '2021-04-15 13:02:52.906436', NULL),
	(10007091, 4, 'PW21A-PN100331BL-36', 0, 0, '2021-04-15 13:02:52.964982', '2021-04-15 13:02:52.964982', NULL),
	(10007092, 4, 'PW21A-PN100332BL-28', 0, 0, '2021-04-15 13:02:52.913896', '2021-04-15 13:02:52.913896', NULL),
	(10007093, 4, 'PW21A-PN100332BL-30', 0, 0, '2021-04-15 13:02:52.929561', '2021-04-15 13:02:52.929561', NULL),
	(10007094, 4, 'PW21A-PN100332BL-32', 0, 0, '2021-04-15 13:02:52.925244', '2021-04-15 13:02:52.925244', NULL),
	(10007095, 4, 'PW21A-PN100332BL-34', 0, 0, '2021-04-15 13:02:52.941168', '2021-04-15 13:02:52.941168', NULL),
	(10007096, 4, 'PW21A-PN100332BL-36', 0, 0, '2021-04-15 13:02:52.936865', '2021-04-15 13:02:52.936865', NULL),
	(10007097, 4, 'PW21A-PN100333BL-28', 2, 0, '2021-04-15 13:02:52.929231', '2021-04-15 13:02:52.929231', NULL),
	(10007098, 4, 'PW21A-PN100333BL-30', 2, 0, '2021-04-15 13:02:52.969728', '2021-04-15 13:02:52.969728', NULL),
	(10007099, 4, 'PW21A-PN100333BL-32', 2, 0, '2021-04-15 13:02:52.930622', '2021-04-15 13:02:52.930622', NULL),
	(10007100, 4, 'PW21A-PN100333BL-34', 1, 0, '2021-04-15 13:02:52.951341', '2021-04-15 13:02:52.951341', NULL),
	(10007101, 4, 'PW21A-PN100333BL-36', 0, 0, '2021-04-15 13:02:52.935662', '2021-04-15 13:02:52.935662', NULL),
	(10007102, 4, 'PW21A-PN100334BL-28', 0, 0, '2021-04-15 13:02:52.939523', '2021-04-15 13:02:52.939523', NULL),
	(10007103, 4, 'PW21A-PN100334BL-30', 0, 0, '2021-04-15 13:02:52.946693', '2021-04-15 13:02:52.946693', NULL),
	(10007104, 4, 'PW21A-PN100334BL-32', 0, 0, '2021-04-15 13:02:52.982707', '2021-04-15 13:02:52.982707', NULL),
	(10007105, 4, 'PW21A-PN100334BL-34', 0, 0, '2021-04-15 13:02:52.950706', '2021-04-15 13:02:52.950706', NULL),
	(10007106, 4, 'PW21A-PN100334BL-36', 0, 0, '2021-04-15 13:02:52.951039', '2021-04-15 13:02:52.951039', NULL),
	(10007107, 4, 'PW21A-PN100335BL-28', 1, 0, '2021-04-15 13:02:52.948175', '2021-04-15 13:02:52.948175', NULL),
	(10007108, 4, 'PW21A-PN100335BL-30', 2, 0, '2021-04-15 13:02:52.993074', '2021-04-15 13:02:52.993074', NULL),
	(10007109, 4, 'PW21A-PN100335BL-32', 2, 0, '2021-04-15 13:02:52.996421', '2021-04-15 13:02:52.996421', NULL),
	(10007110, 4, 'PW21A-PN100335BL-34', 1, 0, '2021-04-15 13:02:52.950324', '2021-04-15 13:02:52.950324', NULL),
	(10007111, 4, 'PW21A-PN100335BL-36', 2, 0, '2021-04-15 13:02:52.956768', '2021-04-15 13:02:52.956768', NULL),
	(10007112, 4, 'PW21A-PN100336GN-28', 1, 0, '2021-04-15 13:02:52.959601', '2021-04-15 13:02:52.959601', NULL),
	(10007113, 4, 'PW21A-PN100336GN-30', 2, 0, '2021-04-15 13:02:53.033236', '2021-04-15 13:02:53.033236', NULL),
	(10007114, 4, 'PW21A-PN100336GN-32', 2, 0, '2021-04-15 13:02:52.960674', '2021-04-15 13:02:52.960674', NULL),
	(10007115, 4, 'PW21A-PN100336GN-34', 2, 0, '2021-04-15 13:02:52.970378', '2021-04-15 13:02:52.970378', NULL),
	(10007116, 4, 'PW21A-PN100336GN-36', 1, 0, '2021-04-15 13:02:52.959887', '2021-04-15 13:02:52.959887', NULL),
	(10007117, 4, 'PW21A-PN100337CM-28', 1, 0, '2021-04-15 13:02:52.969141', '2021-04-15 13:02:52.969141', NULL),
	(10007118, 4, 'PW21A-PN100337CM-30', 2, 0, '2021-04-15 13:02:52.970043', '2021-04-15 13:02:52.970043', NULL),
	(10007119, 4, 'PW21A-PN100337CM-32', 2, 0, '2021-04-15 13:02:52.982268', '2021-04-15 13:02:52.982268', NULL),
	(10007120, 4, 'PW21A-PN100337CM-34', 2, 0, '2021-04-15 13:02:52.970686', '2021-04-15 13:02:52.970686', NULL),
	(10007121, 4, 'PW21A-PN100337CM-36', 1, 0, '2021-04-15 13:02:52.976734', '2021-04-15 13:02:52.976734', NULL),
	(10007122, 4, 'PW21A-PN100338BL-28', 2, 0, '2021-04-15 13:02:53.018358', '2021-04-15 13:02:53.018358', NULL),
	(10007123, 4, 'PW21A-PN100338BL-30', 2, 0, '2021-04-15 13:02:53.025385', '2021-04-15 13:02:53.025385', NULL),
	(10007124, 4, 'PW21A-PN100338BL-32', 2, 0, '2021-04-15 13:02:52.983963', '2021-04-15 13:02:52.983963', NULL),
	(10007125, 4, 'PW21A-PN100338BL-34', 2, 0, '2021-04-15 13:02:52.996105', '2021-04-15 13:02:52.996105', NULL),
	(10007126, 4, 'PW21A-PN100338BL-36', 1, 0, '2021-04-15 13:02:52.998460', '2021-04-15 13:02:52.998460', NULL),
	(10007127, 4, 'PW21A-PN100339CM-28', 2, 0, '2021-04-15 13:02:52.998933', '2021-04-15 13:02:52.998933', NULL),
	(10007128, 4, 'PW21A-PN100339CM-30', 2, 0, '2021-04-15 13:02:53.035489', '2021-04-15 13:02:53.035489', NULL),
	(10007129, 4, 'PW21A-PN100339CM-32', 2, 0, '2021-04-15 13:02:53.017634', '2021-04-15 13:02:53.017634', NULL),
	(10007130, 4, 'PW21A-PN100339CM-34', 2, 0, '2021-04-15 13:02:53.052271', '2021-04-15 13:02:53.052271', NULL),
	(10007131, 4, 'PW21A-PN100339CM-36', 1, 0, '2021-04-15 13:02:53.000202', '2021-04-15 13:02:53.000202', NULL),
	(10007132, 4, 'PW21A-PN100340OL-28', 1, 0, '2021-04-15 13:02:53.015246', '2021-04-15 13:02:53.015246', NULL),
	(10007133, 4, 'PW21A-PN100340OL-30', 2, 0, '2021-04-15 13:02:53.020250', '2021-04-15 13:02:53.020250', NULL),
	(10007134, 4, 'PW21A-PN100340OL-32', 2, 0, '2021-04-15 13:02:53.192321', '2021-04-15 13:02:53.192321', NULL),
	(10007135, 4, 'PW21A-PN100340OL-34', 2, 0, '2021-04-15 13:02:53.032874', '2021-04-15 13:02:53.032874', NULL),
	(10007136, 4, 'PW21A-PN100340OL-36', 1, 0, '2021-04-15 13:02:53.089997', '2021-04-15 13:02:53.089997', NULL),
	(10007137, 4, 'PW21A-PN100341DM-28', 2, 0, '2021-04-15 13:02:53.163740', '2021-04-15 13:02:53.163740', NULL),
	(10007138, 4, 'PW21A-PN100341DM-30', 2, 0, '2021-04-15 13:02:53.034858', '2021-04-15 13:02:53.034858', NULL),
	(10007139, 4, 'PW21A-PN100341DM-32', 2, 0, '2021-04-15 13:02:53.047847', '2021-04-15 13:02:53.047847', NULL),
	(10007140, 4, 'PW21A-PN100341DM-34', 2, 0, '2021-04-15 13:02:53.040742', '2021-04-15 13:02:53.040742', NULL),
	(10007141, 4, 'PW21A-PN100341DM-36', 0, 0, '2021-04-15 13:02:53.048430', '2021-04-15 13:02:53.048430', NULL),
	(10007142, 4, 'PW21A-PN100342DM-28', 2, 0, '2021-04-15 13:02:53.064008', '2021-04-15 13:02:53.064008', NULL),
	(10007143, 4, 'PW21A-PN100342DM-30', 2, 0, '2021-04-15 13:02:53.066881', '2021-04-15 13:02:53.066881', NULL),
	(10007144, 4, 'PW21A-PN100342DM-32', 2, 0, '2021-04-15 13:02:53.037254', '2021-04-15 13:02:53.037254', NULL),
	(10007145, 4, 'PW21A-PN100342DM-34', 2, 0, '2021-04-15 13:02:53.050624', '2021-04-15 13:02:53.050624', NULL),
	(10007146, 4, 'PW21A-PN100342DM-36', 0, 0, '2021-04-15 13:02:53.072085', '2021-04-15 13:02:53.072085', NULL),
	(10007147, 4, 'PW21A-PN100343DM-28', 2, 0, '2021-04-15 13:02:53.070781', '2021-04-15 13:02:53.070781', NULL),
	(10007148, 4, 'PW21A-PN100343DM-30', 2, 0, '2021-04-15 13:02:53.075692', '2021-04-15 13:02:53.075692', NULL),
	(10007149, 4, 'PW21A-PN100343DM-32', 2, 0, '2021-04-15 13:02:53.067980', '2021-04-15 13:02:53.067980', NULL),
	(10007150, 4, 'PW21A-PN100343DM-34', 2, 0, '2021-04-15 13:02:53.067222', '2021-04-15 13:02:53.067222', NULL),
	(10007151, 4, 'PW21A-PN100343DM-36', 0, 0, '2021-04-15 13:02:53.142020', '2021-04-15 13:02:53.142020', NULL),
	(10007152, 4, 'PW21A-WL100344BW-All', 2, 0, '2021-04-15 13:02:53.162998', '2021-04-15 13:02:53.162998', NULL),
	(10007153, 4, 'PW21A-WL100345BW-All', 2, 0, '2021-04-15 13:02:53.213358', '2021-04-15 13:02:53.213358', NULL),
	(10007154, 4, 'PW21A-WL100346BW-All', 2, 0, '2021-04-15 13:02:53.071600', '2021-04-15 13:02:53.071600', NULL),
	(10007155, 4, 'PW21A-HM100347BL-XS', 0, 0, '2021-04-15 13:02:53.093344', '2021-04-15 13:02:53.093344', NULL),
	(10007156, 4, 'PW21A-HM100347BL-S', 0, 0, '2021-04-15 13:02:53.178124', '2021-04-15 13:02:53.178124', NULL),
	(10007157, 4, 'PW21A-HM100347BL-M', 0, 0, '2021-04-15 13:02:53.217578', '2021-04-15 13:02:53.217578', NULL),
	(10007158, 4, 'PW21A-HM100347BL-L', 0, 0, '2021-04-15 13:02:53.227499', '2021-04-15 13:02:53.227499', NULL),
	(10007159, 4, 'PW21A-HM100347BL-XL', 0, 0, '2021-04-15 13:02:53.248270', '2021-04-15 13:02:53.248270', NULL),
	(10007160, 4, 'PW21A-HM100347BL-XXL', 0, 0, '2021-04-15 13:02:53.233683', '2021-04-15 13:02:53.233683', NULL),
	(10007161, 4, 'PW21A-HM100348WT-XS', 0, 0, '2021-04-15 13:02:53.177235', '2021-04-15 13:02:53.177235', NULL),
	(10007162, 4, 'PW21A-HM100348WT-S', 0, 0, '2021-04-15 13:02:53.177671', '2021-04-15 13:02:53.177671', NULL),
	(10007163, 4, 'PW21A-HM100348WT-M', 0, 0, '2021-04-15 13:02:53.201359', '2021-04-15 13:02:53.201359', NULL),
	(10007164, 4, 'PW21A-HM100348WT-L', 0, 0, '2021-04-15 13:02:53.209797', '2021-04-15 13:02:53.209797', NULL),
	(10007165, 4, 'PW21A-HM100348WT-XL', 0, 0, '2021-04-15 13:02:53.183310', '2021-04-15 13:02:53.183310', NULL),
	(10007166, 4, 'PW21A-HM100348WT-XXL', 0, 0, '2021-04-15 13:02:53.218662', '2021-04-15 13:02:53.218662', NULL),
	(10007167, 4, 'PW21A-HM100349BL-XS', 0, 0, '2021-04-15 13:02:53.193381', '2021-04-15 13:02:53.193381', NULL),
	(10007168, 4, 'PW21A-HM100349BL-S', 1, 0, '2021-04-15 13:02:53.209310', '2021-04-15 13:02:53.209310', NULL),
	(10007169, 4, 'PW21A-HM100349BL-M', 1, 0, '2021-04-15 13:02:53.250708', '2021-04-15 13:02:53.250708', NULL),
	(10007170, 4, 'PW21A-HM100349BL-L', 0, 0, '2021-04-15 13:02:53.220700', '2021-04-15 13:02:53.220700', NULL),
	(10007171, 4, 'PW21A-HM100349BL-XL', 0, 0, '2021-04-15 13:02:53.239602', '2021-04-15 13:02:53.239602', NULL),
	(10007172, 4, 'PW21A-HM100349BL-XXL', 0, 0, '2021-04-15 13:02:53.230106', '2021-04-15 13:02:53.230106', NULL),
	(10007173, 4, 'PW21A-HM100350BL-XS', 0, 0, '2021-04-15 13:02:53.252871', '2021-04-15 13:02:53.252871', NULL),
	(10007174, 4, 'PW21A-HM100350BL-S', 0, 0, '2021-04-15 13:02:53.281142', '2021-04-15 13:02:53.281142', NULL),
	(10007175, 4, 'PW21A-HM100350BL-M', 1, 0, '2021-04-15 13:02:53.253764', '2021-04-15 13:02:53.253764', NULL),
	(10007176, 4, 'PW21A-HM100350BL-L', 0, 0, '2021-04-15 13:02:53.226774', '2021-04-15 13:02:53.226774', NULL),
	(10007177, 4, 'PW21A-HM100350BL-XL', 0, 0, '2021-04-15 13:02:53.303087', '2021-04-15 13:02:53.303087', NULL),
	(10007178, 4, 'PW21A-HM100350BL-XXL', 0, 0, '2021-04-15 13:02:53.239913', '2021-04-15 13:02:53.239913', NULL),
	(10007179, 4, 'PW21A-HM100351BL-XS', 0, 0, '2021-04-15 13:02:53.287168', '2021-04-15 13:02:53.287168', NULL),
	(10007180, 4, 'PW21A-HM100351BL-S', 0, 0, '2021-04-15 13:02:53.306909', '2021-04-15 13:02:53.306909', NULL),
	(10007181, 4, 'PW21A-HM100351BL-M', 0, 0, '2021-04-15 13:02:53.271162', '2021-04-15 13:02:53.271162', NULL),
	(10007182, 4, 'PW21A-HM100351BL-L', 0, 0, '2021-04-15 13:02:53.261206', '2021-04-15 13:02:53.261206', NULL),
	(10007183, 4, 'PW21A-HM100351BL-XL', 0, 0, '2021-04-15 13:02:53.258641', '2021-04-15 13:02:53.258641', NULL),
	(10007184, 4, 'PW21A-HM100351BL-XXL', 0, 0, '2021-04-15 13:02:53.254397', '2021-04-15 13:02:53.254397', NULL),
	(10007185, 4, 'PW21A-HM100352BL-XS', 0, 0, '2021-04-15 13:02:53.280630', '2021-04-15 13:02:53.280630', NULL),
	(10007186, 4, 'PW21A-HM100352BL-S', 0, 0, '2021-04-15 13:02:53.301072', '2021-04-15 13:02:53.301072', NULL),
	(10007187, 4, 'PW21A-HM100352BL-M', 0, 0, '2021-04-15 13:02:53.255415', '2021-04-15 13:02:53.255415', NULL),
	(10007188, 4, 'PW21A-HM100352BL-L', 0, 0, '2021-04-15 13:02:53.273034', '2021-04-15 13:02:53.273034', NULL),
	(10007189, 4, 'PW21A-HM100352BL-XL', 0, 0, '2021-04-15 13:02:53.278653', '2021-04-15 13:02:53.278653', NULL),
	(10007190, 4, 'PW21A-HM100352BL-XXL', 0, 0, '2021-04-15 13:02:53.283595', '2021-04-15 13:02:53.283595', NULL),
	(10007191, 4, 'PW21A-HM100353WT-XS', 0, 0, '2021-04-15 13:02:53.292059', '2021-04-15 13:02:53.292059', NULL),
	(10007192, 4, 'PW21A-HM100353WT-S', 0, 0, '2021-04-15 13:02:53.309125', '2021-04-15 13:02:53.309125', NULL),
	(10007193, 4, 'PW21A-HM100353WT-M', 0, 0, '2021-04-15 13:02:53.285756', '2021-04-15 13:02:53.285756', NULL),
	(10007194, 4, 'PW21A-HM100353WT-L', 0, 0, '2021-04-15 13:02:53.284464', '2021-04-15 13:02:53.284464', NULL),
	(10007195, 4, 'PW21A-HM100353WT-XL', 0, 0, '2021-04-15 13:02:53.350115', '2021-04-15 13:02:53.350115', NULL),
	(10007196, 4, 'PW21A-HM100353WT-XXL', 0, 0, '2021-04-15 13:02:53.351258', '2021-04-15 13:02:53.351258', NULL),
	(10007197, 4, 'PW21A-HM100354WT-XS', 0, 0, '2021-04-15 13:02:53.298051', '2021-04-15 13:02:53.298051', NULL),
	(10007198, 4, 'PW21A-HM100354WT-S', 1, 0, '2021-04-15 13:02:53.311393', '2021-04-15 13:02:53.311393', NULL),
	(10007199, 4, 'PW21A-HM100354WT-M', 1, 0, '2021-04-15 13:02:53.311740', '2021-04-15 13:02:53.311740', NULL),
	(10007200, 4, 'PW21A-HM100354WT-L', 0, 0, '2021-04-15 13:02:53.362503', '2021-04-15 13:02:53.362503', NULL),
	(10007201, 4, 'PW21A-HM100354WT-XL', 0, 0, '2021-04-15 13:02:53.299769', '2021-04-15 13:02:53.299769', NULL),
	(10007202, 4, 'PW21A-HM100354WT-XXL', 0, 0, '2021-04-15 13:02:53.342068', '2021-04-15 13:02:53.342068', NULL),
	(10007203, 4, 'PW21A-HM100355RD-XS', 0, 0, '2021-04-15 13:02:53.339613', '2021-04-15 13:02:53.339613', NULL),
	(10007204, 4, 'PW21A-HM100355RD-S', 0, 0, '2021-04-15 13:02:53.310125', '2021-04-15 13:02:53.310125', NULL),
	(10007205, 4, 'PW21A-HM100355RD-M', 0, 0, '2021-04-15 13:02:53.334458', '2021-04-15 13:02:53.334458', NULL),
	(10007206, 4, 'PW21A-HM100355RD-L', 0, 0, '2021-04-15 13:02:53.312055', '2021-04-15 13:02:53.312055', NULL),
	(10007207, 4, 'PW21A-HM100355RD-XL', 0, 0, '2021-04-15 13:02:53.339979', '2021-04-15 13:02:53.339979', NULL),
	(10007208, 4, 'PW21A-HM100355RD-XXL', 0, 0, '2021-04-15 13:02:53.325694', '2021-04-15 13:02:53.325694', NULL),
	(10007209, 4, 'PW21A-HM100356YW -XS', 0, 0, '2021-04-15 13:02:53.325280', '2021-04-15 13:02:53.325280', NULL),
	(10007210, 4, 'PW21A-HM100356YW -S', 1, 0, '2021-04-15 13:02:53.341727', '2021-04-15 13:02:53.341727', NULL),
	(10007211, 4, 'PW21A-HM100356YW -M', 0, 0, '2021-04-15 13:02:53.357009', '2021-04-15 13:02:53.357009', NULL),
	(10007212, 4, 'PW21A-HM100356YW -L', 1, 0, '2021-04-15 13:02:53.331323', '2021-04-15 13:02:53.331323', NULL),
	(10007213, 4, 'PW21A-HM100356YW -XL', 0, 0, '2021-04-15 13:02:53.388088', '2021-04-15 13:02:53.388088', NULL),
	(10007214, 4, 'PW21A-HM100356YW -XXL', 0, 0, '2021-04-15 13:02:53.344916', '2021-04-15 13:02:53.344916', NULL),
	(10007215, 4, 'PW21A-HM100357YW -XS', 0, 0, '2021-04-15 13:02:53.361424', '2021-04-15 13:02:53.361424', NULL),
	(10007216, 4, 'PW21A-HM100357YW -S', 0, 0, '2021-04-15 13:02:53.362776', '2021-04-15 13:02:53.362776', NULL),
	(10007217, 4, 'PW21A-HM100357YW -M', 0, 0, '2021-04-15 13:02:53.378969', '2021-04-15 13:02:53.378969', NULL),
	(10007218, 4, 'PW21A-HM100357YW -L', 0, 0, '2021-04-15 13:02:53.345313', '2021-04-15 13:02:53.345313', NULL),
	(10007219, 4, 'PW21A-HM100357YW -XL', 0, 0, '2021-04-15 13:02:53.366605', '2021-04-15 13:02:53.366605', NULL),
	(10007220, 4, 'PW21A-HM100357YW -XXL', 0, 0, '2021-04-15 13:02:53.360101', '2021-04-15 13:02:53.360101', NULL),
	(10007221, 4, 'PW21A-HM100358WT-XS', 0, 0, '2021-04-15 13:02:53.361774', '2021-04-15 13:02:53.361774', NULL),
	(10007222, 4, 'PW21A-HM100358WT-S', 0, 0, '2021-04-15 13:02:53.392291', '2021-04-15 13:02:53.392291', NULL),
	(10007223, 4, 'PW21A-HM100358WT-M', 0, 0, '2021-04-15 13:02:53.385769', '2021-04-15 13:02:53.385769', NULL),
	(10007224, 4, 'PW21A-HM100358WT-L', 0, 0, '2021-04-15 13:02:53.408541', '2021-04-15 13:02:53.408541', NULL),
	(10007225, 4, 'PW21A-HM100358WT-XL', 0, 0, '2021-04-15 13:02:53.366300', '2021-04-15 13:02:53.366300', NULL),
	(10007226, 4, 'PW21A-HM100358WT-XXL', 0, 0, '2021-04-15 13:02:53.383533', '2021-04-15 13:02:53.383533', NULL),
	(10007227, 4, 'PW21A-JK100359NV-XS', 0, 0, '2021-04-15 13:02:53.373763', '2021-04-15 13:02:53.373763', NULL),
	(10007228, 4, 'PW21A-JK100359NV-S', 0, 0, '2021-04-15 13:02:53.422252', '2021-04-15 13:02:53.422252', NULL),
	(10007229, 4, 'PW21A-JK100359NV-M', 0, 0, '2021-04-15 13:02:53.397387', '2021-04-15 13:02:53.397387', NULL),
	(10007230, 4, 'PW21A-JK100359NV-L', 0, 0, '2021-04-15 13:02:53.393816', '2021-04-15 13:02:53.393816', NULL),
	(10007231, 4, 'PW21A-JK100359NV-XL', 0, 0, '2021-04-15 13:02:53.387752', '2021-04-15 13:02:53.387752', NULL),
	(10007232, 4, 'PW21A-JK100359NV-XXL', 0, 0, '2021-04-15 13:02:53.398963', '2021-04-15 13:02:53.398963', NULL),
	(10007233, 4, 'PW21A-SH100360DM-XS', 0, 0, '2021-04-15 13:02:53.388363', '2021-04-15 13:02:53.388363', NULL),
	(10007234, 4, 'PW21A-SH100360DM-S', 0, 0, '2021-04-15 13:02:53.388836', '2021-04-15 13:02:53.388836', NULL),
	(10007235, 4, 'PW21A-SH100360DM-M', 0, 0, '2021-04-15 13:02:53.409582', '2021-04-15 13:02:53.409582', NULL),
	(10007236, 4, 'PW21A-SH100360DM-L', 0, 0, '2021-04-15 13:02:53.404446', '2021-04-15 13:02:53.404446', NULL),
	(10007237, 4, 'PW21A-SH100360DM-XL', 0, 0, '2021-04-15 13:02:53.429931', '2021-04-15 13:02:53.429931', NULL),
	(10007238, 4, 'PW21A-SH100360DM-XXL', 0, 0, '2021-04-15 13:02:53.405591', '2021-04-15 13:02:53.405591', NULL),
	(10007239, 4, 'PW21A-SH100361BL-XS', 0, 0, '2021-04-15 13:02:53.443614', '2021-04-15 13:02:53.443614', NULL),
	(10007240, 4, 'PW21A-SH100361BL-S', 0, 0, '2021-04-15 13:02:53.425481', '2021-04-15 13:02:53.425481', NULL),
	(10007241, 4, 'PW21A-SH100361BL-M', 0, 0, '2021-04-15 13:02:53.428458', '2021-04-15 13:02:53.428458', NULL),
	(10007242, 4, 'PW21A-SH100361BL-L', 0, 0, '2021-04-15 13:02:53.407448', '2021-04-15 13:02:53.407448', NULL),
	(10007243, 4, 'PW21A-SH100361BL-XL', 0, 0, '2021-04-15 13:02:53.409294', '2021-04-15 13:02:53.409294', NULL),
	(10007244, 4, 'PW21A-SH100361BL-XXL', 0, 0, '2021-04-15 13:02:53.408229', '2021-04-15 13:02:53.408229', NULL),
	(10007245, 4, 'PW21A-SH100362BL-XS', 0, 0, '2021-04-15 13:02:53.420405', '2021-04-15 13:02:53.420405', NULL),
	(10007246, 4, 'PW21A-SH100362BL-S', 0, 0, '2021-04-15 13:02:53.432721', '2021-04-15 13:02:53.432721', NULL),
	(10007247, 4, 'PW21A-SH100362BL-M', 0, 0, '2021-04-15 13:02:53.432357', '2021-04-15 13:02:53.432357', NULL),
	(10007248, 4, 'PW21A-SH100362BL-L', 0, 0, '2021-04-15 13:02:53.431307', '2021-04-15 13:02:53.431307', NULL),
	(10007249, 4, 'PW21A-SH100362BL-XL', 0, 0, '2021-04-15 13:02:53.433003', '2021-04-15 13:02:53.433003', NULL),
	(10007250, 4, 'PW21A-SH100362BL-XXL', 0, 0, '2021-04-15 13:02:53.412815', '2021-04-15 13:02:53.412815', NULL),
	(10007251, 4, 'PW21A-JK100363BL-XS', 0, 0, '2021-04-15 13:02:53.431627', '2021-04-15 13:02:53.431627', NULL),
	(10007252, 4, 'PW21A-JK100363BL-S', 0, 0, '2021-04-15 13:02:53.456460', '2021-04-15 13:02:53.456460', NULL),
	(10007253, 4, 'PW21A-JK100363BL-M', 0, 0, '2021-04-15 13:02:53.451271', '2021-04-15 13:02:53.451271', NULL),
	(10007254, 4, 'PW21A-JK100363BL-L', 0, 0, '2021-04-15 13:02:53.445641', '2021-04-15 13:02:53.445641', NULL),
	(10007255, 4, 'PW21A-JK100363BL-XL', 0, 0, '2021-04-15 13:02:53.455327', '2021-04-15 13:02:53.455327', NULL),
	(10007256, 4, 'PW21A-JK100363BL-XXL', 0, 0, '2021-04-15 13:02:53.456128', '2021-04-15 13:02:53.456128', NULL),
	(10007257, 4, 'PW21A-SH100364BL-XS', 0, 0, '2021-04-15 13:02:53.453447', '2021-04-15 13:02:53.453447', NULL),
	(10007258, 4, 'PW21A-SH100364BL-S', 0, 0, '2021-04-15 13:02:53.479851', '2021-04-15 13:02:53.479851', NULL),
	(10007259, 4, 'PW21A-SH100364BL-M', 0, 0, '2021-04-15 13:02:53.450144', '2021-04-15 13:02:53.450144', NULL),
	(10007260, 4, 'PW21A-SH100364BL-L', 0, 0, '2021-04-15 13:02:53.467645', '2021-04-15 13:02:53.467645', NULL),
	(10007261, 4, 'PW21A-SH100364BL-XL', 0, 0, '2021-04-15 13:02:53.456811', '2021-04-15 13:02:53.456811', NULL),
	(10007262, 4, 'PW21A-SH100364BL-XXL', 0, 0, '2021-04-15 13:02:53.507949', '2021-04-15 13:02:53.507949', NULL),
	(10007263, 4, 'PW21A-SW100365GY-XS', 0, 0, '2021-04-15 13:02:53.467049', '2021-04-15 13:02:53.467049', NULL),
	(10007264, 4, 'PW21A-SW100365GY-S', 0, 0, '2021-04-15 13:02:53.470902', '2021-04-15 13:02:53.470902', NULL),
	(10007265, 4, 'PW21A-SW100365GY-M', 0, 0, '2021-04-15 13:02:53.457515', '2021-04-15 13:02:53.457515', NULL),
	(10007266, 4, 'PW21A-SW100365GY-L', 0, 0, '2021-04-15 13:02:53.477862', '2021-04-15 13:02:53.477862', NULL),
	(10007267, 4, 'PW21A-SW100365GY-XL', 0, 0, '2021-04-15 13:02:53.493473', '2021-04-15 13:02:53.493473', NULL),
	(10007268, 4, 'PW21A-SW100365GY-XXL', 0, 0, '2021-04-15 13:02:53.474111', '2021-04-15 13:02:53.474111', NULL),
	(10007269, 4, 'PW21A-SW100366GY-XS', 0, 0, '2021-04-15 13:02:53.478321', '2021-04-15 13:02:53.478321', NULL),
	(10007270, 4, 'PW21A-SW100366GY-S', 0, 0, '2021-04-15 13:02:53.476990', '2021-04-15 13:02:53.476990', NULL),
	(10007271, 4, 'PW21A-SW100366GY-M', 0, 0, '2021-04-15 13:02:53.479556', '2021-04-15 13:02:53.479556', NULL),
	(10007272, 4, 'PW21A-SW100366GY-L', 0, 0, '2021-04-15 13:02:53.479249', '2021-04-15 13:02:53.479249', NULL),
	(10007273, 4, 'PW21A-SW100366GY-XL', 0, 0, '2021-04-15 13:02:53.500795', '2021-04-15 13:02:53.500795', NULL),
	(10007274, 4, 'PW21A-SW100366GY-XXL', 0, 0, '2021-04-15 13:02:53.527408', '2021-04-15 13:02:53.527408', NULL),
	(10007275, 4, 'PW21A-SW100367BL-XS', 0, 0, '2021-04-15 13:02:53.497093', '2021-04-15 13:02:53.497093', NULL),
	(10007276, 4, 'PW21A-SW100367BL-S', 0, 0, '2021-04-15 13:02:53.494675', '2021-04-15 13:02:53.494675', NULL),
	(10007277, 4, 'PW21A-SW100367BL-M', 0, 0, '2021-04-15 13:02:53.495547', '2021-04-15 13:02:53.495547', NULL),
	(10007278, 4, 'PW21A-SW100367BL-L', 0, 0, '2021-04-15 13:02:53.505186', '2021-04-15 13:02:53.505186', NULL),
	(10007279, 4, 'PW21A-SW100367BL-XL', 0, 0, '2021-04-15 13:02:53.503987', '2021-04-15 13:02:53.503987', NULL),
	(10007280, 4, 'PW21A-SW100367BL-XXL', 0, 0, '2021-04-15 13:02:53.508325', '2021-04-15 13:02:53.508325', NULL),
	(10007281, 4, 'PW21A-SW100368NV-XS', 0, 0, '2021-04-15 13:02:53.518366', '2021-04-15 13:02:53.518366', NULL),
	(10007282, 4, 'PW21A-SW100368NV-S', 0, 0, '2021-04-15 13:02:53.507454', '2021-04-15 13:02:53.507454', NULL),
	(10007283, 4, 'PW21A-SW100368NV-M', 0, 0, '2021-04-15 13:02:53.518791', '2021-04-15 13:02:53.518791', NULL),
	(10007284, 4, 'PW21A-SW100368NV-L', 0, 0, '2021-04-15 13:02:53.525054', '2021-04-15 13:02:53.525054', NULL),
	(10007285, 4, 'PW21A-SW100368NV-XL', 0, 0, '2021-04-15 13:02:53.517813', '2021-04-15 13:02:53.517813', NULL),
	(10007286, 4, 'PW21A-SW100368NV-XXL', 0, 0, '2021-04-15 13:02:53.549925', '2021-04-15 13:02:53.549925', NULL),
	(10007287, 4, 'PW21A-JK100369BL-XS', 0, 0, '2021-04-15 13:02:53.545673', '2021-04-15 13:02:53.545673', NULL),
	(10007288, 4, 'PW21A-JK100369BL-S', 0, 0, '2021-04-15 13:02:53.520060', '2021-04-15 13:02:53.520060', NULL),
	(10007289, 4, 'PW21A-JK100369BL-M', 0, 0, '2021-04-15 13:02:53.528673', '2021-04-15 13:02:53.528673', NULL),
	(10007290, 4, 'PW21A-JK100369BL-L', 0, 0, '2021-04-15 13:02:53.530790', '2021-04-15 13:02:53.530790', NULL),
	(10007291, 4, 'PW21A-JK100369BL-XL', 0, 0, '2021-04-15 13:02:53.539694', '2021-04-15 13:02:53.539694', NULL),
	(10007292, 4, 'PW21A-JK100369BL-XXL', 0, 0, '2021-04-15 13:02:53.571057', '2021-04-15 13:02:53.571057', NULL),
	(10007293, 4, 'PW21A-SH100370NV-XS', 0, 0, '2021-04-15 13:02:53.551124', '2021-04-15 13:02:53.551124', NULL),
	(10007294, 4, 'PW21A-SH100370NV-S', 0, 0, '2021-04-15 13:02:53.529828', '2021-04-15 13:02:53.529828', NULL),
	(10007295, 4, 'PW21A-SH100370NV-M', 0, 0, '2021-04-15 13:02:53.529245', '2021-04-15 13:02:53.529245', NULL),
	(10007296, 4, 'PW21A-SH100370NV-L', 0, 0, '2021-04-15 13:02:53.541721', '2021-04-15 13:02:53.541721', NULL),
	(10007297, 4, 'PW21A-SH100370NV-XL', 0, 0, '2021-04-15 13:02:53.605514', '2021-04-15 13:02:53.605514', NULL),
	(10007298, 4, 'PW21A-SH100370NV-XXL', 0, 0, '2021-04-15 13:02:53.538606', '2021-04-15 13:02:53.538606', NULL),
	(10007299, 4, 'PW21A-SH100371BL-XS', 0, 0, '2021-04-15 13:02:53.550778', '2021-04-15 13:02:53.550778', NULL),
	(10007300, 4, 'PW21A-SH100371BL-S', 0, 0, '2021-04-15 13:02:53.548410', '2021-04-15 13:02:53.548410', NULL),
	(10007301, 4, 'PW21A-SH100371BL-M', 0, 0, '2021-04-15 13:02:53.540609', '2021-04-15 13:02:53.540609', NULL),
	(10007302, 4, 'PW21A-SH100371BL-L', 0, 0, '2021-04-15 13:02:53.594084', '2021-04-15 13:02:53.594084', NULL),
	(10007303, 4, 'PW21A-SH100371BL-XL', 0, 0, '2021-04-15 13:02:53.612360', '2021-04-15 13:02:53.612360', NULL),
	(10007304, 4, 'PW21A-SH100371BL-XXL', 0, 0, '2021-04-15 13:02:53.573567', '2021-04-15 13:02:53.573567', NULL),
	(10007305, 4, 'PW21A-SH100372DK-XS', 0, 0, '2021-04-15 13:02:53.553112', '2021-04-15 13:02:53.553112', NULL),
	(10007306, 4, 'PW21A-SH100372DK-S', 0, 0, '2021-04-15 13:02:53.570190', '2021-04-15 13:02:53.570190', NULL),
	(10007307, 4, 'PW21A-SH100372DK-M', 0, 0, '2021-04-15 13:02:53.572466', '2021-04-15 13:02:53.572466', NULL),
	(10007308, 4, 'PW21A-SH100372DK-L', 0, 0, '2021-04-15 13:02:53.592066', '2021-04-15 13:02:53.592066', NULL),
	(10007309, 4, 'PW21A-SH100372DK-XL', 0, 0, '2021-04-15 13:02:53.584450', '2021-04-15 13:02:53.584450', NULL),
	(10007310, 4, 'PW21A-SH100372DK-XXL', 0, 0, '2021-04-15 13:02:53.601191', '2021-04-15 13:02:53.601191', NULL),
	(10007311, 4, 'PW21A-SH100373GY-XS', 0, 0, '2021-04-15 13:02:53.586202', '2021-04-15 13:02:53.586202', NULL),
	(10007312, 4, 'PW21A-SH100373GY-S', 0, 0, '2021-04-15 13:02:53.597157', '2021-04-15 13:02:53.597157', NULL),
	(10007313, 4, 'PW21A-SH100373GY-M', 0, 0, '2021-04-15 13:02:53.593518', '2021-04-15 13:02:53.593518', NULL),
	(10007314, 4, 'PW21A-SH100373GY-L', 0, 0, '2021-04-15 13:02:53.624724', '2021-04-15 13:02:53.624724', NULL),
	(10007315, 4, 'PW21A-SH100373GY-XL', 0, 0, '2021-04-15 13:02:53.621685', '2021-04-15 13:02:53.621685', NULL),
	(10007316, 4, 'PW21A-SH100373GY-XXL', 0, 0, '2021-04-15 13:02:53.625751', '2021-04-15 13:02:53.625751', NULL),
	(10007317, 4, 'PW21A-SH100374GY-XS', 0, 0, '2021-04-15 13:02:53.622713', '2021-04-15 13:02:53.622713', NULL),
	(10007318, 4, 'PW21A-SH100374GY-S', 0, 0, '2021-04-15 13:02:53.605929', '2021-04-15 13:02:53.605929', NULL),
	(10007319, 4, 'PW21A-SH100374GY-M', 0, 0, '2021-04-15 13:02:53.660790', '2021-04-15 13:02:53.660790', NULL),
	(10007320, 4, 'PW21A-SH100374GY-L', 0, 0, '2021-04-15 13:02:53.606812', '2021-04-15 13:02:53.606812', NULL),
	(10007321, 4, 'PW21A-SH100374GY-XL', 0, 0, '2021-04-15 13:02:53.613697', '2021-04-15 13:02:53.613697', NULL),
	(10007322, 4, 'PW21A-SH100374GY-XXL', 0, 0, '2021-04-15 13:02:53.654580', '2021-04-15 13:02:53.654580', NULL),
	(10007323, 4, 'PW21A-SH100375BL-XS', 0, 0, '2021-04-15 13:02:53.650714', '2021-04-15 13:02:53.650714', NULL),
	(10007324, 4, 'PW21A-SH100375BL-S', 0, 0, '2021-04-15 13:02:53.634786', '2021-04-15 13:02:53.634786', NULL),
	(10007325, 4, 'PW21A-SH100375BL-M', 0, 0, '2021-04-15 13:02:53.635381', '2021-04-15 13:02:53.635381', NULL),
	(10007326, 4, 'PW21A-SH100375BL-L', 0, 0, '2021-04-15 13:02:53.630391', '2021-04-15 13:02:53.630391', NULL),
	(10007327, 4, 'PW21A-SH100375BL-XL', 0, 0, '2021-04-15 13:02:53.711512', '2021-04-15 13:02:53.711512', NULL),
	(10007328, 4, 'PW21A-SH100375BL-XXL', 0, 0, '2021-04-15 13:02:53.643597', '2021-04-15 13:02:53.643597', NULL),
	(10007329, 4, 'PW21A-SH100376CM-XS', 0, 0, '2021-04-15 13:02:53.666530', '2021-04-15 13:02:53.666530', NULL),
	(10007330, 4, 'PW21A-SH100376CM-S', 0, 0, '2021-04-15 13:02:53.639659', '2021-04-15 13:02:53.639659', NULL),
	(10007331, 4, 'PW21A-SH100376CM-M', 0, 0, '2021-04-15 13:02:53.655259', '2021-04-15 13:02:53.655259', NULL),
	(10007332, 4, 'PW21A-SH100376CM-L', 0, 0, '2021-04-15 13:02:53.669209', '2021-04-15 13:02:53.669209', NULL),
	(10007333, 4, 'PW21A-SH100376CM-XL', 0, 0, '2021-04-15 13:02:53.733382', '2021-04-15 13:02:53.733382', NULL),
	(10007334, 4, 'PW21A-SH100376CM-XXL', 0, 0, '2021-04-15 13:02:53.659870', '2021-04-15 13:02:53.659870', NULL),
	(10007335, 4, 'PW21A-SW100377BL-XS', 0, 0, '2021-04-15 13:02:53.675271', '2021-04-15 13:02:53.675271', NULL),
	(10007336, 4, 'PW21A-SW100377BL-S', 0, 0, '2021-04-15 13:02:53.681878', '2021-04-15 13:02:53.681878', NULL),
	(10007337, 4, 'PW21A-SW100377BL-M', 0, 0, '2021-04-15 13:02:53.668242', '2021-04-15 13:02:53.668242', NULL),
	(10007338, 4, 'PW21A-SW100377BL-L', 0, 0, '2021-04-15 13:02:53.676973', '2021-04-15 13:02:53.676973', NULL),
	(10007339, 4, 'PW21A-SW100377BL-XL', 0, 0, '2021-04-15 13:02:53.692904', '2021-04-15 13:02:53.692904', NULL),
	(10007340, 4, 'PW21A-SW100377BL-XXL', 0, 0, '2021-04-15 13:02:53.684849', '2021-04-15 13:02:53.684849', NULL),
	(10007341, 4, 'PW21A-SW100314DK-XS', 0, 0, '2021-04-15 13:02:53.682344', '2021-04-15 13:02:53.682344', NULL),
	(10007342, 4, 'PW21A-SW100314DK-S', 0, 0, '2021-04-15 13:02:53.713566', '2021-04-15 13:02:53.713566', NULL),
	(10007343, 4, 'PW21A-SW100314DK-M', 0, 0, '2021-04-15 13:02:53.692414', '2021-04-15 13:02:53.692414', NULL),
	(10007344, 4, 'PW21A-SW100314DK-L', 0, 0, '2021-04-15 13:02:53.701668', '2021-04-15 13:02:53.701668', NULL),
	(10007345, 4, 'PW21A-SW100314DK-XL', 0, 0, '2021-04-15 13:02:53.720083', '2021-04-15 13:02:53.720083', NULL),
	(10007346, 4, 'PW21A-SW100314DK-XXL', 0, 0, '2021-04-15 13:02:53.700182', '2021-04-15 13:02:53.700182', NULL),
	(10007347, 4, 'PW21A-SW100379GY-XS', 0, 0, '2021-04-15 13:02:53.706718', '2021-04-15 13:02:53.706718', NULL),
	(10007348, 4, 'PW21A-SW100379GY-S', 0, 0, '2021-04-15 13:02:53.698312', '2021-04-15 13:02:53.698312', NULL),
	(10007349, 4, 'PW21A-SW100379GY-M', 0, 0, '2021-04-15 13:02:53.727019', '2021-04-15 13:02:53.727019', NULL),
	(10007350, 4, 'PW21A-SW100379GY-L', 0, 0, '2021-04-15 13:02:53.751489', '2021-04-15 13:02:53.751489', NULL),
	(10007351, 4, 'PW21A-SW100379GY-XL', 0, 0, '2021-04-15 13:02:53.714756', '2021-04-15 13:02:53.714756', NULL),
	(10007352, 4, 'PW21A-SW100379GY-XXL', 0, 0, '2021-04-15 13:02:53.720517', '2021-04-15 13:02:53.720517', NULL),
	(10007353, 4, 'PW21A-SW100380NV-XS', 0, 0, '2021-04-15 13:02:53.747889', '2021-04-15 13:02:53.747889', NULL),
	(10007354, 4, 'PW21A-SW100380NV-S', 0, 0, '2021-04-15 13:02:53.715692', '2021-04-15 13:02:53.715692', NULL),
	(10007355, 4, 'PW21A-SW100380NV-M', 0, 0, '2021-04-15 13:02:53.737709', '2021-04-15 13:02:53.737709', NULL),
	(10007356, 4, 'PW21A-SW100380NV-L', 0, 0, '2021-04-15 13:02:53.737386', '2021-04-15 13:02:53.737386', NULL),
	(10007357, 4, 'PW21A-SW100380NV-XL', 0, 0, '2021-04-15 13:02:53.727509', '2021-04-15 13:02:53.727509', NULL),
	(10007358, 4, 'PW21A-SW100380NV-XXL', 0, 0, '2021-04-15 13:02:53.730922', '2021-04-15 13:02:53.730922', NULL),
	(10007359, 4, 'PW21A-SW100381BL-XS', 0, 0, '2021-04-15 13:02:53.749995', '2021-04-15 13:02:53.749995', NULL),
	(10007360, 4, 'PW21A-SW100381BL-S', 0, 0, '2021-04-15 13:02:53.738772', '2021-04-15 13:02:53.738772', NULL),
	(10007361, 4, 'PW21A-SW100381BL-M', 0, 0, '2021-04-15 13:02:53.741588', '2021-04-15 13:02:53.741588', NULL),
	(10007362, 4, 'PW21A-SW100381BL-L', 0, 0, '2021-04-15 13:02:53.739888', '2021-04-15 13:02:53.739888', NULL),
	(10007363, 4, 'PW21A-SW100381BL-XL', 0, 0, '2021-04-15 13:02:53.743027', '2021-04-15 13:02:53.743027', NULL),
	(10007364, 4, 'PW21A-SW100381BL-XXL', 0, 0, '2021-04-15 13:02:53.752959', '2021-04-15 13:02:53.752959', NULL),
	(10007365, 5, 'PW21A-AC100001BL-All', 3, 0, '2021-04-15 13:06:01.964529', '2021-04-15 13:06:01.964529', NULL),
	(10007366, 5, 'PW21A-AC100002YW -All', 4, 0, '2021-04-15 13:06:01.962048', '2021-04-15 13:06:01.962048', NULL),
	(10007367, 5, 'PW21A-AC100003BL-All', 2, 0, '2021-04-15 13:06:01.975723', '2021-04-15 13:06:01.975723', NULL),
	(10007368, 5, 'PW21A-AC100004BL-All', 2, 0, '2021-04-15 13:06:02.052178', '2021-04-15 13:06:02.052178', NULL),
	(10007369, 5, 'PW21A-AC100005BL-All', 10, 0, '2021-04-15 13:06:01.962878', '2021-04-15 13:06:01.962878', NULL),
	(10007370, 5, 'PW21A-AC100006BL-All', 10, 0, '2021-04-15 13:06:01.961170', '2021-04-15 13:06:01.961170', NULL),
	(10007371, 5, 'PW21A-AC100007BL-All', 0, 0, '2021-04-15 13:06:01.963720', '2021-04-15 13:06:01.963720', NULL),
	(10007372, 5, 'PW21A-AC100008BL-All', 2, 0, '2021-04-15 13:06:01.959152', '2021-04-15 13:06:01.959152', NULL),
	(10007373, 5, 'PW21A-AC100009BW-All', 3, 0, '2021-04-15 13:06:01.973784', '2021-04-15 13:06:01.973784', NULL),
	(10007374, 5, 'PW21A-AC100010MC-All', 3, 0, '2021-04-15 13:06:02.028377', '2021-04-15 13:06:02.028377', NULL),
	(10007375, 5, 'PW21A-AC100011OG-All', 4, 0, '2021-04-15 13:06:02.050585', '2021-04-15 13:06:02.050585', NULL),
	(10007376, 5, 'PW21A-AC100012BL-All', 1, 0, '2021-04-15 13:06:02.067421', '2021-04-15 13:06:02.067421', NULL),
	(10007377, 5, 'PW21A-AC100013OG-All', 0, 0, '2021-04-15 13:06:02.043328', '2021-04-15 13:06:02.043328', NULL),
	(10007378, 5, 'PW21A-AC100014OL-All', 2, 0, '2021-04-15 13:06:02.147341', '2021-04-15 13:06:02.147341', NULL),
	(10007379, 5, 'PW21A-AC100015MR-All', 3, 0, '2021-04-15 13:06:02.103037', '2021-04-15 13:06:02.103037', NULL),
	(10007380, 5, 'PW21A-AC100016BL-All', 2, 0, '2021-04-15 13:06:02.087538', '2021-04-15 13:06:02.087538', NULL),
	(10007381, 5, 'PW21A-AC100017BL-All', 2, 0, '2021-04-15 13:06:01.976608', '2021-04-15 13:06:01.976608', NULL),
	(10007382, 5, 'PW21A-BG100018WT-All', 2, 0, '2021-04-15 13:06:02.039031', '2021-04-15 13:06:02.039031', NULL),
	(10007383, 5, 'PW21A-BG100019BL-All', 4, 0, '2021-04-15 13:06:01.982256', '2021-04-15 13:06:01.982256', NULL),
	(10007384, 5, 'PW21A-BG100020BL-All', 2, 0, '2021-04-15 13:06:02.041915', '2021-04-15 13:06:02.041915', NULL),
	(10007385, 5, 'PW21A-BG100021BL-All', 3, 0, '2021-04-15 13:06:02.223920', '2021-04-15 13:06:02.223920', NULL),
	(10007386, 5, 'PW21A-BG100022BL-All', 2, 0, '2021-04-15 13:06:02.202483', '2021-04-15 13:06:02.202483', NULL),
	(10007387, 5, 'PW21A-BG100023BL-All', 2, 0, '2021-04-15 13:06:02.123736', '2021-04-15 13:06:02.123736', NULL),
	(10007388, 5, 'PW21A-BG100024BL-All', 0, 0, '2021-04-15 13:06:02.187225', '2021-04-15 13:06:02.187225', NULL),
	(10007389, 5, 'PW21A-BG100025BL-All', 0, 0, '2021-04-15 13:06:02.152725', '2021-04-15 13:06:02.152725', NULL),
	(10007390, 5, 'PW21A-BG100026CM-All', 0, 0, '2021-04-15 13:06:02.142919', '2021-04-15 13:06:02.142919', NULL),
	(10007391, 5, 'PW21A-BG100027CM-All', 0, 0, '2021-04-15 13:06:02.103886', '2021-04-15 13:06:02.103886', NULL),
	(10007392, 5, 'PW21A-BG100028CM-All', 0, 0, '2021-04-15 13:06:02.143715', '2021-04-15 13:06:02.143715', NULL),
	(10007393, 5, 'PW21A-BG100029CM-All', 0, 0, '2021-04-15 13:06:02.191789', '2021-04-15 13:06:02.191789', NULL),
	(10007394, 5, 'PW21A-BG100030BL-All', 2, 0, '2021-04-15 13:06:02.188487', '2021-04-15 13:06:02.188487', NULL),
	(10007395, 5, 'PW21A-BG100031BL-All', 3, 0, '2021-04-15 13:06:02.149048', '2021-04-15 13:06:02.149048', NULL),
	(10007396, 5, 'PW21A-BG100032BL-All', 0, 0, '2021-04-15 13:06:02.202976', '2021-04-15 13:06:02.202976', NULL),
	(10007397, 5, 'PW21A-BG100033BL-All', 0, 0, '2021-04-15 13:06:02.155476', '2021-04-15 13:06:02.155476', NULL),
	(10007398, 5, 'PW21A-BG100034BL-All', 0, 0, '2021-04-15 13:06:02.182770', '2021-04-15 13:06:02.182770', NULL),
	(10007399, 5, 'PW21A-BG100035BL-All', 3, 0, '2021-04-15 13:06:02.186595', '2021-04-15 13:06:02.186595', NULL),
	(10007400, 5, 'PW21A-BG100036BL-All', 0, 0, '2021-04-15 13:06:02.198745', '2021-04-15 13:06:02.198745', NULL),
	(10007401, 5, 'PW21A-BG100037OG-All', 3, 0, '2021-04-15 13:06:02.165848', '2021-04-15 13:06:02.165848', NULL),
	(10007402, 5, 'PW21A-BG100038BL-All', 4, 0, '2021-04-15 13:06:02.215436', '2021-04-15 13:06:02.215436', NULL),
	(10007403, 5, 'PW21A-BG100039GN-All', 3, 0, '2021-04-15 13:06:02.162616', '2021-04-15 13:06:02.162616', NULL),
	(10007404, 5, 'PW21A-BG100040WT-All', 3, 0, '2021-04-15 13:06:02.167356', '2021-04-15 13:06:02.167356', NULL),
	(10007405, 5, 'PW21A-BG100041BL-All', 2, 0, '2021-04-15 13:06:02.218819', '2021-04-15 13:06:02.218819', NULL),
	(10007406, 5, 'PW21A-BG100042BL-All', 2, 0, '2021-04-15 13:06:02.207030', '2021-04-15 13:06:02.207030', NULL),
	(10007407, 5, 'PW21A-BG100043BL-All', 2, 0, '2021-04-15 13:06:02.223290', '2021-04-15 13:06:02.223290', NULL),
	(10007408, 5, 'PW21A-BG100044BL-All', 15, 0, '2021-04-15 13:06:02.194289', '2021-04-15 13:06:02.194289', NULL),
	(10007409, 5, 'PW21A-BG100045BL-All', 2, 0, '2021-04-15 13:06:02.219947', '2021-04-15 13:06:02.219947', NULL),
	(10007410, 5, 'PW21A-BG100046BL-All', 2, 0, '2021-04-15 13:06:02.246805', '2021-04-15 13:06:02.246805', NULL),
	(10007411, 5, 'PW21A-BG100047BL-All', 2, 0, '2021-04-15 13:06:02.215906', '2021-04-15 13:06:02.215906', NULL),
	(10007412, 5, 'PW21A-BG100048BL-All', 2, 0, '2021-04-15 13:06:02.244736', '2021-04-15 13:06:02.244736', NULL),
	(10007413, 5, 'PW21A-BG100049BL-All', 2, 0, '2021-04-15 13:06:02.249359', '2021-04-15 13:06:02.249359', NULL),
	(10007414, 5, 'PW21A-BG100050BL-All', 2, 0, '2021-04-15 13:06:02.230606', '2021-04-15 13:06:02.230606', NULL),
	(10007415, 5, 'PW21A-BG100051BL-All', 2, 0, '2021-04-15 13:06:02.227248', '2021-04-15 13:06:02.227248', NULL),
	(10007416, 5, 'PW21A-BG100052BL-All', 2, 0, '2021-04-15 13:06:02.230187', '2021-04-15 13:06:02.230187', NULL),
	(10007417, 5, 'PW21A-BG100053BL-All', 2, 0, '2021-04-15 13:06:02.249917', '2021-04-15 13:06:02.249917', NULL),
	(10007418, 5, 'PW21A-BG100054BL-All', 2, 0, '2021-04-15 13:06:02.283814', '2021-04-15 13:06:02.283814', NULL),
	(10007419, 5, 'PW21A-GL100055YW -S', 1, 0, '2021-04-15 13:06:02.289501', '2021-04-15 13:06:02.289501', NULL),
	(10007420, 5, 'PW21A-GL100055YW -M', 1, 0, '2021-04-15 13:06:02.254481', '2021-04-15 13:06:02.254481', NULL),
	(10007421, 5, 'PW21A-GL100055YW -L', 1, 0, '2021-04-15 13:06:02.266173', '2021-04-15 13:06:02.266173', NULL),
	(10007422, 5, 'PW21A-GL100055YW -XL', 1, 0, '2021-04-15 13:06:02.288477', '2021-04-15 13:06:02.288477', NULL),
	(10007423, 5, 'PW21A-GL100056BW-S', 1, 0, '2021-04-15 13:06:02.261031', '2021-04-15 13:06:02.261031', NULL),
	(10007424, 5, 'PW21A-GL100056BW-M', 1, 0, '2021-04-15 13:06:02.231620', '2021-04-15 13:06:02.231620', NULL),
	(10007425, 5, 'PW21A-GL100056BW-L', 1, 0, '2021-04-15 13:06:02.255404', '2021-04-15 13:06:02.255404', NULL),
	(10007426, 5, 'PW21A-GL100056BW-XL', 1, 0, '2021-04-15 13:06:02.265405', '2021-04-15 13:06:02.265405', NULL),
	(10007427, 5, 'PW21A-GL100057CM-S', 2, 0, '2021-04-15 13:06:02.271656', '2021-04-15 13:06:02.271656', NULL),
	(10007428, 5, 'PW21A-GL100057CM-M', 2, 0, '2021-04-15 13:06:02.289017', '2021-04-15 13:06:02.289017', NULL),
	(10007429, 5, 'PW21A-GL100057CM-L', 2, 0, '2021-04-15 13:06:02.283346', '2021-04-15 13:06:02.283346', NULL),
	(10007430, 5, 'PW21A-GL100057CM-XL', 2, 0, '2021-04-15 13:06:02.304700', '2021-04-15 13:06:02.304700', NULL),
	(10007431, 5, 'PW21A-GL100058BW-S', 1, 0, '2021-04-15 13:06:02.293211', '2021-04-15 13:06:02.293211', NULL),
	(10007432, 5, 'PW21A-GL100058BW-M', 1, 0, '2021-04-15 13:06:02.344666', '2021-04-15 13:06:02.344666', NULL),
	(10007433, 5, 'PW21A-GL100058BW-L', 1, 0, '2021-04-15 13:06:02.305096', '2021-04-15 13:06:02.305096', NULL),
	(10007434, 5, 'PW21A-GL100058BW-XL', 1, 0, '2021-04-15 13:06:02.302211', '2021-04-15 13:06:02.302211', NULL),
	(10007435, 5, 'PW21A-GL100059BL-S', 1, 0, '2021-04-15 13:06:02.314088', '2021-04-15 13:06:02.314088', NULL),
	(10007436, 5, 'PW21A-GL100059BL-M', 2, 0, '2021-04-15 13:06:02.321807', '2021-04-15 13:06:02.321807', NULL),
	(10007437, 5, 'PW21A-GL100059BL-L', 1, 0, '2021-04-15 13:06:02.373052', '2021-04-15 13:06:02.373052', NULL),
	(10007438, 5, 'PW21A-GL100059BL-XL', 0, 0, '2021-04-15 13:06:02.306298', '2021-04-15 13:06:02.306298', NULL),
	(10007439, 5, 'PW21A-GL100060BL-S', 2, 0, '2021-04-15 13:06:02.315539', '2021-04-15 13:06:02.315539', NULL),
	(10007440, 5, 'PW21A-GL100060BL-M', 1, 0, '2021-04-15 13:06:02.318748', '2021-04-15 13:06:02.318748', NULL),
	(10007441, 5, 'PW21A-GL100060BL-L', 0, 0, '2021-04-15 13:06:02.346651', '2021-04-15 13:06:02.346651', NULL),
	(10007442, 5, 'PW21A-GL100060BL-XL', 1, 0, '2021-04-15 13:06:02.317257', '2021-04-15 13:06:02.317257', NULL),
	(10007443, 5, 'PW21A-GL100061RD-S', 1, 0, '2021-04-15 13:06:02.331427', '2021-04-15 13:06:02.331427', NULL),
	(10007444, 5, 'PW21A-GL100061RD-M', 1, 0, '2021-04-15 13:06:02.316594', '2021-04-15 13:06:02.316594', NULL),
	(10007445, 5, 'PW21A-GL100061RD-L', 1, 0, '2021-04-15 13:06:02.347790', '2021-04-15 13:06:02.347790', NULL),
	(10007446, 5, 'PW21A-GL100061RD-XL', 1, 0, '2021-04-15 13:06:02.329897', '2021-04-15 13:06:02.329897', NULL),
	(10007447, 5, 'PW21A-GL100062WT-S', 0, 0, '2021-04-15 13:06:02.331943', '2021-04-15 13:06:02.331943', NULL),
	(10007448, 5, 'PW21A-GL100062WT-M', 1, 0, '2021-04-15 13:06:02.359541', '2021-04-15 13:06:02.359541', NULL),
	(10007449, 5, 'PW21A-GL100062WT-L', 1, 0, '2021-04-15 13:06:02.333696', '2021-04-15 13:06:02.333696', NULL),
	(10007450, 5, 'PW21A-GL100062WT-XL', 1, 0, '2021-04-15 13:06:02.473878', '2021-04-15 13:06:02.473878', NULL),
	(10007451, 5, 'PW21A-GL100063BW-S', 1, 0, '2021-04-15 13:06:02.357538', '2021-04-15 13:06:02.357538', NULL),
	(10007452, 5, 'PW21A-GL100063BW-M', 1, 0, '2021-04-15 13:06:02.347242', '2021-04-15 13:06:02.347242', NULL),
	(10007453, 5, 'PW21A-GL100063BW-L', 1, 0, '2021-04-15 13:06:02.371228', '2021-04-15 13:06:02.371228', NULL),
	(10007454, 5, 'PW21A-GL100063BW-XL', 1, 0, '2021-04-15 13:06:02.370093', '2021-04-15 13:06:02.370093', NULL),
	(10007455, 5, 'PW21A-GL100064WT-S', 1, 0, '2021-04-15 13:06:02.373761', '2021-04-15 13:06:02.373761', NULL),
	(10007456, 5, 'PW21A-GL100064WT-M', 1, 0, '2021-04-15 13:06:02.382842', '2021-04-15 13:06:02.382842', NULL),
	(10007457, 5, 'PW21A-GL100064WT-L', 1, 0, '2021-04-15 13:06:02.404376', '2021-04-15 13:06:02.404376', NULL),
	(10007458, 5, 'PW21A-GL100064WT-XL', 1, 0, '2021-04-15 13:06:02.387393', '2021-04-15 13:06:02.387393', NULL),
	(10007459, 5, 'PW21A-GL100065BL-S', 2, 0, '2021-04-15 13:06:02.388091', '2021-04-15 13:06:02.388091', NULL),
	(10007460, 5, 'PW21A-GL100065BL-M', 1, 0, '2021-04-15 13:06:02.388759', '2021-04-15 13:06:02.388759', NULL),
	(10007461, 5, 'PW21A-GL100065BL-L', 1, 0, '2021-04-15 13:06:02.389590', '2021-04-15 13:06:02.389590', NULL),
	(10007462, 5, 'PW21A-GL100065BL-XL', 1, 0, '2021-04-15 13:06:02.415997', '2021-04-15 13:06:02.415997', NULL),
	(10007463, 5, 'PW21A-GL100066YW -S', 1, 0, '2021-04-15 13:06:02.405039', '2021-04-15 13:06:02.405039', NULL),
	(10007464, 5, 'PW21A-GL100066YW -M', 1, 0, '2021-04-15 13:06:02.402269', '2021-04-15 13:06:02.402269', NULL),
	(10007465, 5, 'PW21A-GL100066YW -L', 1, 0, '2021-04-15 13:06:02.390347', '2021-04-15 13:06:02.390347', NULL),
	(10007466, 5, 'PW21A-GL100066YW -XL', 1, 0, '2021-04-15 13:06:02.416488', '2021-04-15 13:06:02.416488', NULL),
	(10007467, 5, 'PW21A-GL100067BW-S', 1, 0, '2021-04-15 13:06:02.403676', '2021-04-15 13:06:02.403676', NULL),
	(10007468, 5, 'PW21A-GL100067BW-M', 1, 0, '2021-04-15 13:06:02.416893', '2021-04-15 13:06:02.416893', NULL),
	(10007469, 5, 'PW21A-GL100067BW-L', 0, 0, '2021-04-15 13:06:02.439457', '2021-04-15 13:06:02.439457', NULL),
	(10007470, 5, 'PW21A-GL100067BW-XL', 1, 0, '2021-04-15 13:06:02.417866', '2021-04-15 13:06:02.417866', NULL),
	(10007471, 5, 'PW21A-HT100068BL-All', 2, 0, '2021-04-15 13:06:02.419408', '2021-04-15 13:06:02.419408', NULL),
	(10007472, 5, 'PW21A-HT100069BL-All', 0, 0, '2021-04-15 13:06:02.454924', '2021-04-15 13:06:02.454924', NULL),
	(10007473, 5, 'PW21A-HT100070BL-All', 0, 0, '2021-04-15 13:06:02.420266', '2021-04-15 13:06:02.420266', NULL),
	(10007474, 5, 'PW21A-HT100071BL-All', 0, 0, '2021-04-15 13:06:02.455293', '2021-04-15 13:06:02.455293', NULL),
	(10007475, 5, 'PW21A-HT100072BL-All', 2, 0, '2021-04-15 13:06:02.438122', '2021-04-15 13:06:02.438122', NULL),
	(10007476, 5, 'PW21A-HT100073BL-All', 0, 0, '2021-04-15 13:06:02.453600', '2021-04-15 13:06:02.453600', NULL),
	(10007477, 5, 'PW21A-HT100074BL-All', 1, 0, '2021-04-15 13:06:02.437378', '2021-04-15 13:06:02.437378', NULL),
	(10007478, 5, 'PW21A-HT100075BL-All', 0, 0, '2021-04-15 13:06:02.438847', '2021-04-15 13:06:02.438847', NULL),
	(10007479, 5, 'PW21A-HT100076BL-All', 1, 0, '2021-04-15 13:06:02.496865', '2021-04-15 13:06:02.496865', NULL),
	(10007480, 5, 'PW21A-HT100077BL-All', 2, 0, '2021-04-15 13:06:02.453256', '2021-04-15 13:06:02.453256', NULL),
	(10007481, 5, 'PW21A-HT100078BL-All', 4, 0, '2021-04-15 13:06:02.454598', '2021-04-15 13:06:02.454598', NULL),
	(10007482, 5, 'PW21A-HT100079AR-All', 2, 0, '2021-04-15 13:06:02.454093', '2021-04-15 13:06:02.454093', NULL),
	(10007483, 5, 'PW21A-HT100080BL-All', 2, 0, '2021-04-15 13:06:02.464386', '2021-04-15 13:06:02.464386', NULL),
	(10007484, 5, 'PW21A-HT100081CM-All', 2, 0, '2021-04-15 13:06:02.464771', '2021-04-15 13:06:02.464771', NULL),
	(10007485, 5, 'PW21A-HT100082DS-All', 2, 0, '2021-04-15 13:06:02.487515', '2021-04-15 13:06:02.487515', NULL),
	(10007486, 5, 'PW21A-HT100083CM-All', 2, 0, '2021-04-15 13:06:02.476413', '2021-04-15 13:06:02.476413', NULL),
	(10007487, 5, 'PW21A-HT100084DS-All', 2, 0, '2021-04-15 13:06:02.463977', '2021-04-15 13:06:02.463977', NULL),
	(10007488, 5, 'PW21A-HT100085MR-All', 2, 0, '2021-04-15 13:06:02.465230', '2021-04-15 13:06:02.465230', NULL),
	(10007489, 5, 'PW21A-HT100086NV-All', 0, 0, '2021-04-15 13:06:02.477238', '2021-04-15 13:06:02.477238', NULL),
	(10007490, 5, 'PW21A-HT100087BL-All', 4, 0, '2021-04-15 13:06:02.474621', '2021-04-15 13:06:02.474621', NULL),
	(10007491, 5, 'PW21A-HT100088NV-All', 0, 0, '2021-04-15 13:06:02.475044', '2021-04-15 13:06:02.475044', NULL),
	(10007492, 5, 'PW21A-HT100089RD-All', 0, 0, '2021-04-15 13:06:02.476028', '2021-04-15 13:06:02.476028', NULL),
	(10007493, 5, 'PW21A-HT100090BL-All', 0, 0, '2021-04-15 13:06:02.484209', '2021-04-15 13:06:02.484209', NULL),
	(10007494, 5, 'PW21A-HT100091RD-All', 0, 0, '2021-04-15 13:06:02.520579', '2021-04-15 13:06:02.520579', NULL),
	(10007495, 5, 'PW21A-JK100092BL-XS', 0, 0, '2021-04-15 13:06:02.486031', '2021-04-15 13:06:02.486031', NULL),
	(10007496, 5, 'PW21A-JK100092BL-S', 3, 0, '2021-04-15 13:06:02.486462', '2021-04-15 13:06:02.486462', NULL),
	(10007497, 5, 'PW21A-JK100092BL-M', 2, 0, '2021-04-15 13:06:02.508540', '2021-04-15 13:06:02.508540', NULL),
	(10007498, 5, 'PW21A-JK100092BL-L', 3, 0, '2021-04-15 13:06:02.495473', '2021-04-15 13:06:02.495473', NULL),
	(10007499, 5, 'PW21A-JK100092BL-XL', 2, 0, '2021-04-15 13:06:02.507747', '2021-04-15 13:06:02.507747', NULL),
	(10007500, 5, 'PW21A-JK100092BL-XXL', 1, 0, '2021-04-15 13:06:02.498566', '2021-04-15 13:06:02.498566', NULL),
	(10007501, 5, 'PW21A-JK100093BL-XS', 0, 0, '2021-04-15 13:06:02.497219', '2021-04-15 13:06:02.497219', NULL),
	(10007502, 5, 'PW21A-JK100093BL-S', 0, 0, '2021-04-15 13:06:02.496486', '2021-04-15 13:06:02.496486', NULL),
	(10007503, 5, 'PW21A-JK100093BL-M', 0, 0, '2021-04-15 13:06:02.509654', '2021-04-15 13:06:02.509654', NULL),
	(10007504, 5, 'PW21A-JK100093BL-L', 0, 0, '2021-04-15 13:06:02.508117', '2021-04-15 13:06:02.508117', NULL),
	(10007505, 5, 'PW21A-JK100093BL-XL', 0, 0, '2021-04-15 13:06:02.535582', '2021-04-15 13:06:02.535582', NULL),
	(10007506, 5, 'PW21A-JK100093BL-XXL', 0, 0, '2021-04-15 13:06:02.519850', '2021-04-15 13:06:02.519850', NULL),
	(10007507, 5, 'PW21A-JK100094GY-XS', 0, 0, '2021-04-15 13:06:02.497566', '2021-04-15 13:06:02.497566', NULL),
	(10007508, 5, 'PW21A-JK100094GY-S', 0, 0, '2021-04-15 13:06:02.521331', '2021-04-15 13:06:02.521331', NULL),
	(10007509, 5, 'PW21A-JK100094GY-M', 0, 0, '2021-04-15 13:06:02.520936', '2021-04-15 13:06:02.520936', NULL),
	(10007510, 5, 'PW21A-JK100094GY-L', 0, 0, '2021-04-15 13:06:02.518745', '2021-04-15 13:06:02.518745', NULL),
	(10007511, 5, 'PW21A-JK100094GY-XL', 0, 0, '2021-04-15 13:06:02.548175', '2021-04-15 13:06:02.548175', NULL),
	(10007512, 5, 'PW21A-JK100094GY-XXL', 0, 0, '2021-04-15 13:06:02.520225', '2021-04-15 13:06:02.520225', NULL),
	(10007513, 5, 'PW21A-JK100095AR-XS', 0, 0, '2021-04-15 13:06:02.572908', '2021-04-15 13:06:02.572908', NULL),
	(10007514, 5, 'PW21A-JK100095AR-S', 0, 0, '2021-04-15 13:06:02.574514', '2021-04-15 13:06:02.574514', NULL),
	(10007515, 5, 'PW21A-JK100095AR-M', 0, 0, '2021-04-15 13:06:02.538195', '2021-04-15 13:06:02.538195', NULL),
	(10007516, 5, 'PW21A-JK100095AR-L', 0, 0, '2021-04-15 13:06:02.536147', '2021-04-15 13:06:02.536147', NULL),
	(10007517, 5, 'PW21A-JK100095AR-XL', 0, 0, '2021-04-15 13:06:02.536757', '2021-04-15 13:06:02.536757', NULL),
	(10007518, 5, 'PW21A-JK100095AR-XXL', 0, 0, '2021-04-15 13:06:02.550220', '2021-04-15 13:06:02.550220', NULL),
	(10007519, 5, 'PW21A-JK100096BL-XS', 0, 0, '2021-04-15 13:06:02.549641', '2021-04-15 13:06:02.549641', NULL),
	(10007520, 5, 'PW21A-JK100096BL-S', 0, 0, '2021-04-15 13:06:02.550965', '2021-04-15 13:06:02.550965', NULL),
	(10007521, 5, 'PW21A-JK100096BL-M', 0, 0, '2021-04-15 13:06:02.571898', '2021-04-15 13:06:02.571898', NULL),
	(10007522, 5, 'PW21A-JK100096BL-L', 0, 0, '2021-04-15 13:06:02.551708', '2021-04-15 13:06:02.551708', NULL),
	(10007523, 5, 'PW21A-JK100096BL-XL', 0, 0, '2021-04-15 13:06:02.645089', '2021-04-15 13:06:02.645089', NULL),
	(10007524, 5, 'PW21A-JK100096BL-XXL', 0, 0, '2021-04-15 13:06:02.603147', '2021-04-15 13:06:02.603147', NULL),
	(10007525, 5, 'PW21A-JK100097WT-XS', 2, 0, '2021-04-15 13:06:02.553467', '2021-04-15 13:06:02.553467', NULL),
	(10007526, 5, 'PW21A-JK100097WT-S', 2, 0, '2021-04-15 13:06:02.581391', '2021-04-15 13:06:02.581391', NULL),
	(10007527, 5, 'PW21A-JK100097WT-M', 2, 0, '2021-04-15 13:06:02.571456', '2021-04-15 13:06:02.571456', NULL),
	(10007528, 5, 'PW21A-JK100097WT-L', 2, 0, '2021-04-15 13:06:02.580067', '2021-04-15 13:06:02.580067', NULL),
	(10007529, 5, 'PW21A-JK100097WT-XL', 2, 0, '2021-04-15 13:06:02.581725', '2021-04-15 13:06:02.581725', NULL),
	(10007530, 5, 'PW21A-JK100097WT-XXL', 1, 0, '2021-04-15 13:06:02.582611', '2021-04-15 13:06:02.582611', NULL),
	(10007531, 5, 'PW21A-JK100098BL-XS', 0, 0, '2021-04-15 13:06:02.598645', '2021-04-15 13:06:02.598645', NULL),
	(10007532, 5, 'PW21A-JK100098BL-S', 1, 0, '2021-04-15 13:06:02.596742', '2021-04-15 13:06:02.596742', NULL),
	(10007533, 5, 'PW21A-JK100098BL-M', 2, 0, '2021-04-15 13:06:02.588895', '2021-04-15 13:06:02.588895', NULL),
	(10007534, 5, 'PW21A-JK100098BL-L', 2, 0, '2021-04-15 13:06:02.587692', '2021-04-15 13:06:02.587692', NULL),
	(10007535, 5, 'PW21A-JK100098BL-XL', 2, 0, '2021-04-15 13:06:02.601251', '2021-04-15 13:06:02.601251', NULL),
	(10007536, 5, 'PW21A-JK100098BL-XXL', 2, 0, '2021-04-15 13:06:02.610525', '2021-04-15 13:06:02.610525', NULL),
	(10007537, 5, 'PW21A-JK100099BL-XS', 0, 0, '2021-04-15 13:06:02.609109', '2021-04-15 13:06:02.609109', NULL),
	(10007538, 5, 'PW21A-JK100099BL-S', 0, 0, '2021-04-15 13:06:02.610105', '2021-04-15 13:06:02.610105', NULL),
	(10007539, 5, 'PW21A-JK100099BL-M', 0, 0, '2021-04-15 13:06:02.598987', '2021-04-15 13:06:02.598987', NULL),
	(10007540, 5, 'PW21A-JK100099BL-L', 0, 0, '2021-04-15 13:06:02.624041', '2021-04-15 13:06:02.624041', NULL),
	(10007541, 5, 'PW21A-JK100099BL-XL', 0, 0, '2021-04-15 13:06:02.625712', '2021-04-15 13:06:02.625712', NULL),
	(10007542, 5, 'PW21A-JK100099BL-XXL', 0, 0, '2021-04-15 13:06:02.633557', '2021-04-15 13:06:02.633557', NULL),
	(10007543, 5, 'PW21A-JK100100DM-XS', 0, 0, '2021-04-15 13:06:02.613906', '2021-04-15 13:06:02.613906', NULL),
	(10007544, 5, 'PW21A-JK100100DM-S', 2, 0, '2021-04-15 13:06:02.658979', '2021-04-15 13:06:02.658979', NULL),
	(10007545, 5, 'PW21A-JK100100DM-M', 2, 0, '2021-04-15 13:06:02.612923', '2021-04-15 13:06:02.612923', NULL),
	(10007546, 5, 'PW21A-JK100100DM-L', 2, 0, '2021-04-15 13:06:02.627811', '2021-04-15 13:06:02.627811', NULL),
	(10007547, 5, 'PW21A-JK100100DM-XL', 2, 0, '2021-04-15 13:06:02.638274', '2021-04-15 13:06:02.638274', NULL),
	(10007548, 5, 'PW21A-JK100100DM-XXL', 0, 0, '2021-04-15 13:06:02.621617', '2021-04-15 13:06:02.621617', NULL),
	(10007549, 5, 'PW21A-JK100101NV-XS', 0, 0, '2021-04-15 13:06:02.622361', '2021-04-15 13:06:02.622361', NULL),
	(10007550, 5, 'PW21A-JK100101NV-S', 0, 0, '2021-04-15 13:06:02.637432', '2021-04-15 13:06:02.637432', NULL),
	(10007551, 5, 'PW21A-JK100101NV-M', 0, 0, '2021-04-15 13:06:02.634734', '2021-04-15 13:06:02.634734', NULL),
	(10007552, 5, 'PW21A-JK100101NV-L', 0, 0, '2021-04-15 13:06:02.650809', '2021-04-15 13:06:02.650809', NULL),
	(10007553, 5, 'PW21A-JK100101NV-XL', 0, 0, '2021-04-15 13:06:02.655465', '2021-04-15 13:06:02.655465', NULL),
	(10007554, 5, 'PW21A-JK100101NV-XXL', 0, 0, '2021-04-15 13:06:02.635893', '2021-04-15 13:06:02.635893', NULL),
	(10007555, 5, 'PW21A-JK100102BW-XS', 0, 0, '2021-04-15 13:06:02.647953', '2021-04-15 13:06:02.647953', NULL),
	(10007556, 5, 'PW21A-JK100102BW-S', 0, 0, '2021-04-15 13:06:02.644305', '2021-04-15 13:06:02.644305', NULL),
	(10007557, 5, 'PW21A-JK100102BW-M', 0, 0, '2021-04-15 13:06:02.647455', '2021-04-15 13:06:02.647455', NULL),
	(10007558, 5, 'PW21A-JK100102BW-L', 0, 0, '2021-04-15 13:06:02.675254', '2021-04-15 13:06:02.675254', NULL),
	(10007559, 5, 'PW21A-JK100102BW-XL', 0, 0, '2021-04-15 13:06:02.651221', '2021-04-15 13:06:02.651221', NULL),
	(10007560, 5, 'PW21A-JK100102BW-XXL', 0, 0, '2021-04-15 13:06:02.661518', '2021-04-15 13:06:02.661518', NULL),
	(10007561, 5, 'PW21A-JK100103BL-XS', 0, 0, '2021-04-15 13:06:02.671517', '2021-04-15 13:06:02.671517', NULL),
	(10007562, 5, 'PW21A-JK100103BL-S', 0, 0, '2021-04-15 13:06:02.668979', '2021-04-15 13:06:02.668979', NULL),
	(10007563, 5, 'PW21A-JK100103BL-M', 0, 0, '2021-04-15 13:06:02.691480', '2021-04-15 13:06:02.691480', NULL),
	(10007564, 5, 'PW21A-JK100103BL-L', 0, 0, '2021-04-15 13:06:02.662846', '2021-04-15 13:06:02.662846', NULL),
	(10007565, 5, 'PW21A-JK100103BL-XL', 0, 0, '2021-04-15 13:06:02.672116', '2021-04-15 13:06:02.672116', NULL),
	(10007566, 5, 'PW21A-JK100103BL-XXL', 0, 0, '2021-04-15 13:06:02.680802', '2021-04-15 13:06:02.680802', NULL),
	(10007567, 5, 'PW21A-JK100104BL-XS', 0, 0, '2021-04-15 13:06:02.666552', '2021-04-15 13:06:02.666552', NULL),
	(10007568, 5, 'PW21A-JK100104BL-S', 2, 0, '2021-04-15 13:06:02.708161', '2021-04-15 13:06:02.708161', NULL),
	(10007569, 5, 'PW21A-JK100104BL-M', 2, 0, '2021-04-15 13:06:02.691870', '2021-04-15 13:06:02.691870', NULL),
	(10007570, 5, 'PW21A-JK100104BL-L', 2, 0, '2021-04-15 13:06:02.683194', '2021-04-15 13:06:02.683194', NULL),
	(10007571, 5, 'PW21A-JK100104BL-XL', 2, 0, '2021-04-15 13:06:02.723786', '2021-04-15 13:06:02.723786', NULL),
	(10007572, 5, 'PW21A-JK100104BL-XXL', 2, 0, '2021-04-15 13:06:02.704741', '2021-04-15 13:06:02.704741', NULL),
	(10007573, 5, 'PW21A-JK100105TC-XS', 0, 0, '2021-04-15 13:06:02.696391', '2021-04-15 13:06:02.696391', NULL),
	(10007574, 5, 'PW21A-JK100105TC-S', 0, 0, '2021-04-15 13:06:02.706662', '2021-04-15 13:06:02.706662', NULL),
	(10007575, 5, 'PW21A-JK100105TC-M', 0, 0, '2021-04-15 13:06:02.700000', '2021-04-15 13:06:02.700000', NULL),
	(10007576, 5, 'PW21A-JK100105TC-L', 0, 0, '2021-04-15 13:06:02.742157', '2021-04-15 13:06:02.742157', NULL),
	(10007577, 5, 'PW21A-JK100105TC-XL', 0, 0, '2021-04-15 13:06:02.713530', '2021-04-15 13:06:02.713530', NULL),
	(10007578, 5, 'PW21A-JK100105TC-XXL', 0, 0, '2021-04-15 13:06:02.705301', '2021-04-15 13:06:02.705301', NULL),
	(10007579, 5, 'PW21A-JK100106BL-XS', 0, 0, '2021-04-15 13:06:02.720197', '2021-04-15 13:06:02.720197', NULL),
	(10007580, 5, 'PW21A-JK100106BL-S', 2, 0, '2021-04-15 13:06:02.714383', '2021-04-15 13:06:02.714383', NULL),
	(10007581, 5, 'PW21A-JK100106BL-M', 2, 0, '2021-04-15 13:06:02.726100', '2021-04-15 13:06:02.726100', NULL),
	(10007582, 5, 'PW21A-JK100106BL-L', 2, 0, '2021-04-15 13:06:02.729618', '2021-04-15 13:06:02.729618', NULL),
	(10007583, 5, 'PW21A-JK100106BL-XL', 2, 0, '2021-04-15 13:06:02.720585', '2021-04-15 13:06:02.720585', NULL),
	(10007584, 5, 'PW21A-JK100106BL-XXL', 2, 0, '2021-04-15 13:06:02.730795', '2021-04-15 13:06:02.730795', NULL),
	(10007585, 5, 'PW21A-JK100107BL-XS', 0, 0, '2021-04-15 13:06:02.731839', '2021-04-15 13:06:02.731839', NULL),
	(10007586, 5, 'PW21A-JK100107BL-S', 0, 0, '2021-04-15 13:06:02.760186', '2021-04-15 13:06:02.760186', NULL),
	(10007587, 5, 'PW21A-JK100107BL-M', 0, 0, '2021-04-15 13:06:02.743057', '2021-04-15 13:06:02.743057', NULL),
	(10007588, 5, 'PW21A-JK100107BL-L', 0, 0, '2021-04-15 13:06:02.730466', '2021-04-15 13:06:02.730466', NULL),
	(10007589, 5, 'PW21A-JK100107BL-XL', 0, 0, '2021-04-15 13:06:02.737784', '2021-04-15 13:06:02.737784', NULL),
	(10007590, 5, 'PW21A-JK100107BL-XXL', 0, 0, '2021-04-15 13:06:02.745973', '2021-04-15 13:06:02.745973', NULL),
	(10007591, 5, 'PW21A-JK100108BL-XS', 0, 0, '2021-04-15 13:06:02.770519', '2021-04-15 13:06:02.770519', NULL),
	(10007592, 5, 'PW21A-JK100108BL-S', 3, 0, '2021-04-15 13:06:02.757391', '2021-04-15 13:06:02.757391', NULL),
	(10007593, 5, 'PW21A-JK100108BL-M', 2, 0, '2021-04-15 13:06:02.735780', '2021-04-15 13:06:02.735780', NULL),
	(10007594, 5, 'PW21A-JK100108BL-L', 2, 0, '2021-04-15 13:06:02.815098', '2021-04-15 13:06:02.815098', NULL),
	(10007595, 5, 'PW21A-JK100108BL-XL', 2, 0, '2021-04-15 13:06:02.758542', '2021-04-15 13:06:02.758542', NULL),
	(10007596, 5, 'PW21A-JK100108BL-XXL', 1, 0, '2021-04-15 13:06:02.762729', '2021-04-15 13:06:02.762729', NULL),
	(10007597, 5, 'PW21A-JK100109BL-XS', 0, 0, '2021-04-15 13:06:02.785241', '2021-04-15 13:06:02.785241', NULL),
	(10007598, 5, 'PW21A-JK100109BL-S', 0, 0, '2021-04-15 13:06:02.799431', '2021-04-15 13:06:02.799431', NULL),
	(10007599, 5, 'PW21A-JK100109BL-M', 1, 0, '2021-04-15 13:06:02.751986', '2021-04-15 13:06:02.751986', NULL),
	(10007600, 5, 'PW21A-JK100109BL-L', 2, 0, '2021-04-15 13:06:02.767223', '2021-04-15 13:06:02.767223', NULL),
	(10007601, 5, 'PW21A-JK100109BL-XL', 2, 0, '2021-04-15 13:06:02.796231', '2021-04-15 13:06:02.796231', NULL),
	(10007602, 5, 'PW21A-JK100109BL-XXL', 2, 0, '2021-04-15 13:06:02.806021', '2021-04-15 13:06:02.806021', NULL),
	(10007603, 5, 'PW21A-JK100110BL-XS', 2, 0, '2021-04-15 13:06:02.796897', '2021-04-15 13:06:02.796897', NULL),
	(10007604, 5, 'PW21A-JK100110BL-S', 2, 0, '2021-04-15 13:06:02.776323', '2021-04-15 13:06:02.776323', NULL),
	(10007605, 5, 'PW21A-JK100110BL-M', 2, 0, '2021-04-15 13:06:02.789733', '2021-04-15 13:06:02.789733', NULL),
	(10007606, 5, 'PW21A-JK100110BL-L', 2, 0, '2021-04-15 13:06:02.808169', '2021-04-15 13:06:02.808169', NULL),
	(10007607, 5, 'PW21A-JK100110BL-XL', 2, 0, '2021-04-15 13:06:02.881001', '2021-04-15 13:06:02.881001', NULL),
	(10007608, 5, 'PW21A-JK100110BL-XXL', 3, 0, '2021-04-15 13:06:02.779524', '2021-04-15 13:06:02.779524', NULL),
	(10007609, 5, 'PW21A-JK100111BL-XS', 0, 0, '2021-04-15 13:06:02.802675', '2021-04-15 13:06:02.802675', NULL),
	(10007610, 5, 'PW21A-JK100111BL-S', 0, 0, '2021-04-15 13:06:02.808633', '2021-04-15 13:06:02.808633', NULL),
	(10007611, 5, 'PW21A-JK100111BL-M', 1, 0, '2021-04-15 13:06:02.866524', '2021-04-15 13:06:02.866524', NULL),
	(10007612, 5, 'PW21A-JK100111BL-L', 1, 0, '2021-04-15 13:06:02.883178', '2021-04-15 13:06:02.883178', NULL),
	(10007613, 5, 'PW21A-JK100111BL-XL', 2, 0, '2021-04-15 13:06:02.884218', '2021-04-15 13:06:02.884218', NULL),
	(10007614, 5, 'PW21A-JK100111BL-XXL', 2, 0, '2021-04-15 13:06:02.921351', '2021-04-15 13:06:02.921351', NULL),
	(10007615, 5, 'PW21A-JK100112CM-XS', 0, 0, '2021-04-15 13:06:02.879772', '2021-04-15 13:06:02.879772', NULL),
	(10007616, 5, 'PW21A-JK100112CM-S', 0, 0, '2021-04-15 13:06:02.865724', '2021-04-15 13:06:02.865724', NULL),
	(10007617, 5, 'PW21A-JK100112CM-M', 0, 0, '2021-04-15 13:06:02.942001', '2021-04-15 13:06:02.942001', NULL),
	(10007618, 5, 'PW21A-JK100112CM-L', 0, 0, '2021-04-15 13:06:02.888154', '2021-04-15 13:06:02.888154', NULL),
	(10007619, 5, 'PW21A-JK100112CM-XL', 0, 0, '2021-04-15 13:06:02.900796', '2021-04-15 13:06:02.900796', NULL),
	(10007620, 5, 'PW21A-JK100112CM-XXL', 0, 0, '2021-04-15 13:06:02.899728', '2021-04-15 13:06:02.899728', NULL),
	(10007621, 5, 'PW21A-JK100113CM-XS', 0, 0, '2021-04-15 13:06:02.894996', '2021-04-15 13:06:02.894996', NULL),
	(10007622, 5, 'PW21A-JK100113CM-S', 0, 0, '2021-04-15 13:06:02.920662', '2021-04-15 13:06:02.920662', NULL),
	(10007623, 5, 'PW21A-JK100113CM-M', 0, 0, '2021-04-15 13:06:02.921964', '2021-04-15 13:06:02.921964', NULL),
	(10007624, 5, 'PW21A-JK100113CM-L', 0, 0, '2021-04-15 13:06:02.919884', '2021-04-15 13:06:02.919884', NULL),
	(10007625, 5, 'PW21A-JK100113CM-XL', 0, 0, '2021-04-15 13:06:02.924331', '2021-04-15 13:06:02.924331', NULL),
	(10007626, 5, 'PW21A-JK100113CM-XXL', 0, 0, '2021-04-15 13:06:02.932890', '2021-04-15 13:06:02.932890', NULL),
	(10007627, 5, 'PW21A-JK100114CM-XS', 0, 0, '2021-04-15 13:06:02.947824', '2021-04-15 13:06:02.947824', NULL),
	(10007628, 5, 'PW21A-JK100114CM-S', 0, 0, '2021-04-15 13:06:02.931123', '2021-04-15 13:06:02.931123', NULL),
	(10007629, 5, 'PW21A-JK100114CM-M', 0, 0, '2021-04-15 13:06:02.947149', '2021-04-15 13:06:02.947149', NULL),
	(10007630, 5, 'PW21A-JK100114CM-L', 0, 0, '2021-04-15 13:06:02.975382', '2021-04-15 13:06:02.975382', NULL),
	(10007631, 5, 'PW21A-JK100114CM-XL', 0, 0, '2021-04-15 13:06:02.967864', '2021-04-15 13:06:02.967864', NULL),
	(10007632, 5, 'PW21A-JK100114CM-XXL', 0, 0, '2021-04-15 13:06:03.020347', '2021-04-15 13:06:03.020347', NULL),
	(10007633, 5, 'PW21A-JK100115DM-XS', 0, 0, '2021-04-15 13:06:03.010134', '2021-04-15 13:06:03.010134', NULL),
	(10007634, 5, 'PW21A-JK100115DM-S', 2, 0, '2021-04-15 13:06:02.994646', '2021-04-15 13:06:02.994646', NULL),
	(10007635, 5, 'PW21A-JK100115DM-M', 2, 0, '2021-04-15 13:06:02.974529', '2021-04-15 13:06:02.974529', NULL),
	(10007636, 5, 'PW21A-JK100115DM-L', 2, 0, '2021-04-15 13:06:02.966226', '2021-04-15 13:06:02.966226', NULL),
	(10007637, 5, 'PW21A-JK100115DM-XL', 0, 0, '2021-04-15 13:06:03.000713', '2021-04-15 13:06:03.000713', NULL),
	(10007638, 5, 'PW21A-JK100115DM-XXL', 0, 0, '2021-04-15 13:06:02.981629', '2021-04-15 13:06:02.981629', NULL),
	(10007639, 5, 'PW21A-JK100116RD-XS', 0, 0, '2021-04-15 13:06:03.020920', '2021-04-15 13:06:03.020920', NULL),
	(10007640, 5, 'PW21A-JK100116RD-S', 0, 0, '2021-04-15 13:06:02.976838', '2021-04-15 13:06:02.976838', NULL),
	(10007641, 5, 'PW21A-JK100116RD-M', 0, 0, '2021-04-15 13:06:03.011589', '2021-04-15 13:06:03.011589', NULL),
	(10007642, 5, 'PW21A-JK100116RD-L', 0, 0, '2021-04-15 13:06:03.003562', '2021-04-15 13:06:03.003562', NULL),
	(10007643, 5, 'PW21A-JK100116RD-XL', 0, 0, '2021-04-15 13:06:03.003100', '2021-04-15 13:06:03.003100', NULL),
	(10007644, 5, 'PW21A-JK100116RD-XXL', 0, 0, '2021-04-15 13:06:03.133522', '2021-04-15 13:06:03.133522', NULL),
	(10007645, 5, 'PW21A-JK100117BL-XS', 0, 0, '2021-04-15 13:06:03.040386', '2021-04-15 13:06:03.040386', NULL),
	(10007646, 5, 'PW21A-JK100117BL-S', 0, 0, '2021-04-15 13:06:03.016946', '2021-04-15 13:06:03.016946', NULL),
	(10007647, 5, 'PW21A-JK100117BL-M', 0, 0, '2021-04-15 13:06:03.030026', '2021-04-15 13:06:03.030026', NULL),
	(10007648, 5, 'PW21A-JK100117BL-L', 0, 0, '2021-04-15 13:06:03.059558', '2021-04-15 13:06:03.059558', NULL),
	(10007649, 5, 'PW21A-JK100117BL-XL', 0, 0, '2021-04-15 13:06:03.031854', '2021-04-15 13:06:03.031854', NULL),
	(10007650, 5, 'PW21A-JK100117BL-XXL', 0, 0, '2021-04-15 13:06:03.031284', '2021-04-15 13:06:03.031284', NULL),
	(10007651, 5, 'PW21A-JK100118AR-XS', 0, 0, '2021-04-15 13:06:03.012722', '2021-04-15 13:06:03.012722', NULL),
	(10007652, 5, 'PW21A-JK100118AR-S', 2, 0, '2021-04-15 13:06:03.042601', '2021-04-15 13:06:03.042601', NULL),
	(10007653, 5, 'PW21A-JK100118AR-M', 2, 0, '2021-04-15 13:06:03.097127', '2021-04-15 13:06:03.097127', NULL),
	(10007654, 5, 'PW21A-JK100118AR-L', 2, 0, '2021-04-15 13:06:03.047960', '2021-04-15 13:06:03.047960', NULL),
	(10007655, 5, 'PW21A-JK100118AR-XL', 2, 0, '2021-04-15 13:06:03.051348', '2021-04-15 13:06:03.051348', NULL),
	(10007656, 5, 'PW21A-JK100118AR-XXL', 1, 0, '2021-04-15 13:06:03.049058', '2021-04-15 13:06:03.049058', NULL),
	(10007657, 5, 'PW21A-JK100119BL-XS', 0, 0, '2021-04-15 13:06:03.055357', '2021-04-15 13:06:03.055357', NULL),
	(10007658, 5, 'PW21A-JK100119BL-S', 2, 0, '2021-04-15 13:06:03.066612', '2021-04-15 13:06:03.066612', NULL),
	(10007659, 5, 'PW21A-JK100119BL-M', 2, 0, '2021-04-15 13:06:03.072741', '2021-04-15 13:06:03.072741', NULL),
	(10007660, 5, 'PW21A-JK100119BL-L', 2, 0, '2021-04-15 13:06:03.072213', '2021-04-15 13:06:03.072213', NULL),
	(10007661, 5, 'PW21A-JK100119BL-XL', 2, 0, '2021-04-15 13:06:03.135855', '2021-04-15 13:06:03.135855', NULL),
	(10007662, 5, 'PW21A-JK100119BL-XXL', 1, 0, '2021-04-15 13:06:03.155827', '2021-04-15 13:06:03.155827', NULL),
	(10007663, 5, 'PW21A-JK100120BL-XS', 2, 0, '2021-04-15 13:06:03.075952', '2021-04-15 13:06:03.075952', NULL),
	(10007664, 5, 'PW21A-JK100120BL-S', 2, 0, '2021-04-15 13:06:03.091382', '2021-04-15 13:06:03.091382', NULL),
	(10007665, 5, 'PW21A-JK100120BL-M', 4, 0, '2021-04-15 13:06:03.094635', '2021-04-15 13:06:03.094635', NULL),
	(10007666, 5, 'PW21A-JK100120BL-L', 4, 0, '2021-04-15 13:06:03.095196', '2021-04-15 13:06:03.095196', NULL),
	(10007667, 5, 'PW21A-JK100120BL-XL', 4, 0, '2021-04-15 13:06:03.180722', '2021-04-15 13:06:03.180722', NULL),
	(10007668, 5, 'PW21A-JK100120BL-XXL', 2, 0, '2021-04-15 13:06:03.105771', '2021-04-15 13:06:03.105771', NULL),
	(10007669, 5, 'PW21A-JK100121MR-XS', 0, 0, '2021-04-15 13:06:03.211913', '2021-04-15 13:06:03.211913', NULL),
	(10007670, 5, 'PW21A-JK100121MR-S', 2, 0, '2021-04-15 13:06:03.110776', '2021-04-15 13:06:03.110776', NULL),
	(10007671, 5, 'PW21A-JK100121MR-M', 2, 0, '2021-04-15 13:06:03.116098', '2021-04-15 13:06:03.116098', NULL),
	(10007672, 5, 'PW21A-JK100121MR-L', 2, 0, '2021-04-15 13:06:03.129269', '2021-04-15 13:06:03.129269', NULL),
	(10007673, 5, 'PW21A-JK100121MR-XL', 2, 0, '2021-04-15 13:06:03.145654', '2021-04-15 13:06:03.145654', NULL),
	(10007674, 5, 'PW21A-JK100121MR-XXL', 2, 0, '2021-04-15 13:06:03.146179', '2021-04-15 13:06:03.146179', NULL),
	(10007675, 5, 'PW21A-JK100122RD-XS', 0, 0, '2021-04-15 13:06:03.140725', '2021-04-15 13:06:03.140725', NULL),
	(10007676, 5, 'PW21A-JK100122RD-S', 0, 0, '2021-04-15 13:06:03.147911', '2021-04-15 13:06:03.147911', NULL),
	(10007677, 5, 'PW21A-JK100122RD-M', 0, 0, '2021-04-15 13:06:03.179889', '2021-04-15 13:06:03.179889', NULL),
	(10007678, 5, 'PW21A-JK100122RD-L', 0, 0, '2021-04-15 13:06:03.158140', '2021-04-15 13:06:03.158140', NULL),
	(10007679, 5, 'PW21A-JK100122RD-XL', 0, 0, '2021-04-15 13:06:03.196129', '2021-04-15 13:06:03.196129', NULL),
	(10007680, 5, 'PW21A-JK100122RD-XXL', 0, 0, '2021-04-15 13:06:03.179545', '2021-04-15 13:06:03.179545', NULL),
	(10007681, 5, 'PW21A-JK100123BL-XS', 0, 0, '2021-04-15 13:06:03.186774', '2021-04-15 13:06:03.186774', NULL),
	(10007682, 5, 'PW21A-JK100123BL-S', 0, 0, '2021-04-15 13:06:03.182664', '2021-04-15 13:06:03.182664', NULL),
	(10007683, 5, 'PW21A-JK100123BL-M', 0, 0, '2021-04-15 13:06:03.153533', '2021-04-15 13:06:03.153533', NULL),
	(10007684, 5, 'PW21A-JK100123BL-L', 0, 0, '2021-04-15 13:06:03.242245', '2021-04-15 13:06:03.242245', NULL),
	(10007685, 5, 'PW21A-JK100123BL-XL', 0, 0, '2021-04-15 13:06:03.192024', '2021-04-15 13:06:03.192024', NULL),
	(10007686, 5, 'PW21A-JK100123BL-XXL', 0, 0, '2021-04-15 13:06:03.291629', '2021-04-15 13:06:03.291629', NULL),
	(10007687, 5, 'PW21A-JK100124BL-XS', 0, 0, '2021-04-15 13:06:03.193484', '2021-04-15 13:06:03.193484', NULL),
	(10007688, 5, 'PW21A-JK100124BL-S', 0, 0, '2021-04-15 13:06:03.196586', '2021-04-15 13:06:03.196586', NULL),
	(10007689, 5, 'PW21A-JK100124BL-M', 0, 0, '2021-04-15 13:06:03.227214', '2021-04-15 13:06:03.227214', NULL),
	(10007690, 5, 'PW21A-JK100124BL-L', 0, 0, '2021-04-15 13:06:03.202918', '2021-04-15 13:06:03.202918', NULL),
	(10007691, 5, 'PW21A-JK100124BL-XL', 0, 0, '2021-04-15 13:06:03.213714', '2021-04-15 13:06:03.213714', NULL),
	(10007692, 5, 'PW21A-JK100124BL-XXL', 0, 0, '2021-04-15 13:06:03.208785', '2021-04-15 13:06:03.208785', NULL),
	(10007693, 5, 'PW21A-JK100125AR-XS', 0, 0, '2021-04-15 13:06:03.231537', '2021-04-15 13:06:03.231537', NULL),
	(10007694, 5, 'PW21A-JK100125AR-S', 0, 0, '2021-04-15 13:06:03.226698', '2021-04-15 13:06:03.226698', NULL),
	(10007695, 5, 'PW21A-JK100125AR-M', 0, 0, '2021-04-15 13:06:03.216440', '2021-04-15 13:06:03.216440', NULL),
	(10007696, 5, 'PW21A-JK100125AR-L', 0, 0, '2021-04-15 13:06:03.245442', '2021-04-15 13:06:03.245442', NULL),
	(10007697, 5, 'PW21A-JK100125AR-XL', 0, 0, '2021-04-15 13:06:03.219092', '2021-04-15 13:06:03.219092', NULL),
	(10007698, 5, 'PW21A-JK100125AR-XXL', 0, 0, '2021-04-15 13:06:03.229000', '2021-04-15 13:06:03.229000', NULL),
	(10007699, 5, 'PW21A-JK100126BL-XS', 0, 0, '2021-04-15 13:06:03.237103', '2021-04-15 13:06:03.237103', NULL),
	(10007700, 5, 'PW21A-JK100126BL-S', 0, 0, '2021-04-15 13:06:03.286279', '2021-04-15 13:06:03.286279', NULL),
	(10007701, 5, 'PW21A-JK100126BL-M', 0, 0, '2021-04-15 13:06:03.261875', '2021-04-15 13:06:03.261875', NULL),
	(10007702, 5, 'PW21A-JK100126BL-L', 0, 0, '2021-04-15 13:06:03.254121', '2021-04-15 13:06:03.254121', NULL),
	(10007703, 5, 'PW21A-JK100126BL-XL', 0, 0, '2021-04-15 13:06:03.244869', '2021-04-15 13:06:03.244869', NULL),
	(10007704, 5, 'PW21A-JK100126BL-XXL', 0, 0, '2021-04-15 13:06:03.269021', '2021-04-15 13:06:03.269021', NULL),
	(10007705, 5, 'PW21A-JK100127BL-XS', 0, 0, '2021-04-15 13:06:03.253006', '2021-04-15 13:06:03.253006', NULL),
	(10007706, 5, 'PW21A-JK100127BL-S', 0, 0, '2021-04-15 13:06:03.341302', '2021-04-15 13:06:03.341302', NULL),
	(10007707, 5, 'PW21A-JK100127BL-M', 0, 0, '2021-04-15 13:06:03.261214', '2021-04-15 13:06:03.261214', NULL),
	(10007708, 5, 'PW21A-JK100127BL-L', 0, 0, '2021-04-15 13:06:03.296640', '2021-04-15 13:06:03.296640', NULL),
	(10007709, 5, 'PW21A-JK100127BL-XL', 0, 0, '2021-04-15 13:06:03.271672', '2021-04-15 13:06:03.271672', NULL),
	(10007710, 5, 'PW21A-JK100127BL-XXL', 0, 0, '2021-04-15 13:06:03.343489', '2021-04-15 13:06:03.343489', NULL),
	(10007711, 5, 'PW21A-JK100128BL-XS', 0, 0, '2021-04-15 13:06:03.294819', '2021-04-15 13:06:03.294819', NULL),
	(10007712, 5, 'PW21A-JK100128BL-S', 0, 0, '2021-04-15 13:06:03.306796', '2021-04-15 13:06:03.306796', NULL),
	(10007713, 5, 'PW21A-JK100128BL-M', 0, 0, '2021-04-15 13:06:03.313131', '2021-04-15 13:06:03.313131', NULL),
	(10007714, 5, 'PW21A-JK100128BL-L', 0, 0, '2021-04-15 13:06:03.300804', '2021-04-15 13:06:03.300804', NULL),
	(10007715, 5, 'PW21A-JK100128BL-XL', 0, 0, '2021-04-15 13:06:03.302894', '2021-04-15 13:06:03.302894', NULL),
	(10007716, 5, 'PW21A-JK100128BL-XXL', 0, 0, '2021-04-15 13:06:03.308958', '2021-04-15 13:06:03.308958', NULL),
	(10007717, 5, 'PW21A-JK100129YW -XS', 0, 0, '2021-04-15 13:06:03.355155', '2021-04-15 13:06:03.355155', NULL),
	(10007718, 5, 'PW21A-JK100129YW -S', 0, 0, '2021-04-15 13:06:03.311885', '2021-04-15 13:06:03.311885', NULL),
	(10007719, 5, 'PW21A-JK100129YW -M', 1, 0, '2021-04-15 13:06:03.349217', '2021-04-15 13:06:03.349217', NULL),
	(10007720, 5, 'PW21A-JK100129YW -L', 1, 0, '2021-04-15 13:06:03.375553', '2021-04-15 13:06:03.375553', NULL),
	(10007721, 5, 'PW21A-JK100129YW -XL', 1, 0, '2021-04-15 13:06:03.332353', '2021-04-15 13:06:03.332353', NULL),
	(10007722, 5, 'PW21A-JK100129YW -XXL', 0, 0, '2021-04-15 13:06:03.321323', '2021-04-15 13:06:03.321323', NULL),
	(10007723, 5, 'PW21A-JK100130YW -XS', 2, 0, '2021-04-15 13:06:03.351033', '2021-04-15 13:06:03.351033', NULL),
	(10007724, 5, 'PW21A-JK100130YW -S', 2, 0, '2021-04-15 13:06:03.339946', '2021-04-15 13:06:03.339946', NULL),
	(10007725, 5, 'PW21A-JK100130YW -M', 2, 0, '2021-04-15 13:06:03.339199', '2021-04-15 13:06:03.339199', NULL),
	(10007726, 5, 'PW21A-JK100130YW -L', 3, 0, '2021-04-15 13:06:03.344340', '2021-04-15 13:06:03.344340', NULL),
	(10007727, 5, 'PW21A-JK100130YW -XL', 4, 0, '2021-04-15 13:06:03.389121', '2021-04-15 13:06:03.389121', NULL),
	(10007728, 5, 'PW21A-JK100130YW -XXL', 1, 0, '2021-04-15 13:06:03.455087', '2021-04-15 13:06:03.455087', NULL),
	(10007729, 5, 'PW21A-JK100131YW -XS', 0, 0, '2021-04-15 13:06:03.396571', '2021-04-15 13:06:03.396571', NULL),
	(10007730, 5, 'PW21A-JK100131YW -S', 0, 0, '2021-04-15 13:06:03.406388', '2021-04-15 13:06:03.406388', NULL),
	(10007731, 5, 'PW21A-JK100131YW -M', 0, 0, '2021-04-15 13:06:03.400205', '2021-04-15 13:06:03.400205', NULL),
	(10007732, 5, 'PW21A-JK100131YW -L', 0, 0, '2021-04-15 13:06:03.395921', '2021-04-15 13:06:03.395921', NULL),
	(10007733, 5, 'PW21A-JK100131YW -XL', 0, 0, '2021-04-15 13:06:03.365781', '2021-04-15 13:06:03.365781', NULL),
	(10007734, 5, 'PW21A-JK100131YW -XXL', 0, 0, '2021-04-15 13:06:03.394713', '2021-04-15 13:06:03.394713', NULL),
	(10007735, 5, 'PW21A-JK100132BL-XS', 0, 0, '2021-04-15 13:06:03.407789', '2021-04-15 13:06:03.407789', NULL),
	(10007736, 5, 'PW21A-JK100132BL-S', 0, 0, '2021-04-15 13:06:03.417932', '2021-04-15 13:06:03.417932', NULL),
	(10007737, 5, 'PW21A-JK100132BL-M', 0, 0, '2021-04-15 13:06:03.457811', '2021-04-15 13:06:03.457811', NULL),
	(10007738, 5, 'PW21A-JK100132BL-L', 0, 0, '2021-04-15 13:06:03.427096', '2021-04-15 13:06:03.427096', NULL),
	(10007739, 5, 'PW21A-JK100132BL-XL', 0, 0, '2021-04-15 13:06:03.438420', '2021-04-15 13:06:03.438420', NULL),
	(10007740, 5, 'PW21A-JK100132BL-XXL', 0, 0, '2021-04-15 13:06:03.413035', '2021-04-15 13:06:03.413035', NULL),
	(10007741, 5, 'PW21A-JK100133BL-XS', 0, 0, '2021-04-15 13:06:03.432217', '2021-04-15 13:06:03.432217', NULL),
	(10007742, 5, 'PW21A-JK100133BL-S', 0, 0, '2021-04-15 13:06:03.466607', '2021-04-15 13:06:03.466607', NULL),
	(10007743, 5, 'PW21A-JK100133BL-M', 0, 0, '2021-04-15 13:06:03.486227', '2021-04-15 13:06:03.486227', NULL),
	(10007744, 5, 'PW21A-JK100133BL-L', 0, 0, '2021-04-15 13:06:03.439146', '2021-04-15 13:06:03.439146', NULL),
	(10007745, 5, 'PW21A-JK100133BL-XL', 0, 0, '2021-04-15 13:06:03.445335', '2021-04-15 13:06:03.445335', NULL),
	(10007746, 5, 'PW21A-JK100133BL-XXL', 0, 0, '2021-04-15 13:06:03.475116', '2021-04-15 13:06:03.475116', NULL),
	(10007747, 5, 'PW21A-JK100134OL-XS', 0, 0, '2021-04-15 13:06:03.460521', '2021-04-15 13:06:03.460521', NULL),
	(10007748, 5, 'PW21A-JK100134OL-S', 0, 0, '2021-04-15 13:06:03.447285', '2021-04-15 13:06:03.447285', NULL),
	(10007749, 5, 'PW21A-JK100134OL-M', 1, 0, '2021-04-15 13:06:03.507527', '2021-04-15 13:06:03.507527', NULL),
	(10007750, 5, 'PW21A-JK100134OL-L', 2, 0, '2021-04-15 13:06:03.586898', '2021-04-15 13:06:03.586898', NULL),
	(10007751, 5, 'PW21A-JK100134OL-XL', 2, 0, '2021-04-15 13:06:03.508262', '2021-04-15 13:06:03.508262', NULL),
	(10007752, 5, 'PW21A-JK100134OL-XXL', 0, 0, '2021-04-15 13:06:03.586679', '2021-04-15 13:06:03.586679', NULL),
	(10007753, 5, 'PW21A-JK100135BL-XS', 0, 0, '2021-04-15 13:06:03.488425', '2021-04-15 13:06:03.488425', NULL),
	(10007754, 5, 'PW21A-JK100135BL-S', 0, 0, '2021-04-15 13:06:03.534785', '2021-04-15 13:06:03.534785', NULL),
	(10007755, 5, 'PW21A-JK100135BL-M', 0, 0, '2021-04-15 13:06:03.535517', '2021-04-15 13:06:03.535517', NULL),
	(10007756, 5, 'PW21A-JK100135BL-L', 0, 0, '2021-04-15 13:06:03.487168', '2021-04-15 13:06:03.487168', NULL),
	(10007757, 5, 'PW21A-JK100135BL-XL', 0, 0, '2021-04-15 13:06:03.513678', '2021-04-15 13:06:03.513678', NULL),
	(10007758, 5, 'PW21A-JK100135BL-XXL', 0, 0, '2021-04-15 13:06:03.509673', '2021-04-15 13:06:03.509673', NULL),
	(10007759, 5, 'PW21A-JK100136OL-XS', 0, 0, '2021-04-15 13:06:03.544653', '2021-04-15 13:06:03.544653', NULL),
	(10007760, 5, 'PW21A-JK100136OL-S', 2, 0, '2021-04-15 13:06:03.542279', '2021-04-15 13:06:03.542279', NULL),
	(10007761, 5, 'PW21A-JK100136OL-M', 2, 0, '2021-04-15 13:06:03.545445', '2021-04-15 13:06:03.545445', NULL),
	(10007762, 5, 'PW21A-JK100136OL-L', 2, 0, '2021-04-15 13:06:03.535089', '2021-04-15 13:06:03.535089', NULL),
	(10007763, 5, 'PW21A-JK100136OL-XL', 2, 0, '2021-04-15 13:06:03.554476', '2021-04-15 13:06:03.554476', NULL),
	(10007764, 5, 'PW21A-JK100136OL-XXL', 1, 0, '2021-04-15 13:06:03.591535', '2021-04-15 13:06:03.591535', NULL),
	(10007765, 5, 'PW21A-JK100137BL-XS', 2, 0, '2021-04-15 13:06:03.570848', '2021-04-15 13:06:03.570848', NULL),
	(10007766, 5, 'PW21A-JK100137BL-S', 2, 0, '2021-04-15 13:06:03.571811', '2021-04-15 13:06:03.571811', NULL),
	(10007767, 5, 'PW21A-JK100137BL-M', 2, 0, '2021-04-15 13:06:03.553957', '2021-04-15 13:06:03.553957', NULL),
	(10007768, 5, 'PW21A-JK100137BL-L', 2, 0, '2021-04-15 13:06:03.600684', '2021-04-15 13:06:03.600684', NULL),
	(10007769, 5, 'PW21A-JK100137BL-XL', 2, 0, '2021-04-15 13:06:03.637406', '2021-04-15 13:06:03.637406', NULL),
	(10007770, 5, 'PW21A-JK100137BL-XXL', 1, 0, '2021-04-15 13:06:03.591999', '2021-04-15 13:06:03.591999', NULL),
	(10007771, 5, 'PW21A-JK100138OL-XS', 0, 0, '2021-04-15 13:06:03.580004', '2021-04-15 13:06:03.580004', NULL),
	(10007772, 5, 'PW21A-JK100138OL-S', 2, 0, '2021-04-15 13:06:03.593605', '2021-04-15 13:06:03.593605', NULL),
	(10007773, 5, 'PW21A-JK100138OL-M', 2, 0, '2021-04-15 13:06:03.573115', '2021-04-15 13:06:03.573115', NULL),
	(10007774, 5, 'PW21A-JK100138OL-L', 2, 0, '2021-04-15 13:06:03.600332', '2021-04-15 13:06:03.600332', NULL),
	(10007775, 5, 'PW21A-JK100138OL-XL', 2, 0, '2021-04-15 13:06:03.658041', '2021-04-15 13:06:03.658041', NULL),
	(10007776, 5, 'PW21A-JK100138OL-XXL', 1, 0, '2021-04-15 13:06:03.738323', '2021-04-15 13:06:03.738323', NULL),
	(10007777, 5, 'PW21A-JK100139BL-XS', 0, 0, '2021-04-15 13:06:03.637095', '2021-04-15 13:06:03.637095', NULL),
	(10007778, 5, 'PW21A-JK100139BL-S', 3, 0, '2021-04-15 13:06:03.609407', '2021-04-15 13:06:03.609407', NULL),
	(10007779, 5, 'PW21A-JK100139BL-M', 3, 0, '2021-04-15 13:06:03.692515', '2021-04-15 13:06:03.692515', NULL),
	(10007780, 5, 'PW21A-JK100139BL-L', 3, 0, '2021-04-15 13:06:03.618628', '2021-04-15 13:06:03.618628', NULL),
	(10007781, 5, 'PW21A-JK100139BL-XL', 2, 0, '2021-04-15 13:06:03.735072', '2021-04-15 13:06:03.735072', NULL),
	(10007782, 5, 'PW21A-JK100139BL-XXL', 1, 0, '2021-04-15 13:06:03.687925', '2021-04-15 13:06:03.687925', NULL),
	(10007783, 5, 'PW21A-JK100140OL-XS', 0, 0, '2021-04-15 13:06:03.659454', '2021-04-15 13:06:03.659454', NULL),
	(10007784, 5, 'PW21A-JK100140OL-S', 2, 0, '2021-04-15 13:06:03.668377', '2021-04-15 13:06:03.668377', NULL),
	(10007785, 5, 'PW21A-JK100140OL-M', 2, 0, '2021-04-15 13:06:03.637898', '2021-04-15 13:06:03.637898', NULL),
	(10007786, 5, 'PW21A-JK100140OL-L', 2, 0, '2021-04-15 13:06:03.671163', '2021-04-15 13:06:03.671163', NULL),
	(10007787, 5, 'PW21A-JK100140OL-XL', 2, 0, '2021-04-15 13:06:03.659087', '2021-04-15 13:06:03.659087', NULL),
	(10007788, 5, 'PW21A-JK100140OL-XXL', 1, 0, '2021-04-15 13:06:03.714274', '2021-04-15 13:06:03.714274', NULL),
	(10007789, 5, 'PW21A-JK100141BL-XS', 0, 0, '2021-04-15 13:06:03.697576', '2021-04-15 13:06:03.697576', NULL),
	(10007790, 5, 'PW21A-JK100141BL-S', 0, 0, '2021-04-15 13:06:03.698811', '2021-04-15 13:06:03.698811', NULL),
	(10007791, 5, 'PW21A-JK100141BL-M', 1, 0, '2021-04-15 13:06:03.701515', '2021-04-15 13:06:03.701515', NULL),
	(10007792, 5, 'PW21A-JK100141BL-L', 2, 0, '2021-04-15 13:06:03.721501', '2021-04-15 13:06:03.721501', NULL),
	(10007793, 5, 'PW21A-JK100141BL-XL', 2, 0, '2021-04-15 13:06:03.708943', '2021-04-15 13:06:03.708943', NULL),
	(10007794, 5, 'PW21A-JK100141BL-XXL', 0, 0, '2021-04-15 13:06:03.737777', '2021-04-15 13:06:03.737777', NULL),
	(10007795, 5, 'PW21A-JK100142OL-XS', 0, 0, '2021-04-15 13:06:03.708410', '2021-04-15 13:06:03.708410', NULL),
	(10007796, 5, 'PW21A-JK100142OL-S', 2, 0, '2021-04-15 13:06:03.710181', '2021-04-15 13:06:03.710181', NULL),
	(10007797, 5, 'PW21A-JK100142OL-M', 2, 0, '2021-04-15 13:06:03.721602', '2021-04-15 13:06:03.721602', NULL),
	(10007798, 5, 'PW21A-JK100142OL-L', 2, 0, '2021-04-15 13:06:03.743156', '2021-04-15 13:06:03.743156', NULL),
	(10007799, 5, 'PW21A-JK100142OL-XL', 2, 0, '2021-04-15 13:06:03.739003', '2021-04-15 13:06:03.739003', NULL),
	(10007800, 5, 'PW21A-JK100142OL-XXL', 0, 0, '2021-04-15 13:06:03.769168', '2021-04-15 13:06:03.769168', NULL),
	(10007801, 5, 'PW21A-JK100143BL-XS', 0, 0, '2021-04-15 13:06:03.840359', '2021-04-15 13:06:03.840359', NULL),
	(10007802, 5, 'PW21A-JK100143BL-S', 2, 0, '2021-04-15 13:06:03.741419', '2021-04-15 13:06:03.741419', NULL),
	(10007803, 5, 'PW21A-JK100143BL-M', 2, 0, '2021-04-15 13:06:03.752714', '2021-04-15 13:06:03.752714', NULL),
	(10007804, 5, 'PW21A-JK100143BL-L', 2, 0, '2021-04-15 13:06:03.797101', '2021-04-15 13:06:03.797101', NULL),
	(10007805, 5, 'PW21A-JK100143BL-XL', 1, 0, '2021-04-15 13:06:03.779190', '2021-04-15 13:06:03.779190', NULL),
	(10007806, 5, 'PW21A-JK100143BL-XXL', 0, 0, '2021-04-15 13:06:03.746781', '2021-04-15 13:06:03.746781', NULL),
	(10007807, 5, 'PW21A-JK100144AR-XS', 0, 0, '2021-04-15 13:06:03.766797', '2021-04-15 13:06:03.766797', NULL),
	(10007808, 5, 'PW21A-JK100144AR-S', 3, 0, '2021-04-15 13:06:03.755819', '2021-04-15 13:06:03.755819', NULL),
	(10007809, 5, 'PW21A-JK100144AR-M', 3, 0, '2021-04-15 13:06:03.772966', '2021-04-15 13:06:03.772966', NULL),
	(10007810, 5, 'PW21A-JK100144AR-L', 3, 0, '2021-04-15 13:06:03.803136', '2021-04-15 13:06:03.803136', NULL),
	(10007811, 5, 'PW21A-JK100144AR-XL', 2, 0, '2021-04-15 13:06:03.757245', '2021-04-15 13:06:03.757245', NULL),
	(10007812, 5, 'PW21A-JK100144AR-XXL', 1, 0, '2021-04-15 13:06:03.774578', '2021-04-15 13:06:03.774578', NULL),
	(10007813, 5, 'PW21A-JK100145RD-XS', 0, 0, '2021-04-15 13:06:03.781030', '2021-04-15 13:06:03.781030', NULL),
	(10007814, 5, 'PW21A-JK100145RD-S', 0, 0, '2021-04-15 13:06:03.805010', '2021-04-15 13:06:03.805010', NULL),
	(10007815, 5, 'PW21A-JK100145RD-M', 2, 0, '2021-04-15 13:06:03.815706', '2021-04-15 13:06:03.815706', NULL),
	(10007816, 5, 'PW21A-JK100145RD-L', 2, 0, '2021-04-15 13:06:03.789729', '2021-04-15 13:06:03.789729', NULL),
	(10007817, 5, 'PW21A-JK100145RD-XL', 2, 0, '2021-04-15 13:06:03.892775', '2021-04-15 13:06:03.892775', NULL),
	(10007818, 5, 'PW21A-JK100145RD-XXL', 1, 0, '2021-04-15 13:06:03.817800', '2021-04-15 13:06:03.817800', NULL),
	(10007819, 5, 'PW21A-JK100146BL-XS', 0, 0, '2021-04-15 13:06:03.874839', '2021-04-15 13:06:03.874839', NULL),
	(10007820, 5, 'PW21A-JK100146BL-S', 2, 0, '2021-04-15 13:06:03.880845', '2021-04-15 13:06:03.880845', NULL),
	(10007821, 5, 'PW21A-JK100146BL-M', 2, 0, '2021-04-15 13:06:03.890357', '2021-04-15 13:06:03.890357', NULL),
	(10007822, 5, 'PW21A-JK100146BL-L', 2, 0, '2021-04-15 13:06:03.821166', '2021-04-15 13:06:03.821166', NULL),
	(10007823, 5, 'PW21A-JK100146BL-XL', 2, 0, '2021-04-15 13:06:03.828647', '2021-04-15 13:06:03.828647', NULL),
	(10007824, 5, 'PW21A-JK100146BL-XXL', 1, 0, '2021-04-15 13:06:03.825929', '2021-04-15 13:06:03.825929', NULL),
	(10007825, 5, 'PW21A-JK100147BL-XS', 0, 0, '2021-04-15 13:06:03.902641', '2021-04-15 13:06:03.902641', NULL),
	(10007826, 5, 'PW21A-JK100147BL-S', 2, 0, '2021-04-15 13:06:03.841059', '2021-04-15 13:06:03.841059', NULL),
	(10007827, 5, 'PW21A-JK100147BL-M', 2, 0, '2021-04-15 13:06:03.858775', '2021-04-15 13:06:03.858775', NULL),
	(10007828, 5, 'PW21A-JK100147BL-L', 2, 0, '2021-04-15 13:06:03.890984', '2021-04-15 13:06:03.890984', NULL),
	(10007829, 5, 'PW21A-JK100147BL-XL', 2, 0, '2021-04-15 13:06:03.895270', '2021-04-15 13:06:03.895270', NULL),
	(10007830, 5, 'PW21A-JK100147BL-XXL', 1, 0, '2021-04-15 13:06:04.021955', '2021-04-15 13:06:04.021955', NULL),
	(10007831, 5, 'PW21A-JK100148BL-XS', 0, 0, '2021-04-15 13:06:03.965212', '2021-04-15 13:06:03.965212', NULL),
	(10007832, 5, 'PW21A-JK100148BL-S', 3, 0, '2021-04-15 13:06:03.990930', '2021-04-15 13:06:03.990930', NULL),
	(10007833, 5, 'PW21A-JK100148BL-M', 2, 0, '2021-04-15 13:06:03.924645', '2021-04-15 13:06:03.924645', NULL),
	(10007834, 5, 'PW21A-JK100148BL-L', 3, 0, '2021-04-15 13:06:03.942677', '2021-04-15 13:06:03.942677', NULL),
	(10007835, 5, 'PW21A-JK100148BL-XL', 2, 0, '2021-04-15 13:06:03.904432', '2021-04-15 13:06:03.904432', NULL),
	(10007836, 5, 'PW21A-JK100148BL-XXL', 1, 0, '2021-04-15 13:06:03.900072', '2021-04-15 13:06:03.900072', NULL),
	(10007837, 5, 'PW21A-JK100149BL-XS', 0, 0, '2021-04-15 13:06:03.939519', '2021-04-15 13:06:03.939519', NULL),
	(10007838, 5, 'PW21A-JK100149BL-S', 2, 0, '2021-04-15 13:06:04.020008', '2021-04-15 13:06:04.020008', NULL),
	(10007839, 5, 'PW21A-JK100149BL-M', 2, 0, '2021-04-15 13:06:03.955920', '2021-04-15 13:06:03.955920', NULL),
	(10007840, 5, 'PW21A-JK100149BL-L', 2, 0, '2021-04-15 13:06:03.955048', '2021-04-15 13:06:03.955048', NULL),
	(10007841, 5, 'PW21A-JK100149BL-XL', 2, 0, '2021-04-15 13:06:03.958758', '2021-04-15 13:06:03.958758', NULL),
	(10007842, 5, 'PW21A-JK100149BL-XXL', 1, 0, '2021-04-15 13:06:04.033912', '2021-04-15 13:06:04.033912', NULL),
	(10007843, 5, 'PW21A-JK100150BL-XS', 0, 0, '2021-04-15 13:06:03.982329', '2021-04-15 13:06:03.982329', NULL),
	(10007844, 5, 'PW21A-JK100150BL-S', 2, 0, '2021-04-15 13:06:04.004697', '2021-04-15 13:06:04.004697', NULL),
	(10007845, 5, 'PW21A-JK100150BL-M', 2, 0, '2021-04-15 13:06:03.985717', '2021-04-15 13:06:03.985717', NULL),
	(10007846, 5, 'PW21A-JK100150BL-L', 2, 0, '2021-04-15 13:06:03.990354', '2021-04-15 13:06:03.990354', NULL),
	(10007847, 5, 'PW21A-JK100150BL-XL', 2, 0, '2021-04-15 13:06:04.005300', '2021-04-15 13:06:04.005300', NULL),
	(10007848, 5, 'PW21A-JK100150BL-XXL', 1, 0, '2021-04-15 13:06:04.016415', '2021-04-15 13:06:04.016415', NULL),
	(10007849, 5, 'PW21A-JK100151BL-XS', 0, 0, '2021-04-15 13:06:04.021602', '2021-04-15 13:06:04.021602', NULL),
	(10007850, 5, 'PW21A-JK100151BL-S', 2, 0, '2021-04-15 13:06:04.038639', '2021-04-15 13:06:04.038639', NULL),
	(10007851, 5, 'PW21A-JK100151BL-M', 2, 0, '2021-04-15 13:06:04.081105', '2021-04-15 13:06:04.081105', NULL),
	(10007852, 5, 'PW21A-JK100151BL-L', 2, 0, '2021-04-15 13:06:04.056091', '2021-04-15 13:06:04.056091', NULL),
	(10007853, 5, 'PW21A-JK100151BL-XL', 2, 0, '2021-04-15 13:06:04.058301', '2021-04-15 13:06:04.058301', NULL),
	(10007854, 5, 'PW21A-JK100151BL-XXL', 1, 0, '2021-04-15 13:06:04.031819', '2021-04-15 13:06:04.031819', NULL),
	(10007855, 5, 'PW21A-JK100152BL-XS', 0, 0, '2021-04-15 13:06:04.055559', '2021-04-15 13:06:04.055559', NULL),
	(10007856, 5, 'PW21A-JK100152BL-S', 2, 0, '2021-04-15 13:06:04.039232', '2021-04-15 13:06:04.039232', NULL),
	(10007857, 5, 'PW21A-JK100152BL-M', 2, 0, '2021-04-15 13:06:04.152855', '2021-04-15 13:06:04.152855', NULL),
	(10007858, 5, 'PW21A-JK100152BL-L', 2, 0, '2021-04-15 13:06:04.085524', '2021-04-15 13:06:04.085524', NULL),
	(10007859, 5, 'PW21A-JK100152BL-XL', 2, 0, '2021-04-15 13:06:04.057732', '2021-04-15 13:06:04.057732', NULL),
	(10007860, 5, 'PW21A-JK100152BL-XXL', 1, 0, '2021-04-15 13:06:04.088089', '2021-04-15 13:06:04.088089', NULL),
	(10007861, 5, 'PW21A-JK100153GN-XS', 0, 0, '2021-04-15 13:06:04.073451', '2021-04-15 13:06:04.073451', NULL),
	(10007862, 5, 'PW21A-JK100153GN-S', 2, 0, '2021-04-15 13:06:04.065118', '2021-04-15 13:06:04.065118', NULL),
	(10007863, 5, 'PW21A-JK100153GN-M', 2, 0, '2021-04-15 13:06:04.174869', '2021-04-15 13:06:04.174869', NULL),
	(10007864, 5, 'PW21A-JK100153GN-L', 2, 0, '2021-04-15 13:06:04.112407', '2021-04-15 13:06:04.112407', NULL),
	(10007865, 5, 'PW21A-JK100153GN-XL', 2, 0, '2021-04-15 13:06:04.084006', '2021-04-15 13:06:04.084006', NULL),
	(10007866, 5, 'PW21A-JK100153GN-XXL', 1, 0, '2021-04-15 13:06:04.105978', '2021-04-15 13:06:04.105978', NULL),
	(10007867, 5, 'PW21A-JD100154BL-XS', 0, 0, '2021-04-15 13:06:04.116533', '2021-04-15 13:06:04.116533', NULL),
	(10007868, 5, 'PW21A-JD100154BL-S', 0, 0, '2021-04-15 13:06:04.114651', '2021-04-15 13:06:04.114651', NULL),
	(10007869, 5, 'PW21A-JD100154BL-M', 0, 0, '2021-04-15 13:06:04.114158', '2021-04-15 13:06:04.114158', NULL),
	(10007870, 5, 'PW21A-JD100154BL-L', 0, 0, '2021-04-15 13:06:04.130665', '2021-04-15 13:06:04.130665', NULL),
	(10007871, 5, 'PW21A-JD100154BL-XL', 0, 0, '2021-04-15 13:06:04.131065', '2021-04-15 13:06:04.131065', NULL),
	(10007872, 5, 'PW21A-JD100154BL-XXL', 0, 0, '2021-04-15 13:06:04.133708', '2021-04-15 13:06:04.133708', NULL),
	(10007873, 5, 'PW21A-JK100155OL-XS', 0, 0, '2021-04-15 13:06:04.122976', '2021-04-15 13:06:04.122976', NULL),
	(10007874, 5, 'PW21A-JK100155OL-S', 0, 0, '2021-04-15 13:06:04.132127', '2021-04-15 13:06:04.132127', NULL),
	(10007875, 5, 'PW21A-JK100155OL-M', 0, 0, '2021-04-15 13:06:04.148297', '2021-04-15 13:06:04.148297', NULL),
	(10007876, 5, 'PW21A-JK100155OL-L', 0, 0, '2021-04-15 13:06:04.197284', '2021-04-15 13:06:04.197284', NULL),
	(10007877, 5, 'PW21A-JK100155OL-XL', 0, 0, '2021-04-15 13:06:04.152001', '2021-04-15 13:06:04.152001', NULL),
	(10007878, 5, 'PW21A-JK100155OL-XXL', 0, 0, '2021-04-15 13:06:04.231581', '2021-04-15 13:06:04.231581', NULL),
	(10007879, 5, 'PW21A-JK100156YW -XS', 0, 0, '2021-04-15 13:06:04.181566', '2021-04-15 13:06:04.181566', NULL),
	(10007880, 5, 'PW21A-JK100156YW -S', 0, 0, '2021-04-15 13:06:04.181973', '2021-04-15 13:06:04.181973', NULL),
	(10007881, 5, 'PW21A-JK100156YW -M', 0, 0, '2021-04-15 13:06:04.164855', '2021-04-15 13:06:04.164855', NULL),
	(10007882, 5, 'PW21A-JK100156YW -L', 0, 0, '2021-04-15 13:06:04.155381', '2021-04-15 13:06:04.155381', NULL),
	(10007883, 5, 'PW21A-JK100156YW -XL', 0, 0, '2021-04-15 13:06:04.155889', '2021-04-15 13:06:04.155889', NULL),
	(10007884, 5, 'PW21A-JK100156YW -XXL', 0, 0, '2021-04-15 13:06:04.203784', '2021-04-15 13:06:04.203784', NULL),
	(10007885, 5, 'PW21A-JK100157BL-XS', 0, 0, '2021-04-15 13:06:04.189454', '2021-04-15 13:06:04.189454', NULL),
	(10007886, 5, 'PW21A-JK100157BL-S', 2, 0, '2021-04-15 13:06:04.175761', '2021-04-15 13:06:04.175761', NULL),
	(10007887, 5, 'PW21A-JK100157BL-M', 2, 0, '2021-04-15 13:06:04.211097', '2021-04-15 13:06:04.211097', NULL),
	(10007888, 5, 'PW21A-JK100157BL-L', 2, 0, '2021-04-15 13:06:04.213536', '2021-04-15 13:06:04.213536', NULL),
	(10007889, 5, 'PW21A-JK100157BL-XL', 2, 0, '2021-04-15 13:06:04.194136', '2021-04-15 13:06:04.194136', NULL),
	(10007890, 5, 'PW21A-JK100157BL-XXL', 1, 0, '2021-04-15 13:06:04.202932', '2021-04-15 13:06:04.202932', NULL),
	(10007891, 5, 'PW21A-JK100158AR-XS', 0, 0, '2021-04-15 13:06:04.292270', '2021-04-15 13:06:04.292270', NULL),
	(10007892, 5, 'PW21A-JK100158AR-S', 0, 0, '2021-04-15 13:06:04.304916', '2021-04-15 13:06:04.304916', NULL),
	(10007893, 5, 'PW21A-JK100158AR-M', 0, 0, '2021-04-15 13:06:04.234266', '2021-04-15 13:06:04.234266', NULL),
	(10007894, 5, 'PW21A-JK100158AR-L', 0, 0, '2021-04-15 13:06:04.221082', '2021-04-15 13:06:04.221082', NULL),
	(10007895, 5, 'PW21A-JK100158AR-XL', 0, 0, '2021-04-15 13:06:04.217034', '2021-04-15 13:06:04.217034', NULL),
	(10007896, 5, 'PW21A-JK100158AR-XXL', 0, 0, '2021-04-15 13:06:04.322707', '2021-04-15 13:06:04.322707', NULL),
	(10007897, 5, 'PW21A-JD100159MR-XS', 0, 0, '2021-04-15 13:06:04.292884', '2021-04-15 13:06:04.292884', NULL),
	(10007898, 5, 'PW21A-JD100159MR-S', 0, 0, '2021-04-15 13:06:04.253917', '2021-04-15 13:06:04.253917', NULL),
	(10007899, 5, 'PW21A-JD100159MR-M', 0, 0, '2021-04-15 13:06:04.243828', '2021-04-15 13:06:04.243828', NULL),
	(10007900, 5, 'PW21A-JD100159MR-L', 0, 0, '2021-04-15 13:06:04.252389', '2021-04-15 13:06:04.252389', NULL),
	(10007901, 5, 'PW21A-JD100159MR-XL', 0, 0, '2021-04-15 13:06:04.260682', '2021-04-15 13:06:04.260682', NULL),
	(10007902, 5, 'PW21A-JD100159MR-XXL', 0, 0, '2021-04-15 13:06:04.362256', '2021-04-15 13:06:04.362256', NULL),
	(10007903, 5, 'PW21A-JK100160TC-XS', 0, 0, '2021-04-15 13:06:04.261925', '2021-04-15 13:06:04.261925', NULL),
	(10007904, 5, 'PW21A-JK100160TC-S', 0, 0, '2021-04-15 13:06:04.384925', '2021-04-15 13:06:04.384925', NULL),
	(10007905, 5, 'PW21A-JK100160TC-M', 0, 0, '2021-04-15 13:06:04.291373', '2021-04-15 13:06:04.291373', NULL),
	(10007906, 5, 'PW21A-JK100160TC-L', 0, 0, '2021-04-15 13:06:04.337063', '2021-04-15 13:06:04.337063', NULL),
	(10007907, 5, 'PW21A-JK100160TC-XL', 0, 0, '2021-04-15 13:06:04.339899', '2021-04-15 13:06:04.339899', NULL),
	(10007908, 5, 'PW21A-JK100160TC-XXL', 0, 0, '2021-04-15 13:06:04.307753', '2021-04-15 13:06:04.307753', NULL),
	(10007909, 5, 'PW21A-JK100161BL-XS', 0, 0, '2021-04-15 13:06:04.330875', '2021-04-15 13:06:04.330875', NULL),
	(10007910, 5, 'PW21A-JK100161BL-S', 2, 0, '2021-04-15 13:06:04.493923', '2021-04-15 13:06:04.493923', NULL),
	(10007911, 5, 'PW21A-JK100161BL-M', 2, 0, '2021-04-15 13:06:04.376066', '2021-04-15 13:06:04.376066', NULL),
	(10007912, 5, 'PW21A-JK100161BL-L', 2, 0, '2021-04-15 13:06:04.331949', '2021-04-15 13:06:04.331949', NULL),
	(10007913, 5, 'PW21A-JK100161BL-XL', 2, 0, '2021-04-15 13:06:04.370049', '2021-04-15 13:06:04.370049', NULL),
	(10007914, 5, 'PW21A-JK100161BL-XXL', 1, 0, '2021-04-15 13:06:04.477980', '2021-04-15 13:06:04.477980', NULL),
	(10007915, 5, 'PW21A-JD100162BL-XS', 0, 0, '2021-04-15 13:06:04.379824', '2021-04-15 13:06:04.379824', NULL),
	(10007916, 5, 'PW21A-JD100162BL-S', 0, 0, '2021-04-15 13:06:04.391732', '2021-04-15 13:06:04.391732', NULL),
	(10007917, 5, 'PW21A-JD100162BL-M', 0, 0, '2021-04-15 13:06:04.420749', '2021-04-15 13:06:04.420749', NULL),
	(10007918, 5, 'PW21A-JD100162BL-L', 0, 0, '2021-04-15 13:06:04.505388', '2021-04-15 13:06:04.505388', NULL),
	(10007919, 5, 'PW21A-JD100162BL-XL', 0, 0, '2021-04-15 13:06:04.416283', '2021-04-15 13:06:04.416283', NULL),
	(10007920, 5, 'PW21A-JD100162BL-XXL', 0, 0, '2021-04-15 13:06:04.441880', '2021-04-15 13:06:04.441880', NULL),
	(10007921, 5, 'PW21A-JK100163RD-XS', 2, 0, '2021-04-15 13:06:04.438044', '2021-04-15 13:06:04.438044', NULL),
	(10007922, 5, 'PW21A-JK100163RD-S', 2, 0, '2021-04-15 13:06:04.475019', '2021-04-15 13:06:04.475019', NULL),
	(10007923, 5, 'PW21A-JK100163RD-M', 2, 0, '2021-04-15 13:06:04.491847', '2021-04-15 13:06:04.491847', NULL),
	(10007924, 5, 'PW21A-JK100163RD-L', 1, 0, '2021-04-15 13:06:04.460457', '2021-04-15 13:06:04.460457', NULL),
	(10007925, 5, 'PW21A-JK100163RD-XL', 2, 0, '2021-04-15 13:06:04.488744', '2021-04-15 13:06:04.488744', NULL),
	(10007926, 5, 'PW21A-JK100163RD-XXL', 1, 0, '2021-04-15 13:06:04.484417', '2021-04-15 13:06:04.484417', NULL),
	(10007927, 5, 'PW21A-JD100164BL-XS', 0, 0, '2021-04-15 13:06:04.502795', '2021-04-15 13:06:04.502795', NULL),
	(10007928, 5, 'PW21A-JD100164BL-S', 0, 0, '2021-04-15 13:06:04.504241', '2021-04-15 13:06:04.504241', NULL),
	(10007929, 5, 'PW21A-JD100164BL-M', 0, 0, '2021-04-15 13:06:04.509985', '2021-04-15 13:06:04.509985', NULL),
	(10007930, 5, 'PW21A-JD100164BL-L', 0, 0, '2021-04-15 13:06:04.508177', '2021-04-15 13:06:04.508177', NULL),
	(10007931, 5, 'PW21A-JD100164BL-XL', 0, 0, '2021-04-15 13:06:04.526503', '2021-04-15 13:06:04.526503', NULL),
	(10007932, 5, 'PW21A-JD100164BL-XXL', 0, 0, '2021-04-15 13:06:04.512136', '2021-04-15 13:06:04.512136', NULL),
	(10007933, 5, 'PW21A-JK100165NV-XS', 0, 0, '2021-04-15 13:06:04.518514', '2021-04-15 13:06:04.518514', NULL),
	(10007934, 5, 'PW21A-JK100165NV-S', 0, 0, '2021-04-15 13:06:04.559772', '2021-04-15 13:06:04.559772', NULL),
	(10007935, 5, 'PW21A-JK100165NV-M', 0, 0, '2021-04-15 13:06:04.536128', '2021-04-15 13:06:04.536128', NULL),
	(10007936, 5, 'PW21A-JK100165NV-L', 0, 0, '2021-04-15 13:06:04.514822', '2021-04-15 13:06:04.514822', NULL),
	(10007937, 5, 'PW21A-JK100165NV-XL', 0, 0, '2021-04-15 13:06:04.518872', '2021-04-15 13:06:04.518872', NULL),
	(10007938, 5, 'PW21A-JK100165NV-XXL', 0, 0, '2021-04-15 13:06:04.516495', '2021-04-15 13:06:04.516495', NULL),
	(10007939, 5, 'PW21A-JK100166MR-XS', 0, 0, '2021-04-15 13:06:04.535612', '2021-04-15 13:06:04.535612', NULL),
	(10007940, 5, 'PW21A-JK100166MR-S', 0, 0, '2021-04-15 13:06:04.526058', '2021-04-15 13:06:04.526058', NULL),
	(10007941, 5, 'PW21A-JK100166MR-M', 0, 0, '2021-04-15 13:06:04.541245', '2021-04-15 13:06:04.541245', NULL),
	(10007942, 5, 'PW21A-JK100166MR-L', 0, 0, '2021-04-15 13:06:04.565581', '2021-04-15 13:06:04.565581', NULL),
	(10007943, 5, 'PW21A-JK100166MR-XL', 0, 0, '2021-04-15 13:06:04.540518', '2021-04-15 13:06:04.540518', NULL),
	(10007944, 5, 'PW21A-JK100166MR-XXL', 0, 0, '2021-04-15 13:06:04.552940', '2021-04-15 13:06:04.552940', NULL),
	(10007945, 5, 'PW21A-JK100167WT-XS', 0, 0, '2021-04-15 13:06:04.552269', '2021-04-15 13:06:04.552269', NULL),
	(10007946, 5, 'PW21A-JK100167WT-S', 2, 0, '2021-04-15 13:06:04.592391', '2021-04-15 13:06:04.592391', NULL),
	(10007947, 5, 'PW21A-JK100167WT-M', 2, 0, '2021-04-15 13:06:04.554444', '2021-04-15 13:06:04.554444', NULL),
	(10007948, 5, 'PW21A-JK100167WT-L', 2, 0, '2021-04-15 13:06:04.590589', '2021-04-15 13:06:04.590589', NULL),
	(10007949, 5, 'PW21A-JK100167WT-XL', 2, 0, '2021-04-15 13:06:04.579176', '2021-04-15 13:06:04.579176', NULL),
	(10007950, 5, 'PW21A-JK100167WT-XXL', 1, 0, '2021-04-15 13:06:04.570674', '2021-04-15 13:06:04.570674', NULL),
	(10007951, 5, 'PW21A-JK100168BL-XS', 0, 0, '2021-04-15 13:06:04.573176', '2021-04-15 13:06:04.573176', NULL),
	(10007952, 5, 'PW21A-JK100168BL-S', 2, 0, '2021-04-15 13:06:04.619046', '2021-04-15 13:06:04.619046', NULL),
	(10007953, 5, 'PW21A-JK100168BL-M', 2, 0, '2021-04-15 13:06:04.566060', '2021-04-15 13:06:04.566060', NULL),
	(10007954, 5, 'PW21A-JK100168BL-L', 2, 0, '2021-04-15 13:06:04.590984', '2021-04-15 13:06:04.590984', NULL),
	(10007955, 5, 'PW21A-JK100168BL-XL', 2, 0, '2021-04-15 13:06:04.602898', '2021-04-15 13:06:04.602898', NULL),
	(10007956, 5, 'PW21A-JK100168BL-XXL', 1, 0, '2021-04-15 13:06:04.582644', '2021-04-15 13:06:04.582644', NULL),
	(10007957, 5, 'PW21A-JK100169BL-XS', 0, 0, '2021-04-15 13:06:04.597017', '2021-04-15 13:06:04.597017', NULL),
	(10007958, 5, 'PW21A-JK100169BL-S', 0, 0, '2021-04-15 13:06:04.647930', '2021-04-15 13:06:04.647930', NULL),
	(10007959, 5, 'PW21A-JK100169BL-M', 0, 0, '2021-04-15 13:06:04.597403', '2021-04-15 13:06:04.597403', NULL),
	(10007960, 5, 'PW21A-JK100169BL-L', 0, 0, '2021-04-15 13:06:04.602574', '2021-04-15 13:06:04.602574', NULL),
	(10007961, 5, 'PW21A-JK100169BL-XL', 0, 0, '2021-04-15 13:06:04.597856', '2021-04-15 13:06:04.597856', NULL),
	(10007962, 5, 'PW21A-JK100169BL-XXL', 0, 0, '2021-04-15 13:06:04.609192', '2021-04-15 13:06:04.609192', NULL),
	(10007963, 5, 'PW21A-JK100170RD-XS', 0, 0, '2021-04-15 13:06:04.625291', '2021-04-15 13:06:04.625291', NULL),
	(10007964, 5, 'PW21A-JK100170RD-S', 0, 0, '2021-04-15 13:06:04.600606', '2021-04-15 13:06:04.600606', NULL),
	(10007965, 5, 'PW21A-JK100170RD-M', 0, 0, '2021-04-15 13:06:04.618391', '2021-04-15 13:06:04.618391', NULL),
	(10007966, 5, 'PW21A-JK100170RD-L', 0, 0, '2021-04-15 13:06:04.633804', '2021-04-15 13:06:04.633804', NULL),
	(10007967, 5, 'PW21A-JK100170RD-XL', 0, 0, '2021-04-15 13:06:04.653171', '2021-04-15 13:06:04.653171', NULL),
	(10007968, 5, 'PW21A-JK100170RD-XXL', 0, 0, '2021-04-15 13:06:04.625721', '2021-04-15 13:06:04.625721', NULL),
	(10007969, 5, 'PW21A-JK100171WT-XS', 0, 0, '2021-04-15 13:06:04.621886', '2021-04-15 13:06:04.621886', NULL),
	(10007970, 5, 'PW21A-JK100171WT-S', 0, 0, '2021-04-15 13:06:04.659725', '2021-04-15 13:06:04.659725', NULL),
	(10007971, 5, 'PW21A-JK100171WT-M', 0, 0, '2021-04-15 13:06:04.626170', '2021-04-15 13:06:04.626170', NULL),
	(10007972, 5, 'PW21A-JK100171WT-L', 0, 0, '2021-04-15 13:06:04.639048', '2021-04-15 13:06:04.639048', NULL),
	(10007973, 5, 'PW21A-JK100171WT-XL', 0, 0, '2021-04-15 13:06:04.629952', '2021-04-15 13:06:04.629952', NULL),
	(10007974, 5, 'PW21A-JK100171WT-XXL', 0, 0, '2021-04-15 13:06:04.649801', '2021-04-15 13:06:04.649801', NULL),
	(10007975, 5, 'PW21A-JK100172BL-XS', 0, 0, '2021-04-15 13:06:04.632924', '2021-04-15 13:06:04.632924', NULL),
	(10007976, 5, 'PW21A-JK100172BL-S', 2, 0, '2021-04-15 13:06:04.651656', '2021-04-15 13:06:04.651656', NULL),
	(10007977, 5, 'PW21A-JK100172BL-M', 2, 0, '2021-04-15 13:06:04.647468', '2021-04-15 13:06:04.647468', NULL),
	(10007978, 5, 'PW21A-JK100172BL-L', 2, 0, '2021-04-15 13:06:04.688437', '2021-04-15 13:06:04.688437', NULL),
	(10007979, 5, 'PW21A-JK100172BL-XL', 2, 0, '2021-04-15 13:06:04.653482', '2021-04-15 13:06:04.653482', NULL),
	(10007980, 5, 'PW21A-JK100172BL-XXL', 1, 0, '2021-04-15 13:06:04.656196', '2021-04-15 13:06:04.656196', NULL),
	(10007981, 5, 'PW21A-TS100173BL-XS', 0, 0, '2021-04-15 13:06:04.658585', '2021-04-15 13:06:04.658585', NULL),
	(10007982, 5, 'PW21A-TS100173BL-M', 0, 0, '2021-04-15 13:06:04.662436', '2021-04-15 13:06:04.662436', NULL),
	(10007983, 5, 'PW21A-TS100173BL-L', 0, 0, '2021-04-15 13:06:04.679540', '2021-04-15 13:06:04.679540', NULL),
	(10007984, 5, 'PW21A-TS100173BL-XL', 0, 0, '2021-04-15 13:06:04.669449', '2021-04-15 13:06:04.669449', NULL),
	(10007985, 5, 'PW21A-TS100173BL-XXL', 0, 0, '2021-04-15 13:06:04.675156', '2021-04-15 13:06:04.675156', NULL),
	(10007986, 5, 'PW21A-TS100174NV-XS', 0, 0, '2021-04-15 13:06:04.676203', '2021-04-15 13:06:04.676203', NULL),
	(10007987, 5, 'PW21A-TS100174NV-S', 0, 0, '2021-04-15 13:06:04.669079', '2021-04-15 13:06:04.669079', NULL),
	(10007988, 5, 'PW21A-TS100174NV-M', 0, 0, '2021-04-15 13:06:04.678346', '2021-04-15 13:06:04.678346', NULL),
	(10007989, 5, 'PW21A-TS100174NV-L', 0, 0, '2021-04-15 13:06:04.692381', '2021-04-15 13:06:04.692381', NULL),
	(10007990, 5, 'PW21A-TS100174NV-XL', 0, 0, '2021-04-15 13:06:04.702361', '2021-04-15 13:06:04.702361', NULL),
	(10007991, 5, 'PW21A-TS100174NV-XXL', 0, 0, '2021-04-15 13:06:04.700951', '2021-04-15 13:06:04.700951', NULL),
	(10007992, 5, 'PW21A-TS100175BL-XS', 0, 0, '2021-04-15 13:06:04.713221', '2021-04-15 13:06:04.713221', NULL),
	(10007993, 5, 'PW21A-TS100175BL-S', 0, 0, '2021-04-15 13:06:04.703135', '2021-04-15 13:06:04.703135', NULL),
	(10007994, 5, 'PW21A-TS100175BL-M', 0, 0, '2021-04-15 13:06:04.687614', '2021-04-15 13:06:04.687614', NULL),
	(10007995, 5, 'PW21A-TS100175BL-L', 0, 0, '2021-04-15 13:06:04.690650', '2021-04-15 13:06:04.690650', NULL),
	(10007996, 5, 'PW21A-TS100175BL-XL', 0, 0, '2021-04-15 13:06:04.706093', '2021-04-15 13:06:04.706093', NULL),
	(10007997, 5, 'PW21A-TS100175BL-XXL', 0, 0, '2021-04-15 13:06:04.705741', '2021-04-15 13:06:04.705741', NULL),
	(10007998, 5, 'PW21A-TS100176BL-XS', 0, 0, '2021-04-15 13:06:04.739452', '2021-04-15 13:06:04.739452', NULL),
	(10007999, 5, 'PW21A-TS100176BL-S', 0, 0, '2021-04-15 13:06:04.713681', '2021-04-15 13:06:04.713681', NULL),
	(10008000, 5, 'PW21A-TS100176BL-M', 0, 0, '2021-04-15 13:06:04.797453', '2021-04-15 13:06:04.797453', NULL),
	(10008001, 5, 'PW21A-TS100176BL-L', 0, 0, '2021-04-15 13:06:04.704734', '2021-04-15 13:06:04.704734', NULL),
	(10008002, 5, 'PW21A-TS100176BL-XL', 0, 0, '2021-04-15 13:06:04.725479', '2021-04-15 13:06:04.725479', NULL),
	(10008003, 5, 'PW21A-TS100176BL-XXL', 0, 0, '2021-04-15 13:06:04.716565', '2021-04-15 13:06:04.716565', NULL),
	(10008004, 5, 'PW21A-TS100177BL-XS', 0, 0, '2021-04-15 13:06:04.752219', '2021-04-15 13:06:04.752219', NULL),
	(10008005, 5, 'PW21A-TS100177BL-S', 0, 0, '2021-04-15 13:06:04.736732', '2021-04-15 13:06:04.736732', NULL),
	(10008006, 5, 'PW21A-TS100177BL-M', 0, 0, '2021-04-15 13:06:04.717646', '2021-04-15 13:06:04.717646', NULL),
	(10008007, 5, 'PW21A-TS100177BL-L', 0, 0, '2021-04-15 13:06:04.735584', '2021-04-15 13:06:04.735584', NULL),
	(10008008, 5, 'PW21A-TS100177BL-XL', 0, 0, '2021-04-15 13:06:04.737971', '2021-04-15 13:06:04.737971', NULL),
	(10008009, 5, 'PW21A-TS100177BL-XXL', 0, 0, '2021-04-15 13:06:04.763938', '2021-04-15 13:06:04.763938', NULL),
	(10008010, 5, 'PW21A-TS100178BL-XS', 0, 0, '2021-04-15 13:06:04.741047', '2021-04-15 13:06:04.741047', NULL),
	(10008011, 5, 'PW21A-TS100178BL-S', 0, 0, '2021-04-15 13:06:04.765907', '2021-04-15 13:06:04.765907', NULL),
	(10008012, 5, 'PW21A-TS100178BL-M', 0, 0, '2021-04-15 13:06:04.751771', '2021-04-15 13:06:04.751771', NULL),
	(10008013, 5, 'PW21A-TS100178BL-L', 0, 0, '2021-04-15 13:06:04.768957', '2021-04-15 13:06:04.768957', NULL),
	(10008014, 5, 'PW21A-TS100178BL-XL', 0, 0, '2021-04-15 13:06:04.753850', '2021-04-15 13:06:04.753850', NULL),
	(10008015, 5, 'PW21A-TS100178BL-XXL', 0, 0, '2021-04-15 13:06:04.754506', '2021-04-15 13:06:04.754506', NULL),
	(10008016, 5, 'PW21A-TS100179BL-XS', 0, 0, '2021-04-15 13:06:04.764311', '2021-04-15 13:06:04.764311', NULL),
	(10008017, 5, 'PW21A-TS100179BL-S', 2, 0, '2021-04-15 13:06:04.786897', '2021-04-15 13:06:04.786897', NULL),
	(10008018, 5, 'PW21A-TS100179BL-M', 1, 0, '2021-04-15 13:06:04.808141', '2021-04-15 13:06:04.808141', NULL),
	(10008019, 5, 'PW21A-TS100179BL-L', 0, 0, '2021-04-15 13:06:04.795420', '2021-04-15 13:06:04.795420', NULL),
	(10008020, 5, 'PW21A-TS100179BL-XL', 0, 0, '2021-04-15 13:06:04.769540', '2021-04-15 13:06:04.769540', NULL),
	(10008021, 5, 'PW21A-TS100179BL-XXL', 0, 0, '2021-04-15 13:06:04.757721', '2021-04-15 13:06:04.757721', NULL),
	(10008022, 5, 'PW21A-TS100180BL-XS', 0, 0, '2021-04-15 13:06:04.801037', '2021-04-15 13:06:04.801037', NULL),
	(10008023, 5, 'PW21A-TS100180BL-S', 0, 0, '2021-04-15 13:06:04.810402', '2021-04-15 13:06:04.810402', NULL),
	(10008024, 5, 'PW21A-TS100180BL-M', 0, 0, '2021-04-15 13:06:04.870083', '2021-04-15 13:06:04.870083', NULL),
	(10008025, 5, 'PW21A-TS100180BL-L', 0, 0, '2021-04-15 13:06:04.785528', '2021-04-15 13:06:04.785528', NULL),
	(10008026, 5, 'PW21A-TS100180BL-XL', 0, 0, '2021-04-15 13:06:04.806739', '2021-04-15 13:06:04.806739', NULL),
	(10008027, 5, 'PW21A-TS100180BL-XXL', 0, 0, '2021-04-15 13:06:04.807692', '2021-04-15 13:06:04.807692', NULL),
	(10008028, 5, 'PW21A-TS100181BL-XS', 0, 0, '2021-04-15 13:06:04.824183', '2021-04-15 13:06:04.824183', NULL),
	(10008029, 5, 'PW21A-TS100181BL-S', 2, 0, '2021-04-15 13:06:04.810028', '2021-04-15 13:06:04.810028', NULL),
	(10008030, 5, 'PW21A-TS100181BL-M', 1, 0, '2021-04-15 13:06:04.858630', '2021-04-15 13:06:04.858630', NULL),
	(10008031, 5, 'PW21A-TS100181BL-L', 1, 0, '2021-04-15 13:06:04.820122', '2021-04-15 13:06:04.820122', NULL),
	(10008032, 5, 'PW21A-TS100181BL-XL', 0, 0, '2021-04-15 13:06:04.821013', '2021-04-15 13:06:04.821013', NULL),
	(10008033, 5, 'PW21A-TS100181BL-XXL', 2, 0, '2021-04-15 13:06:04.840948', '2021-04-15 13:06:04.840948', NULL),
	(10008034, 5, 'PW21A-TS100182BL-XS', 0, 0, '2021-04-15 13:06:04.821932', '2021-04-15 13:06:04.821932', NULL),
	(10008035, 5, 'PW21A-TS100182BL-S', 0, 0, '2021-04-15 13:06:04.841581', '2021-04-15 13:06:04.841581', NULL),
	(10008036, 5, 'PW21A-TS100182BL-M', 0, 0, '2021-04-15 13:06:04.828308', '2021-04-15 13:06:04.828308', NULL),
	(10008037, 5, 'PW21A-TS100182BL-L', 0, 0, '2021-04-15 13:06:04.845203', '2021-04-15 13:06:04.845203', NULL),
	(10008038, 5, 'PW21A-TS100182BL-XL', 0, 0, '2021-04-15 13:06:04.839963', '2021-04-15 13:06:04.839963', NULL),
	(10008039, 5, 'PW21A-TS100182BL-XXL', 0, 0, '2021-04-15 13:06:04.844636', '2021-04-15 13:06:04.844636', NULL),
	(10008040, 5, 'PW21A-TS100183BL-XS', 0, 0, '2021-04-15 13:06:04.881711', '2021-04-15 13:06:04.881711', NULL),
	(10008041, 5, 'PW21A-TS100183BL-S', 0, 0, '2021-04-15 13:06:04.850210', '2021-04-15 13:06:04.850210', NULL),
	(10008042, 5, 'PW21A-TS100183BL-M', 0, 0, '2021-04-15 13:06:04.865642', '2021-04-15 13:06:04.865642', NULL),
	(10008043, 5, 'PW21A-TS100183BL-L', 0, 0, '2021-04-15 13:06:04.856827', '2021-04-15 13:06:04.856827', NULL),
	(10008044, 5, 'PW21A-TS100183BL-XL', 0, 0, '2021-04-15 13:06:04.872296', '2021-04-15 13:06:04.872296', NULL),
	(10008045, 5, 'PW21A-TS100183BL-XXL', 0, 0, '2021-04-15 13:06:04.900595', '2021-04-15 13:06:04.900595', NULL),
	(10008046, 5, 'PW21A-TS100184BL-XS', 0, 0, '2021-04-15 13:06:04.861724', '2021-04-15 13:06:04.861724', NULL),
	(10008047, 5, 'PW21A-TS100184BL-S', 0, 0, '2021-04-15 13:06:04.877591', '2021-04-15 13:06:04.877591', NULL),
	(10008048, 5, 'PW21A-TS100184BL-M', 0, 0, '2021-04-15 13:06:04.873011', '2021-04-15 13:06:04.873011', NULL),
	(10008049, 5, 'PW21A-TS100184BL-L', 0, 0, '2021-04-15 13:06:04.887162', '2021-04-15 13:06:04.887162', NULL),
	(10008050, 5, 'PW21A-TS100184BL-XL', 0, 0, '2021-04-15 13:06:04.926594', '2021-04-15 13:06:04.926594', NULL),
	(10008051, 5, 'PW21A-TS100184BL-XXL', 0, 0, '2021-04-15 13:06:04.886810', '2021-04-15 13:06:04.886810', NULL),
	(10008052, 5, 'PW21A-TS100185BL-XS', 0, 0, '2021-04-15 13:06:04.878938', '2021-04-15 13:06:04.878938', NULL),
	(10008053, 5, 'PW21A-TS100185BL-S', 0, 0, '2021-04-15 13:06:04.930823', '2021-04-15 13:06:04.930823', NULL),
	(10008054, 5, 'PW21A-TS100185BL-M', 0, 0, '2021-04-15 13:06:04.914638', '2021-04-15 13:06:04.914638', NULL),
	(10008055, 5, 'PW21A-TS100185BL-L', 0, 0, '2021-04-15 13:06:04.886328', '2021-04-15 13:06:04.886328', NULL),
	(10008056, 5, 'PW21A-TS100185BL-XL', 0, 0, '2021-04-15 13:06:04.902576', '2021-04-15 13:06:04.902576', NULL),
	(10008057, 5, 'PW21A-TS100185BL-XXL', 0, 0, '2021-04-15 13:06:04.905683', '2021-04-15 13:06:04.905683', NULL),
	(10008058, 5, 'PW21A-TS100186BL-XS', 0, 0, '2021-04-15 13:06:04.893856', '2021-04-15 13:06:04.893856', NULL),
	(10008059, 5, 'PW21A-TS100186BL-S', 0, 0, '2021-04-15 13:06:04.898484', '2021-04-15 13:06:04.898484', NULL),
	(10008060, 5, 'PW21A-TS100186BL-M', 0, 0, '2021-04-15 13:06:04.906361', '2021-04-15 13:06:04.906361', NULL),
	(10008061, 5, 'PW21A-TS100186BL-L', 0, 0, '2021-04-15 13:06:04.929114', '2021-04-15 13:06:04.929114', NULL),
	(10008062, 5, 'PW21A-TS100186BL-XL', 0, 0, '2021-04-15 13:06:04.909032', '2021-04-15 13:06:04.909032', NULL),
	(10008063, 5, 'PW21A-TS100186BL-XXL', 0, 0, '2021-04-15 13:06:04.940019', '2021-04-15 13:06:04.940019', NULL),
	(10008064, 5, 'PW21A-TS100187BL-XS', 0, 0, '2021-04-15 13:06:04.931201', '2021-04-15 13:06:04.931201', NULL),
	(10008065, 5, 'PW21A-TS100187BL-S', 0, 0, '2021-04-15 13:06:04.918012', '2021-04-15 13:06:04.918012', NULL),
	(10008066, 5, 'PW21A-TS100187BL-M', 0, 0, '2021-04-15 13:06:04.932874', '2021-04-15 13:06:04.932874', NULL),
	(10008067, 5, 'PW21A-TS100187BL-L', 0, 0, '2021-04-15 13:06:04.918407', '2021-04-15 13:06:04.918407', NULL),
	(10008068, 5, 'PW21A-TS100187BL-XL', 0, 0, '2021-04-15 13:06:05.017193', '2021-04-15 13:06:05.017193', NULL),
	(10008069, 5, 'PW21A-TS100187BL-XXL', 0, 0, '2021-04-15 13:06:04.976075', '2021-04-15 13:06:04.976075', NULL),
	(10008070, 5, 'PW21A-TS100188BL-XS', 0, 0, '2021-04-15 13:06:04.951998', '2021-04-15 13:06:04.951998', NULL),
	(10008071, 5, 'PW21A-TS100188BL-S', 0, 0, '2021-04-15 13:06:04.935105', '2021-04-15 13:06:04.935105', NULL),
	(10008072, 5, 'PW21A-TS100188BL-M', 0, 0, '2021-04-15 13:06:04.952080', '2021-04-15 13:06:04.952080', NULL),
	(10008073, 5, 'PW21A-TS100188BL-L', 0, 0, '2021-04-15 13:06:04.954290', '2021-04-15 13:06:04.954290', NULL),
	(10008074, 5, 'PW21A-TS100188BL-XL', 0, 0, '2021-04-15 13:06:05.022549', '2021-04-15 13:06:05.022549', NULL),
	(10008075, 5, 'PW21A-TS100188BL-XXL', 0, 0, '2021-04-15 13:06:04.976485', '2021-04-15 13:06:04.976485', NULL),
	(10008076, 5, 'PW21A-TS100189BL-XS', 0, 0, '2021-04-15 13:06:04.962608', '2021-04-15 13:06:04.962608', NULL),
	(10008077, 5, 'PW21A-TS100189BL-S', 0, 0, '2021-04-15 13:06:04.963245', '2021-04-15 13:06:04.963245', NULL),
	(10008078, 5, 'PW21A-TS100189BL-M', 0, 0, '2021-04-15 13:06:04.973306', '2021-04-15 13:06:04.973306', NULL),
	(10008079, 5, 'PW21A-TS100189BL-L', 0, 0, '2021-04-15 13:06:04.987554', '2021-04-15 13:06:04.987554', NULL),
	(10008080, 5, 'PW21A-TS100189BL-XL', 0, 0, '2021-04-15 13:06:04.988062', '2021-04-15 13:06:04.988062', NULL),
	(10008081, 5, 'PW21A-TS100189BL-XXL', 0, 0, '2021-04-15 13:06:04.978907', '2021-04-15 13:06:04.978907', NULL),
	(10008082, 5, 'PW21A-TS100190WT-XS', 0, 0, '2021-04-15 13:06:05.009160', '2021-04-15 13:06:05.009160', NULL),
	(10008083, 5, 'PW21A-TS100190WT-S', 0, 0, '2021-04-15 13:06:04.992930', '2021-04-15 13:06:04.992930', NULL),
	(10008084, 5, 'PW21A-TS100190WT-M', 0, 0, '2021-04-15 13:06:04.997669', '2021-04-15 13:06:04.997669', NULL),
	(10008085, 5, 'PW21A-TS100190WT-L', 0, 0, '2021-04-15 13:06:04.988508', '2021-04-15 13:06:04.988508', NULL),
	(10008086, 5, 'PW21A-TS100190WT-XL', 0, 0, '2021-04-15 13:06:04.991110', '2021-04-15 13:06:04.991110', NULL),
	(10008087, 5, 'PW21A-TS100190WT-XXL', 0, 0, '2021-04-15 13:06:05.000111', '2021-04-15 13:06:05.000111', NULL),
	(10008088, 5, 'PW21A-TS100191YW -XS', 0, 0, '2021-04-15 13:06:05.006270', '2021-04-15 13:06:05.006270', NULL),
	(10008089, 5, 'PW21A-TS100191YW -S', 0, 0, '2021-04-15 13:06:05.053475', '2021-04-15 13:06:05.053475', NULL),
	(10008090, 5, 'PW21A-TS100191YW -M', 2, 0, '2021-04-15 13:06:05.019167', '2021-04-15 13:06:05.019167', NULL),
	(10008091, 5, 'PW21A-TS100191YW -L', 0, 0, '2021-04-15 13:06:05.003854', '2021-04-15 13:06:05.003854', NULL),
	(10008092, 5, 'PW21A-TS100191YW -XL', 0, 0, '2021-04-15 13:06:05.020050', '2021-04-15 13:06:05.020050', NULL),
	(10008093, 5, 'PW21A-TS100191YW -XXL', 2, 0, '2021-04-15 13:06:05.038390', '2021-04-15 13:06:05.038390', NULL),
	(10008094, 5, 'PW21A-TS100192GN-XS', 0, 0, '2021-04-15 13:06:05.019629', '2021-04-15 13:06:05.019629', NULL),
	(10008095, 5, 'PW21A-TS100192GN-S', 2, 0, '2021-04-15 13:06:05.044538', '2021-04-15 13:06:05.044538', NULL),
	(10008096, 5, 'PW21A-TS100192GN-M', 2, 0, '2021-04-15 13:06:05.078931', '2021-04-15 13:06:05.078931', NULL),
	(10008097, 5, 'PW21A-TS100192GN-L', 2, 0, '2021-04-15 13:06:05.025417', '2021-04-15 13:06:05.025417', NULL),
	(10008098, 5, 'PW21A-TS100192GN-XL', 2, 0, '2021-04-15 13:06:05.048601', '2021-04-15 13:06:05.048601', NULL),
	(10008099, 5, 'PW21A-TS100192GN-XXL', 2, 0, '2021-04-15 13:06:05.041263', '2021-04-15 13:06:05.041263', NULL),
	(10008100, 5, 'PW21A-TS100193BL-XS', 0, 0, '2021-04-15 13:06:05.026619', '2021-04-15 13:06:05.026619', NULL),
	(10008101, 5, 'PW21A-TS100193BL-S', 2, 0, '2021-04-15 13:06:05.054630', '2021-04-15 13:06:05.054630', NULL),
	(10008102, 5, 'PW21A-TS100193BL-M', 2, 0, '2021-04-15 13:06:05.054143', '2021-04-15 13:06:05.054143', NULL),
	(10008103, 5, 'PW21A-TS100193BL-L', 2, 0, '2021-04-15 13:06:05.070682', '2021-04-15 13:06:05.070682', NULL),
	(10008104, 5, 'PW21A-TS100193BL-XL', 2, 0, '2021-04-15 13:06:05.061636', '2021-04-15 13:06:05.061636', NULL),
	(10008105, 5, 'PW21A-TS100193BL-XXL', 2, 0, '2021-04-15 13:06:05.055925', '2021-04-15 13:06:05.055925', NULL),
	(10008106, 5, 'PW21A-TS100194RD-XS', 0, 0, '2021-04-15 13:06:05.079849', '2021-04-15 13:06:05.079849', NULL),
	(10008107, 5, 'PW21A-TS100194RD-S', 2, 0, '2021-04-15 13:06:05.056288', '2021-04-15 13:06:05.056288', NULL),
	(10008108, 5, 'PW21A-TS100194RD-M', 0, 0, '2021-04-15 13:06:05.083178', '2021-04-15 13:06:05.083178', NULL),
	(10008109, 5, 'PW21A-TS100194RD-L', 2, 0, '2021-04-15 13:06:05.073139', '2021-04-15 13:06:05.073139', NULL),
	(10008110, 5, 'PW21A-TS100194RD-XL', 2, 0, '2021-04-15 13:06:05.078554', '2021-04-15 13:06:05.078554', NULL),
	(10008111, 5, 'PW21A-TS100194RD-XXL', 2, 0, '2021-04-15 13:06:05.067377', '2021-04-15 13:06:05.067377', NULL),
	(10008112, 5, 'PW21A-TS100195BL-XS', 0, 0, '2021-04-15 13:06:05.093574', '2021-04-15 13:06:05.093574', NULL),
	(10008113, 5, 'PW21A-TS100195BL-S', 2, 0, '2021-04-15 13:06:05.081010', '2021-04-15 13:06:05.081010', NULL),
	(10008114, 5, 'PW21A-TS100195BL-M', 2, 0, '2021-04-15 13:06:05.080207', '2021-04-15 13:06:05.080207', NULL),
	(10008115, 5, 'PW21A-TS100195BL-L', 2, 0, '2021-04-15 13:06:05.111947', '2021-04-15 13:06:05.111947', NULL),
	(10008116, 5, 'PW21A-TS100195BL-XL', 2, 0, '2021-04-15 13:06:05.092257', '2021-04-15 13:06:05.092257', NULL),
	(10008117, 5, 'PW21A-TS100195BL-XXL', 2, 0, '2021-04-15 13:06:05.087374', '2021-04-15 13:06:05.087374', NULL),
	(10008118, 5, 'PW21A-TS100196BL-XS', 0, 0, '2021-04-15 13:06:05.106557', '2021-04-15 13:06:05.106557', NULL),
	(10008119, 5, 'PW21A-TS100196BL-S', 2, 0, '2021-04-15 13:06:05.104708', '2021-04-15 13:06:05.104708', NULL),
	(10008120, 5, 'PW21A-TS100196BL-M', 2, 0, '2021-04-15 13:06:05.090800', '2021-04-15 13:06:05.090800', NULL),
	(10008121, 5, 'PW21A-TS100196BL-L', 3, 0, '2021-04-15 13:06:05.133335', '2021-04-15 13:06:05.133335', NULL),
	(10008122, 5, 'PW21A-TS100196BL-XL', 2, 0, '2021-04-15 13:06:05.134954', '2021-04-15 13:06:05.134954', NULL),
	(10008123, 5, 'PW21A-TS100196BL-XXL', 2, 0, '2021-04-15 13:06:05.105913', '2021-04-15 13:06:05.105913', NULL),
	(10008124, 5, 'PW21A-TS100197BL-XS', 0, 0, '2021-04-15 13:06:05.121489', '2021-04-15 13:06:05.121489', NULL),
	(10008125, 5, 'PW21A-TS100197BL-S', 0, 0, '2021-04-15 13:06:05.106872', '2021-04-15 13:06:05.106872', NULL),
	(10008126, 5, 'PW21A-TS100197BL-M', 0, 0, '2021-04-15 13:06:05.106242', '2021-04-15 13:06:05.106242', NULL),
	(10008127, 5, 'PW21A-TS100197BL-L', 0, 0, '2021-04-15 13:06:05.126387', '2021-04-15 13:06:05.126387', NULL),
	(10008128, 5, 'PW21A-TS100197BL-XL', 0, 0, '2021-04-15 13:06:05.133972', '2021-04-15 13:06:05.133972', NULL),
	(10008129, 5, 'PW21A-TS100197BL-XXL', 0, 0, '2021-04-15 13:06:05.108978', '2021-04-15 13:06:05.108978', NULL),
	(10008130, 5, 'PW21A-TS100198BL-XS', 0, 0, '2021-04-15 13:06:05.132892', '2021-04-15 13:06:05.132892', NULL),
	(10008131, 5, 'PW21A-TS100198BL-S', 2, 0, '2021-04-15 13:06:05.139324', '2021-04-15 13:06:05.139324', NULL),
	(10008132, 5, 'PW21A-TS100198BL-M', 2, 0, '2021-04-15 13:06:05.150671', '2021-04-15 13:06:05.150671', NULL),
	(10008133, 5, 'PW21A-TS100198BL-L', 2, 0, '2021-04-15 13:06:05.122993', '2021-04-15 13:06:05.122993', NULL),
	(10008134, 5, 'PW21A-TS100198BL-XL', 1, 0, '2021-04-15 13:06:05.130583', '2021-04-15 13:06:05.130583', NULL),
	(10008135, 5, 'PW21A-TS100198BL-XXL', 2, 0, '2021-04-15 13:06:05.173972', '2021-04-15 13:06:05.173972', NULL),
	(10008136, 5, 'PW21A-TS100199BL-XS', 0, 0, '2021-04-15 13:06:05.142738', '2021-04-15 13:06:05.142738', NULL),
	(10008137, 5, 'PW21A-TS100199BL-S', 0, 0, '2021-04-15 13:06:05.133660', '2021-04-15 13:06:05.133660', NULL),
	(10008138, 5, 'PW21A-TS100199BL-M', 0, 0, '2021-04-15 13:06:05.160281', '2021-04-15 13:06:05.160281', NULL),
	(10008139, 5, 'PW21A-TS100199BL-L', 0, 0, '2021-04-15 13:06:05.194722', '2021-04-15 13:06:05.194722', NULL),
	(10008140, 5, 'PW21A-TS100199BL-XL', 0, 0, '2021-04-15 13:06:05.157196', '2021-04-15 13:06:05.157196', NULL),
	(10008141, 5, 'PW21A-TS100199BL-XXL', 0, 0, '2021-04-15 13:06:05.158200', '2021-04-15 13:06:05.158200', NULL),
	(10008142, 5, 'PW21A-TS100200BL-XS', 0, 0, '2021-04-15 13:06:05.192128', '2021-04-15 13:06:05.192128', NULL),
	(10008143, 5, 'PW21A-TS100200BL-S', 0, 0, '2021-04-15 13:06:05.145500', '2021-04-15 13:06:05.145500', NULL),
	(10008144, 5, 'PW21A-TS100200BL-M', 0, 0, '2021-04-15 13:06:05.162107', '2021-04-15 13:06:05.162107', NULL),
	(10008145, 5, 'PW21A-TS100200BL-L', 0, 0, '2021-04-15 13:06:05.159872', '2021-04-15 13:06:05.159872', NULL),
	(10008146, 5, 'PW21A-TS100200BL-XL', 0, 0, '2021-04-15 13:06:05.161290', '2021-04-15 13:06:05.161290', NULL),
	(10008147, 5, 'PW21A-TS100200BL-XXL', 0, 0, '2021-04-15 13:06:05.170060', '2021-04-15 13:06:05.170060', NULL),
	(10008148, 5, 'PW21A-TS100201BL-XS', 0, 0, '2021-04-15 13:06:05.189116', '2021-04-15 13:06:05.189116', NULL),
	(10008149, 5, 'PW21A-TS100201BL-S', 2, 0, '2021-04-15 13:06:05.181089', '2021-04-15 13:06:05.181089', NULL),
	(10008150, 5, 'PW21A-TS100201BL-M', 1, 0, '2021-04-15 13:06:05.184755', '2021-04-15 13:06:05.184755', NULL),
	(10008151, 5, 'PW21A-TS100201BL-L', 2, 0, '2021-04-15 13:06:05.176497', '2021-04-15 13:06:05.176497', NULL),
	(10008152, 5, 'PW21A-TS100201BL-XL', 2, 0, '2021-04-15 13:06:05.186514', '2021-04-15 13:06:05.186514', NULL),
	(10008153, 5, 'PW21A-TS100201BL-XXL', 2, 0, '2021-04-15 13:06:05.201391', '2021-04-15 13:06:05.201391', NULL),
	(10008154, 5, 'PW21A-TS100202BL-XS', 0, 0, '2021-04-15 13:06:05.188350', '2021-04-15 13:06:05.188350', NULL),
	(10008155, 5, 'PW21A-TS100202BL-S', 2, 0, '2021-04-15 13:06:05.211910', '2021-04-15 13:06:05.211910', NULL),
	(10008156, 5, 'PW21A-TS100202BL-M', 2, 0, '2021-04-15 13:06:05.191747', '2021-04-15 13:06:05.191747', NULL),
	(10008157, 5, 'PW21A-TS100202BL-L', 2, 0, '2021-04-15 13:06:05.208366', '2021-04-15 13:06:05.208366', NULL),
	(10008158, 5, 'PW21A-TS100202BL-XL', 2, 0, '2021-04-15 13:06:05.209263', '2021-04-15 13:06:05.209263', NULL),
	(10008159, 5, 'PW21A-TS100202BL-XXL', 2, 0, '2021-04-15 13:06:05.267480', '2021-04-15 13:06:05.267480', NULL),
	(10008160, 5, 'PW21A-TS100203BL-XS', 0, 0, '2021-04-15 13:06:05.212326', '2021-04-15 13:06:05.212326', NULL),
	(10008161, 5, 'PW21A-TS100203BL-S', 2, 0, '2021-04-15 13:06:05.225091', '2021-04-15 13:06:05.225091', NULL),
	(10008162, 5, 'PW21A-TS100203BL-M', 2, 0, '2021-04-15 13:06:05.201739', '2021-04-15 13:06:05.201739', NULL),
	(10008163, 5, 'PW21A-TS100203BL-L', 2, 0, '2021-04-15 13:06:05.214031', '2021-04-15 13:06:05.214031', NULL),
	(10008164, 5, 'PW21A-TS100203BL-XL', 2, 0, '2021-04-15 13:06:05.214333', '2021-04-15 13:06:05.214333', NULL),
	(10008165, 5, 'PW21A-TS100203BL-XXL', 2, 0, '2021-04-15 13:06:05.231026', '2021-04-15 13:06:05.231026', NULL),
	(10008166, 5, 'PW21A-TS100204BL-XS', 0, 0, '2021-04-15 13:06:05.240109', '2021-04-15 13:06:05.240109', NULL),
	(10008167, 5, 'PW21A-TS100204BL-S', 2, 0, '2021-04-15 13:06:05.219260', '2021-04-15 13:06:05.219260', NULL),
	(10008168, 5, 'PW21A-TS100204BL-M', 2, 0, '2021-04-15 13:06:05.218400', '2021-04-15 13:06:05.218400', NULL),
	(10008169, 5, 'PW21A-TS100204BL-L', 0, 0, '2021-04-15 13:06:05.284226', '2021-04-15 13:06:05.284226', NULL),
	(10008170, 5, 'PW21A-TS100204BL-XL', 3, 0, '2021-04-15 13:06:05.243887', '2021-04-15 13:06:05.243887', NULL),
	(10008171, 5, 'PW21A-TS100204BL-XXL', 2, 0, '2021-04-15 13:06:05.238515', '2021-04-15 13:06:05.238515', NULL),
	(10008172, 5, 'PW21A-TS100205WT-XS', 0, 0, '2021-04-15 13:06:05.225437', '2021-04-15 13:06:05.225437', NULL),
	(10008173, 5, 'PW21A-TS100205WT-S', 0, 0, '2021-04-15 13:06:05.232846', '2021-04-15 13:06:05.232846', NULL),
	(10008174, 5, 'PW21A-TS100205WT-M', 0, 0, '2021-04-15 13:06:05.282752', '2021-04-15 13:06:05.282752', NULL),
	(10008175, 5, 'PW21A-TS100205WT-L', 0, 0, '2021-04-15 13:06:05.242027', '2021-04-15 13:06:05.242027', NULL),
	(10008176, 5, 'PW21A-TS100205WT-XL', 0, 0, '2021-04-15 13:06:05.239727', '2021-04-15 13:06:05.239727', NULL),
	(10008177, 5, 'PW21A-TS100205WT-XXL', 0, 0, '2021-04-15 13:06:05.278262', '2021-04-15 13:06:05.278262', NULL),
	(10008178, 5, 'PW21A-TS100206WT-XS', 0, 0, '2021-04-15 13:06:05.312259', '2021-04-15 13:06:05.312259', NULL),
	(10008179, 5, 'PW21A-TS100206WT-S', 0, 0, '2021-04-15 13:06:05.272950', '2021-04-15 13:06:05.272950', NULL),
	(10008180, 5, 'PW21A-TS100206WT-M', 0, 0, '2021-04-15 13:06:05.346985', '2021-04-15 13:06:05.346985', NULL),
	(10008181, 5, 'PW21A-TS100206WT-L', 0, 0, '2021-04-15 13:06:05.271453', '2021-04-15 13:06:05.271453', NULL),
	(10008182, 5, 'PW21A-TS100206WT-XL', 0, 0, '2021-04-15 13:06:05.294412', '2021-04-15 13:06:05.294412', NULL),
	(10008183, 5, 'PW21A-TS100206WT-XXL', 0, 0, '2021-04-15 13:06:05.290662', '2021-04-15 13:06:05.290662', NULL),
	(10008184, 5, 'PW21A-TS100207BL-XS', 0, 0, '2021-04-15 13:06:05.279962', '2021-04-15 13:06:05.279962', NULL),
	(10008185, 5, 'PW21A-TS100207BL-S', 2, 0, '2021-04-15 13:06:05.286328', '2021-04-15 13:06:05.286328', NULL),
	(10008186, 5, 'PW21A-TS100207BL-M', 2, 0, '2021-04-15 13:06:05.284593', '2021-04-15 13:06:05.284593', NULL),
	(10008187, 5, 'PW21A-TS100207BL-L', 2, 0, '2021-04-15 13:06:05.319141', '2021-04-15 13:06:05.319141', NULL),
	(10008188, 5, 'PW21A-TS100207BL-XL', 2, 0, '2021-04-15 13:06:05.349735', '2021-04-15 13:06:05.349735', NULL),
	(10008189, 5, 'PW21A-TS100207BL-XXL', 2, 0, '2021-04-15 13:06:05.288268', '2021-04-15 13:06:05.288268', NULL),
	(10008190, 5, 'PW21A-TS100208BL-XS', 0, 0, '2021-04-15 13:06:05.308972', '2021-04-15 13:06:05.308972', NULL),
	(10008191, 5, 'PW21A-TS100208BL-S', 0, 0, '2021-04-15 13:06:05.314756', '2021-04-15 13:06:05.314756', NULL),
	(10008192, 5, 'PW21A-TS100208BL-M', 0, 0, '2021-04-15 13:06:05.296603', '2021-04-15 13:06:05.296603', NULL),
	(10008193, 5, 'PW21A-TS100208BL-L', 0, 0, '2021-04-15 13:06:05.323527', '2021-04-15 13:06:05.323527', NULL),
	(10008194, 5, 'PW21A-TS100208BL-XL', 0, 0, '2021-04-15 13:06:05.320370', '2021-04-15 13:06:05.320370', NULL),
	(10008195, 5, 'PW21A-TS100208BL-XXL', 0, 0, '2021-04-15 13:06:05.323152', '2021-04-15 13:06:05.323152', NULL),
	(10008196, 5, 'PW21A-TS100209BL-XS', 0, 0, '2021-04-15 13:06:05.342631', '2021-04-15 13:06:05.342631', NULL),
	(10008197, 5, 'PW21A-TS100209BL-S', 2, 0, '2021-04-15 13:06:05.314159', '2021-04-15 13:06:05.314159', NULL),
	(10008198, 5, 'PW21A-TS100209BL-M', 2, 0, '2021-04-15 13:06:05.333649', '2021-04-15 13:06:05.333649', NULL),
	(10008199, 5, 'PW21A-TS100209BL-L', 2, 0, '2021-04-15 13:06:05.364042', '2021-04-15 13:06:05.364042', NULL),
	(10008200, 5, 'PW21A-TS100209BL-XL', 2, 0, '2021-04-15 13:06:05.343828', '2021-04-15 13:06:05.343828', NULL),
	(10008201, 5, 'PW21A-TS100209BL-XXL', 2, 0, '2021-04-15 13:06:05.327484', '2021-04-15 13:06:05.327484', NULL),
	(10008202, 5, 'PW21A-TS100210BL-XS', 0, 0, '2021-04-15 13:06:05.353696', '2021-04-15 13:06:05.353696', NULL),
	(10008203, 5, 'PW21A-TS100210BL-S', 0, 0, '2021-04-15 13:06:05.355804', '2021-04-15 13:06:05.355804', NULL),
	(10008204, 5, 'PW21A-TS100210BL-M', 0, 0, '2021-04-15 13:06:05.345989', '2021-04-15 13:06:05.345989', NULL),
	(10008205, 5, 'PW21A-TS100210BL-L', 0, 0, '2021-04-15 13:06:05.381747', '2021-04-15 13:06:05.381747', NULL),
	(10008206, 5, 'PW21A-TS100210BL-XL', 0, 0, '2021-04-15 13:06:05.394881', '2021-04-15 13:06:05.394881', NULL),
	(10008207, 5, 'PW21A-TS100210BL-XXL', 0, 0, '2021-04-15 13:06:05.385501', '2021-04-15 13:06:05.385501', NULL),
	(10008208, 5, 'PW21A-TS100211BL-XS', 0, 0, '2021-04-15 13:06:05.375675', '2021-04-15 13:06:05.375675', NULL),
	(10008209, 5, 'PW21A-TS100211BL-S', 0, 0, '2021-04-15 13:06:05.357348', '2021-04-15 13:06:05.357348', NULL),
	(10008210, 5, 'PW21A-TS100211BL-M', 0, 0, '2021-04-15 13:06:05.367357', '2021-04-15 13:06:05.367357', NULL),
	(10008211, 5, 'PW21A-TS100211BL-L', 0, 0, '2021-04-15 13:06:05.375327', '2021-04-15 13:06:05.375327', NULL),
	(10008212, 5, 'PW21A-TS100211BL-XL', 0, 0, '2021-04-15 13:06:05.380839', '2021-04-15 13:06:05.380839', NULL),
	(10008213, 5, 'PW21A-TS100211BL-XXL', 0, 0, '2021-04-15 13:06:05.413791', '2021-04-15 13:06:05.413791', NULL),
	(10008214, 5, 'PW21A-TS100212GN-XS', 0, 0, '2021-04-15 13:06:05.445785', '2021-04-15 13:06:05.445785', NULL),
	(10008215, 5, 'PW21A-TS100212GN-S', 2, 0, '2021-04-15 13:06:05.380325', '2021-04-15 13:06:05.380325', NULL),
	(10008216, 5, 'PW21A-TS100212GN-M', 1, 0, '2021-04-15 13:06:05.385976', '2021-04-15 13:06:05.385976', NULL),
	(10008217, 5, 'PW21A-TS100212GN-L', 1, 0, '2021-04-15 13:06:05.406264', '2021-04-15 13:06:05.406264', NULL),
	(10008218, 5, 'PW21A-TS100212GN-XL', 2, 0, '2021-04-15 13:06:05.413256', '2021-04-15 13:06:05.413256', NULL),
	(10008219, 5, 'PW21A-TS100212GN-XXL', 2, 0, '2021-04-15 13:06:05.388232', '2021-04-15 13:06:05.388232', NULL),
	(10008220, 5, 'PW21A-TS100213BL-XS', 0, 0, '2021-04-15 13:06:05.397464', '2021-04-15 13:06:05.397464', NULL),
	(10008221, 5, 'PW21A-TS100213BL-S', 2, 0, '2021-04-15 13:06:05.407483', '2021-04-15 13:06:05.407483', NULL),
	(10008222, 5, 'PW21A-TS100213BL-M', 2, 0, '2021-04-15 13:06:05.447528', '2021-04-15 13:06:05.447528', NULL),
	(10008223, 5, 'PW21A-TS100213BL-L', 2, 0, '2021-04-15 13:06:05.414782', '2021-04-15 13:06:05.414782', NULL),
	(10008224, 5, 'PW21A-TS100213BL-XL', 2, 0, '2021-04-15 13:06:05.418463', '2021-04-15 13:06:05.418463', NULL),
	(10008225, 5, 'PW21A-TS100213BL-XXL', 2, 0, '2021-04-15 13:06:05.419933', '2021-04-15 13:06:05.419933', NULL),
	(10008226, 5, 'PW21A-TS100214BL-XS', 0, 0, '2021-04-15 13:06:05.416214', '2021-04-15 13:06:05.416214', NULL),
	(10008227, 5, 'PW21A-TS100214BL-S', 0, 0, '2021-04-15 13:06:05.448745', '2021-04-15 13:06:05.448745', NULL),
	(10008228, 5, 'PW21A-TS100214BL-M', 0, 0, '2021-04-15 13:06:05.431324', '2021-04-15 13:06:05.431324', NULL),
	(10008229, 5, 'PW21A-TS100214BL-L', 0, 0, '2021-04-15 13:06:05.489907', '2021-04-15 13:06:05.489907', NULL),
	(10008230, 5, 'PW21A-TS100214BL-XL', 0, 0, '2021-04-15 13:06:05.434709', '2021-04-15 13:06:05.434709', NULL),
	(10008231, 5, 'PW21A-TS100214BL-XXL', 0, 0, '2021-04-15 13:06:05.451132', '2021-04-15 13:06:05.451132', NULL),
	(10008232, 5, 'PW21A-TS100215BL-XS', 0, 0, '2021-04-15 13:06:05.446088', '2021-04-15 13:06:05.446088', NULL),
	(10008233, 5, 'PW21A-TS100215BL-S', 0, 0, '2021-04-15 13:06:05.448164', '2021-04-15 13:06:05.448164', NULL),
	(10008234, 5, 'PW21A-TS100215BL-M', 0, 0, '2021-04-15 13:06:05.453182', '2021-04-15 13:06:05.453182', NULL),
	(10008235, 5, 'PW21A-TS100215BL-L', 0, 0, '2021-04-15 13:06:05.455675', '2021-04-15 13:06:05.455675', NULL),
	(10008236, 5, 'PW21A-TS100215BL-XL', 0, 0, '2021-04-15 13:06:05.474010', '2021-04-15 13:06:05.474010', NULL),
	(10008237, 5, 'PW21A-TS100215BL-XXL', 0, 0, '2021-04-15 13:06:05.472571', '2021-04-15 13:06:05.472571', NULL),
	(10008238, 5, 'PW21A-TS100216NV-XS', 0, 0, '2021-04-15 13:06:05.488031', '2021-04-15 13:06:05.488031', NULL),
	(10008239, 5, 'PW21A-TS100216NV-S', 3, 0, '2021-04-15 13:06:05.463615', '2021-04-15 13:06:05.463615', NULL),
	(10008240, 5, 'PW21A-TS100216NV-M', 0, 0, '2021-04-15 13:06:05.504054', '2021-04-15 13:06:05.504054', NULL),
	(10008241, 5, 'PW21A-TS100216NV-L', 0, 0, '2021-04-15 13:06:05.476057', '2021-04-15 13:06:05.476057', NULL),
	(10008242, 5, 'PW21A-TS100216NV-XL', 1, 0, '2021-04-15 13:06:05.467079', '2021-04-15 13:06:05.467079', NULL),
	(10008243, 5, 'PW21A-TS100216NV-XXL', 2, 0, '2021-04-15 13:06:05.476541', '2021-04-15 13:06:05.476541', NULL),
	(10008244, 5, 'PW21A-TS100217BL-XS', 0, 0, '2021-04-15 13:06:05.477951', '2021-04-15 13:06:05.477951', NULL),
	(10008245, 5, 'PW21A-TS100217BL-S', 2, 0, '2021-04-15 13:06:05.474781', '2021-04-15 13:06:05.474781', NULL),
	(10008246, 5, 'PW21A-TS100217BL-M', 2, 0, '2021-04-15 13:06:05.476880', '2021-04-15 13:06:05.476880', NULL),
	(10008247, 5, 'PW21A-TS100217BL-L', 1, 0, '2021-04-15 13:06:05.477649', '2021-04-15 13:06:05.477649', NULL),
	(10008248, 5, 'PW21A-TS100217BL-XL', 1, 0, '2021-04-15 13:06:05.503027', '2021-04-15 13:06:05.503027', NULL),
	(10008249, 5, 'PW21A-TS100217BL-XXL', 1, 0, '2021-04-15 13:06:05.531240', '2021-04-15 13:06:05.531240', NULL),
	(10008250, 5, 'PW21A-TS100218BL-XS', 0, 0, '2021-04-15 13:06:05.504600', '2021-04-15 13:06:05.504600', NULL),
	(10008251, 5, 'PW21A-TS100218BL-S', 2, 0, '2021-04-15 13:06:05.502275', '2021-04-15 13:06:05.502275', NULL),
	(10008252, 5, 'PW21A-TS100218BL-M', 2, 0, '2021-04-15 13:06:05.505532', '2021-04-15 13:06:05.505532', NULL),
	(10008253, 5, 'PW21A-TS100218BL-L', 2, 0, '2021-04-15 13:06:05.505981', '2021-04-15 13:06:05.505981', NULL),
	(10008254, 5, 'PW21A-TS100218BL-XL', 2, 0, '2021-04-15 13:06:05.527530', '2021-04-15 13:06:05.527530', NULL),
	(10008255, 5, 'PW21A-TS100218BL-XXL', 1, 0, '2021-04-15 13:06:05.525169', '2021-04-15 13:06:05.525169', NULL),
	(10008256, 5, 'PW21A-TS100219BL-XS', 0, 0, '2021-04-15 13:06:05.529841', '2021-04-15 13:06:05.529841', NULL),
	(10008257, 5, 'PW21A-TS100219BL-S', 2, 0, '2021-04-15 13:06:05.513598', '2021-04-15 13:06:05.513598', NULL),
	(10008258, 5, 'PW21A-TS100219BL-M', 3, 0, '2021-04-15 13:06:05.558125', '2021-04-15 13:06:05.558125', NULL),
	(10008259, 5, 'PW21A-TS100219BL-L', 2, 0, '2021-04-15 13:06:05.513150', '2021-04-15 13:06:05.513150', NULL),
	(10008260, 5, 'PW21A-TS100219BL-XL', 2, 0, '2021-04-15 13:06:05.530877', '2021-04-15 13:06:05.530877', NULL),
	(10008261, 5, 'PW21A-TS100219BL-XXL', 2, 0, '2021-04-15 13:06:05.525794', '2021-04-15 13:06:05.525794', NULL),
	(10008262, 5, 'PW21A-TS100220BL-XS', 0, 0, '2021-04-15 13:06:05.561247', '2021-04-15 13:06:05.561247', NULL),
	(10008263, 5, 'PW21A-TS100220BL-S', 2, 0, '2021-04-15 13:06:05.538152', '2021-04-15 13:06:05.538152', NULL),
	(10008264, 5, 'PW21A-TS100220BL-M', 2, 0, '2021-04-15 13:06:05.531882', '2021-04-15 13:06:05.531882', NULL),
	(10008265, 5, 'PW21A-TS100220BL-L', 2, 0, '2021-04-15 13:06:05.551922', '2021-04-15 13:06:05.551922', NULL),
	(10008266, 5, 'PW21A-TS100220BL-XL', 2, 0, '2021-04-15 13:06:05.553462', '2021-04-15 13:06:05.553462', NULL),
	(10008267, 5, 'PW21A-TS100220BL-XXL', 2, 0, '2021-04-15 13:06:05.532289', '2021-04-15 13:06:05.532289', NULL),
	(10008268, 5, 'PW21A-TK100221BL-XS', 0, 0, '2021-04-15 13:06:05.562094', '2021-04-15 13:06:05.562094', NULL),
	(10008269, 5, 'PW21A-TK100221BL-S', 0, 0, '2021-04-15 13:06:05.535682', '2021-04-15 13:06:05.535682', NULL),
	(10008270, 5, 'PW21A-TK100221BL-M', 2, 0, '2021-04-15 13:06:05.554319', '2021-04-15 13:06:05.554319', NULL),
	(10008271, 5, 'PW21A-TK100221BL-L', 2, 0, '2021-04-15 13:06:05.555996', '2021-04-15 13:06:05.555996', NULL),
	(10008272, 5, 'PW21A-TK100221BL-XL', 2, 0, '2021-04-15 13:06:05.556590', '2021-04-15 13:06:05.556590', NULL),
	(10008273, 5, 'PW21A-TK100221BL-XXL', 2, 0, '2021-04-15 13:06:05.556301', '2021-04-15 13:06:05.556301', NULL),
	(10008274, 5, 'PW21A-TS100222BL-XS', 0, 0, '2021-04-15 13:06:05.580981', '2021-04-15 13:06:05.580981', NULL),
	(10008275, 5, 'PW21A-TS100222BL-S', 2, 0, '2021-04-15 13:06:05.571254', '2021-04-15 13:06:05.571254', NULL),
	(10008276, 5, 'PW21A-TS100222BL-M', 2, 0, '2021-04-15 13:06:05.573555', '2021-04-15 13:06:05.573555', NULL),
	(10008277, 5, 'PW21A-TS100222BL-L', 2, 0, '2021-04-15 13:06:05.558856', '2021-04-15 13:06:05.558856', NULL),
	(10008278, 5, 'PW21A-TS100222BL-XL', 2, 0, '2021-04-15 13:06:05.574410', '2021-04-15 13:06:05.574410', NULL),
	(10008279, 5, 'PW21A-TS100222BL-XXL', 2, 0, '2021-04-15 13:06:05.583522', '2021-04-15 13:06:05.583522', NULL),
	(10008280, 5, 'PW21A-TS100223BL-XS', 0, 0, '2021-04-15 13:06:05.581697', '2021-04-15 13:06:05.581697', NULL),
	(10008281, 5, 'PW21A-TS100223BL-S', 0, 0, '2021-04-15 13:06:05.622872', '2021-04-15 13:06:05.622872', NULL),
	(10008282, 5, 'PW21A-TS100223BL-M', 0, 0, '2021-04-15 13:06:05.572221', '2021-04-15 13:06:05.572221', NULL),
	(10008283, 5, 'PW21A-TS100223BL-L', 0, 0, '2021-04-15 13:06:05.578356', '2021-04-15 13:06:05.578356', NULL),
	(10008284, 5, 'PW21A-TS100223BL-XL', 0, 0, '2021-04-15 13:06:05.577907', '2021-04-15 13:06:05.577907', NULL),
	(10008285, 5, 'PW21A-TS100223BL-XXL', 0, 0, '2021-04-15 13:06:05.584324', '2021-04-15 13:06:05.584324', NULL),
	(10008286, 5, 'PW21A-TK100224BL-XS', 0, 0, '2021-04-15 13:06:05.617218', '2021-04-15 13:06:05.617218', NULL),
	(10008287, 5, 'PW21A-TK100224BL-S', 0, 0, '2021-04-15 13:06:05.594274', '2021-04-15 13:06:05.594274', NULL),
	(10008288, 5, 'PW21A-TK100224BL-M', 1, 0, '2021-04-15 13:06:05.596076', '2021-04-15 13:06:05.596076', NULL),
	(10008289, 5, 'PW21A-TK100224BL-L', 2, 0, '2021-04-15 13:06:05.599296', '2021-04-15 13:06:05.599296', NULL),
	(10008290, 5, 'PW21A-TK100224BL-XL', 2, 0, '2021-04-15 13:06:05.596600', '2021-04-15 13:06:05.596600', NULL),
	(10008291, 5, 'PW21A-TK100224BL-XXL', 1, 0, '2021-04-15 13:06:05.605265', '2021-04-15 13:06:05.605265', NULL),
	(10008292, 5, 'PW21A-TK100225BL-XS', 0, 0, '2021-04-15 13:06:05.596898', '2021-04-15 13:06:05.596898', NULL),
	(10008293, 5, 'PW21A-TK100225BL-S', 1, 0, '2021-04-15 13:06:05.602102', '2021-04-15 13:06:05.602102', NULL),
	(10008294, 5, 'PW21A-TK100225BL-M', 2, 0, '2021-04-15 13:06:05.616707', '2021-04-15 13:06:05.616707', NULL),
	(10008295, 5, 'PW21A-TK100225BL-L', 2, 0, '2021-04-15 13:06:05.600036', '2021-04-15 13:06:05.600036', NULL),
	(10008296, 5, 'PW21A-TK100225BL-XL', 2, 0, '2021-04-15 13:06:05.621629', '2021-04-15 13:06:05.621629', NULL),
	(10008297, 5, 'PW21A-TK100225BL-XXL', 0, 0, '2021-04-15 13:06:05.602426', '2021-04-15 13:06:05.602426', NULL),
	(10008298, 5, 'PW21A-TS100226BL-XS', 0, 0, '2021-04-15 13:06:05.604936', '2021-04-15 13:06:05.604936', NULL),
	(10008299, 5, 'PW21A-TS100226BL-S', 2, 0, '2021-04-15 13:06:05.615333', '2021-04-15 13:06:05.615333', NULL),
	(10008300, 5, 'PW21A-TS100226BL-M', 1, 0, '2021-04-15 13:06:05.617522', '2021-04-15 13:06:05.617522', NULL),
	(10008301, 5, 'PW21A-TS100226BL-L', 2, 0, '2021-04-15 13:06:05.625864', '2021-04-15 13:06:05.625864', NULL),
	(10008302, 5, 'PW21A-TS100226BL-XL', 2, 0, '2021-04-15 13:06:05.653889', '2021-04-15 13:06:05.653889', NULL),
	(10008303, 5, 'PW21A-TS100226BL-XXL', 1, 0, '2021-04-15 13:06:05.647668', '2021-04-15 13:06:05.647668', NULL),
	(10008304, 5, 'PW21A-TK100227BL-XS', 0, 0, '2021-04-15 13:06:05.619802', '2021-04-15 13:06:05.619802', NULL),
	(10008305, 5, 'PW21A-TK100227BL-S', 1, 0, '2021-04-15 13:06:05.643007', '2021-04-15 13:06:05.643007', NULL),
	(10008306, 5, 'PW21A-TK100227BL-M', 3, 0, '2021-04-15 13:06:05.620542', '2021-04-15 13:06:05.620542', NULL),
	(10008307, 5, 'PW21A-TK100227BL-L', 1, 0, '2021-04-15 13:06:05.626214', '2021-04-15 13:06:05.626214', NULL),
	(10008308, 5, 'PW21A-TK100227BL-XL', 2, 0, '2021-04-15 13:06:05.670414', '2021-04-15 13:06:05.670414', NULL),
	(10008309, 5, 'PW21A-TK100227BL-XXL', 2, 0, '2021-04-15 13:06:05.672388', '2021-04-15 13:06:05.672388', NULL),
	(10008310, 5, 'PW21A-TS100228BL-XS', 0, 0, '2021-04-15 13:06:05.637480', '2021-04-15 13:06:05.637480', NULL),
	(10008311, 5, 'PW21A-TS100228BL-S', 2, 0, '2021-04-15 13:06:05.647272', '2021-04-15 13:06:05.647272', NULL),
	(10008312, 5, 'PW21A-TS100228BL-M', 1, 0, '2021-04-15 13:06:05.645755', '2021-04-15 13:06:05.645755', NULL),
	(10008313, 5, 'PW21A-TS100228BL-L', 2, 0, '2021-04-15 13:06:05.646463', '2021-04-15 13:06:05.646463', NULL),
	(10008314, 5, 'PW21A-TS100228BL-XL', 2, 0, '2021-04-15 13:06:05.686796', '2021-04-15 13:06:05.686796', NULL),
	(10008315, 5, 'PW21A-TS100228BL-XXL', 2, 0, '2021-04-15 13:06:05.646858', '2021-04-15 13:06:05.646858', NULL),
	(10008316, 5, 'PW21A-TK100229BL-XS', 0, 0, '2021-04-15 13:06:05.650219', '2021-04-15 13:06:05.650219', NULL),
	(10008317, 5, 'PW21A-TK100229BL-S', 1, 0, '2021-04-15 13:06:05.673453', '2021-04-15 13:06:05.673453', NULL),
	(10008318, 5, 'PW21A-TK100229BL-M', 2, 0, '2021-04-15 13:06:05.653400', '2021-04-15 13:06:05.653400', NULL),
	(10008319, 5, 'PW21A-TK100229BL-L', 2, 0, '2021-04-15 13:06:05.668753', '2021-04-15 13:06:05.668753', NULL),
	(10008320, 5, 'PW21A-TK100229BL-XL', 2, 0, '2021-04-15 13:06:05.675422', '2021-04-15 13:06:05.675422', NULL),
	(10008321, 5, 'PW21A-TK100229BL-XXL', 2, 0, '2021-04-15 13:06:05.672659', '2021-04-15 13:06:05.672659', NULL),
	(10008322, 5, 'PW21A-TK100230BL-XS', 0, 0, '2021-04-15 13:06:05.672094', '2021-04-15 13:06:05.672094', NULL),
	(10008323, 5, 'PW21A-TK100230BL-S', 2, 0, '2021-04-15 13:06:05.678842', '2021-04-15 13:06:05.678842', NULL),
	(10008324, 5, 'PW21A-TK100230BL-M', 2, 0, '2021-04-15 13:06:05.689793', '2021-04-15 13:06:05.689793', NULL),
	(10008325, 5, 'PW21A-TK100230BL-L', 2, 0, '2021-04-15 13:06:05.694602', '2021-04-15 13:06:05.694602', NULL),
	(10008326, 5, 'PW21A-TK100230BL-XL', 2, 0, '2021-04-15 13:06:05.674176', '2021-04-15 13:06:05.674176', NULL),
	(10008327, 5, 'PW21A-TK100230BL-XXL', 2, 0, '2021-04-15 13:06:05.691240', '2021-04-15 13:06:05.691240', NULL),
	(10008328, 5, 'PW21A-TS100231BL-XS', 0, 0, '2021-04-15 13:06:05.692804', '2021-04-15 13:06:05.692804', NULL),
	(10008329, 5, 'PW21A-TS100231BL-S', 0, 0, '2021-04-15 13:06:05.681198', '2021-04-15 13:06:05.681198', NULL),
	(10008330, 5, 'PW21A-TS100231BL-M', 0, 0, '2021-04-15 13:06:05.733868', '2021-04-15 13:06:05.733868', NULL),
	(10008331, 5, 'PW21A-TS100231BL-L', 0, 0, '2021-04-15 13:06:05.694937', '2021-04-15 13:06:05.694937', NULL),
	(10008332, 5, 'PW21A-TS100231BL-XL', 0, 0, '2021-04-15 13:06:05.728523', '2021-04-15 13:06:05.728523', NULL),
	(10008333, 5, 'PW21A-TS100231BL-XXL', 0, 0, '2021-04-15 13:06:05.692465', '2021-04-15 13:06:05.692465', NULL),
	(10008334, 5, 'PW21A-TK100232GN-XS', 0, 0, '2021-04-15 13:06:05.722286', '2021-04-15 13:06:05.722286', NULL),
	(10008335, 5, 'PW21A-TK100232GN-S', 0, 0, '2021-04-15 13:06:05.696624', '2021-04-15 13:06:05.696624', NULL),
	(10008336, 5, 'PW21A-TK100232GN-M', 0, 0, '2021-04-15 13:06:05.701555', '2021-04-15 13:06:05.701555', NULL),
	(10008337, 5, 'PW21A-TK100232GN-L', 2, 0, '2021-04-15 13:06:05.719615', '2021-04-15 13:06:05.719615', NULL),
	(10008338, 5, 'PW21A-TK100232GN-XL', 2, 0, '2021-04-15 13:06:05.704840', '2021-04-15 13:06:05.704840', NULL),
	(10008339, 5, 'PW21A-TK100232GN-XXL', 2, 0, '2021-04-15 13:06:05.723242', '2021-04-15 13:06:05.723242', NULL),
	(10008340, 5, 'PW21A-TS100233BL-XS', 0, 0, '2021-04-15 13:06:05.714686', '2021-04-15 13:06:05.714686', NULL),
	(10008341, 5, 'PW21A-TS100233BL-S', 0, 0, '2021-04-15 13:06:05.722911', '2021-04-15 13:06:05.722911', NULL),
	(10008342, 5, 'PW21A-TS100233BL-M', 0, 0, '2021-04-15 13:06:05.721931', '2021-04-15 13:06:05.721931', NULL),
	(10008343, 5, 'PW21A-TS100233BL-L', 0, 0, '2021-04-15 13:06:05.727503', '2021-04-15 13:06:05.727503', NULL),
	(10008344, 5, 'PW21A-TS100233BL-XL', 0, 0, '2021-04-15 13:06:05.745445', '2021-04-15 13:06:05.745445', NULL),
	(10008345, 5, 'PW21A-TS100233BL-XXL', 0, 0, '2021-04-15 13:06:05.752485', '2021-04-15 13:06:05.752485', NULL),
	(10008346, 5, 'PW21A-TK100234BL-XS', 0, 0, '2021-04-15 13:06:05.752169', '2021-04-15 13:06:05.752169', NULL),
	(10008347, 5, 'PW21A-TK100234BL-S', 0, 0, '2021-04-15 13:06:05.725922', '2021-04-15 13:06:05.725922', NULL),
	(10008348, 5, 'PW21A-TK100234BL-M', 0, 0, '2021-04-15 13:06:05.754959', '2021-04-15 13:06:05.754959', NULL),
	(10008349, 5, 'PW21A-TK100234BL-L', 0, 0, '2021-04-15 13:06:05.757116', '2021-04-15 13:06:05.757116', NULL),
	(10008350, 5, 'PW21A-TK100234BL-XL', 0, 0, '2021-04-15 13:06:05.760503', '2021-04-15 13:06:05.760503', NULL),
	(10008351, 5, 'PW21A-TK100234BL-XXL', 0, 0, '2021-04-15 13:06:05.754009', '2021-04-15 13:06:05.754009', NULL),
	(10008352, 5, 'PW21A-TS100235BL-XS', 0, 0, '2021-04-15 13:06:05.786497', '2021-04-15 13:06:05.786497', NULL),
	(10008353, 5, 'PW21A-TS100235BL-S', 2, 0, '2021-04-15 13:06:05.751024', '2021-04-15 13:06:05.751024', NULL),
	(10008354, 5, 'PW21A-TS100235BL-M', 2, 0, '2021-04-15 13:06:05.770345', '2021-04-15 13:06:05.770345', NULL),
	(10008355, 5, 'PW21A-TS100235BL-L', 2, 0, '2021-04-15 13:06:05.804210', '2021-04-15 13:06:05.804210', NULL),
	(10008356, 5, 'PW21A-TS100235BL-XL', 2, 0, '2021-04-15 13:06:05.770938', '2021-04-15 13:06:05.770938', NULL),
	(10008357, 5, 'PW21A-TS100235BL-XXL', 1, 0, '2021-04-15 13:06:05.760195', '2021-04-15 13:06:05.760195', NULL),
	(10008358, 5, 'PW21A-TK100236WT-XS', 0, 0, '2021-04-15 13:06:05.757927', '2021-04-15 13:06:05.757927', NULL),
	(10008359, 5, 'PW21A-TK100236WT-S', 2, 0, '2021-04-15 13:06:05.773271', '2021-04-15 13:06:05.773271', NULL),
	(10008360, 5, 'PW21A-TK100236WT-M', 2, 0, '2021-04-15 13:06:05.797322', '2021-04-15 13:06:05.797322', NULL),
	(10008361, 5, 'PW21A-TK100236WT-L', 2, 0, '2021-04-15 13:06:05.772909', '2021-04-15 13:06:05.772909', NULL),
	(10008362, 5, 'PW21A-TK100236WT-XL', 2, 0, '2021-04-15 13:06:05.783756', '2021-04-15 13:06:05.783756', NULL),
	(10008363, 5, 'PW21A-TK100236WT-XXL', 2, 0, '2021-04-15 13:06:05.774033', '2021-04-15 13:06:05.774033', NULL),
	(10008364, 5, 'PW21A-TS100237BL-XS', 0, 0, '2021-04-15 13:06:05.816826', '2021-04-15 13:06:05.816826', NULL),
	(10008365, 5, 'PW21A-TS100237BL-S', 0, 0, '2021-04-15 13:06:05.785591', '2021-04-15 13:06:05.785591', NULL),
	(10008366, 5, 'PW21A-TS100237BL-M', 0, 0, '2021-04-15 13:06:05.783392', '2021-04-15 13:06:05.783392', NULL),
	(10008367, 5, 'PW21A-TS100237BL-L', 0, 0, '2021-04-15 13:06:05.795269', '2021-04-15 13:06:05.795269', NULL),
	(10008368, 5, 'PW21A-TS100237BL-XL', 0, 0, '2021-04-15 13:06:05.799201', '2021-04-15 13:06:05.799201', NULL),
	(10008369, 5, 'PW21A-TS100237BL-XXL', 0, 0, '2021-04-15 13:06:05.776319', '2021-04-15 13:06:05.776319', NULL),
	(10008370, 5, 'PW21A-TS100238BL-XS', 0, 0, '2021-04-15 13:06:05.792437', '2021-04-15 13:06:05.792437', NULL),
	(10008371, 5, 'PW21A-TS100238BL-S', 0, 0, '2021-04-15 13:06:05.995435', '2021-04-15 13:06:05.995435', NULL),
	(10008372, 5, 'PW21A-TS100238BL-M', 0, 0, '2021-04-15 13:06:05.802363', '2021-04-15 13:06:05.802363', NULL),
	(10008373, 5, 'PW21A-TS100238BL-L', 0, 0, '2021-04-15 13:06:06.029355', '2021-04-15 13:06:06.029355', NULL),
	(10008374, 5, 'PW21A-TS100238BL-XL', 0, 0, '2021-04-15 13:06:06.279996', '2021-04-15 13:06:06.279996', NULL),
	(10008375, 5, 'PW21A-TS100238BL-XXL', 0, 0, '2021-04-15 13:06:05.799519', '2021-04-15 13:06:05.799519', NULL),
	(10008376, 5, 'PW21A-TK100239OG-XS', 0, 0, '2021-04-15 13:06:05.805048', '2021-04-15 13:06:05.805048', NULL),
	(10008377, 5, 'PW21A-TK100239OG-S', 1, 0, '2021-04-15 13:06:05.805593', '2021-04-15 13:06:05.805593', NULL),
	(10008378, 5, 'PW21A-TK100239OG-M', 2, 0, '2021-04-15 13:06:06.025974', '2021-04-15 13:06:06.025974', NULL),
	(10008379, 5, 'PW21A-TK100239OG-L', 2, 0, '2021-04-15 13:06:06.007611', '2021-04-15 13:06:06.007611', NULL),
	(10008380, 5, 'PW21A-TK100239OG-XL', 2, 0, '2021-04-15 13:06:06.236898', '2021-04-15 13:06:06.236898', NULL),
	(10008381, 5, 'PW21A-TK100239OG-XXL', 2, 0, '2021-04-15 13:06:06.127570', '2021-04-15 13:06:06.127570', NULL),
	(10008382, 5, 'PW21A-TK100240OG-XS', 0, 0, '2021-04-15 13:06:06.051376', '2021-04-15 13:06:06.051376', NULL),
	(10008383, 5, 'PW21A-TK100240OG-S', 0, 0, '2021-04-15 13:06:06.028414', '2021-04-15 13:06:06.028414', NULL),
	(10008384, 5, 'PW21A-TK100240OG-M', 0, 0, '2021-04-15 13:06:05.994961', '2021-04-15 13:06:05.994961', NULL),
	(10008385, 5, 'PW21A-TK100240OG-L', 1, 0, '2021-04-15 13:06:06.011441', '2021-04-15 13:06:06.011441', NULL),
	(10008386, 5, 'PW21A-TK100240OG-XL', 2, 0, '2021-04-15 13:06:06.024968', '2021-04-15 13:06:06.024968', NULL),
	(10008387, 5, 'PW21A-TK100240OG-XXL', 1, 0, '2021-04-15 13:06:06.046051', '2021-04-15 13:06:06.046051', NULL),
	(10008388, 5, 'PW21A-TS100241YW -XS', 0, 0, '2021-04-15 13:06:06.237527', '2021-04-15 13:06:06.237527', NULL),
	(10008389, 5, 'PW21A-TS100241YW -S', 1, 0, '2021-04-15 13:06:06.087353', '2021-04-15 13:06:06.087353', NULL),
	(10008390, 5, 'PW21A-TS100241YW -M', 0, 0, '2021-04-15 13:06:06.126577', '2021-04-15 13:06:06.126577', NULL),
	(10008391, 5, 'PW21A-TS100241YW -L', 0, 0, '2021-04-15 13:06:06.112634', '2021-04-15 13:06:06.112634', NULL),
	(10008392, 5, 'PW21A-TS100241YW -XL', 2, 0, '2021-04-15 13:06:06.205564', '2021-04-15 13:06:06.205564', NULL),
	(10008393, 5, 'PW21A-TS100241YW -XXL', 1, 0, '2021-04-15 13:06:06.129277', '2021-04-15 13:06:06.129277', NULL),
	(10008394, 5, 'PW21A-TS100242BL-XS', 0, 0, '2021-04-15 13:06:06.235566', '2021-04-15 13:06:06.235566', NULL),
	(10008395, 5, 'PW21A-TS100242BL-S', 2, 0, '2021-04-15 13:06:06.259891', '2021-04-15 13:06:06.259891', NULL),
	(10008396, 5, 'PW21A-TS100242BL-M', 2, 0, '2021-04-15 13:06:06.236246', '2021-04-15 13:06:06.236246', NULL),
	(10008397, 5, 'PW21A-TS100242BL-L', 2, 0, '2021-04-15 13:06:06.284282', '2021-04-15 13:06:06.284282', NULL),
	(10008398, 5, 'PW21A-TS100242BL-XL', 2, 0, '2021-04-15 13:06:06.242388', '2021-04-15 13:06:06.242388', NULL),
	(10008399, 5, 'PW21A-TS100242BL-XXL', 1, 0, '2021-04-15 13:06:06.263160', '2021-04-15 13:06:06.263160', NULL),
	(10008400, 5, 'PW21A-TK100243BL-XS', 0, 0, '2021-04-15 13:06:06.338029', '2021-04-15 13:06:06.338029', NULL),
	(10008401, 5, 'PW21A-TK100243BL-S', 2, 0, '2021-04-15 13:06:06.284040', '2021-04-15 13:06:06.284040', NULL),
	(10008402, 5, 'PW21A-TK100243BL-M', 2, 0, '2021-04-15 13:06:06.246189', '2021-04-15 13:06:06.246189', NULL),
	(10008403, 5, 'PW21A-TK100243BL-L', 2, 0, '2021-04-15 13:06:06.357750', '2021-04-15 13:06:06.357750', NULL),
	(10008404, 5, 'PW21A-TK100243BL-XL', 2, 0, '2021-04-15 13:06:06.299477', '2021-04-15 13:06:06.299477', NULL),
	(10008405, 5, 'PW21A-TK100243BL-XXL', 2, 0, '2021-04-15 13:06:06.296421', '2021-04-15 13:06:06.296421', NULL),
	(10008406, 5, 'PW21A-TS100244BL-XS', 0, 0, '2021-04-15 13:06:06.290664', '2021-04-15 13:06:06.290664', NULL),
	(10008407, 5, 'PW21A-TS100244BL-S', 0, 0, '2021-04-15 13:06:06.298990', '2021-04-15 13:06:06.298990', NULL),
	(10008408, 5, 'PW21A-TS100244BL-M', 0, 0, '2021-04-15 13:06:06.325066', '2021-04-15 13:06:06.325066', NULL),
	(10008409, 5, 'PW21A-TS100244BL-L', 0, 0, '2021-04-15 13:06:06.288523', '2021-04-15 13:06:06.288523', NULL),
	(10008410, 5, 'PW21A-TS100244BL-XL', 0, 0, '2021-04-15 13:06:06.325778', '2021-04-15 13:06:06.325778', NULL),
	(10008411, 5, 'PW21A-TS100244BL-XXL', 0, 0, '2021-04-15 13:06:06.377375', '2021-04-15 13:06:06.377375', NULL),
	(10008412, 5, 'PW21A-TS100245RD-XS', 0, 0, '2021-04-15 13:06:06.288215', '2021-04-15 13:06:06.288215', NULL),
	(10008413, 5, 'PW21A-TS100245RD-S', 2, 0, '2021-04-15 13:06:06.326350', '2021-04-15 13:06:06.326350', NULL),
	(10008414, 5, 'PW21A-TS100245RD-M', 2, 0, '2021-04-15 13:06:06.361523', '2021-04-15 13:06:06.361523', NULL),
	(10008415, 5, 'PW21A-TS100245RD-L', 2, 0, '2021-04-15 13:06:06.313019', '2021-04-15 13:06:06.313019', NULL),
	(10008416, 5, 'PW21A-TS100245RD-XL', 2, 0, '2021-04-15 13:06:06.359305', '2021-04-15 13:06:06.359305', NULL),
	(10008417, 5, 'PW21A-TS100245RD-XXL', 1, 0, '2021-04-15 13:06:06.345398', '2021-04-15 13:06:06.345398', NULL),
	(10008418, 5, 'PW21A-TK100246BL-XS', 0, 0, '2021-04-15 13:06:06.412384', '2021-04-15 13:06:06.412384', NULL),
	(10008419, 5, 'PW21A-TK100246BL-S', 2, 0, '2021-04-15 13:06:06.390129', '2021-04-15 13:06:06.390129', NULL),
	(10008420, 5, 'PW21A-TK100246BL-M', 2, 0, '2021-04-15 13:06:06.393123', '2021-04-15 13:06:06.393123', NULL),
	(10008421, 5, 'PW21A-TK100246BL-L', 2, 0, '2021-04-15 13:06:06.369934', '2021-04-15 13:06:06.369934', NULL),
	(10008422, 5, 'PW21A-TK100246BL-XL', 2, 0, '2021-04-15 13:06:06.408010', '2021-04-15 13:06:06.408010', NULL),
	(10008423, 5, 'PW21A-TK100246BL-XXL', 2, 0, '2021-04-15 13:06:06.395529', '2021-04-15 13:06:06.395529', NULL),
	(10008424, 5, 'PW21A-TS100247NV-XS', 0, 0, '2021-04-15 13:06:06.439185', '2021-04-15 13:06:06.439185', NULL),
	(10008425, 5, 'PW21A-TS100247NV-S', 0, 0, '2021-04-15 13:06:06.405650', '2021-04-15 13:06:06.405650', NULL),
	(10008426, 5, 'PW21A-TS100247NV-M', 0, 0, '2021-04-15 13:06:06.386008', '2021-04-15 13:06:06.386008', NULL),
	(10008427, 5, 'PW21A-TS100247NV-L', 0, 0, '2021-04-15 13:06:06.420650', '2021-04-15 13:06:06.420650', NULL),
	(10008428, 5, 'PW21A-TS100247NV-XL', 0, 0, '2021-04-15 13:06:06.403652', '2021-04-15 13:06:06.403652', NULL),
	(10008429, 5, 'PW21A-TS100247NV-XXL', 1, 0, '2021-04-15 13:06:06.403214', '2021-04-15 13:06:06.403214', NULL),
	(10008430, 5, 'PW21A-TS100248BL-XS', 0, 0, '2021-04-15 13:06:06.423368', '2021-04-15 13:06:06.423368', NULL),
	(10008431, 5, 'PW21A-TS100248BL-S', 2, 0, '2021-04-15 13:06:06.468610', '2021-04-15 13:06:06.468610', NULL),
	(10008432, 5, 'PW21A-TS100248BL-M', 2, 0, '2021-04-15 13:06:06.425279', '2021-04-15 13:06:06.425279', NULL),
	(10008433, 5, 'PW21A-TS100248BL-L', 2, 0, '2021-04-15 13:06:06.406190', '2021-04-15 13:06:06.406190', NULL),
	(10008434, 5, 'PW21A-TS100248BL-XL', 2, 0, '2021-04-15 13:06:06.431915', '2021-04-15 13:06:06.431915', NULL),
	(10008435, 5, 'PW21A-TS100248BL-XXL', 2, 0, '2021-04-15 13:06:06.436000', '2021-04-15 13:06:06.436000', NULL),
	(10008436, 5, 'PW21A-TK100249WT-XS', 0, 0, '2021-04-15 13:06:06.461444', '2021-04-15 13:06:06.461444', NULL),
	(10008437, 5, 'PW21A-TK100249WT-S', 0, 0, '2021-04-15 13:06:06.471550', '2021-04-15 13:06:06.471550', NULL),
	(10008438, 5, 'PW21A-TK100249WT-M', 2, 0, '2021-04-15 13:06:06.513074', '2021-04-15 13:06:06.513074', NULL);
INSERT INTO `warehouse_product` (`id`, `warehouse_id`, `product_id`, `stock`, `reject`, `updated_at`, `created_at`, `deleted_at`) VALUES
	(10008439, 5, 'PW21A-TK100249WT-L', 2, 0, '2021-04-15 13:06:06.446134', '2021-04-15 13:06:06.446134', NULL),
	(10008440, 5, 'PW21A-TK100249WT-XL', 2, 0, '2021-04-15 13:06:06.438573', '2021-04-15 13:06:06.438573', NULL),
	(10008441, 5, 'PW21A-TK100249WT-XXL', 1, 0, '2021-04-15 13:06:06.451774', '2021-04-15 13:06:06.451774', NULL),
	(10008442, 5, 'PW21A-TS100250WT-XS', 0, 0, '2021-04-15 13:06:06.469350', '2021-04-15 13:06:06.469350', NULL),
	(10008443, 5, 'PW21A-TS100250WT-S', 2, 0, '2021-04-15 13:06:06.452258', '2021-04-15 13:06:06.452258', NULL),
	(10008444, 5, 'PW21A-TS100250WT-M', 2, 0, '2021-04-15 13:06:06.711161', '2021-04-15 13:06:06.711161', NULL),
	(10008445, 5, 'PW21A-TS100250WT-L', 2, 0, '2021-04-15 13:06:06.462992', '2021-04-15 13:06:06.462992', NULL),
	(10008446, 5, 'PW21A-TS100250WT-XL', 2, 0, '2021-04-15 13:06:06.492979', '2021-04-15 13:06:06.492979', NULL),
	(10008447, 5, 'PW21A-TS100250WT-XXL', 2, 0, '2021-04-15 13:06:06.527388', '2021-04-15 13:06:06.527388', NULL),
	(10008448, 5, 'PW21A-TS100251BL-XS', 0, 0, '2021-04-15 13:06:06.478452', '2021-04-15 13:06:06.478452', NULL),
	(10008449, 5, 'PW21A-TS100251BL-S', 2, 0, '2021-04-15 13:06:06.487077', '2021-04-15 13:06:06.487077', NULL),
	(10008450, 5, 'PW21A-TS100251BL-M', 2, 0, '2021-04-15 13:06:06.493490', '2021-04-15 13:06:06.493490', NULL),
	(10008451, 5, 'PW21A-TS100251BL-L', 2, 0, '2021-04-15 13:06:06.495363', '2021-04-15 13:06:06.495363', NULL),
	(10008452, 5, 'PW21A-TS100251BL-XL', 2, 0, '2021-04-15 13:06:06.521332', '2021-04-15 13:06:06.521332', NULL),
	(10008453, 5, 'PW21A-TS100251BL-XXL', 1, 0, '2021-04-15 13:06:06.506579', '2021-04-15 13:06:06.506579', NULL),
	(10008454, 5, 'PW21A-TS100252WT-XS', 0, 0, '2021-04-15 13:06:06.535106', '2021-04-15 13:06:06.535106', NULL),
	(10008455, 5, 'PW21A-TS100252WT-S', 2, 0, '2021-04-15 13:06:06.524929', '2021-04-15 13:06:06.524929', NULL),
	(10008456, 5, 'PW21A-TS100252WT-M', 2, 0, '2021-04-15 13:06:06.962450', '2021-04-15 13:06:06.962450', NULL),
	(10008457, 5, 'PW21A-TS100252WT-L', 2, 0, '2021-04-15 13:06:06.752131', '2021-04-15 13:06:06.752131', NULL),
	(10008458, 5, 'PW21A-TS100252WT-XL', 2, 0, '2021-04-15 13:06:06.518181', '2021-04-15 13:06:06.518181', NULL),
	(10008459, 5, 'PW21A-TS100252WT-XXL', 2, 0, '2021-04-15 13:06:06.542914', '2021-04-15 13:06:06.542914', NULL),
	(10008460, 5, 'PW21A-TS100253BL-XS', 0, 0, '2021-04-15 13:06:06.894668', '2021-04-15 13:06:06.894668', NULL),
	(10008461, 5, 'PW21A-TS100253BL-S', 2, 0, '2021-04-15 13:06:06.711583', '2021-04-15 13:06:06.711583', NULL),
	(10008462, 5, 'PW21A-TS100253BL-M', 2, 0, '2021-04-15 13:06:06.752487', '2021-04-15 13:06:06.752487', NULL),
	(10008463, 5, 'PW21A-TS100253BL-L', 2, 0, '2021-04-15 13:06:06.542388', '2021-04-15 13:06:06.542388', NULL),
	(10008464, 5, 'PW21A-TS100253BL-XL', 2, 0, '2021-04-15 13:06:06.926228', '2021-04-15 13:06:06.926228', NULL),
	(10008465, 5, 'PW21A-TS100253BL-XXL', 1, 0, '2021-04-15 13:06:06.754017', '2021-04-15 13:06:06.754017', NULL),
	(10008466, 5, 'PW21A-TK100254BL-XS', 0, 0, '2021-04-15 13:06:06.961246', '2021-04-15 13:06:06.961246', NULL),
	(10008467, 5, 'PW21A-TK100254BL-S', 2, 0, '2021-04-15 13:06:06.927493', '2021-04-15 13:06:06.927493', NULL),
	(10008468, 5, 'PW21A-TK100254BL-M', 2, 0, '2021-04-15 13:06:06.753143', '2021-04-15 13:06:06.753143', NULL),
	(10008469, 5, 'PW21A-TK100254BL-L', 2, 0, '2021-04-15 13:06:06.969484', '2021-04-15 13:06:06.969484', NULL),
	(10008470, 5, 'PW21A-TK100254BL-XL', 2, 0, '2021-04-15 13:06:06.928599', '2021-04-15 13:06:06.928599', NULL),
	(10008471, 5, 'PW21A-TK100254BL-XXL', 2, 0, '2021-04-15 13:06:06.968299', '2021-04-15 13:06:06.968299', NULL),
	(10008472, 5, 'PW21A-TS100255BL-XS', 0, 0, '2021-04-15 13:06:06.992640', '2021-04-15 13:06:06.992640', NULL),
	(10008473, 5, 'PW21A-TS100255BL-S', 2, 0, '2021-04-15 13:06:06.961167', '2021-04-15 13:06:06.961167', NULL),
	(10008474, 5, 'PW21A-TS100255BL-M', 2, 0, '2021-04-15 13:06:06.967819', '2021-04-15 13:06:06.967819', NULL),
	(10008475, 5, 'PW21A-TS100255BL-L', 1, 0, '2021-04-15 13:06:07.012209', '2021-04-15 13:06:07.012209', NULL),
	(10008476, 5, 'PW21A-TS100255BL-XL', 1, 0, '2021-04-15 13:06:07.034479', '2021-04-15 13:06:07.034479', NULL),
	(10008477, 5, 'PW21A-TS100255BL-XXL', 2, 0, '2021-04-15 13:06:06.974903', '2021-04-15 13:06:06.974903', NULL),
	(10008478, 5, 'PW21A-TK100256BL-XS', 0, 0, '2021-04-15 13:06:06.979443', '2021-04-15 13:06:06.979443', NULL),
	(10008479, 5, 'PW21A-TK100256BL-S', 1, 0, '2021-04-15 13:06:06.965577', '2021-04-15 13:06:06.965577', NULL),
	(10008480, 5, 'PW21A-TK100256BL-M', 2, 0, '2021-04-15 13:06:06.981885', '2021-04-15 13:06:06.981885', NULL),
	(10008481, 5, 'PW21A-TK100256BL-L', 2, 0, '2021-04-15 13:06:06.998758', '2021-04-15 13:06:06.998758', NULL),
	(10008482, 5, 'PW21A-TK100256BL-XL', 2, 0, '2021-04-15 13:06:06.994550', '2021-04-15 13:06:06.994550', NULL),
	(10008483, 5, 'PW21A-TK100256BL-XXL', 2, 0, '2021-04-15 13:06:06.997280', '2021-04-15 13:06:06.997280', NULL),
	(10008484, 5, 'PW21A-TS100257WT-XS', 0, 0, '2021-04-15 13:06:07.001476', '2021-04-15 13:06:07.001476', NULL),
	(10008485, 5, 'PW21A-TS100257WT-S', 0, 0, '2021-04-15 13:06:06.999635', '2021-04-15 13:06:06.999635', NULL),
	(10008486, 5, 'PW21A-TS100257WT-M', 0, 0, '2021-04-15 13:06:07.025244', '2021-04-15 13:06:07.025244', NULL),
	(10008487, 5, 'PW21A-TS100257WT-L', 0, 0, '2021-04-15 13:06:06.999199', '2021-04-15 13:06:06.999199', NULL),
	(10008488, 5, 'PW21A-TS100257WT-XL', 0, 0, '2021-04-15 13:06:07.104133', '2021-04-15 13:06:07.104133', NULL),
	(10008489, 5, 'PW21A-TS100257WT-XXL', 0, 0, '2021-04-15 13:06:07.008120', '2021-04-15 13:06:07.008120', NULL),
	(10008490, 5, 'PW21A-TS100258WT-XS', 0, 0, '2021-04-15 13:06:07.048295', '2021-04-15 13:06:07.048295', NULL),
	(10008491, 5, 'PW21A-TS100258WT-S', 2, 0, '2021-04-15 13:06:07.014669', '2021-04-15 13:06:07.014669', NULL),
	(10008492, 5, 'PW21A-TS100258WT-M', 2, 0, '2021-04-15 13:06:07.075423', '2021-04-15 13:06:07.075423', NULL),
	(10008493, 5, 'PW21A-TS100258WT-L', 2, 0, '2021-04-15 13:06:07.024401', '2021-04-15 13:06:07.024401', NULL),
	(10008494, 5, 'PW21A-TS100258WT-XL', 2, 0, '2021-04-15 13:06:07.033816', '2021-04-15 13:06:07.033816', NULL),
	(10008495, 5, 'PW21A-TS100258WT-XXL', 1, 0, '2021-04-15 13:06:07.071423', '2021-04-15 13:06:07.071423', NULL),
	(10008496, 5, 'PW21A-TS100259BL-XS', 0, 0, '2021-04-15 13:06:07.058937', '2021-04-15 13:06:07.058937', NULL),
	(10008497, 5, 'PW21A-TS100259BL-S', 2, 0, '2021-04-15 13:06:07.037660', '2021-04-15 13:06:07.037660', NULL),
	(10008498, 5, 'PW21A-TS100259BL-M', 2, 0, '2021-04-15 13:06:07.039305', '2021-04-15 13:06:07.039305', NULL),
	(10008499, 5, 'PW21A-TS100259BL-L', 2, 0, '2021-04-15 13:06:07.110346', '2021-04-15 13:06:07.110346', NULL),
	(10008500, 5, 'PW21A-TS100259BL-XL', 2, 0, '2021-04-15 13:06:07.040239', '2021-04-15 13:06:07.040239', NULL),
	(10008501, 5, 'PW21A-TS100259BL-XXL', 1, 0, '2021-04-15 13:06:07.078692', '2021-04-15 13:06:07.078692', NULL),
	(10008502, 5, 'PW21A-TS100260BL-XS', 0, 0, '2021-04-15 13:06:07.108600', '2021-04-15 13:06:07.108600', NULL),
	(10008503, 5, 'PW21A-TS100260BL-S', 2, 0, '2021-04-15 13:06:07.061984', '2021-04-15 13:06:07.061984', NULL),
	(10008504, 5, 'PW21A-TS100260BL-M', 2, 0, '2021-04-15 13:06:07.077208', '2021-04-15 13:06:07.077208', NULL),
	(10008505, 5, 'PW21A-TS100260BL-L', 2, 0, '2021-04-15 13:06:07.079200', '2021-04-15 13:06:07.079200', NULL),
	(10008506, 5, 'PW21A-TS100260BL-XL', 2, 0, '2021-04-15 13:06:07.080844', '2021-04-15 13:06:07.080844', NULL),
	(10008507, 5, 'PW21A-TS100260BL-XXL', 2, 0, '2021-04-15 13:06:07.072168', '2021-04-15 13:06:07.072168', NULL),
	(10008508, 5, 'PW21A-TS100261BL-XS', 0, 0, '2021-04-15 13:06:07.125591', '2021-04-15 13:06:07.125591', NULL),
	(10008509, 5, 'PW21A-TS100261BL-S', 2, 0, '2021-04-15 13:06:07.094602', '2021-04-15 13:06:07.094602', NULL),
	(10008510, 5, 'PW21A-TS100261BL-M', 2, 0, '2021-04-15 13:06:07.076683', '2021-04-15 13:06:07.076683', NULL),
	(10008511, 5, 'PW21A-TS100261BL-L', 2, 0, '2021-04-15 13:06:07.109142', '2021-04-15 13:06:07.109142', NULL),
	(10008512, 5, 'PW21A-TS100261BL-XL', 2, 0, '2021-04-15 13:06:07.093345', '2021-04-15 13:06:07.093345', NULL),
	(10008513, 5, 'PW21A-TS100261BL-XXL', 1, 0, '2021-04-15 13:06:07.109702', '2021-04-15 13:06:07.109702', NULL),
	(10008514, 5, 'PW21A-TS100262BL-XS', 0, 0, '2021-04-15 13:06:07.110809', '2021-04-15 13:06:07.110809', NULL),
	(10008515, 5, 'PW21A-TS100262BL-S', 2, 0, '2021-04-15 13:06:07.150317', '2021-04-15 13:06:07.150317', NULL),
	(10008516, 5, 'PW21A-TS100262BL-M', 2, 0, '2021-04-15 13:06:07.107334', '2021-04-15 13:06:07.107334', NULL),
	(10008517, 5, 'PW21A-TS100262BL-L', 2, 0, '2021-04-15 13:06:07.103027', '2021-04-15 13:06:07.103027', NULL),
	(10008518, 5, 'PW21A-TS100262BL-XL', 2, 0, '2021-04-15 13:06:07.144327', '2021-04-15 13:06:07.144327', NULL),
	(10008519, 5, 'PW21A-TS100262BL-XXL', 2, 0, '2021-04-15 13:06:07.146772', '2021-04-15 13:06:07.146772', NULL),
	(10008520, 5, 'PW21A-TS100263BL-XS', 0, 0, '2021-04-15 13:06:07.142405', '2021-04-15 13:06:07.142405', NULL),
	(10008521, 5, 'PW21A-TS100263BL-S', 4, 0, '2021-04-15 13:06:07.140146', '2021-04-15 13:06:07.140146', NULL),
	(10008522, 5, 'PW21A-TS100263BL-M', 2, 0, '2021-04-15 13:06:07.145872', '2021-04-15 13:06:07.145872', NULL),
	(10008523, 5, 'PW21A-TS100263BL-L', 4, 0, '2021-04-15 13:06:07.126420', '2021-04-15 13:06:07.126420', NULL),
	(10008524, 5, 'PW21A-TS100263BL-XL', 2, 0, '2021-04-15 13:06:07.170475', '2021-04-15 13:06:07.170475', NULL),
	(10008525, 5, 'PW21A-TS100263BL-XXL', 2, 0, '2021-04-15 13:06:07.212242', '2021-04-15 13:06:07.212242', NULL),
	(10008526, 5, 'PW21A-TS100264WH-XS', 0, 0, '2021-04-15 13:06:07.179044', '2021-04-15 13:06:07.179044', NULL),
	(10008527, 5, 'PW21A-TS100264WH-S', 0, 0, '2021-04-15 13:06:07.194822', '2021-04-15 13:06:07.194822', NULL),
	(10008528, 5, 'PW21A-TS100264WH-M', 0, 0, '2021-04-15 13:06:07.147363', '2021-04-15 13:06:07.147363', NULL),
	(10008529, 5, 'PW21A-TS100264WH-L', 0, 0, '2021-04-15 13:06:07.193584', '2021-04-15 13:06:07.193584', NULL),
	(10008530, 5, 'PW21A-TS100264WH-XL', 0, 0, '2021-04-15 13:06:07.150848', '2021-04-15 13:06:07.150848', NULL),
	(10008531, 5, 'PW21A-TS100264WH-XXL', 0, 0, '2021-04-15 13:06:07.172070', '2021-04-15 13:06:07.172070', NULL),
	(10008532, 5, 'PW21A-TS100265RD-XS', 0, 0, '2021-04-15 13:06:07.192533', '2021-04-15 13:06:07.192533', NULL),
	(10008533, 5, 'PW21A-TS100265RD-S', 2, 0, '2021-04-15 13:06:07.234382', '2021-04-15 13:06:07.234382', NULL),
	(10008534, 5, 'PW21A-TS100265RD-M', 2, 0, '2021-04-15 13:06:07.190659', '2021-04-15 13:06:07.190659', NULL),
	(10008535, 5, 'PW21A-TS100265RD-L', 2, 0, '2021-04-15 13:06:07.198955', '2021-04-15 13:06:07.198955', NULL),
	(10008536, 5, 'PW21A-TS100265RD-XL', 2, 0, '2021-04-15 13:06:07.203134', '2021-04-15 13:06:07.203134', NULL),
	(10008537, 5, 'PW21A-TS100265RD-XXL', 2, 0, '2021-04-15 13:06:07.233341', '2021-04-15 13:06:07.233341', NULL),
	(10008538, 5, 'PW21A-TS100266BL-XS', 0, 0, '2021-04-15 13:06:07.194195', '2021-04-15 13:06:07.194195', NULL),
	(10008539, 5, 'PW21A-TS100266BL-S', 2, 0, '2021-04-15 13:06:07.245505', '2021-04-15 13:06:07.245505', NULL),
	(10008540, 5, 'PW21A-TS100266BL-M', 2, 0, '2021-04-15 13:06:07.212908', '2021-04-15 13:06:07.212908', NULL),
	(10008541, 5, 'PW21A-TS100266BL-L', 2, 0, '2021-04-15 13:06:07.229228', '2021-04-15 13:06:07.229228', NULL),
	(10008542, 5, 'PW21A-TS100266BL-XL', 2, 0, '2021-04-15 13:06:07.232498', '2021-04-15 13:06:07.232498', NULL),
	(10008543, 5, 'PW21A-TS100266BL-XXL', 2, 0, '2021-04-15 13:06:07.216424', '2021-04-15 13:06:07.216424', NULL),
	(10008544, 5, 'PW21A-TS100267BL-XS', 0, 0, '2021-04-15 13:06:07.256111', '2021-04-15 13:06:07.256111', NULL),
	(10008545, 5, 'PW21A-TS100267BL-S', 2, 0, '2021-04-15 13:06:07.228864', '2021-04-15 13:06:07.228864', NULL),
	(10008546, 5, 'PW21A-TS100267BL-M', 2, 0, '2021-04-15 13:06:07.243862', '2021-04-15 13:06:07.243862', NULL),
	(10008547, 5, 'PW21A-TS100267BL-L', 2, 0, '2021-04-15 13:06:07.233920', '2021-04-15 13:06:07.233920', NULL),
	(10008548, 5, 'PW21A-TS100267BL-XL', 2, 0, '2021-04-15 13:06:07.236846', '2021-04-15 13:06:07.236846', NULL),
	(10008549, 5, 'PW21A-TS100267BL-XXL', 2, 0, '2021-04-15 13:06:07.243559', '2021-04-15 13:06:07.243559', NULL),
	(10008550, 5, 'PW21A-TS100268BL-XS', 0, 0, '2021-04-15 13:06:07.255676', '2021-04-15 13:06:07.255676', NULL),
	(10008551, 5, 'PW21A-TS100268BL-S', 2, 0, '2021-04-15 13:06:07.288600', '2021-04-15 13:06:07.288600', NULL),
	(10008552, 5, 'PW21A-TS100268BL-M', 2, 0, '2021-04-15 13:06:07.258353', '2021-04-15 13:06:07.258353', NULL),
	(10008553, 5, 'PW21A-TS100268BL-L', 2, 0, '2021-04-15 13:06:07.260835', '2021-04-15 13:06:07.260835', NULL),
	(10008554, 5, 'PW21A-TS100268BL-XL', 2, 0, '2021-04-15 13:06:07.257184', '2021-04-15 13:06:07.257184', NULL),
	(10008555, 5, 'PW21A-TS100268BL-XXL', 2, 0, '2021-04-15 13:06:07.257816', '2021-04-15 13:06:07.257816', NULL),
	(10008556, 5, 'PW21A-TS100269BL-XS', 0, 0, '2021-04-15 13:06:07.260187', '2021-04-15 13:06:07.260187', NULL),
	(10008557, 5, 'PW21A-TS100269BL-S', 1, 0, '2021-04-15 13:06:07.289754', '2021-04-15 13:06:07.289754', NULL),
	(10008558, 5, 'PW21A-TS100269BL-M', 2, 0, '2021-04-15 13:06:07.285033', '2021-04-15 13:06:07.285033', NULL),
	(10008559, 5, 'PW21A-TS100269BL-L', 2, 0, '2021-04-15 13:06:07.272243', '2021-04-15 13:06:07.272243', NULL),
	(10008560, 5, 'PW21A-TS100269BL-XL', 2, 0, '2021-04-15 13:06:07.287639', '2021-04-15 13:06:07.287639', NULL),
	(10008561, 5, 'PW21A-TS100269BL-XXL', 2, 0, '2021-04-15 13:06:07.293968', '2021-04-15 13:06:07.293968', NULL),
	(10008562, 5, 'PW21A-TS100270BL-XS', 0, 0, '2021-04-15 13:06:07.275311', '2021-04-15 13:06:07.275311', NULL),
	(10008563, 5, 'PW21A-TS100270BL-S', 0, 0, '2021-04-15 13:06:07.275679', '2021-04-15 13:06:07.275679', NULL),
	(10008564, 5, 'PW21A-TS100270BL-M', 0, 0, '2021-04-15 13:06:07.305510', '2021-04-15 13:06:07.305510', NULL),
	(10008565, 5, 'PW21A-TS100270BL-L', 0, 0, '2021-04-15 13:06:07.319132', '2021-04-15 13:06:07.319132', NULL),
	(10008566, 5, 'PW21A-TS100270BL-XL', 0, 0, '2021-04-15 13:06:07.288110', '2021-04-15 13:06:07.288110', NULL),
	(10008567, 5, 'PW21A-TS100270BL-XXL', 0, 0, '2021-04-15 13:06:07.288909', '2021-04-15 13:06:07.288909', NULL),
	(10008568, 5, 'PW21A-TS100271BL-XS', 0, 0, '2021-04-15 13:06:07.305822', '2021-04-15 13:06:07.305822', NULL),
	(10008569, 5, 'PW21A-TS100271BL-S', 2, 0, '2021-04-15 13:06:07.299050', '2021-04-15 13:06:07.299050', NULL),
	(10008570, 5, 'PW21A-TS100271BL-M', 2, 0, '2021-04-15 13:06:07.341433', '2021-04-15 13:06:07.341433', NULL),
	(10008571, 5, 'PW21A-TS100271BL-L', 2, 0, '2021-04-15 13:06:07.316751', '2021-04-15 13:06:07.316751', NULL),
	(10008572, 5, 'PW21A-TS100271BL-XL', 2, 0, '2021-04-15 13:06:07.316342', '2021-04-15 13:06:07.316342', NULL),
	(10008573, 5, 'PW21A-TS100271BL-XXL', 1, 0, '2021-04-15 13:06:07.314979', '2021-04-15 13:06:07.314979', NULL),
	(10008574, 5, 'PW21A-TS100272BL-XS', 0, 0, '2021-04-15 13:06:07.327156', '2021-04-15 13:06:07.327156', NULL),
	(10008575, 5, 'PW21A-TS100272BL-S', 2, 0, '2021-04-15 13:06:07.341093', '2021-04-15 13:06:07.341093', NULL),
	(10008576, 5, 'PW21A-TS100272BL-M', 2, 0, '2021-04-15 13:06:07.321825', '2021-04-15 13:06:07.321825', NULL),
	(10008577, 5, 'PW21A-TS100272BL-L', 2, 0, '2021-04-15 13:06:07.317971', '2021-04-15 13:06:07.317971', NULL),
	(10008578, 5, 'PW21A-TS100272BL-XL', 2, 0, '2021-04-15 13:06:07.325624', '2021-04-15 13:06:07.325624', NULL),
	(10008579, 5, 'PW21A-TS100272BL-XXL', 1, 0, '2021-04-15 13:06:07.324940', '2021-04-15 13:06:07.324940', NULL),
	(10008580, 5, 'PW21A-TS100273WT-XS', 0, 0, '2021-04-15 13:06:07.343721', '2021-04-15 13:06:07.343721', NULL),
	(10008581, 5, 'PW21A-TS100273WT-S', 2, 0, '2021-04-15 13:06:07.328900', '2021-04-15 13:06:07.328900', NULL),
	(10008582, 5, 'PW21A-TS100273WT-M', 2, 0, '2021-04-15 13:06:07.351984', '2021-04-15 13:06:07.351984', NULL),
	(10008583, 5, 'PW21A-TS100273WT-L', 2, 0, '2021-04-15 13:06:07.386550', '2021-04-15 13:06:07.386550', NULL),
	(10008584, 5, 'PW21A-TS100273WT-XL', 2, 0, '2021-04-15 13:06:07.339096', '2021-04-15 13:06:07.339096', NULL),
	(10008585, 5, 'PW21A-TS100273WT-XXL', 1, 0, '2021-04-15 13:06:07.341719', '2021-04-15 13:06:07.341719', NULL),
	(10008586, 5, 'PW21A-TS100274BL-XS', 0, 0, '2021-04-15 13:06:07.368151', '2021-04-15 13:06:07.368151', NULL),
	(10008587, 5, 'PW21A-TS100274BL-S', 2, 0, '2021-04-15 13:06:07.431291', '2021-04-15 13:06:07.431291', NULL),
	(10008588, 5, 'PW21A-TS100274BL-M', 2, 0, '2021-04-15 13:06:07.355874', '2021-04-15 13:06:07.355874', NULL),
	(10008589, 5, 'PW21A-TS100274BL-L', 2, 0, '2021-04-15 13:06:07.359942', '2021-04-15 13:06:07.359942', NULL),
	(10008590, 5, 'PW21A-TS100274BL-XL', 2, 0, '2021-04-15 13:06:07.386002', '2021-04-15 13:06:07.386002', NULL),
	(10008591, 5, 'PW21A-TS100274BL-XXL', 1, 0, '2021-04-15 13:06:07.406012', '2021-04-15 13:06:07.406012', NULL),
	(10008592, 5, 'PW21A-TS100275BL-XS', 0, 0, '2021-04-15 13:06:07.383005', '2021-04-15 13:06:07.383005', NULL),
	(10008593, 5, 'PW21A-TS100275BL-S', 2, 0, '2021-04-15 13:06:07.372105', '2021-04-15 13:06:07.372105', NULL),
	(10008594, 5, 'PW21A-TS100275BL-M', 2, 0, '2021-04-15 13:06:07.360325', '2021-04-15 13:06:07.360325', NULL),
	(10008595, 5, 'PW21A-TS100275BL-L', 2, 0, '2021-04-15 13:06:07.389258', '2021-04-15 13:06:07.389258', NULL),
	(10008596, 5, 'PW21A-TS100275BL-XL', 2, 0, '2021-04-15 13:06:07.376822', '2021-04-15 13:06:07.376822', NULL),
	(10008597, 5, 'PW21A-TS100275BL-XXL', 1, 0, '2021-04-15 13:06:07.378408', '2021-04-15 13:06:07.378408', NULL),
	(10008598, 5, 'PW21A-TS100276WT-XS', 0, 0, '2021-04-15 13:06:07.392791', '2021-04-15 13:06:07.392791', NULL),
	(10008599, 5, 'PW21A-TS100276WT-S', 2, 0, '2021-04-15 13:06:07.393933', '2021-04-15 13:06:07.393933', NULL),
	(10008600, 5, 'PW21A-TS100276WT-M', 2, 0, '2021-04-15 13:06:07.402415', '2021-04-15 13:06:07.402415', NULL),
	(10008601, 5, 'PW21A-TS100276WT-L', 2, 0, '2021-04-15 13:06:07.412356', '2021-04-15 13:06:07.412356', NULL),
	(10008602, 5, 'PW21A-TS100276WT-XL', 2, 0, '2021-04-15 13:06:07.422720', '2021-04-15 13:06:07.422720', NULL),
	(10008603, 5, 'PW21A-TS100276WT-XXL', 1, 0, '2021-04-15 13:06:07.416643', '2021-04-15 13:06:07.416643', NULL),
	(10008604, 5, 'PW21A-TS100277BL-XS', 0, 0, '2021-04-15 13:06:07.419929', '2021-04-15 13:06:07.419929', NULL),
	(10008605, 5, 'PW21A-TS100277BL-S', 2, 0, '2021-04-15 13:06:07.469390', '2021-04-15 13:06:07.469390', NULL),
	(10008606, 5, 'PW21A-TS100277BL-M', 2, 0, '2021-04-15 13:06:07.413994', '2021-04-15 13:06:07.413994', NULL),
	(10008607, 5, 'PW21A-TS100277BL-L', 2, 0, '2021-04-15 13:06:07.434337', '2021-04-15 13:06:07.434337', NULL),
	(10008608, 5, 'PW21A-TS100277BL-XL', 2, 0, '2021-04-15 13:06:07.426849', '2021-04-15 13:06:07.426849', NULL),
	(10008609, 5, 'PW21A-TS100277BL-XXL', 1, 0, '2021-04-15 13:06:07.419613', '2021-04-15 13:06:07.419613', NULL),
	(10008610, 5, 'PW21A-TS100278BL-XS', 0, 0, '2021-04-15 13:06:07.425099', '2021-04-15 13:06:07.425099', NULL),
	(10008611, 5, 'PW21A-TS100278BL-S', 2, 0, '2021-04-15 13:06:07.451870', '2021-04-15 13:06:07.451870', NULL),
	(10008612, 5, 'PW21A-TS100278BL-M', 2, 0, '2021-04-15 13:06:07.473565', '2021-04-15 13:06:07.473565', NULL),
	(10008613, 5, 'PW21A-TS100278BL-L', 2, 0, '2021-04-15 13:06:07.435857', '2021-04-15 13:06:07.435857', NULL),
	(10008614, 5, 'PW21A-TS100278BL-XL', 2, 0, '2021-04-15 13:06:07.436668', '2021-04-15 13:06:07.436668', NULL),
	(10008615, 5, 'PW21A-TS100278BL-XXL', 1, 0, '2021-04-15 13:06:07.437169', '2021-04-15 13:06:07.437169', NULL),
	(10008616, 5, 'PW21A-TS100279WT-XS', 0, 0, '2021-04-15 13:06:07.440873', '2021-04-15 13:06:07.440873', NULL),
	(10008617, 5, 'PW21A-TS100279WT-S', 2, 0, '2021-04-15 13:06:07.447159', '2021-04-15 13:06:07.447159', NULL),
	(10008618, 5, 'PW21A-TS100279WT-M', 2, 0, '2021-04-15 13:06:07.475085', '2021-04-15 13:06:07.475085', NULL),
	(10008619, 5, 'PW21A-TS100279WT-L', 2, 0, '2021-04-15 13:06:07.493507', '2021-04-15 13:06:07.493507', NULL),
	(10008620, 5, 'PW21A-TS100279WT-XL', 2, 0, '2021-04-15 13:06:07.453633', '2021-04-15 13:06:07.453633', NULL),
	(10008621, 5, 'PW21A-TS100279WT-XXL', 1, 0, '2021-04-15 13:06:07.476785', '2021-04-15 13:06:07.476785', NULL),
	(10008622, 5, 'PW21A-TS100280BL-XS', 0, 0, '2021-04-15 13:06:07.465486', '2021-04-15 13:06:07.465486', NULL),
	(10008623, 5, 'PW21A-TS100280BL-S', 0, 0, '2021-04-15 13:06:07.488973', '2021-04-15 13:06:07.488973', NULL),
	(10008624, 5, 'PW21A-TS100280BL-M', 0, 0, '2021-04-15 13:06:07.490925', '2021-04-15 13:06:07.490925', NULL),
	(10008625, 5, 'PW21A-TS100280BL-L', 0, 0, '2021-04-15 13:06:07.512009', '2021-04-15 13:06:07.512009', NULL),
	(10008626, 5, 'PW21A-TS100280BL-XL', 0, 0, '2021-04-15 13:06:07.491226', '2021-04-15 13:06:07.491226', NULL),
	(10008627, 5, 'PW21A-TS100280BL-XXL', 0, 0, '2021-04-15 13:06:07.480980', '2021-04-15 13:06:07.480980', NULL),
	(10008628, 5, 'PW21A-TS100281BL-XS', 0, 0, '2021-04-15 13:06:07.499804', '2021-04-15 13:06:07.499804', NULL),
	(10008629, 5, 'PW21A-TS100281BL-S', 0, 0, '2021-04-15 13:06:07.478126', '2021-04-15 13:06:07.478126', NULL),
	(10008630, 5, 'PW21A-TS100281BL-M', 0, 0, '2021-04-15 13:06:07.514202', '2021-04-15 13:06:07.514202', NULL),
	(10008631, 5, 'PW21A-TS100281BL-L', 0, 0, '2021-04-15 13:06:07.485900', '2021-04-15 13:06:07.485900', NULL),
	(10008632, 5, 'PW21A-TS100281BL-XL', 0, 0, '2021-04-15 13:06:07.511726', '2021-04-15 13:06:07.511726', NULL),
	(10008633, 5, 'PW21A-TS100281BL-XXL', 0, 0, '2021-04-15 13:06:07.514593', '2021-04-15 13:06:07.514593', NULL),
	(10008634, 5, 'PW21A-TS100282BL-XS', 0, 0, '2021-04-15 13:06:07.522896', '2021-04-15 13:06:07.522896', NULL),
	(10008635, 5, 'PW21A-TS100282BL-S', 0, 0, '2021-04-15 13:06:07.509439', '2021-04-15 13:06:07.509439', NULL),
	(10008636, 5, 'PW21A-TS100282BL-M', 0, 0, '2021-04-15 13:06:07.547945', '2021-04-15 13:06:07.547945', NULL),
	(10008637, 5, 'PW21A-TS100282BL-L', 0, 0, '2021-04-15 13:06:07.507061', '2021-04-15 13:06:07.507061', NULL),
	(10008638, 5, 'PW21A-TS100282BL-XL', 0, 0, '2021-04-15 13:06:07.506244', '2021-04-15 13:06:07.506244', NULL),
	(10008639, 5, 'PW21A-TS100282BL-XXL', 0, 0, '2021-04-15 13:06:07.547051', '2021-04-15 13:06:07.547051', NULL),
	(10008640, 5, 'PW21A-TS100283BL-XS', 0, 0, '2021-04-15 13:06:07.548212', '2021-04-15 13:06:07.548212', NULL),
	(10008641, 5, 'PW21A-TS100283BL-S', 0, 0, '2021-04-15 13:06:07.571976', '2021-04-15 13:06:07.571976', NULL),
	(10008642, 5, 'PW21A-TS100283BL-M', 0, 0, '2021-04-15 13:06:07.572418', '2021-04-15 13:06:07.572418', NULL),
	(10008643, 5, 'PW21A-TS100283BL-L', 0, 0, '2021-04-15 13:06:07.547369', '2021-04-15 13:06:07.547369', NULL),
	(10008644, 5, 'PW21A-TS100283BL-XL', 0, 0, '2021-04-15 13:06:07.502644', '2021-04-15 13:06:07.502644', NULL),
	(10008645, 5, 'PW21A-TS100283BL-XXL', 0, 0, '2021-04-15 13:06:07.548493', '2021-04-15 13:06:07.548493', NULL),
	(10008646, 5, 'PW21A-TS100284BL-XS', 0, 0, '2021-04-15 13:06:07.548991', '2021-04-15 13:06:07.548991', NULL),
	(10008647, 5, 'PW21A-TS100284BL-S', 0, 0, '2021-04-15 13:06:07.549518', '2021-04-15 13:06:07.549518', NULL),
	(10008648, 5, 'PW21A-TS100284BL-M', 0, 0, '2021-04-15 13:06:07.547663', '2021-04-15 13:06:07.547663', NULL),
	(10008649, 5, 'PW21A-TS100284BL-L', 0, 0, '2021-04-15 13:06:07.570598', '2021-04-15 13:06:07.570598', NULL),
	(10008650, 5, 'PW21A-TS100284BL-XL', 0, 0, '2021-04-15 13:06:07.570153', '2021-04-15 13:06:07.570153', NULL),
	(10008651, 5, 'PW21A-TS100284BL-XXL', 0, 0, '2021-04-15 13:06:07.595937', '2021-04-15 13:06:07.595937', NULL),
	(10008652, 5, 'PW21A-TS100285BL-XS', 0, 0, '2021-04-15 13:06:07.597188', '2021-04-15 13:06:07.597188', NULL),
	(10008653, 5, 'PW21A-TS100285BL-S', 0, 0, '2021-04-15 13:06:07.615668', '2021-04-15 13:06:07.615668', NULL),
	(10008654, 5, 'PW21A-TS100285BL-M', 0, 0, '2021-04-15 13:06:07.548746', '2021-04-15 13:06:07.548746', NULL),
	(10008655, 5, 'PW21A-TS100285BL-L', 0, 0, '2021-04-15 13:06:07.549268', '2021-04-15 13:06:07.549268', NULL),
	(10008656, 5, 'PW21A-TS100285BL-XL', 0, 0, '2021-04-15 13:06:07.593823', '2021-04-15 13:06:07.593823', NULL),
	(10008657, 5, 'PW21A-TS100285BL-XXL', 0, 0, '2021-04-15 13:06:07.575176', '2021-04-15 13:06:07.575176', NULL),
	(10008658, 5, 'PW21A-TS100286BL-XS', 0, 0, '2021-04-15 13:06:07.596867', '2021-04-15 13:06:07.596867', NULL),
	(10008659, 5, 'PW21A-TS100286BL-S', 0, 0, '2021-04-15 13:06:07.573244', '2021-04-15 13:06:07.573244', NULL),
	(10008660, 5, 'PW21A-TS100286BL-M', 0, 0, '2021-04-15 13:06:07.575621', '2021-04-15 13:06:07.575621', NULL),
	(10008661, 5, 'PW21A-TS100286BL-L', 0, 0, '2021-04-15 13:06:07.576095', '2021-04-15 13:06:07.576095', NULL),
	(10008662, 5, 'PW21A-TS100286BL-XL', 0, 0, '2021-04-15 13:06:07.574750', '2021-04-15 13:06:07.574750', NULL),
	(10008663, 5, 'PW21A-TS100286BL-XXL', 0, 0, '2021-04-15 13:06:07.594817', '2021-04-15 13:06:07.594817', NULL),
	(10008664, 5, 'PW21A-TS100287BL-XS', 0, 0, '2021-04-15 13:06:07.572832', '2021-04-15 13:06:07.572832', NULL),
	(10008665, 5, 'PW21A-TS100287BL-S', 0, 0, '2021-04-15 13:06:07.595117', '2021-04-15 13:06:07.595117', NULL),
	(10008666, 5, 'PW21A-TS100287BL-M', 0, 0, '2021-04-15 13:06:07.633330', '2021-04-15 13:06:07.633330', NULL),
	(10008667, 5, 'PW21A-TS100287BL-L', 0, 0, '2021-04-15 13:06:07.595638', '2021-04-15 13:06:07.595638', NULL),
	(10008668, 5, 'PW21A-TS100287BL-XL', 0, 0, '2021-04-15 13:06:07.613188', '2021-04-15 13:06:07.613188', NULL),
	(10008669, 5, 'PW21A-TS100287BL-XXL', 0, 0, '2021-04-15 13:06:07.597491', '2021-04-15 13:06:07.597491', NULL),
	(10008670, 5, 'PW21A-TS100288BL-XS', 0, 0, '2021-04-15 13:06:07.615937', '2021-04-15 13:06:07.615937', NULL),
	(10008671, 5, 'PW21A-TS100288BL-S', 0, 0, '2021-04-15 13:06:07.598881', '2021-04-15 13:06:07.598881', NULL),
	(10008672, 5, 'PW21A-TS100288BL-M', 0, 0, '2021-04-15 13:06:07.620936', '2021-04-15 13:06:07.620936', NULL),
	(10008673, 5, 'PW21A-TS100288BL-L', 0, 0, '2021-04-15 13:06:07.600221', '2021-04-15 13:06:07.600221', NULL),
	(10008674, 5, 'PW21A-TS100288BL-XL', 0, 0, '2021-04-15 13:06:07.616420', '2021-04-15 13:06:07.616420', NULL),
	(10008675, 5, 'PW21A-TS100288BL-XXL', 0, 0, '2021-04-15 13:06:07.662709', '2021-04-15 13:06:07.662709', NULL),
	(10008676, 5, 'PW21A-TS100289BL-XS', 0, 0, '2021-04-15 13:06:07.615157', '2021-04-15 13:06:07.615157', NULL),
	(10008677, 5, 'PW21A-TS100289BL-S', 0, 0, '2021-04-15 13:06:07.614748', '2021-04-15 13:06:07.614748', NULL),
	(10008678, 5, 'PW21A-TS100289BL-M', 0, 0, '2021-04-15 13:06:07.616682', '2021-04-15 13:06:07.616682', NULL),
	(10008679, 5, 'PW21A-TS100289BL-L', 0, 0, '2021-04-15 13:06:07.619466', '2021-04-15 13:06:07.619466', NULL),
	(10008680, 5, 'PW21A-TS100289BL-XL', 0, 0, '2021-04-15 13:06:07.634711', '2021-04-15 13:06:07.634711', NULL),
	(10008681, 5, 'PW21A-TS100289BL-XXL', 0, 0, '2021-04-15 13:06:07.618429', '2021-04-15 13:06:07.618429', NULL),
	(10008682, 5, 'PW21A-TS100290OL-XS', 0, 0, '2021-04-15 13:06:07.635806', '2021-04-15 13:06:07.635806', NULL),
	(10008683, 5, 'PW21A-TS100290OL-S', 0, 0, '2021-04-15 13:06:07.635011', '2021-04-15 13:06:07.635011', NULL),
	(10008684, 5, 'PW21A-TS100290OL-M', 0, 0, '2021-04-15 13:06:07.684670', '2021-04-15 13:06:07.684670', NULL),
	(10008685, 5, 'PW21A-TS100290OL-L', 0, 0, '2021-04-15 13:06:07.635534', '2021-04-15 13:06:07.635534', NULL),
	(10008686, 5, 'PW21A-TS100290OL-XL', 0, 0, '2021-04-15 13:06:07.638261', '2021-04-15 13:06:07.638261', NULL),
	(10008687, 5, 'PW21A-TS100290OL-XXL', 0, 0, '2021-04-15 13:06:07.636699', '2021-04-15 13:06:07.636699', NULL),
	(10008688, 5, 'PW21A-TS100291BL-XS', 0, 0, '2021-04-15 13:06:07.661740', '2021-04-15 13:06:07.661740', NULL),
	(10008689, 5, 'PW21A-TS100291BL-S', 0, 0, '2021-04-15 13:06:07.639352', '2021-04-15 13:06:07.639352', NULL),
	(10008690, 5, 'PW21A-TS100291BL-M', 0, 0, '2021-04-15 13:06:07.636975', '2021-04-15 13:06:07.636975', NULL),
	(10008691, 5, 'PW21A-TS100291BL-L', 0, 0, '2021-04-15 13:06:07.664157', '2021-04-15 13:06:07.664157', NULL),
	(10008692, 5, 'PW21A-TS100291BL-XL', 0, 0, '2021-04-15 13:06:07.641017', '2021-04-15 13:06:07.641017', NULL),
	(10008693, 5, 'PW21A-TS100291BL-XXL', 0, 0, '2021-04-15 13:06:07.665352', '2021-04-15 13:06:07.665352', NULL),
	(10008694, 5, 'PW21A-TS100292NV-XS', 0, 0, '2021-04-15 13:06:07.668254', '2021-04-15 13:06:07.668254', NULL),
	(10008695, 5, 'PW21A-TS100292NV-S', 1, 0, '2021-04-15 13:06:07.664544', '2021-04-15 13:06:07.664544', NULL),
	(10008696, 5, 'PW21A-TS100292NV-M', 4, 0, '2021-04-15 13:06:07.666676', '2021-04-15 13:06:07.666676', NULL),
	(10008697, 5, 'PW21A-TS100292NV-L', 0, 0, '2021-04-15 13:06:07.682415', '2021-04-15 13:06:07.682415', NULL),
	(10008698, 5, 'PW21A-TS100292NV-XL', 1, 0, '2021-04-15 13:06:07.666398', '2021-04-15 13:06:07.666398', NULL),
	(10008699, 5, 'PW21A-TS100292NV-XXL', 0, 0, '2021-04-15 13:06:07.667552', '2021-04-15 13:06:07.667552', NULL),
	(10008700, 5, 'PW21A-TS100293OL-XS', 0, 0, '2021-04-15 13:06:07.711588', '2021-04-15 13:06:07.711588', NULL),
	(10008701, 5, 'PW21A-TS100293OL-S', 0, 0, '2021-04-15 13:06:07.684268', '2021-04-15 13:06:07.684268', NULL),
	(10008702, 5, 'PW21A-TS100293OL-M', 0, 0, '2021-04-15 13:06:07.671125', '2021-04-15 13:06:07.671125', NULL),
	(10008703, 5, 'PW21A-TS100293OL-L', 0, 0, '2021-04-15 13:06:07.687868', '2021-04-15 13:06:07.687868', NULL),
	(10008704, 5, 'PW21A-TS100293OL-XL', 0, 0, '2021-04-15 13:06:07.686941', '2021-04-15 13:06:07.686941', NULL),
	(10008705, 5, 'PW21A-TS100293OL-XXL', 0, 0, '2021-04-15 13:06:07.686020', '2021-04-15 13:06:07.686020', NULL),
	(10008706, 5, 'PW21A-TS100294OL-XS', 0, 0, '2021-04-15 13:06:07.688236', '2021-04-15 13:06:07.688236', NULL),
	(10008707, 5, 'PW21A-TS100294OL-S', 0, 0, '2021-04-15 13:06:07.693094', '2021-04-15 13:06:07.693094', NULL),
	(10008708, 5, 'PW21A-TS100294OL-M', 0, 0, '2021-04-15 13:06:07.687244', '2021-04-15 13:06:07.687244', NULL),
	(10008709, 5, 'PW21A-TS100294OL-L', 0, 0, '2021-04-15 13:06:07.710657', '2021-04-15 13:06:07.710657', NULL),
	(10008710, 5, 'PW21A-TS100294OL-XL', 0, 0, '2021-04-15 13:06:07.706137', '2021-04-15 13:06:07.706137', NULL),
	(10008711, 5, 'PW21A-TS100294OL-XXL', 0, 0, '2021-04-15 13:06:07.730884', '2021-04-15 13:06:07.730884', NULL),
	(10008712, 5, 'PW21A-TS100295NV-XS', 0, 0, '2021-04-15 13:06:07.690456', '2021-04-15 13:06:07.690456', NULL),
	(10008713, 5, 'PW21A-TS100295NV-S', 0, 0, '2021-04-15 13:06:07.706524', '2021-04-15 13:06:07.706524', NULL),
	(10008714, 5, 'PW21A-TS100295NV-M', 0, 0, '2021-04-15 13:06:07.710127', '2021-04-15 13:06:07.710127', NULL),
	(10008715, 5, 'PW21A-TS100295NV-L', 0, 0, '2021-04-15 13:06:07.710951', '2021-04-15 13:06:07.710951', NULL),
	(10008716, 5, 'PW21A-TS100295NV-XL', 0, 0, '2021-04-15 13:06:07.727646', '2021-04-15 13:06:07.727646', NULL),
	(10008717, 5, 'PW21A-TS100295NV-XXL', 0, 0, '2021-04-15 13:06:07.709806', '2021-04-15 13:06:07.709806', NULL),
	(10008718, 5, 'PW21A-TS100296BL-XS', 2, 0, '2021-04-15 13:06:07.713842', '2021-04-15 13:06:07.713842', NULL),
	(10008719, 5, 'PW21A-TS100296BL-S', 2, 0, '2021-04-15 13:06:07.711245', '2021-04-15 13:06:07.711245', NULL),
	(10008720, 5, 'PW21A-TS100296BL-M', 2, 0, '2021-04-15 13:06:07.724316', '2021-04-15 13:06:07.724316', NULL),
	(10008721, 5, 'PW21A-TS100296BL-L', 2, 0, '2021-04-15 13:06:07.725860', '2021-04-15 13:06:07.725860', NULL),
	(10008722, 5, 'PW21A-TS100296BL-XL', 2, 0, '2021-04-15 13:06:07.747014', '2021-04-15 13:06:07.747014', NULL),
	(10008723, 5, 'PW21A-TS100296BL-XXL', 2, 0, '2021-04-15 13:06:07.729026', '2021-04-15 13:06:07.729026', NULL),
	(10008724, 5, 'PW21A-TS100297OL-XS', 0, 0, '2021-04-15 13:06:07.732712', '2021-04-15 13:06:07.732712', NULL),
	(10008725, 5, 'PW21A-TS100297OL-S', 0, 0, '2021-04-15 13:06:07.778091', '2021-04-15 13:06:07.778091', NULL),
	(10008726, 5, 'PW21A-TS100297OL-M', 0, 0, '2021-04-15 13:06:07.715838', '2021-04-15 13:06:07.715838', NULL),
	(10008727, 5, 'PW21A-TS100297OL-L', 1, 0, '2021-04-15 13:06:07.770755', '2021-04-15 13:06:07.770755', NULL),
	(10008728, 5, 'PW21A-TS100297OL-XL', 2, 0, '2021-04-15 13:06:07.726736', '2021-04-15 13:06:07.726736', NULL),
	(10008729, 5, 'PW21A-TS100297OL-XXL', 2, 0, '2021-04-15 13:06:07.730381', '2021-04-15 13:06:07.730381', NULL),
	(10008730, 5, 'PW21A-TS100298OL-XS', 0, 0, '2021-04-15 13:06:07.752883', '2021-04-15 13:06:07.752883', NULL),
	(10008731, 5, 'PW21A-TS100298OL-S', 0, 0, '2021-04-15 13:06:07.734054', '2021-04-15 13:06:07.734054', NULL),
	(10008732, 5, 'PW21A-TS100298OL-M', 0, 0, '2021-04-15 13:06:07.752342', '2021-04-15 13:06:07.752342', NULL),
	(10008733, 5, 'PW21A-TS100298OL-L', 0, 0, '2021-04-15 13:06:07.738736', '2021-04-15 13:06:07.738736', NULL),
	(10008734, 5, 'PW21A-TS100298OL-XL', 0, 0, '2021-04-15 13:06:07.756571', '2021-04-15 13:06:07.756571', NULL),
	(10008735, 5, 'PW21A-TS100298OL-XXL', 0, 0, '2021-04-15 13:06:07.764415', '2021-04-15 13:06:07.764415', NULL),
	(10008736, 5, 'PW21A-TS100299BL-XS', 0, 0, '2021-04-15 13:06:07.755199', '2021-04-15 13:06:07.755199', NULL),
	(10008737, 5, 'PW21A-TS100299BL-S', 2, 0, '2021-04-15 13:06:07.760072', '2021-04-15 13:06:07.760072', NULL),
	(10008738, 5, 'PW21A-TS100299BL-M', 2, 0, '2021-04-15 13:06:07.754850', '2021-04-15 13:06:07.754850', NULL),
	(10008739, 5, 'PW21A-TS100299BL-L', 2, 0, '2021-04-15 13:06:07.792126', '2021-04-15 13:06:07.792126', NULL),
	(10008740, 5, 'PW21A-TS100299BL-XL', 2, 0, '2021-04-15 13:06:07.774034', '2021-04-15 13:06:07.774034', NULL),
	(10008741, 5, 'PW21A-TS100299BL-XXL', 2, 0, '2021-04-15 13:06:07.759365', '2021-04-15 13:06:07.759365', NULL),
	(10008742, 5, 'PW21A-TS100300MR-XS', 0, 0, '2021-04-15 13:06:07.758173', '2021-04-15 13:06:07.758173', NULL),
	(10008743, 5, 'PW21A-TS100300MR-S', 0, 0, '2021-04-15 13:06:07.774706', '2021-04-15 13:06:07.774706', NULL),
	(10008744, 5, 'PW21A-TS100300MR-M', 0, 0, '2021-04-15 13:06:07.779028', '2021-04-15 13:06:07.779028', NULL),
	(10008745, 5, 'PW21A-TS100300MR-L', 0, 0, '2021-04-15 13:06:07.798363', '2021-04-15 13:06:07.798363', NULL),
	(10008746, 5, 'PW21A-TS100300MR-XL', 0, 0, '2021-04-15 13:06:07.775267', '2021-04-15 13:06:07.775267', NULL),
	(10008747, 5, 'PW21A-TS100300MR-XXL', 0, 0, '2021-04-15 13:06:07.784932', '2021-04-15 13:06:07.784932', NULL),
	(10008748, 5, 'PW21A-TS100301BL-XS', 0, 0, '2021-04-15 13:06:07.830958', '2021-04-15 13:06:07.830958', NULL),
	(10008749, 5, 'PW21A-TS100301BL-S', 0, 0, '2021-04-15 13:06:07.802449', '2021-04-15 13:06:07.802449', NULL),
	(10008750, 5, 'PW21A-TS100301BL-M', 0, 0, '2021-04-15 13:06:07.804307', '2021-04-15 13:06:07.804307', NULL),
	(10008751, 5, 'PW21A-TS100301BL-L', 0, 0, '2021-04-15 13:06:07.799533', '2021-04-15 13:06:07.799533', NULL),
	(10008752, 5, 'PW21A-TS100301BL-XL', 0, 0, '2021-04-15 13:06:07.783615', '2021-04-15 13:06:07.783615', NULL),
	(10008753, 5, 'PW21A-TS100301BL-XXL', 0, 0, '2021-04-15 13:06:07.805285', '2021-04-15 13:06:07.805285', NULL),
	(10008754, 5, 'PW21A-TS100302BL-XS', 0, 0, '2021-04-15 13:06:07.786472', '2021-04-15 13:06:07.786472', NULL),
	(10008755, 5, 'PW21A-TS100302BL-S', 2, 0, '2021-04-15 13:06:07.803734', '2021-04-15 13:06:07.803734', NULL),
	(10008756, 5, 'PW21A-TS100302BL-M', 2, 0, '2021-04-15 13:06:07.819114', '2021-04-15 13:06:07.819114', NULL),
	(10008757, 5, 'PW21A-TS100302BL-L', 2, 0, '2021-04-15 13:06:07.808375', '2021-04-15 13:06:07.808375', NULL),
	(10008758, 5, 'PW21A-TS100302BL-XL', 2, 0, '2021-04-15 13:06:07.836130', '2021-04-15 13:06:07.836130', NULL),
	(10008759, 5, 'PW21A-TS100302BL-XXL', 2, 0, '2021-04-15 13:06:07.807649', '2021-04-15 13:06:07.807649', NULL),
	(10008760, 5, 'PW21A-TS100303BL-XS', 0, 0, '2021-04-15 13:06:07.828744', '2021-04-15 13:06:07.828744', NULL),
	(10008761, 5, 'PW21A-TS100303BL-S', 0, 0, '2021-04-15 13:06:07.823732', '2021-04-15 13:06:07.823732', NULL),
	(10008762, 5, 'PW21A-TS100303BL-M', 0, 0, '2021-04-15 13:06:07.826396', '2021-04-15 13:06:07.826396', NULL),
	(10008763, 5, 'PW21A-TS100303BL-L', 0, 0, '2021-04-15 13:06:07.855783', '2021-04-15 13:06:07.855783', NULL),
	(10008764, 5, 'PW21A-TS100303BL-XL', 0, 0, '2021-04-15 13:06:07.837611', '2021-04-15 13:06:07.837611', NULL),
	(10008765, 5, 'PW21A-TS100303BL-XXL', 0, 0, '2021-04-15 13:06:07.829335', '2021-04-15 13:06:07.829335', NULL),
	(10008766, 5, 'PW21A-TS100304OL-XS', 2, 0, '2021-04-15 13:06:07.810940', '2021-04-15 13:06:07.810940', NULL),
	(10008767, 5, 'PW21A-TS100304OL-S', 2, 0, '2021-04-15 13:06:07.878218', '2021-04-15 13:06:07.878218', NULL),
	(10008768, 5, 'PW21A-TS100304OL-M', 2, 0, '2021-04-15 13:06:07.833586', '2021-04-15 13:06:07.833586', NULL),
	(10008769, 5, 'PW21A-TS100304OL-L', 2, 0, '2021-04-15 13:06:07.844499', '2021-04-15 13:06:07.844499', NULL),
	(10008770, 5, 'PW21A-TS100304OL-XL', 2, 0, '2021-04-15 13:06:07.881012', '2021-04-15 13:06:07.881012', NULL),
	(10008771, 5, 'PW21A-TS100304OL-XXL', 2, 0, '2021-04-15 13:06:07.848950', '2021-04-15 13:06:07.848950', NULL),
	(10008772, 5, 'PW21A-TS100305AR-XS', 0, 0, '2021-04-15 13:06:07.856277', '2021-04-15 13:06:07.856277', NULL),
	(10008773, 5, 'PW21A-TS100305AR-S', 2, 0, '2021-04-15 13:06:07.842790', '2021-04-15 13:06:07.842790', NULL),
	(10008774, 5, 'PW21A-TS100305AR-M', 2, 0, '2021-04-15 13:06:07.851652', '2021-04-15 13:06:07.851652', NULL),
	(10008775, 5, 'PW21A-TS100305AR-L', 2, 0, '2021-04-15 13:06:07.862514', '2021-04-15 13:06:07.862514', NULL),
	(10008776, 5, 'PW21A-TS100305AR-XL', 2, 0, '2021-04-15 13:06:07.858106', '2021-04-15 13:06:07.858106', NULL),
	(10008777, 5, 'PW21A-TS100305AR-XXL', 2, 0, '2021-04-15 13:06:07.859530', '2021-04-15 13:06:07.859530', NULL),
	(10008778, 5, 'PW21A-TS100306GN-XS', 0, 0, '2021-04-15 13:06:07.869041', '2021-04-15 13:06:07.869041', NULL),
	(10008779, 5, 'PW21A-TS100306GN-S', 2, 0, '2021-04-15 13:06:07.872643', '2021-04-15 13:06:07.872643', NULL),
	(10008780, 5, 'PW21A-TS100306GN-M', 2, 0, '2021-04-15 13:06:07.899888', '2021-04-15 13:06:07.899888', NULL),
	(10008781, 5, 'PW21A-TS100306GN-L', 2, 0, '2021-04-15 13:06:07.863640', '2021-04-15 13:06:07.863640', NULL),
	(10008782, 5, 'PW21A-TS100306GN-XL', 2, 0, '2021-04-15 13:06:07.867467', '2021-04-15 13:06:07.867467', NULL),
	(10008783, 5, 'PW21A-TS100306GN-XXL', 2, 0, '2021-04-15 13:06:07.880660', '2021-04-15 13:06:07.880660', NULL),
	(10008784, 5, 'PW21A-TS100307GN-XS', 0, 0, '2021-04-15 13:06:07.878529', '2021-04-15 13:06:07.878529', NULL),
	(10008785, 5, 'PW21A-TS100307GN-S', 2, 0, '2021-04-15 13:06:07.883261', '2021-04-15 13:06:07.883261', NULL),
	(10008786, 5, 'PW21A-TS100307GN-M', 2, 0, '2021-04-15 13:06:07.871707', '2021-04-15 13:06:07.871707', NULL),
	(10008787, 5, 'PW21A-TS100307GN-L', 2, 0, '2021-04-15 13:06:07.882760', '2021-04-15 13:06:07.882760', NULL),
	(10008788, 5, 'PW21A-TS100307GN-XL', 2, 0, '2021-04-15 13:06:07.892334', '2021-04-15 13:06:07.892334', NULL),
	(10008789, 5, 'PW21A-TS100307GN-XXL', 2, 0, '2021-04-15 13:06:07.901936', '2021-04-15 13:06:07.901936', NULL),
	(10008790, 5, 'PW21A-TS100308GN-XS', 0, 0, '2021-04-15 13:06:07.886742', '2021-04-15 13:06:07.886742', NULL),
	(10008791, 5, 'PW21A-TS100308GN-S', 2, 0, '2021-04-15 13:06:07.888910', '2021-04-15 13:06:07.888910', NULL),
	(10008792, 5, 'PW21A-TS100308GN-M', 2, 0, '2021-04-15 13:06:07.901640', '2021-04-15 13:06:07.901640', NULL),
	(10008793, 5, 'PW21A-TS100308GN-L', 2, 0, '2021-04-15 13:06:07.890542', '2021-04-15 13:06:07.890542', NULL),
	(10008794, 5, 'PW21A-TS100308GN-XL', 2, 0, '2021-04-15 13:06:07.923349', '2021-04-15 13:06:07.923349', NULL),
	(10008795, 5, 'PW21A-TS100308GN-XXL', 2, 0, '2021-04-15 13:06:07.900373', '2021-04-15 13:06:07.900373', NULL),
	(10008796, 5, 'PW21A-TS100309GN-XS', 0, 0, '2021-04-15 13:06:07.904825', '2021-04-15 13:06:07.904825', NULL),
	(10008797, 5, 'PW21A-TS100309GN-S', 2, 0, '2021-04-15 13:06:07.902262', '2021-04-15 13:06:07.902262', NULL),
	(10008798, 5, 'PW21A-TS100309GN-M', 2, 0, '2021-04-15 13:06:07.912430', '2021-04-15 13:06:07.912430', NULL),
	(10008799, 5, 'PW21A-TS100309GN-L', 2, 0, '2021-04-15 13:06:07.916797', '2021-04-15 13:06:07.916797', NULL),
	(10008800, 5, 'PW21A-TS100309GN-XL', 2, 0, '2021-04-15 13:06:07.941957', '2021-04-15 13:06:07.941957', NULL),
	(10008801, 5, 'PW21A-TS100309GN-XXL', 1, 0, '2021-04-15 13:06:07.911895', '2021-04-15 13:06:07.911895', NULL),
	(10008802, 5, 'PW21A-SW100310BL-XS', 0, 0, '2021-04-15 13:06:07.923629', '2021-04-15 13:06:07.923629', NULL),
	(10008803, 5, 'PW21A-SW100310BL-S', 0, 0, '2021-04-15 13:06:07.928640', '2021-04-15 13:06:07.928640', NULL),
	(10008804, 5, 'PW21A-SW100310BL-M', 0, 0, '2021-04-15 13:06:07.904505', '2021-04-15 13:06:07.904505', NULL),
	(10008805, 5, 'PW21A-SW100310BL-L', 0, 0, '2021-04-15 13:06:07.951048', '2021-04-15 13:06:07.951048', NULL),
	(10008806, 5, 'PW21A-SW100310BL-XL', 0, 0, '2021-04-15 13:06:07.962448', '2021-04-15 13:06:07.962448', NULL),
	(10008807, 5, 'PW21A-SW100310BL-XXL', 0, 0, '2021-04-15 13:06:07.930239', '2021-04-15 13:06:07.930239', NULL),
	(10008808, 5, 'PW21A-SW100311BL-XS', 0, 0, '2021-04-15 13:06:07.931610', '2021-04-15 13:06:07.931610', NULL),
	(10008809, 5, 'PW21A-SW100311BL-S', 3, 0, '2021-04-15 13:06:07.942438', '2021-04-15 13:06:07.942438', NULL),
	(10008810,